CDF       
      
timeseries        obs   )   station_name_strlen       platform1_strlen      instrument1_strlen     +   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:17:36Z http://pacioos.org
2022-11-15T19:17:36Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2021-01-01T00:00:00Z&time%3C2022-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2021-04-22T19:00:00Z   time_coverage_resolution      PT30M      time_coverage_start       2021-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A   A q      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      N r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      AGA   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH           salinity                   _ChunkSizes                
_FillValue        y    actual_range      <
A=q   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B        g   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      F_P
   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz           chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      >\)Bn33   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C           oxygen                     _ChunkSizes                
_FillValue        y    actual_range      @{AC
   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        ]   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      BzC%\   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C           ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        $   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AGA   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        R,   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                4   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      <   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      	GD   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      	L   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      
T   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      <\   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      d   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      l   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      
1t   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      
|   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	         temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      &   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      ͔   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	      t   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	         salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      <
A=q   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B        ¬   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range                i   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	         salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	         salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      ^   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	         salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	         salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      S   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	         salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	         salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      H   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	         salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	         salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      >   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	         salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      $   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      F_P
   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        3,   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range                4   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      <   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      (D   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      L   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      vT   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	       \   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	       d   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      !kl   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      "t   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      "|   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      #`   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      $   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      $   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      >\)Bn33   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        %U   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range                %   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      &   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      'J   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      '   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      (   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      )?   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      )   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      *   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      +4   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      +   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      ,   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      -)   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      -   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      @{AC
   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        .x   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                /   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      /   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      0m$   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      1,   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      14   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      2b<   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      3	D   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      3L   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      4WT   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      4\   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      5d   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      6Ll   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      6t   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      BzC%\   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        7|   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range                8A   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      8   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      9   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      :6   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      :ݤ   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      ;   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      <+   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      <Ҽ   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      =y   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      >    oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      >   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      ?n   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      @   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        @   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                Ac   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      B
   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      B   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      CY   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      D    	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      D   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      EN$   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      E,   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      F4   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      GC<   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      GD   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      HL   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      I8T   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045         I\   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde      J   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    w Q݀Ap?  wqb_04  A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   Að   Ađ   Ar   AS   A4   A   A   A   Aʸ   A˙   Az   A[   A<   A   A   A   A   Aҡ   Aӂ   Ac   AD   A%   A   A   A   A٩   Aڊ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   A U   A6   A   A   A   A   A   A|   A]   A>   A	   A
    A
   A   A   A
   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A    A!   A"   A#}   A$^   A%?   A&    A'   A'   A(   A)   A*   A+f   A,G   A-(   A.	   A.   A/   A0   A1   A2n   A3O   A40   A5   A5   A6   A7   A8   A9v   A:W   A;8   A<   A<   A=   A>   A?   A@~   AA_   AB@   AC!   AD   AD   AE   AF   AG   AHg   AIH   AJ)   AK
   AK   AL   AM   AN   AOo   APP   AQ1   AR   AR   AS   AT   AU   AVw   AWX   AX9   AY   AY   AZ   A[   A\   A]   A^`   A_A   A`"   Aa   Aa   Ab   Ac   Ad   Aeh   AfI   Ag*   Ah   Ah   Ai   Aj   Ak   Alp   AmQ   An2   Ao   Ao   Ap   Aq   Ar   Asx   AtY   Au:   Av   Av   Aw   Ax   Ay   Az   A{a   A|B   A}#   A~   A~   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   Aȹ   Aɚ   A{   A\   A=   A   A   A   A   AТ   Aу   Ad   AE   A&   A   A   A   Aת   A؋   Al   AM   A.   A   A   A   A޲   Aߓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A    A    A   A   A   A}   A^   A?   A    A   A   A	   A
   A   Af   A
G   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A    A!~   A"_   A#@   A$!   A%   A%   A&   A'   A(   A)g   A*H   A+)   A,
   A,   A-   A.   A/   A0o   A1P   A21   A3   A3   A4   A5   A6   A7w   A8X   A99   A:   A:   A;   A<   A=   A>   A?`   A@A   AA"   AB   AB   AC   AD   AE   AFh   AGI   AH*   AI   AI   AJ   AK   AL   AMp   ANQ   AO2   AP   AP   AQ   AR   AS   ATx   AUY   AV:   AW   AW   AX   AY   AZ   A[   A\a   A]B   A^#   A_   A_   A`   Aa   Ab   Aci   AdJ   Ae+   Af   Af   Ag   Ah   Ai   Ajq   AkR   Al3   Am   Am   An   Ao   Ap   Aqy   ArZ   As;   At   At   Au   Av   Aw   Ax   Ayb   AzC   A{$   A|   A|   A}   A~   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   Aƺ   AǛ   A|   A]   A>   A   A    A   A   AΣ   Aτ   Ae   AF   A'   A   A   A   Aի   A֌   Am   AN   A/   A   A   A   Aܳ   Aݔ   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A    A   A~   A_   A@   A!   A   A   A   A   A	   A
g   AH   A)   A
   A
   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A `   A!A   A""   A#   A#   A$   A%   A&   A'h   A(I   A)*   A*   A*   A+   A,   A-   A.p   A/Q   A02   A1   A1   A2   A3   A4   A5x   A6Y   A7:   A8   A8   A9   A:   A;   A<   A=a   A>B   A?#   A@   A@   AA   AB   AC   ADi   AEJ   AF+   AG   AG   AH   AI   AJ   AKq   ALR   AM3   AN   AN   AO   AP   AQ   ARy   ASZ   AT;   AU   AU   AV   AW   AX   AY   AZb   A[C   A\$   A]   A]   A^   A_   A`   Aaj   AbK   Ac,   Ad
   Ad   Ae   Af   Ag   Ahr   AiS   Aj4   Ak   Ak   Al   Am   An   Aoz   Ap[   Aq<   Ar   Ar   As   At   Au   Av   Awc   AxD   Ay%   Az   Az   A{   A|   A}   A~k   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   AĻ   AŜ   A}   A^   A?   A    A   A   A   A̤   Aͅ   Af   AG   A(   A	   A   A   AӬ   Aԍ   An   AO   A0   A   A   A   Aڴ   Aە   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A    A`   AA   A"   A   A   A   A   A   Ah   A	I   A
*   A   A   A   A
   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A #   A!   A!   A"   A#   A$   A%i   A&J   A'+   A(   A(   A)   A*   A+   A,q   A-R   A.3   A/   A/   A0   A1   A2   A3y   A4Z   A5;   A6   A6   A7   A8   A9   A:   A;b   A<C   A=$   A>   A>   A?   A@   AA   ABj   ACK   AD,   AE
   AE   AF   AG   AH   AIr   AJS   AK4   AL   AL   AM   AN   AO   APz   AQ[   AR<   AS   AS   AT   AU   AV   AW   AXc   AYD   AZ%   A[   A[   A\   A]   A^   A_k   A`L   Aa-   Ab   Ab   Ac   Ad   Ae   Afs   AgT   Ah5   Ai   Ai   Aj   Ak   Al   Am{   An\   Ao=   Ap   Ap   Aq   Ar   As   At   Aud   AvE   Aw&   Ax   Ax   Ay   Az   A{   A|l   A}M   A~.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A¼   AÝ   A~   A_   A@   A!   A   A   A   Aʥ   Aˆ   Ag   AH   A)   A
   A   A   Aѭ   AҎ   Ao   AP   A1   A   A   A   Aص   Aٖ   Aw   AX   A9   A   A   A   A߽   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   A  B   A #   A    A    A    A    A    A i   A J   A +   A 	   A 	   A 
   A    A    A 
q   A R   A 3   A    A    A    A    A    A y   A Z   A ;   A    A    A    A    A    A    A b   A C   A $   A    A    A     A !   A "   A #j   A $K   A %,   A &
   A &   A '   A (   A )   A *r   A +S   A ,4   A -   A -   A .   A /   A 0   A 1z   A 2[   A 3<   A 4   A 4   A 5   A 6   A 7   A 8   A 9c   A :D   A ;%   A <   A <   A =   A >   A ?   A @k   A AL   A B-   A C   A C   A D   A E   A F   A Gs   A HT   A I5   A J   A J   A K   A L   A M   A N{   A O\   A P=   A Q   A Q   A R   A S   A T   A U   A Vd   A WE   A X&   A Y   A Y   A Z   A [   A \   A ]l   A ^M   A _.   A `   A `   A a   A b   A c   A dt   A eU   A f6   A g   A g   A h   A i   A j   A k|   A l]   A m>   A n   A o    A o   A p   A q   A r   A se   A tF   A u'   A v   A v   A w   A x   A y   A zm   A {N   A |/   A }   A }   A ~   A    A    A u   A V   A 7   A    A    A    A    A    A }   A ^   A ?   A     A    A    A    A    A    A f   A G   A (   A 	   A    A    A    A    A n   A O   A 0   A    A    A    A    A    A v   A W   A 8   A    A    A    A    A    A ~   A _   A @   A    A    A    A    A g   A H   A )   A 
   A    A    A    A    A o   A P   A 1   A    A    A    A    A    A w   A X   A 9   A    A    A    A    A    A    A `   A A   A "   A    A    A    A Ȧ   A ɇ   A h   A I   A *   A    A    A    A Ϯ   A Џ   A p   A Q   A 2   A    A    A    A ֶ   A ח   A x   A Y   A :   A    A    A    A ݾ   A ޟ   A ߀   A a   A B   A #   A    A    A    A    A    A i   A J   A +   A    A    A    A    A    A q   A R   A 3   A    A    A    A    A    A y   A Z   A ;   A    A    A    A    A    A    A b   A C   A $   A    A    A   A   A   Aj   AK   A,   A
   A   A   A	   A
   Ar   AS   A
4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A    A!k   A"L   A#-   A$   A$   A%   A&   A'   A(s   A)T   A*5   A+   A+   A,   A-   A.   A/{   A0\   A1=   A2   A2   A3   A4   A5   A6   A7d   A8E   A9&   A:   A:   A;   A<   A=   A>l   A?M   A@.   AA   AA   AB   AC   AD   AEt   AFU   AG6   AH   AH   AI   AJ   AK   AL|   AM]   AN>   AO   AP    AP   AQ   AR   AS   ATe   AUF   AV'   AW   AW   AX   AY   AZ   A[m   A\N   A]/   A^   A^   A_   A`   Aa   Abu   AcV   Ad7   Ae   Ae   Af   Ag   Ah   Ai}   Aj^   Ak?   Al    Am   Am   An   Ao   Ap   Aqf   ArG   As(   At	   At   Au   Av   Aw   Axn   AyO   Az0   A{   A{   A|   A}   A~   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   AƧ   Aǈ   Ai   AJ   A+   A   A   A   Aͯ   Aΐ   Aq   AR   A3   A   A   A   AԷ   A՘   Ay   AZ   A;   A   A   A   Aۿ   Aܠ   A݁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A    A   Ak   AL   A-   A   A   A   A   A   A	s   A
T   A5   A   A   A
   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   A M   A!.   A"   A"   A#   A$   A%   A&t   A'U   A(6   A)   A)   A*   A+   A,   A-|   A.]   A/>   A0   A1    A1   A2   A3   A4   A5e   A6F   A7'   A8   A8   A9   A:   A;   A<m   A=N   A>/   A?   A?   A@   AA   AB   ACu   ADV   AE7   AF   AF   AG   AH   AI   AJ}   AK^   AL?   AM    AN   AN   AO   AP   AQ   ARf   ASG   AT(   AU	   AU   AV   AW   AX   AYn   AZO   A[0   A\   A\   A]   A^   A_   A`v   AaW   Ab8   Ac   Ac   Ad   Ae   Af   Ag~   Ah_   Ai@   Aj!   Ak   Ak   Al   Am   An   Aog   ApH   Aq)   Ar
   Ar   As   At   Au   Avo   AwP   Ax1   Ay   Ay   Az   A{   A|   A}w   A~X   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   AĨ   Aŉ   Aj   AK   A,   A
   A   A   A˰   A̑   Ar   AS   A4   A   A   A   AҸ   Aә   Az   A[   A<   A   A   A   A   Aڡ   Aۂ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   A l   AM   A.   A   A   A   A   A   At   AU   A	6   A
   A
   A   A   A
   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A    A    A!   A"   A#   A$u   A%V   A&7   A'   A'   A(   A)   A*   A+}   A,^   A-?   A.    A/   A/   A0   A1   A2   A3f   A4G   A5(   A6	   A6   A7   A8   A9   A:n   A;O   A<0   A=   A=   A>   A?   A@   AAv   ABW   AC8   AD   AD   AE   AF   AG   AH~   AI_   AJ@   AK!   AL   AL   AM   AN   AO   APg   AQH   AR)   AS
   AS   AT   AU   AV   AWo   AXP   AY1   AZ   AZ   A[   A\   A]   A^w   A_X   A`9   Aa   Aa   Ab   Ac   Ad   Ae   Af`   AgA   Ah"   Ai   Ai   Aj   Ak   Al   Amh   AnI   Ao*   Ap   Ap   Aq   Ar   As   Atp   AuQ   Av2   Aw   Aw   A|Y   A}:   A~   A~   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A©   AÊ   Ak   AL   A-   A   A   A   Aɱ   Aʒ   As   AT   A5   A   A   A   Aй   Aњ   A{   A\   A=   A   A   A   A   Aآ   Aك   Ad   AE   A&   A   A   A   Aߪ   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A /   A   A   A   A   A   Au   AV   A7   A   A   A	   A
   A   A}   A
^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A    A!   A"v   A#W   A$8   A%   A%   A(   A)~   A*_   A+@   A,!   A-   A-   A.   A/   A0   A1g   A2H   A3)   A4
   A4   A5   A6   A7   A8o   A9P   A:1   A;   A;   A<   A=   A>   A?w   A@X   AA9   AB   AB   AC   AD   AE   AF   AG`   AHA   AI"   AJ   AJ   AK   AL   AM   ANh   AOI   AP*   AQ   AQ   AR   AS   AT   AUp   AVQ   AW2   AX   AX   AY   AZ   A[   A\x   A]Y   A^:   A_   A_   A`   Aa   Ab   Ac   Ada   AeB   Af#   Ag   Ag   Ah   Ai   Aj   Aki   AlJ   Am+   An   An   Ao   Ap   Aq   Arq   AsR   At3   Au   Au   Av   Aw   Ax   Ayy   AzZ   A{;   A|   A|   A}   A~   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   Aǲ   Aȓ   At   AU   A6   A   A   A   Aκ   Aϛ   A|   A]   A>   A   A    A   A   A֣   Aׄ   Ae   AF   A'   A   A   A   Aݫ   Aތ   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A    A   A   Av   AW   A8   A   A   A   A   A	   A
~   A_   A@   A
!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   A w   A!X   A"9   A#   A#   A$   A%   A&   A'   A(`   A)A   A*"   A+   A+   A,   A-   A.   A/h   A0I   A1*   A2   A2   A3   A4   A5   A6p   A7Q   A82   A9   A9   A:   A;   A<   A=x   A>Y   A?:   A@   A@   AA   AB   AC   AD   AEa   AFB   AG#   AH   AH   AI   AJ   AK   ALi   AMJ   AN+   AO   AO   AP   AQ   AR   ASq   ATR   AU3   AV   AV   AW   AX   AY   AZy   A[Z   A\;   A]   A]   A^   A_   A`   Aa   Abb   AcC   Ad$   Ae   Ae   Af   Ag   Ah   Aij   AjK   Ak,   Al
   Al   Am   An   Ao   Apr   AqS   Ar4   As   As   At   Au   Av   Awz   Ax[   Ay<   Az   Az   A{   A|   A}   A~   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   Aų   AƔ   Au   AV   A7   A   A   A   A̻   A͜   A}   A^   A?   A    A   A   A   AԤ   AՅ   Af   AG   A(   A	   A   A   A۬   A܍   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A    Aw   AX   A9   A   A   A   A   A   A   A	`   A
A   A"   A   A   A
   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A :   A!   A!   A"   A#   A$   A%   A&a   A'B   A(#   A)   A)   A*   A+   A,   A-i   A.J   A/+   A0   A0   A1   A2   A3   A4q   A5R   A63   A7   A7   A8   A9   A:   A;y   A<Z   A=;   A>   A>   A?   A@   AA   AB   ACb   ADC   AE$   AF   AF   AG   AH   AI   AJj   AKK   AL,   AM
   AM   AN   AO   AP   AQr   ARS   AS4   AT   AT   AU   AV   AW   AXz   AY[   AZ<   A[   A[   A\   A]   A^   A_   A`c   AaD   Ab%   Ac   Ac   Ad   Ae   Af   Agk   AhL   Ai-   Aj   Aj   Ak   Al   Am   Ans   AoT   Ap5   Aq   Aq   Ar   As   At   Au{   Av\   Aw=   Ax   Ax   Ay   Az   A{   A|   A}d   A~E   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   Aô   Aĕ   Av   AW   A8   A   A   A   Aʼ   A˝   A~   A_   A@   A!   A   A   A   Aҥ   Aӆ   Ag   AH   A)   A
   A   A   A٭   Aڎ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   A Y   A:   A   A   A   A   A   A   Aa   AB   A	#   A
   A
   A   A   A
   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A    A!   A"   A#   A$b   A%C   A&$   A'   A'   A(   A)   A*   A+j   A,K   A-,   A.
   A.   A/   A0   A1   A2r   A3S   A44   A5   A5   A6   A7   A8   A9z   A:[   A;<   A<   A<   A=   A>   A?   A@   AAc   ABD   AC%   AD   AD   AE   AF   AG   AHk   AIL   AJ-   AK   AK   AL   AM   AN   AOs   APT   AQ5   AR   AR   AS   AT   AU   AV{   AW\   AX=   AY   AY   AZ   A[   A\   A]   A^d   A_E   A`&   Aa   Aa   Ab   Ac   Ad   Ael   AfM   Ag.   Ah   Ah   Ai   Aj   Ak   Alt   AmU   An6   Ao   Ao   Ap   Aq   Ar   As|   At]   Au>   Av   Aw    Aw   Ax   Ay   Az   A{e   A|F   A}'   A~   A~   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   AȽ   Aɞ   A   A`   AA   A"   A   A   A   AЦ   Aч   Ah   AI   A*   A   A   A   A׮   A؏   Ap   AQ   A2   A   A   A   A޶   Aߗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A    A    A   A   A   A   Ab   AC   A$   A   A   A	   A
   A   Aj   A
K   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A    A!   A"c   A#D   A$%   A%   A%   A&   A'   A(   A)k   A*L   A+-   A,   A,   A-   A.   A/   A0s   A1T   A25   A3   A3   A4   A5   A6   A7{   A8\   A9=   A:   A:   A;   A<   A=   A>   A?d   A@E   AA&   AB   AB   AC   AD   AE   AFl   AGM   AH.   AI   AI   AJ   AK   AL   AMt   ANU   AO6   AP   AP   AQ   AR   AS   AT|   AU]   AV>   AW   AX    AX   AY   AZ   A[   A\e   A]F   A^'   A_   A_   A`   Aa   Ab   Acm   AdN   Ae/   Af   Af   Ag   Ah   Ai   Aju   AkV   Al7   Am   Am   An   Ao   Ap   Aq}   Ar^   As?   At    Au   Au   Av   Aw   Ax   Ayf   AzG   A{(   A|	   A|   A}   A~   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   Aƾ   Aǟ   AȀ   Aa   AB   A#   A   A   A   AΧ   Aψ   Ai   AJ   A+   A   A   A   Aկ   A֐   Aq   AR   A3   A   A   A   Aܷ   Aݘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A	    A	   A	   A	c   A	D   A	%   A	   A	   A	   A	   A		   A	
k   A	L   A	-   A	
   A	
   A	   A	   A	   A	s   A	T   A	5   A	   A	   A	   A	   A	   A	{   A	\   A	=   A	   A	   A	   A	   A	   A	   A	 d   A	!E   A	"&   A	#   A	#   A	$   A	%   A	&   A	'l   A	(M   A	).   A	*   A	*   A	+   A	,   A	-   A	.t   A	/U   A	06   A	1   A	1   A	2   A	3   A	4   A	5|   A	6]   A	7>   A	8   A	9    A	9   A	:   A	;   A	<   A	=e   A	>F   A	?'   A	@   A	@   A	A   A	B   A	C   A	Dm   A	EN   A	F/   A	G   A	G   A	H   A	I   A	J   A	Ku   A	LV   A	M7   A	N   A	N   A	O   A	P   A	Q   A	R}   A	S^   A	T?   A	U    A	V   A	V   A	W   A	X   A	Y   A	Zf   A	[G   A	\(   A	]	   A	]   A	^   A	_   A	`   A	an   A	bO   A	c0   A	d   A	d   A	e   A	f   A	g   A	hv   A	iW   A	j8   A	k   A	k   A	l   A	m   A	n   A	o~   A	p_   A	q@   A	r!   A	s   A	s   A	t   A	u   A	v   A	wg   A	xH   A	y)   A	z
   A	z   A	{   A	|   A	}   A	~o   A	P   A	1   A	   A	   A	   A	   A	   A	w   A	X   A	9   A	   A	   A	   A	   A	   A	   A	`   A	A   A	"   A	   A	   A	   A	   A	   A	h   A	I   A	*   A	   A	   A	   A	   A	   A	p   A	Q   A	2   A	   A	   A	   A	   A	   A	x   A	Y   A	:   A	   A	   A	   A	   A	   A	   A	a   A	B   A	#   A	   A	   A	   A	   A	   A	i   A	J   A	+   A	   A	   A	   A	   A	   A	q   A	R   A	3   A	   A	   A	   A	   A	   A	y   A	Z   A	;   A	   A	   A	   A	Ŀ   A	Š   A	Ɓ   A	b   A	C   A	$   A	   A	   A	   A	̨   A	͉   A	j   A	K   A	,   A	
   A	   A	   A	Ӱ   A	ԑ   A	r   A	S   A	4   A	   A	   A	   A	ڸ   A	ۙ   A	z   A	[   A	<   A	   A	   A	   A	   A	   A	   A	c   A	D   A	%   A	   A	   A	   A	   A	   A	k   A	L   A	-   A	   A	   A	   A	   A	   A	s   A	T   A	5   A	   A	   A	   A	   A	   A	{   A	\   A	=   A	   A	   A	   A	   A	   A
    A
d   A
E   A
&   A
   A
   A
   A
   A
   A
l   A
	M   A

.   A
   A
   A
   A

   A
   A
t   A
U   A
6   A
   A
   A
   A
   A
   A
|   A
]   A
>   A
   A
    A
   A
   A
   A
   A
e   A
F   A
 '   A
!   A
!   A
"   A
#   A
$   A
%m   A
&N   A
'/   A
(   A
(   A
)   A
*   A
+   A
,u   A
-V   A
.7   A
/   A
/   A
0   A
1   A
2   A
3}   A
4^   A
5?   A
6    A
7   A
7   A
8   A
9   A
:   A
;f   A
<G   A
=(   A
>	   A
>   A
?   A
@   A
A   A
Bn   A
CO   A
D0   A
E   A
E   A
F   A
G   A
H   A
Iv   A
JW   A
K8   A
L   A
L   A
M   A
N   A
O   A
P~   A
Q_   A
R@   A
S!   A
T   A
T   A
U   A
V   A
W   A
Xg   A
YH   A
Z)   A
[
   A
[   A
\   A
]   A
^   A
_o   A
`P   A
a1   A
b   A
b   A
c   A
d   A
e   A
fw   A
gX   A
h9   A
i   A
i   A
j   A
k   A
l   A
m   A
n`   A
oA   A
p"   A
q   A
q   A
r   A
s   A
t   A
uh   A
vI   A
w*   A
x   A
x   A
y   A
z   A
{   A
|p   A
}Q   A
~2   A
   A
   A
   A
   A
   A
x   A
Y   A
:   A
   A
   A
   A
   A
   A
   A
a   A
B   A
#   A
   A
   A
   A
   A
   A
i   A
J   A
+   A
   A
   A
   A
   A
   A
q   A
R   A
3   A
   A
   A
   A
   A
   A
y   A
Z   A
;   A
   A
   A
   A
   A
   A
   A
b   A
C   A
$   A
   A
   A
   A
   A
   A
j   A
K   A
,   A

   A
   A
   A
   A
   A
r   A
S   A
4   A
   A
   A
   A
   A
   A
z   A
[   A
<   A
   A
   A
   A
   A
á   A
Ă   A
c   A
D   A
%   A
   A
   A
   A
ʩ   A
ˊ   A
k   A
L   A
-   A
   A
   A
   A
ѱ   A
Ғ   A
s   A
T   A
5   A
   A
   A
   A
ع   A
ٚ   A
{   A
\   A
=   A
   A
   A
   A
   A
   A
   A
d   A
E   A
&   A
   A
   A
   A
   A
   A
l   A
M   A
.   A
   A
   A
   A
   A
   A
t   A
U   A
6   A
   A
   A
   A
   A
   A
|   A
]   A
>   A
   A
    A
   A
   A
   A
   A
e   A F   A'   A   A   A   A   A   Am   AN   A/   A	   A	   A
   A   A   A
u   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A    A!   A"   A#n   A$O   A%0   A&   A&   A'   A(   A)   A*v   A+W   A,8   A-   A-   A.   A/   A0   A1~   A2_   A3@   A4!   A5   A5   A6   A7   A8   A9g   A:H   A;)   A<
   A<   A=   A>   A?   A@o   AAP   AB1   AC   AC   AD   AE   AF   AGw   AHX   AI9   AJ   AJ   AK   AL   AM   AN   AO`   APA   AQ"   AR   AR   AS   AT   AU   AVh   AWI   AX*   AY   AY   AZ   A[   A\   A]p   A^Q   A_2   A`   A`   Aa   Ab   Ac   Adx   AeY   Af:   Ag   Ag   Ah   Ai   Aj   Ak   Ala   AmB   An#   Ao   Ao   Ap   Aq   Ar   Asi   AtJ   Au+   Av   Av   Aw   Ax   Ay   Azq   A{R   A|3   A}   A}   A~   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   AȪ   Aɋ   Al   AM   A.   A   A   A   Aϲ   AГ   At   AU   A6   A   A   A   Aֺ   Aכ   A|   A]   A>   A   A    A   A   Aޣ   A߄   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A 	   A    A   A   A   An   AO   A0   A   A   A   A	   A
   Av   AW   A
8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A    A!o   A"P   A#1   A$   A$   A%   A&   A'   A(w   A)X   A*9   A+   A+   A,   A-   A.   A/   A0`   A1A   A2"   A3   A3   A4   A5   A6   A7h   A8I   A9*   A:   A:   A;   A<   A=   A>p   A?Q   A@2   AA   AA   AB   AC   AD   AEx   AFY   AG:   AH   AH   AI   AJ   AK   AL   AMa   ANB   AO#   AP   AP   AQ   AR   AS   ATi   AUJ   AV+   AW   AW   AX   AY   AZ   A[q   A\R   A]3   A^   A^   A_   A`   Aa   Aby   AcZ   Ad;   Ae   Ae   Af   Ag   Ah   Ai   Ajb   AkC   Al$   Am   Am   An   Ao   Ap   Aqj   ArK   As,   At
   At   Au   Av   Aw   Axr   AyS   Az4   A{   A{   A|   A}   A~   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   Aƫ   Aǌ   Am   AN   A/   A   A   A   Aͳ   AΔ   Au   AV   A7   A   A   A   AԻ   A՜   A}   A^   A?   A    A   A   A   Aܤ   A݅   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A
    A
   A
o   A
P   A
1   A
   A
   A
   A
   A
   A
	w   A
X   A
9   A
   A
   A

   A
   A
   A
   A
`   A
A   A
"   A
   A
   A
   A
   A
   A
h   A
I   A
*   A
   A
   A
   A
   A
   A
p   A
 Q   A
!2   A
"   A
"   A
#   A
$   A
%   A
&x   A
'Y   A
(:   A
)   A
)   A
*   A
+   A
,   A
-   A
.a   A
/B   A
0#   A
1   A
1   A
2   A
3   A
4   A
5i   A
6J   A
7+   A
8   A
8   A
9   A
:   A
;   A
<q   A
=R   A
>3   A
?   A
?   A
@   A
A   A
B   A
Cy   A
DZ   A
E;   A
F   A
F   A
G   A
H   A
I   A
J   A
Kb   A
LC   A
M$   A
N   A
N   A
O   A
P   A
Q   A
Rj   A
SK   A
T,   A
U
   A
U   A
V   A
W   A
X   A
Yr   A
ZS   A
[4   A
\   A
\   A
]   A
^   A
_   A
`z   A
a[   A
b<   A
c   A
c   A
d   A
e   A
f   A
g   A
hc   A
iD   A
j%   A
k   A
k   A
l   A
m   A
n   A
ok   A
pL   A
q-   A
r   A
r   A
s   A
t   A
u   A
vs   A
wT   A
x5   A
y   A
y   A
z   A
{   A
|   A
}{   A
~\   A
=   A
   A
   A
   A
   A
   A
   A
d   A
E   A
&   A
   A
   A
   A
   A
   A
l   A
M   A
.   A
   A
   A
   A
   A
   A
t   A
U   A
6   A
   A
   A
   A
   A
   A
|   A
]   A
>   A
   A
    A
   A
   A
   A
   A
e   A
F   A
'   A
   A
   A
   A
   A
   A
m   A
N   A
/   A
   A
   A
   A
   A
   A
u   A
V   A
7   A
   A
   A
   A
   A
   A
}   A
^   A
?   A
    A
   A
   A
   A
   A
   A
f   A
G   A
(   A
	   A
   A
   A
Ĭ   A
ō   A
n   A
O   A
0   A
   A
   A
   A
˴   A
̕   A
v   A
W   A
8   A
   A
   A
   A
Ҽ   A
ӝ   A
~   A
_   A
@   A
!   A
   A
   A
   A
ڥ   A
ۆ   A
g   A
H   A
)   A
   A
   A
   A
   A
   A
o   A
P   A
1   A
   A
   A
   A
   A
   A
w   A
X   A
9   A
   A
   A
   A
   A
   A
   A
`   A
A   A
"   A
   A
   A
   A
   A
   A
h   A
I   A
*   A
   A
   A
   A
   A
   A p   AQ   A2   A   A   A   A   A   Ax   AY   A	:   A
   A
   A   A   A
   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A    A    A!   A"   A#   A$y   A%Z   A&;   A'   A'   A(   A)   A*   A+   A,b   A-C   A.$   A/   A/   A0   A1   A2   A3j   A4K   A5,   A6
   A6   A7   A8   A9   A:r   A;S   A<4   A=   A=   A>   A?   A@   AAz   AB[   AC<   AD   AD   AE   AF   AG   AH   AIc   AJD   AK%   AL   AL   AM   AN   AO   APk   AQL   AR-   AS   AS   AT   AU   AV   AWs   AXT   AY5   AZ   AZ   A[   A\   A]   A^{   A_\   Ac   Ad   Ae   Afd   AgE   Ah&   Ai   Ai   Aj   Ak   Al   Aml   AnM   Ao.   Ap   Ap   Aq   Ar   As   Att   AuU   Av6   Aw   Aw   Ax   Ay   Az   A{|   A|]   A}>   A~   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A­   AÎ   Ao   AP   A1   A   A   A   Aɵ   Aʖ   Aw   AX   A9   A   A   A   Aн   Aў   A   A`   AA   A"   A   A   A   Aئ   Aه   Ah   AI   A*   A   A   A   A߮   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A 3   A   A   A   A   A   Ay   AZ   A;   A   A   A	   A
   A   A   A
b   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A    A!   A"z   A#[   A$<   A%   A%   A&   A'   A(   A)   A*c   A+D   A,%   A-   A-   A.   A/   A0   A1k   A2L   A3-   A4   A4   A5   A6   A7   A8s   A9T   A:5   A;   A;   A<   A=   A>   A?{   A@\   AA=   AB   AB   AC   AD   AE   AF   AGd   AHE   AI&   AJ   AJ   AK   AL   AM   ANl   AOM   AP.   AQ   AQ   AR   AS   AT   AUt   AVU   AW6   AX   AX   AY   AZ   A[   A\|   A]]   A^>   A_   A`    A`   Aa   Ab   Ac   Ade   AeF   Af'   Ag   Ag   Ah   Ai   Aj   Akm   AlN   Am/   An   An   Ao   Ap   Aq   Aru   AsV   At7   Au   Au   Av   Aw   Ax   Ay}   Az^   A{?   A|    A}   A}   A~   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   AǶ   Aȗ   Ax   AY   A:   A   A   A   Aξ   Aϟ   AЀ   Aa   AB   A#   A   A   A   A֧   A׈   Ai   AJ   A+   A   A   A   Aݯ   Aސ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A    A   A   Az   A[   A<   A   A   A   A   A	   A
   Ac   AD   A
%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A {   A!\   A"=   A#   A#   A$   A%   A&   A'   A(d   A)E   A*&   A+   A+   A,   A-   A.   A/l   A0M   A1.   A2   A2   A3   A4   A5   A6t   A7U   A86   A9   A9   A:   A;   A<   A=|   A>]   A?>   A@   AA    AA   AB   AC   AD   AEe   AFF   AG'   AH   AH   AI   AJ   AK   ALm   AMN   AN/   AO   AO   AP   AQ   AR   ASu   ATV   AU7   AV   AV   AW   AX   AY   AZ}   A[^   A\?   A]    A^   A^   A_   A`   Aa   Abf   AcG   Ad(   Ae	   Ae   Af   Ag   Ah   Ain   AjO   Ak0   Al   Al   Am   An   Ao   Apv   AqW   Ar8   As   As   At   Au   Av   Aw~   Ax_   Ay@   Az!   A{   A{   A|   A}   A~   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   Aŷ   AƘ   Ay   AZ   A;   A   A   A   A̿   A͠   A΁   Ab   AC   A$   A   A   A   AԨ   AՉ   Aj   AK   A,   A
   A   A   A۰   Aܑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A    A{   A\   A=   A   A   A   A   A   A   A	d   A
E   A&   A   A   A
   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A >   A!   A"    A"   A#   A$   A%   A&e   A'F   A('   A)   A)   A*   A+   A,   A-m   A.N   A//   A0   A0   A1   A2   A3   A4u   A5V   A67   A7   A7   A8   A9   A:   A;}   A<^   A=?   A>    A?   A?   A@   AA   AB   ACf   ADG   AE(   AF	   AF   AG   AH   AI   AJn   AKO   AL0   AM   AM   AN   AO   AP   AQv   ARW   AS8   AT   AT   AU   AV   AW   AX~   AY_   AZ@   A[!   A\   A\   A]   A^   A_   A`g   AaH   Ab)   Ac
   Ac   Ad   Ae   Af   Ago   AhP   Ai1   Aj   Aj   Ak   Al   Am   Anw   AoX   Ap9   Aq   Aq   Ar   As   At   Au   Av`   AwA   Ax"   Ay   Ay   Az   A{   A|   A}h   A~I   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   Aø   Aę   Az   A[   A<   A   A   A   A   Aˡ   A̂   Ac   AD   A%   A   A   A   Aҩ   Aӊ   Ak   AL   A-   A   A   A   Aٱ   Aڒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A ]   A>   A   A    A   A   A   A   Ae   AF   A	'   A
   A
   A   A   A
   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A    A    A!   A"   A#   A$f   A%G   A&(   A'	   A'   A(   A)   A*   A+n   A,O   A-0   A.   A.   A/   A0   A1   A2v   A3W   A48   A5   A5   A6   A7   A8   A9~   A:_   A;@   A<!   A=   A=   A>   A?   A@   AAg   ABH   AC)   AD
   AD   AE   AF   AG   AHo   AIP   AJ1   AK   AK   AL   AM   AN   AOw   APX   AQ9   AR   AR   AS   AT   AU   AV   AW`   AXA   AY"   AZ   AZ   A[   A\   A]   A^h   A_I   A`*   Aa   Aa   Ab   Ac   Ad   Aep   Ap   Aq   Ar   As   Ata   AuB   Av#   Aw   Aw   Ax   Ay   Az   A{i   A|J   A}+   A~   A~   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   Aɢ   Aʃ   Ad   AE   A&   A   A   A   AЪ   Aы   Al   AM   A.   A   A   A   Aײ   Aؓ   At   AU   A6   A   A   A   A޺   Aߛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A     A   A   A   A   A   Af   AG   A(   A	   A   A	   A
   A   An   A
O   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A    A!   A"g   A#H   A$)   A%
   A%   A&   A'   A(   A)o   A*P   A+1   A,   A,   A-   A.   A/   A0w   A1X   A29   A3   A3   A4   A5   A6   A7   A8`   A9A   A:"   A;   A;   A<   A=   A>   A?h   A@I   AA*   AB   AB   AC   AD   AE   AFp   AGQ   AH2   AI   AI   AJ   AK   AL   AMx   ANY   AO:   AP   AP   AQ   AR   AS   AT   AUa   AVB   AW#   AX   AX   AY   AZ   A[   A\i   A]J   A^+   A_   A_   A`   Aa   Ab   Acq   AdR   Ae3   Af   Af   Ag   Ah   Ai   Ajy   AkZ   Al;   Am   Am   An   Ao   Ap   Aq   Arb   AsC   At$   Au   Au   Av   Aw   Ax   Ayj   AzK   A{,   A|
   A|   A}   A~   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aǣ   AȄ   Ae   AF   A'   A   A   A   AΫ   Aό   Am   AN   A/   A   A   A   Aճ   A֔   Au   AV   A7   A   A   A   Aܻ   Aݜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A    A   A   Ag   AH   A)   A
   A   A   A   A	   A
o   AP   A1   A
   A
   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   A h   A!I   A"*   A#   A#   A$   A%   A&   A'p   A(Q   A)2   A*   A*   A+   A,   A-   A.x   A/Y   A0:   A1   A1   A2   A3   A4   A5   A6a   A7B   A8#   A9   A9   A:   A;   A<   A=i   A>J   A?+   A@   A@   AA   AB   AC   ADq   AER   AF3   AG   AG   AH   AI   AJ   AKy   ALZ   AM;   AN   AN   AO   AP   AQ   AR   ASb   ATC   AU$   AV   AV   AW   AX   AY   AZj   A[K   A\,   A]
   A]   A^   A_   A`   Aar   AbS   Ac4   Ad   Ad   Ae   Af   Ag   Ahz   Ai[   Aj<   Ak   Ak   Al   Am   An   Ao   Apc   AqD   Ar%   As   As   At   Au   Av   Awk   AxL   Ay-   Az   Az   A{   A|   A}   A~s   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   AŤ   Aƅ   Af   AG   A(   A	   A   A   A̬   A͍   An   AO   A0   A   A   A   AӴ   Aԕ   Av   AW   A8   A   A   A   Aڼ   A۝   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A    Ah   AI   A*   A   A   A   A   A   Ap   A	Q   A
2   A   A   A   A
   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A +   A!   A!   A"   A#   A$   A%q   A&R   A'3   A(   A(   A)   A*   A+   A/   A0   A1   A2   A3   A4b   A5C   A6$   A7   A7   A8   A9   A:   A;j   A<K   A=,   A>
   A>   A?   A@   AA   ABr   ACS   AD4   AE   AE   AF   AG   AH   AIz   AJ[   AK<   AL   AL   AM   AN   AO   AP   AQc   ARD   AS%   AT   AT   AU   AV   AW   AXk   AYL   AZ-   A[   A[   A\   A]   A^   A_s   A`T   Aa5   Ab   Ab   Ac   Ad   Ae   Af{   Ag\   Ah=   Ai   Ai   Aj   Ak   Al   Am   And   AoE   Ap&   Aq   Aq   Ar   As   At   Aul   AvM   Aw.   Ax   Ax   Ay   Az   A{   A|t   A}U   A~6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   Aå   AĆ   Ag   AH   A)   A
   A   A   Aʭ   Aˎ   Ao   AP   A1   A   A   A   Aѵ   AҖ   Aw   AX   A9   A   A   A   Aؽ   Aٞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   A J   A+   A   A   A   A   A   Aq   AR   A3   A	   A	   A
   A   A   A
y   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A    A!   A"   A#r   A$S   A%4   A&   A&   A'   A(   A)   A*z   A+[   A,<   A-   A-   A.   A/   A0   A1   A2c   A3D   A4%   A5   A5   A6   A7   A8   A9k   A:L   A;-   A<   A<   A=   A>   A?   A@s   AAT   AB5   AC   AC   AD   AE   AF   AG{   AH\   AI=   AJ   AJ   AK   AL   AM   AN   AOd   APE   AQ&   AR   AR   AS   AT   AU   AVl   AWM   AX.   AY   AY   AZ   A[   A\   A]t   A^U   A_6   A`   A`   Aa   Ab   Ac   Ad|   Ae]   Af>   Ag   Ah    Ah   Ai   Aj   Ak   Ale   AmF   An'   Ao   Ao   Ap   Aq   Ar   Asm   AtN   Au/   Av   Av   Aw   Ax   Ay   Azu   A{V   A|7   A}   A}   A~   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   AȮ   Aɏ   Ap   AQ   A2   A   A   A   A϶   AЗ   Ax   AY   A:   A   A   A   A־   Aן   A؀   Aa   AB   A#   A   A   A   Aާ   A߈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A 
   A    A   A   A   Ar   AS   A4   A   A   A   A	   A
   Az   A[   A
<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A    A!s   A"T   A#5   A$   A$   A%   A&   A'   A({   A)\   A*=   A+   A+   A,   A-   A.   A/   A0d   A1E   A2&   A3   A3   A4   A5   A6   A7l   A8M   A9.   A:   A:   A;   A<   A=   A>t   A?U   A@6   AA   AA   AB   AC   AD   AE|   AF]   AG>   AH   AI    AI   AJ   AK   AL   AMe   ANF   AO'   AP   AP   AQ   AR   AS   ATm   AUN   AV/   AW   AW   AX   AY   AZ   A[u   A\V   A]7   A^   A^   A_   A`   Aa   Ab}   Ac^   Ad?   Ae    Af   Af   Ag   Ah   Ai   Ajf   AkG   Al(   Am	   Am   An   Ao   Ap   Aqn   ArO   As0   At   At   Au   Av   Aw   Axv   AyW   Az8   A{   A{   A|   A}   A~   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   AƯ   Aǐ   Aq   AR   A3   A   A   A   Aͷ   AΘ   Ay   AZ   A;   A   A   A   AԿ   Aՠ   Aց   Ab   AC   A$   A   A   A   Aܨ   A݉   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A    A   As   AT   A5   A   A   A   A   A   A	{   A
\   A=   A   A   A
   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   A U   A!6   A"   A"   A#   A$   A%   A&|   A']   A(>   A)   A*    A*   A+   A,   A-   A.e   A/F   A0'   A1   A1   A2   A3   A4   A5m   A6N   A7/   A8   A8   A9   A:   A;   A<u   A=V   A>7   A?   A?   A@   AA   AB   AC}   AD^   AE?   AF    AG   AG   AH   AI   AJ   AKf   ALG   AM(   AN	   AN   AO   AP   AQ   ARn   ASO   AT0   AU   AU   AV   AW   AX   AYv   AZW   A[8   A\   A\   A]   A^   A_   A`~   Aa_   Ab@   Ac!   Ad   Ad   Ae   Af   Ag   Ahg   AiH   Aj)   Ak
   Ak   Al   Am   An   Aoo   ApP   Aq1   Ar   Ar   As   At   Au   Avw   AwX   Ax9   Ay   Ay   Az   A{   A|   A}   A~`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   Aİ   Aő   Ar   AS   A4   A   A   A   A˸   A̙   Az   A[   A<   A   A   A   A   Aӡ   AԂ   Ac   AD   A%   A   A   A   Aک   Aۊ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   A t   AU   A6   A   A   A   A   A   A|   A]   A	>   A
   A    A   A   A
   A   Ae   AF   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A    A    A!   A"   A#   A$}   A%^   A&?   A'    A(   A(   A)   A*   A+   A,f   A-G   A.(   A/	   A/   A0   A1   A2   A3n   A4O   A50   A6   A6   A7   A8   A9   A:v   A;W   A<8   A=   A=   A>   A?   A@   AA~   AB_   AC@   AD!   AE   AE   AF   AG   AH   AIg   AJH   AK)   AL
   AL   AM   AN   AO   APo   AQP   AR1   AS   AS   AT   AU   AV   AWw   AXX   AY9   AZ   AZ   A[   A\   A]   A^   A_`   A`A   Aa"   Ab   Ab   Ac   Ad   Ae   Afh   AgI   Ah*   Ai   Ai   Aj   Ak   Al   Amp   AnQ   Ao2   Ap   Ap   Aq   Ar   As   Atx   AuY   Av:   Aw   Aw   Ax   Ay   Az   A{   A|a   A}B   A~#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A±   AÒ   As   AT   A5   A   A   A   Aɹ   Aʚ   A{   A\   A=   A   A   A   A   AѢ   A҃   Ad   AE   A&   A   A   A   Aت   Aً   Al   AM   A.   A   A   A   A߲   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A 7   A   A   A   A   A   A}   A^   A?   A    A	   A	   A
   A   A   A
f   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A    A!   A"~   A#_   A$@   A%!   A&   A&   A'   A(   A)   A*g   A+H   A,)   A-
   A-   A.   A31   A4   A4   A5   A6   A7   A8w   A9X   A:9   A;   A;   A<   A=   A>   A?   A@`   AAA   AB"   AC   AC   AD   AE   AF   AGh   AHI   AI*   AJ   AJ   AK   AL   AM   ANp   AOQ   AP2   AQ   AQ   AR   AS   AT   AUx   AVY   AW:   AX   AX   AY   AZ   A[   A\   A]a   A^B   A_#   A`   A`   Aa   Ab   Ac   Adi   AeJ   Af+   Ag   Ag   Ah   Ai   Aj   Akq   AlR   Am3   An   An   Ao   Ap   Aq   Ary   AsZ   At;   Au   Au   Av   Aw   Ax   Ay   Azb   A{C   A|$   A}   A}   A~   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   AǺ   Aț   A|   A]   A>   A   A    A   A   Aϣ   AЄ   Ae   AF   A'   A   A   A   A֫   A׌   Am   AN   A/   A   A   A   Aݳ   Aޔ   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A    A   A   A~   A_   A@   A!   A   A   A   A	   A
   Ag   AH   A
)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A    A!`   A"A   A#"   A$   A$   A%   A&   A'   A(h   A)I   A**   A+   A+   A,   A-   A.   A/p   A0Q   A12   A2   A2   A3   A4   A5   A6x   A7Y   A8:   A9   A9   A:   A;   A<   A=   A>a   A?B   A@#   AA   AA   AB   AC   AD   AEi   AFJ   AG+   AH   AH   AI   AJ   AK   ALq   AMR   AN3   AO   AO   AP   AQ   AR   ASy   ATZ   AU;   AV   AV   AW   AX   AY   AZ   A[b   A\C   A]$   A^   A^   A_   A`   Aa   Abj   AcK   Ad,   Ae
   Ae   Af   Ag   Ah   Air   AjS   Ak4   Al   Al   Am   An   Ao   Apz   Aq[   Ar<   As   As   At   Au   Av   Aw   Axc   AyD   Az%   A{   A{   A|   A}   A~   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   AŻ   AƜ   A}   A^   A?   A    A   A   A   Aͤ   A΅   Af   AG   A(   A	   A   A   AԬ   AՍ   An   AO   A0   A   A   A   A۴   Aܕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A    A   A`   AA   A"   A   A   A   A   A   A	h   A
I   A*   A   A   A
   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   A B   A!#   A"   A"   A#   A$   A%   A&i   A'J   A(+   A)   A)   A*   A+   A,   A-q   A.R   A/3   A0   A0   A1   A2   A3   A4y   A5Z   A6;   A7   A7   A8   A9   A:   A;   A<b   A=C   A>$   A?   A?   A@   AA   AB   ACj   ADK   AE,   AF
   AF   AG   AH   AI   AJr   AKS   AL4   AM   AM   AN   AO   AP   AQz   AR[   AS<   AT   AT   AU   AV   AW   AX   AYc   AZD   A[%   A\   A\   A]   A^   A_   A`k   AaL   Ab-   Ac   Ac   Ad   Ae   Af   Ags   AhT   Ai5   Aj   Aj   Ak   Al   Am   An{   Ao\   Ap=   Aq   Aq   Ar   As   At   Au   Avd   AwE   Ax&   Ay   Ay   Az   A{   A|   A}l   A~M   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   Aü   Aĝ   A~   A_   A@   A!   A   A   A   A˥   A̆   Ag   AH   A)   A
   A   A   Aҭ   Aӎ   Ao   AP   A1   A   A   A   Aٵ   Aږ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   A a   AB   A#   A   A   A   A   A   Ai   AJ   A	+   A
   A
   A   A   A
   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A    A    A!   A"   A#   A$j   A%K   A&,   A'
   A'   A(   A)   A*   A+r   A,S   A-4   A.   A.   A/   A0   A1   A2z   A3[   A4<   A5   A5   A6   A7   A8   A9   A:c   A;D   A<%   A=   A=   A>   A?   A@   AAk   ABL   AC-   AD   AD   AE   AF   AG   AHs   AIT   AJ5   AK   AK   AL   AM   AN   AO{   AP\   AQ=   AR   AR   AS   AT   AU   AV   AWd   AXE   AY&   AZ   AZ   A[   A\   A]   A^l   A_M   A`.   Aa   Aa   Ab   Ac   Ad   Aet   AfU   Ag6   Ah   Ah   Ai   Aj   Ak   Al|   Am]   An>   Ao   Ap    Ap   Aq   Ar   As   Ate   AuF   Av'   Aw   Aw   Ax   Ay   Az   A{m   A|N   A}/   A~   A~   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   Aɦ   Aʇ   Ah   AI   A*   A   A   A   AЮ   Aя   Ap   AQ   A2   A   A   A   A׶   Aؗ   Ax   AY   A:   A   A   A   A޾   Aߟ   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A $   A   A   A   A   A   Aj   AK   A,   A
   A   A	   A
   A   Ar   A
S   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A    A!   A"k   A#L   A$-   A%   A%   A&   A'   A(   A)s   A*T   A+5   A,   A,   A-   A.   A/   A0{   A1\   A2=   A3   A3   A4   A5   A6   A7   A8d   A9E   A:&   A;   A;   A<   A=   A>   A?l   A@M   AA.   AB   AB   AC   AD   AE   AFt   AGU   AH6   AI   AI   AJ   AK   AL   AM|   AN]   AO>   AP   AQ    AQ   AR   AS   AT   AUe   AVF   AW'   AX   AX   AY   AZ   A[   A\m   A]N   A^/   A_   A_   A`   Aa   Ab   Acu   AdV   Ae7   Af   Af   Ag   Ah   Ai   Aj}   Ak^   Al?   Am    An   An   Ao   Ap   Aq   Arf   AsG   At(   Au	   Au   Av   Aw   Ax   Ayn   AzO   A{0   A|   A|   A}   A~   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   Aǧ   AȈ   Ai   AJ   A+   A   A   A   Aί   Aϐ   Aq   AR   A3   A   A   A   Aշ   A֘   Ay   AZ   A;   A   A   A   Aܿ   Aݠ   Aށ   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A    A   A   Ak   AL   A-   A   A   A   A   A	   A
s   AT   A5   A
   A
   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   A l   A!M   A".   A#   A#   A$   A%   A&   A't   A(U   A)6   A*   A*   A+   A,   A-   A.|   A/]   A0>   A1   A2    A2   A3   A4   A5   A6e   A7F   A8'   A9   A9   A:   A;   A<   A=m   A>N   A?/   A@   A@   AA   AB   AC   ADu   AEV   AF7   AG   AG   AH   AI   AJ   AK}   AL^   AM?   AN    AO   AO   AP   AQ   AR   ASf   ATG   AU(   AV	   AV   AW   AX   AY   AZn   A[O   A\0   A]   A]   A^   A_   A`   Aav   AbW   Ac8   Ad   Ad   Ae   Af   Ag   Ah~   Ai_   Aj@   Ak!   Al   Al   Am   An   Ao   Apg   AqH   Ar)   As
   As   At   Au   Av   Awo   AxP   Ay1   Az   Az   A{   A|   A}   A~w   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   AŨ   AƉ   Aj   AK   A,   A
   A   A   A̰   A͑   Ar   AS   A4   A   A   A   AӸ   Aԙ   Az   A[   A<   A   A   A   A   Aۡ   A܂   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A     A l   A M   A .   A    A    A    A    A    A t   A 	U   A 
6   A    A    A    A 
   A    A |   A ]   A >   A    A     A    A    A    A    A e   A F   A '   A    A    A    A    A    A m   A N   A  /   A !   A !   A "   A #   A $   A %u   A &V   A '7   A (   A (   A )   A *   A +   A ,}   A -^   A .?   A /    A 0   A 0   A 1   A 2   A 3   A 4f   A 5G   A 6(   A 7	   A 7   A 8   A 9   A :   A ;n   A <O   A =0   A >   A >   A ?   A @   A A   A Bv   A CW   A D8   A E   A E   A F   A G   A H   A I~   A J_   A K@   A L!   A M   A M   A N   A O   A P   A Qg   A RH   A S)   A T
   A T   A U   A V   A W   A Xo   A YP   A [   A \   A ]   A ^   A _w   A `X   A a9   A b   A b   A c   A d   A e   A f   A g`   A hA   A i"   A j   A j   A k   A l   A m   A nh   A oI   A p*   A q   A q   AGAɅAʏ\A
=A(AA(A  A
AA=qAffAȸRApAǮAQAǮA=qAǅAǮAȸRA33AʸRAƏ\A(A  AAȏ\AɅA(A
=A  A=qA
AÅAģAȏ\AGAAzA(Aď\A\)AƸRAzAQAzAGAGA33AA  A33AA{ApAĸRAAAŅAGApAHA¸RA=qA=qAQAzA
A=qAA=qAAGAAÅAHAAffAÙAAzA\)AAA
ARAAA=qA
A
=AAAAA33A\)AGA\)A¸RAA
A\)A{AŅAŅAQAŮAzAA  ApAA\)AƣAAAGA\)AAQApA33Aď\A
=AzAAA
A
A(A{A\)AHAA(AA{A33AAď\AA£ApAAzAřAď\AÙA¸RAAQAA
=AAGARAGA{A\)AAzAAA\)ARA\AApA
=AApAAřA{AQAŮAŅAGA
A
A{AHA\)AǮApAƸRAA33A\)AAȏ\ApAǅAAA\)AGA
=AəA  AQAAffAzA
A\)A\)AApAHAAAA
=AzAAffAʏ\A  AˮA
=A˅A
=AGAˮAȣA
A(A=qAAƣAŅAffAǅA{A{ARA33AHAHA
AƏ\ApApA\)AAffAzAŅAřAzA
=ApAď\Aď\AGA{AƸRA33AŅAGA
AA  AA33A\A\A33AA\)AA
=A
=AHAHAGAŮAřA{A
=AQAffAAƏ\AAffA{Aȏ\AA{A(Aȏ\AAA
A
AffAHAAəAGAzAQA
=A  AHA(Aʏ\AAȸRA33AˮAʸRAHA
=AA33AȸRA(AA
=Aȏ\AGA
A\)A  AAffA  AƸRAřA{AŮA
AzAzA\)ApAģApA
=A
=AHAŮAřA=qApAHAƏ\AAģA  AřAAQA{AApAApAAAffA  AƸRA\)A
=AffA\)AAǮAAɅAǙA(AAǙA{AHA\)AŅAģAApAA33A  AQAƏ\AA
A{A=qA(A(A
A  AAHAAȏ\AffA
A=qẠA{AGAA̸RAAA
A\)AʸRAɅAAəA  A
A\)A=qAAʏ\ApAƣAffA̸RẠAAffAʸRAHA33AAAǅA
=A33AǙAAHA{A
=A33A(A=qAffAzA=qA=qA=qAǅAƣAAGAˮAʸRAAƏ\AřAAGAA
=AHA  AŮAAA
A  AffAAHAǅAǅA
AəA  AA=qAffAəAəAəAAAHA33AAHAȏ\Aȏ\A
=A
=AGA
ApA\)AʣAffAA˅AAAAffAẠAʏ\AffAəAɅAAffAAˮAffAffAυAAzAGA  AA(A
=AA˙AzAɮA{AGAǅAQA(A=qAAǮApA=qA  AQA
=AȣAɅAGAQAQApAAˮApAˮAʸRA\)ApAAAAɅA  AAGAAffA{AAʣAȏ\A\)AȣAHAAffAAəAAɅAA
=AʣA{A(AȣAʣAʸRAA{AAQA(AʸRAʸRA{A
=AAAʣAʸRẠAAApAA
=AA(AApAffAA33AˮAHA
=AGAAʏ\A  AzA
AʣAAɅAAA\)AA(AGA
AAHA
A33AffA
AA(A  AAA(A\)A£A  A  AAǙApApAŮAQAHAģAĸRAGAəApAQAʸRAAŮA
=AApAŅAƣAHAQAApAHAȸRA
=A33AɅAɮAAȸRA{AəAGAffAȏ\AGAɅAQA=qA
AȸRAȏ\A=qAʸRApA\)AA\)Aʏ\A{A33AffA
=A33A
AQAffA(AAGAAHA
=AȣAȸRAȸRApAGAAAA
=AAŮA
=AffA  AA£ApAAA£AzAǮAHAffA˅AzAzAAGAAʣAHAA{A(AA\)AzA(AQA  AffAA(A
AHAAĸRAĸRAGAŅAffA
=A
=AǙA(AȸRAApAGAAȸRAAzA(AGAQA
A
AQAǮAɅAǅAǮAQAA{Ȁ\A̸RAˮA  AˮAʣA{A\)A\)A˅A(A˙A˙AA\)A
=A˅ẠAA\)A33AHA
A{AzAQAəAȣA33A{AȣAAHAffAƸRA  A  A  A\)AƸRAAA=qApAʣAffA(AGA33A33AffA
=ApAǅA{A  AA\)A˙ApAQA(AẠA͙AͮA=qAAA
=AͅAQAffAGA
=A(AAǮAA  A{AHAA
=A\)A
A\)A
A
AHAA33AȸRAffAApAA33AAQẠApAɮAzAQAHAffA=qAffA{AA(A  AͮA33A˅A˙AʸRA=qA
=AQA
=AǙA\)ApA(AffAARAAAHAGAřAQA\)A(AzAAzAA=qAAAǙAȏ\AAǙAGAǅA\)AGAGA33AQAǅAA(A{AffA
=A
=AɅAʸRAAʏ\AAffAQAA(AQAzA(A
AHAAzA=qAGAͅA33AˮȀ\A33AʣAGAA{A˙A˙AAA(A  AAGAGAAAʣAȣA˅AɮȀ\AAȀ\AʣAA33AAGAAA=qAGAAAGA33AɮAʸRAAAffAǅAAGAɮAffAǮAGAApAAzAAGAGAŅA{AɮA  AəAGA
A
AAəAȣAGAAGAAAAƏ\AA{AȣAffAQA33Ȁ\AGApAϮAQA=qAͮAͮAffAQA{AA˙A(AAA=qAAQApA˅A˅A˅AAAHAʏ\A(AGAəA=qAʸRAʸRAAHAHAʣA(A
AɅA
A33AGAȸRA(A
AGApAƣApAGA(Ȁ\A˅A(AAA{A{AffAAAA(A=qAAzA(AGAffA¸RAAŅA
AAǮA
=A=qAQA{AŮAď\AģA\)AAzAAAffA33AAAHAQAAAʏ\AzAʣAffAʣAʣAA33A˅ApA˅AʣAʏ\AffAʸRAɅAɅAffA\)AAHApAAAzAǙAA33AA\)AGA(ApAƣAǮAQAGAA
=AȸRAɅAʏ\AA
AAzAǮAGAAǮAǮAA
=AǅA  AȣAȸRA33ApAQA
=AʸRAHA=qAA
=A(AffA  AAffA  AGApA  AAA£A=qAƣAAGApAA=qAAAAǮA
AQA=qAApAɅAȣAȏ\Aȏ\AAȸRAffA33ApAHA=qAA(AQApAǙA(AApAA  AȸRAzAApA  ApA
AA(ApAA{A{A{A{A\)AƸRA(A{AAA{AƸRA
A=qA(A33A(A{AAȸRA=qA(AAA  AA(ApAffAˮAˮA  AAzA\)A{AGAA\)A¸RAHA33AAGAGA\)AQAA(AAƣApAffAǅAAGAHAŮA=qA\)A
AffA33AGAřAǅA  AȣA
=ApA=qA˅AA(A  ApA˅A˅A
AˮA˙AAzȀ\AffA͙AGApA=qA  AAɮA(AzAAzAGAAGA\)Aʏ\Aʏ\A
AzA=qA\)A\)AHA(AȸRAzA  AAHAzA\)A=qA=qAƏ\AAAŅAĸRAîAA=qA
ApA{ApAƣA
=ARAQA¸RAAA
=A\)AGAď\A
=A=qAƏ\AAřA=qAƸRAƏ\AHAA
AApA  AAAȏ\AəAɮA
A(AffAHA\)AAʏ\AffA33A\)AA=qAffA\)AzAGApApAGAͅApAAAAAA̸RA=qA  Ȁ\AAǅA33AɅA
A33A
=A
=AHAA33AAAʏ\AAAȣAHAQA{A(AǙAGAȣAȣAGA  ApAzAƸRAQAřAA33AGA  A(A=qAARA=qAŅAAA  AzA
AGAŮA\)AřAHAĸRA33AÙAHApAAffAď\A=qA
AA
=AŅAǙAAQA(AƸRAAƸRAǅApAHA33ApAGAǅAǅA\)AǅApAAHA
AȣAHA
=A\)AA=qAɅA
A  A{AzAA33AŅAffAAƣA
=AƏ\AA
AQA(A(A=qA=qA=qAəA(AȣA
AAAffAQA{AGAĸRA(Aď\AGAHAAA=qA(A
=AA
AŅAƸRAAGAGAzAA(AAŮA  AřAAA  AApA(AA  AAzApAǙAGAHAƸRAA{A33A  AAHAAHA=qA=qAƸRAGAǮAGAAA  A  AzAƸRAAƣAHAAAGAzAAGAAAA  AǅA=qAAƸRAApAGA
=AƸRAGAA33A
=A\)AAȏ\AAHAHAȏ\AǅA(AŮAA{AHAGAGAHA
=AAģAA=qA(A
AAHA  AHAAA(Aʏ\ApAǙAAƏ\AffAA33Aď\AGApAŅAƸRAAAHAQA  AAƏ\Aď\AĸRAA(A
A  A=qAQAƣAGAA=qA{A
=AǅAA{A(A
AAA
A
AAAǅAǙApA\)AAAAAƸRAQA\)AřAGAƣAzA=qAƸRA
=A\)ApAǅAAA{AGAÙA33AAzAĸRAQAApA=qApApAQA  A¸RA\)A{A
AARAAHAA33AGA33AffAHA33A
=A\)A£ApAGA
A£A\)AzA33AAHA33A\)A33A
A33AA  AA{A{AAAApApAAGAGA
=A
=ApA
A
=AA(A\AA  AGAÅA
AA\)Aď\AģA
=A=qAzA33Aď\AA(A
AffAA  AQAA33A  A=qA\)A(A=qAÙAA=qA
=AA
AîAAA=qAHA\)AAŅAŮAAģAzA
Aď\A33AGAffA
A
Aď\A
=AffAffAÅAAAQApA
=AGAA{ApAAQA(A{A=qA  A\AA
=A\AzAǅAGAAzA=qAřAGAA
=AAGAAHA
AAzAA{A(AAAAffAÙA(A  AÅAApAGAAAÙAAAGA
=AAAQA33AAAQA=qAA\AzApAAffAA  A=qARA\AAGAGA\AA£A  AAGA33A
AHA
A
AAQA£A
A\ApAffAAQAAA=qAA  A=qA33AARAAARAAAA33A£AARAA¸RA{AHA=qAzAƣA{AzAA=qAApA{AHAffA\A=qAA
=AAA
AA
=AffA\A{AGA  AQAzAHA\AA(AApA
A¸RAzA{AzA
AGA
=AA
=AAAAAQA£AARAA  A\)A33A(AApAîA{AAA=qAA{AAffA=qAQA{AHA=qAGAA33AAA¸RAAGAAîA(AģAŅA  AŮA{AƏ\A{AAA=qA\AQAA33AAAÅAÅAAĸRAřAƏ\A
=AffAGAGApAAď\AQA  AGA\)AHA\)A=qA=qA\)ApA33AGAAAAAAAffA  AAA
=AAAApApA=qAA{AA
AAA¸RAzA
=AA
AAÅA=qApApA  A{A\AÙAAHAAď\A(AGAA=qA  A
A=qA£A\AGA=qAffAAAffAŮApAƏ\AƣAǮAǙA(Aȏ\AAA33AHAAHAHAȏ\AȣAɅA33A=qA{AȣA
=AA  AGAffAȸRAAAHA
AQAǮAA=qAzAA\)AģAGAAĸRA\)A¸RApA
=A33A
=AzAÙAGAď\ApA
=AAzAAŅA{AřA\)AQAƸRA
AGA  AAHA\)AÅAffAď\ApAAHAGApA\)AAîA33AÅAzAA
A33A
=AAHAAzA
AHAǅAApAAffAffAffA33AGA33ApAƏ\AAǙAffA{AƸRAzAAAQAzAAǅAGA\)AAzAffAQAƸRA33A
A33AƸRAAA
=AffA
AHAȏ\Aȏ\ApAHAȏ\A=qA{AA33A  AGAHAǙA33A\AAzARAA{A
AA\)AzA\)AAAAffAAffAAAAffAAA
=AA(AzA
=AAAA
=A\ApAAQAHAA
ARAAAffAAzAA=qApA33A33AAAAAA
=AGAAAQAzAApAA{A{AHAA\AAA
=A\AzApAAA
A\)AARA
A
ARAAGApA(AAzAGA{AA33AAAQAAA{A
=AffA\ARA
AAAQA  AAAQAffAAA{A
A\)AzA{A\A33AAHA33AQA{A\ARAHAzA
=AARA\)A{A
=A(AGA\AzAQAzAA
ApA\AAApA
ApAAAA\)AHAAffA
=A\)AffA33AAzA
AzA  A\)AQA33AA=qARApA\)A\AA=qA
AGA
A  A\)A{AA\A
ARAA33AAffA
AGA(A  A  AA=qA  AzAAAA33AA{A  AQAApAAzAAzAAzApAAAAffA\)AffAzAAffAGAAAAzA33AAAA
ApA33AA  AHA=qAAA
A(AAQA
AAGAAffAQAAAA{AAAAAA  A{A{A\)A
=AAAffAAAffA{AAAA=qA\)AApAApAAARAGAHA
AApAA
AAAA\A\AA33A33ARAzA33A33AA\AQARAQApA
A33A(AQAAAHA(ApAAAA
AA\AA\)A33AA{ARAAffA33AAAAGAAARAA
=A\)ARA
=A  AAAAAffAAAQA(A  ApAGAGA{A\AA33ARA(AzA\A(A{A\)ARAHAAA\A  AzAAA(A
AA=qAAAQA
ARA\AAAAA{AAzA
A33AAHAQAA=qAA  AHA33A\)A33AA33A(AzA
=A(AA  ApAAQARAHA(AA\)A\)ARAAA33A
A33A=qAAAQAHAAAA\)AA
=AHA=qA=qAA=qAA(AAzAAARA\)AAAzAAA
=AA\A33AffApA\)ApAAA=qAQA(AA(AAAGAAAAAAHAAA{AffAA
=AARAARAGA33ApA(A33A
=AAzAAA33ARAffA\)AAA\)A{AAAA{A(A(A
A{AƣAA  AŮA{A{AA{AHA
=A{AAA(A  AAAA=qAzAHA33AAGAGA\A\)AA{A
=AAAQA
AApAffA
AAffA33A33AGA\)A(A(AHA  AHApAAffA33A(AAffA=qAGAffAAA
AAAA  A(AffAAGAAGARApA
=A  A\)AAAA\A  AA\ApAAAQA=qA
A\)Aď\AĸRA\)AƏ\AQA=qA33AAAHA{AQApARARAAffAQA
=AffAHAA(A33A(ARAAGA\)AA  A
=A33AA  AHAAAQA33A
=A=qAAAHAzAAffA{A{AApA33AffA(A(AAffAA  AA=qA
AHA(A33A{AGAAÙAffAA\)AAAA{AAffAA=qARA
ARAAAHAffAQAAHA33ARA  AA  A\)AAGAffA=qA=qA  AA
A  A33A(A=qAA
=AARA\)A¸RA
=A
=A(AřA  A{AffAAffA=qA=qAîAQAGARAQAA
=A=qAHAAffA  Aď\A33AA\)AA(A¸RAApA
=AÙA  AÙAzAAA  AA
AÙAď\AGA
AHAffAAŅAAƏ\ApApAÙAîA33AA33A
=ARAzA£AAHAģAŅApAAAǮAAHAAȣAAɮAɅAHA(AGAHAffAQA=qAǮAAAffAƣAzAƏ\AHA
=AȸRA
AɅA{AAȏ\A33AAA33A\)Aȏ\AŮAA\)AzApA=qAzA=qA(A
=AAffAʣAŅAǮAzA
=AA(A  A{AQA\)AîA  A\)AzA\ARAAA\)ApAAQA£A
AA\AAzA\)AA\)AffA{AQAGAA=qAGAĸRA
=A(AƸRA33AAzAApA(AŅAƣAǮAA{A  A{A=qAQAAAŅAffAƏ\AŅA\)AAřApA
A(AQA=qA(AÙARAAzAAQA(AzA\)AǙA
AƣA\)A33AǮA{A
AAzAffAAA
ApA\)A  AzA
=A
=A\AA{A33AAffApA33AQA
A\AzA=qAGAŮAffAffA
AAAzARA  AAA
=AA
AHA
=AzA  A{AA(A33A33AA
=ApAA\)AA
A¸RA\)AîAÙAA
A33AHAGAAA\AA\ARAA\AA(A=qAAAAÅA(A{AA
AA33A{A\ApA
AAzA=qAAAzAAAGA  A\)A{AGAAAAAzAHA  AQAQAGAAAAA
=AA\)AGAA
=ARA
=A33ApAAAQAffAA33ApA(AA
AApA(AAA  A(ApA  ARAzAA\A
=AA{AffAAAGA
AA=qA=qA  AQARA  AA33AAA\)ApAffAAAGARA{AAA
=A\)AzAAAzAffA{A\)AA=qA{A¸RAAAGAAffA£A\A
=A{AAA\AQA=qApAffAAAA(A\)AAAApAHAA33A(AffAAApAffAffA=qA33AAQAGA\A\ApAAGA\A=qA{A  ApAApAA
ARARAAAQAHAAA¸RAGAQA¸RAAAA
AA{A\)ApAAzAffAƸRAǮAHAA  A  A33A33Aď\A  ApAAAǅA  AA  AA33AA33A\AÙAffAHA  AGAA\AAQA=qA\)A\ApAffA(A  AAffApAzAA
A=qApA33AA33AAAAAAQAffApAA33AA=qAA(A(AzA\)A(AA  A
=A=qARAAA33A
Aď\AzAHApA(AQAřA(AA\)AAHA  AffA(ApA
=AQA¸RA33A=qA{A33A33AA
AAÙA¸RA(AA
=AHAA
AÅAHA£ApA\AAA¸RAAApA
=AAA=qA{A\)AARA  A
=AAA\A
=AffA
=AǅAAAzA(ARA33A33ApA33AzA
=AA
A  AAA(AAAHA
=AffA£A\A{AĸRAffA33AGA\A
A=qAGA{ARA\AAffAffAzAARA\)A33A
=AA\A  AA  A=qA\AzAÅAQA{A=qAƣAAɅAȸRA
Aȏ\AɮAffA
=AGA{A(A£A
A\)AA¸RApAŅAAĸRAŅAzAģA  AzA\)AAApA
AzAǅAAA(AAffA
ApA  A(AAGA(AQAA{A  A33A(A
A=qA\AHAAA
=A33A33AA(AzAAAffA=qA  AA{A{AQA
=A\)AAA  A  A(A(AffAQAA33AA33AffAA
=ApAAA{A(AzAffA
A\A{AffAAffA\AA{AzA  A  AffAffA33AAffAAAHApAffA
A\)AAzA(A
=AAA33AffA
AAAAAHARA
A
AA  A\A\)A=qARAAzAffAAGAAAA(AzAA\AA
=AAA{A
=AHAA(AAARAffA
=AHAA\)AA
=A
=A  A  AffAApAQARAA33ApAA{AAGAHAA33AA
=A
=AHA(AffAQA
=AA\)AQAA=qAffA=qAAAAA{A(AAGAffA(AARAAAffAAAA{A(A\A{A33AHAA=qAA\A  AAzA\AAHAAffAGAAAAA
=A33AGAQAA\AARAGAAA33AA\A33ARAA=qAAGAAAAGA
=AffAA(AzA(AÙA
=AQA\)AA\AQA\AGAApAÙAAA
=A¸RAzAAHAAQAA
A\)A  AHA\)A
=A  AHA=qA33AŮAA
A=qAHAHAffAAGAîApAffAffA(AA(AQAǙApA  AAA33AffA{AAA33AAŅAA33AffA
A\AGAQAAffAGAGAAA\A=qApAÙA\)AAAAAAAGApA
=ApA(A33ApAA(AǅAAƸRAƏ\AƏ\AQAQAQAffAƏ\AƣAƸRAQAƏ\A  AHAffApA\)AƏ\AA  AAȏ\AffAGAģAAAA
AÅApAHAGAffA(A33AzA(A
=A
A(AHAîAĸRApApAǅAəAɮA  AȣAȣA{AffAȸRAzA  A  A(A33AǮAzApA
AƣAffA\)AQA
AAģAffApAAA\)AGAHA  A
AAǙAǅAřAAA
AAƣAA=qAÙA\AÅAAQAŅA=qA=qApAəAAɅAɮAAQAȏ\AʸRAffAAAÙApAď\AQA{A(AAȏ\A{ApAAŅAzAGApA\)A{A  A  A=qA
=A=qAƏ\AzAřApAģAAAQAzApAAAAA  A=qAAȏ\AAÅAffAzA  A\)AAARAƸRAHA
AA{ApAď\AGAHAAģAģA\)A
A(Aď\AƏ\AzAA\)A{A=qAHAGA͙AͅAGAA̸RA=qAˮAGA
=AGAˮAˮAAʸRApA=qAŮAĸRAGAHAĸRA
A  A(AŅA
AǙAGA  AzA33AGApA=qA
AQA\)AGAǙA33AAA{A33A{A(AȣAȣAȸRAGAȣAȸRAȣA
A33AHAQA(A{A
=AƣAAAHAHAŮAď\A\)A=qAAffA=qAÅA
A
AzAQARA(A\A
=AAzAHAHA\A\AAGAA¸RA33ApAA
A{A(AffA  AîAAA(A=qAģAAHAAffA{AzAĸRAA  AA(AQAQAƣAQA{A(AŮAŅAA
A\AÙAÙAA=qAîAGAîA
ApAffAAffAHA33AřA(AƏ\AŅAzAzA\AA¸RAA(AAAAA
A(A
A{A
=A
AA\A  A{A{AHA¸RAA  AAApAGAzA=qAAAGA=qA{A\AAQAzAGAGA33A33AGA33ApAAffAzA(AA(AĸRApAŅA
A{AA(AHAGAA{A(AHA33AA33A33AHAA{A33A33ApAŮAƸRApA(A=qA\)AŅAģApA{A(AƏ\A  A=qAHA{AffAzAď\ApAA
=AHAAAGAĸRAA{AHAffAQA£A{A  AARAAApAA
AGA33AffA33ApAA33AffAGA=qAAffA{AAAHAHA
=A33AAQA¸RAAAÙA{AAÙA  A{AzAzA(AffA{AA(A=qAď\AQAffAGAAƸRAffA\)A{AA33AHAAzAAƏ\A33AffAĸRAHAApAAîApAA(ApA=qAîApAAA\AzA{AAHAHA  AGAď\AHAĸRAĸRAģA
AŅA=qAƏ\AffA
=AA
=AGAƏ\AŅAď\Aď\A\)AffAȏ\AǙAffAřAQAǮAzA=qAQAîA=qA  AA¸RA£AA£AAzAzA\)AA\)AA{AAQA¸RAÅAď\AAŮAGAAQA\)AGAffA
=AQAHA
AzAzAAQA33A
=AÅA=qAAGA=qA  AȸRA\)A  A
A(AA{AffApAA
=A¸RAffAAAAAĸRAQApAA(AAzA
=A=qAAAffAAA\AA£AGA\)A£A
A\A
A(AAřAzAAď\A
=AAA=qAAffAAəA=qAʏ\AHAGAˮA{A
AQA  AˮA
=A{A(A
AQAʣA  AffA˅AQAQAQA̸RA  AffAˮAAA(A  ẠȀ\ApA˙Ȁ\AA\)A˙A
=AẠAHAA(A˅AzȀ\ẠAQAQAˮA˅AɮAɅAAAȣAǅAA\)A=qAʏ\ApAHA33AQA
AřApAQAA33AzAGAQA(A
A33AA
=A
=AȸRAHAGA  AȣAǙAǮAǅAŅA=qA£AHAÙAHA(A\A£A
=AQAřA33A\)AHAAA33AAƸRAApApAŅAffAģApA(A
=AAAƣA(AA  A  A{A{AAffAŅAŅAĸRAQAQA33A  AzAA
A
=AzA
A\)AƸRAGAȸRA\)AHAAA=qA  ApAƣA33Aď\AAAGA  A  AŮAÙAģA£AŮApAA£AGAÙA(AApAŅAHA=qA{AĸRAHAA33A33A  A  A  A=qA
AA\)AÅAffA{A£A\AÙA¸RA33AAÅAGA\)A\)A\)AAA£A\)AAAzAQA\A33AÅAAÅA(AQAģA
=AŮAřAAzAď\AA(AAAzA\)A£A(A\A\AAAHAARA(A{AGA33AAA=qA  AHAAA=qA\A¸RAAQAAA33AHA=qA=qAA  A=qAQAAAA=qAAAAQA  A\AA
=A=qAffAffAA=qAffAHAQApAGA
AAA\)AHAAAA=qAHA(AAA\)AA£ApAAzA(A
AAA\A\A  A\)AA(A{A£A33AA\A£AîApA=qAGA¸RApA
A£AzA{A=qAAzA  AAA33A=qAQA\)AAA{A\)AAffARAAAA33AAffA  AA
ARA  AAGAffA\)AA=qAA=qApA\)A\)A33A(A  AAffA\A=qAQAAAÅAGAÅAÅAA(AA33AAAApAGA  A{A  A  A
ApAGAAARAAAARA(AffAffAApAAApA\AApA(A
AA33AAA=qAAAAzAzA=qA\AHA¸RAffAA
ARAAGAAQApApAHAHAAGA(A
=AzAApAA  AA  A(A
AA{AHAAffAA
=ApARAzAApA=qAA=qAA{AffA
AA¸RAffA¸RAAffA\A=qA(A
=A=qAAAHAA\AzA\A33AAA=qAA  AzA\)AAA(A(AzA(A
=AA33A(AApA
A=qAAHA
AA
AffARAAAA{A\)AAA\)AffAA33AA\)A
=AAAAAAA
AAApAQAAARApAA
=A{AAAAAQApApAAAHA
AA
A{A
AAAAzAGA  A\AAA
=AAAARAAAA(AQA
=ARAzA=qA
=ARA  A
=A\AHAzA
=A
AA\)A
A33AARA\)A
=AAQApA
=AAAGApAAGAffA33AHAAA\)AzA\A  ApA\)AAAQAAAA  A=qAAAffAA
=AAAA(AApAQA\)AAQA\AGAGA=qARAApAHAAA\AAzAA¸RA¸RAAGA¸RA\AA
AA
=A
=A(A
AAApA33AA=qAffAA
A  A=qAA\)ApAHARAAzApAAGA
A
AGAzA  A{AzAAQAAGA
AA  AA\AA  AA  AA
ApA(ARAA\)A{AA{A{AAAAzA=qAA\A  A=qAAAA33ApAQAQA(A(AAA
=AAzA33AAA(AAAA\)AffA33A{A
A(AAAGAAA33AA\AARA{AA=qA\ARARAA  AAA\AAA(AHAAffA(A{A{A\)A
AffAzApAA  ARAA{A
A
A\ARA\)A=qAHA  AAffA
A{AHAGA\)A
=A(AQAAffAAA\)AffAA=qAA=qA(A\A\)A{AAGAffAAAAAffAAAAAzAAAGApAHAARAAGAARARAAAAAAAAApAAA(A=qA(AAA
=A
A=qA{A
=A{A
=A
AA=qAA(A\)AzApAAGApA33ARAApAffAGAGAHAARApA
AA\AA33AA
A33ARA{A
=A
=A(AAQAGA\)AAzApAAAAAQAAQA=qA
=A\A33AffAA\ApAffAAA  A\AAAAffAGAAA{AffA(AAAA\A  AffAffAffA\AARAAAA
=A\AA\AAA
=AA\AA{AzA\AARAAffAARA=qAA\)AGA\)A(AApA
AAGAAAAA{A=qA=qAA\)AQAAffA\)AzAAGAA\)A=qA(ApA33A(AAAAA\AHAHAQA\)A(AzAAA=qAHAHA33ARAAHAA=qAGA(A
ARAHAA\)AGApA
AGAffAQAA\A\A
=A{ApAAHA33A\)AA33A\)AGA
=ApAGA\)ARAzAA\)AHAGARAAzA33AAAAQAAA  A=qAA  AARAAQAQAAAAzAA\A33A(A\)AffAQA
=A33A
AQApAAzAAAAAffAzAHAA33AAAAAA(AA=qAA\)AQA
=AA
=AA
AQAApA\AHAAGA\)AA
=AA\A\)A=qAA
=AARA=qA33AzAAffA\)AAA{AA
=AffApA
=AGAGA\AAA{A
AzA
AAAGAffAA
AzA\)A
A  AHAAA{AA33A\)AQAAffAA{AA\AA=qA
=AAAAffA
A
A
=AAAA
AGA{A  ARA  AA=qApAHAAAAffA(AAGAGAAAffAAQA
=AHAQAffAA=qA  A33A33AAA\AA{A
=AA(A=qA
=AĸRAApAĸRAÅA
=AŅAA(A=qA\AA33AzAAffAzAA
AAARA=qApAA(AAGApAAAQA=qAAzAARApA
=AAHAzAQA=qAAA
=ApApAzAAAARAHA{AA(A
AAAAA(AGAA=qARARAA33AA=qAAApARA33A
=A(AzAAQA{AGA
=AA33AQAA(AAHAģA=qAA(A\)A  AA  A\A
=A\A  AAQA(AAAGAAA33A=qApAA\AHAAffAAAARAApA\)AA(AAAAA  AQA\AQAHA
=AA{A33AHAHA\)AQA  ARAHA\AAGAAARA33AApA(AAAA\AApARAAAAAAAzAA
AAA33A\ApAAA(ARAffAHA\)AAQA\)AAQAA33AAHAAzAAQAA\)A=qAGApAAA=qA33A=qA
A  AHAAQA(A33A\AA{AzAA
AA  AA\AA\)AA33AARA=qA(AAAGARA33ApA
A\)AGAA
AHAARAffApA=qA=qAffAQApAA
A
A{A(ARAQAAGA{AAffA(ARARA
=AHA  AAA=qAAGA
AHA\)ApAA{AGAQAApA
A{A(A  A\AAAQAAQAApAAHApA(A  A{A
=AAARA=qAHApARAAA(AffAAzAQA=qA\AzAARAA  A\AA{AA  ARA\)AGA\AAAAGAHAffAAHAA\A(AAAAA\)AffAAAAAzAGAA
AzAA
AARA
=A{A
A
=A  ApAAzAAA
ApApAAA33A(A33A(AAA  AA(AHA33A  A
AQAA
AQAQAGAHAzA\AHApA=qAAHApA
A\)AzA33A(AzA
A=qAA\)A\)A\ApAAAA{AffAAHA=qApA{AAA
=AAGAzAHAAAARAGA
A33A
ApAA(A{A33AA\)AAAA  AA33A{AAAzAQA  A=qARA\AARAQAAHARA\AA33A  A{ApAGAAA=qA=qAAffA33ARARAA  AA  AApAAApApA=qA
=AAAAGA  AAA\A33A(AQAAGAA33AAA  A
=AAA=qA33A
=AA(AA
A\)AffAA\A
A
AA
=AA=qA\)AA{A=qAAApAffA  AHA\A\AAGA\AAAffA\)AzAQA\ARAGAQAGAHA=qAzAAzA
=AQAHAA33AGAA
=A
A
=A\)AAzAffA
=AAAAffAAHAffAAAA=qARAGApAAA  ARApAAGAffA(A\)A(AAARA=qA{ARAA33AA\)AAAAQAA\)ARAAA  ARAAAA\)A
AAA(AAQAAAAA(AQA\AA\ARAAQApApAAAGA\)AA
A  A{A  A{AA=qA(AHAQAA(A  AffA=qAAffA
AGA(A(ApAAA=qAAQAApA\ApAA  A\AAHAAAHA\AA=qAAA  AAQAAAAAAA=qARApAffA=qAHAAHAQApARAA(AA  ARAGA\AA=qAHARAffAHA=qA\AffA=qAAQAAAAA=qA{A\)AAGAApAAffA{ARAQAAGAApAHApARAffAzARAAAApA\)AGAAGAA
A{A33AA(AA  AffAQA(A=qARAARAQAAAA(AffAQA33AA\AA(AHA(A=qApA{A
=AGA\A\A
A=qAAA  A
A(A
A  A=qA\AffAAQA  A
=AHARARApAA(A=qARA\AHA\AAHAAAAARAzAA\AAAAA
A\)AAzA(A\A  A\)ApAQAGAQAAAffA
=AAAAGAAA\)A=qAffA=qA{AAAffApAA33AQA{AARA  AGA  AHAAA
A33AHApAGAA
=AAAffA{AAGAA
=AffA{AAAA=qAAA33A
AQA(A(AQA{AAAHAAAAAApAGA33AAHAAAAAQAA{A(AQAAAAzA
=A{A\)A33AAAAAAHAAAQAA
A33AA(A  AzAApAA33AAAA
AAQA\A\ARA\)ApAGAAQAzApAA{AQAffARAAA33ApAÅAzAA(A
=A\)A\)A33Aď\AzAA
=AGAîA
=A=qAAAÙAAGAAA
=A(AAA(AAARAQAA\AHAAzAAA(A
AzA
A{AGA\)A
A33ApA
=AzAAA\A
AHAHAzAAAHARA\AzAA(AHAQAAGA\)A\)AGAAzApAA\AAAAAAQA\)ApAAQA\A(A¸RA33A(A{A=qAffAď\A\)A
AzAƏ\AƏ\A  A33ApAHA\)AǙA  AîAA  A
=AGAA(AAAGAAGApA\A
A
AģAAAAA
=AAAHAAAAģAģAAĸRAGAĸRAzA33AQA33A\AQAHAA
=A\AQAAA
AAzAAAA
=A  A\A
=AAA(A
=AAffAQA\)A  A=qAzAzARAAQA{A\AQA33AAA(AAAA{A(A
AApA
=A33AAGAA
AAffA  AAAAGAA
=ApAAA  A
=AHARA
=AAAA{A\A
=AAA
ApA
=AQA\)AAAQA=qAzAAA(A  AAQAAQA
=AA{AAA  AA
AQAAffAAffARARA(A{AA=qAGAAffARAzA\AHAAA\AA{AGA{AA(A=qAAQAA\A(AAAAHAAHA{A\)AA(AApAAHAHA
=A
AA
=AA\ARAAffAAA\A(AAffAGA
=AAQAAA
=AAA\AARARAA\A(AQA{ApA\AA
A=qA33AARA
=ApAARAzA(AAffAA
ApAA
ARA
=AA=qAGApAApA{A
A  AffAApA33A  A
=AQAA\A(A  AHApApAAA
=A
AAAQAAA  AQAGAHAGA(AApAffA(AAAAAA
=AffAApAzA  AApAA\A=qAA  AAAA
ARAAAffAHA33AzA\ARAAA\ARA\AA(AA(ApAffA\)A\)A(A
A
=AAGA
AAAAAAAAAAA
=AAAA=qA  AA(AQAGA(AQAA(A  ARA
=AGA
AGAHAQA=qA33AGAAAGAApAAffAA33A33A{AzA{A33AAAffAA
A(AAARAAApAA{AHAA{A\AGAAGA  AffA\AGARAAffAAA(A\)ApAzAAA\A\)AAAA
AAAARA=qA  A33A
AA33AAQAA  A=qAGAA  AAA(AAAGA  A=qA{A{AHARA\)A(AAzA33AA\)AffAAQAAAAA  A  A{ApAAA=qAA33AQAQAApApA33AffAQA
AAA=qA\AzAHA=qAAAzApApAQAA(AffAzA\AzAARAA{AffA{ApA\ApAGA
A
=AHAARApA\A\)AA
=ApAGAQA
=AAAGA=qA=qAA33AAQAAGAHA
=A33ApA=qAAGAAA=qAAffA(A{AzA=qApAAQA\AAAAAAGA=qAA\A=qA{A33A\AAAA=qAzA  AAA  AAAA{AGA\AApA  AzAzAzAApA
AQA33AGA
ApApAA
AA  A(A  ApAffAAHA33A{AzA  A(A  AAAAAAA
ARA
=A33AAA\AAAAffAAffAffA\A{A{AAHA
AQAA(AAA=qAA\)A33AHAA
=AAAAHA=qA\ARAAzARAffA\)AAzA  AAAAzA=qA\AA\AA{A  AAA\)A33AA\AAA  A
=AAARAAGApAAAAAHA33A
A(AA=qARA33AAGA=qAApA(A\ApA{A\)ARA=qAAAGAffAffAzAA\AQA
A33AffAHAAAA\AzAARAQA  A(AHApAHAAȣAA33AffA
=A  A¸RAA
A\)A\)A\)AffA(A33AAA{A\)A=qA(AffApAHAAA
AAAA33ApA
A  A33AAAA
=AAA
AA\AAQA
AAAGA
A
AA(A\AGA\A(A33ARA\AGApAzAApAAAAzAAA\)AAARApAAAApAAA(AAQApARAffAA  A
=AA{AffAAď\A=qAîAîAÙAffA\AzAzA
ApAAGAA
A(AffAHA\)A{A£A{A
A{A¸RA£A\A(A
AQAQA(A  AAAGAHAAzAzA(AApAA\AAAA33A  A\A=qAAA\AQAApAAApAGA=qAAAHARA
=A
=AGAA(A
=ARAA(AAApA
=A  A(A\)A33AApApAAARA\)AA{A(AGA(AAA=qARAApA33A\AffAQA=qAAAAAA
ARA33ApAGAGAAAGA{ApA=qAARAffA{A\AAApAApA  AQAGAAA{A33AGAffAA
=AGA\)AA  AzAA
=AffA\)A33AAzAAHAGApAAAA  A(AA33AA
A  AQA
=AA33A\AQApAAGAHA\)AA  AA\)ARA
AAAA  AffARAGAApAffAA  A=qAA{AzAAQA
AA{ApAAAAGAHAA33AHApAzAA
=AA
=AAAAGA33A\)AQAffA  ARAApA(AGAA
AffA\)ApApA33AzAQAA
=AApA{AffAA33AQAHAARA(A\)A33AA33AAA
A
A
AAffAA
A=qAAGA33A
AGAQAA=qAGAA(A
A  AApAAAffA\AAffA  AAA(AAGApA
=A{A{AzAQA33A  A
AA{A\A
AApAAAApA33AAAGA
=AAAAHAAApAA(AA\)AffARAAAA  AA
=AA(AGApAHA{AA{ARA\A\A  A  AffA(AA=qAHA  AA(A{AHA(AHAGAffA33ApAAffAAzA{AAA{AQA\AAGAAA
A(AAApA
=A=qA
=ARA
=A(AHAAA
ApAffAAffA=qAAA=qA  A{A\A
=AAAARAHARAffAA(A
=A33AAA
=AAAAARA  AARAzAAAAGA
=AQA(AA=qAffAApA(AAAAGA=qAGAffA\)A
AAffAAGAARApA\)ARA\AAHAApAA=qA
A
=A\)A=qA=qAffAAAAAA(AAAAHAA\)AGA
=AA  AAA=qA  AzApA  AA\AA
A=qA  A
ApA(AffApAAAzAAGA\A\AA  A33A{AAzA(AA=qAAA  A=qAGAA  A33AffA\)AzAAQAAQA\)AAffAAAAAzA33A
AA
=A=qARA\AAHAA
=A(A{AQAQA\AA{AzAzAģAHAA
=AA33AŅAAA(AQA=qA=qAAŅAA
AGAAGAģAď\AA\)A
AAAA{A(AGA
=AffAA33A=qAAGAHAAQA\)A
=AAffAzA\)AGARAAAAA\ARAQA=qA{A{A(A
=A\A  AzAGAA
AAAGA=qAARApAA(AAA
A
=AzAzApA33AA33A(AAA=qApAA
AAAApAɅA33AAAffA
AzA\)A{AffApAGA
AAA
ARAA{A¸RA£AHAQAAQApAzAA33A=qAAA\)AffA(AHApApAGA(AA\)AGA  AAARAAAAAA33AA\A\AîApAA\A
=ApAAA
=AA(AAAƏ\AzAAGA33AffAHARA\)A(AAȣA=qAA
AzA(A
=A(AzAHAŅAƏ\AAȣAA{A(A  AA(AQA{A(A{A=qA33AɮAɮA33AAGApA\)A=qAA(A{AQApA(AǅA33AzA(AApAffAAîAApAģA\)AQAAGA\AQA  A33AA\)A\)A\)A£AA
A(AAHAHAA
=A33ARA(A\)A\AffAAAA{A(A{AA\)AHAAGAA\A=qARA\AARAAA\)AGAQA\AffAA
A  AA¸RAzA\A¸RA
=A¸RA(A(A
A
AGA=qAAHA{A
=AHAA  A\AģAQAA
=AQAHAAHAHARAAzAAAQApApA\)AAGA
=AAQAQAAAzAA
=AA
AAAQAA
AzAzA=qAzAA=qAGAGA\)AAAAffA
=A\)AzAApAA\)A{A
=A  AA\)AAAAffAA\AŮA
AQA  A
AHAAHAAAAď\AHAA=qAQA{AAA=qAď\A
AQA\A33AffA33AA=qA
AffAAHA=qAAA  AAHAAAA
ApAAA33AA33AAAffAHAARA  A33A  A
ARA=qAARA\)AA\)A\A=qAAAzA
AA\AAAA
AAGARAGAAAA(AAAGAzAAAffA
AA=qAGA\)ARAHAQAHAAffAQA\AffA{A\AAAAAffAA(A(AHA=qAAffAAAA\A
AzA  AGA
ApAQA(A{A\)A  AffARARAAA(A=qAQAA
=A33ARA\)ApA(A
=AA\)AA  AApA{A
=AffA(AAAAAAAAA  A=qA{AGA{A(A=qAA{A  AAHAAAAGAffAAAGAQA
=AQA\AApAAAffAGAAGAAffA
A  A\)ARAGA(AAAGA  AApAAAAzAAAGApAzAA\AApA
AA(ARARA(AAAffAAA(AQAGA=qAA
A\A
=A=qAA33AA(ARApAA
=AAQA(A  AHAAAAAAAAAARARA\A
A=qAA  AzA
A(AzAzA=qARAAARA\A{A{A33AA=qAHAAffAHA
=A\)AA  AffA\AAHA
=AA
=AA  AA
AA33AGAAA\A\A(AAAQA33A=qA(AAAAAzAzA{AA\AA{A
AGAzAA
=AzAA
A(A{AHAzA
=AAApA{AGA{AAA(AA  A\AffAAAA
=ApAAARAGAAAAAGA
AGA
=A(AA\)A  ARA  AA=qA=qAA33AAAA  AAQAA  ARA
AAA
AAffAA=qA=qAAzAAAAAAQAGAAA=qA\)AAAAAAA{AAARA{A=qAAA{A33A(AHAffAAAA(A  A
AGAAQApApA
=A
A
=AA
ApA
AAAAARAAQAzAA\AA  AQApA(AHA\)A\)AA
A  A
=AffA\)A
AApAAAA\)ApAAAHA¸RA£A£AHAffA
AAAAAAApA\)ARAA33AQAApApAGA\)A(AzAAffAA(AAQAGAA
AAHA\)A\AARA
=A33AAApAffApAffARAA
=AARAA(AQAQA=qAGA(AHA\AAAA
=AAAA
A\AAAAAA
=A\)A
=A  A  AGA
AA  A=qA\)AGA¸RA£A¸RA{AffApAA
=A\)A\)A\)AQAA  A\)AA
=A=qAGA=qA=qAHA\AffAA=qA\AHA33AAAzAA  A¸RA
=AARApA\AzAQAA33A{AA\AAAA\)A33A\)ApAffAAzAApA{AffA33A\)AAAHAffAA
=AA
A{AA{AHAAAAA\)AAA33A\)A{AAA  AApAGAARAHAHAA\)AGA{AAApAzA\A  AA\)AAGApA\)AHA{AA(A{A  A\Aď\AffAA  AzAA33A(A=qA  AA(A\)ApAAAÙAHAAzApAA(ARApAzAzA  AAA
AQAAHA(A33AHApApAQAApA
=AA33AApAQA\)AAAA
=AAAAAA
A
AApA
AA\)AQAA{A\A\AAAQAffAîAAA\AApAA  AAA\AQA=qAzAGAffAA=qAAAAQA33AHAAQA
AA\)AA\AA\A
=AAAHAAzA
AAffA33AAAAAAHAAAAAHA(AA{AGAHAAAA  AA=qA33ApAAAzAzA
AffAA(AA(AAGAA
A  A\)AAzA33ApARAAA
A  A=qApAffAA  A\AÅAAQAA{AAAAHA{AQApAffAffAffA  AƏ\A\)AAHA=qAÅAAQA
=A
=A  A=qAApA33A33AîA\)AAGApAA
AzApA\AA33AA\)AQA33A
A(AAffAA{AA(Aď\Aď\AHAAGAQAA  AA(AQA
=AHAAAzAAA\AA{ApA\A\A\A
=A
ARAAQA\)AAA  AAď\Aď\AřAQAģA33AAƏ\AGAǮA  A(Aȏ\A(A=qAAAAAHA\)AAffAAQAAAARAHAQApAAA(AffAAA\)A33ApAAA(A\A
A  A\)A
=A(AA{A{AAAƸRApA\)AAĸRA33AGAGA  AGAAAGApAA=qA{AzAHAAď\A\A{AHAɮAAŅA
=AGApAîA=qAGAHA
AGA  A
=AAffA{A  AîA(AA\)AA(AƣA33AAȣAGAA(AɮApA33ApA\)A
=AAzAA(AARAŅA  AǮAHAAȣA\)AffAAƏ\Aď\A{AA
AAAApAŮAAffAGAď\AffA(A\)ApAĸRAAď\AA
=AîAÅA\A(ApAGAAAAAQA
AģAA{AA=qAApAQA£AQAA{AHA  AAzA£AŮAÙAîA
AÙA(A
AÙApAA
=A\)AAQAƸRAzAAHA\)AǮA
A{A33ApA33A33AəAGAAffAǮAGAQA{AřAƏ\AǅAǅA  AǅAA\)AAAzA{AQAA(AA
=Aď\A(AA33ApAHA{AřAĸRAzAGAĸRA(A
=AAGAGAQA
AffA33AƸRAAA(AAGAAAAAA
AŅAƣA33AŮA
=A\)ApAffAƏ\AƏ\A{AHA
A(AȣAȸRAȸRAȸRAȏ\A(A{AffAAffAQAzA\)AˮA˙A{A(A=qAA
=AͅA\)AHA33ApA\)AͮA=qA͙ẠA˙AzAˮAA33AˮAʏ\AzAǅAHAAƣA
AAzA  Aď\A\)ApAA  A
AƏ\AAAQAGA
=AApAGAHAA£AHAffAAAA
=AGA33A  A(AzA
=A
AAAA(AAAAffA
=AA\)AAARAA=qA
A¸RAQAHApAîAÙA  Aď\AŮAAAǅA{A33AA
=AGAɅA
A  A(AffAzAQAʣAHAHA(ApA
=AȣAǙAAffAQA\)AʸRAʣAHA33AGAQA(AAȏ\AQA(AAA  AŅAAHApAffAAAQAAzA  A(AAAGA
A\)AA
=AGA
AA
=AŅApAȣAƣAAA¸RAÙAÙA\)A\)AAģA
=AA
=A  AA(AAAÅAA(AȸRAɮAʏ\AʸRAQA(AɮAGAAHA=qAʣAQA
=A\)AHAHẠAffẠA=qAHA\)ARAAA33A
=AHA=qAAɮApA33A
=AAȏ\A=qAǙApA\)A33AAƸRAƏ\AzA=qA{AŮApA33AAAģAffAffAA(AAAAQA{A33A(AzAA\AAAAA\A
=AzApAAAQAA33A
A
=A
AQA
A
=ApAA\AQAAGAzA=qA
A  AAffAffAAzA
A
AAAA33A\)AARA{AQA33A\ApAAA=qA(AzA=qA{A\)AAA33A
=A33AHAAA33AHAƸRAffA  AřAřAŅApAGAAAHAĸRAĸRAzAzA=qA{A(A{AÙAAÅAAAQAA\)ARAAA
=A  ARA=qAA33A(A(A  A33A(AARAAQAA(A33ApAAGAŮAHA=qAHAȣAȸRAA(A(AffA
=AffA=qApẠA͙AffAHAzA͙A̸RA\)Ȁ\AƏ\AGA
=AQAffA  A=qA
=A
AA  AA33AřAA=qA33AǙAGAAƏ\AA
=AHAƣAƸRAƣAzA(A  A
AŮApA\)AGA
=AHAAffAģA
AAQA
=A\)ApA\AGAA(AQAAAHApAffA
A  ARAAAAARA=qA  ARAAAA=qARAGApAAGA33A=qAffAGAAA
=AAřAAffA
=A  ApAʏ\AAzAA33A
AHAQAЏ\A  AîAA{ARAمAٮAAɮAQA\A\)AA=qAA  AGAΏ\AљA=qA\)AЏ\A{AхAA͙A(AQAA(A
AGAffAHA
Ȁ\A\)AŅA\)A
AQA  AAHA\)AծApAA˙AA  A=qAƸRAď\AA  AAAHAəAGAQAA\AծApAɮAffARAA{AHA(AGAA
ApAHAQAA  AƣAA(AծA=qA
=A=qAGAQẠAApAzAυAA
AA\)AQAGAffA33AffAأAA  AAAffAQA˙ApAͮAAӅAGA\)AAυA=qAA
AApAʸRA
AGAA
AAծAθRAGAAəA33A\)A33ApAۅA=qA
=AAڏ\AAڏ\AGAAAHAAA\)A33A\)A(AʸRA̸RAˮA
AƏ\A33AGAAGAA(A\)AHA  AAzAřAȸRAȸRA
A{AGAARAAAAAģA
AHAҏ\A\A
AA33AffA(A=qAɅApAAA=qAffAȸRA  AzApAHA\A(AHAA
A֣AA=qAA(AGA33ApAՙAAA=qA=qAϮAظRA
A33A
=AAffA  A33AGA=qẠA
=A˅A\)AA=qA  AָRAA\)A\)AAA
=A͙AAΣA{AՙAzAA=qAAHAAÙA33AAAGA\A
AGAAA
AA
AHAQAHAAARAA
=AzA(AЏ\A33A؏\A
AʣApAȸRAθRA׮AңAAA\)AͅAGAzAzAApAΏ\A{ẠAΣA{AẠA
=AљAA33AA  AAҸRAظRAAffAAͮAQAәAA\)A=qAHA=qAQAAzA
=A33Aҏ\AAAA33A{AřA
=Aԏ\A{A33AffAAHA
ApA=qȀ\AA  AǮAƸRA  AHAAA˅A{AиRAAffAffA33AυAQAQAffApAHA{AGAA
=A
=AzA
AQAzAAHAAޣAffAݮA
=A
AGA  ApAA
AиRAGA
=AA(A
AffA(A  AAAA؏\A؏\A(AA  AGAQAAQA33A33A  A\)AAQA{AۅA  AffA  A\)A\)AAAzA
=AޣAzAzAA{A=qAAffAffAͅA33A\)A  AQAɮAffA\)ApA(ApAHA\)AA=qA=qAřA(AGAAffAǮAffA{AGAA¸RAˮAQAzAHA؏\AA33ARAApAA
AۮAzA(AA(A{A=qA
=AA\)AA33A  AAAGARAAAAApAAڣAA  AzApAAAٮA
AA\)AAA{AߙA(A
=A33AQA癚A=qAA(A\AA=qAARA
=A=qAAAAHAQAffA
=AA
=AQAAAQA(ApA(A{AQAffA\)ApAȣAA=qAڏ\AA(A=qARAAQAA
=ApA(AQApAGA\A\ApAAHAQAAApAzAHAQAQAAAAAApApAzAAARAA=qA
AAAA噚A߮A{AffA=qA\AQAA߮AޣA=qAA܏\AمAHAיA(AA33A(AQAzA߮AzA
=AA{AAAA{A=qAHA{A{AمAңAzAAGA  Ȁ\AAAffA
=AQA(AAЏ\A  A{AAAzAQA33A(A(A(AAA{A\ApA
=AQAA=qA{AAA(A33A\)A\ARAAffApA{AffAA\)A  A{AAzAARA(AA  A\A33AGAQAGAAߙA\AAAA
=A(AQARA\AA=qAA33AA(AA
ApAAGAA
A  AA
ARA
A33AAHAAzAzAApA(AA(AݮA(AGAAffA\)AޣApAۮA{A  A
AݮAA\)AQA\)AAAGA{A\)AA
=AGAA{A=qA  AffAAAGA=qAA\A뙚ARAA\)AGAffA(AffA(A(A\)AGAffA  A
=AAAA33A{AzAAzA(AzAA  A  AGAAAAAAA(ApARA\)AffAA\)AA  AAHA(AAA\AQAGAAffA
AGA=qA=qA(AAARAzA=qA癚ARA  AA33A(ApAיAׅA
AיA{AffAיAA\)AffAARA  AA\AAA{A
=AzAHA
=AA
=AHA(ARA
=AQAAHAAAAAAA(AA(AA\AA(A
=AAA{AA  ApA(A噚A\A(A33A\)AAAAAGA  A\)A뙚A{AQAARA=qAA뙚AApA33AA33AA33AQA\A\)AzAA33AA33AHA\)AA(A
AݮAffA
=AzAA{AffAۮA
=A(AffAAHAA  AAGAAAGAA{A홚A{AARAGAA33ApAGAAAQAAA33AA33AAQAAAA\A\)ApAApA뙚A\)AzA\AA\)A(A  AAA{AffAffA\)AA癚AAGApAQAGA{ARAAAA(AA\)A=qA\)A뙚A  AAHAظRA
=A\)A\)AᙚApAQAffA33AQA33AAA(AQA
=A{A(AA33ARAA33AzA33A\)AA
=A(A
=AffAQAAAAAARAAGA\A\)ARAffAARA{AA(AHA\)A(AAHAGAGA(A\A\AAAffA{AffAA\AA33AHAQAGAݮAAA{A\)A  AAffA  AHAA  AA33AAA33AA\AQA  A
=AAAzAARARAAGAGAA33AHAA
=A\AHA=qAzAffARA=qA
=A{A  AA  A{A\AAAAA33ApAffAA  AAA\)AA  AAzAGAQAzA\AQA\)AQAAzAAAAAAAHAAGA
=AAAAApA
ApA
=AAA33AGAzAAAffAQAAAAAAAA
AAffAApARAGA{AAA\)A
=A
=A\)AיA  AHA׮A33ApAQAۮAۙAAܣAAA  A噚A߅AAzA\AAA=qA\)AA
A(ApA
=AAA(A
=A33A
=ARAAA{AA  A\)A{A=qAHA33A\A\)AA  AzAA
AGA\)A(AGAAGA=qAffA  A33AGAARAAHAAffAGA
A
=A{A  AHAA
=AA
AA(AAAA
A\)ApA33A=qAffAA
=ARAAAHA
AHAzAAA33A
=AAAAA\AQA=qAA\)AAffAA33AGAQA=qAHA  AAGAQAffA33AAQAA\)A
ARAAA=qAGA  AA  A  ARAzA33A=qA
A\ApA\A(AHAAHA33A\)AA\)AAA=qA{AzAApA{AQA{A(AAAHA33AA\)AGAAHAzARA\)A  ApA{AA  A
AAGA=qAzA33AA\)A33A{A
AۙA{AڸRAApAA{A癚A
=A33A{AAzAAA\AA(A\AffA33AAA
=AA
AGAHAHAffAGAARA(AA
AzAAAA{AA(AARAffA
A{A{A=qAHA
=A{AzAAAGAffAHAAHAffAA33A\A33AAQAA
AAAzAAA
=ARAA=qAHAA=qA
=AzAAA
AzA
=A܏\A=qAיAA؏\Aڏ\AQAQA{AApAAAA=qA(AAAA
=ARA\)A\AQARA=qA\)A  AzAA(A\AAA\)A(A\ARA
=AAA噚A(AAAApAA
A
A=qApA\ARAAffAzA\A=qAHAffApAAAHAA
AAAA{A  AzA
=AAA
=A{AQA  A\AAffAAAAzAHA(A
A\AA陚AAA\)AffA{A{A33ApA(AAzA(AAAA(A
AAffA{AAQAAQAAffA\A\)A\A
A\)AAAAA=qAzAAARA\AARAQAHA
A
AzAHAAAHAGAQAA33ApAARA{ARAARA\)AQAHAA=qA(AA\A  A33AHA
AAAA
AzA
A
=AA  AA  A(A(AA홚AQAAzAAGARAA{A=qA\)A\AAA  A߮A=qAAظRAGA׮Aڏ\A=qAApA
=ApAA\)AApAGA{AApAA
=A  ARAA  AA\AGAAzAA홚AHA(A  AAAA=qAzA=qA  AAA33A߅AGAHARA
A33ApAA
AffAAA뙚AA=qAHAGAffAQA
AHAA33AGAzARAffAffAQA=qARAA33AA뙚A(AAzA\)A
=A޸RAҏ\A33AQA=qAzA  A33AأApA\AGAڸRA
=AA{A\)AQAۙA33AAٙAQA\)A(AܸRAAA߮AffApA㙚AAA\)AAzA{AHA33AAA=qAffAHAA(A
AHAGA(ApAA
A\AHApAHAܣAffAzAAA(AQA
AA=qAQA{AAAAAffA{A{A=qARAA33A\)AffAHAzAA\)AGARAAGAHA\)A(AA33A33AA{A  AHA
AAA{A{AGAAGA\A=qA陚A33AܣAAGA33AљA=qA뙚A33A\)AffAHAA
AA{A{AQApAGAA޸RAAAAzA㙚AA{AARA=qApA\AzAQAA܏\AAGA{AzA(A
=A
AzA33A
=A=qA  AAA
A{A
=A(AAA{A{A33A{ApARAAAݙApA
AA߮AAAffA
=A{AٙAӮAՙAأAffAܣA33A=qAθRAԏ\AdzAУA33ApA\AAAAQA
AA\AA
=AzA33AHAۙAۅAۮAޏ\AGAޣAHA\)AܣA߅AzAAHA=qAA  AᙚA=qA  ARAA(A33AGAAأA\)A33AA
=AA
AA(A33AܸRA݅A\)AAߙA
=ARA\)AA=qAAA  A33A=qA=qARARA  A{AݙA33AA\)AݙAAA\A{A\)AQAۮAzAHA  ApAA=qA
AzA  A(A֏\A33AHA(A
=AÅAAAAAɮAAǙAAŮAHA(AAAAHA{A=qA
A  A͙Aҏ\AָRA\)AיA=qA=qAA\AQAA\)A޸RAGAᙚAAAA
AQA{A=qA33AQAAAGA33AۮA
AQAzA
=AzAAzA  AAA  AffAڏ\A\)AA(AGAAAQAApA
=AA
=AAAQAHA\AzA\AGAAGAQA=qAAڏ\A\)AՙAzA֣A=qAzAAՅAՙAәAיA(ApAԏ\AݙA\)AمA{AՅA(A  AA=qARAAHAAAffAݮA=qAAHAARAA33A=qAHARA=qAܣAAߙA
=AA
=A=qAAzAAA  A\)AAAA癚AzAzAAQA=qA33AAQA\A뙚AffAA\)AAffAAAA\AffA
AAA(A\AAA
AAApA
AffAA33AffAA\A
AQA33A\)ARAAApA(AIAAAffA=qA\)AHAܸRARAARAAHA=qA홚A33A\)ApAAAAzAAAAApApA  AAzAAQAQAA=qAAA(AGA
A
=AQApA=qAAffA\A
AAHA  AzARAQAAA
AA  AAAA{AAAHAA{AA=qApAsAA\APQA`(AQGAG
A@QAGAH  A:\ADA?
AW\)AsAgAUAG33ALQA8  A=pA3\)A5A0QA'33A#A%@
A%A!A=q@{A (A zAAA+33A8(A9pA'A;
=AD  AaGALALQA:RA;
=A4  A0A5A@AMAO\)AVRAc
=A_Av{A(AiGAo33Av{AsAt  AzHAx  A~HAGA\)A=qAxAxAypAv\AA
=AzA
=AAz{ApAPQA^HAEAgAB=qAO33AKAFffAB\AB\A%A*=qA&\A  A!A\)A33AffA'
A)A$(A zAA{AA
AQA33AQAz@zA A	GAffA{@  A{A;
A@GAzA,A2HA6ffA3A&HA(A#AGA$A2{AAA_
AN{Al  AeAA
A
A}A
=As
=AoA(A}AA\)AAA|A=qAQAARARAAHAA
AA=qAffAHA{AARAAGAA  AAQA\)A=qAAA  A=qA\)Ao
=AuAAmAp(AA{AoAtzAuAGAhzA
=A  A(AAAAzA  A
=AAtQA=qAvHAHA~RAAHARARA
=A
=A=qA33A\)AzA{ARA=qAAAAffAAqAw
=Ao\)AupAyGAuA}Ac33AApAQA{\)AA^ffA~{Al(AAHA{Az\Aw\)AARAzAA\AGA{AGAffA
=AAARA  AA
A  AA\)AQAA\A  A\AA{AA33ApA\AA
=AA=qA33ARAHA33AA\)AAA
=AHAHA{AARAAAupApAGA=qA
A
=AffA(AHA  AAAA{AA\A\A
=AxAyAAzA\AzA=qA=qAARAAAAffA\A\A=qAAA
=AffA
A33AAAzAA\)AffA
A
AAƣAAAAAHApAQAAAffAAAzAARA
A
AAHA=qAAGA{A=qA
=AApAffAzAAHAffAffAzAHAARA{AAA\)ApAA  AA=qAAǙA  A33A
AQA\)A
A£ApA(A\)AÙAA
=AAHAAAAA
A\)AAA  A
=ApAAAA
A\A\A(AffA\)AǅA
=AHAAGAAAA{A
=ApAHAQAAA{AARA  A
AŅA\)A\)A
=A
=AA33AzAAAAA\AAA
A\ARAQA{AA  AA\AAAAAHAAzA
A
=AGAA{A33AzAA\)ARAHAAA{AAAHA=qA\)AA{AA=qAA=qAAffAzA\A{ARAA
=AA(AzAA33A\A(AAA{AAAGARA\A
=AA
=AQAAAAA  AAAzAAGARA=qAzA
AA\A
=AQA(AHA=qA\A=qA=qAGA
=A  AAA\)A
=A  AQAAHAQAApAAA  AمAA{AQA
AffAA33AzA{AAAAffAA(A33A
=A\)AAHAAzAA
=AzApARAApA  AQA{ApAA=qA
A
=AQAHA\AAA
=AzAQAQA=qAA(A  AA\)AǙA
=A\)A\)A(A=qAffAA
A(AAHAAGAAʏ\AQAApAəAffAAffAffA{AģAA(A
=AAGAÅAA(A  AAQAffA(A̸RAAʣAՙAffAAәA33AAAHAʏ\AA  ApAA{AzA\)A\)AA  A
=A{AGA
AAAzAAHAAA\)A\AAQA=qAGA  AGAA\)A(ApAffA
A=qA
=A{AHAGApA\)A׮AمA
=AAۮAAAAHAAHA=qAAٙApA\)A=qAأA؏\AzAffAzA(AGAAAGAٮAA{Aڏ\AGAA
=AAA33AA  AHAA(AAzA33AAA=#
AәA33AۅA\)AظRA\)AAQAHA
AzAٮA\)AApA(AAA̸RA33AݙA  AݮA
AA߅A=qA=qAQAzApA\A\)A{AA\)AHAA=qAffAAGARAzApA
AAA\A\AAQA
A  AAAA\)AAAAQAAGAAzAAGA
AA33AGA癚A
=A
=AAQAAAGA
=A
AApAARAffA
AzA\)AܣA33AA\)AAzA\)A\)AzA\)AA  AApA
AHA
=ARAAA(AAGAAA
AApApA(AAA  AAApAA홚A\AAQAAA\)A=qA  A噚A
=AffAAA=qAAAQA\)AAffAHA
AAծAzA\)AՙA
AܸRA
=AA߅ARA㙚AA  A\AA߅AffAffAA
=A{AԸRA(AAzAzA\)AA
=ApA݅A=qA\)AA\AGARApA\A(AAAA33A홚ARA
AA(A{AHAffA\AA{AA  AQAzAQA33AGA=qAHAυApAzAˮẠAAAʸRA\A
A33A  AGARApAA
ApAAHA̸RA33AمAApAͅAÅA\)AיA؏\AAzA  A
AGAAAA=qAAAAAAAHAApAA(A{AAHAA{ApAԣA  ARA(A߮ApARA
AA㙚A뙚AAAظRA׮AA\)AA  AzAzAHAՅAȀ\AAHA=qA{Aҏ\ApAHAApAٮAAAHAAQAAA33A=qAGAʸRAHAzAϙAAϮA\)A33A
AӅA33AAᙚAA܏\A\)A\)A{AzAGAzAQA  A=qAۅAڏ\AA=qAffAffAAA(A߮AAA=qA{AffAffAffA=qA
=AAңAծA=qAzAA
A陚AA
=AApAGAQAffAHAGAA܏\ApAHA  A߮A(A  AٙAzAHA
A=qAAظRA  A(A̸RAȸRAǮA  Aȏ\A  AͮA(AAHA  AAzA׮ApAՙAљAQA
AA܏\AAָRAӮAGA
=A33A
AӮAAAAApAA߮AffAAzAHA
AAQA\AAGAA  A{AGA  AGAQAA  A{AڸRA؏\A33A
A܏\AAAGAA(A(AܣA{A
=AA33ApAzAAApA{AA
=ARAffAffA(AAAHA(A
=ApAAAAAA{A\AᙚAA噚AA(AAQAAAAAA33A(ApAA
=ApA݅AA߅A33A  AQAQA
=ApAޏ\ApAffAA(AAAAzAA  A癚AA{A(AA\)ARAA{AQA\)A{AzAARARAA
=A
=AݮA=qAffAGA33AHA\)AQAA  AAA33AffAAAAA\)A33AffA陚ARA=qAffAHA  A{ApA33AzA(AA  A
A\)AәA\)A{A=qAGA֏\ApAՅA(AA\)AָRAיAQAA؏\AApA
=A
=AzAأA{AQAzAAGA
=AAAAA{A33AAA(AA  AAffARApA=qAۅA޸RA\AA
=ARAA
AA
AA{AQAAA(A(AAQAGA  AA
=AffA\)AGAzA\)A{ApAzAzAffAQA\)AAӅA
=AGAۮAQApAffAA(A(A
A=qAQAͅA
=AAθRAffAAAиRAϮA(AAAԣAGApApA=qAGAA=qA\)AծA
A(A(A(AAẠAGAGAAGAA\A  AAƣApAÅA\)A\AHAA\A£A33A
AHAřAA{AGA33AAA
=A(A(AAffA{A\AGAA\)AQAffAA
ARAGAffA
A33AzA33AHAҏ\AffApAffAzAffAGApApAApAA=qA
AǅAA
AAAAAǅAzAƣẠA
A
AAAGAA̸RA(AAˮAŅAGA(AAzAARA
=AAzAAHAA(AAAAAA  A
AzA  AffAzAυAzA  A=qAȏ\AƣA{AHAGA
=AәAGA֣AׅA{AיAAGAffA
A(AHAͮA(ApA{A=qA˙Aʏ\A(AAAAԸRAѮA  A  AƣAzAQAAAAظRAAͮA{AAAҸRAՙA33AУAffAApAָRAHAѮAAQAȣAQA
AՙA\)A33A
=AљAGA\)A=qA¸RAA
=A  AffA\AARAzAAHAAAAApAأAGA
AAffA(A(A
A(A(AAA
=AHAAٙAׅAAARA=qA33AA(AA33AAٙAA
A(AHA33A33AޣAQA
AAAQARApApARAQA=qAԸRAۅAQAffA\)AzAAHA=qA
AzA  AᙚAA=qAHAʣAQAAƏ\AzAυAAQAʸRAAffAθRAGAzAљA(AAՙA{A
AzAffA33A
=AzApA  AGAHAڣAAQAAޣAAA
=AAGAAAQApAAAAA\)A
A=qAݮAܣA߅AAQA(AzA33A(AGA  A\)AAAGAffAܸRARA݅AAAzAA
=AA
ApA(AA{AܣAAAAA  AAHAGApA  AffA=qAApAzA=qAQApA\)A33A=qA(AA噚AQA噚AᙚAQAڸRAڣA
AffA{A=qAA
A(AҸRAԸRAQAHApAAA
=ApARA\)AAzApA{A
=AA׮AGAzA  AAGA{AzAffAHApAAzAQA=qAޣAQA߮AAA33AAA(AffAAA
AGAffA\)AzA㙚A
=AffA\)AGApAAzAAzA  A\AA=qAAAQA\)AQAffA{AQAA{A  AQAQApAAAHA\)A  AڣAQAHARAAAAAGAQAQA=qAA  A
=A=qA33A
AA=qApAQAQA=qA(A\AA\A\A\)A噚A(A  AA\ApAA=qARAzA
=AAAzA33AAQA  AAAAA  A\)AffAffARApAGAffA\)AzAA{AAARAHAffApAAAA{AzAAzAAA{A  AAARAA
=AAQA(AQAHA\ApAHA
=AAGAApA{AHA\A=qAffA\ARA=qA  A陚A\)A=qAzAA\)AA33A{A\AAHA(A\)AAA
=AA33AAAA\)A\)ApAHARAHARAAAQA\ApA33AAzAA
AzApA=qAAA33AAA=qA=qA{AffApAHA  AffAA\)A
=A=qAA\)A{A\AAA\)AAffAzA
A(ApAA\A(AA
=A=qAޏ\AzA噚A{AAQA33AAGAۅAٮAQAAHAAAڣAQAݮAQAٙAHA=qAܣApA(A\AA=qAGAA33A{A33AAffApA\AAQAQAHAAAA  A(A
A{AA\AffAAzAAAGAGAAAQAAAGAA
=AAHAAQA(A  AffApAA\A  A\ApAAA홚A߮AA
=AffA홚AARA\)AHAffA홚A
=ARA\)A(ApA{A  A=qAߙA߅A=qApA{AՅA(A
A
=AծA֏\A
=AzAمAAA=qA(ApA  AՙA
=A33AׅA=qA
A޸RA33A
ApA\A=qA33AA=qAAGA\)ARAAAA=qApA\AApAAAAA=qAA{AA{AA
=AHA  A\)A܏\A
AAAAAAA  AQAAQAA
=A  A{A33AApAzAzApAGAffA
A뙚A\)AA\)A
=AA\)AzAңAQAHAA33A\)AAAAɅAzAA{AAA=qAQAͅAԸRA\)AGAffAA{AzAAA
AzAHA33A
=ARAAA  A
=AAQAޏ\AAzAGA\AA
=A\)A  A
=AA33A=qAHA
=A
=AA=qA\)A\)AHA\A
A=qAAAA(A  A{A{AA(A(A  AQA
=AQAQA
AA(A\)A33A\A  AffAA=qAAA
=AffAzAHAA  AAffA33AۙA܏\AݮAffA=qAHA߅AAA\)A߅ApAޏ\AA
=A߅A癚AARAHAAA
AAzAQA\)ApA(ARA=qA{A{AQA\A\)AAQAzAAzA  ARA\AGAAGA\A=qAAzAA\AzAQA{AAA
=A  A=qAAA  AQA\A\AA=qAffAzA(AAzAA\)A
=A\AAA{A=qApAQA33A  AA=qAAA  AGA뙚Aڏ\A  A(A噚AA\)A
A£AA
Aȏ\AAAzAAڸRA
=A
=AϮA
AAQA(A
=AffAA
=AA
A33AffA\)A
AA{A  A(A33AHApA(AQAAA(AA\AAA
AA\)AApAAA
=AGAAHA{AAQAGARA=qAAQAffAQApAAQAzApAA陚A뙚AA{AQA噚A\)A
AAAzAAA(AA\AA{A
=AA
AGAAQAQAGAzAٮAAڏ\AffA
AAA{AۅA\)A\)AAظRAAQAAA\A
AAAGAAA\)AApAAAAAA33A33AHA  AAA{AAAzAAAAٙAffAޏ\A33AۅAAݙAzAA=qApAљAARA\)A؏\AQAffA(ApAAGAAۅAApAHAAHAffA  A\AAߙA
ARApA
AffAA
A߅AA\)Aԏ\AAHAAHA
AA
=AǙARARA\)A33AģA=qAAzAzApApAʏ\AA  A(AϙA=qA
AAۙA
=ARA  AApAAAzAQAzAA  AAA
AffAA  A  AAޣAݙAApAAQA݅AQAHA܏\A
=AAՙAΣA33A  A
Aԏ\A{A{AHAޣA\)A
=AAAA  A33AHAAAffA\AHAGAffA߅A(A(AAAAA߮A\)AٮAGAAGAA
AQApAGAGAظRAٙA
A
AѮAA
AzAA
A  A{A
=AA33AAARA
=AݙA߅AQAGA=qA(ARAQAHAGAAGA{AAQAA
=A\)A  AzAGA{AffAHAAAQA֏\A(A  A׮AAzAGA֣A(A(ApAzAA
A\)AA\)AHA(A33AGA(AffA33A\)AHA=qAҏ\AAffA33A\)A
=A
AzAffARA\)ApA
=AAAAQAA=qAA
=AAAQA  AԸRAӅA(AApARA(AAAA
ApA(AA\A33AA{AˮA  A
=ApA=qAzA܏\A  AϮA  A\)A{A˙AzAzAA=qAAA  ARAÅA{A(A
A{AGA
=A=qAAHAAԏ\AzAA=qApAAAAA
=A{AzAHAУAQAA33A\A
ApAAAA\)A\)ARARAθRA  A(A(ApAA(A{AAHApAA{A¸RAzApAA{ARẠAA˅ApA̸RA=qA\)A33AffA(AϮA
A(AAHA\)AɮA
=AHAAGAӮAңA=qA=qAAGA(A  AHAәAЏ\ApAď\A(A(AˮAәAȸRA  AAAHApApA=qA33A(A33A  AQA֏\AAA  A33A
A(AA(AffAffA߮ApAffAA
AՅA\AAA݅AA
=AA
=AڣAAA=qA
=AיAأAٙAHApA  AQA  A\)A
=AۙAٮAٙA{AљAٙAQAڏ\AHAA
Aڏ\AzA(A\)A(AݙARAA  AAߙAأAA(AAzAԣA(A֏\AхApAAʸRAGAA\)A͙A{AAHAGAHA=qAĸRAƸRA
AffAA\)AA\AA33AA(A  AA33AAHA\A\)ARA33AHAzAAAffAApApAAAљAHAGA33A\A
=A{AGA\)ARA
A{A
AzAA{A
AAffAA
=ApA(A{AApA33A  AAAAAA{AAQGAkAR\A0QAbffAP(A]AV\AMA6\Ao\)Ao
AtAAAAk
=AXQAQGA>HAFRA:\AGAN{AZRA>\AAAJHA]AgAeAhAKABffAHQAUAf{AmA|A|A=qAffA\)ApAUAHA\AD(ADABRAQA{\)AzAAQAQAzAA{A
=AzAHA(A|zA|(AAARARA(A
AAGA(Ax  Aw\)A}AoAk
=AVHAQpAk33Ab=qA@QA;A[\)A<AhQARAA\)A{A  ApA
=AA{A{Ao
=AiAeApQAc33A=AEpA2\A(A.HA.ffA"HAAz@\@ff@=q@{@H@q@
=@A=qA  AffA@G@G@HAffAQA
AA{A/A,(AAAEGAHzA_33AMAIGAMGA@AHA?33A>RA!@A&ffAHA\)A&=qA
AA2{A8A+AA\A#
=AGA@  @@ff@{@H@Å@@@Q@@Q@Q@@H@ۅ@z@p@@\@@{@@ə@@\)@H@
@=q@(@Ӆ@{@Q@z@A
ffA#
@@\@@33A=q@@ff@A\@
AAff@@ٙAHA	p@
@z@Q@@=qApA33A\AA6HA
=A\)A@  @
=@H@{AA$QAz@AAARA2ffAEAGA@ALQAEA;\)AO
=A9AHAALA_ARffAuAt  AF\A?33AZ\A9A,AHzA;AL(A3AuAJffA^HAMpA>\AB\ALzA_33AS\)AL(AKA-pAXA,AffAAAAAA0QA=GA1A9A+
=A4  ARAQADAUAPzA:{A<AO\)A?AO
=AS
=A/
A2RA_33AVffAs
AxAs
=A=qAn{AlAqApQAqAxzAffA(AQAA{AAQAGA
AA=qA(A
=A
AHAHAA{AAAA  A
AAA33A33AQAA(A=qAAA\AA  A~RAwAd(AkAcAp(AF{ARffAO\)AmA
=Ac33Ad(AfRAL(AR{A\zA\A\QA\zAUAFRA`zA>{AMA?33A?AD(AKAz=qAS
AYABRAJ=qAC\)ATzAf{AqA{
ApAA33AA
A  AzApzAA{A(AAAA{AGAQAHAAA(A\)AAApA(AAHAA\)AHAAAffA
=AHA
=A33A{A(AA\AAA
=A(AA
AQAA  A{A~\A(A=qAAA=qAA(AA{AApA(AffAAGAAAwAA{
=AQAA|  A|AzAGA{A}A\AAAGA=qA\)AHAAAA33AA(A{ApAA(A  AGAAAzA
=A33A
=A(A  AAGAAAA(AAAffAA(AHA  A(A=qAAGA\)A
A{AAGA(A
=AHA\)A=qAA{A\)AffA
=AA(AυAHA=qA=qA\)A33A33AAAHA(A
A\A
AQAAzA(AAǅAzAAĸRA33A
=AffAApA
=ARA\ApA  A=qA(AffAA\AAAAA  A  A\AA
AAǙAzAǮAAA{AGAGA33A֏\A  AA(A
AA֣A(A֏\AA\)AzAУA  AA(AAиRAA
=A{AzA\)Aҏ\AzA{AݙA33AAGAיAAGAAᙚA{ẠAGAׅAHA
=A߮A
AGAAɮA  AffAΏ\AA
=A\AɮAԏ\AǙAȏ\A  A{A\)AӅA{A݅AAARAظRAQAA\)AظRAAGA33AffAffAQAARAA33A
=AAQARARAA{AAGAA
=AzA{AڸRAHA33A33AA{AffA  A֏\A؏\AzA
AAʸRAĸRA33AHAApAA
A\A
=AAzAAHA  AzAQA(A  A\)AffA
AAA  AAQAʣA\)AHAQA\AA33ApA33AAffA=qA
=AÙA=qA  ApAA  AAHApAA33AQAAQAQARA{ARA33AHAffA\)AffApAffA
=AAzAGAϙA\)A˙AA؏\AڸRAHA  AffA
AA\)A
=AQAGAAA  AAAQAARAffAffAzA33AA(AAQAGAffAA
=AA\A
=AA(A\A{AAffAA
=AAAARAAHAAHA=qAAAAQApA\)AAffAA  AHAffAA33AA
A  AA(AAAA  ApAA\AA
=AA\)AGApAAffAHA|QAA
A
AA{ARA  A`  AS
=AJRAP(AB=qAJ\A@A7
=A;
A4A9GA'\)A;
=A2=qA#
A1pAA
=AA\A
pA  A@\)A(AA
A\)AzA{A
{AA33A=qAzA
AzAffAHA A'
=A0A+AA%pA&RA#\)A%AQA/A4(A,(AFHA>ffA.RAdzAMA^{AdQAN{A]pAo
AupAo
AkA{AdzA_As
=ApQAuGAr\AiAV=qAXzAL(AepAL  A*RAEAT  APAMA@A5A*HA?Ak\)AzASAC33AYAS
AKAHA\)A$A?
=A6\A,A:RA%A1pA@ATzA\)AC\)AG
=AUAdA`AgA;
AS
A\AaGAsAupA}GAAA  AAAA{ARAA
ApAAAHA=qAAQAApA33AHA33AAA
=A\AA(AHARA  AA33AzAffAǅA£AA33AAQA(A{A(AȸRAθRAHApAzApAzA(AA=qAƣA=qA
AffAGAAQA33A{AAA\AϙAʣAҏ\A
AffA33AAхA33AzAGAA£AHAAAA  AAAϮAffApAzAA(A֏\AAԸRAHA{AAzAA(A{AǅAAGAGA  A\AffAGAApAzAHAA
Aȏ\AAAΣAAAΣA
=A{A
=A=qAAQA{A(AA  A
AAAHA(A
=AHAAŮA=qAHAȏ\AẠAљAHAAQAA33AȣA
=AAA=qA(A¸RAAffAQAA(AAA\)AAQAApA{AܣAՅA֏\A33AQA
=AΣA(AzApAzAA33A{A  A(AHA33ApA33AQApAGAzA33AA\)AиRA
AA{AffA{AAffAQAA{A33AA{AݙAA׮A{AffA
=AAAAẠAQAŅAAϙAQA\A\)A
A
=AÅA{AGAApA33A\)AŅA̸RAA=qA(A=qAARApAAܸRAGAA{A\AAQAHAģAAAA  AAƣAθRAAǙAAAHA=qA{A޸RAGAffAA=qAAApA
=AQAQA=qA=qAŅAAʸRAǅApA
AQA33AAHAApA=qAA(AHAAA\A33A\)AAAAA
=AAzAAffA(AAQAAHA
A
=AAA=qAA=qAAA
ApA{AA\AGA{ApAAAAAA
=AAAAA  A{A=qAAApApAAHA  AGAQAΏ\A(AAQAffA\)ApA֏\AHA
A33AAָRA  AAQAAHAffAîAzAڣApAzAхAffAޣAA  AHA(AAffA
=AָRA  AîAAΏ\A(A(A{AA{A  AQAAAᙚAAGA  A  A
AQA܏\A
A=qA33AAA\)A(AܸRA{AQAffA
ARAApA=qAffAAAمAGA֣AAGApAՅAڸRAffA  AHAAA33AAA=qAffAHA(A\AGA  AHAQAAAڸRAQAљA֏\AиRA(Aޏ\A\)AAAA33A\)A33A  AA33AAAA
AzARARAA癚ARA33AAffAzA\A
=ApA
=A(A
=AAAQA  AQAQApARARA
=AA(AAA33AA(AAޏ\AGAA33AAA{AA
=A(AA\)A(AQA\)A(AՙAA  AzAQAAAڸRA=qA\)A㙚A{A=qAиRAzARA33AٮA33AۮA{AAۙAᙚAApAApAAمA=qAA\AۙA޸RAGA  AAzAQA\)AQAA
A
=A߅A(AAA(AAQAA  A=qA=qA{A\ARAzAA  AأA33ApA
AٙAܸRAٙAAܣAA
=AQA=qA˅A
=AQAAzAϮA33AљAУAQAApAď\AA  AGAA{AA
A\AAGAQAAAA
=A(A33Aȏ\AՅAHApAܸRAzAA
A
=A  AAA
=AffAAA(A\AA\)A
AԸRAљAQAzAݮAхAθRAAԏ\AAծA˅A
=AGAHA(A=qA=qA  AAffAAApAAffAA=qAAAAQApAAAApAApARAAAAApAAAARARAAQA\A(AffAGA\)A{A{AA  A\)ARApAAAQAƏ\AA
AffApAAAAGAHAAAHAApAAAQA
=AA33AAHAA\)AAA=qAQA
AA\A
=AHAAQAHA(AAQA\ARAA{AA(AA=qAȸRAHA
=AA=qAϮAAAA
=AAAA\A  AAՙAA33AA  A
=AQA  A(AzApA  AA=qAAÙAA
A33AGAA\AzApAAA
AĸRAzA(A{AQAAffAиRAхA=qARAƣA
AAͮAHAƣAQA(AƣAAҏ\AΏ\A͙A{AîAǮAЏ\AApAApA{AA\)A
=ApAA\)A\)A33A
A(AHA\)AA\)AA(AHAAΣAA\)AָRApA  AzAGA\AA=qAAAAA\A
ApA\ApA
=ARAffA33AA{A  AffA{AA=qA
A\)AAA  ApARAA
AffAA=qA(AQAGAA\)A=qAGAGAHAA
=AAHAA\)A{AA\AGAzA33AHAGAAARA33AzAAHAAAAA{AAGAffA
AzAA33A  AA{ApAARAAA  A
=A(AǮA\)A(ApA33AŅAQAA
AffA
=A
AffApApAϙA\)ApA
=AיAΣAAHApA(AAAA=qA{AAAA  ApA{A=qA=qAGA(AA(AA(AAA=qA  AA33AAGAffAA
AGA\ARA\AQA(AAA\)AAffAffAA\A\AzAzA(AAQAAAAA=qAAA\A\)AAffA=qA(AAA  AffA{A=qAAGAAHAQAHA(AAzAHARAŅA{A
=A33AAQA(AA  AA(ARAAzAA  AffAAAARA  AffAzA\AffA{AAAHAGAAA  AA(AGAffA33A~ffA|(AffA\AAAffAAqAHAAA=qAAwAffA\AQA
A  AAAARA(AHAAAApAHA=qAAQAA
=A  AAAA33AAAA
AA{AGA33A
AAzAA(AzA{AupAA
AA(A
=ARAQA\)AGAuAyAt  AAHAffAA
=AA\AAA=qAzA33ARAQAAf=qATzAc33AZ\AAA]Af\A[
=AHAnffA|A{AAlzAv=qA33ARA(AA  AAzAqpAt  A{AtzAg33AcA^{Ah  ATQAVffAVHAO33AO\)AS
AXA`AbHAj\Ag
=Ag
Ak\)AoAs\)AvRAypAyAtAhzAZRA]AJffAYA\  A(AYAjRA
=AA|(AfHAypAt  AmAxQAffA
=A=qA=qA  AzA
A~HA\A
AAGA{AHAzA
AA~ffAAAGAA  A  AffAA(AA=qA  AAA=qAlAv=qAp(AbffA=qAlAwAL(A@A^RAxAQAAA{A=qAA(A\AAAA\AAGAk
=AjRAF=qALAhAkApzA}GAv=qAoA  AuGAyAt(AnHA=qAA\)A  AAAA
=AHA=qA{AAAzA\A
=AHAA{AGAHAApA\)A33AQA{A{ApAA(ARAAAA
A\)AA33AAA\AAυAffAQA  AAffAٮA=qAQAAffA߅AApAzAA  A홚AQAARA\)AAAAQA͙A33A
=AA
AAA
AAQARAzA{A\A(AAHA\)AffA\AAAzAA㙚AARAGAAAHARA
A33AAzAffA
AAAA\A
A
AAAGA{AAAA׮A\)AϙAģAA\)AAAffA
AAAHAAQAģAQAA33AA\)AAffAAٙAڸRA
=AAGA{A؏\A
AQAAGApAAиRAHA  AQA
=A
AəA  AGA͙AHAAffAAAA뙚AA\)AffA{AzA
AAA  AAffAHA홚AQA
=AAA\)AA\AzAAAA\)AAQA؏\A{AAAARA
=A{A33AA33AѮAA33AQA
=AAʣA=qA  AܸRAΣAGAAȣA޸RA\)AQAAAGAzAĸRAͅA
AHAGAՙAAAAŅAQAΣAՅAffAٙAGAA
=A33A\AAA{AzAÅAHAARA\)AAA
=AAHA33AA(A33AAAď\AAAAffA
AԣAffAAυA=qAAffAAǮA  AȣAAA(Aʏ\AAzA
AQA=qAģAAzAA
=AA\A
=AHAzAAQA=qA33A
A33Ȁ\A=qA
=Aԏ\A33AzAAمA\)A
AA(AAA  ARA33AGAA{A(A
=A33A\)AA
AzAAA
=AAQAA33AA\A=qAQAAAAHAGA  A33AHA
AffA=qA
=AAAǅA\AAA33A  A=qAAŮAA33A
=AGAՙApAAA=qApApAΣẠA\)A{A
AzAƣAzAǅAŅA33ARA=qA  AAA
AAHA{A£A
=A(AɮA
=AzA{AGAAGAzA
=AffApAAffAA=qApA  Aʏ\AHAffAәA=qAAAA
=A33A\)AӅA{A
=AхAQAzAљA
=AQA\)A{A\)A  AAApAϙAȏ\AՅAA{A(AȸRA
=A
=AHAʸRAĸRApApAQAApAAApA\)AQA(AA͙AApAffA33AȀ\AA
AȣApAzAӅAQAҸRA{ApAQA
=AzA{AffAAffAAÙAQAA33A(AͅAAA{AA\AA=qA  A33AQAA=qAʏ\AffA{A33AA\)AиRAAHApA֣A  A\)A£A=qA
=ApA33A¸RAAffAApA
=AAzApAîApA
A
=A  AAQA\)AA{AŮAQAď\A  A(A
=A
A(A\)AAAQA=qA癚A=qAGA  A㙚AffA߮AHAAA
AٙA33A  A{AAA=qAәAϙAȣA33A
=AA{AA׮A  AָRApA(ApAHAHA
AAHAÙAAAAA{A=qA
=A֣AAͮA
AAGA=qAQAAA(ApAA(ARA
=A{AAGARAA\AAAffAffA33A=qẠAzAzAAAAAffA{AA{AƸRA\)AΏ\A33A  A
=A33A  AAˮAApA
=A
=AۮAAҸRAGA\)AHApAffȀ\AffAAȣA  A33AAffAAAHAzAӅA33AzA\AAA(A33A33A{A33AA(AGAQA33A\A(AAA{Ȁ\AAȏ\AɅA
=A
=A
A  A=qAQAA\A\AA(AA{A
=AAHAAA33AAAHA\AzAAA33A(A
=A{AARAAA=qAARAAHApAAAυA{AAAffAA(AAHApA
ApAAGAAA  AAffAQAA=qAffA{A(AQA  AffAAA33AGAA\)AAHAAAARA\)AffAAAffAAApA{AApA\AGAGAffAA=qAQAffAApApARAAA\)A
=AQAQAzA  ApAffA=qAAAA\AA
=A{AAA\AAA=qA33AHAQAA(AQAzAAA=qApAAA  ApAA=qA=qAzAAAAAHAGA(AAAAA
AAAA{AGAA
=AA
=A  A(AffA\A(AAAAAAA(AffAAGAAffAHAA{AAA(A=qAA(AA\AAHAA
=ARAHAAffAARAAAAA=qA
=AA{AA  AA\)AAApA
A
AAA
=ARAffAAQA  AA
=AA{ARAƣAAAzA
AARA{A=qApA  A{A\A{A  A33AA\)A33A\AAQA(ApApAA(A=qA=qAzAHAAffAA{AA
=A33AApAAAA\A
ApA33AA(A=qA\AģA
A
=AAGAGAA{AA\AzA{AffAffA33ApARAAAGAƣAAAGAA
=AHAGAA
=AHA  A\)AAAAA=qAAzARAA\)AA\AARAffAQAAAQAAAA\A
=AAAAGA(A33AGAA=qAApA̸RA=qA(ApA
A  AApAƸRAAəAHA=qA
=AffAAAAƏ\A=qApAAzAA{AAA{A  AŮA33A\A£AĸRAHA(AzAAHA(AA£AυA=qAA  AGA£AHAzAA\AAGAQAAffAA{A=qARARA
=A{A(AAffAAHAAQA  A(AAA\)AffA{AAAQAA
AhAaAPzA  A}An=qAlA{AipA|AGARA
A
AA
=A(A=qAAAk33AmA[AYANRAC
ADzA9GA33A+\)A&HAAA A'
A\A A\)A
AA
A
HAffA.=qA&H@AzA/
A0A-ADzA A;A\QAjHAiAHAt(Az=qA
=A\)A(AA{AA[A(AmAtAo33Ah(AYA9pAG\)ALAPQA?AG\)A0A5pA<AO
=AQGAK
=A8(A9AKAR{AdzAk\)A\)Ac\)AdQA[ATA\  AeA\AzRA=qAA\)AzHA\AQAQAQARAGAAHApA(AApAHAAApAAApAA33A=qA  AA(ARA
=ARA  AA=qA=qA\AA\A\)A(AA
=A33AA  AAA(A
=AAAAffAA(AHAAAQARA
=AARAAA33A  A=qAA\A
A
=AHAzAAA\AHAA
=AAAApAAA\AffAAGA
A=qAAARA
AffAA\)AA
ApAzAGA
=A\ApA=qAzAzAAAzAGAQA\AA33AffARAAA  AAA33AffAAA\A=qApAARApA(AAGA
AQAAA=qA
=AffAA{A\)A\)ApAzA{A=qA\AA33AHAAffAAA(AAA\)A=qA\)AA\AApARA(AA(AA33AA=qAQAHAAǅA\AģA33AÙA=qAQA\AA33AA=qAA\AAAffA\AA=qAAA  A
=AzAffA(A
AAAAAQAA<
AQAAffAAA(AA=qAAzA33ARA
A\A=qAAffA(AzAGAA(A  ApA\AARAffApAA=qAAffA\A=qA=qAGAHAzApAQAHA=qARAAAGAffAA=qAHA{AAQA\)AQA\)ARA
=A33A
AA
=A
=A\)A\A
A
AApAAGA  AA=qApAGA
=AAApAřAAA
AQA33AA\A
ARARAA
A  A  AAQAA(A33ARAAA  ARAAAA{AAAAHA33A=qARAHAzAQAA  AA{AAzAzA{AAA|(AQA{AAAAzAARA{A
A\)AîA{A{AAA(A=qAA
=AAAzAHARAHAA
AQAAAA
=ARA\AA
AA
AHAAA=qAAAA  A(AHAA\AAAA
AŅAGAAGAA
A=qAGAAA(AffAGAAA\A(AGAGAAAHAAA
=AAQAA\)AAAApAAARAzA  AA33AAQA
AGAAA\)ARA33AA\)A33AAAAGAzA\)AA\AARA\)AHAȸRAAffAљAәAQAHAAzAffA33AAAzAzAʏ\AGAAQAffARAA
AQA=qAA
AA=qApA{Aȏ\A=qAŅA33AřA{A=qA=qA33AffA=qAAAA
A{AA{A(AApApA(ApA\A33A(AffAA=qA  A
=AAHAQẠApA
AAffA33AGA
=A=qAQAA=qAHAGA33Ȁ\AHAzA  A¸RA˙AAA
=A=qA33AHAȸRAQAzAхA  AHAиRAθRAͮA33AA
AA33A(Aҏ\A  A  A¸RAGAAA  A(A33AA
AəAAAAȏ\AffAمAA
A=qARAAzA\A33A
=AAAAQA\A\AffAAAA=qAffAA{A(AA(AAAA{A
AAAAGApAAAGAHA
A\AAA(ARAGAAHAQA(A{AAGAAAAAAA{A{AAAAGA\)AffAARA  AAffAHAQAA\)A{A\)AA
AAA=qA\)AA(AAHAGAGAAzAHApAA
=AAAHA33AAHAzA\)AHAHAGA
AAzA33AzAA33A\AA{A\AHA33A
AffAARAARAffA33AzA\AHA=qAAQAAHAA  ApAAAAAǅARA
AA=qA=qA  A
=A\AAA33AA
AzA
A  AAGAARA{AAAAAHAzA=qA{AAA=qA=qAA
AffApA=qAA(AA33ApAA{AA  AA=qAA
AAAGA\A\A(A{A\AQAzAQA\)A\)AARAAAA=qAAQARA
AHAffApA33AzAA(A{AQA\A33AA  AzAAQA\)AQAAAA(A33ARA\)AAQA
=A=qApAffA
AAzAA=qA
=A
AAA\)AAAQAAA33A  A33AAAA{ARAAAGAAAA33AA(ApAzA(A
=A33AۅA=qAffAA
AQAHAzA
=A
A
AffAHAHAffARA\)A{AzAA(AAAA
=A
=AGA(AA£AGAffAARAAAGA
=A33AAAffAGAAffA  AAAȣAGA  AA
AAA\AA  AGAGAˮAAzAAAHAAA\)AGAģAGApAffAǙA{AŮA\)A
=A\)ApAAffAAGA{A
=AGAأAAHAAݙA=qAffAQA=qAQAHAA\)AQA(AffApA\A\)AAA{A\)AAAQAQAHA33AAHAQA
AApAzAQA
=AApAGAGAffAHAAAA  AGAA
=A
AA\)AƣA{AƸRA{A{AApAAAA  AAƸRA  A{AGA\)AӅAЏ\A͙AA\)AQA=qA=qA\)A33A
AAəAAΏ\AAəAzAA
=AGA\)AAA  AAA؏\AAffA33AAQAGAQAՅAGA=qAٙAA߮AGAApAffAĸRAAHAA{A=qA33AA  A
A33ARAAA\)AAAAQA
=AAA33A  A
=A33AAGAAHA(A
=AQA=qAQAGA(AA  ARA
AffA
=A\AQA
=AQA33AHAAAϮA
=A\)AGAzA
AřA\)A{AŮA
=AA33A
AǮA(A{AQA{A
AffA(AA
AGAA{AAʸRAA
=AzAHAÅA
=AffA£A(AAAA\AAA
AAAffA\ARA
AHA\)AAAA=qAHAAQAQA=qAffA{AAAAA\A\A(AAAAɮAffApAARAAAAA
AQA=qA  A\)Aҏ\Aҏ\AхAAffAA
=A
A؏\AAffA߅A=qA
AAQAA㙚A{AffAffAA{AHA߮A=qAAAA噚AAAApA\A{A=qA\)AA{AGAǮAȣA{A33AA{AAߙAARAAQAA
AzA  A뙚AAA{A
A(A\)A33AA=qA
=AAA=u<<
ApA33AA\AQA
A癚AzAHA\AzA=qAzA=#
A\)Ao
=A=qAG?\?A  >kAAGA=qAG=A
?>z=G>=q=\)=\)>W
=@\=L?\(=u>=u<=u<=L<<<<<<
<<
<
=#
><<=u<
=u<
<=L==L=\)=u<<<=G<=G=#
=#
=u=L=L=#
=#
=u<<
<
=#
<
<
=L<
<
<
=L<
=#
<
>\)<
<
=#
=#
=uAC=u>W
==u>  A>u>  =GA  A&=qAAAwA33AN{AAAA\?QA
A{A\)>L>?\)?>  ?G=L?R=L=#
<<=#
<<<<<<
=L<
<<<
<<<<=#
<<<=L<=u=LA=#
==u=L>=#
?aG>\)>8Q>8Q?33=L=LA
=>{<
A
>L=#
>G<
=#
<
<
<
<
<
<
<
<<
>W
=<
<A=#
=#
=L=u=u=GA>u?A33ARA
AA
=AAA
A=>B\@c
=#
A?kA{=u>@
=q?G>{=L><
<
<<
<
<<
<
<
<
<
<
<
<
<
<<<
<
<<@GE@ff@
=@@@  @%@E?\@-p@.R@/\)@z@#33@
=@,@%@*H@0  @3
@7@<(@+@@  @3
@2\@S33@@  @7@>{@<(@0  @G
=@B\@<(@8@1G@7
=@6ff@:=q@6ff@9@<(@333@5@H@\)@*=q@-p@1@/\)@$z@\)@\)@&ff@.{@&ff@%@-p@{@\)@1@<(@4z@@  @7@3
@\)@+@.R@5@+@R@/\)@33@/\)@8@p@Q@,@(@:=q@9@Mp@1@<(@0  @%@'@"\@)@1G@1G@*=q@.{@(Q@@ @%@p@'
=@#33?@;@@  @XQ@AG?  @E@AGC}q@5@4z@&ff@>R@(@HQ@@  @C
@>R@W@O\)@J=q@5@>{@B\@E@7@:H@1@9@-p@G@#
@-p@#33@!@%@@H@ @@@H@"\@R@   @!@ ?R@ @2\@333@.{@?\)@.R@8@e@3
@.R@4z@G@ ?&ff@333?G@@#33@2\@\)@JH@E@JH@N{DR@A@(@O\)@>{CofA@5@5@<(@<@U@9@<(@#33@7@;@AG?\@;@Fff@JH@(Q@6ff@3
@:H@B\@AG@>{@8Q@3
@7
=@.{@(@>{@A*\@g
=@Q@@
@=q@ƸR@33@@
@\@p@{@^{@fff@<(Cd3@^R@xA@@Q@@=q@p@@Vff@mp@6ff@C
@[@,(@\@@\@{@=q@Q@P@^R@aG@QG@X@XQ@W@c33@@L(@
=@@Fff@7
=?@HQ?xQ@+@.R@,@333>Ǯ?Q@1>p@)@   @(@p?R@@(?\@.R@%@ >z@   @G@1G@333@:H@2\@9@;@8@AG@>R@H?+@HQ?=q@H?@   @B\@*=q@<@@{@Ϯ@@^{@s
@ff@s33@}p@33@\)@33@@G@@@{@q@z@\@{@X@fff@2\@fff@r\@H@\)@fff@@G@H@
@ff@ff@c33@7
=@>R@U@4z@J=q@=q@0  @AG@I@G@g
=@ָR@}p@!G@&ff@ @@@\)@\)@'@@@)@
=@z@@=q@
p@0  @?\)@'@2\@\@(@R@8Q=\)?G@R?Q@*=q?33@Q@R@R@@
H@{@@1G@
@@\@@\@\)@@\)@$z@#33@@  @ZH@^R@
@33@@\(@
=@B\@W
=@]p@nR@lA7@{@vff@
@  @~{@H@@  @@p@33@
@@\)@  @p@=q@<(@Dz@u@aG@hQ@XQ@e@\@{@A(@H@33@@
@{@XQ@@0@.R?L@R\@
=@A@{@<@.{@#33?>p@333@ ?B\@	@@Q@@@G@  @@	@\)@=q@@   @{@
=q@
H@\)@
H@AQ@{?@R@{@
p@@h@H@@z@z@\@p@w
=@  @@\)@  @h@vff@R@G@
=@ff@@K@9@w@ff@   @Mp@@xQ@N{@5@dz@jH@@=q@H@@@p@=q@@  @@\@=q@G@n{@@p@G@@i@z@Q@G@C
@
H@
=?Q@@\)@R@@G@
p@ff@
@G@@{@
H@@z@p@R@{@@
=@@
=@\)@
=q@\)@@?p?@
=@z@@@*H@{@
H@G@(@0  @
=@@Dz@"\@\)@@{@H@A (@(@G@[@R@@tz@߮@@Q@\)@\@\)@dz@ff@R@R@@A@33@أ@p@x@@ff@+@
p@AQ@  @H@@@{@@  @\@@@{@@  @@@@p@ff@:=q@Q@G
=@"\?
=@333@%@C33F_P
@H@_\)@4z@^R@/\)@@*=q@Y@@3
@I@l(@`@A@@@@@+@-p@2\@(Q?ff@.{@1@1G@1@:H@4zA(@9@.{@Z=q@R@ff@w
=@(@l(@@Å@@(@HAR@zA
ff@@@=q@\)@@(@H@@33@  Aff@@ff@@@p@z@
=@H@@z@33@R@@H@HA@@\)@(@@(@RAQA!@R@޸R@P  ?p@@@	@@ @{@@p@@
H@@  @  @
H@G@@(@
H?=q@@33@
p@33@@@z@ff@
@B
=@
=B33@@z@ff@@Q>@H@
=@(@ @>R@z@\@(@n{@z=q@p@@@@@U@R@@Mp@  @Q@p@@@33@Q@ff@ff@@@@@\)@ҏ\@@R@@G@=q@
@Q@@@\@G@@j=q@@=qA
=@
@@=q@@@ff@Q@xQ@	@@z@@ ?@@   E%@@@=q@@\)@ff@@?c
?H@
=?(@ @=q?R@H@  @#33@!G@/\)@(@\)@R@G@G@ff?33@  @33@Q@A@)@@H@6ff@+@?\)@J=qA	p@Q@R@33@@\@R@MpA
R@33@ff@hQ@@(@@(@
=A@=q@H@
=@A(@{@@{Az@A
@
AH@ʏ\@@H@HA
GAGAA QA  @A7
@~{@hQ@@
A@@ff?{@R@%@%@A@-p@:H@@hQ@p  @`@Fff@@G
=@5@\)@AG@6ff@/\)@E@=p@<(@7@7@@@Q@ZH@Z=q@Y@U@X@x@l@p@@R@@@  @@@@@
=@@
@zAG@@
=@Q@=q@A z@@\A@33@=q@33@Q@@Q@@ff@޸R@@
@z@=qAHA$@H@s
@(@=q@ff@p@ff@@p@G@\)@
@ff@
=@=qA  A\A1@\)@A
=q@33@@(@  @9@AG@O\)@C33@O\)@`  @U@z@Q@R@G@33@vff@~R@X@l@h@{@XQ@U@P  @Fff@HCC@5@c33@xQ@x@G@z@@@z@(@@{@|@dz@@z@nR@\)@\)@@@
=@  @RA(z@R@\)@a@p@
@=q@=q@@(@
@{@Q@@^{@U@dz@s33A
@=q@`  @@@  @s33@p  @\)@@P@@5@>R@H@ff@G@S33@33@@
=@ff@@@Q@@H@C
@B\@I@9@#
@@3
@.R@-p@]p@@R\@3
?0@8@
=@:H@'@"\@[@H@x@@ZH@N{@{A\@JH@8@*=q@\@{@=q@!G@'
=@"\@,@@.{@XQ@h@8Q@2\@7>\@5@;@:H@]p@2\@333@A@\)@fff@7@@\@P  @=q@i@3
@<@jH@O\)@p@ff@ff@jH@R@=p@\@p@{@G@dz@j=q@.RB33@G@z@$z@C33@S33@|(@j=q@^R@  @XQ@
@G@@@33@޸R@
=@@@=q@\@i@(Q@6ff@[@3
@4z@*=q?p@JH@1@E@A@Dz@1@7@;@,@L@S
@G
=@<@;@1A#
@I@I@4z@ᙚ@@@%@.R@K@0@5@K@%@-p@*=q@+@0@Z=q@  @*H@@0@P  @q@,@:H@@~R@  @
=@H@r\@A?
=@O\)@z=q@QG@Q@@6ff@
@z@
=q@@@Q@=q@'@@
=@<@Fff@)@R@2\@p  @33@r\@;@(@S
@>{@8@A@p@
=@(Eݚ@>R@
=@Q@E@S
@@g
=@
=@@k@(Q@l@L@x@@Q@I@B\@N{D=?zH@p@
=@?p@ff?
=@{@'
=@)@*=q@$z@z@
p@#
@@(@-p@0A(@+A@H?:H@P@ff?޸R@^R@p  @G
=@U@i@)@1G@@@H@33@  @A@7AH@@@s33BQR@0@:=q@ @R@p@(@$z@ @$z@)@&ff@0  @*=q@33@  @!G@*H@+@!G@)@*=q@"\@3
@ @%@#33@{@^R@(@:=q@$z@'@,(@2\?@#33@:=q@(@@E@@B\@B\@Q@Tz@I@Q@Q@Z=q@dz@w
=@c33@X@ZH@P  @K@Tz@Tz@`@QG@ZH@g
=@c
@c
@\)@_\)@mp@b\@j=q@e@Z=q@`@G@^{@Dz@K@JH@7@:H@<@7@6ff@(@Z=q@\)@qG@;@=q@^{@6ff@n{@(AH@@6ff@xQ@3
@#33@{@@a@R@>R@,(@1G@Mp@P  @4z@\)@33@@S33A33AS@QA#\)@|(@dz@i@Q@\)@@N{@@2\@.R@9@c33@Q@w@<@z=q@(?޸R@.R@0  @8@6ff@0@/\)@4z@*=q@7A=q@-p@1G@>{@;>(@=p@=p@:=q@1@:=q@8@+@Z=q@]p@mp@Dz@QG@5@J=q@C
?p@A@;@=p@9@AG@NR@[@W@U@W
=@@\)@p@  @
@Q@H@@R@  @33@(@
=A:H@33@Q@X@U@]p@I@AG@i@H@p@xQ@i@~{@@@\@\@
=@Q@33@u@=q@k@@33@=q@@l@e@g@l@AAG@E@=p@L@G
=@@@C33@C33@Fff@(@<@G
=@K@E@=p@?\)@7@:H@X@9@J=q@8Q@(@J=q@X@L@Q@l(@R@@U@N{@U@`  @Tz@`@L@;@.{@*=qD
@+@)@5@0@Vff@2\@  @@  @7@=q@ZH@A@@@\)@QG@@AG?\)@C33@L(@1G@@[@J=q@@n{@4z@P@7@-p@a@n{@i@tz@@Q@@@(@<@0@A@@@G@@\)@u@@R\@p  @q@]p@@33@{@33@9@Q@>R@P@.R@:=q@9@G@Q@^{@5@1G@.{@#33@)@@&ff@@(@=q@"\@%@'@@:=q@0@/\)@5@5@2\@333@$z@(@+@7
=@333@5@6ff@:=q@Dz@,@1@=p@AG@1G@*H@{@GA
@\)@Vff@@@y@NR@AG?@\@ff@ff@\@G@@$z@P  @n{@@333@/\)@^{@<(@W
=@&ff@\@
=@P  @S
@x@S
@
=q@W
=@@@AG@Dz@(@W@
=@NR@<(@N{@tz@@@5@\@c
@J=q@Tz@l(@U@QG@H@6ff@:H@/\)@5@#
@ @H@@(Q@'@.{@#33@#33@*=q@,(@o\)@3
@1A	p@>R@L@=p@C
@,@2\@.{@7@6ff@C
@333@1G@.R@:H@5Bp@7@3
@Q@z=q@333A2R@w
=@Q@O\)@$z@@{@@{@@\@i@p@(@G@@@@@,@@@@@  @?\)@Mp@A@hQ@c
@G@Q@  @@@e@k@R@@0@@ff@nR@xQ@Q@`@5@S
@p@p@@G
=@U@XQ@U?
=@W
=@Fff@E@\(@Q@Vff@A@E@Tz@\(@l(@^R@^R@\?@,@?\)@D3@AG@AG@Fff@#
@6ff@>R@A@B\@Fff@@@?\)@L@xQ@^R@
@qG@s33@^R@g@fff@\@@33@Dz@(@|(@@@(A	@\@ff@33@z@N{@JH@@aG@
@@@@33@@tz@q@p@=q@l(@S
@N{@1G@333@9@C
@U@ZH@:=q@@]p@ff@33@=q@Y@U@ZH@=q@S
@/\)@U@q@ff@@Tz@E@
@L@ZH@L(@s33@
=@@c
@c33C3@h@\A@
?33@1@@@5@5@N{@,(@+B\@*H@0  @8@1G@4z@7@z@L@J=q@Mp@ff@1G@8Q?R@Q@G@(@
@ff@@9@Mp@q@H@@{@p@p@(@33@i@@j=q@\@p@=q@z@@ZH@5@=p@1@Mp@<(@5@p  @K@@Q@Vff@Q@@w@jH@h@\)@-p@U@ff@ff@~{@x@G@w@@@}p@@ff@Q@\)@z@fff@s
@NR@G@c
@e@z=q@  @@:=q@EE}R@Vff@P@W@O\)@e@W@P  @Q@Y@P@K@@`@QG@p@n{@ZH@c
@p  @@`  @FffAz@:H@G@E?@Mp@\)@^{@aG@dz@hQ@^R@q@\)@z@  @\@@
@z@z@R@\A@z=q@R@p@
@z@z@p@@=q@@ff@=q@{A@z@@{@=q@@
@@Q@\@y@Q@Q@  @k@@@
@@@Ӆ@{AN{@HQ@E@!@3
@6ff@:=q@HQ@;@5@1@ff@@@ff@G@W@;@E@(@0@   @@
@(Q@#
@=q@)@Dz@HQ@E@<(@:=q@O\)@^{@`  @c33@NR@aGA@~{@i@@c
Ab{@\(@w
=@X@@Q@  @
@@p@\)@o\)@@`@^R@e@z=q@H@'@H@A@@ff@ff@  @R\@=q@@
=@@@@j=q@@33@L(@p  @xQ@R\@G@C
@Z=q@Q@33@8@8@\@\)@@\@|(@(@qG@|(@JH@P  @L@@{@W@^{@QG@E@O\)@Mp@@@:=q@9@c
A6H@.{@+@<(@8Q@@L(@nR@.{@Mp@^{@mp@j=q@dz@o\)@33D{@g@@=q@r\@@@[@@y@{@ff@33@QAff@=q@@w@33@Ap@{@  @g@@n{@AG@
@\@@HA
=@  @z@
@ۅ@Ϯ@33AG@ۅA@ff@H@@33@33@@33@Q@A
A(A4QA?AHA>=qA  B(B8HB>
B\B%pBpA(B(AHAAڸRAA\AQA  A33AAAGAȏ\AARAAGAڏ\AzAAA(AΣAQApA{ApA\)A=qARAHAAffAAAAGB)Av{AsAupAA
=AaAj=qA[Ab\AN\AEAMAW33AQAXQANffA\  A=A2{A-A.{A-A'\)AL(A@  A\A.ffAAQA>HA2=qAQAzA=qA
A5ABA=qAIABQBA\AzAffBB
=BFffB 33A\ApB  A\AzAA  A  AA
=A=qA{A{AAAHAAAGA  AAA\)AAAzAzAA(AyAzA
=A{
AupAbHAXzAUAOADA9AAA@(A4  A6{A/\)A/
A  AA   A33A{A#
=A=qA
GAGAF\A  @(A{A
=@޸R@@Ӆ@@Q@=q@GA @(AzA@
=@\@
=@z@=q@@G@Q@Q@z@@ff@@@ff@@=q@  @p@G@@(@
@
@p@ƸR@@ff@@@GD^@g@^{@L@k@;@33@a@H@ff@Q@{@  @@@R@@Q@G@
=@z@ff@  @(@R@ff@33@H@@ff@33@޸R@@ff@w
=@33@G@{@ff@@@R@
@z@ff@@\)@(@@@z@p@\)@\)@@Ϯ@=q@z@=q@@@{@p@љ@ٙ@  @=q@\@@H@z@@H@θR@@G@33@@G@ƸR@@}p@|(@R@(@Q@
=@\)@Q@Q@y@@@G@p  @p  @mp@tz@  @ff@H@@(@|(@Q@vff@p@XQ@s33@hQ@jH@jH@n{@Q@l@^R@\(@_\)@O\)@]p@tz@z@Q@|@@
@k@n{@dz@o\)@S33@E@L(@@u@X@QG@AD
@H@zH@(@z@=q@R@\@\@hQ@ZH@JH@P  @@  @nR@s33@X@z@P  @\)@p@*H@{@1@1@0@E@+@4z@/\)@/\)@1@;@G@:=q@7@C33@_\)@k@H@h@=q@N{@_\)@z@@L(@g@S33@l@E@>{@(Q@U@O\)@[@C33@>{@5@Dz@>{@9@:=q@0@8Q@C33@_\)@vff@w@aG@AA@8Q@I@mp@dz@mp@@@`  @p@zH@e@e@tz@zH@@}pC@h@333@u@l(@G@@
H@H@R\@c
@w@p@G@@W
=@R@@@@e@XQ@p@Fff@QG@@u@\)@\@g
=@{@=q@@\@c33@@p@@i@|(@`@  @H@u@H@@p@R@ȣ@@G@˅@H@@R@\)@y@\)@~R@qG@\@e@fff@Tz@`@ZH@]p@Q@8@Vff@aG@U@PBǮ@mp@`  @W@c33@QG@]p@_\)@n{@W@XQ@Tz@  @H@W@E@AG@L@l@Mp@G@JH@P@JH@Fff@>R@C
@6ff?@iC@n{@8Q@l(@zH@a@q@^{@c
@S
@  @Q@{@~{@ff@zH@\@B\@[@\@5@/\)@333@%@3
@1G@\)@!G@#33@6ff@A@P@3
@=q@HQ@@3
@@\@x@`  @@n{@MpA@  @\@@@@
=@p@NR?@^R@S33@Mp@H@5@4z@,@0  @/\)@<(@H@>{@8Q@-p@\(@X@W@W
=@8Q@7@G@7
=@H@P  @JH@X@Vff@Tz@l@[@L@P  @#
@<(@'@%A
@
=@@  @;@C
@AG@:=q@>{@:H@Dz@^{@]p@AG@G@9@p@*H@u@l@
=@@|(@@{@=q@ff@p@|@e@R\@xQ@;@z@Q@@Q@@G@R@B\@@@
=q@?{?Q@ @8Q@c
@@@p@\)@@@\)@(@@1@(@@(@@@)@.{@0  @A@%@5@p@@33@?zH@
=q@@
p@
@\)@ZH@A@Fff?Q@??0?@
=q@z@\)@G@!G@  @33@?
=q@p@"\?p>@
=@R?&ff?@Q@@p@  @H@@:=q@R@\)@@ff@}p@p@@O\)@  @p@{@{@@R@  @\)@@@@@@\@@  @XQ@y@aG@z@(Q@@\)@@@=q@H@!G@@H@@ff@p@u@%@*=q@@R?ff@#33@@{@
@@@@
=@9:H@@=q@(@
=@@ȣ@\@\)@p@@ҏ\@@ָR@z@ȣ@ff@\)@DEc3@@@@G@@p@@r\@G@nR@(@33@\@ff@  @33@=q@@@H@@{@
=@
@ff@@ff@
@\)@  @33@  @H@@@@(@@33@
@=q@R@\@@@
@=q@R@@@
=@
@@(@ff@{@R@@@{@ff@\)@@(@@G@@ff@
=@@p@=q@
@@\@@ff@@  @
=@\)@\@@z@  @z@@@R@@=q@@@
=@p@@p@H@Q@@@G@p@H@@{@ff@pC
@{@ff@zH@@  @p@@  @@@(@R@=q@z@
@z@  @Å@G@@  @
@@H@\@33@\@@H@@\@Q@@@@H@  @33@@@R@G@R@33@R@@@\@  @@@z@\@@@\)D@z@@@33@ff@@p@=q@{@
@
=@  @@
=A@\)@(@@@@@{@@@@Q@@@  @\)@\@33@z@tz@@JH@@@@\@@@@(@H@@Q@@ff@H@33@R@p@ƸR@=q@@Q@@\)@@@  @@33@@H@@33@ff@ff@@  @{@@R@33@33@@Q@z@
=@=q@=q@
@Q@H@@  @p@z@  @Q@  ?G@@(@z@G@\@
=@@@ff@ff@{@@H@{@p@
@
=?
=@H@zH?@{@
@@@z@=q@
D@{@(@p@@\)@\@@R@H@@@@H@ff@@G@
=@
@\@=q@@33@@@@(@z@=q@@@Q@@@p@@
=@(@
@p@=q@\)?{@{@ff@@
=@@(@
=@@ff@@
=@@R@R@@=q@\@p@@\)@  @\@33@@@33@{@@H@
@@
@}p@|(@z=q@|C@|(@}p@@z=q@z@  @@  @|(@z=q@~{@H@@{@@@@
=@H@{@
=@p@G@
=@@
@@@@@@\@33@R@@\@@@ff@=q@
@(@H@\@G@ff@Q@H@p@R@@33@
=@  @@ff@{@@@ff@@(@{@ff@
@
@
=@@@ff@33@@p  @=q@Q@  @(@
@@H@@
=@g@  @@33@@@ff@}p@@H@33@Q@G@@~{@\@z=q@y@zH@z@G@33@  @
=@(@\)@@{@@p@\)@  @=q@H@p@  @@\@@{@=q@x@|@Q@@{@H@
=@\)@33@(@(@H@H@H@@@Q@@}p@|@@G@Q@@Q@33@@  @@@z=q@z=q@zH@zH@~R@  @@\@H@@Q@Q@
@G@R@
=@@G@@zH@Q@z@  @@z@~{@@=q@|(@zH@x@zH@zH@s
@jH@h@e@u@33@|@
=@p@@mp@dz@l(@l@g@c33@c
@`@c33@g@g
=@i@mp@k@s33@mp@mp@s
@p@jH@n{@nR@n{@p@mp@e@l(@s33@n{@0@Fff@^R@g
=@tz@o\)@p  @p  @]p@Z=q@ZH@W@c33@c
@nR@c
@q@s
@s33@p@o\)@nR@k@e@vff@s33@w@tz@s
@w@j=q@c
@fff@h@l@e@aG@k@hQ@n{@l(@e@b\@fff@W
=@g@s33@s33@l@u@nR@r\@x@o\)@c
@N{@HQ@N{@HQ@I@X@W@mp@o\)@u@|(@@H@@@R@(@xQ@|(@u@zH@{@u@vff@o\)@l@s33@j=q@h@b\@mp@fff@e@\(@fff@y@@@u@G@
@ff@z=q@=q@p@@@g
=@u@  @w@y@ZH@b\@l(@y@~{@xQ@u@vff@s
@s
@q@q@y@p@S
@W
=@QG@Z=q@\@hQ@`@fff@j=q@^R@X@O\)@@33@U@@\@s33@q@p  @j=q@i@p  @x@(@qG@Z=q@^{@\@\(@a@`  @a@l@n{@b\@_\)@`@i@_\)@]p@a@X@S
@W@W@P  @U@JH@L@L(@K@NR@`@R\@a@Vff@`  @g
=@xQ@jH@p  @@Z=q@^R@`@]p@U@O\)@\@L(@G
=@I@C
@?\)@3
@(@(@!G@p@\)@!G@ @!G@@H@$z@"\@#33@@@33@\@
=q@
=q@@
=@G?Q@@   @33@@?(?z?(?
=?33??33?
??@@@R@Q@G???R@G@ff@
@G@ZH@K@E@A@E@AG@A@A@B\@Q@jH@a@Y@XQ@Z=q@U@X@Q@G
=@J=q@O\)@O\)@S33@Vff@S
@U@i@y@xQ@w
=@mp@y@|(@r\@p@u@c33@c33@g
=@\@g
=@]p@\@\(@`@^R@o\)@e@hQ@k@dz@aG@a@aG@l(@dz@a@dz@g@p  @`  @p@n{@s33@q@h@s
@l@qG@]p@[@Z=q@\(@`  @^{@_\)@^R@[@[@a@?\)@3
@P@^{@^{@^R@a@`@Z=q@[@ZH@c33@n{@a@b\@aG@h@hQ@n{@|@@H@tz@w@w@fff@c33@aG@p  @u@n{@p  @k@dz@c33@_\)@e@a@dz@i@g@e@g
=@k@fff@i@`  @ZH@c
@@i@[@Z=q@aG@e@_\)@^R@_\)@`  @^R@X@Z=q@X@XQ@XQ@Y@XQ@U@X@XQ@U@Vff@U@W
=@W@ZH@U@Y@Y@X@Vff@U@U@Y@U@U@W@[@Y@X@`  @]p@\(@aG@^R@c33@c33@b\@_\)@`  @Z=q@^R@]p@ZH@e@dz@\@]p@]p@g
=@[@`@_\)@jH@y@`@`@R\@g@e@\@^{@ZH@g
=@g@j=q@[@w@u@s
@G
=?!G@j=q@r\@q@u@dz@jH@U@[@X@W
=A\z@@@c
@e@dz@e@hQ@_\)@b\@e@`@b\@_\)@Z=q@l(@_\)@\@e@e@dz@_\)@^{@\@[@c
@X@S33@U@U@Y@\(@Y@^{@ZH@\@aG@]p@\(@[@ZH@Y@X@W@^{@W
=@[@\(@]p@Vff@Z=q@Z=q@b\@`@W
=@^{@ZH@]p@ZH@Z=q@\(@?\)@U@XQ@`  @g
=@a@`@c
@h@^R@e@`@[@Y@XQ@@ZH@U@U@^R?@W
=@[@jH@Q@@33@~R@zH@{@|@zH@w@q@g
=@dz@^R@b\@a@qG@|@ff@z@\)@(@@R@ff@  @@\@@G@@@G@33@mp@XQ@w
=@aG@e@a@c33@\@R\@Y@W
=@P@S
@P  @H@L@L@NR@N{@L(@Mp@L@N{@O\)@N{@Mp@N{@P  @Q@Q@S
@P  @QG@P  @O\)@Y@P  @R\@JH@i@s
@c33@\(@r\@r\@33@@  @U@R\@S
@N{@P  @L(@L(@N{@R\@P  @R\@Q@(@Vff@NR@U@@W@U@Vff@\@Tz@_\)@k@_\)@]p@X@aG@_\)@b\@B\@aG@%@w@b\@c
@k@a@^R@nR@`  @\(@]p@NR@U@W
=@X@XQ@Z=q@a@U@X@[@XQ@S
@NR@X@X@U@Mp@S33@P  @S33@QG@N{@K@I@Dz@E@JH@E@E@P  @JH@U@Y@(@(@
=@  @(@@@~{@u@@@z@r\@\(@fff@,(@e@Mp@N{@1G@JH@E@HQ@@@Fff@K@JH@E@G
=@Dz@@  @E@C33@JH@G
=@G
=@I@I@J=q@NR@L(@H@JH@L@L@K@I@[@L@W
=@Tz@N{@K@HQ@H@=q@H@E@J=q@HQ@E@C33@E@Fff@Dz@C
@C
@Dz@Fff@E@Dz@C
@E@E@Dz@L@H@Fff@G
=@C
@C33@B\@A@Dz@Fff@C
@Dz@C
@C33@E@K@Dz@P  @N{@^R@`  @G@P  @Vff@R\@JH@C
@G@I@G
=@QG@I@JH@J=q@Q@G
=@H@K@L@Tz@a@c33@^R@^{@Vff@L(@G@C33@AG@B\@E@B\@>R@>R@=p@<(@>{@;@>R@>R@>{@@@>{@@  @=p@A@<(@>{@@@A@AG@@@C33@I@QG@?\)@B\@AG@B\@G@C33@@  @@  @>R@>R@:H@?\)@<@<(@=p@@@@  @C33@Dz@A@Dz@C
@HQ@B\@E@E@Fff@I@Dz@JH@I@Fff@E@E@I@I@I@E@J=q@G@Fff@Dz@G
=@E@E@Vff@?\)@R\@L@N{@Mp@L@JH@.R@C
@I@O\)@Q@NR@NR@@/\)@9@`  @dz@L@Tz@c33@}p@w@Q@Tz@Mp@:H@N{@U@O\)@L(@H@.{@JH@I@L(@K@I@J=q@J=q@I@Mp@NR@Q@S
@QG@G@P@S
@Q@Tz@P@W@S
@Q@J=q@HQ@Fff@B\@G
=@H@S33@P  @P@P@Mp@L(@NR@Tz@^{@N{@P@P@O\)@P@NR@QG@R\@Tz@Vff@QG@W@W@W@Vff@Tz@U@Y@U@Vff@Vff@W@XQ@Y@[@Z=q@^{@b\@S33@\@Z=q@Z=q@W@N{@JH@K@>{@QG@Mp@L(@Q@QG@O\)@R\@U@XQ@^{@dz@k@nR@s
@zH@}p@,(@{@w
=@w
=@vff@zH@tz@z@Tz@qG@g@_\)@b\@aG@s
@{@@u@r\@[@W@`  @P  @Vff@K@K@H@HQ@K@K@J=q@HQ@Q@R\@N{@R\@QG@J=q@L@Mp@P  @Q@QG@Tz@QG@NR@H@JH@G
=@E@J=q@S
@U@S33@Mp@O\)@R\@O\)@N{@K@X@@\(@e@XQ@S33@Vff@Vff@W
=@^R@Y@aG@hQ@g
=@n{@r\@i@ۅ@o\)@s33@mp@mp@l@s33@j=q@b\@c33@r\@@\)@b\@X@P  @Mp@Dz@G
=@A@C
@C
@G
=@[@W
=@Vff@Q@U@P  @o\)@s
@i@Tz@Z=q@n{@Q@P@N{@8@J=q@?\)@Fff@HQ@Tz@J=q@G@L(@E@G
=@HQ@E@Mp@Mp@L@S33@J=q@U@QG@HQ@JH@HQ@G
=@A@?\)@H@I@QG@N{@]p@i@l@e@X@`@b\@\(@l@[@XQ@U@Vff@ZH@S33@N{@XQ@S33@S33@P  @Y@XQ@ZH@S
@Mp@QG@S
@U@fff@XQ@~{@c
@\(@`@Vff@\(@Z=q@S
@U@@i@@g@e@r\@\)@Q@У@@g
=@h@X@W
=@XQ@Y@S33@Vff@W
=@\(@[@Tz@Z=qBp@\@W
=@Tz@@Fff@JH@L@O\)@P  @NR@K@O\)@L@JH@L(@Vff@L(@G@hQ@l@i@h@\@Vff@c33@L@^R@_\)@_\)@hQ@mp@`  @j=q@nR@q@j=q@l@hQ@g
=@^{@^R@\(@c33@b\@h@r\@mp@mp@nR@G@Tz@W@U@S33@$z@U@X@[@@Tz@Tz@P@X@]p@W@`@r\@aG@Z=q@U@QG@ZH@^R@e@dz@ZH@^R@z=q@
@{@33@33@z@@ZH@@33@R@{@@Q@@\)@  @@@@(@=q@\)@{@w@z@
=@@vff@p  @^R@\@[@O\)@Mp@S33@H@E@L(@N{@S
@e@]p@b\@\@Vff@o\)@w
=@q@o\)@G@@H@@
@G@w@u@{@{@~R@}p@@p@|@@vff@q@^R@b\@i@^{@XQ@S33@Z=q@fff@aG@u@jH@aG@r\@Vff@(@  @s
@jH@[@zH@c
@Z=q@s
@`@aG@k@~{@z@\)@z@Q@@@R@(@33@@Q@
@(@33@\)@ff@@33@Q@\(?ff@l@k@jH@e@H@r\@e@fff@n{@{@  @  @@@@@@@{@@@\@z@ff@Q@@@  @\)@w
=@=q@@w@~R@Q@x@ff@@ff@H@z@(@{@@@
=@(@R@\)@
@\)@(@E@\@
=@p@R@G@@(@G@
@H@z@(@H@{@@ff@@{@˅@@z@
=@(@@p@@=q@33@@H@@\)@p@
@(@\)@@Q@  @@p@
@H@@\)@@  @p@
=@{@@ff@G@{@@(@z@o\)@@@p@z@Q@b\@ff@@@@@R@{@@HAA
=qA$QAQA)A%A-A@QA5A)pA8Ap@QA@\)@(@33@@Q@A@z@p@
=@
=@@@p@\)@=q@(@@\@Q@ȣ@@G@@(@
=@R@@p@z@@G@{@
=@=q@@@
=@\@@p@=q@  @  @\@=q@
=@R@(@@ƸR@=q@  @  @Q@@\@33@=q@\)@=q@H@  @
=@
=@@(@@33@@=q@G@=q@@@=q@@@@p@ff@
@\@@@ff@@@{@@p@G@@G@@  @=q@Q@@@@H@R@@Q@@z@
=@Q@@@@
@@z@\@H@Q@z@  @@R@G@
=@=q@@@{@@\)@R@@\)@p@@\)@z@ff@z@z@(@@
@{@z@p@\@@\@=q@z@=q@ff@ʏ\@A
=@θR@p@
@ff@@@@(@
@{@33@љ@ff@@z@33@G@Q@@@
=@陚@\@Q@߮A@AQ@QA
pA33@\)Az@(@@\@z@
@ᙚ@=q@ٙ@
@@A=A\)AA#\)AFHAf{ANRDAAzA (A{AAAVffAA,AK
A,  A=qA=qAIAhA_
=AMAqAaAr\AZ=qA3\)A=qAr{AxzATQAApACAKA]pAAxAxzAOAAAwAffB  BBB9{BcBPB_{BfB}=qBFB#B%ffAA
A{AGAQA{AA
=AAAAA=qAGAAAffA(AAA
=AxAaA_
=AXAPzAHzAIA5A+
=A,A"=qA9A"RA>RA+A)GA\A\)ARA33AHAA{AHA  A@Aff@=qA@  A@\@\)@{@Q@@=q@(@\@  @=q@@H@  A @33@  @AzA  A
AAR@ffAAA
A=qA*=qA1GAK\)A^HAAx(AAA
=AGA(AffAAAυAQAGB	ffAB=qA{AffA
A  AיA
=A
=AQAQAAzAffA33AAAAAAA\)Az\AfRAJffAMAC
ADA@QA-A"\A*ffA0  A)A7A0  A<  A(  A(AVHA5pA^\AfRAiAlQAFRA?\)AF{AG
=AD(A4zAB\A@(AKAEpALQAVffAV=qAQAS33ALAYAW\)AT(AW33AaAQAEA@(A;A0A,A%A*=qA(zA-AQ@@A
=qAQA{A\)A{A
A@=q@@ff@@@H@ff@R@
=AQ@33@\)A@R@@@Å@ff@z@(@ҏ\@Q@\)@
@ȣ@@z@33AA
=A:HAffA  @陚@ff@Q@˅@(@Å@ff@@(@  @(@@ff@  @33@Q@z@\@z@R@Q@ff@}p@@@~{@\)@\@@@z@\)@ff@=q@@p@R@p@\)AffA
ffA33A\)@G@{@p@@@Q@(@@G@33@Q@33@H@  @33@u@@p@@@p@Q@@z=q@@o\)@e@\(@33@nR@
@@  @z@=q@]p@hQ@U@9@@@b\@N{@S33@XQ@A@A@A@4z@A@>R@=q@'@2\@E@R\@Q@]p@l(@S33@S33@@  @ @(Q@b\@
@l@g
=@i@g
=@X@^R@h@c33@^{@k@j=q@g@fff@dz@aG@j=q@Vff@g
=@[@S
@W
=@\(@S
@Vff@S
@G
=@4z@@@9@;@8Q@Vff@R\@Z=q@\(@p@aG@9@E@AG@XQ@dz@Q@7
=@3
@5?(@
=q@
=q@\@@{@\@@(@	@
H@
H@@ff@Q@
=@
@z@?@{@Q@\@
p@@  @=q@\@
=@
H@  @\@@(@@  @&ff@!?@
=q?33?(?@'
=@.{?(@@@
=@@   @,@R\@<(@/\)@\@p@#33@R@{@  @
=q@
@p@@@#
@=q@(@2\@1@0  @(Q@,@6ff@?\)@4z@?\)@7
=@8@A@@@7@A@1G@1@333@8@W@JH@0  @$z@G@@&ff@*=q@Q@@
@ @@@???H?G?˅??33?G?
?\?˅???33?H?H?  ?p?@{?@H@0@1G@C33@   @?z@@ff@{@@9@8Q@.{@&ff@#
@R@R@	@@
H@
H@	@
@@
@@z@(@#33?z@z@  @@H@!@@%@&ff@\)@@{@@@@+@0  @8Q@AG@L(@H@>{@r\@33@s
@o\)@w@u@(@P  @H@>{@R@E@N{@C
@)@[@fff@H@p  @jH@8Q@   @$z@B\@Mp@U@Q@aG@r\@L(@O\)@i@c33@]p@\(@Q@N{@NR@g
=@  @{@@@~R@\@@@
=@@z@\@@p@R@@@@=q@\@G@z@(@~R@@@33@@@@@@@@Q@G@p@ff@p@ff@\@Q@p@@ff@\@
@ə@@p@@@R@
=@p@R@H@@  @(@(@
=@@
=@@
@@Q@ff@@
=@G@\@@=q@
=@H@ff@\)@=q@\)@\@{@ff@(@\)@@\@p@H@@@p@@H@H@H@H@R@  @
=@@H@H@@G@@@ۅ@ۅ@HA
R@=q@@R@љA
AQAA
=q@H@  @Q@(@ٙ@(@ƸR@θR@(@\@\A!@@G@ff@@H@
@@@\)@@ff@
@  @@=q@@G@@@@\)@
@
=@33@\)@@{@G@R@Q@@  @H@@@  @=q@p@
@@@
=@  @AQAAMGA_A@zAaA
A<AGApQA`AR=qALAJRAG\)AIAYAOAQGAYGA@QA<zA5AAAG@G@
=A  A	@=q@  @A=q@=qA@\)@(@@@33@r\@@@w@ff@
@I@+@{@e@ZH@p@l@w@ZH@R@ff@p@nR@p@@ffA\)AAeAGAB	(BE33BABBB#33BHB=BHBD=qBM\BoffBCB#B$
=BH\BQA{BffA
=ApA\)AHARA
A\A
B\B0BIzB8HBTB_B2GB$HBzBpB\B
B*\B)pBGBAzAzAͅAHA(A  AA
A(A\)AA  AAk
A^HAIA8A4A1A%A"=qAA(A"HA
HA\A
@@@@\)@Q@ڏ\@H@ff@@@\)@{@{@G@z@zA@pAAAAA(A7Az=qAȸRA
=AAA|QAAw
=AepAo
=AYAKA^{AGA6=qA%A(  A'
=AQAzAAA{A	pA@@G@=q@AQ@ۅ@Ǯ@@@@@  @  @
=@R@@p@@G@(@@@(@@G@@\@R@@H@\)@{@z@@p@@  @@33@\)@\@b\@33@G@p  @\(@Z=q@{@@{@p@\@H@!@@+@\@ff@7
=@\)@@ D5s@[@
=@{@fff@G@Q@\)@fff@l@e@hQ@b\@`@g
=@@@u@  @{@H@ff@w
=@@u@\)@u@
p@	@{@#
@33@@R@Q@3
@%@/\)@8@\)@R\@C
@NR@e@c
@8Q@E@=p@w@@@\@
@^R@@@XQ@@,@'
=@R\@]p@Z=q@dz@u@33@xQ@o\)@l(D!@e@xQ@z=q@ZH@>{@@G@@G@Mp@(@   @@9@E@e@2\@8@6ff@w@ff@l(@a@ZH@P@I@E@@H@\@@  @R\@S33@C
@W@\)@w
=@Z=q@2\@P  @G
=@HQ@p@Z=q@E@Mp?@R@%@P@3
@*=q@.R@G?
=???p?Ǯ?\)?\)?G?(??G?=q??\@	??޸R??G?
=?
=?=q?Q??z?(?Q?H?Q?R????z@@\)@   @,@(@,@c
@JH@=p@K@HQ@%@1@(?@  ?@?p?\)@@  @??p@Q@$z@\?R@
H@Z=q@@H@@#
@JH@@@Q?H@@Q@#
@\)@Q@#
@Fff@   @   @W@8@(Q?R??H@(@{@??R???  @{@
=q??Q??
=??=q?p?G?^R?s33?n{?=p?=p?G?k?33?
???{?\?=q?\)?H?
=??z?(??޸R??
?
=?Ǯ??{?33D	?aG?@z?\@z@0  @/\)@p@@@	?G?Q@z???\?Ǯ?G?p??
=?zH?^R?@?(?Q?Q@ ?
??(?˅??\)?ٙ?H@G?=q?ff?z@z?H?G?
=?z@G??????˅??{?У???&ff>\)?u>z?8Q?c
?(?333?z?5?333?5??&ff?(??G?.{?=p?ff?z??  ?Q@@?ff?  ?{??=q?n{?p?(@??(?@l?{@Q?\)?ff@R@(@,(@+@%@(@?z@?R@ff@33@
=?
@0@@=p@aG@=qA7@\(@?\)@w
=@aG@AG@8A
ff@\@@{@{@@z@ff@@@33@@@
=@\@@@@@z@  @\)@jH@b\@S33@g
=@w@@@@e@
@@nR@l@o\)@P@X@AG@P@W@Q@K@G@N{@XQ@[@P@L@G@l@fff@l(@c33@tz@e@s
@|@{@xQ@Q@@R@\@  @@H@@z@p@o\)@fff@xQ@G@\@@@Q@R@z@R@33@(@  @@
=@l@R@@  @p@{@p@\@޸R@
A @\)@@(@p@(@@p@G@Q@@@@  @(@A@AG@\)@z@@\@@ff@\)@@33@\)@@=q@\)@H@R@@33@@@G@z@=q@@H@@(@jH@mp@e@s
@hQ@o\)@mp@`@g
=@g@e@g
=@c33@ff@
=@aGCSs3@\@y@QAff@Q@L@Q@q@vff@l@jH@o\)@=q@@\)@NR@s
@g
=@]p@\@\@ZH@Z=q@U@[@W@P  @G
=@L@NR@]p@`@nR@R\@e@4z@0  @J=q@ZH@a@qG@X@Y@b\@s
@;@Q@<@,@0  @/\)@5@+@0  @{@ff@G?ٙ?R@
=q?Q?R@ ?33?H@
=q@33?
=??p?R?@G@@@?(@ff@\)@G@
?R?G@ @@#33??(@G?У@@#33@@@R@1G@>{@I@B\?=q@;@XQ@I@8@1G@   @*H@3
@=p@O\)@<(@G
=@Dz@B\@<@C
@C33@B\@=p@9@7@ZH@333@;@N{@3
@B\@0  @\@z@@
@33@\)@(@\@L(@@r\@@g@
=@j=q@c33@\@\@
@W
=@(@>R@g
=@H@
=@{@R@\)@@{@nR@
@33@@
=@{@
@
@@G@=q@tz@l@U@333@(?H@ff?ff@
@  @ @33@<(?H@
=@@&ff@l(@\)@7
=@p@@
@\@33@Fff@33@@z@R@@@@@\)@vff@<(@g@vff@ff@@33@fff@@=q@q@aG@.R@@U@7@s33@2\@J=q@+@U@`  @#33@~R@[@xQ@w@s
@(@  @=q@z@P  @@vff@C33@(@@@@ff@G@ff@@@|(@vff@h@QG@Z=q@[@a@j=q@a@6ff@hQ@k@u@<@L(@W@j=q@l(@B\@U@U@2\@Q@N{@U@]p@]p@XQ@L(@K@R\@:=q@[@5@8@@i@$z@e@*=q@,(@aG@(@N{@QG@C33@H@8Q@Q@,(?G@.{@5@AG@@%@,@9@7@333@*H@4z@4z@'
=@#33@#33?33@@#33@@"\@33@(@\)@{@   @'@
?@$z?@G
=@@L(@>{@&ff@?\)@(@?@
=@	?H??Q?
=??@  ?Ǯ?33?Tz?????p?z?Q?fff?aG?ff??E?=q?@ @\?
?\)?޸R@z?Q???
??ff?Ǯ?h?У?Ǯ?z?{?\)@@ ??ff?(?Q@33@z@
@#
@#33@(?33@"\@Q@:=q@H@8Q@#33@
p??O\)@@'
=@-p@0  @@!G@@E@(@!@{@R@@#33@@@?
=A5@
=@
=q@3
@C
?\@&ff@#
@7
=@?
@Fff@C
@C33@x@x@Q@
@@z@33@@tz@U@L@N{@#
@Q@,(@33@Y@{@u@U@{@@]p@@ٙ@Q@p@
@{@j=q@(@+@@   @	@:H@I@\@{@
=@6ff@H@\)@\)@@R@A@@@@@@@@A  A@GA   @Q@@R@H@33@(@H@@˅@ڏ\@\@@  @ۅ@Q@  @R@z@H@@@@(@Ӆ@\)@  @33@p@
@(@(@˅@@G@p@
@ƸR@\)@@ff@@@R@{@@@@\)@ff@@p@@  @@\)@.R@@@@@@z@>{@K@C
@u@k@s33@`@jH@u@hQ@W@NR@l(@i@{@J=q@=q@
=@
@@@@H@(@@  @Q@i@G@}p@@ff@G@
=@p@\@R@33@\@R@\)@=q@Å@G@R@\@ff@{@G@Q@@  A QA=GA8(A@QDiAW
=A33AffApA
=AzA33AApAAиRARA̸RAAA{AGA33AAAzAHAHAARAypAqAPAQA;
A(A(QA)A=qAA\)A33Ap@@=q@{@@Q@zA(@@\)@{@@R@ff@@{@@{@p@p@\@H@@o\)@s
@zH@\)@p@p@Q@k@Q@@@@|(@=q@{@\@p@H@@@aG@e@NR@@H@@\@@@@@A As33AABGB6B4(Ba\)Bt33BW
=B=(BHBAȀ\AffA\)A  A33A{A݅AřAAApAQAŮA\A
AzHAh(AApAQAZffAEABHA2{A-pA'33AzAA
ffA{@z@
=@p@H@
=@@=q@\)@@=q@z@ff@R@ff@G@\@{@ff@z@
=@Q@
@Q@@@H@33@l(@@}p@s33@G@H@H@(@@33@C
@=q@@
=@A
A  AA=qA#\)A1AO
A2\A%@w@B\@=p@)@#
@#33@.{@@ @$z@??@@@=q@=q??G?ff?p>?&ff?#
?
=?8Q???G?
?>G?\??ٙ???R??ٙ?Ǯ?z@
?=q@(@,@Q@ff@vff@w
=@A?
=@,(@\)@G@1?@  ?ff@@5@?@@
@33??Q?G?  ?=q?Q@B\@'
=@p@Y@(@0  @{@ZH@E@p@R@
p@{@#
@,@2\@E@]p@a@q@mp@x@fff@u@33@@@R@
=@=q@\)@{@s33@R\@xQ@R@@
@\@g
=@^{@8@&ff@'@'
=@!G@@@*=q@#33@\@R@Q@  @?(@@z@@@G@ ?R?p@	@@ff@Q@@z??(@33@ff@1G@NR@NR@_\)?H@-p@0@@  @\@   @(@@(@\@@@@2\@!G@
H@Q@G@@@@
@&ff@33@
=q@@\)?@(?\???(?
?Q?Q??{@
p@@?@ @   @   @
@@
?R@ @  @
@@@
p?z@(Q@\@>
@33@p@
=@R?@?G@@(@
=?{?G@
=?xQ@33?R@z@\)@\)?Y@
p@?G@#
@"\@@@)@@@(Q@/\)@+@:H@H@8Q@0@*H@:=q@<(@6ff@Fff@3
@=p@,@'@!@\)@@
=@
H@\@ff@@?@"\@G@@@33@@0@%@@
H?R?\)?=q?33????Q@
=?R@@\?33@Q@@
H@
p=L@  >B\@{@G?z@@=p@-p@@	@
H@@	@G@@z@   ?R@G@ff@z@Q@   @{@R@\?@?H?(?{??{????R??Q?z@   @\?R@   @33@
??R@@z@ff@
p@?p@@@@33@@@@,@@\)@@%@R@'
=@>R@\)@@ @Q@ ?  @z?33?
=@{?
=@\@@@z@@   ?{@R@'@%@(?@8@Q@P@dz@\(@\@y@q@e@\(@H@L@AG@7
=@/\)@R@*=q@
=@
=q@R@?{@!@
H@H@p@!G@,(@0@p@z@\)@=q@@Q@(@   @
=@!G@)@(Q@#33@@33@(@@
H@   ?(@   ?@@@(@@
=q@@@@p@333@6ff@/\)@7@&ff@C
@@?\)@B\@'
=@4z@#
@#33@\)@
=q@.R@.R@C33@I@2\@*H@(Q@R@*=q@,(@:=q@C33@>{@*=q@#33@(Q@@,(@\)????
??Q???{@@@z@@@ff?Q?@   ?G?H?
=?{?\@z@=q@(@p@+@,@#
@@Q@G@\@{@@@
=@\@@@z@\@(@z@@ff@%@z@@@=q?
=@\@ff@p@)@(?aG@&ff@9@3
@Fff@B\@]p@9@:H@7@   @(Q@+@(?G@"\@&ff@#
@@,@L@u@8Q@9@(@@G@33@ff@@
p@
H@:H@R@
=@z@R@
=?8Q@@%@!?s33@@(?@>R@@ff@{@@Q@
p@@(@@@ff@	?@\@z@!G@@@	@z@	@\@@H@6ff@.{@%@	@ff@{@	@\)@'
=@\@ff@   @\@\@z@   @G@   @@?R@\)@R@@p@@
H@@
=q@ff?Q@	@@@(@@33@33@\)@@Q@,(@Fff@Tz@Y@X@O\)@@@
H@
H@33@33@@z?H@   ?Q?z?p?
=8Q?=q@\?H?@@@ @ ?H@(???33?Q?Q@
?H?(?H?R?z?@z@@ff@@33@G@?33@z@R@=q@@@\)@   @\@@(@@6ff@NR@k@u@
=@XQ@c33@[@qG@g@ff@љ@
@A AR@z@
@33@@  @G
=@'
=@P@#
@!G@8@5@Z=q@@@33@zH@(@
=@33@@{@U@Tz@JH@P  @QG@333@ @!G@"\@$z@!G@7
=@>{@A@g
=@fff@  @z@Q@z@@\)@=q@
@\@@
@@z@@@@
=@  @@G@@=q@p@@
=@Q@  @@=q@{@u@33@AG@
@@~R@@@G@
=@\@@<@e@vff@L@@Q@z=q@hQ?
@I@#33@ff@A@b\@K@Fff@aG@3
@E@O\)@O\)@\@8@Q@L@(Q@l(@c33@(@qG@H@LAVH@0@8Q@J=qA (@P@C33@R?\@@{@)?@{<@?
=q@?\@ff@@=q??J=q@
=q@N{@=q?H@G@'?z@+@=q@(@!G?J=q@>u?8Q@!G??+=G@=q?@  ?@G@\@
=q@"\@R=
@%@{@Q=u>.{?G?@+@R@ @E?G@7@?Q@?޸R@.R?=q@?@'@@2\@AG@Fff@{@p?33@7
=?
=@,@*=q@*H@&ff?H@!G@@(@p@(@B\@5?R@z@@@
p@R?33@{@!G@ ?@???@Q?=q@@@{@$z@.R?z@3
@Z=q?@S
@\@9@G?Q@9?J=q@7@<(@+?333?G@!@(Q?L@?\)>\?@-p@)@2\?=q@@  @.{?=q@)@?xQ??c
?B\?@?@O\)@XQ?p?{@&ff@_\)?=q@zH@]p@?(@C
>z@1?@  @\)@R@L@*H?  @(Q@(Q@\@O\)@2\@Tz@S
?z@
@&ff@@@s
@g@7
=@;@r\?=q@ZH@@S
@{@i@33@H@e@Q@@33@r\@z@@u@33@J=q?
@j=q@H@(@j=q@L@(@n{@N{?0@8Q@{@H@Fff>Ǯ@
?@w
=@]p@z=q@Q@*H@H@{@@A@@=qA5AO33AzA#ALzAR=qA=GAg
AUAVRAdAn\ApAAffAQApAffAA
=A(AGAمApA{AzAzAAA
AnHAUAb=qAjHA}An{A}AAyGAIGADzA\A$zA4zAvRAAAtAzHAGAuBAAzRA{AARAA
AAqA^{AAYGA
ff@ffAQAHAbRAQGA?A	A*\A	AAR@AA)pA	pA
A
ffAz@ٙA!pA&RA*ffA
=A3\)AQA,APAXzAffA#
ARHAOA0z@z@޸RA  A  ARAAG@@
@@@A@@@{@33@@ȣ@@z@ff@Az@
=@
@z@ApAH@A'33@RAp@H@˅@@Q@G@  @@Q@h@G@(CU@@  @z@pB!@˅@p@(@33@p@H@{@=q@\@Q@@
@\@z@R@{@@@\@G@@(@G@
@@@@@H@@@@p@R@@33@\)@@33@J=q@33@:=q@(@E@ff@R@jH@@R\@ff@ff@=q@{@@@y@R@jH@G@
@@=q@@\@@@33@Q@@@@H@p@33@Q@@@\@]p@@@Q@
@@(@@@
@=q@
=@@33@@@@@p@ָR@@@@@@Q@@z@\@pD@\)@j=q@@@@@Q@u@@@s
@QF{@=q@w@33@=q@  @g
=@H@U@\)@@
=@@@@\@   ?p@l(@{?{?Q?G?@@{@Z=q@@p@\)@@p@@H@7@33@U@Q@P  @@Q@=q@\@@Q@(@G@(@B\@\@@G@G@=q@@@@  @@z@G@@{@(G@(@ƸR@\)@{@@33@
@R@p@@=q@=q@@У@p@@p@ff@Q@Q@@{@@
=@
=@l(@G@=q@@(@@@\@z@@Q@Q@}p@  @z@{@(@@@@@  @@@G@@H@ff@\)@
=@\@(@
@@Q@=q@  @
@z@@R@@\)@(@@@@@{@=q@R@z@@z@@@\)@R@H@
@=q@\@=q@@
=@@(@ff@@@@G@@\)@@s
@n{@u@y@w@w@H@H@@33@=q@  @@@{@@@@(@
@z@@G@33@\)@R@@G@@p@R@@
=@Q@33@@  @Q@qG@vff@33@tz@Y@{@  @w@@vff@q@q@hQ@k@l(@qG@e@o\)@tz@q@
@@@\)@ff@ff@{@@vff@y@s33@k@`@qG@H@zH@~{@tz@w@g
=@qG@@zH@l(@k@p  @l@(BBQ@r\@<(@|@x@Q@~R@h@^R@C33@c
@qG@K@C
@@7
=@8@C
@E@<@S33@P  @b\@zH@~R@Q@G@n{@kC#ff@fff@q@dz@r\@s33@Q@|@l@p  @S
@L(@K@X@a@aG@p@Vff@W@p  @:=q@:=q@Dz@R\@U@JH@B\@JH@c33@L(@P@Y@QG@QG@Q@H@@  @B\@P@G
=@8Q@>{@G@Q@HQ@7
=@333@)@[@S
@C33@K@E@@@333@7
=@,(@$z@!G@@#33@#
@.R@<@1@4z@9@;@2\@/\)@=p@`@E@O\)@HQ@P  @K@P@P@JH@<(@{@$z@{@@Q@!@&ff@0  @.{@-p@#33@2\@&ff@-p@1G@,(@-p@+@8Q@*H@-p@7
=@0  @0@,(@;@8@,@-p@   @(@*H@-p@"\@!G@&ff@-p@2\@,@$z@&ff@$z@ @!G@$z@*=q@*H@'@$z@\)@H@R@@\)@(@
=@1G@R@#
@@H@R@!@'@(@@!G@"\@@!G@   @=q@@(@"\@G@(@@#33@@+@&ff@"\@,(@,@@@
=@@@ff@33@Q@\@@33@@R@@
@\)@\@{@'@#
@+@(@*=q@p@"\@H@@\)@ff@@
D@@@R@\)@@\)@@ff@   @p@ @ @@3
@z@R@
=@Q@%@,@*=q@{@5@p@#33@H@$z@{@\@@@ff@@G@
p@\)@
p@(@R@\@=q@=q@@
H@z@@
?H??@z@\??R@z@Q@@{@\@ @@@@z@
=@R@'@$z@-p@33@	@
?z?\)?z?=q@z@  @@
=q@@Q@@@=q@{@@ff@?p???(?A??H?@\@z@	@@G?33?(??33??
=@{@@@R@+@Mp@p@e@z@7@@  @2\@H@{@.{@@@@G@(@Q@\?(@
H@@@
p??z@@
H@ff@Q?ff?  @(@ADF@2\@/\)@
p@@@{@H@,???Q?=q@33?33?p??z?
??ff?G?
??z?(??\??G?ff?p??ٙ?Q?޸R??????
=?=q?33?  ??G?޸R??
?\?{?p?  ?Q@!G?33?
=@
H@   @(@\)@\@@  @@??{?
=?\)???z?ff?˅?\)??=q??R@   ?
??У????\@fff?}p??33?{??Q??33??(??H???\?ff?Q?G???
=?  ??ff@
=@
=?ٙ?˅??G?p?ff???G???Q?{?=q?
???aG?{??
=?ff=\)?=q???
?R?  ?H?  ???H??  ???=q?=q?ff???\?{?z?  ?
=?(?(?G?33?G?
?{??z?\)??33?Q?????(??33??
D6??
??c
?{????{??  ?
?p?p?ff??G??H?33??z?ff?G?(??{?G?}p?^R?xQ?n{?\?u?fff?=qBf?&ff?k??G??ff?n{?zH?xQ?xQ?p?k?\?k?  ?p?ff???G????}p?G?u?  ?c
?zH?\?aG?}p?u?aG?xQ?W
=??\???z????ff?
?G?(??=q??u?ff?xQ???
?H??=q?\?=q?p?p?zH??u??fff?G?J=q?Y?}p?s33??ff???
?(?Q??\)?G@?(BB??H?(?
?У?
=??33?  ???Q??ff?  ?\?(??G???  ??R?{?33?33?(?(??
=??ff?p?R?
=?\)??{????  ?  ?ff???ff?}p??Q???p???R??(?ff??}p?  ?G??\??  ?ff?n{?u?
???ff?
??\)?p?J=q??zH?G?fff???}p?^R?k?aG?aG?s33???R?
=???
=???G??z?  ?  ?Q??z?z?ff?33??
??{?\??
?c
?aG?@  ?G?G?=p>\)?:H?G?:H?E?G?L?W
=?Y?xQ?c
?\(?Q?B\?Y?aG?}p?\(?Y?^R?\(?\(?p???\?zH?xQ?xQ?u?n{?G?\???
??\?k?  ?G?p?G??}p??{??33?z??\?R?ff?G?˅??33???ff?33??H?ff?(?
???p??˅?@g?H?G?R?z?  ?
=?=q@`  @k@?\)A]GC9:A*{A6=qA
ARBRAQA(B(A\)A.\AF=q@ZHA33A=BAC3DbAxz@RAw
AfRApA33@UC޸D@e@}p@]p@U@L@AA7
=@ZH@P  @(@O\)@Tz@P  @S
@^R@JH@W
=@H@QG@QG@JH@R\@H@I@\)@5@Fff@HQ@=q@G@Tz@E@E@@zH@Dz@~R@j=q@C33@B\@AG@<@C33@L(@HQ@DzALQ@L(@IAMG@Q@j=q@K@O\)@5@\@jH@Dz@g
=@G
=@0  @E@{@HQ@Q@?\)@Dz@>R@C33@Fff@IA@p  @AG@r\@J=q@b\BT
=@Dz@1@^RB	D{B0\ADBDH@3
B8RB@AMA\)@aGB=qAzA   @jH@z@@Y@vff@`  @l@ʏ\@c
@o\)@b\@w
=@s33@g@dz@a@\(@XQ@]p@R@XQ@]p@_\)@U@ZH@NR@P@a@Y@W@c33@]p@@n{@Vff@vffDdp @\@`@_\)@x@@dz@u@Y@W
=@W
=@
=@zH@n{C@R@W
=C`T{@hQ@g
=@Y@^R@\@_\)@\@^{@`@b\@[@P@X@W
=@S
@^R@UB@aG@b\@U@aG@R\@^{@
=@O\)A zA?B)BffA=qA
=ABJ(CzAkA$@Y@l(@lDC(\)@@j=q@\)@\@
@u@@@Mp@o\)@fff@p  @s
@u@xQ@s33@tz@q@qG@qG@p  @qG@s33@vff@qG@nR@mp@r\@q@0  A@:=q@4z@H@~{@@@\)@@@\)@G@p@@  @@Q@@@@p@\@L(@H@'@?\)@]p@aG@=q@@@n{@X@k@`@@ff@\)@x@P@Mp@hQ@p@|@u@w
=@Q@g@e@c
@XQ@@@E@E@@@6ff@0  @1@ @.{@#33@!@2\@*=q@0@dz@A@HQ@@H@{@H@pA=AVHAffA@p@ffBn33@\)Ao33B33Ag@dz@@8@ @:H@@{@A@@
=@h@mp@P@g@W@W@S
A\)A   A
@  @@ff@33@(@H@G@z@L(@aG@\@e@G
=@Dz@333@333@B\@@@@\)@A
H@QA@ffA@@H@
@@@\@u@@g@Fff@
@
=@{@z@zH@dz@<@9@Q@"\@@=q@(@;@'
=@H@\)@7@S
@Q@k@@s
@L(@E@@z@  @G@{@A%@
=AGA\)@H@
=@R@@
H?@  @$z@\)@{?{?Q@33?ٙ???@!G@#
@7@Y@Tz@@@qG@b\@R\@hQ@c
@J=q@Vff@~R@C
@Fff@AG@B\@JH@HQ@3
@.{@C
@*H@Q@ZH@B\@c33@2\?(@@\?@
=q?=q@
@??p@R@fff@Mp@NR@5@S33@.{@2\@'@(@ff?G?G???ff?\)@{??\@{@(@l@~R@p@Ӆ@p@AH@ٙ@ٙ@Q@z@p@R@p@z=qA6ffA\)@
=@  @Q@Q@@G@p@{@@g@H@(@@O\)@
@I@A@4z@aG@r\@(A
@z@H@@H@@k@^R@o\)@Y@S33@mp@QG@Tz@Fff@QG@i@n{@{@vff@(@G
=@R@@  @{@l@h@g
=@w@@@n{@ff@O\)AA5@@
@@jH@H@W@@  @4z@@  @`@]p@:H@J=q@n{@n{A@_\)@G@x@s33@w@z=q@X@0@A@hQ@^R@G@H@;@Y@
p@ff@@}p@@y@  @|(@aG@@I@E@333@E@h@@=q@`@3
@1G@z?p?33@
H@  @p@*=q@H@%@7@\(@@Z=q@aG@z@|(@33@p@@=q@}p@y@qG@\@0  @   @.{@*=q@H@+@@:=q@Q@P@X@U@>{@$z@'@'@'
=@0  @+@H@?\)@@@G
=@G
=@@!@z@
H@(@G@  @   @z@
@(@
?@@G@)@H@1@8@w
=@
=@Q@p@A3
@(@
A
A%G@33@ff@(@@ҏ\Az@@ @?33??(??˅?p?У?G?@Y@c33@@33@@z@G
=@\@(@A   @
=@H@R@R@z@Q@
=@=q@G@@\)@G@R@  @Q@
=@ff@i@a@AG@Q@AG@P  AmAk@ffA
=AHA\@@ffA
R@S
@\)@c
@H@
=@`@Az@{@B\@z@ff@ff@y@{@h@U@\@1G@(@>R@  @@A
GAj{@ffA<A3\)ApA9GAK33A333A(@pA#A=q@@R@7
=@\)@G@
=@@A@
@RA\)AA(A]@\)A/33@
@@y@X@C
@\@{@  @=q@p@\)@\)@@{@@U@XQ@W@jH@hQ@Y@2\@
=q@H?(@=q?(@\?G@33@!@\)@?=q@
p?\)@@R??Q?=q@@%@33@(@z@@@@(@*H@$z@{?  ?=q?
=@ @?z?=q???\)????@\@G@J=q@~R@b\@@@QG@\@5@qG@@أAS@@@@ff@fff@33A
=A@33@{@'
=@#
?z@7
=@?@(@"\@@<@%??@2\@\)@QG@@L(@=q@U@@h@
=@\@ff@p@xQ@_\)@e@\)@[@B\@7
=@@.{@z@ff@z@   @@Q@
=??@ @(?ff?У?(???Q?
?p?{??  ?R@G@+??(@
=q@
p?ٙ????@B\@JHA2HA"ff@
AI@@  @QAHAB\@Q@pA	A.=q@@A\@@g@E?Q?H?@33@z@?Q@@^{@g
=@u@<(?(?(??Q?\?  ?33@{@!@AG@C33@C33@NR@Tz@y@x@mp@@dz@xQ@k@i@@@  @j=q@,@#33@'@33@:H@R@>R@\(@Q@4z@+@  @3
@'
=@-p@R@#
@!@G@z@	@.{@I@H@>R@N{@G@7@(@0  @
@  @@   @  ?(@@
H@@  @
H@??@@@5@(@   @o\)@{@@\)AGA$@@H@u@5@n{@(Q@\)?@G?@   ??@,(@-p@Q@J=q@G?(@
p@(Q@@=q@=q@{@  @{@<@-p@*=q@7@w
=@C
@i@P  @@333@Vff@mp@@Dz@e@R\@%@Q@\)@
@w
=@@\)A
@l(@7
=@R@^{@@o\)@@P@@AG@%@%@"\@'@R@Q@@(@@   ?R?p@R\?@*=q@<(@_\)@U@JH@+@
=q@G@
H@5@u@Q@2\@=q@(@wAA{B GAC\)A\zAA_@Å@?@O\)@@@w@@  ?{@
=q?z?Ǯ@@A.ffAD(@
=@<(A"=q@{@\@G@R@wA{@33A9ApAAAAx  A1G@(@@5@#33@@@?H?{@?\)?ff???
=??@
?G@@   @_\)@P  @
=@<(@7
=@Q@@ff@\@ @  @_\)@p@@w@{@G@@R@ @
=q@.R@=q@Q@=q@AH@}p@s
@B\@%@AG@ @AcA$zAt(ARA£ApAGAW
=@<(?(A>{@G
=@$z@6ff@R?=q@ ?
@	@Tz@?pARHA
=@@
@{@@q@s33@dz@mp@{@K@*=q@/\)@A@(@\)?@?=q?޸R?˅???У?{?  ??G?ٙ?@ff@
H@G?\)?\)?(?@?R@@?G?33?33?G?޸R?\???  ?@
p?ff?@
??\)?H?z???
?@?33??@	@
@'
=@#33@w@@љ@@@ٙAR@QAA A
=AQAAHB#pBkzB;B\A\)AQ@(@@@=q@p@.R@\)@,@:H@I@P@k@=p@AR@p@ff@r\@ff@G@R@θR@p@(@r\@W@0@<(@y@}p@=q@L@@  @H@  @@{@`@$z@\)@=p@G@)@.{@h@K@@ @   ?@z??У??У?޸R?\??  ?\)?У?H?Q??\?=q?R@
@'@<@!@:=q@ZH@^{A)Ac
AffA(A@=q@@k@s
@@z?
??p@Q@
p@   @?z??33?
=@@@@tz@
p@hQ@tzAqpA@A   @33@@{A/33A3
=A4@@
A-p@A=q@@@#
@Fff@Y@%@@,(@(@R@7
=@1G@'@.{@,(@+@p@G
=@@ffA((@QA@z@\)@R@\)@ffA  @33@\@=q@ff@~{@=qA#@`@<@\@Tz@a@@pA
RArH@  @0AH@{@@@G@z@Q@@L(AARA)AG@{@xQ@@q@@z@8Q@>R@Vff@^R@@@@(@@{@p@z@@R@H@G@W
=@@Y@c
@
@hQ@eA@HA@  @@G@
@)@2\@p@ff@   @.{@p@@
p?p?@?
=@1G@,@S
@Dz@'@!@C33?z@*=q@0  @u@
@Q@@
@(AApA'33A((@  @H@z@G@Ajff@G@  @=q@@@A@g@
@AF{@@EAff@@@\@33?GAffAAmAz\@=qA^HADzAAffA@@@@{@QG@p  @^{@~{@JH@  ?(?@ff?R??\)?  ?@
@
=@
=q@ff@@@@@@
=@Q@R@ff?{?R??33?  ?  ??G?z?G?ff?@@33@G@G@\)@?(?z@G?\??(??p?{?Q??\?
=@33@ff@R@@8Q@;@9@#
@C33@G@@p@%@>R@XQ@/\)@B\@*H@^R@Fff@JH@JH@Tz@Q@i@@ffApA733A;33@
=@`@ȣA2=q@=qAiA\@=q@c33@+??Q?k?(?Q??(@{@2\@+@?
=@ @G@@*H@@G@  @\@@@(@(@G?\)?{?=q???H?  ?p@	@
H@@(Q@XQ@*H@L@:H@'
=@W@o\)@P@G
=@^R@=qA(@@{@^R@J=qA\)@|@z@G@(A
=@pA33A  @ff@H@QAӮA`(A2\A6HA<zAAA`A z@AA<AACA"HAaGA
=AA(A%pA
\A  A@@r\@vff@H@AAAYBB6RB&AӅA
=AfffA܏\AffAzAv\A5@H@(Ay@o\)@  @z@(A*ff@tz@{@ʏ\A.R@@ff@@
@QA\)AAHAAS33A£ApAB  A(BffApAffAHAQA?A\  ALzAA.ffAA AAA9pAA
{AE@@  A{AtARAA\Ac33A  @ffA	A@Ao
=A|  A
AA=qAAAǮAUAAz=qA\Ah(AGA
A{@@H@\)@a@O\)@z=q@AsA(AUGA
=A+
=APzA\@@??(?ff@
H@@@
=@{@S
@R@&ff@@  @333@@
@
=@@Q@@@	@   @@
=?p?H??=q??G?Q?=q?޸R?33?
?У?@?
@!G@,(@~{@q@J=q@nR@U@E@7@z@#
@   ?@@   ??@
H?
?У???Ǯ?У?H?
?p?(?\???=q?\??
?ff???{?{??\?H??\)?^R?Y?zH?xQ?u??p???\)@??33??@?  ?@@   @5@@@(Q@@*H@
H@@=q@"\@?Q?
=?  ?33??33?(?\)?޸R@Q??  @?@
=@@33@	@@R@Q@@!G@%@'@"\@\@\?p?˅?33?\)?\)?33?ٙ@?Q@\@@z@
=q@@5@>R@u@i@@G@߮A@A\A5A
=A<(AG@p@@@s
A
{@\)@(?R?
?=q?s33?=q?u?\)??(?
=?Q?޸R@<(@@dz@
=@(@(@Z=q@E@@33A  A@@
=@@P  @:=q@X@*=q@AG@G@@%@R@{@
@-p@
p@ff@ @%@,@'
=@B\@s33@=q@
H@  @$z@B\@(@'@
p@Q@
=@(@Q@@?H@ ??
?33?\)?Q?p??\)?  ?=q@z@+@!@8Q@\)@'@$z@%@:=q@:=q@9@=qAG@  @@G@z@hQ@`@@  @@@??ff?У@{@?\?
?33@1@|(@=q@
=@@\@<@QA%p@ᙚAPAk
AM@Aff@QA
=@\@{@z@~{@
@>{@C33@C33@8@4z@.{@'
=@R@p@!G@@Q@@Q@
@  @Q@R@@@\)@
=q@@\)@R??=q@@33@=q@
=@
H@G@@   @
?p?R?R@ ?@@ ?\)?p??@@\)@j=q@zH@C33@\)@x@H@33@qG@@|(@mp@g@z@<@(@aG@=q@
=@H@@8@\A\@Dz@dz@E@@
=@'@nR@>{@(AY@{@:=q@@#
@,(@+@2\@P@Q@n{@p  @E@#
@<@'@6ff@JH@g
=@h@\@l(@R\@Y@B\@W
=@aG@1@H@-p@JH@*H@8@*=q@R@Z=q@=p@.R@P  @.R@ff@B\@7
=@#
@@{@\)@@33@$z@\)@'@ff@@ @@
p@Q@@z@ ?@@(@p@*=q@'@
@333@0  @HQ@>R@O\)@qG@h@@o\)@=q@G@33@z@@hQ@&ff?33?\)??  ?G?33@z@4z@]p@}p@@qG@J=q@Z=q@c
@>{@Fff@1G@1G@B\@R@ff@{@@\@}p@l(@]p@W@@@@c33@e@|(@L@H@=p@NR@Dz@2\@_\)@Tz@H@:=q@C33@>R@7
=@r\@\(@(@y@W@@@+@1@=p@7@1@%@(Q@)@
=@@@
=@R@E@-p@,(@9@%@B\@Mp@H@@@\@
=@%@A?33@QA_
=A
@Q@33@pAPA=@{@\@@H@Q@{@@A@p@=qAA@i@0@A=q@@ffA@RAHAQ@@Af\@УA\@߮A@H@
@\)AD  AA
AuA@~R@
@z@R@r\@XQ@NR@c33@@L(@G
=@G@J=q@7@%@0  @,(@/\)@&ff@-p@8Q@4z@@@4z@1G@%@@#
@%@a@Q@W
=@.{@\)@@(@0  @(@3
@W
=@s33@y@q@[@L(@P  @_\)@j=q@dz@s33@Q@g
=@@@r\@@  @R@z@@{@@\)@@mp@vff@p  @nR@qG@z=q@r\@p@x@\)@  @z=q@w
=@G@|@s33@l(@g
=@\@X@U@^R@c33@l@`  @NR@[@Q@X@NR@Fff@R\@Tz@N{@HQ@C
@QG@B\@L@I@Fff@K@B\@HQ@C33@8@:=q@=p@2\@1G@8@.{@1@)@1G@%@0  @!@@(@@(Q@%@{@0  @$z@.R@)@.{@6ff@3
@-p@.{@+@1@333@E@E@E@JH@QG@Y@^R@Y@[@E@>R@<@333@@@6ff@.{@2\@0@3
@7
=@3
@8Q@H@7
=@B\@G
=@Fff@L(@L(@n{@Y@>R@;@jH@C33@;@5@4z@,@-p@L(@Q@O\)@<@.{@/\)@*=q@,@
=@
=@@Q???
=??H???=q?Q?G??ff?{?Q?\)??ff?z?ٙ?Q??\)?˅?ٙ?=q?H?Q??˅??
?˅?\??(?\?(??=q?{?У?=q?
=?У?ff?p??ff??=q?
=?
=?@
=q@Q@\)@33@AG@h@z=q@l@(?  ?У?\?Q@(Q?
=@@!@G@AG@pA@dz@7@A@_\)@5?z?
=????H?
??z?z?z?˅?
=?33?Q???????\)?z?Q?R?  ?z?(?H?Q?G?H?\)??p?\??=q??H?Q??\)??G?=q?=q?=q?ff???R?G?Q?
=?(??Q??R??(?Ǯ??Ǯ?˅?  ?Ǯ?R??˅?(?33?z?\)?=q???33?p?33?\??G???Q?ff?=q?{?˅?z?ff???
?Q?=q?{?R?G?G??Q?\?ff??ff?(?z?p?Q?H?Q?
=?
=??H??z?\)?ff?
?p??n{??\)?{???p???33?u??z?\???
=??Q?Q??
=??\)?\)?\)?zH?
??  ??\)?
??
?p?p??=q?R?G???Q??  ?
=?G?\)?\)?
??@p@  AzAX  @?\)AF=q@A@  A@Ay@@@P  @E@?޸R@   @
=q@	@{@(@@(@{@#
@Q@
=q?Q@@@ ?p?@\???У??(???G?p?ٙ?Q?ٙ?????˅?˅??33?@
??ff@33@G@???Q?G?
?ff??(?\)?
=?R?Q?Q?33?33??Q?Q??Q?z????ٙ?\)?Q???=q??Q?R??(?Q??  ?ff?\)?H???{?У?˅?33?Q?\)?@@@
H?p???H@@  @@?p??H@@Q@   @(@e@@,(@'@.{@8Q@#
@\)@5@Fff@6ff@1@,(@%@#33@@G@\)@#
@(@@'@H@%@.{@$z@%@{@H@@#33@H@@Q@\)@{@
=@@p@\)@
@@
=@
@@R@(@ @(?  @w
=?H@G???У?޸R@7@.R@?@ff?\)?G???޸R@5?33??Q@
@g
=@a@Q@z@XQ@~R@jH@>{@AG@@	@  @%@\)@  @H@@@k@B\@n{@\@dz@`@<@XQ@O\)@fff@zH@@@@{@ff@\)@G@Q@z@
@p@@@R@@\@{@  @@\)@\)@@R@(@qG@a@dz@nR@|@r\@p@fff@ZH@E@C33@8@\(@\)@=q@i@\)@O\)@XQ@I@s33@K@y@7@/\)@g
=@@s
@5@'@333@Fff@"\@ff@.{@,(@!G@B\@I@0@>{@E@xQ@@{@@ə@@G@  @@G@ָR@AAAffA&HA2{A'AHA+
AQA)A2{A6{Aff@߮A(A"RA{@zAp@{@A   A (@\)A@@  @(@\@G@ff@G@33@@(@33@@Q@b\@e@l@s33@l(@{@{@xQ@x@p@@  @
@@z@ff@@p@Q@@fff@S
@?\)@5@\)@Q@U>\)@C33@~{@_\)@J=q@z=q@\@&ff@\@*=q@_\)@W@H@H@@@u@  @ffA2{@@
@  @@G@  @@@
@
@Q@
=@@
=@=q@=q@  @p@R@x@^{@s
@p@@@@nR@@@@@~{@o\)@o\)@I@P  @S33@HQ@L@I@G@_\)@Tz@R\@QG@e@dz@\(@X@9@333@'@8Q@/\)@,@5@:=q@:=q@C33@HQ@%@+@?\)@P  @C
@JH@N{@Tz@c
@[@@  ?ff?z?33@@:H@
H@?
=?R??z?\??z?Ǯ@@33??ff?z?ٙ@@!@3
@R\@@C
@X@jH@@33@z@@
@@ff@@\)@=q@H@Q@@@@@@
=@@ff@33@H@H@@
=@@33@{@Q@Q@s33@\@(@J=q@w
=@u@H@`@X@S33@k@W@[@^R@Q@Q@R\@K@\)@}p@H@i@-p@(@JH@vff@qG@X@\(@[@K@8@1@5@TzA\@5@"\@33@/\)?@Q???  ?G?(@*H@0@0  @/\)@z@Fff@fff@vff@O\)@@@Q@ə@\)@\)@@  @@@=q@@=q@@z@Q@{@Q@=q@θR@Q@@ə@׮@=q@{@\@@
=@@zH@Q@r\@=q@=q@  @  @H@@Q@љ@@p@{@\)@{@=q@\)@
=@33@@@˅@ffA   @H@  @@@h@aG@W
=@N{@G@a@G
=@G
=@L@i@q@o\)@L(@JH@W
=@G@G@(@z=q@9@AG@E@|@G@
@,(@H@G@{@p@H@2\@*=q@4z@<(@Tz@jH@Z=q@\@p@p@@zA
=A
=A>HAA  A'\)AffA zAIAAA
=A  ApAHAo\)A}GAdQA33AffAmGAk\)AXzAUAZ=qA>RA2RA%A@QAD(AOAW
AZ=qA|(Az{A$A,A0QA3\)A<  A0QA6\A8A&\AGA0AGA\)A9pAQA@@\)@H@
@\@@=q@ff@=q@޸R@\)@@
=@  @\)@ٙ@33A@Q@@\@H@@=q@  @Mp@H@C
@R\@L@I@*H@,@0  @0@@@JH@C33@p  @p@@ڏ\@@AA3
AB=qA9GADAiATAtQAaANRA8@
=AA=q@@(@33@@@R@R@@@@\)@j=q@3
@I@Vff@dz@s33@\@E@,(@=p@\@H@k@@>{@s
@Q@p@#
@7@.R@7
=@5@.R@1G@/\)@!@H@4z@P  @8@ @(@@@$z@(@,(@/\)@K@W@I@@@%@@3
@:=q@-p@@ff@Q@)@??G?Q??\)??Q@ff@R@ff@%@\)@%@3
@HQ@q@q@{@
=@@Q@{@@RA
AAA'
=A$  AHA&HA(AGA(QAGA,zA33A@  @z@pA{Aff@@@@ᙚ@@\@@z@
@zH@tz@aG@p@QG@c
@c
@qG@{@@z@z@@fff@w@aG@G
=@W@_\)@_\)@U@C
@c
@1@B\@@|(@r\@z=q@@Vff@`  @NR@@  @_\)@A@Q@E@Dz@%@,(@?p??޸R?ff?{?G??(?H?H?p?@?
=?ff??ff?
=?
?ٙ@
=@Fff@\@>R@G@U@:=q@[@G@Fff@Dz@B\@C
@x@xQ@  @i@qG@{@|(@^{@ @!G@7@5@33@
@
?(?{@=q@	@*=q?@G@#33@@JH@=p@
=@@ @
=q@z@{@ff@'
=?
=@
=q?ٙ?Q@33??R?@G@
H@
=@  @{@ ?p@?\?{???@R?33@(Q@G?\?H?=q?
??  ?=q??ff??z?z?@???@{@ @ @@\)@@\)@2\@7@H@\@c33@fff@~R@r\@u@u@|@Q@@
@@z@H@@\)@@R@z@R@33@
=@w@\)@k@zH@\)@=q@@@(@\)@@x@@~R@nR@Fff@^{@QG@NR@g@c
@U@\@p@}p@e@\@=p@G@=q@C
@A@0  @,@-p@&ff@H@=q@@@z?p@
H??˅?ff?=q????(?G?\)?
=?=q?G??R?R?p?Q?\?\)???Q??Ǯ??(?\)??z?33?{@@=p@L@H@<@H@N{@\@dz@h@ff@@@@33@@@(@Q@G@\@(@
=@y@s33@@  @o\)@Fff@8@#33@\)@=q@@
=@{@G@(@  @  ??@\@\@R@?Q@
=q??{@???R@ @?Q@ ??\)?=q????z?@
=q@33?=q?(@ ??\??\?R???33?33?ff?  ?R?p??{?@Q@@@@G@@R@#
@.{@:H@XQ@^{@\@S33@zH@w@i@|@@@G@p@=q@G@(@@@@z@@
=@p@@@Q@
@G@@@r\@u@@@\)@  @@z@R@y@@@\)@\)@@@Q@,(@2\@.{@0@5@@XQ@e@]p@Fff@
p@@%@O\)@H@R@
p@Q@dz@[@,@e@L(@@@\?{@?
=???H?H?(??ff?z??ff?  ?G?33?z?H??
=?
=??\)??R@@C33@7
=@9@U@C
@O\)@j=q@a@(@=q@@  @@@@Q@S33@]p@O\)@<(@:H@,(@!G@,@Q@ @@Q@?
=???
=?
=?ٙ?z?ٙ?R@
=??33@@ff@#
@ff@333@-p@8@7
=@?\)@P@NR@AG@2\@@R@p@@@@Q@%@ @(@'
=@#33@>R@G@g@33@a@@Fff@ə@6ff@"\@6ff@@Q@-p@nR@}p@\@L@G
=@:=q@@%@(@6ff@^{@N{@L(@Z=q@7@#
@H@@&ff@Mp@b\@hQ@{@\)@@\)@G@Q@@}p@Dz@0@W
=@@/\)@G@@@	@@@	?Q?
?H?  ?33@ ?Q@?Q?@
H?H@R?{?
?\)@ ?H@?z?z?\)??z@	@@
=q@z@,(@@
p?R@
=q@
=?H@
H@33@ff@N{?R?Q@G?H?Q?\)??G?G?Ǯ?G?
?  ?  ?(@??z?(?{@   @5@2\@"\?R?˅?p@  @z@?R?ff?(?\)?z??@@ @
p??@ ?ff?\)@@Q@G@@@
?(@??@'
=@33@@?Q?  ??Q???33?z??33??\?  ?  ?33?\)??
?z???
=@?H?33??
=???@?@(@@(Q@Y@Dz@u@:H@B\@J=q@\)???{???{?G?(@@"\@G@@ff@;@@	?@*H@R\@6ff@?(?Q?ff@#33@@ff???=q?  ?
??  ?z?ff??=q?(?=q???(?=q?\?\)?\)?  ??
??
?˅?
?p?H@Q@@	@@3
@'
=@9@?\)@E@{@H@???
=?(@	?Ǯ??ff@c33@@  @"\@`@@@\)@Å@{@@k@|@(A	p@?޸R?\)?k?p??Tz?s33?}p?u?n{?H?  ?}p?}p?
?s33?  ??Tz?B\?W
=?33??
=?˅???  ?H?ff?{??=q??p?{?
=?G?{?H??33?\?(??(?H?(?ff?H??Q?\)??Q?{?ff?(?  ?33@#
@33?R@@  ??p?@Q@
?@G@@7
=@aG@Vff@r\@mp@p@@*H@7
=@?\)?
?\)@	@$z@Fff@5@1@@=q?=q@@333@P@H@z@jH@aG@'@@ff@4z@8Q?
=?=q?H?}p?\(?J=q?B\?aG?k?u?aG?O\)?ff?u?\?fff?  ??Q?(?
?33@33@p@&ff@xQ@33@~R@^{@3
@=q@4z@=q@\?H?\)?33???=q??Ǯ??33@,(@@@
=@1@7@$z@3
@   @@\@W
=@  A@G@  @l(@l@
@
=@@K@@
=@Fff@U@Mp@ZH@:H@I@Y@\)@H@Y@@=q@@
=@Y@@nR@=q@=q@=q@p@_\)@A(@\@Q@<@*=q@@@ə@p@o\)@Fff@\)@k@HQ@5@:H@{@@!G@\)@)@\)@@  @C33@)@P@b\@@e@~R@`@Y@9@I@8@#33@-p@+@   @R@,(@!@R@@0  @Vff@w
=@,(@
@,@Tz@g@|@|(@xQ@u@@`@z=q@w@ff@
=A  @@(@
@\)@=q@fff@AR{AAEA>{A#A
=AAMpAhA3
=AqpA_33Ag33A  @
=@ff@33@b\@Q@6ff@NR@G
=@Z=q@C33@\(@B\@q@l@
=@xQ@33@p@z@ff@AA.R@Q@@g@@ٙ@ffA@(A*HA*H@w
=@p@b\@@@@*H@ƸR@@{@p  @Fff@C33@7@1@@4z@1@7@7
=@0@-p@(@@p@Y@@\)@@w@q@Q@\@
A
@H@\)@3
@@y@(@A)GA@=qA@yA
AAAH@{A<A,QA
A%A	@ff@(@^{A	AO
=A#33ApA&HA.ffANffAffADA3
=A\AvHAUGA@A @\)A?
=@GAHApApA   A'@@?
=?\(??H?  ?Q@A?\)?p?@@g
=@@R@@R@A;\)@C
@  @
@@L@@@@@@nR@@@AG@>{@?\)@R@:=q@}p@tz@9@P  @'
=@C
@R\@K@5@X@?\)@#
@dz@G@H@\@@@z@
=@
@GA @
=@ff@k@@0@@:=q@@K@ۅ@E@@@=q@=q@@@AQA,@AAQAGAK
=AA:ffA/
A4QA4(@A5@RAA@QA!AABHAHAF=qB(A:=qA
=A	G@\@ff@hQ@ @5@   @
@ @8@{A(@a@U@7
=@(@p@@@!G@\)@H@\@?z@33?R@?=q?33?{?Q???{??\)?z?33??\)???
=?\??33??z@ ?G???33?˅?
=?{?33?Q?33?  ?G?  ?z??У?ff?z?p@z?p?
?@ff@N{@  AG@@@@@@}p@@  @#33@l(@p@=q@RA"=q@\)A\)A1A  A$Q@H@  @
A
A[
A<(@\)@Q@b\@'
=@
H?G?{?@   @@
p@@ ??{?ٙ?@\@
=?p?У@
p@{@#33@$z@G?(?
=?
=?Q?\?У?޸R?  ?У????У?H?Q?\)???z?
=?Q?  ???(?R?(?
=?У??\?p?\)??\)?@?\?(?
=?@
p?z@<(?R@O\)@Q@u@Q@@{@C
@\)@H@@Ӆ@\@
=@RApAYAMAz@nR@xQ@b\@S
@xQ@2\@Q@R@
=??@)@AG@J=q@K@QG@E@C33@<@:H@0  @)@)@!@R@
@\@@	?
=?G??Q??\?ff?R?{?33?(?p??@33@z?R??(@\@G@
=?z?R????  ?  ?33?G?ff??33?ff??\?H@@2\@{@  ?H??@
=@lA@AA@@\)@`@@  @^{@xQ@ӅA
@\A&ffA
=AA.ffAG33A&ffAeAff@ff@\@@
=@@@G@qG@G@NR@,(@-p@%@:=q@8@5@333@<(@1G@6ff@1@$z@*H@(@z@@33@33@@H@{@@\@!@#
@K@L@)@@0@&ff@'@%@#33@,@'@(Q@)@0@%@a@8Q@>{@?\)@4z@<(@:H@0@
=@ff@{@%@#33@.R@#33@"\@,(@\)@(A
=q@ָR@(@z@Å@\)@~{@{@Af=qAZHA
@{@\A33A@Q?
=@1G@HAV\A`@A
=A
AT(@p@@\@\)@A@@=q@^{@W
=@@@+@\)@.{@@\)@@R@Q@33??  ?z?
=?33??Q?{??@G??(?\)?
?Q????H?33?
@G??H?{?=q??p?G?z???Q?G?p?  ?z?ٙ?{??z?R?=q????\??H?Q?@(@33@%@@  A@Q@\)?p@(@
=@ffA(@r\B\
=B2{AAS\)@5@@@H@=p@)@(@%@*H@(@?H?Q??{???޸R??\?ٙ?Q?33?У??Ǯ???33?H??\?z?p??
=?R?=q?(?Q???
??\?G?
??(???Ǯ?  ??(??z?\)?ٙ??\)???Q?˅?˅?{?33??p?  ??p???@Q@c33@@@\)@?{AmB6=qAA(zA|AffAA
=A=qA1G@h@@
=@pA33A1GAEA=qA<@
@s
@n{@(@B\@R\@S
@%@"\@@z@
@@{@@"\@@9@E@g
=@`  @?\)@S33@J=q@S
@a@QG@Vff@U@Fff@'@#33@,@,@&ff@+@%@(Q@\)@H@@@=q@=q@p@ @@ff@
@@\)@(@@=q@@@
=@Q@
p@{@@
=q@  @G@{@
@33@R@@R@@U@ff@  @A@!G@  A4zA@:=q@xAS@j=q@=q@@nR@
@Y@/\)??G?ff?
=@?Q?R@\?Q?G???\?R?G??z???
=?33??  ?޸R??ff??(?R@	@@(@
H@@(@  @Q@@@=q@33@
=@Q@\@
=@p@@
=@=q@\)@'@   @%@"\@@H@   @@&ff@\)@R@(@G@@@G@33@R@z@@{@G@Q@@@@@z@	@
p@@{@@z@ff@@
=@@@@
=q@
H@ @z@@Q@@
p@0@2\@
=q@@{@	@@ff@33@@AG@z@$z@ @@@@\)@	@(@@@
H@
H@z@@@(@?R@   @@
H@(@{@33@   ?R@
p@ ??=q?H???@ ?H?
?ff?ff?33?\??ٙ?G??G?Q?Q??33??(?
=?\)??ff?@
?@33?33@@{?z?H@@'@
H@R@?p?G@
=@(?=q@@@$z?@ff@???H??ff?
=?G?????
??{?
=?{?\)???\??p??\)?z?33?{??ff?
??R?{?ff?
=?\?\)?ff??33?H?  ?Q?
=??{?
=?33?H?33???z?H?\)??
=?z?=q?33??(???33?H??=q?H??=q??G??ff?ff?R??\)?p?G???G?
=?
?\?
?33?p?G??  ?z?\?G???????z?
@Q?\??33?  ?{?\)?s33?\?ff??G??u?Q?{?G???G??33??\?\?\)?
?G???????
=?33?Q?{?\)???H?\)??{?????z??\)?˅?z?\?R?R?H???
=???  @!@"\@P  @E@<(@=q?
???  ???Q?
=?(?zH?z?У??z?{?ff?
=????p?@@   @@*H@E@6ff@<@@33@?˅?
=?\)?=q?z?33?У@
=q@R@
??p?=q?33@   @\)@@@9@   @8Q@@  @U@w@fff@qG@h@G@/\)@Q@@{@ff@
p@ff?
=??\?
?33?=q@Q@Q@
p@@@ @
@  @G@\@@{@%@H@B\@'
=@B\@Mp@I@XQ@s33@g
=@p@@fff@H@@U@<@QG@b\@Q@\)@@@p  @AA@@{AAAA6ff@ff@
=@@\@(@@|@XQ@C
@S33@HQ@
@z@@A @R@@@@\(@
=@Q@NR@k@\)@@(@@~{@_\)@k@N{@@  @1@333@B\@6ff@Dz@E@G@C33@,@.R@(@@
@
=@=q@Q@\@=q@(@-p@@(Q@@B\@@@
@!G@#
@(@?\)@*=q@Q@@{@
@!G@
@*H@C
@1@@@"\@p@@?@
@%@(@@333@.R@
=q@{@S
@R\@%@\@@
=q@
=@
=@R??@Q@ @!G@=p@@ @"\@"\@ff??@@@
@%@Mp@Z=q@g@g
=@vff@\(@^{@q@:H@\(@A@QG@:=q@>R@2\@0  @NR@/\)@$z@R@%@\)@@
p@R@?R?@z@
=@
=?\)?p@   ?p@
?33?H?R?Q??????Q?G?
=??=q??
=?R@	@"\@7@,(@:=q@*=q@)@\)@@z@'@>R@!G@(Q@-p@8Q@QG@.R@@G@!@{?У@  @
=@%@(@\)@
=@@@
p@@=p@-p@:=q@(@G
=@+@Tz@}p@}p@z@H@@e@mp@S
@G
=@AG@Dz@C33@7
=@1G@/\)@6ff@0@@(@0@&ff@(Q@)@&ff@#
@ @"\@(@!G@'
=@!@#33@@ff@@\)@@z@z@z@???(@@z@?Q@G?Q@@33@@"\@(Q@<(@W@@e@Q@G@H@+@:H@s33@0  @z@
p@@(@z@\@G@33@@  @
=@1@7@6ff@L(@JH@Mp@Dz@Fff@Z=q@S33@`@X@_\)@Y@O\)@aG@E@L@@@6ff@333@.{@*H@*=q@(@'
=@*H@\)@=q@*=q@)@(Q@*H@R@&ff@{@@@@@\@
@(@@(@R@$z@!G@H@@\)@ff@=q@ff@
=@ff@@(@33@@
@  @
@@G@@\@G@@G@R@
p@ff@	@  @@R@H@
H@
p@ff@Q?(?@@ @?H@@ @@?(@\@ @
=@
=@ @
@@   @33@
H@@\@
=@ff@@!G@@@@Q@\)@R@@"\@@@R@@
H@
@
=q@@   @@   ?޸R?  ?
=?\)@Q?p@G?z?H???
=?p?@   ??{?
?У?33?
=??˅?p??p?ff?
?R?
?z?G?(??33????\)???\?=q?Q?˅??G??Q?\)??ff???(@?G?˅?У?(?  ??  ?\)?Q?{?(???Q?{?ff?R?\?H?
=?\?H?H??=q??xQ?fff?  ?G?  ?G?????Q?(?33?\??(??ff?z?  ??{??  ??z??R?(?=q?
=?G?ff??z??z??(?G?
=?  @{?G??޸R?ff???p??s33?ff?=q?
=?\(?c
?Y?Tz?^R?Q?c
?Q??\?H??z?=q??{?R?p???\?{@ff???ff?H?Q?R?
=???{?
=??
=?  ??
??G??G?Q?У?H?33?(?\)?ff???H?  ?\)?z??R??p?\??s33??k??n{?h?aG?\(?k?h?E?E?=q?G?R??
?33??z???ff?\)?(?(?
?G?G?\?R?G??p?
?s33?fff??G?
=?
=@)??Q?\)?z@.{@s33@u@p  @L(@@@6ff@&ff@ @'@AG@?ٙ?{@G?{@$z@(Q?z??޸R@$z@!G@\)@
@{@@"\@\)@33@@Q@33@??(?(??z?33?z?
=?@\?Q@\@   ?33@ ???\)?H??ff?G?@G??
=@?(?ٙ?{??{?޸R?=q?
=?Q??  ??G??\??z??
=??Q?\?{?  ?(?@33?33?p?@33@#
@!G@ff?H@@^R@I@Mp@A@6ff@G
=@Y@1G?(@	@H@'@$z@  @
@/\)@@*=q@H@'
=@$z@e@5@.R@333@7@2\@K@[@H@{@\@@%@O\)@P  @dz@@h@~R@<@4z@?\)@%@z@XQ@B\@@5@*H@\)@!G@4z@@R@*=q@@(@+@?Q@R@G@(@{@	@z@@R@@@7@p@@=q@0@@??
=?У?
=?޸R?=q?
?
=?p@@'@>R@{@@jH@`  @Vff@L(@@  @8Q@5@{@@Q@E@.{@0  @4z@#
@@@\@\?(@,@.{@`@mp@a@[@c
@S
@O\)@L(@?\)@=p@1G@2\@6ff@7@7@(Q@0@   @9@7
=@,(@4z@)@>{@7
=@0  @*=q@,(@0@!G@*=q@'
=@{@.{@p@R@{@R@{@
=q?(?(?ff?\)?z??=q?  ???Q???p?Ǯ??G??(?(?(??Ǯ?z?=q?Ǯ?ff?\?
??޸R??(?Ǯ?(?(@,@%@,@@ @   @@   ?\?z??
?˅?У?(?
=?\)?33?ff??
?\)?G?33?R??(?  ?˅??=q?Ǯ?  ??\?
=?
?\?  ?33?У?H?{?\?˅?˅?R??Ǯ?
=?
=?@??У?z??
=??(??G??У??
?
??  ??Q?ٙ?У@?
=?z?z?=q?z?=q?
=???{???(?p??z@@
=@  ?H@@:=q@
=@:H@_\)@@@u@Q@H@=q@R\@w
=@@{@U@JH@$z@@333@(@
=q@
H??{??z@G@ ?@@ff?
=?p?p@ ?33???Q?\)?H?=q@@(?  ?=q?H?H@??ٙ?Q??\)?ff?33?ff???p?\)?=q?\?z?
=?\??G?{?
?ff??p?33?  ?33?@G?ff@@??\)?޸R??H???33??p?
=@
H@\)??ff?R@@JH@G@\)@
p@
=@{@[@R@#
@@  @.R@p@z@p?H?\@???@33@#33@@
=@z@@@R@@\)@	@
p@@(@
=q@
p@@@@@
?R@??Q??
=@ff@?p?=q?=q?\)?p?(?  ?{?{@\@ @G@@\@z@\)@
@@z@
H@\)@"\@5@*=q@{@@z@!G@	@(@"\@'@#33@?H@	@@@@@
p@@
=@$z@
=@!@\)@=q@>{@\)@{@\@z@
p@33@?p@z@\)@@#33@@@?R?{@Q@?@?????@
@@33?p@?R??{??  ?(?H???33?(?{?
=??Ǯ?ff?\)?
?
?H??z?H?Q????(?˅??ff??z?p?R?
?
?@33?H?@  @   ??˅?ff?????˅?z?\)?@(@(@Q@\)@,@=p@HA-AzA(@33@n{@  @$z@#
@=q@@??ff?p???{?Q?33?33@
=@
=@33@
p@33@H@@(@@ @
H@R@
=q?33?(???{???޸R?  ?33?@   ???\?Q?Q?
??R?H??
?  ??Q??  ?=q?˅?޸R?G?Ǯ@ff?@?@(@2\@ff@Vff@
=@#33@6ff@ @Q@?(@??
=@
=q?ٙ??
=?\@   ?33@	@{@Q@G@(@@G@333@.{@
p@@*=q?
=@@#
@Fff@H@$z@
H@@-p@3
@AG@H@\)@H@@!G@?33?@33?p@=q@33@
=q@<@0@-p@'@p@/\)@(@!G@$z@'@(@H@R@	?=q?\)?G?{?{?  ?@ff@@R@
p@ff?33?@ ?R@
@G@\??Q??H??\?޸R?@   @
?Q@@@@@@@=q@ff@{@
=@=q@@
H@G@{@"\@C
@R\@1@H@C
@g
=@H@33@=q@@  @\@=q@У@w
=@8@
@@@1@p@!G@@:=q@*=q@<(@XQ@#33@(@(@@@@	@@z@ff@	@ @  @
=q@   @33@@	?R@z@z?@@ @ @ff@33@ @ @@ @
?@ ?R?p@	?R?@z@   @33@G@@
=@
=@.R@	@ff@H@R@p@2\@2\@S
?(@\@@\)@
p?=q?33@z?(@\@@
=@@\@@@z@\)@z?p@G?Q?G?{??p?=q@G@@@ff@ff@
@\)@@@!@#
@'@8Q@>R@9@.{@*H@&ff@(@
=@@(@p@Q@H@@
=@33@R@Q@z@?@ ?R?(?(?Q??z??\)??Q?{?(??H?(???z?=q??G??  ?У?\)?ff?\?p?\?  ?R?У?Ǯ?z??޸R??p?G???33@   @ff?
=?ٙ?˅??=q?\?У?{?(??p?R?p?\?ff?z?@  @
H@33@$z@*H@ @"\@'
=@(@{@   @@@\)@
=@@R@@@
=@p@ff@
=@R@ @{@
=q@  @@@@z@@@@\?R?z??z?Q????33?z??(???\?\)?  ??{??(?У?\?=q?\)??ff??˅?  ?
=?p?z??˅?p?G?33??H??\?\)?У@
p@ff@Q@&ff@333@33@@\@@
p@R??  ?8Q?  ?c
?xQ?u?G???z?z?Q??
=?\)?(?  ?  ?33??(?=q?p??
?
?\)??=q?33?R?Ǯ?=q?\)?33?
?(?p?Ǯ?(?У??Ǯ?
=??ff?(?{?Q?33?\)?Q?(?zH?=q?\??\?=q??Q?^R?O\)?u?\(?G?W
=?O\)?E?xQ?Q?h???zH??\?\(?u?G?8Q?E?z?.{?O\)?O\)?^R?k?Q?Ǯ?Q?p@@"\@z?H??z@(@
?{?Ǯ?z??H?ٙ?z???У?@
=@(@'
=@'
=@,@%@{@
??@
p@@33@@\)@@
p@G?Q?(@   ?p@Q@@\@R@	@@
=q@
@\)@33@
H@\)?R?
=??R?R??\)?H?
?
=?У?z??
=?(?(?p??  ??\)??  ?s33?u?}p?\(?ff?G?Q?c
?h?33?p?R?E?fff?c
?ff?{?ff?z??
?R@
@33@H@@  @@@   @8@@%@G@z@G?
@
?=q@*=q@@
=@Q@  @@ @
p@33@R?H@Q@33?@
@{@@
@
=@z?p@33@ff@Q@G@ @Q@
?(?R@G@@
=@(@@
?\)?
?ٙ?G?33?  ?\?(?{??{????Q?33@z@Q?  @@Q??  ?@ff?R?
=??ff?G????R@@7
=@6ff@NR@+@L@Q@%@\(@G@@@R\@/\)@@?\)@
=@)@QG@!@3
@J=q?z?(?H?33@@,@4z@9@-p@(@@@#
@"\@z@@(@
=q?@ ?
=@?
@@
=@=q@0  @5@A@8@4z@*=q@&ff@ff@Q@@\?R?H?@?H?=q??=q?z@
=q@   @@@H@@@@p@H@#33@,(@@@
=q?R@G@
=q@@
=q?p?R?R?{?Q?޸R?????\)??z?@@z@
=@@  @@@@
@z@@
p@(@
=?R@z@G?(@z@   @XQ@2\@NR@/\)@/\)@+@4z@5@l(@+@333@R\@QG@E@5@R@-p@S33@p@ZH@Dz@6ff@@@@	?{??
@G??z?  ?\?(?{?\?@@ff??@ @?R@z??ٙ?(?H?@
H@ @\)@1@\)@(?p??33?ٙ???33?
?xQ??ff??=q??\?\)?G??R???33?G?ff?ٙ?33????p?Q?@{@\??  ?ff?R@@.R@=p@1G@HQ@=q@?(?(@@?H@z@ ?p?ٙ?\)@   @&ff@ff@@\@/\)@5@@\?@ff?G@???@??G??\)?\???{?p?˅?H?Ǯ?G?޸R@\)@@
H?ff?z?=q?n{?s33??  ???ff?ff?(?{?z?\)?z??\?n{???z?\????{?Ǯ?Q?z???G??\)?
=??p@@@@
=@@1@@@  @mp@qG@x@p@q@Mp@Y@U@(@#
@@,@&ff@R@@1?@33???\?@   @3
@2\@,(@Q?p@*H@\)@!G@p@=q@@@R@@Q@\)@R@
=??=q??  ?  ??G?=q?=q??p?  ?\?
?
=?ff??H??ff?ff??{?ff?zH?  ?\?G?
?xQ?}p?
=@H?R??
=?(???z?H@\)@\)@1@<(@P@a@w@l@
@ff@R@Q@H@@o\)@0@@@(@
@@
=@\@S
@'@'
=@#33@`  @u@@@>R@'
=@\@R@7@$z@-p@NR@0  @:=q@Q@\)@\)@
p@{@p@*=q@5@.R@&ff@@=q@{@@Q??H?{?  ??{??H??޸R?У?
=??˅?R?H??H???{?ff?{?\)?Q?33?\)?G?=q?R?
=??{?@
@H@)@[@dz@L(@U@8Q@!@#
@=q@,(@@@H@p@HQ@g
=@2\@,(@$z@"\@0@1@:=q@J=q@@  @=p@%@,@;@?\)@7
=@7
=@E@\(@Z=q@Y@4z@1@8Q@@  @'
=@1G@0  @AG@P@7
=@P  @c33@U@p  @@^{@w@H@z@  @zH@nR@Tz@dz@o\)@ZH@p  @l@Fff@C33@P@K@HQ@9@5@"\@(@1G@%@,@'
=@   @<(@?z?Q?p@
@	?=q?  ??H???@
=@Q@#
@%@.R@@@I@Y@@33@Q@G@H@@=q@{@ᙚ@z@33@ffA
ffApA4(A\)A
@\@p@A\)@@  @\@{@{@
=@G@@@@\@X@@@tz@fff@Vff@@}p@ff@nR@@|(@<@R\@a@s33@k@nR@qG@qG@r\@r\@;@W@dz@w@\@Vff@AG@=p@L(@HQ@.R@?\)@*H@4zAH@3
@@@%@@33@
H@@=q@
?  @7
=@Fff@B\@x@Q@@@(@@@ff@\)@A@(@@H@R@\)@G@A-A9A33@\)AA
AAIAAhzA8QA
@@=q@@A&=q@
@@z@@@@=q@ff@jH@c33@
@ff@z@n{@@x@Q@33@
=@ff@H@G@
@Tz@X@Q@dz@^R@W@:=q@P@O\)@h@L@#33@*H@@   @ff@:H@@!@?p?@z@H@0  @
=q@@7@(@U@a@e@@Q@p@u@G@33@(@p@{@@޸R@@(@33@@33@@@Q@
@\)@H@p@AzA{A&{A
=q@@@@@@p@\)@@@
@
@@\@{@@g@aG@z@z@}p@^R@<@1G@,(@=p@(@#33@p@(@%@)@1@,@.{@7
=@1G@:=q@K@0  @*H@'@.R@,@@@Dz@9@;@Fff@B\@+@R@!@!G@H@Q@@?\)?Q?Q@
p@@z@	@@
@@(@\)@{@@@
@@
@R@@z@{@?p@z@	@{@@ff@  @!@\@   @H@@`  @*H@)@%@<(@G
=@-p@g@A@@  @?\)@333@.R@"\@!@{@@
=@(@z@
p@\)@33@
=@  @@R@G@\@=q@@p@@@G@@33@33@@@#33@@(@
H@   @{@G@@G@G@
=q@z@z@u@33@   ?(?ff@
=@\@'@@@
=q@
=q@
=q@A+@  @Q@	?@33@\@  ?H?@33@z@'
=@&ff@@(?33@
=@G@G@Q@@H@@R@(Q@-p@E@G@S33@g
=@N{@aG@h@U@P@7
=@<(@#33@_\)@O\)@NR@S33@a@XQ@E@E@0@,@/\)@8@5@-p@*=q@@
H@	@Q@
p@z@z@
=q@@
=@@\?\)?\)?Q?=q?=q?=q?\)?(?=q???z?У??=q?ff??=q?˅?(?{?p????Q?  ?=q??Q?G??\)???33?R?33?z?
=?Q?\)?Ǯ?{??@@  A
@'
=@$z@333@-p@2\@%@&ff@3
@,@(@n{@^{@QG@c
@hQ@6ff@1G@8Q@,(@H@Q@\(@e@NR@Z=q@:H@tz@Fff@r\@y@@  @C
@]p@J=q@A@Fff@HQ@U@R\@J=q@=p@8@E@>R@1G@+@7
=@3
@(@'@$z@%@)@"\@
p@@{@Q@Q@
=??@@ ?Q?z@\?Q@
=@@@@ff@33@33@\)?\@#
@7@&ff@(@{@!G@'@R\@w@H@zH@c33@|@jH@qG@@@@@@G@33@p@33Aff@p@33A
G@\@ҏ\A@陚@@R@R@H@ff@ȣ@
=@  @=q@33@Q@@(@p@Q@=q@@{@{@z@Q@}p@(@~{@\)@o\)@s33@o\)@@xQ@XQ@S
@G@JH@AG@K@a@j=q@
@QG@7@333@C
@B\@QG@<@8@0@)@/\)@@@E@Mp@QG@@*H@%@$z@
=@\)@8Q@@zH@G@R\@5@(Q@@@G@p@
p@33@\@4z@*=q@8@9@x@mp@\)@@33@{@
AA1GA(Ag33AC33AA
RAzA  @@ff@\)@=q@{@@(@@أ@@\)@  @@z@@ff@\)@ڏ\@{@@@G@\)@޸R@@  @\)@
@@\@  @Q@{@  @@@G@@@
=@@@@n{@p  @r\@H@33@
@@33@@@@  @(@(@=q@w
=@@Q@˅@@@zAz@{@@@=q@@g
=@o\)@n{@p@hQ@ff@H@=q@@޸R@p@  @(@\@QA@@G@@R@\@Q@@  @  AffA=A
A-A!A  Ap@p@G@A @@ʏ\A33@AA1@@@@׮@@R@@@љ@@A@(A@(@׮@\)@ָR@@\)@G@\@@
@ff@p@@p@33@H@Ӆ@@H@{@zH@k@g
=@p@@@@fff@mp@Y@C
@i@NR@jH@8Q@.{@XQ?@R@R@9@8@A@[@xQ@l@g@R@@e@@G@@\@33@@ff@O\)@k@s33@\(@qG@w@o\)@7
=@B\@p@XQ@NR@\@  @Fff@+@-p@!G@<(@QA33A@
A=q@
=A*=q@  @33A33AG@Q@\@H@$z@H@@/\)@JH@nR@@U@7
=@C33@|(@`  @jH@i@hQ@Z=q@@  @%@H@s
@u@K@`@HQ@0@@+@P  @:H@E@Y@Mp@K@N{@E@Mp@G
=@H@B\@E@Fff@K@Tz@^R@s33@|(@p  @
@
=@  @(@H@ff@{@\@@H@ҏ\@33@@@A)AA(A\)A  A\AQAAzAA
=AAA
=A{A@A
=@G@ff@  A@H@\@A(@zAG@A\(A/A=qAAΣA  AAAqA)@  A]GA@ffAH@33@{A\A4zAcAmA\Aw33AA7
=A(A!pA(A+
ArRA+
=AQAff@GA@G@\)@H@G@@@H@(@@p@@@@=q@HAAffAHA\)@H@@@@@
=@@@(@(@
@@
=A=qAAAAAHAffAAzAA(A\A\)Aҏ\A
=B QAAAk\)AAHAGAQAʏ\ARA  A{A(A\A\ASAPAZRA(AQAffAIpA\QA|QApAepAL  AAAApAARApAA\)AiAYA
=ApAQA;A5ADA[33A0  A\)A.=qA
\AGA
@A  @G@AGA
=AffA QA @QA{A@pA
=Ap@RAA{A\)A{AmGA-ANHA<(AAAapA~\APzAp  A\AHARAAQAzAQAA
=A  AA(AQAHBANffAzAA
=AA
=As33AAB\)B
=B
QBA(A(AA{AjffAQAIA=qA@\)A^=qA/AAAGAAp  ARA(A
A33AYpA$A:ffA;
=A{@(@@H@p@R@@\A@@\@@(@Q@p@@Z=q@\@  @[@@   @(Q@/\)@^{@QG@tz@Q@A QA
A  A(A&HA\A!GA0AUpA?
=A>{AG
=A7
ALzAAepAc
AQAA=qAA\)A\)AA=qA\)AAHAhzAzAGAffAzAAAAAAA8  A*RA A-G@HA`zA\zAIpA]GA
=A
=AA(AQAƏ\AuGAj\AjHAZ\Az=qAW
=AYA!AMA.HA,ApQA,A@p@Q@
=A'
=A7@(@@=q@@@=q@@  @z@|@@
@(@A  @R@{A\)A=q@\)@p@\ARA%@p@@QAGAtA0(A!pA1pAA?
=AAaAA33AA
=AυAAAAAnHABQAA
=B(AGBGAAA33AHAAMpAHAC
@  A@\)A<QA/
=A6=q@A   @G@@pA9AzA}A_A{ADAA7
AQALA<AAAAeA\)ADA2{AG@{A7
AHAG@{@)@@i@33@p@tz@@]p@Mp@(@Fff@5@C33@:=q@
@@(@%@H@;@=q@w
=@@{@G@H@
@@R@33@(A	A8  AIpAnffAHACAA\)A|QAA
AA33AA
A
=ARA33AHAApAAzAAApAAffARAffA=qAAV=qAv\AvRAAYp@A
HADAh  A{
AHAGALA0AA=qA0A%A&HAGA9A)AaA,QA33A
=AA{@=q@p@{@=q@RAQ@{@33@
@@33@ff@
@r\@_\)@@@z@@U@?\)?@33??ff?  @33@1G@=p@y@@w
=@z@@33@33@A
{A&{A/AA;A,QAV\AS
A:{ARA(A\AfHA\)AGA_\)@HA%@`  @33@@nR@\)@u@G@W@L@e@j=q@dz@[@z@\@G@E@&ff@C
@#33@QG@1@>R@@33@ff@xQ@@@  @zH@@{@k@Mp@>R@E@e@*H@	@@
H?@R@@@H@
=@ @1@G@*H@@\@"\@	?@ ?=q??(?H??\?{??aG?G?G?L?Tz?.{?Q?J=q??{???}p??
?H?p?
?˅?c
?@  ?\(?=q??R???ff?  ?R?zH?s33?k?p?s33?G?Y?=q?zH?  ?}p?ff??}p?fff??u?zH?aG?J=q?^R?c
?u?xQ?Q?k?L?L?  ?O\)??\(?L?Q?Q?W
=?8Q?@  ?E?Q?J=q?@  ?Y?J=q?Tz?h?h?Y?n{?E?Y?\)?Y?k?@  ?J=q?O\)??  ???xQ?\(?:H?ff?c
?\(?L?^R?=q?Q?aG?G?@  ?:H?Tz?O\)?G?@  ?B\?B\?O\)?B\?L?@  ?E?E?B\?B\?c
?L?=p?Tz?Q?Y?33?c
?n{?c
?c
??^R?{?s33?Q?ff?33?˅??{?  ???p?xQ?Tz?Q?  ?L?k?\?^R?n{?aG?\)?G??333?=p?B\?333?E?J=q?\(?Q?\(?J=q?O\)?B\?L?O\)?Q?Q?J=q?J=q?\(?L?L?Y?W
=?W
=?{?fff?J=q?O\)?
?G?  ?J=q?H@7?B\?{@?aG?˅?fff?0?E?H?c
?=p??zH?5?h?:H?@  ?5?=p?L?.{?E?J=q?@  ?!G?J=q?O\)?J=q?G??5?=p?8Q?G?\(?333?=q?@  ?  ???  ?\)??R??\?(?k??33?=q?(?\)?z?h?L?(?H?s33?:H?fff?O\)?8Q?Tz?W
=?E?J=q?\(?\(?Tz?aG?O\)?k?W
=?Y?aG?fff?fff?c
?\(?L?\(@@  @@@\)@G@@
@=q@33@
@@z@z@p@{@
=@R@R@{@z@@A (AA\)A\)A\)A A{A\AAAAAA
=AAAGAHA{AA @R@p@p@33@@p@\)@
=@p@=q@z@R@@  @@Q@G@
=@
=@@  @ff@@\)@
@
=@@\@p@@R@@@ff@z@  @A zApAA@33@A=qAAAzAzA\)A\)A	GAA	GA
pAAAA(A{A=qAA(AA zA\AApAAA
ffA@
=A\A{A(A(AA(AGA33AQAA33AAffA{AA	pA	GA
HA AHA=q@@
=@  @z@\)A @@G@@33@=q@@\)A zA @
=A @
=@=q@ffA
=A\)AAA @p@33@Q@@33@@@@{@@{@@AAAAffAApAAAGA
=A\)AAQAzApAA{AffARAffA  AAA33AA\)A
AAAAAz@R@
=A A   @@@@(@@(@HA@A
A=qAffAAQA=qA (@=q@@ffA   A{ApA@AAAGApA
A
A (@(@@33@@
@pA   A (@  @33@33@{AA ARA   ARA{A
A{A\Ap@\)AffA=qA Q@(A@z@G@\@@@ff@@AA{AA
=qA  A
A
=AHAzA	A
AA  A
\AAQA
\AffA
=A	AQA
RA	AHA\)ARAQAQAAAAQAzAQAAA
A(AA=qA
=A33@z@33@\AA\)@@@(@ff@ffA@A=qARAffAA=qA A @\)@G@\@G@\@(A AHAzA
A\)A\)AQAA
AAp@AAG@{A @A  @{@\)@  @\)@z@@p@
@@
=A (@
A Q@R@RA (A@AffA\A @G@z@@p@@R@{A   ApA(AQAQAAAAA{AAApA
=A
A=qA	A	AA
AA{A  AHA  A{AffApA   @@G@QAA
AAR@pA  AA{A  A
=AzA33AAARA
=AHAGA{AffAA	AAAA
AAA@\)@@
=@z@\@AAA=q@
@\@33AQA  @@@p@ff@@G@A{AA A A\)AffAHAR@z@zA z@RAAA\)ApA  AHAA(AAGAApA AA{A=qAHApA A @R@(@Q@@Q@(@G@(@A QA (A AA  AzAGAffAHAQAAQ@z@z@=q@H@=q@@A @(@A   @z@  @@\)@{@
=@z@H@33@  @H@@Q@p@@{@@(A   A Q@
A (ApA\)A(A\A{AAffAAAAA=qA@A@@
=@\@\)ARAA=qA
RAffA\)A(ARA=qA
RA
\AAA z@z@33A AA@AffAzAA
GAzAA
A=qAffAHAARARA
AAA QA33AAAA  AffA
A
AA33AAA33AQA	AzAAAA  @@{A@@{@R@(@  @Q@p@  @@  @=q@R@@p@@\@{@p@@=q@
@
@{A@\@R@\)A
@
=@\@\@@H@@\@A=qA\)A  A
A\AAA@@(@@(@(@@
=@{@z@@
@=q@(@ff@\)@  @@ff@{@@R@@@G@\)@Q@R@@\@G@33A
A\)A@{@z@33@G@@33@\@@A
A{A
A	AAA  A\)A=q@@@@
=@Ϯ@  @@ff@
=@=q@\@\)@\)@33@ff@ff@H@(@@@H@@@@@@\)@
@@@33@@@@(@
@@{AA zAA AA33AHApA @@ffApA@\)@{@pAff@ffA AGA=qA@\)A{A
=AAA
\AGAAA\AAzAA33AA
A(AzARA\A\AAARApAff@R@A @@@@G@@@@H@ff@\)@
AR@H@
=@H@@33@(@@@(@A (@ff@@p@@(A   @\)A33AQA   AA33A
A @pA@H@ff@@H@RA\)A  A\)AzARAzA\)A
A
A	pA33AzAHAAApA\)A\Ap@RA=qA=qA\A{A
AAAA
pA
HAQA
RAAzAzApAAffA$AQAA{@Q@33@RA @ff@@
@@@Q@R@z@Q@G@@33@\)@{@@@@@@\)@
@\@G@@ff@@=q@
=@G@Q@@Q@@33@
=@
@ff@@G@ff@  @@
@\)@@@ffA(ARA
=A{A	A\)AAA33ApAA (@
=A\A=qA @
@@@@@
=@@p@33@@@@@
@@R@
@p@@@z@@@@ff@@R@@
A AA@A
A{A33@p@HAA
A	AGA @
=@@(@@(@߮@p@\)@(@(@z@(@H@
@33@ff@\)@H@ᙚ@@@p@R@(@HA@H@@
=@  @@H@@@\)@=q@{@ff@33@@@G@=q@A{A33A\AAQA
=A\)A
A
A\@A Q@\)@@\@@{@@陚@
@Q@
=@ff@=q@33@R@@
@=q@ᙚ@=q@H@@ff@\)@ff@陚@  @G@@Q@@@
=@G@(AAAff@
@@ff@ۅ@
=@=q@
@{@@@߮@ᙚ@{@p@p@@@
=@߮@
=@@(@
@H@@@33@\@
=@pA AAffA
=qA  ApAffA\)A
A  A=qA
A=qAHA\A
AAApAQA33A{AA=qA\A\ApA
A
{@33@@Q@@@H@=q@\)@\@p@\)@p@{@ff@@(@R@
@@z@@\)@@A (@@Q@Q@@=q@
@
=@ٙ@@@@{@Q@p@ff@@z@GAHAAAffAA33@z@
@@z@G@Q@@z@@@HA @@R@@HA (@  @@\@ffA
AA=qA	@@AA=q@R@
=@ARAARAA=qA A\)A\A\)AzA	AzAzApA
RA33A(A	A
\A
@A
A
=qA=qA=qA\)AGAAAA  A
=@\@
@ff@
@
A@{@@=q@陚@
@ff@{@@ff@G@
=AH@(AA\)AzARAAA(A @
@@@@(@@@z@33@(@\@陚@R@(@p@@  @
=@@(@G@ff@@@@@@
=@@=q@@@p@@{AGA
AQAARA
=qA
ffA	A	AffA
pA\)A	pA	A@
@A=qA
pAffA
@\)Aff@@@@\@33@=q@@
@@{A\@R@p@Q@@p@H@@@\@p@p@ff@p@R@p@G@=q@33@  @
=@p@R@@p@Q@@{@@@(@@
@\)@  @ᙚ@p@(@@@
=@G@ff@@z@{@@
@z@pA@\@@
@@\@  @R@  @\)@  @@@@R@\)@R@@  @@R@Q@@@@G@@H@ff@=q@33@z@G@
@33@@@ff@33@Q@{@{@R@\@@\@H@@@(@@\@H@\@  @\)@G@  @@G@(@@(@@z@@@
=@  @@z@ff@R@z@\@@\)@\)@\)@
=@ff@@@\@߮@@R@=q@
@(@
=@\@\@@\)@G@@G@H@@@(@33@H@z@R@Q@@33@A @(A AAA\)AA{A\)AHAA{Ap@
=A Q@G@33@
=@@\@G@z@33@@@
=@@Q@Q@  @=q@@Q@R@@ff@@Q@G@z@(@z@Q@ff@
=@@\@
@z@ff@G@G@@H@@(@{@z@ᙚ@ff@ff@p@ڏ\@  @@ٙ@  @أ@  @\)@Ӆ@
=@
@(@  @
AA  AQA (@@@@33@ff@R@
A\AAGAGAzA  AA33AzA33@ff@@R@ff@ff@
@
@@\)A (@@R@ff@
=@(@@R@\)@G@Q@=q@p@@@@\)@z@\@
@  @33@@@ᙚ@\@p@G@߮@@  @@33@z@Q@@Q@Q@z@@  @ff@\)@=q@  @=q@=q@@H@@G@@@@@@(@R@@\)@{@H@{@@=q@z@@
@
@
=@{@
@H@{@
=AApAA
=A
{AQA\A
=@@R@(@33@p@@@p@@=q@@33@A
A@=q@
=@Q@
@@@@@@  AffA33A A\A
=A
=AffAA@\)@G@@HA (@\@{A   A=qARA (AHA   @H@R@@@ff@\)@@\)@@@@R@Q@\@H@@{@Q@
=@{@33@ff@R@@\@\@@p@@z@z@@@p@z@
=@@@\@@H@@@p@@@@p@ff@=q@@RA @H@@@Q@Q@@  @H@(@@G@\)@z@G@ff@ff@
=@\@ff@p@R@H@R@@(AA A A(AA   A
AA   A\)A=qA zA AA\)@p@H@@@\)@R@@\)@p@陚@@\)AA z@R@pApA   A A@R@p@33@{A (@\)A   AAAzA=qAQAzAG@\)@@\)@@z@ff@
=@@@\)@@G@@@(@=q@
@@RA A  AQAAffA(AAA  A\AAHAAzA  @A\AffARAffAQA
=qA	A(A
=A  AA(AGApAAAAA@p@(A @A@33@@@@R@(@=q@ff@
=@ff@{@ff@G@@\)@p@\@=q@@=q@z@@p@@
=@ff@R@{@R@  @@
@33@R@\@H@@z@@33@ff@@33@33@p@@p@@33@G@@
@\A  @(@GA=qAffAA	A(A\)AA	AAGA  A	AA AffA	pA33@\)@@@@z@@@@
@  @R@ff@ff@ff@@@@  @@@陚@z@\@G@  @@H@\)@@
@H@@@
=@@@H@(@\)@p@@Q@ff@z@(@@  @@{@@߮@{@{@G@=q@߮@33@@@@Q@G@
@=q@@@@z@
=@R@p@@p@A   @33@=q@pA @Q@\)@Q@  @@@@=q@@@@  @\)@\)@ff@@H@G@\@p@=q@@Q@=q@H@\@@@\)@
=@z@
@\@(@H@(@(@z@@@{@
=@\)@@Q@@=q@@p@=q@{@H@G@@  @  @@ff@H@@G@(@(@=q@陚@33@陚@33@33@陚@
@\)@@@  @33@@GA QA @\)@@@R@R@z@p@H@\)@33@Q@@
@  @=q@@@H@@@R@{@R@  @
@@@@@ff@
AAGAQA
A
A	AA  A=qAA   A QAzAHAAA(A	A   @ff@\@(@@G@@=q@Q@@@  @\)@{@ff@\@33@@@@
=@R@@Q@@  @ff@{@Q@G@=q@@@@@R@(@  @G@33@{@@@  @  @@@@(@@=q@=q@=q@@H@\@
A A(A
=qAAA\AA
=A\A A QA AGA AA Q@A   A A=qAAGA
=A zA{ApA	p@\)@z@@@R@p@@AA @\)@\)@{@=q@@\@=q@@G@@{@@\@{@@@
=A @zA
=A zA\A{A(A	AA  AA\)A=qAzARAzA
A
AQAAA  AQA  AA
=A\)A!pA#A\)A#A$  A#A#
A#33A$zA"ffA%A zAA QA%GA%GA#33A'33A&\A&{A&{A&\A&ffA%A#
A(A!pA%A%GA*=qA)A"=qA (AA"\A
=A  A\)A#33AAHAAAffA\AHA33AQA=qA  A
AAAAA\AQA{AA\A\)A
=AQAAApAAGA=qAAQA{AzA{AAA
AQAA33A#33A#A&=qA%A$QA&{A#A"ffA#A#33A"=qA AzARAA#\)AA=qA=qA A33A!A#
A#
=A&\A"=qA&{A&HA)GA'A&=qA$(A&=qA(zA%A\A%A%A$  A A33A\AGAAA{A!AAQA=qA\)A(A{A
AffAA
AzAARA  A
AAAHA{A
GAAAAA\)AA  A
=qAAQARA  AA	A
RA	AQAAA
{A
HA  A	GA	A	A	pA
HA
ffAA=qAA{@p@R@
@33@ApA\)A
{AQAA(A
A	AA\A
=ARA
GA	AAAAHAA33A
pAA
\A33A	AAAAAzAQA\)A  A	A
\A
ffA
AAGAzAA\AAHA(AQA{A
pAA\AA33A  A\A\AA\)ARAAAHAARA
=A
A
A
\A
\A{AA
GAA
A
HA
=AA	AQA
=AffA{A
=A\AHA{A
AQAA33AAA\)A
=A
RA\)AA
GA
GA
A(A	AA
{AzAQA(A
AzAAHA\)A
\AA
=A
GA
=qA  AffA
ARARAAzA
=AAGAA\)A33AA	GA	pA  A\)A33AA
=AApA\A
=AGA@\)@p@{A{@@@@@Q@@z@ff@G@H@G@G@H@A Q@@{@  @p@G@
@@@z@{A Q@GA
=A\)AGA33A
AffA (@@ff@
=@A (@RAGA Q@\)A@Q@(@Q@{@\)@@(@@
=@R@R@\)@@G@
@  @R@
@\@(@@p@H@Aff@\)ApAAffA	AA\)AffA=q@@@RA{A z@@
=@GA@QAp@=q@H@(@@@33@H@{@H@H@{@  @G@{@AA
=A
A
=A\)@pA
@@(@R@\)@\@ffA=qA (AA33A33AA (A   @@R@H@{@@@@
=@{@ff@@33@@@@@z@@@p@@=q@G@@ff@HA QA\@@@
@RA z@pA QA (A zA (@@@=q@G@@=q@=q@\@H@\@@ffA=qA
=AA
=A A A{A{AAA z@\)A=qAA  @H@{@z@ff@z@@@\)@  @
=@\@
=@\@(@@{@@p@p@Q@\@{@{@33@  @\@@(@\)@G@@@Q@@z@=q@G@@ff@R@  @@=q@
@@=q@@Q@@@Q@@H@p@@@  @G@Q@=q@
@@@@陚@ff@陚@\@@\@33@R@ff@@@@(@{AA\)A33A (@A @
@@
@
=@@H@ffAp@@ffA   @\)@=q@@\)@zA@{@
=A AA @@@
@@@@@@z@33@@  @@(@@\@  @@\@@
=@\)@{@H@(@@@@@{@z@33@@ᙚ@
@R@@\@{@Q@\@H@z@@H@\@G@
@p@
=@=q@@\@H@z@\@G@@33@\@@ff@@@@@p@{A @\)@\)@A QA AAAA zARAA
=@{A   AGA @p@  @G@\@\@@z@@R@@p@G@(A A   @ff@{@ff@=q@@G@@@\@=q@\@߮@@޸R@p@33@ᙚ@
@=q@@33@p@@@@\@\@@33@@@@@H@H@@
@A
@33@=q@@
=@@@AAH@@@  @pA @@
@R@ffAH@@@\)@@\@
@=q@33@H@  @\@
@AAQA  AA\AA  A
A\AzAA
=qAzAAAffA	pA
=AA  A@@@R@ff@  @H@
=@@@z@p@G@{@
=A\)@@p@
@ff@@ff@@@(@@
@@\@ᙚ@G@Q@(@Ӆ@@p@H@G@@陚@  @@{@ff@
@{@ҏ\@
=@
@@@{@ᙚ@z@陚@@@@=q@G@@@Q@\@p@R@@@G@@(@(@
@H@@G@@H@H@R@@33@z@@@@
@33@\@陚@ff@@@z@@@@G@@ff@33@
=@33@H@  @(@@p@33@@z@@z@(@@  @@G@G@\)@=q@@H@ᙚ@{@
=@p@p@@陚@33@H@@
@(@z@@R@\)@@p@@p@p@(@@@{@\)@@@(@@@ff@@@H@
@33@@G@G@@(A (@33@(AA@@p@{@@  @
=@H@@33@G@@ff@(@@@@(@=q@
@=q@@@@@@H@
@\@G@\@z@@@R@@@@H@@@Q@{@@R@{@@@\@H@(@陚@R@@@Q@\)@@  @G@H@\@\@@\@H@33@
=@(@H@=q@(@@{@{@(@@(@ff@
=A   AA ApApA=qA
=A\)AzA\AA  ApAGA	GA	A	GA	AA
ffAA(AzAQA\AA\)AffA A{AAA @
=AA zAGAApA
A  @
@@R@
=A   @@@\)@p@@@
@@@G@p@@H@G@@\@ff@@\)@G@{@p@@R@@
=@p@@G@R@@{@{@
=@{@R@z@\)@=q@
@
@ff@=q@@33@(@A @@ARAA=qA(AzA
ffAQAA  AAAA  A=qA
A
{ARApA@p@G@(AA @A @H@G@@G@@@H@H@33@R@R@
=@{@@ff@@\)@@R@@A zA   @{@ff@@@=q@\)@@G@  @p@@@33@
=@  @G@Q@@=q@H@G@Q@@@@\@H@H@\@z@=q@H@33@Q@\)@
@@@Q@
@33@@R@@@@\@H@@@@
@z@@
=@A (AA
=AA\)A  AQA  A{AAffA\A\A\A\A A   @
=@zA   AG@
=@{@(@@=q@@{@@@z@Q@R@@  @@33@@@z@33@=q@@z@\@@\)@G@H@(@@p@p@@޸R@(@{@{@@G@{@G@33@\)@\@@R@@@Q@G@@@@33@@@33@@@H@@@@@@@=q@H@@
@(@p@{@ff@  @  @Q@@@@  @@@@@\)@  @z@
=@@@p@@  @
@@33A
@z@z@R@@@  @
@R@H@(@\)A(@@
=@\@A (A z@z@A{@33AA @(@ff@(@@z@33@(@(@ff@@@R@@\@33@@@33@@Q@\)@R@=q@@@(@Q@\)@@\)@G@=q@G@@\@33@@(@@\@
@(@z@@p@p@ff@
=@@Q@@@H@\@@@G@Q@  @Q@G@@@@=q@@\@@=q@\@33@@@
@
@
@=q@=q@33@\@z@@@p@@z@\@@R@A   @\)@
=@(@@H@@@=q@
=@\)@@\@z@  @ff@@@=q@33@=q@@
=@@33@H@
@ff@@33@@(@@@@p@ff@@{@
=@ff@
=@
=@Q@@33@@G@@=q@33@z@@@  @{A ApA (@@
=@
=@R@
=@\)@
=@\)@\)@R@@R@@p@z@{@p@{@@@@@@=q@R@@@@@@z@z@(@@z@@@p@@
=@G@  @Q@Q@  @Q@Q@  @  @@  @@@G@\@\@=q@@=q@@@\)@z@(@ff@Q@Q@@\)@@\)@  @Q@@G@@\@@G@@p@@33@ff@z@@@
=@z@p@\)@@ff@@@ff@
=@R@
=@ff@{@@@{@{@\)@\)@
=A33AffA\AA33AHAGAH@ffAAzAA
{A QAGARApAHAAAAHA  AAAA@\@33@(@@@=q@@@@@{A\A\)A
=@H@pA @
=@33@
=@ffA A@@\)A (@@@@Q@Q@޸R@ff@@
=@G@\)@\)@=q@
=@z@p@=q@Q@  @{@p@{@
=@@33@33@@@@ff@
=@ff@\)@ff@{@  @G@=q@G@G@\@H@\@=q@@p@@@@@  @ff@@ff@@\@=q@H@G@@H@@z@33@33@@R@
=@ff@Q@R@ff@
=@ff@(@@z@H@p@ff@\@=q@  @
@@@@@  @=q@
=@
@{@p@@@R@
=@@\)A AGA
=A @
@A\)AGAApAA @
@\@
@(@@R@ff@@z@@@@G@
=@\)@  @Q@@@@  @@@@
=@{@\)A (A@ffA @  @@@33@Q@=q@G@G@R@z@H@@  @@ff@ff@  @@\@\@
@@R@@  @33@{@@@@{@@陚@陚@@陚@Q@
=@
=@@@\)@@@G@@
=@  @p@@Q@
@33@p@@@
@@@=q@=q@@\)@=q@@z@
@p@@\@z@ff@@
@@H@@@p@@33@@G@  @{@
@\)@@z@G@33@  @
@
@\@G@=q@@z@Q@G@@ff@33@(@(@@陚@{@@@@@z@
=@(@{@G@@@(@@Q@@z@
=@@@@@z@ᙚ@G@@=q@@@@ۅ@33@ڏ\@=q@@ۅ@33@ҏ\@У@
@ָR@@33@@@p@
@H@ᙚ@@=q@
@@\)@@@G@@@陚@
@{@@  @ff@ff@@R@Q@@@@@33@@
@@ff@=q@G@{@Q@@@
@@  @@
=@ff@{@33@ff@@@@@@p@@R@H@  @\)@R@{@p@@@
@33@  @  @@(@@G@(@(@Q@G@=q@\)@@@(@Ϯ@Ϯ@ff@
@ٙ@@=q@z@@(@(@{@
=@@33@@@{@R@@@
@
@p@\)@Q@@@=q@\@33@33@
@@\)@
@G@
@ff@
=@@@@{@@@H@\@@陚@@=q@ff@
=@{@33@H@=q@@=q@\@陚@@
@@H@=q@  @  @
=@@Q@H@\@Q@@\)@
=@R@@R@ff@@@
=@@޸R@@R@޸R@z@@(@@z@33@
@@
@{@=q@p@@\)@=q@p@@z@\)@@z@{@@\@@@@@\)@Q@Q@@@ff@R@{@R@
=@  @@@@G@33@z@z@\@(@H@
@33@@
@@=q@R@@@  @H@@\@@@z@@z@@{@{@{@p@R@ff@@p@ff@ff@p@{@p@p@@@p@p@p@@@z@@@
@@@=q@  @  @@Q@ff@p@陚@@@陚@Q@@Q@=q@=q@Q@@  @33@@@
=@ff@@HA33A Q@=q@33@{@
=@R@\)AAAA ApApA=qA\A=qA\)AffA{A@
=@ff@ffA   @ff@@33@@  @@AGA=qA=qAQAA{A@@@H@A zA33ApAA
pA33@ff@@(@@A{AARA QA@p@\)@@Q@33@@(@
@
@33@33@33@p@@@  @@@@@@H@p@  @  @
@@@
=A{ApA{A ApAA33AA
A33A	pAA\A	GAAHAHARAA{A\)AffAzA	GA	GAAGA
=AA\)AA
RA
ffA
A(A
A=qA
A
GA
pA
pA
pAHAffA
A
A
A
RAAGA=qA
A33AzA  A
A
GAAAzARAGAAA=qA  A\)ApA
=AA\AA
AA(A{A\A\)A
=AAffA (A @(@ff@\)@@{@@
@(@\@(@G@z@
A Ap@{AQA	pAQAffA A33A@{@@p@(@\)@\)@@@R@z@@pA zA   @33@@
@@@zA A A\ApA	GAA
A@Ap@z@HA z@z@ff@Q@\)@A@=q@A33AAAA
A	A	GAAzA
=AQAA (@
=A{@
=@=q@p@
=@
=@@=q@@@{@ff@Q@ff@\)@@p@  @@z@@@ff@@@33@ff@{A QA AGA
AAGAHARA
@33A
=ARAA33AA	A
=A\AAA	A(A\)A	pA	GAQAffAARAAffA(AAGAA\A33A  AAzA	AAApAGARAHAQAQ@@{@@@@H@@
@p@@ff@\)@G@@G@@@
=@p@\@H@pA   @@p@
=@@z@(@=q@\)@@Q@@@33@G@{@@G@@\@33@R@@\@z@A   AGA   @@
=@H@H@H@@ff@AAAAzAAzAQAAA\)AA
HA
=ApA33AA\ApApA (@ff@
=@R@R@@@@{@
=@
=@{@@{@R@R@(@
@@H@33@z@Q@
@  @=q@@=q@=q@@  @@
@33@
@@@@@@ff@  @G@33@\)@R@@H@@{@@R@p@@=q@H@ff@@33@
@(@33@@@(A AARA (A{AffAzA	AQAA\A   @ApA(AzAA (A(AQA(AA{AA  AA
=A{AAffA  AAzA\)A=qAAzA=qAzA
A
ARAA A Q@  @{@@@\)@@H@z@33@z@@@@@{@ApA AA(A\)AzAQAA (AAffA
AAGA
AQA @ff@(@
=@33@p@33@33@p@p@\)A @A zAGA zAAffA	A	A(AffAAA AGAA\A=qAA
A\AffAGA33AA
GA\AA=qA\ApA(AHAA=qAAA=qAHA=qA33AAHApA(A  AAA	ARAAAzA33AA33AQA(A
AARAHA\A\)AGA  A	AzAffA	GA	A	pA
A	A(AA
=A(AGAQAHA@Az@@33@@RA (A QA@33@=q@QAR@@HA@
=A Q@p@pAzA\)Aff@RA33AA33@z@
=AGA(AA	pA=qA{AGAA zAzA
=A{AA{AAGA{AQA{AQAffA=qA!GA=qA
A\)A33AA  A\)@@A   A   @p@{@A (@R@pA QAGA\AA@\)A A@pA{A
=A QAffAAA QA{A\)A{A{@
=@ff@p@
=@@@@
@z@\)@Q@
=@  @@@@@@ff@{@@@ff@@33@H@@\)@(@  @Q@R@Q@\@AGA\A
RAffA  AR@
=@@ffA zA QA AAAAzA(A(A
=A\A Q@@@(@
@@z@z@
@\@@33@  @
=@@@@@@@@=q@  @\@H@33@(@33@
@{A   AGA   A   @\)AGA\)@{A zA33@RA{@RAffAHAAff@@@\)A   @ff@R@@R@\@z@
=@
@=q@33@
@ffAA@\)AQA
=AffARA	AA	GA=qARA\)A	AA
{AAAA
HA
GAffAAffA(A
AA
=A33A33A(A\)AQA=qA	A33A
{A=qAAHA(A
=AAAAA
A
AQA AA{A
=A33A\A\AffA=qAAAA  A\AAAAA  AA  AffA\A33A
A{AQAAQA{AGA
A33A33AAzAHAGARA\)ARA
AQAA(A
ffAA
\A
RA33A	A A\)AAzA
ffAAA
AHA
AA\)AA
A
AA\AQA\AA(AGAAApAA  AAA
HA
AA
A=qA\A
=A
=A\A33AAzAAARA zAffAA33A
=AA"RA"RA)A(A+33A+\)A-GA8QA6RA,zA(A(  A&ffA+
A-A,A-A)A&\A'
=A&ffA'
=A!pA!AA\)A  ARARA\)AAGA  AffA33A'A,A%A&RA&{A#A%A$A#AAA!A!GA QA!A A A#A%A&ffA'
A%A&\A%A$A$A'A,QA*{A$  A%A(QA(zA(A)A&HA$  A"\A A"HA"=qA%A,  A.{A+
A(QA'
A%A%A#
=A   A  A%A$  A#A!AffA A A
A\)AffAffAffAA QA"\A\)A QAApAA(AAA  AGAA\A
=A\)A"RA.{A)GA$zA zAA!pA%A   A"\A!GAzAQA(AAA{AA(AffA33A
pAAAGA  AA33A
A
AA=qAzAA\)AHA=qApAAAA
AAA{AA=qAAQApAA   AA#
=A AAzARA
=AA
=AffA QAAGAAAAAffAA{AGAA\AAQAHA
=AHA
AAffA=qA\A\AGA
A
HAAAA
pA	pAQA\)AAGAAA  AAHA	AAzAHAAAAA A(A
ffA  AA
A  A
=AHA
=AA
A  AApAA
=AA\AGAffAA
RA	GA  AQA
pAAARA33AHA
A
RAQA
A\)A
=A=qAA33AA(AzA\AA=qAA{A
A
pA
pA	A
pA	A33AA
AQAAAp@{AA
=AGAffA AAAARAAGA  A(A=qAA	A33AA\ARA{AA   @@33A
=@=q@HAAAAzAAA\A   @QAAAA
A	A(A	pA	pAA(@A A A\)A QA   A AA A AG@RAA z@\)@RA A QAGAAHA\)A\)A\)AHA\)AA
AGA
A
=qAAAGA=qAA=qA Q@\)A (A (AAffA{A A AAAAffA QAA=qAA33A\)AQA@pA@{@G@
=@@@p@
=@  @z@H@ff@@
=@\@@G@\)@p@R@Q@\)@H@@@\@ᙚ@@{@Q@
@R@z@{@@G@{@R@@(@GAA33A\AAAAQAH@G@ff@pA A(A\)A QA{A z@@AAA
ffA@@(AAA@H@@z@\)@@  @@z@ff@H@ff@\@\)@陚@R@@p@R@@=q@H@(@ᙚ@@G@(@޸R@R@{@(@ᙚ@@(@ۅ@@z@(@(@{@߮@@ff@p@@ff@ۅ@
=@=q@Q@@\@p@
@߮@p@@@
=@@@@{@{@=q@H@@@  @33@@@Q@R@\@G@ff@@@\@@\)@\)@
=@\@@p@\)@z@{@@@@
=@Q@Q@
=@{@@{@z@p@
@=q@
=@@  @@(@G@@ff@@G@@@G@H@@@  @Q@z@ff@H@z@33@
=@\@R@{A QA @
=AGA(@R@ff@@AAAGA z@
@@
@H@=q@ff@(@Q@(@R@@ff@\)@{@p@G@@Q@
=@p@AGA QAA (@GA A{A Q@{@A\)AzAAAGA{@(@\@{@R@{@QA @  @@p@
=@z@  @\@(@{@\A   @\)AA (AzAAA(ApAQAA
=AHA	GAzAAffAGAHA\)AffAAA  AAA\)A33@@@@@@@  A{ApA
@
@H@@R@p@@@R@@H@@\)@33@H@ff@\@33@
@@@ff@{@R@@@@=q@pA A
AAAHAQAHA=qAA
ffAA
=A33ARAARA
=AAQApAA\)AzAAGARAAA(AGAffApAA!A33A"{A!A  A"\A%A(zA%pA*{A*{A(A*{A*{A)A)A)A&HA%pA'\)A(  A((A'
A'
=A%A#\)A$  A A\)A
=AffA  A{AHApAHApA\AA
ApA
A=qA\)AGAA=qA	A(AA33AGApAA\)AAAAQA
=AzAzAQAAA{AHA\AA=qAzA{AQA
A!pAAHA AGA=qA\)A  AA\)AAQAAffA
A
A{ARAQAHAAA\A33A
pAzAGA\AA=qA(AA
AzA
HA=qA
=ARA\AHAzAA A\)AA=qAAAAQA(AA
AA\A{@@pA33A\)@@
=@@H@@{@
@\@z@Q@p@(@(@@R@@G@\@ff@  @
=@Q@@@(@
@@ff@{@@@Q@Q@p@@=q@  @=q@\@@z@{@33@=q@ff@@z@@
@@@=q@@@@@@ff@H@=q@@G@@
=@H@@@@  @{@ᙚ@@ڏ\@(@z@
=@@@33@33@@
=@ff@@z@Q@p@ff@33@\@
=@\)@(@@\)@z@=qA@@H@
=@\)@33@zAA{@@@@Q@@=q@ff@@@@33@@R@\@@@@
@@@Q@p@@@AA@@\@@RA@A (A(@=q@\)@p@@=q@z@
@G@@@ff@@@ff@{@@(@Q@@@H@@
@G@Q@
@@\)@@
@\)@@z@@{@ff@أ@
=@G@ff@Q@{@@@\)@@=q@
=@ff@ᙚ@@ڏ\@@߮@@z@  @R@@  @Q@(@H@G@Q@R@@@(@Q@@Q@=q@ff@@\@Q@p@  @33@\@\@p@H@
@
=@R@ff@
=@G@@@@ff@A (@@
=@@  @p@@z@33@@@  @  @ff@@{@{@H@@z@@@H@=q@33@@\@G@@p@Q@ff@=q@\)@(@@@p@
=@ff@
=@@\)@陚@@
@@@  @\)@Q@{@@  @\)@@@@@@pA@p@z@  @\@R@(@@\)@@{@  @@
=@z@R@@@G@@\)@\)@p@R@@@H@
=A A @\)@@33@ff@Q@p@R@ff@(@@z@\@@z@
@H@@\@@@ff@\)@@@
@H@
=@z@ᙚ@(@ڏ\@  @ff@׮@\)@@@ᙚ@R@G@@@@޸R@R@@陚@
@  @33@\)@
=@ff@@=q@ۅ@  @Q@ᙚ@@ᙚ@G@=q@=q@\@@{@
@@z@H@@z@\)@@@H@@  @ff@@{@@
@@@@ff@R@=q@
@p@
@  @R@ff@R@R@R@@@@R@@z@R@@@@ff@陚@
@@(@{@\)@@@
=@@p@@@@陚@ff@=q@z@\)@z@R@33@
@H@
@(@ᙚ@p@@@陚@
=@@p@@@R@33@@Q@@  @\)@\)@@@
@@R@@@@
@@{@@\@G@R@@G@(@\@z@@@=q@R@@
@@=q@@G@z@G@\)@@ff@ff@ff@@
@G@Q@@ff@R@G@ff@  @@\)@\)@@z@{@G@ᙚ@@\)@R@@@R@ff@(@R@(@
@33@  @(@@@{@\)@@Q@@
@G@=q@H@
@\)@ָR@G@
=@޸R@ff@@
=@Q@  @@\@p@=q@@@\@@G@Q@Q@\)@@  @@=q@33@(@
@@@@@H@
@@(@p@@ff@@R@
=@@(@{@G@@33@@@G@p@z@
@@@@@H@
@(@@@(@(@33@
@@@@33@\)@@
@33@33@
=@Q@z@@z@@陚@Q@R@=q@33@H@H@ᙚ@ۅ@\)@ᙚ@@p@{@=q@Q@33@\)@R@  @Q@Q@  @@\@33@{@@{@@{@
=@@Q@@G@=q@H@@33@z@z@@ffA\)AAAAQAAG@
=@R@(@A@{@=qA   @\)A=qAAR@\)@@@@\)@
@A   A   @R@@@
@\)A A\AAA{A ApAH@@z@p@
=@@
=@(@@
=@
=@@
=@  @R@@  @Q@ff@R@@=q@z@@  @(@ff@@
=@Q@@@33@@\@ᙚ@@z@@@33@=q@{@H@@H@@@@R@@\@{@(@  @=q@  @@\@Q@@Q@@ff@G@陚@=q@
@33@Q@R@@  @@G@@33@p@\)@
=@Q@\)@\)@(@陚@33@\@\)@@ff@33@
@p@p@R@@\@p@@@R@z@Q@@@R@\)@\)@=q@Q@
@z@R@@陚@@@{@=q@ff@(@@@H@@H@
=@@@=q@@@@@G@33@33@ff@@@  @=q@AAA (AA=qA33ARA=qA{AA{AA\A  A  A
=AHAHA
A  A33A\AAAAA=qAffAAffA z@\)@ff@
=@ff@R@@p@33@p@@ff@
A (A (AGAAA\)@@\)@\)@\)@{@@@(@
=@  @@@Q@z@@@(@{@ff@\@p@@H@@G@p@@@G@R@\)@
=@
@  @(@  @R@@@@@\@@@{@{@@(@@QA   @
=A@\)A=q@@{A QAR@A(AAAA\A\AQA@GA@zA@
=AAA A@(@\)@=q@@@G@@  @33@H@\@@@@(@@ffA A QA   A (AAGA{AAAA\)A\A A zAp@R@{@ff@ff@\)ARA zAp@ff@pA   A@RA Q@@RAA{A=qAA
=AffA
AA	AA	AARA QAAA=qAAA33A(A
=AzAA(A(AA
=A33AzA
A
A
GA(A33ARA33A{A\)AffA
=A
GAAA\)A\)A33A
=A
=qAAAA\A	GAA
=qA	GA\)AQA
=AA(A
=qAAQA	A33A	AA
=A33A  A	GA(A(A(AAGAApA  AA\)AffA
=AA=qA
=A	pAzA(AA
=A=qAAA
A  A
AA=qAA=qAA
AA
=qA
AffA
A
{A\)AA\)A\)@{ApAA	A(ApA	pAAHAA=qAAAA
A\AAffA33AA(A
=AA(A
A
=AA{AAA33AGAAA\)AAAARA\)AA=qApARA\AAAAAQA
AQA  A  AAA(A
=AAARA	AA{A\)A\A
=A
A	A
ffAA
\ApA{AApAHA\AA
RAz@A A33AffA zA QA{AffARAR@{@@ff@(@
=@\@A{AffA{A\)AGARAzAA
AQA{AAzA(AHAAAA{AHAA{AAAAzA
HA
A\AffAAffAAAffAAQAA33AA\)AQAzA	A
RA
=qAA
AAHA\)A33AffA
ffA33AQAzAAAARAQ@AGAAffA\)@H@H@(AA\AzAAGA (A
@33@A z@
=@\)A@A   @
@@@@ҏ\@Å@{@
@z@У@
=@ȣ@=q@@G@(@˅@@@Q@ff@@@߮@
@@@@  @33@=q@\@@@H@H@H@ۅ@ۅ@
@
@z@@@  @޸R@H@߮@  @Q@Q@@z@H@@@
@أ@@ٙ@ڏ\@G@z@H@@H@\)@@p@@@=q@@@  @  @@33@Q@R@R@@33@z@
@ff@=q@
=@  @G@z@@@
=@@\@@Q@@@
@@@
@H@G@Q@  @@=q@z@
=@G@G@  @=q@\@@@33@Q@\)@p@@z@p@\)@G@z@
=@@\)@@{@\)@  @ff@
=@@\)@  @@@陚@@G@@=q@=q@\@\@@p@
@
@=q@陚@@@33@@@Q@
=@@Q@@@@@
@{@@=q@@(@ff@@=q@H@@@z@{@
@=q@R@H@z@\@z@(@(@@(@@@\)@{@p@@=q@@R@R@
@\@Q@Q@@\@p@ff@@A (Ap@ff@@33@ffA   @RA z@@AH@\)A{AAG@A   @HA (A (@R@A @@R@  @@@\)@=q@@Q@Q@@@@@@G@@  @@
=@  @Q@\@33@@
@  @@
=@@R@G@{@Q@p@@@@@ff@@(@@@@=q@@@
@A=qA\@@G@R@@(@@{@RA   A   @\)AA
=A=qA=qA{A33A  A
AApAAHAHA{A\)A
=A
=A\)ApAQA(A(A
A\)A@\)A   @RA QAGAA   A (@\)@\)@\)A @@{@z@@\@@=q@@@p@\)A zA A AGA A A (@\)@\)@pA @R@p@
@\@\)@@@(@R@@@G@@
=@Q@
=@{@Q@G@
@  @@\)@
@R@@@\@@p@  @
@@ff@
=@
@@ff@ff@p@33@
@@@33@\@G@@R@
=@@Q@H@@G@R@@p@@R@
=@@  @
=@@Q@33@@33@33@@=q@@\@H@G@
@@@\)@ffAA @{@33@@ff@33@@@@@\@G@p@\)@=q@{@@R@@@z@ff@@@p@p@(@@H@@ff@p@@@@@AA@{@\@\@@@@\)@@{@@\@(@@{@@H@33@H@H@@33@@33@
@@33@33@(@@z@\@@R@@{@@@ff@H@@(@\@@@@p@p@@\@z@Q@@ff@  @\@@@
@z@{@@(@(@@R@@Q@  @z@@@@
=@R@  @ff@@  @\)@33@H@@@  @\)@z@R@=q@\)@R@G@R@@H@Q@(@\@33@
@Q@@@@R@\)@G@@Q@\@@\@33@{A zA   @z@
=@
=@{@{@R@{@{@@@p@\@Q@R@p@R@@  @\)@G@G@@
=@{@@Q@z@@(@\)@\@Q@@\@=q@@33@@@p@@p@@z@ff@@@33@@
@G@@@p@G@ff@@R@\)@{@z@  @z@
@H@@R@@  @G@  @p@33@33@@G@  @@=q@@@ff@\)@@@@@=q@H@@(@(@(@p@p@@ff@{@@p@z@p@z@ff@ff@@pA z@
=@ff@@@z@
@z@@@RA   A   @  @@@zA Q@R@H@@(@G@
=@
@\)@
=AA33A{A{@QA (@ff@R@AA  AAAAAffAA\)A@33@z@z@R@33@@33@33@GA  ARA=q@GAz@H@@  @@@  @  @G@@@@A QA A@A (A A A ApARA(A(AAHApA A=qAAHA\@ff@p@
=@{@A   A (AAAGA
=AA
AAA33AARAffAAGA  AAzA33A33AA{A
=AA
AA A Q@@
=A AG@{@33@\)@\)A QA @\)@A z@@@z@p@@@ff@@AffA @@z@@A   @{@R@
@  @ff@Q@@ff@ff@\)A (A (@R@A AAAAA=qAA=qA
A33ApAAGA QA33AAAAA
AQA\)AA\)AHAA{A ApAHARAffAAAA @ff@@@(@\)@@A zA@
=@@ff@
=@
=@33AGAAA @R@{@A   @
=@
=@
A @33@@(@(@
@G@H@@(@@G@\@\@@\@@R@\)@z@@@{@
=@R@RA ApAARA
AA=qAA\)A\A{A
=AAAAGA  A(A\)AA  AA(AAffARA\AAA\AAA33AzAQA(AQAA  A  A33AHAHARA\A
=A
=A
=A\)AHAHARA
=A  ARAA=qA @
=A@AQ@p@z@@ff@\@@@ff@p@@
@
@(@@=q@\@{@  @@z@@33@p@ff@{@@
=@{@z@@
=A=qAGA{A AHA  A
=A\ARA  A(AAGAzA  AA
=AA
AzA  ARAAHA\AAAGA (A (A @p@@(@@@A @\)A@p@{@{ApA\)A33AA33A33A  A\AffA
A	AA	A
AQAzA
A
AAARA
A=qA33AQAA
A\)A	A	A  A	GA33AAA
GA
=qAHAGAA
A(A	A
=A
=qApA\)AAA
ApAAA QAQA\A{A=qA\)A
=A  AAQAA\A
\A	AAAA
=AzAAA\)A	pA
ffApA	pA\)A	pAA	AA{A  AAA
GA
A=qAA33A33A
AAAA
=A
RAAAA
A
AzA	AzAAA	GA	A
=A
HA	pA
=qA33AAzA	A	pAffAAffA=qA\AA
AAAAHAGAA@\)@
@Q@  A{@A33ApApA33@A Q@@z@\@H@A @ffA   ARAHARA
=AA\AAQAHA\)AAGA=qA{AApA{AAAffAApAAA zA@{@{A   AA A Q@
@RA=qA{A=qA=qAAAAGA AAAffA (A z@@p@@@p@@33@ff@@{@\)A   @\)@
=@ff@p@z@
@z@
@\@@33@\@33@
@z@@{@
=A   @
=@RA A @A A   A Q@\)A   A   A (A (A QA A AAApAGApAGA{A=qA{A\AffAffA33A
=AHA
=A33AAAA(AQAA33AAAAGA=qAA z@A (A ApAApA @ffA A\@{@ARA
=AA   @@@  @z@H@Q@H@z@z@R@ff@
@{@Q@ff@@G@\@=q@@(@@p@@=q@H@@\@
@=q@@@
@@pAHA
AGAA\A{ARA\)A\A=qA
=AAAzA  AAA(A(AAApARAAAffAQAHA	AQA
=A	A
=qA	A	A
{AAA	pAHAA  AARA
AGA=qARA=qAA
AAffA\)AAAAARAAAA  A
=ARA@\)@R@\)@
=@{@{@H@@ffAGA\)A(A{A @
=@@Q@@Q@33@@@@zA   A Ap@AApARA33AAGAAA\A{A{A{AffA\AA\A\AAA  A33A\A
AA	A	GA
RA
GA\A\AGA\)AHAAHA
A
HA33A
A
pAA
A  AAA
HA
{A
=AAA	AAAHAAzAQApAAzAAA=qAzA{AA(A(A\A=qA QApAQAAAAAAAAzAAAA A
A\A
@\@33@HAGA AAA z@33A
AHA  AAApAAA
GAAQA
A
HA
{A
AA
A	A
GAA
AARAARAA\A
A	AzAQA
=qA33AA33A{A
=AffA\)AHA
=ARA
AA(AAAA
AQAA(A
A
{AA
A
A33AAAA33A(AAAAARAAAHA\A A   A33AffA@
=A QApApAAAAA\)A\)A AAAHARA
A	pA	A	AApA
=A
RA\ARA A{A
AA\AQA	A
\AQA
\AAAQAA	AA	A
\A
HA	ARAAAARAffA33A=qA
=A @
=@zAAA33ARA
=A
=A33AA33A{AA{A33AQA=qAAAHAzA   A=qAAA  A33@(@@p@(@@@@@\@
=@@@G@@
=@\)A zA   A zA QA A Q@\)@
=@
@@(@
@
@@@A QA
AAA=qARA33AGA{AHA
AA
{A\)AA
pA{A(AA
A33A
A(ARAA\)AAA(QA$(A&{A*ffA'33A"ffA\A33AAGA=qApAAAA
A
{AQA\)A(AA33A  A
AAA
=AAA	ApA\)AzAAA{A
AQAA
HA
A33A
=qAAA	A  AA
A\)AHA  AQA	A33A\A=qA
A\A AAHA(AApAAAffAAA
=AzA
AA
A33A
HAzAA  A=qA33AQARAGAHAA
=AARA
A
=AA\)AAAGA&ffA&ffA(A'A(zA(A%A#33A)A#A!GA#A!pA A!A   AQApA{A  A=qA\)AAGA33AHAA(A
\A\)A
=qAffA\)A\AQA\)AA33A  AA33AA{A(A
A
pA=qA
A33A
A
GAffA(AA
=AA	A	A
HA
=qAQAQAA	A
=qAA33A(A
A  AA  A  AAHARA(AAApA   A A\A#A!GA(  A*HA+
=A*HA,A-A0zA0A1A5A333A6ffA8(A9A@  AC
A3
A6ffA2RA*{A&RA'33A&ffAAA A QA
=AffA\AAGAA+
A(A*HA#33A!GA!AAzA\AAffApAA  AGAffAA
=AHAzAA(A{A(A=qA\A
A
A
RA  AAffAQA
=AAA
A
A
A	A
ffA	A(AAGA
A
A
AzA=qAGA
AAA
AAAHA
=A QA A!A!A!A#A%A&HA%pA$(A$  A%GA$QA$QA#\)A,(A2=qA1pA3
A3A1GA-A-A+AGAA QA*HA,(A$  AGAGAAA33A=qAAA
=A	A
RA	AA
HA33AffA
A
AAA
ARA	AA	GA
=A  A	GA  AAA{A=qAAzA
=A33AHA AAAG@ff@(@{@33@@@\)AH@{AQA
\AA  AA  AAAAAAGApAffAA(A(AffAHA!pAGAffAA{A zA"RA%A&{A$A!GA A!A"=qA A!ARA
=A (A=qA  AA!pA$A!pA
A{AAA\A	AA=qA=qA  A33A\)A
=qAAzAAAAAAAQAA
=qA	GA(AA  AA\)A\@ffA @ffA A zAA(AffA @@@=q@@=q@\@G@
@\@A Q@\)AGAAGA z@
@\)AA A  AA\)AAA	A\AA
=AA\)A
=A
A=qA  A\AA A!A!pA!GA$(A&\A!A&{A)GA-A1GA7\)A2RA+33A A,A$QA A{A!pA
A AzAA=qA
AARAA
AA33A
=A=qAA\A
RA
AA33A	A
ffA
{A	A	A	A(A
ARApAARAAAA{AA@\)A QApAA@RA@@=q@@p@z@AHAQARAA(A@pA @
=@\)A QAAA(AQAQA
A
A=qA=qA
=AffAApA(AzA33ApA
A=qAGAHA
AA(AAAffA33A@@@
=@
=@@
@@@G@@
@\@@@\@33@Q@@@@@\@(@@33@@p@  @@
=@z@z@p@(@
@G@\@@{@@
@\@G@H@\@H@
=@R@ff@Q@@@(@{@@ff@R@R@ff@@@
@
=@z@@\@@\@(@G@@@Q@H@@@@ff@@(@@@@@HA
RA
HAz@p@R@p@p@p@@33@=q@@\@33@陚@陚@GA
\@33@\@陚@HA33A
=A
{@@陚@G@A
RA\)@陚@=qAffA\)A33A
AA@\A
A
AAAQAAA=qA\AA=qAApA(AA\A  A
=A\ARAA
AffA
AQAA
=AA(A33AAA\)A	A
ffA
RA
{A
\A
RA	A
ffA
{AAA
=qA
=A\)AA{AAA
A
A{AA{A(A
=A
RA
HA
A33A\)A33A
=qA
R@(A
=qA
\A
RA
=qA	A
\A
\A
H@33@(A@z@@
@H@@H@=q@HA\)@@A33A\)A
=qA	@GA33A
ffA
@\A\)A  AA
GA{AAQAffARA33A\)AffAAAzA  AAA
AA
pA\)AAA33A
{A
=A
R@zA
HA
HA
{A	AAAA	AA	A	A(A(@(A  A	@{AzA	A33A
\A	AA\)AAQA
HAzA
AA
AA33A
RA
RA	A
=qA
{A
ffA
{A	pAA	A
ff@z@R@\@@33@H@@@
A
@@(A@HA
ff@\A33A
\@  @pA
A  A  A
AAAzAApA\A  AA\AAA\AA
AAA\A
AA
BBBBLBB8RBأBڽqBGBڅB.B
B
BQBGB8RB
B33B
BܸRBBfB
=BݽqB{B=BqBGBpBHB\BBBqBuBBffB
BBBBB33B=BB  B=qBޏ\B=qBB(BBBBBըB֨BB\B\)Bˏ\B̏\BBB΀ BaHBBHBB#BzBQBBBBB  B33B
=B  BBB)BfBB.B\B=qBѽqBֽqB=qBǮB(BBW
BBB  B
=BB{BBB
=B3BW
BBHBBB߅B)B(BQBB)BGB
=B
=B㙚BBBBB\)BB\)BuB=BBCRC )C BBRBBQB홚B8RBݣBٙB(BBBuBڅBBBffBB\)Bي=BBޣBݳ3BBLB8RB(BfBW
BBBBǮBր B8RBB֮BBffBaHBԞB׸RBfBܔ{BB{BBpBuB33BBǮB\BBRBfB#BGB=qBB#B\BBaHBBB8RBRBqBGB=BBBfB♚BBqBB܀ BǮBBܳ3BB)BB{BpBzB#BGBߏ\C =B\Cs3B33CBW
BBۣBBB
=BB♚B3BpB CzC	33B۞BBBLBBzB\BW
B۽qB=qBޅBHB33BBB{BfBaHB\)BB#BBBBB  BB\B)B8RB8RBBՏ\B  BۅBBaHB\BBߏ\BuBBzB  BHB(B  BBB8RB#B{BB)BBBBqBB8RB8RBB(BBBBBBB=qB{BQBBBǮBffBpBBQChBQBzBqB{BLB{BffB.B=qBBW
BݣB݀ BB(BpB㙚BuBBHB.B3BݸRBB٣Bٔ{BzBB\)BǮBBBqBaHBBB{BBpBuBHBaHB#BܞBB33B\BkBܔ{BӽqBGBBٸRBޔ{BڨBLBBីB\)BB=B➸BHBBBBBBB׀ BkB\BǮBffB)BBޣBBqB(B螸B\)B  BB#B)BffB BB(BkB8RBB
=BC B\BQB\BBQB)BǮBGBpB33BffB(BCC 5BǮB֣C#CC B3B(B  B3BRB8RB)BpBaHBqB{B=qBpBBBBBBpBW
BB33BٮBW
BkB\BHB3B\)BuBޮBܙBǮBQBB8RBBuBB٣B)B#B.BffBBBpBzBffB.BHBpBB\)BHBBffBB{B33BB
=B{BBLBBB BHBBkBBBBkB߸RB.BBW
BܙB  BpBBBRBǮB=qB=qB{BHBCcB\B=B B\B)BQB#B
=BÏ\BBB#BzB{BBߏ\BffBǮBHBٸRBkBfBBffBBB)B33BҮBس3BBBRBBRBBGBB{BBzBLBaHB\B잸B
BBRBBqBB
=B(BBBzB BCBBB BqB{B
B\BQBBHBaHB#BuBRB8RB=qB
=B33B=CBBLBuC\BRBqCQCEC
\CW
CqBC}qCHCǮCC
QC	C	YCCBǮBC
=CnCLCC 8RB3BqB.C
CC
BaHB۳3B=BffBޏ\BҨBBffB)BfBҙB8RB33B
B.BBɏ\B̳3BW
B)B{BB8RBBBQBHB
B
=B33BB(B=qB{B
B  BLB֨BۮBLB\B晚BBB BGBffBffBB݊=B(BݙB=qBfBzBpB\BkBBBuBӅB8RB#BǽqB݊=BfB)BB
=B{BB\B33BLB\B=BܨB\)C qCqBfB
=B BLBߏ\B)BW
BkBW
BB BBfBHB33BBBǮBRB\B
BޅBQB33BuBǣBpB8RB\)BBBǮBB
=B)BpB#Bр Bۊ=BBRB݀ B߮BB8RBzB۸RB֔{B33B.BQBݣB.B\BB޽qBQB(B垸BBfBQB  BaHB\)BBBzB8RB噚BkB)BBzB=qB#B B
=B#BBQBqB\)B{BHB3B=BBQBzB)BBqB
=B=BLBC:C	@ C+B\)BBaHB3B\B\BܞB\)BLBߏ\BBܮBܳ3B{BBڏ\B\)B33B  BШBRB  BGBBkB
BBB\BuBBB{BB33BBffBW
BHB.CB癚BW
B C8RBBBW
B\)BBLBQB#B.BzB3BCCC33CB\)BaHBBRBBBBB)B{BzBQBBBaHBBHBCCffBBB3BǮBBCnC3CfCC\)CT{CB=CYCBBW
BBBBHB{B(BܨB=qBGB8RB{BBҨBЀ BBBBѮBzBѮBӨBԞB
BνqB.BBaHBLB͞BpB\)BBBBGBָRBBuBըBB33BffB33BՙBB۞BB33B  BBpBzC\BW
BHBBBW
B(B=qBBB#BHBꞸBꞸBffBB{BBLB۽qBpBߞBܔ{BڮBB׊=B8RB8RB#BBB̸RBQBLBpBBB
=BHB.BីBfBGBfBBBB{BHB
=BB
BB  B\BB(BBBBBۀ BӀ BB͞B.B\)BΣB˸RBр BB(B#BǮBBB\)BkB˔{B\B
=BQBQBB\)BaHB(BBBB=qBzBЀ BuBՏ\B{BBB(B\)BuB3B=qBzB\BBpB3B
B
BB{BBB鞸BBQB=B#B߸RB.BB33BBӸRBzBBpBўBҙB#BHBkBuB̅B8RBͽqBΏ\BGBϣBffBkB  BўB)BB  BЊ=BB
=B33B)BuB  BGBW
BШBƊ=BəBŮBBՏ\BBuBGB˸RBBBșB
=BǮB)BȔ{BƣBfBŅBGBfBzBW
BB  B\BB.BffBqB=BaHBBaHB(BBLCBC\C C {CGCCCqCCW
C
{C	{C!HC	 CCC޸CqB B.BBpBLBGB\)BW
BхBΙB8RBW
BBHB{BB\B(B
B33B33B̏\BaHB8RBսqB
=B螸Bճ3B B#BǮBýqBBfBGB¸RBǮB΀ B\BGBuB  BÊ=BBC3BQBW
B33BB B8RBqBBpBQBpBBϣB8RB؅BǮBBBޔ{B(BkB\)BQB߸RB8RBfB(B\B
=BBBBߔ{B.BzBBRBBBBQB  B
=B(BB=B\B\BzBaHCBC{B=BBHBW
BqB.B8RBBBffBB8RBzB  B33B)BRBBB=BBمBLBBpBBBffB̀ BfBBʅB͸RBzBzBffBǮB{CBڏ\CBBB\B  B
BkBzB{B
=B B#BzBB8RB33B
=BʽqBӏ\BΞBW
BBW
BuBB33BӨB=qBܙB\)BB\B{BaHBffBffBuBB٨B\BHB=qBB{BBRBBW
BGBB\BBBLBBB\B{B\BBؽqBCs3C3C xRBaHBBԮB8RBٔ{BB
BfB
BBfBkB3BޮB֮BHBڳ3BǮBڞB.BBffBB8RBB{BBǮBBԽqB33BBՙBQBՊ=BBBBӮBzBB33BѮBGBˊ=BҽqB{B  BǮBɊ=BuBuBBffBGB˞B̸RB33B\)B{B=B=qB=qBߣBۅBaHBW
B33B
BսqB33B(Bճ3B
=B\)BǮBkB33BBBkB{B8RB
B
BՀ BaHB
=BBB\B=qBuB׽qBGB֞B33BB؏\BB#B8RB؅BBۊ=BBuB33BB܀ BBBB{BBB#Bـ B.Bڳ3B׳3Bה{BظRB
=BffBLBؽqBBffBBB޳3BBHBQB.B{BpBaHBמBQB=qB\BQBBBBǅB#BaHBLBBBҙBB.B׳3B=qBBpB\)Bӏ\BBffBkB8RBݮBBǮBBBBB.BpBߞBkBBffB.BB(BBBBBB33B
=BB=qB)BuB.B٨B
BۅBB(BBܳ3B8RBހ BBGB\)B.BuB\Bה{BӔ{BffB=qBB(BBLB˳3BBQBȮBuB
=BHBpBЙBuB͞BffB
=BîBų3BLBaHBƮBpBpBèBfBBfB33BpBffBBW
BBffBҨBπ BBBLB
=B B8RBBߣBߊ=BBBݣBBzBRBBB3BBBB33BLB{BBQBәBBBҊ=B  BkBLB)Bڏ\BBpBBٙBԽqBՙBHBB{BBBۏ\BǮBϊ=BϞBBB˽qBǮB=qB̨B̏\B8RB.BLBBB{Bʳ3BȔ{B33B˨B(BHBaHBfB  BfB33BQBkB.B=qBBʣBGBuBGBkBǮBǊ=BBʙBuB(B̸RB#BQBǮBBي=BfBBBۏ\BǮB.B  BͅB
BB\)BѣBpB\Cs3C@ C B8RBB\)BqB.B=qB33BBkBuBBϔ{BBBBיBHBBBBaHBGBףBffBffBzBffBBޏ\B݊=BB B#BBBfB33B(B  B
B(BQBמBfB߸RB۞B(BQB=qB=B3B
=BW
B)BBLBaHBffBѳ3B  B
=B(BaHBLBHB֮B)B֙B(B˳3BBǮB
B
BGBBBͅBfBzBπ BBBBpBѣBW
Bъ=BӞB#BӣB)BfBpBffBLBݙB(BǮBQBpB=qBHBBBBӣBBBр BѣB#B\B=qBBpBѽqBЀ BӸRBҙB(BнqBя\BBB(Bҏ\B\BLBBׅB=BBBB#BzBkBkB߽qBaHBqBBBBW
BB  B33BHBڸRB.BBW
BffBνqBؽqB
B=qBBpBpBBB BpB{BaHBݽqBfB)BffB=B)BBBHBW
BBLBB#BGBLBB\BHB\)BBB8RBffBBЊ=BԙBڅBܣBBB߽qBQC+BpB33CCC.C 0BfBB\B{BC
C=qB(BfCffCBqBzBBBBBB
BkBqBRB3B33BBB  BGBߨBGBBB3BzBW
BuBB֮BffBGBW
BǮBυBpBffB)BBkBHBBffB.BBkB\)BzB\)B#BW
BЀ BB
=B{B#B
=BB\BνqBԔ{B)BGB\BpBBɔ{BBʨBffBBˏ\B˽qBB
=BͣBΨBkB)BЏ\B؊=BHBBBB3B.BC {BBBHBBBBzBB33BuBBBڮB#BӣB33BBB=qBLBνqBBW
BBBBǮBzBBBW
BB(BBQBˊ=BzBB\)BǽqBQB=qBffBGBfBBkBGB  BƊ=BHBfBɅBșBB
BfBǀ B=qBkB)BîBBkBǮBB33BģBBŏ\BGB8RB=qBzBaHBήB(B#B
B̽qBBBօBaHBBzBמBBGB\)B33B33B33BfBBGB
=BffBBBB=qBW
B)BHBԙB.BB\BԽqBB=qBBҮB.BaHBBԀ BB  BB=qBӸRBuB
=Bͳ3BϽqB΀ BϏ\B{BΞBBBB)BBϳ3B33BҽqB  BBՙBB֞B.B.Bπ BLBBBΞBǮB̳3B{BaHBBBGBBGB
B\B33BΞB#BѸRB.BaHBzBبBُ\B)BBBBB\BǮBؙB֞B  B)BУBBѣB  Bݔ{Bـ BBB۞BuB\BBaHBHBBڮBޮBW
BpB
BpBڽqB(BffBBB  BBffBC{CnC	{CCB)BBQB33B
B=qBpBuBkBBBBffB{BzBӸRBzBBBъ=BѣBϮBϏ\BϙBkB(BfBffBBHB#BBԙB
=B#B҅BͽqBB#BBHBӣBzB\)B۔{BB\)Bس3B33B۽qBۀ BծB(B33B{BpB
BӽqBBBُ\B\BffBQBB
=BBBBkBBB\)BLBLBRB3B\BqBHB\BpB)B{B8RBǮBBRBB BRBHBfB\BRBW
B=BBBីB
B\)B=qBǮB
B8RB\)BBuBє{BѽqBڏ\B׳3BB=qBaHBBB=qBBpB۳3B
=BfBݳ3B
BfBBB BQB=B{BkBBBBBB
BB
BBaHB8RB\B\BBB{BB)BGB8RB3BkBBqB(BBGB BaHB{BBB3BQBBzBBB#BB\BRB.BBqBpBLB.B
BB\)BQB B33BW
BBBBBB BBBLBGB=qB{B3B\B{B)B(B.BBB\)B)BB8RBzB
=Bߊ=BRBB)B\)B#B(BB  BBǮB B3B)BBB B
=B33B3BBB=B  BW
BBGB#B
=B\BRBzB8RB33BfB=BBBRB3B=qBzB{BaHB{BB(BzBBuBaHBB\BBB BBB8RB
B(BBB\B虚B
B왚BBW
BQBHBHBqBݸRBW
BHBB\BzBǮBڞBBBGBB=BBzB(Bܳ3BaHBBޅBޔ{B  BaHBۣB  BzB٨BQBݏ\B
B)B  BaHB8RB  Bۊ=BB#BffBۣB{BBLBW
BBBHB\BB#B)B\BȀ BBֳ3BQBQB׏\BBGBffB؀ B؏\BBkBfBB33BBӨBBpB(BBBBLBBBB\BkB)B
BpBkB݀ BpB߳3B\)BBB.BaHBB BqBW
B  BqB
B\BGBaHBBB\)BzB\B
B.BW
B8RBBǮBW
BBGBuB)BݽqBqB߮B
BQBފ=B݊=BpBǮBB  BQBBBBBBߙB)B
=BaHB=qBfB33BިBB(B
=BffBۨBBܨB܀ Bܳ3BBBڽqB٨B#BܨBܽqB8RBBGBGB{BܮBۊ=BkBBBkBڮB8RBkB٣B)Bה{BBQBљBр BffBя\B\B.BLB٣BڅBfBBW
BǮB8RBfBה{BԣB=qBfB)BBԙB
BգBfBҮB(BuBBBB=qB.BҔ{BBШBBaHBәBzBǮBLBBBɮBLB.B\BffB)BW
B΀ BBaHBǮB
=BuB33BLBLBBB
Bӳ3BzBԏ\B(B
BffB)BzB33BW
BBǮBΊ=BBLBǸRBȔ{B(B#B\BffB.B  BpBpBHBB҅BW
BڣBBkBBW
BBBzBBfB.B  B  BaHBBHBBffBBؽqBpBBɊ=B
=BGBBaHBBBĸRBB˸RB  BzBQBνqBaHBӣB33Bس3BB#BBBBffBǸRBaHBGBɸRBaHBЏ\B\)BQB  BzBǮBGBЅBр B8RB  BШBОB\BLBBҸRBя\BB
=BGB
=BLBҮBB  BB
=BУBHBkBBхBՙBB=qBpBaHBBӳ3B)BBBW
BօBӨBҳ3B=qBuBHBkBҽqBW
BpBBBԊ=BW
B֨BGBָRB{BpBHBֳ3BոRBuBBBӞBǮB֨B(BҔ{B33BfBǮBBB  BԀ BQB(BB=qB)B
=BBzB8RBǮBkBBǏ\BBkBBkBΏ\BBBϞBLBBB
=B=qB\)BpBʨBʳ3B̨BBBffBpBBBʊ=B8RB̳3BB\)B(B33BυBΙBQBB33BǮBffB)BqBƣBBȞBĨBĞBBQBB33BkBƞBBfB{B33B
B
=BǮBfBBB
=BzBҞBўB33BBBBffBLB֊=BQBkB  BӮBffBaHB.BBaHBaHBBB۳3BBمB\BfBB
=BШBB(B{BͮBzBBBLBHB{BBB B33B  BGBffBBuBШBB\BpBBʳ3BB33Bɳ3B
=BzBΔ{BθRB{BҽqBր BaHB̀ B̏\BffBBBBfBǮBfB33BB\)B  B)BBLBQB\BΏ\BϏ\BffB\)BԀ BBkB(BBB33BBLBBBǮBB݀ B.BB枸BW
BuBBRBuBǮBǮBkB݀ BuBۣB  BBB٨B  Bܔ{BuB(B♚B#BffB.BfBӊ=B׸RBLB
=B33Bӏ\BBƔ{BBffBBaHBBŊ=B(BkB=qBB
=B{B\BW
BظRB)B߸RBHB)BW
Bڊ=B۳3BuBBBBfBuBaHBҔ{BԞB=qBBBBٔ{B\B
BBuBBfBBaHBݣBس3BkBLB#BBuB=BBBLBݞBQBB#BݽqBHB=qBW
BBBuC \CC CaHC HB33B(B33BzB(B)BzBBBB癚BQB\B\B݀ B.BaHB֣B=BݮB߅BLBpBGBHB\BfBB{BB=qBfB33B)BzBBBϽqBΞBBǮB  B=qBBBqBBHBBBɀ B33BBîB\BW
BBB
BaHBB)B33BQBBΣBuB؀ Bٳ3B\Bӳ3BҸRBuBBB)B˽qB\BB
BfB.BԙBffBؔ{BB
B#B
=BBظRBkB؏\BaHBGB)B\BܸRBBaHB
BLBҳ3B33BGBQB͔{B{B{BB=qBB\BОBLBaHBθRBBǽqB
=BaHBǙBǮBBuBB(BQB\)BkB=qBƙB͞BBHBLBBB8RBBʣBBˏ\BBBpBBB  BԊ=B.Bг3BzBzBBfBўBҊ=B33BkB33BB\BLBBB׏\B
=BHBB33B۞BۙBLB)B֨BǮB֏\B  BBGBיB؅B\B
=BӀ BBBffBpBpBЮBBB=qBBB{BkB\B8RBȮBˮB{B)BLB̀ BBǮBzBuB8RB\BGB̨BBBҀ BBBpBffB8RBHBǮBՀ BffB̽qBBzBaHBBʣB̏\B8RBHBffBɀ B.B{B{BBGB(BGBB˙B)BB
=BGBB33B\B)B  BД{BBBW
BָRB  B  BB=qBLBffBݏ\BaHBfBߣBBB33BHBpB\)BB BBBkBkB8RBBBpB.B䙚B B\B33BBGB\)B=B{B)Bߊ=B)B  B BRB(B8RBBB۸RB=qBzB\B\BB
=B#BݞB؀ Bݳ3BLB
=BܣBǮB33BBՏ\B\BԞBҳ3BaHBҀ B33B܅BBQB.BzBBB\BBٮB\BԮBQB
=BLBܽqB
BӅBkBծB֙B
=BظRBaHBԸRBB؅BBfB33BBHB=B\)B B=qBRB33BqB(B BǮB  BQBpBLBLB.B#BBB۞Bߏ\BpB䞸B  BB\B  B33BǮBڞB
=BB)BGBffB.B)BݨBB)BLBB.BW
B#BܞBޣB=qB۽qBۨB  BpBW
BօBոRB)B׮B  BBҸRBǮBϙBzB(BҮB\)B.BBffB33BϏ\BQBBг3BpB8RBҨBBBӊ=BGBҔ{BBGBBHB#BՀ B#B\)BBBBBڙB\B33BBߏ\B(B=qBW
B.BBޔ{BB  BBBaHBffBBBBpB3BB垸B B=BkB.B
BzBaHBǮBǮBǮB8RBffB.B8RB(BffBأBׅBfBzBۮBffB
=BQB
=BۮB
BzBB܏\Bۀ BBԏ\BffBϞBΞBW
BBLBҀ BѽqB(BW
B{BuB#B֏\BBЀ BkBB.BB{BBuB
BܣBۀ Bܳ3BGBW
Bس3BuBB
B)BBfBQB\)B\)BW
B33BBHBBpB8RBGBӔ{BԣBՀ BfB֔{BׅBרB#BؽqBB  B׽qBuB)B=qBǮBBB33B
BW
BBuBBمBB8RB(B(B.B)BљBkBӅB͊=BB.BQB(BW
BzB\Bݏ\B߮BaHBBBHB{BBBBBBBB=qB
=BLB)BzB{BӨB(BυBuBzBBB.BQB\)BffB\BBuBֽqBǮBuBffBB(BͅBB
BͨBB(BBpBʳ3BffBQB  BѨBGBҽqB=qBuBԞBLBBB8RBB)B33BBBBzBW
BB33B)BBBW
BљBҙBGBBkB=qBBBffBBѳ3Bг3BB.BңBBQBҙBBхBaHBQBfBBЅB#BД{BBBBzBє{B8RBѨBfB.BרBОBBzBW
BB͞BLB  B(B͊=BfB
B=qBuB  BB\BpBBBBǮBpBffBBΊ=BB
BW
BQBpB
=BхBkBkBQBBBGBֳ3BǮB\BָRBuB(B#B׽qBǮBBBծBׅB\)BzB33BuB֊=B#BBB.BBԏ\BBǮB#B{BBHB\B\)B{B8RB
BЏ\B\)BѮB.B(B.BGB{BǮBǮBkBԊ=BB
=BW
B\)B\)B.BӀ BGBҏ\B
BBBѣB
=BBkBBBϏ\BW
BBє{Bр B.BǮBzB33BҊ=Bӳ3BBBBԅBpBԊ=BBBԳ3BuBոRB{B.Bس3BkB֣BkBGBBBzBBzBۣBzB݀ B(B۳3B޽qB{B8RB\BBٽqB۞BBBkBمB  Bس3B#B(B{Bڊ=B
BW
BBBBBGB{B\)B
B׏\B\BǮB
=B\Bޔ{B(BaHBBQBBBkBBBB#B3B鞸B8RBӊ=BzBBfB׳3BǮBB\)BB#BuB{BpBQBaHBBfB
BݨB(BBB䙚BBW
BBمBиRBpB=qBBĨBBǙBBǣBBB΅BpBffBzB#BBЙBϏ\BffB=qBB
BBpBօBBٳ3BBBfBBB(B#B33BۅBܣBpBۅBfBLB݀ B܏\BQBffBHB)BBޅB
B
BkBBHBuBBpB  BaHBԊ=BB֙BՔ{BBBٳ3B\B BB.B  B#B=qBոRBB8RBոRBHBfB\)B#BޮBB֞Bӳ3BBBBB.BpBӊ=BǮBW
B{BW
BW
BBBB)BuBHB
BBBBB߮BHBuBBqB
BB{BޙB33BpBܣBǮBW
BB=B)BߣB(Bؔ{B  B
=BBؽqBBBٸRB#BzB)B{B
=BBaHBBffB=qB8RBpB֙B
B)BB֣BծBBzB#BЊ=BB.BǮBfBLBkBԅB8RBzBǮBzBLBBB)B\)BBؔ{BLBfB.B)BͅBuBǮBʮB33BB)BؙB#BLB.B33B  BͨBˀ BʽqBB
Bє{BBBffBє{BОBB
=BB
BuB\BHB΅BffBϮB(BB{BԅB֞BٮBB
B
B
=BffB8RB\BBW
BBBpBݞBٳ3BBBB8RBͅBLB
=BBƽqBǞBǳ3BfBzB
=BuBBǮBHBB\B\)B
BBг3BB)B
B׳3BaHBkBǮBBffBΣB(B=qBBBǅBBB\)B8RB˔{BffBHBW
B#BW
BBřBHBB#BBãBLBGB)BB\BaHB.BBpBffBaHBBƣBzBzBQBƸRBaHB8RBaHB  B˳3B
=BffBfB33BBzBQBpBW
BBBي=BڸRB.B݊=BLBݙBffB߳3BܮB׏\B.BڣB#BffB  BިBߙB\)BBfBފ=BpBW
BW
BBBQB(BGB.BzBB\)BpBϸRB#BB
BͮBͳ3B͞BǮBpBBBQB=qBGB̊=BǮBzBBQBaHBHBBfB B33B#BRB(BuBffBaHB33BʅBˣBʀ B33BGBBBBBȅBɳ3BBȮBQBBQBW
BBɸRBʸRB˞BB̏\B̮BkBuB
BLB)B\BBՀ B׏\B)B׏\Bה{B)BBљBѮBW
B\)BҙBҀ Bҳ3B\BaHBǮB)BBHBB.BpB(B.B8RBBҞBBffBǮB33BՀ B׳3BBzBǮB
=BpB
B{BBBԳ3Bӏ\B؀ B{B΀ B=qBBBQBǮB33BBBaHBBBBLB{BuBBB#B33B
=BӽqBգB؏\BB\BڨBڔ{BמBHBг3B33B(B
B(B8RB\)BBB
B8RBυBπ BBBkBB\B҅BBBLBB{Bԏ\BǮBԙBBBBGB\BpBBB֙BօB)BҔ{BGBkBҔ{B{BfBuBәBBB33BҙBpB
B33BBѳ3BQBHB
=B)BB)B
=B\BzB
BffBW
B\)B\Bҳ3BBffBЊ=BЅBpBuBͅBQBfBB.BШBLB  B\BB
=B՞BǮBǮB
B݀ BB\)B\BpB
=BB׀ BaHBBfBB#B{BB{BݞBBHBBǮB
=B\)BzB\)B
=BfBᙚB(BHB߅BBBB݀ BܞBB  BQB#B=qB\BBW
BBW
BBW
BǮB\)BԀ BGBkB{BW
BBQB8RB)BۅBBǮBBpB垸BBBffBBؽqB(B۸RBB  B
=Bɔ{BzB  BȊ=BB{B
BLBfBGB)BǮBB#BBB(Bڔ{BBݙBGBLBLB{B.B晚BGBB=qBB.BGBuBLB(BqB33BB{BBBLBfB
=BB)B=BaHBpBLB\)BGBBRBB(BGC{BC:C =C YC 
C C HC CB
B\)CqB  CQCHCC+CcCC=C )C C+C)CC
W
C
C@ C\)C zCC C\)C BffCBffCBLBkBqB=qB\BffBGB
=BB3BfBQB8RB33B=qBB#B8RBfB.B33B#B33B\)B  BkB B3BBBkBRBǮB
=B֏\B.BB\BGBBBԞBfB\)B
=B߅B.B)B{BW
BBǮB{BaHB  BffBBBB뙚B\BB B\BuBRB33B  BܙB۳3B܀ B)BܸRBuBBffBQBuBQB8RBBLBBBBBǮB\BQBB=B  B(BBBB#BᙚBB\B#BݣB3BQB=qBBڽqBHBGBGBBpB(BB
BHBQB\BBB8RBffBuBB BaHB
B߮B
=BB#BpB\)BǮB3BaHBBGBBBBpBaHBzBB8RB=B.BBfB)B33BB\BB\BffBBB BBffB.BzBGB#BkBB)BBB\B׊=BBB(Bؔ{B؅B\)B\BuBW
Bٔ{BaHBۙBިBBBLBٮBBޣBBQBB  B{BϨBBB)BW
Bр B33B  BB8RBuBЮBҨB#Bӊ=BW
BHB=qB֏\B  B
B33BzBBffBffBkB  BܞBfBzB{BffB\B)BBBQBkB=qB)BB BBzB8RB8RBߞBBݳ3BBpB#B33B33BBBBՙBGBuBיB(BffBڀ BBBfBQB\BBހ Bߏ\BLBfBڳ3B(B#BffB
BۙB.BGB=qB#BfB\)BpBخBؙB׀ BBQBBB\Bٔ{B  B؊=BLBBBԀ BԅBB(BLBBpB=qBڣB#Bޏ\BaHBRB
B݀ B\BkB=B)BaHBffBB\BkBkBB
BffBB=BqB33B߸RBBffB B{BfBfB  B.B♚B߳3BLBRB
=BuBB{B3BBpBB{B枸BaHBBuB\BB
BuB.BףBبBBB  BָRBB
Bה{B
B(BB(B\)B=B  BB晚B#BB߅BHBB=qBBHBBpB\BBߔ{BBBۀ B.B#BڞB8RB\)BBޏ\BB۽qBǮB{B
B޽qB(B{B\)BǮB{B䞸BីBHB(B33BB噚BuB33BuBBB{BBB홚B#BQB鞸B=B=qC=C BBBkB
B{B{C &fCs3BB8RBuB.BuBGCcBB\CQB)B B{C@ BQBBGB\B)B33B߳3BB33BHBW
BaHB#BfB枸BuB  B33B3BLBBQB)BQBۀ BծBaHBB)B֣BW
B
B׊=BܮBuBԀ BpBB#B
BٽqBB\BffB33BaHBۙBB
B.B߅BB33BkBڮBីBBB=BaHBBB)BB3BB3B\B8RB{C\CCBC CCCGBB3B{B噚BBHB
BHB
=B
=BHBaHBBBݙBHBB)BBܳ3BBQB
=B.BBzBfBzBBB.BB)B
B(B\B33BBـ BzB\BBfB#B(B\)BB.B\)B(Bӊ=BffB)BuBBBΞBѨBQBkB\)BД{BҀ BHBBBB  BzBLB8RBݮBQB.BHBBBLB㞸BBuBݣBW
BLB
BB8RBBB{BB{BGBLBfB8RBۨBW
BkBۏ\BBaHB
=BٸRBڨB.BLBzBzB֙B{BBր B33BfB#BսqBfBB.BLBՊ=BGB\)BڙB(BǮBBLB=qBǮB\)Bـ Bֳ3BHB{BW
Bؔ{B#BףBuB
BBبB{BBӽqBӨBҽqBҨBҞBӣBLB\)B)B\)B۸RBܸRBՊ=B.BffBpBBBǮB  BW
BRBaHBB߅BBB.BLBRBRB B\)BB\)B\BBBB\BQBޮB
BB(BkBBBLBBBW
BW
BBBBkBB8RBffBB  BBBBLB33BB=qBB
=B=qBkBBBBzB\BW
BB B=qBB=B33BHB=BRBBBBB3BBLBBBB\BB(B8RBQBW
BBB۞B\BuB(BǮB33B{BBB\BBkB(B\)BBBس3B۽qB8RBٙBڸRBBᙚBGBLBzB(BB
=BqB3BߣBBQBpB(BBBܸRBuBB8RBkB33B\BuB  BfBHBBBGB=BB=BHB3B3BfBB왚BRB
=B  B  BB(B{BBkBffBBBGBBHBW
BBBBB\B3BHBB8RBHBBLBBB33BGB33B)B
BHBBBkBBpBRB\)BB\)B8RBB8RB.B3BqBW
BBǮBBB8RBW
BB\BB3B3BB{BfBB)B(BBB
B8RBfBB=qB.BBuB=B  B3B\B3B(BBB=qBBB♚B䙚B
BLB߮BݙB(B\BިB=B8RBkBqB\B
=BpBuB
BffBBB\)B=qBpBBB33BuBB=BffBHBqBHB=BB\B#B
=BB(BfB3B#BGBqB\BߞBBkB#BLB8RB޳3BW
BW
B{BBߊ=B)B.B33B=BBBB)BpB.BB䞸BqBQBB(BBB
=BRBfBB\)B B{BGB{BLBLBRBfBpBBBaHBBkBLBkBBBBqBqB=BBuBffBGBW
B޳3BW
B\B\BBBB(B۸RBBBۨBBfBBϽqBB{BBBHBր BuBרB(BB׊=BٙBB֏\BQBuBBffB
=BܸRBpB#BޮBؔ{BBB߳3B.BB=qB
BHBBfBB܏\BۣB8RBQB)B\)B33BfB֙BzB#BBսqBיB֮B33B=qBǮBǮBQBB׽qBր BHBBBǮBkBkBqBB߀ BB߳3BBݏ\BBߞBBݸRB{BBѸRBBBٮBLBfBzBB\B
BGBٳ3BָRBBkB33BHBQBBBffBBuBָRBBШBʏ\BBB\BkBҔ{BBB=qBϊ=BυBuBѽqBΣB.BW
BҮBBΣBڅBaHBBBڸRBє{BBuB33BЙBBΏ\BǮBfBLB\BBBzBzB  BΨBW
BBBπ BҙBBǮBԮBkBuBffB؀ BB۳3BBݔ{BۨBuBB\)B\)BՏ\BkB=qBָRB٣B\)BBB
BW
BݨB#BuBߊ=BGBkBW
Bݳ3BHBٮBBpBB\BBB{BBLBW
B.BuB)B
B{BBW
B  BBȏ\BBfB
=BGBBBBȏ\BzB(B.BȀ BB{B\BHBBBB33B=qBʳ3BB\)BBB8RBǮB\B8RBqBuBBBǮB{BBԀ BfBaHBڞB{BBݏ\BfB֊=B\)B
=BǮB  B.BLB
BzBٙBaHBBB֏\BBҔ{BBB.BBB͏\BpB.BʮBB33BǞBBBBkBLBQB
B\BB8RB\BBHB=qB)BĔ{BqBB)B\B\BffBkBQBĮBB\)BBHB.B
B=qB
B½qB#BQBB#BffBď\BɮBuB=qḄB)BHBъ=BLBGBͮB\)BB=qBB=qBB̨BkB=qB{B=qBLBLBBfBpBBԅB
BBўBЀ B\)BaHBǮBθRBuB)B(BQBGB{BήBBfBBϏ\BBB.B33BǮBpB{B33BиRBϊ=BBήBϸRBB\)B  B=qBBӞBBBBϊ=BHB)BB
B\)B)BӅBBB.BЀ BBBBkBffB)BŮBBHBpBffBBBpBBBBBӔ{B
=BʞBɊ=BffBffB=qBpBBB
BzBУBԽqBәBBuB
=Bֳ3BBB
BBGBBΣBuB\)BBԊ=B#BӔ{BBB(BffBȣB  BGBγ3B33BaHBυBBѽqB#BffB֔{B  B=qBGBԅBLB.B׮B=qBB{BaHBր BBLBB33B)BB=qB
BBҳ3B33BǮB  BϏ\B\)BB\BGBBLBBBBBBB̀ BBaHBB.BBBϳ3BpBzBQBuB33B.B\BɣBB(B BBaHBșBW
BBzB{BHBGBW
B
BffB8RBkBpB#BߣBW
BB8RBBޣB)B{B  BޙB܊=B=BuB33BqBuBHBBB\)BffBB B BW
B\B=qBBqBBBffBpB\BB\B=B
=BffBBB.B{B  BBzBBuB잸BBB=B
=BW
B BBBuBuB(BBBߔ{B#BǮB33BkBB޸RBfBfBיBuBGBǮBɏ\BGB8RBB{B۽qBLBGBffB(BfB#B33Bߔ{B)BBfB#B#BzB)BGBǮB#B
BzB\)BBB\BaHB
BW
BpBB.BBٳ3BB)B(Bߏ\B\)B{B{BBܔ{BٮBGBW
BǮBBܳ3B\BۅBfBBW
BBҙBӸRB#BB#BGBffBffBπ BѽqB=qBљBW
B
=BBҀ BQBўB=qBaHB  BW
B)BBBfBɮBɊ=B(B
BpBB
=BBB
BB̅BиRBQBøRB  B  BB)B=B)BB(BBBBpBĮBHB\BaHBƽqBɳ3Bϳ3BǮBЀ B
BB.BuBBBffBLB#B#BpBGBGBBB.Bˀ BǮB\)BBBÊ=BBffBB)BkB#BBB
BB{B{BzB\B8RBBB=qB{B33B\BBGBkB\)BBzBW
BpBBBB{B=qBffBB=qBB)BBBBaHB(BBW
B.B.BǮB.Bˀ BLBʔ{Bˏ\BzBffB
=BfBaHBaHBB\B͔{Bͳ3BBBGBW
B˽qBHBBɸRBɞB  B\)BaHBzBϸRB̽qBuBW
BӸRBҳ3B
=B(B˔{Bͳ3B33BBǏ\B  BHBB33B{BQBBƅBqBLBɊ=Bȳ3B8RBƸRBzBffBBĊ=BBʮBBBʔ{BBBB(B\)BfBBGBzBBLBffB33BBBkB˔{B#BB\BB\B\)B(BffB
BBfBBĽqBÅBkBÙBÞB8RBRBɳ3B.BɽqB{BzBÊ=B33BGBBBЅB#BB.BBͽqB33BǮBfBB͸RBGB
Bͳ3B̏\BHB˔{BͮBBBϏ\BGB=qB{BЊ=B=qB33B)BkBzBfBBGB#BəBpBǣB.BB(BBʏ\BB
=BB̽qBBaHB̮BBBBkB{BfBfB.BzBB{B(B#B{B33B  B=BLB
BLBBBǮB=qBB\)B33B(B͔{BBuB=qBBBuBfBѨBBQB(BŊ=B8RBB8RBBfB
BBϳ3BBuBW
B\)BϮBϔ{BzBBBB͊=B)BBΞBBBBffB\BBuBĸRBɨBHBzBfB=qBkBfB8RBƙB)BȔ{B
=BBB½qBBB=qBBzBB)BǮBBzBB)BB#BBaHB)BQBď\B  Bʀ BGBpBfBBkBŊ=B\)BęBfB)B3BkBB(B(B=B#B\)BaHB\)BLB{BÙBÊ=BuBǮBřBHBBǽqBuB\)B\)BaHBBBB
=B(B\B  B˔{B
=BW
B˽qB̮B\BBBBQBLB͏\B̀ B\)Bɳ3B\)BɮBɞBɅBkBHB(BkBǣBLBBpB=qBB
BzBʅBBʳ3BBBəBzB)B\)BBǔ{BzBBʊ=BîBBB(B\)B.B(BHBkBŨB  B\BBƳ3B\BQBW
B)BǮBzBkBȔ{BzBaHBB
BffBBʀ B˞BǮBBBW
BЏ\BffBϳ3BpBBB
BBԊ=BLBpB\)BLB֙B՞BօB8RB33BzBQB{B{BBB#BBGBϸRBBB8RBBffBpBGB33BB̔{B=qBzBzB)BHBǮBȽqBȸRBkB\BBuBBBęB.BƙBaHB
=B.BţBBBǀ BffBǽqBzBƔ{B33BȞB)BLBǞBfBBˏ\BQB˞BǙBuBBuBBBHB{BzBLBaHB=qB{BBBǣB.B\)BƳ3BĀ B{BBBBǮBȳ3BffBȔ{BffB33B)BʣBLB#BW
BLB(BѨBB
=BӔ{B
=Bӏ\B=qB  BfBъ=B\BBўBBѣBpB{BW
B
BϽqBΣBϞB#Bϊ=BǮBLBpB33BЊ=B̅BB8RBϮBϙBaHBBϊ=B
=BУBkBBϣBϊ=BBB
=BͽqBνqBΨBͽqBB  B=qBǮB\)BffBB
=BĮB(BB.BĨBQBĨB.B
B(B  BBŞBƅB(Bȳ3B)BȸRBɞBBaHBaHBBBBɨB8RBGBBB̀ B8RBLBϽqBB
B  BͅB\BϨB  BzBHBBԀ BaHBBHBBB\BffBB  BffBBBўB{BB\)B=qBBpBaHBхBLBB#BuBLBϔ{B˙Bг3BkBkBǮBLBkBB#B8RBkBBǮBBLB#B͙Bˏ\BfBBzBQB=qB33B  B\)B
B.BaHB{B{BřBpBřB8RBpBBʳ3B̨BW
BνqBBBaHBkBBǅBęB.B{B\BȀ BBzBkB)BBHBBB.BfBB\B
BBBBGBB\BzBͅB#BBʳ3B.BBǮBkB=BQBBB)BBǮBB33BfBQBɸRBəBɀ BBǸRBBffBuBQBBBkB8RB
=BȅBB)BBzB33B33B33BfB
=BfBpBW
B33B8RBĞBƙB  BzB˸RBGBǮB)B=qBď\BƣBaHB#B̮BkB̅B)B#BkBǮBpBffBBBzB#BB#BƏ\B8RBGB  BʙB)BQBBQBHBaHBHBBffB)Bڏ\BأB{B#Bڊ=BڨBؔ{B׽qB{B֮BֽqBBHBֽqBBHB.BB=qB=qBaHB8RBffBծB8RBuB  BHBBBLB\)BuBҊ=B(BӞBӨBB  BB
B  B  B
=BB\)BaHB=qBʞBBW
B̞BHB#BBLBǅBBȔ{BɮBɸRB
=B
BήBB=qBffBpBGBǮBzBB.BB\BBƨBŔ{BB.BffBW
BșBBBϔ{BffBήBB  B=qBBkBУB
=BkBָRB8RBBuBׅB8RBףBLB8RB)B
BBBBB\)B\)BQBԨBpBfB33BHB.BBBB8RBˏ\BͮBˮBW
B(BBB\B(B
B
=BΔ{B#BиRBBBuB.BaHBfBHBBB٣BBԀ BхBУB\)B
=BԊ=BB҅BHBҳ3BW
BaHB
=B8RBB\)BBBBӨB
BzBffB8RBpB33BBB
B(B.BǮBW
BB\B{BըB֮B՞BՏ\BkB(BׅBB  BpB
BB\)BBBBBffBzB#BBޅB\B\BޣB  B܏\B{B#B\)B)Bܔ{B#Bڀ BuBuB8RBuB)B۳3BۣB=qB۔{B܀ B  B.BܽqB
B=qBڨBQB\BBۣBBBpBBzBڣB.BָRB֞BfB)BB8RBֽqBLBB{Bֳ3BuBǮBBQBBBkBHB.BBBB۞BBBBLB)BݙBBߔ{B۳3Bݏ\BBfB.BHBծBӸRBB
=BBBpBըB8RBBB
B  B  BpB➸B)B)BB\)Bފ=B.BHB{B\BGBBqBkBǮBޅB\)B{B=B(BzB)BkB3BRB{B
B
BB3B BB  BǮB.B#BBBBܸRBaHBaHB8RBQBݞBݸRB\)BBיBB(BԔ{BB
=Bѳ3BЅBB#BBzBԙB  BΊ=B8RBϙB=qB.BңBW
B  BB͊=BaHBΏ\BBϨB  BkBҳ3BBkBkBʣBffBĮBBQBW
B\)BυBϔ{BaHBzBӣBB  B33B\B.B33B{B
=B(B3BB➸B)BfBLBqBبBGB\)B߮BB8RBuBfB
Bߔ{BRBB B޸RB8RBBBՔ{BؽqB=qBuB\BǮBָRB.BBGBҨB
BBҀ BBB{BнqBGBϔ{BͽqBѸRBBʙBBBBLBBBîBŽqBҮBΨBǮBBBfB
=B
=B8RB̽qB)BBBkB
=B\BBBBBBLBzBBBffBBBB=qBBpB8RBHBGBBĳ3BƽqBpBŊ=BGBBǊ=BW
BfBuBȽqBBB#B{BBBB
=BW
B
BB\BBB(BŔ{BęBuB)BBffB(BW
B
BfBqB{BB.BB
=BpBǮBkBǏ\BɞBŸRB  BBB
=BǮBGBB8RBzBB8RBBqBB(BB\BpB)BB
=B8RBBˮBBȏ\BQB8RBLBBBÏ\BBW
BBų3BBBBĊ=BĊ=BŞBW
BBBQB)BQBQB
BB.BʣBˀ B8RB\B
BęBB\B
=BʣB̙BuBkB{BB.B̊=BB{B\)B#BB=qBͽqB͸RB{BW
BB33BΊ=B8RB33BBθRB#BLBQBͣB.BLB{BͨBzB)B\B̀ BΔ{B̀ B8RBθRBBffBȔ{BffBˀ B8RBB8RBpBaHBB  BkBƸRB
=Bƀ Bǳ3BЏ\B̞B)BBʞBʽqB#BB\)BW
BǮBHB͔{B\)B  B8RBB33B)BҀ BBBB8RB33BѸRBB=qBHBBkBBBzBB\)B8RB׸RBpB=qB׽qBՊ=BB٣B׸RBuBHBخBBظRBaHB؊=B
=BخB\B)B׸RBըBBpBBBԙBGBHB=qBBҏ\BҞB
BBffB(B.BBB\BaHB
=BB8RB#BW
BиRBBfB  BBBϨBͽqBѽqBB.B)B\B͞BǮB\)BҽqB̽qB՞B)B{BBҔ{BBfBBB\)BkB{BzBѽqBBB#B(BLBBبBܽqB#BzBLB\)B\BB
=B߀ Bފ=BBڅBBaHBޙB\)BB\)BW
BaHBLBzBۙB)BBQBuBBBB  B8RBGB
B=qBB٨BHBQBBBي=BzB
=BLBBpBB܅B  B
BBBQBמBBԽqBGBBBQBBճ3BϽqB
Bʔ{BQBuB.BӸRBӣBBB(BaHBBzB)BzB׽qBBBظRBBBuBڳ3BԳ3BkBԔ{BخBٮBBڣB܊=BۮBBfB#BHB؏\B\B؊=BzBB
B=qBӔ{BzBӮBӞB{BaHBӽqBӞBBǮBҨB(BBҨBzBW
BԮBB\BkBW
BǮB֔{BۮBBuBǮB؅B=qBffBkBُ\B33B{B؏\BLB
BӮBBӨB33BθRBQB(B{BBB  B\)BиRBǮB˸RBўB33Bӏ\B
B\)BBBBBBB8RBLB{BQBď\BBzB8RB(BQB{B֊=BָRBpBHBB=qBBHBԽqB33BB33BҞB#B
=B.B
BӣBBBҏ\BffBBBBԅBB
B8RB׽qB
Bֳ3BսqBՊ=BսqBkBԮB  B.BǮBLBBըB\)BffB#Bӏ\BW
BBԞBԣBәB=qBLBӣBҽqBaHBpBBuBǮBәBW
BBaHB.Bҏ\BҞB(B
=B
BzBBLB
=BffBЮBGBЅB\BBBBʏ\BQBǮBfB(BҀ B#BW
BpB\)B˳3B8RBffBBϳ3B#BuBkB#BϽqB
=BBaHB.BυBLB#BpBBaHBЙB33B#BBBBօBB\BBօB
BָRB(BBkBBLBԣBԳ3BԀ BaHBBzBԮBԞBW
BBzBzBԀ BkBB=qBBӊ=BffBHBҨBӞBpBӀ B{BQBBӀ B
=B)Bѳ3BpB#B
=BB\)B͊=BB(B#BHBBϳ3BGBϞBBBB(B{BLBє{BBǮB.B#B=qBҞBBuB#BzBЊ=BBϨBpBг3BzBBBӨB=qBԅBB֔{BfB׊=BffB#BpB؏\Bٔ{B٨BBBpBBٸRBBڔ{B8RBǮB33BٙBBۊ=BמBkBٸRBBمB  B#B{B׊=BzB\B؅BǮB=qB׊=BǮBpB
BzBGB\BBBԞBBBB\BBٮB٣BBǮBffBBՊ=BaHBkBB۳3BpBLB8RB\Bה{B
=BpB̮BBBˣBʞBОBBaHBBHBaHB.BffBkB  B\)BB33B˔{BǮB\)BB=qB=qB(BGBBB؞BBٽqBfB\)BfB
B=qBB\B{BB=qBB\)BǮB{BBHBkBB\Bӳ3BW
B)BuBB\)B\BBffBڮBB\)BBpBHB׳3B=qB\BB\B=qBB\)BBkBGBBQB  B#B33BؽqBBרBfB׏\BׅBBHB
B׽qB׳3B#BՙB)BB=qB
B.BBBٔ{BBՊ=BBBuBuBHBܔ{Bڏ\B33BǮBBѳ3BՀ B՞BՙBBkB=qB؊=BBB(BGBBB(Bފ=BB\BLBuBBBǮB=BBHB
=BBfB\BQB3B3BߞBB\B
=B.B{Bۏ\Bۀ BHBB{BBW
B)B.BuBBօBBB
BzBBBأB؞B\BڞBuBBffB{BBֳ3BkBǮBpBfB\)BԞBBkBգB
=B33BӞB  BB=qB=qBϮBQBzBaHB=qB  BB#B҅Bҳ3B\)BծB\)BB(B#BzBpBޣBBBpBkB=qBfB8RBBBzBLBޔ{BGBfBzB\)BqBQB=qBB䙚B8RBffBffB\B{B=BBW
BB BBQBB8RBkBaHBpB33BݣBBBB\)BޅBkBHB8RBۏ\BمB.B=qB؞B)BըBpBBzBGBBҏ\BW
BHBBBW
BBBBB=qB(BfB8RBB#B׽qBHB.BӨBӸRB\)BؙB)B8RBس3B)B8RBB3B#BڽqBBBBݏ\B
BffBfBzB
=BqBB
BpBB3BaHBBB\BLB)BaHBuB߸RB{BBQBBڸRBՏ\BBBHBGBӮBBԙBW
BB\B\BB֨BǮBLBبBffBBڸRBي=BBB  BBB)B.BBBkBBBGB  B\BBBފ=BzBB{B޽qBBBBݨBڣBٳ3BBffBޅB۳3BB)B33B8RBB\)BW
B{BB3BBaHBuBpB33B\B33BB BBQB3BB
=BB݊=BBuBQBхBffBBuBLBB٣BǮBBרB=qBffBBB=qB{Bـ BGB#BBBaHBǮBBܣBpB\)BHBffB
=BuBBB)BՏ\B8RBٮBؙBpBGBӮBkBҸRBB  B  BBaHB.B33BW
BB֮Bր Bր B.BfBzB33BkBB֊=B#B  B\BՀ B.BՅB.BuB  B8RB̀ B҅BǮBfB)BfB\)BBϙB
=B)B33BʽqBBHB\)B{B=qB(BLB=qBԞBaHBԸRBԣBGBBҀ BBkBffBBGB
BӮB
=BBkBaHBLBBBfB(BǮB8RBB.BHBBB8RBBHBQBGBўB\)BBBг3BffBѸRBLBиRBffBϳ3BνqB33BHBffB=qBkBД{BЮBkBя\B{BЙB=qB#BBϳ3BfBϊ=BBυBBBfB(BLBϽqBЊ=BB33BHB=qB
=BuBҽqBBЀ BHBB\)B8RBBBBzBfBӽqBBԙBԏ\BB33BՔ{BօBBkBB#Bؔ{BبB.Bـ BLBB\BB׽qBB֣BHBՙBBBkB8RB՞B#BBBԏ\BՅBԳ3BB#BW
BB
Bԏ\B(B(BBfBB҅BBpBGB{BzBĸRB=qBBW
BLBBW
BkBGB̽qBʊ=BυBGBBGBB΅BBBBBB.Bɏ\BBzBǮB
=BHBQBW
BәBBffB\B#BGB׸RB#BQB׏\BؽqBٮBHBڳ3BB۔{BBaHB٨BkBۮBpBBܮBqBBB=qBBBzBW
B#B(BB8RBzBW
BBǮBBBBB)BݸRBB33BBBۊ=BB=qB  Bڏ\B(BaHB#B؊=B؀ B#BBffBfBBє{BхBЮBͮBͮB\BBHB.B
B=qBB8RBGBԅB.B#BuBuBϣBuBϔ{B  BW
BB33BѮBHBҨBӽqB\)BBB֊=BfBLB\BHB
=BffBBLBծBרBؽqB#BBffB33B  BܞB{BLBfBB=BfBBffB=BBBBBBQBHBBHBRBBGBBǮBW
BfB=qB.B(BpBkB\B8RBLBuBqB
=B{B
=B.BBQBB.B#BzB)BǮBfB֮BaHBB؞BGBfB.B\)B8RB.B؏\B׸RB\BӸRBBǮB  BHBuBGBBB(BǮB
BBB)B(B=BRBB  B B{B{B{B#BpBBBB  BRB#BGB  B(BB8RB\BpB
B)BRBaHBzB晚BW
BǮB\B  B垸BǮB33B=BBB\B=qB8RBaHBBBffB=qBB(CCBCǮBBQB垸BBHBBBBB{BBqBpB.B  BuBB8RBBޣBB܅BLBBBBBٽqBBzBBB׳3B.B\B۸RB8RBB؏\BW
BBBB#BuBBfBRBpB BǮBuBB{BBzB{B#BQBBBBLBB{B{BRB
B噚B
B{BfB=qB=BBB B3B#BBB
BW
BݣB(BB.BǮB33Bݔ{BkB
=BۙB
BBLBLB.BqB.BfBuB33BBB#BLB{B)BBLBB.BBٸRBkBظRBԸRB=qB
=BBB33BLB֣B֊=BaHBׅB8RBBffBzB8RBuBffB(B
BHB\)BҀ B=qBՏ\BօBǮB  B#B=qBffB=qBڀ BB(B
BzB\)BGBB
=BaHBB8RBBuBRBBHB)BGB  BBBB3C
}qC
YCqCfCC	33CCEC  BfC C \)CCCW
B
=BBBBqB)BGB)BBuBBBGBaHBCGC5C5C qC HB.BBB\)B BBHBffB\)BBB3BLB(BB3BuBݞBB(BRBkBHBBBuBQB
B\)BW
BW
B33B  B
=B{B.B
BB
=BBBpBaHBB)B BC 
BBHBBB
=B)B33B\BBzB33BB)BqCRC
CCCYCYCHC
RCBCqC=CC
s3CnCRC	CC{CkC	\BHBW
C@ C 
BLBǮBBB=qB
B
=BBkBRB BfBpB왚BBB33BBBBRBBBQBBB33BBB.BBBLB{B{B3BBB\B BB枸BBBB8RB
BHBB
=B8RBzB
=C C ǮCxRCffCC!HCCC.C
C	)C!HCCfC5CC3CCC\C)CxRCٚCLCxRC! C%\C
CCC
.C	
C	C BGCCfCBB8RC #B.C CٚCCuC C
fC
EC
C3CB=CzBC^BBzBCCC\BpCC EB\BfB  B=qBHBQBaHB  B{B3BBQB㞸BQBHBqBRB(BuBB)BRC cC BBBLBGB3BBB=qBGBB.BC CkCC&fCffCC	{C	C:C

CxRC
s3C3CٚCfCHCT{C{CnC=qCBCCqCChC}qC(C C=qCuCRCQCCC CT{C3CC.BaHB  B33BB3BQBpBffBBBkBBqB{B\)BBBLBB\)B
=BB B#BBaHB)BpBBB=qBB B
B{BW
BW
BW
B۔{B33B۽qBڸRB
BQBB)BB鞸B3BBfCC޸C)CٚCC8RCCECffCBC  CǮC{C	
CCO\CCCC8RC
CCC#CCC C  C\CǮC	RC
kCC{C޸C
C
 CRC!HCGCQCB{B#B BLBBpB홚BB3B\)B잸B瞸BHBHB\)BGBBffB\BW
BBBǮB뙚B{BB3BuBaHBpB
BB\B(BߞB{Bܳ3BGBՅB\)B#B۳3B  BݣBBQBHBW
BfBBW
B=qBݙB{BHBBBffBpBQB33BBǮB\B  C  BLBGCW
CChC	C
{CC=CCuCGCCCC{CCO\C {CLChC=qCcCCqC	CCC{CO\C CCffC:C=qC {B
B)BB  BfBߔ{B{B.BBLBBW
B=qB.B=qB33BBꞸBBBQB
BzBBkBBkB\)BkBzBBkBW
BLBkBB#B#B
BffB8RBW
BBkBffBBBLB
=B=qBُ\BBBBzBBuB33B33BBB(B(BB8RB.BuC HC\)ChC
C3C
33CCC	HCC{CCCs3B\)BQBBǮBBBB.B{BڙB33BGB׳3BףBB{BBמB{BGBfB֙B؀ BGBיB#BLBkBBuB{BaHB߮BLBffBB#BfB.B
=BB=qB
BBǮBϮBBЀ BLBBBўBя\BBнqBўBfBBBBˮB̙BW
B{BB8RBuB\BW
BB(BuBB=qBBЏ\BиRB
=BHB#B#BW
B
=B\B#BBHBٙBzBي=BGBѸRBBBծB33BLBzB)BzBzB{BѣBхBLBъ=BљBр BuBzBB8RBW
BBuB#BBBBfB)BхBLBѮBѨB8RBHB)BW
BuBQB)BBBЮBЀ BОBBB8RB{BхBОBг3BОBffBLB(BHBpBLB8RB33B\)BBGBB8RBъ=B(B  BuBfBѮBШB.BϮBkB  B\)B  B
=BљBя\BfB#Bє{BϨBGBϞBBpBffBffBuB(B\)BB)B\)BffB
=BaHBǮBBѨBє{BнqBuB{BBLBkBHBъ=BW
BuBя\BBkBaHBӸRBffB)B)B
=BB#BpBя\BBг3Bг3BQBBиRBuBB  B.BBaHBОBaHB33BиRBBkBг3BHB8RB\)BffBѣBǮBHBўB\BЅBW
B#BҀ B  BBBЊ=BϮB\)BQB\Bя\BҀ B(B  B
B
=B\B
=BGBkBBBBBѳ3BBУBѨBBBиRB)BBъ=BfBϊ=B\)B8RB=qBѳ3BBBBBLBОBfBϳ3B
BB  BpBffB\)B.BBpBpB#BB#B
BGBBuBffBҳ3B#BѨB(BнqBǮBЊ=BzB
BfBя\BУB\)BpBQBzBzBѨBQBљBǮBGB\)B{B8RB
Bр BQBўBBB\)B8RB҅y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AGAɅAʏ\A
=A(AA(A  A
AA=qAffAȸRApAǮAQAǮA=qAǅAǮAȸRA33AʸRAƏ\A(A  AAȏ\AɅA(A
=A  A=qA
AÅAģAȏ\AGAAzA(Aď\A\)AƸRAzAQAzAGAGA33AA  A33AA{ApAĸRAAAŅAGApAHA¸RA=qA=qAQAzA
A=qAA=qAAGAAÅAHAAffAÙAAzA\)AAA
ARAAA=qA
A
=AAAAA33A\)AGA\)A¸RAA
A\)A{AŅAŅAQAŮAzAA  ApAA\)AƣAAAGA\)AAQApA33Aď\A
=AzAAA
A
A(A{A\)AHAA(AA{A33AAď\AA£ApAAzAřAď\AÙA¸RAAQAA
=AAGARAGA{A\)AAzAAA\)ARA\AApA
=AApAAřA{AQAŮAŅAGA
A
A{AHA\)AǮApAƸRAA33A\)AAȏ\ApAǅAAA\)AGA
=AəA  AQAAffAzA
A\)A\)AApAHAAAA
=AzAAffAʏ\A  AˮA
=A˅A
=AGAˮAȣA
A(A=qAAƣAŅAffAǅA{A{ARA33AHAHA
AƏ\ApApA\)AAffAzAŅAřAzA
=ApAď\Aď\AGA{AƸRA33AŅAGA
AA  AA33A\A\A33AA\)AA
=A
=AHAHAGAŮAřA{A
=AQAffAAƏ\AAffA{Aȏ\AA{A(Aȏ\AAA
A
AffAHAAəAGAzAQA
=A  AHA(Aʏ\AAȸRA33AˮAʸRAHA
=AA33AȸRA(AA
=Aȏ\AGA
A\)A  AAffA  AƸRAřA{AŮA
AzAzA\)ApAģApA
=A
=AHAŮAřA=qApAHAƏ\AAģA  AřAAQA{AApAApAAAffA  AƸRA\)A
=AffA\)AAǮAAɅAǙA(AAǙA{AHA\)AŅAģAApAA33A  AQAƏ\AA
A{A=qA(A(A
A  AAHAAȏ\AffA
A=qẠA{AGAA̸RAAA
A\)AʸRAɅAAəA  A
A\)A=qAAʏ\ApAƣAffA̸RẠAAffAʸRAHA33AAAǅA
=A33AǙAAHA{A
=A33A(A=qAffAzA=qA=qA=qAǅAƣAAGAˮAʸRAAƏ\AřAAGAA
=AHA  AŮAAA
A  AffAAHAǅAǅA
AəA  AA=qAffAəAəAəAAAHA33AAHAȏ\Aȏ\A
=A
=AGA
ApA\)AʣAffAA˅AAAAffAẠAʏ\AffAəAɅAAffAAˮAffAffAυAAzAGA  AA(A
=AA˙AzAɮA{AGAǅAQA(A=qAAǮApA=qA  AQA
=AȣAɅAGAQAQApAAˮApAˮAʸRA\)ApAAAAɅA  AAGAAffA{AAʣAȏ\A\)AȣAHAAffAAəAAɅAA
=AʣA{A(AȣAʣAʸRAA{AAQA(AʸRAʸRA{A
=AAAʣAʸRẠAAApAA
=AA(AApAffAA33AˮAHA
=AGAAʏ\A  AzA
AʣAAɅAAA\)AA(AGA
AAHA
A33AffA
AA(A  AAA(A\)A£A  A  AAǙApApAŮAQAHAģAĸRAGAəApAQAʸRAAŮA
=AApAŅAƣAHAQAApAHAȸRA
=A33AɅAɮAAȸRA{AəAGAffAȏ\AGAɅAQA=qA
AȸRAȏ\A=qAʸRApA\)AA\)Aʏ\A{A33AffA
=A33A
AQAffA(AAGAAHA
=AȣAȸRAȸRApAGAAAA
=AAŮA
=AffA  AA£ApAAA£AzAǮAHAffA˅AzAzAAGAAʣAHAA{A(AA\)AzA(AQA  AffAA(A
AHAAĸRAĸRAGAŅAffA
=A
=AǙA(AȸRAApAGAAȸRAAzA(AGAQA
A
AQAǮAɅAǅAǮAQAA{Ȁ\A̸RAˮA  AˮAʣA{A\)A\)A˅A(A˙A˙AA\)A
=A˅ẠAA\)A33AHA
A{AzAQAəAȣA33A{AȣAAHAffAƸRA  A  A  A\)AƸRAAA=qApAʣAffA(AGA33A33AffA
=ApAǅA{A  AA\)A˙ApAQA(AẠA͙AͮA=qAAA
=AͅAQAffAGA
=A(AAǮAA  A{AHAA
=A\)A
A\)A
A
AHAA33AȸRAffAApAA33AAQẠApAɮAzAQAHAffA=qAffA{AA(A  AͮA33A˅A˙AʸRA=qA
=AQA
=AǙA\)ApA(AffAARAAAHAGAřAQA\)A(AzAAzAA=qAAAǙAȏ\AAǙAGAǅA\)AGAGA33AQAǅAA(A{AffA
=A
=AɅAʸRAAʏ\AAffAQAA(AQAzA(A
AHAAzA=qAGAͅA33AˮȀ\A33AʣAGAA{A˙A˙AAA(A  AAGAGAAAʣAȣA˅AɮȀ\AAȀ\AʣAA33AAGAAA=qAGAAAGA33AɮAʸRAAAffAǅAAGAɮAffAǮAGAApAAzAAGAGAŅA{AɮA  AəAGA
A
AAəAȣAGAAGAAAAƏ\AA{AȣAffAQA33Ȁ\AGApAϮAQA=qAͮAͮAffAQA{AA˙A(AAA=qAAQApA˅A˅A˅AAAHAʏ\A(AGAəA=qAʸRAʸRAAHAHAʣA(A
AɅA
A33AGAȸRA(A
AGApAƣApAGA(Ȁ\A˅A(AAA{A{AffAAAA(A=qAAzA(AGAffA¸RAAŅA
AAǮA
=A=qAQA{AŮAď\AģA\)AAzAAAffA33AAAHAQAAAʏ\AzAʣAffAʣAʣAA33A˅ApA˅AʣAʏ\AffAʸRAɅAɅAffA\)AAHApAAAzAǙAA33AA\)AGA(ApAƣAǮAQAGAA
=AȸRAɅAʏ\AA
AAzAǮAGAAǮAǮAA
=AǅA  AȣAȸRA33ApAQA
=AʸRAHA=qAA
=A(AffA  AAffA  AGApA  AAA£A=qAƣAAGApAA=qAAAAǮA
AQA=qAApAɅAȣAȏ\Aȏ\AAȸRAffA33ApAHA=qAA(AQApAǙA(AApAA  AȸRAzAApA  ApA
AA(ApAA{A{A{A{A\)AƸRA(A{AAA{AƸRA
A=qA(A33A(A{AAȸRA=qA(AAA  AA(ApAffAˮAˮA  AAzA\)A{AGAA\)A¸RAHA33AAGAGA\)AQAA(AAƣApAffAǅAAGAHAŮA=qA\)A
AffA33AGAřAǅA  AȣA
=ApA=qA˅AA(A  ApA˅A˅A
AˮA˙AAzȀ\AffA͙AGApA=qA  AAɮA(AzAAzAGAAGA\)Aʏ\Aʏ\A
AzA=qA\)A\)AHA(AȸRAzA  AAHAzA\)A=qA=qAƏ\AAAŅAĸRAîAA=qA
ApA{ApAƣA
=ARAQA¸RAAA
=A\)AGAď\A
=A=qAƏ\AAřA=qAƸRAƏ\AHAA
AApA  AAAȏ\AəAɮA
A(AffAHA\)AAʏ\AffA33A\)AA=qAffA\)AzAGApApAGAͅApAAAAAA̸RA=qA  Ȁ\AAǅA33AɅA
A33A
=A
=AHAA33AAAʏ\AAAȣAHAQA{A(AǙAGAȣAȣAGA  ApAzAƸRAQAřAA33AGA  A(A=qAARA=qAŅAAA  AzA
AGAŮA\)AřAHAĸRA33AÙAHApAAffAď\A=qA
AA
=AŅAǙAAQA(AƸRAAƸRAǅApAHA33ApAGAǅAǅA\)AǅApAAHA
AȣAHA
=A\)AA=qAɅA
A  A{AzAA33AŅAffAAƣA
=AƏ\AA
AQA(A(A=qA=qA=qAəA(AȣA
AAAffAQA{AGAĸRA(Aď\AGAHAAA=qA(A
=AA
AŅAƸRAAGAGAzAA(AAŮA  AřAAA  AApA(AA  AAzApAǙAGAHAƸRAA{A33A  AAHAAHA=qA=qAƸRAGAǮAGAAA  A  AzAƸRAAƣAHAAAGAzAAGAAAA  AǅA=qAAƸRAApAGA
=AƸRAGAA33A
=A\)AAȏ\AAHAHAȏ\AǅA(AŮAA{AHAGAGAHA
=AAģAA=qA(A
AAHA  AHAAA(Aʏ\ApAǙAAƏ\AffAA33Aď\AGApAŅAƸRAAAHAQA  AAƏ\Aď\AĸRAA(A
A  A=qAQAƣAGAA=qA{A
=AǅAA{A(A
AAA
A
AAAǅAǙApA\)AAAAAƸRAQA\)AřAGAƣAzA=qAƸRA
=A\)ApAǅAAA{AGAÙA33AAzAĸRAQAApA=qApApAQA  A¸RA\)A{A
AARAAHAA33AGA33AffAHA33A
=A\)A£ApAGA
A£A\)AzA33AAHA33A\)A33A
A33AA  AA{A{AAAApApAAGAGA
=A
=ApA
A
=AA(A\AA  AGAÅA
AA\)Aď\AģA
=A=qAzA33Aď\AA(A
AffAA  AQAA33A  A=qA\)A(A=qAÙAA=qA
=AA
AîAAA=qAHA\)AAŅAŮAAģAzA
Aď\A33AGAffA
A
Aď\A
=AffAffAÅAAAQApA
=AGAA{ApAAQA(A{A=qA  A\AA
=A\AzAǅAGAAzA=qAřAGAA
=AAGAAHA
AAzAA{A(AAAAffAÙA(A  AÅAApAGAAAÙAAAGA
=AAAQA33AAAQA=qAA\AzApAAffAA  A=qARA\AAGAGA\AA£A  AAGA33A
AHA
A
AAQA£A
A\ApAffAAQAAA=qAA  A=qA33AARAAARAAAA33A£AARAA¸RA{AHA=qAzAƣA{AzAA=qAApA{AHAffA\A=qAA
=AAA
AA
=AffA\A{AGA  AQAzAHA\AA(AApA
A¸RAzA{AzA
AGA
=AA
=AAAAAQA£AARAA  A\)A33A(AApAîA{AAA=qAA{AAffA=qAQA{AHA=qAGAA33AAA¸RAAGAAîA(AģAŅA  AŮA{AƏ\A{AAA=qA\AQAA33AAAÅAÅAAĸRAřAƏ\A
=AffAGAGApAAď\AQA  AGA\)AHA\)A=qA=qA\)ApA33AGAAAAAAAffA  AAA
=AAAApApA=qAA{AA
AAA¸RAzA
=AA
AAÅA=qApApA  A{A\AÙAAHAAď\A(AGAA=qA  A
A=qA£A\AGA=qAffAAAffAŮApAƏ\AƣAǮAǙA(Aȏ\AAA33AHAAHAHAȏ\AȣAɅA33A=qA{AȣA
=AA  AGAffAȸRAAAHA
AQAǮAA=qAzAA\)AģAGAAĸRA\)A¸RApA
=A33A
=AzAÙAGAď\ApA
=AAzAAŅA{AřA\)AQAƸRA
AGA  AAHA\)AÅAffAď\ApAAHAGApA\)AAîA33AÅAzAA
A33A
=AAHAAzA
AHAǅAApAAffAffAffA33AGA33ApAƏ\AAǙAffA{AƸRAzAAAQAzAAǅAGA\)AAzAffAQAƸRA33A
A33AƸRAAA
=AffA
AHAȏ\Aȏ\ApAHAȏ\A=qA{AA33A  AGAHAǙA33A\AAzARAA{A
AA\)AzA\)AAAAffAAffAAAAffAAA
=AA(AzA
=AAAA
=A\ApAAQAHAA
ARAAAffAAzAA=qApA33A33AAAAAA
=AGAAAQAzAApAA{A{AHAA\AAA
=A\AzApAAA
A\)AARA
A
ARAAGApA(AAzAGA{AA33AAAQAAA{A
=AffA\ARA
AAAQA  AAAQAffAAA{A
A\)AzA{A\A33AAHA33AQA{A\ARAHAzA
=AARA\)A{A
=A(AGA\AzAQAzAA
ApA\AAApA
ApAAAA\)AHAAffA
=A\)AffA33AAzA
AzA  A\)AQA33AA=qARApA\)A\AA=qA
AGA
A  A\)A{AA\A
ARAA33AAffA
AGA(A  A  AA=qA  AzAAAA33AA{A  AQAApAAzAAzAAzApAAAAffA\)AffAzAAffAGAAAAzA33AAAA
ApA33AA  AHA=qAAA
A(AAQA
AAGAAffAQAAAA{AAAAAA  A{A{A\)A
=AAAffAAAffA{AAAA=qA\)AApAApAAARAGAHA
AApAA
AAAA\A\AA33A33ARAzA33A33AA\AQARAQApA
A33A(AQAAAHA(ApAAAA
AA\AA\)A33AA{ARAAffA33AAAAGAAARAA
=A\)ARA
=A  AAAAAffAAAQA(A  ApAGAGA{A\AA33ARA(AzA\A(A{A\)ARAHAAA\A  AzAAA(A
AA=qAAAQA
ARA\AAAAA{AAzA
A33AAHAQAA=qAA  AHA33A\)A33AA33A(AzA
=A(AA  ApAAQARAHA(AA\)A\)ARAAA33A
A33A=qAAAQAHAAAA\)AA
=AHA=qA=qAA=qAA(AAzAAARA\)AAAzAAA
=AA\A33AffApA\)ApAAA=qAQA(AA(AAAGAAAAAAHAAA{AffAA
=AARAARAGA33ApA(A33A
=AAzAAA33ARAffA\)AAA\)A{AAAA{A(A(A
A{AƣAA  AŮA{A{AA{AHA
=A{AAA(A  AAAA=qAzAHA33AAGAGA\A\)AA{A
=AAAQA
AApAffA
AAffA33A33AGA\)A(A(AHA  AHApAAffA33A(AAffA=qAGAffAAA
AAAA  A(AffAAGAAGARApA
=A  A\)AAAA\A  AA\ApAAAQA=qA
A\)Aď\AĸRA\)AƏ\AQA=qA33AAAHA{AQApARARAAffAQA
=AffAHAA(A33A(ARAAGA\)AA  A
=A33AA  AHAAAQA33A
=A=qAAAHAzAAffA{A{AApA33AffA(A(AAffAA  AA=qA
AHA(A33A{AGAAÙAffAA\)AAAA{AAffAA=qARA
ARAAAHAffAQAAHA33ARA  AA  A\)AAGAffA=qA=qA  AA
A  A33A(A=qAA
=AARA\)A¸RA
=A
=A(AřA  A{AffAAffA=qA=qAîAQAGARAQAA
=A=qAHAAffA  Aď\A33AA\)AA(A¸RAApA
=AÙA  AÙAzAAA  AA
AÙAď\AGA
AHAffAAŅAAƏ\ApApAÙAîA33AA33A
=ARAzA£AAHAģAŅApAAAǮAAHAAȣAAɮAɅAHA(AGAHAffAQA=qAǮAAAffAƣAzAƏ\AHA
=AȸRA
AɅA{AAȏ\A33AAA33A\)Aȏ\AŮAA\)AzApA=qAzA=qA(A
=AAffAʣAŅAǮAzA
=AA(A  A{AQA\)AîA  A\)AzA\ARAAA\)ApAAQA£A
AA\AAzA\)AA\)AffA{AQAGAA=qAGAĸRA
=A(AƸRA33AAzAApA(AŅAƣAǮAA{A  A{A=qAQAAAŅAffAƏ\AŅA\)AAřApA
A(AQA=qA(AÙARAAzAAQA(AzA\)AǙA
AƣA\)A33AǮA{A
AAzAffAAA
ApA\)A  AzA
=A
=A\AA{A33AAffApA33AQA
A\AzA=qAGAŮAffAffA
AAAzARA  AAA
=AA
AHA
=AzA  A{AA(A33A33AA
=ApAA\)AA
A¸RA\)AîAÙAA
A33AHAGAAA\AA\ARAA\AA(A=qAAAAÅA(A{AA
AA33A{A\ApA
AAzA=qAAAzAAAGA  A\)A{AGAAAAAzAHA  AQAQAGAAAAA
=AA\)AGAA
=ARA
=A33ApAAAQAffAA33ApA(AA
AApA(AAA  A(ApA  ARAzAA\A
=AA{AffAAAGA
AA=qA=qA  AQARA  AA33AAA\)ApAffAAAGARA{AAA
=A\)AzAAAzAffA{A\)AA=qA{A¸RAAAGAAffA£A\A
=A{AAA\AQA=qApAffAAAA(A\)AAAApAHAA33A(AffAAApAffAffA=qA33AAQAGA\A\ApAAGA\A=qA{A  ApAApAA
ARARAAAQAHAAA¸RAGAQA¸RAAAA
AA{A\)ApAAzAffAƸRAǮAHAA  A  A33A33Aď\A  ApAAAǅA  AA  AA33AA33A\AÙAffAHA  AGAA\AAQA=qA\)A\ApAffA(A  AAffApAzAA
A=qApA33AA33AAAAAAQAffApAA33AA=qAA(A(AzA\)A(AA  A
=A=qARAAA33A
Aď\AzAHApA(AQAřA(AA\)AAHA  AffA(ApA
=AQA¸RA33A=qA{A33A33AA
AAÙA¸RA(AA
=AHAA
AÅAHA£ApA\AAA¸RAAApA
=AAA=qA{A\)AARA  A
=AAA\A
=AffA
=AǅAAAzA(ARA33A33ApA33AzA
=AA
A  AAA(AAAHA
=AffA£A\A{AĸRAffA33AGA\A
A=qAGA{ARA\AAffAffAzAARA\)A33A
=AA\A  AA  A=qA\AzAÅAQA{A=qAƣAAɅAȸRA
Aȏ\AɮAffA
=AGA{A(A£A
A\)AA¸RApAŅAAĸRAŅAzAģA  AzA\)AAApA
AzAǅAAA(AAffA
ApA  A(AAGA(AQAA{A  A33A(A
A=qA\AHAAA
=A33A33AA(AzAAAffA=qA  AA{A{AQA
=A\)AAA  A  A(A(AffAQAA33AA33AffAA
=ApAAA{A(AzAffA
A\A{AffAAffA\AA{AzA  A  AffAffA33AAffAAAHApAffA
A\)AAzA(A
=AAA33AffA
AAAAAHARA
A
AA  A\A\)A=qARAAzAffAAGAAAA(AzAA\AA
=AAA{A
=AHAA(AAARAffA
=AHAA\)AA
=A
=A  A  AffAApAQARAA33ApAA{AAGAHAA33AA
=A
=AHA(AffAQA
=AA\)AQAA=qAffA=qAAAAA{A(AAGAffA(AARAAAffAAAA{A(A\A{A33AHAA=qAA\A  AAzA\AAHAAffAGAAAAA
=A33AGAQAA\AARAGAAA33AA\A33ARAA=qAAGAAAAGA
=AffAA(AzA(AÙA
=AQA\)AA\AQA\AGAApAÙAAA
=A¸RAzAAHAAQAA
A\)A  AHA\)A
=A  AHA=qA33AŮAA
A=qAHAHAffAAGAîApAffAffA(AA(AQAǙApA  AAA33AffA{AAA33AAŅAA33AffA
A\AGAQAAffAGAGAAA\A=qApAÙA\)AAAAAAAGApA
=ApA(A33ApAA(AǅAAƸRAƏ\AƏ\AQAQAQAffAƏ\AƣAƸRAQAƏ\A  AHAffApA\)AƏ\AA  AAȏ\AffAGAģAAAA
AÅApAHAGAffA(A33AzA(A
=A
A(AHAîAĸRApApAǅAəAɮA  AȣAȣA{AffAȸRAzA  A  A(A33AǮAzApA
AƣAffA\)AQA
AAģAffApAAA\)AGAHA  A
AAǙAǅAřAAA
AAƣAA=qAÙA\AÅAAQAŅA=qA=qApAəAAɅAɮAAQAȏ\AʸRAffAAAÙApAď\AQA{A(AAȏ\A{ApAAŅAzAGApA\)A{A  A  A=qA
=A=qAƏ\AzAřApAģAAAQAzApAAAAA  A=qAAȏ\AAÅAffAzA  A\)AAARAƸRAHA
AA{ApAď\AGAHAAģAģA\)A
A(Aď\AƏ\AzAA\)A{A=qAHAGA͙AͅAGAA̸RA=qAˮAGA
=AGAˮAˮAAʸRApA=qAŮAĸRAGAHAĸRA
A  A(AŅA
AǙAGA  AzA33AGApA=qA
AQA\)AGAǙA33AAA{A33A{A(AȣAȣAȸRAGAȣAȸRAȣA
A33AHAQA(A{A
=AƣAAAHAHAŮAď\A\)A=qAAffA=qAÅA
A
AzAQARA(A\A
=AAzAHAHA\A\AAGAA¸RA33ApAA
A{A(AffA  AîAAA(A=qAģAAHAAffA{AzAĸRAA  AA(AQAQAƣAQA{A(AŮAŅAA
A\AÙAÙAA=qAîAGAîA
ApAffAAffAHA33AřA(AƏ\AŅAzAzA\AA¸RAA(AAAAA
A(A
A{A
=A
AA\A  A{A{AHA¸RAA  AAApAGAzA=qAAAGA=qA{A\AAQAzAGAGA33A33AGA33ApAAffAzA(AA(AĸRApAŅA
A{AA(AHAGAA{A(AHA33AA33A33AHAA{A33A33ApAŮAƸRApA(A=qA\)AŅAģApA{A(AƏ\A  A=qAHA{AffAzAď\ApAA
=AHAAAGAĸRAA{AHAffAQA£A{A  AARAAApAA
AGA33AffA33ApAA33AffAGA=qAAffA{AAAHAHA
=A33AAQA¸RAAAÙA{AAÙA  A{AzAzA(AffA{AA(A=qAď\AQAffAGAAƸRAffA\)A{AA33AHAAzAAƏ\A33AffAĸRAHAApAAîApAA(ApA=qAîApAAA\AzA{AAHAHA  AGAď\AHAĸRAĸRAģA
AŅA=qAƏ\AffA
=AA
=AGAƏ\AŅAď\Aď\A\)AffAȏ\AǙAffAřAQAǮAzA=qAQAîA=qA  AA¸RA£AA£AAzAzA\)AA\)AA{AAQA¸RAÅAď\AAŮAGAAQA\)AGAffA
=AQAHA
AzAzAAQA33A
=AÅA=qAAGA=qA  AȸRA\)A  A
A(AA{AffApAA
=A¸RAffAAAAAĸRAQApAA(AAzA
=A=qAAAffAAA\AA£AGA\)A£A
A\A
A(AAřAzAAď\A
=AAA=qAAffAAəA=qAʏ\AHAGAˮA{A
AQA  AˮA
=A{A(A
AQAʣA  AffA˅AQAQAQA̸RA  AffAˮAAA(A  ẠȀ\ApA˙Ȁ\AA\)A˙A
=AẠAHAA(A˅AzȀ\ẠAQAQAˮA˅AɮAɅAAAȣAǅAA\)A=qAʏ\ApAHA33AQA
AřApAQAA33AzAGAQA(A
A33AA
=A
=AȸRAHAGA  AȣAǙAǮAǅAŅA=qA£AHAÙAHA(A\A£A
=AQAřA33A\)AHAAA33AAƸRAApApAŅAffAģApA(A
=AAAƣA(AA  A  A{A{AAffAŅAŅAĸRAQAQA33A  AzAA
A
=AzA
A\)AƸRAGAȸRA\)AHAAA=qA  ApAƣA33Aď\AAAGA  A  AŮAÙAģA£AŮApAA£AGAÙA(AApAŅAHA=qA{AĸRAHAA33A33A  A  A  A=qA
AA\)AÅAffA{A£A\AÙA¸RA33AAÅAGA\)A\)A\)AAA£A\)AAAzAQA\A33AÅAAÅA(AQAģA
=AŮAřAAzAď\AA(AAAzA\)A£A(A\A\AAAHAARA(A{AGA33AAA=qA  AHAAA=qA\A¸RAAQAAA33AHA=qA=qAA  A=qAQAAAA=qAAAAQA  A\AA
=A=qAffAffAA=qAffAHAQApAGA
AAA\)AHAAAA=qAHA(AAA\)AA£ApAAzA(A
AAA\A\A  A\)AA(A{A£A33AA\A£AîApA=qAGA¸RApA
A£AzA{A=qAAzA  AAA33A=qAQA\)AAA{A\)AAffARAAAA33AAffA  AA
ARA  AAGAffA\)AA=qAA=qApA\)A\)A33A(A  AAffA\A=qAQAAAÅAGAÅAÅAA(AA33AAAApAGA  A{A  A  A
ApAGAAARAAAARA(AffAffAApAAApA\AApA(A
AA33AAA=qAAAAzAzA=qA\AHA¸RAffAA
ARAAGAAQApApAHAHAAGA(A
=AzAApAA  AA  A(A
AA{AHAAffAA
=ApARAzAApA=qAA=qAA{AffA
AA¸RAffA¸RAAffA\A=qA(A
=A=qAAAHAA\AzA\A33AAA=qAA  AzA\)AAA(A(AzA(A
=AA33A(AApA
A=qAAHA
AA
AffARAAAA{A\)AAA\)AffAA33AA\)A
=AAAAAAA
AAApAQAAARApAA
=A{AAAAAQApApAAAHA
AA
A{A
AAAAzAGA  A\AAA
=AAAARAAAA(AQA
=ARAzA=qA
=ARA  A
=A\AHAzA
=A
AA\)A
A33AARA\)A
=AAQApA
=AAAGApAAGAffA33AHAAA\)AzA\A  ApA\)AAAQAAAA  A=qAAAffAA
=AAAA(AApAQA\)AAQA\AGAGA=qARAApAHAAA\AAzAA¸RA¸RAAGA¸RA\AA
AA
=A
=A(A
AAApA33AA=qAffAA
A  A=qAA\)ApAHARAAzApAAGA
A
AGAzA  A{AzAAQAAGA
AA  AA\AA  AA  AA
ApA(ARAA\)A{AA{A{AAAAzA=qAA\A  A=qAAAA33ApAQAQA(A(AAA
=AAzA33AAA(AAAA\)AffA33A{A
A(AAAGAAA33AA\AARA{AA=qA\ARARAA  AAA\AAA(AHAAffA(A{A{A\)A
AffAzApAA  ARAA{A
A
A\ARA\)A=qAHA  AAffA
A{AHAGA\)A
=A(AQAAffAAA\)AffAA=qAA=qA(A\A\)A{AAGAffAAAAAffAAAAAzAAAGApAHAARAAGAARARAAAAAAAAApAAA(A=qA(AAA
=A
A=qA{A
=A{A
=A
AA=qAA(A\)AzApAAGApA33ARAApAffAGAGAHAARApA
AA\AA33AA
A33ARA{A
=A
=A(AAQAGA\)AAzApAAAAAQAAQA=qA
=A\A33AffAA\ApAffAAA  A\AAAAffAGAAA{AffA(AAAA\A  AffAffAffA\AARAAAA
=A\AA\AAA
=AA\AA{AzA\AARAAffAARA=qAA\)AGA\)A(AApA
AAGAAAAA{A=qA=qAA\)AQAAffA\)AzAAGAA\)A=qA(ApA33A(AAAAA\AHAHAQA\)A(AzAAA=qAHAHA33ARAAHAA=qAGA(A
ARAHAA\)AGApA
AGAffAQAA\A\A
=A{ApAAHA33A\)AA33A\)AGA
=ApAGA\)ARAzAA\)AHAGARAAzA33AAAAQAAA  A=qAA  AARAAQAQAAAAzAA\A33A(A\)AffAQA
=A33A
AQApAAzAAAAAffAzAHAA33AAAAAA(AA=qAA\)AQA
=AA
=AA
AQAApA\AHAAGA\)AA
=AA\A\)A=qAA
=AARA=qA33AzAAffA\)AAA{AA
=AffApA
=AGAGA\AAA{A
AzA
AAAGAffAA
AzA\)A
A  AHAAA{AA33A\)AQAAffAA{AA\AA=qA
=AAAAffA
A
A
=AAAA
AGA{A  ARA  AA=qApAHAAAAffA(AAGAGAAAffAAQA
=AHAQAffAA=qA  A33A33AAA\AA{A
=AA(A=qA
=AĸRAApAĸRAÅA
=AŅAA(A=qA\AA33AzAAffAzAA
AAARA=qApAA(AAGApAAAQA=qAAzAARApA
=AAHAzAQA=qAAA
=ApApAzAAAARAHA{AA(A
AAAAA(AGAA=qARARAA33AA=qAAApARA33A
=A(AzAAQA{AGA
=AA33AQAA(AAHAģA=qAA(A\)A  AA  A\A
=A\A  AAQA(AAAGAAA33A=qApAA\AHAAffAAAARAApA\)AA(AAAAA  AQA\AQAHA
=AA{A33AHAHA\)AQA  ARAHA\AAGAAARA33AApA(AAAA\AApARAAAAAAAzAA
AAA33A\ApAAA(ARAffAHA\)AAQA\)AAQAA33AAHAAzAAQAA\)A=qAGApAAA=qA33A=qA
A  AHAAQA(A33A\AA{AzAA
AA  AA\AA\)AA33AARA=qA(AAAGARA33ApA
A\)AGAA
AHAARAffApA=qA=qAffAQApAA
A
A{A(ARAQAAGA{AAffA(ARARA
=AHA  AAA=qAAGA
AHA\)ApAA{AGAQAApA
A{A(A  A\AAAQAAQAApAAHApA(A  A{A
=AAARA=qAHApARAAA(AffAAzAQA=qA\AzAARAA  A\AA{AA  ARA\)AGA\AAAAGAHAffAAHAA\A(AAAAA\)AffAAAAAzAGAA
AzAA
AARA
=A{A
A
=A  ApAAzAAA
ApApAAA33A(A33A(AAA  AA(AHA33A  A
AQAA
AQAQAGAHAzA\AHApA=qAAHApA
A\)AzA33A(AzA
A=qAA\)A\)A\ApAAAA{AffAAHA=qApA{AAA
=AAGAzAHAAAARAGA
A33A
ApAA(A{A33AA\)AAAA  AA33A{AAAzAQA  A=qARA\AARAQAAHARA\AA33A  A{ApAGAAA=qA=qAAffA33ARARAA  AA  AApAAApApA=qA
=AAAAGA  AAA\A33A(AQAAGAA33AAA  A
=AAA=qA33A
=AA(AA
A\)AffAA\A
A
AA
=AA=qA\)AA{A=qAAApAffA  AHA\A\AAGA\AAAffA\)AzAQA\ARAGAQAGAHA=qAzAAzA
=AQAHAA33AGAA
=A
A
=A\)AAzAffA
=AAAAffAAHAffAAAA=qARAGApAAA  ARApAAGAffA(A\)A(AAARA=qA{ARAA33AA\)AAAAQAA\)ARAAA  ARAAAA\)A
AAA(AAQAAAAA(AQA\AA\ARAAQApApAAAGA\)AA
A  A{A  A{AA=qA(AHAQAA(A  AffA=qAAffA
AGA(A(ApAAA=qAAQAApA\ApAA  A\AAHAAAHA\AA=qAAA  AAQAAAAAAA=qARApAffA=qAHAAHAQApARAA(AA  ARAGA\AA=qAHARAffAHA=qA\AffA=qAAQAAAAA=qA{A\)AAGAApAAffA{ARAQAAGAApAHApARAffAzARAAAApA\)AGAAGAA
A{A33AA(AA  AffAQA(A=qARAARAQAAAA(AffAQA33AA\AA(AHA(A=qApA{A
=AGA\A\A
A=qAAA  A
A(A
A  A=qA\AffAAQA  A
=AHARARApAA(A=qARA\AHA\AAHAAAAARAzAA\AAAAA
A\)AAzA(A\A  A\)ApAQAGAQAAAffA
=AAAAGAAA\)A=qAffA=qA{AAAffApAA33AQA{AARA  AGA  AHAAA
A33AHApAGAA
=AAAffA{AAGAA
=AffA{AAAA=qAAA33A
AQA(A(AQA{AAAHAAAAAApAGA33AAHAAAAAQAA{A(AQAAAAzA
=A{A\)A33AAAAAAHAAAQAA
A33AA(A  AzAApAA33AAAA
AAQA\A\ARA\)ApAGAAQAzApAA{AQAffARAAA33ApAÅAzAA(A
=A\)A\)A33Aď\AzAA
=AGAîA
=A=qAAAÙAAGAAA
=A(AAA(AAARAQAA\AHAAzAAA(A
AzA
A{AGA\)A
A33ApA
=AzAAA\A
AHAHAzAAAHARA\AzAA(AHAQAAGA\)A\)AGAAzApAA\AAAAAAQA\)ApAAQA\A(A¸RA33A(A{A=qAffAď\A\)A
AzAƏ\AƏ\A  A33ApAHA\)AǙA  AîAA  A
=AGAA(AAAGAAGApA\A
A
AģAAAAA
=AAAHAAAAģAģAAĸRAGAĸRAzA33AQA33A\AQAHAA
=A\AQAAA
AAzAAAA
=A  A\A
=AAA(A
=AAffAQA\)A  A=qAzAzARAAQA{A\AQA33AAA(AAAA{A(A
AApA
=A33AAGAA
AAffA  AAAAGAA
=ApAAA  A
=AHARA
=AAAA{A\A
=AAA
ApA
=AQA\)AAAQA=qAzAAA(A  AAQAAQA
=AA{AAA  AA
AQAAffAAffARARA(A{AA=qAGAAffARAzA\AHAAA\AA{AGA{AA(A=qAAQAA\A(AAAAHAAHA{A\)AA(AApAAHAHA
=A
AA
=AA\ARAAffAAA\A(AAffAGA
=AAQAAA
=AAA\AARARAA\A(AQA{ApA\AA
A=qA33AARA
=ApAARAzA(AAffAA
ApAA
ARA
=AA=qAGApAApA{A
A  AffAApA33A  A
=AQAA\A(A  AHApApAAA
=A
AAAQAAA  AQAGAHAGA(AApAffA(AAAAAA
=AffAApAzA  AApAA\A=qAA  AAAA
ARAAAffAHA33AzA\ARAAA\ARA\AA(AA(ApAffA\)A\)A(A
A
=AAGA
AAAAAAAAAAA
=AAAA=qA  AA(AQAGA(AQAA(A  ARA
=AGA
AGAHAQA=qA33AGAAAGAApAAffAA33A33A{AzA{A33AAAffAA
A(AAARAAApAA{AHAA{A\AGAAGA  AffA\AGARAAffAAA(A\)ApAzAAA\A\)AAAA
AAAARA=qA  A33A
AA33AAQAA  A=qAGAA  AAA(AAAGA  A=qA{A{AHARA\)A(AAzA33AA\)AffAAQAAAAA  A  A{ApAAA=qAA33AQAQAApApA33AffAQA
AAA=qA\AzAHA=qAAAzApApAQAA(AffAzA\AzAARAA{AffA{ApA\ApAGA
A
=AHAARApA\A\)AA
=ApAGAQA
=AAAGA=qA=qAA33AAQAAGAHA
=A33ApA=qAAGAAA=qAAffA(A{AzA=qApAAQA\AAAAAAGA=qAA\A=qA{A33A\AAAA=qAzA  AAA  AAAA{AGA\AApA  AzAzAzAApA
AQA33AGA
ApApAA
AA  A(A  ApAffAAHA33A{AzA  A(A  AAAAAAA
ARA
=A33AAA\AAAAffAAffAffA\A{A{AAHA
AQAA(AAA=qAA\)A33AHAA
=AAAAHA=qA\ARAAzARAffA\)AAzA  AAAAzA=qA\AA\AA{A  AAA\)A33AA\AAA  A
=AAARAAGApAAAAAHA33A
A(AA=qARA33AAGA=qAApA(A\ApA{A\)ARA=qAAAGAffAffAzAA\AQA
A33AffAHAAAA\AzAARAQA  A(AHApAHAAȣAA33AffA
=A  A¸RAA
A\)A\)A\)AffA(A33AAA{A\)A=qA(AffApAHAAA
AAAA33ApA
A  A33AAAA
=AAA
AA\AAQA
AAAGA
A
AA(A\AGA\A(A33ARA\AGApAzAApAAAAzAAA\)AAARApAAAApAAA(AAQApARAffAA  A
=AA{AffAAď\A=qAîAîAÙAffA\AzAzA
ApAAGAA
A(AffAHA\)A{A£A{A
A{A¸RA£A\A(A
AQAQA(A  AAAGAHAAzAzA(AApAA\AAAA33A  A\A=qAAA\AQAApAAApAGA=qAAAHARA
=A
=AGAA(A
=ARAA(AAApA
=A  A(A\)A33AApApAAARA\)AA{A(AGA(AAA=qARAApA33A\AffAQA=qAAAAAA
ARA33ApAGAGAAAGA{ApA=qAARAffA{A\AAApAApA  AQAGAAA{A33AGAffAA
=AGA\)AA  AzAA
=AffA\)A33AAzAAHAGApAAAA  A(AA33AA
A  AQA
=AA33A\AQApAAGAHA\)AA  AA\)ARA
AAAA  AffARAGAApAffAA  A=qAA{AzAAQA
AA{ApAAAAGAHAA33AHApAzAA
=AA
=AAAAGA33A\)AQAffA  ARAApA(AGAA
AffA\)ApApA33AzAQAA
=AApA{AffAA33AQAHAARA(A\)A33AA33AAA
A
A
AAffAA
A=qAAGA33A
AGAQAA=qAGAA(A
A  AApAAAffA\AAffA  AAA(AAGApA
=A{A{AzAQA33A  A
AA{A\A
AApAAAApA33AAAGA
=AAAAHAAApAA(AA\)AffARAAAA  AA
=AA(AGApAHA{AA{ARA\A\A  A  AffA(AA=qAHA  AA(A{AHA(AHAGAffA33ApAAffAAzA{AAA{AQA\AAGAAA
A(AAApA
=A=qA
=ARA
=A(AHAAA
ApAffAAffA=qAAA=qA  A{A\A
=AAAARAHARAffAA(A
=A33AAA
=AAAAARA  AARAzAAAAGA
=AQA(AA=qAffAApA(AAAAGA=qAGAffA\)A
AAffAAGAARApA\)ARA\AAHAApAA=qA
A
=A\)A=qA=qAffAAAAAA(AAAAHAA\)AGA
=AA  AAA=qA  AzApA  AA\AA
A=qA  A
ApA(AffApAAAzAAGA\A\AA  A33A{AAzA(AA=qAAA  A=qAGAA  A33AffA\)AzAAQAAQA\)AAffAAAAAzA33A
AA
=A=qARA\AAHAA
=A(A{AQAQA\AA{AzAzAģAHAA
=AA33AŅAAA(AQA=qA=qAAŅAA
AGAAGAģAď\AA\)A
AAAA{A(AGA
=AffAA33A=qAAGAHAAQA\)A
=AAffAzA\)AGARAAAAA\ARAQA=qA{A{A(A
=A\A  AzAGAA
AAAGA=qAARApAA(AAA
A
=AzAzApA33AA33A(AAA=qApAA
AAAApAɅA33AAAffA
AzA\)A{AffApAGA
AAA
ARAA{A¸RA£AHAQAAQApAzAA33A=qAAA\)AffA(AHApApAGA(AA\)AGA  AAARAAAAAA33AA\A\AîApAA\A
=ApAAA
=AA(AAAƏ\AzAAGA33AffAHARA\)A(AAȣA=qAA
AzA(A
=A(AzAHAŅAƏ\AAȣAA{A(A  AA(AQA{A(A{A=qA33AɮAɮA33AAGApA\)A=qAA(A{AQApA(AǅA33AzA(AApAffAAîAApAģA\)AQAAGA\AQA  A33AA\)A\)A\)A£AA
A(AAHAHAA
=A33ARA(A\)A\AffAAAA{A(A{AA\)AHAAGAA\A=qARA\AARAAA\)AGAQA\AffAA
A  AA¸RAzA\A¸RA
=A¸RA(A(A
A
AGA=qAAHA{A
=AHAA  A\AģAQAA
=AQAHAAHAHARAAzAAAQApApA\)AAGA
=AAQAQAAAzAA
=AA
AAAQAA
AzAzA=qAzAA=qAGAGA\)AAAAffA
=A\)AzAApAA\)A{A
=A  AA\)AAAAffAA\AŮA
AQA  A
AHAAHAAAAď\AHAA=qAQA{AAA=qAď\A
AQA\A33AffA33AA=qA
AffAAHA=qAAA  AAHAAAA
ApAAA33AA33AAAffAHAARA  A33A  A
ARA=qAARA\)AA\)A\A=qAAAzA
AA\AAAA
AAGARAGAAAA(AAAGAzAAAffA
AA=qAGA\)ARAHAQAHAAffAQA\AffA{A\AAAAAffAA(A(AHA=qAAffAAAA\A
AzA  AGA
ApAQA(A{A\)A  AffARARAAA(A=qAQAA
=A33ARA\)ApA(A
=AA\)AA  AApA{A
=AffA(AAAAAAAAA  A=qA{AGA{A(A=qAA{A  AAHAAAAGAffAAAGAQA
=AQA\AApAAAffAGAAGAAffA
A  A\)ARAGA(AAAGA  AApAAAAzAAAGApAzAA\AApA
AA(ARARA(AAAffAAA(AQAGA=qAA
A\A
=A=qAA33AA(ARApAA
=AAQA(A  AHAAAAAAAAAARARA\A
A=qAA  AzA
A(AzAzA=qARAAARA\A{A{A33AA=qAHAAffAHA
=A\)AA  AffA\AAHA
=AA
=AA  AA
AA33AGAAA\A\A(AAAQA33A=qA(AAAAAzAzA{AA\AA{A
AGAzAA
=AzAA
A(A{AHAzA
=AAApA{AGA{AAA(AA  A\AffAAAA
=ApAAARAGAAAAAGA
AGA
=A(AA\)A  ARA  AA=qA=qAA33AAAA  AAQAA  ARA
AAA
AAffAA=qA=qAAzAAAAAAQAGAAA=qA\)AAAAAAA{AAARA{A=qAAA{A33A(AHAffAAAA(A  A
AGAAQApApA
=A
A
=AA
ApA
AAAAARAAQAzAA\AA  AQApA(AHA\)A\)AA
A  A
=AffA\)A
AApAAAA\)ApAAAHA¸RA£A£AHAffA
AAAAAAApA\)ARAA33AQAApApAGA\)A(AzAAffAA(AAQAGAA
AAHA\)A\AARA
=A33AAApAffApAffARAA
=AARAA(AQAQA=qAGA(AHA\AAAA
=AAAA
A\AAAAAA
=A\)A
=A  A  AGA
AA  A=qA\)AGA¸RA£A¸RA{AffApAA
=A\)A\)A\)AQAA  A\)AA
=A=qAGA=qA=qAHA\AffAA=qA\AHA33AAAzAA  A¸RA
=AARApA\AzAQAA33A{AA\AAAA\)A33A\)ApAffAAzAApA{AffA33A\)AAAHAffAA
=AA
A{AA{AHAAAAA\)AAA33A\)A{AAA  AApAGAARAHAHAA\)AGA{AAApAzA\A  AA\)AAGApA\)AHA{AA(A{A  A\Aď\AffAA  AzAA33A(A=qA  AA(A\)ApAAAÙAHAAzApAA(ARApAzAzA  AAA
AQAAHA(A33AHApApAQAApA
=AA33AApAQA\)AAAA
=AAAAAA
A
AApA
AA\)AQAA{A\A\AAAQAffAîAAA\AApAA  AAA\AQA=qAzAGAffAA=qAAAAQA33AHAAQA
AA\)AA\AA\A
=AAAHAAzA
AAffA33AAAAAAHAAAAAHA(AA{AGAHAAAA  AA=qA33ApAAAzAzA
AffAA(AA(AAGAA
A  A\)AAzA33ApARAAA
A  A=qApAffAA  A\AÅAAQAA{AAAAHA{AQApAffAffAffA  AƏ\A\)AAHA=qAÅAAQA
=A
=A  A=qAApA33A33AîA\)AAGApAA
AzApA\AA33AA\)AQA33A
A(AAffAA{AA(Aď\Aď\AHAAGAQAA  AA(AQA
=AHAAAzAAA\AA{ApA\A\A\A
=A
ARAAQA\)AAA  AAď\Aď\AřAQAģA33AAƏ\AGAǮA  A(Aȏ\A(A=qAAAAAHA\)AAffAAQAAAARAHAQApAAA(AffAAA\)A33ApAAA(A\A
A  A\)A
=A(AA{A{AAAƸRApA\)AAĸRA33AGAGA  AGAAAGApAA=qA{AzAHAAď\A\A{AHAɮAAŅA
=AGApAîA=qAGAHA
AGA  A
=AAffA{A  AîA(AA\)AA(AƣA33AAȣAGAA(AɮApA33ApA\)A
=AAzAA(AARAŅA  AǮAHAAȣA\)AffAAƏ\Aď\A{AA
AAAApAŮAAffAGAď\AffA(A\)ApAĸRAAď\AA
=AîAÅA\A(ApAGAAAAAQA
AģAA{AA=qAApAQA£AQAA{AHA  AAzA£AŮAÙAîA
AÙA(A
AÙApAA
=A\)AAQAƸRAzAAHA\)AǮA
A{A33ApA33A33AəAGAAffAǮAGAQA{AřAƏ\AǅAǅA  AǅAA\)AAAzA{AQAA(AA
=Aď\A(AA33ApAHA{AřAĸRAzAGAĸRA(A
=AAGAGAQA
AffA33AƸRAAA(AAGAAAAAA
AŅAƣA33AŮA
=A\)ApAffAƏ\AƏ\A{AHA
A(AȣAȸRAȸRAȸRAȏ\A(A{AffAAffAQAzA\)AˮA˙A{A(A=qAA
=AͅA\)AHA33ApA\)AͮA=qA͙ẠA˙AzAˮAA33AˮAʏ\AzAǅAHAAƣA
AAzA  Aď\A\)ApAA  A
AƏ\AAAQAGA
=AApAGAHAA£AHAffAAAA
=AGA33A  A(AzA
=A
AAAA(AAAAffA
=AA\)AAARAA=qA
A¸RAQAHApAîAÙA  Aď\AŮAAAǅA{A33AA
=AGAɅA
A  A(AffAzAQAʣAHAHA(ApA
=AȣAǙAAffAQA\)AʸRAʣAHA33AGAQA(AAȏ\AQA(AAA  AŅAAHApAffAAAQAAzA  A(AAAGA
A\)AA
=AGA
AA
=AŅApAȣAƣAAA¸RAÙAÙA\)A\)AAģA
=AA
=A  AA(AAAÅAA(AȸRAɮAʏ\AʸRAQA(AɮAGAAHA=qAʣAQA
=A\)AHAHẠAffẠA=qAHA\)ARAAA33A
=AHA=qAAɮApA33A
=AAȏ\A=qAǙApA\)A33AAƸRAƏ\AzA=qA{AŮApA33AAAģAffAffAA(AAAAQA{A33A(AzAA\AAAAA\A
=AzApAAAQAA33A
A
=A
AQA
A
=ApAA\AQAAGAzA=qA
A  AAffAffAAzA
A
AAAA33A\)AARA{AQA33A\ApAAA=qA(AzA=qA{A\)AAA33A
=A33AHAAA33AHAƸRAffA  AřAřAŅApAGAAAHAĸRAĸRAzAzA=qA{A(A{AÙAAÅAAAQAA\)ARAAA
=A  ARA=qAA33A(A(A  A33A(AARAAQAA(A33ApAAGAŮAHA=qAHAȣAȸRAA(A(AffA
=AffA=qApẠA͙AffAHAzA͙A̸RA\)Ȁ\AƏ\AGA
=AQAffA  A=qA
=A
AA  AA33AřAA=qA33AǙAGAAƏ\AA
=AHAƣAƸRAƣAzA(A  A
AŮApA\)AGA
=AHAAffAģA
AAQA
=A\)ApA\AGAA(AQAAAHApAffA
A  ARAAAAARA=qA  ARA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            AAA=qARAGApAAGA33A=qAffAGAAA
=AAřAAffA
=A  ApAʏ\AAzAA33A
AHAQAЏ\A  AîAA{ARAمAٮAAɮAQA\A\)AA=qAA  AGAΏ\AљA=qA\)AЏ\A{AхAA͙A(AQAA(A
AGAffAHA
Ȁ\A\)AŅA\)A
AQA  AAHA\)AծApAA˙AA  A=qAƸRAď\AA  AAAHAəAGAQAA\AծApAɮAffARAA{AHA(AGAA
ApAHAQAA  AƣAA(AծA=qA
=A=qAGAQẠAApAzAυAA
AA\)AQAGAffA33AffAأAA  AAAffAQA˙ApAͮAAӅAGA\)AAυA=qAA
AApAʸRA
AGAA
AAծAθRAGAAəA33A\)A33ApAۅA=qA
=AAڏ\AAڏ\AGAAAHAAA\)A33A\)A(AʸRA̸RAˮA
AƏ\A33AGAAGAA(A\)AHA  AAzAřAȸRAȸRA
A{AGAARAAAAAģA
AHAҏ\A\A
AA33AffA(A=qAɅApAAA=qAffAȸRA  AzApAHA\A(AHAA
A֣AA=qAA(AGA33ApAՙAAA=qA=qAϮAظRA
A33A
=AAffA  A33AGA=qẠA
=A˅A\)AA=qA  AָRAA\)A\)AAA
=A͙AAΣA{AՙAzAA=qAAHAAÙA33AAAGA\A
AGAAA
AA
AHAQAHAAARAA
=AzA(AЏ\A33A؏\A
AʣApAȸRAθRA׮AңAAA\)AͅAGAzAzAApAΏ\A{ẠAΣA{AẠA
=AљAA33AA  AAҸRAظRAAffAAͮAQAәAA\)A=qAHA=qAQAAzA
=A33Aҏ\AAAA33A{AřA
=Aԏ\A{A33AffAAHA
ApA=qȀ\AA  AǮAƸRA  AHAAA˅A{AиRAAffAffA33AυAQAQAffApAHA{AGAA
=A
=AzA
AQAzAAHAAޣAffAݮ