CDF       
      
timeseries        obs   /=   station_name_strlen       platform1_strlen      instrument1_strlen     +   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2023-01-05T18:42:10Z http://pacioos.org
2023-01-05T18:42:10Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2022-01-01T00:00:00Z&time%3C2023-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2022-12-31T23:30:00Z   time_coverage_resolution      PT30M      time_coverage_start       2022-04-15T20:15:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      Aؖt   A1~      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      y r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      A
=Az   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH           salinity                   _ChunkSizes                
_FillValue        y    actual_range      <#
CY   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      
=F   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        f   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      8QC[   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        #   oxygen                     _ChunkSizes                
_FillValue        y    actual_range      =GAJ\   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH           oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      @^{C9   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C           ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        Z   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      A
=Az   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        x   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                l   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      	`   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      
NT   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      H   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      <   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      0   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      
B$   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      
   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	         temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      y    temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      5   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	         temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	         temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	      l   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      )   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      <#
CY   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range                   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      `   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	         salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      ڈ   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      |   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      Tp   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      d   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      X   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      L   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      H@   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      4   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      (   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	         salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	      <   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	         
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      
=F   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz           turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range                 r   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      !/   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      !   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      "   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      #f   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      $#   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      $   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      %   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      &Z   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      '   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      't   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      (h   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      )N\   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      8QC[   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        *P   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range                *D   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      +8   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      ,B,   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      ,    chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      -   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      .y   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      /5   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      /   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      0   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      1l   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      2)   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      2   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      3   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      =GAJ\   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        4`   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                5   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      5ڐ   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      6   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      7Tx   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      8l   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      8`   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      9T   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      :HH   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      ;<   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      ;0   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      <$   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      =<   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      =   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      @^{C9   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        >    oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range                ?r   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      @/   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      @   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      A   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      Bf   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      C#   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      C   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      D   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      EZ   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      F   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      F|   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      Gp   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      HNd   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        IX   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                IL   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      J@   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      KB4   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      K(   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      L   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      My   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      N6   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      N   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      O   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      Pl   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      Q)   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      Q   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      R   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       p S`   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     @ T|    crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    ( \k`Ap?  wqb_04  Aؖt   Aؖur   Aؖw4   Aؖx   Aؖz   Aؖ|z   Aؖ~<   Aؖ   Aؖ   Aؖ   AؖD   Aؖ   Aؖ   Aؖ   AؖL   Aؖ   Aؖ   Aؖ   AؖT   Aؖ   Aؖ   Aؖ   Aؖ\   Aؖ   Aؖ   Aؖ   Aؖd   Aؖ&   Aؖ   Aؖ   Aؖl   Aؖ.   Aؖ   Aؖ   Aؖt   Aؖ6   Aؖ   Aؖ   Aؖ|   Aؖ>   Aؖ    Aؖ   Aؖ   AؖF   Aؖ   Aؖ   AؖČ   AؖN   Aؖ   Aؖ   Aؖ˔   AؖV   Aؖ   Aؖ   AؖҜ   Aؖ^   Aؖ    Aؖ   Aؖ٤   Aؖf   Aؖ(   Aؖ   Aؖ   Aؖn   Aؖ0   Aؖ   Aؖ   Aؖv   Aؖ8   Aؖ   Aؖ   Aؖ~   Aؖ@   Aؖ   Aؖ   Aؖ   AؖH   Aؖ
   Aؖ   Aؖ   Aؗ P   Aؗ   Aؗ   Aؗ   AؗX   Aؗ	   Aؗ
   Aؗ   Aؗ`   Aؗ"   Aؗ   Aؗ   Aؗh   Aؗ*   Aؗ   Aؗ   Aؗp   Aؗ2   Aؗ   Aؗ!   Aؗ#x   Aؗ%:   Aؗ&   Aؗ(   Aؗ*   Aؗ,B   Aؗ.   Aؗ/   Aؗ1   Aؗ3J   Aؗ5   Aؗ6   Aؗ8   Aؗ:R   Aؗ<   Aؗ=   Aؗ?   AؗAZ   AؗC   AؗD   AؗF   AؗHb   AؗJ$   AؗK   AؗM   AؗOj   AؗQ,   AؗR   AؗT   AؗVr   AؗX4   AؗY   Aؗ[   Aؗ]z   Aؗ_<   Aؗ`   Aؗb   Aؗd   AؗfD   Aؗh   Aؗi   Aؗk   AؗmL   Aؗo   Aؗp   Aؗr   AؗtT   Aؗv   Aؗw   Aؗy   Aؗ{\   Aؗ}   Aؗ~   Aؗ   Aؗd   Aؗ&   Aؗ   Aؗ   Aؗl   Aؗ.   Aؗ   Aؗ   Aؗt   Aؗ6   Aؗ   Aؗ   Aؗ|   Aؗ>   Aؗ    Aؗ   Aؗ   AؗF   Aؗ   Aؗ   Aؗ   AؗN   Aؗ   Aؗ   Aؗ   AؗV   Aؗ   Aؗ   Aؗ   Aؗ^   Aؗ    Aؗ   Aؗ   Aؗf   Aؗ(   Aؗ   Aؗ   Aؗn   Aؗ0   Aؗ   Aؗȴ   Aؗv   Aؗ8   Aؗ   Aؗϼ   Aؗ~   Aؗ@   Aؗ   Aؗ   Aؗ؆   AؗH   Aؗ
   Aؗ   Aؗߎ   AؗP   Aؗ   Aؗ   Aؗ   AؗX   Aؗ   Aؗ   Aؗ   Aؗ`   Aؗ"   Aؗ   Aؗ   Aؗh   Aؗ*   Aؗ   Aؗ   Aؗp   Aؗ2   Aؘ    Aؘ   Aؘx   Aؘ:   Aؘ   Aؘ	   Aؘ   Aؘ
B   Aؘ   Aؘ   Aؘ   AؘJ   Aؘ   Aؘ   Aؘ   AؘR   Aؘ   Aؘ   Aؘ    Aؘ"Z   Aؘ$   Aؘ%   Aؘ'   Aؘ)b   Aؘ+$   Aؘ,   Aؘ.   Aؘ0j   Aؘ2,   Aؘ3   Aؘ5   Aؘ7r   Aؘ94   Aؘ:   Aؘ<   Aؘ>z   Aؘ@<   AؘA   AؘC   AؘE   AؘGD   AؘI   AؘJ   AؘL   AؘNL   AؘP   AؘQ   AؘS   AؘUT   AؘW   AؘX   AؘZ   Aؘ\\   Aؘ^   Aؘ_   Aؘa   Aؘcd   Aؘe&   Aؘf   Aؘh   Aؘjl   Aؘl.   Aؘm   Aؘo   Aؘqt   Aؘs6   Aؘt   Aؘv   Aؘx|   Aؘz>   Aؘ|    Aؘ}   Aؘ   AؘF   Aؘ   Aؘ   Aؘ   AؘN   Aؘ   Aؘ   Aؘ   AؘV   Aؘ   Aؘ   Aؘ   Aؘ^   Aؘ    Aؘ   Aؘ   Aؘf   Aؘ(   Aؘ   Aؘ   Aؘn   Aؘ0   Aؘ   Aؘ   Aؘv   Aؘ8   Aؘ   Aؘ   Aؘ~   Aؘ@   Aؘ   Aؘ   Aؘ   AؘH   Aؘ
   Aؘ   Aؘ   AؘP   Aؘ   Aؘ   Aؘǖ   AؘX   Aؘ   Aؘ   AؘΞ   Aؘ`   Aؘ"   Aؘ   Aؘզ   Aؘh   Aؘ*   Aؘ   Aؘܮ   Aؘp   Aؘ2   Aؘ   Aؘ   Aؘx   Aؘ:   Aؘ   Aؘ   Aؘ   AؘB   Aؘ   Aؘ   Aؘ   AؘJ   Aؘ   Aؘ   Aؘ   AؘR   Aؘ   Aؘ   Aؙ   AؙZ   Aؙ   Aؙ   Aؙ   Aؙ
b   Aؙ$   Aؙ
   Aؙ   Aؙj   Aؙ,   Aؙ   Aؙ   Aؙr   Aؙ4   Aؙ   Aؙ   Aؙz   Aؙ!<   Aؙ"   Aؙ$   Aؙ&   Aؙ(D   Aؙ*   Aؙ+   Aؙ-   Aؙ/L   Aؙ1   Aؙ2   Aؙ4   Aؙ6T   Aؙ8   Aؙ9   Aؙ;   Aؙ=\   Aؙ?   Aؙ@   AؙB   AؙDd   AؙF&   AؙG   AؙI   AؙKl   AؙM.   AؙN   AؙP   AؙRt   AؙT6   AؙU   AؙW   AؙY|   Aؙ[>   Aؙ]    Aؙ^   Aؙ`   AؙbF   Aؙd   Aؙe   Aؙg   AؙiN   Aؙk   Aؙl   Aؙn   AؙpV   Aؙr   Aؙs   Aؙu   Aؙw^   Aؙy    Aؙz   Aؙ|   Aؙ~f   Aؙ(   Aؙ   Aؙ   Aؙn   Aؙ0   Aؙ   Aؙ   Aؙv   Aؙ8   Aؙ   Aؙ   Aؙ~   Aؙ@   Aؙ   Aؙ   Aؙ   AؙH   Aؙ
   Aؙ   Aؙ   AؙP   Aؙ   Aؙ   Aؙ   AؙX   Aؙ   Aؙ   Aؙ   Aؙ`   Aؙ"   Aؙ   Aؙ   Aؙh   Aؙ*   Aؙ   Aؙ   Aؙp   Aؙ2   Aؙ   AؙĶ   Aؙx   Aؙ:   Aؙ   Aؙ˾   Àؙ   AؙB   Aؙ   Aؙ   AؙԈ   AؙJ   Aؙ   Aؙ   Aؙې   AؙR   Aؙ   Aؙ   Aؙ   AؙZ   Aؙ   Aؙ   Aؙ   Aؙb   Aؙ$   Aؙ   Aؙ   Aؙj   Aؙ,   Aؙ   Aؙ   Aؙr   Aؙ4   Aؙ   Aؙ   Aؚ z   Aؚ<   Aؚ   Aؚ   Aؚ   Aؚ	D   Aؚ   Aؚ   Aؚ   AؚL   Aؚ   Aؚ   Aؚ   AؚT   Aؚ   Aؚ   Aؚ   Aؚ\   Aؚ    Aؚ!   Aؚ#   Aؚ%d   Aؚ'&   Aؚ(   Aؚ*   Aؚ,l   Aؚ..   Aؚ/   Aؚ1   Aؚ3t   Aؚ56   Aؚ6   Aؚ8   Aؚ:|   Aؚ<>   Aؚ>    Aؚ?   AؚA   AؚCF   AؚE   AؚF   AؚH   AؚJN   AؚL   AؚM   AؚO   AؚQV   AؚS   AؚT   AؚV   AؚX^   AؚZ    Aؚ[   Aؚ]   Aؚ_f   Aؚa(   Aؚb   Aؚd   Aؚfn   Aؚh0   Aؚi   Aؚk   Aؚmv   Aؚo8   Aؚp   Aؚr   Aؚt~   Aؚv@   Aؚx   Aؚy   Aؚ{   Aؚ}H   Aؚ
   Aؚ   Aؚ   AؚP   Aؚ   Aؚ   Aؚ   AؚX   Aؚ   Aؚ   Aؚ   Aؚ`   Aؚ"   Aؚ   Aؚ   Aؚh   Aؚ*   Aؚ   Aؚ   Aؚp   Aؚ2   Aؚ   Aؚ   Aؚx   Aؚ:   Aؚ   Aؚ   Aؚ   AؚB   Aؚ   Aؚ   Aؚ   AؚJ   Aؚ   Aؚ   Aؚ   AؚR   Aؚ   Aؚ   AؚØ   AؚZ   Aؚ   Aؚ   Aؚʠ   Aؚb   Aؚ$   Aؚ   AؚѨ   Aؚj   Aؚ,   Aؚ   Aؚذ   Aؚr   Aؚ4   Aؚ   Aؚ߸   Aؚz   Aؚ<   Aؚ   Aؚ   Aؚ   AؚD   Aؚ   Aؚ   Aؚ   AؚL   Aؚ   Aؚ   Aؚ   AؚT   Aؚ   Aؚ   Aؚ   Aؚ\   A؛   A؛   A؛   A؛d   A؛&   A؛	   A؛   A؛
l   A؛.   A؛   A؛   A؛t   A؛6   A؛   A؛   A؛|   A؛>   A؛    A؛    A؛"   A؛$F   A؛&   A؛'   A؛)   A؛+N   A؛-   A؛.   A؛0   A؛2V   A؛4   A؛5   A؛7   A؛9^   A؛;    A؛<   A؛>   A؛@f   A؛B(   A؛C   A؛E   A؛Gn   A؛I0   A؛J   A؛L   A؛Nv   A؛P8   A؛Q   A؛S   A؛U~   A؛W@   A؛Y   A؛Z   A؛\   A؛^H   A؛`
   A؛a   A؛c   A؛eP   A؛g   A؛h   A؛j   A؛lX   A؛n   A؛o   A؛q   A؛s`   A؛u"   A؛v   A؛x   A؛zh   A؛|*   A؛}   A؛   A؛p   A؛2   A؛   A؛   A؛x   A؛:   A؛   A؛   A؛   A؛B   A؛   A؛   A؛   A؛J   A؛   A؛   A؛   A؛R   A؛   A؛   A؛   A؛Z   A؛   A؛   A؛   A؛b   A؛$   A؛   A؛   A؛j   A؛,   A؛   A؛   A؛r   A؛4   A؛   A؛   A؛z   A؛<   A؛   A؛   A؛ɂ   A؛D   A؛   A؛   A؛Њ   A؛L   A؛   A؛   A؛ג   A؛T   A؛   A؛   A؛ޚ   A؛\   A؛   A؛   A؛   A؛d   A؛&   A؛   A؛   A؛l   A؛.   A؛   A؛   A؛t   A؛6   A؛   A؛   A؛|   A؛>   A؜     A؜   A؜   A؜F   A؜   A؜   A؜
   A؜N   A؜   A؜   A؜   A؜V   A؜   A؜   A؜   A؜^   A؜    A؜   A؜   A؜!f   A؜#(   A؜$   A؜&   A؜(n   A؜*0   A؜+   A؜-   A؜/v   A؜18   A؜2   A؜4   A؜6~   A؜8@   A؜:   A؜;   A؜=   A؜?H   A؜A
   A؜B   A؜D   A؜FP   A؜H   A؜I   A؜K   A؜MX   A؜O   A؜P   A؜R   A؜T`   A؜V"   A؜W   A؜Y   A؜[h   A؜]*   A؜^   A؜`   A؜bp   A؜d2   A؜e   A؜g   A؜ix   A؜k:   A؜l   A؜n   A؜p   A؜rB   A؜t   A؜u   A؜w   A؜yJ   A؜{   A؜|   A؜~   A؜R   A؜   A؜   A؜   A؜Z   A؜   A؜   A؜   A؜b   A؜$   A؜   A؜   A؜j   A؜,   A؜   A؜   A؜r   A؜4   A؜   A؜   A؜z   A؜<   A؜   A؜   A؜   A؜D   A؜   A؜   A؜   A؜L   A؜   A؜   A؜   A؜T   A؜   A؜   A؜   A؜\   A؜   A؜   A؜Ƣ   A؜d   A؜&   A؜   A؜ͪ   A؜l   A؜.   A؜   A؜Բ   A؜t   A؜6   A؜   A؜ۺ   A؜|   A؜>   A؜    A؜   A؜   A؜F   A؜   A؜   A؜   A؜N   A؜   A؜   A؜   A؜V   A؜   A؜   A؜   A؜^   A؜    A؜   A؝    A؝f   A؝(   A؝   A؝   A؝	n   A؝0   A؝   A؝   A؝v   A؝8   A؝   A؝   A؝~   A؝@   A؝   A؝   A؝   A؝ H   A؝"
   A؝#   A؝%   A؝'P   A؝)   A؝*   A؝,   A؝.X   A؝0   A؝1   A؝3   A؝5`   A؝7"   A؝8   A؝:   A؝<h   A؝>*   A؝?   A؝A   A؝Cp   A؝E2   A؝F   A؝H   A؝Jx   A؝L:   A؝M   A؝O   A؝Q   A؝SB   A؝U   A؝V   A؝X   A؝ZJ   A؝\   A؝]   A؝_   A؝aR   A؝c   A؝d   A؝f   A؝hZ   A؝j   A؝k   A؝m   A؝ob   A؝q$   A؝r   A؝t   A؝vj   A؝x,   A؝y   A؝{   A؝}r   A؝4   A؝   A؝   A؝z   A؝<   A؝   A؝   A؝   A؝D   A؝   A؝   A؝   A؝L   A؝   A؝   A؝   A؝T   A؝   A؝   A؝   A؝\   A؝   A؝   A؝   A؝d   A؝&   A؝   A؝   A؝l   A؝.   A؝   A؝   A؝t   A؝6   A؝   A؝   A؝|   A؝>   A؝    A؝   A؝ń   A؝F   A؝   A؝   A؝̌   A؝N   A؝   A؝   A؝Ӕ   A؝V   A؝   A؝   A؝ڜ   A؝^   A؝    A؝   A؝   A؝f   A؝(   A؝   A؝   A؝n   A؝0   A؝   A؝   A؝v   A؝8   A؝   A؝   A؝~   A؝@   A؝   A؝   A؝   A؞H   A؞
   A؞   A؞   A؞P   A؞
   A؞   A؞
   A؞X   A؞   A؞   A؞   A؞`   A؞"   A؞   A؞   A؞h   A؞*   A؞    A؞"   A؞$p   A؞&2   A؞'   A؞)   A؞+x   A؞-:   A؞.   A؞0   A؞2   A؞4B   A؞6   A؞7   A؞9   A؞;J   A؞=   A؞>   A؞@   A؞BR   A؞D   A؞E   A؞G   A؞IZ   A؞K   A؞L   A؞N   A؞Pb   A؞R$   A؞S   A؞U   A؞Wj   A؞Y,   A؞Z   A؞\   A؞^r   A؞`4   A؞a   A؞c   A؞ez   A؞g<   A؞h   A؞j   A؞l   A؞nD   A؞p   A؞q   A؞s   A؞uL   A؞w   A؞x   A؞z   A؞|T   A؞~   A؞   A؞   A؞\   A؞   A؞   A؞   A؞d   A؞&   A؞   A؞   A؞l   A؞.   A؞   A؞   A؞t   A؞6   A؞   A؞   A؞|   A؞>   A؞    A؞   A؞   A؞F   A؞   A؞   A؞   A؞N   A؞   A؞   A؞   A؞V   A؞   A؞   A؞   A؞^   A؞    A؞   A؞¤   A؞f   A؞(   A؞   A؞ɬ   A؞n   A؞0   A؞   A؞д   A؞v   A؞8   A؞   A؞׼   A؞~   A؞@   A؞   A؞   A؞   A؞H   A؞
   A؞   A؞   A؞P   A؞   A؞   A؞   A؞X   A؞   A؞   A؞   A؞`   A؞"   A؞   A؞   A؞h   A؟ *   A؟   A؟   A؟p   A؟2   A؟   A؟
   A؟x   A؟:   A؟   A؟   A؟   A؟B   A؟   A؟   A؟   A؟J   A؟   A؟   A؟!   A؟#R   A؟%   A؟&   A؟(   A؟*Z   A؟,   A؟-   A؟/   A؟1b   A؟3$   A؟4   A؟6   A؟8j   A؟:,   A؟;   A؟=   A؟?r   A؟A4   A؟B   A؟D   A؟Fz   A؟H<   A؟I   A؟K   A؟M   A؟OD   A؟Q   A؟R   A؟T   A؟VL   A؟X   A؟Y   A؟[   A؟]T   A؟_   A؟`   A؟b   A؟d\   A؟f   A؟g   A؟i   A؟kd   A؟m&   A؟n   A؟p   A؟rl   A؟t.   A؟u   A؟w   A؟yt   A؟{6   A؟|   A؟~   A؟|   A؟>   A؟    A؟   A؟   A؟F   A؟   A؟   A؟   A؟N   A؟   A؟   A؟   A؟V   A؟   A؟   A؟   A؟^   A؟    A؟   A؟   A؟f   A؟(   A؟   A؟   A؟n   A؟0   A؟   A؟   A؟v   A؟8   A؟   A؟   A؟~   A؟@   A؟   A؟   A؟   A؟H   A؟
   A؟   A؟Ȏ   A؟P   A؟   A؟   A؟ϖ   A؟X   A؟   A؟   A؟֞   A؟`   A؟"   A؟   A؟ݦ   A؟h   A؟*   A؟   A؟   A؟p   A؟2   A؟   A؟   A؟x   A؟:   A؟   A؟   A؟   A؟B   A؟   A؟   A؟   A؟J   A؟   Aؠ    Aؠ   AؠR   Aؠ   Aؠ   Aؠ	   AؠZ   Aؠ
   Aؠ   Aؠ   Aؠb   Aؠ$   Aؠ   Aؠ   Aؠj   Aؠ,   Aؠ   Aؠ   Aؠ r   Aؠ"4   Aؠ#   Aؠ%   Aؠ'z   Aؠ)<   Aؠ*   Aؠ,   Aؠ.   Aؠ0D   Aؠ2   Aؠ3   Aؠ5   Aؠ7L   Aؠ9   Aؠ:   Aؠ<   Aؠ>T   Aؠ@   AؠA   AؠC   AؠE\   AؠG   AؠH   AؠJ   AؠLd   AؠN&   AؠO   AؠQ   AؠSl   AؠU.   AؠV   AؠX   AؠZt   Aؠ\6   Aؠ]   Aؠ_   Aؠa|   Aؠc>   Aؠe    Aؠf   Aؠh   AؠjF   Aؠl   Aؠm   Aؠo   AؠqN   Aؠs   Aؠt   Aؠv   AؠxV   Aؠz   Aؠ{   Aؠ}   Aؠ^   Aؠ    Aؠ   Aؠ   Aؠf   Aؠ(   Aؠ   Aؠ   Aؠn   Aؠ0   Aؠ   Aؠ   Aؠv   Aؠ8   Aؠ   Aؠ   Aؠ~   Aؠ@   Aؠ   Aؠ   Aؠ   AؠH   Aؠ
   Aؠ   Aؠ   AؠP   Aؠ   Aؠ   Aؠ   AؠX   Aؠ   Aؠ   Aؠ   Aؠ`   Aؠ"   Aؠ   Aؠ   Aؠh   Aؠ*   Aؠ   AؠŮ   Aؠp   Aؠ2   Aؠ   Aؠ̶   Aؠx   Aؠ:   Aؠ   AؠӾ   AؠՀ   AؠB   Aؠ   Aؠ   Aؠ܈   AؠJ   Aؠ   Aؠ   Aؠ   AؠR   Aؠ   Aؠ   Aؠ   AؠZ   Aؠ   Aؠ   Aؠ   Aؠb   Aؠ$   Aؠ   Aؠ   Aؠj   Aؠ,   Aؠ   Aؠ   Aءr   Aء4   Aء   Aء   Aءz   Aء
<   Aء   Aء
   Aء   AءD   Aء   Aء   Aء   AءL   Aء   Aء   Aء   AءT   Aء!   Aء"   Aء$   Aء&\   Aء(   Aء)   Aء+   Aء-d   Aء/&   Aء0   Aء2   Aء4l   Aء6.   Aء7   Aء9   Aء;t   Aء=6   Aء>   Aء@   AءB|   AءD>   AءF    AءG   AءI   AءKF   AءM   AءN   AءP   AءRN   AءT   AءU   AءW   AءYV   Aء[   Aء\   Aء^   Aء`^   Aءb    Aءc   Aءe   Aءgf   Aءi(   Aءj   Aءl   Aءnn   Aءp0   Aءq   Aءs   Aءuv   Aءw8   Aءx   Aءz   Aء|~   Aء~@   Aء   Aء   Aء   AءH   Aء
   Aء   Aء   AءP   Aء   Aء   Aء   AءX   Aء   Aء   Aء   Aء`   Aء"   Aء   Aء   Aءh   Aء*   Aء   Aء   Aءp   Aء2   Aء   Aء   Aءx   Aء:   Aء   Aء   Aء   AءB   Aء   Aء   Aء   AءJ   Aء   Aء   AءĐ   AءR   Aء   Aء   Aء˘   AءZ   Aء   Aء   AءҠ   Aءb   Aء$   Aء   Aء٨   Aءj   Aء,   Aء   Aء   Aءr   Aء4   Aء   Aء   Aءz   Aء<   Aء   Aء   Aء   AءD   Aء   Aء   Aء   AءL   Aء   Aء   Aء   Aآ T   Aآ   Aآ   Aآ   Aآ\   Aآ	   Aآ
   Aآ   Aآd   Aآ&   Aآ   Aآ   Aآl   Aآ.   Aآ   Aآ   Aآt   Aآ6   Aآ   Aآ!   Aآ#|   Aآ%>   Aآ'    Aآ(   Aآ*   Aآ,F   Aآ.   Aآ/   Aآ1   Aآ3N   Aآ5   Aآ6   Aآ8   Aآ:V   Aآ<   Aآ=   Aآ?   AآA^   AآC    AآD   AآF   AآHf   AآJ(   AآK   AآM   AآOn   AآQ0   AآR   AآT   AآVv   AآX8   AآY   Aآ[   Aآ]~   Aآ_@   Aآa   Aآb   Aآd   AآfH   Aآh
   Aآi   Aآk   AآmP   Aآo   Aآp   Aآr   AآtX   Aآv   Aآw   Aآy   Aآ{`   Aآ}"   Aآ~   Aآ   Aآh   Aآ*   Aآ   Aآ   Aآp   Aآ2   Aآ   Aآ   Aآx   Aآ:   Aآ   Aآ   Aآ   AآB   Aآ   Aآ   Aآ   AآJ   Aآ   Aآ   Aآ   AآR   Aآ   Aآ   Aآ   AآZ   Aآ   Aآ   Aآ   Aآb   Aآ$   Aآ   Aآ   Aآj   Aآ,   Aآ   Aآ   Aآr   Aآ4   Aآ   Aآȸ   Aآz   Aآ<   Aآ   Aآ   Aآт   AآD   Aآ   Aآ   Aآ؊   AآL   Aآ   Aآ   Aآߒ   AآT   Aآ   Aآ   Aآ   Aآ\   Aآ   Aآ   Aآ   Aآd   Aآ&   Aآ   Aآ   Aآl   Aآ.   Aآ   Aآ   Aآt   Aآ6   Aأ    Aأ   Aأ|   Aأ>   Aأ    Aأ	   Aأ   Aأ
F   Aأ   Aأ   Aأ   AأN   Aأ   Aأ   Aأ   AأV   Aأ   Aأ   Aأ    Aأ"^   Aأ$    Aأ%   Aأ'   Aأ)f   Aأ+(   Aأ,   Aأ.   Aأ0n   Aأ20   Aأ3   Aأ5   Aأ7v   Aأ98   Aأ:   Aأ<   Aأ>~   Aأ@@   AأB   AأC   AأE   AأGH   AأI
   AأJ   AأL   AأNP   AأP   AأQ   AأS   AأUX   AأW   AأX   AأZ   Aأ\`   Aأ^"   Aأ_   Aأa   Aأch   Aأe*   Aأf   Aأh   Aأjp   Aأl2   Aأm   Aأo   Aأqx   Aأs:   Aأt   Aأv   Aأx   AأzB   Aأ|   Aأ}   Aأ   AأJ   Aأ   Aأ   Aأ   Aأ   Aأ   Aأ   AأZ   Aأ   Aأ   Aأ   Aأb   Aأ$   Aأ   Aأ   Aأj   Aأ,   Aأ   Aأ   Aأr   Aأ4   Aأ   Aأ   Aأz   Aأ<   Aأ   Aأ   Aأ   AأD   Aأ   Aأ   Aأ   AأL   Aأ   Aأ   Aأ   AأT   Aأ   Aأ   Aأǚ   Aأ\   Aأ   Aأ   Aأ΢   Aأd   Aأ&   Aأ   Aأժ   Aأl   Aأ.   Aأ   Aأܲ   Aأt   Aأ6   Aأ   Aأ   Aأ|   Aأ>   Aأ    Aأ   Aأ   AأF   Aأ   Aأ   Aأ   AأN   Aأ   Aأ   Aأ   AأV   Aأ   Aأ   Aؤ   Aؤ^   Aؤ    Aؤ   Aؤ   Aؤ
f   Aؤ(   Aؤ
   Aؤ   Aؤn   Aؤ0   Aؤ   Aؤ   Aؤv   Aؤ8   Aؤ   Aؤ   Aؤ~   Aؤ!@   Aؤ#   Aؤ$   Aؤ&   Aؤ(H   Aؤ*
   Aؤ+   Aؤ-   Aؤ/P   Aؤ1   Aؤ2   Aؤ4   Aؤ6X   Aؤ8   Aؤ9   Aؤ;   Aؤ=`   Aؤ?"   Aؤ@   AؤB   AؤDh   AؤF*   AؤG   AؤI   AؤKp   AؤM2   AؤN   AؤP   AؤRx   AؤT:   AؤU   AؤW   AؤY   Aؤ[B   Aؤ]   Aؤ^   Aؤ`   AؤbJ   Aؤd   Aؤe   Aؤg   AؤiR   Aؤk   Aؤl   Aؤn   AؤpZ   Aؤr   Aؤs   Aؤu   Aؤwb   Aؤy$   Aؤz   Aؤ|   Aؤ~j   Aؤ,   Aؤ   Aؤ   Aؤr   Aؤ4   Aؤ   Aؤ   Aؤz   Aؤ<   Aؤ   Aؤ   Aؤ   AؤD   Aؤ   Aؤ   Aؤ   AؤL   Aؤ   Aؤ   Aؤ   AؤT   Aؤ   Aؤ   Aؤ   Aؤ\   Aؤ   Aؤ   Aؤ   Aؤd   Aؤ&   Aؤ   Aؤ   Aؤl   Aؤ.   Aؤ   Aؤ   Aؤt   Aؤ6   Aؤ   Aؤĺ   Aؤ|   Aؤ>   Aؤ    Aؤ   Aؤ̈́   AؤF   Aؤ   Aؤ   AؤԌ   AؤN   Aؤ   Aؤ   Aؤ۔   AؤV   Aؤ   Aؤ   Aؤ   Aؤ^   Aؤ    Aؤ   Aؤ   Aؤf   Aؤ(   Aؤ   Aؤ   Aؤn   Aؤ0   Aؤ   Aؤ   Aؤv   Aؤ8   Aؤ   Aؤ   Aإ ~   Aإ@   Aإ   Aإ   Aإ   Aإ	H   Aإ
   Aإ   Aإ   AإP   Aإ   Aإ   Aإ   AإX   Aإ   Aإ   Aإ   Aإ`   Aإ "   Aإ!   Aإ#   Aإ%h   Aإ'*   Aإ(   Aإ*   Aإ,p   Aإ.2   Aإ/   Aإ1   Aإ3x   Aإ5:   Aإ6   Aإ8   Aإ:   Aإ<B   Aإ>   Aإ?   AإA   AإCJ   AإE   AإF   AإH   AإJR   AإL   AإM   AإO   AإQZ   AإS   AإT   AإV   AإXb   AإZ$   Aإ[   Aإ]   Aإ_j   Aإa,   Aإb   Aإd   Aإfr   Aإh4   Aإi   Aإk   Aإmz   Aإo<   Aإp   Aإr   Aإt   AإvD   Aإx   Aإy   Aإ{   Aإ}L   Aإ   Aإ   Aإ   AإT   Aإ   Aإ   Aإ   Aإ\   Aإ   Aإ   Aإ   Aإd   Aإ&   Aإ   Aإ   Aإl   Aإ.   Aإ   Aإ   Aإt   Aإ6   Aإ   Aإ   Aإ|   Aإ>   Aإ    Aإ   Aإ   AإF   Aإ   Aإ   Aإ   AإN   Aإ   Aإ   Aإ   AإV   Aإ   Aإ   AإÜ   Aإ^   Aإ    Aإ   Aإʤ   Aإf   Aإ(   Aإ   AإѬ   Aإn   Aإ0   Aإ   Aإش   Aإv   Aإ8   Aإ   Aإ߼   Aإ~   Aإ@   Aإ   Aإ   Aإ   AإH   Aإ
   Aإ   Aإ   AإP   Aإ   Aإ   Aإ   AإX   Aإ   Aإ   Aإ   Aإ`   Aئ"   Aئ   Aئ   Aئh   Aئ*   Aئ	   Aئ   Aئ
p   Aئ2   Aئ   Aئ   Aئx   Aئ:   Aئ   Aئ   Aئ   AئB   Aئ   Aئ    Aئ"   Aئ$J   Aئ&   Aئ'   Aئ)   Aئ+R   Aئ-   Aئ.   Aئ0   Aئ2Z   Aئ4   Aئ5   Aئ7   Aئ9b   Aئ;$   Aئ<   Aئ>   Aئ@j   AئB,   AئC   AئE   AئGr   AئI4   AئJ   AئL   AئNz   AئP<   AئQ   AئS   AئU   AئWD   AئY   AئZ   Aئ\   Aئ^L   Aئ`   Aئa   Aئc   AئeT   Aئg   Aئh   Aئj   Aئl\   Aئn   Aئo   Aئq   Aئsd   Aئu&   Aئv   Aئx   Aئzl   Aئ|.   Aئ}   Aئ   Aئt   Aئ6   Aئ   Aئ   Aئ|   Aئ>   Aئ    Aئ   Aئ   AئF   Aئ   Aئ   Aئ   AئN   Aئ   Aئ   Aئ   AئV   Aئ   Aئ   Aئ   Aئ^   Aئ    Aئ   Aئ   Aئf   Aئ(   Aئ   Aئ   Aئn   Aئ0   Aئ   Aئ   Aئv   Aئ8   Aئ   Aئ   Aئ~   Aئ@   Aئ   Aئ   AئɆ   AئH   Aئ
   Aئ   AئЎ   AئP   Aئ   Aئ   Aئז   AئX   Aئ   Aئ   Aئޞ   Aئ`   Aئ"   Aئ   Aئ   Aئh   Aئ*   Aئ   Aئ   Aئp   Aئ2   Aئ   Aئ   Aئx   Aئ:   Aئ   Aئ   Aئ   AئB   Aا    Aا   Aا   AاJ   Aا   Aا   Aا
   AاR   Aا   Aا   Aا   AاZ   Aا   Aا   Aا   Aاb   Aا$   Aا   Aا   Aا!j   Aا#,   Aا$   Aا&   Aا(r   Aا*4   Aا+   Aا-   Aا/z   Aا1<   Aا2   Aا4   Aا6   Aا8D   Aا:   Aا;   Aا=   Aا?L   AاA   AاB   AاD   AاFT   AاH   AاI   AاK   AاM\   AاO   AاP   AاR   AاTd   AاV&   AاW   AاY   Aا[l   Aا].   Aا^   Aا`   Aاbt   Aاd6   Aاe   Aاg   Aاi|   Aاk>   Aاm    Aاn   Aاp   AاrF   Aاt   Aاu   Aاw   AاyN   Aا{   Aا|   Aا~   AاV   Aا   Aا   Aا   Aا^   Aا    Aا   Aا   Aاf   Aا(   Aا   Aا   Aاn   Aا0   Aا   Aا   Aاv   Aا8   Aا   Aا   Aا~   Aا@   Aا   Aا   Aا   AاH   Aا
   Aا   Aا   AاP   Aا   Aا   Aا   AاX   Aا   Aا   Aا   Aا`   Aا"   Aا   AاƦ   Aاh   Aا*   Aا   Aاͮ   Aاp   Aا2   Aا   AاԶ   Aاx   Aا:   Aا   Aا۾   Aا݀   AاB   Aا   Aا   Aا   AاJ   Aا   Aا   Aا   AاR   Aا   Aا   Aا   AاZ   Aا   Aا   Aا   Aاb   Aا$   Aا   Aب    Aبj   Aب,   Aب   Aب   Aب	r   Aب4   Aب   Aب   Aبz   Aب<   Aب   Aب   Aب   AبD   Aب   Aب   Aب   Aب L   Aب"   Aب#   Aب%   Aب'T   Aب)   Aب*   Aب,   Aب.\   Aب0   Aب1   Aب3   Aب5d   Aب7&   Aب8   Aب:   Aب<l   Aب>.   Aب?   AبA   AبCt   AبE6   AبF   AبH   AبJ|   AبL>   AبN    AبO   AبQ   AبSF   AبU   AبV   AبX   AبZN   Aب\   Aب]   Aب_   AبaV   Aبc   Aبd   Aبf   Aبh^   Aبj    Aبk   Aبm   Aبof   Aبq(   Aبr   Aبt   Aبvn   Aبx0   Aبy   Aب{   Aب}v   Aب8   Aب   Aب   Aب~   Aب@   Aب   Aب   Aب   AبH   Aب
   Aب   Aب   AبP   Aب   Aب   Aب   AبX   Aب   Aب   Aب   Aب`   Aب"   Aب   Aب   Aبh   Aب*   Aب   Aب   Aبp   Aب2   Aب   Aب   Aبx   Aب:   Aب   Aب   Aب   AبB   Aب   Aب   Aبň   AبJ   Aب   Aب   Aب̐   AبR   Aب   Aب   AبӘ   AبZ   Aب   Aب   Aبڠ   Aبb   Aب$   Aب   Aب   Aبj   Aب,   Aب   Aب   Aبr   Aب4   Aب   Aب   Aبz   Aب<   Aب   Aب   Aب   AبD   Aب   Aب   Aب   AةL   Aة   Aة   Aة   AةT   Aة
   Aة   Aة
   Aة\   Aة   Aة   Aة   Aةd   Aة&   Aة   Aة   Aةl   Aة.   Aة    Aة"   Aة$t   Aة&6   Aة'   Aة)   Aة+|   Aة->   Aة/    Aة0   Aة2   Aة4F   Aة6   Aة7   Aة9   Aة;N   Aة=   Aة>   Aة@   AةBV   AةD   AةE   AةG   AةI^   AةK    AةL   AةN   AةPf   AةR(   AةS   AةU   AةWn   AةY0   AةZ   Aة\   Aة^v   Aة`8   Aةa   Aةc   Aةe~   Aةg@   Aةi   Aةj   Aةl   AةnH   Aةp
   Aةq   Aةs   AةuP   Aةw   Aةx   Aةz   Aة|X   Aة~   Aة   Aة   Aة`   Aة"   Aة   Aة   Aةh   Aة*   Aة   Aة   Aةp   Aة2   Aة   Aة   Aةx   Aة:   Aة   Aة   Aة   AةB   Aة   Aة   Aة   AةJ   Aة   Aة   Aة   AةR   Aة   Aة   Aة   AةZ   Aة   Aة   Aة   Aةb   Aة$   Aة   Aة¨   Aةj   Aة,   Aة   Aةɰ   Aةr   Aة4   Aة   Aةи   Aةz   Aة<   Aة   Aة   Aةق   AةD   Aة   Aة   Aة   AةL   Aة   Aة   Aة   AةT   Aة   Aة   Aة   Aة\   Aة   Aة   Aة   Aةd   Aة&   Aة   Aة   Aةl   Aت .   Aت   Aت   Aتt   Aت6   Aت   Aت
   Aت|   Aت>   Aت    Aت   Aت   AتF   Aت   Aت   Aت   AتN   Aت   Aت   Aت!   Aت#V   Aت%   Aت&   Aت(   Aت*^   Aت,    Aت-   Aت/   Aت1f   Aت3(   Aت4   Aت6   Aت8n   Aت:0   Aت;   Aت=   Aت?v   AتA8   AتB   AتD   AتF~   AتH@   AتJ   AتK   AتM   AتOH   AتQ
   AتR   AتT   AتVP   AتX   AتY   Aت[   Aت]X   Aت_   Aت`   Aتb   Aتd`   Aتf"   Aتg   Aتi   Aتkh   Aتm*   Aتn   Aتp   Aتrp   Aتt2   Aتu   Aتw   Aتyx   Aت{:   Aت|   Aت~   Aت   AتB   Aت   Aت   Aت   AتJ   Aت   Aت   Aت   AتR   Aت   Aت   Aت   AتZ   Aت   Aت   Aت   Aتb   Aت$   Aت   Aت   Aتj   Aت,   Aت   Aت   Aتr   Aت4   Aت   Aت   Aتz   Aت<   Aت   Aت   Aت   AتD   Aت   Aت   Aت   AتL   Aت   Aت   AتȒ   AتT   Aت   Aت   AتϚ   Aت\   Aت   Aت   Aت֢   Aتd   Aت&   Aت   Aتݪ   Aتl   Aت.   Aت   Aت   Aتt   Aت6   Aت   Aت   Aت|   Aت>   Aت    Aت   Aت   AتF   Aت   Aت   Aت   AتN   Aت   Aث    Aث   AثV   Aث   Aث   Aث	   Aث^   Aث
    Aث   Aث   Aثf   Aث(   Aث   Aث   Aثn   Aث0   Aث   Aث   Aث v   Aث"8   Aث#   Aث%   Aث'~   Aث)@   Aث+   Aث,   Aث.   Aث0H   Aث2
   Aث3   Aث5   Aث7P   Aث9   Aث:   Aث<   Aث>X   Aث@   AثA   AثC   AثE`   AثG"   AثH   AثJ   AثLh   AثN*   AثO   AثQ   AثSp   AثU2   AثV   AثX   AثZx   Aث\:   Aث]   Aث_   Aثa   AثcB   Aثe   Aثf   Aثh   AثjJ   Aثl   Aثm   Aثo   AثqR   Aثs   Aثt   Aثv   AثxZ   Aثz   Aث{   Aث}   Aثb   Aث$   Aث   Aث   Aثj   Aث,   Aث   Aث   Aثr   Aث4   Aث   Aث   Aثz   Aث<   Aث   Aث   Aث   AثD   Aث   Aث   Aث   AثL   Aث   Aث   Aث   AثT   Aث   Aث   Aث   Aث\   Aث   Aث   Aث   Aثd   Aث&   Aث   Aث   Aثl   Aث.   Aث   AثŲ   Aثt   Aث6   Aث   Aث̺   Aث|   Aث>   Aث    Aث   AثՄ   AثF   Aث   Aث   Aث܌   AثN   Aث   Aث   Aث   AثV   Aث   Aث   Aث   Aث^   Aث    Aث   Aث   Aثf   Aث(   Aث   Aث   Aثn   Aث0   Aث   Aث   Aجv   Aج8   Aج   Aج   Aج~   Aج
@   Aج   Aج
   Aج   AجH   Aج
   Aج   Aج   AجP   Aج   Aج   Aج   AجX   Aج!   Aج"   Aج$   Aج&`   Aج("   Aج)   Aج+   Aج-h   Aج/*   Aج0   Aج2   Aج4p   Aج62   Aج7   Aج9   Aج;x   Aج=:   Aج>   Aج@   AجB   AجDB   AجF   AجG   AجI   AجKJ   AجM   AجN   AجP   AجRR   AجT   AجU   AجW   AجYZ   Aج[   Aج\   Aج^   Aج`b   Aجb$   Aجc   Aجe   Aجgj   Aجi,   Aجj   Aجl   Aجnr   Aجp4   Aجq   Aجs   Aجuz   Aجw<   Aجx   Aجz   Aج|   Aج~D   Aج   Aج   Aج   AجL   Aج   Aج   Aج   AجT   Aج   Aج   Aج   Aج\   Aج   Aج   Aج   Aجd   Aج&   Aج   Aج   Aجl   Aج.   Aج   Aج   Aجt   Aج6   Aج   Aج   Aج|   Aج>   Aج    Aج   Aج   AجF   Aج   Aج   Aج   AجN   Aج   Aج   AجĔ   AجV   Aج   Aج   Aج˜   Aج^   Aج    Aج   AجҤ   Aجf   Aج(   Aج   Aج٬   Aجn   Aج0   Aج   Aج   Aجv   Aج8   Aج   Aج   Aج~   Aج@   Aج   Aج   Aج   AجH   Aج
   Aج   Aج   AجP   Aج   Aج   Aج   Aح X   Aح   Aح   Aح   Aح`   Aح	"   Aح
   Aح   Aحh   Aح*   Aح   Aح   Aحp   Aح2   Aح   Aح   Aحx   Aح:   Aح   Aح!   Aح#   Aح%B   Aح'   Aح(   Aح*   Aح,J   Aح.   Aح/   Aح1   Aح3R   Aح5   Aح6   Aح8   Aح:Z   Aح<   Aح=   Aح?   AحAb   AحC$   AحD   AحF   AحHj   AحJ,   AحK   AحM   AحOr   AحQ4   AحR   AحT   AحVz   AحX<   AحY   Aح[   Aح]   Aح_D   Aحa   Aحb   Aحd   AحfL   Aحh   Aحi   Aحk   AحmT   Aحo   Aحp   Aحr   Aحt\   Aحv   Aحw   Aحy   Aح{d   Aح}&   Aح~   Aح   Aحl   Aح.   Aح   Aح   Aحt   Aح6   Aح   Aح   Aح|   Aح>   Aح    Aح   Aح   AحF   Aح   Aح   Aح   AحN   Aح   Aح   Aح   AحV   Aح   Aح   Aح   Aح^   Aح    Aح   Aح   Aحf   Aح   Aحn   Aح0   Aح   Aح   Aحv   Aح8   Aح   Aحȼ   Aح~   Aح@   Aح   Aح   Aحц   AحH   Aح
   Aح   Aح؎   AحP   Aح   Aح   Aحߖ   AحX   Aح   Aح   Aح   Aح`   Aح"   Aح   Aح   Aحh   Aح*   Aح   Aح   Aحp   Aح2   Aح   Aح   Aحx   Aح:   Aخ    Aخ   Aخ   AخB   Aخ   Aخ	   Aخ   Aخ
J   Aخ   Aخ   Aخ   AخR   Aخ   Aخ   Aخ   AخZ   Aخ   Aخ   Aخ    Aخ"b   Aخ$$   Aخ%   Aخ'   Aخ)j   Aخ+,   Aخ,   Aخ.   Aخ0r   Aخ24   Aخ3   Aخ5   Aخ7z   Aخ9<   Aخ:   Aخ<   Aخ>   Aخ@D   AخB   AخC   AخE   AخGL   AخI   AخJ   AخL   AخNT   AخP   AخQ   AخS   AخU\   AخW   AخX   AخZ   Aخ\d   Aخ^&   Aخ_   Aخa   Aخcl   Aخe.   Aخf   Aخh   Aخjt   Aخl6   Aخm   Aخo   Aخq|   Aخs>   Aخu    Aخv   Aخx   AخzF   Aخ|   Aخ}   Aخ   AخN   Aخ   Aخ   Aخ   AخV   Aخ   Aخ   Aخ   Aخ^   Aخ    Aخ   Aخ   Aخf   Aخ(   Aخ   Aخ   Aخn   Aخ0   Aخ   Aخ   Aخv   Aخ8   Aخ   Aخ   Aخ~   Aخ@   Aخ   Aخ   Aخ   AخH   Aخ
   Aخ   Aخ   AخP   Aخ   Aخ   Aخ   AخX   Aخ   Aخ   AخǞ   Aخ`   Aخ"   Aخ   AخΦ   Aخh   Aخ*   Aخ   Aخծ   Aخp   Aخ2   Aخ   Aخܶ   Aخx   Aخ:   Aخ   Aخ   Aخ   AخB   Aخ   Aخ   Aخ   AخJ   Aخ   Aخ   Aخ   AخR   Aخ   Aخ   Aخ   AخZ   Aخ   Aخ   Aد   Aدb   Aد$   Aد   Aد   Aد
j   Aد,   Aد
   Aد   Aدr   Aد4   Aد   Aد   Aدz   Aد<   Aد   Aد   Aد   Aد!D   Aد#   Aد$   Aد&   Aد(L   Aد*   Aد+   Aد-   Aد/T   Aد1   Aد2   Aد4   Aد6\   Aد8   Aد9   Aد;   Aد=d   Aد?&   Aد@   AدB   AدDl   AدF.   AدG   AدI   AدKt   AدM6   AدN   AدP   AدR|   AدT>   AدV    AدW   AدY   Aد[F   Aد]   Aد^   Aد`   AدbN   Aدd   Aدe   Aدg   AدiV   Aدk   Aدl   Aدn   Aدp^   Aدr    Aدs   Aدu   Aدwf   Aدy(   Aدz   Aد|   Aد~n   Aد0   Aد   Aد   Aدv   Aد8   Aد   Aد   Aد~   Aد@   Aد   Aد   Aد   AدH   Aد
   Aد   Aد   AدP   Aد   Aد   Aد   AدX   Aد   Aد   Aد   Aد`   Aد"   Aد   Aد   Aدh   Aد*   Aد   Aد   Aدp   Aد2   Aد   Aد   Aدx   Aد:   Aد   Aدľ   Aدƀ   AدB   Aد   Aد   Aد͈   AدJ   Aد   Aد   AدԐ   AدR   Aد   Aد   Aدۘ   AدZ   Aد   Aد   Aد   Aدb   Aد$   Aد   Aد   Aدj   Aد,   Aد   Aد   Aدr   Aد4   Aد   Aد   Aدz   Aد<   Aد   Aد   Aذ    AذD   Aذ   Aذ   Aذ   Aذ	L   Aذ   Aذ   Aذ   AذT   Aذ   Aذ   Aذ   Aذ\   Aذ   Aذ   Aذ   Aذd   Aذ &   Aذ!   Aذ#   Aذ%l   Aذ'.   Aذ(   Aذ*   Aذ,t   Aذ.6   Aذ/   Aذ1   Aذ3|   Aذ5>   Aذ7    Aذ8   Aذ:   Aذ<F   Aذ>   Aذ?   AذA   AذCN   AذE   AذF   AذH   AذJV   AذL   AذM   AذO   AذQ^   AذS    AذT   AذV   AذXf   AذZ(   Aذ[   Aذ]   Aذ_n   Aذa0   Aذb   Aذd   Aذfv   Aذh8   Aذi   Aذk   Aذm~   Aذo@   Aذq   Aذr   Aذt   AذvH   Aذx
   Aذy   Aذ{   Aذ}P   Aذ   Aذ   Aذ   AذX   Aذ   Aذ   Aذ   Aذ`   Aذ"   Aذ   Aذ   Aذh   Aذ*   Aذ   Aذ   Aذp   Aذ2   Aذ   Aذ   Aذx   Aذ:   Aذ   Aذ   Aذ   AذB   Aذ   Aذ   Aذ   AذJ   Aذ   Aذ   Aذ   AذR   Aذ   Aذ   Aذ   AذZ   Aذ   Aذ   Aذà   Aذb   Aذ$   Aذ   Aذʨ   Aذj   Aذ,   Aذ   AذѰ   Aذr   Aذ4   Aذ   Aذظ   Aذz   Aذ<   Aذ   Aذ   Aذ   AذD   Aذ   Aذ   Aذ   AذL   Aذ   Aذ   Aذ   AذT   Aذ   Aذ   Aذ   Aذ\   Aذ   Aذ   Aذ   Aذd   Aر&   Aر   Aر   Aرl   Aر.   Aر	   Aر   Aر
t   Aر6   Aر   Aر   Aر|   Aر>   Aر    Aر   Aر   AرF   Aر   Aر    Aر"   Aر$N   Aر&   Aر'   Aر)   Aر+V   Aر-   Aر.   Aر0   Aر2^   Aر4    Aر5   Aر7   Aر9f   Aر;(   Aر<   Aر>   Aر@n   AرB0   AرC   AرE   AرGv   AرI8   AرJ   AرL   AرN~   AرP@   AرR   AرS   AرU   AرWH   AرY
   AرZ   Aر\   Aر^P   Aر`   Aرa   Aرc   AرeX   Aرg   Aرh   Aرj   Aرl`   Aرn"   Aرo   Aرq   Aرsh   Aرu*   Aرv   Aرx   Aرzp   Aر|2   Aر}   Aر   Aرx   Aر:   Aر   Aر   Aر   AرB   Aر   Aر   Aر   AرJ   Aر   Aر   Aر   AرR   Aر   Aر   Aر   AرZ   Aر   Aر   Aر   Aرb   Aر$   Aر   Aر   Aرj   Aر,   Aر   Aر   Aرr   Aر4   Aر   Aر   Aرz   Aر<   Aر   Aر   Aر   AرD   Aر   Aر   AرɊ   AرL   Aر   Aر   AرВ   AرT   Aر   Aر   Aرך   Aر\   Aر   Aر   Aرޢ   Aرd   Aر&   Aر   Aر   Aرl   Aر.   Aر   Aر   Aرt   Aر6   Aر   Aر   Aر|   Aر>   Aر    Aر   Aر   AرF   Aز    Aز   Aز   AزN   Aز   Aز   Aز
   AزV   Aز   Aز   Aز   Aز^   Aز    Aز   Aز   Aزf   Aز(   Aز   Aز   Aز!n   Aز#0   Aز$   Aز&   Aز(v   Aز*8   Aز+   Aز-   Aز/~   Aز1@   Aز3   Aز4   Aز6   Aز8H   Aز;   Aز=   AزFX   AزH   AزTh   Aزg   Aزi   AزkB   Aزm   Aزn   Aزp   AزrJ   Aزt   Aزu   Aزw   AزyR   Aز{   Aز|   Aز~   AزZ   Aز   Aز   Aز   Aزb   Aز$   Aز   Aز   Aزj   Aز,   Aز   Aز   Aزr   Aز4   Aز   Aز   Aزz   Aز<   Aز   Aز   Aز   AزD   Aز   Aز   Aز   AزL   Aز   Aز   Aز   AزT   Aز   Aز   Aز   Aز\   Aز   Aز   Aز   Aزd   Aز&   Aز   Aزƪ   Aزl   Aز.   Aز   AزͲ   Aزt   Aز6   Aز   AزԺ   Aز|   Aز>   Aز    Aز   Aز݄   AزF   Aز   Aز   Aز   AزN   Aز   Aز   Aز   AزV   Aز   Aز   Aز   Aز^   Aز    Aز   Aز   Aزf   Aز(   Aز   Aس    Aسn   Aس0   Aس   Aس   Aس	v   Aس8   Aس   Aس   Aس~   Aس@   Aس   Aس   Aس   AسH   Aس
   Aس   Aس   Aس P   Aس"   Aس#   Aس%   Aس'X   Aس)   Aس*   Aس,   Aس.`   Aس0"   Aس1   Aس3   Aس5h   Aس7*   Aس8   Aس:   Aس<p   Aس>2   Aس?   AسA   AسCx   AسE:   AسF   AسH   AسJ   AسLB   AسN   AسO   AسQ   AسSJ   AسU   AسV   AسX   AسZR   Aس\   Aس]   Aس_   AسaZ   Aسc   Aسd   Aسf   Aسhb   Aسj$   Aسk   Aسm   Aسoj   Aسq,   Aسr   Aسt   Aسvr   Aسx4   Aسy   Aس{   Aس}z   Aس<   Aس   Aس   Aس   AسD   Aس   Aس   Aس   AسT   Aس   Aس   Aس   Aس\   Aس   Aس   Aس   Aسd   Aس&   Aس   Aس   Aسl   Aس.   Aس   Aس   Aسt   Aس6   Aس   Aس   Aس|   Aس>   Aس    Aس   Aس   AسF   Aس   Aس   AسŌ   AسN   Aس   Aس   Aس̔   AسV   Aس   Aس   AسӜ   Aس^   Aس    Aس   Aسڤ   Aسf   Aس(   Aس   Aس   Aسn   Aس0   Aس   Aس   Aسv   Aس8   Aس   Aس   Aس~   Aس@   Aس   Aس   Aس   AسH   Aس
   Aس   Aس   AشP   Aش   Aش   Aش   AشX   Aش
   Aش   Aش
   Aش`   Aش"   Aش   Aش   Aشh   Aش*   Aش   Aش   Aشp   Aش2   Aش    Aش"   Aش$x   Aش&:   Aش'   Aش)   Aش+   Aش-B   Aش/   Aش0   Aش2   Aش4J   Aش6   Aش7   Aش9   Aش;R   Aش=   Aش>   Aش@   AشBZ   AشD   AشE   AشG   AشIb   AشK$   AشL   AشN   AشPj   AشR,   AشS   AشU   AشWr   AشY4   AشZ   Aش\   Aش^z   Aش`<   Aشa   Aشc   Aشe   AشgD   Aشi   Aشj   Aشl   AشnL   Aشp   Aشq   Aشs   AشuT   Aشw   Aشx   Aشz   Aش|\   Aش~   Aش   Aش   Aشd   Aش&   Aش   Aش   Aشl   Aش.   Aش   Aش   Aش   Aش   Aش|   Aش>   Aش    Aش   Aش   AشF   Aش   Aش   Aش   AشN   Aش   Aش   Aش   AشV   Aش   Aش   Aش   Aش^   Aش    Aش   Aش   Aشf   Aش(   Aش   Aش¬   Aشn   Aش0   Aش   Aشɴ   Aشv   Aش8   Aش   Aشм   Aش~   Aش@   Aش   Aش   Aشن   AشH   Aش
   Aش   Aش   AشP   Aش   Aش   Aش   AشX   Aش   Aش   Aش   Aش`   Aش"   Aش   Aش   Aشh   Aش*   Aش   Aش   Aشp   Aص 2   Aص   Aص   Aصx   Aص:   Aص   Aص
   Aص   AصB   Aص   Aص   Aص   AصJ   Aص   Aص   Aص   AصR   Aص   Aص   Aص!   Aص#Z   Aص%   Aص&   Aص(   Aص*b   Aص,$   Aص-   Aص/   Aص1j   Aص3,   Aص4   Aص6   Aص8r   Aص:4   Aص;   Aص=   Aص?z   AصA<   AصB   AصD   AصF   AصHD   AصJ   AصK   AصM   AصOL   AصQ   AصR   AصT   AصVT   AصX   AصY   Aص[   Aص]\   Aص_   Aص`   Aصb   Aصdd   Aصf&   Aصg   Aصi   Aصkl   Aصm.   Aصn   Aصp   Aصrt   Aصt6   Aصu   Aصw   Aصy|   Aص{>   Aص}    Aص~   Aص   AصF   Aص   Aص   Aص   AصN   Aص   Aص   Aص   AصV   Aص   Aص   Aص   Aص^   Aص    Aص   Aص   Aصf   Aص(   Aص   Aص   Aصn   Aص0   Aص   Aص   Aصv   Aص8   Aص   Aص   Aص~   Aص@   Aص   Aص   Aص   AصH   Aص
   Aص   Aص   AصP   Aص   Aص   AصȖ   AصX   Aص   Aص   AصϞ   Aص`   Aص"   Aص   Aص֦   Aصh   Aص*   Aص   Aصݮ   Aصp   Aص2   Aص   Aص   Aصx   Aص:   Aص   Aص   Aص   AصB   Aص   Aص   Aص   AصJ   Aص   Aص   Aص   AصR   Aص   Aض    Aض   AضZ   Aض   Aض   Aض	   Aضb   Aض
$   Aض   Aض   Aضj   Aض,   Aض   Aض   Aضr   Aض4   Aض   Aض   Aض z   Aض"<   Aض#   Aض%   Aض'   Aض)D   Aض+   Aض,   Aض.   Aض0L   Aض2   Aض3   Aض5   Aض7T   Aض9   Aض:   Aض<   Aض>\   Aض@   AضA   AضC   AضEd   AضG&   AضH   AضJ   AضLl   AضN.   AضO   AضQ   AضSt   AضU6   AضV   AضX   AضZ|   Aض\>   Aض^    Aض_   Aضa   AضcF   Aضe   Aضf   Aضh   AضjN   Aضl   Aضm   Aضo   AضqV   Aضs   Aضt   Aضv   Aضx^   Aضz    Aض{   Aض}   Aضf   Aض(   Aض   Aض   Aضn   Aض0   Aض   Aض   Aضv   Aض8   Aض   Aض   Aض~   Aض@   Aض   Aض   Aض   AضH   Aض
   Aض   Aض   AضP   Aض   Aض   Aض   AضX   Aض   Aض   Aض   Aض`   Aض"   Aض   Aض   Aضh   Aض*   Aض   Aض   Aضp   Aض2   Aض   AضŶ   Aضx   Aض:   Aض   Aض̾   Aض΀   AضB   Aض   Aض   AضՈ   AضJ   Aض   Aض   Aضܐ   AضR   Aض   Aض   Aض   AضZ   Aض   Aض   Aض   Aضb   Aض$   Aض   Aض   Aضj   Aض,   Aض   Aض   Aضr   Aض4   Aض   Aض   Aطz   Aط<   Aط   Aط   Aط   Aط
D   Aط   Aط
   Aط   AطL   Aط   Aط   Aط   AطT   Aط   Aط   Aط   Aط\   Aط!   Aط"   Aط$   Aط&d   Aط(&   Aط)   Aط+   Aط-l   Aط/.   Aط0   Aط2   Aط4t   Aط66   Aط7   Aط9   Aط;|   Aط=>   Aط?    Aط@   AطB   AطDF   AطF   AطG   AطI   AطKN   AطM   AطN   AطP   AطRV   AطT   AطU   AطW   AطY^   Aط[    Aط\   Aط^   Aط`f   Aطb(   Aطc   Aطe   Aطgn   Aطi0   Aطj   Aطl   Aطnv   Aطp8   Aطq   Aطs   Aطu~   Aطw@   Aطy   Aطz   Aط|   Aط~H   Aط
   Aط   Aط   AطP   Aط   Aط   Aط   AطX   Aط   Aط   Aط   Aط`   Aط"   Aط   Aط   Aطh   Aط*   Aط   Aط   Aطp   Aط2   Aط   Aط   Aطx   Aط:   Aط   Aط   Aط   AطB   Aط   Aط   Aط   AطJ   Aط   Aط   Aط   AطR   Aط   Aط   AطĘ   AطZ   Aط   Aط   Aطˠ   Aطb   Aط$   Aط   AطҨ   Aطj   Aط,   Aط   Aطٰ   Aطr   Aط4   Aط   Aط   Aطz   Aط<   Aط   Aط   Aط   AطD   Aط   Aط   Aط   AطL   Aط   Aط   Aط   AطT   Aط   Aط   Aط   Aظ \   Aظ   Aظ   Aظ   Aظd   Aظ	&   Aظ
   Aظ   Aظl   Aظ.   Aظ   Aظ   Aظt   Aظ6   Aظ   Aظ   Aظ|   Aظ>   Aظ     Aظ!   Aظ#   Aظ%F   Aظ'   Aظ(   Aظ*   Aظ,N   Aظ.   Aظ/   Aظ1   Aظ3V   Aظ5   Aظ6   Aظ8   Aظ:^   Aظ<    Aظ=   Aظ?   AظAf   AظC(   AظD   AظF   AظHn   AظJ0   AظK   AظM   AظOv   AظQ8   AظR   AظT   AظV~   AظX@   AظZ   Aظ[   Aظ]   Aظ_H   Aظa
   Aظb   Aظd   AظfP   Aظh   Aظi   Aظk   AظmX   Aظo   Aظp   Aظr   Aظt`   Aظv"   Aظw   Aظy   Aظ{h   Aظ}*   Aظ~   Aظ   Aظp   Aظ2   Aظ   Aظ   Aظx   Aظ:   Aظ   Aظ   Aظ   AظB   Aظ   Aظ   Aظ   AظJ   Aظ   Aظ   Aظ   AظR   Aظ   Aظ   Aظ   AظZ   Aظ   Aظ   Aظ   Aظb   Aظ$   Aظ   Aظ   Aظj   Aظ,   Aظ   Aظ   Aظr   Aظ4   Aظ   Aظ   Aظz   Aظ<   Aظ   Aظ   Aظʂ   AظD   Aظ   Aظ   Aظъ   AظL   Aظ   Aظ   Aظؒ   AظT   Aظ   Aظ   Aظߚ   Aظ\   Aظ   Aظ   Aظ   Aظd   Aظ&   Aظ   Aظ   Aظl   Aظ.   Aظ   Aظ   Aظt   Aظ6   Aظ   Aظ   Aظ|   Aظ>   Aع    Aع   Aع   AعF   Aع   Aع	   Aع   Aع
N   Aع   Aع   Aع   AعV   Aع   Aع   Aع   Aع^   Aع    Aع   Aع    Aع"f   Aع$(   Aع%   Aع'   Aع)n   Aع+0   Aع,   Aع.   Aع0v   Aع28   Aع3   Aع5   Aع7~   Aع9@   Aع;   Aع<   Aع>   Aع@H   AعB
   AعC   AعE   AعGP   AعI   AعJ   AعL   AعNX   AعP   AعQ   AعS   AعU`   AعW"   AعX   AعZ   Aع\h   Aع^*   Aع_   Aعa   Aعcp   Aعe2   Aعf   Aعh   Aعjx   Aعl:   Aعm   Aعo   Aعq   AعsB   Aعu   Aعv   Aعx   AعzJ   Aع|   Aع}   Aع   AعR   Aع   Aع   Aع   AعZ   Aع   Aع   Aع   Aعb   Aع$   Aع   Aع   Aعj   Aع,   Aع   Aع   Aعr   Aع4   Aع   Aع   Aعz   Aع<   Aع   Aع   Aع   AعD   Aع   Aع   Aع   AعL   Aع   Aع   Aع   AعT   Aع   Aع   Aع   Aع\   Aع   Aع   AعǢ   Aعd   Aع&   Aع   AعΪ   Aعl   Aع.   Aع   Aعղ   Aعt   Aع6   Aع   Aعܺ   Aع|   Aع>   Aع    Aع   Aع   AعF   Aع   Aع   Aع   AعN   Aع   Aع   Aع   AعV   Aع   Aع   Aع   Aع^   Aع    Aع   Aغ   Aغf   Aغ(   Aغ   Aغ   Aغ
n   Aغ0   Aغ
   Aغ   Aغv   Aغ8   Aغ   Aغ   Aغ~   Aغ@   Aغ   Aغ   Aغ   Aغ!H   Aغ#
   Aغ$   Aغ&   Aغ(P   Aغ*   Aغ+   Aغ-   Aغ/X   Aغ1   Aغ2   Aغ4   Aغ6`   Aغ8"   Aغ9   Aغ;   Aغ=h   Aغ?*   Aغ@   AغB   AغDp   AغF2   AغG   AغI   AغKx   AغM:   AغN   AغP   AغR   AغTB   AغV   AغW   AغY   Aغ[J   Aغ]   Aغ^   Aغ`   AغbR   Aغd   Aغe   Aغg   AغiZ   Aغk   Aغl   Aغn   Aغpb   Aغr$   Aغs   Aغu   Aغwj   Aغy,   Aغz   Aغ|   Aغ~r   Aغ4   Aغ   Aغ   Aغz   Aغ<   Aغ   Aغ   Aغ   AغD   Aغ   Aغ   Aغ   AغL   Aغ   Aغ   Aغ   AغT   Aغ   Aغ   Aغ   Aغ\   Aغ   Aغ   Aغ   Aغd   Aغ&   Aغ   Aغ   Aغl   Aغ.   Aغ   Aغ   Aغt   Aغ6   Aغ   Aغ   Aغ|   Aغ>   Aغ    Aغ   AغƄ   AغF   Aغ   Aغ   Aغ͌   AغN   Aغ   Aغ   AغԔ   AغV   Aغ   Aغ   Aغۜ   Aغ^   Aغ    Aغ   Aغ   Aغf   Aغ(   Aغ   Aغ   Aغn   Aغ0   Aغ   Aغ   Aغv   Aغ8   Aغ   Aغ   Aغ~   Aغ@   Aغ   Aغ   Aػ    AػH   Aػ
   Aػ   Aػ   Aػ	P   Aػ   Aػ   Aػ   AػX   Aػ   Aػ   Aػ   Aػ`   Aػ"   Aػ   Aػ   Aػh   Aػ *   Aػ!   Aػ#   Aػ%p   Aػ'2   Aػ(   Aػ*   Aػ,x   Aػ.:   Aػ/   Aػ1   Aػ3   Aػ5B   Aػ7   Aػ8   Aػ:   Aػ<J   Aػ>   Aػ?   AػA   AػCR   AػE   AػF   AػH   AػJZ   AػL   AػM   AػO   AػQb   AػS$   AػT   AػV   AػXj   AػZ,   Aػ[   Aػ]   Aػ_r   Aػa4   Aػb   Aػd   Aػfz   Aػh<   Aػi   Aػk   Aػm   AػoD   Aػq   Aػ   Aػ   Aػ   Aػ\   Aػ   Aػ   Aػ   Aػd   Aػ   Aػ   Aػl   Aػ.   Aػ   Aػ   Aػt   Aػ6   Aػ   Aػ   Aػ|   Aػ>   Aػ    Aػ   Aػ   AػF   Aػ   Aػ   Aػ   AػN   Aػ   Aػ   Aػ   AػV   Aػ   Aػ   Aػ   Aػ^   Aػ    Aػ   Aػä   Aػf   Aػ(   Aػ   Aػʬ   Aػn   Aػ0   Aػ   AػѴ   Aػv   Aػ8   Aػ   Aػؼ   Aػ~   Aػ@   Aػ   Aػ   Aػ   AػH   Aػ
   Aػ   Aػ   AػP   Aػ   Aػ   Aػ   AػX   Aػ   Aػ   Aػ   Aػ`   Aػ"   Aػ   Aػ   Aػh   Aؼ*   Aؼ   Aؼ   Aؼp   Aؼ2   Aؼ	   Aؼ   Aؼ
x   Aؼ:   Aؼ   Aؼ   Aؼ   AؼB   Aؼ   Aؼ   Aؼ   AؼJ   Aؼ   Aؼ    Aؼ"   Aؼ$R   Aؼ&   Aؼ'   Aؼ)   Aؼ+Z   Aؼ-   Aؼ.   Aؼ0   Aؼ2b   Aؼ4$   Aؼ5   Aؼ7   Aؼ9j   Aؼ;,   Aؼ<   Aؼ>   Aؼ@r   AؼB4   AؼC   AؼE   AؼGz   AؼI<   AؼJ   AؼL   AؼN   AؼPD   AؼR   AؼS   AؼU   AؼWL   AؼY   AؼZ   Aؼ\   Aؼ^T   Aؼ`   Aؼa   Aؼc   Aؼe\   Aؼg   Aؼh   Aؼj   Aؼld   Aؼn&   Aؼo   Aؼq   Aؼsl   Aؼu.   Aؼv   Aؼx   Aؼzt   Aؼ|6   Aؼ}   Aؼ   Aؼ|   Aؼ>   Aؼ    Aؼ   Aؼ   AؼF   Aؼ   Aؼ   Aؼ   AؼN   Aؼ   Aؼ   Aؼ   AؼV   Aؼ   Aؼ   Aؼ   Aؼ^   Aؼ    Aؼ   Aؼ   Aؼf   Aؼ(   Aؼ   Aؼ   Aؼn   Aؼ0   Aؼ   Aؼ   Aؼv   Aؼ8   Aؼ   Aؼ   Aؼ~   Aؼ@   Aؼ   Aؼ   Aؼ   AؼH   Aؼ
   Aؼ   AؼɎ   AؼP   Aؼ   Aؼ   AؼЖ   AؼX   Aؼ   Aؼ   Aؼמ   Aؼ`   Aؼ"   Aؼ   Aؼަ   Aؼh   Aؼ*   Aؼ   Aؼ   Aؼp   Aؼ2   Aؼ   Aؼ   Aؼx   Aؼ:   Aؼ   Aؼ   Aؼ   AؼB   Aؼ   Aؼ   Aؼ   AؼJ   Aؽ    Aؽ   Aؽ   AؽR   Aؽ   Aؽ   Aؽ
   AؽZ   Aؽ   Aؽ   Aؽ   Aؽb   Aؽ$   Aؽ   Aؽ   Aؽj   Aؽ,   Aؽ   Aؽ   Aؽ!r   Aؽ#4   Aؽ$   Aؽ&   Aؽ(z   Aؽ*<   Aؽ+   Aؽ-   Aؽ/   Aؽ1D   Aؽ3   Aؽ4   Aؽ6   Aؽ8L   Aؽ:   Aؽ;   Aؽ=   Aؽ?T   AؽA   AؽB   AؽD   AؽF\   AؽH   AؽI   AؽK   AؽMd   AؽO&   AؽP   AؽR   AؽTl   AؽV.   AؽW   AؽY   Aؽ[t   Aؽ]6   Aؽ^   Aؽ`   Aؽb|   Aؽd>   Aؽf    Aؽg   Aؽi   AؽkF   Aؽm   Aؽn   Aؽp   AؽrN   Aؽt   Aؽu   Aؽw   AؽyV   Aؽ{   Aؽ|   Aؽ~   Aؽ^   Aؽ    Aؽ   Aؽ   Aؽf   Aؽ(   Aؽ   Aؽ   Aؽn   Aؽ0   Aؽ   Aؽ   Aؽv   Aؽ8   Aؽ   Aؽ   Aؽ~   Aؽ@   Aؽ   Aؽ   Aؽ   AؽH   Aؽ
   Aؽ   Aؽ   AؽP   Aؽ   Aؽ   Aؽ   AؽX   Aؽ   Aؽ   Aؽ   Aؽ`   Aؽ"   Aؽ   Aؽ   Aؽh   Aؽ*   Aؽ   AؽƮ   Aؽp   Aؽ2   Aؽ   AؽͶ   Aؽx   Aؽ:   Aؽ   AؽԾ   Aؽր   AؽB   Aؽ   Aؽ   Aؽ݈   AؽJ   Aؽ   Aؽ   Aؽ   AؽR   Aؽ   Aؽ   Aؽ   AؽZ   Aؽ   Aؽ   Aؽ   Aؽb   Aؽ$   Aؽ   Aؽ   Aؽj   Aؽ,   Aؽ   Aؾ    Aؾr   Aؾ4   Aؾ   Aؾ   Aؾ	z   Aؾ<   Aؾ   Aؾ   Aؾ   AؾD   Aؾ   Aؾ   Aؾ   AؾL   Aؾ   Aؾ   Aؾ   Aؾ T   Aؾ"   Aؾ#   Aؾ%   Aؾ'\   Aؾ)   Aؾ*   Aؾ,   Aؾ.d   Aؾ0&   Aؾ1   Aؾ3   Aؾ5l   Aؾ7.   Aؾ8   Aؾ:   Aؾ<t   Aؾ>6   Aؾ?   AؾA   AؾC|   AؾE>   AؾG    AؾH   AؾJ   AؾLF   AؾN   AؾO   AؾQ   AؾSN   AؾU   AؾV   AؾX   AؾZV   Aؾ\   Aؾ]   Aؾ_   Aؾa^   Aؾc    Aؾd   Aؾf   Aؾhf   Aؾj(   Aؾk   Aؾm   Aؾon   Aؾq0   Aؾr   Aؾt   Aؾvv   Aؾx8   Aؾy   Aؾ{   Aؾ}~   Aؾ@   Aؾ   Aؾ   Aؾ   AؾH   Aؾ
   Aؾ   Aؾ   AؾP   Aؾ   Aؾ   Aؾ   AؾX   Aؾ   Aؾ   Aؾ   Aؾ`   Aؾ"   Aؾ   Aؾ   Aؾh   Aؾ*   Aؾ   Aؾ   Aؾp   Aؾ2   Aؾ   Aؾ   Aؾx   Aؾ:   Aؾ   Aؾ   Aؾ   AؾB   Aؾ   Aؾ   Aؾ   AؾJ   Aؾ   Aؾ   AؾŐ   AؾR   Aؾ   Aؾ   Aؾ̘   AؾZ   Aؾ   Aؾ   AؾӠ   Aؾb   Aؾ$   Aؾ   Aؾڨ   Aؾj   Aؾ,   Aؾ   Aؾ   Aؾr   Aؾ4   Aؾ   Aؾ   Aؾz   Aؾ<   Aؾ   Aؾ   Aؾ   AؾD   Aؾ   Aؾ   Aؾ   AؾL   Aؾ   Aؾ   Aؾ   AؿT   Aؿ   Aؿ   Aؿ   Aؿ\   Aؿ
   Aؿ   Aؿ
   Aؿd   Aؿ&   Aؿ   Aؿ   Aؿl   Aؿ.   Aؿ   Aؿ   Aؿt   Aؿ6   Aؿ    Aؿ"   Aؿ$|   Aؿ&>   Aؿ(    Aؿ)   Aؿ+   Aؿ-F   Aؿ/   Aؿ0   Aؿ2   Aؿ4N   Aؿ6   Aؿ7   Aؿ9   Aؿ;V   Aؿ=   Aؿ>   Aؿ@   AؿB^   AؿD    AؿE   AؿG   AؿIf   AؿK(   AؿL   AؿN   AؿPn   AؿR0   AؿS   AؿU   AؿWv   AؿY8   AؿZ   Aؿ\   Aؿ^~   Aؿ`@   Aؿb   Aؿc   Aؿe   AؿgH   Aؿi
   Aؿj   Aؿl   AؿnP   Aؿp   Aؿq   Aؿs   AؿuX   Aؿw   Aؿx   Aؿz   Aؿ|`   Aؿ~"   Aؿ   Aؿ   Aؿh   Aؿ*   Aؿ   Aؿ   Aؿp   Aؿ2   Aؿ   Aؿ   Aؿx   Aؿ:   Aؿ   Aؿ   Aؿ   AؿB   Aؿ   Aؿ   Aؿ   AؿJ   Aؿ   Aؿ   Aؿ   AؿR   Aؿ   Aؿ   Aؿ   AؿZ   Aؿ   Aؿ   Aؿ   Aؿb   Aؿ$   Aؿ   Aؿ   Aؿj   Aؿ,   Aؿ   Aؿ°   Aؿr   Aؿ4   Aؿ   Aؿɸ   Aؿz   Aؿ<   Aؿ   Aؿ   Aؿ҂   AؿD   Aؿ   Aؿ   Aؿي   AؿL   Aؿ   Aؿ   Aؿ   AؿT   Aؿ   Aؿ   Aؿ   Aؿ\   Aؿ   Aؿ   Aؿ   Aؿd   Aؿ&   Aؿ   Aؿ   Aؿl   Aؿ.   Aؿ   Aؿ   Aؿt   A 6   A   A   A|   A>   A	    A
   A   AF   A   A   A   AN   A   A   A   AV   A   A   A!   A#^   A%    A&   A(   A*f   A,(   A-   A/   A1n   A30   A4   A6   A8v   A:8   A;   A=   A?~   AA@   AC   AD   AF   AHH   AJ
   AK   AM   AOP   AQ   AR   AT   AVX   AX   AY   A[   A]`   A_"   A`   Ab   Adh   Af*   Ag   Ai   Akp   Am2   An   Ap   Arx   At:   Au   Aw   Ay   A{B   A}   A~   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   AȚ   A\   A   A   AϢ   Ad   A&   A   A֪   Al   A.   A   Aݲ   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A    A   A^   A    A   A	   Af   A
(   A   A   An   A0   A   A   Av   A8   A   A   A ~   A"@   A$   A%   A'   A)H   A+
   A,   A.   A0P   A2   A3   A5   A7X   A9   A:   A<   A>`   A@"   AA   AC   AEh   AG*   AH   AJ   ALp   AN2   AO   AQ   ASx   AU:   AV   AX   AZ   A\B   A^   A_   Aa   AcJ   Ae   Af   Ah   AjR   Al   Am   Ao   AqZ   As   At   Av   Axb   Az$   A{   A}   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   Aź   A|   A>   A    A   A΄   AF   A   A   AՌ   AN   A   A   Aܔ   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   A
H   A
   A
   A   AP   A   A   A   AX   A   A   A   A`   A!"   A"   A$   A&h   A(*   A)   A+   A-p   A/2   A0   A2   A4x   A6:   A7   A9   A;   A=B   A?   A@   AB   ADJ   AF   AG   AI   AKR   AM   AN   AP   ARZ   AT   AU   AW   AYb   A[$   A\   A^   A`j   Ab,   Ac   Ae   Agr   Ai4   Aj   Al   Anz   Ap<   Aq   As   Au   AwD   Ay   Az   A|   A~L   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   A¡t   A£6   A¤   A¦   A¨|   Aª>   A¬    A­   A¯   A±F   A³   A´   A¶   A¸N   Aº   A»   A½   A¿V   A   A   AĜ   A^   A    A   Aˤ   Af   A(   A   AҬ   An   A0   A   Aٴ   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A `   A"   A   A   Ah   A	*   A
   A   Ap   A2   Ax   A:   A   A   A   AB   A    A!   A#   A%J   A'   A(   A*   A,R   A.   A/   A1   A3Z   A5   A6   A8   A:b   A<$   A=   A?   AAj   AC,   AD   AF   AHr   AJ4   AK   AM   AOz   AQ<   AR   AT   AV   AXD   AZ   A[   A]   A_L   Aa   Ab   Ad   AfT   Ah   Ai   Ak   Am\   Ao   Ap   Ar   Atd   Av&   Aw   Ay   A{l   A}.   A~   AÀ   AÂt   AÄ6   AÅ   AÇ   AÉ|   AË>   AÍ    AÎ   AÐ   AÒF   AÔ   AÕ   A×   AÙN   AÛ   AÜ   AÞ   AàV   Aâ   Aã   Aå   Aç^   Aé    Aê   Aì   Aîf   Að(   Añ   Aó   Aõn   A÷0   Aø   Aú   Aüv   Aþ8   Aÿ   A   A~   A@   A   A   Aʆ   AH   A
   A   Aю   AP   A   A   Aؖ   AX   A   A   Aߞ   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A	   A   A
R   A   A   A   AZ   A   A   A   Ab   A$   A   A    A"j   A$,   A%   A'   A)r   A+4   A,   A.   A0z   A2<   A3   A5   A7   A9D   A;   A<   A>   A@L   AB   AC   AE   AGT   AI   AJ   AL   AN\   AP   AQ   AS   AUd   AW&   AX   AZ   A\l   A^.   A_   Aa   Act   Ae6   Af   Ah   Aj|   Al>   An    Ao   Aq   AsF   Au   Av   Ax   AzN   A|   A}   A   AāV   Aă   AĄ   AĆ   AĈ^   AĊ    Aċ   Ač   Aďf   Ađ(   AĒ   AĔ   AĖn   AĘ0   Aę   Aě   Aĝv   Ağ8   AĠ   AĢ   AĤ~   AĦ@   AĨ   Aĩ   Aī   AĭH   Aį
   Aİ   AĲ   AĴP   AĶ   Aķ   AĹ   AĻX   AĽ   Aľ   A   A`   A"   A   AǦ   Ah   A*   A   Aή   Ap   A2   A   Aն   Ax   A:   A   Aܾ   Aހ   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   A
r   A4   A
   A   Az   A<   A   A   A   AD   A   A   A   A!L   A#   A$   A&   A(T   A*   A+   A-   A/\   A1   A2   A4   A6d   A8&   A9   A;   A=l   A?.   A@   AB   ADt   AF6   AG   AI   AK|   AM>   AO    AP   AR   ATF   AV   AW   AY   A[N   A]   A^   A`   AbV   Ad   Ae   Ag   Ai^   Ak    Al   An   Apf   Ar(   As   Au   Awn   Ay0   Az   A|   A~v   Aŀ8   AŁ   AŃ   AŅ~   AŇ@   Aŉ   AŊ   AŌ   AŎH   AŐ
   Aő   Aœ   AŕP   Aŗ   AŘ   AŚ   AŜX   AŞ   Aş   Aš   Aţ`   Ať"   AŦ   AŨ   AŪh   AŬ*   Aŭ   Aů   Aűp   Aų2   AŴ   AŶ   AŸx   Aź:   AŻ   AŽ   Aſ   AB   A   A   Aƈ   AJ   A   A   A͐   AR   A   A   AԘ   AZ   A   A   A۠   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A    AL   A   A   A   A	T   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A .   A!   A#   A%t   A'6   A(   A*   A,|   A.>   A0    A1   A3   A5F   A7   A8   A:   A<N   A>   A?   AA   ACV   AE   AF   AH   AJ^   AL    AM   AO   AQf   AS(   AT   AV   AXn   AZ0   A[   A]   A_v   Aa8   Ab   Ad   Af~   Ah@   Aj   Ak   Am   AoH   Aq
   Ar   At   AvP   Ax   Ay   A{   A}X   A   Aƀ   AƂ   AƄ`   AƆ"   AƇ   AƉ   AƋh   Aƍ*   AƎ   AƐ   Aƒp   AƔ2   Aƕ   AƗ   Aƙx   Aƛ:   AƜ   Aƞ   AƠ   AƢB   AƤ   Aƥ   AƧ   AƩJ   Aƫ   AƬ   AƮ   AưR   AƲ   AƳ   AƵ   AƷZ   Aƹ   Aƺ   AƼ   Aƾb   A$   A   Aè   Aj   A,   A   Aʰ   Ar   A4   A   AѸ   Az   A<   A   A   Aڂ   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A	   A   A
|   A>   A    A   A   AF   A   A   A   AN   A   A    A"   A$V   A&   A'   A)   A+^   A-    A.   A0   A2f   A4(   A5   A7   A9n   A;0   A<   A>   A@v   AB8   AC   AE   AG~   AI@   AK   AL   AN   APH   AR
   AS   AU   AWP   AY   AZ   A\   A^X   A`   Aa   Ac   Ae`   Ag"   Ah   Aj   Alh   An*   Ao   Aq   Asp   Au2   Av   Ax   Azx   A|:   A}   A   Aǁ   AǃB   Aǅ   Aǆ   Aǈ   AǊJ   Aǌ   AǍ   AǏ   AǑR   AǓ   Aǔ   Aǖ   AǘZ   Aǚ   AǛ   Aǝ   Aǟb   Aǡ$   AǢ   AǤ   AǦj   AǨ,   Aǩ   Aǫ   Aǭr   Aǯ4   Aǰ   Aǲ   AǴz   AǶ<   AǷ   Aǹ   Aǻ   AǽD   Aǿ   A   A   AL   A   A   Aɒ   AT   A   A   AК   A\   A   A   Aע   Ad   A&   A   Aު   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A    A   A   AV   A
   A^   A    A   A   Af   A(   A   A   An   A0   A   A   A!v   A#8   A$   A&   A(~   A*@   A,   A-   A/   A1H   A3
   A4   A6   A8P   A:   A;   A=   A?X   AA   AB   AD   AF`   AH"   AI   AK   AMh   AO*   AP   AR   ATp   AV2   AW   AY   A[x   A]:   A^   A`   Ab   AdB   Af   Ag   Ai   AkJ   Am   An   Ap   ArR   At   Au   Aw   AyZ   A{   A|   A~   AȀb   AȂ$   Aȃ   Aȅ   Aȇj   Aȉ,   AȊ   AȌ   AȎr   AȐ4   Aȑ   Aȓ   Aȕz   Aȗ<   AȘ   AȚ   AȜ   AȞD   AȠ   Aȡ   Aȣ   AȥL   Aȧ   AȨ   AȪ   AȬT   AȮ   Aȯ   Aȱ   Aȳ\   Aȵ   Aȶ   Aȸ   AȺd   Aȼ&   AȽ   Aȿ   Al   A.   A   AƲ   At   A6   A   Aͺ   A|   A>   A    A   Aք   AF   A   A   A݌   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A    Av   A8   A   A   A	~   A@   A
   A   A   AH   A
   A   A   AP   A   A   A   A X   A"   A#   A%   A'`   A)"   A*   A,   A.h   A0*   A1   A3   A5p   A72   A8   A:   A<x   A>:   A?   AA   AC   AEB   AG   AH   AJ   ALJ   AN   AO   AQ   ASR   AU   AV   AX   AZZ   A\   A]   A_   Aab   Ac$   Ad   Af   Ahj   Aj,   Ak   Am   Aor   Aq4   Ar   At   Avz   Ax<   Ay   A{   A}   AD   AɁ   Aɂ   AɄ   AɆL   AɈ   Aɉ   Aɋ   AɍT   Aɏ   Aɐ   Aɒ   Aɔ\   Aɖ   Aɗ   Aə   Aɛd   Aɝ&   Aɞ   Aɠ   Aɢl   Aɤ.   Aɥ   Aɧ   Aɩt   Aɫ6   Aɬ   Aɮ   Aɰ|   Aɲ>   Aɴ    Aɵ   Aɷ   AɹF   Aɻ   Aɼ   Aɾ   AN   A   A   AŔ   AV   A   A   A̜   A^   A    A   AӤ   Af   A(   A   Aڬ   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A
"   A   A
   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A    A"   A$   A&B   A+   A-J   A/   A0   A2   A4R   A6   A7   A9   A;Z   A=   A>   A@   ABb   AD$   AE   AG   AIj   AK,   AL   AN   APr   AR4   AS   AU   AWz   AY<   AZ   A\   A^   A`D   Ab   Ac   Ae   AgL   Ai   Aj   Al   AnT   Ap   Aq   As   Au\   Aw   Ax   Az   A|d   A~&   A   Aʁ   Aʃl   Aʅ.   Aʆ   Aʈ   Aʊt   Aʌ6   Aʍ   Aʏ   Aʑ|   Aʓ>   Aʕ    Aʖ   Aʘ   AʚF   Aʜ   Aʝ   Aʟ   AʡN   Aʣ   Aʤ   Aʦ   AʨV   Aʪ   Aʫ   Aʭ   Aʯ^   Aʱ    Aʲ   Aʴ   Aʶf   Aʸ(   Aʹ   Aʻ   Aʽn   Aʿ0   A   A´   Av   A8   A   Aɼ   A~   A@   A   A   A҆   AH   A
   A   Aَ   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A :   A   A   A   AB   A	   A
   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A!   A#b   A%$   A&   A(   A*j   A,,   A-   A/   A1r   A34   A4   A6   A8z   A:<   A;   A=   A?   AAD   AC   AD   AF   AHL   AJ   AK   AM   AOT   AQ   AR   AT   AV\   AX   AY   A[   A]d   A_&   A`   Ab   Adl   Af.   Ag   Ai   Akt   Am6   An   Ap   Ar|   A˂N   A˄   A˅   Aˇ   AˉV   Aˋ   Aˌ   Aˎ   Aٸ   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   A d   A&   A   A   Al   A	.   A
   A   At   A6   A   A   A|   A>   A    A   A   AF   A    A!   A#   A%N   A'   A(   A*   A,V   A.   A/   A1   A3^   A5    A6   A8   A:f   A<(   A=   A?   AAn   AC0   AD   AF   AHv   AJ8   AK   AM   AO~   AQ@   AS   AT   AV   AXH   AZ
   A[   A]   A_P   Aa   Ab   Ad   AfX   Ah   Ai   Ak   Am`   Ao"   Ap   Ar   Ath   Av*   Aw   Ay   A{p   A}2   A~   A΀   A΂x   A΄:   A΅   A·   AΉ   A΋B   A΍   AΎ   Aΐ   AΒJ   AΔ   AΕ   AΗ   AΙR   AΛ   AΜ   AΞ   AΠZ   A΢   AΣ   AΥ   AΧb   AΩ$   AΪ   Aά   Aήj   Aΰ,   Aα   Aγ   Aεr   Aη4   Aθ   Aκ   Aμz   Aξ<   Aο   A   AÂ   AD   A   A   Aʊ   AL   A   A   Aђ   AT   A   A   Aؚ   A\   A   A   Aߢ   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A	   A   A
V   A   A   A   A^   A    A   A   Af   A(   A   A    A"n   A$0   A%   A'   A)v   A+8   A,   A.   A0~   A2@   A4   A5   A7   A9H   A;
   A<   A>   A@P   AB   AC   AE   AGX   AI   AJ   AL   AN`   AP"   AQ   AS   AUh   AW*   AX   AZ   A\p   A^2   A_   Aa   Acx   Ae:   Af   Ah   Aj   AlB   An   Ao   Aq   AsJ   Au   Av   Ax   AzR   A|   A}   A   AρZ   Aσ   Aτ   Aφ   Aψb   Aϊ$   Aϋ   Aύ   AϏj   Aϑ,   Aϒ   Aϔ   Aϖr   AϘ4   Aϙ   Aϛ   Aϝz   Aϟ<   AϠ   AϢ   AϤ   AϦD   AϨ   Aϩ   Aϫ   AϭL   Aϯ   Aϰ   Aϲ   AϴT   A϶   AϷ   AϹ   Aϻ\   AϽ   AϾ   A   Ad   A&   A   AǪ   Al   A.   A   Aβ   At   A6   A   Aպ   A|   A>   A    A   Aބ   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   A
v   A8   A
   A   A~   A@   A   A   A   AH   A
   A   A   A!P   A#   A$   A&   A(X   A*   A+   A-   A/`   A1"   A2   A4   A6h   A8*   A9   A;   A=p   A?2   A@   AB   ADx   AF:   AG   AI   AK   AMB   AO   AP   AR   ATJ   AV   AW   AY   A[R   A]   A^   A`   AbZ   Ad   Ae   Ag   Aib   Ak$   Al   An   Apj   Ar,   As   Au   Awr   Ay4   Az   A|   A~z   AЀ<   AЁ   AЃ   AЅ   AЇD   AЉ   AЊ   AЌ   AЎL   AА   AБ   AГ   AЕT   AЗ   AИ   AК   AМ\   AО   AП   AС   AУd   AХ&   AЦ   AШ   AЪl   AЬ.   AЭ   AЯ   Aбt   Aг6   Aд   Aж   Aи|   Aк>   Aм    Aн   Aп   AF   A   A   Aƌ   AN   A   A   A͔   AV   A   A   AԜ   A^   A    A   Aۤ   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A    AP   A   A   A   A	X   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A 2   A!   A#   A%x   A':   A(   A*   A,   A.B   A0   A1   A3   A5J   A7   A8   A:   A<R   A>   A?   AA   ACZ   AE   AF   AH   AJb   AL$   AM   AO   AQj   AS,   AT   AV   AXr   AZ4   A[   A]   A_z   Aa<   Ab   Ad   Af   AhD   Aj   Ak   Am   AoL   Aq   Ar   At   AvT   Ax   Ay   A{   A}\   A   Aр   Aт   Aфd   Aц&   Aч   Aщ   Aыl   Aэ.   Aю   Aѐ   Aђt   Aє6   Aѕ   Aї   Aљ|   Aћ>   Aѝ    Aў   AѠ   AѢF   AѤ   Aѥ   Aѧ   AѩN   Aѫ   AѬ   AѮ   AѰV   AѲ   Aѳ   Aѵ   Aѷ^   Aѹ    AѺ   AѼ   AѾf   A(   A   Aì   An   A0   A   Aʴ   Av   A8   A   AѼ   A~   A@   A   A   Aچ   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A	   A   A
   AB   A   A   A   AJ   A   A   A   AR   A   A    A"   A$Z   A&   A'   A)   A+b   A-$   A.   A0   A2j   A4,   A5   A7   A9r   A;4   A<   A>   A@z   AB<   AC   AE   AG   AID   AK   AL   AN   APL   AR   AS   AU   AWT   AY   AZ   A\   A^\   A`   Aa   Ac   Aed   Ag&   Ah   Aj   All   An.   Ao   Aq   Ast   Au6   Av   Ax   Az|   A|>   A~    A   Aҁ   A҃F   A҅   A҆   A҈   AҊN   AҌ   Aҍ   Aҏ   AґV   Aғ   AҔ   AҖ   AҘ^   AҚ    Aқ   Aҝ   Aҟf   Aҡ(   AҢ   AҤ   AҦn   AҨ0   Aҩ   Aҫ   Aҭv   Aү8   AҰ   AҲ   AҴ~   AҶ@   AҸ   Aҹ   Aһ   AҽH   Aҿ
   A   A   AP   A   A   Aɖ   AX   A   A   AО   A`   A"   A   Aצ   Ah   A*   A   Aޮ   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A    A   A   AZ   A   A   A
   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   A!z   A#<   A$   A&   A(   A*D   A,   A-   A/   A1L   A3   A4   A6   A8T   A:   A;   A=   A?\   AA   AB   AD   AFd   AH&   AI   AK   AMl   AO.   AP   AR   ATt   AV6   AW   AY   A[|   A]>   A_    A`   Ab   AdF   Af   Ag   Ai   AkN   Am   An   Ap   ArV   At   Au   Aw   Ay^   A{    A|   A~   AӀf   Aӂ(   AӃ   AӅ   AӇn   AӉ0   Aӊ   Aӌ   Aӎv   AӐ8   Aӑ   Aӓ   Aӕ~   Aӗ@   Aә   AӚ   AӜ   AӞH   AӠ
   Aӡ   Aӣ   AӥP   Aӧ   AӨ   AӪ   AӬX   AӮ   Aӯ   Aӱ   Aӳ`   Aӵ"   AӶ   AӸ   AӺh   AӼ*   Aӽ   Aӿ   Ap   A2   A   Aƶ   Ax   A:   A   A;   Aπ   AB   A   A   Aֈ   AJ   A   A   Aݐ   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A    Az   A<   A   A   A	   AD   A
   A   A   AL   A   A   A   AT   A   A   A   A \   A"   A#   A%   A'd   A)&   A*   A,   A.l   A0.   A1   A3   A5t   A76   A8   A:   A<|   A>>   A@    AA   AC   AEF   AG   AH   AJ   ALN   AN   AO   AQ   ASV   AU   AV   AX   AZ^   A\    A]   A_   Aaf   Ac(   Ad   Af   Ahn   Aj0   Ak   Am   Aov   Aq8   Ar   At   Av~   Ax@   Az   A{   A}   AH   Aԁ
   AԂ   AԄ   AԆP   AԈ   Aԉ   Aԋ   AԍX   Aԏ   AԐ   AԒ   AԔ`   AԖ"   Aԗ   Aԙ   Aԛh   Aԝ*   AԞ   AԠ   AԢp   AԤ2   Aԥ   Aԧ   Aԩx   Aԫ:   AԬ   AԮ   A԰   AԲB   AԴ   AԵ   AԷ   AԹJ   AԻ   AԼ   AԾ   AR   A   A   AŘ   AZ   A   A   A̠   Ab   A$   A   AӨ   Aj   A,   A   Aڰ   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A
&   A   A
   Al   A.   A   A   At   A6   A   A   A|   A>   A!    A"   A$   A&F   A(   A)   A+   A-N   A/   A0   A2   A4V   A6   A7   A9   A;^   A=    A>   A@   ABf   AD(   AE   AG   AIn   AK0   AL   AN   APv   AR8   AS   AU   AW~   AY@   A[   A\   A^   A`H   Ab
   Ac   Ae   AgP   Ai   Aj   Al   AnX   Ap   Aq   As   Au`   Aw"   Ax   Az   A|h   A~*   A   AՁ   AՃp   AՅ2   AՆ   AՈ   AՊx   AՌ:   AՍ   AՏ   AՑ   AՓB   AՕ   AՖ   A՘   A՚J   A՜   A՝   A՟   AաR   Aգ   Aդ   Aզ   AըZ   Aժ   Aի   Aխ   Aկb   Aձ$   Aղ   Aմ   Aնj   Aո,   Aչ   Aջ   Aսr   Aտ4   A   A¸   Az   A<   A   A   A˂   AD   A   A   AҊ   AL   A   A   Aْ   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A >   A    A   A   AF   A	   A
   A   AN   A   A   A   AV   A   A   A   A^   A    A   A!   A#f   A%(   A&   A(   A*n   A,0   A-   A/   A1v   A38   A8~   A:@   A<   A=   A?   AAH   AC
   AD   AF   AHP   AJ   AK   AM   AOX   AQ   AR   AT   AV`   AX"   AY   A[   A]h   A_*   A`   Ab   Adp   Af2   Ag   Ai   Akx   Am:   An   Ap   Ar   AtB   Av   Aw   Ay   A{J   A}   A~   Aր   AւR   Aք   Aօ   Aև   A։Z   A֋   A֌   A֎   A֐b   A֒$   A֓   A֕   A֗j   A֙,   A֚   A֜   A֞r   A֠4   A֡   A֣   A֥z   A֧<   A֨   A֪   A֬   A֮D   Aְ   Aֱ   Aֳ   AֵL   Aַ   Aָ   Aֺ   AּT   A־   Aֿ   A   A\   A   A   AȢ   Ad   A&   A   AϪ   Al   A.   A   Aֲ   At   A6   A   Aݺ   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A    A   Af   A(   A   A	   An   A
0   A   A   Av   A8   A   A   A~   A@   A   A   A    A"H   A$
   A%   A'   A)P   A+   A,   A.   A0X   A2   A3   A5   A7`   A9"   A:   A<   A>h   A@*   AA   AC   AEp   AG2   AH   AJ   ALx   AN:   AO   AQ   AS   AUB   AW   AX   AZ   A\J   A^   A_   Aa   AcR   Ae   Af   Ah   AjZ   Al   Am   Ao   Aqb   As$   At   Av   Axj   Az,   Ar   Aׁ4   Aׂ   Aׄ   A׆z   A׈<   A׉   A׋   A׍   A׏D   Aב   Aג   Aה   AזL   Aט   Aי   Aכ   AםT   Aן   Aנ   Aע   Aפ\   Aצ   Aק   Aש   A׫d   A׭&   A׮   Aװ   Aײl   A״.   A׵   A׷   A׹t   A׻6   A׼   A׾   A|   A>   A    A   AǄ   AF   A   A   AΌ   AN   A   A   AՔ   AV   A   A   Aܜ   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   A
P   A   A
   A   AX   A   A   A   A`   A"   A   A   Ah   A!*   A"   A$   A&p   A(2   A)   A+   A-x   A/:   A0   A2   A4   A6B   A8   A9   A;   A=J   A?   A@   AB   ADR   AF   AG   AI   AKZ   AM   AN   AP   ARb   AT$   AU   AW   AYj   A[,   A\   A^   A`r   Ab4   Ac   Ae   Agz   Ai<   Aj   Al   An   ApD   Ar   As   Au   AwL   Ay   Az   A|   A~T   A؀   A؁   A؃   A؅\   A؇   A؈   A؊   A،d   A؎&   A؏   Aؑ   Aؓl   Aؕ.   Aؖ   Aؘ   Aؚt   A؜6   A؝   A؟   Aء|   Aأ>   Aإ    Aئ   Aب   AتF   Aج   Aح   Aد   AرN   Aس   Aش   Aض   AظV   Aغ   Aػ   Aؽ   Aؿ^   A    A   AĤ   Af   A(   A   Aˬ   An   A0   A   AҴ   Av   A8   A   Aټ   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   A h   A*   A   A   Ap   A	2   A
   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A    A!   A#   A%R   A'   A(   A*   A,Z   A.   A/   A1   A3b   A5$   A6   A8   A:j   A<,   A=   A?   AAr   AC4   AD   AF   AHz   AJ<   AK   AM   AO   AQD   AS   AT   AZ   A[   A]   A_T   Aa   Ab   Ad   Af\   Ah   Ai   Ak   Amd   Ao&   Ap   Ar   Atl   Av.   Aw   Ay   A{t   A}6   A~   Aـ   Aق|   Aل>   Aن    Aه   Aى   AًF   Aٍ   Aَ   Aِ   AْN   Aٔ   Aٕ   Aٗ   AٙV   Aٛ   Aٜ   Aٞ   A٠^   A٢    A٣   A٥   A٧f   A٩(   A٪   A٬   Aٮn   Aٰ0   Aٱ   Aٳ   Aٵv   Aٷ8   Aٸ   Aٺ   Aټ~   Aپ@   A   A   AÆ   AH   A
   A   Aʎ   AP   A   A   Aі   AX   A   A   A؞   A`   A"   A   Aߦ   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A	   A   A
Z   A   A   A   Ab   A$   A   A   Aj   A,   A   A    A"r   A$4   A%   A'   A)z   A+<   A,   A.   A0   A2D   A4   A5   A7   A9L   A;   A<   A>   A@T   AB   AC   AE   AG\   AI   AJ   AL   ANd   AP&   AQ   AS   AUl   AW.   AX   AZ   A\t   A^6   A_   Aa   Ac|   Ae>   Ag    Ah   Aj   AlF   An   Ao   Aq   AsN   Au   Av   Ax   AzV   A|   A}   A   Aځ^   Aڃ    Aڄ   Aچ   Aڈf   Aڊ(   Aڋ   Aڍ   Aڏn   Aڑ0   Aڒ   Aڔ   Aږv   Aژ8   Aڙ   Aڛ   Aڝ~   Aڟ@   Aڡ   Aڢ   Aڤ   AڦH   Aڨ
   Aک   Aګ   AڭP   Aگ   Aڰ   Aڲ   AڴX   Aڶ   Aڷ   Aڹ   Aڻ`   Aڽ"   Aھ   A   Ah   A*   A   AǮ   Ap   A2   A   Aζ   Ax   A:   A   Aվ   A׀   AB   A   A   Aވ   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   A
z   A<   A
   A   A   AD   A   A   A   AL   A   A   A   A!T   A#   A$   A&   A(\   A*   A+   A-   A/d   A1&   A2   A4   A6l   A8.   A9   A;   A=t   A?6   A@   AB   AD|   AF>   AH    AI   AK   AMF   AO   AP   AR   ATN   AV   AW   AY   A[V   A]   A^   A`   Ab^   Ad    Ae   Ag   Aif   Ak(   Al   An   Apn   Ar0   As   Au   Awv   Ay8   Az   A|   A~~   Aۀ@   Aۂ   Aۃ   Aۅ   AۇH   Aۉ
   Aۊ   Aی   AێP   Aې   Aۑ   Aۓ   AەX   Aۗ   Aۘ   Aۚ   Aۜ`   A۞"   A۟   Aۡ   Aۣh   Aۥ*   Aۦ   Aۨ   A۪p   A۬2   Aۭ   Aۯ   A۱x   A۳:   A۴   A۶   A۸   AۺB   Aۼ   A۽   Aۿ   AJ   A   A   AƐ   AR   A   A   A͘   AZ   A   A   AԠ   Ab   A$   A   Aۨ   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A    AT   A   A   A   A	\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A 6   A!   A#   A%|   A'>   A)    A*   A,   A.F   A0   A1   A3   A5N   A7   A8   A:   A<V   A>   A?   AA   AC^   AE    AF   AH   AJf   AL(   AM   AO   AQn   AS0   AT   AV   AXv   AZ8   A[   A]   A_~   Aa@   Ac   Ad   Af   AhH   Aj
   Ak   Am   AoP   Aq   Ar   At   AvX   Ax   Ay   A{   A}`   A"   A܀   A܂   A܄h   A܆*   A܇   A܉   A܋p   A܍2   A܎   Aܐ   Aܒx   Aܔ:   Aܕ   Aܗ   Aܙ   AܛB   Aܝ   Aܞ   Aܠ   AܢJ   Aܤ   Aܥ   Aܧ   AܩR   Aܫ   Aܬ   Aܮ   AܰZ   Aܲ   Aܳ   Aܵ   Aܷb   Aܹ$   Aܺ   Aܼ   Aܾj   A,   A   Að   Ar   A4   A   Aʸ   Az   A<   A   A   Aӂ   AD   A   A   Aڊ   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A
    A   A
   AF   A   A   A   AN   A   A   A   AV   A   A    A"   A$^   A&    A'   A)   A+f   A-(   A.   A0   A2n   A40   A5   A7   A9v   A;8   A<   A>   A@~   AB@   AD   AE   AG   AIH   AK
   AL   AN   APP   AR   AS   AU   AWX   AY   AZ   A\   A^`   A`"   Aa   Ac   Aeh   Ag*   Ah   Aj   Alp   An2   Ao   Aq   Asx   Au:   Av   Ax   Az   A|B   A~   A   A݁   A݃J   A݅   A݆   A݈   A݊R   A݌   Aݍ   Aݏ   AݑZ   Aݓ   Aݔ   Aݖ   Aݘb   Aݚ$   Aݛ   Aݝ   Aݟj   Aݡ,   Aݢ   Aݤ   Aݦr   Aݨ4   Aݩ   Aݫ   Aݭz   Aݯ<   Aݰ   Aݲ   Aݴ   AݶD   Aݸ   Aݹ   Aݻ   AݽL   Aݿ   A   A   AT   A   A   Aɚ   A\   A   A   AТ   Ad   A&   A   Aת   Al   A.   A   A޲   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A    A   A   A^   A    A   A
   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A!~   A#@   A%   A&   A(   A*H   A,
   A-   A/   A1P   A3   A4   A6   A8X   A:   A;   A=   A?`   AA"   AB   AD   AFh   AH*   AI   AK   AMp   AO2   AP   AR   ATx   AV:   AW   AY   A[   A]B   A_   A`   Ab   AdJ   Af   Ag   Ai   AkR   Am   An   Ap   ArZ   At   Au   Aw   Ayb   A{$   A|   A~   Aހj   Aނ,   Aރ   Aޅ   Aއr   Aމ4   Aފ   Aތ   Aގz   Aސ<   Aޑ   Aޓ   Aޕ   AޗD   Aޙ   Aޚ   Aޜ   AޞL   Aޠ   Aޡ   Aޣ   AޥT   Aާ   Aި   Aު   Aެ\   Aޮ   Aޯ   Aޱ   A޳d   A޵&   A޶   A޸   A޺l   A޼.   A޽   A޿   At   A6   A   Aƺ   A|   A>   A    A   Aτ   AF   A   A   A֌   AN   A   A   Aݔ   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A    A~   A@   A   A   A	   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A `   A""   A#   A%   A'h   A)*   A*   A,   A.p   A02   A1   A3   A5x   A7:   A8   A:   A<   A>B   A@   AA   AC   AEJ   AG   AH   AJ   ALR   AN   AO   AQ   ASZ   AU   AV   AX   AZb   A\$   A]   A_   Aaj   Ac,   Ad   Af   Ahr   Aj4   Ak   Am   Aoz   Aq<   Ar   At   Av   AxD   Az   A{   A}   AL   A߁   A߂   A߄   A߆T   A߈   A߉   Aߋ   Aߍ\   Aߏ   Aߐ   Aߒ   Aߔd   Aߖ&   Aߗ   Aߙ   Aߛl   Aߝ.   Aߞ   Aߠ   Aߢt   Aߤ6   Aߥ   Aߧ   Aߩ|   A߫>   A߭    A߮   A߰   A߲F   Aߴ   Aߵ   A߷   A߹N   A߻   A߼   A߾   AV   A   A   AŜ   A^   A    A   A̤   Af   A(   A   AӬ   An   A0   A   Aڴ   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A
*   A   A
   Ap   A2   A   A   Ax   A:   A   A   A   AB   A!   A"   A$   A&J   A(   A)   A+   A-R   A/   A0   A2   A4Z   A6   A7   A9   A;b   A=$   A>   A@   ABj   AD,   AE   AG   AIr   AK4   AL   AN   APz   AR<   AS   AU   AW   AYD   A[   A\   A^   A`L   Ab   Ac   Ae   AgT   Ai   Aj   Al   An\   Ap   Aq   As   Aud   Aw&   Ax   Az   A|l   A~.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   Aজ   A^   A    A   A୤   Af   A(   A   Aബ   An   A0   A   A໴   Av   A8   A   A¼   A~   A@   A   A   Aˆ   AH   A
   A   AҎ   AP   A   A   Aٖ   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   A B   A   A   A   AJ   A	   A
   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A!   A#j   A%,   A&   A(   A*r   A,4   A-   A/   A1z   A3<   A4   A6   A8   A:D   A<   A=   A?   AAL   AC   AD   AF   AHT   AJ   AK   AM   AO\   AQ   AR   AT   AVd   AX&   AY   A[   A]l   A_.   A`   Ab   Adt   Af6   Ag   Ai   Ak|   Am>   Ao    Ap   Ar   AtF   Av   Aw   Ay   A{N   A}   A~   Aန   AV   A   A   Aᇜ   A^   A    A   AᎤ   Af   A(   A   Aᕬ   An   A0   A   A᜴   Av   A8   A   A᣼   A~   A@   A   A   Aᬆ   AH   A
   A   A᳎   AP   A   A   Aẖ   AX   A   A   A   A`   A"   A   AȦ   Ah   A*   A   AϮ   Ap   A2   A   Aֶ   Ax   A:   A   Aݾ   A߀   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A    A   Aj   A,   A   A	   Ar   A
4   A   A   Az   A<   A   A   A   AD   A   A   A    A"L   A$   A%   A'   A)T   A+   A,   A.   A0\   A2   A3   A5   A7d   A9&   A:   A<   A>l   A@.   AA   AC   AEt   AG6   AH   AJ   AL|   AN>   AP    AQ   AS   AUF   AW   AX   AZ   A\N   A^   A_   Aa   AcV   Ae   Af   Ah   Aj^   Al    Am   Ao   Aqf   As(   At   Av   Axn   Az0   A{   A}   Av   A8   A   Aℼ   A~   A@   A   A   A⍆   AH   A
   A   A┎   AP   A   A   A⛖   AX   A   A   A⢞   A`   A"   A   A⩦   Ah   A*   A   AⰮ   Ap   A2   A   Aⷶ   Ax   A:   A   A⾾   A   AB   A   A   Aǈ   AJ   A   A   Aΐ   AR   A   A   A՘   AZ   A   A   Aܠ   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   A
T   A   A
   A   A\   A   A   A   Ad   A&   A   A   Al   A!.   A"   A$   A&t   A(6   A)   A+   A-|   A/>   A1    A2   A4   A6F   A8   A9   A;   A=N   A?   A@   AB   ADV   AF   AG   AI   AK^   AM    AN   AP   ARf   AT(   AU   AW   AYn   A[0   A\   A^   A`v   Ab8   Ac   Ae   Ag~   Ai@   Ak   Al   An   ApH   Ar
   As   Au   AwP   Ay   Az   A|   A~X   A   A   Aマ   A`   A"   A   A㊦   Ah   A*   A   A㑮   Ap   A2   A   A㘶   Ax   A:   A   A㟾   A㡀   AB   A   A   A㨈   AJ   A   A   A㯐   AR   A   A   A㶘   AZ   A   A   A㽠   Ab   A$   A   AĨ   Aj   A,   A   A˰   Ar   A4   A   AҸ   Az   A<   A   A   Aۂ   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   A l   A.   A   A   At   A	6   A
   A   A|   A>   A    A   A   AF   A   A   A   AN   A    A!   A#   A%V   A'   A(   A*   A,^   A.    A/   A1   A3f   A5(   A6   A8   A:n   A<0   A=   A?   AAv   AC8   AD   AF   AH~   AJ@   AL   AM   AO   AQH   AS
   AT   AV   AXP   AZ   A[   A]   A_X   Aa   Ab   Ad   Af`   Ah"   Ai   Ak   Amh   Ao*   Ap   Ar   Atp   Av2   Aw   Ay   A{x   A}:   A~   A䀾   A䂀   AB   A   A   A䉈   AJ   A   A   A䐐   AR   A   A   A䗘   AZ   A   A   A䞠   Ab   A$   A   A䥨   Aj   A,   A   A䬰   Ar   A4   A   A䳸   Az   A<   A   A   A伂   AD   A   A   AÊ   AL   A   A   Aʒ   AT   A   A   Aњ   A\   A   A   Aآ   Ad   A&   A   Aߪ   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A	   A   A
^   A    A   A   Af   A(   A   A   An   A0   A   A    A"v   A$8   A%   A'   A)~   A+@   A-   A.   A0   A2H   A4
   A5   A7   A9P   A;   A<   A>   A@X   AB   AC   AE   AG`   AI"   AJ   AL   ANh   AP*   AQ   AS   AUp   AW2   AX   AZ   A\x   A^:   A_   Aa   Ac   AeB   Ag   Ah   Aj   AlJ   An   Ao   Aq   AsR   Au   Av   Ax   AzZ   A|   A}   A   Ab   A$   A   A冨   Aj   A,   A   A印   Ar   A4   A   A唸   Az   A<   A   A   A坂   AD   A   A   A夊   AL   A   A   A嫒   AT   A   A   A岚   A\   A   A   A幢   Ad   A&   A   A   Al   A.   A   Aǲ   At   A6   A   Aκ   A|   A>   A    A   Aׄ   AF   A   A   Aތ   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A
~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   A!X   A#   A$   A&   A(`   A*"   A+   A-   A/h   A1*   A2   A4   A6p   A82   A9   A;   A=x   A?:   A@   AB   AD   AFB   AH   AI   AK   AMJ   AO   AP   AR   ATR   AV   AW   AY   A[Z   A]   A^   A`   Abb   Ad$   Ae   Ag   Aij   Ak,   Al   An   Apr   Ar4   As   Au   Awz   Ay<   Az   A|   A~   AD   A   A   A慊   AL   A   A   A挒   AT   A   A   A據   A\   A   A   A暢   Ad   A&   A   A桪   Al   A.   A   A樲   At   A6   A   A毺   A|   A>   A    A   A渄   AF   A   A   A濌   AN   A   A   AƔ   AV   A   A   A͜   A^   A    A   AԤ   Af   A(   A   A۬   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A    AX   A   A   A   A	`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A :   A!   A#   A%   A'B   A)   A*   A,   A.J   A0   A1   A3   A5R   A7   A8   A:   A<Z   A>   A?   AA   ACb   AE$   AF   AH   AJj   AL,   AM   AO   AQr   AS4   AT   AV   AXz   AZ<   A[   A]   A_   AaD   Ac   Ad   Af   AhL   Aj   Ak   Am   AoT   Aq   Ar   At   Av\   Ax   Ay   A{   A}d   A&   A   A炪   Al   A.   A   A牲   At   A6   A   A琺   A|   A>   A    A   A癄   AF   A   A   A砌   AN   A   A   A秔   AV   A   A   A箜   A^   A    A   A絤   Af   A(   A   A缬   An   A0   A   Aô   Av   A8   A   Aʼ   A~   A@   A   A   Aӆ   AH   A
   A   Aڎ   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A
   A   A
   AJ   A   A   A   AR   A   A   A   AZ   A   A    A"   A$b   A&$   A'   A)   A+j   A-,   A.   A0   A2r   A44   A5   A7   A9z   A;<   A<   A>   A@   ABD   AD   AE   AG   AIL   AK   AL   AN   APT   AR   AS   AU   AW\   AY   AZ   A\   A^d   A`&   Aa   Ac   Ael   Ag.   Ah   Aj   Alt   An6   Ao   Aq   As|   Au>   Aw    Ax   Az   A|F   A~   A   A职   AN   A   A   A舔   AV   A   A   A菜   A^   A    A   A薤   Af   A(   A   A蝬   An   A0   A   A褴   Av   A8   A   A諼   A~   A@   A   A   A贆   AH   A
   A   A軎   AP   A   A   A   AX   A   A   Aɞ   A`   A"   A   AЦ   Ah   A*   A   A׮   Ap   A2   A   A޶   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A    A   A   Ab   A$   A   A
   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A!   A#D   A%   A&   A(   A*L   A,   A-   A/   A1T   A3   A4   A6   A8\   A:   A;   A=   A?d   AH.   AI   AK   AMt   AO6   AP   AR   AT|   AV>   AX    AY   A[   A]F   A_   A`   Ab   AdN   Af   Ag   Ai   AkV   Am   An   Ap   Ar^   At    Au   Aw   Ayf   A{(   A|   A~   An   A0   A   A酴   Av   A8   A   A錼   A~   A@   A   A   A镆   AH   A
   A   A霎   AP   A   A   A飖   AX   A   A   A骞   A`   A"   A   A鱦   Ah   A*   A   A鸮   Ap   A2   A   A鿶   Ax   A:   A   Aƾ   AȀ   AB   A   A   Aψ   AJ   A   A   A֐   AR   A   A   Aݘ   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A    A   AD   A   A   A	   AL   A
   A   A   AT   A   A   A   A\   A   A   A   A d   A"&   A#   A%   A'l   A).   A*   A,   A.t   A06   A1   A3   A5|   A7>   A9    A:   A<   A>F   A@   AA   AC   AEN   AG   AH   AJ   ALV   AN   AO   AQ   AS^   AU    AV   AX   AZf   A\(   A]   A_   Aan   Ac0   Ad   Af   Ahv   Aj8   Ak   Am   Ao~   Aq@   As   At   Av   AxH   Az
   A{   A}   AP   A   A   Aꄖ   AX   A   A   Aꋞ   A`   A"   A   A꒦   Ah   A*   A   Aꙮ   Ap   A2   A   A꠶   Ax   A:   A   Aꧾ   Aꩀ   AB   A   A   A갈   AJ   A   A   A귐   AR   A   A   A꾘   AZ   A   A   AŠ   Ab   A$   A   Ą   Aj   A,   A   AӰ   Ar   A4   A   Aڸ   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A
.   A   A
   At   A6   A   A   A|   A>   A    A   A   AF   A!   A"   A$   A&N   A(   A)   A+   A-V   A/   A0   A2   A4^   A6    A7   A9   A;f   A=(   A>   A@   ABn   AD0   AE   AG   AIv   AK8   AL   AN   AP~   AR@   AT   AU   AW   AYH   A[
   A\   A^   A`P   Ab   Ac   Ae   AgX   Ai   Aj   Al   An`   Ap"   Aq   As   Auh   Aw*   Ax   Az   A|p   A~2   A   A끶   Ax   A:   A   A눾   A늀   AB   A   A   A둈   AJ   A   A   A또   AR   A   A   A럘   AZ   A   A   A릠   Ab   A$   A   A뭨   Aj   A,   A   A봰   Ar   A4   A   A뻸   Az   A<   A   A   AĂ   AD   A   A   Aˊ   AL   A   A   AҒ   AT   A   A   Aٚ   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   A F   A   A   A   AN   A	   A
   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A!   A#n   A%0   A&   A(   A*v   A,8   A-   A/   A1~   y AAzAA\AAîAAÙA
=A33A  A  AQAA(AA33A33AAQA
=AǅAAAGAffA\)A\AAAA  AffAAffARA33AAGAAÅARAffA33A(AffApAHAAAA33AGA\ARAAzAAGA  A\)AAAA\A  A
=ApAApA=qAQAGA
AQA
=AA  A
AQAffA\)A(AffAzAAA(ARAAAApAA(AHAGApA(AAAA
=AA(AAAQA33AffA
AQAA
AA{ApA=qA33AffA\AAAA=qAAAffA(A  ApApAAffA
AQAAAAA\A=qA(AzAA\)AAffA
=AHAGA\)A=qApAAAAAAA=qA{A{A33A(AGA=qAAQAQAHAAA{AARA  AGAA\AAAAHA\AA=qA
=AAzAAHA=qA
AffAGAQAGApAAAŮA
=A\)AAApA(AA=qAQAAffA(A{AffAffA
=A¸RAQA(A
A
AAAQA
A
=A
=AAÅA\A
AAApA  A{AA  A  AApA¸RAQAQAǙAȸRA(AffA
=AA33AȣAzAAffA(AffAffAAHAA33AAģA33AQAzAAAAA\A33AQAQA=qAAHA
A33AGA
A\)AAA{AGAAAAAA
AA
=AzAGAHA
=AA¸RA
=A{A=qAHA  A\)A
=AAffA(A  AzAGA
AA
AAQAHAHA\AA\)AQAAGA¸RA
=AffA  AGAHAffA
=A\)AÙAAApA(AHAAAAzA  AQA=qAffAHApA¸RA
=AAAîA\)Aď\A  A{A(A  AA  AHAffA(A(A¸RA{AAAffAAApAHA\)A
A33AGA(AHAGA
AffAAAQAffA{AģAHA
=Aď\AGAApAŮA{AA  AGApAzA\)AApAGAffAAGA£AAÙA\A¸RAîA=qAA{AAQAQA=qA33AAHAApA  A(AHAA=qA33AŅAA{AffAA  Aʏ\AƏ\A(AAĸRAffA33AAď\AA33A
=AƸRAQA{AģAGAƏ\AǅAGA33A(A(A\A=qAQAGA
=A  AGAAAGAA
=AAŅA{A33AƣA\)ApAzA
=AɮA  AQAʣAHAHA\)AHA
=AAffAəA
A(A
=AA  AzA
AGAƏ\AîApApAAǅAGA{A\AffAA¸RAApA(A
A¸RA  Aď\AzAÅAŮAƏ\AA(AA  A
A
=AA(AA˙A=qA(AffA  AʣA33A\)A=qApA
A33AǙAHAɅA{A
=AAHAəA=qA33ApAȸRAɅA=qApApAGAzAAHAəAAʣAA˙A
A{AAAAzA33ApAGAAʏ\ApA
AɅAɅA(AəA˅AffAǮAȸRAffAAƸRAģA
=AGAGA(A£AAGAAffAA  AGA£AHApAA(AzAȏ\A{AHAGA(AApA
=AřAHAAȏ\A\)AɅAɅAǮAGAffA\)AǅAzA(ApAɅA(A{AApAAzA
A
Aď\A(AÅAď\A(A\)AAA{A\)A  A
=AȸRAHAQAzAffA
AzAÙAAGAŮAHAHA33A(A
ApAffA=qAA\)AffAĸRA  AAřAAA
=AGAǮA(AA
=AAÅAřAAAA{AffAAAAAAAAA\)A=qAAffAAffAÅAĸRAƸRAď\A\)AAffAQA
=AÅAÅAffA  A{AAÅAzAGAAA  AApA\AAGAzA=qAAA\)ApAQARAA  A33ARAGA
=AGAAA=qARAffA\)AA33AA\)AffAAAAGAAAQApA
A  AA
=A33AffAAffA\)AA\ApAQA
=A
AA\ARA\AQA\A\AffA  A
=AHAA{AzAAAffAAGA
=AAAA\AA(AA\)AAHA(AAHAA  AAAAHA\A\)AHA  ARAHARAzA\AffAQA  AAAffAAffAffA
=ARAffAApA  AGAHA33AQA{A  AAAAzA33A33AA33ApARARAA(AGAA\AA  AAAA
=A
AHAAHApA{AAzA{AGAA
AHAzAAA
=A33A33A
AAGApA
AHA\ApA\ARAAApA33A  AAGAA  AAAARAA{AAzAGAzA\)A  AQA  ApAAAAAHAAAAA\AGAARA
=AApA
=AAAA33AHA=qA{AAA(A=qA=qA
AHARA  AAA
A=qApA  AAA(A=qA
ApAAAzAAHA{A=qARAGAGAAAA33A
=AGAAA(ApA\)A=qA(ApA  A(AA{AQAAA{A33AzAHAGA{AAGA
=AAAAAA
AAHAApA  A
A
=AAzApA{AA\A
AQAA{A=qA\AzAAAGA\AA
A=qAHA{A{AAAA
AA  AA\)AA\AffA\)AQAAffA
=AA  A  AAA(AzA=qA\AzAHARAGA(A=qA=qAA
A(A33AAA=qAffAAAffAA33AA
ARAřAŮAzAApA33A\)AAA\A\AffA\)AAzA
=AA
AAzA  A\)A  A
=AApAA\AAzAA
AQA\A{AzA\A(AGAA¸RApAAffAffAAffAzAĸRAŅA33AȸRAʸRẠA(ApAAȏ\AʸRA  Aʏ\A\)A\)ApAǮAǙAffA=qA
AÅAAAîApA(A
=AHAffAŮAîAA  AzApA(AAAHA£AA(A=qAGAŮAŮAĸRA\AffAAAAď\A
A  A\)AA=qA{A33AȸRAzAǮA=qApA33ApAAApA(ApAď\AAAď\AAHAzAAAA33A
A{A33AAffAƸRAîA¸RA  AAƸRAƸRA  AȣA\)A
=A(AȸRAffAAȸRA
AffAǙAAȸRAzAHAʣAA  AffAAǮAHA  A\)AAA=qAAAffAffA=qA
=A  A(AAApAQA\)AA£AAGA  AAA=qAAA
AHAQApA˅AHAzAA
=AȸRAffA˙A
AAǙAzAffAAƏ\AAȸRAAA
=AHAzAA(ApAŮAĸRAǙAA(AffAQAŅAAGARA
=A=qAƏ\AA=qAAʏ\A
=ApAAQAA
AAA
=ẠA(AəAffAƣA=qAȸRAA
ApAǙA
=AĸRAřAA\)AHA
AQA\)AHAAGApAHAAŅAA  A
=AHAA
ApAHAAɅA=qAAˮȀ\A˅AA=qA˙A˙Ȁ\A̸RAffAAŅAǙAAGAHAzA=qA(A\)Aď\A=qA\)AAĸRA
AĸRAffAHApAƣAɅA(ApA
A=qAffAŅAQA
AffAffAAƸRAǮApAQA33AȣAAȸRAffA
=AffAA\)AAffA{A
=AQApA{A33AffA(ApA(AHAA=qAzA
AAAď\Aď\A
ApA£A33AApAQA  AGAffAŅAƏ\AffA
AAȣA\)AffA{ApAʏ\A{AAͅA̸RAffA{AGAʸRAʏ\AʸRA=qAəA(A\)AzAˮAˮAəAffAŅAAĸRAzAGA
=AzA¸RA\)A  A=qA=qAîAffAGApA=qA\A\A  AQAģA(A{AAǅAAǙAHA  A=qAffAffAʏ\AQAGAʣA  AAApAʏ\AffAA(Aʏ\AAɅAAȸRA
=AǅA
=AřAřAA
=AŮAAď\A=qAÅAA\)A(A
=A(AƸRA
AȸRAAA\)AGA
=AɮA  AAɮAA
AəAəAəAȸRA=qA=qA  AAəAAȏ\AzAǮAȣA
AAAȏ\A(A{AȣAffAȸRAAȸRAGAffAǙAzA£A{AQAAzAƸRA33A  AffAQAAA(ApAzA{AǮAAGAǙA33AȸRAǮAAzAAQAzAQA(AApAȸRAǙA(AǮA
A
AA  AffA=qAǙAAGAGAƣAAHA33A=qAƸRAǅA(A  AffAǮA  AAɮA33AʣA{AAAəAəA
AɮA(AAAA
AA
AəAɅApAA{AA33A
AQAəAQA=qA(A(AƸRA
A=qAA\)A
AǮA33AHAA(AŅAzAGAQAƸRAAAAffAHA  A(AffAȣAȣAȣAȣA{A
=AApAAA  A=qAA  AAffA\)A\)AAA  AGAA33AÙAQA(AƣAHA  AQAGA\)A33AAHAffAQA33A\)AȣA{AHAA{AHAQAQAAAHAHA̸RAAQAͮAͮAͅAzAẠAGAɅA
AHAzAȸRAAǅAřAď\A
A  A=qAʣA{A(AẠA͙AʣA(AzA
=A
=AǅA
A  AθRA33AzAθRAAͅAΣAΏ\A  A
AQAΣA̸RApAAA  A  A̸RA
=A̸RAGAɮA=qA
=AAəA(A
AƸRA(AffA=qA(AƏ\A
=A
A(AGẠAHAəAʸRAʏ\AApA
A
=AͮAиRAHA\)A\)AиRAQA(AҸRAAA\)AAӅAңAHAffA{A
=AAΏ\AffA
AAͮAͮAʏ\AʣAHAAAǙA(AffA(AQAȣA=qẠA\)A{AHAA\)AəA  ApAA=qA˅A{AffA33A
AffAGAzAGA=qAAGA˙A(Ȁ\AffAApAA  A  AffAApAHAͅAAApAffAA˙A=qAAAHAǅA{AA=qAǮAzA=qAȸRA
AA
=AffA(AͮA
AzAA\)AϙAͅAͅAffAzAAAAHAffAˮA=qAGApAA  A
Ȁ\A
=AɮA{A(ApA{A
AffA=qAAGAQA33Aʏ\AA\)AȣAA=qA(A\)A
AffAƸRApA{A
AHA{AȸRAɅAAQAAͮAʸRA
=AAɅApA
AɮA(A
AAAHAȣAAAAď\AAQAffAŅAƸRA(AǅA33AffAGA
AA
AΏ\AQAQAA
Ȁ\AʸRApAɮA(A33A  A  AA  AGAAQA˅AA{AAApA
AA{ApAAəAəApAAAɮA
AzA=qAŮA(AAQAffApAGAffAAA=qAGA{AƸRA  AzAAȸRAAffApAAͮAGA˅AzA\)A˙AΣA\)A̸RA  AAʏ\A  AA
=AQAəAHApA
ApA\)AǅAǮAHAA33A
AîAGAîAGAŅAƣAƸRApA=qAzAģAřAzAǮA33ApA=qAˮA  AQA{AˮA{A  A  A˙A\)ApApA˅A˙A(AAAAGA33AffAffAɅApA33AGAɅAAAŮAAGAQA  A
A=qAɮAʣA33AAAGAAɮAɮAɮAffA33A=qA
AΣA\)A{AAGAхA\)A  AυAυApAυAϙAϮA33A
=A  AA˙AGAzAzA\)ApA33AffAȏ\AHAA33AɮAAAHA
AˮA\)AAA  AGAɅAȣA\)AɅA(AzAHAAɮA
A
AʸRAHA˙AGAAAzApAGApA\)ApApAͅA\)AAAffA33Aȏ\A(A
A{AǙApA
A=qA  A(AffAǮAApAǙAƏ\AHAA=qApAʣAˮAzAͅA{AzA(AA
=A
A(ApA
AA{AA33AAA\)AGAAθRA
=AθRAAGA33AAAϮAQAθRAQA
AυA33A(A
=A
=A
A(A=qAHA\)AAθRAθRA33A=qAиRAѮAAffAApAHAAA\)A
ApA33AAzA
AңAzA  AҸRA  AѮAffA(AzAAHAAAAHAGA(AѮAA
=A(AGA=qA33AAϮAGAA=qAAϙAAϮA=qAQA
=A(AAAGA
AAљA\)AQA=qAzAffA=qAzA(AffAA
=AQA=qA  A
=AQAffAzAAAAθRA=qA͙ApA
=A\)AΣAQA\)AхA(AGAQAQAAѮAffA
AA\)AzAӮAӮAQA
=AԣA(A
=AхApA=qA
AAAzAAzAA  AA{AΏ\A\)ẠAAAͮAA
=AǙAǮA
A\)AǅA
ApAɅAffAQAǙA
AAͅAΏ\AA  AиRAQA\)A{AzAAңAҸRAAffA(AхApAΣAQAϙApAϙAυA͙A(AA
=A
AAʏ\AAɅAffAʸRAAGAAzAQAA33AA
A
=AɅAffAˮȀ\A͙AAA{AzAzA{AffApAApAAAAϙAAAϙA33A  AAΣAGAAʸRA(A(AɅAGAHAQA\)AHAGA̸RAzA\)AApAAȏ\AȣAA˅AŮAHAAzAffA=qAzApA=qA(A33AЏ\AЏ\A
=AиRAzA=qA
AAAA  AθRAAA
=AAˮAAʏ\AɮAɮA33ApAȣAQAQAȏ\AA  AƸRAzA
=AȣA{A  AƏ\A  A{A\)AA\)Aʏ\AˮAA˅ApAffAAApAGAͅA  AffAGA(A͙A  A  A{A{AʸRA=qAHA=qA=qAAȏ\A
A{AGAHAƏ\A{AQApAHA=qAA  AzA{AAǅAAƏ\AAzAQAʣAGA
AzAA
=AϙA33AѮAHA\)A\)AңAAffA=qA
=AУA{AzAУA33AffA
AЏ\A{AzA33ApAAA=qA  AffAQAAHAˮAA
AƣA\)A
=AzAA  A33AAЏ\A33AApA(A\)AGA(AͮA(A{A̸RȀ\A̸RA(AθRAA(A{A
A(AA
A̸RAAzA\)A33AAʸRA  AA33A(ApApAApAffAʏ\A˅A˙A=qApAAHAHA{A̸RAͮA(A{AQA\)AθRAHAΏ\A=qAΣAA=qA=qAΏ\AffAͅA  AΏ\ApA
=AGAzAΏ\AΏ\A
A  A=qAGA\)AȸRA\)AɮA(A(AQA
=AGAzAQA˅AAAQAGAΏ\ApApAυAAAӮA  A(AAԣA  AӮA\)AAәAҸRA33AAңA(ApAΏ\AAAAθRAffA(AffA\)AϮA
AAA=qAAAHAΏ\AzA{AzA
=AAA=qAУA\)AQA33AҸRAAA(AָRAzAQA(A׮AٙAGAأA\)A
=AAУA֣A(AAzAffA\)AHAծAՅA׮AϮAffAQAAAHAAA  A
=AA(AңA\)AʣA
=A\)AΏ\A33A{A
A{AA  A(A33Aԏ\AzAQAzAAAAָRAzA{A(AՙApAՙApAA33ApApA
A  AأA
=AAzAָRAҏ\AәAzAGAA(AQA(A(AՅAffAA͙ApA=qAzAA(AAA(AAffAظRAAGAQA=qA(AHAA֣A֏\AAApAAAzApAәAHAҏ\AGAzApA=qAAԸRAQAәAzA\)AffA  AӮAAԣA=qAAHA
=AAHAAA
AffAHA33AHAA33A=qA
AӮAәAәAәA
=AQAԣAҏ\A33AәAҸRAԏ\AApAQA(AΏ\AffAAͅA̸RA=qAA
ApA˅AˮA(A=qA=qA{Ȁ\A
=AˮA˅AˮA{A33AHAQA(A=qA33A(AAHAAffA=qA\)AHAA33ApAϙAȀ\A  AffA̸RAzA͙AHA˙AHAA˅A
=AAA˅AQAGAAʏ\AHA  A=qA  A
=Aʏ\AffA(AʣAAzAffA  A(AGAA{A(A\)A\)AGAAЏ\A=qAQAңAиRAиRAљA33A  AљAQAHAΣA=qAAAͅAͅAͅAffA(AΣA
=AQA\)A  A˙AAʏ\A  AA{Ȁ\A\)AљA\)A
A
=AϙAAzA
AAҏ\A=qAA
=AAѮA=qAAA\)A\)AAApAAAAA  AQApAAffAGA33A  A(AAzA˅A33ẠAzAzA  A
=Aʏ\AGAẠAzA\)A
AA
A{Aҏ\A\)A{AAңAzAzAљA{AӅA=qAGAѮA{AУAHA
A=qAУAA=qAzAGAθRA=qAGA  A33A{AϙA(AHAHA
AУA
=AAϙAA{A(AϮAffAңApAиRA\)AϮA(AHA\)A{Aҏ\AA{AӮAAAffAA\)A
AңAңAAљA33AAυAffA=qAθRA\)ẠA{AAиRAA
=AffAQA(AHAΣAѮAȸRA=qA=qA
=AȣAGAAGAʏ\AffAˮA=qAΏ\A  AΏ\AңAAHAAQAQA(AAхApAӮAA(AffAѮAңA
=AυAGA=qAQAẠAffAAʸRApA\)AͅA\)A33AAQAѮAѮAQAңA=qAУA(AQAffAGAzAAffA33A
A{AAظRAHAffAأAA(A{A\)AAڸRAzAظRA
=A=qAffAA=qA\)AA(AҸRApA  ApAAHAәAՅAA
A  AAQAAՅAAҏ\AAAffAՅAzA33AA
AAָRAՅAAGA׮AAAՙAӅAGAAQAAzA=qAQAffAGAAAffAͮA  A33AЏ\AGAAθRAAңAՅA
=AңA{AHA\)A(AңAԸRAffAAԸRAծAՅAՅAՅA33AHA=qAzA\)A׮AәAAHA
=A\)AҸRAԸRA33AQApAAA
=A=qA=qAAffA=qAA\)A  A(AυAΏ\AApA  A{A(AApA33A  A\)A{A33AHA{AA  A
Aԏ\Aԏ\Aԏ\A
=A
AQAՙAAָRAzA(A
=AAAGA  AAAA(AA(AzApA  Ȁ\A\)AAAхAͅA
Aҏ\A{AHAffAAυA33A33AA
AA(A׮AzAQAA33AAffA
=ApAѮAAGAA
ApA֏\AzA֣A(A33AGAzA
AхA(ApA
A  A  AQA=qAΏ\AHA(AAAͮA(A
=AHAϙAAУAAzAAAAHAՙA  AӮAQAԸRA33AԣA
=AՙA֏\AffA33AA
AGA
=AQA=qẠAA
=AхA{A  A{AAЏ\AљA{AУAAGA33A
AQAzA33AхA  A=qA  AA
=AθRA33AAхA=qA  A
=AA
=AAffA
A=qA
=AffA֣A֣AQAA33A\)AAHA֣AGAA
=AffAԸRAAԣA
=Aԏ\AQAAQAA33AϙA̸RAͮAGAAGAHA=qAffAffA
=AA{AҸRA(AAA33AՙAffAָRAAzAHAGAHAGAQAAՅA=qAՙAffAzA֣AffA֏\AԣAAHAϮA
AˮAGA̸RAʏ\A  A\)AA{AхAAzA  AzA\)A
AẠA  A  A  AffAffAzAQAApAffAffAңAHA\)AAҸRAQAхA
AQAHAAԣA
A
=Aԏ\Aԏ\AAAA  AGA
AәA
AQA(AӮA
AAиRAЏ\ApA(A33AAffAA(AHAυAϮAϮAzAхAҸRApAHAHA{A\)A
AϙAΣA{A\)AzAHA(AЏ\A  AA  AA(AAGAHA
AҸRA=qA=qA
=AHA\)AϙAθRAQA(A33AΏ\A  AθRAA\)A(AQAљAQAӮAffAzAAA{AAָRAAzAAA=qA֣AQA֏\AՙAA{AHAGA33A֏\AA\)AՙAAAA
AծA  A(AQAУA{A=qApA=qA  AϮA  AAGAA
=AAA֏\AHAGA  A
=AمAGAأA33AHAQAffAأAffA׮AzA֣AApAA=qA(A=qAAA=qAGAffAԣA(AzAҸRA{A
AծAՅAApAGAϙAA  AԸRAAӮA  AٙA{AAԏ\AzAׅA(AffA  AQAQAzAAۙAA  AQAAAAܸRAAQA؏\A\)A
A  AAQA=qA  AzAAAәAGAљAљAӮAHAHA  AffA=qAѮAHA(A{A=qAՙA
AQAҸRAՅA֣ApAָRA
=AHAffAAӅA
AAAA
=AәAAәAAHAԸRA\)AA33AHAHApAAAхA  A\)A=qA֣AAԸRAffA=qAAՙApA33A33A{AHAՅA֣AָRA33A
=A\)A
=AծAԣA=qAAzA  A=qAzA=qApA  A=qAѮA33Aԏ\A{A33A33A
AHA33AAAGAظRAأApA  AظRAظRAAQA(A  A׮AzAծA\)A
AָRAffA֣AffA=qAAHA\)A=qAA\)A\)A\)A
A{AЏ\A33A{A(A33AיA33AGAA
A
=AA{AA
A{A33AGAGAAffA
=A33A\)AиRAHAУA{A=qAЏ\AΣAˮAA
=A͙A  A
AffA͙A
=ApAHAzA(AzA
=ẠA  A
=AQAхA{AAGAQAA33ApAA{A
A֏\AA֣AAمAzA{A
=AٙAٮA\)A
=A=qA{A؏\AA(AQA
=A
=AυA  A  A
=AHAHAzA  A33ApA
AAAA(ApA33A{A\)AQA\)A(A\)AԣA(A\)A=qApA؏\A
AGApA
=AAAffAffAAAٮAAGAGAGAAٙApAA
=AQAGAՅA{AHAծAffA׮A؏\AQA؏\AAA
=AAzAәA\)A\)A{AQA\)A(AՙA
=AѮApAAQAGAAϙAиRAzAυAυAAffA˅A
=AAAGA(A\)AɮAAͅẠAHA(AGAAffA=qAffAʣA  A\)AffAˮAffAʸRA(AA{A  AͮA\)AΣAУAQAӮAӮAԣA
AәA\)AظRAۅAApAAՙA=qAA֣A(AAָRAAҸRAAGA
AՅApA=qAҸRAңAӮAAAӮAA(A=qAAΣAиRAңAAәA
=AHA
AffA  AԣAԸRA(AԸRA֣A33A  AAٙAzA{AAQA\)AzAљAAA  A33AЏ\AQA{A׮AәAӮAffA
=A33A  A(A  AA\)AAQAAϮAffAAʏ\A\)AzA  AzAAQA
AͮA
=A(AˮA  A
A33AGAAAAAAAA\)A  AȣAĸRAA̸RA˅A=qAAzA(AAA̸RAAɮA
ẠApAʏ\AA  A{AřAƸRAHAAͮApAGA=qAffAQA  AAAGAQAHAApA  AңAAәAAծA
A(A\)A  AHAхAϮAУAAθRA˙AffAиRAΏ\A\)A
A{AͅAQA(A  AυA  AffAAffAHAGAAHAϙAϙAffAAA=qAՙA=qA
A(A{A(ApApA  AzA=qAQA  A=qAиRA  A33ApAAA
=AͮAA
=A(A\)A{A(AЏ\AAAͅA33AΏ\AΣAffA
AffA=qA
=A
A
AA(AA{ApAϙAAzApA=qA  A֣A  A
AzA\)A=qA=qAңAӅAApAAA33AAffAffAԸRAHAAzAffA
A  AA33AA˅AGAAzAҏ\A33A
A33AHA
A  A  A  AAхA  AA33AAffAffAҸRAAәA
=AffA{AңAGA
A͙A
AAzA֏\AAظRAQAQA{AzAGA(ApA{A33A
A=qAˮA\)AGAʣAϙA
=AAAA{A
=A
AA  AGAffA\)AzAHA͙AΏ\A
AffAGAΣA=qAAffAAApAA=qA  AʸRA˙AHAθRAAGAzA{AɮAɅAGAGAɅAAAzAA
=AAffApAɮA(A=qAʸRA˅A
=A
AAA
AzA(A(ẠA33A  AʣA=qAˮA
AəA{A(Aʏ\AGAHAzAffAA˅A
=A33AffA33ApA  A
=AAA
A  AɅAřApApAQAȸRA(AȸRAHA
AHAGAHA\)AȸRAA(A\)AAA
AGAAAřAzA
=AQApAəAAffAHAQA
A  Aď\AQA{AzAƸRAffAŮA
A  A
=A{AȣAAɮAQA  A(AffAAAA=qA  A
A  ApAA
=AAәAAAApA
=AffAхAӅAҏ\A(A\)AffAAAQAѮAffAΏ\A(AA(A{AzAGAAGAͮAffAθRA\)AQA͙A(AAA{AzAQAẠA
AQA  AAAffA\)AA=qAA=qAffA=qAԏ\AzA  AHA  Aԏ\AA
=A=qAЏ\AzAGAҏ\A\)AхAѮAЏ\AGAA{AAAиRAffA(A  A(ApAAʣAA(AA(A  A˙AzAȀ\AͮAAA=qAAAAHAυAQAffAA\)AΣAθRAHAΏ\A33ApApA(A  AAGA
A
=ApAA=qA(A  AA\)ApA=qAHAzAffAffAHAȏ\A33A
=AʣAQA=qApAәAAAA  AңA  A
=ApAApA׮A֏\AQA33AծA33AҸRA{A{AAΣAAϙA
=AQA=qA
A{AGAΏ\AA̸RA\)AʣA
AA33A
=A  A͙AAApAQAхAѮAңAAGAA(A\)AAffA\)AzA
A33A֏\AָRAQAQA=qA(A  AHA33AAԏ\AffAҸRAA(A=qAAΣAzAHAGA{A͙AA(A=qA˅AˮAAGAzAAͮẠA
=AͅA͙A  AffAθRAAQA(AAffA
=AЏ\AGAA(AѮA
AA
=AzAљAGAQA
=A=qAffAθRAHAffAQAͮA{ApA͙ApAffA  ApAЏ\AϙA  AAУA33A(A
AffA{A  AУAЏ\A  AffAzAҸRAӅAGAՙA
AGAGAAA33AAHA
=A33AәA  A{AHAGAΏ\AAљAԏ\AHA(AGAAңApAffAGA˅AffA  A(A
=AHAHA̸RȀ\A
AGA
ApAAңApA{A
=AՅAԏ\AԣA{ApA\)AAA
=AHA\)A=qAЏ\A
=AѮAA(ApA  A33AхAЏ\AAиRAHAGAAиRAͮA(AAAA\)AA˙AAHA\)AЏ\AAzAQA=qAΏ\A(AхA  AffAAԸRAGA\)A33A=qA  ApAЏ\AA33ApAхApAAҸRA
=AӅAAffA\)AAϮAffA{AAApA=qAAӅAљA
=AљAҏ\AңAϙA=qAGApApAAffAAHA\)AA{A
=AA\)AAHA
=AHA=qAңAGAHAGA(AHA{AָRApAA
AQAϙA
A\)AυȀ\AHAA
AУA=qAA(AУAљAAиRAҸRAљAA֏\AAQA
=AHA  AԸRAAA֣A
=A33A=qA  AApAיAA{A֏\A  AzAAծA{AzA
=A֣A֏\AӅAQAHA(AAծAAՙA  AAծAAffA\)A׮A  AAA{AӮAGAԣA֏\A{AAAمAGAAٙApAA׮AAA
ApAAأAAA33AיAGA  AAA֏\AծAApAAָRA=qA33A  A{A
=Aҏ\AҸRAAԣA{AծAծAA(A
=Aԏ\AAA׮ApA
A{AأAAAAAApA
AzAԣAҏ\A(AGAӮA\)AAҸRAAͮA33A=qA33AͅA(AAθRAϙA  AAAѮAAGAAGA\)AׅAAA׮AׅA{AظRAٙAظRAAAAGAיAA33A
=AGA\)AffAHAQA=qAQA\)ApAAәAHAGAGAAAHAҏ\AѮAA
=AGAA33AQAffA\)AGAAHApA33A{A=qAA33A
=AGAׅAA
AGAAׅA֏\A33AAzAzA(A
AzA=qAA{AAԣAA(AA  A\)AGAA
A(AAљAzA{AA{AѮAңA
=A{Aԏ\A\)AzA{AQAHAׅAәAׅA33A
ApAzAffAԣAAzA  A
=A
A  A׮AGAυAGA  AAffAӮA{A  A
=AQA{AAхAѮA
A{AQAA
=A
AA=qAffAA(A
=AA֏\AQAzA=qApAA\)AAAծAffA֏\A
=AHAAAAAQA  AՙAHAHAA{A(AzApAхA=qAυAУAиRA\)AQAQAҏ\AљAzAHAffA33AAҏ\A
AzAA=qA(AffAA33AA
AGAۅAAAffAQAQAffA=qAڏ\AڣA
=A\)A=qA
AGAffA33ApAAGA(A
=AA=qAHAffA֏\AHAׅA֣AffAHAHAՙA{ApAAQA؏\A=qAAQAיAQAAGAffAGA{AܣAApAAܸRA=qApA
=A=qAۅA33A{AAHA
AՙAA  AָRAQAzAA֏\AzAzAzAA33A
AffA\)ApA
=A֣AAzA
AzAffA{A(ApA
A(A33A݅A{ApAffA33AQA  AA؏\A=qAיA׮AٙAأAGAA(AGA=qAQAAڣAA33AՅA
A
ApAAHA=qAAQAԣAHAٮA\)ApAAۮAAHA(A\)AڸRA
A
=A
=AڸRAGAۅAHAQAۙAffAݮAAffA  Aޏ\AA܏\Aڏ\AQA  AיA׮AۮA݅A  AzAҏ\A=qA(AA
AԣA
=A
=Aҏ\A  Aҏ\AA(A׮AApA֏\AffAAffAQA33A؏\A=qA׮A׮AGAٮAA33A\)AٙAمAGA=qA؏\AzA׮A֏\AיAGAӅA{AAAՙA֣AHAApAGAمA\)A33A  AA33AzAЏ\AиRAAңA{AمAffA  AՅAծAӮAҏ\AA33AGA
=A
=AAУA\)AAЏ\AУA=qApA
A\)AffAffA
A{A
AQA֣AԸRApAԣAffA(AӮAҏ\A33AA
AӮAA{AzAAGAAGAffApA{AHAңA\)AA\)A=qApAمAمA=qAAAAAۙAAAָRA33AٙAA33AHA33AApAQAԸRA{A
A
=AׅApAQAApAAңAӅA(AAffAӮAՙA֏\AAָRAՅA\)Aԏ\AGA{A33A=qAA  AzAڸRA
=A33AڸRAڏ\AڣAڏ\AffAzAffAGAHApAۙAAۮA
=A(AٙAAffA  AծAՅAA
=AA33AљAGAAzAA=qAHAA(A׮A  AHAGA
=AffAٮA=qAڣA33A\)ApA33AAAGAHA\)A\)ApAۙA
AAA\)AA\)A(A{AAA=qA
=A33AAծAָRAzAԸRAGAGAAәAQAӮAՅAAffA33AGAAAӅAمAGA֏\AAۮAA{A(A  AA{AffAQAAAQA
AzAA  ApApAAHAՅAָRAGAәAAHA(AA  A\)AϙAՙAHAЏ\A(A=qAԏ\AծAծAҏ\AՅAzA{AzAzAA
=A  A33AA{AAGA
ApA33AمAAٙAQAQAGAA  A֏\A\)A{AӅAԣAծA
AzAAأAffAיAzAAAffA
=AffA  AQApAA{A(AGAљA=qA
=A{AA{A֣ApA{A33AA
=AHAיApAAQAӮAҏ\A
AHAAծAAׅAظRAQAڸRAڣApA(AAffAڏ\A{A
AAGAљAGA
=AQAAzA  A=qA\)A\)AffAԏ\A֣A33A׮ApAיAיA\)A\)A
=ApA33AA33AڸRAHAAHAڣA=qAۮAHAAffA=qA
A{A֏\AۅAAڏ\Aڏ\AffAQAڸRAڣAڏ\AAffAApAAA(ApAApAffAAQAffAۅA
A=qAۅAA{AQA{A{AظRApAՙAffAمAHAA\)AمAظRA
A(AffAQAQAGAzA֣AQA\)AA
ApAԏ\A(AGA  ApAGA
AAA֣AAA
=A{A\)AQAAA33AԸRAGAAAAAApApA\)AAAQA֣A
=A\)A׮AיAAՙAAЏ\A(A  AffAApApAGAGApAGAԏ\AՙAA
=AׅA(A׮A؏\AAׅAיAQAծAA֏\AיAA؏\AHAzA
=AA\)AGAٙAAGA  A(AAApAָRA֏\A33A
=AծA֏\A{AApAHA֣AAA
=AzAGA\)A  ApAffAأA
AיAGA
=Aԏ\A
AՅAՙApAיA
A\)A33A=qA=qAָRApAAGAיA
=ApAzA=qA=qAffAՅAQAՙAԸRA\)AAՅA{AԸRAԏ\AA
AAQAхAffA
=AGA{AAA
=AA33AAԣAA׮A  AHA33A֏\AA(A
=A\)AٮAAAمAQAٙAA(AٮAA  A
=AمA33A
A
AGA=qAAAzAA\)AׅAՙAծAHAծA33A
=A{A
=A(AԣA=qA\)AיAApA{A
=AGAA33AAAGA\)A{AAޏ\A޸RA=qA  AffAݮAAA(AAA33AAݮA{AظRAffAffAA
A33AGAAծApAAمA܏\AAffAGA܏\A=qAAA  AיAAzAHAGApApAۙAۙAHAzA=qA=qAHA=qA=qA33AA
A{AݮAۮA
AffAAffAڏ\AٙA{Aԏ\A\)A(A  A=qAGAָRAA\)AיA(A{AQAHAׅA؏\A\)A(A
A(AffAAzAAHA33A\)AܸRAܸRAffAAQAAAffAAHAQAAGAGAAQAڸRAffAffAGAԸRA  AffAڏ\AGAיA(A֣AHAQA\)AAٮAA\)A=qAffAٙAQA  AۙA{AHAۙA
=A(AAffA=qAA{ApA  AA
=A޸RAQA{A  A޸RAޏ\A޸RA{AݙAA\)AGAHAApAffAAzA
AGAA׮A{AA{AۅAAܸRAA\)AڸRAzA\)AՅAٙAA(A\)AGAمAٮAٙAڣAQAGA\)AA=qAڣA
=A33ApA
AڣAڣA{A
ApAQAָRA  A\)ApA֏\AAGAA؏\A(A{AA{A
AA(AڸRA(A=qA
=AAAQAzAڏ\A\)A܏\AGAGAޣApA33A33A
=AޣAޣAGARA33ARAHA\AQAffA=qAGARAAAA  AApAAHAHAA  AA33AA߅ApA\A
=A
=A
ApAARAHA
AQAAffARAAAffA
A(AGAޏ\AffAᙚAᙚAApAAA
=AA\)A=qAGAAzA\)A{AA(AA
=A{AA  AA\)A
AARA܏\A
AffAHAAffA
A=qAzAA݅AGA  AޣA
=AA߅A{ApAGApAA\Aڏ\AA\)A\)A߅A  AA݅AQA݅AݮAffAHA=qA  Aԏ\AQAٙAݮAffAffA{AAۙAיA33A  A  AңA33AHAԏ\A{A׮A
=AٮAظRAzA  AڣA
AAAܣA
A
A
=ApA33ApAAޏ\AܣAffAޣA޸RA=qAݙAGAܣAAۙAzAݮAffA܏\AGAHAAGAAzA
AA(AAۮA{A
AHA݅AݮApAA(ARApAAGA(AGARARAzARAGAzA߅A=qAޣApA33AݮAA\)AQA
=AHAٮAA{AߙAܸRAAA  AAޣA(AיA33AA
A֣ApA
=AٙAzAA܏\AAffAGA  AApAAA{A{AQA(AA(AݙA
=A݅A  AAݙA
A
A
AݙA
AApAݮA޸RA  A(AAAݙAzA܏\AA(AHAzAA=qA߅AAڏ\A؏\AAAffAܣA݅A{AA߮AA߅AGAAzA{A=qAAݮA(A33A33A\)AA{AAޏ\AHAGAߙAA33AޣAffAݮA=qAffAffAffApAQAA33AQA
A(A
=AAܣA\)A޸RAAAffA
A33AAGAAQA
=ARAA(A
AA33AffA33A33AGA33AHAHAAܣA
=ApA߮ApA޸RA߅AA݅AffA޸RAA33A(AHAffAzA33AHAA܏\AܣA
AAᙚA\A\ARAQApAA\A=qAQAApA(A  AffAAAA{AAzAAA
Aޏ\AܣA=qAޣA(AA߮AA\)AAffAAA
A  A
AAA߅ApAۙAffAA
AAA=qA{AffAAQA{AAAA=qAGApA\ApA=qA33AffA(A
AܸRAޏ\A{AAAHARA(AQA33AۅA(AffAGAffAA=qAQA(AApAApAzA
A\)AܣAܣAzAAߙAA{A=qA
=AAAAA(AA33AzAݙAffA\)A(A\)A
AA  AApA
=AApAGApAGA(A{A\)AܸRAݮAݮApAzAأAA\AQA\AHAᙚAA=qA33A=qAffAQAAAffA  A޸RAAARA(A  A{AݮAޣA{A
AAݮA
=A  AzA=qA{A\)A(AQA33AAA33A
=AffAAA
=A
=AݙAzA؏\A=qA  AAzA(AHAԸRAAAGApA=qA
AffAA(AڸRAAAA݅AHApAAQA  A
A{A  AA֏\A33AәAQAڣAծA
AHAQAAzA\)AHAAGAffAڸRAۅA؏\AGA݅AffAݮA  AڸRAݮA(AGAAܸRAAܣAA
=A(AٮAffA  AمA
=A=qA=qAGAAA  A  AAәAָRApAظRApA\)A׮AәAffA  AA{A{A{AAAGAAծAѮA=qA
A؏\AمAAA{A(AׅAיAיAAGAGAzAأApAمA\)A
=AzAA33A
=A֣AzAA33AAzAԏ\AԸRAzAffAAzAzA  Aԏ\A  A\)A  AՙA׮A
AAԸRA
=AQAApA=qAظRAGAAمAGAAۙAڏ\A=qAHAA33AAA(AQAzAۅA
=AHAzAAڣAA(AA
A  AׅAA֏\A(AӮA֏\AQAӮAHA
AָRAQA(AծA33AAָRAHAffAzA{AڣA  AAQA=qA(ApAAظRA=qA׮AAٙAQAAA33AA=qAԣAGAԏ\AAAAzAA  AAffAָRAծAzA{AAA33ApA=qAA
=A
AׅAۮAQA
=AApAAA33AHA
=A
=AיAӅAGAA\)A(A֣A(AיAՙA\)A=qAңAzAAЏ\A{A33A\)AzAffAA33ApAzAأApA֏\AݙApA\)AzAAәAңA33AGAAٮA
=AHApAۅA  AA{AAۮA=qAڣApAڏ\A
A(A33AzA݅AAzAGAיAHApAA33AA=qAA{AffAָRA=qAۙAA  AA\)AA  AGA
=A\)AAQA33A33AGAܣA݅A
A  AQAAApAA=qA(A\)AAHA(A(AݙAffAܸRAffAݙAHA
ApAڸRAAܸRAAAffA
AffA\)A\)AA  Aڏ\AAأAzAGA\)AQA
=A  ApApA{AAARA
A
=AAA=qApA{AA=qAQA  A߅A\)A\)A
=AffAڣApAHA܏\A{AHAQAGAApAיA
=AQAAA
=AۙA\)A(A  A(AۅAzAA  ApApA(AffAޣAAAAAA=qA޸RAݙAA=qAٮAA  AGAָRAׅAׅA؏\AzAHAGAיAAAAAHA33A  AzA\)A  AAffA(A
=A\)A33AffAٮA
A  A33A؏\ApAQAڸRAڣAffAQAQAA܏\A{A  AA=qA33AAQA(AAָRAיAAҏ\AA
AծAzA  AծA{AHAApA  A
A{A\)AۮAA݅AܸRAAAAٙA33AۅAۙA{AzAAA\)AA{A{AzAGAARARA޸RAA
=A  A(AAffA\AA{A\)AQA  A33A܏\AۅAߙAܣA  A=qApA  AGAڸRAAٙAHAA֣AٙAAA܏\A  A޸RAAAA܏\A݅AݮAffAffAޏ\AHA  AAQAHA
=ApA(A=qA=qA
A
AffA
=AޣA  A=qAAApAQA33AڸRAffAڏ\AHAAQA
=AAݙAޏ\AߙA߅AAffA
A\AAzAAARAA
AAHAA{A߮A޸RAۅAA
Aڏ\AHAڸRAAHA=qA܏\AۙA
=A\)A  AڸRAAAAA
=A
A{AָRAA
A(A\)A
A=qA
Aڏ\A(AAAffAApA
A  AۮApAۙApAۅA\)ApAGA
AۮAA
AA33A  AffA
AQAApA֏\A  AA=qAAAAA  AffAzAԏ\AApAՙA(AzAQAAGAծA\)AAAAA\)AQA
=AׅAHA֣AGAApAzAffA؏\AzA=qA؏\A(AHAGAffA؏\AمAApAAAAхA(AׅAAA\)A
=AAA\)ApA=qA
A
=AظRA
AGAzA
A
=AQAHApAڣAڸRAظRA  AA
=AQAظRAAڸRA
=AzAffA=qA
=AAQAffAA33AA=qAffA
A33AӅA33A=qAљAQA
ApAҸRA=qAHAA\)A33A  A33AA  A(ApA33AA(A=qAۅAGA
=AA\)ApA\)A\)A؏\A
=AظRAمAمAAأAAHA
=A
=AGA\)AAQAיAffAffAԏ\AA׮AָRAҸRApA؏\AGA\)AمA=qA
A\)A
=AԣAQAיAzAأAHAQA؏\AظRAffA  AיAׅA  AQA33A
=AffAHAApA
A(AAffAAzA  ApAծAzA(A(A(A  AffAԣA(AA֏\AAGAظRAأA\)AHA  AffA\)A(A؏\AٮA(AGAGAڸRAAAGAGAGAGA{AA(AأAمAApAAڏ\ApAffAAAHAיAָRAظRAHAHAHAׅAffAQA(AA  AAׅA(A֣A  A
=AffAӮA֏\AיAQAٙAffAA33A33AGAGAHAڸRA܏\A(AffAAڣAڣAAzA{AڸRAڏ\A֣AzA  AGAAA
AAӮAAQAHAAffAأAٙAGAظRAӮA؏\AHA\)A{A(AGAffA
=A{Aڏ\A=qA  A{A
AۮAGAA\)AۮA=qA{A(A{AۙA(ApAzA޸RAA݅A33A݅A
=AޣA
AݙAܣAGAۮAA݅A
AݙA݅AۅAffA=qAAHA\)A
=AAAޏ\A\)AHA{A޸RA
=A\)ARA(ApAQAffA(A
ApA  A=qA{A=qA  A=qAHAHAA
=AAߙAzAAzA
AQAAffA33AGAAAA=qA\AAAᙚAA{AffAAߙAޣAzAA{AAAA  ApAA\)A\A
A
AAA{AARAffA
=AzAAAA\)A޸RA  A܏\AAA\)A33AڣAޏ\A  A߅AGAffAAۅAAzA=qAAԣA(AQAA(ApAA(AzAAzAׅAAzAQAAAGApAzAffA
=AAڏ\A
=AHA֣A֏\A
=AA  AA  AAAAzAمAAA  ApAHAHA=qAٮA33AA(AиRAzAՙAՙA=qA
ApAظRA\)AA33ApAA  AָRAHAָRAffAمAzA\)AA
=A\)AأA(A
=AָRA(AzA{AGA\)Aԏ\AхAљAхA
AAA
AУAУAأAGAׅA  AAԏ\AAָRApA(AHAٮAzAۅAHApApA(AGAA\)ApAQA
A  A܏\A
AۮAffAAۙAمAA(AׅA
AיAzA=qAAQAAQAڏ\AA\)AAHA
A(AܸRA
=AݮAAޣAA{A  AQA(A{A޸RA߅AAApA\)AGAAA=qA(Aޏ\A
=A=qAQAA{AAݙAAA\)AܸRApAݮA\)A=qAHAޣAAݙA=qA=qARARAzAffAA(ApAGA{A33A޸RAߙAA=qAAAGAHAAAGApARA33AGAA33AᙚAA(A{A  AA
ApAApAA(AAARA{AAHA  AᙚAAAApAAAAffAAمAڏ\AAA33A
AAޏ\AQA
=AHAffA܏\A=qA
AAܣA߅ApAAAޏ\AAۮApA(AGAAۮA\)AAApA
AAظRA33AA33AمAzA(A
AۙAܸRA33A{A33AӅA
Aԏ\A׮AڣA33A{AAGA߅A߮AA
=AۙAۅAAA
Aڏ\A(AۮAHAڸRAڸRAHAAۙAۙAffAA33ApAHAAAGApA33AzAGAAA33A
=Aԏ\A33AQAA(A{AمAA33Aڏ\AHAۙA  ApAڸRAGAzAQA(A(A{A33A׮AQA׮A֣A֣AAׅA  AՙAՙA=qAAHAA33AHA
=AffAΏ\A=qA
AA\)AָRAHA33ApA֏\ApAљAA
AA  AA33A֣A(AAיAՙA=qA\)AңAAָRA33AHAՙAQAffA33A\)AA  AAffAׅAAApApA  A(AAA  A(A(A33A{A
=AAQA{AA(A33AGAأAӮAQAzA\)A(A  AA\)AA  AzAHA
=A(AA
=ApAAAՙAAQAffA\)A33Aԏ\A(AAԏ\AHApAхA  AЏ\Aҏ\AծAՙAGAѮAA33A\)A{ApAAHA؏\A(A֏\A  A=qAzAمAٙAٮA  ApAGA\)A{AܸRAۙAffAܸRAۅA33AffAGAffAۅApAA
=AAHAA{AՙA(AA\)AGAffA
=A(A(AHA  AApA=qA
=AQA{A(Aڏ\A33A  A(AzAܣAܸRAAۮAGAۙAݙAGApAܣAݮAۮAQAQA  AAAAۮA\)A֏\A=qAA(A33AAffAԸRAԏ\A{AAՙA  A33AЏ\AՙAA33AAHA
=A\)A33AA(A33AGA(AA  A{AA33AAAAA
A=qAAA
=A
=AA(A{AۮA=qA؏\AAԏ\AӮAиRAGAׅAҏ\AәAAQAڣA׮AԸRAԸRAffAAAA  AGAծA
=AՙAA33AGA(A=qAיAA  AzAzAA  A{AAՙAظRAHAffAAGAA\)AffA  A(AffAQAA(A  A
A(AӅA\)AQAԣA=qA{AAA(AzAAffA(A\)A֏\AA33AAzAAHAAHAA׮A׮A33A  AAzA׮AHA=qAA  AԸRAQAAӮAAԏ\AzAAQA  AQApAHAA׮A
AأAAָRA؏\AHAA33AA{A33AظRApA  AQAAA=qAۅAffA\)A(AQAޣAޣAQAA
AA(ApAGAGAڏ\AمApAׅA֏\AHA33A֣A  A֏\AָRA(AzAԣAHA  AzAHAQAٮA(A֏\AAׅAHAA(A
A{A
A  A{A(A
AծApA=qAAAڸRA
AAAGAԏ\AәAՙAׅAA
=ApAQA(AzA
AУAѮAGAңApAffAAЏ\Ȁ\AGA33A
=AˮA(Ȁ\A{A33AffAAGA
AAffAA\)A33AAAծAA
AGAffAzAأAظRA
AzAظRA\)AAA=qA33AӮAffAAAA
A
=A  AffAңAffAzAHA{A֏\AAAAHA
=AzAAϙAffAиRAAՙA׮AHAAAffAffAAӮA=qA؏\AzAQA(AGAҸRAӅA
AA
AGAAA
ApAGAHAA  AAffA͙A33AffA
=AΏ\AθRAA
A
AθRA(AA̸RA̸RAGAA
A(A\)AA˙A=qAffAʸRAzA(AǙAA\)A\)AGAzAHAGA=qA=qAA˙ApAffA(A  AəA(AAGA(A\)AŅAȸRA
AffAȏ\AǮAHAʣA(AGAAA=qAAGAAƏ\AǮAɅAɮA\)A=qAGA=qAQA=qAʏ\AzA̸RA=qA=qAͮAʏ\A\)A  AA
=A(AA  AəAAɮA(AʸRAAȸRApA33AHAGA33A
=A33A
=A33AffẠAA=qAffAGAzAA\)A
=A
ẠA{AAGAGAA33ApAҸRApA{AϙApAGA=qAA{AA{A
AAQA˙A\)A˙AQA{A͙A\)AAAAffA˙A͙AzA
AAQAQAQA33A33ApApA=qA
=AQA33A  A
AˮA  AЏ\AυAAGA(A  AGAϙA\)AУAңA  AApA(A(AHA  A
=A33AԸRApA\)AиRAGApAHAGAzA\)AGA
=A(AAAҸRAҏ\AAHAAHAЏ\ApAQAAffA\)Aԏ\AffA(A33AA\)A\)AӅAҸRApAA  AҸRAљAQAAΏ\Aԏ\A{AA{AͅA
A
AffAQAA{A
A{A
=AHAAѮAGA
=AәA  A(A
=AхAzA33A33AAAffA=qAԸRA
=AθRAA33AA(AAAGA  AиRAУAGAϮAA  AAzẠAffAʏ\AAA(AGAQAA
AffA
A33ApA=qAәApAљApAԣAffAхAAѮA(AzAffApA
=A{A33A̸RAϙA(AAAљAA{AA{AHȀ\AA
ApAȀ\A
=AˮA\)AffA˅AzAffAAυAGAAʣA=qȀ\A=qAffȀ\AͅAθRAθRAAA=qAϙA
=AθRAΏ\AυA
ẠA
=A͙AͮA
AQA  A33AzA
A(AхAA33A33AAхAθRA{A(A  AffAzAAAAӅA=qAHAQA\)AθRA=qAΣAHApA=qAA
A{AQA  AљApA
=A
AzAϮAAHApA33A͙A
=A̸RAAAAͅA33A\)AzAAͅA(AGAʣA
A
AƏ\AA(A{AzAУAffApAƣAȣAzAʣAAɅA=qA\)AAͮAffAͅAͮAAHAΏ\A
AHA(AGAA
A33AGA\)AGAHAΣAA\)AAA
=ẠA
A{ApAAHA(A  AϙA͙AAǮAQA=qA\)AGAGA
A
A̸RA=qAθRAffAAϮAиRAAGAAңAffA(AGApA
AffA
=AzA
=A33A
=ApAGAA(A
=A33A(AȀ\AЏ\A
=AAхAУAAЏ\A  AGAHAәA=qAA{A̸RAA(AHAAϙAGAzAϮAzAzA(AAУA(AzAУA(AzAͮA
A(A͙AAQAA(A
A(A(A
A  ApA=qAɅA{AʸRAʸRA̸RẠAQA
=A
A=qAͮA{AѮAAAGAɅA33A
A
=A
=A  AHAϙA(AffAHAHAGAAAAQAЏ\A33AffA  AffAA  AA(A33A33AGAffA\)AəAθRA
AzA\)A
=A͙AffA  AzA(Aҏ\AӮA33AӅAzAA{A(A
AAAҏ\A(AAυAAAљAңA  A(AAHA(AffA
AQAA(A(AծAԣApAAffAAHAAAѮAGAхA  AA
AffA33AΏ\AzAԏ\AՙA֏\AzA  Aҏ\ApAAzA\)AՙAffA{A(AٮAAQA=qA{ApAApAظRA
AzAzA
AׅA
A֣A׮AzAיAיAԣAԸRAԣA{ApAӮAAԏ\A
=A
AQAAӮA
=AңAGA
=A
AAQAAA
A=qA(A(A(AAՅAAA(AQAQAՅAՅAGAffA֣AA(AAϙAӅA{A
=A
AGApAѮAHAυAAϮAУAzAхAУAAApA=qA
=A=qAHAͅA
AAAΣAA33AϙAA=qAQAҏ\AAQAңAӅAԣAҸRAAԣAzA  A33AzAHAAHA  A{A33A\)AAЏ\AffAљAиRA
=A33AzAGAQAѮAЏ\AGA͙A˙A˙AHA̸RA  Ȁ\AɅAA33AAzA˙A=qA
=AAGA=qAΏ\AA
A
=AGAAApA˙AAA
Ȁ\AzAzA  AzAиRApAHA  AHAͅAAȸRAƸRAAGAA=qAffA  AzAGA=qAA\)AA\)A=qAA\)A  A  Aʏ\Aʏ\A(A  AȸRA{AAGAȏ\AzAAzAA͙AHAЏ\A
A
A
AAffAͅAˮA
=AAA
=AAQAəAȣA=qAȣAǅApAA\A
A{AĸRAzAAQAHAQA{A{AУA
=A
AϮAA(AA
=A{AffAәAхAAffAAAυAffAЏ\AиRAθRA{A{AAȀ\AQAffA\)Aʏ\Ȁ\AffA{AиRȀ\A{AffA
A=qAGAAиRA
A͙A33AQAQA\)A(AA
AffA
=AAQAzA(A{AAApAϙA
ẠAffAzA\)AAQAHA33A
=A˅AϙAffAQAʏ\AQA
AA=qA˅ẠA33AGȀ\AAffAzA(AAѮAA
=AхAffAGA  A=qAA(AGA˙A  AA\)AAA{AA
AƣAAA=qAŮAA(ApAAffAAǙAÙAQAzA
AA33A{A
A33A=qAAAřAzAƣApA(A(AAQA
=A\)A(AŮAHA{Aď\AAÅA(A(A\AQAA\)AA
=A{AHAAAHA\)Aʏ\AzAƏ\AAAHAʣAffA\)AffAǅA˅AGA(AHAHAǮA  AQAffAA
AAϙA=qAΣAAΣAAЏ\A
=AA
=AAAͅA  AGAȀ\AΏ\AffAȀ\AQA͙AzAΏ\A(AʸRAAAͅA̸RA{AzAGAAʏ\A  A=qAAʏ\AʸRAA\)AAHAGA\)AA
=A͙AQAHA
=A\)AͅApA33ApAA  A
A  AA˙A˅ApApAHAAGApA\)A˅AGApA\)AGAHA
=AffA
AȸRAAAGAHAƸRAƏ\A  AȣAAzA{AA  AAHAAGAϙApA\)AQAAAθRAA
=A
=AAθRAAΏ\AQAϙAϮAϮApA(AͮAϮAAAϮAA  AϙAΏ\AͮA  A
A˅ApApApAAGA\)AϮAffAzAΣA{AGA(A
=AffAA
AυA\)AHA
=AхA33AAzAAQAzA{AϮAυAЏ\AϙAΣAffAQAQAQAAGA33A33AGA33A
=AApAϮAϮAAAϙAA  AQAHAA(AA
AHAAGAQAҏ\AәAA\)AAGAԸRAAӅAәAӅApAәAԣA33AHAAA
AGAQA=qA
=AffAԏ\AffA  Aԏ\AHAHA{AGAУAϮA
A=qAffAA  A=qA{A(AAffA
AHAA33AAffAA  AA33A=qA=qAAA33Aҏ\AAAѮAѮA  AѮAQA\)A\)A(A  AA(A  AϙA{AAϮAϙA
=AAAЏ\A
=A
AљA(AљAQȀ\A͙AGAхAAHAA(AA\)AA
AхAffAAGAHAGApAͅA{AAzA  A
AffAAʸRA  AzA\)AͅAͮA  AzA(AGAAͅAУAA  ApA
=A
=AAУAA=qA\)AљA(Aҏ\AAA\)AљAљA
=AHAAͮAΏ\AGA{A
AA˅A(AQApAA33AzA=qAHAHAΣA
AAGAGAAȸRA=qAffA
AɮAA\)A{ẠA\)AͅA  A33AGA
AHA
AΏ\AAЏ\AϙAQAAGAGA(A(AA\)AͅAHA̸RAzA  A˅A˙A(ApA\)AˮApA
=AʣA\)AɅA
AA
A{A
=A
=AHAQAȣAGApAȏ\A  AAQAQA
AAGA=qAθRAͮAAzA33A(AϙAAGAzAΏ\A(A{ApA(AθRA
=A=qA33AͮA͙A\)AGA33A̸RA˙AA\)A
A  A
=AAAffAA
=AAˮAʏ\AA=qAΏ\AffAʣAHAəAQAAɅAAzA=qA˅AˮA{AAͮAAffA˅A˅A(AHA  Aʏ\AȣAHAffA
=A̸RAẠA˅A˙A33AəAA(AGAGA(AA
AǮA{AA(AAʏ\A
AˮȀ\AHApAȏ\AApAʣA=qAHA
=AAApAAzAzẠA  AQAHAGAʸRAGAzAHAA  AAHAffA
AAGA{AƏ\AAƣA=qAřAA{AǙAGAĸRA  AAAzA
ApAɮA  AffA˙A  A33A=qA(Aʏ\AAHA\)Aʏ\AɮA  AA(AAA(A33AGAÙAAAApAGAGAzA
ApAAƣA33AA(AHAA
AzAzA{A(AƸRA  AHAffAffAHA=qAAȣAəA{A  A
AAAAɮA33AffA33AffA˅Aʏ\A˅ApAA{AffAǮA
=A(AAȣAHA  A
AAffA{AGApAģA
AAffAQAHAȣAȸRA=qAffAƸRAǙAʏ\AɮA  AzA33AAǙA(AAɅA=qA\)A33A\)AA=qAͮA
=AGAAA
AHA  AAzAffAǙAAAHAQAA33A{AģAŮAA
=AĸRA\)A33A=qAîA
AîAřAzA33AÅAÅAŅAAzAʸRAHAAGA  AAA̸RAffAřA\)A˅A
=AAˮA(A˙Ȁ\AʣAʣApAHAzA(AzAQA̸RAA\)AA\)A=qAA33A
AAHA
=AA=qAffA\AA
AÅAGAA33A{AA(A
AHAĸRAƸRA\)AƸRAƏ\AƸRAAGAAffA{A
AffAƏ\AřA\)AȣA\)AzA(A(A  AŮAAÙA\)A(A\AGARAApAA=qARAAApAzAffAQAApA\A
=AQAA  AzAARAAAAffAQAGAAzA
=AAzA
=A33A  AAGA33AHA33A
=AA\)AA33AffARA
=ARAzApA33AApAARAffAAA33A(AGA33AAzA=qApAHA{A=qAřAzA(A{AA˅Aʏ\A\)AAAzAAAGAzAA\A33A=qAA33AAQAÙA{A(A{AAAAGA
=AƸRA(AǮAffA=qAʣA33AA
=AʣAA
=ẠAHAΏ\A  A{AAAA{ẠAͅAȀ\AȀ\A  Ȁ\AAffA(ẠAʏ\A33AzA
=AǙA=qAƣAɅAȸRA
AAȣA\)A
=AɅAGA33A
AˮAȀ\AffA(AAAʸRA
AAəAɮAzA=qA(A  A
A\)A\)A=qAəAǮAApAHAQA  AǮAGAəAHAQAAʸRAǙAAƏ\ApAAzA(AɮA
AA33AƸRAHA
AAffAQAApAGAAʏ\A(AɮẠAAAẠAAGAzAzA˙AAGAGAŮAzAŮAzA(AHApA
A{AŅA  AGAA  AʣAǅA˙AAƣAəAɮA
AHAA  A33Aʏ\AAAʏ\A(Aʏ\A33AAffAɅAGA{AAA
AɅAHAˮAffA{AAHAffAͮẠAffA\)AƏ\AA
AGAǅAAǅA{AHAˮAˮApA¸RA  AǙA{AǅApAHAəA(A33AģApA33AAÙA\ApAzAAAA{A33AAQA=qAAÅAzAA{AřAď\ARApAA  A(AA  A
=AQAAA(ApA
=AQAzA33AA=qAģA  Aď\AÙAAAĸRA\)A=qA  A\)AƏ\AAAÅA\)A33AυA
AʸRAA{A̸RȀ\AQA
ApA̸RA\)A\)AɮApA=qAffApAǅAģA33A=qA
=ApA33AAƣAApAȸRAGAffAAřA  A33ApAffAȏ\A
ApAQAȸRAzAHAA{AǅAɅA33AzA=qȀ\A
A̸RA33A{A{A(AA͙AΏ\AQAzA˙A=qAffAffAffAzAŅA(AA\)A  AəApAGAHApA
ApA
=AHAGAAʸRA33A˙A˙A  AʸRAzẠA(A̸RA
=A{ẠAHA=qA{Ȁ\AHAAAͅAˮA
=AHA\)A(AAΏ\AGAAAˮA33A{A
AzAAAzAffA
AHAAGAAHA{A=qA(A=qA{ApAQAȣAAHAzA33AˮA\)AˮAʏ\A{ApAA(AAAƣA(A(AAA
A
A{AAAA33AƸRAffA˅AGAǅAȸRApAAHAʸRA33AAθRAGA{AQAAffA{A{AʣAʸRAʣAHȀ\A
A͙ẠA{AΏ\A
ApAHAAGAGA  AAAˮA=qA{A˅AApA˅AA=qA
ApAApAˮA(A(A
=A
=AHAQAA
=AA(AΣAffAA
=AzAzAHA\)A33AHAAGAA  AA=qA  A{AAAzA
AffA{AиRAљA  A  AGẠAGAA{AAƣAʏ\ẠA̸RAQAAAΏ\AA33AϮA\)A(A(AffAA
=AиRA=qAAffAHAAQAffA  AzA\)AΣAzAApA33AQA=qAAͅAQẠAGA  A
Aȏ\AAƣAȸRAǅAîA
=A(AffAAzAffAƸRA
AGAʣAʸRApAA
AQAɮAGAA
AA
A˅A
AQA(AAGAʣAəAHAʏ\AQAʏ\Aʏ\AʣAzAHAAʸRAzA
=Aʏ\AˮA(Aʏ\Aȏ\AAAzAffAȣAɮA\)AǙA=qAAAA˅AQA̸RA
=AHȀ\AA{AHA
A  Ȁ\AHAHA̸RA̸RAAffAffApAɮAA(A  AəAffA(AA(A˙AAAQAA{A\)AQAŮAÙAffA(AǅAGAAzAA
A
A(AzAzAGAGAA
=AHA33A{AA  AA=qA̸RAffApA
AAˮA=qȀ\A̸RAAffAˮAAzA  A\)A=qA  AˮAAʣAǙA
A{AAffAA=qAƏ\A
AAƸRAǮA
A{Aȏ\A=qAȏ\AAA{AAǮAȸRAGAɅAAʸRA(A
A33ApAɅAʏ\AẠAʸRAAAA33AQAA
AɅAɅAA{A
=AAA\)AɮA
=AAA=qAƣAÅAģAAQy Aҏ\A(AffA\)AffAGAAA
AGAffA
AQA=qAԏ\A
A=qApAQA33A33A(A\AHAzA33A(AAǮApAHA33AĸRẠA˙A  A\)A֏\AAAzA  A
AAARA(AA{AAHA\)A33AA(AAAGAQA\)A\AAzAQA  A33AHAQAɮAQARAA(AAQA
=AAzAAAAffAAAAҸRAAzAGA{AAHAAHABA\AQAA\)AzA\A  A\)A\A\AA
=AApAHAffA{AA=qAQAAAA33ARAٮAHAܸRAAAƸRAAAӮARAffAARAzARAHAA=qAAA\)A{AÙA
=ApA{A(ApAQARAAGAA=qAHAHA(ApAAAAGA
A(AΏ\AffA33ARAAffAA(A  A
A=qA
=AA
A{A=qAծAAѮAA  AAQApAzA  A
AA(AzAQApAƣA(AA=qAQA
=A\AzA33AAQAQA{A33AAAffARA33AAAAApAQAA\)AA=qA{A{AٙAzAҏ\AͅAď\ApAәAA݅AAA\)AA=qA֏\A\)AƸRAͮA{A
AzȀ\AzAffA\)AA33AffB 
A=qAA=qAAzA
=A(AAGA\)ARAzA  AAA=qAHA=qA˅AAApAGAffAAAA{A\AAA(AGAzAHAAAAA=qAAHA
ApAQAQAAAHAA=qA
AA33ApARBRB 
A
A{AQAA\)AApAAHA(AffA{ApA=qB{A\)AA  A  AA
=AA
=ApAA  A(A33A\A{AAA߮A܏\A{A33AޣAAA
=AAϙA\AzARAGAAA߮AzA陚AAA\)AAzA{A
A陚ARAHAzA(AApARA
=A
AHA{A  A{A33A㙚AA  AApAQAffAA=qAzAARAffA
=A\)AA(AAA
A=qB\)AA{AzA(AzAAAAffAޏ\AGAAQAffAA  AffAAA
=AAzAAAA{A
AGA  A(A{AffAHAУAAA͙AzAHAAA  A33ARAAQA33A{AAffAܸRAHA33AQAAƏ\AȣA\A˅AٙA
=A=qAAHAGAA\)A{ApAٮApA
=A\A(A  ApA\)A33A
A܏\AAۅApAA
AǅAՅAңAQA(AҸRAGAݮAA{AAA߅A(A(AָRAffA\)AGAA\)A\)ApA
ApAApA(AڣAڏ\A\)A{A{A߅AԣA׮AQAAϮAzAzA{AAۙAGAͅAģAAffA{AA(AأAAAA(AGA33ApA  AAQAGAHA޸RA{A{A  AQAA
=ARAAܣA\)AQA
=AA=qAffAQA(AA\)A(AffAAffA\AQA
=A33A\AAA{A\)AffAAffA{ARApAzA\ApAA=qAA㙚A{AA\)A{A癚A  AAA  AA  AA(AzBB\)BAAAzA\A{A{A\)AHAAzA\AzA
ApA
=A\)AA홚AQAHB=qBA\ApA
=A
B {BBBHARApAffA(A33AA(ARAA=qAGAB33AB QAHAA(A(AQA\AA=qA
AܣAظRAA{A=qA{Aޏ\A\)AڸRA(AЏ\AQA33AAAzA33A33AAQAAߙAQA\B \)BAffA33A
AAAAGAӮAA=qAA
=AٮA33A33ApAA\A\)AAffA癚AA  AҸRAAA  AffAzA£AA
=AƸRA=qAA(AϙAzAQA  AGAApA33AɮAA(A33AA\A
AHA
A}pAA\AA{A\)A~ffA33AuAo
As
=AL(A=A*=qA@QAH@H@@A\)AA1AS
=AMASAdAqADAj\A[\)AG
=A\(AZ=qAtA}AwAN{A@(AN=qAJ{ADQA`(ALQAEA}pAUAYAXzA[
=AL  AS
AYAnRAs
=A{AqAAAApA{AffAHA
A
AzA
=A33AA{A\)ApA33AffA~RAxzAfffAZRAR=qAA{A.RA/33A:{A7
A,A+
A=GA,zA2RA(A%AA&RA7A3
AApAffA,(A:ffA=pAJ=qA3
AA3A<ALAD(A/AABffA
A!pA&{A>=qA{A$A#A!AA	AQ@A=qAp@33@@z@H@33A  A#A
=@ff@@\@{A
@GApA	AGARAffA  AA)pAB=qAapA&ffA2=qA@A]A_\)AAQAAjHA}GAzRAeGAipA(A`(Af\AbffAb\AZ{A{A33Ao33AAAzA
=A=qAAzAA|QAmpAGAHA
=A
=A=qARA\AA
=A\)A  AAA(A
ARAffA
AAGAA\AffAGA=qẠAAأARA\A=qAGAAA\)A\)AffA=qA
=AAffAď\A\AAzAQAzAA=qA{A  AHAAAGA(A
A=qApAîAAApAAzAΣAǮAAAA\AHAHAAAAAAAAzA
=AAzA  ARARAAHAƸRA33AģAAzAHAAAAQA\AQAA=qA33AffARA
=A=qAzA  AQA33AA(AAQAffA=qAA=qA\A\)AGAA33A  A33A=qA\)A33A{AŮA
=A
=AffAAA=qAȏ\A=qAffApAQAzAA=qA33AzA
AA\)AģAffAܸRAͅARAAQAͮA33A  AQAAffA  AAA
AAď\A=qAҸRA{AQAQApAHAGAָRAîAGAAA(AԣA33A=qAָRA  A  AۙAGAHAzAAARAQAffAЏ\A=qAHA
AA  A(AA  A  AٙA=qAAA=qA
=AApA\AHAAAA߅A\)A޸RA=qA{AzAAٮAәA
=A=qAׅA
=A  AA=qAAAԣA  A33AGA
=A\)AAAʏ\AA  AA
=A
=AAӮAzA\)A(AzAA{AGA\)AәAQAÅAA  AzAGAARAzAA
=AAA\)A܏\AۙA
=AHA  AAAGAAAA
AυAAA
AAffAǙAAA(AAzAA(AAGAGApAGA=qAAQAQA͙ApA֣A\)AAхAA=qA
A
=ARAȣAzApA
=AAA{AA\A{AAAAAffAA{AٙAA(A{AۮA
=AHAA{AAAffAA(AAzAffA  A  A  AA33AHAA
=ApA33A
A֣AܣA=qA
=ẠA  AA  AA
AAffAzA㙚AQA(AB {AA
=A癚AffA(AA\)AGA=qApA33A33A(ApAAԸRAHA  AA\AAGAA
=A33AffAHA\AAA\)AHAQA{B{ApA\AGAAzAA\B =qAA  A
A{AARAffAzA
=AAQAQAAۅA
=AܸRAAA{A(AHAffAHAA(A=qAA\)A
=AᙚAA  AA
=AAAAffAڸRAљAٮAA=qARAA  AAݙAQAAffA(AA㙚A\A(AzA{A\AAQAGAA{ApApA\AHAAAAA
AffARARAGAQAA=qA\)A=qAA
AAAAA(AffA߮AApARAAA  A=qBBAA{AAHAAAA
A{AApAzAffA(AAAHA
=BzA33B\B
AAAAAAAGBBBRB\)B  B33BB33B	  BBQBAffA=qB	
B
BQBA
=AAAA{A=qAQA\)A  A\)A(AAHAB ffB   AAA\AAHAAA(A
=AA\A=qA\AA
=B  B
=B=qB=qABAAHAA\)BBABB
=BBQB33BB(B(B{BffBQBAB  AB(B RA\B=qAGBHBB GAffBBBHBB
=B(BQBB=qB
BpBBHB33BBBBB
=B	\B\)B=qB	  BRBpB GB  A{B=qBB(BGB
B
B	pB	{BBB	
B\)A=qBBGB
=B GB
B BBpBffBBzBpBRBffB =qB
BB B zB{B
=B
BBBffB(BQBQBQBRBBB	BGBA  BBGB\)B
=B33BpB=qB\BHBpBQBBzBffBA33A
=BB33AHA
=B ffAAzA
=B BB GA{AAHAHA
A=qAGAAzBRBBzBBB33BzA{AB BQBHB(BB\)A\)B   B 
A{BpBffBBGBpA\B \ApAApAA=qAzA33A{AffA=qAAGA\AAA{A  A(AAzA{AGA{AA=qAHApA
=AB ARAA\)AffA{A
A33ARAA(A(AAffA=qAAzAA=qAAAA
AׅAHA=qAzAAHApA\)AәAzAծAQAυAQAAGA  BGB\A\A\B (AA  AApA癚A
=ApA陚AAGA
=AAzBBAffB
=ABB GBffBGB \AHA
=AzA{A\)A
A
B(BBAHAAHAffAAGAHB\B\A(AB {B BffBpB  B(BB\)B
=B=qBB33BpBBpA
=AGA\B AA
=AA33AB BB\)AAAB zAzAAGAffA
A
=ApApA  AA؏\AڣA؏\A  AAۮA=qAApAAGAzApA  A=qAAzAA{AAAGAA{A  AAA\)AA=qA  A
AAAGA  AA
A߅A
AHA܏\AAA=qApAHA33AAAGAA
=AAAA33AAffAAׅA
AAHApAA  ARA=qA(ARAAAAAᙚAHAAHAAHA=qAA
=AzA\AٮAA{A{ApAGAffA
AGAA  A(AGAA{AAGAθRA\)AApB   AzAAffAARAGAzAAAA
=AGAA{AAffAffAzAzAAA\)AffARAAA{A(AAٮAzAffA  AApAzA{A֣A
AQB(AABpA33A\A\)B ffB33BBBBA\)ARAzAzAA33AA
=AA\)A\)AQB ARBpB BB{B\)BBAAAA33AzAARA33A\)AzAAApAA\)B
A=qARA=qA\AffA
AQB 
B=qAApARAAA(AGA33AGBA  AA
AB
AAA
=B=qB33B(AGA噚A(A33AA
AAffA=qA
AffAAݮA
=A
=A
=Aڏ\AAA\B B B 
=B ffAAA
=AzAA\A33ARAAB 33AzA=qA
=A{AAQARApA=qAA(BAGAGAAHA=qAAQAApA33AA\)AGA܏\AA\)A33A33A=qAAzBQBRAA\AHABffAAB zARAApA
=AApAA{A{B\AAzA33B  BBffAffAGAAffB A=qAAAA\AAA=qA=qAA\A\)A(A  B \A
=AGA\)A{BB(AAzB=qBffAB B=qB
B (BBHB B
=BffA
B(B GARBBBHBB{ABBpA(ApAAffAGAA=qA=qA(A\)A\AQAAzAHApA=qAffAB
=BB=qB
B\B\B\BB33B33AA33B B RB\)BHB\B
BBB
=BBGBB{B=qA\AffApAGAA陚A=qA(AAApAA33AGA\A癚AHAAffAAffARAzB
BRApAQA(AAAA\)BpB \)B  BffBffB{B\)AB  BGBHB zBB
ABAA\AAGA33AffA\)ApAQAHAߙA=qA33AQA\AzA(A֣AffAٙAۮAAA
A=qAܸRAڣAݮA  A{AA{AHAAARA
AGAA=qA{AHAARA  A㙚ApA{AAffAGAQAAA{AzARAA=qApA=qAAHAHAA
A  A=qBA
=AAA{AA=qAA=qA\)B 
BHA\B
BB \)A
=AAzAHAAzAHABGBABRApB QAAHAAzAzA
A
BA
A=qAzB=qBRBAzBAAGAAB\)B33B  B	BpB(AA
=A{A\)A\B \)A  AAA33BAABBzA\)AAAA\ABA{A
AQAAAAGAA
AA\A\AzA
=A{ApA=qAABpBffBpBB{B\)B\)BAGA\A
AffAHAA(A\)AAARA\ApAAffB(BQB \)B ApAzAAAffA
AAGAGAA
AA33A{AGAzAB\)B 
B RB 
BGB{AB\)BffBBQB{AffAB
=B=qBBA(B
=B\)B=qBzB\BBHB  B	33BAffA\BBA33BAAGAAAAAAA=qAA=qA{A(B {BzBpBzBBzBB\BpBBzBB  BBBBRBB\BHB=qB=qB
BB{BRABA{B
A
B GB{B B\BA\BBffBGB
=B  B	B	zB	zBHB	B	\)B

=BQApBQBGAffBffB(BBB{B  B
AGA
=BffB33BB\BffB\)BzBGB
BffB A
B BAGAB zA\AAA\)AAAA=qA  B\)AAA{AQAA
=A  A(AGApAGA(B QBB\B33B ffA33AAAARAA\AGARAAA
=AAB =qAffBB33A\)A=qAHA(AA\)BBBB  BBQB\A\)AQA  AA癚A33AAۙAAA33B
=BB
=BB
=B pBB33BGBB
B33B HB{B
=A
=A33ARAAABABBBffAB
AAB A
AA  AHB(B(AA
=AQAARAAzAHAA  B \A{BQBBGB{B33BQARAAAA33B B33BpBBBHBB\BB  ARBBABB
B=qBAQA  A=qApAHAARAA
=A
=AffBRB
A\)AffBHB GA(AA33AAA
=BBRARApAAAApB \AHA(A\)A癚AA
AAffB =qAApAA(A
=AApAffAAA
AٙA
=A  AAۅA؏\AHA{AA\)AAʣAzA
A
A
AAA
=AAffA\)AHA
=AffAAAffA
ApAGA(AHA
=A
=AB
AA{AA\)AQA(A\)A
A
A  AGA(AأA  A
=A׮AHAظRA؏\A  A\AzAHAQApApApAAAAA
ApAzAA=qA
=B ffB ARA33AQAABBQBB\)BBAAARAzA33A
=AzAffApAffA33AARApA=qAzA
=A(AA\AB\)BBHB33BBHBHB
(B
\BB  AGB pB A=qB  BB33BffBQB\B\BB{BBzB =qAHAzAffA
AHA(A  A\)AHAffA
A{AffA33C(AA33B \)B{BB=qABB(B33BGBAGA
AHBBAGBzApAGAffA
A\AGAA=qAAGA  AzApAA33A{A
A\AѮAمAݮAHA33AA33AAGA\)ApAA=qAQAAApA
AzA\AAAA
=A33A  A33AA\AAQA
AHAzA{AA
AQAHABffAA33AffA=qBRAAA\AAAzAAQApAAzA
A
A
A
=A{AA  AA(AAApB
=AGAHA=qA(AGAAARAA  B QB33BB\)B GAffA=qAA
AAB zAGABB33BAHA\)A  AA
=BAHBB\AAGAzAAA\AffAAQB (AB 
=B BARAzAA{AApA(AAAQAA=qAGAAAAAApA(AHARA\AQAHAApARA(AApAAAAAәAA  AApB\)B
B =qBBzBBBBGB 33B AB(AQA=qAffApA\B  AARAQA
=AGB=qAGA{ABApA\)A{B{A\AAHAAHA
=AGAA
=AHA33ARAGAAAA=qAApApA\)A(ARAAQA  AA{AAAGAffA\AzA  AAAGAAAB {AAHAAA(AڸRAGAGAיAAAۙAHA߮AHAA
=AܣAڸRApA=qAʣA  AÙAzB AffAA33A(AAGA\AA(AHAAAAffApAB =qAAQBApAB AB AAA=qAAAQA33AAQAٮAAAA{AffA
AA=qAAҏ\A\)AQAARA{A\)AGA߮A噚AA
=A=qA癚AA{A33A33AAQAԸRAAffAAQA
AA33AAAHAzAQAzA=qAٙAAڸRAۙA33A\)AzAʣAffAffAGAA{AAGAAGAA
ARAA33AAzAA\)A\AAܸRAAA(AAGA  ApB33A  AffA
=AQA\)AA=qA\A=qA=qAHA(AA33BB
=B(BHBB
=A
AzAB	A{AA{BAB AB {AARA\AB B AzA
=AB{ABAA(B=qBB33AB{AzABpB\BAA\A\A
AzAzAApA(AHAA33AffA  AffARA\)AA  A\AA(BGB33AffAAAzA{AAA33A(AAGB
=A
ApBAAA{A
=ARB=qB \)ARB (AB
=BB33ABB{ApA=qA\)A  A{BzAB (AGA\)A
BBA(A33AA\)AB AB B33BBB zAGAAQAA  A{A33AHAHAARAAAA
A\ARA(AA߮A(ApA33AzA  A  AᙚABAAAzAAGA\)B\A=qAA{A\)AHAAQAA(AHA
AB =qB{B{BffBA33B ffA(BffAA
AHAAARA33BARA{A
AAGB
=BAHAAzAAGBB AAHBBpBA=qAB AHApBzAB HA(AAHAHApB
=AAAQAAQAA33A\)AGAffApAA  AApA=qAQAzAAAAHAGAHAA(AAApApAAAffA(A33AAQA  AQARAzA
=AApA׮A(AffAGA݅A{A
A܏\A
AGAA33A
A홚ApA33AAHA
AA{AffAApAڣAAApAA\AAAA  AAᙚAQARA
A{AAAA\)A{AGAGARAA
A
=A
AQAAAAA33AA޸RA=qAAAAAGAAzAAAA=qAzAGA\)A
A
=AA=qApAA=qAHAGAߙAHAQAٮA=qA
=A
ABBA33A
AffAA  AA\)A\AA  AAAAA\ARApARA
=AA\)A޸RAA33AՙAظRA(A
A  A=qA\)AۙAAAA{A33AGAAA{ARA\AA(AHAQAzAARA\A  AAHARAzAA
=AA33A\AAHA\)A
=AA
A  AA
A
=AAAAA\)A
AA(ApA
=AGAAffA33A\B GA=qA
=AA
=AA
AAA\)AA(AzA=qARAGB \)AA{B RBBA33AHAzAA\)A
AzAAAAAGAzAAԸRA㙚AҸRApA癚AA(AzA{A33B 33BGBB33B\BHABAA\AB ffAAAAB =qB33A\)AAHAAHB \)B(BHB 33ApA33A\AAzAGB B GA
=A陚A
B\B\)B GAAAAffAffA
A=qA{AAA(A
=A\)AA  B{AGA  A33AAA뙚ARA
ApA  AABA
AAAHA(AAQAffAAHAAA{AGA陚AA  AQApA  ARBGAARA
AA33AA33AAA  A
=B\)AA{AzAA\ARAHA
=AAAAApA\)AAzAffAAAHA33AHAHAGA
=AAGARAAAA
=A{A
AffA33ARA(AzAGAffA܏\AAA33A\)AAA
=A
A(AAA{AffA
AzA֣A{AApAffA=qAHAۮA{A33A
=AAAљAA{ARApA33AHARA(A
AQAA{AffARA{A{AARA  ApA{AA(A33AffA=qA
AA{A
AQAޏ\AAzA޸RAߙA
A(AAA㙚AA=qAAGAA  AAHAQA\A  A{AAARARAA  AAQB GB   AA\)AAAAAAA\ApAAAAAAQAA{AAQApA{BBGBffAAHA\A(B{B\BpBHA
B RB ffBB   AA  AQB zBGBHB33B{BHBRBA  AzA{A33A
=AB GAGAzA  @AGA
=ARAA
A33AAffA(A
=AθRAA
=A(AQA\)A33AARApA{ApAAƸRA
=AۅApARARA33AÙA\)Ȁ\A
=A33A(AA=qAHAAAzAzA  Aڏ\A=qAAAA33AՅAAʣA
=A  AAAffAApAHA\)AA\A\)ApAQAߙA癚AA{AA{AHA(AAAGA  Aȏ\A
=A\AffAHA؏\AGAQA{A噚A
=AծAQA
=ẠA˅AAAAAA{AA\)A{AAٙA=qAffAA=qAۮAAAAzAAAAÙAA{A{AAAAA\)ApApA  A
=A(A\A\ARA(AAA  A(A(AA{A
A33AHAAAA
A  AAÙA  AҸRAA
A{AA
=AA{AAAHAGA\)AHA
A  AQAQAAȸRApAʸRA\ApA
AAAA߅AGA
AAQAA\)AAAȏ\AzAA
AffAAŅA33AAAAA
=A
=ApAARA뙚AQA
=AA(AA\AAڣAA{A  A{ABpA(AAQAApAܸRARA߅A(AمA
AAAϙA  A{AGA(AA  AApA\)AAA׮AAٙAܣA\A\)AݮAۮAzAAApA  AffAQA  A
=AzARAA=qApA33AApAA陚A\)A33AApAHAQA  A  A=qAzAӅA(AAAУAA(A
=A=qAHAAARA\A\AAzApAzAA  AAzA  A(AffAAAݙAA\)A
AA癚AA\AAGApA\)B
=ARAAAAۙAGAHAA
AAffAHA\AAǅAᙚAzA\)AHAQAffApAHAAΣA\AQAHA\)A
=AAzB B AAA\A=qAAA  AHARAA\ARAHARBB AzAAAARAApAAApAzAA33A=qA
=AAQA\)A  B AGAA(AA33A
A
=ApAA(B {AAGAAAzAAڣA(ARBBARB A\ApA
AGA
=A\AAffA  A{A(AA{AAffAAυAѮAəA=qA\)AAݮAQA
=AA  AAzAAzAzAAAA33ApAA=qAAAGA\)A\)A  AA  AAHA=qAA\)AA
AAA=qA=qB A\AAApAA=qA(AυApAzA  A
AB=qB	zA\)AAHA33AA
AHApA{AAQA\)AHA(AQAA33AHBA33ApAzA\)AAAAAzAQA=qAQA{A߅A݅AAٮAzA\)AHAHẠA(AAAȏ\AzAӅA
=AA=qA=qAGAAAA\)AGAffAffAA(A
ARAAA陚A  AAAAA  A
AffAA  AԣAAۅA=qA{Aޏ\AAAՅAQA=qA\)AA
AzA=qARAzA{AApA33AQA\)AzApAAzAA\)AܣAffA  A癚A=qA\A=qA\)A{AAAAAߙAzAGAʏ\AA=qAʏ\AApA\A{A\)A(AAA(AQAGA  AHA{ARA33A33AAAޏ\AzB \A{A=qA
=A(A  A=qAzA\)AffAAzAGA\)A
=A֣AٮA\)ARA
AzA
=AأAQA˙ApAÅAQAיAA=qA33AffAȸRAɅAzA=qA˙A{A\)AQAA=qAA֏\AA33AHAA\)AA
A
AffAAA{A33AAzA{A(AQA(AQAffAAffA\AAA
A33AA33AܸRAffAA{A(AABA  A\AAzA\)AApAHA\)BzA\)BzBB\AAHAGAGBffB {AQB BBRBRBBBpABAABRAޏ\AffA
AffAQAA
=AQAQA{AHAGBQAzAGAQAzAA
=A  A\)BB33BffBAQAAAAAffAA=qAHAGAA  A\AAA
ApB33B33BB	zBGBQBRAGAAGAGA
A{A
A33AA
=AAA\)AHAARAAAAzAARAAAQAAAA
AABRAQA=qA  AAApA33A(AAGAAGAGA=qApAAծAA  AA\AAAA홚AA
=AϮAυA\)A{A(AGA=qApA(AA
AA  AGA(AHAQA(AAGA{ApApARAQAAA\)A=qAA(AHARAA  A{B{AHAAQA\)AffA(AGAHAffAڣAAۙAA{A(AffA{A=qAՅAAA
=AGAܣAzAffAffAffAAA\)ApAAzAAffAzAAARA  AffAGBzAHA
=AGAGAAA
=A  AGA
AffAAAHAGAB 
=A
=A33A{ARA(AffAݙApAA\AzABB\AQAAApAAA\A  AA
=A
=A33A\B AffAHAzAffAA(A  A=qAAApA
=AۮAәAܸRAGAݙA\AAA(AGA=qAᙚAQA{AAffAHAzAA\)AzA(A{A33A\)ARA(A(AA  A
AA\ApApA(ABA  AQA=qAAzAA(A{A  AHA33AAHAAA  AA  A\A홚A(A
=A
A\)AA\BB B RBffA\)A(AffAB QAB 
=ABA\BzA=qAzAB 33A(AAffAGBBB{AARA\)AABA33AAGAA
A\B	
BB\)BBRBzB\)B{BRARA=qA\)BffB BB A\)AA=qAGAAA\)AAHARA
A
=AAAAA\AffBGBB33BpBAB
=B
=AAB B B 
B=qBB33BB
BGBB A  A\)A  ApA33A33ABffB 33B(BpB
=BQB33A33AAAA  B (B   AABRA\AApAAAQA(AGA33A
AA\A
=AABARAB 
BA\)AAAffA
AffB BQBB
BBB A
B\)AA  AQA\)BAB(B QA\)B\B 
=B 
=B (B\BBffB33BB
=BzB QAB(AAAAAA
A{AHA
=A\)B\)B\AAffAARBQAA=qB AzAAffA=qAQB33BzAA\)BpA33BA
=A
=AzApAHAGAQA\A\)BQBApA
=A
A  AAAA33AHA
ARAHAGA
=ARA33AQA
AffA33AGA\)AAAA=qAA\A
=AAAzAB
B A\)A
=B 
B
AA\ARAAAQAAffAA\)A  AAzApAARAAB AQAA\)BAAAzAARAHABzBBHBffBBB RB BBB zAAAAQARAAQAB 
AffA
A  AAڸRA
=ApAAA\AAA  AAApAffAAQA(AQAA\A  A(A
=AAzB {AB AAA{AA\AffAB RAB\)A  AGAARA33AA  A=qAڸRAAAA噚ARAA
=AA33A(AQA(AA뙚AAAAQAAҏ\A=qAGA33ApA{AAHB B\)B AAGARAA{BAAAAA=qAAzBBQAA(BQA{AAAAGA  A(AHAA\)AAARAHAA33BAB BzB=qBB pBBGBpBpBRB
ffB
B33ABffAQAGAAffAAGB BAB 33AHBB B   BA33AQAffARAzA{AHA  AffA
AAA(AHARAAApA(AAAApA  AAAAzAA(AA\)AAB
BB AAAAAGA
=AGA  ARBzApA33AGAAA
=A=qApAAffARA
=ApAzA  A{A(A(AB B=qB  BB{BB\)BB{BQAGBQAGAAARA\B 
=BBpBBBpB	BBB=qB A{A(AzAA33AAB BB QB pAzA(AAAA
=B\)BzBpBB
BzAA
=AA  AHA  A  AAGBzB
=B  BBRAAABAAAGAB zBAB  A
=A\)AQAAAAHAGAHA
=A=qAA  AzA
AzAB=qBBAzAB BRA\)BB
AB{B
A{A
ApAAAA33AABB RA
=BHBBBGB33AAGA\AAQAzAAffA  AffAARA  AAffA  A33AA\BB=qBBBA
BffAffA33A
=B {BBRA33B ffA33B33BBB  BA33B  BB pBBBHB  <B
=AzA
=ABGB
33AApB
B
B	QB	pBGBzBzB	ffBzBffA\)A{BffBBBQB	  BpB	{BBQBQBB33B
33BGBpA\BHB
=A=qB{BBRBBRBQB	=qBBB=qARAA
A  A(ApA\AGA=qApAA=qAffA
AA33AGABffB33BpB
=BQB =qB  B RAA{AA{A=qAAAAAAAzAA\)ApAA{B AA\)AGAAޏ\A߮AA
=AAGAA㙚A33AA(AAAQA(AܸRAAA\)A=qAffAυA33A؏\AABBBpA
A=qApB ffB HAHBpAzAAB RA=qABB  AQA
B 
=A33AA
=A
AHAHAGAθRAzAHAθRAυAA(AAAAzARAA\AffAB BQABGB=qBRApBB\)B\)BB{BHBffB  BHAB
=BBB{BBQBBB
=B\B\)B	B
(BBBB	GB	\)B	\)BB{B\BBABBBB	RBzB
B\AB  B B {BQB33B{BRB\B BB   BpBBzBGARBBHB33BBBA\AAzAHA  ApAAHAffAA\)B GAQARA\A33AAA(AA=qB\)BB(B=qBBBHBAA\)BGB
B  BpBApARAAQBpB zBB=qB
B
BBB  BBBGA33AA\AzA㙚A{AAAGA
AApAA=qAA  A(A\)AGApA(AQB(BB=qB(BzBAQAApBpBpA  AAHB\)ARBpB pB\B
BBB\)BA\A{A(A
=ARA\)AAzA=qAA
AzA=qA=qA
=B\)B \)B33BB
=BBBBBHBBBffBB
BQB\)BB=qAB BA{AAB=qAAB pBffA=qAAAAA(A\AQAARAA㙚AA  A33A=qAAA
=A33AAA\)ApAAzAffB ApA\)AABB{BBQBB zABGB\)BGARARBA33A\AzAQAzA\A\)A޸RA(AzAAAAAA33A\AA(AHAzA\A{B \)B{B=qB	ffABpBHB(BffB
=AApAAB(AA\AffAA\)B   AB  BB
=A33A\)AA噚AAGA
=A噚AA33AffARAApAAQAARARAAHA(AAffAABpAzBB=qBffBBBGB{A
A
A  ARA{ARA\A  A
BRBBzBBHBpB=qBAA\A  A{AGA(AQAA=qA{AQAARAAAQAffAAA33A  A\ApB BHBABBAA33AQA
=A
BRAAABBpApAB 
A33B pB QAAAGAzAQAzApAAAQAA(ARAGAffA\)A  AA
A{A(B BRA{B(BGAA\)B B   AAAzA陚AAQARApA
=AAA33AHA  A=qB BBQB\A
A\)AffA{AAQA\B33A{A
AzAAAAAzA=qARApARA
AABBB zApBA{AAAAA\A\BGB HAB pAffAHB ABAABA33B GA(AffA
=A(A{AAA{ApAA{ApA  AۮA=qAAffABAARAzAQBA\)BBHB(AA
=A=qB RARABBRBzB B zA
A
B \BQBHAAAAARARAA{AQA(A(A  A{A33ApA
=AAAzA陚AAAB
=BA
B GBpA{B(BB=qBGB(AB=qAA\)AGAAQBffBBBB=qBzAA
B\)B
=B33A{A  AQAAA33AQAAGA=qARAGAAARAA(AAzA(B{BHBpBApBBGB(BBRB  BQBGB B B BAAB\BBpA=qA(AAAARAAA33A\)AAffA\)AzAAAAA
AA\)AۅA\)AA
A=qARB (A
=BB=qAAApAAffA33A홚A\AHAA\)A
AffApApA(A\AB  BB\)BBBRBRB =qAQAQA=qB
BzB\BBRAApARAAA{A  B  A33AB =qAHAA{A33BGBBAzARB BB HAAABBpBzAAA\)A=qA\AzAAA\)AA(AAA޸RAAޏ\A(AA
A=qAGA\)A33AA=qAA=qAQARAB\)ApA
A  AffB   AQAffB B  AAAzA
A=qA33AQAAGAA\)B\BB (B RB QA{A֏\AA  A
=AQAQA߅ARARAA
=AHARARAAAHA㙚AHAHAA\AHBHAQAGAARApB QB  BApAGB B33BzARB B =qA=#
A33AB=qA
=AՙAA\)ARA{AA=qAzA\)AAA  A{A  AAAծA
=A  AffAAAffB QB33AA
A\)AB AzBpBBzBzAAB {AHAARAQB
ABGB33B AA(AAAzA
AzA(AAffAGAA  AGA  A\A\)AAAQApAzA\)AGAB33BHBffB33B A
=BBB
BQB
=BBzBHB QBBB(BA  BBzB AGAQARA33A
A\A\A\)A{A33A  A=qAAGAAAzA\)AAABffB BB {AHAA33B QBGB(BffB
BHB
B
BQB
=B  BBB\)B33BHBBB
B 
A=qA33A
AAzAQAffAGA{A  AGAAzA\)A33A{AAffA\)AApAARAA
=A(AA
AAQA  B (B
B\B\BGBAHA
=AA
=B=qBAA癚AARBB \B A\AAApAAA\)A33AAA癚AGAAAAffAA(AAffA뙚ARA33AAQBBB\)BRBHBGB
=BB(B(BBBBpBzBRA\)BzB pB RA
BBRAA=qAAAQAA\)AA  AAffAA
=BAzBffBGB33B  BB  BRBBffBBBzBffARB 
=A{A\B33AApABBffBBzBBpBzB\B33B33ARB(B\BB	
AzAB33B B33B
=BBB=qB  BB=qB
B
=B BBzB
=AGBBB  B GB(B \B (BB=qBpB
B	(BBB(BB
=B  B	B
BffB
B\)B AA  AHAHAAAGA(AQAffA  A33AffAzAA
A(ABB{B(B33BffBB(BB=qBzBBQBQBRBzB	(B33BffB	zBHB	QB
zB
\BBB
=B  BBBffB{B \)A\)AGBB=qB B \)B AAzAQA
AAHAAGA(AAAQA
BB  B
B=qBBBB
=B
B	\)B	B
QB	B
33BHBBffBQB33BffBBBBBBAB33B A33ARB  BRBRBBBffBBHB \BB
=B\B
BBGBGBB{AffAA\A(B 
A\)A33BAGA  AA33AffABBpAA{A(A\)B  BHBAAApAB
=B{A
=A  BffA(AHApAQAzAzAffA(ABHB ffA\A
=B
=B RA33AA(A{A\)A\)A
=AAB33AB
=A
ApB{BRB(AGBHBB B(BBA{A
=AAffAQA
A
=AAGAA
=AA=qAARAAApABHA  A
BB\BB GBQAAffABGBRA33A
=A(A
B {A
=AB B 
=BB(BRB ffB  AAHAA33AA\AAffA{AAAGA{AA홚AGA=qAA  A=qAHARAB B (AQB{BzB A=qA
=A33AAGB  B
=BB\B\)B{B33B
BB=qBGBGA{A=qAAffA(A
A\)AAAffA(AAzAzAB \)B QB B GAGAGAB33B BBBB33BBBRBQBBBGBBGBHBGBffB	BRBA  B\B  AA
<#
AzAAA
=A\AAA33AA  AA=qAAA{ARAAzAzAHAAzB \B 
=B GBB BBBGAGBBffBBGBB
BBRBBB33BzBBQBB  AQAA
=AA
=AA{A(A33AHARA33AA\)AffA(AB B33A\A\)AAAzA\)A  B A
AAARAGA33AQAAQ@AAB BQAA
=B {B \BBRA\)A\)AA{A홚ApApAQAffA{AzAAA\)A  ApAB ffBBzB\A{A{ABGBABBAB\B  BAGB33B A\)B
=BBffBB\BBRBAGA  AA{AA
=AAA=qB QAQAGA{A
=AffA{A
=A33A\A=qAA{ABBzB=qA\)B=qB  AB33B(BzBAA\A=qAB  B  B
B RBzBBB{B\)AA=qBB33BBpBB
BB=qB
B
BBHBB(BGAARAB B  BHB
=BQB33B(BQB{B
=BHB  B\BBB33B  B
=BBRB  B\B{BB(B
=BBB33BBBB\)B BGBpB \B B zBBffB RBB{B BQB HBzBB 33BzB33BA(B AB  BHA\AmBffB
B33BBRAȏ\A\AffAzA(AAQAA{B \)A\AA{AAffARAGA(AA
=AA\AA(A
AA  AAAA33ARB
=A\BA(AB{BAvRA}BA4(BpB B RA
=A33A(A
=A
=Ar\BBRBffBRB	B
BRBBpAAffA=qAffARBpBRB B GB  BARBB AAAHARAAp  BGB ffBA
BBffAB B(ABHB\)BBBA
AA\)AzARAGA\)A
=ABzAzA33A
=A  A
=A(AzA=qAB zB 
AGA陚A=qA(AQA
A=qAB(BpB zABpBB  B\)BABB=qBpBB33BGB
A\)BBAARAzBzBQAAB(BHBQB\)BB33A  AAA(B \BzARB AB ffB GAA=qAAHB 
=B BB  ApB33A{BzA=qB=qB33AzBBBB pAA(ARAA  AAB ffAB QBpB zBffBpB\B
=BGApAA33A\)AA=qAA(A
AB  ABB ffB{B A(B AARB
ARB{B B33A  B \)B(B  BB AHA
BRB
=BBBGARB(B=qA\B33BBBBAAGABpBBB(AA\A\AAB=qB33B{A噚AABBBB
=A=qApAB\)A(ABGABBzB {AA{B BRB{BQBBBGB33B  AB{BB ffBBffAAUGA\)AHA33A  AAzAAQA\)A뙚A
ARAA\)A
AffB \)ABAzB \BBffB\B
=BQAABBAHA\)B   BB
BQBAB\)B(BB(B=qB\B\BB AA33AffAAQAzA\)AA{AAffAAHAA{AffAApA  AQA
=A\)BGB zAA33A\AA
AffA  B ffAB HAB   BBQB\)BB
=BzB\)BBpBB  AAQARA(A  AGAAAA33A
=AAA陚A陚A(AAffApAQBAAQA33AzAAA
=AA33A
=B{B
=AAzA
=BGB33AzBffB 33B QAAAffA(A߅A\)AQAߙAA{Aޏ\AHA  A(A{AAAAAAA33AAAffAA(AAAA\AQAGAA  A\)ARAAAzA{AA33AAA\)B=qAAzA
=AffARAA؏\A\AAGApAffAARA
=AQA
AAHB
AAAAA=qA\)AAAGAAA{AQA  A  AAzA33AApAHA\)AA=qB zBffAAA=qB
BB{BzAAffAAzA{A
AGAzA(AGA
=AAA=qAJRAffAAzAAAGAA  AB
BB AAAGApAQA=qB QAffA\)BAHAAAB B(BBB  BRBQBffB  AA\)A\)AApAAAAA\)AzAAARA33AQA33BBffA{BzA33A=qA=qA\)AABARABA
A(A33B (AA=qA(BGB\)BBBpBB(BGAffAGApAApAHA癚AzAGApAffAGAAA癚A=qA(ApA\AQAGAA\)B33BB GAB GB QA(A{AGAAffA뙚B
BA
B  B33B\BBBB
BBBpAA33AARAffAA
=AB A33ARA(A\)AAHAAAAGBBQBBB=qB(BRBHBBBpBBRBBpBRB=qBBpBB
B
BB33BB
=BB	(BBBzB\B(BBGBBpBHBBB=qBRBRBBBHBA33A
=AA  BB  B(B33BB\)B	pB	QB ffBHBBAEpB
=BpBGBQBzBGBAA\)AGBB HBB
=ApA33B
AGAAQA(AA{AAAA{AAffA
A뙚A
A\A  A
AAAAAA  A\A\A
B 
=B (B   ARA(AA\AAQA(A  B B HBBA=qAGB \AApAA{A\A33A
BA{AB ffA33AAHAAA33A
=AA{AB(AA(B
=BzBBzBBB\B A  A{AAA33AAAffAAffAB A  AB
=BBBffB A{AAA=qA홚A=qA(AA  A\AA=qAAAHAA\)B   A\)A=qA
=A
BA
=BApBzB(BzBApAB AAB 
=BzB B A  BBHBB\)B
=B \)AzA33AA(ApA{AAzB ffAA(A\A
AAAA\)BBBBQB\B=qBQAffBB
=BzBQAAA
=B\)B
=@\B=qA=qA{ARBB B=qBB
=BHB (AzAA33AApApAA\AQAAzA\A{A=qA(A  A\)BGBQAA=qB
=AzB HAHAA
=AAHAffAA\AffA
A=qAAzAGAAA\AGAzAAA33A\AAQAA{AzAARA
=AHAA\AQAAAffAA  AGA  ApAQA\)BpA=qB=qBRA
B {BpAAAAAffAAHAAB 33B(B(BB   B \B=qB QB=qB33B GAAQB AA=qAAAA
=ApAffAGAApA\)A{A\)AA  AffB AAQAA{ARA33AAffB(BAAAA33AA
B pAAA
=AB B  AAzAApAffAA33ARAQAARA33AAA33AARAffAA
AAHAGARAzA\A  AffA=qAffAApAARAGAAA\)A\AzA
A  AB{B QAAAAGAAAAA  AQAffAffAGA(AGAffA  A
A=qAAA(A=qAQA33A{AGAGA=qAA(AA{ANRAzA{AAAApA\AzAAffAHAAAB\B B AAA{AA
AAGA33A\)AGAGAAAA33AHBGB
=BAAA\)AAAAHAAx  AAAHAzA\)A  ARAAGAQA33A\)A\A\)AzAAAA=qAA8AA
AԣA33AҸRA֣AׅAAיAzA  A(A(A33AA  AGAHAffAAzA
AHA=qAHAQA
A=qAHA\ARA  A=qA
=A{A
AGAA
A
=A  A  AAAAffA{ARAQAAӮAߙAAۮA\A{A=qA  AAGAAffAAffAffAAffAr\AA{A?A
=ARAR\AAffAXAAA{AڣAzAAo
A
=AָRAffAAHAzAAA
=AѮAʏ\A؏\AffAA
AffAAAǙA
=AzAA(A(AAAHA;\)A
A
A*=qA\AAׅAAGA{A!AGAaGA
A{AYAHAǮA
A2{AхA,Q@  AAAڸRAQ@\)ApApA  A
=A¸RA33A{AQARAffAAzA
=ApA=qA\A(A33AVffAyGAw
=AIAGA׮A
=AA׮AA\AQA\)AQA
=AffAˮAzAffAAA33AѮAͮAHAӮA߅AzAͮAУAAޣAAffApA=qAA
=AA33A  A  AHA{A=qA֏\A(AA܏\A{AAQApA  ARA{AA
=AffAAAQAApA{A{AHA(AAA=qAffAܸRA33AڣAܸRAAAHA
=CYA=qAARA=qAGA\)AAAQA=qA
AA33AAңApA=qAA(AffAHA\)AGAAAHA{AzAHApA{ApAHA
=B  AQB(B \)A
=AAAAA\)ABzBffBffA33A/A\)A(ApAQA\AAQAߙA{AHA(AAA
=A  A33A  A
=ApB=qA\AAA
AGA
=AAffA=qAzBzA
=A=qA홚AGAA\)A{A\)AAB 
=ApARAA(ApAA\AAARA\)A\A\)B {AARAA(A  A\)A\ARA  AAQA\)A
A=qApA
=AA\)A\)A
AQA{A\A(A  A\)A
ARA{A/A=qA@A
AAH@\AAzA\AAAffAAAHAffA
=AAAzA(A\AffA(AѮAQAA  AA\A  AGARAQA噚AAA
A=qA(ARA(AAAAApAQA
=A\)AzA\AA{A33AAAA癚AQA\)AHA{AAAA  A
A=qAAمA33A=qAܣAA݅AAAHA\AAA=qAAA  A  A33AAAAHA
AB BBpB 
AB  AA
=AAAA33AARA33A{A33A\)AGAQAA\AA@\)AA=qARA
AAA(AAzAA=qA
=ApAAARAAAA\)A\A{A{A\ABAAAA(ApA\)A홚AAA뙚A=qAAAAAAAA33AA
AzAffAGA
AAA=qAHAAAA=qA\AA
=A
=A{AffA)AA=qAAAGARAGA  AA陚@AAzBAA33A33AA\AAAzAffA
AffA{AzAAHAGAAGAAzB pApB33B QAAA
=AAAAA  AAAAAAffBB33B
B
AAQA33AAzAA
AffAAA
ApA
A<zA
=A  AHAAAAffAAAzAAAΣAGAAA
=A  AqAA
=@AA
ARAA֣AAA\A=qAAA
=ABGB33B \A  A\AHAGAA
=ApAQAA\A\)A홚ApA\A@ffAA
=ApA؏\ApARA{A(AGA\AGAA{AffAAARAGAA=qA\)A\)A
AAzAA\)AGBpB\ApB
AAA  ApA\)A(A뙚AzAޣA{AA=qAA=qAB B  B\)BHB33BQA(A33A\)B A
ABBB {BGB33B\)AHA  AAQB ffAB AQB =qAff@pB
=B
=B\BBBQBBBB=qAGAARAB GB ffB 
B33B ApAA=qBzBQBffB
=B
=BpBBHB  BpBpB
B  B\BGBB\BBBffBffBBQBBQBAٮAHBQAffBRB A\AB (AGA
A33AA\)AARAAAA{A\)AzARB
=BpBA
AA33A\)AffA
=B\)BAB 
=AAApA  AAffAAHA=qAA
=A\A\)AARAffAHA=qAAA{A\)A{ARAGA  A\AAA{AAGAAݮA㙚ApAQA܏\ARA\A
AGA{ARApAffA33AAAffA(AzAAAAA  ApAA
AAQAzAAGAAݙA=qAHAA
AQA\)AθRA{AA
=A{AmAzA=qAAA=qAAƸRAGAޏ\AAA
=AGA{A
=AHAA\)AGAA33AQAծA\)AA  AA
=A
AA\)AQA\AGAHAAAәA
=A33AυAAΏ\A=qAAA͙ApAHAǅA=qAхApAٙAA
A
=AAQAAApAHAApAAffA\)AAQAQAAzA
=AA33ApAGAA\A
=AQA(A=qAQA(A  A  ARA\A噚AՅAAݮAAffA͙ApAAzA{A{A(A=qAHAAHA\)AA33AA=qAApApA=qARA  AHAAHAAAQA
=A=qApApA  AAAAffA33A\AAffAQA(AAffAٙApAڸRA
AޣAA܏\AQAzAۅA
=AޣA\AzA
A  AARAHAAAAARA  AAQAHA
AQAB AAHA=qA
A  B{BRB
B{BQBBpB
=BBAzAA\)A
ARA=qAA܏\AffAzẠAיA\)A
A=qAAGA
=A癚AzA
ARA{ApA33A
ApAAA陚ApAAffAffA(A\AA(AAQAAA\AAApA\)A(A{A  A{AAљAffAAA  AAAARAAAQA33A=qAB{AzAB
=BB BGA{B
BQB B33B(A
=BB{BHB
=BBBBBBHB{B\)BpBBB
BQB33BGBB{B
BBQB(B{BRBB
B
BBB	33B	33B	  BB\)B33BBBBBRB\BBBBB=qBBzB{BzBBBB{B
=B=qB
=B(B\B=qBABpBpBB  BB\)BRB=qBHBBRBBBBBB  BB  BB
BBB\)B
BB
=B
BGBRBHBRB
=BBzB BBBBffB\)BB
=BRBzA
A{BQABBB BBzBRB{B(B(B=qB33B=qBB  BBBffBBBffBBB  BBffBBB\)B(B33B\B=qBRB	=qBBB\)B\BBBAAA=qA=qBQB GB   BQBBffB
=B33B
B{BBBBBHB
=B=qB\)BB33B=qB33BpB\)BBBGBpBzBRBffB B(B
B	B33BBQB
=ARBBA  AQAffAGAAA(A
A
=ApA33AGA
AAGAGA
AAA\AffB  B(B33ABB B  BGARAQB A\A
=ABB\AA
AB=qA癚AAAAܣAzAffAڏ\A33ApAAAޏ\ApApAϙAͅAAAݙA  A{A=qAApB 
=AApA
=B
=B
=BAAAffA\)AARAQA{AAGA=qA33AA(A
=BffB pA(B{A(AAQAB\BABQAB zBQAAzAHAHBABAzA  A
AARAA=qA33A33AGA
=AGAzA
=A\AB33B GA(BRBHAB33B 33AQAAAQA\BB
=B  B
BBBffBBBB\B  BpB33B=qBB  B GBApAffB =qAAA  AffARB
=BzBBB\B pB zARB B(B pB B pBBffBBHBBBGB
=A  ABBzBBBpB HBffA
A
=AB B 
=AABBGBGB
BB
=BRB 33B\)BB B 33BffB\BBzB B AffAApApA{B  A33BAAAB \B  BB \BB  B   BGBpBB B 
B (A33ARARAAHA{AAzA
=B  BHB\B\)B  B B  B
=B(B(B(BffBGA33ABB  BB33BzBA
=AA
=BzBzBBpB{B33BABHB
B \)B GBQBA  AffA\B  AAAAGA
=AA33AA(A\AAGAA33B  BBAQA\)AA(A  A=qAAAA{ApAAHA\)ARApAA{AA33A
A
AAAA\)A{A
=A
=AAHA
A  A
AAzB A\)AAHA\AffAA=qBRBB
=A
A33AHA=qAAAHAApA  AA
=A
=A=qA홚AARA
=AHA\)B A(A(AHA
AA噚AΏ\A33AARAAA=qA33A(AAHAGAA\)A  AΣA\AA=qAGAAGA33ARAffAApAARARAffAQAHAzAAAGAHAA홚AffApAHAA
AA
AHAܣA=qAffA
=AәA{A\)AA݅AԸRA
=AA홚A=qApA
=AAA߅AGAGAHA
AHA33AApA33A
=AffA
AA(AAAARA=qA=qA=qAA{A(ApARAGA  AAA33AA
A
A
AA\A{AA33AApAA=qAAQA{ARAAA
AAA  AAGAzA\)AGAA(A
AHA  A=qA\)AAA
=AA\AA  AAQA{AzAA\A\A
=ApAHAA
=A(A(AffA
=AAAB   ABQB BffAQA  A{AA  AAAB AAQA\)A
=AAA=qAAA33AA
A
=AۙA(AQA\)A=qAb\AAQAA\)AAGA(AӅA\)AAGAA=qA{ApA  AQAA{A\AzAAAGA33A홚ARAA{AAA㙚AQAA  A\)A{AHAAzApAA  A
=AA
=AAk
AnRA(AxAuAQAAaAW\)AffAzAA\)AzA
AffA\)AHAApAQAAA=qAAAAA=qAzAzApAAAA33AŅAA
A
AиRApAA\)AA{A(AQARAîAApAZHA(AA\AAƏ\A33AA\)AAAffAHBAB B AAAB =qAAAAHA홚AQA(A33ApAzA\AB QBB(ABAA
A=qAAAffA{AA  A͙AAARAAA
BAARB\B RAB \)ApBBBpARB
=B\BBB zBBffB33B{B zB  A
A\)A(B
=BQBBB  A\)B
B
A\AA  AQA\)ApApA(A33AAffAHAQA
AAAAARA33A(AA{ApAAAHA
A  A{AAffABGAAAARA  AffA{ARBAB   A(AAGAAffA
=ApA{A
=A33AffA33ApA33AٮAB 33B 33BB
=BB\A\)A{BpApAffApA\)AQA33A=qARA\)AA33A(A{AA\B
AB33BGAB33BA33B B A  A  AzA33AAAzAHA{AA(A\A
AAA
AA
AƏ\AA(B
AB GA\)B33AAffB\B B{B{AzB(B RAApAAzAB33B{BAAA癚AA  AARA33B 
=AGA
AGAAffAffA\AӮAٙAAAӮAffB ARAA=qAGAA
AA{AAGA{AA
AAffAzAAARB ApA{AAA
AB
=A\)AAA\ApA{AHAAffA
A{AA\AۙA\)AA_
=AָRAB  B	
=BHB 33BB
=BHBBzBffB33BRB

=B  BB  BB
B QB RAA{AA(A(AAGAB33B
A=qB(BQA\)A
AHAAA=qAA  AQA\AHA(QAAGAAA=qABA{BB
BBB
=BBBGBffB(B33BBB 
B
BA33AAA33A\)BzBBBffB BBB RAAA7
=A  AGAAA8(AAGAA(AQARAQB B
B{BB(B\)BBBB33B\)B (A  AAA  BBpB\AGBzBApA  BBp@QB33B{AA
=AQA\)AzA\)ApAAGA{AApAA  A(AHAABzBzB\BB  BzB QB ffAA\A\)A
=B \)B 
=B
BpBffBRBB
B{AAA  BBQBAřAAzAAB\)B 
AA\AA
=AGA(A33AAAB pAB ffB{BBpB\)BBzBB33B B=qA=qA\AAB B BQBzB(AA(B(B(B B
=A=qBQBB 
A=qAQAAAA\AQA(AAHA  A\)AffAHA\)A33AAAHARB\)B	
=BB\)BB	RBBB	BB	\)B	
=BHB
B=qBB
BBBpB	33B
pB	{B\BBHBpB\)B RBBBHAB RBRB 33BQBQB(A
AB HB ffAA
=B B=qB zAA33AB
BBB=qB
B
pB\BpBffBHB
\)BBRBpBffBBB\)BBpBzBBB	
B	ffARAAAAAGAA\AAARARA=qAB ffA{ARAB =qB=qBHBB33B33B zA\BzB{BBpBzB\B\)B	
=BB(BBRB	33BB	ffBpBffBzBBBBRB{B=qBGAB{AAGB ffB33AGBBGB \)AApB B RBpBQBffBBGB
  BBBBB
=B{BGB=qBGBBBBB{B	  B
B	  B
BGBB\B B	=qBB=qAB A=qBpApBHBQBQBA{AAAApB B{B
B\)B(BQB	(BBBQBBBHB	zB	pB
pB	B33BRBBffBB
B
RB
B
B  AA(BBQB\B	  BQB \A(AAAAAAHAAApA{AffA{AARAHB BRB(B33BQB  BB =qBBB	ffBffBB
BB	\)BBHBGBQBQBBBA
BBHBGBQBBHB B(AGA=qAGA=qy @)@p@$z@{@
@@\)@
@"\@"\
@%@"\@\)@'
=@p(@@z@ @(Q@@@@33@@=#
@@G@z@@@=q@$z@"\@#33@p@P  @L(?@=qA\@ @hQ@@@=p@2\AzAp  A7
AlA(A(A\)A@p@
=A7
AG
A?AV\Ag\)AYA;@AHA$  C{RAH  A#
A9A(  A\)@@U@L(@\@S
@\@H@33@@@}p@tz@(@{@@p@s33@ff@
=@Q@QG@5@&ff@R\?\)@#33@@"\@ ?Q@"\@N{@i@(@z@33@p@j=q@S
@(@.R@\)@"\@'@
@2\@@+@33@@@B\@HQ@Q@A?@R@6ff@~R@@@o\)@@z@1G@\?У?R@
@G@*=q???=q?@7
=@XQ@*=q@?(@
=@33@(?33?=q?Ǯ?Q?  ?H@
H?33@\@H@7
=@-p@6ff@;@Vff@hQ@??@\)@R@@{@ ??\!G@
=q@
=@ @ ???  ?G?H=p??Q?Q?ff??H@ @(@G@R?(@@@ FD6f?p?  @G@Q@
?޸R??@\?p?z?{?=q?????G?R?G??H?(?Q???@   @?ٙ?Ǯ?p???33??z?p?=q??\)?У@
H@z?G?\?У??????Ǯ?  ?\)?{?  ??{?˅?{?Ǯ?{??8Q?Q?R
?{?ff?ff??{?33??{?У?H?33??33??\?p?R?\?{?\?\)?˅?\?
=?p?p??=q??p?ff???=q?(?H?{??z?33?33??\)?
=??k??=q?ff?H?z?{??
?G?\)?\?ff@?H@\)@(?
@   ?
=?
=???p?p??  ??
=?
?\???=q??
?z?G?=q???\??H?
=?G?\??R?G?^R?W
=???\?ff?{?W
=??\??ff?(??H?p?{???s33?c
?G?zH?ff?
?Ǯ?R??33?=q??(??
=??Q????ff???\?Q?333?E?\(?h?s33?^R?ٙ?W
=?J=q?k?=q??u?^R?c
?zH?:H?J=q?0?L?\)?\?
?p?\)??R?  ?
?????  ?fff?c
?\(?L?R>Q>\)=L=\)>>p>u>#
?+?#
?\)>?
=>
==\)>Q?u>{=G=>#
?
=q?5??>>?O\)?xQ?=q?c
?Tz>?>ff>H>H??z?8Q?\)?
=>(>z>>>.{>z?
=?\)>Q>.{<
#
>z>  >=L=G>W
=>33>\>=q=Ϳ5#

#
#
#
ͼ
=Q>.{<=ͽ;B\k\)G=>B\>>R>R
=q=pB\LͿ(þ\(!GpzzGYGhÿQ녿zH
\(xQW
=kGY33Y{{Q쿕Hn{Q쿊=qu5kffffff}pǮ׿(\)33zῺHRͿQ쿏\)(RR=qHffD)
\)

(z	
=\	\)!p({p=q  '
=Q$z%*H,<(?\)8<(:=q>R@JHIULG
=JHHJ=qK<(?\)>RC33IGR\L(QGINRTzXQ\]pW
=QG\_\)`  ]p`b\`  `S
X\S
S33W
=W
=hQe`dzmpj=q\(`wx  \)`[=pEzῆffMp,ͿQ\)׿\)kap*=q\) -p˅!Q?R?Gs33(   >#
=G  CRXekxQzHzHyuZ=qQ`J=qp
fff\>G?\)@@{A4(AaGAmARffAR=qAX(AQAAHAB pAGA  AGB"\)BA=qA{A\A=qA"ffA zAzA33@Q@K@>{?z@k@@33@H@GAhQAc33AAHAA|QAMpABHA8@H@@@ @?=q??(???333?   ?\녿\)p׾8QǮn{#
??O\)??Y(@iAA=AMAA=qB  B5
=B/QB(BB	33A33A
=A
=AA\)AgA=qAxzA{ATQAN{A @33@p@@@Q@@Ӆ@\)@@(@A8  A{APQA,AffAA  AAA=qAzAGAApA  AYAffAA{A_\)AxAh  ASAHAoA\)A
AA;\)A+AA\)@R@θR@Q@
=@@@p@K??G#
Ǯ@Vff?(?aG?}p?E>  =u???  >(<
zῘQhÿ
uR=q?   \LͿkG\)Ϳ{ÿ\=qQ'
=QffQ0=p1FffD]q:H>{:H2\\)
HffffpQ
pͿG޸R  ff{(5<MpDzͿ+;1$z+1GC
\) \
='G333LQ_\)\^{l(^R]pj=q\(`  GS
eL(1
=%"\ffp7,(7\p
=q0  KUXQ]pQG'
="\R*=qC
10#33>{G
=PP  =p>{JHR\Q!Q4z]pL(UR\PPhQl(ehP  zE57
=333:H@  7
=7;GP  VffFffDzN{HQ5C33W
=IZHZH`  [H6ff7PNRS
VffHL8QS
FffAGaGl(`  XXHQE-p03
?\)7
=J=q>{Fff<N{TzTzIC
H4z2\Q#33JH+\`G
=^{gn{ec
Z=q\(hQP  C33AFffa\JHPO\)YXPN{YJ=qS
W
=PP9GG'
=>{HQ4zB\ZH`  [\(\(XQ^{\(Z=q_\)dzXULE\(N{-pAG\).R1G7
=G˅\)  0J=qNRAGÿ  ?ff\)>{?^R??p׽Q}p.{$z(ÿ33	p; H:H;G
=/\)(2\GDz)Q'9!S33)8>{HQS33Z=qR\=p333Mp>{>RKJHA'
=%\)ffQ<(%#
D%333,E:H81G0=pA;:H@  @A333?\)C33L(<(.Rp*=qS
C
@DzP  S
NRX[UW
=@MpL(6ff0  338=p333#
98Q0  <C
1:=qJ=qE@HO\)XQ\XQP  Mp.RG\\,(<>{AHTzQX]pZ=q^Rc
`  ^{VffS33YP  S
QGUG<((ÿC?\)C
JH74z5<(53
HQ>RA@  KGMpG
=MpO\)P  ZHG@7
=3
0  8Q쿰DzFffS
Mp\(ES33N{XQR\R\LQGQGP  AG8QDKu:=q78Q8Q56ff?\)E>{AGC
C
QVffXJ=qMpTz>RB\MpO\)qGC
P  DxeS33N{PS
QGP  QR\P  LPO\)N{P  O\)EHQAC33G
=<HQFff>RMp@@  NRFff?\)B\AG<S33KHHN{PL(LL(O\)QMpLJ=qKN{W
=E>RQGZHKUI<C
DzHQFffS33NRO\)K@  =pDs&fJ=qC9HP  HQE:HD{2\KDz?\)E4z,')0  '-p00:H@  J=qGHN{O\)JHJ=q?\)B\DzFffFffGE>R-p=p5AGC33J=qIDzE{Ǯ

=16ff.R7
=C33@<@@8<7
=:H5.{1G1G1G8Q7
=<(74z?\):=q.R4z54z58>R>{AAGADz;873330  9:=q882\,(.R:=q8Q>{;5<(3
=p:=q76ff6ff1G"\%"\!G%)*=q&ff'*H0  1917
=78Q8Q7
=8Q57
=5,(82\("\$z(,D0.R$z*H.R*H/\)+1-p333-p/\)10  ,,($z),((%#
(Q$z%   )0  50  '
=,.R1.{)-p*=q'!,((#33*=q('++(Q+/\).R*=q/\),(-p.R,,(*=q%,'
=)-p*=q*=q,(*=q(Q(#
#33&ff#33$z"\%&ff("\!#33#
$z!$z%   "\R   (1l!!"\|(k}p&ffx)%$z@  p   #
$z($z!G! Q!G!''
=&ff"\R"\"\ %"\ !
=qC
l(\)pQQ
ff=q

=((ffz! H
="\H!&ffpp   "\!G     	
HQ
p  33
=z  
33
p33RHR 
   
p
=qGR녿
=
=\\(HzzGR7
=   Q   Q{\){R
 

=ÿ޸Rٙ˅H녿G׿z녿녿޸R  "\׿  pQhÿͿ\(ÿ=qÿ\ÿG
zٙ녿R˅ͿpffpͿ3333\\(=qHp\\)Ǯ{GQ쿙RffpÿG33ǮͿ{HHͿ\)\)  33G{=qͿ
=-p:HaG\)ÿp=q=qÿͿRУ׿
(  녿\)׿\RͿGG\)\Q쿼(녿˅녿Q쿷
=ͿpH  
\)R  Q{ٙ녿
GHٙz(ٙR33ff  \)녿\)GGpff33녿     Qzff=q׿zῙp
=Ϳ{\DQHͿ׿H{D渿(
=׿=q녿녿z  z῾Rzῳ33{zῂ\

=33c
0׿n{8Q쿞R׿z῅
=ÿ
ÿ(ff
=ÿ\)B\xQ?=qpͿ녿=qff  >{녿p{ÿG׿=q33׿pͿHRz!G\\Tz:H&ffzᾊ=q=q=phÿ(\)녿  
J=q{fffff@J=qLͿ
녿zHͿffJ=qÿff\)\z῝p33p׿c

J=qW
=aGs33z
=qHJ=q8Q+W
=Q333J=qGEhÿQ녿C!J=G^RQ녿\kG#
kY8QYTz8QYuu
}pE^Rs33fff0׿G8Q쿏\)\(=pLͿc
xQ}p
\(kTzp׿uTzfffW
=fff=pͿR:H333׿녾H&ffzHaGxQLͿ0׿Tzc
LͿ.{:H33G(ffͿ@  8QTz\YJ=q&ff&ff!G@\)녿녿\Ϳ녿ÿ   
=\þ;B\.{RTzQ논;>ͼ#
#
k(!G@QG׿\
=Ǯ׿
=
=(녾Qffu>  >  W
=׿Ϳ++C
=
=q\)G녿녾\GB\W
=  #
\)#
G<
>aG>R    u>.{=Q?333?
=>Ǯ=#
(>33>H?p>33?녽L>  Lͽ#
Q=Q.{#
>Qu>=q?=>aG=L<
kB\RaG{HaG33\zᾮ{녾aG
=q
=q
=\G333녾p
=
=Q>B\?\)?B\=G>׼
=
=q#
uz#

<=ͼ
R=#
?R>z\)
\u<
<#
GF    L;
=ffǮ
pff
=q#
  >B\L;8Q콏\)LͿ\)!GYn{5
=qHH@  z(   CGHQ;녾  \u33GkRL;uÿ\=p;HH׾ff\\)=#
=G=\)=uu>.{    =<
=\)F=Q>W
=Q콏\)uL;  W
=#
.{\).{aG\)    =L;BG=;33=qD8   ;W
=\)=q#
=L>8Q>aG>B\>>.{>\)GG>aG    \)u<#
aG
=QuR=qR#
#
uL;>aG#
<8QG;.{L;kQ콣
L;8Qu33p녾\)kRp;\Q(
;#
8Q=\)>aG>=GL=u=Q>B\=
L<#
G  =\)uL=#
=
W
=RL<=q<>\>?8Q==>\)>8Q>R>{<>B\>>Ǯ>
>aG>Q>p>k=u<=\)>#
>z>?
=q>Q>  >=>p>\)>>>>Ǯ?>>H>>Ǯ>>33>ff>ff??(?(?\)>>?(?#
?.{>H>>\)=\)=L?
=q?E?5?+?:H?L?:H>>?   ?=p?0?(?E?O\)?\B
D(?E*?\>G??!G?G>G>=q?z?>=q=L>Q?333?:H???:H?R?\(?.{?333(Q>kBֳ3=Q>#
>{>ff>R>k>aG>>>L>H   >   >(?(C>k?GQ?@  ?333?J=q?E?=p?G>#
?Tz?E??u.{?&ff?(?+
=qB\?LͿTz??+>=q?R;   
=>{>  
=u?c
?\?\?{?\)??Q녿+?Q녿\)>ffz?&ff??B\?}ph?(?A"ff>=??=q?33?p???(?z?zH?:H?{?xQ?
=?>B\>L?0?\)  =L>?   ???G?h?(?u???E?33=
?(ÿ&ff??p??(?
?
@33@?\)@
?@:=q?
=?p?H??У??G?
?z?У?˅?c
@p?H???(?Ǯ?ff?p??z???Ǯ?(=
??ff@ff@ff@5?G@>{@
>?>
?ٙ??G?{?=q?=q?p??ff?(D%?Ǯ?˅?  ?R??fff?\)?
?{s33???þ  ?Q??  ?ff?n{???Hff?>R\)33>33?G(?G@
=qu?xQ?z???{B ??R>?ff?ǮQ?У?ff?޸R??
D)LE4
?H??
=?(?
=?(<#
?z??R?p?zH?\?&ff?Tz\(H?z<#
?
?p?޸R?@?&ff@ ?zH?p?=q???\)???H@Q@R?p?H?˅?(?z?z??G??G?R??pBBN
=@|(@@33@@@p@@@@  @@  @@@\@33@G@
@@z@(@
@R@@DٚD(@(@ʏ\@ʏ\@H@
=@(@=q@@@
=@@ff@\@ff@ʏ\@ȣ@
=@p@@z@@ҏ\@{@R@p@=q@ə@{@G@p@=q@R@ᙚ@߮@p@@
=@(@@@\)@
@{@Q@G@@G@G@H@@
=@{@@Q@Q@@G@z@@ff@Q@\@Q@@G@=q@@@z@@ÅBR&ff@@J=q@(@@@@@@Å@G@@p@ə@  @\)@@@ff@\)@@@@@@33@@@p@\@@33@\@Ϯ@Q@@{@θR@H@\)@Ӆ@\)@H@=q@ff@
=@(D)qH@$z@@H@
=@\)@˅@p@@{@@p@ff@R@@ff@ƸR@˅@G@@H@{@z@\@H@ƸR@@{@{@  @@Å@ʏ\@@\@z@(@(@@
@\)@R@ff@@z@ff@{@  @Q@@@\)@Q@z@(@
@H@@33@@\)@@
=@@H@z@=q@z@
@(?s33@=q@?Q@\@Q@{@@H@@@  @R@H@@@33@(@@  @  @@\@\)@@ff@(@p@ff@\)@
=@z@=q@@ff@@ff@@@@@
@Q@ff@p@@@@p@
H@  @z@@@
@\@G@@p@33@@
@
@p@ff@Q@ff@@\)@@@
@@G@33@\)@@33@\)@@
@
@@
@G@ff@@p@H@z@@@@Q@\)@@@H@\)@R@p@@(@\@33@33@@z@@  @  @@@  @R@(@\)@@@@H@W
=@+@,@/\)@"\@.{@/\)@'@ff@)@5@3
@n{@]p@aG@Tz@U@g@P  @i@JH@Tz@R\@>R@A@J=q@L@N{@Fff@_\)@h@B\@^{@R\@QG@Fff@?\)@L(@G
=@>R@L(@W@K@G
=@L(@R\@^R@JH@I@R\@]p@aG@fff@b\@aG@r\@@@@|@qG@l(@g
=@o\)@\)@y@g@~R@k@x@p@zH@mp@s33@Q@\(@{@QG@c
@e@L@hQ@Q@s
@p  @b\@^{@g
=@`  @Y@=p@JH@JH@L(@Mp@Dz@`  @jH@a@;@XQ@S33@Tz@c33@P@U@Tz@P  @Tz@U@\@_\)@O\)@G
=@`@`@I@Q@Vff@U@\(@`@W@L@X@aG@G
=@`  @_\)@b\@QG@g@e@ZH@k@l(@n{@b\@c33@`@e@i@j=q@e@]p@NR@S33@NR@U@W@]p@XQ@b\@aG@I@K@h@g
=@r\@nR@l@hQ@^{@b\@^R@fff@e@jH@nR@g
=@a@s33@hQ@c
@o\)@hQ@e@b\@h@_\)@nR@e@`  @g@h@i@\)@u@33@@p@s
@Q@s33@g
=@a@c
@_\)@Y@Tz@dz@XQ@]p@e@fff@`  @\@S33@U@X@Z=q@Z=q@a@[@Y@^R@NR@R\@L@Y@b\@P@X@h@`@U@]p@Y@fff@XQ@S33@U@X@e@fff@b\@@q@]p@ZH@L(@aG@aG@XQ@N{@Tz@L(@H@NR@\(@Tz@Tz@_\)@_\)@n{@o\)@dz@W@K@E@H@>R@5?
=@8Q@E@@  @B\@>{@P@333@333@P  @7@I@JH@@XQ@n{@c33@jH@G@,@3
@:H@1@>{@>{@6ff@4z@<@5@8@=p@=p@<@C
@?\)@?\)@=p@@  @Dz@:H@0@8Q@8@7@L(@R\@G
=@QG@@@E@>{CH@A@H@9@E@?\)@:=q@JH@A@7@8Q@E@6ff@<@<(@Dz@>{@J=q@3
c
@I@E@@@??\?p?\)??G?R?(@?ff?\)@XQ@E@33?@@??@+@>R@.R@7@A@B\@%@#
@?\)@AG@NR@?\)@6ff@,@#33@!G@%@+@*H@(Q@&ff@:=q@A@*=q@@'@0  @p?=q@G@!@@@=p@   @
=@@%@@1G@&ff@Vff@6ff@@  @\)@ @?
@+@+@'@R@333@33@ff@@I@@@z@@=q@33@
=@Q@(@
@?p@
@
H@@@@#
@@Q@@
=@\)@@@	?33@R@Q@33@!G@ff?\?ff@33@(?R?@G?ff@\@
H@G?R@ff@ff@z?p?޸R?????Q?
?@ ?33?  ??33?
=??Ϳ?
??þ.{B\@  >=q>R>W
=>B\=u?L<#
??\??\?@  ?:H???z?p??=q?ff?  ??J=q?Y?8Q?0????(?@y>?+?.{?(?.{?s33?!GDF?333?:H?333>33?.{Lͼ
{Q녿TzffY
>8Q쾏\)8Q>     =
>p<=\)<
>\)>?>.{>Ǯ>W
=<
=
?=q?#
??Q>33??G<  \)Ϳ
=q+Gp׾Ǯ\(ÿ8Q!Gff{n{G0׿+!G
=B\:H>@  
=(ÿO\)W
=^Rfffu&ffTz333(þQ
=
=Q\Y^Rp׿J=q@  TzQ녾H(RuR33333:Hu\(\GG
333}pc
Q(GxQ쿏\)׿n{
}pÿHO\)\)33ff(33{ÿEQ녿LͿR(
\\\
ÿ`  MpÿQ쿞Rz῵ff{z(
=ٙ޸RGff{ff녿޸R׿
=
HG녿ffzp33녿  {녿{ÿ(GGl(˅Ϳz  \(˅\)Ϳ
Ǯÿpz῾R  
=
={
  z?3333{
=p33G  
=33   \Ϳp\ ׿=q33Kffp޸RzD#У׿˅=q33=q\:=q

Hn{\)ٙGGxQGG
=׿{   =q׿Gz   RffQ
=qzRG\)=qz

=q	(p   z
H{\)R	׿\)uG'0ffRHp{%{{*H(\{
=qQG
HG{˅R\
GQ33GEF.{?O\)?33R?p@W@H@@h@P  @Q@|(@B\@5@أ?33?@@Q?n{?8Q>
>k?J=q>#
#
@G@?\)=W
=J=q
-pQ쿷
=,k
=?O\)@@z@=q@@  @p@<(@B\@jH@H.{Bf@5@jH?#
@@p  @P  @H@P@*=q@[?@H@2\@QG@,(@  @Q@
p@*H@C
@5@Q@@  @GDθ@@NR@7@>{@4z@1@  @(@+@9@)@0@'@(@p@ff@   @R@(@
@@Y@'
=Dq@$z@*=q@&ff?33?ٙ?{?@?z@
=@@  @G@\?@#
@R@\)@@@@H?@@  DC@Dz@5@<@5@8@.{@
@6ff@4z@0  @)@'@(Q@0  @8Q@.{@=p@=p@:H@@Z=q@ZH@\)@Tz@@Q@@H@ff@p@G@xQ@@\)@ƸR@߮@G@L@G@=q@{@
@z@x@(@@θR@=q@=q@@\)@6ff@@!@
p@0@!G@.{@/\)@&ff@@
@-p@I@ @H@vff@Y@;@E@Vff@7
=?(?\?(??ff?z?G??\)?ff?G?u??
>
=?  @
p?
=@(@@R@$z?@\)@\)@#33@\?(@=q@?{@@\@@(@R@p@R@@R@@
p@@R@\)@@?Ǯ?33??&ff>#
?Tz?Q??z?޸R??\?H?Q?H?ff?k?  @33?\)?=q?ffBQ@$z@@{@
p@G@	?R@@%?z??(@ @z@  ?R?ٙ?{??(??{?{??H?\)?Q?z?=q???k?L??n{?fff?5>R?(?\)?^R?=q?#
?R?33??{?  ?p?33????ff@  ?˅???
?{?{??Q?QEC@R?\?(@?{??У??  ?\)?0?.{?}p?G?}p?{?>=q>.{=u>G>L?\)?.{>33?c
>Ǯ???s33?W
=?z?H??(??=q?33???L??ff?\?G??\)?
????(?RCo\??z??Q??h?(>=q>B\?Y?R?@  ?R?c
?h?c
>=L?^R    R>R?=p?\(?E?}p?33??{?R??{?(?Q??ff?{?
=???  ?33?  ?z?\?p?
=?333<Ǯ8Q(=\)Ϳfff
=q?G>L>ff\)up><#
=L?z>aG>L><
>(>ff?@  >?!G?&ff??!G?Y?(?(?O\)?@  ?8Q?@  ?333>G>?&ff?z>G>
=>k?(?fff?c
?ff?.{?8Q?W
=?Y>>H??Q??!G?z??s33?Y?h?zH?Y?O\)?h?J=q?  ?aG?^R?ff??33?ff?{?zH?  ???\)?Q?}p??^R?J=q?k?J=q?O\)?B\?\)?xQ>Ǯ>>p>Ǯ>\)>L=u>>=q>zL>8Q#
s33>Ǯ=\)QǮ=#
=uu    8Q쾸Q<
?\)?z?>H?333?>L<
>\)>H?>=q>>Ǯ>Ǯ>p>=q>
>Ǯ???
=q>ff#
k>#
Ǯz    Y\)=>L>>z>W
=?>z=Q    ?\)?\)?
=>  >ku>z>>
>aG
>z>L>\>>aG?G?(>?\)>(A>Q>R=G=Q>8Q>8Q??G>?z>>#
>L=Q=>>=Q\)>u>Ǯ>??:H?W
=>Q?\)=
>.{.{>k>z>\>W
=>W
=>{>k>k?
=>>R>
=>z>.{>>>L>=>Ǯ?xQ>(?   <#
uLͿ+H\H   
=:H+@  LͿ8Q({8Q쾙
=녾\GǮp
.{ͽLͽ\)<
u׾
<
.{
    u33p
=\)H\\33Ǯp   H\Hk=q녿   8Q   p׾
=
=Ϳ
=      
\׿z
=q=G
L;L;\W
=zᾅ=qffGHffp
=B\=p^RY:HO\)0׿zG+F>vͿͿ#
:H:H!G.{\
=Rn{p׿ͿHxQfffG}pW
=s33\녿녿33Ϳ33ͿHs33k    33H{\
\)=p\)G
=˅\=qp\ff
׿ͿͿ
=׿R׿p33Rpp(z´ppͿQ녿:H.{5@  G.{p׿=p@  :H(=paG33˅33p33Ǯ׿G  G{G׿G=qÿǮQ쿬ͿQ쿽pGͿ=q\  \p\)GRp33\=qÿ녿У׿G  
=qQ쿬Ϳ  H
녿\Ǯp(ffQp׿\({z῜(R
==uHͿ9(녿Ϳ\)RR(ͿHR
=\)  {\   ޸R=q33  \)Q쿵\z(GǮ  Ϳ=q޸R?  zῼ(  =q
\H녿Q
H
(33ٙff
=q\)
H
=ffGGffG33
=Q\ÿ=q=q=q?.{33p33\pffp
%z6ffQ
Q(33=qR+,,7
=2\*H=p0  .{/\)59B\9B\Dz0  @9;3
<<(5[C
?\)EFff>{GUUUR\L(HC33C
<(0aP^{`  c33^RZHZHS
S33P  @LW
=^R`  ZH[[_\)c33Yw
=U^{^{YB+(TzUNRTzXQ\wahQhQg
=`  a[W
=R\\(``  adzhQ^{agfffKp)!Gÿp,!G0<0  HC#7`  S33qGdzb\c
]p]p_\)aGaGZH\`  `eZH^R[EAQW
=^R(QGc33g
=51G.{Uec
ehQfffhQg
=iB\*H@8Q>R?\)z=q[`  s
PZ=q>{57
=Dz>{`  C
G>R?\)HFffHQULMpVff\)NRL(QG\S33]p\Q6ff(Q?\)KTz]pYXQ^{WP  Mp`_\)Qel(^Re_\)XQaaGZHKWS33G
=S
3
EES
R\S33S
LJHPR\L(MpEI@U[YaG`a\(VffJHVffX\PC
P7
=A@GMpP  QLMpS
W
=[[[^RXQQS
R\S33R\MpJ=qHC
DzG
=HL(KS
US
QGP  W
=US
_\)aG]peee\(\]p\?\)@PK`  O\)UWS
W
=AUUMpN{PQGNRS
QPMpMpN{H@  AC33EH4zNRGL(MpN{UVffZHZH]pUQGO\)C
G
=;IEC33QJ=qRHKIIL(II  L(N{NRHQ_\)J=qGKGEGJHEQGP  QGQGJ=qHO\)G
=Tz@<(S
W`  ^R^R\X3
LP  QMp{QTz\)O\)N{jHC33QTzO\)?R\O\)\)P  NRPO\)PJ=qO\)LO\)PzMpP  IN{W
=QS33S
UQL(W
=\(DzPFffP  G
=GQAG8>LIHQNRJ=qL(ZHGc331>R
=C33INRO\)NRR\zHR\(>RC
C
LGEAIGE?\)EJHGAHQDz>RAGAEw
=gQC333
16ff@  4z;8Q0  &ff4z<7
=\7.R3
/\)tzr\A53
8Q4z/\)333<(>{@@@B\EC
C
>{7
=79>{7
=86ff52\@1G55?\)1G:=q8Q703333
6ff{7^{8(52\3
b\-pa%CX^333,5.{0  1G53
.R4z3
956ff.R000  ,({'}p\)%RR\)'
=!zH"\ {{pp=q\)QpE\)8Q!G\H(\)#
\)!ff
pR
=R#33HRQQw{>7
HG
=z
=
=
\G{
RR
p{
HzG{{
p
Gffz33  \){
=q\	33
=q
H  @@=q@33@H@@@mp@p@l(@`  @Y@[@W@W@`  @W
=@Tz@Y@ZH@g
=@hQ@`  @c
@]p@a@W
=@S33@S33@W@S
@O\)@NR@S
@O\)@s33@dz@jH@l@hQ@q@q@q@k@k@c33@g
=@c
@e?Q@ZH@]p@XQ@U@Vff@W
=@U@W@S
@Vff@\@\@Y@`@\(@^{@W
=@S33@K@L(@Mp@G@J=q@H@S
@\@X@Vff@`@XQ@[@W@Vff@P@J=q@L@NR@W
=@X@Vff@]p@c
@`  @U@L(@G
=@J=q@Tz@XQ@Y@XQ@[@aG@]p@\@\@[@Z=q@[@`  @a@l(@c
@b\@c33@g
=@c33@\(@aG@g
=@dz@c33@`@S
@_\)@Y@XQ@Q@ZH@`  @[@QG@X@jH@P  @Vff@J=q@fff@K@`@Y@E@E@O\)@L(@JH@R\@W@S
@X@Mp@P  @P@Mp@J=q@H@J=q@G@E@L(@P  @P  @L(@U@L@P@L(@@@B\@:H@8@C
@:H@:H@XQ@@  @JH@W@Tz@N{@A@N{@AG@=p@K@I@P@J=q@HQ@=p@?\)@E@C
@Dz@J=q@Tz@U@Q@K@Vff@^R@W@fff@o\)@P  @K@I@Dz@E@Dz@G@C
@@  @L@@@G@JH@H@L(@P  @L@JH@E@Dz@HQ@N{@L(@JH@C33@G@?\)@B\@E@G
=@Mp@Dz@C
@AG@G@E@C
@AG@G
=@>R@:H@7
=@5@8@8Q@4z@.R@.R@2\@5@9@?\)@:H@:=q@:=q@5@4z@5@0@2\@,(@-p@-p@+@,(@,@-p@/\)@*=q@2\@1@1@.R@7
=@2\@3
@1G@-p@9@5@333@6ff@2\@1G@6ff@,@AG@7
=@5@6ff@5@0  @333@0  @.{@G@0  @,@.R@333@1@7@:H@1G@3
@7
=@.{@3
@/\)@-p@&ff@ @=q@@Q@@Q@ @'
=@1@0@0  @0  @,@*H@#
@*H@'
=@$z@$z@%@,@1@,@(@,(@-p@)@*H@(Q@%@#
@(@%@+@+@{@+@'
=@$z@@(@=q@@
=@@@33@R@33@@@@
=@@
=@@Q@$z@R@=q@
@{@@@@z@@@{@  @ff@&ff@!G@R@
=@@  @@33@G@\@
@@G@
@@@@z@
@{@\)@@@
p@
H@(@<(@!G@{@>{@@@@
=q@@
@G@ff@@,(@ff@\)@'@@@@G@
@
p@@	@@
H@
=@ff@Q@@@@	@z@(@
p@
p@(?H?R???@H@???A1p@R@G@G??Q?33?(@\?R@
@   @
?@
=?p@@   @\?p?p?Q?z?{????=q?\)?\)?\)???
=?33????ff????\)?ff?(????\)?H?(?
?H?Q?
?ff?(?p?ٙ?
?Q?޸R?޸R?
?ff??
=?  ?z??Ǯ?\?G??(?R?  ?  ?G?
???R?Q??33?H??
=?33??\)??H?fff??Q?????s33??H?=q?zH?Y?L?W
=?E?@  ?O\)?fff??L?333?:H?(?!G>H>ff>???\?.{?#
?0?J=q?G?>k=LͽLͼ
=#
    =L>B\?>=G>\)?>H?=p>
=>=Q=>=q<
\)>z>=G#
8QLͿz\\)kppGQ쾮{   \)(ÿ\)\+(z녿8Q=p#
R333@  Tz῎{}pEB\&ffff  p(.{uGn{\zH0׿5hÿ=p
=J=q\(khÿLͿEB\\(uzῆff}p=q=q녿׿(Q׿{p녿((G녿H33녿\)H(Q\R˅
  \)˅=qQ(ffffff\)pR
=G
=q	Q
H  33\     pG
=
=zÿzῳ33\)GRQ
=Q#
1G>ff$z-p5&ffzQ(*H,7,(Q'{z   33G
=
@
=q33z/\)H{"\'
=\)   3333
=q*=q!\)   .RAď\#
&ff%*H*H/\)
=\p\)!G!
={\)(*H9
NRG ׿׿p   
    H
=q
   *=q
=q-p<(XJHMpJHKYNRS
WE2\,O\)S
NRQW
=HQC
C337
=ADz>Ro\)QGQG7$z8Q6ff-p(QH/\)J=qL(  R.R(1Fff5/\),IfffO\)G
=c33c33
c
h}p@\ze|@RKY?\)JHFffAG6ff6ff02\R\E-p>{HQ
p
=q\P'p)0  .R'
=)%>{
=LfffP  /\)S33@R\ll(N{U\(US
HDzH;B/R<;6ffp%HGxQ\(7UXQAER\hQTzL_\)PHQ]p@z@E?D@\)@33@@@Q@@=q@\@@@33@@330@
@G@@p@
=@{@b\@fff@<(@@@
=@H@@  @Q@@Q@(@
@\@@G@?@33@{@@g@@@@ff@\@@\)?Y@H@@=q@{@@@  @G@@ff=G@@\@p@{@@@@ff@@=q@@@
=@  @z@@@(@@  @H@@@G@\?33@G@@@@@\@Q@@\)@(@33@@p@R@{@@\@33@@\)@@{@l@@  @33@z@p@\@@\@R@@@\@=q@tz@nR@hQ@}p@z@
@
@@x?^R@l@NR@c
@n{@>R>>L@@dz@R@{D@33@@@@  @l(@H@@\)@HQ@
=@@=q@@Q@@=q@
@R@G@ff@(@p@@{@@(@G@@@@\)8Q@@@Tz@H@{?333@׿\(@A@@p@!@{@\)@@@\)@@q@@@\@z?Y@p@@Q@33@z@Q@@ff@G@@\)@
=@Q@Q@l@@s
@Q@{@(@\@@>zn{@@k@H@z@@@Q@
=@33p=.{@\@Q@?@c
@  @H@p@zH@  @z@w
=@33@33@33@~R@xQ@}p@Q@H@=q@@G@@@@@Q@ff@  @@
AR=q@@<(@jH@`  @r\33@Tz@o\)@33@XQ@X@p@=q@l(@}p@XQ@
=@=q@@w
=@p@<(E({@@@I@@  @5@=p@c33@jH@^R@H@W@ZH@QG@O\)@S33@Y@W
=@Tz@X@qG@dz@nR@S
@JH@u@Y@\@Y@ZH@I@dz@]p@mpz@n{@Tz@@@:=q@<@2\@7@8Q@;@1@6ff@7@2\@3
@>{@C33@ECZ)AQ@6ff@'
=@(@p?
=@%@5@@@9@*H@@@(@33@\)A_
=@  @@z@  @
p@ff@
=@33?@33@\@  @
p@@	@
=q????=q??ff?  ?ٙ?H?˅?\)?
(??(????R?z???u?\(?#
?   >
=>R>u=u
\)B\(
=׾Ǯ;G\(   \)\(\H
=\\)
zͿ޸R?(Q
H
p\)Rz
=ff
=H ')/\)53331GMp3
@NRQ8QMpL(B\MpQG[^{>RDzQG=pW
=Z=qUS
UYg
=p^{p  j=qn{\)`  l\uvfftzqGvffyh[dzvffMp]pS3333Dml(qGdzulus33HGo\)x  R  |(zHIqvffaGepnRtzs33zHp  tz\)ufffs33xQ\)e~{{\xQ\)%G|(zHz=q|u=qzH~{  {zHwwu  p  \)tzuVffs
>Rp  u|(~RH33\R|(zHqwxQw_\)zH~R~{4z{{D쿮~{H\)~R    \)zHs33\Gs33l(p  `  w
=  3333
=Q\pGpj=qc33`  nRr\xQo\)dzs
H\)z(({W
=@׮UUS
P  QGNRn{L(N{BhJHGFffEAGHMpKN{B\EJHEHB\DzEA6ff8Q71G(4z\)B   (&ffl(R:H<5Dz1G1G.{.{.R,+,))(Q$z*=q'
=!B!(Q'%#33!G%%(!(Q%p"\!G=q\)pp\)@=qz	D(P׿R{@
=
=qff
U33Q<(D

=q
H(
p
p
ffff33޸R\
=ÿz=q\޸R  
=\(C\H\ffD=qnRH\)ff*=qDC
=CfC?zA  6ffC˅\)ff\)z?Ϳ=p#
5aGÿ
=q\)O\)
&ffQ?\)?#
>\)k\??@  \)?
=?  ?n{?fffCqD5 CR?Q?L?Y?\?G
?\(?
=????ff?p?R?L?k?s33?E?E?   ?
=q>?u?(?G?\?333>Ǯ?\?(??z?L?@  ?G?{?=q?u??L?p?G?5?fffDhR?
?(?R??z??
=qG?(?L>L>B\??B\.{>DK>{?=p?&ff>ff?   ?z?5>?(?
=q?>?O\)AK
=>>  #
ýQ>
=>pD<w
?0?aG?Y?L?Y?333z?E?Y?J=q??E?333\?(Dg?\??B\\)DM

={>  ffC񇮽L?\(@DGҏ?zD)?J=q?+C;?#
??#
?\>ff?(?:H?@  ??@  ?Tz?J=q?z?zC/\>.{CH3>{>Q>p?\>?ÿDe^R>{zCR>?333>Ǯ@{CФ>p>
CV(ÿ>H>Rz>R>u\)?  ?z?(@p?
=?H?=Q?R?У׿0?@R@xQ??zDD&,)C|)D]?@  ?&ffB33?W
=˅B33?@
HC8?+>H?@  ?@  ?0?Q쾀  D?ff?:HD8BV
>
=?<
?L>?33?xQ?E33?+>ff??>?
=qz?ff?fff?LͿ?Q녽G>>?
=?G?>HB\>ff?\?aG>zῸQ>pA)?\)?G?   D$`?!G<#
?Tz??
=>\>8Q>33>=q>>33>aG?>(?.{?5?u?\?=q?>>=q@Q?{?GCz?\)@zEff?
=>>R>\=L>z>>
=>  =Q=G?&ff@@(@p?}pC
Q=G>{>>L>B\=L?>Q>8QBX
@xQ>>
@)>Ǯ=Q    u>  @33<?pB
CB׼C  ?!GB>Qu>#
CSB=#
\)#33Ϳ
=녿   33G@}p\({#
DC;^(ÿQ녿=paG\(s33R333n{DoD"${G  ׿.{DK{O\)p׿p
{(N{
=qkQC$Ϳ\

D3cDeGzУCqG
!녿{CФ
=D 
B}HP׿{R 
p
=R@R
=q33DD{D#jHc33C
GGp#33
=qp׿(zNRz(
ff^R(	ff(D0<ͿHB$A
=RGzzB
H\)Q ׿  ff
HG\G\Czff+`  33   Qff\){,C33GG
pa
B?=p<#
>33\)
=q33c33\)
=qR\   33У׿

=nRG@zaG\R{Bʔ{\zffGͿ33{ÿ33((Q[   Q녿{CԕÿD;	C`\@
(ff  \)
녿p\)Q쿺H\\33(\ffQ쿪=qDCߗ
z$z@  (mp<Ϳ녿B\#
P  \)CCͿ\)RAffD
=qff33=q{Ϳ  {zῂ\녿hÿn{녿(\ff׿Ϳ
   D	H
b\  ffffÿN{=qQ?\)C'ͿffCCr3C.C9D.޸A'33=qz῎{pHQ쿆ffGÿH
3333R  Q쿰׿(CbO\n{uD͔)333\(\)A\E/쿕׿=q\ffCcG33ff

?  ffC}qE,\\)ÿ\){ffk{ffzῌͿz῞R(
33\  Es33DmZ=Ϳ=q
ÿzC0DR
D%O\33CjD)p
=u8CACEGB HGffGuÿc

33C

B\ff
TzΉxQW
=E:Hzΰ
ÿǮ=qDKE#׿
=E{`׾l(zDCH\H\(\녿=q{D	{  DT)
=R  ׿׿
=

=Q쿓33ff
H=qzῡGs33H33C"쿥׿{XQ쿐׿=q  ffQhÿ
=q,;z&ff=qCʾ33  ?z>GRs33^RW
=LͿ}p
W
=zῚH(þ0׾녿
=qýzBB\ý@`׿@GzCff?
=q<R\\Q=#
33=q0Dф{A?(?G>?ff?k?J=q?333?aG?@  ?>?fff?c
?=p>>>>33?k>(??33?k?
?c
?\)?n{D?  \)G  >zL;zῪ=q=QEIR˅  ?\)>
=>
=>k333>.{=#
>=q=#
>#
W
=
>8Q>W
=#
  
8Q#
Dq<#
>B\=Q>=
    >.{.{s33Q쿼(\)>
=CѨG>\)    AG,Ϳ
=q0׾H7
=*=qǮ\A'
=CW
=\)Q콸Q.{=Q>  =\)?
=#
u=uQ쾔z᾽p\)W
=COaHB\LͿ\DyL)=?Dq>xQ켣
QDCD/L)GC4Ek
\?BE  
  H녿.{>=q?>  =\)?B\\)C&fk@R>CDR\)=qp#
\)>B\Z=q\)\CR<
aG#
Y>\)   @ff{333ÿ(D{8<#
У׿\>aG@D>8Q?\?>Q@(=
>Q>==Lͼ
L>    uD"u<#
=L=L    <
#
Q=
=
>k
=ff@3333=Q=LͿ^R>?(W
=??+
=>B>\\)C{>W
=C3=\)=G=\)>L><#
=u<#
=G#
=\)=\)=Q=>#
>\)>>\)?=\)?\?B"z=
A?>B\?333?RC>>\C98R=\)>=q?
=.{>A <p>>\)>=G<
=GL==u>  >>\)>8Q8Q\(pC>B\>  
=?>@R>Ǯ>HD3>?ͼ
>>\)zH>33>>{>L;\=Q.{>aG><#
=#
>B\<>  >W
=8Qff#
ffLͽ

=u>#
LͿ
Q=\)>>LͿ{^R=LͿc
R >GG\)>R>8Q>k>.{=#
=<#
,;ff=u333>B\:H<>Q<
\).{Q?J=q#
CB\)COH(uУ׾׿Tzٙ\)G=
@\)>Dc ffDN\

=qaG>p>>33>
=?B\?>?z>p?
=>
=<
AAÿTzzH?B\BF>B\>Q>W
=ٙCCEf?!GCo8R?J=q?ExQ>\??>\)\)?#
?5?\?aG?G?.{?\DS>?>GA3
=   ?333?R?(??\>>H@>ff?c
=Q>L?O\)CĂ?R?+>Qu>Ǯ33>B\>=
>\)<#
>>#
>W
=>ff>  ?#
??#
?>(?
=qC!ٙ
G?+?!GaG>
?J=q>\)>D3>\)>=qY{
=>G??Tz?Y=D>z>L>aGCCo\?  CqD  <#
?!G>
?Y?ff@R@33@,C@D
@mp@^R@(@\@VffB\)@b\@AD0@g@  @QA  @z@@\)A\)A\D&{@Q@33@\@zDvR@DY5D(A @˅@
=@A?GDS!@C{C@{Cq@vffDgDfD2C˗
Ch@D˅C%@0  C|)DUvfD #3BE RDE
@{>@0@@C
@[@$zDN@z@@@G@,@
=@@g
=DH@CФCs3C/\Dt{@?Q?33?R??pCT{@6ffD`s@(BǮR@Z=q@]p@s
@_\)@JH@0@AG@[@>R@,(:H\?  ?{>GD!L)?LͿH?5?k=qzH?@?׿?B\?H?YB{?z?J=q>@   O\)?33?  ???Q?G???33?ff???(??Q?{??s33?
?ͿLDvY}pBQ?BW
A33A\@Cm{@33@pB
@@أ@G@&ff@G@?ff@?  @Å@z@@c33@z@(@@`@r\A3
@  @?ff@@Ǯ@@h@\)@p@  @P  @(@@@ff@׮@3
@(@@
@(@\@@G@z@ə@
=@
@@  @p@Q@z@@{?@(@{@G@
@@@H?ff@@33@z@p@@33@@@R@
@ff?@)@@G@w@H@
@ff@\)@@@H@G@
@G@@p@{@  @z@=q@{A=q@Q@R@
@ @@33@#
@AG@H@  @\)@33@i@33@@{@@@33@@G@@Q@ff@R@\)@z@  @  @p@@@{@=q@R@G@{@z@  @@H@Q@@33@H@@R@@R@R@
@\)@33@G@\)@\@ff@{@\@(@@\)@|(@9@@=q@
@33@H@@@{@@z@p@G@
=@  @@
p@@@{@@G@G@@@R@pA$Q@
=@{@R@?{@@G@33@@=q@
DY@
=@=q@=q@G@@@\)@\@{@<@p  @ff@\)@  @@\)@@G@
=@@  @ff@G@Q@
=@p@@@=q@W
=@Q@@Q@@H@R@Q@H@p@Q@0@p@z@@{@iD`@  @G@ff@@
@@ָR@ᙚ@@@
=@@QAGA  AHAGA@33@@@p@(@
@ǮA
=q@A@(@@@
=@@\)@{@@(@
=@@R@@#33@@@(@R@}p@C@@@  @@
@H@@  @\)@G@@\@@@Q@@{@  @@H@pDqES@
=@p@1@@33@H@@@Q@R@
@Q@p@G@p@z@@H@@z@@@G@DN` @33@HCH@w
=@W@K@S
@NR@S
Cq@U@y@Vff@`  @U@@@;@A@HQ@H@K@0  @,@<(@U@@w@@=q@C33@8@&ff@z?У@!?{?RC|)?\)?AG?QDRB)???{?z?G?O\)?E??RC٦f>
=Cq>L>W
==QDj#
D
Dnf\)D]Cʌ;ffDD{?DAH?D)J=qkA=q  zA\
׿p녿ffQ=qff=qff{Q
=BBaHG
p
=qffH#
'
=,(*=q).R+G*H*HC33>
C
?TzD(eTzN{C
G
=N{S
N{NRG\:=q7@  K7Z=qS33VffZHu^{ZH`a[_\)^{^RR\D4zQDzD:=R\N{Ej6fD-IR\U_\)dzic33eaB{fff]pmpS33\)^RGhQs
|~RfffG(   {QGA5s
CB\)G
H('
=B8RL(AGO\)K?\)O\)C33N{IXQVffXS33S33VffL(JHNR<g
=w
=?p@{QGEP|DzHUJH72\?5fff,N{2\
p:H=p5Dw
@}pC33EHQ>{L(NRJ=qQUR\S33L(HHQHQJHIFff{:=q)-pC
H81:=qC
xQ?\)EMp\J=q8QFff=p
JHG333XQEc< '(Q1G4z/\)333;9AG99/\)1G2\.R'%}p'0  00.R&ff0     0  ffvffW
=9:H:H<=p:Hl(\7
=HQ3
Fff3
2\B\C
*=q(+"\"\    C331X\){N{]p#
#33G33zH*HHQ'
=z:H<!ff5*H
pp׿Q
H
=q
=q33\)!GZ=q\+w˅33QCOaH'
=Q
H33\)G33(	\ff
{ͿE\En{׿Ϳ{zǮ/\)o\)eUS33Gff0׿H=qDsmqÿRp(녿{ff\׿{QQ޸R\)ÿQ^R{)ͿHzppGff
(Q쿫
= Ar\;\)xÿH=q	$zjHQz6ffB{Ϳٙٙ@s
ÿff  
=
ٙ(  ޸R{
ffu,`  ޸RH=q޸R*=q=qff
=33ff녿
=5zΎTz
=q>W
=  >u?h?\(?p?  @\?(?=q?G?L@,(@G>{??R?+=
Ǯ\)B\R#
G=G<
>R>z?p?fff?W
=?}p?ff>ff?^R?޸R@??{?W
=@(@@@ ?33?33?\(=G?J=q?xQ>녿8Q>Ǯ?^R=#
>z?ff?p@@R@
=@
@Q?{?(@
=A\)@mp??=q?z?
=?p?Y@.R@{@Q@D@U@ffA z@GAA
=@@  @@@)@G
=@@=q@{@ȣ@ff@  @\@ff@_\)@@@  @@G@\@@R@z@33@@@Q@\)@tz@q@
@ff@@ff@y@G@@Q@
@{@q@
=@\)@z@ff@@ff@@(@G@{@@@@z@p@{@p@@H@p@p@\)@Q@tz@|@_\)@Q@Tz@R\@[@`  @b\@U@i@&ff@8A
@\)@2\B@9@aG@q@X??@#
@]p@@o\)@Q@N{@QG@Fff@Q@
@`@5@)@(@(@"\@R@   ??Q@
=q@Q@   @?  @@@'
=@@z@=q@  @
??\)??ff??n{>#
?   ?aG?׾#
?\>\?
?zH?????ٙ?Q??h?@\?  ?G?G?Tz?O\)@?Ǯ?G=?G?L???zH>.{?k?Q?fff?zH?u?@  ??:H?(ÿ@  ?O\)?O\)?@  ??h    =u>L>G?+>(=ͿB\>k<
=
ff\)W
=
Ei*#
#
GC=u=u#
=#
=u=u

<@j=q=\)==L>\)=u>=#
>????(þu@z<>\)>k>\)
D/
>L>aG>33>8QG
>ff>>>z>\)>=#
L=L>R>8Q>.{#
>=u=Q>
>8QL=
=Q==Q>=qH>8Q>\)#
>{>׿L>(?R>Rff>{?>33>R>>.{=#
?\(?   ?   ?R>\>(>{>(>p>{>  >R>R?p?L>녿5>.{>.{<
=??ff?R>
=>aG?^R?#
?#
>׿\)?Ed?h?ff?  >(#
Dj=?p??&ff?p?G?=p?Tz?p?}p?p?޸R?  >u??@7@.R@%@@-p@#
@L@  @G@/\)@@"\@C
@7@P@O\)@s
@G
=@_\)@O\)@Fff@i@r\@  EE@  @Q@@@mp@G?E0@h@tz@h@e@u@S33@5@W
=?@y@@@@(@(@
=@@@@~{@|(@l@s
@\(@W
=@TzD%@K@H@AG@JH@HQ@@@C33@L(@Fff@S33@3
@(?ff?33@@1G@Dz@E@G?h@{?@HCH@,(@H@@R@\)@  @\@mp@XQ@dz@s33@jH@@
=@??H@
=?Q@33@\?
????Q?G?33?  ????@@S33@^R>?@@
p?p@
=??
?Q@\)@?zCR@:H@<@c33@mp@^R@@\(@l(@%@;@6ff@p@!@Q@H@z@ff?
=?H?ff?޸R@
@{@   @(@1G@!@4z@vff@c
@\@\(@W
=@1@,@E?ff@Du3@p  @\)@W>
?{@?\)@NR@5?H@p@z@z=qBy{?=q@g
=@H@=q@@@`@Fff@G@/\)@G
=@'
=@,(@@ @\)@:=q@:H@E@&ff@,(@2\@Fff@>R@6ff@O\)@U@XQ@mp@H>(@33@S33@U@Dz@@\)@D/@G@8@xQ@@\)A@@z@/\)?=q@vff@@W@h@zH@k@ZH@C
@E@>R@@  @S
@tz@e@Vff@4z@1G@Dz@&ff@(@)@%@@@@{@   @33@ @p@3
@@\)@~{@~R@0  @jH?&ff??@B\@g
=??R?Q@ ??z@G@(@jH@x@AG@7@0  @$z@R@33?
=?\)@@2\@@\@@??@
H?\)@@
@@@D?G=G?h@?(?Hn{
=@z@@>R@,@\)?O\)?G?G@{@@HAH@(Q@u?G޸R?p?=q???
=?ٙ?p?\???{??Q??{?޸R@S33?33?  ?\)???(@:=q@L(@{@   @1G?aG>@qG@@  @A@nR?ff@Vff5@B\@'
=>Q@ͿB\(ÿR@"\@$z@3
@(@4z@&ff@<@   @H@p?33??H?H?p@@@@
=?R@\@!G@
H@33@@ff@	?{?Q@33˅ٙ@\@G@@ @@3
@0  C3?0@^{@2\@#
@
=@
=  CB  @3
@?\)@1@(Q@0  @,@
=@ff@\@\@{@?p@@@@R@
=@%@\@5@0@-p@333@@@xQ@  AuAB	BBizB+BAģAA\)D"vfAAQAA
=D(S3AgA>HAIpDFA@ۅ@@Q@@@\@33@@{@ff@
@'@JH??@<(@N{@u@|(@hQ@W
=@.{@J=q@XQ@W@Vff@7@a?@-p@7@;@=q@AGDl>Ct{D5?
=?\?c
C3Do\C9C=?(?H@
@\)?@ff?H@?(@?33???p?(?p?
=?@  ?8Q?.{?333?&ff??@R@%@
@R@$zD#@*H@L(@{@(@'@(Q@	@Q@@ff@C
@@\)@C=@@ @?@33@
@0@Q@
@*H@?R???p?
=?У??(?  ??
=???
=@???33?=q?h?\)?H@@@p@'?G?W
=??  ?G?R?R?n{>ff?+>??8Q.{
?k>u@?L?B\?8Q?Tz?(?=p?aG?(??>H>ff?   >p?#
??
=q?\)?
=?
=q>
=>>G?33?\)?n{>
=>\\)>W
=?>=
G>z?(z὏\)Tz>\>G?W
=>(>W
=:H@H>>\)=Q#
    >B\>k>>k<
>=L;L<


>zG>Ǯ;\)B\
G\W
==u=QL;LCÿ\>W
={녾\)=#
\)R>\)?\>  >L?333>33?=p?+?n{?u?Q??0??5?(?W
==  u#
>z<=?   G>u>?G?R?>aG?\Rh=Q=;H<L;\;\.{#
u>R>L>Ǯ><
\);\)
<W
=>#
>Q#
?333>=G>
>aG\)þ=q?W
=k\)=;
\)
=Q녿0׿\ÿxQ쿊=q?
=q
=q
녿\)C#׿^RW
=   {
H(Ϳ
=z(޸R׿H(=qz=LͿ׿  У   G녿  >33zΎz  
=G\)\)@jH.{\)
H\}pQ쿦ffB˨ff8Q
=׿5#

=qffWTz\b\^R`c
aG`a?ec33]pJHCxGD+Mq8  ;Ip׿R5pCnpA#33C^)CHQGL(B\B\WU[ag
=fffk\?\)HB\#33eI=qIN{N{\c
VffDUÿaGR\DzD`GCI)HEDB#
J=qC3C33LS33S
NRU33Fff6ffAITzP  L(L(QGY>W
=ff @\?E.RNRUN{>RPQGR\UQiJ=qCǆfDzC
DQJ=D\D{`Q:H:H?(ÿ
W
=
=׿E=#
&ff3
:=q3
@  >{C33C33AEFff@  AGDzAG/\)<(AC330  ?\)=p2\<
 D-l)E-
p
=CLDL
=D@Bg9DD4{F ffDǵED|qHQGFff{@<C33ADzB\:H;<<:=q58<9>{?\)@  :HL(1?J=q{
ff   ÿ,(\)	
=:=q
EB
D<
p녿XQLͿÿ?
=576ff
="\{ff)-p1G,(+
=-p-p-p\)2\.R.{xQ
=ffD (\)B{CФff6ffR)GC90DvR
ÿÿ>8Q(=q{{   {"\R   !3333ff

=\z

=EeC׿\D͍gEl)CuqD#<(DT&f
D RD0ٚ
pDNDtHA;33R\)  \z33\33׿(z
Gff\\녿Rٙ\)ÿ   \,?k@{C)B׿CCD7G
DfByCH
Do{D=q    ׿{C
ÿHff\)QzQR ׿\)Q녿33\) ׿pQ녿{ÿ  \Q쿪=qD33DL=Aa녿\ٙ޸R
D#${DD=D܂HD)Dt3Dj+D=3
==qͿ=q=qff=qÿÿG  (\)\ ׿33   녿(RHH=qDj33
Czff׿?
p@DzDH)C;)Cf@?\)?\?
?p?=q?Q@
=q@@\(@l(@@{@ff@H@ff@vff@mp@q@R@\@hQ@R@{@@\)@(@|@B\@l@U@O\)@R\@3
@<(@<@:=q@1@B\@33@'
=@0  ?(?=q?\)?}p?p?@  @ @=q@p@<@   @@
p@L@a@H@Dz@<@3
@1@1G@+@=q@7
=@2\@L(@JH@.{@,@(@.{@\?=q??Q?p?H?˅@ff@{@(@
=q@@
?p??33??(@\?H@@\)@Q@\)@W
=?H??(??(?ff@(@C33@@@@c33@(@   ?p@\@;@'@N{@G
=@C
@=p@1G@H?H??ff??˅?У?Q??\)?Q?{?33?Q?ٙ?H?G??H?ff?\)?G?z?z?z??=q?\)?@&ff@H@7
=@Fff@J=q@HQ@Mp@&ff@33@@}p@\)@G@@Q@Q@{@Q@]p@fff@Z=q@X@A@#
@9@l(@N{@@R@.{@=p@5@4z@8@0  @G@
@R????z?\)?(@
p?
?33?{??@'
=@AG@|@R@=q@H@
=@@\)@\@A
@љ@@G@  @33@\@@(@33@@@@xQ@s33@G@@c33@tz@@ff@"\@2\@G@@{@ff@Q@r\@!G@z?У?ff?=q?\?Q@33@
=q@1@|(@@@\@s
@B\@G@qGAHARAp@@33@>{@9@S33@c33@S
@g
=@z@   @@@3
@fff@`@w
=@Vff@2\@(??@@.{@  @*=q@/\)@@\@-p?=q@   @:H@hQ@q@^R@g@`  @jH@c33@b\@
=@ff@HAGA%A733A+A@R@@{@ff@H@@@u@(@U@hQ@7
=@Q@\)@:=q@&ff@(@(@@@
=?33@#33@:H@&ff@?(@J=q@:=q@>{?  @1G@   @B\@@dz@~R@A@θR@A(A.\A<Af=qA{AApABffAB\@G@w
=@
@޸RA@z@@I@Tz@R\@~R@p@[@
@H@=q@
=@o\)@y@-p@)@!@0@XQ@(@\@%@G
=@H@L(@
@@0@c
@ff@qG@G@A
{A#33A A"{A&ffAW
=A
=Aw
A{AjRAG33A A;33A
@  @QA(A@\@
=@R@R@ff@Fff@@R@@@mp@jH@z@Y@Tz@}p@Q@nR@c
@'
=@4z@   @)@'
=@xQ@w@@Q@@Q@{@z@@GApARA1AIA0QA<zAAffAA33A&HAQ@\@@Ǯ@QA=qA@G@\(@[@H@<(@=q@(@p@B\@I@\@@R@R@>R@-p@G@R@s33@"\@(@L(@o\)@(@H@\)A   @ffA33ANRA
=@i@  @
=@z@@ƸR@33A   @
=@@|@
=@\@
@(@(@\)@@\)@
@H@nR@g@{@@z=q@XQ@@33@n{@l(@ff@ff@^{@:=q@l@c
@E@"\@(@NR@>R@@(@
@AA!A$  @333@33A@ƸR@(@p@}p@ZH@tz@\@(@\)@33@@(A	G@
@H@A  @@@33@@{@jH@l@a@dz@B\@N{@(@H@B\@U@E@O\)@7
=@7@:=q@*=q@HQ@;@H@`@`@@  @]p@hQ@@@
=@@@@@@ff@ָR@U?
=@?@
p@,@C
@K@9@8Q@e@%@@R?Q??{?33?@.R@.{@p@<@c
@:H@ff@4z@E@@@G
=@E@N{A\(@(AEAYA@  @G@
=@Q@=q@p@Vff@_\)@y@O\)@X@=p@L(?(@z@p@
=@ff@(@@G??ٙ?G@$z@?У?H?p??
=?@?p@(@U@j=q@G@@R@@
=@A0@Az@\)@ǮA	Aff@@\@=q@5@{?@A@4z@.{@@??  @@(@.{@z@@G@!G@;@(Q@@Q?
=?p@(@   @@*H@{@A@@&ff@P@@l(@n{@b\@@G@
@  @H@z@GAp@H@G@=q@\@@
@\@z@w
=@}p@@u@@E@0@7
=@'@@#
@G@-p@@@,@\)@8Q@?\)@&ff@Fff@O\)@J=q@S33@a@XQ@I@XQ@B\@(Q@
@@=q@(Q@P  @^R@e@K@;@G@!@@\)@0@8@E@H@E@B\@?\)@8Q@C
@G@>{@J=q@JH@   @#
@R@\)@??@@ @
H?R?  @
=q?33?G???z?(?z?p?(?G?У?Ǯ??޸R@@@z@@R@&ff@#33@#33@*=q@,(@1@+@<@1G@)@   @@*=q@5@7
=@7@5@(@G@{@33?@
=@ff@\@R@
=@
=@\@@\@Q?Q@@
@@
@
@!G@{@&ff@   @%@4z@{@ @@{@)@H@@@=q@Q@=q@@\@Q?(??Q??G?p??33?  ??
??{??z?=q?\??R?\?z??z?
?(?z?=q?\)?ff?Tz?\?ff??
??p????
=?
=?33???
=?p?\)??(?H?p?R?ff?p?
=???  ?33?fff?s33?p??  ?{?=q?\?ff??\)?p?ff??R??p?{?p@R@G?R@
=??\)?Q@z@z@@  @@1G@!@
=@
@@,(@ @333@ @&ff?ff?33@
@??\)?p?z??(?
=??  ?H@@7
=@\?@?ff?@  @  @A@@H@u@_\)@\(@K@JH@-p@ @dz@@  @p  @{@@{@@z@@G@Q@  @@w
=@A@R\@p@
=@R@Z=q@&ff@@  @JH@9@B\@=p@J=q@w
=@=q@!G@
=?\@/\)@L@;@C33@g@@pA\)@AG
=A<(A2{@Q@HA
\@p@@@@\)@@\@@ʏ\@@@ff@@\)@@R@@\)@ᙚ@33@ڏ\@ff@Q@  @[@s
@  @33@@
=@(@~R@@(@  @;@aG@7@'@w
=@@z@@QA{A
A@@\@R@=q@\)@@@@K@H@0@]p@I@ @s
@]p@h@aG@0  @Y@U@@'
=@*H@!G@(@ ???Ǯ?{?z?\)?{?H?
??Q?G?(??
=?z?\?p@ @*H@#33@#33@0@R@=p@XQ@Tz@E@Dz@HQ@P@333@(@  ??ff??
=?˅?˅?  ?ff??\??H?G????p?ff?
?=q??33?=q?p?=q?\?\?
@
=q@   @
=q@@  ?
=?
=@   @
p@z@:=q@)@#33@"\@P  @'@z@C
@A@[@,(@!@   @=q@\)@
@@   @33?  @@?H@2\?@R@R@\)@H?(?c
?(?(?\)?33?Q?Q?(@{@.{@Fff@dz@p@33@ff@\)@  @@@@xQ@ff@@
@W
=@=p@/\)@e@XQ@W
=@Tz@P@\@0  @E@,@@(@1G@1?p@Q@?˅@?{?  @?
@?޸R???
??p@@R@1GA
\@@
A33A)G@=q@@RA@z@@{@@o\)@k@E@@@5@7
=@G
=@5@@@   @9@{@
=@HQ@L@,(@A@Tz@`  @~{@  @
?\)?33?  ?  ?{@@@,(@AG@QG@p  @Q@  A
=@ҏ\@  @  Ax(A
A7
=@
=@=q@\@@R@vff@\)@@@\)@Q@@R@\)@{@@@@w
=@G?޸R??{??p@\?Q?(??p???33?
?(??G?@@I@b\@
=@\@A.RA@Az@@z@p@H@=q@ff@p@  @@@mp@E@ @!@4z@X@g@Q@\)@Q@\@33@\@5@C33@5@^{@w
=@\@@@_\)@@H@E@"\@*H@>{@Q@s
AGAQAHzAYALA:ffA&ff@=q@{@@@=q@33@W
=@e@H@p@%@:H@Q@+@@\)@$z@-p@
=@1@
=q@tz@G
=@#
@@R@R@(@%?\)?z?H?@'@=q?\)?
?33?@hQ@@@@,@   @{@33?=q?
?H??p?p?
???  ??H?p@G@ ?R????У?{????(?
?
??R??k?=q??G?Q??p?p?@(?޸R?\??  ?33@ ??@E@QG@
@@\@b\@nR@8@3
@@33?p@G?33?G??(??ff?\)???=q?Q?{?\)???ٙ?33?Q?W
=?=p??(?   >G??z>
=>Ǯ?\?8Q?0???\??G?p?G?(??{?z?G?\)??
?{?
=?(?
??\)???  ??p?\)??
?(??У?ff?H?\)?G?\??>>G>Ǯ?>>(?(?!G?&ff?p?p??޸R?(??=q?z@
H?Q??z?z?Q?33?????z?H?  ?
???  ?\?33?
?@p?Ǯ?G?G?z?(?5>?(>H?:H?n{?s33?L?=q?h?c
?G?=q?ٙ??˅@z@'@3
@=q@
=?p@	?=q???  ?
?
?33?H????H?  ?ff?z?n{?h?s33?fff??33??Q?zH?B\??zH?
?n{?  ?ff??G???
?G@33@
=@@?\)@C
@#
@<(@L@S
@.R@L@/\)@:H@G@4z@9@;@#33@-p@R@
=q?
=?R@	@@Q@
=?
=?33?ff?(?  ???p??p???  ?Tz?aG?G?Y?G?\@@@Y@L@@@]p@@z=q@XQ@\@'
=@}p@Q@S
@AG
@\(@G@(Q@J=q@@@K@E@@  @Y@
=q?Q@>R?@
H??H?33?@(?Q?  ?(?H??\?^R>?@  ??Q@dz@@G@  @H@b\@5@z@@Mp@r\@1G@5@@\@
=?Ǯ?
=??{?R?xQ?\?O\)?Y?{?s33??\??@(Q@?\?{?p?Q???G?\)@Z=q?(?@(Q@G
=@XQ@h@O\)@l(@`  @1G@|(@r\@A
AA-AzAA&\A0(A\)A  @A$A=q@@
=A@Q@mp@!G@N{@KA/
=A6=qAIAZH@
@y@|(@@\A*ffA	G@(@  @h@HA\@]p@Q@H@zA
@@33@RA	GAb=qAA"\An=qAHARAQAA\)AffAlzA@RAOAA$  AAiAJHAVHA\)AApAA@QAA{AmA)A.ffAA@=qA-ApA@Q@(@(@@|@@A
{@S
@@@
A[33A{\)A$Ac
=A
A=qAAAT(A{A7@33@GAHAw33AmA(@z@AA@A:ffA=qA\)A^HACA<  @33AA=qAPA]@ҏ\@=q@AzAA33A"ffApASAJ{A"\AGA%AffAzAffAA33@
A/33A A(zA(@b\@@\)@{@q@[@:H@4z?@-p@HA{A
=AH@A
p@G
=A
APzA@(@@<(@@=q@-p@J=q@b\@@@
=@fff@xAGA1AoAc
=AbR@GA  A(  AzAA@AAAA@A\@ȣ@  @ff@`  @@  @Q@ffAc\)A:HAGA333A~HA@(A0(A\Q@33A	G@A
ffA\)@\)@h?@\@
@AG@@lA9AcARAP  AN\@s
A[A!GAxAPAuGAA33AC33AK
A}@
A]@ff@(A33Am@
=@g
=@޸R@@z@|@tz@\)?Q@Q@q@ff@@
=@(@e@@R@3
@/\)@
@@@vff@\@C
@\)AAG@ϮA(ACAaAAARA6ffA(A(BA\)AHA;@zAPAHA
=A\z@AW\)@fff@Q@33@^R@@c
@G@`@GA	p@\)@zAC@qG@{@A Q@}p@QAzAA@@H@QAR\@GA
\@@pA$QAH  ASAN{AAdQA{A1AAHA33A\AvHAmAff@=qA@  @Q@
=@[@<@0@:H@>{@0  @33@(@@z@@C33@@dz@j=q@\)@(@@@]pA\)AHA,@A*RA6{AuGApAG
A|AՙAZRAGApzAAۅAh(A5AHA@\)A
=A*=qA6ff@A @(AAp@{@a@ZH@W@hQ@U@Dz@Y@0  @N{@2\@>R@(@(@*=q@&ff@*H@^{@@=q@33@\@
@  A
=@33A(AkA{A A  BRA\AA{A{A  AzAAGA33A+
=AAA{AvHAOAHAA]Aw
@33A
A@@AA@z@
@A
ffAEGAQA@@
=@A z@陚@QA$@A1A@УAF{A%AHQAA2\@33AAP  AoA33AzAAyAs33A
AAGA^\AO
AEGA=qB  AArRA\A8(@AapAJ{A@AXQA0Ak\)A1GA/\)@:=q@Ax(@\@G@\)A33A
=@\A<(@@@A@H@G@qAAff@=qAAAp@A0  AjHA{33@A׮@
=@
A&\@
=@\@@\)@@@\)@
=q@AuGA=qA
@\)A'
@=q@hQ@zA!GA=q@@\A'\)@k@@ @s
@\)@@GA)@%@,@g@B\@\(@LA\)@hQ@P@:H@$z?33@)@E@G
=@E@@@Mp@^R?=q@@H@@\)@@ڏ\A
@Vff@(@1@
@qG@Ϯ@\)@p@33A{@33@\)A"ff@33@R@
=@(@ff@@
AA\AQAApAA(AAAff@ff@=q@(@G@z=qAu@p@p@RA;\)@@ə@(@@s33@%@R@1G@I@'
=@aG@|(@{@33@
=AH@@@(A)A=q@{@Å@aA=qAff@\)A,(A0  AQpA  AQApAA
p@z@@A7@zA0(A@@G@A&=qA@@ff@A@G
=@G@ff@@C
@
@
@\@@
=?H@<(@{A6ffAU@QA2{@i@p@@
@(@1G@p@=q@z@HA\AAf=q@=qAI@l(A@
=A-GA	@e@\)@K@
@\)@h@dz@Dz@R@
=@?Q@?ff???(@
@@;@R@L(@I@G@(@(Aff@@G@33A\@@ə@@@jH@@W@AA
@2\@c33@@ffAQp@(@=q@@1G@@c
@s
@@@=q@{@@@z=q@{@a@S
@mp@k@G@
=A
@w
=A\)@@@{AH@\)A*R@(A	G@θR@AGA=qA33AJ=q@
=@A,AbHA`QA`(AiGAUAUA`AO
AMAc
=AAA A(A
AffAYGAAA~HA@
A5pA'A?\)AA[AxApA@@AxA
Ak
=A\AqGA  AffA,  @o\)@@AR@AACA=qBA\AapAA{AHA33AzA
=A\)@\)@
=AHAc@H@33@
=@p@(@z@AG\)@\@A~HAv{AS
=@33@{@@A@p@}pA*R@
=@@33@(A (@A3@AL(@@=qAAAyAQAAAqAffAApARA\Af\@  APQ@ҏ\@\)@GAHA&ffAiAQ@@{@C
@y@;@<(@4z@P  @C33@#
@c33@y@J=q@e@XQ@=q@W
=@=q@^{@2\ApA   A\AGAPAApAHAA A?AA#
AHAeA@@ʏ\@A~=qAW\)A?
ARAA
\@\@
@(A
A\)AsAf\AAtA\)@AA@A  @A
AA
AGAD@@@@RA\AA*RARAA%pA:=qAA{A(AH  AAAr\A\)A
pA=qAUAS
AmpA=pAmATAqA:=qA9GAAACAtA%GAyA|  A?AAYA$A@R@(A!A\@ARA`AAR@pA
A.\@(@QATQA_\)A9AA{AO\)AAQAA33A(AA&ffA(A?
=AA;
=AXzARAh(A  AJffA33AR@(@{A<(A{Aw\)A
A33AA;A!GA@RA@33@c
@@A"ffAQG@
A@  @vff@@  @_\)@=q@\@
=An{A0AW
=A\A:RA#\)A!AaAlzA@\AK
=@33@ZH@^{AQ@(@R@@=qA33@ff@@@@  A   @zAg@p@p  @HQ@Vff@N{@pA@z@@@@H?@   @  @G@\)@QAffA\)AL@ffA2{AhA#A`  A=q@A@@@=qA@ffARA  A'AAM@
=@{@{@}p@(@
=@@  @z@{@NR@@  @!G@g
=@G@1@c
@zA(A33@ָRA=@H@=q@\@{Aff@@RA+
=A&ffAAffAAQABRB\A
A@@5Ap@@=q@uAR@`  @q@XQ@aG@(@p@?\)@^{@  @@A6R@Q@<(@  A9@@\@H@\)A5GA@@p@p@Q@ff@A#33@@(@ٙADAA\)A33A  AzAAc33@\@@w
=@ff@
@@33@q@XQ@
@@\@r\@n{@8Q@:=q@0@_\)@Y@ffA	@@\)@A@k@@p@y@(@33@@@b\@Q@У@x@l@u@p@ff@;@@AAz=qAR{@AQ@GB
=@@@  A{A  AM@R@jH@@S
A\A\A  @=q@{A33A5AQ?\A*{@=q@|(@@R@YAhz@A!pA:H@A-@GAQAO\)AzA>=q@ffAA.RAiGBpAQAb=q@ff@LA\)@p@@9@vff@@@p@a@@aG@Z=q@g
=@@=q@
=@EAHA
AfH@@p@@
AO33@@@33@33@@4z@HQA9A{@\)Az=qAAPQ@RAIANRA@ffAz@z@ff@A8@  @\@{Ax(@HA
AR=qAhAGA(A|QAF{AuA~ffAvHA+
@
A=q@A0zA:RA=qAQA@  @A9@GAFRA A@AA
A;@RA\  A333@A/\)AbRAk
A AAp@
=A*ffA<A\)Ah  @\A6RA\@s
A  @\)@УAApA~HAzA\)AOAsAG
=A}GA2\A  A7
=A7
A
ff@ffA@  @Q@G@(@  @A(@
=@
=@dz@@A   APA:=qAc
A(Ar=qAffA{AQARA(ApASAUGAnHAAg
At  AYA\)AF\A&HA"=qA0QA3
A`Al  AK\)AA;
A_\)A<zAA6\@@33A;\)A&{AK
=@}p@33@
=@(@dz@RAMAjffAX  AAzAsA\)AAHAHA33AAGA	GAsAc
APQAGAAA`A=qA`ADzA!p@׮AAyAHA A`QAAHA[\)A*ffA,(Ap(@G@(A  @
@z@u@H@(AL@zAffAA1@(@A\)@+@?\)@U@H@@r\AHA   A@33@@@@\)@:=q@
=@l@y@3
@Fff@\)Af\@@R@\)@G@@Y@ȣ@zH@@@u@@@@p@(Q@\(@P@J=q@b\@C
@HQ@\@p@33@\)A  AA1A~RA33A\)AzApAZRA{A
p@
=A\)AwA2{A0  @\)@@HAqARAQGA1A@@@@C
@=q@\)@\)@G@@z@@  @QA
@dz@
@\@vff@=q@@U@@  @r\?z@YAAr{A\)AS
AG@AARABHA$Q@Q@A1GAt(A3AA>HAc
=@Q@p@R@@pAff@{AA((AO
@@Q@p  @tz@@{A@{@\@
=A=q@\)A#
=A
=APzA
{@QA A8QAw
A+
A(AF{AffA=q@AA:{AGAApAC33@\)@GARADA+AL(AA  AfffA%GA.H@@@ָR@
=@y@Vff@(@@{@c33@G@@w@ffA   A6ff@ffAJ{@\A,A@z@G@g@\)@@RA4QA"ffA@eAA\A
@ٙ@HA:H@33AA=@\)@R@
=Azff@G@\)@RA\AA.=q@@AQ@aG@@{@y@k@e@ff@\(AG@\A@@(@ffA (@zA  ATzA$APA
=q@\)@QA
=A  A@z@
A@AAzA{AA>HA\A`(AS\)AJ{AAU@\@@GAA(A33A=qAA A  @\@=q@u@
@  @~R@@AuAAp@A9ABHAA{A=qA#A[AaGAQA{A#
A=qARA1A@(A_
A
=AAzA  @A$  AAp@A33AC
Ar{AA=qA5A(A(A=qAW33A#\)AL@pA\@ff@
@ff@QAGAE@\@(A)AdQA<A	A
AG
=AuA|QA
A
GApAAzAxAAQAAk
AAHzA2RAKA A@=q@
A/@QAz@@ҏ\A9@Q@A(Q@AW\)A33A@}p@
@G@AG@_\)@Tz@\@
=@{@H@
=@\)@z@@(A QABRAAAB2A=qA\BQA!A!AsAAM@
=AAA A\)AyA (AAP  @A_
@(A  @p@
@  @@p@33@@@
@@aG@p@\)@
=@z@ff@أA@{AHAA
=A  A33A33AA(zAS
@(@\)AHQA\A{Aap@(@A6ff@A:R@AffA@AA	@@
=@@A z@@@@33@e@:=q?\)@zH@u@g
=@g@Q@G@أ@\@R@7AK\)A(@=qAfffARA3
=A
=A\AQAA@ffA=q@׮@?˅@ff@@xQ@~{@\A%GA@@@Q@QG@Vff@Q@aG@>{@a@U@
@@j=q@s33@\@@H@1G@
AAffA8@AH@=q@
=@
@zH@n{@E@UA(@\)AYpABffA=qA  A33AAAffA{Aw\)ACATzAmAC
=@A8A:=q@33A\)AqAQAAA   @A@
=@e@\)@=q@33@e@33@l@Q@  @33@  @z@A!@GAd  AqAN{A(AgAA@{@(@~R@fff@Z=q@Vff@AffA  A,  @
=@AG@G@@Å@\@33@
@=q@A(ApAA5AA
AAJffA\@GA\@AQAc33A?
A
=A
=AA
RAQABffAAAIGAmA=qA33@G@GA@ᙚ@@  @ff@{AA@@{@Q@  @P  @Q@G@H@{A&=qA=qA,A<AAHApA  AǮAB@  B
  AGAAAA
=AzAAHABQA1ARAA-A,zAR\AH(AT(A\)AAAA33AA&\A8(@H@\@ffA @
=@L@H@p@~RAQ@33@{@z@@AG@\@A#
AAAAGAHAffARAׅA뙚A
AffAA-GAR@A6R@ٙAANR@\@
@  @@z@p@Q@@{@nR@\(@=q@@H@X@Z=q@qG@[@K@;@7
=@b\@qG@(?QAA
@=qAW@{@=q@33A8AO\)@p@@z@@n{@zH@@R@z@nRA!p@У@AH@=q@
=@@@p@hQ@NR?z@L(@\@~{@@0@6ff@Dz@<(@
A*H@=qA4AqAZ=qAIG@AD  @\A\A
@=q@R@=q@Q@ff@w
=@G@@HQ@l@R\@@@\)@@@H@[@QG@{@@A%GA"{@33@Å@ə@@=q@@L(@2\@G@
=@A@33@ᙚ@j=qA	@z@AzA\AzA^RA	@R@w@r\@Fff@.R@A6\@\)@\)AH(@NRA(zAF\A@@
@љ@׮AGAp@zA33A@\A{AA!GA"=q@
=@Q@H@@{AA%GA
A (@R@AffAOAJffA;
AS33AffAzA\AhAABRAHA&ffAAffAffAAA
=AzA
=A)A  AAA,  A(A`  A(Ahz@{A\AA
Ab=qA4zA\AvRA  AbHA6ffA?AJHAfHAp(A\)AA=qA
=A=qA
=B'zAGA\)ANffAcA<zAA&R@pAAA1GA
@
A=qAB\AK\)ALAo\)A6ffA5pAzA A;
=AA9A
=qA zA33@zA-GAcA'A,QAHAA@z@33@A.=qAX(A(A0(A*ff@
=APQAAHA\Ax(AAuAH@kA@{@\@(A1@ff@H@Å@@e@w@@~RA(@A{@@@@p@ff@&ff@  @\)@"\@\)@E@Q@@33@(@ARA=qAA8AJRAO\)AA[
Al  A\)@=qA\)A
ARA1@  @@h@I@C33@Tz@ҏ\@C33@?\)@33Aip@ǮAp  AHA  AQA*\AtA@@(AepA(AAff@@
=@@zA;A'AA3
A%pA1AJ\AHA8(A(ApAwA`AG
=AGA^{Af{AJ\@\@@˅@(@  A`AQARA!@jHA+\)@{Aw
=AH@33@Q@ff@QA,A(A\ABff@@H@(@@  @@p@G@p@tz@'@{@\@nR@
AIAffA"\AS
=@s33A)pA3@
=@@AHAA5GA
A
=AuA{A\)A{AAGAV\@
=@(Az@@@ٙ@=q@@A33@\@@H@@z@@@{@R@\)@w
=@tz@@Mp@!@@H@\)@~{@XQ@G@  @^R@Aff@(@AD(@ff@hA+@
=@ffA<@9@vff@R@0@Mp@a@p@pAG@A(A33A*\@ffA#@=q@=qA?=q@@`  @<@Q@<(@!@G@??z?(?\?G@A@\)@=qA*{A  AAApAA33AffBQApAQA]GA{AzA@@l(@@@@@tzA @(ARAK
@ʏ\@pA
=A   @ff@Ǯ@@Mp@@@\@zA@e@@fff@H@@{@33@6ff@GA*HAJ{Ap@A=qA\)A  AG@a@J=q@\)@#33@/\)@)@@H@(@8@1GAHz@EAA:ffA:{A
=@׮AJ\@\)A(AUG@p@p@@>{@p@y@XQ@3
@qG@@Q@@ff@H@@\)@A/
=A
RA=qAh  AApA\)@AS
A(A(A
A
=AJ\A(A\AdA%@A.RAMpAO33A=@@
=@@z@GAI@\A  AMpA
GA7@{@@G@@@A
A	G@@@@=q@ffA33A#A=GAAHA=qAAAzAAA  A6ffAhQA\(A&R@(AqA`(ARAHAAAffA7
=@\)A
=AƏ\AzA.ffA@AA=q@R@z=q@@R@Q@@
@@
=AA@HA33AWA_33@(@  @@{@@33ATAAAď\A  @p@  AffA,QAcAYA
p@l(@  @ƸR@ARRAZffAGAyAxzA\AeAGA\)A   A4(A$zAXQ@\(@
=@33@ff@\)A@Ϯ@ƸR@@@@˅@AA\@@HA AQAHAAb{A
AAyA
A
=A\)AA\)AmpA@=q@\@QA7
ApA@\)@zAA	@Ǯ@@z@@J=q@G@=q@H@XQ@^R@{@=q@{@!@@@\@@{@=q@33@ff@33@@
=@pA5A\@  A(A"\AAmA*{AQ@ffA@@@=q@
=@ZH@e@R\@+@
p@"\@Mp@(@
@ @\?Q?У?
??@x@E@(@(A
@˅A A_A\A*RAk
=A=q@=q@AQA!GA~\AZHA{@ʏ\@{AA1@  @e@w
=@  AMA'\)AzA (@p@@@ff@  @
@Q@@A5pA-AQ@(@7@Mp??u@G?z?@ff@@@@N{@(A@H@@
=@A)@pA=qA3\)AzAyA  A}As33@RA ATApAapA{\)A=qAAy@33AhQ@
A8A(A5AXzA
AKAYpA,(A@^R@(@pAFH@p@GA  As\)A   A?33@@33@A#@
@33@GATAAAA33AHA8AAzAAA  AAGA\AQAV{A~=qAAGAffAT  AHAARAAffApAAIA>ff@A>R@ARAA  @MpAG
=@G@A  @z@HAEG@ff@@33@@@\A.RA]AvHARAoARAARB AAHA\)AK33A?33AîAAzA_
=AzA֏\AA=qAdQAT  A@@G@ۅAff@G@  @@\@@@\)@=q@^{@  @zA@@Q@\@  @@H@@p@\A4AHBA3
AaAoAmA\)AHA @z@z@B\?(@AR@`  @|@
@AJffA@=q@H@
=@H@Q@ָR@H@!G@8Q@?\)@33@??=q@~R@o\)@@@=qAAARAd(AaGA{A|(A\)AAAA:=qA/A<AffA:\AdA=A
AA(ApzAdA(A\)AdA<(A,AQAEGA@@(@c33@{@h@{@Q@ZH@7
=@0@h@L(@p  @  @{@\@H@{A*ffA((@
@(A<zAs
AWAAQ@pAn=q@u@R@(@iAA1p@33A33@QA\@u@a@G@aG@1@@@ə@j=q@!G@s
@ff?z?G?33@\@aG?H@(@jH@:H@	@
H@@@xQ@x@s33@  ?G@JH@c
@O\)@%@Q@'
=?Ǯ@
?޸R?Q?{@!?H@z?(@\)@:=q@h@Q@6ff@.{@?Q???
?G?˅?  ?{?33?G??zH?O\)?(?zH??\??У@@p@(@c33@
@p@
=@Q@u@`  @%@3
@@z@R@   @??@R@?R@   ?(?z??Q@G?Q??Q??\?G?
=?
?=q????33?У?H?Q?p?G@R@@c
A@Q@@nR@\)A33@]p@@u@7@9@`  ?޸R@{@$z?\?33?Q??H???33?R?=q?Q?H?\??
=??ٙ?޸R?=q?@!G@2\A_@\AH(@@ȣ@Mp@|@l(@8Q@R@p@陚@z@{@Q@@zH@@@7@@3
@@33@R?@,(@ff@Q@%@;@<(@S33@C
@z@@6ff@?{@e?p@@jH@`  @8Q@R?\)?{?@G?G@@\)@@*H@   @.{@}p@@@Q@@QA@@  @@
=@tz@g
=@
=@@)@nR@@K@fff@I@zH@~{@?G@@ ?
=?  ?33?(????R@R?\?H??@R?H@6ff@)@4z@G
=@y@EAARAzA\@O\)@\)@@@H@H@\@ff@p@33@33@@qG@AG@??H?p?@Q@\@3
@HQ@G
=@O\)@p@@g@e@:H@\@(Q@?=q?\)@1@w@mp@(@\@
=@{@@AzA(  ANRA
=AQAAffALQA{AffAP  A]GAuAEA\)@{@@s33@U@}p@tz@Q@ff@{@@@\@p@  @@\)@ff@z@aG@@^R@33@@@(@(@y@{@'
=@C33@@@@@H@33A
\@p@@=qA QAhzAzAzffAQA (AHA:=q@G@@ff@Mp@Vff@zH@=q@\@S33@@@q@@Q@8Q@33@ff?Ǯ?xQ?!G???B\??\)??
@@@p@.{@1G@C
@ff@z@G@z@H@Q@{@jH@{@~R@p@4z@G@,@z@   ?p????{@<?ٙ@@ ?ff??R@   ?\)?{?
?O\)??\)?+?#
>p?{?{?s33??p?Q?333?+?n{?G?ff@@R@(@@33@Q@G@R\@@[@C
@$z@@@\)@(Q@{@&ff@333@<@L(@b\@e@%@ @ff@R?  ?p?˅??
?\)?c
?fff?zH?zH?s33?
?p@(@W
=@w
=@@
@@G@
@33@\@@
=@@@z@^{@fff@:H@@@(??z?\@z@O\)@@@@@*H@@\)@ff@
=?p?  ?z?=p?aG?@  ?#
?h?ff?R?p?p?R?Y?h?O\)?p?u?  ?
?H@9@  A'@p@H@e@6ff@%?@j=q@{@(@Q@@n{@Tz@0@@@%@{@33?@0  @@0  @G@?p???Q??p??p?k??R??z?=q?@(@ff@Vff@R@33@@ff@{@p@G@@33@e@H@ff@@Q@ff@p@@k@Q@!?R@{@L(@C
@(Q@   @*H@R@{@
?@?p?{?33?\(?H?=q?\)?@33?{?޸R??@*=q@G
=@@@z@׮AA\A!AAA/\)@@^R@b\@@=p@J=q@Dz@L@.R@!@=q@??G?R?
??Ǯ?  ?p@AG@@  @@  @ ?
=?=q?H?G?ffA@z@2\@H@   @
=@@(@HQ?Q??(?(?=q@5@ff?{@@,@g
=@]p@.{@   @ff@:H??H?z@{?(?{@{@R\@@nR@(?Ǯ@2\@@2\@Z=q@?
=?\)?=q?h?E??&ff?R@!?33?˅?(@G@+@I@`@@  AHA#AHA4zADQAzHA@33@@
=@R@\)@=qAAEA
=A6\AYA*ffAH@@z@\@l@(@G@{@  @U@@*=q@'
=?ff??\)@G@,@Mp@~R@G@|@@z@@@Å@A	AC33ARffAxQA
=AMGA3AAv=qAd  ATzAlzAl  A:HAEp@=q@p@  @  @{A,A
=@{@ff@  A@@@H@  A@~R@@
=?\?H@tz@;?Ǯ@
p@)@@@  @7
=@#33@
@@=q@@R@R@A
@  @ٙ@p@@u@{@ff@aG@
@(Q@,@p@=q@
H@%@+@'
=@#
@?\)@\(@'
=@.R@$z@-p@H@J=q@*=q@+@g
=@G
=@Q@*=q@H@NR@nRA@\A!@
AffA
A
A
=A@@ff@b\@C
@z@@=q@
=@6ff@#
@\)@	@R@!G@*=q@3
@z=q@X@K@C33@'
=@l(@g
=@5@@h@33@e@~R@]p@=q@r\?޸R?\)?p?
??H?
=@8Q@\?R?  ?H@HQ@(@
=@{@HA.ff@A6HAQ@@@HAA:ff@\@Q@N{@:H@!@(@@AG@@\)@@/\)@1@>R@9@@{@@ff@(@H@i@@5@Q@ff@R?H?@G@@33@!@1@Y@JH@S33@33@@  A\)@  AN{A
=A噚A=qAlzAbffAX  A
ff@p@(@G@@Q@Tz@:H@?\)@1@ @e@  @z@G@=q@\@p@=q@@vff@o\)@>{@!@O\)@G@33@$z@(@@\)@\@j=q@\)@eAQ@
@@R@pAAGA zA
{@l@vff@i@G@E@L(@   @p@#
@\@{@   @ff?=q@
@!@?\)@@.{@8@E@s33@@mp@&ff@)@(???33??  ?s33?W
=?@0  @L@Vff@nR@R@R@Q@p@A&\A!ApA@33A@  @@\@=q@@G@@\)@h@^{@@G@s33@w@Fff@*H@*H@@*H@:H@Q?@e@33@c
@>{@@%@   @*=q@#33@<(@L@Z=q@>R@5@Fff@hQ@@\)@GA4A{A#
A
HA@xQ@x@y@<(?p@޸R@l(@!G@:H@1@Tz@z@@Q@s33@p@mp@ZH@=q@{@=q@fff@'
=@?G?z?\?\@@%@"\@
=?(?
?У@"\@7@jH@[@
=@p@ff@@Q@\@@@p@@
@jH@@?p@ZH@4z@\?˅?
@@33@@33@JH@fff@c33@r\@hQ@AG@
??Ǯ?R?p?z?\)?=p?0?G?H@
=?\)?
?@\)@a@@\)@{AAA A
pA,A3A#A @{@G@p@
@ᙚ@@@E@H@hQ@"\@G@33@
=@  @@@.{@@ᙚ@z@@  @E@3
@^{@\@@z@@\)@XQ@U@@G@
@nR@@\A@(AA(  AhA=A}AXzAU@ᙚ@\)@Q@@G@@AAfH@˅@\@ҏ\AffALQAypANffAr\A33AAz@{A33A33A!Aff@p@Q@z@@P@z=q@\)AA>=q@@=q@@(@@\)AzAR=qAN=qAN{Ak
=AiA^HAAAMA!A'\)AG@\)@ָR@\)@@θR@GA"{A3AGABffAj{A\(A33@(@A\@ffA
RA\@
=@\@(@g
=@X@ff@*H@*=q@>R@G
=@H@  A
{@AzAA3\)A5pA1AHzA\zA
=qAfRAf=qA%A@pAff@
Ao@H@33@  @qG@R@  @@Ӆ@@=qA
@@\)@?@@H@@{@
@p  @$z@R@Q@
=?\)@@ff@z@nR@p@H@@p@@@@
=@>R@陚@AA8Q@GA#
=@\)@  @5@ff@  @@e@@+@\)?R@
=@\AGA%A{AIG@=q@z@(@@8Q@Q?@p@33@??@vff@@4z@*=q@y@Q@N{@   @E@O\)A
p@@\)@33A   @AR@
=@G@@@W
=@p?{@W@aG@c33@$z@W
=@8Q@?޸R?H@
H@J=q@  @H@{@R@p@@r\@\@  A*=q@\@ff@z@ff@s33@@H@@ff@ffA@{@ffA7AQpA-A^{AGAA0zA\A$A\AG@A$z@z=q@Q@
=A@@(@=qAAzA@@(@@GA@@p@\)@Q@Q@H@"\@-p@`  @
@ff@(@-p@U@ٙ@У@@@{@
=@{AdA\@\AVRA @33@Q@G@AG@ff@=qA'
=A@@Ӆ@Q@*=q@GA33AQ@{AAN{AA\)AG\)@H@@\@G@R@
@R@Y@mp@
@ff@|@@@z@qG@@AAAQAMpAaGA
AA(AGAA{A=qA<AK
@{AAA=qA@H@HA5@G@ffA-Ao\)A%AQA
=A^HAAA9@
@G@l(@<@\(@]p@=p@@=q@@@أ@
@A=qA7A)pAL  AAEAeAQAg
=AEA,QA(ApAAA@
@VffA  @
=A{A1A
H@(@@vff@=q@@G@33@=q@@(@
=@þ8Q@Ǯ@S33@<(ANH@{@NR@@(@.R@Mp@\@P  @G@(A!pA#AxQA{AMA=qA  A'\)@  APQA@Ϯ@@@@{@@jH@@P@
@aG@u@b\@w
=@GA@AA@pA@R@p@qG@7
=@\@  @ȣ@ff@p@33@33@@@=q@(@
=ApAVRArRAXzA
=AAAAffAA733@\AAPAz@p@JH@S
@7
=@(@@l@@{@xQ@\@
=@Q@@
@u@{@R@R@dz@QG@C
@6ff@AG33@Ϯ@@  @\@(@߮@A{A<AGAA%AiGAIAHB =qA2{A<QA1p@ffA
ff@
@@
=@  Az@Q@@XQ@p@ @Q@W
=@@u@nR@{@@I@ ?p?(?G?R?\)@3
@@\)@@~R@G@\)@{@(A(@ffAr=qAepAApA<A AAA@ffApAQ@(@p@RA  @pA@
@Q@
=A\)@ٙ@R@ff@p  @n{@jH@n{@H@@@@\)A@@@=q@\@W
=@l(@@(@@@ffAQA	AQA
\AhAG\)A\A-pA=qAAFHAJ=qAzAHzAyAzAQAp@pA#
=@@R@_\)@k@6ff@;@,@B\@L(@@\@@w
=A@p@HA@@@33AH  @{@a@\)A\)Ak
A?
AxAffA
AřAA\)A-pA1AG@>{A"ff@Az@@]p@K@X@AG@>R@H@(Q@mp@w@@HAGA@x@%ARA33A\@j=q@S33@NR?Q?
?H?\)@@%@HQ@G@_\)?z?p?R@JH@Q@
@=q@33@   ?G?H??
?У?H?\)@,(@/\)@'
=@G@z=q@~{@>R@<(@
@e@(@G
=@  @@\??(?G??z??33?  ?{??R?W
=?\(?Y?ff?\@  @Vff?(?R@33@S
@.R@@@@A&HA$QAnffA2R@Q@Ǯ@z@\)@P@E@vff@J=q@:H@333@$z@z@@
@%@!G@@
p@33@
H@
=@
=?H?
?H?
?G?33?\)?H??  ?{?p?z?(?@@*H@HQ@w
=@\@33@@
=@A33AA{AA@ff@R@G@\)@ʏ\@\@@XQ@e@W@<(@??R?33??p?z??ٙ?\)?p?ٙ?ٙ?33?H@
H?ff@   @
=@@33@7
=@^{@^{@Q@@c33@mp@@{@\)@\@G@@@ff@@H@
@dz@y@@^{@\@@.{@p@@  @@@  @j=q@s33@Q@@@H@K@@??{???(@
=q?У@z@$z??H@c33@n{@p  @ָRA@H@\)@H@z@@z@\)@3
@<(@(Q@1G@\@  @dz@@
=@@{@Q@:H@G@P@?\)?(@@ ???\)?
?Ǯ?????k?xQ@H@P  @ZH@\(@a@=q@G@{A
ffA:ffAnHA=qA  A{AA
=AA  AA(A\)AC
@33@  @A  @HAA@R@z@陚AOA)pA
ffA$(A C[A6ffAA=q@@p@\@G@\@p@@z@  @=q@
=@(@\)@
=@A	A\)AHA|zAQpArHAjHAAQAA
=A@(A0  @A@(@\@p@ffAQA8QA8  A(QA#\)@{@
@{@,(@@
=q@????{?@ff@@C33@O\)@X@S33@*=q@!@R@HQ@#33@@.R@0  @1G@   @(@9@B\@@@l@L@(@Z=q@E@\?Q??  ??=q??H??
=?z???ff??Q?
?z@\)@U????(?\)?O\)?^R?O\)?ff?33?@33@.{@>{@Y@Q@\)@\)@
=@\@@\)@E?G@R@&ff@33?޸R?{??(?Q??=q??\)?Q?Q?R???=q??R?Q??
?.{>H?>?#
?}p?ff?G???{?
@8@zH@@@ə@ҏ\@\@@
=@@\(@ff@(@@
@e@A@>R@*=q@  @9@$z@8@333@<@L(@8@5@1G@=q@*=q@"\@z@,(@?p???ff???
=@
@=q@=p@i@QG@(@z@AApA_
A5A
=AG@ڏ\@)@
=@_\)@\)@@
@E@@
=@l(@W@U@1G?{@<@W@Q@??Q??  ?H????{???H?=q?Q??  ?˅@\@{@(A;
=@\)A(  A4AaAHA6=qAffA@z@Ǯ@33@H@H@33@ff@@33@=q@ff@@G@=q@@(@
@@p@{@@ff@R@ϮAQ@\)@{@(@qG@@  @?޸R??
=?z@Q@R\@ə@
A=qAffAA\)@@@fff@hQ@g
=@U@(@@Q@$z@ff@-p@@@@8Q@#
@H?@
@ff@@ff@@ @33@"\@Q@{?ٙ?z?Q??\?ff@z@1@>{@X@{@<@X@Q@33@{@@ָR@Ϯ@@Q@{@G@{@{@\@H@`  @ZH@2\@)@*=q@#
@@G@	?ff?@?33?(?p?p@
=q@
p@@ff??޸R?ff??G?R?ff???=q@\)@\@%@aG@g
=@@33@
@\A9A#33A2=qA0QA\)@@{@C33@!@L@(Q@+@  @>R@h@q@R@
@  @@=q@@
@@^{@@/\)@@
=?u??
?p@G@[@<(@Q???(?G@@p@@z=q@mp@{@{@ffA<zA5AH(@=q@@
@@@߮@A@,@.{@!@/\)@>R@&ff@Tz@S
@g
=@S
@^R@H@Q@O\)@^R?@4z@o\)@3
@@@@S33@`  @c33@{@  @>R@R@?\)@R\@k@  @ff@@p@@\@@
@
@Q@  @(@@b\@9@A@G
=@*=q@@,@)@-p@ZH@p  @fff@\(@H@n{@h@mp@P@6ff@>{@/\)@Tz@
?\)??G?33@?\?p@(@4z@S
@[@7@2\@G
=@w
=@p@(@\)@{@\)@R@Q@33@{@@HQ@w@@@vff@k@Tz@h@@R@@R@  @ff@@p@@(@@@Vff@J=q@S33@<(@
=?Q???=q@
??(?33?
@9@=q@R@
@\@\@@z@ff@|@  @{@H@33@H@@Z=q@^{@A@:H@\@\)@H@@  @1@#
@.R@)@A?@ff@=p@<(@	?=q@_\)@5?{?޸R@????
=?\)?33?z?
=?p?33?@@  @K@=p@Y@x@33@=q@Q@@R\@Q@H@Mp@p@
=@@@g@QG@c33@*H@HQ@{@-p@.{@ @%@0  @(Q@:H@(Q@@
=q@H@w
=@#
@!@?p?@@*=q?  ?z?
@{@@@K@xQ@Z=q@s
@(@Q@@ff@ҏ\@@l@B\@>{@>{@H@0@4z@Fff@AG@(@Fff@C
@'@:H@AG@<@%@$z@33@z@z@7?33?H??33?  ?Q?G?\??  ?Ǯ?\?ff@\)@E@  @R@(@p@
?{@\)@G@qG@@  @p@@\(@s
@j=q@HQ@`  @Q@U@^{@jH@p@E@\(@L@L@E@C
@@  @N{@?@?H?ٙ@G?޸R??G?z@\@
=@=q@ @
p@#
@E@s33@@{@R@AH@R@@߮@@@H@{@
@E@  @@{@p@ƸR@~R@\)@(@@_\)@@=p@)@nR@a@@@9@,(@
p@@6ff@(Q@&ff@5@,@HQ@N{@>{@JH@vff@{@RA
pAAA&=qA,  A:RAo
AGAAR{ASAVH@H@zA@G@Q@z@p@p@H@(@ffA
@@R@(@\)@H@
=A{@@z@R@=p@zH@>R@h@n{@xQ@@|(@@@{@@\)A$  A%pA?AffAzAHA  @AɮAAAMA!AA"{A^HAA{AHA_AQA|A(  AyA$zAAA:{@@Å@p@@p@p@@A @s
@@U@(Q@@(@G@@@A(z@33AUA{@!@A733AAHAGA33A{AQA33AHQA  AAv=q@{@(A\A]A
{AQA.HA[\)AFHA<  ANRAAdAzAAx  AA+33A33A  @{@H@=q@33@@@ʏ\@33@Q@pAQ@ffA'\)AHQAPQAt  AsA
=Ac
A\AAA
=@\)A'
=Ao
=A(AA\)A
ABffAzARAG
=AXAhABffApApAQAC33AAc
AzAAA}A@@Q@ff@@2\@@p@\@AA!GAXzA9AAAQA(A"ffA{BbBA=qAÅAB  BAQB	AjHAAGAARAffAA(AffAARAHAkAF\A}p@33A,zAA	A+@\)@  @G
=@	@@@=q@@p@p@R@@(@\)A>ffA"RAvHAW\)A%ARAL  A(AoAO
=AH@<(@{@@G
=@2\@8@aG@~R@|@s
@i@zH@NR@9@O\)@8@,(@#
@   @ff?@33?
@?=q@?
=??H@)@x@O\)@p@
=??H@8@z=q@N{@{@n{@\)@@@o\)@3
@-p@K@@z=q@H@
p?\??H?ٙ?G?z??{?33?p?{?Q?33?\)???
=??{?
=?
=?Q?޸R?z?
?=q?
?
@7??G@33?޸R@@R@-p@(Q@<(@"\@G@:=q@N{@C
@*H@5@XQ@@@Mp@AG@*=q@"\@\@
??
=@?ff??{?{@
=?R@@z?{@
p@'
=@B\@
@C33@@  @nR@\@Dz@@R@@)@
=@1G@?\)A{@@w
=@Y@Q@33@@@@@ff@@@
@tz@r\@@  @G
=@#
@\)@*=q@@
=@{@\)@@R@z@
@Q@G@33@@=q@%@  @z?@\@\??(@{@@
=@w@ff@@ə@\)@@AQAaAA{AmA@ҏ\@љ@ƸR@Q@
A Q@p@y@33@\)@G@S
@Tz@Tz@\(@P@W
=@A@e@\@Q@_\)@1@9@#
@L@(@ff??@(Q@y@33@
p@@H@{@{@@(A@A"{AQAA@
A,  ABHA@|@A7@Y@@xQ@@
=@p@Mp@L@=q@  @أ@Q@S
@8Q@*H@@@w@Mp@:=q@\)@$z@.R@z?R??  @33@@I@z=q@y@@љ@p@A0zA$zA.ffA_AK
A?33A+
A
@
@  AH@33@@=q@@{@
A@@@33@#
@@@(@G@R@p@ff@R@@z@Q@@p@@G@7
=@5@~R@qG@~{@
=@@\)@\)@  @A:H@
@G@@mp@AGA	p@
=Ap@x@\)@8@\)@@\)@HQ@
=@|@H@@z@Z=q@JH@e@h@NR@.{@&ff@(@(@@&ff@	?\)?p@G?@\@B\@p@#
@%@Y@ff@{@
@əA6RAYA)AMA!GAN\A4QA\A#
=A@@
=@@ff@ʏ\@\@@{@\(@xQ@qG@@  @>R@_\)@~R@g@\@   @5@8Q@=p@h@%@%@.R@*=q@HQ@{@(@%@#33@=q@@@^R@@zA33AD  A6ffA\QAP  ARff@(A{A"RAQ@H@@\)@@33@G@=q@ff@{@@Q@ff@@@p@@@H@(@(@}p@	@   @Tz@@G@
=@ @'
=@"\@s33@
@
=@ff@=qA\ApA@
@@@\)@{A @\@R@
@@Å@@G@H@
@@@QA@\)@Q@33@  @@H@H@@@  @(@ÅAH@x@|(?{@?33@8Q@(@@Fff@\@ָR@=q@(AffA=qA QA
=@@A*{@H@\)@Vff@jH@q@W@fff@z=q@@:H@z=q@mp@w
=@S33@b\@H@(Q@@@<(@z=q@G@g@n{@w
=@`  @g
=@]p@^R@p@NR@a@5@6ff@Fff@JH@P  @@@3
@0@@@ff@33AIA@@33A\@33A@\(@{@(@@s33@W@qG@p@
@z@p@@ff@@\@R@@ff@x@ff@L(@!G@
=q?33?33?R??ff?Q?ff@{@@/\)@z@33@@@J=q@.R@A@.R@e@z@
@@(@=q@pA@q@Vff@8@E@NR@2\@
=q?
=???Q???޸R@   @
H@@ZH?R@33@\?z@?Q@Q@ @p@(@G@-p@:H@R\@X@g@\@k@W
=@b\@c33@I@0@S
@ZH@S
@p@7
=@5@L(@C33@@
=Az@@Q@A@-p@/\)@+@!@(@(@4z@H@@  @p  @*=q@G@!G?@
p?R?Ǯ@
H@*H@,@/\)@p?@Ǯ@\@Dz@QG@@Mp@r\@Vff@NR@?\)@9@5@2\@+@7@E@}p@Tz@Dz@&ff?@R@ff@$z@z@
@H@	@+@@ff@z@
=@@R@R@ff@@@
?@@
??
=????
=??@#33@Q?R@mp@p@G@G@_\)@:=q@@fff@.R@@Q@@E@H@%@@ff@\)@=q@{@=q@ff@{@ff@@R@
=@{???  ?G@z@
=@vff@&ff@XQ@,@0  @aGA*R@33@I?@333@B\@fff@R@أA=q@  @(@\@  @~R@Q@@(@@H@  @ff@G@33@R@\)@@@R@q@G@HQ@J=q@S33@\(@q@^R@e@^{@`  @>R@%@*H@{@=q@33AB{@l@lA	@@(@Q@P  @Q@r\@\@G@p@@Q@HA7A
A@ҏ\@ffA
HA(A@
=@R@A@z@\)@@
@(@ҏ\@p@33@^R@^{@\@ff@z@33@(@zH@q@(@G@@@ff@H@
=@ff@A>HA\)A"=qAx  A1A/
AA=qAA@33AA	G@
=@  @Q@ʏ\@@=q@@@ff@\)@\)@
=@(@=q@@@H@@33@Q@e@H@@R@Tz@z@tz@I@L@@Mp@AG@j=q@@tz@@R@b\@(@Vff@U@G@@p@
=@Q@33@@@\)@
@=q@H@(@z@  @Q@
=@G@@R@x@j=q@Y@Vff@XQ@Q@Vff@4z@5@E@>{@3
@W@[@L(@@
=@z@8Q@Q@\)@'@$z@@Q@s
@G@p@@33AA=qAAR@zAzA{AA
A&HAQ@(@@  @G@أ@
=@33@(@H@H@\)@
@@z@G@{@\)@p@Dz@L@fff@@@\)@@mp@6ff@I@#
@e@@\@Q@˅@HAAA"\A*{A_
A
AQ@@@\)Aff@z@H@=q@p@
=@
=@@@{@{@G@\)@z@  @@@p@@  @~R@~R@
@Q@w@@p@33@33@4z@W@zH@L@o\)@  @@  @AAA0QA9A5pA^{A9A0(@\)@ff@z@@ff@{@@ff@@
=@z@=q@\@s33@fff@:H@Vff@zH@o\)@o\)@^R@E@C
@R\@Tz@G@\)@@
@
H@|(@@!@	@!G@e@5@XQ@a@\@jH@=q@Y@7@P  @}p@R@@\)@@jH@fff@H@G
=@Z=q@e@h@{@xQ@r\@g
=@\@XQ@fff@k@R\@6ff@R@8Q@!@
@
@{@O\)@S
@_\)@g
=@?=q?@?=q?  @!G@E@Y@c
@p  @r\@@G@{@@Ǯ@@{@@w
=@ff@@fff@nR@@u@u@|(@Q@w
=@@h@^R@q@h@9@r\@h@?\)@NR@(Q@\@@7
=?(@ @g?33??H??H?G?ٙ?G@@p@8@S33@@\)Ap@Q@@@  @w@\)@H@R@(@@G@33@@@|(@u@e@G@r\@s
@N{@
@N{@
@8Q@=q@{@!@2\@@0  @,(@@@Q@@{@#
@x@Z=q@(@P@@@Q@(@@{@  @p@Tz@@H@
=@
=@Q@
@A-@JH@H@=q@b\@Z=q@ff@z=q@l(@+@!@8@A@ff@*=q@&ff@G@8@@)?@{????z?Q?z??@+@n{@w
=@XQ@I@h@w
=@H@
=@@(@H@@,@C
@{@@S33@Q@,(@X@@mp@+@?z?=q?=q@z@33?\)@
p?z@??(?  ?H?˅??R?(?G??\?\(?u?=q?(?\@
=@e@@R@@33@@@|(@hQ@_\)@AG?R@HQ@<(@NR@/\)@G
=@6ff@\)?p@Q@\@ff?(@
@@
@'
=@\)@\??(?Q?޸R@
@#33??G?˅??=q??
?p?{@Q@@:=q@g@@  @@{ARA AGARA
@z@RA@ff@
=@HQ@{@@33@ҏ\@G@@z@dz@fff@S
@X@dz@<(@>R@G@3
@'
=@$z@)@@E@5?(@Q@
p@Q?  @33@(@)@+@p@
@@ҏ\AA
=q@@Q@@У@
@ff@(@陚AH@\@
=@R@
=@@G@p@{@A!G@
=@p@@\)@R@~{@l@mp@5@L(@P  @]p@0@\@9@?\)@\)@:H@mp@!G@{@g
=@@s
@@=qAA{@  @p@=q@
@
A
AA@\)@@hQ@AG@:H@=p@<(@3
@z@@Vff@p@A@?\)A733@b\@U@n{@C33@&ff@>{@@
=@ALAH@>{@P  @6ff@@`  @G@@A@@@z@@(@W@@33@a@@w@x@:=q@@  @p@W@C
@%@i@|@l@q@J=q@U@QG@(@%@\?
@\@33@
=q@Fff@%@'
=?@@333@{@{@@\@R?У@\)@z@33@1@J=q@S33@fff@@@@{@@{A@A @Ϯ@Q@H@\@a@@]p@=q@U@Z=q@;@@@jH@|(@R@w@
@@{@S
@9@8Q@p@@!@C
@#33@ff?
??Q??Q@
=@\)@*H@ff@u@GAA4QABffA2RAA6\ARAAzA@
=@
=@˅@ᙚ@z@  @\@@z@@@
@G@ȣ@
=@
=@@\)@@=q@H@  @p@\@@U@7@C
@ @0@3
@NR@_\)@w
=@R@@@p@A@  @G@@@z@H@
@@{@
@@  @Q@ff@G@@I@9@:=q@:H@nR@?\)@$z@333@(Q@<@e@Q@'
=@\@ff@=q@:H@
=@
=@*H@@z=q@P  @X@I@@Q@8Q@@O\)@\)@W@	@)@G@?ff?˅?ff??zH?Q?u?  ?(?
?k?G?p?G?h?h?33??{?h?
?\?\??\?aG?G?B\?c
??p@{@I@|(@
=q?Q@z@@!G@H@mp?@$z??H??u?\)??
?zH?zH?fff?L?\(?G?333?=p?+?B\?W
=?J=q?#
?@  ?5?.{?B\?333?(?!G?:H?0?5?8Q?R?=p?u?ff@?
?E?(?!G??  ??˅@	@#
???H?}p???Q????33??G?xQ?}p??{?\?xQ?z?33?G?G?33?  ?p??Y?fff?\(?G?p?G?@  ?:H?c
?xQ?fff?\)?(?E?333??fff?p?J=q?  @L(@l@O\)@???@G@?
=?ff?\)?(?޸R?
?p??=q?Q?H???ff?
=?
?\)?G?R?p??\?(?33?p?\)?=q??aG?c
?xQ?Q?J=q?@  ?aG?+?0?J=q?J=q?J=q??
=?\)?޸R@@1G@@  @3
@JH@=p@0@7
=@Mp@JH@HQ@;@>R@1@:H@/\)@(Q@z@)@5@3
@:H@;@@\@   @-p@7?z?@
=q@Q@@Q@
=@33?G?z?\)@z@ @#
@.R@B\@nR@@(@@@A
AH@@(@@e@H@Tz@Q@33@k@8@w@nR@P  @\)@@@|(@Q@
=@R@@33@]p@O\)@B\@9@333@
@#
@2\@\@333@AG@!G@!G@p@
p@0@(@8Q@0  @Mp@B\@Y@qG@}p@@@z@G@g
=@s
@R@g
=@G@B\@J=q@E@K@X@@  @K@0  @@@'
=@G@
=@%@<@#
@6ff@G@@{@H@H@u@@=p??\@@Q?@@S
@jH@S33@J=q@u@>R@7
=@\)@@@@
H@ff@
?????33@   @!@H@\@(?G?
=?  ?G??  ?G??  ???ff?p?p?=q@
H?G?޸R@G?  @_\)@P?R?G@?H@G@
@:=q@?H@
H@?@z??(?p??\)??Q?У?\)?ٙ?z?Q?Q?У?p??ff??(?  ?H?G?\)?z?ٙ?
?Q??33???@(Q@{@H@=q@x@G@Vff@@A!G@l(@:H@!G@C33@`@@@U@J=q@N{@J=q@/\)@7@#
@'@.{@9@ ?ٙ@@=q@
=q@
@@Q@
?Q?p??=q@
=q@@{@5@<(@+@@
=@x@Y@@pAU@R@33@\)@
@?\)@ @W@1G@G@@@2\@R?(@@\)@
=@@Q@\??@#
@&ff@   @p@\)@.{@@$z@ @\@@G?z@%@
=@
@@)@*=q@0  @:=q@O\)@&ff@\?
@
@,@\)@ff@ffA5@ff@@  @a@/\)@K@P  @l(@1G@C33@(Q@-p@:=q@   @{@G
=@Y@NR@8Q@@@'
=@0  @z@ff?(@33?p@
H@R@.{@A@ @,@E@Q@H@p@A
A{33@p@^{@QG@
p@R@4z@A@J=q@;@-p@W
=@@\)@ZH@!@
=@\@33@
@\@#
@  @@\@\?{??(?\)?
?33?R?  @z@ ?Q??{@\?
=??R@\)@33@@%@#
@
=q@ff?z@@
=?(?z?(@   @
=@g
=@+@I@k@=p@p@5@1G@2\@g@6ff@@
=@@\@P  @@^{@Fff@1G@AG@6ff@2\@0  @.R@7@333@.R@@@@
=@:H@@G@0  @Dz?@ff@\)@&ff@33?z@?(?p@@
=@@@J=q@jH@  @=q@=q@G@@@ff@ff@NR@H@@R@z@@e@`  @^R@Tz@,@"\@  @@=q@ff@*H@<@I@K@8Q@jH@|(@4z@#
@G@R@C33??=q???p@C33@@Q@hQ@G@z@p@ZH@@QG@+@@2\@5@@R\@E@Q@S33@Tz@L(@jH@y@g
=@N{@hQ@k@I@p@'@.R@P@C
@@6ff@1@@"\@G@"\@1@$z?  @
p@	@ @
=q@p@@)@A@O\)@hQ@p  @q@  @tz@tz@\)@{@hQ@J=q@l(@  @
=@(@@@*=q@(Q@
=@!@^{@`  @33@g@[@5@p@6ff@\@]p@S
@z@  @
=Ap@Q@Ǯ@R@H@(@{@@:=q@R@{@p  @p@e@@@?G@@  @/\)@2\@%@=q@:H@Q@+@5@"\@&ff@'
=@\@??Q@@
H@@!G@\@@
@ff@	@@	@@R@@@'
=@   ?@z@q@S
@θR@B\@
@\)?\?޸R?33@G@{?R?(?@ff?H?p@\@
=q@\)@G@	@@@??G??\?
?
=???p?  ?  ??Q?
?{?ff??@\@\@3
??ff?@;?ٙ?=q??H?Q@=q@HQ@?ff?H?޸R??33?z?ff@?{?z??@ ?p???=q?(?Q??Ǯ?\??
?˅?33?R?Q??p?˅?@Q@?޸R?
=???=q?  ???=q?  ?H?@ @ @@ @#33@Y@HQ@3
@-p@?\)@9@
=@&ff@6ff@9@333@(@*=q@.R@#
@Q??(?
?\)@\?ٙ?
=?G?{?H?
=?
=@ @2\@
p@33?(?˅?{??G???ff@ @z@5@@>R@S
@A@}pA@@@p@  @
@
@ʏ\@@\)@@p@33@ff@qG@p  @C
@Tz@;@y@jH@@;@@@I@S33@1@p@JH@R@@k@`  @ff??G?(?(?  ?\@Q@QG@u@@ָR@R@=q@33@H@{@@@H@@
@˅@@@Q@=q@G@G@33@@p@{@@@z@\)@Q@\@n{@A@s33@W@/\)@w@g
=@)@NR@S
@R\@'@6ff@9@%@9@2\@K@|(@@|@i@zH@<(@33@\@w
=@n{@tz@G@=q@`@y@u@e@jH@mp@q@\(@.R@S
@P@J=q@(@I@E@G@:=q@333@333@ff@R@@ff@z?ٙ?  ?\?ff?}p?p?ff?H?R?  ?{@A=q@@@5@H@[@,@P@@@[@-p@H@@@33@
=q@z@=q@G?У?=q@
@ff@1G@4z@'
=@   @????z?G?p?ff@   ?ff?=q??xQ?=q?fff?c
?ff?z?R?
@
H@333@u@I@[@H@]p@@J=q@e@Y@>R@5@,@JH@+@!G@<@Dz@<@0  @aG@L(@7
=@>R@.{@(@33@G@!?Q?H@@\@+@Q@R?33?p?\@
=??O\)?R?@  ?333?8Q?0??=q@(@J=q@nR@i@\(@jH@U@]p@H@AG@E@ @+@@,@'
=@/\)@Q@\@@\@z@Q?ff?G?(????H?@z@?  ??
=?@??ffAff?(@(@E@@  @`@z=q@|@@z@p@{@\)@
@@@33@(@\)@@R@{@w
=A]@aG@{@6ff@s33@r\@c33@~R@<(@#33@Fff@"\@
?H?\????@#
?\?33?  ?aG?W
=?\?\?=q?@H@7
=@HQ@a@|@=q@@h@e@dz@XQ@]p@L@I@G@C
@QG@>{@,@.{@Vff@<(@>R@L@AG@2\@@G@R@33@?
=?\)@G@??@??33?Y?xQ?c
????z?Q@l(@@G
=@ff@z@\)@2\@@ff@p?(?
=??p?z@G?Ǯ?33?=q?p???z?H?n{??
=??@
=@
=@E@K@*H?(?z??u?+?   ?#
@@<?\??#
??8Q?\(??=q?
=@'?\)@R@AG@ff?(?ٙ@@
H@(@{??R?Q??H???\)??\?R?\?\@
?޸R?\)@@#33@G?ٙ@h@@ȣ?Q?E?8Q?(?=q?s33?G?W
=?u?ff?
??ٙ@>R@[@JH@4z@P  @-p@z@
H@@@?z?  @@@\??p@  @A@AG@&ff@J=q@
@O\)@o\)@z@w@@9@]p?(?=q?Ǯ?
?(?^R?333?R??#
????}p??p??ff?{@@8Q@p@@@????p@?Q?\)??ff?ff@!G@Tz@\)@>{@W@dz@P  @0@@Q?˅@
@H@   ?z@?{?\(?=q?Y?z??{???Q?˅??ff?@ff@4z@`@xQ@I@1G@0  ???Q@@z??
@R@(@&ff@;@5@z=q@jH@~{@
=@z=q@,(@(@H@QG@QG@AG@@E@E@@@G@?  ??R?(@@G
=@@@Y@NR@aG@Dz@@w@
=@@\)@(@@A\AzA;AV=qAf\ApAz\A(AAuA33A\)AQAsA33A\)A:{A733A#
=AX  @@@U@z=q@$z@0  @Q@#
?(@,(@`  @zH@z@z@y @@R@
@(@
@@Q@
@\@@G@@(@Ap@@\)@R@{@@\)@G@@z@
@@=q@  @@{@@@
=@{@@p@@H@@z@A\)A
=@
@@H@H@Q@A\AAA{@{@R@@{@(A A\A33AAHA=qAp@(A@A AA AAffA  @R@@H@@
=@A@@z@\@H@@(@33@\)@G@\@  A @@@@@R@G@@Q@(@H@p@@@H@33@A A @Q@@(@
@Q@@@p@@@@@Q@ff@@p@\)@\)@
@H@z@=q@@(@(@
@(@
@
=@@33@أ@ff@33@p@  @@p@R@33@z@H@@G@\)@R@33@@  @33@@z@@@=q@@Q@p@@  @@p@(@@@@@
=@H@@\)@
=@  @Q@ff@
@@(@z@p@{@{@
@@33@33@p@z@R@@H@@\)@
=@Q@=q@@@R@@R@\@Q@z@R@\)@@@@@@@@@{@
@{@@\@z@
@@
@@\@@@@@p@z@\)@ᙚ@{@
=@\)@@@
@R@=q@{@{@@\@\)@=q@z@@
@z@@G@{@33@@\)@p@  @@  @ff@z@=q@z@@ۅ@@p@\)@ᙚ@@G@@
@z@G@@z@
@
=@ff@@(@@{@\)@{@
=@@
=@(@
=@\@@  @=q@z@\)@@H@  @޸R@  @ᙚ@@@@@\)@@33@(@@
@=q@@ٙ@H@G@ff@׮@=q@p@@љ@
@  @\)@޸R@33@ff@H@G@  @
@@=q@@ff@@z@@@=q@G@@
=@
=@
=@\)@ff@(@H@=q@@z@H@@
@@\)@ff@@33@ڏ\@=q@ff@=q@ۅ@ۅ@׮@=q@  @ٙ@@ᙚ@@@=q@@@@G@=q@@@33@33@\@\@p@
=@{@33@@@
=@\@@@@ff@@Q@
@@z@
@H@p@\)@Q@
@ٙ@Q@H@33@33@z@ff@@@(@@=q@z@H@  @{@
=@p@@@
@(@@G@@Q@\)@p@@@{@@@33@33@p@p@@@R@{@p@G@ff@z@@z@@{@G@=q@p@@\)@@陚@  @  @@@@{@@@
@Q@z@A{@\)@\)@@{@zA   AGAA@ff@
@@\)@@R@33@33@\)@@p@R@(@@@  @@@\@\)@ff@G@R@@(@33@=q@(@H@
=@@z@{@陚@\@\@H@@@@
=@ApAff@
@(@@G@@G@@@\@\)@=q@@@@@\)@{@R@(@=q@=q@G@@Q@@߮@
=@R@Q@@Q@@R@@(@33@=q@@陚@陚@@=q@\)@  @\@@@
=@G@@@Q@߮@@
@\)@z@@z@
@ۅ@=q@@33@ۅ@ٙ@ڏ\@=q@ff@ٙ@G@
@љ@У@Q@Q@(@p@Q@
@ᙚ@33@@
@H@@=q@@ڏ\@  @@@\)@=q@  @33@@G@  @@H@Q@(@z@@
@@
=@ff@p@@@@{@@@@Ӆ@Q@Ӆ@љ@@@p@ٙ@33@z@ڏ\@
@  @z@@(@G@H@H@p@p@R@z@@@Q@Q@@(@@@أ@ָR@(@@  @ָR@p@z@@أ@{@@߮@@ۅ@ڏ\@޸R@\)@H@G@@(@p@@Q@
@\)@@Q@@߮@ff@(@@Q@@陚@@33@H@
@@p@@@Q@@
@33@ᙚ@H@(@z@H@=q@
=@@@p@G@
=@GA@ffAA{AQAHAffAA
=AzA
A  A=qAA\)AzA\)AA\)AA
A	AAffA\A
RAAA=qAzARAA	A
{A	A
A(A=qAA\)ApAGA33AA
RA	AA=qA\A\AARA A
@@@@\)@=q@(@@(@R@@@
=@@G@
=@\)@pAGAA	AffAAAA=qA\ApAA  AAzA
A=qA
=AGAA{A
=AARAAA33A
{AQAHApAGAAzAAQARA{AAAffAA
AHA   A"HA!A"\A"HA#AA(AGAA"\A!A%GA$(A$zA-A,ARA'
=A!AAA
AQAAAAAzA(AAAp@ff@A	GAA	pA	A
{AAA
=A	GA
\AQA  A
AHARAp@\)@@\)AAGA
RA@
=@AHAA(A\)AApAffAAAA33AR@@p@ff@@@z@@ff@(@@
=@@\)@\)@=q@
@{@p@{@=q@\@@  @{@@H@(@ff@@\@33@(@
=@(@@33@33@ff@@@z@@@G@=q@H@@޸R@\)@@ff@\@Q@
@@
@@@@@ۅ@33@@p@@33@
=@
=@(@ff@@陚@R@@  @@{@z@\)@p@(A @\@\@@z@G@=q@p@@@(@@33ApA33A@@33@ff@@R@@G@  @H@R@=q@@@@A @{@@@@p@@
=A A   AAApA=qA   A@{AG@Q@
A Q@Q@\@@
@@@\@@=q@@@ff@p@@  @@@=q@(@\@ff@\)@ff@
@Q@R@@@ff@@{@@R@@z@H@\AHA(A\AA	AzAAA{@@@
=@ff@@
@\)@ff@G@p@@\)@@Q@=q@R@R@{@@@@33@
=@z@R@  @@@\)@ff@\)@33@@G@H@33@@@
=@@G@@z@=q@@@H@@@@@@R@33@Q@@
@
@z@@@\)@\@=q@G@(@@  @ff@@z@@@H@R@=q@H@33@\@=q@=q@p@Q@@z@AH@(AffA\A\A{@
=@A   @
=@
=@(@
=@{@
=@R@=q@ff@  @@
=@(@33@{@@ff@@(@@33@@@\)@@@33@=q@\@ff@@
@ff@H@\@Q@G@(@p@@
=@@@
=@A=qAA @R@\@33@  @R@p@z@
@@  @\)@@@@
=@{@@@陚@H@@\@R@33@=q@G@@Q@p@R@@(@
@
=@{@z@
@@Q@@{A AAA\)AA A   A   @@33@H@H@@
=@ff@  @{@{@{@p@{@@@@@@\)@@p@
@33@\@@p@@33@
=@G@H@=q@@@z@
@@@\@A QA A\Ap@
=A{@@@G@R@(@G@@\@@@33@z@z@ff@ff@@{@@\)@ff@@\@33@33@=q@ff@R@z@@ff@@@@
@\@@@@@@@@@ff@@A
=AAAA Q@\)@z@\)@p@p@G@(@\)@  @ff@@=q@  @
=@R@{@
=@Q@@@@{@
@{@ff@@\)@(@=q@@@@p@
=@(@@\@@@\)@\)AA=qAA\ARAA @@(@\@R@p@33@@@
@@@
=@
=@\)@
=@R@G@z@@{@p@z@@Q@H@  @H@H@=q@
=@@@@@  @G@G@z@z@H@G@Q@Q@Q@(@
=@z@  @Q@@@@\@@@@Q@@R@{@{@@@
@R@@ff@@\@@\)@=q@(@{@@
=@33@
@@@  @\)@@\@R@\)@Q@@\@=q@@@\@\)@G@=q@@p@@ff@33@p@p@\)@z@(@
@@=q@޸R@G@@@@߮@@{@
=@  @p@H@޸R@\)@߮@G@G@G@@Q@@G@=q@\@H@@@(@@@\)@R@ff@ff@R@@ff@@@ff@
=@\)@z@@
@z@33@H@@\@@ᙚ@
=@33@ڏ\@
@\)@
@ff@ff@@@  @G@H@@(@@@p@p@R@\@{@ff@
=@p@(@@ᙚ@\@=q@\@@ᙚ@ᙚ@ᙚ@\@Q@\)@Q@G@z@@@@@Q@\)@
=@\)@  @\)@
=@
=@߮@@@Q@=q@@G@=q@@z@=q@@@
=@@ᙚ@@(@@  @R@R@@
=@R@@z@z@z@(@(@@ff@@{@z@33@@H@@p@H@=q@@
=@@Q@@@@  @޸R@߮@{@@
=@  @@H@G@@@@\@
@@@R@\)@@@@@33@@33@(@@@ff@33@H@33@
@\@
@陚@
@G@@=q@=q@H@@@R@@@\@@ff@@@(@@(@\@@\)@p@@  @(@\@{@RA (@ff@@{@33@\)@z@ff@R@  @Q@ff@{@ff@@33@@(@p@@G@@@@=q@(@
@33@@@=q@@@ff@ff@@=q@  @(@@33@\@@@@@\)@ff@@@=q@R@\@@ff@
@H@H@G@Q@
=@ff@{@@(@p@
@(@
=@R@@z@ff@@@@{@ff@(@@陚@=q@@@{@@p@  @ff@@{@@{@{@RAAA=qARAA\)A{AAHA	GA	AG@@@=q@@\@@ff@@\@@@Q@@p@G@
@R@@
=@  @pA zA(AAA
A	AA\AAA	A
A\)A
A
=AAHAAA=qAAzAA
=A
=A\)A  AA=qA=qA\)AAA  A	A
A
=AAAAQA@
=AA
=AAA	A
AAQAGAzA  A
GARA
=ApA"HAAApAA{A!GAffA$zA-A33AA(A\)A
=A\)AQA\)AAAA\A\AAGA
A\A	A
AA	AAA  AA\A	AAGA
=A=qAAffA%GA%pA"RA
=ApAGA  AHA QA=qA AGAAAAA zA\A @R@@\)@33@=q@@@33@陚@=q@ffAA   @@\)@{@@@
=@@
=@(@R@@(@ffAHA(AA
HA
A33AGAA\A{A
A
pAffAA
AQAzAA\)AAHAzA
A@G@z@@@@  @@RAAGAG@p@33@(@@@Q@ff@
@GA @
=@@\@RA@pA(A=qA\AAA"\A$(A
{AA&=qA&=qARA*\A)pA(AA  A
pAHA z@R@A(AA@{@@@
=@z@\@Q@@Q@
=@R@ff@@  @@@z@@\)A zA  A\)AzA
=A
=qAA\A
AA33A
=AAARAAHAAffAffA
=Ap@A(A
=AAz@\@@@(@@@Q@\)@R@(@=q@{@@H@@@
=@ff@33@@ffA\)A	A	G@ffAffA33AA
GAAffAGAA\)A"HAA\)AARAAffAA\)AA{A33A(A  AA Q@H@{@@
=@
=@@H@\@Q@@ᙚ@
=@=q@  @=q@  @
@@@@  @QAzAA  AA\)A
A33A
A
A\AQA=qA
AA33ARAAzA(AAG@
=@ff@=q@\@p@R@G@ff@  @{@H@=q@33@@@H@@Q@@\)@@Q@\@R@A\A33A\)A  AA\)AAGAQA=qAzAQA$zA'
=A.\A-pA'A33A)pA\AQA=qA
A\)A=qA  A
=A
=AGApAA33A@z@\)@{@
A (A@@ff@\AA{A
=AAffAARA33AAAzA{A  A{A(A\AAA\AHAAAA AAQA
=AAQA33AAHA  A	GA
A(A
AAHA
GA	@pAAQAA\)A33AAGA
ffA\)AA  A	A  A	AffA\A=qAHAHA(AA
ffA	A
=AA(A	A	GA
A33AA	AA(AHAA	GA@
@
=@
A
=A{@@
@
@R@z@(A QA{@ff@Q@HA@ffA  @33AffAAzAAA@@
A Q@  AA
A A A
=AAA\A@@=q@pA A AA @G@=qA
=qA@p@@陚@\@{@{@{@\@=q@@陚@p@=q@\@\)@\)@@z@@@{A	A33AAzAQAAAAzA	pAAzA(A$(A'
=AzA!GAA@@\A@@陚@@p@\)@G@  @ff@\@\)@
@
=@@G@\@
@H@@@ff@z@Q@\@zAGAGAAAAA
A(AAA
A  A  A (AA$zA+\)AzA33AA=qA	A(A
HA=qA  A{@@@z@R@33@@H@  @@
@z@@(@@\@=q@@@A=qA
A (A (A	A AA
A	A	ARAAA
{A
=AQAGAA	A
=qAAA(A\)A@@ff@@ff@G@z@G@  @@z@33@
@
@\@  @Q@\)@p@p@R@p@\@ff@@@AffAQA@A
=AAA
=A{@{@G@\)@RA=q@ff@R@\)AA!A
=A
=qARA A zA=q@@@@z@@  @@@G@
=@
=@@@H@@@(@@@A(AA
=AA
A
A
ffAA(AGA\AA	A#
=A#A*{A.=qA/\)A/
=A-GA+A(A*RA.=qA(AA=qA\)AAAAAAA\)A\A
ffA\)A  AAA(A
AAA\)A\)A
AA{AQAAffA&ffAAAA\)AARA\)A
AA&ffA&\A (ARAA zA
AA\A	A (@@AA @@
@@@p@ff@{@\)@@p@HA @@
@@Q@p@ff@zA
=A(AA
=AzAAHAAA
=A{AAA"{A&HA.{A1GA1A"RAffA QA\AA
AA
pA
AA\)AffA
=AzA
A=qAG@z@{@Q@ff@H@G@
@G@@@
=@G@(A
{@(A{@HA
AffA!A,zA$(A%A%A(AAHA33AA{A
AGAffA
RA
A
ARAA=qAA33AAA
=A\A  A	ApAA @
=AA A @
@AAARA
\AA	GA
=A=qA(A33AGAAffA#
=A%A"HA%pA.ffA)A)A*ffA4A733A6\A=qA4(A,QA$A
AQA
AA QA zAA{A
A A(A  AA\AA=qAffA33A
GApAHA
A{AAQAA33A
A!A-pA#
=A*=qA8  A9GAAAF=qADAJ\A=A<QA<QA9A=A6=qA
=AA
=A
AAA\A"{A(A)GA
=A QA!A#33A#
=A A  ARA   A"RAHAQAAAffA
\A	AQA33A33AA\)AA	AzAQA33A
GA
ffAA\A33A"=qA#33A#
A$(A$QA#A#
=A  A
HA\AARA (@@@H@
A AA
A=q@\)@@@@@\@R@R@H@@  @G@@\@(@pA33A33@@@(A zA\AAAzA	pA?GARAzA\)AAH@pA33A (@H@zAA   A	@=q@p@H@@
=@@{@\@
=@p@(@@\@@
@ff@Q@(@@
=@pA{A	A
ffA  AQA
=qAQA(AQA	A
A	pA
RAA\A{AAA
AzAA(@\@@@H@(@(@@33@(@(@\@  @\)@  @  @H@@@
=@@@
=@p@G@{@H@  AQA(A ARA  A
ffA	A
\A	AAA
=A
A33A=qA=qAffA\AHAzA @@\)@@
=@@@
=@\)@
@@G@Q@@@\)@
=@R@ff@@H@\)@33@@33@ffA{@\)@z@H@\A
A33AffA=q@R@@R@(@@33A A   A A  AA{AGAffAA.=qA(AGA	A33A  AzAAA
=A@AA\@
@@ff@{@\A @p@R@Ap@AffAGAA\)AffARA  AzA\)A\AAAA33A33A#
=A1A"\AzA  AQA\)A@ff@\@  @@@@@@G@
@@z@@
=@R@\)@ff@ff@@ff@@@
@A=qAHA\)A@ffAA{AA
pAAzAAffA(QA#A'33A33A%A/\)A\ARA	pAAGA
{A(AARA\)AA  AAAAAffAzA
=qA  A
{@AzAG@AQA  A\)AApAA33A
=AA A&ffA)pA&ffA2\A:{AzA5A$(A\)A#33A5A5A%A33AffA
=A	pAAApA
=qA
GA
=A	pA
A)A&HA"RA#
A
=A33A(AA
pAAAzAA(AQA\A
A(A
=ApA"HA'AA	AAA*=qA.ffA1A3
=A4(A9A;
=A<(A?\)A>\A;A5A.\A0A2\A$AAffA\)AAAA{A  A\)A
=A
=A{AA
A  AA
pA\A33A
ffA(AAA33A  A33AzAA	GA
A-A.=qA5A9A6RA-GA>HA8A7A/\)A(  A\)A\)AAAffAGAHAffAzAA(A33A  A\)AH@QAAGA	ARA33Aff@\)A AH@R@{AA{AQA  AA  AAARAAA
ffAA  @@\)@zA\)A
AQAHAA
=AAQA @33A @R@@\@G@@(A
=Az@  @  @
=@@z@=q@@H@\@@@(@z@\@@=q@A=qAA@
=AQA\)A33A  AA
A)A+A+
=A,(A.{A1A(  A (AGAA\AHA
=AzAGAA zA
=ARAA\A=qA @G@@
=@(@
=A z@A@
=@
=@@(AQA  @RA
ApA
RAA
=AA=qA(A  A{A%A"HApA
A-AQA%AA
A  A	AA
=qAAAAARAzAA A QAHA33AffA=qA\)A@
@@@A
AA(A(AA\)A
pApAA{AA
A
=AAQA=qA  A!pAAzAAzA\)AQA
AA
ffA
=qA	A33AA
{AA	AHAAzA
=AGAp@(A (@R@@@  @@@@QAA QAHAQAAA\A	GA\AffAA  AAHAA(A
=qA\)AQA  A(A{AAAAAzAHAQA33AAQAAAzA
ApAzA33AA
{AzAA{@@(A zAAzA\)A=qA
=qAzAQA
AAAAA"=qAHAzA{AAA8A:{A  AHA
ARAAA-A#AA(A{A\A
=A%AAA
A33A=qApAGAApA	ARA\)AGAAffA\)@  @AAA{AzAA  AA\A"ffAHA/33A(  A(QA.ffA+A0A#
=AARA%GA.ffA9GA3A-AHAA=qAA
=AzA(AA AAAffAzAGA=qAAHA=qApAAAffA  AA
{A	AHA{AA
A A$A'A'A AA"RA=qA+33A)A'
=A   AA
pAQAA\)A{AffA\@RA AzA AzA33@A
A\A  A	AARA	A
ffA
@A
=A  AA AAQAHA(AA(A
AAARAAA!GA$zA(  A-A+A'AAAQA	A
A{AAAGAAA33AGAARA33A	GA
=qAAffA@AHAGAQAA33A
{A  AffA  A\)A
ApAAA\)A  AAARA/33A*HA1A0A)GA{AzA
A"=qA!AAA=qA
RAAAzAQAzAAA	A
AA	GAAffA  A{AA@@A{AAzAAQA	ApA
A=qA
RAA$(A&\A   A*\A)AA%A
=A=qA\)A AA"RAARA=qAA  AQA
AAA
{AGAQA{A A zA   A @\)@RA (A A@
=A AG@(@33AApA
pA(A\A\AA  ARAHAGAA=qA zAAA(AAA%pA!A#A"ffA"ffA"\A  AA\)A(A
=A\)A
=qAA	pA\)A=qA  A
RAA AApAffA(A
A	GA
GA	GA
A33AA=qA(A
=AQAGA=qAA33A\)AGA
A((AA@@Q@z@@@AA
A
A
=AA@AQApARAA\A
A\AffA  AAzA.\A,A&ffA\)A
=A
=AzAGAzA
=A
AApA
=AAAAQA33AAA
=qA\)A33A	A{A\@ffA	A A
=AAA
=AzA\A33AHA$  ARAAzAzAA!A+A%A'
A+A*=qA)A#33A'A'\)A$zA&ffA$A#AHA\)AGAQAzAAffAAARA(AAffA\AzA
HAA{A	A\A	AAQAAffApAAAzA=qAA zAQA  AHA33A
AAAA!A!A!A'A)GA#33A%A'A   ARAA	AQA=qAQAA(A  A @=q@A A@ff@(AAQAAA
AAffA
pA
AA
=qA
ffA	GAA
=AQA\AAzAGAGAAA\)A	pA{AHA  @ffA(A\)A\AH@{AQAGA AHAA=qAA	GA	A
A(AzAA33A	p@{AA{ARAQARAQA
A
=qAffA
=A{ARAffA33AQA\A33A
=A
=A\)A
\A
{A	pA
A
\@\)A\AA  A
=A33AA QA@A A
=AAQA(AAAGAGAGAHA A zA{AzApA
RA\AAA
=AA=qA
\AA
AzA
A
AAA	GA=q@33@(AAffAA
pA=qA	A\AAAQAA   @@@A\)AffARApAHAAAAA
HA(AA	A	AffAffA=qAAHAA
A\)A#33ApA
=A-GA*=qA.HA33A!A
=AA
AQA=qAQA=qAzAAffAA
AQA
{A	A
=A\)A=qAQAAAA	A	GAAzA
AA
AAzA\AHA=qA\)A!A&\A&\A.{A-pA4(A*=qA'A(AffAA33A
RAzA
AzA
=qA
RA	A	GAffAQA33A
AA
A	A  AHAffAAAQA  A	GA  AQA
A	pAAQAAGA
=A!pA QA=qA"\AQAA-AQA\)A(AA)A (A"ffAffAHA(A{ApAHA
HA(A(AA(A	ApAA\A=qA=qA=qAAGA  A  AA\)@
A33A33AA33A
A	AAzA
=AGAGA(A#A%GA+
=A)A,QA AA33A=qA#
=A33AzA=qA\)AHA{ApA@@pA{A
AHAA	pA33AAAAffA33AHA(A   A(A   AGA{AA=qA
A
AA\AzA
=A\)A=qAAHAQA,  A/33A$(A%GA A!A\)AAAAA
\AHAQAffAA{AAffA=qAA
RA
pA
HAzAA\)AzA
{AzA\)A33A QAffA\)AQAAAAAzA
A\)AA
AA  AQA"=qApA$AHA	AQA(  A\A{ARAAQA=qA
A
=AAA(AAQARA
=AHA\)AHA
=AA{AQA=q@@
=A (@A QA AAp@AGA  AHA{ApApA zAA\)A(A
\ApAA
A
A
AA
A
ffAA\AzA\)A{AApA AAAffAA
Aff@(@GAA (@(@G@H@p@z@ff@@p@z@@@\)@
=@@@\@33@AGA=qAA
=AAA,(A1A3A.HA&HA.ffA#A4zAzAAA
AAHA(ARAGA (@A (AA33A{ARA=qA Q@\@(@33@@@zA ApA A{@A z@ffA A A\ARAA
=A{A:\A1GA&ffA2ffA-A2{A/A(@{AA@\)@pA
=A33A (@33@(AA   A
A
A
\AApAzA
AAzA @RAp@
@@@AA  AzAzA\A{AQA\AAA"=qA$QA A$  A,A.ffAAffA$A%GA
A
AAA!AA\)A\)A	GA
pAHAQA
\A(AHApAffA33A(AzAzApAAHA  AQAApA=qA  A(A
A  A\AzAzAARA QA&RA/A1A5A4A:RA9A;
=A:RA<A'\)A QA\)A{A  AA zA
AA(QA!AAAA A(  A
=A(ApAA\)A=qA(A  A	GA
RAzA
pAzA33A{A  A	AHA33A (AA  A{AQAAHA,A:\A!A;
ABffA
{AA)A!A QA/\)AAGAAAA%A"ffA   AzAAApA(A33A  AffA{AGA@AAQA\AQA(A(AAGAAA!A%A$AA AA-A0QA0A2\A6RA3
A0  A.RA/
=A,QA+\)A(A zA zAA
=AAHAAHAA\)AHA  A{AffAffA
AA
ffA
pAAA
=A\AA=qAA#A(A&{A+
A*RA)A'AA=qAA33A
=A&\A   ARAA=qAAARA33AAA\)AAQA
ffA\)A33AzA	pA	AAA	A	A	AzA
AffAGA\A\AffAQA  AGAAAAA   A"RA&HApAQAApApA&{A&ffA$QA(AA	A  A
A
AQA
A=qA  AAQA	pAz@(@ff@p@\)A(A
AA{A\ARAGA
ApAA
GAA
=A33AA(AA  A
=ApAA(A\A  A{A A$A+33A.ffA-A (A(AA%A=qAAGA"ffA$QAzA=qA
=ApAAHApA
A	pAA\)A
GA
=A	pA  A
=A\AAA33A\)AA
=AAGA\)AA
AAGApARA(A$A&RA+A3A,(A+A(A'
=A(QA(A!AHA%AA33AAA\)A(A
AffA{AA33AffAGA\)A=qAA
=AA A
ffAQA
=qA
\A(A{A33A(ApA{AHAffA$  A\A{AA
=A
A	pAHA1GA3A/A)GA&HA"ffA AA&{AAHAHAA!A
=AffAAAzA=qAA
{A
=A@@\)AA@
=AAAAAAffAAGAAAAA
HAzA{AzAA zAGAA
=ApA AARA  A(A(AQA
G@{A
A  A (@
=A@H@
A@{A\)A\@@=q@@33@=q@@(@  @ff@@@=q@=q@\)AA=qA\A\)A
ffA	A
=A33AAQApAAA{A  A\A
A
{AA	A	A=qA  A\)A
=A
=A33A	GAHA33A  A
=A
AGA   A z@{@@R@
=A   AAA=qApAAffA	AQA
=A
A  AA
ffA
ffA
A
{AA	GARA=qA(A
=qA	GA(AHA=q@{A @(A\)A=qA A @@\@@@\)@(@@@\@@G@@@  @@@z@z@\@@z@@H@(@\)@@@A A=q@ff@Q@@33@@@R@{@\@R@{@@Q@\)@H@
@H@=q@Q@
=@Q@{@@R@z@\)@@G@33@@@\@{@H@@33@z@@z@  @\)@@@\@@@
=@{@@33@H@@  @@@@33@@\@@陚@=q@=q@@@33@H@@{@ff@@G@ᙚ@@@@@@ff@
=@{@Q@Q@G@=q@\@H@{@R@@=qA z@{@R@@=q@@z@@@G@G@@@Q@@(@{@@  @{@ff@@  @{@
@@  @@Q@
=@{@p@(@@@G@  @@  ApA  Ap@R@AQARAA	GA33A	A
=A @RA Q@33@33@@A @p@=q@QA   @ff@@z@\@@\@=q@ffAp@Aff@@\@G@\)@@G@R@
AAAA=qAA=q@R@\ARAQA	AA  AQA  A33A\)A(A33A{A{A\A  A
=AAA\@@A@Q@@{@
@@ff@G@33@(@@@Q@@@@{@@(@{@A{AGAA	A(A
\A
ffA
A  A
AAAHAA33AA\)A
ffA	A
=AAHA	AAffA\)@@H@\)@Q@{@@=q@\@@@
=@@@@Q@\)@@(@\)@RAAA  AA
A33A
A\A
A
A=qA
=AffAAAAGAApAAffAAAA(A
=A{A=q@{@\@@@=q@@R@R@@  @@ff@(A(ApAARAzA33AAA{A\A
AQA=qAA  A{AA  A33A#\)A'
A$A'
=A#\)A   AARA
=ApA
A
AffA  A=qA
AzA  @\)AA (@ff@@\AA"=qAA\)A33A(AARA
=qA
A33A\)A\)A\)A
=A{A=qAAAAzA=qAA!A (ApA33A{AAHA(A"RA"RA.\A\AA(A  AA
pAHA-GA@A'A.ffA	AQA
A
=A
=qA(A
GA33A
=AA(AAAA{AA  A	A	A
HA\)A
A{A  A  A
A
A
A
AA
AzARAA
RA	AA
=AzA@R@R@33A @@
A z@AA
{A33A  AzA
\AQA z@{@p@@G@\@33A
=A@
=@RAGA
=AA=qAA\)AAGAAAffAHA\AAff@=q@@(@A
=AzAA A	A
{AAHARAAGAGA33AA@A   @@pA A @@@(@@\@{@@@ff@@@@{@
=@ff@@@{@@
=AH@
=@@
=@@G@z@G@=q@H@R@\)@
@@ff@R@z@G@@@\)@Q@
@@@R@@G@陚@
@z@z@Q@ff@@ff@  @(@ffA (A AAApAARA (A A AGA Q@@AA QAA @\)A@H@@@R@z@(@  @p@@z@p@H@33@A Q@ff@33@@33A @A AApA A (AA
=AzAGARAAA
ffAA\)A
ffA{A
A
ffAAA\)A\AzAA
{A33@@@A   A   @ffA QA (@@p@@ff@@@(@A Q@ff@RA AA zAzAHA(AAA
HA\)A
\AA
A
AA  A
A
RAQAzA
RA
A  ARA A z@AA(A
\AAA   ApA\@{A33@H@H@@ff@R@
=@G@@@G@Q@z@=q@@  @Q@@{AGAHAAAAA
A
\AzA
A\)A\)AffA  A
AA\)AAAp@Q@
@z@ff@(A\@
ARA  A
=Ap@@R@\)A=q@@R@p@@p@33@R@@
=AAA\)AA
GAAQAA33A  AzA  A
=A33A$A!GAGAAA\AGAAA\)A(A
pAzA @H@R@A A(AA
=A(AARA
=AzA=q@ffAffAA{A	ARA=qA
A
pA
AQAQA\)AA\)A
pAzAA
AA=qA
A(AA\A\)AzAHA\)A\A@\)A   @R@33@\@@(@A (@A z@{A A A (A   A Q@\)A A\A zAApAA @RAGAzA
=AA\AAA/\)A0A7
=A{AQA
AA
ARAAHA33AAHAA33A=q@{A@H@
@@@=q@@@@\)@ff@\)@@p@(@R@G@@G@Q@
=@Q@陚@  @@=q@@G@33@H@@@QAAA  A=qAGA  AzA=qA@\@ff@z@33@@  @Q@p@@@@\)@ᙚ@33@ff@@  @R@
@@
@陚@@R@z@@{@@@{@@R@ApA=qAffA=qAA A
=A\A	A
ARAffA
AQAAA
A
GAR@\)@@陚@陚@陚@@
=@
@ffA Q@=q@HA Q@{@@ff@\)@@@33@HA33@
@zAGA(A(A
=qA33AAApA
ffAAGAGA
=A(A
AAffA	A
A
AA	AzA=qAA@@
=AA{@{A\AffAQ@
@=q@RAHA
@
=A @\)@A{AA{AA
=@@@=qA33A\A	A	A
RA
=AQAAApAffA=qA
A{A
AA	GAQAA\A
A @@R@p@\@\)@H@@@H@@@33@\)@@p@\)@@ffA   A QAGA=qA A
=AA	A\)A=qA	pA	A
A(A\)A
=A=qA=qApA(ApAHAffA
=AA Q@A\)A
=@Q@A (AQA\@H@@ff@Q@G@@\)@\)@z@A QA33AAA	A
AA\AAAAA(A	AA
ffA
A
A
=A
A\A\)A
GA	A33@z@p@\@G@AA QA @33@(@@p@ff@@GA QAHAQA\)ApA A   @ff@{@@p@@@
=@ff@H@AApAzAHAAAA
HAApA33A33A\)AAA
GA	pA	GAHA@A @(@@@@@GA QAAGAGAR@HA
A(AA
RA\A  A
=ARApAQ@@
=A=qA33AzAAA(A
pAA=qAAAHA"\A'A/33A*ffA!GAA  A
AA=qAffAA	pAA	GAA\)A	AA	A	A
RA\)AAAAAzAAAGA(AAAzAffA
AAAAA{AGA
pA
AApApA   A$zA$zAAAApAAGA
ARA=qA AGAAAA
pAA
A{A
AARAGAHAA{A=qAAHA=qAA	A	A  AAA
A\AARAA"RA%GA,zA+33A)GA+33A/
=A1A4QA0A'
AA\)AHA
=AzAAAA33ApAGA	AAGA\)A	pAAHA{A(A\AA	GA
=A	AA
ffA
AffA@ARA(AQA{ARAGA{A\AA=qA\)A33A
pA\)AARA33AAzA\A
ffAAA@\)A QA\)@=qA   AAA	GAQAA	A	AAzA(AffA  A
{A
=qA
AAA
AA
A
GA
=qA
AffA
AA	A	A33AGA\)AA\AA  AAA
{AA	GA\A
=A
HARAA{ApA   @G@@@@@33@
@33AA@@@QA(ApARAHA
{AARA
AffA{ApAzA{A33A!A!A&\A"ffA&ffA#\)A!AQA33AHAHAA=qAzApA@\)AHA	A  AQAffA33A	pAffA@A
=@\)@p@@@\)@A @@{@p@Q@\)AffAAA
A
pA=qA QApAHA
AffA(AA\)AA{AzAG@(A
p@
=A QAA=q@\)@33A{A(AQAA A{A A	AffAp@\A   A@@
=@R@p@(@
=@A zA
A{ARAQA
ffA	A
=AA=qA\)ApAAAA QA AA=qAGAffA  AHA
RA   AzAARAff@{A@\)@Q@AQAARA QA A Q@{@@=qA{AA  AA
A(AAA
=A
HAAA  AGAAGA!GA$A%GA%A$zAA(AAAGA\)AzA=qA
@A (AAA
AA\A Ap@
=AffA   A z@@p@ff@ff@\)AffA	GA
\AAHA(A
pA
=A	pARA\)AAA  AA=qAApA"ffA!pA QA#
=A!AA
HA=qAA   A  A(A
=@ff@@33@{@@@@ff@=q@A (AzAzAH@R@A   @\)A\A  AA A
AffAAffA  AA{AA
A(A	A
RAQAffAA
AA(A
=AGA
=A
A
AGA
A@\@  @@=q@@33@z@p@p@(@@@Q@(@H@@z@@@=q@A{AQARA	A
=A=qA(AQAzA{A
AQAQAAAQA\)A(A=qAAA@
=A@zAA @@z@\@33@  @(@@\)@(@@H@G@=q@\@ᙚ@Q@Q@33@
@
@33@
@RApA(A
HAQA
ffA=qAAHAAApAAQA
=A=qA{A\)AA	GAAz@@@\)@33@@@{@@
=@@@{@H@Q@@z@
=@(@
=@@A{AQAA
AAAARA(A\AzAQAAGA  A
A
=AAA  A33AQA
=AffAzAA	@A@ff@33@H@
=@ff@G@R@@  @=q@ۅ@\)@@@p@ff@Q@@@
@A33AQA33Ap@HA  A	AA\A\)AzA\)AQA33A@ff@ffA
=@GAA(A @\)@ff@@
@@Q@\@
@@@@@љ@{@˅@ff@љ@љ@@У@ff@\)@\)@ə@ʏ\@  @  @@Ӆ@Q@@p@@љ@(@33@@
@{@z@H@G@޸R@޸R@
=@Q@G@ff@@ff@\)@H@@
=@33@H@Q@\)@@\)@@{@\@˅@@ff@\)@@  @Q@{@H@G@
@@@33@@  @@߮@z@G@\@߮@p@@z@A QA@33@\@\@Q@߮@@ff@p@  @
@ȣ@
=@p@љ@ҏ\@
@z@
@33@H@{@ָR@{@
=@ff@  @أ@ָR@У@@@{@Q@@  @33@Q@@޸R@@(@ff@G@@p@{@\)@R@\@@@R@H@
=@p@G@{@33@\@=q@\@(@
=@Q@(@ۅ@
@ۅ@H@@@Q@=q@H@H@H@Q@Q@ָR@z@߮@H@@{@  @{@G@  @@@{@{@p@  @(@
@=q@H@@p@33@@{@Q@Q@=q@H@@(@
@Q@\)@G@@
@
@@@@
@G@H@@\)@@@@ff@@޸R@p@
=@޸R@33@=q@p@{@A @{@@@\@Q@33@@=q@@陚@z@  @
=@  @(@@(@@{@@G@  @ڏ\@@\)@׮@@z@ə@˅@ff@
=@@{@
=@@
@
@z@p@@A zAA=qA	A
AAQAAAQAGAAAQAAAAAA=qAffAQAA A zApAA  A\@@
=AA (A
=A (A{@Q@AGA AffAffA33A=qAA33AAAGAA\A33AffA!A"RA!A   AA A'A%GA!A{ARA
{A
RAzAHAAA
HAA\)AzA@  ARAG@@@@{@{@\)@@=q@@GAQA
RAAA
GA
ffA  A
A
=A33AA z@@@\)@
=@@H@  @\)@@ff@ffAGA (AA33A33@z@  A @p@R@=q@陚@=q@@p@33@\)@@\)@@@ff@\)@A(@p@33@@
@@@A (A zA AGApApA @A Q@{@@=q@Q@@@@  @\)@@(@{@@
=@=q@\@{@@33@=q@  @
=@33@
=@@@R@@=q@@@@p@33@
@@ff@ff@  @@R@
=@\)@\)@ff@AAAA
A{A   @p@G@
=@ff@(@\@R@G@G@@@=q@H@@A\)@@R@@{@33A QAffA
A z@ff@p@z@
=@ffAA AA
=AA{AA	pA	pA
A
=A\)AAA33AAAAAA=qA  AQA(A(AAzAA
A{A
AzA{A	pA33AA(A	AffAAAR@R@@ff@H@@A\)@@{A   A\AA(A\A@\)AAffAR@
@(@@@@  A
@@(@p@@@(@@@@@@ᙚ@p@(@@(@ff@@@=qA
=AG@HA @
@{@pA QAA	A@=qApA
=Az@33A @
AH@(@@(@=q@R@33@p@{@@ff@
=@@33@ff@\@H@33@@陚@\)@
=@\)@@\@@ڏ\@@=q@\)@p@@
@@ᙚ@(@ᙚ@\@(@  @陚@H@=q@  @R@
@p@{@ff@\@\)@=q@@{@@
@R@@=q@@
=A @(@ᙚ@߮@\)@߮@{@z@
=@\)@  @  @  @@@  @z@33@(@(@ٙ@@@@(@(@@Q@
@(@@zA   @z@z@@@33@@
=@{A(A=qAGA
AA@A33@@H@G@  @=q@{@z@ff@{@{@z@@z@@{@
@Q@p@{@\)@  @
=@p@߮@@p@@@@@@  @\@\)@@
=@\@33@R@@
=@=q@@@@33@\@@陚@陚@ff@@
=@Q@@ᙚ@@@z@@H@@33@
@޸R@
=@Q@\@R@(@ff@G@(@@{@{@z@=q@@@@R@\)@33@@\)@@H@\@@AG@(@@@@@@陚@  @陚@@ff@R@
@@=q@ᙚ@33@
=@{@@
=@ff@Q@=q@G@p@\)@@  @QAA
=q@
@G@G@Q@
@@(@@
=@@\)@  Aff@\@@p@HA{@ff@=q@33@@\)@\)@\)@  @(@(@p@  @z@=q@@@H@@(@  @ff@Q@=q@@@@@33@@@@@G@p@
=@  @p@=q@ff@@@ff@z@@\)@
=@ff@ff@@R@@(@RAG@
@ff@@p@33@@@(@\@@@\)@@@߮@=q@ff@
=@@@33@
@@{@Q@=q@H@(@@@@
@ff@G@33@
@=q@33A	@@H@=q@@GAp@@=q@@=q@z@
=@z@@
=@ۅ@@@@@@@R@
=@@A=q@H@
=@@\@G@@(@{@@@p@z@@(@{@33@
A@G@@G@@G@@(@陚@\)@{@H@Q@G@@\@\@@H@\@z@@ᙚ@\@z@@  @@@@@H@\@@@G@@@
=ApAAA @@@\@@@\)@R@
@=q@(@  @{@@@@@\@@@\@=q@H@=q@G@R@@@ff@@ff@@{@@ff@33@H@H@@p@p@\)AGAAA33AA
AffAffARAffAA (@H@@\@@ff@G@@
@@H@\)@@G@z@{@@\@\)@33@H@G@陚@@\@z@p@Q@33@R@R@
=@\@H@A (A zAAA
=AGA
=A  AQA
A
=AA@R@pA@(Ap@{@@=q@@@{@33@z@@@ff@\)@@
@@A(@@@@\)@@{@陚@\@pA AAAzAQA
pAAA=qA(AA	GAQA
A\)A
=AARA
=AQAAffAAA
ffA
{A{A (@
@@@ff@@(@H@33@R@33@@@@R@@(@A A@\)@p@A
=A
A\)AHA\)ARAffA{AA(QAHA\)A{A  A  A
ffA33AA@A
=@{@{@
=@\)@33@=q@33@\@@
@@A@(@
@=q@@\)@GAA
AA	AAA
pAHA\A
AAzAffA
=A
A33ARA
AA(A
ApAA{ARA{AAA  A
ffAAQAA=qAGAA
=A
=qAARA
ffA
RA
RAQA{A  A(AA
{A\AAApA
A\A(AHAA%A)A,  A*ffA)A1pA3\)A,A%A*ffA&HA$A"\A"RA$A  A  A
{AAAAAffARApAAAA\)AA@p@@R@A z@z@\@
@(A @A{AA
pA
ffAGAARAGA	pA
pA
GAzAAAA
=A
HAA	pAAQA(AHA{@A (AARA=qA=qAHAH@
=@@H@@
=@p@ff@@\)@z@\)@33@(@=q@33@R@z@p@p@ff@@@@@{@@  @p@R@@  @p@  @@(@\)@@@ff@@@@陚@
@\@33@H@G@RA@@R@z@@
=@@Q@ff@ff@ٙ@׮@@ff@(@љ@ٙ@Ӆ@ff@޸R@@  @(@{@\)@@@@H@\@(@G@G@Q@  @@z@@\)@@G@@ᙚ@߮@
@@ᙚ@ff@
=@ff@z@@@ۅ@Q@
@@@G@Ӆ@أ@G@{@H@z@@(@@@@z@@p@@pA A33ApAH@\A@zA A @@z@  @ff@G@@@p@ff@R@
@33@H@\@33@p@@@H@33@@(@p@\@
@Q@@@@\)@\)@
=@33@pA Q@@@@
AzA
A
HA@
@@R@=q@p@@@\@z@@=q@@G@@
@p@z@@@G@{@p@=q@@
=@@@R@33@@Q@G@@\)@@(@\)AGAAAzA	A
AzARA@@@ffAA	A
\AA
RAA
=AA
=A
=A=qA
=AR@{Ap@Az@33A@@=q@\@ff@@@H@\)A Q@@@
@G@
=AARAQAGAffAHA
AA\A=qAAQA @AA A@@
=@@=q@33@pA@z@@\)@\)@ff@z@(@(@
@p@p@@@@@ff@@=q@zApAHAA@
=AGAA=qAARA
{A
=A@@AAA33A33AzAffA QAAffA\)AAAGA{A\@\)@@z@
@R@@ff@(@\@H@߮A (@33@33@  @
@\)@@33@33@A z@H@@
AA
A
=A
A  A
{A
A33A33AGA@@pA (@Q@@=q@R@=q@{@G@\)@(@@@p@߮@\@\)@陚@  @\@@ڏ\@p@@ff@
=@Q@
=@  @
=@@@\@\)@\@A   A@ARA=qAA  AAAApA
Aff@H@ff@p@G@
=@p@@\@z@p@R@@G@H@  @R@G@p@(@@陚@
=@(@\@G@p@  @33A (@\AA33A	A
{A
A
AAQAHAAA\)AAAAQA
=AzA	AA=qApAA A A33A33@@@
=A z@\)@(@Q@@p@{@\@33@G@z@
@@p@@H@Q@
=A (AGA ARApA33A(A	A	pA
\A@33@@A A
=@p@33@
A{AffA(@pA33@@@@
=@G@
=@@G@@@陚@(@@@G@@@z@ff@GA\)@@@@p@
=AARAQA	AA  A  A
=AAA\)A\AGApAAA@A\@AA{A{A@RA @
@  A Q@@=q@@G@
@Q@@{@@G@@H@\@ff@@@@H@@=q@@@@33@=q@33@H@(@
@33@@AA@G@@@(@A{@@=q@R@
@@(@=q@
@A@p@  @@
@
@
@
=@@H@@=q@@@
=@@@(@@=q@@@@Q@\)@@=q@
=A\)A (@A
=A
A\)AGA  @z@\)A33@A @A(A A (@@RA\)@(@\)Aff@=q@=q@@@z@H@
=@\@@(@=q@@z@
=@  @G@
@H@
@@G@z@A (@\)@RA
@\@R@@{@\@
=@@
@陚@33@@ᙚ@
@\)@
@
@=q@ۅ@@=q@{@@߮@p@{@(@{@(@H@H@@
=@
@H@(@Q@@@Q@
=@@@@Q@@陚@Q@@R@@=q@H@\@@Q@H@\)@@ff@@=q@H@H@ᙚ@  @\)@ٙ@H@@@p@p@Q@G@=q@
=G@@ff@ff@R@@{@
@@Q@R@\@H@@@z@p@Q@ff@@zA z@@p@
@33@=q@H@陚@33@\)@@Q@(@z@\)@@(@@أ@@ff@׮@أ@(@@ٙ@ff@@\)@R@@@  @(@Q@
@R@p@@(@pA@@33@@@A (AHARA=q@\)A Q@@=q@ff@@@@A@(@{@ff@\@  @\@G@\)@@(@@
=@G@\)@Q@=q@@\AAAA	A=qAA
AA
A
AffA(A@@A A @@  @Q@R@(@33@@R@p@p@(@@@(@@(@@(@A=q@  @zAQ@ff@@{A	p@
A
=AAGA@@{@p@z@\@p@ffA Ap@A z@\)@
=@@ff@(@@@
=@\@  @R@@ff@@33@{@{@Q@@@H@\)@@\)@z@p@@G@=q@=q@
@@  @R@@@
@33@A   AffA(AAAHA{A\AAAHA
A  A=qAAA  A\)AA\)@\)AG@AAffA@p@
@@@
=@@H@@@
@{@@Q@z@z@Q@
=@G@H@p@\)@@@@@z@RAAA=qAA@
=@(@@
@=q@R@\)@G@p@ff@@  @ۅ@@G@ff@@(@@p@p@@
@z@z@@p@z@\)@@@@@@z@@@RAA (AAHA{AHAQA	A
A
=A{AAzA  AzAAQAAff@{@\@@@p@@@(@@@\)@@\@\)@H@@@(@{A{@33@z@G@@33@@  @@=q@
@ffAA\)@\)@ff@@(@@
=@@ff@@=q@  @@@(@H@
=@@=q@  @  @p@@@H@\)@H@{@ff@\@\)@\)@ff@߮@ۅ@Q@Q@ff@Q@@@H@@z@\)@A@
@@@@=q@=q@@@  @@z@{@
@p@
@z@@A@@(A(@@
=@G@@G@@33@@H@33@Q@@ff@޸R@޸R@  @@@ff@@ff@R@  @@(@@@{@@G@A
@ff@@@33@(@=q@H@@
=@
@@G@=q@Q@@
=@@  @@@@{@@\)@G@Q@H@R@{@z@陚@陚@@ff@@@(@@@  @Q@\@AG@ffA A z@Q@\@@\)@@(@@@{@{@(@Q@ff@ff@R@
@z@@ff@ڏ\@\)@
=@\)@R@G@@@@@p@@  @@@\)@33@  @H@\)@ff@R@Q@
AA\)A{A (@=q@H@@\)@޸R@AffA   A@(@
=@@
=@
=@H@Q@
@ff@(@@(@@@\@G@p@@Q@H@p@
=@@33@Q@\)@߮@\)@ᙚ@ᙚ@@@@\)@p@Q@
@p@ff@
=@p@@H@\@HA   A	@(@@{@Q@\@@@@33@@33@@
@\@\@@@H@33AG@\@
@Q@33@@@\)@
=@H@=q@33@Q@Q@\@@ff@@@@A   @R@ff@R@p@33@@=q@=q@@R@@(@z@@p@H@@  @\)@ff@ff@p@{@@Q@\)@@\)@Q@@  @33@@@\@
=@Q@@
@@\)A zA A AAAApAQAA
A
=AA=qAAAGA A A zA A @p@p@ff@
@H@@  @R@Q@  @
=@@
@G@p@{@33@@@@A z@
A AAffAAffA\A\)AzA	pA
ffA	AA	GA	A	GA
=AAff@  @=q@
@@Q@\@33@H@H@@33@@z@@@
@R@@ff@
@@@z@=q@@@ffA AAGA(AAA=qA	GA
GA
\A  A
\A(A
{A{AAA(AA=qA	A33A=qAQAGAAA
A{A=qAApAA33@z@
=@
=A QAG@@33@@G@=q@@@(A @
=@ff@  @ff@\A QA=qA  A\AffA
=AAAGAAA(AAAAA z@R@G@z@@@=q@H@(@@@  @@{@@R@p@R@\@陚@  @H@z@=q@G@\@
@(@{@ᙚ@p@\)@H@
@\@p@RAGA=qA33A @{@R@p@@p@33@{@(@(@@@\@@@@\)@@@
@陚@
@H@@@z@@@@R@@z@\@H@\@@{@@@=q@RA\)A
AQAGAHAAAA{A\A
=A z@
=@A Q@ff@R@(@
@ff@33A z@{@  @@H@ʏ\@  @=q@z@R@У@(@ۅ@  @Q@G@G@p@  @@H@  @Ϯ@@=q@{@ᙚ@(@θR@z@ָR@
=@Ϯ@R@ƸR@Q@@z@@θR@@
=@(@˅@  @
=@ҏ\@Ǯ@p@@@{@@G@
@Ǯ@
@@
=@ȣ@ʏ\@
@
@{@Q@@{@H@љ@@У@У@@z@Q@z@z@߮@\)@@p@z@ٙ@=q@{@\)@@z@@@@
@z@33@ٙ@أ@Q@  @Q@  @
=@ff@ff@=q@Ӆ@@Q@G@=q@p@ҏ\@33@(@H@33@@@H@@H@
@
=@@=q@p@\)@33@
@{@
=@@=q@@@Q@@
@(@@=q@@G@ٙ@أ@G@33@ҏ\@@33@(@@ҏ\@Q@G@
=@z@(@@
=@
=@˅@ə@@@ƸR@˅@H@
@Ϯ@G@
=@(@H@H@@Q@33@(@Ӆ@(@Ӆ@@Q@@˅@  @G@@ҏ\@
=@
@
@33@@@ȣ@Q@\)@
=@
=@ƸR@
=@@=q@ʏ\@H@{@@@Å@ʏ\@ə@
@@@@G@@У@@@љ@Ӆ@Ӆ@
@  @
@G@\)@Q@
@@33@p@  @ڏ\@Q@  @أ@ָR@(@ҏ\@Q@
@=q@@=q@ۅ@׮@H@(@=q@G@=q@p@p@ʏ\@p@Ϯ@(@׮@ff@@\@{@ff@Q@z@33@(@@\)@\@@@ff@@@{@@@\@@@  @G@@@Q@@Q@Q@R@@33@ڏ\@@أ@ٙ@ٙ@޸R@ff@ٙ@@@
=@\)@@(@\)@
=@@
@p@
=@@=q@H@Q@@G@
@@(@z@(@@R@z@@@@@z@
@陚@@p@ۅ@@@{@@ff@p@@ڏ\@
=@@أ@33@33@@ᙚ@  @p@ڏ\@ᙚ@\@H@@(@(@p@
=@ff@\)@
=@@@33@G@߮@@33@޸R@
=@p@ff@@@{@{@
=@G@@z@33@ڏ\@33@=q@߮@@ff@@޸R@(@ff@
@(@ٙ@Q@ָR@Q@{@@@޸R@H@\)@\)@@
=@@@@
=@@{@{@H@G@{@{@{@R@p@H@@\@޸R@ff@@@ᙚ@G@@H@33@
@(@\@33@  @H@=q@@@޸R@@@@߮@ڏ\@@  @=q@@p@R@(@@G@陚@@@@@@@H@(@@\)@@@=q@@z@@(@=q@H@{@
=@ۅ@Q@Q@@{@  @
=@׮@@Ӆ@p@׮@@@33@Ӆ@@ָR@H@@33@ff@33@߮@{@(@@H@@@
@@R@ff@@z@@=q@{@@@z@ҏ\@ڏ\@33@=q@@=q@@R@\@G@@Q@G@أ@
@@@ᙚ@ff@ۅ@z@ָR@@Ӆ@z@@(@@@@z@\@\)@z@@@z@ff@陚@=q@@\@@\@@  @@  @ff@p@\)@G@{@p@陚@@(@ff@ᙚ@\@\@\@Q@Q@@@@@ff@@ff@  @p@R@\@Q@@Q@
=@@(@Q@@R@\)@@R@@\)@ff@@@@p@(@@@
@
@\@@@H@H@{@\)@\)@@  @@{@@@=q@33@\@33@@ff@33@R@\)@ff@\@@z@@{@  @ff@\)@Q@Q@@@ff@@@@H@\@z@p@  @z@@p@@
@G@ff@@\@@Q@@@p@H@@G@\)@  @R@@@H@p@p@H@Q@ff@@Q@H@H@
@G@@33@@
@(@
@(@z@@=q@Q@\)@ff@R@R@33@@
@@33@  @G@ff@@@=q@Q@Q@
=@ff@p@p@  @@@陚@ff@@@
@\)@\)@
@
=@ff@(@@\@\@G@(@Q@@
=@@(@\@@p@33@@  @@\)@{@@@ff@p@z@=q@R@{@@@(@@陚@\@@ff@G@\@@=q@z@@@\@=qA@G@@z@R@A (@R@R@(@@@H@@  @G@R@ffA@\)A@p@{@\@R@  @\)@=q@@@\)@\)@Q@33@Q@R@AAffA=qA
\A(AGAffA
=A
A\AzA33AAA{A=qAARA=qA=qA	A\A
=AG@zA A\)A  @{@ff@Q@@G@@z@@@
=@33@\@\@@
=@@
@{@@@@(@p@
@\)@
@p@G@@R@@{@ff@@@z@(@33@=q@{@GA@@\@G@H@\@
=@
=@z@33@=q@@@H@\)@ٙ@{@@@  @\)@@z@H@@  @Ϯ@(@@Q@\)@ƸR@ff@أ@
@=q@
@ᙚ@(@=q@=q@R@R@
=AR@{@Q@p@޸R@=q@߮@{@
=@@{@{@
@@Q@\)@ָR@أ@@@=q@
@\)@H@@  @ff@Q@@ٙ@Ӆ@@33@Ϯ@Q@ٙ@33@z@@޸R@33@ff@ff@
@@
@\@=q@G@G@G@@@@R@
=@\)@@=q@@{@{@@
=@@Q@@޸R@ff@ۅ@
@@\@=q@Q@@أ@׮@ҏ\@ҏ\@=q@ָR@=q@
=@@ڏ\@ڏ\@陚@陚@陚@\@@=q@H@p@@ff@@H@  @  @z@{@@@p@Q@ff@H@33@H@@z@H@
@G@޸R@@p@@@ᙚ@@@ٙ@׮@׮@H@33@߮@@\)@{@{@
=@Q@
=@@R@\)@@z@\)@=q@@@\)@G@p@@@@p@p@@@{@
@p@߮@@p@@\@(@G@@Q@ff@p@\)@ᙚ@ff@\@@33@
=@
=@
=@@
@
@z@@@@H@\@@{@\)@\)@
@33@(@(@@Q@@\)@p@z@@
=@z@z@G@@Q@G@@陚@G@=q@H@@{@
@G@(@\)@
=@@p@(@@@{@H@\)@@=q@Q@@H@@Q@
@@@G@
=AG@@\)@{@@ff@Q@(@@@z@p@R@陚@@G@{@p@@(@ᙚ@
=@=q@@@\@=q@@\@ᙚ@33@ff@
@(@33@H@G@@
=@=q@z@@@@@@A33@G@@  @@\@
@Q@@ff@{@z@z@p@@@H@@33@
@\@@(@ۅ@@
@@@z@{@أ@Q@  @ۅ@
=@@
@p@@p@@@  @ff@A(@@@
=@  @R@{@p@@@z@@H@G@G@@@H@@ff@
=@  @@@@@@@陚@H@R@ff@@A@G@@R@z@33@Q@@陚@@@
=@@=q@=q@G@\)@@@@Q@ff@@ff@z@{@p@\@陚@z@@Q@陚@R@  @G@@@
@{@@\)@{@@@  @@@@z@=q@@p@@@
=@G@@@(@p@(@\@z@p@@\@G@@ff@@@@p@ff@@@G@p@=q@
@@=q@@@@\)@@
@Q@@@@G@@G@\@p@@@@R@@
@z@@
=@\)@Q@R@{@@{@p@@z@@
@@\)@ۅ@ۅ@
@
@
=@ff@@ff@  @@(@{@@@@ۅ@\)@\)@@H@ٙ@{@@\@@{@(@
=@ff@\)@  @{@@p@{@@R@{@p@p@\)@@@  @  @@@\)@ff@陚@ff@߮@z@@@z@R@z@ff@R@\)@
=@R@z@@G@@{@ff@R@@@33@R@@@(@@33@(@z@@@@\@\)@ff@@Q@R@@\)@@\@33@@=q@H@G@Q@  @@
@ff@
=@z@@@@
@Q@@@@  @\)@@@@Q@@R@R@\)@@@
=@\@
@@R@@R@{@33A@@\@ff@@(@@Q@=q@
=@\@@=q@H@@@  @Q@Q@p@
@G@=q@
@ff@
=@
=@{@(@޸R@
@߮@@H@\@@@@@z@ff@
@@=q@=q@
@@ff@@G@@
=@ff@(@=q@H@@@{@\@@p@=q@H@@G@޸R@@
@p@p@Q@(@޸R@أ@@z@׮@@=q@{@p@
=@R@z@@Q@@陚@H@陚@@G@\@H@G@@G@=q@@@@@
=@@@G@@
@(@R@\)@Q@  @p@H@33@@(@@  @@@@=q@(@\@33@ff@p@33@@陚@@@zy BkBzB  B=qBkB#B
=B=qBؙBLBٞB{BBݙBǮBfBuBBB
=B
BB߽qBޔ{BBBHB۸RB)BԽqB(BBиRBzBӏ\BGBӞBӞB\BӅBԔ{BfBW
BHBB{BǮBaHBȮB̅B  BԨB\)BfB֮BՏ\BBBLBг3BԙB\B.BfBظRBףBBffB؏\BkBffB׳3B33B\BHBBaHBøRBHBGBĮB\)Bє{BBBBƙBģBB\)BȊ=BB BB(BϣB=qB(BGBɳ3BQBGBÅBƳ3B  BW
BB˞B̽qBϊ=BBB
BQBBB.B
BW
BzB(BfB.BzBQBfB͔{B)BHBʀ Bʳ3B)BaHBŔ{BɞB̮BBǮB(BQBB33BB3BaHBkB\BpBŞBfBȨBBɳ3BBBBBʸRBɳ3B̽qBLBHBBˊ=BʮBpBBLB
Bɔ{BǮB8RB33BBBBBLBƳ3B)B.B{B)BƊ=B(B)BBB)BGB(BBƮBHBBȏ\BfBQBfBȀ B̨BuBB\BaHB
=BҙBBffBӔ{BԨBpBB33BǮB#BӅB
B
=BQBήBffBaHB  BșBuBzB{B33BBBʙBǨBBƸRB33BkBBÏ\BƏ\BɞB
BǮBaHBǮB\)BBqB  B\)BBB̀ B\)B{BW
BԙBzBaHB  BGB\)BzB\BҙBaHBBB̊=BBffBBʙBB˅BBǙB=qB#BÏ\B.B
=B
B BB\BB33BQB
BBLBƽqBŊ=BBɸRBffBkBǮB\)BǮBBffBBB\BB\)Bҏ\BLBBQBaHBaHBB̞Bˏ\BLB8RBɸRBBBLBBBB.BQBBB3B{BzB.BǮBB)B33BBW
B  B33BB
B8RBąBBpBȳ3B)B{BBӨBaHBBB  BݨBzBB۸RBQB͏\B̳3B˽qBLBBʣBHB#BBɮBǮBB  B  BfB.BBzBHBLBBBB{BBBffBRB£BĽqBBB˳3BkBQBգBB{B֨BBBՀ BBffBBីB
B8RBB҅B=qBνqBfBffBQBͣBBW
B33B33BW
B
=B B=qBkBuBB.BfB.BuBQBB\BzBÀ BŸRBǳ3BpBaHB\BBBBӀ BBpBpB=qBBB̔{BBB8RBuB33BΞB8RB\)B8RBBW
B8RBkBGBBB=qBąB
BB(B\B̳3B
B½qBB#BǙBffB
BǸRBpB̏\BaHBԅBB.BuBЙB(BBؙBfBaHBBRB8RBBHBBޮBBBBpBW
B33BǮBBfBBfBQBkBǮBҀ BffB
=BҮB8RBя\B\BBQBBBQBffBW
B)BHB
=B8RBzBkB΅BffBBBBѽqBBB
=B֔{BޙBqB  B BRBъ=B͏\B\B®BB\)B(BB8RBBBBBHBBpB̸RB8RBQBB\)B\B33BǸRBB
=BzB(B͏\Bˊ=BBǮBǮBGB#BBBBLBBBBBffBBўBHBGBLBW
B8RBfBBuB  BW
B
B\BBHBfBBkBBpBBW
B=qBB.BB8RBBBB.BpBBBGBBBuBǊ=BȊ=B  BB33BB\)BBW
B#BBʙBBB=qBخBBӔ{BBzBQBQBBB8RBqB(BkBBB(BBBB8RBBB.BBBzBǮBBzB\BqB
=BqBuBĸRBBÔ{BB)BHBͣB̞BuB(BzBBўBHB8RBǮBpBB̮BfBƣBĀ BÅBB\BǮBfBHBBLBBBQBqBBHBzBzBBRBBBB{BB8RBBBpBĳ3BèB)BBƙB=qBBW
BBB8RB)BW
BʙBBʮBBfBaHBǮBșBŮB{BBGBBB33B
BffBB
B8RBW
BBBpB\B8RBϙBaHBңBBaHBpBHBBB.B=B
BffB)B  B)BQB
BfBGBה{BBfB{BԣB.Bҏ\B#B\)BӮBԙBָRB؊=BffB8RBݏ\BܣB#BkBBBBuB{B(BϞB)BGB33B8RB(BGB33BBaHBBBRB#BBB=BzB˙BfBHBB˔{BϞB=qBaHBB(B(B  BB3BBLB)B3BfB.BBqB8RBLBBǮBqBB\)BzBGBBΏ\BיB{BkB BzB
=BڸRB=BB\BBW
BpB8RBkB8RBuBQB#B8RBzB.BGB(B߳3BkBǮB\BfB왚BBzB.BB=qBLBB BaHBٸRBBBaHBBB  B
BɨBǅBB8RBkBBBB#BBBuB\BBpBЙB{BBB.BЏ\BЏ\B33B
=BBBBٳ3BBffBfBffBԣBBW
Bҳ3BθRBәBBB33BaHBQB˙BQB33BffB(BBffBBŏ\BĞBÏ\BBQBBfB{BpB{B̅BǞBǣBGBȞBɔ{B=qBBB˞B.B{B8RB\BBţBBBŅB#BBBBǮB
BHBqBpBfB=qBLBB8RB33BĮBǅBffBkB)B)B{B8RBRB(BBqB=qBuBƊ=B
=Bų3BHB33BBHBîBŅBBȳ3B33B8RBBffBǮBpBѣB  BBW
BǮB#BuB(BB{BBQBЙBBҊ=BǮBLBΣB.BЊ=BϞBΙB̙B̀ Bϔ{BaHBBW
BЅBBB
=BƅB{B{BGBBϊ=BBָRBBߙBݏ\BHBڸRB  BkBzBuBBBمBpBB\BQBBB\)BB(B8RBHBW
BB̅B{B\)Bǀ B˳3BBBήBBB.BffBBԔ{B
=BuBBBӣBBBBzBؔ{BB߳3BaHBGBBRBីBGB#BpBBHB\)B(B  BpBBҨBB  BpBǮBBЀ Bϊ=B\B)B\)BB  B{B)B̀ B΅BfB
=B
BBԅB.BԮB#BQBӏ\BӸRB8RBuBӳ3BBֽqB
BףBLBBBLBճ3B\)B\)B{BBzBBBHBkBӞBuBQBԨBW
Bѳ3BkBB8RBBхBBҊ=B{BpBљBW
BuBuBHBQB(BBB(B̀ BBffBϙB.B
=BpB=qB8RB#BW
BۮB۸RBڅB
BؙB
=Bڏ\BBzB#BBBB33BkBBԅB=qBBB
=B{B
Bӏ\Bъ=B\B=qB(BBףB8RBӏ\BոRB
=BkBԳ3BӀ BBW
BB.BѨBB\)B\)B33BٸRBٳ3B\BB݊=B  BBuBݨBǮB33B׊=BaHBBBB)BBѣBЮB\B.B
=B
=BϙBHBfB33BGBB{BBB̏\B=qB\BBBϨBBӀ BuB  B=qB\)BBB\)BңB
B֏\BpBB33BB BBߔ{BBuB8RBڸRBǮBB=qB33BBzB8RBףBBBQBՔ{BШB  BaHBBBBpBffBBffBѸRBәB.BHB#BՊ=BBBGBfBHB؅BB۸RBffB޳3BLB33B BBB3B8RBkBBkB33B)B
BLB܅BۣBQB\)BׅB.BۣB۳3BۨB\)B֞B.B8RB\BBkB  Bԏ\BffB=qB֔{B#BBHBW
BBGBGB=qBBB
=B8RB
=BW
BݮB޽qBBBB{B3BݸRBBۊ=B\Bֳ3BՅBǮBBB\)B֮B8RB{BՔ{BfBBBkBؔ{BBՊ=B#BpB)Bъ=BҮB#B׀ BBB33BkBBkB۳3B#Bݔ{Bۏ\BBB߽qBٽqBW
B.BfBBBQBGBBBBBQBڣBي=B׳3BaHBۀ B٣B\)BW
BؽqBBQBճ3B.BkB
BљB33BkBB̮BffB=qBzBͨB\B̸RB8RBЀ BGBaHB\BB٨BۣB8RBuBpBBBGB
=BQBzB8RB\)BمBLB#BpBfBӨBӞB(BW
BkBӮBϽqBΏ\BBBB#BpB8RBB8RBkBaHB͔{BͮBffBB̏\B  BʣBBB
BљB33BBGB)B)BՙB=qB׮B׀ B\)BָRB)B)BӣB\BzBHBОBzBGBՊ=BҞBBpB\Bр BнqB\)B)BB=qBHBzBʨBfBBaHBBBȊ=BfBˊ=BHB33B=qBHB͔{B͔{BB=qBBϊ=B\)BBр BѮBpB  Bӳ3BBpBӔ{B\BӀ B=qBGBuBBaHBҨBHBQBaHB\)BЅBД{BǮBϣBBBϽqBϽqBBȀ BɣB\B
=B{B(B#B
=BW
BB̳3BHBkBШBBОB8RBpB#B{BѸRB#Bє{B8RBB΅B33BLB
BuBGBLBaHBkBkB
BGB8RBB
=B=qBkB̀ BkBͣB\)B̮BBBB33B#BB˽qB̙B\B(BpB̅B͏\BB̨BW
B̞BʮBzB
=B
BͨBͽqBHBBW
BЅBpB{Bє{Bя\BѣBр Bѳ3B.BB#BuBBBє{BLBЮBУB=qBBBGBBͳ3B33B=qBʊ=BpBW
B̔{B̨BfBɔ{BfB#BBBBB
=BBQBHBǮBBB(BffBfBHB՞B֮BpB  BBس3BB33BkBףBB֣BW
BBӮBBBҊ=BfBzB{B
BBfBffBBB.BBQB
=BB
=BՔ{BԔ{BBpBW
B՞BǮB\BHB(Bؔ{BBߔ{Bޏ\B{BǮB䙚B\B\B(BfBBߊ=B=qBaHB8RBBǮB=qBaHBݣBkB.BB
BҙB.BB  BٸRBԣBHBB8RBәBB#BؙBBuBBBBBׅBB׳3BBؙB.BB#BBRBᙚBBBzB#B
=B\BQB؞BuBuB׮B֨BB\BBѮBW
BBϞBpBϔ{BЀ BW
Bπ BBffBЀ BΣB\)B)B
=B
=BB\B)BBBB߅BBQB33BaHBW
BBBBB{B{BuBBfBBzB홚BB BaHB B)BB)B\)BB\)B33BBǮBҞBfB܏\BB(B#B(BՔ{B8RBuBBBB{BB8RBB(B=B홚B(BB
B{C O\B{CǮCCCJ=C
=C)C	5CCO\CǮCCfC =B3BLBkBQBB33B=B BBqBBBqB\BBB BGBRBB  BuBkBqBB\)B.CxRBBB
=CCHCCC\CxRCC
uC
{CCCCpC
C=qC{B#CCxRC &fBkCCs3BffB)B\)BGBRBW
BQBBaHBBW
B=qB=qBBB홚BuCCCW
CCO\C
J=CC:CLC\)C  C{C
fC
CBC	HC
8RC.C BBBuBuBǮB3BBGB33Bފ=BuB܅B؊=BpBGBB\B\)BHBB33Bܳ3B33B߽qBBݸRBǮBaHB#BߞB{B\BBC 3BLBB33C CCC)CfC)BBC C!HCBBC	3CC0BBzBB BBޏ\BW
B=qBQBB噚BfBBBB8RBBB݀ BQBה{B  B33B{B=B(BQBaHBfBzBRBHCLCaHCC3CC}qBC{C8RC{CpCpCCC\C
CBaHBuBB\BB\)BBBBBkB  B۸RBBGB8RBͽqBpBB#BfBQBBBخBڸRBpBBB\)B33BBfB(C CCCCCǮC޸CfC	HCHC
W
C.C
C
fB\)B8RBfBuBǮBBBBBBߣBBffBמBBֳ3BԊ=BB33BpBמBօBިBQB
BBBfBW
BBRC
ǮCqCxRBW
C\C &fCC
\C
CC:CChC&fB{C=C
{C
=C\)BBB#BaHC B=qB#BRBBܮBڊ=Bي=BBLB.B\)BЮB̸RBҀ BzBҮBB)BB3BffBB\BBB3B8RBBW
BC5CBaHCW
C  CC3CC
C C
C
pCBBkBB
=BBBRBffBBBQBBє{B#B.BͨBW
BLBД{B#B33Bӊ=B  BB
Bӳ3BBBB
BBqB\B BǮC ǮC}qCfCxRC}qC
CCYCfCC!HCCCC0C}qCqBHB CCC	CcC
)CW
CBffB\BuBaHBBBLBBBkBB8RB(B=qB33BB  BBRBkC
C}qCnC)C3C
RC{CffCqC
C	  CCxRCCO\CJ=CBC
C}qCaHC	qC	pCBCǮC
W
B=qC CJ=BC uC=C  BBffBB33CW
BRBffBqB\BB{BC B33BBBC	3C	CCBC}qCBRB(BzB(BuBBfBCBLC ^BC0C)CٚCB.BBffBW
B  BLB)BǮBuBuB{B݀ BBHBBB B\B33BBBW
BzBǮBfC(CzCkB
BǮBqBffBCfBBB{BǮB8RB B{B8RB=BfBQBBB{BǮB\C BBLBpBffBǮB(BpBHBBBBԏ\B8RBGBBЊ=BBB܏\BffBB8RBB(BRBBQBuBGBzBB=CCC
C^C C33CC	5C.BffBqBB\)BBHB
BBBuB\)B.BpBգBpB̞BzB=qBB̀ BffBBQB#B
=B݅BGB8RBBCs3C CffC 
B{C ^B8RBCC	J=CC!HCٚCpC\CCCBBRCzC {B\)BpBLBHB#B33BB\BׅB֔{B33BW
B(BB\)BQB=qBW
B(BڣB
BB뙚BBBW
B BqC&fB
=BBBffCffBBpC kC
CCO\BfBB.BB.BuBLBLB BBfBBQBBzB
=BمB؏\B؅B؀ B33BB
BB)BGBpB
=BffB֔{BݣBHB\BLB8RB8RBǮC B#BBBLBBzB.BHBBqB)B3BC=BBzC{BǮBBB䙚B䙚BfBBkBB8RB\B33BW
B#Bڊ=BBffB BBfB؏\B(BBpB)B홚B
B  BBW
C\C	s3C(C CqBW
CCC\C
CC \ChCǮC3CCC C#CQBB\CCCBCC	C
(C=B33B=CRCLC{BC RC\BC8RC C:CB\B3CC
C
C)CCC:C
^CCC33CC)C{CCCfC=qCO\CxRCB\B홚B BB33B=B\B\B{BfBB\)BB.BGB=qB33BGB#BBBBݏ\BffBzB瞸BGBqBBC uBfC )CzCCCBaHB
=CnCffC.Cs3C C!CnC:CfCC
{C
CC CfBBC)CECpCC!HB\)BB\)BڸRBٸRB{BܮBBzBffBB
BܨB(BffB8RBBBBLCRCxRCCC5CGCRC\)C
RCRC
CCCCCC=CǮC}qCfCB
BfB\B
BB  BzB BB=B(BkB{BǮBB BqBB)BBuC BB\BLC CCfCffCxRCnC+CCCCCHCC%  C'C&8RCfC"C{CC CCC
C#CC\C=C	s3C!HCCCC
C+C
CC	8RCLCC8RCW
BC
.CECCGC
  CC#C CYC%C%C/O\C3)C3\)C83C,C+C+fC(C,޸C' CQC{C\)CnC	 C.C33ChCBC(CHCC!HC
CfC\CCCCC
xRCBCCHC=C)C \C^C
5CQCT{CCW
BC
CC3CC {CCCqC)CC0C{CCzCRC)CBBW
BqB{BB3BaHBޙBW
BBBBkBBB8RBBB=BffBQB{BqBGB{BuBڔ{Bي=BBB#B B33BB33BBBBBCJ=BCW
C
LCkB=B
BB{BzBB\BBB{BkBqB\)B.BffB=qB㞸B
B{B8RB#Bۊ=B33BBBB֊=Bה{BBأBBuBBQBBǮBB.B  B  BpBBǮBBBCC!HC.B=qB B#BaHBffB BB܀ BBݨBݸRBaHBۀ B.BܙB۽qBGBfBBBW
Bڳ3BQB8RB.BؙBBBBB8RBB
=BkBfBBBBfB\BB3BBpBC C	ٚCCJ=CcCCuC B왚BBBB(B)BB8RBLB  B(B܊=BBBBzBGBLBܞB=qBڏ\BBBۀ B
BffBBBBQBBaHB.BqB)BaHBB B  BB{B\)BBHBBBB33B3BBCB
=B
=BBC 8RB\)BGBBffBLB(BB B
=B8RB
=BLBޏ\BB垸BLBBRB#BCCqC	ٚC	EC
)C\)C	3C
\C
{CCHC.C3C{C3CChC
&fBBzBGB#BBBBBffB
BBLBGB\B(BBRBLB\BGB=BHBfB33BBpBBBǮB\BBBBC3C=qC3C{CuCC&fC+CCCC:C\BB
=BfBaHBBB{C\)BGCC
CQC
C
8RC
cCs3CO\C BǮBC 3BaHBBB{B䙚CǮB33BGCٚCCCC  C)C
)C\C5CQCkC&
=C
{C#=qC{C޸CC#nC#CCC0BB{CCC\)BkCB8RBBC\CO\C{CLCCC{CCnBfBkB=qB\BǮBC}qCCǮCC^C33CCC}qBBC&fCC!HCYC!C#nC$
C)C+EC,{C.C.C*
C%QCYC"{C#3C:CC
GC
BaHC33CC\)C{C5ChCfCRCBC GBCEBHCBC )C.CxRCC\)CC fB{B  BBCCCT{C%&fC)pC&qCRC-C((C%
C!C޸CCC33C
C!HCCCzC0C:CBLB
BB
=BBaHBB3B{BuBBB  B.BRBB
=BBzB{BGBGBCCcCCpCٚC C.C	  BBfBǮC\C@ CLC3CBǮB.B)BRB#BGB(BBB晚BW
B33BzBBpB
BHB#BW
BǮBBBB{BڙB.BՅB.BިBW
BuBW
BBBBBB\C{CC{CYCC\)CCC0C"=qCCzC8RCCC)CRCYB33BBBffBC fB\)B#BuBkBߣB)B{BB.B#BHB#BzBB\BffB#B\)B(BffC)CO\BBCC
uCkCC
CC
\C!HC
CRCqC
CQC B{CRCYCC+B=qC  CBBBaHBW
BBGB8RBBRB\BkB(BBB  BBBaHC YC 
=CQCCCHC  CCCC
QC	EC+CC)C5C
)C!HCBCC  CBzC 
=BB BB{BBRB\BGBfB
BBQB.BB=B\)BBBaHB(BfB=qBkBpB\C !HCzCChC C5CCRC
ǮB{BffC HCBRCffCkC&fCCqBǮCC
\C	}qC
C(CBBzBGBC3BqB BBB8RC .CC ޸B=qB=qBfB)BB\B(B
BB=CC  B\)C CC
C
qCCfC޸CcCCfCC)C*CcCCs3C  CnC
ٚCCRC
C.CC.CCC:CBQCzBBBkBfBQBfB  BkBW
C޸C#BpBBǮBC
)CLC	5C0C	HC	CRCEC+CCCC^CC!HC33CC  C+C
C'qC#C
=C  CC
 C	3CCC:C@ C{CC{CٚC33CǮC	kC{CBB=BBB3BCqBBffCCT{C@ C
O\C^CGChCYCLC	C=CC C(CCC޸C \CkChC&fCfB{B3BffB
BBBkBǮBBBBaHCB\BkC)B33B{BB8RB{BBqBzB8RC	LC

CqC  CCC=C
=CGC	CC\CC3C=C{CcCC.CEBfCB.BLCfC=CuCBLBpCHB BB8RC CBGBuBfB\BffBzB33BC B#C
CRCCCCC5C^CpC3CJ=C=qCC C#:C#RCBC

C33CCGC0C
RBBCHBCCEC
fC
ǮCCBB#BQBBGBBHBBaHBffBffB)BǮBuBBBBBCs3CGCJ=CCCCxRC=qCCaHC:CC\CqC0C3C\CC.CC+C
C	\CCC	fBqBffBGBBBBB3BBힸB B(BힸBzBBB
=BffB(BqBzCC=C{C@ CW
BHBW
CkCcBRB
=BfC +CcC
=C
nCC:CCECqCCCGC
J=C=qCfC\C{C EC
B=qCYCB  BBBffBzB BpBǮC޸BfCRC 8RBBC#C\)C\CCCaHC C	5CkC޸C{CCCRC#B\B  BB B8RB3BBBBBBGB  CnCW
C.C}qC{C  CkCCEC
=C
RC"  C O\CC=qCHCCffC!HC޸C:CcCCxRCJ=C

=CpC	.CC33CYC{B\)BpB3C hB=qB\BqBB#BCCٚCCC\C@ CxRCCJ=CEC}qCfC}qC5C5CC+CC=qC\)ChChCǮCCCC C}qC\C.C0CB
=B\BBfB
=BBfC 3C
=BQB3BB.BkC}qBCC C	YCRCxRCfC	C	33CC@ C)C:C5CCkC:C
CC=qCfC\CCC\C\C C.CCffBB8RBQB33B33B8RB8RBBBB.BLBaHBBaHB3BBBB)C\C^CpCC@ CC }qC ޸C W
C 
CC +B{B#CkCO\CCC	HCǮC\CO\CT{BBffC C BBBfB B
BGB BqBqB3C .C ٚCkC )C 3C  CGBC8RBRB33B=qBBpB8RB.BW
C \C:BqCC
CCkB.CC zB BBW
B BB.BuB)BHB
=BHB=qB➸B3BfBqBGB{B=B㙚B33BW
BBBߔ{BBBaHBffBBfB3B\B\B=B.BffB.C YCB8RBBqB8RB C LCCC ٚB.BBRBB{CC!HC\)CB=B
C zCqC qB(BkBpBzB\BBB(B33B)BLB8RBBB)BB\BBBB{CC)C
BCC)CC{C	CCYC0CGCCCs3C=CC	)C CxRC
C
=CJ=B3CfB3C	qC#C#B=BuBB.BkBB\)C=BǮBǮB\)BuBBBBHBzBǮB3BC hC\CQCffC)CC=C3C{C)C=qC)C
B#B  B3BB{BW
B=qB#BǮBBBBBBBB{BHBBB\)B=qBB#BB
B8RBǮBHBBfC	CBC
=C
HCCJ=CC{CC C
CCC	HCCC:CBzCC  CHCQCW
B33BRBBkBpB=BHBW
BBB.BRB=qB\BW
B\BqBQB\B.B33BBuBBBW
B
BHC CcCC
CCCCqCCCC=C CW
C&fC
CB)B=qBqB
=BǮBaHBB=B=qB\BHB.B33BBBBBW
B)B BB BuBLBB\BpB
=B왚BBB{B#C CCCCC=C
)CC
=C\CC}qCCC
 C#BpBBBBC	CCCqBCBaHCCC C@ CBC=BQBCB)B왚BB3BRBBBuCaHBQBkB\)BfBpC)C
CCC
CٚC
\)CT{CGCcCǮB)BCCCO\CnCQC^CC qBBzC33BB33BfB3BǮB BBBBǮBuBQBBW
B.BBB\B\BBB
BBꞸBB\BB=B
BǮBRB BBC=qBpCGCCJ=C!HC  BHC)B\)BHC{BBB.B\)B  B\)BRBpBBpB{B
B
=BW
B=qBQB=qBBBfB׊=BB
BڸRBW
B  BBpB(B.BkB\)BBRB=BHBBfCC
 C	{CCC.CBC CٚCCnC C\C
C	xRBB{BBꙚB
BLBBǮB.BBpB
BkBW
B#B{B\)BǮBHBaHBzB)BBaHBRBB.BkB\)BzBB{BQCEC'CCC+C)C:C=qB  BQBB\BffBffBffBBRBQBaHBpB
B)B3BB
BQBB
B홚BpB\BB{B
=B8RBuB枸BBBCLCs3C	xRCzCCQCC\C#C\C CW
CC	ٚCYCC\C^C
=C ChCxRC+C	Cs3B8RB{CzC B#BBW
BBBBBzBBLB  BHB.B
=BBBW
B\)CqC#C CCpC C
33C CCEC\C 
C$YC$C(C(aHC)C%T{C*)CCCCBQC
!HCCcCC(CCCCxRC
CCCC33B  BGBQBkBfBB33BfBBqBC
C	W
BLC	^CxRC
{CC@ C3CCC
޸CLC'fC3C)J=C.QBfC3CRCfCYC&fC=qB
CC	CYCfC33CC{C\C	=C
ǮCCnC
=CCC	{B33BzCkC#B  BC޸Cs3CRC B)CfCO\CCC
cCJ=CCCCC!T{C%#C"@ CCkCC5CCHC\CC=CC
#C\C)CBLB CCHC \C zBBGBBBGCQBkCC)C	)C
)CCuC3CC޸CǮCC\)CC	C
C+CcC0C C(C޸ChCC
CǮCuC
C
pC
W
C#CBqBpBǮBB{B=qB B(B#BBBW
B  BBkBBBBkBkCW
C)CCC
(CCCC{C=qCC
qCCqC!HC{C}qCHC {B\)C=CCCBuC
 CLC{BBuBB\)BQBuBQB)BBCYCuBkBuB=B C J=C  B33B{B33BQBBC YC:C
CC
C)CW
C
{CǮCHCC CC\CcCnC(C{C=C
0C+CaHCqC3CCBCs3BCB=qBaHC
=CpBfBaHB\BBfB
=B#BGBC =C}qCC C}qC)C޸C	s3C8RC
C(C\C+C!HC3C"O\CffCuCqCCHC  CfC
qCC
:C+CHBRC)CW
C\CO\C:CCCzCBB{BW
B)BGB잸BBBBB{B#BC33B{CqC
C
xRC
s3C
CfBuCRC{C .BC	nCC!CO\CcCRCCCzCQC
CCEBCٚBkCC #C	RCCBBpBB{BBW
BkBBB  BGBBqB
=BuB8RBBCO\B=BuC {CC)CnB=B
=C	ffBffC
C	C@ CCC=qCǮCQCJ=CfBBBBRB33B33C fBffBpBfB=BQB(B(B{B\BǮBBzB.BBBBLB
=BGBǮBB33BpBBQBB33C.CCQC\C	\)CC\BC(C#B\C BBB.BW
BC =qBzB  BuB  BǮBfB.BBaHBHBBBBfBBaHBBB  BB8RBaHBBBBB  BC RC ǮC.C =qB8RBQC\CQCC C B=BB)BffBB8RBqB3B BW
BQB  BkBB{B\)BB{B\B8RBzBBߣB8RBB33B\B{BBBBBzBB晚B=BGB뙚B3B3BBzBkBpB
=B{B#BzB{B܊=BBBB޽qB(BffBBܳ3BBBuB  B=qB#B.BBB{Bʊ=B{BBЏ\BB
BBݏ\B
BfBߣB\BីBBBBQBB\BBGBRBzBB#B#BǮBݙBؽqBQB؏\B׳3B#BBuBLBBBBӔ{B\BBB(B
B\BϙBBBHBGB{BBBݞBݨB{BޣB  B
=B(BHB䞸B
B)BBqBB\BBHB랸BaHB3BBBBQBfBLB݀ BfBBfBHBkB.BB(BaHBffB{B
=BBBޅB33BǮBBB۽qBBۨB.B
B
=BBB\B#B  BBffBLBBffB{BB
=B\)BBBffBBǮBB\B3BBBaHBffBBQB瞸BBBGB33BGBpBBfBW
BffBBǮB#BfBqB
BzBB3BzC BᙚB8RBBBHCGCqB8RBffBBB\BBffB
B{BzBBaHB B=qB BBkB=B\)BffBaHB{Bڏ\BׅBzBzBڽqBHBRBB\)BW
BBBBBǮBBLB=qC GBW
C cC #BBzCO\CcC
qB)BGBBGBǮCaHC#B  B.B\)C5B\)BzBBHBB.B3BBRB BBBǮB߳3BBB=qB#B{BzBqBHBB(BBfC8RC CcCC#CfCQC}qC}qCCCCCC@ CCC
cC
C	  C&fC	(B=BLB  BqB{B=qBǮBffB8RBǮB
B
=BBB噚BB=qB\BffB B)C CCRC\)CCC	T{C
C

CqCW
CC@ C.CCHC=C
=CQCCnCECCC{C
qC
O\C CQC
HC RBBB=BzB{BBkBHCCs3CBCT{CBB  C!HCCBǮC5C C	ٚC5C8RC
CRCC
{CLCCCHC	fCCzC!HCC
3C{CǮC&{C^CW
CaHCC33CCJ=C%hC9C!qC&{BCCCaHC
CCqC\C8RCT{CC=qCfCzCCC
BqBC C CC.CC
=C\CCٚCCC{C(CCpC RCBW
B BB\BB33BBBBB=qB8RBBC BHC.CHCBBffB#BHB)B=qB䞸B)BC B(BW
B3BHBkB
BBBaHBB{BBBBBBBBB
=BB{B8RBzBGBfC@ CB\B33B\B  BGBBGBuBffBBBB\B
=BpBHBBB\)B
=B3BkB(BᙚBfBQBzB虚BffBBB#BpB
=B\BLBBGB=BBB(B
=B B#B3BꞸBB.B\BߞB(BݮBۨBuBBBBB#Bٔ{BzBpB\)BHB
=Bس3B.BuB(BuBW
BBBRB3BQBBBfBGBpBfB
=BQBBBBB
=B3BBzB8RBuB{B  B33BkBBffBBpBkBBqBBBGBB)BBfBfB{B\BǮBBB#BqB3BkBQBBBBqBB C@ BC8RB
=CaHCCCǮC ^C BC
:C RCǮBB\)B\BGBB\)BBB33BRBǮBBRBBBaHBRBzB.BBuB\B#B
=BQBW
BLBC=C	ffCCCqC{CCJ=CcCO\CCCHCkCBBBffBBfBCLC=Cs3BB\BBBpCBՀ BHBBB{BpBLBBLB)B33BǮB{BQB߅B\B.BRB=qBBB3BB BC 0CHC=qCRC&fCYC=CB=B.B{BLB{BBaHBBuB8RBBBBB.BBBBBBBBffB\B\)B{B
BB=qB)BB
=BB(BCaHCLCkCCC!HC

C
kC33CCO\CCBC	C  CnC{CCC޸C QB BGBW
B=qB#BkBzC 
BW
BqC qBBBCB{B{C8RBC\CٚBCqCLCCRCBBB(BC \BW
B\C @ BǮCCC	)CGCCqCChCCBBffB#B\BBB)BBuB#B3BBqBQB  B8RBpBBBBBBBBB\)BBBC@ CC\)CC
+C)C'RC)C/s3C}qC\CC^CCuC
CǮCkC#B#BaHBB=qBB3B8RB{BW
B33BQBfBHB33B\)BָRBخBaHB螸BW
BB{B33B=qBQBBBBBBBzBkB=B3B3BzB
B(B3B
=BB{BaHBBBRBBB=qBBW
BݣB۞BۨBǮBBBՅBШBЙBѣBGBLB(BBaHB
=B=qBfB.B8RB#B  B\)BB{BQBLB{BBB3BBB=qBqBힸB  BB{CfCBCCC+C\)CfCkC\)BB BBBBkBB\)BGBzBǮB3BB33BqB{BB=qB
BǮB\B(B
=B{B)B\BC BB)BfBǮB=B\)C QBB#BBBC3B{BC33C:CC@ CnC B=qBB.BBBLBuBBBB
B33B\)BBBfBB#BQBQB
BfBBzBHBGBBǮBB33BGBGBBBpChCC)CfCfCECCs3C(C)BB\C=BB3B B8RBuBB8RBBuB)BpBffBHB\BfBGBǮBߞBfB#BרBqB8RBB
BzB{B33BBCBLBW
C{C\C=C	QC	C5C=qCCHC
xRCC GBB3BkCJ=B B BHBC=BBꙚBBHBBffBfBLBBBǮB C zC C
CCJ=BǮBffBB
BLB#BuBB  C CCCCCCǮC
C {BB홚BBkBBffB\)BzBpBHBBB
BffBkBuB#B\)B(B=BBBB\)B33B8RB#B噚BBٞBHB33B\)BuBqB=qBBpBB3CCCpC
J=C
CCCffCkB33CB=B=B)BB8RBffBB\B  BqB BBBpB.BBߊ=B)B\B.CO\BffBBBB#BkC BpB#BB=B8RBCqCCBCW
CpC\C.CC3CC"LCHCaHC0C C BzBaHBpB{C\C	C
C BC BffC B{B
=BBBQB(B8RBaHBBBBBB)BBaHBC)CkC	CuCCfCChC\CC:CC C
CCqCfCffCC
C
CB{BQB{BpBBkC 
CCqCC+CC
BffBǮBBqBB\B\B#BffBRC3CRC=CC	C CC^CpC)C{CxRC:CCECC"C$3C'!HC#)CfC	CqCCffCQC:BRCaHBBBQCC\BfCffBzCǮC:BqB.BHChC fCxRCpC33CCCC
kBBLCcC =C
=C	.CC	{C
 C	5CCHCECnC3C
C{CCJ=C	:C{CBBBB  B8RBB8RBQBB
C
BuC  C^C޸C3CCaHC GCCHC.C
CfC:CC
CCCCffCQC\)CCQCCC	=C{C\)CCǮChCC33C kC
CC BǮCHB  BLB3BHBBkBaHBuBBLB  B#B\B#B{BqB
=BBQBB{B#B
B\)BkCT{CLCBC
s3C
:C{CuC3C8RC8RC)C}qC{C C{CCCJ=CHCqCٚC&fBBC {C(C pB\B
B=qC 5B33BB{B{B.BB\BB=BaHB#BffBBBfBfBBuCnCfCCBBCYCJ=CCCRC{CHCT{C{BaHBǮC5B  BBBBǮBuC 
=C^BHBkBLBfBCxRB=BBBRB
=BffB=BBBBkBLB
BB(BBHB8RC }qBLC CffC\C
C  C@ CC
C}qCCCCC\C	fCChBBpBBfB)B(BB33BHB.B\BBBB(BGBRBBB\B#BHBBC.CqBCJ=C{BW
CC	fC{C
CCzC C3CCCC
=C CffC&fC\)CCcC	qC@ B
BBC{B8RCLC J=BqBzBBaHBzB{B.BzB BB{BRB33B{C
CC C GC@ BW
B\B\)BW
B=qBaHBfCC.CpCqC0CQCcCO\CRC
C  C
 BBBBB  B.BBB3BBB♚BfBB3B=qBqB\)BB{B33BqBB\BBBBzB3BBCC)CCCCJ=C	CcCC}qCCC
uC  C
C0CqC
C
5C.CnCYCC#CBBǮB\B.B3BHB  BB)B
BꙚBBzBGBB=BBBBRB=qBBLCRCCC+BCW
C	CRCHCCCGCO\C=CffC{CffCfC	B\)C YB{B  BBRBB33BB=B)B
BܙBBLBQB۳3BuBuB׸RBBǮBըB֏\BLBڸRBkBBB홚BqC kC\)C 8RCfC	^C

C
pBzC
HC
C^CGC\)CzC
\CBC	)C=qCEB{BBaHB\)BpB{BBBuBBaHB\B➸BfB
B\)Bӊ=B#BaHBB{BLBBBuBBBBCxRC
C
\)CC	CCkCCnCRCcCnC
LCC  CCCRBC(C aHBBpB♚BBBBfBzBB.BB\)BB8RB\)B33B
=B{BBffB
BqBBQBCǮBBfC 
CEC ٚC
\CCC
3CaHCCqBBfC{B螸C =BW
BB\)BHBqBB\BBBBW
BڞBffBkBaHBLBBqBQBBBfBBB8RBfBW
BfBƊ=BB{BB\BaHB
=BBBǮB8RBBڊ=BBB8RB
=B{B#B33B\)BGBԨBzB\BўBB
BQBBBԅBѨBB8RB\)BaHB\)B=BBzBW
BzBBRB.B3B(BQBqBBQBGBƙB#BzBϙBǮBӔ{BBңB)BB.BBGB  BBB(BQBӅBBBaHBkB\B=BRB{B  BŽqBƔ{BǮBǔ{BǏ\BBBɳ3BBBQBʸRBuB
BHBBB\BĨBÏ\BzB#Bɳ3B̙B  Bъ=BLBӮB֔{BHBB
=B8RB3BBuBHB#Bڀ BHBzB\)BBB׽qB=qBBB{BՊ=B؊=B  BՔ{BffBЙB
=BBBpBB8RB˞B΀ B̽qBBkBˣBW
Bπ BхBpB
=BGB\)B33BaHB
B\)BB\)B܀ BB{BzBRBaHB#BBB\BBfB)B.B)B\BBfB
B#BިBuB#BLBؽqBaHBڀ BaHBݽqBڔ{BBkB)B
=BǮBkBpBBW
B8RB
B)BBBaHB=BBBzBGB
=BB\)BB䙚B.BBB  B
=BfBߏ\BBǮBB㙚B8RBB{B{B̮Bŀ B\BGBB{BBBBBB8RBBuB#BǮBߔ{BB
=BBB8RBBCnCs3C
C
C=qCCO\C
CC
C
!HCC)C BC LC B#BGBffBB=BffBaHBkB{BLB8RBkBǮBBkB
=BBQB)BpB B8RC3CCJ=C
CpC	3C)C
C	EC
CkC
Cs3C@ CuCqCCC+C
C
hC(CLCC)B
=BRCC\)CC
aHCCRB
B{BW
B\B33B{B
B{B\)BQB8RBfB3C C\C	\C=C8RCqChBpC 5BBHBBB8RBBRBBBBBܳ3B3BBBQBQB{BLB8RBBBBBW
BQB33B=qBBBBBBQB33B䞸BBQBpB)BHB8RB\)BBLB3B8RB=BpB
=BǮBHBBLBB=B(BGBGBBBqB{BBBB33BBB{BB=BBHBB㞸B{BHBBB3BBBQBǮB  BBBRBB.BHBBB{BaHB.BkBBqB홚BzBB BfC CC(BB{B#BBBB{BB\BBzBߨBuBBǮB B
=BB BB{B3BqB8RBaHBBBBB(B33BB{BBB\B
=B BBC qC
=CCRB{BB=C+C
BkBffBLB{C \CECs3B8RC.CCC
.CB C{C0CC.CǮC :C(CfB8RBW
B BB(BBLBB)BB#BRBBW
B)BuBBB8RB(B  BkB33BLBBBGBuBBBaHBB B#B\B\)BBB  BQBB֙BBHB(BׅB.BkB\BBBBǮBBBffBqB\)B8RCC:B
BpB  CEC\)BqBBB#B)BB\)BB(BBBBܽqB\)B\)B֣BBBfBBkBB{B܏\BW
BzBֽqBBffBpBzBͳ3BuBqBîBЙBBճ3BQBBB
BBܽqB  BkBBڣBBB B\BffB(B݀ BݣB
=BB  BfBB)BָRBpBԙBQB{BB)BB\BBǮB  BνqBHBЅB.BkBB\BӣBBӣBB)BBzBBBBB\BpB(B B=B{BLBBB\BHBBkBzB8RB{B\BGBffBHBqB
=B#B
=BۨBfB8RB˳3BɮBǮBؔ{B
B׊=Bٳ3BW
B
BBuBBB8RBأBQBB׸RBaHBffB\BQBBzBW
BuBuB33BRBkB33B\)B
=BBW
B
B
=B߽qBBߙBBGBݔ{B{BpB#B=qBQBǮBGBр B8RBfBB\)BBBB{B)B#BϙB#B  BգBǮBڀ BHB  Bߊ=BLBHB(B
=BB\B
BHBaHB=qBfB.BqB8RB=qBuBBǮB33B\BB=qBpB\B(BB#BHB֣B(BW
BB{B)BBHB
BǮBBԞBBHBzB
=BޣB
=BBB33BqBaHB8RBaHBB
B.BGB3BBBW
BBzB{BߣB33B=qBBzB8RBۅBמBߞBߊ=BޙB؊=BǮBԣBBۣB\BܽqBQBpB{BHBʔ{Bϳ3BB
B؞B(BՅBW
BQB݅BBBBBW
BBBpBǮBBݣBBBܽqBB\BB۸RBkBB B#BݣBߔ{BBBQB\BLB  B\BBfBLB׸RBՀ B#Bۀ BBӨBϮB.BՔ{B؀ BB\B{BuB(BuB8RB(BqBBB{BB#BB33B
=BaHBBaHB\B{BB{B BីB
=B
BBGB
B{B\BB\BqBυBQBffB\BuBBB
=B  B\B3BǮB(B(BܞBQBBBBBpBBfBLBB BqBqBLB BB枸B
BB
B  BQB\B
=BǮBB߮Bܔ{Bۀ BݞBLBLBǮBBkB
=BBaHBB۞BHBHBkB B瞸BBRBB
=B\)BfBB BBkB\B=B BBB3BuB(BaHBW
BB\BBBpBޮB㙚B  B
=B䙚BaHB.BzBBHB3B#BuBGBHB\B螸BRBBǮB\BzBB=BB BuB#B{BBQC 33BHB\BBBfBBB=BBzBuBBBB\)BꙚBBLBfB.B=BBHBqBܙBfBBBffB33BpB#B.B.BBGB݅BW
BpBB\)B3B=B\B#B\)BffB=B33B33B(B BRBBB3BB\B\BB)BB晚B.B33BBBBB\B
BLB
=BBuBHB
=BBzBBٙBߔ{BBݏ\BB\B.B=qBfBBuBHC@ C\)Cs3C^C
qC
C&fCHCC qCCRBBB=BHB33B
=BBC QBBB\BQBuBBLB33B  BǮBظRB.B
BW
B)BaHBuB)B噚B=qBffBBB\B#BHBB\CxRC C	T{C C5C
=CCCCCC
 C
CkBCJ=B=B\)BBBHB晚BzB3BfB㙚B{BzBGBB)BRBBݔ{BBkBqBW
BRBQBkCJ=C\C\CCٚC	{C
0CǮCJ=C8RC\CfC}qCCs3CC\CCcCC5CCC{CC)CCGCRBB  BǮB3CECLC \C GC{CBC(B\BBBB{B\C5BGBkC@ C	޸CEC
33CC!HC^C5ChC!RC C C&uC(=qC"uCC !HCaHCCEC
C
CGCC=qC!HCqC
3C
CW
CC=C
J=CCB8RC CRB8RBBBB)BkBBQB{BǮB3BuBGC(CCYBBC }qC )BCC^Cs3CCHC0C=C:C)CCCC\C{CB\BBGBHBBǮBB3BBB
=BLB잸BB3BBHBBGBBBzBqBBpBBB
=BǮBޮBB8RBڅB  BBBRBkBBGBGB.B\BBBBBB  BLBBBBkB\B  B33BBffB{B׽qBBڏ\B{BB)B#BǮB#BGB
=BɞBνqBBLBèB#BfBpBfB{B
B՞B׽qBB33B\BٮBُ\BٮBۣBظRBB33BB\)B=qBzBpBBB)BBffBBBBB.BkBfBBЙBBɞBǣBBBǳ3BBƣB\BBBθRBπ B
B
BBaHB8RBBޔ{Bݔ{BBB=BaHB=qBBBB\BBuBLBqBW
BW
BW
BBBHB
BfBBGBB.BLBBӔ{BӔ{BBHBHBҨBuBBBBBBkB  BמBBkB8RBBffBHBBzB8RBBBBW
B)BB3B\BB)B33B8RBBޏ\BpBHBB
BBpB(BpB\BLB)BLBBڮBυBǮBuBLB\BB(BBܳ3B\)BQBpBBB3BBǮB\C ^C\C8RCkCffCBB)B
BCT{CC{CJ=C
=C 
BC5B\BkC  B
=B\BQBQBBB33B{BBaHBBڸRB(BB\B\BB=BfBfBB)B  BBBpB\B)C =qC B=B  B\C ǮBB  B  B(B\BBBuBaHBB8RB\B왚BuBB#B BQB(BLBBBaHBBBkB)BBHB晚B B B{BBQBQB3BqBzBB33B
C CٚCpBfBB=qBBqBkBBBB\BqBB.B\BB3BB33BLBǮB33BBBBffBBpBzBBBB{B؏\BBaHBڞBBkBBffBRBB\BBBzB{BuBB8RB  B.B
=B(BBuBǮBRB  BǮB8RBߞB\BBkBڳ3B
B33BיB{BǮB֏\BpBB
Bʊ=B
=BB  BGBB=qBB{BՅBBBffB.BB=B\)BBǮBB
=B{BaHBB\)B\)BB\BLBqBBB)BB癚BBLBpBkB=BBBRB
=BBފ=Bޔ{B33BpB(BzBBHBBGB\B8RB(B B#BRBB
BLB#B\)CCEC)CCCzCs3C)C:C+CCCT{C.BaHBB=qBBBfBffBǮB.BB{B\BBBǮB#BBuBBޮBBB=B\B(B=qBaHBLBB.B{B=B#BW
BB=qB
=BBB)BB=qBBBB BLB(B\BpBzBBBǮB=qBBܔ{B߮B.BaHBBGB\)B\B؀ BBBє{BBaHBuBѸRBfBB֊=BkBW
Bݳ3B߀ BfB=BuBLBqB\BBBC BpBB BB#B.BffB{BRBLBB{BBLBB B{B
=B虚BW
B33BqB=BBBس3B՞BW
BHB
=BǮBBǮBB3BB8RBaHBB#BffB=qB33BBQBB\)B=qB3BB{BBB\)BffBBBW
B#BQB
BBBB
BHBkBBBхBֳ3BHBBffBԮB.BB
BףB؞BBQB(B  BB֣BBBBQBۨBBBٽqBB  B=qBǮBB۔{BըB۔{BBB(BQB BBB33BLBQB33B#BBӀ BB
=BffBBBӨBȣBpBB{BӸRBpB
BaHBkBϊ=BϏ\B
BB\BffBkB
=BQBfBѨBљB{BBД{B.B=qBB=qBӏ\B(B\BaHBuB)BBƅBţBBfB͸RBB8RB)BBǀ BGB=qBQB\BLBffBȀ BǅBøRBBǽqB(BpBʳ3Bˀ BǮBBȨBήBBBGBўB)BӞB׏\B33BҮB=qBـ BǮBBuBBڏ\BBۮBLB\)B  BBHB
=BffB)BpBGBʊ=BȊ=BǊ=B33BĮB\)BfB
=BĽqB8RBW
BzBąB@^{BuBǮB\BGBBBǮB)BLB
=BkBzBffBQBW
BffBڙBרBffBׅBBBBٳ3B)BBBaHBGBGBBڸRB=qBѣB\BԔ{B#BLB{BaHB8RBB  B=qB8RBʸRBzB\)BB#B.BLBծBγ3BBBHBBLB݅B=qB{B33BqBpB#B)BB=qB=qBBBqBB3BB BLBpBHB\BBB.BBBLBԊ=BffBУBЅB֊=B#BBzB)B
=B݅B  BިBBkB33BBBC!HC
3CHBaHCB(B{ChC\BaHBB
=BpBǮBߙBߊ=BBGBBݔ{BffBBHB=qBֳ3BpB)B{B33BfBaHB  BBݙBיB.BB\)B߸RBB)BQBBBB)B=qB\Bݳ3B
=BGBGBHBkBaHB
=B8RBQBB
=BGBBBBzBB#B{BߨBuB=qBW
BўBQBGBǮBHB֏\B׀ BօBHBW
BffBB
=B\)BB݀ B߽qB
=BB8RB33BGBB癚BHBBBBaHBBuBBB瞸B\B33B{B=qB(B\)B#BB\B.BBHB=BBQB  BfBBuB B\BffBpBqB
B۽qBBuB#BB33B٨BW
BܙBzB\BfBǮBB晚B=BLB#BBBB
B랸B=qB{B
=B\B)B{B)B\)BaHBpBBzB8RB)B
BHBЊ=BǮBGB=qBӞBBѣBGBǮBB8RBʸRBӨBffB  B33BBBBBQBpB{BB
=BBB
=B.BkB{B)B3BBW
B)BB33BBB3BBBBqB܀ BBzBǮB(BHBBBBGB䙚BីBܞBBuBҸRBzBkBpBkBfBր B\)BW
B{B\B#BBffBBB  B
=BڣBkBpBBBB=qBBBffB=qBܣBBkB
=B
=BkB(Bֳ3Bٳ3BBBBBB8RB(BӅBkB#BȮBȔ{BBǮBBkBfBffBҳ3BQBfBس3BBfB{B#BB#BkBǮBqBkBzB=B߽qB8RBBBߔ{BܮBٮBBkB߳3BffBLBڊ=BBkB֏\B)B#BW
B)B  BB\BQBBaHB
B8RBBBBؽqBBB׽qB׽qB׀ BBB)BffBB\BB=qBB䞸BǮBBBpB.B8RB3B{B
BB\B33BBGB۔{BBָRBGBٞBW
B=qBuBffBǮB׏\BӅBBBBBBԳ3BB.BzB.BB)BBܞBBޣBߏ\B B8RBaHB=qB)BB\)BꞸBBHBǮBLBfBBBW
BB߽qB  BߣBffBW
BBzBճ3BB#BHBǣBBB=BQBkB
BGBHBLB=qBB
=BW
B̳3BuB)BQBLBخBBB=qB
=B.B B(B{B=BܞBQBѸRBQB3BCBfB  BBB B BB㙚B#BBaHBB  BLBB#B.B=B\B㞸BB.BƳ3BBνqBBB
BОB\BBfB߀ BfBHBߊ=B33BB=qBBaHBuB\B鞸B=qB)Cs3B{B(BB=qB
=BǮBܙB)Bٔ{Bس3B{B\B؅B  BLBHBffB33BΏ\B(BОBffB8RBٸRBظRBB#B.BBܨBQBǮBBBfBB=qB\BffBuBfBB=qBǮB BBBRBBzBzBLBߞB
=BB߽qBߞBݞBǮBڊ=BۮBBڣBHBaHBfBkBpB.BBfB  B\BBHBLBӀ Bۏ\B8RBǮBݽqBW
BǮBaHBB䙚BfB\)BBuB
BqBB.BB\)B=qBkB=BkB=BBB3BBǮB3B噚BߙBQBBBۮBBaHBBܽqBBQBܣBܔ{BaHBuB\BB33BqBuBBW
BB)BaHB(BBBB=B B(BB  B=qB BzB
BfBܸRBkBpBBBܽqBHBB)BuBBpBBހ B.B(BBffB\)BBLBޔ{BuB  B BffB垸BB=qB{BffB=qB\B
=BB#B{B.B(BB(BBzBBC3BB.BB.BBB{BǮB\)BGBBqBBB
BB(BB  BRBfBuB۔{BuBffB(B{BkBB  BٞBܸRBBBB33BGB=B.B)B#BBBQBuBW
BpBGB\BuBܨBBffBkBRBǮBB  BBBHBW
B{B܀ B.B
BۅB{B33B  BٮBHBHB33B؊=B
=BW
BaHBQBՔ{B{BfB.Bٳ3BuBHB잸BLB{B3B8RBBuBLB#B{BHBBր BBBУB  BffBЅBpBffBΊ=B̊=BBQBBffBaHB.BЙB33Bπ BЀ BB\)B.BҞBB#B  Bݔ{BBB3B#BaHBQB
=B=BGB{B{BBBB33B33B=B=BBߨB)BBߏ\B\BBffB(BBffB8RBQBW
BƞBGB#B
B(BBB8RBuB
=B
=BfBkBǳ3B{BBBB.BpBpBzBB=BB
BȨBBpB\BkBBB.BBRBB8RBBBBB£BaHBBB BBpBffBB33BfBLB#B\)BBfBBQBffB#BLBB
=BţB BB  BGBϣBGBBBǸRBŔ{BGBĽqBɮBHBzBQBˊ=B  BkBfBBBHBHB
B{BHBƣBƮBuBų3BBĸRBaHB  B.BBBfBzB=qBBƽqBǊ=B
=B\B{B{BȅBBffBBBQB{B  BBǞBШBLBzB
=B.BBBBπ BQBˏ\BˮBBʔ{BʙBBBGBzBQBBB\)BB.BÙBBGBuB  BzBB\B3BBBBHB BBB=qBzB=qBBGBB3B
=BB.BpBGB#B)BąB  B¨BLB.B\)BBkB
BBBpBB  BLBBBB\B.BffB
=B.BBBBHB.BBB{BHBzBpBBBuB3B8RB33BB(BGBuB
=B\BBBGBaHBBÊ=BW
BÀ BB\B8RB)BzBɊ=B{Bʳ3BBBƙB{BpBBpBBHBB{B(B{B{B\BBBuB=BB=B\BƏ\BÙBșBB̊=B#BϨB\Bӳ3B.B֊=BBרBkB\)BBuBLB=qBǮBQB#BBس3Bֳ3BBBGBBبBB֞B=qB.B͞BQBBB\Bǀ B\)B̀ B͙B(BB.B(B  BzB̸RBBaHBЀ Bр B
B8RB)BB#B{BB׀ BHBǮB׮BffBGBQBB׸RB.BݸRBBׅBB33BBѮBBBffBǏ\BzBpBW
BǮB
BǮB33B\Bʏ\BBBB=qB̏\BHB˙BHBBffBffBaHBLB=qB\BB֏\Bה{B׮BB{BѽqB
BΣBfB{B˔{BGBuBʅBfB\B
=BBϊ=B33BͮB  BBGBǳ3B̀ Bˀ BB8RBȏ\BQBBǮBɨBfB{BQB33BǞBB˳3BkB̏\B.B=qBծB33BB׀ BܣBBܔ{B8RB#BBpBkBBW
BLB
=B\)BffBaHBB
BQB=qB{B΀ B
B̨BBBB΀ B̀ BLBBˮBpBkB\)BBɨBpB#BBBǽqBGBє{BӅBQB{BǮBـ B\)BzBBBBB\)BҞB=qBpBffBг3BHB)BfBϣB#B=qB˔{BǮBGBBBpBˀ BuBBȊ=BB
=BBBQBBaHB33BB{BpBW
BǮBBBffB{BǣBpBȮBLBЮBϸRB#BBBBB  BҙBѣB(Bϊ=BBLBHB\B8RBB33BpBzBθRBGBͮBBffB̀ B̞BBB(BpBˊ=BBǮB.BBBW
BBBkBqBθRBB
BLBՏ\BB#Bӳ3B֔{BaHB33BffB  BՙBBB{BӨB
BʅB)Bʀ BB
=BB(B=qBBϔ{BW
BЮB˸RBLBəBB=qBBBBB  B
BȨB̸RBW
BBB\BuB{B(B׳3BؙBڀ BBBB=qBѳ3BBB33BׅBB=qB=qBaHBҞBB.BkB{B8RBBB(BBpBսqBkBuBսqBǮBB{B8RBuB{BУBңBӏ\BҔ{BѽqBBBaHBBBָRBkB׸RB٨BיB.BBBي=BBzB\B)BݮB=qBGBHBHBBۙBLBB߅B޳3BB٨BQBـ BpBBQB\)B=qB
B.B
=BzB.BBffBBHBԨB#BBׅBB#Bۏ\BB؞BfB33BBfBBfB  BaHBfB{B3B
=BBkBBaHBBBqB\B)B
=BGB)B  BaHB
BfBBBBΊ=BBzB=qBpBɣBBB\)BGBBBʸRB=qB(BәBBBճ3Bؔ{B)B)BօBffB{BQB(B=B3BB#BffBBB֊=BW
BGB  BfB{B
B
B۳3B8RB\BBGB{BBaHBBBӮBpB\B
BpBW
BОBpBB(BB=qBBǮBըBBQBӨB33B
BzBսqBBBfB{BBQBffBBޮB
B.BBBW
B♚B B3BBzBӞBʏ\BaHBBոRB
=BBBffBճ3BuB#B)BB8RB\BᙚBB
B{B.BB=qB3BffB
=BBW
BHB
=B\)B(B{BBffBuBր BBBͮBǮBڳ3B8RB
=BԣB(B)BaHB{B
BϨB=qBЙBB{BBuBHBBϣBffB\)BϸRBД{BǮBLBBBѨBʸRBBpB#B
=Bр BHBBϣB̊=BQB8RB)BB
BșBBϙB\BBuBuBBBBB{B(B̳3B=qBW
BkBBǮBffBaHBkBW
B\BGB33BfBBBǮB)BB(BBŽqB{B)BȔ{B=qB.BʽqBkBzB\)BQBuBBʏ\B\)BͮBfBŞB̳3BB8RB˅B=qB)BǅB#B8RBGBĀ BLBBBBRB#BaHB=qBÅB
=BÞB)B.BB=qBBǮBpBBB8RB\B֊=B
=BB֨BGBffBBGB=qBҸRBBB{B
=BpB)BѨBBBBBЀ BBB{BB˞BBQB{BƳ3BʅBBBBBBB.BBǞBBBffBǏ\B
=BBиRBffBхBҨB33BLBuBBaHBBܙBGBB\BLBڨBҮB.BBBW
B\B33B\BHB33B)BBB˅BǮB.BLBBGBQB\BfB33BGB33Bɳ3B.Bʔ{B˸RBQBB\BW
B(B33B
=BGBGBոRB׳3BBGB
BBBLB\)B8RBр BffBʮBBҀ BͨBҸRBffBuBˊ=BLBڨBuBB٨B(B
BBW
BGBB˞B̸RBBpBШB8RBʸRB
BaHBGBBQB33B#BffBǮBBѣBGB(Bӳ3B
=BӔ{BQBҔ{BBBڣBLBBzB\BB\)BaHB.BBўB\B̳3B{B\Bγ3B.BΏ\B̀ BB˳3BɨBBQBfB)BaHBpBʳ3BB\BaHBBʙB33B̮BήBBLB  B.BԸRBԊ=B
=BBBBkBBBfBuBW
Bӳ3BBBB{BؽqB(BBkBBLBffB8RBaHB{BB.BǮBɏ\B  BBB̅BȨBǏ\BBBBHBzBB˔{BzBkB΅BսqBBӳ3B.BLB)B{BuB  BBLBBӏ\BLBӀ B(BӮB=qBҔ{BҽqBkBBڔ{B  B.B΅B\BȸRB\)BǊ=BǮB
=B)BQBfBŽqBB.B.B.BǮBfB  BQBγ3BǮBЏ\B  BӞB  B׀ Bה{B#B(BؽqB\B  BٞB\BfBڨBaHBW
B(BLBBǮBkBBBЀ BffBг3B(BaHBըBQBLB  BǮBLB(BffB(BծB#B
BGB{B  BBҀ BkBր BffBLBBBQBB(Bؔ{BؙBLBBuB\)BBffBؽqBzBpBսqBB\BўBٞBڮBݔ{BW
BGBBffBߊ=B#B׮BՊ=BBBݨBB֙B8RBԀ B  B
B{BW
B)BۮBB.BBBǮBaHBBBǮB߅B=qB8RBBGBqBfBkBBBB܅BLBHBuB܊=BޮBǮBݨBaHB=qB(B.BaHBaHB33B
=BǮBQB
=BٙBaHB
=BBգBBB#BBBaHBߔ{BB\BB㞸B
=B
B  BǮBB.BB
=B\BfB\BBͣBBBЀ BzB׮BؽqB\)BW
B(BܮBٸRBpB
BΔ{BBqBBǨBfBuBfBBkB B)B3BǮBW
B\B#B۞B#BBQBB۳3BBB#B8RBB8RBHBkB{BڞBaHBBHBffBLB33BuBԅBB8RBfBճ3BGB  BәBBBBBB)BpBўB33BffBBB8RBQBՔ{BՙB֏\B{BfBBBٳ3Bـ BuBBBمBۏ\BٙBB33B\BHBuBB
=BǮBӣBԣB  B{BB33B۞BٮBB֨B)B8RB΀ B
BBŀ BffBԣBLBݣB۽qB)BB#Bр B\)BBBBBB\)BfBڅBBBW
B{BfBGBۊ=BBڅBBB.BffBB۽qBQBߔ{BޣB۳3BͣB
=BuBҸRBBBkBУBBBQBB(BBɳ3BBΏ\BBBǮB
=B
=BW
BkBԮB
BӀ BظRB{BըBzB֮B׳3B#BLB֨BQBB.BuBBfB33BBBBpB߽qBffB٣BfB(BuBͽqBB  BB.BЅB̀ BBBqBB
=BBHBԨB#B.B.BHB΅BGB(BffB  BҊ=BW
BBя\BBGBǮBffBB
=BҮBԏ\BBB҅BBԀ B#BkBӽqBB  B=qBǮB33B#BpB.BQBB8RBBffBBϳ3BϨB  BǮB.BϮB͏\BϸRBkBBzBҊ=y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AAzAA\AAîAAÙA
=A33A  A  AQAA(AA33A33AAQA
=AǅAAAGAffA\)A\AAAA  AffAAffARA33AAGAAÅARAffA33A(AffApAHAAAA33AGA\ARAAzAAGA  A\)AAAA\A  A
=ApAApA=qAQAGA
AQA
=AA  A
AQAffA\)A(AffAzAAA(ARAAAApAA(AHAGApA(AAAA
=AA(AAAQA33AffA
AQAA
AA{ApA=qA33AffA\AAAA=qAAAffA(A  ApApAAffA
AQAAAAA\A=qA(AzAA\)AAffA
=AHAGA\)A=qApAAAAAAA=qA{A{A33A(AGA=qAAQAQAHAAA{AARA  AGAA\AAAAHA\AA=qA
=AAzAAHA=qA
AffAGAQAGApAAAŮA
=A\)AAApA(AA=qAQAAffA(A{AffAffA
=A¸RAQA(A
A
AAAQA
A
=A
=AAÅA\A
AAApA  A{AA  A  AApA¸RAQAQAǙAȸRA(AffA
=AA33AȣAzAAffA(AffAffAAHAA33AAģA33AQAzAAAAA\A33AQAQA=qAAHA
A33AGA
A\)AAA{AGAAAAAA
AA
=AzAGAHA
=AA¸RA
=A{A=qAHA  A\)A
=AAffA(A  AzAGA
AA
AAQAHAHA\AA\)AQAAGA¸RA
=AffA  AGAHAffA
=A\)AÙAAApA(AHAAAAzA  AQA=qAffAHApA¸RA
=AAAîA\)Aď\A  A{A(A  AA  AHAffA(A(A¸RA{AAAffAAApAHA\)A
A33AGA(AHAGA
AffAAAQAffA{AģAHA
=Aď\AGAApAŮA{AA  AGApAzA\)AApAGAffAAGA£AAÙA\A¸RAîA=qAA{AAQAQA=qA33AAHAApA  A(AHAA=qA33AŅAA{AffAA  Aʏ\AƏ\A(AAĸRAffA33AAď\AA33A
=AƸRAQA{AģAGAƏ\AǅAGA33A(A(A\A=qAQAGA
=A  AGAAAGAA
=AAŅA{A33AƣA\)ApAzA
=AɮA  AQAʣAHAHA\)AHA
=AAffAəA
A(A
=AA  AzA
AGAƏ\AîApApAAǅAGA{A\AffAA¸RAApA(A
A¸RA  Aď\AzAÅAŮAƏ\AA(AA  A
A
=AA(AA˙A=qA(AffA  AʣA33A\)A=qApA
A33AǙAHAɅA{A
=AAHAəA=qA33ApAȸRAɅA=qApApAGAzAAHAəAAʣAA˙A
A{AAAAzA33ApAGAAʏ\ApA
AɅAɅA(AəA˅AffAǮAȸRAffAAƸRAģA
=AGAGA(A£AAGAAffAA  AGA£AHApAA(AzAȏ\A{AHAGA(AApA
=AřAHAAȏ\A\)AɅAɅAǮAGAffA\)AǅAzA(ApAɅA(A{AApAAzA
A
Aď\A(AÅAď\A(A\)AAA{A\)A  A
=AȸRAHAQAzAffA
AzAÙAAGAŮAHAHA33A(A
ApAffA=qAA\)AffAĸRA  AAřAAA
=AGAǮA(AA
=AAÅAřAAAA{AffAAAAAAAAA\)A=qAAffAAffAÅAĸRAƸRAď\A\)AAffAQA
=AÅAÅAffA  A{AAÅAzAGAAA  AApA\AAGAzA=qAAA\)ApAQARAA  A33ARAGA
=AGAAA=qARAffA\)AA33AA\)AffAAAAGAAAQApA
A  AA
=A33AffAAffA\)AA\ApAQA
=A
AA\ARA\AQA\A\AffA  A
=AHAA{AzAAAffAAGA
=AAAA\AA(AA\)AAHA(AAHAA  AAAAHA\A\)AHA  ARAHARAzA\AffAQA  AAAffAAffAffA
=ARAffAApA  AGAHA33AQA{A  AAAAzA33A33AA33ApARARAA(AGAA\AA  AAAA
=A
AHAAHApA{AAzA{AGAA
AHAzAAA
=A33A33A
AAGApA
AHA\ApA\ARAAApA33A  AAGAA  AAAARAA{AAzAGAzA\)A  AQA  ApAAAAAHAAAAA\AGAARA
=AApA
=AAAA33AHA=qA{AAA(A=qA=qA
AHARA  AAA
A=qApA  AAA(A=qA
ApAAAzAAHA{A=qARAGAGAAAA33A
=AGAAA(ApA\)A=qA(ApA  A(AA{AQAAA{A33AzAHAGA{AAGA
=AAAAAA
AAHAApA  A
A
=AAzApA{AA\A
AQAA{A=qA\AzAAAGA\AA
A=qAHA{A{AAAA
AA  AA\)AA\AffA\)AQAAffA
=AA  A  AAA(AzA=qA\AzAHARAGA(A=qA=qAA
A(A33AAA=qAffAAAffAA33AA
ARAřAŮAzAApA33A\)AAA\A\AffA\)AAzA
=AA
AAzA  A\)A  A
=AApAA\AAzAA
AQA\A{AzA\A(AGAA¸RApAAffAffAAffAzAĸRAŅA33AȸRAʸRẠA(ApAAȏ\AʸRA  Aʏ\A\)A\)ApAǮAǙAffA=qA
AÅAAAîApA(A
=AHAffAŮAîAA  AzApA(AAAHA£AA(A=qAGAŮAŮAĸRA\AffAAAAď\A
A  A\)AA=qA{A33AȸRAzAǮA=qApA33ApAAApA(ApAď\AAAď\AAHAzAAAA33A
A{A33AAffAƸRAîA¸RA  AAƸRAƸRA  AȣA\)A
=A(AȸRAffAAȸRA
AffAǙAAȸRAzAHAʣAA  AffAAǮAHA  A\)AAA=qAAAffAffA=qA
=A  A(AAApAQA\)AA£AAGA  AAA=qAAA
AHAQApA˅AHAzAA
=AȸRAffA˙A
AAǙAzAffAAƏ\AAȸRAAA
=AHAzAA(ApAŮAĸRAǙAA(AffAQAŅAAGARA
=A=qAƏ\AA=qAAʏ\A
=ApAAQAA
AAA
=ẠA(AəAffAƣA=qAȸRAA
ApAǙA
=AĸRAřAA\)AHA
AQA\)AHAAGApAHAAŅAA  A
=AHAA
ApAHAAɅA=qAAˮȀ\A˅AA=qA˙A˙Ȁ\A̸RAffAAŅAǙAAGAHAzA=qA(A\)Aď\A=qA\)AAĸRA
AĸRAffAHApAƣAɅA(ApA
A=qAffAŅAQA
AffAffAAƸRAǮApAQA33AȣAAȸRAffA
=AffAA\)AAffA{A
=AQApA{A33AffA(ApA(AHAA=qAzA
AAAď\Aď\A
ApA£A33AApAQA  AGAffAŅAƏ\AffA
AAȣA\)AffA{ApAʏ\A{AAͅA̸RAffA{AGAʸRAʏ\AʸRA=qAəA(A\)AzAˮAˮAəAffAŅAAĸRAzAGA
=AzA¸RA\)A  A=qA=qAîAffAGApA=qA\A\A  AQAģA(A{AAǅAAǙAHA  A=qAffAffAʏ\AQAGAʣA  AAApAʏ\AffAA(Aʏ\AAɅAAȸRA
=AǅA
=AřAřAA
=AŮAAď\A=qAÅAA\)A(A
=A(AƸRA
AȸRAAA\)AGA
=AɮA  AAɮAA
AəAəAəAȸRA=qA=qA  AAəAAȏ\AzAǮAȣA
AAAȏ\A(A{AȣAffAȸRAAȸRAGAffAǙAzA£A{AQAAzAƸRA33A  AffAQAAA(ApAzA{AǮAAGAǙA33AȸRAǮAAzAAQAzAQA(AApAȸRAǙA(AǮA
A
AA  AffA=qAǙAAGAGAƣAAHA33A=qAƸRAǅA(A  AffAǮA  AAɮA33AʣA{AAAəAəA
AɮA(AAAA
AA
AəAɅApAA{AA33A
AQAəAQA=qA(A(AƸRA
A=qAA\)A
AǮA33AHAA(AŅAzAGAQAƸRAAAAffAHA  A(AffAȣAȣAȣAȣA{A
=AApAAA  A=qAA  AAffA\)A\)AAA  AGAA33AÙAQA(AƣAHA  AQAGA\)A33AAHAffAQA33A\)AȣA{AHAA{AHAQAQAAAHAHA̸RAAQAͮAͮAͅAzAẠAGAɅA
AHAzAȸRAAǅAřAď\A
A  A=qAʣA{A(AẠA͙AʣA(AzA
=A
=AǅA
A  AθRA33AzAθRAAͅAΣAΏ\A  A
AQAΣA̸RApAAA  A  A̸RA
=A̸RAGAɮA=qA
=AAəA(A
AƸRA(AffA=qA(AƏ\A
=A
A(AGẠAHAəAʸRAʏ\AApA
A
=AͮAиRAHA\)A\)AиRAQA(AҸRAAA\)AAӅAңAHAffA{A
=AAΏ\AffA
AAͮAͮAʏ\AʣAHAAAǙA(AffA(AQAȣA=qẠA\)A{AHAA\)AəA  ApAA=qA˅A{AffA33A
AffAGAzAGA=qAAGA˙A(Ȁ\AffAApAA  A  AffAApAHAͅAAApAffAA˙A=qAAAHAǅA{AA=qAǮAzA=qAȸRA
AA
=AffA(AͮA
AzAA\)AϙAͅAͅAffAzAAAAHAffAˮA=qAGApAA  A
Ȁ\A
=AɮA{A(ApA{A
AffA=qAAGAQA33Aʏ\AA\)AȣAA=qA(A\)A
AffAƸRApA{A
AHA{AȸRAɅAAQAAͮAʸRA
=AAɅApA
AɮA(A
AAAHAȣAAAAď\AAQAffAŅAƸRA(AǅA33AffAGA
AA
AΏ\AQAQAA
Ȁ\AʸRApAɮA(A33A  A  AA  AGAAQA˅AA{AAApA
AA{ApAAəAəApAAAɮA
AzA=qAŮA(AAQAffApAGAffAAA=qAGA{AƸRA  AzAAȸRAAffApAAͮAGA˅AzA\)A˙AΣA\)A̸RA  AAʏ\A  AA
=AQAəAHApA
ApA\)AǅAǮAHAA33A
AîAGAîAGAŅAƣAƸRApA=qAzAģAřAzAǮA33ApA=qAˮA  AQA{AˮA{A  A  A˙A\)ApApA˅A˙A(AAAAGA33AffAffAɅApA33AGAɅAAAŮAAGAQA  A
A=qAɮAʣA33AAAGAAɮAɮAɮAffA33A=qA
AΣA\)A{AAGAхA\)A  AυAυApAυAϙAϮA33A
=A  AA˙AGAzAzA\)ApA33AffAȏ\AHAA33AɮAAAHA
AˮA\)AAA  AGAɅAȣA\)AɅA(AzAHAAɮA
A
AʸRAHA˙AGAAAzApAGApA\)ApApAͅA\)AAAffA33Aȏ\A(A
A{AǙApA
A=qA  A(AffAǮAApAǙAƏ\AHAA=qApAʣAˮAzAͅA{AzA(AA
=A
A(ApA
AA{AA33AAA\)AGAAθRA
=AθRAAGA33AAAϮAQAθRAQA
AυA33A(A
=A
=A
A(A=qAHA\)AAθRAθRA33A=qAиRAѮAAffAApAHAAA\)A
ApA33AAzA
AңAzA  AҸRA  AѮAffA(AzAAHAAAAHAGA(AѮAA
=A(AGA=qA33AAϮAGAA=qAAϙAAϮA=qAQA
=A(AAAGA
AAљA\)AQA=qAzAffA=qAzA(AffAA
=AQA=qA  A
=AQAffAzAAAAθRA=qA͙ApA
=A\)AΣAQA\)AхA(AGAQAQAAѮAffA
AA\)AzAӮAӮAQA
=AԣA(A
=AхApA=qA
AAAzAAzAA  AA{AΏ\A\)ẠAAAͮAA
=AǙAǮA
A\)AǅA
ApAɅAffAQAǙA
AAͅAΏ\AA  AиRAQA\)A{AzAAңAҸRAAffA(AхApAΣAQAϙApAϙAυA͙A(AA
=A
AAʏ\AAɅAffAʸRAAGAAzAQAA33AA
A
=AɅAffAˮȀ\A͙AAA{AzAzA{AffApAApAAAAϙAAAϙA33A  AAΣAGAAʸRA(A(AɅAGAHAQA\)AHAGA̸RAzA\)AApAAȏ\AȣAA˅AŮAHAAzAffA=qAzApA=qA(A33AЏ\AЏ\A
=AиRAzA=qA
AAAA  AθRAAA
=AAˮAAʏ\AɮAɮA33ApAȣAQAQAȏ\AA  AƸRAzA
=AȣA{A  AƏ\A  A{A\)AA\)Aʏ\AˮAA˅ApAffAAApAGAͅA  AffAGA(A͙A  A  A{A{AʸRA=qAHA=qA=qAAȏ\A
A{AGAHAƏ\A{AQApAHA=qAA  AzA{AAǅAAƏ\AAzAQAʣAGA
AzAA
=AϙA33AѮAHA\)A\)AңAAffA=qA
=AУA{AzAУA33AffA
AЏ\A{AzA33ApAAA=qA  AffAQAAHAˮAA
AƣA\)A
=AzAA  A33AAЏ\A33AApA(A\)AGA(AͮA(A{A̸RȀ\A̸RA(AθRAA(A{A
A(AA
A̸RAAzA\)A33AAʸRA  AA33A(ApApAApAffAʏ\A˅A˙A=qApAAHAHA{A̸RAͮA(A{AQA\)AθRAHAΏ\A=qAΣAA=qA=qAΏ\AffAͅA  AΏ\ApA
=AGAzAΏ\AΏ\A
A  A=qAGA\)AȸRA\)AɮA(A(AQA
=AGAzAQA˅AAAQAGAΏ\ApApAυAAAӮA  A(AAԣA  AӮA\)AAәAҸRA33AAңA(ApAΏ\AAAAθRAffA(AffA\)AϮA
AAA=qAAAHAΏ\AzA{AzA
=AAA=qAУA\)AQA33AҸRAAA(AָRAzAQA(A׮AٙAGAأA\)A
=AAУA֣A(AAzAffA\)AHAծAՅA׮AϮAffAQAAAHAAA  A
=AA(AңA\)AʣA
=A\)AΏ\A33A{A
A{AA  A(A33Aԏ\AzAQAzAAAAָRAzA{A(AՙApAՙApAA33ApApA
A  AأA
=AAzAָRAҏ\AәAzAGAA(AQA(A(AՅAffAA͙ApA=qAzAA(AAA(AAffAظRAAGAQA=qA(AHAA֣A֏\AAApAAAzApAәAHAҏ\AGAzApA=qAAԸRAQAәAzA\)AffA  AӮAAԣA=qAAHA
=AAHAAA
AffAHA33AHAA33A=qA
AӮAәAәAәA
=AQAԣAҏ\A33AәAҸRAԏ\AApAQA(AΏ\AffAAͅA̸RA=qAA
ApA˅AˮA(A=qA=qA{Ȁ\A
=AˮA˅AˮA{A33AHAQA(A=qA33A(AAHAAffA=qA\)AHAA33ApAϙAȀ\A  AffA̸RAzA͙AHA˙AHAA˅A
=AAA˅AQAGAAʏ\AHA  A=qA  A
=Aʏ\AffA(AʣAAzAffA  A(AGAA{A(A\)A\)AGAAЏ\A=qAQAңAиRAиRAљA33A  AљAQAHAΣA=qAAAͅAͅAͅAffA(AΣA
=AQA\)A  A˙AAʏ\A  AA{Ȁ\A\)AљA\)A
A
=AϙAAzA
AAҏ\A=qAA
=AAѮA=qAAA\)A\)AAApAAAAA  AQApAAffAGA33A  A(AAzA˅A33ẠAzAzA  A
=Aʏ\AGAẠAzA\)A
AA
A{Aҏ\A\)A{AAңAzAzAљA{AӅA=qAGAѮA{AУAHA
A=qAУAA=qAzAGAθRA=qAGA  A33A{AϙA(AHAHA
AУA
=AAϙAA{A(AϮAffAңApAиRA\)AϮA(AHA\)A{Aҏ\AA{AӮAAAffAA\)A
AңAңAAљA33AAυAffA=qAθRA\)ẠA{AAиRAA
=AffAQA(AHAΣAѮAȸRA=qA=qA
=AȣAGAAGAʏ\AffAˮA=qAΏ\A  AΏ\AңAAHAAQAQA(AAхApAӮAA(AffAѮAңA
=AυAGA=qAQAẠAffAAʸRApA\)AͅA\)A33AAQAѮAѮAQAңA=qAУA(AQAffAGAzAAffA33A
A{AAظRAHAffAأAA(A{A\)AAڸRAzAظRA
=A=qAffAA=qA\)AA(AҸRApA  ApAAHAәAՅAA
A  AAQAAՅAAҏ\AAAffAՅAzA33AA
AAָRAՅAAGA׮AAAՙAӅAGAAQAAzA=qAQAffAGAAAffAͮA  A33AЏ\AGAAθRAAңAՅA
=AңA{AHA\)A(AңAԸRAffAAԸRAծAՅAՅAՅA33AHA=qAzA\)A׮AәAAHA
=A\)AҸRAԸRA33AQApAAA
=A=qA=qAAffA=qAA\)A  A(AυAΏ\AApA  A{A(AApA33A  A\)A{A33AHA{AA  A
Aԏ\Aԏ\Aԏ\A
=A
AQAՙAAָRAzA(A
=AAAGA  AAAA(AA(AzApA  Ȁ\A\)AAAхAͅA
Aҏ\A{AHAffAAυA33A33AA
AA(A׮AzAQAA33AAffA
=ApAѮAAGAA
ApA֏\AzA֣A(A33AGAzA
AхA(ApA
A  A  AQA=qAΏ\AHA(AAAͮA(A
=AHAϙAAУAAzAAAAHAՙA  AӮAQAԸRA33AԣA
=AՙA֏\AffA33AA
AGA
=AQA=qẠAA
=AхA{A  A{AAЏ\AљA{AУAAGA33A
AQAzA33AхA  A=qA  AA
=AθRA33AAхA=qA  A
=AA
=AAffA
A=qA
=AffA֣A֣AQAA33A\)AAHA֣AGAA
=AffAԸRAAԣA
=Aԏ\AQAAQAA33AϙA̸RAͮAGAAGAHA=qAffAffA
=AA{AҸRA(AAA33AՙAffAָRAAzAHAGAHAGAQAAՅA=qAՙAffAzA֣AffA֏\AԣAAHAϮA
AˮAGA̸RAʏ\A  A\)AA{AхAAzA  AzA\)A
AẠA  A  A  AffAffAzAQAApAffAffAңAHA\)AAҸRAQAхA
AQAHAAԣA
A
=Aԏ\Aԏ\AAAA  AGA
AәA
AQA(AӮA
AAиRAЏ\ApA(A33AAffAA(AHAυAϮAϮAzAхAҸRApAHAHA{A\)A
AϙAΣA{A\)AzAHA(AЏ\A  AA  AA(AAGAHA
AҸRA=qA=qA
=AHA\)AϙAθRAQA(A33AΏ\A  AθRAA\)A(AQAљAQAӮAffAzAAA{AAָRAAzAAA=qA֣AQA֏\AՙAA{AHAGA33A֏\AA\)AՙAAAA
AծA  A(AQAУA{A=qApA=qA  AϮA  AAGAA
=AAA֏\AHAGA  A
=AمAGAأA33AHAQAffAأAffA׮AzA֣AApAA=qA(A=qAAA=qAGAffAԣA(AzAҸRA{A
AծAՅAApAGAϙAA  AԸRAAӮA  AٙA{AAԏ\AzAׅA(AffA  AQAQAzAAۙAA  AQAAAAܸRAAQA؏\A\)A
A  AAQA=qA  AzAAAәAGAљAљAӮAHAHA  AffA=qAѮAHA(A{A=qAՙA
AQAҸRAՅA֣ApAָRA
=AHAffAAӅA
AAAA
=AәAAәAAHAԸRA\)AA33AHAHApAAAхA  A\)A=qA֣AAԸRAffA=qAAՙApA33A33A{AHAՅA֣AָRA33A
=A\)A
=AծAԣA=qAAzA  A=qAzA=qApA  A=qAѮA33Aԏ\A{A33A33A
AHA33AAAGAظRAأApA  AظRAظRAAQA(A  A׮AzAծA\)A
AָRAffA֣AffA=qAAHA\)A=qAA\)A\)A\)A
A{AЏ\A33A{A(A33AיA33AGAA
A
=AA{AA
A{A33AGAGAAffA
=A33A\)AиRAHAУA{A=qAЏ\AΣAˮAA
=A͙A  A
AffA͙A
=ApAHAzA(AzA
=ẠA  A
=AQAхA{AAGAQAA33ApAA{A
A֏\AA֣AAمAzA{A
=AٙAٮA\)A
=A=qA{A؏\AA(AQA
=A
=AυA  A  A
=AHAHAzA  A33ApA
AAAA(ApA33A{A\)AQA\)A(A\)AԣA(A\)A=qApA؏\A
AGApA
=AAAffAffAAAٮAAGAGAGAAٙApAA
=AQAGAՅA{AHAծAffA׮A؏\AQA؏\AAA
=AAzAәA\)A\)A{AQA\)A(AՙA
=AѮApAAQAGAAϙAиRAzAυAυAAffA˅A
=AAAGA(A\)AɮAAͅẠAHA(AGAAffA=qAffAʣA  A\)AffAˮAffAʸRA(AA{A  AͮA\)AΣAУAQAӮAӮAԣA
AәA\)AظRAۅAApAAՙA=qAA֣A(AAָRAAҸRAAGA
AՅApA=qAҸRAңAӮAAAӮAA(A=qAAΣAиRAңAAәA
=AHA
AffA  AԣAԸRA(AԸRA֣A33A  AAٙAzA{AAQA\)AzAљAAA  A33AЏ\AQA{A׮AәAӮAffA
=A33A  A(A  AA\)AAQAAϮAffAAʏ\A\)AzA  AzAAQA
AͮA
=A(AˮA  A
A33AGAAAAAAAA\)A  AȣAĸRAA̸RA˅A=qAAzA(AAA̸RAAɮA
ẠApAʏ\AA  A{AřAƸRAHAAͮApAGA=qAffAQA  AAAGAQAHAApA  AңAAәAAծA
A(A\)A  AHAхAϮAУAAθRA˙AffAиRAΏ\A\)A
A{AͅAQA(A  AυA  AffAAffAHAGAAHAϙAϙAffAAA=qAՙA=qA
A(A{A(ApApA  AzA=qAQA  A=qAиRA  A33ApAAA
=AͮAA
=A(A\)A{A(AЏ\AAAͅA33AΏ\AΣAffA
AffA=qA
=A
A
AA(AA{ApAϙAAzApA=qA  A֣A  A
AzA\)A=qA=qAңAӅAApAAA33AAffAffAԸRAHAAzAffA
A  AA33AA˅AGAAzAҏ\A33A
A33AHA
A  A  A  AAхA  AA33AAffAffAҸRAAәA
=AffA{AңAGA
A͙A
AAzA֏\AAظRAQAQA{AzAGA(ApA{A33A
A=qAˮA\)AGAʣAϙA
=AAAA{A
=A
AA  AGAffA\)AzAHA͙AΏ\A
AffAGAΣA=qAAffAAApAA=qA  AʸRA˙AHAθRAAGAzA{AɮAɅAGAGAɅAAAzAA
=AAffApAɮA(A=qAʸRA˅A
=A
AAA
AzA(A(ẠA33A  AʣA=qAˮA
AəA{A(Aʏ\AGAHAzAffAA˅A
=A33AffA33ApA  A
=AAA
A  AɅAřApApAQAȸRA(AȸRAHA
AHAGAHA\)AȸRAA(A\)AAA
AGAAAřAzA
=AQApAəAAffAHAQA
A  Aď\AQA{AzAƸRAffAŮA
A  A
=A{AȣAAɮAQA  A(AffAAAA=qA  A
A  ApAA
=AAәAAAApA
=AffAхAӅAҏ\A(A\)AffAAAQAѮAffAΏ\A(AA(A{AzAGAAGAͮAffAθRA\)AQA͙A(AAA{AzAQAẠA
AQA  AAAffA\)AA=qAA=qAffA=qAԏ\AzA  AHA  Aԏ\AA
=A=qAЏ\AzAGAҏ\A\)AхAѮAЏ\AGAA{AAAиRAffA(A  A(ApAAʣAA(AA(A  A˙AzAȀ\AͮAAA=qAAAAHAυAQAffAA\)AΣAθRAHAΏ\A33ApApA(A  AAGA
A
=ApAA=qA(A  AA\)ApA=qAHAzAffAffAHAȏ\A33A
=AʣAQA=qApAәAAAA  AңA  A
=ApAApA׮A֏\AQA33AծA33AҸRA{A{AAΣAAϙA
=AQA=qA
A{AGAΏ\AA̸RA\)AʣA
AA33A
=A  A͙AAApAQAхAѮAңAAGAA(A\)AAffA\)AzA
A33A֏\AָRAQAQA=qA(A  AHA33AAԏ\AffAҸRAA(A=qAAΣAzAHAGA{A͙AA(A=qA˅AˮAAGAzAAͮẠA
=AͅA͙A  AffAθRAAQA(AAffA
=AЏ\AGAA(AѮA
AA
=AzAљAGAQA
=A=qAffAθRAHAffAQAͮA{ApA͙ApAffA  ApAЏ\AϙA  AAУA33A(A
AffA{A  AУAЏ\A  AffAzAҸRAӅAGAՙA
AGAGAAA33AAHA
=A33AәA  A{AHAGAΏ\AAљAԏ\AHA(AGAAңApAffAGA˅AffA  A(A
=AHAHA̸RȀ\A
AGA
ApAAңApA{A
=AՅAԏ\AԣA{ApA\)AAA
=AHA\)A=qAЏ\A
=AѮAA(ApA  A33AхAЏ\AAиRAHAGAAиRAͮA(AAAA\)AA˙AAHA\)AЏ\AAzAQA=qAΏ\A(AхA  AffAAԸRAGA\)A33A=qA  ApAЏ\AA33ApAхApAAҸRA
=AӅAAffA\)AAϮAffA{AAApA=qAAӅAљA
=AљAҏ\AңAϙA=qAGApApAAffAAHA\)AA{A
=AA\)AAHA
=AHA=qAңAGAHAGA(AHA{AָRApAA
AQAϙA
A\)AυȀ\AHAA
AУA=qAA(AУAљAAиRAҸRAљAA֏\AAQA
=AHA  AԸRAAA֣A
=A33A=qA  AApAיAA{A֏\A  AzAAծA{AzA
=A֣A֏\AӅAQAHA(AAծAAՙA  AAծAAffA\)A׮A  AAA{AӮAGAԣA֏\A{AAAمAGAAٙApAA׮AAA
ApAAأAAA33AיAGA  AAA֏\AծAApAAָRA=qA33A  A{A
=Aҏ\AҸRAAԣA{AծAծAA(A
=Aԏ\AAA׮ApA
A{AأAAAAAApA
AzAԣAҏ\A(AGAӮA\)AAҸRAAͮA33A=qA33AͅA(AAθRAϙA  AAAѮAAGAAGA\)AׅAAA׮AׅA{AظRAٙAظRAAAAGAיAA33A
=AGA\)AffAHAQA=qAQA\)ApAAәAHAGAGAAAHAҏ\AѮAA
=AGAA33AQAffA\)AGAAHApA33A{A=qAA33A
=AGAׅAA
AGAAׅA֏\A33AAzAzA(A
AzA=qAA{AAԣAA(AA  A\)AGAA
A(AAљAzA{AA{AѮAңA
=A{Aԏ\A\)AzA{AQAHAׅAәAׅA33A
ApAzAffAԣAAzA  A
=A
A  A׮AGAυAGA  AAffAӮA{A  A
=AQA{AAхAѮA
A{AQAA
=A
AA=qAffAA(A
=AA֏\AQAzA=qApAA\)AAAծAffA֏\A
=AHAAAAAQA  AՙAHAHAA{A(AzApAхA=qAυAУAиRA\)AQAQAҏ\AљAzAHAffA33AAҏ\A
AzAA=qA(AffAA33AA
AGAۅAAAffAQAQAffA=qAڏ\AڣA
=A\)A=qA
AGAffA33ApAAGA(A
=AA=qAHAffA֏\AHAׅA֣AffAHAHAՙA{ApAAQA؏\A=qAAQAיAQAAGAffAGA{AܣAApAAܸRA=qApA
=A=qAۅA33A{AAHA
AՙAA  AָRAQAzAA֏\AzAzAzAA33A
AffA\)ApA
=A֣AAzA
AzAffA{A(ApA
A(A33A݅A{ApAffA33AQA  AA؏\A=qAיA׮AٙAأAGAA(AGA=qAQAAڣAA33AՅA
A
ApAAHA=qAAQAԣAHAٮA\)ApAAۮAAHA(A\)AڸRA
A
=A
=AڸRAGAۅAHAQAۙAffAݮAAffA  Aޏ\AA܏\Aڏ\AQA  AיA׮AۮA݅A  AzAҏ\A=qA(AA
AԣA
=A
=Aҏ\A  Aҏ\AA(A׮AApA֏\AffAAffAQA33A؏\A=qA׮A׮AGAٮAA33A\)AٙAمAGA=qA؏\AzA׮A֏\AיAGAӅA{AAAՙA֣AHAApAGAمA\)A33A  AA33AzAЏ\AиRAAңA{AمAffA  AՅAծAӮAҏ\AA33AGA
=A
=AAУA\)AAЏ\AУA=qApA
A\)AffAffA
A{A
AQA֣AԸRApAԣAffA(AӮAҏ\A33AA
AӮAA{AzAAGAAGAffApA{AHAңA\)AA\)A=qApAمAمA=qAAAAAۙAAAָRA33AٙAA33AHA33AApAQAԸRA{A
A
=AׅApAQAApAAңAӅA(AAffAӮAՙA֏\AAָRAՅA\)Aԏ\AGA{A33A=qAA  AzAڸRA
=A33AڸRAڏ\AڣAڏ\AffAzAffAGAHApAۙAAۮA
=A(AٙAAffA  AծAՅAA
=AA33AљAGAAzAA=qAHAA(A׮A  AHAGA
=AffAٮA=qAڣA33A\)ApA33AAAGAHA\)A\)ApAۙA
AAA\)AA\)A(A{AAA=qA
=A33AAծAָRAzAԸRAGAGAAәAQAӮAՅAAffA33AGAAAӅAمAGA֏\AAۮAA{A(A  AA{AffAQAAAQA
AzAA  ApApAAHAՅAָRAGAәAAHA(AA  A\)AϙAՙAHAЏ\A(A=qAԏ\AծAծAҏ\AՅAzA{AzAzAA
=A  A33AA{AAGA
ApA33AمAAٙAQAQAGAA  A֏\A\)A{AӅAԣAծA
AzAAأAffAיAzAAAffA
=AffA  AQApAA{A(AGAљA=qA
=A{AA{A֣ApA{A33AA
=AHAיApAAQAӮAҏ\A
AHAAծAAׅAظRAQAڸRAڣApA(AAffAڏ\A{A
AAGAљAGA
=AQAAzA  A=qA\)A\)AffAԏ\A֣A33A׮ApAיAיA\)A\)A
=ApA33AA33AڸRAHAAHAڣA=qAۮAHAAffA=qA
A{A֏\AۅAAڏ\Aڏ\AffAQAڸRAڣAڏ\AAffAApAAA(ApAApAffAAQAffAۅA
A=qAۅAA{AQA{A{AظRApAՙAffAمAHAA\)AمAظRA
A(AffAQAQAGAzA֣AQA\)AA
ApAԏ\A(AGA  ApAGA
AAA֣AAA
=A{A\)AQAAA33AԸRAGAAAAAApApA\)AAAQA֣A
=A\)A׮AיAAՙAAЏ\A(A  AffAApApAGAGApAGAԏ\AՙAA
=AׅA(A׮A؏\AAׅAיAQAծAA֏\AיAA؏\AHAzA
=AA\)AGAٙAAGA  A(AAApAָRA֏\A33A
=AծA֏\A{AApAHA֣AAA
=AzAGA\)A  ApAffAأA
AיAGA
=Aԏ\A
AՅAՙApAיA
A\)A33A=qA=qAָRApAAGAיA
=ApAzA=qA=qAffAՅAQAՙAԸRA\)AAՅA{AԸRAԏ\AA
AAQAхAffA
=AGA{AAA
=AA33AAԣAA׮A  AHA33A֏\AA(A
=A\)AٮAAAمAQAٙAA(AٮAA  A
=AمA33A
A
AGA=qAAAzAA\)AׅAՙAծAHAծA33A
=A{A
=A(AԣA=qA\)AיAApA{A
=AGAA33AAAGA\)A{AAޏ\A޸RA=qA  AffAݮAAA(AAA33AAݮA{AظRAffAffAA
A33AGAAծApAAمA܏\AAffAGA܏\A=qAAA  AיAAzAHAGApApAۙAۙAHAzA=qA=qAHA=qA=qA33AA
A{AݮAۮA
AffAAffAڏ\AٙA{Aԏ\A\)A(A  A=qAGAָRAA\)AיA(A{AQAHAׅA؏\A\)A(A
A(AffAAzAAHA33A\)AܸRAܸRAffAAQAAAffAAHAQAAGAGAAQAڸRAffAffAGAԸRA  AffAڏ\AGAיA(A֣AHAQA\)AAٮAA\)A=qAffAٙAQA  AۙA{AHAۙA
=A(AAffA=qAA{ApA  AA
=A޸RAQA{A  A޸RAޏ\A޸RA{AݙAA\)AGAHAApAffAAzA
AGAA׮A{AA{AۅAAܸRAA\)AڸRAzA\)AՅAٙAA(A\)AGAمAٮAٙAڣAQAGA\)AA=qAڣA
=A33ApA
AڣAڣA{A
ApAQAָRA  A\)ApA֏\AAGAA؏\A(A{AA{A
AA(AڸRA(A=qA
=AAAQAzAڏ\A\)A܏\AGAGAޣApA33A33A
=AޣAޣAGARA33ARAHA\AQAffA=qAGARAAAA  AApAAHAHAA  AA33AA߅ApA\A
=A
=A
ApAARAHA
AQAAffARAAAffA
A(AGAޏ\AffAᙚAᙚAApAAA
=AA\)A=qAGAAzA\)A{AA(AA
=A{AA  AA\)A
AARA܏\A
AffAHAAffA
A=qAzAA݅AGA  AޣA
=AA߅A{ApAGApAA\Aڏ\AA\)A\)A߅A  AA݅AQA݅AݮAffAHA=qA  Aԏ\AQAٙAݮAffAffA{AAۙAיA33A  A  AңA33AHAԏ\A{A׮A
=AٮAظRAzA  AڣA
AAAܣA
A
A
=ApA33ApAAޏ\AܣAffAޣA޸RA=qAݙAGAܣAAۙAzAݮAffA܏\AGAHAAGAAzA
AA(AAۮA{A
AHA݅AݮApAA(ARApAAGA(AGARARAzARAGAzA߅A=qAޣApA33AݮAA\)AQA
=AHAٮAA{AߙAܸRAAA  AAޣA(AיA33AA
A֣ApA
=AٙAzAA܏\AAffAGA  AApAAA{A{AQA(AA(AݙA
=A݅A  AAݙA
A
A
AݙA
AApAݮA޸RA  A(AAAݙAzA܏\AA(AHAzAA=qA߅AAڏ\A؏\AAAffAܣA݅A{AA߮AA߅AGAAzA{A=qAAݮA(A33A33A\)AA{AAޏ\AHAGAߙAA33AޣAffAݮA=qAffAffAffApAQAA33AQA
A(A
=AAܣA\)A޸RAAAffA
A33AAGAAQA
=ARAA(A
AA33AffA33A33AGA33AHAHAAܣA
=ApA߮ApA޸RA߅AA݅AffA޸RAA33A(AHAffAzA33AHAA܏\AܣA
AAᙚA\A\ARAQApAA\A=qAQAApA(A  AffAAAA{AAzAAA
Aޏ\AܣA=qAޣA(AA߮AA\)AAffAAA
A  A
AAA߅ApAۙAffAA
AAA=qA{AffAAQA{AAAA=qAGApA\ApA=qA33AffA(A
AܸRAޏ\A{AAAHARA(AQA33AۅA(AffAGAffAA=qAQA(AApAApAzA
A\)AܣAܣAzAAߙAA{A=qA
=AAAAA(AA33AzAݙAffA\)A(A\)A
AA  AApA
=AApAGApAGA(A{A\)AܸRAݮAݮApAzAأAA\AQA\AHAᙚAA=qA33A=qAffAQAAAffA  A޸RAAARA(A  A{AݮAޣA{A
AAݮA
=A  AzA=qA{A\)A(AQA33AAA33A
=AffAAA
=A
=AݙAzA؏\A=qA  AAzA(AHAԸRAAAGApA=qA
AffAA(AڸRAAAA݅AHApAAQA  A
A{A  AA֏\A33AәAQAڣAծA
AHAQAAzA\)AHAAGAffAڸRAۅA؏\AGA݅AffAݮA  AڸRAݮA(AGAAܸRAAܣAA
=A(AٮAffA  AمA
=A=qA=qAGAAA  A  AAәAָRApAظRApA\)A׮AәAffA  AA{A{A{AAAGAAծAѮA=qA
A؏\AمAAA{A(AׅAיAיAAGAGAzAأApAمA\)A
=AzAA33A
=A֣AzAA33AAzAԏ\AԸRAzAffAAzAzA  Aԏ\A  A\)A  AՙA׮A
AAԸRA
=AQAApA=qAظRAGAAمAGAAۙAڏ\A=qAHAA33AAA(AQAzAۅA
=AHAzAAڣAA(AA
A  AׅAA֏\A(AӮA֏\AQAӮAHA
AָRAQA(AծA33AAָRAHAffAzA{AڣA  AAQA=qA(ApAAظRA=qA׮AAٙAQAAA33AA=qAԣAGAԏ\AAAAzAA  AAffAָRAծAzA{AAA33ApA=qAA
=A
AׅAۮAQA
=AApAAA33AHA
=A
=AיAӅAGAA\)A(A֣A(AיAՙA\)A=qAңAzAAЏ\A{A33A\)AzAffAA33ApAzAأApA֏\AݙApA\)AzAAәAңA33AGAAٮA
=AHApAۅA  AA{AAۮA=qAڣApAڏ\A
A(A33AzA݅AAzAGAיAHApAA33AA=qAA{AffAָRA=qAۙAA  AA\)AA  AGA
=A\)AAQA33A33AGAܣA݅A
A  AQAAApAA=qA(A\)AAHA(A(AݙAffAܸRAffAݙAHA
ApAڸRAAܸRAAAffA
AffA\)A\)AA  Aڏ\AAأAzAGA\)AQA
=A  ApApA{AAARA
A
=AAA=qApA{AA=qAQA  A߅A\)A\)A
=AffAڣApAHA܏\A{AHAQAGAApAיA
=AQAAA
=AۙA\)A(A  A(AۅAzAA  ApApA(AffAޣAAAAAA=qA޸RAݙAA=qAٮAA  AGAָRAׅAׅA؏\AzAHAGAיAAAAAHA33A  AzA\)A  AAffA(A
=A\)A33AffAٮA
A  A33A؏\ApAQAڸRAڣAffAQAQAA܏\A{A  AA=qA33AAQA(AAָRAיAAҏ\AA
AծAzA  AծA{AHAApA  A
A{A\)AۮAA݅AܸRAAAAٙA33AۅAۙA{AzAAA\)AA{A{AzAGAARARA޸RAA
=A  A(AAffA\AA{A\)AQA  A33A܏\AۅAߙAܣA  A=qApA  AGAڸRAAٙAHAA֣AٙAAA܏\A  A޸RAAAA܏\A݅AݮAffAffAޏ\AHA  AAQAHA
=ApA(A=qA=qA
A
AffA
=AޣA  A=qAAApAQA33AڸRAffAڏ\AHAAQA
=AAݙAޏ\AߙA߅AAffA
A\AAzAAARAA
AAHAA{A߮A޸RAۅAA
Aڏ\AHAڸRAAHA=qA܏\AۙA
=A\)A  AڸRAAAAA
=A
A{AָRAA
A(A\)A
A=qA
Aڏ\A(AAAffAApA
A  AۮApAۙApAۅA\)ApAGA
AۮAA
AA33A  AffA
AQAApA֏\A  AA=qAAAAA  AffAzAԏ\AApAՙA(AzAQAAGAծA\)AAAAA\)AQA
=AׅAHA֣AGAApAzAffA؏\AzA=qA؏\A(AHAGAffA؏\AمAApAAAAхA(AׅAAA\)A
=AAA\)ApA=qA
A
=AظRA
AGAzA
A
=AQAHApAڣAڸRAظRA  AA
=AQAظRAAڸRA
=AzAffA=qA
=AAQAffAA33AA=qAffA
A33AӅA33A=qAљAQA
ApAҸRA=qAHAA\)A33A  A33AA  A(ApA33AA(A=qAۅAGA
=AA\)ApA\)A\)A؏\A
=AظRAمAمAAأAAHA
=A
=AGA\)AAQAיAffAffAԏ\AA׮AָRAҸRApA؏\AGA\)AمA=qA
A\)A
=AԣAQAיAzAأAHAQA؏\AظRAffA  AיAׅA  AQA33A
=AffAHAApA
A(AAffAAzA  ApAծAzA(A(A(A  AffAԣA(AA֏\AAGAظRAأA\)AHA  AffA\)A(A؏\AٮA(AGAGAڸRAAAGAGAGAGA{AA(AأAمAApAAڏ\ApAffAAAHAיAָRAظRAHAHAHAׅAffAQA(AA  AAׅA(A֣A  A
=AffAӮA֏\AיAQAٙAffAA33A33AGAGAHAڸRA܏\A(AffAAڣAڣAAzA{AڸRAڏ\A֣AzA  AGAAA
AAӮAAQAHAAffAأAٙAGAظRAӮA؏\AHA\)A{A(AGAffA
=A{Aڏ\A=qA  A{A
AۮAGAA\)AۮA=qA{A(A{AۙA(ApAzA޸RAA݅A33A݅A
=AޣA
AݙAܣAGAۮAA݅A
AݙA݅AۅAffA=qAAHA\)A
=AAAޏ\A\)AHA{A޸RA
=A\)ARA(ApAQAffA(A
ApA  A=qA{A=qA  A=qAHAHAA
=AAߙAzAAzA
AQAAffA33AGAAAA=qA\AAAᙚAA{AffAAߙAޣAzAA{AAAA  ApAA\)A\A
A
AAA{AARAffA
=AzAAAA\)A޸RA  A܏\AAA\)A33AڣAޏ\A  A߅AGAffAAۅAAzA=qAAԣA(AQAA(ApAA(AzAAzAׅAAzAQAAAGApAzAffA
=AAڏ\A
=AHA֣A֏\A
=AA  AA  AAAAzAمAAA  ApAHAHA=qAٮA33AA(AиRAzAՙAՙA=qA
ApAظRA\)AA33ApAA  AָRAHAָRAffAمAzA\)AA
=A\)AأA(A
=AָRA(AzA{AGA\)Aԏ\AхAљAхA
AAA
AУAУAأAGAׅA  AAԏ\AAָRApA(AHAٮAzAۅAHApApA(AGAA\)ApAQA
A  A܏\A
AۮAffAAۙAمAA(AׅA
AיAzA=qAAQAAQAڏ\AA\)AAHA
A(AܸRA
=AݮAAޣAA{A  AQA(A{A޸RA߅AAApA\)AGAAA=qA(Aޏ\A
=A=qAQAA{AAݙAAA\)AܸRApAݮA\)A=qAHAޣAAݙA=qA=qARARAzAffAA(ApAGA{A33A޸RAߙAA=qAAAGAHAAAGApARA33AGAA33AᙚAA(A{A  AA
ApAApAA(AAARA{AAHA  AᙚAAAApAAAAffAAمAڏ\AAA33A
AAޏ\AQA
=AHAffA܏\A=qA
AAܣA߅ApAAAޏ\AAۮApA(AGAAۮA\)AAApA
AAظRA33AA33AمAzA(A
AۙAܸRA33A{A33AӅA
Aԏ\A׮AڣA33A{AAGA߅A߮AA
=AۙAۅAAA
Aڏ\A(AۮAHAڸRAڸRAHAAۙAۙAffAA33ApAHAAAGApA33AzAGAAA33A
=Aԏ\A33AQAA(A{AمAA33Aڏ\AHAۙA  ApAڸRAGAzAQA(A(A{A33A׮AQA׮A֣A֣AAׅA  AՙAՙA=qAAHAA33AHA
=AffAΏ\A=qA
AA\)AָRAHA33ApA֏\ApAљAA
AA  AA33A֣A(AAיAՙA=qA\)AңAAָRA33AHAՙAQAffA33A\)AA  AAffAׅAAApApA  A(AAA  A(A(A33A{A
=AAQA{AA(A33AGAأAӮAQAzA\)A(A  AA\)AA  AzAHA
=A(AA
=ApAAAՙAAQAffA\)A33Aԏ\A(AAԏ\AHApAхA  AЏ\Aҏ\AծAՙAGAѮAA33A\)A{ApAAHA؏\A(A֏\A  A=qAzAمAٙAٮA  ApAGA\)A{AܸRAۙAffAܸRAۅA33AffAGAffAۅApAA
=AAHAA{AՙA(AA\)AGAffA
=A(A(AHA  AApA=qA
=AQA{A(Aڏ\A33A  A(AzAܣAܸRAAۮAGAۙAݙAGApAܣAݮAۮAQAQA  AAAAۮA\)A֏\A=qAA(A33AAffAԸRAԏ\A{AAՙA  A33AЏ\AՙAA33AAHA
=A\)A33AA(A33AGA(AA  A{AA33AAAAA
A=qAAA
=A
=AA(A{AۮA=qA؏\AAԏ\AӮAиRAGAׅAҏ\AәAAQAڣA׮AԸRAԸRAffAAAA  AGAծA
=AՙAA33AGA(A=qAיAA  AzAzAA  A{AAՙAظRAHAffAAGAA\)AffA  A(AffAQAA(A  A
A(AӅA\)AQAԣA=qA{AAA(AzAAffA(A\)A֏\AA33AAzAAHAAHAA׮A׮A33A  AAzA׮AHA=qAA  AԸRAQAAӮAAԏ\AzAAQA  AQApAHAA׮A
AأAAָRA؏\AHAA33AA{A33AظRApA  AQAAA=qAۅAffA\)A(AQAޣAޣAQAA
AA(ApAGAGAڏ\AمApAׅA֏\AHA33A֣A  A֏\AָRA(AzAԣAHA  AzAHAQAٮA(A֏\AAׅAHAA(A
A{A
A  A{A(A
AծApA=qAAAڸRA
AAAGAԏ\AәAՙAׅAA
=ApAQA(AzA
AУAѮAGAңApAffAAЏ\Ȁ\AGA33A
=AˮA(Ȁ\A{A33AffAAGA
AAffAA\)A33AAAծAA
AGAffAzAأAظRA
AzAظRA\)AAA=qA33AӮAffAAAA
A
=A  AffAңAffAzAHA{A֏\AAAAHA
=AzAAϙAffAиRAAՙA׮AHAAAffAffAAӮA=qA؏\AzAQA(AGAҸRAӅA
AA
AGAAA
ApAGAHAA  AAffA͙A33AffA
=AΏ\AθRAA
A
AθRA(AA̸RA̸RAGAA
A(A\)AA˙A=qAffAʸRAzA(AǙAA\)A\)AGAzAHAGA=qA=qAA˙ApAffA(A  AəA(AAGA(A\)AŅAȸRA
AffAȏ\AǮAHAʣA(AGAAA=qAAGAAƏ\AǮAɅAɮA\)A=qAGA=qAQA=qAʏ\AzA̸RA=qA=qAͮAʏ\A\)A  AA
=A(AA  AəAAɮA(AʸRAAȸRApA33AHAGA33A
=A33A
=A33AffẠAA=qAffAGAzAA\)A
=A
ẠA{AAGAGAA33ApAҸRApA{AϙApAGA=qAA{AA{A
AAQA˙A\)A˙AQA{A͙A\)AAAAffA˙A͙AzA
AAQAQAQA33A33ApApA=qA
=AQA33A  A
AˮA  AЏ\AυAAGA(A  AGAϙA\)AУAңA  AApA(A(AHA  A
=A33AԸRApA\)AиRAGApAHAGAzA\)AGA
=A(AAAҸRAҏ\AAHAAHAЏ\ApAQAAffA\)Aԏ\AffA(A33AA\)A\)AӅAҸRApAA  AҸRAљAQAAΏ\Aԏ\A{AA{AͅA
A
AffAQAA{A
A{A
=AHAAѮAGA
=AәA  A(A
=AхAzA33A33AAAffA=qAԸRA
=AθRAA33AA(AAAGA  AиRAУAGAϮAA  AAzẠAffAʏ\AAA(AGAQAA
AffA
A33ApA=qAәApAљApAԣAffAхAAѮA(AzAffApA
=A{A33A̸RAϙA(AAAљAA{AA{AHȀ\AA
ApAȀ\A
=AˮA\)AffA˅AzAffAAυAGAAʣA=qȀ\A=qAffȀ\AͅAθRAθRAAA=qAϙA
=AθRAΏ\AυA
ẠA
=A͙AͮA
AQA  A33AzA
A(AхAA33A33AAхAθRA{A(A  AffAzAAAAӅA=qAHAQA\)AθRA=qAΣAHApA=qAA
A{AQA  AљApA
=A
AzAϮAAHApA33A͙A
=A̸RAAAAͅA33A\)AzAAͅA(AGAʣA
A
AƏ\AA(A{AzAУAffApAƣAȣAzAʣAAɅA=qA\)AAͮAffAͅAͮAAHAΏ\A
AHA(AGAA
A33AGA\)AGAHAΣAA\)AAA
=ẠA
A{ApAAHA(A  AϙA͙AAǮAQA=qA\)AGAGA
A
A̸RA=qAθRAffAAϮAиRAAGAAңAffA(AGApA
AffA
=AzA
=A33A
=ApAGAA(A
=A33A(AȀ\AЏ\A
=AAхAУAAЏ\A  AGAHAәA=qAA{A̸RAA(AHAAϙAGAzAϮAzAzA(AAУA(AzAУA(AzAͮA
A(A͙AAQAA(A
A(A(A
A  ApA=qAɅA{AʸRAʸRA̸RẠAQA
=A
A=qAͮA{AѮAAAGAɅA33A
A
=A
=A  AHAϙA(AffAHAHAGAAAAQAЏ\A33AffA  AffAA  AA(A33A33AGAffA\)AəAθRA
AzA\)A
=A͙AffA  AzA(Aҏ\AӮA33AӅAzAA{A(A
AAAҏ\A(AAυAAAљAңA  A(AAHA(AffA
AQAA(A(AծAԣApAAffAAHAAAѮAGAхA  AA
AffA33AΏ\AzAԏ\AՙA֏\AzA  Aҏ\ApAAzA\)AՙAffA{A(AٮAAQA=qA{ApAApAظRA
AzAzA
AׅA
A֣A׮AzAיAיAԣAԸRAԣA{ApAӮAAԏ\A
=A
AQAAӮA
=AңAGA
=A
AAQAAA
A=qA(A(A(AAՅAAA(AQAQAՅAՅAGAffA֣AA(AAϙAӅA{A
=A
AGApAѮAHAυAAϮAУAzAхAУAAApA=qA
=A=qAHAͅA
AAAΣAA33AϙAA=qAQAҏ\AAQAңAӅAԣAҸRAAԣAzA  A33AzAHAAHA  A{A33A\)AAЏ\AffAљAиRA
=A33AzAGAQAѮAЏ\AGA͙A˙A˙AHA̸RA  Ȁ\AɅAA33AAzA˙A=qA
=AAGA=qAΏ\AA
A
=AGAAApA˙AAA
Ȁ\AzAzA  AzAиRApAHA  AHAͅAAȸRAƸRAAGAA=qAffA  AzAGA=qAA\)AA\)A=qAA\)A  A  Aʏ\Aʏ\A(A  AȸRA{AAGAȏ\AzAAzAA͙AHAЏ\A
A
A
AAffAͅAˮA
=AAA
=AAQAəAȣA=qAȣAǅApAA\A
A{AĸRAzAAQAHAQA{A{AУA
=A
AϮAA(AA
=A{AffAәAхAAffAAAυAffAЏ\AиRAθRA{A{AAȀ\AQAffA\)Aʏ\Ȁ\AffA{AиRȀ\A{AffA
A=qAGAAиRA
A͙A33AQAQA\)A(AA
AffA
=AAQAzA(A{AAApAϙA
ẠAffAzA\)AAQAHA33A
=A˅AϙAffAQAʏ\AQA
AA=qA˅ẠA33AGȀ\AAffAzA(AAѮAA
=AхAffAGA  A=qAA(AGA˙A  AA\)AAA{AA
AƣAAA=qAŮAA(ApAAffAAǙAÙAQAzA
AA33A{A
A33A=qAAAřAzAƣApA(A(AAQA
=A\)A(AŮAHA{Aď\AAÅA(A(A\AQAA\)AA
=A{AHAAAHA\)Aʏ\AzAƏ\AAAHAʣAffA\)AffAǅA˅AGA(AHAHAǮA  AQAffAA
AAϙA=qAΣAAΣAAЏ\A
=AA
=AAAͅA  AGAȀ\AΏ\AffAȀ\AQA͙AzAΏ\A(AʸRAAAͅA̸RA{AzAGAAʏ\A  A=qAAʏ\AʸRAA\)AAHAGA\)AA
=A͙AQAHA
=A\)AͅApA33ApAA  A
A  AA˙A˅ApApAHAAGApA\)A˅AGApA\)AGAHA
=AffA
AȸRAAAGAHAƸRAƏ\A  AȣAAzA{AA  AAHAAGAϙApA\)AQAAAθRAA
=A
=AAθRAAΏ\AQAϙAϮAϮApA(AͮAϮAAAϮAA  AϙAΏ\AͮA  A
A˅ApApApAAGA\)AϮAffAzAΣA{AGA(A
=AffAA
AυA\)AHA
=AхA33AAzAAQAzA{AϮAυAЏ\AϙAΣAffAQAQAQAAGA33A33AGA33A
=AApAϮAϮAAAϙAA  AQAHAA(AA
AHAAGAQAҏ\AәAA\)AAGAԸRAAӅAәAӅApAәAԣA33AHAAA
AGAQA=qA
=AffAԏ\AffA  Aԏ\AHAHA{AGAУAϮA
A=qAffAA  A=qA{A(AAffA
AHAA33AAffAA  AA33A=qA=qAAA33Aҏ\AAAѮAѮA  AѮAQA\)A\)A(A  AA(A  AϙA{AAϮAϙA
=AAAЏ\A
=A
AљA(AљAQȀ\A͙AGAхAAHAA(AA\)AA
AхAffAAGAHAGApAͅA{AAzA  A
AffAAʸRA  AzA\)AͅAͮA  AzA(AGAAͅAУAA  ApA
=A
=AAУAA=qA\)AљA(Aҏ\AAA\)AљAљA
=AHAAͮAΏ\AGA{A
AA˅A(AQApAA33AzA=qAHAHAΣA
AAGAGAAȸRA=qAffA
AɮAA\)A{ẠA\)AͅA  A33AGA
AHA
AΏ\AAЏ\AϙAQAAGAGA(A(AA\)AͅAHA̸RAzA  A˅A˙A(ApA\)AˮApA
=AʣA\)AɅA
AA
A{A
=A
=AHAQAȣAGApAȏ\A  AAQAQA
AAGA=qAθRAͮAAzA33A(AϙAAGAzAΏ\A(A{ApA(AθRA
=A=qA33AͮA͙A\)AGA33A̸RA˙AA\)A
A  A
=AAAffAA
=AAˮAʏ\AA=qAΏ\AffAʣAHAəAQAAɅAAzA=qA˅AˮA{AAͮAAffA˅A˅A(AHA  Aʏ\AȣAHAffA
=A̸RAẠA˅A˙A33AəAA(AGAGA(AA
AǮA{AA(AAʏ\A
AˮȀ\AHApAȏ\AApAʣA=qAHA
=AAApAAzAzẠA  AQAHAGAʸRAGAzAHAA  AAHAffA
AAGA{AƏ\AAƣA=qAřAA{AǙAGAĸRA  AAAzA
ApAɮA  AffA˙A  A33A=qA(Aʏ\AAHA\)Aʏ\AɮA  AA(AAA(A33AGAÙAAAApAGAGAzA
ApAAƣA33AA(AHAA
AzAzA{A(AƸRA  AHAffAffAHA=qAAȣAəA{A  A
AAAAɮA33AffA33AffA˅Aʏ\A˅ApAA{AffAǮA
=A(AAȣAHA  A
AAffA{AGApAģA
AAffAQAHAȣAȸRA=qAffAƸRAǙAʏ\AɮA  AzA33AAǙA(AAɅA=qA\)A33A\)AA=qAͮA
=AGAAA
AHA  AAzAffAǙAAAHAQAA33A{AģAŮAA
=AĸRA\)A33A=qAîA
AîAřAzA33AÅAÅAŅAAzAʸRAHAAGA  AAA̸RAffAřA\)A˅A
=AAˮA(A˙Ȁ\AʣAʣApAHAzA(AzAQA̸RAA\)AA\)A=qAA33A
AAHA
=AA=qAffA\AA
AÅAGAA33A{AA(A
AHAĸRAƸRA\)AƸRAƏ\AƸRAAGAAffA{A
AffAƏ\AřA\)AȣA\)AzA(A(A  AŮAAÙA\)A(A\AGARAApAA=qARAAApAzAffAQAApA\A
=AQAA  AzAARAAAAffAQAGAAzA
=AAzA
=A33A  AAGA33AHA33A
=AA\)AA33AffARA
=ARAzApA33AApAARAffAAA33A(AGA33AAzA=qApAHA{A=qAřAzA(A{AA˅Aʏ\A\)AAAzAAAGAzAA\A33A=qAA33AAQAÙA{A(A{AAAAGA
=AƸRA(AǮAffA=qAʣA33AA
=AʣAA
=ẠAHAΏ\A  A{AAAA{ẠAͅAȀ\AȀ\A  Ȁ\AAffA(ẠAʏ\A33AzA
=AǙA=qAƣAɅAȸRA
AAȣA\)A
=AɅAGA33A
AˮAȀ\AffA(AAAʸRA
AAəAɮAzA=qA(A  A
A\)A\)A=qAəAǮAApAHAQA  AǮAGAəAHAQAAʸRAǙAAƏ\ApAAzA(AɮA
AA33AƸRAHA
AAffAQAApAGAAʏ\A(AɮẠAAAẠAAGAzAzA˙AAGAGAŮAzAŮAzA(AHApA
A{AŅA  AGAA  AʣAǅA˙AAƣAəAɮA
AHAA  A33Aʏ\AAAʏ\A(Aʏ\A33AAffAɅAGA{AAA
AɅAHAˮAffA{AAHAffAͮẠAffA\)AƏ\AA
AGAǅAAǅA{AHAˮAˮApA¸RA  AǙA{AǅApAHAəA(A33AģApA33AAÙA\ApAzAAAA{A33AAQA=qAAÅAzAA{AřAď\ARApAA  A(AA  A
=AQAAA(ApA
=AQAzA33AA=qAģA  Aď\AÙAAAĸRA\)A=qA  A\)AƏ\AAAÅA\)A33AυA
AʸRAA{A̸RȀ\AQA
ApA̸RA\)A\)AɮApA=qAffApAǅAģA33A=qA
=ApA33AAƣAApAȸRAGAffAAřA  A33ApAffAȏ\A
ApAQAȸRAzAHAA{AǅAɅA33AzA=qȀ\A
A̸RA33A{A{A(AA͙AΏ\AQAzA˙A=qAffAffAffAzAŅA(AA\)A  AəApAGAHApA
ApA
=AHAGAAʸRA33A˙A˙A  AʸRAzẠA(A̸RA
=A{ẠAHA=qA{Ȁ\AHAAAͅAˮA
=AHA\)A(AAΏ\AGAAAˮA33A{A
AzAAAzAffA
AHAAGAAHA{A=qA(A=qA{ApAQAȣAAHAzA33AˮA\)AˮAʏ\A{ApAA(AAAƣA(A(AAA
A
A{AAAA33AƸRAffA˅AGAǅAȸRApAAHAʸRA33AAθRAGA{AQAAffA{A{AʣAʸRAʣAHȀ\A
A͙ẠA{AΏ\A
ApAHAAGAGA  AAAˮA=qA{A˅AApA˅AA=qA
ApAApAˮA(A(A
=A
=AHAQAA
=AA(AΣAffAA
=AzAzAHA\)A33AHAAGAA  AA=qA  A{AAAzA
AffA{AиRAљA  A  AGẠAGAA{AAƣAʏ\ẠA̸RAQAAAΏ\AA33AϮA\)A(A(AffAA
=AиRA=qAAffAHAAQAffA  AzA\)AΣAzAApA33AQA=qAAͅAQẠAGA  A
Aȏ\AAƣAȸRAǅAîA
=A(AffAAzAffAƸRA
AGAʣAʸRApAA
AQAɮAGAA
AA
A˅A
AQA(AAGAʣAəAHAʏ\AQAʏ\Aʏ\AʣAzAHAAʸRAzA
=Aʏ\AˮA(Aʏ\Aȏ\AAAzAffAȣAɮA\)AǙA=qAAAA˅AQA̸RA
=AHȀ\AA{AHA
A  Ȁ\AHAHA̸RA̸RAAffAffApAɮAA(A  AəAffA(AA(A˙AAAQAA{A\)AQAŮAÙAffA(AǅAGAAzAA
A
A(AzAzAGAGAA
=AHA33A{AA  AA=qA̸RAffApA
AAˮA=qȀ\A̸RAAffAˮAAzA  A\)A=qA  AˮAAʣAǙA
A{AAffAA=qAƏ\A
AAƸRAǮA
A{Aȏ\A=qAȏ\AAA{AAǮAȸRAGAɅAAʸRA(A
A33ApAɅAʏ\AẠAʸRAAAA33AQAA
AɅAɅAA{A
=AAA\)AɮA
=AAA=qAƣAÅAģAAQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     