CDF       
      
timeseries        obs   #&   station_name_strlen       platform1_strlen      instrument1_strlen     +   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.10, ACDD-1.3, IOOS-1.2    
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2024-01-02T21:11:27Z http://pacioos.org
2024-01-02T21:11:27Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2023-01-01T00:00:00Z&time%3C2024-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2023-07-17T22:00:00Z   time_coverage_resolution      PT30M      time_coverage_start       2023-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A3@   A-nx      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      0 r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      @  A
=   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH           salinity                   _ChunkSizes                
_FillValue        y    actual_range          C   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      ffFU)   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        D   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      LCf   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        1   oxygen                     _ChunkSizes                
_FillValue        y    actual_range      >  AH   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        t   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      @C3q   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        K   ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        פ   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      @  A
=   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        d<   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      }l   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      
   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	         temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      	#4   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      	   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      
<d   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      
   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      U   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      ,   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      n   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      \   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      
   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	         temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      $   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range          C   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B        -   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range                T   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      F   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      ӄ   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      `   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	         salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      yL   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	         salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      |   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	         salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	         salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      8D   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	         salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      Qt   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	         salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      j   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      ffFU)   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        <   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range                   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      l   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	         turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      )   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      4   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      B   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      d   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      [   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	         turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      u,   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	         turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      \   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	         chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      LCf   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C           chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range                 4$   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	          chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      !MT   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      !   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      "f   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      "   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      #   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      $L   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      $   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      %%|   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      %   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      &>   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      &D   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      >  AH   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        'W   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                't   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      (q   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      (   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      )<   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      *   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      *l   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      +0   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      +   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      ,I4   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      ,   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      -bd   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      -   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      .{   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      @C3q   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        /,   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range                /   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      0!\   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      0   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      1:   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      1$   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      2S   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      2T   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      3l   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      3   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      4   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      5   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      5L   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      6+   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        6|   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                7E   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      7Ѭ   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      8^D   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      8   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      9wt   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      :   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      :   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      ;<   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      ;   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      <6l   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      <   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      =O   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      =4   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045         >h   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     d ?;   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    <X E#Ap?  wqb_04  A3@   A5   A6   A8   A:H   A<
   A=   A?   AAP   AC   AD   AF   AHX   AJ   AK   AM   AO`   AQ"   AR   AT   AVh   AX*   AY   A[   A]p   A_2   A`   Ab   Adx   Af:   Ag   Ai   Ak   AmB   Ao   Ap   Ar   AtJ   Av   Aw   Ay   A{R   A}   A~   A쀘   AZ   A   A   A쇠   Ab   A$   A   A쎨   Aj   A,   A   A앰   Ar   A4   A   A윸   Az   A<   A   A   A쥂   AD   A   A   A쬊   AL   A   A   A쳒   AT   A   A   A캚   A\   A   A   A   Ad   A&   A   AȪ   Al   A.   A   Aϲ   At   A6   A   Aֺ   A|   A>   A    A   A߄   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A    A   An   A0   A   A	   Av   A
8   A   A   A~   A@   A   A   A   AH   A
   A   A    A"P   A$   A%   A'   A)X   A+   A,   A.   A0`   A2"   A3   A5   A7h   A9*   A:   A<   A>p   A@2   AA   AC   AEx   AG:   AH   AJ   AL   ANB   AP   AQ   AS   AUJ   AW   AX   AZ   A\R   A^   A_   Aa   AcZ   Ae   Af   Ah   Ajb   Al$   Am   Ao   Aqj   As,   At   Av   Axr   Az4   A{   A}   Az   A<   A   A   A톂   AD   A   A   A퍊   AL   A   A   A픒   AT   A   A   A훚   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   Aǌ   AN   A   A   AΔ   AV   A   A   A՜   A^   A    A   Aܤ   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   A
X   A   A
   A   A`   A"   A   A   Ah   A*   A   A   Ap   A!2   A"   A$   A&x   A(:   A)   A+   A-   A/B   A1   A2   A4   A6J   A8   A9   A;   A=R   A?   A@   AB   ADZ   AF   AG   AI   AKb   AM$   AN   AP   ARj   AT,   AU   AW   AYr   A[4   A\   A^   A`z   Ab<   Ac   Ae   Ag   AiD   Ak   Al   An   ApL   Ar   As   Au   AwT   Ay   Az   A|   A~\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   AĬ   An   A0   A   A˴   Av   A8   A   AҼ   A~   A@   A   A   Aۆ   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   A p   A2   A   A   Ax   A	:   A
   A   A   AB   A   A   A   AJ   A   A   A   AR   A    A!   A#   A%Z   A'   A(   A*   A,b   A.$   A/   A1   A3j   A5,   A6   A8   A:r   A<4   A=   A?   AAz   AC<   AD   AF   AH   AJD   AL   AM   AO   AQL   AS   AT   AV   AXT   AZ   A[   A]   A_\   Aa   Ab   Ad   Afd   Ah&   Ai   Ak   Aml   Ao.   Ap   Ar   Att   Av6   Aw   Ay   A{|   A}>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A塞   An   A0   A   Aהּ   Av   A8   A   Aﳼ   A~   A@   A   A   A＆   AH   A
   A   AÎ   AP   A   A   Aʖ   AX   A   A   Aў   A`   A"   A   Aئ   Ah   A*   A   A߮   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A	   A   A
b   A$   A   A   Aj   A,   A   A   Ar   A4   A   A    A"z   A$<   A)   A+D   A-   A.   A0   A2L   A4   A5   A7   A9T   A;   A<   A>   A@\   AB   AC   AE   AGd   AI&   AJ   AL   ANl   AP.   AQ   AS   AUt   AW6   AX   AZ   A\|   A^>   A`    Aa   Ac   AeF   Ag   Ah   Aj   AlN   An   Ao   Aq   AsV   Au   Av   Ax   Az^   A|    A}   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   AǶ   Ax   A:   A   Aξ   AЀ   AB   A   A   A׈   AJ   A   A   Aސ   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A
   AD   A   A   A   AL   A   A   A   AT   A   A   A   A!\   A#   A$   A&   A(d   A*&   A+   A-   A/l   A1.   A2   A4   A6t   A86   A9   A;   A=|   A?>   AA    AB   AD   AFF   AH   AI   AK   AMN   AO   AP   AR   ATV   AV   AW   AY   A[^   A]    A^   A`   Abf   Ad(   Ae   Ag   Ain   Ak0   Al   An   Apv   Ar8   As   Au   Aw~   Ay@   A{   A|   A~   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   AƘ   AZ   A   A   A͠   Ab   A$   A   AԨ   Aj   A,   A   A۰   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A    A\   A   A   A   A	d   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A >   A"    A#   A%   A'F   A)   A*   A,   A.N   A0   A1   A3   A5V   A7   A8   A:   A<^   A>    A?   AA   ACf   AE(   AF   AH   AJn   AL0   AM   AO   AQv   AS8   AT   AV   AX~   AZ@   A\   A]   A_   AaH   Ac
   Ad   Af   AhP   Aj   Ak   Am   AoX   Aq   Ar   At   Av`   Ax"   Ay   A{   A}h   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   Aø   Az   A<   A   A   Â   AD   A   A   Aӊ   AL   A   A   Aڒ   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A
   A   A
   AN   A   A   A   AV   A   A   A   A^   A    A    A"   A$f   A&(   A'   A)   A+n   A-0   A.   A0   A2v   A48   A5   A7   A9~   A;@   A=   A>   A@   ABH   AD
   AE   AG   AIP   AK   AL   AN   APX   AR   AS   AU   AW`   AY"   AZ   A\   A^h   A`*   Aa   Ac   Aep   Ag2   Ah   Aj   Alx   An:   Ao   Aq   As   AuB   Aw   Ax   Az   A|J   A~   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   Aɢ   Ad   A&   A   AЪ   Al   A.   A   Aײ   At   A6   A   A޺   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A     A   A   Af   A(   A   A
   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A!   A#H   A%
   A&   A(   A*P   A,   A-   A/   A1X   A3   A4   A6   A8`   A:"   A;   A=   A?h   AA*   AB   AD   AFp   AH2   AI   AK   AMx   AO:   AP   AR   AT   AVB   AX   AY   A[   A]J   A_   A`   Ab   AdR   Af   Ag   Ai   AkZ   Am   An   Ap   Arb   At$   Au   Aw   Ayj   A{,   A|   A~   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   AȄ   AF   A   A   Aό   AN   A   A   A֔   AV   A   A   Aݜ   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A    A   AH   A
   A   A	   AP   A
   A   A   AX   A   A   A   A`   A"   A   A   A h   A"*   A#   A%   A'p   A)2   A*   A,   A.x   A0:   A1   A3   A5   A7B   A9   A:   A<   A>J   A@   AA   AC   AER   AG   AH   AJ   ALZ   AN   AO   AQ   ASb   AU$   AV   AX   AZj   A\,   A]   A_   Aar   Ac4   Ad   Af   Ahz   Aj<   Ak   Am   Ao   AqD   As   At   Av   AxL   Az   A{   A}   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   AŤ   Af   A(   A   A̬   An   A0   A   AӴ   Av   A8   A   Aڼ   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A
2   A   A
   Ax   A:   A   A   A   AB   A   A   A   AJ   A!   A"   A$   A&R   A(   A)   A+   A-Z   A/   A0   A2   A4b   A6$   A7   A9   A;j   A=,   A>   A@   ABr   AD4   AE   AG   AIz   AK<   AL   AN   AP   ARD   AT   AU   AW   AYL   A[   A\   A^   A`T   Ab   Ac   Ae   Ag\   Ai   Aj   Al   And   Ap&   Aq   As   Aul   Aw.   Ax   Az   A|t   A~6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   AĆ   AH   A
   A   Aˎ   AP   A   A   AҖ   AX   A   A   Aٞ   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   A J   A   A   A   AR   A	   A
   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A!   A#r   A%4   A&   A(   A*z   A,<   A-   A/   A1   A3D   A5   A6   A8   A:L   A<   A=   A?   AAT   AC   AD   AF   AH\   AJ   AK   AM   AOd   AQ&   AR   AT   AVl   AX.   AY   A[   A]t   A_6   A`   Ab   Ad|   Af>   Ah    Ai   Ak   AmF   Ao   Ap   Ar   AtN   Av   Aw   Ay   A{V   A}   A~   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   AȮ   Ap   A2   A   A϶   Ax   A:   A   A־   A؀   AB   A   A   A߈   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A    A   Ar   A4   A   A	   Az   A
<   A   A   A   AD   A   A   A   AL   A   A   A    A"T   A$   A%   A'   A)\   A+   A,   A.   A0d   A2&   A3   A5   A7l   A9.   A:   A<   A>t   A@6   AA   AC   AE|   AG>   AI    AJ   AL   ANF   AP   AQ   AS   AUN   AW   AX   AZ   A\V   A^   A_   Aa   Ac^   Ae    Af   Ah   Ajf   Al(   Am   Ao   Aqn   As0   At   Av   Axv   Az8   A{   A}   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   Aǐ   AR   A   A   AΘ   AZ   A   A   Aՠ   Ab   A$   A   Aܨ   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A
\   A   A
   A   Ad   A&   A   A   Al   A.   A   A   At   A!6   A"   A$   A&|   A(>   A*    A+   A-   A/F   A1   A2   A4   A6N   A8   A9   A;   A=V   A?   A@   AB   AD^   AF    AG   AI   AKf   AM(   AN   AP   ARn   AT0   AU   AW   AYv   A[8   A\   A^   A`~   Ab@   Ad   Ae   Ag   AiH   Ak
   Al   An   ApP   Ar   As   Au   AwX   Ay   Az   A|   A~`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   Aİ   Ar   A4   A   A˸   Az   A<   A   A   AԂ   AD   A   A   Aۊ   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   A t   A6   A   A   A|   A	>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A    A!   A#   A%^   A'    A(   A*   A,f   A.(   A/   A1   A3n   A50   A6   A8   A:v   A<8   A=   A?   AA~   AC@   AE   AF   AH   AJH   AL
   AM   AO   AQP   AS   AT   AV   AXX   AZ   A[   A]   A_`   Aa"   Ab   Ad   Afh   Ah*   Ai   Ak   Amp   Ao2   Ap   Ar   Atx   Av:   Aw   Ay   A{   A}B   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   AÒ   AT   A   A   Aʚ   A\   A   A   AѢ   Ad   A&   A   Aت   Al   A.   A   A߲   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A	   A   A
f   A(   A   A   An   A0   A   A   Av   A8   A   A    A"~   A$@   A&   A'   A)   A+H   A-
   A.   A0   A2P   A4   A5   A7   A9X   A;   A<   A>   A@`   AB"   AC   AE   AGh   AI*   AJ   AL   ANp   AP2   AQ   AS   AUx   AW:   AX   AZ   A\   A^B   A`   Aa   Ac   AeJ   Ag   Ah   Aj   AlR   An   Ao   Aq   AsZ   Au   Av   Ax   Azb   A|$   A}   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   AǺ   A|   A>   A    A   AЄ   AF   A   A   A׌   AN   A   A   Aޔ   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A
   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A!`   A#"   A$   A&   A(h   A**   A+   A-   A/p   A12   A2   A4   A6x   A8:   A9   A;   A=   A?B   AA   AB   AD   AFJ   AH   AI   AK   AMR   AO   AP   AR   ATZ   AV   AW   AY   A[b   A]$   A^   A`   Abj   Ad,   Ae   Ag   Air   Ak4   Al   An   Apz   Ar<   As   Au   Aw   AyD   A{   A|   A~   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   AƜ   A^   A    A   Aͤ   Af   A(   A   AԬ   An   A0   A   A۴   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A    A`   A"   A   A   A	h   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   A B   A"   A#   A%   A'J   A)   A*   A,   A.R   A0   A1   A3   A5Z   A7   A8   A:   A<b   A>$   A?   AA   ACj   AE,   AF   AH   AJr   AL4   AM   AO   AQz   AS<   AT   AV   AX   AZD   A\   A]   A_   AaL   Ac   Ad   Af   AhT   Aj   Ak   Am   Ao\   Aq   Ar   At   Avd   Ax&   Ay   A{   A}l   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   Aü   A~   A@   A   A   Ă   AH   A
   A   Aӎ   AP   A   A   Aږ   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A
   A   A
   AR   A   A   A   AZ   A   A   A   Ab   A$   A    A"   A$j   A&,   A'   A)   A+r   A-4   A.   A0   A2z   A4<   A5   A7   A9   A;D   A=   A>   A@   ABL   AD   AE   AG   AIT   AK   AL   AN   AP\   AR   AS   AU   AWd   AY&   AZ   A\   A^l   A`.   Aa   Ac   Aet   Ag6   Ah   Aj   Al|   An>   Ap    Aq   As   AuF   Aw   Ax   Az   A|N   A~   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   Aɦ   Ah   A*   A   AЮ   Ap   A2   A   A׶   Ax   A:   A   A޾   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A $   A   A   Aj   A,   A   A
   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A!   A#L   A%   A&   A(   A*T   A,   A-   A/   A1\   A3   A4   A6   A8d   A:&   A;   A=   A?l   AA.   AB   AD   AFt   AH6   AI   AK   AM|   AO>   AQ    AR   AT   AVF   AX   AY   A[   A]N   A_   A`   Ab   AdV   Af   Ag   Ai   Ak^   Am    An   Ap   Arf   At(   Au   Aw   Ayn   A{0   A|   A~   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   AȈ   AJ   A   A   Aϐ   AR   A   A   A֘   AZ   A   A   Aݠ   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A     A    A L   A    A    A 	   A T   A 
   A    A    A \   A    A    A    A d   A &   A    A    A  l   A ".   A #   A %   A 't   A )6   A *   A ,   A .|   A 0>   A 2    A 3   A 5   A 7F   A 9   A :   A <   A >N   A @   A A   A C   A EV   A G   A H   A J   A L^   A N    A O   A Q   A Sf   A U(   A V   A X   A Zn   A \0   A ]   A _   A av   A c8   A d   A f   A h~   A j@   A l   A m   A o   A qH   A s
   A t   A v   A xP   A z   A {   A }   A X   A    A    A    A `   A "   A    A    A h   A *   A    A    A p   A 2   A    A    A x   A :   A    A    A    A B   A    A    A    A J   A    A    A    A R   A    A    A    A Z   A    A    A    A b   A $   A    A Ũ   A j   A ,   A    A ̰   A r   A 4   A    A Ӹ   A z   A <   A    A    A ܂   A D   A    A    A    A L   A    A    A    A T   A    A    A    A \   A    A    A    A d   A &   A    A    Al   A.   A   A   At   A
6   A   A
   A|   A>   A    A   A   AF   A   A   A   AN   A!   A"   A$   A&V   A(   A)   A+   A-^   A/    A0   A2   A4f   A6(   A7   A9   A;n   A=0   A>   A@   ABv   AD8   AE   AG   AI~   AK@   AM   AN   AP   ARH   AT
   AU   AW   AYP   A[   A\   A^   A`X   Ab   Ac   Ae   Ag`   Ai"   Aj   Al   Anh   Ap*   Aq   As   Aup   Aw2   Ax   Az   A|x   A~:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   AĊ   AL   A   A   A˒   AT   A   A   AҚ   A\   A   A   A٢   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   A N   A   A   A   AV   A	   A
   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A!   A#v   A%8   A&   A(   A*~   A,@   A.   A/   A1   A3H   A5
   A6   A8   A:P   A<   A=   A?   AAX   AC   AD   AF   AH`   AJ"   AK   AM   AOh   AQ*   AR   AT   AVp   AX2   AY   A[   A]x   A_:   A`   Ab   Ad   AfB   Ah   Ai   Ak   AmJ   Ao   Ap   Ar   AtR   Av   Aw   Ay   A{Z   A}   A~   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   AȲ   At   A6   A   AϺ   A|   A>   A    A   A؄   AF   A   A   Aߌ   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A    A   Av   A8   A   A	   A~   A
@   A   A   A   AH   A
   A   A   AP   A   A   A    A"X   A$   A%   A'   A)`   A+"   A,   A.   A0h   A2*   A3   A5   A7p   A92   A:   A<   A>x   A@:   AA   AC   AE   AGB   AI   AJ   AL   ANJ   AP   AQ   AS   AUR   AW   AX   AZ   A\Z   A^   A_   Aa   Acb   Ae$   Af   Ah   Ajj   Al,   Am   Ao   Aqr   As4   At   Av   Axz   Az<   A{   A}   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   Aǔ   AV   A   A   AΜ   A^   A    A   Aդ   Af   A(   A   Aܬ   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A
`   A"   A
   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A!:   A"   A$   A&   A(B   A*   A+   A-   A/J   A1   A2   A4   A6R   A8   A9   A;   A=Z   A?   A@   AB   ADb   AF$   AG   AI   AKj   AM,   AN   AP   ARr   AT4   AU   AW   AYz   A[<   A\   A^   A`   AbD   Ad   Ae   Ag   AiL   Ak   Al   An   ApT   Ar   As   Au   Aw\   Ay   Az   A|   A~d   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   AĴ   Av   A8   A   A˼   A~   A@   A   A   AԆ   AH   A
   A   Aێ   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   A x   A:   A   A   A   A	B   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A    A!   A#   A%b   A'$   A(   A*   AO   AQT   AS   AT   AV   AX\   AZ   A[   A]   A_d   Aa&   Ab   Ad   Afl   Ah.   Ai   Ak   Amt   Ao6   Ap   Ar   At|   Av>   Ax    Ay   A{   A}F   A   A   A   AN   A   A   A   AV   A   A   A   A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   AÖ   AX   A   A   Aʞ   A`   A"   A   AѦ   Ah   A*   A   Aخ   Ap   A2   A   A߶   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A	   A   A
j   A,   A   A   Ar   A4   A   A   Az   A<   A   A    A"   A$D   A&   A'   A)   A+L   A-   A.   A0   A2T   A4   A5   A7   A9\   A;   A<   A>   A@d   AB&   AC   AE   AGl   AI.   AJ   AL   ANt   AP6   AQ   AS   AU|   AW>   AY    AZ   A\   A^F   A`   Aa   Ac   AeN   Ag   Ah   Aj   AlV   An   Ao   Aq   As^   Au    Av   Ax   Azf   A|(   A}   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   AǾ   Aɀ   AB   A   A   AЈ   AJ   A   A   Aא   AR   A   A   Aޘ   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A
   AL   A   A   A   AT   A   A   A   A\   A   A   A   A!d   A#&   A$   A&   A(l   A*.   A+   A-   A/t   A16   A2   A4   A6|   A8>   A:    A;   A=   A?F   AA   AB   AD   AFN   AH   AI   AK   AMV   AO   AP   AR   AT^   AV    AW   AY   A[f   A](   A^   A`   Abn   Ad0   Ae   Ag   Aiv   Ak8   Al   An   Ap~   Ar@   At   Au   Aw   AyH   A{
   A|   A~   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   AƠ   Ab   A$   A   Aͨ   Aj   A,   A   A԰   Ar   A4   A   A۸   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A    Ad   A&   A   A   A	l   A.   A   A   At   A6   A   A   A|   A>   A    A   A   A F   A"   A#   A%   A'N   A)   A*   A,   A.V   A0   A1   A3   A5^   A7    A8   A:   A<f   A>(   A?   AA   ACn   AE0   AF   AH   AJv   AL8   AM   AO   AQ~   AS@   AU   AV   AX   AZH   A\
   A]   A_   AaP   Ac   Ad   Af   AhX   Aj   Ak   Am   Ao`   Aq"   Ar   At   Avh   Ax*   Ay   A{   A}p   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   Ał   AD   A   A   A̊   AL   A   A   AӒ   AT   A   A   Aښ   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   A	F   A	   A	   A	   A	N   A	
   A	   A	
   A	V   A	   A	   A	   A	^   A	    A	   A	   A	f   A	(   A	    A	"   A	$n   A	&0   A	'   A	)   A	+v   A	-8   A	.   A	0   A	2~   A	4@   A	6   A	7   A	9   A	;H   A	=
   A	>   A	@   A	BP   A	D   A	E   A	G   A	IX   A	K   A	L   A	N   A	P`   A	R"   A	S   A	U   A	Wh   A	Y*   A	Z   A	\   A	^p   A	`2   A	a   A	c   A	ex   A	g:   A	h   A	j   A	l   A	nB   A	p   A	q   A	s   A	uJ   A	w   A	x   A	z   A	|R   A	~   A	   A	   A	Z   A	   A	   A	   A	b   A	$   A	   A	   A	j   A	,   A	   A	   A	r   A	4   A	   A	   A	z   A	<   A	   A	   A	   A	D   A	   A	   A	   A	L   A	   A	   A	   A	T   A	   A	   A	   A	\   A	   A	   A	¢   A	d   A	&   A	   A	ɪ   A	l   A	.   A	   A	в   A	t   A	6   A	   A	׺   A	|   A	>   A	    A	   A	   A	F   A	   A	   A	   A	N   A	   A	   A	   A	V   A	   A	   A	   A	^   A	    A	   A	   A	f   A
 (   A
   A
   A
n   A
0   A
   A

   A
v   A
8   A
   A
   A
~   A
@   A
   A
   A
   A
H   A

   A
   A
!   A
#P   A
%   A
&   A
(   A
*X   A
,   A
-   A
/   A
1`   A
3"   A
4   A
6   A
8h   A
:*   A
;   A
=   A
?p   A
A2   A
B   A
D   A
Fx   A
H:   A
I   A
K   A
M   A
OB   A
Q   A
R   A
T   A
VJ   A
X   A
Y   A
[   A
]R   A
_   A
`   A
b   A
dZ   A
f   A
g   A
i   A
kb   A
m$   A
n   A
p   A
rj   A
t,   A
u   A
w   A
yr   A
{4   A
|   A
~   A
z   A
<   A
   A
   A
   A
D   A
   A
   A
   A
L   A
   A
   A
   A
T   A
   A
   A
   A
\   A
   A
   A
   A
d   A
&   A
   A
   A
l   A
.   A
   A
   A
t   A
6   A
   A
   A
|   A
>   A
    A
   A
   A
F   A
   A
   A
Ȍ   A
N   A
   A
   A
ϔ   A
V   A
   A
   A
֜   A
^   A
    A
   A
ݤ   A
f   A
(   A
   A
   A
n   A
0   A
   A
   A
v   A
8   A
   A
   A
~   A
@   A
   A
   A
   A
H   A

   A    A   AP   A   A   A	   AX   A
   A   A   A`   A"   A   A   Ah   A*   A   A   A p   A"2   A#   A%   A'x   A):   A*   A,   A.   A0B   A2   A3   A5   A7J   A9   A:   A<   A>R   A@   AA   AC   AEZ   AG   AH   AJ   ALb   AN$   AO   AQ   ASj   AU,   AV   AX   AZr   A\4   A]   A_   Aaz   Ac<   Ad   Af   Ah   AjD   Al   Am   Ao   AqL   As   At   Av   AxT   Az   A{   A}   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   AŬ   An   A0   A   A̴   Av   A8   A   AӼ   A~   A@   A   A   A܆   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A
:   A   A
   A   AB   A   A   A   AJ   A   A   A   AR   A!   A"   A$   A&Z   A(   A)   A+   A-b   A/$   A0   A2   A4j   A6,   A7   A9   A;r   A=4   A>   A@   ABz   AD<   AE   AG   AI   AKD   AM   AN   AP   ARL   AT   AU   AW   AYT   A[   A\   A^   A`\   Ab   Ac   Ae   Agd   Ai&   Aj   Al   Anl   A   Aj   A,   A   A   Ar   A4   A   Aĸ   Az   A<   A   A   A͂   AD   A   A   AԊ   AL   A   A   Aے   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A |   A>   A    A   A   A	F   A   A   A   AN   A   A   A   AV   A   A   A   A^   A     A!   A#   A%f   A'(   A(   A*   A,n   A.0   A/   A1   A3v   A58   A6   A8   A:~   A<@   A>   A?   AA   ACH   AE
   AF   AH   AJP   AL   AM   AO   AQX   AS   AT   AV   AX`   AZ"   A[   A]   A_h   Aa*   Ab   Ad   Afp   Ah2   Ai   Ak   Amx   Ao:   Ap   Ar   At   AvB   Ax   Ay   A{   A}J   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   AÚ   A\   A   A   Aʢ   Ad   A&   A   AѪ   Al   A.   A   Aز   At   A6   A   Aߺ   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A	   A   A
n   A0   A   A   Av   A8   A   A   A~   A@   A   A    A"   A$H   A&
   A'   A)   A+P   A-   A.   A0   A2X   A4   A5   A7   A9`   A;"   A<   A>   A@h   AB*   AC   AE   AGp   AI2   AJ   AL   ANx   AP:   AQ   AS   AU   AWB   AY   AZ   A\   A^J   A`   Aa   Ac   AeR   Ag   Ah   Aj   AlZ   An   Ao   Aq   Asb   Au$   Av   Ax   Azj   A|,   A}   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   AɄ   AF   A   A   AЌ   AN   A   A   Aה   AV   A   A   Aޜ   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A    A   A   AH   A
   A   A
   AP   A   A   A   AX   A   A   A   A`   A"   A   A   A!h   A#*   A$   A&   A(p   A*2   A+   A-   A/x   A1:   A2   A4   A6   A8B   A:   A;   A=   A?J   AA   AB   AD   AFR   AH   AI   AK   AMZ   AO   AP   AR   ATb   AV$   AW   AY   A[j   A],   A^   A`   Abr   Ad4   Ae   Ag   Aiz   Ak<   Al   An   Ap   ArD   At   Au   Aw   AyL   A{   A|   A~   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   AƤ   Af   A(   A   Aͬ   An   A0   A   AԴ   Av   A8   A   Aۼ   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A    Ah   A*   A   A   A	p   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   A J   A"   A#   A%   A'R   A)   A*   A,   A.Z   A0   A1   A3   A5b   A7$   A8   A:   A<j   A>,   A?   AA   ACr   AE4   AF   AH   AJz   AL<   AM   AO   AQ   ASD   AU   AV   AX   AZL   A\   A]   A_   AaT   Ac   Ad   Af   Ah\   Aj   Ak   Am   Aod   Aq&   Ar   At   Avl   Ax.   Ay   A{   A}t   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   Aņ   AH   A
   A   A̎   AP   A   A   AӖ   AX   A   A   Aڞ   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A
   A   A
   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A    A"   A$r   A&4   A'   A)   A+z   A-<   A.   A0   A2   A4D   A6   A7   A9   A;L   A=   A>   A@   ABT   AD   AE   AG   AI\   AK   AL   AN   APd   AR&   AS   AU   AWl   AY.   AZ   A\   A^t   A`6   Aa   Ac   Ae|   Ag>   Ai    Aj   Al   AnF   Ap   Aq   As   AuN   Aw   Ax   Az   A|V   A~   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A¦   Ah   A*   A   Aɮ   Ap   A2   A   Aж   Ax   A:   A   A׾   Aـ   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A ,   A   A   Ar   A4   A   A
   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A!   A#T   A%   A&   A(   A*\   A,   A-   A/   A1d   A3&   A4   A6   A8l   A:.   A;   A=   A?t   AA6   AB   AD   AF|   AH>   AJ    AK   AM   AOF   AQ   AR   AT   AVN   AX   AY   A[   A]V   A_   A`   Ab   Ad^   Af    Ag   Ai   Akf   Am(   An   Ap   Arn   At0   Au   Aw   Ayv   A{8   A|   A~   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   AȐ   AR   A   A   AϘ   AZ   A   A   A֠   Ab   A$   A   Aݨ   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A    A   AT   A   A   A	   A\   A
   A   A   Ad   A&   A   A   Al   A.   A   A   A t   A"6   A#   A%   A'|   A)>   A+    A,   A.   A0F   A2   A3   A5   A7N   A9   A:   A<   A>V   A@   AA   AC   AE^   AG    AH   AJ   ALf   AN(   AO   AQ   ASn   AU0   AV   AX   AZv   A\8   A]   A_   Aa~   Ac@   Ae   Af   Ah   AjH   Al
   Am   Ao   AqP   As   At   Av   AxX   Az   A{   A}   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   AŰ   Ar   A4   A   A̸   Az   A<   A   A   AՂ   AD   A   A   A܊   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A
>   A    A
   A   AF   A   A   A   AN   A   A   A   AV   A!   A"   A$   A&^   A(    A)   A+   A-f   A/(   A0   A2   A4n   A60   A7   A9   A;v   A=8   A>   A@   AB~   AD@   AF   AG   AI   AKH   AM
   AN   AP   ARP   AT   AU   AW   AYX   A[   A\   A^   A``   Ab"   Ac   Ae   Agh   Ai*   Aj   Al   Anp   Ap2   Aq   As   Aux   Aw:   Ax   Az   A|   A~B   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   AĒ   AT   A   A   A˚   A\   A   A   AҢ   Ad   A&   A   A٪   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   A V   A   A   A   A^   A	    A
   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A!   A#~   A%@   A'   A(   A*   A,H   A.
   A/   A1   A3P   A5   A6   A8   A:X   A<   A=   A?   AA`   AC"   AD   AF   AHh   AJ*   AK   AM   AOp   AQ2   AR   AT   AVx   AX:   AY   A[   A]   A_B   Aa   Ab   Ad   AfJ   Ah   Ai   Ak   AmR   Ao   Ap   Ar   AtZ   Av   Aw   Ay   A{b   A}$   A~   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   AȺ   A|   A>   A    A   Aф   AF   A   A   A،   AN   A   A   Aߔ   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A    A   A~   A@   A   A	   A   A
H   A
   A   A   AP   A   A   A   AX   A   A   A    A"`   A$"   A%   A'   A)h   A+*   A,   A.   A0p   A22   A3   A5   A7x   A9:   A:   A<   A>   A@B   AB   AC   AE   AGJ   AI   AJ   AL   ANR   AP   AQ   AS   AUZ   AW   AX   AZ   A\b   A^$   A_   Aa   Acj   Ae,   Af   Ah   Ajr   Al4   Am   Ao   Aqz   As<   At   Av   Ax   AzD   A|   A}   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   Aǜ   A^   A    A   AΤ   Af   A(   A   Aլ   An   A0   A   Aܴ   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   A
h   A*   A
   A   Ap   A2   A   A   Ax   A:   A   A   A   A!B   A#   A$   A&   A(J   A*   A+   A-   A/R   A1   A2   A4   A6Z   A8   A9   A;   A=b   A?$   A@   AB   ADj   AF,   AG   AI   AKr   AM4   AN   AP   ARz   AT<   AU   AW   AY   A[D   A]   A^   A`   AbL   Ad   Ae   Ag   AiT   Ak   Al   An   Ap\   Ar   As   Au   Awd   Ay&   Az   A|   A~l   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   Aļ   A~   A@   A   A   A͆   AH   A
   A   AԎ   AP   A   A   Aۖ   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A    AB   A   A   A   A	J   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A $   A!   A#   A%j   A',   A(   A*   A,r   A.4   A/   A1   A3z   A5<   A6   A8   A:   A<D   A>   A?   AA   ACL   AE   AF   AH   AJT   AL   AM   AO   AQ\   AS   AT   AV   AXd   AZ&   A[   A]   A_l   Aa.   Ab   Ad   Aft   Ah6   Ai   Ak   Am|   Ao>   Aq    Ar   At   AvF   Ax   Ay   A{   A}N   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A0   A   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   AÞ   A`   A"   A   Aʦ   Ah   A*   A   AѮ   Ap   A2   A   Aض   Ax   A:   A   A߾   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A	   A   A
r   A4   A   A   Az   A<   A   A   A   AD   A   A    A"   A$L   A&   A'   A)   A+T   A-   A.   A0   A2\   A4   A5   A7   A9d   A;&   A<   A>   A@l   AB.   AC   AE   AGt   AI6   AJ   AL   AN|   AP>   AR    AS   AU   AWF   AY   AZ   A\   A^N   A`   Aa   Ac   AeV   Ag   Ah   Aj   Al^   An    Ao   Aq   Asf   Au(   Av   Ax   Azn   A|0   A}   A   Av   A8   A   A   A~   A@   A   A   A   AH   A
   A   A   AP   A   A   A   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   AɈ   AJ   A   A   AА   AR   A   A   Aט   AZ   A   A   Aޠ   Ab   A$   A   A   Aj   A,   A   A   Ar   A   Az   A<   A   A   A   AD   A    A   A   AL   A   A   A
   AT   A   A   A   A\   A   A   A   Ad   A&   A   A   A!l   A#.   A$   A&   A(t   A*6   A+   A-   A/|   A1>   A3    A4   A6   A8F   A:   A;   A=   A?N   AA   AB   AD   AFV   AH   AI   AK   AM^   AO    AP   AR   ATf   AV(   AW   AY   A[n   A]0   A^   A`   Abv   Ad8   Ae   Ag   Ai~   Ak@   Am   An   Ap   ArH   At
   Au   Aw   AyP   A{   A|   A~   AX   A   A   A   A`   A"   A   A   Ah   A*   A   A   Ap   A2   A   A   Ax   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   Aƨ   Aj   A,   A   AͰ   Ar   A4   A   AԸ   Az   A<   A   A   A݂   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   A    Al   A.   A   A   A	t   A6   A   A   A|   A>   A    A   A   AF   A   A   A   A N   A"   A#   A%   A'V   A)   A*   A,   A.^   A0    A1   A3   A5f   A7(   A8   A:   A<n   A>0   A?   AA   ACv   AE8   AF   AH   AJ~   AL@   AN   AO   AQ   ASH   AU
   AV   AX   AZP   A\   A]   A_   AaX   Ac   Ad   Af   Ah`   Aj"   Ak   Am   Aoh   Aq*   Ar   At   Avp   Ax2   Ay   A{   A}x   A:   A   A   A   AB   A   A   A   AJ   A   A   A   AR   A   A   A   AZ   A   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   AŊ   AL   A   A   A̒   AT   A   A   AӚ   A\   A   A   Aڢ   Ad   A&   A   A   Al   A.   A   A   At   A6   A   A   A|   A>   A    A   A   AF   A   A   A   AN   A   A   A   AV   A
   A   A
   A^   A    A   A   Af   A(   A   A   An   A0   A    A"   A$v   A&8   A'   A)   A+~   A-@   A/   A0   A2   A4H   A6
   A7   A9   A;P   A=   A>   A@   ABX   AD   AE   AG   AI`   AK"   AL   AN   APh   AR*   AS   AU   AWp   AY2   AZ   A\   A^x   A`:   Aa   Ac   Ae   AgB   Ai   Aj   Al   AnJ   Ap   Aq   As   AuR   Aw   Ax   Az   A|Z   A~   A   A   Ab   A$   A   A   Aj   A,   A   A   Ar   A4   A   A   Az   A<   A   A   A   AD   A   A   A   AL   A   A   A   AT   A   A   A   A\   A   A   A   Ad   A&   A   Aª   Al   A.   A   Aɲ   At   A6   A   Aк   A|   A>   A    A   Aل   AF   A   A   A   AN   A   A   A   AV   A   A   A   A^   A    A   A   Af   A(   A   A   An   A  0   A    A    A v   A 8   A    A 
   A ~   A @   A    A    A    A H   A 
   A    A    A P   A    A    A !   A #X   A %   A &   A (   A *`   A ,"   A -   A /   A 1h   A 3*   A 4   A 6   A 8p   A :2   A ;   A =   A ?x   A A:   A B   A D   A F   A HB   A J   A K   A M   A OJ   A Q   A R   A T   A VR   A X   A Y   A [   A ]Z   A _   A `   A b   A db   A f$   A g   A i   A kj   A m,   A n   A p   A rr   A t4   A u   A w   A yz   A {<   A |   A ~   A    A D   A    A    A    A L   A    A    A    A T   A    A    A    A \   A    A    A    A d   A &   A    A    A l   A .   A    A    A t   A 6   A    A    A |   A >   A     A    A    A F   A    A    A    A N   A    A    A Ȕ   A V   A    A    A Ϝ   A ^   A     A    A ֤   A f   A (   A    A ݬ   A n   A 0   A    A    A v   A 8   A    A    A ~   A @   A    A    A    A H   A 
   A    A    A P   A    A!    A!   A!X   A!   A!   A!	   A!`   A!
"   A!   A!   A!h   A!*   A!   A!   A!p   A!2   A!   A!   A! x   A!":   A!#   A!%   A!'   A!)B   A!+   A!,   A!.   A!0J   A!2   A!3   A!5   A!7R   A!9   A!:   A!<   A!>Z   A!@   A!A   A!C   A!Eb   A!G$   A!H   A!J   A!Lj   A!N,   A!O   A!Q   A!Sr   A!U4   A!V   A!X   A!Zz   A!\<   A!]   A!_   A!a   A!cD   A!e   A!f   A!h   A!jL   A!l   A!m   A!o   A!qT   A!s   A!t   A!v   A!x\   A!z   A!{   A!}   A!d   A!&   A!   A!   A!l   A!.   A!   A!   A!t   A!6   A!   A!   A!|   A!>   A!    A!   A!   A!F   A!   A!   A!   A!N   A!   A!   A!   A!V   A!   A!   A!   A!^   A!    A!   A!   A!f   A!(   A!   A!   A!n   A!0   A!   A!Ŵ   A!v   A!8   A!   A!̼   A!~   A!@   A!   A!   A!Ն   A!H   A!
   A!   A!܎   A!P   A!   A!   A!   A!X   A!   A!   A!   A!`   A!"   A!   A!   A!h   A!*   A!   A!   A!p   A!2   A!   A!   A"x   A":   A"   A"   A"   A"
B   A"   A"
   A"   A"J   A"   A"   A"   A"R   A"   A"   A"   A"Z   A"!   A""   A"$   A"&b   A"($   A")   A"+   A"-j   A"/,   A"0   A"2   A"4r   A"64   A"7   A"9   A";z   A"=<   A">   A"@   A"B   A"DD   A"F   A"G   A"I   A"KL   A"M   A"N   A"P   A"RT   A"T   A"U   A"W   A"Y\   A"[   A"\   A"^   A"`d   A"b&   A"c   A"e   A"gl   A"i.   A"j   A"l   A"nt   A"p6   A"q   A"s   A"u|   A"w>   A"y    A"z   A"|   A"~F   A"   A"   A"   A"N   A"   A"   A"   A"V   A"   A"   A"   A"^   A"    A"   A"   A"f   A"(   A"   A"   A"n   A"0   A"   A"   A"v   A"8   A"   A"   A"~   A"@   A"   A"   A"   A"H   A"
   A"   A"   A"P   A"   A"   A"Ė   A"X   A"   A"   A"˞   A"`   A""   A"   A"Ҧ   A"h   A"*   A"   A"ٮ   A"p   A"2   A"   A"   A"x   A":   A"   A"   A"   A"B   A"   A"   A"   A"J   A"   A"   A"   A"R   A"   A"   A"   A# Z   A#   A#   A#   A#b   A#	$   A#
   A#   A#j   A#,   A#   A#   A#r   A#4   A#   A#   A#z   A#<   A#   A#!   A##   A#%D   A#'   A#(   A#*   A#,L   A#.   A#/   A#1   A#3T   A#5   A#6   A#8   A#:\   A#<   A#=   A#?   A#Ad   A#C&   A#D   A#F   A#Hl   A#J.   A#K   A#M   A#Ot   A#Q6   A#R   A#T   A#V|   A#X>   A#Z    A#[   A#]   A#_F   A#a   A#b   A#d   A#fN   A#h   A#i   A#k   A#mV   A#o   A#p   A#r   A#t^   A#v    A#w   A#y   A#{f   A#}(   A#~   A#   A#n   A#0   A#   A#   A#v   A#8   A#   A#   A#~   A#@   A#   A#   A#   A#H   A#
   A#   A#   A#P   A#   A#   A#   A#X   A#   A#   A#   A#`   A#"   A#   A#   A#h   A#*   A#   A#   A#p   A#2   A#   A#   A#x   A#:   A#   A#Ⱦ   A#ʀ   A#B   A#   A#   A#ш   A#J   A#   A#   A#ؐ   A#R   A#   A#   A#ߘ   A#Z   A#   A#   A#   A#b   A#$   A#   A#   A#j   A#,   A#   A#   A#r   A#4   A#   A#   A#z   A#<   A$    A$   A$   A$D   A$   A$	   A$   A$
L   A$   A$   A$   A$T   A$   A$   A$   A$\   A$   A$   A$    A$"d   A$$&   A$%   A$'   A$)l   A$+.   A$,   A$.   A$0t   A$26   A$3   A$5   A$7|   A$9>   A$;    A$<   A$>   A$@F   A$B   A$C   A$E   A$GN   A$I   A$J   A$L   A$NV   A$P   A$Q   A$S   A$U^   A$W    A$X   A$Z   A$\f   A$^(   A$_   A$a   A$cn   A$e0   A$f   A$h   A$jv   A$l8   A$m   A$o   A$q~   A$s@   A$u   A$v   A$x   A$zH   A$|
   A$}   A$   A$P   A$   A$   A$   A$X   A$   A$   A$   A$`   A$"   A$   A$   A$h   A$*   A$   A$   A$p   A$2   A$   A$   A$x   A$:   A$   A$   A$   A$B   A$   A$   A$   A$J   A$   A$   A$   A$R   A$   A$   A$   A$Z   A$   A$   A$Ǡ   A$b   A$$   A$   A$Ψ   A$j   A$,   A$   A$հ   A$r   A$4   A$   A$ܸ   A$z   A$<   A$   A$   A$   A$D   A$   A$   A$   A$L   A$   A$   A$   A$T   A$   A$   A$   A$\   A$   A$   A%   A%d   A%&   A%   A%   A%
l   A%.   A%
   A%   A%t   A%6   A%   A%   A%|   A%>   A%    A%   A%   A%!F   A%#   A%$   A%&   A%(N   A%*   A%+   A%-   A%/V   A%1   A%2   A%4   A%6^   A%8    A%9   A%;   A%=f   A%?(   A%@   A%B   A%Dn   A%F0   A%G   A%I   A%Kv   A%M8   A%N   A%P   A%R~   A%T@   A%V   A%W   A%Y   A%[H   A%]
   A%^   A%`   A%bP   A%d   A%e   A%g   A%iX   A%k   A%l   A%n   A%p`   A%r"   A%s   A%u   A%wh   A%y*   A%z   A%|   A%~p   A%2   A%   A%   A%x   A%:   A%   A%   A%   A%B   A%   A%   A%   A%J   A%   A%   A%   A%R   A%   A%   A%   A%Z   A%   A%   A%   A%b   A%$   A%   A%   A%j   A%,   A%   A%   A%r   A%4   A%   A%   A%z   A%<   A%   A%   A%Ƃ   A%D   A%   A%   A%͊   A%L   A%   A%   A%Ԓ   A%T   A%   A%   A%ۚ   A%\   A%   A%   A%   A%d   A%&   A%   A%   A%l   A%.   A%   A%   A%t   A%6   A%   A%   A%|   A%>   A%    A%   A&    A&F   A&   A&   A&   A&	N   A&   A&   A&   A&V   A&   A&   A&   A&^   A&    A&   A&   A&f   A& (   A&!   A&#   A&%n   A&'0   A&(   A&*   A&,v   A&.8   A&/   A&1   A&3~   A&5@   A&7   A&8   A&:   A&<H   A&>
   A&?   A&A   A&CP   A&E   A&F   A&H   A&JX   A&L   A&M   A&O   A&Q`   A&S"   A&T   A&V   A&Xh   A&Z*   A&[   A&]   A&_p   A&a2   A&b   A&d   A&fx   A&h:   A&i   A&k   A&m   A&oB   A&q   A&r   A&t   A&vJ   A&x   A&y   A&{   A&}R   A&   A&   A&   A&Z   A&   A&   A&   A&b   A&$   A&   A&   A&j   A&,   A&   A&   A&r   A&4   A&   A&   A&z   A&<   A&   A&   A&   A&D   A&   A&   A&   A&L   A&   A&   A&   A&T   A&   A&   A&   A&\   A&   A&   A&â   A&d   A&&   A&   A&ʪ   A&l   A&.   A&   A&Ѳ   A&t   A&6   A&   A&غ   A&|   A&>   A&    A&   A&   A&F   A&   A&   A&   A&N   A&   A&   A&   A&V   A&   A&   A&   A&^   A&    A&   A&   A&f   A'(   A'   A'   A'n   A'0   A'	   A'   A'
v   A'8   A'   A'   A'~   A'@   A'   A'   A'   A'H   A'
   A'    A'"   A'$P   A'&   A''   A')   A'+X   A'-   A'.   A'0   A'2`   A'4"   A'5   A'7   A'9h   A';*   A'<   A'>   A'@p   A'B2   A'C   A'E   A'Gx   A'I:   A'J   A'L   A'N   A'PB   A'R   A'S   A'U   A'WJ   A'Y   A'Z   A'\   A'^R   A'`   A'a   A'c   A'eZ   A'g   A'h   A'j   A'lb   A'n$   A'o   A'q   A'sj   A'u,   A'v   A'x   A'zr   A'|4   A'}   A'   A'z   A'<   A'   A'   A'   A'D   A'   A'   A'   A'L   A'   A'   A'   A'T   A'   A'   A'   A'\   A'   A'   A'   A'd   A'&   A'   A'   A'l   A'.   A'   A'   A't   A'6   A'   A'   A'|   A'>   A'    A'   A'   A'F   A'   A'   A'Ɍ   A'N   A'   A'   A'Д   A'V   A'   A'   A'ל   A'^   A'    A'   A'ޤ   A'f   A'(   A'   A'   A'n   A'0   A'   A'   A'v   A'8   A'   A'   A'~   A'@   A'   A'   A'   A'H   A( 
   A(   A(   A(P   A(   A(   A(
   A(X   A(   A(   A(   A(`   A("   A(   A(   A(h   A(*   A(   A(   A(!p   A(#2   A($   A(&   A((x   A(*:   A(+   A(-   A(/   A(1B   A(3   A(4   A(6   A(8J   A(:   A(;   A(=   A(?R   A(A   A(B   A(D   A(FZ   A(H   A(I   A(K   A(Mb   A(O$   A(P   A(R   A(Tj   A(V,   A(W   A(Y   A([r   A(]4   A(^   A(`   A(bz   A(d<   A(e   A(g   A(i   A(kD   A(m   A(n   A(p   A(rL   A(t   A(u   A(w   A(yT   A({   A(|   A(~   A(\   A(   A(   A(   A(d   A(&   A(   A(   A(l   A(.   A(   A(   A(t   A(6   A(   A(   A(|   A(>   A(    A(   A(   A(F   A(   A(   A(   A(N   A(   A(   A(   A(V   A(   A(   A(   A(^   A(    A(   A(   A(f   A((   A(   A(Ƭ   A(n   A(0   A(   A(ʹ   A(v   A(8   A(   A(Լ   A(~   A(@   A(   A(   A(݆   A(H   A(
   A(   A(   A(P   A(   A(   A(   A(X   A(   A(   A(   A(`   A("   A(   A(   A(h   A(*   A(   A)    A)p   A)2   A)   A)   A)	x   A):   A)   A)   A)   A)B   A)   A)   A)   A)J   A)   A)   A)   A) R   A)"   A)#   A)%   A)'Z   A))   A)*   A),   A).b   A)0$   A)1   A)3   A)5j   A)7,   A)8   A):   A)<r   A)>4   A)?   A)A   A)Cz   A)E<   A)F   A)H   A)J   A)LD   A)N   A)O   A)Q   A)SL   A)U   A)V   A)X   A)ZT   A)\   A)]   A)_   A)a\   A)c   A)d   A)f   A)hd   A)j&   A)k   A)m   A)ol   A)q.   A)r   A)t   A)vt   A)x6   A)y   A){   A)}|   A)>   A)    A)   A)   A)F   A)   A)   A)   A)N   A)   A)   A)   A)V   A)   A)   A)   A)^   A)    A)   A)   A)f   A)(   A)   A)   A)n   A)0   A)   A)   A)v   A)8   A)   A)   A)~   A)@   A)   A)   A)   A)H   A)
   A)   A)Ŏ   A)P   A)   A)   A)̖   A)X   A)   A)   A)Ӟ   A)`   A)"   A)   A)ڦ   A)h   A)*   A)   A)   A)p   A)2   A)   A)   A)x   A):   A)   A)   A)   A)B   A)   A)   A)   A)J   A)   A)   A)   A*R   A*   A*   A*   A*Z   A*
   A*   A*
   A*b   A*$   A*   A*   A*j   A*,   A*   A*   A*r   A*4   A*    A*"   A*$z   A*&<   A*'   A*)   A*+   A*-D   A*/   A*0   A*2   A*4L   A*6   A*7   A*9   A*;T   A*=   A*>   A*@   A*B\   A*D   A*E   A*G   A*Id   A*K&   A*L   A*N   A*Pl   A*R.   A*S   A*U   A*Wt   A*Y6   A*Z   A*\   A*^|   A*`>   A*b    A*c   A*e   A*gF   A*i   A*j   A*l   A*nN   A*p   A*q   A*s   A*uV   A*w   A*x   A*z   A*|^   A*~    A*   A*   A*f   A*(   A*   A*   A*n   A*0   A*   A*   A*v   A*8   A*   A*   A*~   A*@   A*   A*   A*   A*H   A*
   A*   A*   A*P   A*   A*   A*   A*X   A*   A*   A*   A*`   A*"   A*   A*   A*h   A**   A*   A*®   A*p   A*2   A*   A*ɶ   A*x   A*:   A*   A*о   A*Ҁ   A*B   A*   A*   A*و   A*J   A*   A*   A*   A*R   A*   A*   A*   A*Z   A*   A*   A*   A*b   A*$   A*   A*   A*j   A*,   A*   A*   A*r   A+ 4   A+   A+   A+z   A+<   A+   A+
   A+   A+D   A+   A+   A+   A+L   A+   A+   A+   A+T   A+   A+   A+!   A+#\   A+%   A+&   A+(   A+*d   A+,&   A+-   A+/   A+1l   A+3.   A+4   A+6   A+8t   A+:6   A+;   A+=   A+?|   A+A>   A+C    A+D   A+F   A+HF   A+J   A+K   A+M   A+ON   A+Q   A+R   A+T   A+VV   A+X   A+Y   A+[   A+]^   A+_    A+`   A+b   A+df   A+f(   A+g   A+i   A+kn   A+m0   A+n   A+p   A+rv   A+t8   A+u   A+w   A+y~   A+{@   A+}   A+~   A+   A+H   A+
   A+   A+   A+P   A+   A+   A+   A+X   A+   A+   A+   A+`   A+"   A+   A+   A+h   A+*   A+   A+   A+p   A+2   A+   A+   A+x   A+:   A+   A+   A+   A+B   A+   A+   A+   A+J   A+   A+   A+   A+R   A+   A+   A+Ș   A+Z   A+   A+   A+Ϡ   A+b   A+$   A+   A+֨   A+j   A+,   A+   A+ݰ   A+r   A+4   A+   A+   A+z   A+<   A+   A+   A+   A+D   A+   A+   A+   A+L   A+   A+   A+   A+T   A+   A,    A,   A,\   A,   A,   A,	   A,d   A,
&   A,   A,   A,l   A,.   A,   A,   A,t   A,6   A,   A,   A, |   A,">   A,$    A,%   A,'   A,)F   A,+   A,,   A,.   A,0N   A,2   A,3   A,5   A,7V   A,9   A,:   A,<   A,>^   A,@    A,A   A,C   A,Ef   A,G(   A,H   A,J   A,Ln   A,N0   A,O   A,Q   A,Sv   A,U8   A,V   A,X   A,Z~   A,\@   A,^   A,_   A,a   A,cH   A,e
   A,f   A,h   A,jP   A,l   A,m   A,o   A,qX   A,s   A,t   A,v   A,x`   A,z"   A,{   A,}   A,h   A,*   A,   A,   A,p   A,2   A,   A,   A,x   A,:   A,   A,   A,   A,B   A,   A,   A,   A,J   A,   A,   A,   A,R   A,   A,   A,   A,Z   A,   A,   A,   A,b   A,$   A,   A,   A,j   A,,   A,   A,   A,r   A,4   A,   A,Ÿ   A,z   A,<   A,   A,   A,΂   A,D   A,   A,   A,Պ   A,L   A,   A,   A,ܒ   A,T   A,   A,   A,   A,\   A,   A,   A,   A,d   A,&   A,   A,   A,l   A,.   A,   A,   A,t   A,6   A,   A,   A-|   A->   A-    A-   A-   A-
F   A-   A-
   A-   A-N   A-   A-   A-   A-V   A-   A-   A-   A-^   A-!    A-"   A-$   A-&f   A-((   A-)   A-+   A--n   A-/0   A-0   A-2   A-4v   A-68   A-7   A-9   A-;~   A-=@   A-?   A-@   A-B   A-DH   A-F
   A-G   A-I   A-KP   A-M   A-N   A-P   A-RX   A-T   A-U   A-W   A-Y`   A-["   A-\   A-^   A-`h   A-b*   A-c   A-e   A-gp   A-i2   A-j   A-l   A-nx   AQAAGAŮA(A  AŮAA{AŮAzAʸRAA=qAɅAʏ\Aʏ\AAGAA  A˅AˮA˙AGA(AffA(ẠAQA=qAAAA  A\)A
A(A\)Aȏ\AHAȏ\AHAA\)AřAƏ\AŮA=qAȏ\A=qA{AǙA(A{AəAAAffAAHAʸRA33A  A(AzAHA{A\)AzAffA  AA̸RA\)Aʏ\AɅA33AɮAȏ\A33A33A\)AA\)A33Aď\A(AîA(A{ARA¸RAřA(A=qAǮAƸRAA  A=qA{A=qA=qA=qAffA{A˙A{Ȁ\AAffA\)AffAʏ\AA33A
AAͮẠAHAA͙A
AͮAˮAAƣAAAɮA=qAffA
=A\)AA\)AɅAǅAǙA33AȸRAəA=qAffAffAʸRA{AɅA
AɮA33AGAȏ\AGAA
A=qA{Aʏ\AApApA˙AˮA=qA(AAQAQA  AəAAȣAHAHApA\)A{AffA\)AɅAHA˅AʣAAQA£AîA33AAřA\)A=qAzA(AAGAǮApAAAȸRA{AAȏ\AɅAA
=AAHA  AʣAQA{ApA  AAAHA
=A(AɮAQA
=A33AǮAAȣA=qA
=A(AǮAřAʏ\ApAAHAɮA
=A
ApAGA
=AʸRAzAHAA
=AAGAʏ\AʸRApAʸRAApA=qȀ\AAAAAAAAȸRA
AHA=qAƏ\A
AȸRAAQA{A
=AGA(A
=AɮA{A
=AAAAA33AθRAzApA{AA\)AA33AAͅA33AHA\)A
=A˅AffA˅AffA(AA(AʸRAAʣAA33A=qA  AQA{AA
=AGAffA
A
AHAřAQA  AA{A=qAffAzAffAA=qAHAAA{A
AAHA
A
=AGA\)AHAɮA33AɮAffApApAɅA
AǙA  AA{AȸRAzA  A(AQAɮAffAGAģApAQAA\AQAģA(AQApAȏ\A  AAəApAȏ\AGA=qApAɮA33AȸRAffAzA=qA{AǮAǙA  A
AǙAHAAzA˅AQAͅẠAAffA˙A  Aʏ\AHA33AHA33AffAQA{AQA{A(A  A  AɮAHA\)A̸RA͙AAʏ\AffAffA̸RAA{A  A(A(A{A
=A(AAʏ\AGA\)AAGA\)AȣA(AffAA=qAApAA{AGAAA{AAzApAzAzA
AƣAAƏ\AȣAHAzAHAA
=AAŮA  A(AǮAA
A
AəAȣAȣAȏ\AA(A\)A
AǅAAGAGApA\)AAǅAA  AǙAAAGAǙAƸRAA  A  AģApA
AA\)AAAAffAGA(AGA\)AHAǮAAǅAAǮAQAffA{AǅAǙA
=AAGAffA(A(AA=qAffA(A
=AəAA  A33A
=A33AŮA\)AA
=A
AffApAAAA\)ApA=qAAřAAHAĸRAAģA
ApAAGAAzA33AǅA  AGAǮAǮAǅAǅAA(A=qAGAƏ\AA
=AAƏ\AƸRAAHAA
=AzAƸRAApAHAQA=qA  AAzAAGA  A
=AAHA
AAď\A=qApAƣA
ApA  A  AɮAGAȏ\A=qAǙAƸRAǮAAGAA\)AAffAƸRAffAƣAƸRAffAzAAA(A\)AGAƏ\AffA
=AAAřAA
A=qA
A
=AŮA  AřA33AŅAGAA(A(AƸRAA
=AA\)AGApAǙAAǅA33AAAƸRA=qAffAƸRAƸRAQAGAHA{AAAGA
=AĸRA=qAĸRA(A{A(A(A  AîA=qAA=qA{A
A=qAGAAzA  AHAffAA{AŮA=qAffAApA\)AģAA
=AApAƸRAƏ\AƏ\AAƏ\AzA
=AǅApAAA(AHA=qA33AƣAǙAAǙA{AȸRAȏ\A¸RAîA  AƏ\AƸRAîA
AAřAA\)Aȏ\ApAffAA˅A˅A=qAHA=qA
=A33AAȣAzA˅A\)AAGAQA\)AA33AȸRAHAzA  AAA  AQA{A\)AǅAǙA  A(AƏ\AQAQAGAAffA  AȣAffAƸRA  ApApA(A=qAƸRAAHAǮA  A
AzA=qAHApAA\)ApA33A33AAAffA{AAA
=AA(AƣAApA33AAŮAHA\)AffAHAA{AAĸRA  AAGAAQA(A\)A  A33AȸRAGAɅA\)AHA
=AȸRA{AǙAzA  AAHAAǅAǮA
AAffAQA(A=qAzAǅAƸRA
=AAřAģAŅA\)AA
=AŮA  Aď\AƏ\A  AȸRA33AǙAHAǙAQA
=ApAA  A  A
AAɮAAQAAA=qAA  A{A
AAGAGA{AǙAAƣA=qAƣAzAzAƏ\A(A(AƸRA(AffAģAA\)A\)AHApA
AffAAA
A  AHAAǮA{AzAȏ\AȸRAzAȏ\AQA{A  AǙAǅAzA  A{AA\)A\)AffA
=AƣAzA  ApA33Aď\AAHAĸRAA{AAzAŮA(AGA\)AAffApA=qAď\AŮA  AƸRA33A
AƣA33AǮAAffAQA(A  A  A  AǅAƣAAzAA{A{AGAHAzAƣA(AGAƣAGA
=AĸRA
=Aď\AQAAA(AĸRA=qAffA
AÙAffA(AA=qA  AAA\)AǅAƣAřAŮA  A{A
AAffA33AǮAǮAǙAǮA
AzAAAffAAAHAGA33AzAffA  A33AHAHAď\AŮA  AģAÙA33A£A
=AAGAÙAîA
A\)ARAAAzA  AAA  A\)AîA(AA\)A\)AĸRA  AAzAÙAHAģAď\AHAAA
AÅAGAAAAApA
=AAGAA  AQAA\)AÙAîAHAA¸RA\)A\)A=qAA
=AÅAA(A
=AQA£A
=AzAď\AA=qAAƸRA
=A  AA33AAƣAzAA(AffAQAAřA
A(A{AAŅA\)AA
=AffAAffAffA=qAffAffAA\)AAQAAzAď\AAHApAĸRAA{AAŅAffA
=AÅA\)AÅA¸RAGAzAAGA¸RAď\ApAHAAffA{AÅA
AA{AQAĸRAřAA33A\A\)AA=qAÙA\)AffA
=AffApAffAAzAzAAA33AÙAAHA33ApA
AAffAAÙA\)AAA£AAHAffAÅAģA
=A\)AAŅAƏ\A
=A33AAƸRAƸRAƏ\AHAƣAffA  AģAzAģAzA
=ApAAAGA  AzA  AzA33A\AAAÅA{A{Aď\AGAŮA
=AÅA\)AAA=qA\)AQAƏ\AƏ\AQAHA
=A  ApAď\A\)AģA\)A
=AAAzA  A  A=qAď\A(AAGA(AAŮAApAzAHApA¸RAÙAŅAŅA=qAHAŅA  A33Aȏ\AȸRAAřAGApAQAHAHAHAAŅAAAHAAHA\A{A33A(ARAHA\)A(A=qAQAA
A\)ARAA
=AAAA33AffA(AQAAGA\)A{A\)AAffAAÙAîAApA
=AAAzApAAAzARAAA¸RA{AffAA{AzA£A(AzA  A\A
A
A=qAAffA\)A£AA\AÙApA=qAA33A=qAHARApA\)AAA{A{A
=A33AQAQA\AzAAA(AHApA=qAzA
A33A
=AA\AGAffA{AffAřAGA\)AHA£AA\)AzAA{AzAffAGA{A
A
=AApA
AA
=A
=AŮAAA
=A(A  AQAGA
A{AAŮAzA
AÙA
A(AAÙAîAHAAģAAGAA  A  AHA
AAffAAAA
AHA{AA  A33A
AƸRAQAŮAƣA33AAAǅA33A(AəA
A\)A{AHA{A  A  AzAȸRA33AAHAAAffA(A=qAAǙA33AAA
=AAHA=qA\)AffAHAAzA
AƸRAA{AApAA  A˅AffAɮAʸRAA(Ȁ\A̸RAffA{A˅AʸRAA
AQAA(AQA{AAAʸRAA\)AGAHAʏ\A
=AʸRAʏ\AɮA(A\)AApAɮA\)AGAǅAAGAGAAAffAAəA33A(AAƏ\AGA33AHA
=AGAA
A
=AAGApApAGAȏ\Aȏ\A33AAəA{A{AApA33AʸRAȣA(AGAˮAA{AAAˮAǅA
=AGAQAA\)A
=AǙAGAHAAGAA{AÅA
AApAzAAƸRA(AƏ\AffAApAŮAŅAGAAĸRAîAHAģA33A{A=qAQA(A=qAQAƏ\A
=AzAƏ\A=qA\AAď\AAřAŅA=qA
AģA£ApA33AA
AAAzA
=A33AA  AQA
=AGA=qAA
AQA{AGAǮAǮAƸRAŅA  AAHA
AĸRAHAAAHAzAHA
ApAffAHA  AA=qA\AffA
A\AAď\AA  AHAƸRAAAffAƏ\AƣApAGAApAzA(AA  AAŅAǅAǙAHA\)AzA33AřAŮAƏ\A(AAAƸRAģAAHA¸RAQA{A¸RA
=AřAÙAîAAƏ\A=qAA(AŅA
=AffAď\AAÅAHAÅA33ApAffAA{A{AÙAAQAAHAAAzA¸RAQAHAffAffA\A\A¸RA£A  AA(AA=qAA  A33AAA
AzAA  AAGAAffAzAA\)AAA\AA33A{A(A(A  AARA(ARAGAAHAA(A=qARAAAA(A\)AAA\AffA
=AAAHAAAA33A
A\)AA\AAAA  A
ApA
AzAGA{AQAGARAAAzA\)A
AA(A33A\A  A(A
AGAzAAHAA
AA  AffAAA=qA\AA  AGA=qA(A  A
=AHAA33AffAAGAHApAAA(A(AA
=A
A=qA\A\A\AAA=qA  A(A  ARA(A\A\A{AA=qAA33AA33ARAGAQAAAA
=AAAAAzApA{AffARAzAAA(AAHAA\)AAAA\AA
AA  A{AA\A{AGAAffAAHA{AQA(AAGAzA{AARAHA\A\A
ARA(A  A  ARApA=qA\AHA(AAAAQAGA(A=qApAA
AGA\A\)AAAAHAAAAHA\)AffAzAAffAA(A
=A=qAGA\)A  A
=AA=qAQAA=qAA\)A  A{AAA(A\)AAAA{AzAA\AAAzA{AA
=ARAA\)AA(A(AGAAHAHAffAffARAA  ARAffA\A\)A\)AAAAHA\AAA\ApAzAffAzAAA
=A\AAQAAAQAHApAA
=AA\)AA\)AGA{AAAA\A  AA
AffA\ApAAA  A=qA33AA(AffA
AA
AA
A  AAA33AAA
=AARA  A\AGA{AAAHApARAzAA33AffAA
=A
A\)A=qAAGAA\)A(A
AA33A
A
ApAA\A  AzA=qA\)AAGAAHAffAAARAAA
=A{AA33ARAA=qA
=A{AHA\)AGA
=ARAAA33AQAQAAQAQAGA33AffAA=qA=qAGA=qAzAA\)ARAzA(ARAA
A  A33A\)AAA{A\AffAApAAAHA33AA
AGA  A  AHAA{AA33A\)AffAHA=qAffA\AA\)A
=AffA  AQA
AA33A
AAA(AAffApA
ARAAApA\ApAAAA\)AAAffAAGAGARAApApAA\)AAA  AAA{ARAAAA\AA33AAHAQAAAAzAAffAAA33A{A  AA
=AA=qAffA\)A
AA(A(A
=AAA=qAA
=AAffA\)AAzA  AHARAAzApA=qAffApARARA
A(A33A=qA\)A  AAAAAHAA
=AAAApA\AAffA
ApAARAAzA\A33A(AffAffAAQAA\)AHA(ApA
AA  AzA  AAAffA
=A
=AAA\)AAQA\)ARA{AH@ffAAA  AA33A	A
=A	ARAQAzAGARARAHA
AAffA{AGA(AffAAAAHAA	GA(AAGA zAA33AA(AGAffAAHA(@  A(A
pAAA=qApAA  AHAGA\AffAAAA(AAGA(ApAffA  A\A
A  AHAAQAA
AA  ApAzAQARAAGAQAHA33A
=AzApAARA  A\A\)AQAAA\A33AQA33ARAQA\)AHAA33AffA
AAffA  AQARAApAzA
=AzAQAAA\A\A
AAA=qAGAA(AAffA
A\AA\)AApAAHAQA=qAHA
=AffAffAAAA\A{AA
AAA=qA  A(AA\)A  AAApAzAA  AzA  A\)A\A{ARAAA=qA=qA\AA(A\AQAzAQA
=AHAAffAA{AHApApA
A{AAGAGAA(AHAAQA\AApA\)A  AAA\AAA\)AAA  AQA
=AQA
ARA(AAGAAAApAQAAAffAAA  AAHA{A
AA33A(ApAA33AAA\)A\AA{A\ApAAAQA{A  A
A33AAffA\AAHA33AA\AAAGAAA33AA(ARA33AAA  AGAQAA=qAHAQAA(AGAAffAAAA\A=qA=qApAA\A
AA
A33AHAQA  AQA
ApA\A\)A
A
=AA=qA\)AQA\AAHAA(A(AA(AGAAA
=A(AAAA\)ARAAHA(AffA\)AQA=qAA
AA\)A
A
A=qA33AGAAGAAAAA33AffAGA(AA\AffA\AAAHAARA{A{AAA(A33AAQA{AGAAQAHA33AAAQApAHA
ApA
=A\AffAAAHApA(A=qAAAAzAA  A
=AzA(A(AffA{AA(AA=qA  AAAA  AA=qA\)AHApAAA{A
=AA33AA=qAA
AHA{AA  AHA
AA{A(A
A\AAA{AA  AA=qA  AA{ARAA\A  A{AAAAAA(ARARA(AARA\AA\)A  A{AffA
AA(AAHAA=qARA=qA(A=qAAApAGA=qA\)AA
=AHAzAzA\AA{ApAA\AARAAAGApAGARA(A
A=qA33AA\)AHAffAAAA\A
AHAQAAAAffA\)AzA  AAGAQAARA  AGA33A\A\)A(ApA\)AGARAA  AffAA
=A  A  ApARAA
=ARA  A\A
=A=qA(AAAA{ApAHA  AAA  AA\)AA=qA(AHAAzAA\A
AAAA
=AffAQA=qAA\)A=qAffAAAAzAQAQAffAffAApAffA
A\)AA{A
ARAA
AARAAA(A=qA\)ApAQAQAAQA{AAQA(AGAHA\A=qARAAAA
ARARApAGA{ARA(AAAzARA
A(AQAAA
=AÙAHA=qAApAffAQAAzAGA\AA\AA33A
AQAA=qApAAAQA33AA
=AffAARAA(ApAGAzAzAHARA
AHAzAAGA  A33AA(AAA
AGA\AAARAARA\)A(AGAAAA=qAffAAA
AAAAffAA33AAA  AHAzAAHAGA
=AA33AA\AQAffAQAAA
AAAApARA
AGA
=AHAAffAA
A33A(AÙA
A
A\ARA
AQAGA\AA\AzAAHA=qA=qA  AA=qARAAA\)AQA{A£AAffA
A=qA\)A\)A£AAGA=qAzAAGA\A33AA\AHA  A{Aď\A\)AAAAAApAApA(A\AAA
=ApAA\AAAAAA33A\)AHA  AzA(A  A=qAAARAGAAAA=qA(AffAGA
=A
A\)A\ARAHAAzAA  A\)AGA
=A  AAAA\)AAHAHAAAAGA33ApAAARAAQA(A{ARAffARA=qA(AApApApAAA\)A\)AffAzA  A33AA  AAffAAQAA
A
=A(ApAGAHA
=AAAGAGA(A  AAAAAGAGA33AApAA  AHAGA33AARA(A  AzAAAAģA  AA
AAģAĸRAřApAQAA
=AGAAQAA  A(AA¸RA\)AAAîA  AģA=qA=qA
=AHA  A=qAA33AAGA(A(AQA33AGAAģAAA
AA
AA
AGAÙA{A
=ApA33A
=A  AÅAA33A33AQA
A
=AAŅAď\A
AA(AA  AAĸRA
A{AAAA
A33AGAQAǮAȏ\ApA  AffAAffAffAQAA=qAQAAʸRAˮAˮAAɅAəAzA  A  AffAʸRA\)ApA=qAA{A\)ApAǮA  A{A(AAQAAGA  AɮAAHAAHA=qA  AA
A
=A{AͅAzAͮA
AȣApAAȸRAAΏ\AAGAGAA{AAˮAɮAzA=qA˅AQA̸RAzAAAHAAȏ\A(Aʏ\A
ApA˙A
=AɮAʣAffA
A  A  AGAQA
=A\)AzApA33AQAΣAϙAzAHAGAGA
=AΣAffAA  A  AAAAAAGAA=qȀ\A=qAGAAA33ApAAˮAģAAŮA(AAAA(A  AHAǙAȸRApAA
=A\)AGAA˙AGA
=Ȁ\A=qAzAzAˮAQAffAȏ\AɮA=qAˮA33AQA
AɅAAA
=AˮAAApA  AzA\)AɮA\)AɮAAȣAȣAAƸRA(AƸRA{AɅAAAQAʣAHAAHAffAffAɅA
=AɅAA  A
=A{A
ApA
A33AAɮA=qAȸRA\)AəA\)A\)A\)ApAAHAəA33A
AHA
A\AAAA
AģA=qAGA(A=qAAÅA
AffA(A  Aȏ\AɮAɮAHAQA\)AQAAQA(AzA=qAǙA=qA
AǅApAAAřA=qA=qA{AffA  AA=qAģA(A\)A  AA
=AA¸RApAĸRAAÅAGAA=qAGAAAGA\)AŅAŅA\)A  A=qAGA  AA(AAHA33A(AAzA\)AAAAHAzAzAƸRA\)AHAA\)ApAA\A  AAA\)AAAAAĸRAGAƣAƸRAAQAɅAAA\)ApA33A{A̸RAA\)AHAAzAAAAA
A
AAGA(A\)A
A33AAzAQAŮA{AGAƏ\AzAA
=A33AGAřAffAHA  AÅAAAQAĸRAA\)AŅA=qA
AAARA33A£AGAřA33A
=AQA
AAAĸRAřAAzAQA
A33AARA\)AApA(AQAffAGAAA{AA\)AHAAGAHA{A(A{A(A\A\)AAAAAHA  A
A  A
AGAřAƸRAffAQA=qAģA
=AĸRAGAA{A
=AŅA\)A
=AAģA33A£ApAÅAQAAAHA
AAzAQAA  A(A  A\)A{A{AHAĸRAřA\)A
A33A(AffAǙAȣA\)AA(AffA
A=qAzAA{Aȏ\A(AQA  AAGAAAřAA33AAHAGA\A¸RA(AAAAAA33AzA
AA(A
A33AAď\A=qAÙAA{ApAA=qA(A33AŅAď\AîAGAîApA33AAQAA33AîA=qAîA{AzAGAGA(AA  AHA33AA
AA33A  AAAzAGAffA\)AGApAHAA\AQAAAAA  A\AHA33AAApA(AÙA£AģAÅAApApAHAÅAAApAQA{A(AzA{AAzA(ARA\A  AAzAHA=qA\)AApAffA\AHAAA
=A
=A
AA=qAAHAAAQAA{A=qA(A  A=qAzA33AÙAA\AÙAÙAAGApA
=A
=A
AA=qA  AQA\)AAAGA
=AHAA=qAA=qAAzAAA(A=qA  AHAAGA{A{AAAffA  AffA\A
=ApA\)AÙAÅA\)A
=AHAAffA£A33AA33A\)AAA{AQA(AGAHA
=AAAAAA{AA(AffAQApAAHA{AAAA=qAAÙAAģAA33A33AzAģA{AGAA33AAffA(AĸRA(A  AîApAGA
=AAÅA{A(A=qAA  A33A33AHAHA  AAAAA  A
AHA\AzA
AA=qA
AAGAƣAAAQAAffAQAÅA£AA\)ApAAGAHAQA¸RA¸RA(ApAQAAffARA¸RAzA\)AAA\)A{AAHAAAAAAffApAAA(AzA¸RA
A33AřA  A=qA=qAGA
=AAÙAHApAÙA
=A33A33AA
=AGAGAAQA(AQAAzA£AAAHAA(AffAAA=qAAzA{AHApA
AAApAAzAA
AAÅA  A
A  AAQAA
AAÙA(AzAģAA
A{AA\)A(A{A
ApAĸRAřA  AHAAA33AAģA=qAApA  A
A=qA\)A33AA\)A\AA
AQAÅAQAA\)A
AřApAA
=A=qAÙAARAffAřAAAzAA
ApAAAzA
AAA
A
=A33A  AA=qAAHAAAGA\A(A
AAGA\AAGARAffAAzAAzAA=qAffAA(AGAAA\)A
A
AAQAzAAAA{A\)AQA¸RA  A  AzAA\)AA\)ARAffA(A=qAAGAA=qAAAAAQAffAzAAAGAQAAGA\)AzAzAAA(A
=ApAAHA
AGA  AAAHAARAAffAffARAAAA\AQAA  AA(A  AHARAARA  AzA\AGAAARAffA
A\)AAGA  AAA(ARAAAAAAzAA{ARAAAAAzAQA\)ARAAAApARAAAAffARAffApA(AHARA33AAAA(AGAHAQA33ARAHAAA  AHA\AApAHA33AAA\AAQAQAARA  A=qAAApAAGAzApAAHA\)ARAAAAARApARA{A=qAAA
=AA  AA
AGA=qAîA{A
=A{ApA(A{A{AApAHA33AA(AA(AAzAĸRA  AQA33AƣAzA
AřAď\Aď\Aď\Aď\AzA(AA33AAA\)A¸RAAQA=qA33AA(A{A£AA  ApA¸RAAQAHAAAA
=AQAA=qA=qApA\A\AA=qAA  AAA  A  AQApA{AAzARA\AA
=AAAA33A
=AHAAzAApA\AzAzAffA  AAA{A{AAAARAffApA\ARAQA
AzAApAzAARA
AA\)AAGAAÅA(A=qAǮAǮA
AGAA33A˙A33AGAȏ\AƸRAȣAď\AǙA
AƏ\AzAǅAƏ\AffAƏ\AƏ\AffA  AA\)AAQAAAAAĸRAA\)AA(A{AÅAA=qAGApAAǙA  AQAȣAHAAAȸRAzAȣA  A{A(AAffAApA=qA
=AȣAHAGAA{AǮA
=AHAA{A(A(AŅA  A33AÅAffA
=AîA
=A33AAA  ApAAzA(AģAǙAHA=qAAƏ\A
Aȏ\Aȏ\A  AAA  AzAƸRAAA
=AƸRAA33AƣA\)A{AQAzAAffApAAAHA
A  A
=ApAAGA33AffA=qApAAAAHA
=AzAAffAǮAɮA
AHAɅAA
A(AffA{A(A
A
=A  AQA  AA˙AGAʸRAʏ\AGAHA\)A33AȣAzAȸRAHAffA=qA33A(AǮAǮAƏ\AǅA33AƏ\AAȣAAHAA{AffA\)AHA33A33ApApAɮAzA{A
=AGA33AAGA\)ApAəAɮApAəA\)AA{A
=A33AGApA
=A33AA
=A=qAȣA{AAǮAAzA(A
Aȏ\AɅA33AAQAAffA
=A\)AHA=qApAAAzAAHAɮAffAʏ\AʸRAffA
A˙AffA33AAGA33A
AAGA=qA(A=qA  AA
A˙AˮA˙AʣA\)ApAAApAʸRA{AəAAAȣA  AAA33A  Aʏ\A
=AGAAHA=qAGAzA33AA  A˙Aʏ\AA\)AHAAͅA33A̸RApA\)AGAffAA
AˮA
=AʸRAʣAA33AGA˅AffA  AŅAˮAA(AʸRAHAffAˮA33ApApAzA(AẠA=qA  AA{A{AzA̸RAA̸RAˮA  AzȀ\A{A  AAQA{A=qAffA{AA
AA=qAˮAʏ\AAA
AffAA
=A\)AAˮA  A{AʣApA
=AAǙAHAʣAQAˮApAHAAAAϙA
=AυAθRAHA{AͮA{AffAffAQAffAAQA
ApApA
AApA
AAzAA˅A{A{ApAA˙AǅAAzAHA
=AͮA
=AAQAQAΣAHAϙA
AGA(A=qA  A˅AAzAǙAzAAGAffAAAƏ\AřAAA\)AHAƣA  A
AzAQAGAQA{ApA\)A  A33AƏ\ApA=qAA  A(AɅAffAHA
AA  AffAAzAǮA
A  ApA=qAA(AA
AHA
AAȸRAzAAAffA  A(AA{A33AAApAAŮA
=A=qA(AA\AĸRAA  AQA  ApA\)A  AHApAŮA33AHAffAʸRA˙A
A
A(A˙AAAˮApAˮAGAHA  A˙AzA˅AHA(A(AQAʣAAA
=AQA\)A
AGAAA
=A
A{AƸRA(AǮAQAAHAɮA=qA33AAƸRAffAɮAGAAͮAAͅA  A\)A
=AǅA  A
A
A{AAGA
AǙA\)AGAA(AQA{AŮA(A
AA
=AGApAÙAAAAHAzAGAA(A  AQAHAAAGAÙAģAŮAA{A  A
=ApAAA33AϮAAGAHA\)A  AA\)AAǅA
AǮA  AAA
=AřAŅAzAGAQAď\AffA{AA\)Aď\A=qAA
A(AA  AAĸRAffA33AHA\)AGAA33AA
AA(AAzAA=qAA(AzAffA{ARAzA\A£A(AffA{AHA{A{AA(A(AAA\AA33AAQA
AHAAAHAAAAA\AQAQA
AAHAffApAApAŮAřAA
=AAffAĸRAA  A33AA
=AÅAHA=qARA=qAA
=ApA
A\)AÅAA33AAAAffARARA\)A£AA  AQA\)A{AA(AAffAAffApAffAɅA˅A{AAɅA=qAAAAÙAǅAƣApA  AffAffAȣAƸRA(AzAGAGAĸRA=qAHA\)AAřA=qA\)Aď\AffAAřA\)ApAîA
=A(ApA\AA\)A
Aď\AAǅA33AĸRAŅA{AffAȸRAȣAřAAA
=A
AƏ\A  A\)AAffA
AŅA\)A
A
=A
=AQApAɅAHAAQAffA(AAzA
=A  A\A
=A=qAA\)AApA\AîAzAAA
Aȏ\AHAɮAffAA33AHAŮAApA\)A=qAAAŅAÅAGAGAzAĸRAGAzAʸRA
A\)AəA{A  A
=AƏ\A  AAȏ\AAģAď\AAA
A
AA{A  A  AAŅA
AƣApAQAffAAɅAɮAAA\)AA=qA
=A(AƏ\AffAÅA{A(A=qAGAAHAffAApAAA  A=qA=qAAAAQA
=AffAQA=qAGAAAAAA(A{AHA\)AAzAzAAAGApAHA\)AzApAǮAA
A\)ApAAAffAĸRAA¸RA  AA\A(AGA33A  ApAA=qA
AffAĸRA33A
A
AÅAA(AAAGA(AAzA(Aȏ\AȸRAzAAA
=AHA
=AAAQAAA\)A\)A33AQA\)AĸRAģAAHAAzA33A\)AîAA
=AQAffAAîAAÅApAAzA\)AA33A=qAGA=qA
=A  AQA
=A
AHAApA
ApAQAǅAzA=qAʏ\AzA{AffA  A  A=qAApAGAHAAHAA
A{AffAzAHA{AA=qAHAAHA\)AəA{A=qAAHA
=AǙAǅAHApAAffAHAGA33AAˮA=qA  A  A  A(A  A˅AʸRẠA͙AAA  AϮAθRA(AGAAȏ\A(A
=A  AAAʏ\A\)ApAQA33AzA
AẠA{ApAAGAzAffAÅA33AGA  AHAA\)ApAffAəAAQAAA33AffAA=qApAȣA  AA(A33AGAGA{AHA˙AǮA
=AAzAzA
A\AGAHAA  A
AApA
AAȸRAzAAffA  AƏ\AffAƏ\A33AQA  Aȏ\AAȣAȣAAȏ\AQApA{AGAA(AǮAHA  A
A=qA
AAffAQAGAŅA\)AAGA
=AÙA  A(A=qAģAzApA  AAŮAď\AGA  A  A
=AAAəAA\)Aȏ\A\)A33AHA
AGAɮA=qApA  AȸRAHA
AǮA(AAȸRA  ApA
A=qAA\)AƸRA  A{AřA
AzAffAŮA=qA¸RA33AffA
AȣAffAřAA
=AŮAzA
=AffA=qA  AAʸRAʏ\AAAAʏ\AǅAʸRAA=qAAHA{AAAǙAHA
=AAAAÅAAGAffAffAĸRAHA{Aȏ\AÙAʏ\A̸RAAˮApA  AA
AHAÅA  Aď\A{AŅA=qAApAAɮA33AAAʏ\AzA\)A{A\)AAHA33AAHApAAA33Ȁ\AAGA
=AAQA\)A\)A(AzAA\)AzAʣA{AƏ\AǙA(AAQAHA  ApAʏ\A˅AHA=qA̸RAzAA̸RAGAΏ\AθRAHAͅAͅAAA
AzAAHApA33A  A(A33AAffAΣA˅AAAˮAA=qAA\)AA˙A
ApȀ\ApAͅAAͅAΏ\AHAɮA̸RA
AHA(AzAAAՙAәAzAAGAGAQA
=A
A
A\)A(AЏ\A
A
=A  AAzAA
=AΏ\A
=AΏ\AzAͮAQA
=A{AͅA
=A(AHAQA  A{AzA
=AzA
Aȏ\A(AAиRA
=A
=AAAңAHA
AQAҏ\AңA
=A
AA33AffAzAѮA\)A\)AA  AAѮAAQAҸRA
=A(A\)AA͙AиRApAffAffAffAиRAAffAυAϙA{AHAGAAΏ\AHA
=AHAA  AхAHAGA33AиRApAAApA{AA\)A
=AAzA
AGA
AHAQAA
=AAAΏ\A(AA(A(AθRAzA
=A(A
=A(AƏ\A˅AQA  AȣAAHAGȀ\AʣApȀ\A=qAA(A͙A33A
=A33AHA=qAzAAGAA33A=qA33A  AхAAA\)AA{AәAffAzAzAȏ\A33AApAApA33A̸RAGA  AͮAQAHAиRAиRA
AAzAzAAzAAAӅAҸRAffAAңA(A(A  AGAGA=qAffA{AљApAffAA{AAиRAθRAGAˮApA
=AʸRAAffA͙AHA(A(AA\)ApAzȀ\ApAͮA
=AɮAAQAGAA=qA
=AGAͅAffAAAAA
AϙA\)AAʸRApAͮAΏ\AA{A=qAQA˅AHAffAQA{AzAGApAď\AffAʏ\AAAȀ\A
=AA\)AAA{A
A=qA\)AzAʣAzA
A\)A=qAQAͅAzAθRAAQAGAHAAA=qAΣAθRApA\)A33AffAAGAȸRAAȣAA  AAffAʣAGA\)AA(A  AffȀ\AGApAA  AQAAAͅAHAAAAҸRAQA
AAAAУAљA
ApAѮA(ApAAffA  A33AA(AA
AApA=qAffA{AQAffAA
=A͙AͅAA\)AAAHAzA͙AHA  ApAθRA(AHA{A{AffA
AΣAЏ\AQAAA33AυA{A\)A\)A
=A(AAffAΏ\AA=qAAϙAA{AA
=AɅAQApAAHA  AffA  AAffA
AA˅AʣAAʸRAθRAЏ\AΣA  A\)AΏ\A\)AQAGA{A
=ApAQA\)AAffA\)A(AУAffApApAΣA
AzAAAQAA˙AẠA(AQAApAGA
=AQAHA=qA(A˅A{A  AzAzAffA  AAAΣA33AΏ\AA˅A˅AGApA(A=qAȏ\AAAʏ\A˙AAʏ\AA˙ApA=qA(A=qApAʸRAʣA\)A
=A  A33AGAAǅAȸRAffAA
=AQAAAffAHAHAəAAA33AzAȀ\AAAͅAffAApAУAzA
=A33AѮAAʣA=qAңAЏ\AA\)AQA(AHAA  AAGẠAzAApAǮAHAAAẠȀ\A
=ApAHAAzA£A(A£AHAGA
=AffA
A(AGAɅAʸRA  A˅AˮAHAffAHA{A33A33A  A
AffAAHAA
AAA(A=qAəAffAŅAHAA=qAzAģAAA=qAffAAzẠAAzAʣAffAAˮAffȀ\A
=A͙ApAAͅAA{AΣAΣAθRA  Aȏ\AɮAA(AθRAHAA(AA
AA̸RAzA\)AGAΏ\AAHAGA͙A
A{AAA  AHAȏ\A{AʸRAGAȣAA(AffAʸRAGAͮAAAzA
=AQA(AQAGAA=qAAAA  AͮAA  AУAҏ\A  AAAϙAQA͙AAA\)AAӅA  A33AAzA=qAυAѮAAAϮAљAzAGAApAffA\)AHAffA\)A33AzAAAAffA
AңA\)AGA=qApA{A33AA=qAApAQA
AAAͅAzAzA=qA
=AHA33AȣAͅAЏ\AzAA
=AңAHAљAAApA˅A\)AffAͅAzAAυAA{AQAУA
=A33A\)A(A  AхAA
ApAхA=qAAzAAA
AQAΣA
=AЏ\AAЏ\AzA33AͅAQAzA
AAzA
A=qAҏ\AApAAHA  AAA33AәA33AӅA  AzA
AHAGAљAңAffAA\)Aԏ\A33ApA(A
A  AQA{AϮA
=AA(ApApA{A  A\)ẠAQAAQA(A{AAzAAA(AAͅAΏ\A  AA\)AGAЏ\AиRAхApApAA(A  ApA
AӅAҏ\AӮA33ApAҏ\AAffAAffAҏ\AAzAGAAHAͅA\)A
=Ȁ\A  A
AGAAAffA˙AA(Ȁ\AAA(AzA=qA
AffAzA33AΏ\AAA{A  AAHA\)AGA
AәAffA{A\)AӅAAҸRAGApAQA=qA  A
AϙAͅA  AAHAУAA33AΣAΏ\AA{AҸRAυA33A(ApAA
=A  A͙AGAиRAѮAҏ\AGAӅA=qAAծA  A֏\AffAAՅAAׅA֣A(ApAffAzAGA{AGAԏ\AffAffAӮA
=AAӅA33A(A{AҸRAӮA33AәAAHAҸRAңApAәAQAӅAHAҸRAԏ\ApA{AApA(A؏\AA
A\)AGA(AA
A\)A׮A
A׮AA  A  A33AיAָRA  AAAΏ\AͮA
AGAAHA=qAљA
AϮAGAA(AҸRAӮA=qAAAAAԏ\AӮA(AHAAHA׮A  AQAAظRAأApA\)AAQA=qA=qA{AGA\)AأA=qA\)A֣A
=AծAGA=qAAAAHAGAzAGAָRAAԸRAA33A
Aԏ\AAAAծAzAQAָRA\)AQA=qA(A
=AA
A
AQAGAA\)A33AڸRA=qAۙA  AٙAHAAA(AQA=qAA\)A  AHAHA33AAԣA{ApAffA
=AAGA
AхAљAA
=AљAљAѮApAԏ\Aԏ\A=qAzA  AՙA  A=qAָRAיA֏\AA
AHA֏\AAAA
A{AӅA
AӅA=qAљAAυA
=A33AAAθRAҸRAA33AѮAθRAΣApAхAиRAA
AGApAҏ\A=qAGAԏ\AHAHAԏ\AծA؏\A׮A  A؏\AffA=qAA֣A\)AGAQA33AׅAffAGAԏ\AffAffAѮAҏ\AAA
=AљAУA=qAGAΣA\)A\)AΣAffAϙAͮA(A  AAẠAHAzA=qAHA(A33A{AzApA
AՙAՅAՙAՙA{A33A33AA{AָRA33ApA
=AzAљApA=qA{AυAHA33A
=AΏ\AA33AAA
=A
=A{AΏ\A  A  AQAʸRA  AΣAAGA(A  AHAAљAхA=qAQA=qAA(A
AzAQAЏ\AθRAУAGA{AAzA
AffA\)ApAA=qA{AGAQA̸RAGAAAAQAQA̸RẠA{AQA{AA\)AGȀ\AAΏ\AΏ\AθRAffȀ\A
=AΏ\AA
=A33AAGAGAAHAΏ\A
=AΏ\A(AͮAGAHAffAAͅAA
A̸RA  Ȁ\A˅ApAAGA
ApA=qAQA(A(AʸRAʸRA(AGAʣA˅A(A
A(A\)A(AQAQAQA=qAGAffA
A
=AGAA33AGA  AәAӮAӮAffA=qA\)A
=AҸRAңAQA
AApA{AA{AЏ\AͅAA(A
A=qAzAHA(A(AϮAQAGA  AA33A  AffAQA
AffAУAA
=A(A  Aҏ\AGAA{AϙAЏ\AЏ\A{AA
=AHA(AΣA
A  A
AθRAΣA=qAͮAΏ\AQAAzAHAzA{AAȸRA{A{A
=ApA  AʣȀ\A
AHA̸RA˙Ȁ\A
=A  AAϙAzAApAAQAԏ\AԸRAԏ\AԣAԏ\Aԏ\AӮAәAҸRAҸRAA  AApAHAΣA33AA\)A
=A33ApA\)AAQA(A
AzAͅAzAGAθRAʣA33AQA  A
A˙AˮAQA
=Ȁ\A
AΏ\A
A{AffA33A(AAAGAԏ\AzAQA
AӅAA\)AAAԣA\)A
=AAAzAәAA
=AиRAAA=qAzAЏ\AffAϙAΣA  ApẠAA{A{AAAиRAAѮAGA(Aҏ\AHA{A
A\)A(AA
=A33AA=qAffAAAffA{AAӅAzAzAffAңAQA
AυAA\)AѮAҸRAиRAA  AQA{AHAϙA(A
AHA
=A{A  A33A33A33A=qA(ApAҸRAQAAѮAҏ\AAљAHAGA33AAffAHA33AУA{AљAHAAA  A=qAυAυA\)AAHAHA
=AGA\)AzAzAffApA͙AAΏ\AAAͅA33A(AϮA
=AHAУAυAAQA
=AAԣAՅAQAҸRA
=A  AAљAљA
AzAHAffA  AffAΣA33AGA  A{AθRA(A  A{AȸRAA33AQAɅA=qAAHAəAHA{A
AA33A{AˮA
AθRAθRAGAA=qA
A
=Aԏ\AAAӮAHA
AУA(AQAAУAQAQAQAθRA{A  A
=AAGAAAAQAAzAȀ\A
=AGA˅AAˮAHAˮAQAA=qAͅA  AͮAffAzA=qAυA=qAHA
A  A\)A  AffAQA(AzApAzA(A(AAApA=qAA(AУA33A
=A{A  AAAQApA(A  AzAΣA
=A{AzAA  AAA͙A{A͙A
=AͅAΏ\AυAϮA{A(AиRAУApAA(A\)AzA=qAAϙAHApAAffAɅA\)AɅA(A
=A
=AzAAzAA{AAAȸRA
=AAAffAA  A(AͮAffAͅAQA
AHA  ApAGAхAңApA(AffAԸRAӮA  AәAzA{AҸRAzA{AхA(AffAGA{AQAA\)AA\)A33AffAˮAЏ\AΏ\AHA
=AAAHA  AѮApA\)AAA
A{AAʸRA(A=qAHA(A  AQAGAAәAAA  A̸RAA͙AA
A(AA(A{AzApAԸRAQAхA  AθRA͙ApApAQApA  A  A̸RA{AQA
A
AϙA  A
=A
A=qAA\)ApA
AffAQAffAzApA(AApA  A=qAҸRAҏ\AәAHAӅApAԸRAѮAϮAAzA33A
AApAӮA(A
ApA  AHA
=A\)AGAԸRAA=qAԏ\A(AͮAθRA
=A
AHA(A
AGAՅAAAӅA(AAGAAApA33A׮A  AGAمA(A֏\A֏\A\)A{AAA
=AԸRAԏ\AأApApA{A؏\ApA  AA
AA{ApAHAиRA
=AAQA  A  AљA33AԸRA
AA33A
AәA
AQA
AأAffAHAHApAAڸRA؏\A
=A؏\A
=AffAA33AأAA(A  A  A\)AAGAAAQAGA  AAzAA(AQA(AθRApAңA\)A
AѮAzA\)AAҸRAzAA{AA  AԣA\)A(AծA  AzA=qA=qAָRAAzA(A=qAApAAхA\)A33ApAԸRAәAԏ\A
=A
AAffAzAAθRAԣAԣAHAHAA{A
=AAHAQApA
AffAУAиRA{AHAAӅApA
=AA(A  A  A{AԸRA{AAԣA=qA33AӅAAGA\)A
=AҸRA(A
ApAхAҏ\AffA(A{A
=A33A\)A33A  A  A\)A{AңAffAQApAAAхA{AӮA
AAAHAظRAGAffAAAffAAָRA\)AظRAأA
AAffAظRAA(AffA\)AffAԏ\AA\)AzAҏ\AAңAAAffA(AAA
AHApAzA  AzAA=qAָRA\)A{AAծApAGAٮA33AA
=AffAׅApA
=AQAAՙAHA  AծAָRA\)AAHA֣A֏\AԣAGAՅAA=qAѮA\)AՅA\)A{AAA33AAͅApA(A33AffA=qAѮApAAQAӮA
=AӮAzApAHAӮA
A=qAҏ\Aҏ\AGAQAA(A=qAAЏ\A  AAͮAGA
AAHA˙AGAAffAɅAǮAƏ\AAəAAQAAA\)A\)AͅA\)AffA=qAˮAHApAAΏ\AΣAΏ\AϙAϮAЏ\A33AHAңA{AQAffA  A=qAͮA  A̸RAzAʸRAHA=qA
AQAԣAиRA
=AƏ\A(A33AAffAAAAAď\A  A33A
ApA{A
A\)A˙AA{A͙ApAљA{AAՙAәA
=AzA
=A=qA\)AәAӅAҏ\AHAҸRAхAGAAffAHAAA=qAхAGAAѮAAљAAAQA
=A\)AϙAHAͅA
=AиRAУAиRA33AGAңAAхAхAQAA\)A
A
A=qApAAӮAծAA  AzA\)AHA
A=qA(AՅAzA=qA
AAЏ\AAAA
AAϙAQAхA\)A  AҸRAңA
AQAѮAңApAffAԣAApAAQAAAҏ\AAԣAGApA{AzAA֣A
=AAQA=qA
A33AՙAAԣAGA33AzA(AzAHAGA33A=qA
=AAAA33AGAHAхAAAQAAA
AԸRAΣAAffAAffAQAָRApA33A=qAGAAGA(AA\)Aԏ\AՅApA=qA33ApAA=qAԏ\AzA=qAffAAHAӮApAԏ\A
=ApAӮAGAУAA(A֏\A֏\AA  AGA\)A  AAӮAHA  AәAӮA\)AQAGAAzAHAGA33AQAׅAיA33AיAA(A  AAHA{AzAQA֏\AA
=A
AA=qA=qAHAиRA
=A
AAHAAQA
=AAA(AQAθRA  A33A
=AffA\)AAHA
A֏\AAGA
AzAٮA{AA  AzA{A׮A
=AיA(AAA=qAأAQAAAӅAffAAԸRAՙAָRAיAӮA(AיA\)A֏\AAԸRAԣAGAУAхAՅAA֣AQA
=A(A  A֏\AHAׅAAQAأA\)AٙAمAGAAأA=qA؏\AGA=qAffAׅAA؏\AAQA{A33A  AGAffA  A33A33A̸RAQA
=AәA(A{ARAffAA33A
A(ARAA  A¸RA(A
A{ApA  A(A\)AHA  ApAzApAApA
AAQApA  AGAAA{AA{A\AA
A=qAAApAAAAAAGA
A  AυAAA֏\AAAffAՙApA{A^\A33A{AAAffAffAABBHBBBBB=qBRB
=BHB  BBB
=B	HB
pB	HB
pB	ApAzAAB=qBHBBHB
BB=qBffA{BBffAzAAzA  AAHAffApAQARB (AA
=BBB33BpBBffBBQB{BBB\)B	B	BB
ffBBB
=BBBGAB\)B	
=BB	
=B {BzA
A\)A{AQAAGA
B{A\A\)A=qA\)AGA  AGA33AAAzB RBzB=qB\)BB
BBBHBB  B(BB	HBBB	33BB	B	ffB\BHBB
=BHBB	BBGBBB
B B QBAffB\)BpB
=BB\)AGAAffA\A
AAA㙚AzA
=AB B (BB{BBQBBpB{BB
=BBBB
=B(BffBRB B33B
=BHB{B=qBHB=qB\)B33B HAffAA
=A(AA33ApA33ApAA  A
=AA{A
=A  AB QB{AB
=BffBRBB\)BBRB{BRB{BBzB
B	B
=B   BB=qB\)BB=qB\)BBpBQBB ffAAHAffA
AHA33AHAHAt  AAA=qAGA33AA\AHARA\)ARB 
=ABB(B  BzBBBBffBBGB\)BB
BRB=qB GB\)BRBB33B(BpB =qB=qB\BzB
BBGB A  AAB pBA\)AAA33A
=A=qARA{A\AQAHAA33B (B
=BHBRB
BB33BffBQBQB\BGB QB =qA
AB 
=B ffB B B
=B
=B 
=B ffA\)B BB{B\A\)ARARAAָRA{AA=qAQAA\AA\AHAGA
AAQAGA(ApB BBffB
BGBB  BBBBQBBzBBBzBQBzB\BRBABzBzB
B\BBQB  BB
=B (AGARB B HA33A\ApA(AAAA\A{A(A(AB
BGB(BBffBHBzBBHB\B=qBBRB{B=qBQB\)BffBHB  BB(B
=ABffBBA\BffA
=BApBBQB  BQB\B  B\B\B\BBB\BBBRB B BQBzBB(BHBpBB\B33BBGB{BBffB  BB{BBBpB

=B
ffBffBHBzBAHAQB=qBRB
=BGB A
=B 33BRBzB pB  B(ABBB BAB  B33B  B  BBBBpBBzB(BB
=BRBBB\BA{A=qB BffB=qBQB 
B{BGA
=B RA33AApB B(AffAA
=A\A\AQA  AffAHAQA
AB {B 
ABB{A
BB B RA=qB \)B pA
=AffAQA(A(AGA{A33ApA33BBBB33B A\AA\A=qApA33AAHA
=A=qA33AQA  AAA  A\AffB AARAAB{BRBB=qB=qBBB\BHBBB33B=qB  BB{BzBGBQBB33B=qB AzBA=qAA{B  AA
AARAAApAHA(AARBffBBffBB
BBB33B\B{BffBB\B
BQB\BHBRBBHB
=BB=qBB(BB
BzB  B\)B  BA(A  BAffAApA
=A  A(ApAQA\AA\)ApA{B QBB ffBBBB(B\B=qBzB{B HBBzBBBBB\)BGB
B(B
BBBBffB	zBB  B  BBB33BzB\)A  B A
A
AzAA=qA(A  A\AzAAGB33BB  B{B=qBB
=BRBzBHBpBB=qB=qBBQBBBB  B  B	=qB	
BBQBQBHBAGBGB
BHB{ABB ffBBffB
B(B
B
=BzB  BGA
A  B pBB
B
=B\)BBB
BBBGBB{BB
B\)B{B33BffBHBB	B	RBRBBzB	BBB(B	B
BRBBB\BGBGBA33A33B=qBpBB RApB  B B \)B33B33BGBB33BpBzBBB=qB  B
=BBQB(BBRBBBGAQB=qBBBBBB	pB
pB	\)B	pBB pBBBBB\)BffB=qB B\BQB ffA{BzBQB  B\)BffBB{B
=B{B33BQB(B\)BBBGBRBHBGB\BffBB{B  B  B
=BB	(B
(B
=B	B	\B=qB=qBQBB(BBQBBBBzBGBpB
BB  BBBBpB\)BGB
BffB
=BB
=BBzB
BBBB=qB
BpB	RBBBB{B33B	{B=qBB	(B
=BBB\)BzBHBffBBB	=qB

=BHB	BBBB33B(BBQB	pB	{B	\)B\)BBBzBB\B=qBpBzB
=BB
B\)BzB=qB
pBBffB33BRB	33B	{B	33BB	B	B
QBBffBzBGBzBffB33BBGB(BffB
=B  BzBBGBB{BRBRB
BRBBffBB33BzBpB
=B
B\B33BRB
=B  B(BBB=qBffBpBB\B
BBBffAHB
QB	(BB=qBGB33BzB B {AA{AHA\A\AHAAA(ARA33AB \)B GB{B{BRBB  B\)B\)BzBBQBpBBB  B
=B  BBB
B33B\BBGB
=BRB\)BBBBpB=qBffB\AAQB(B33BQA(AA33A(A\AAA{AQA33AQB zBRBBBB
BBBHB \)B33BB{BBBGBBHBpBBBBpB\)B
BBBRBBB   AB pB A
=A\B AApA  AAHAQBBB B\)ARB GBB{B=qBBBGBBzBBB=qBQBB(BBB33BB	
B	33BB	zBpBGB\)BB\)BBGBpBB QAGB   B {AGAAHA{A  B33BB(BBBffBB =qBRAA=qB BBB  BB  B\AB \BBBHB33A
ABB {ApBB
=B=qB GB=qB\B
=B33BAABHB (A{AGAffA  AAAAHB(BGB\)B\)BBpB\BBpBpBBBBB  B\)BRB
BzBGB
B
BGBB(B{B
=BHBQBB=qBBBB33B AB GAARApAA\AARAAAAQAAzB zB  BBB=qB RBB
BRBzB
BBB
=BAB B (B   BBBBHBffB{B=qB33A(A
=BBB\)B33B\BGBBffB
=BQB
BB\)ABB B {AB=qA33ApA=qAAGA(AffAA=qAA  AQApAAAA\AA
AQB33B\)AA  AA=q>
BB{B\)B
=B(BA
A33B RB{BpB ffA\A
AApAARARB 
ApA\)BQBBpBBB=qBBBB  B
B\)BB  BzBHBBBGB  B
=BBB(BBB=qBB\)B=qBBBBBHBGBBBQAA
A33AAAAAHA  AA=qA(B33BBBBQB
BB\BffB=qB{BAGA{ARB
=BB  BffBGB\BBzB\)B B(BzBBBBBARB B ffBzBBB(BHBRBB=qB  BRB
=BQBHBGB33B\BBBpBB
=B
=BRBB {BQB
=BBBRB
=BBHBBHBB=qBffB\)BzB QB{ARB AffAHA\B 33B zAABzBffBBBffBBB{BffBBBBBBBB33BB33B33B  BBzB33BBzBpB(BHB
=BzB\)B33BRBA{A33B  B RB {AffAB   B B B AAAA=qAA  B \)B 
=B HBHBB\)BB{B{BB	\)B\)B33B
BffBB  BB	HB
QB
ffBBGB{B\B33B
=BzBffBBffA=qBBzBB =qBBB
=B A
ARA\)B{AGA=qB BB{BBGBffBBBRB\)B=qB
B=qB
B
B	{BpBBRBffBB
=B{B=qB	B	{B\BQBB	zB\BBB=qARA\)AA(A=qAQAGAAHAA33AA=qAAAAzA33AzAffAB B{B BB
=BQBzBB	BHB	ffB	GBBB\)BB33B
=BzB33BABGBB\BQB33BBBpB{BB\)B33BzBBBB\BGB  B 
=B\)B33ABffBBB
=ApBB=qBB{BBB  B{BQB
=B{BBAB HB 
=AB GBGB{B33BffBQB{BQBpB  BBCAAQAAA\)ApA33AApA\)A
=AQB A(A  AAB ffAAARApApAAA
=A
ApA33A
B=qAA
=B
=BABffBAB(ABBAA(AAffAffAA뙚AQApA
=A\AzAApAA=qAAAAAAffAAQA  ARA
=A
A  AzAffA(A
=AQApA\)A  A33ApAA33AA33A(AAffAffAzAAA=qAHA
A(A(AHAHAυAAӅAAA\)AŅAϮA
=A
=Aʏ\AȸRAffA  AA33AApAffA\)AAAGAAׅA33ARAA\A{A  A33AzAGAzAQAzAAffA=qA
=AڣA=qA
=A=qA\)AzAAHAGA33A\)AQApAApA=qA˅A=qA=qAffAAǮAffA33AGAҏ\AGAθRA֣AAffAA
AAQA홚A\)AARAA=qA陚AAA  A
A33A؏\AׅAHAمAA{A  A=qA
=A
AA{AGA
=AᙚAޏ\A(AܣA\)AA  A{AGAAAQA=qAAAHA{A\)AffA{A(AffA
A33AQAA\)ApA33AA=qA33AA33AA33A(A\AARAHAڸRApAGA(AAυA33AAAzA{AAٙA  AAׅA(AGA\AGAA(AʣAffA(A33AA  AgAXA`zAmGAs
=AyAwARHA=qAA{AApARARAffAA\)ApApAAGAffAGAHAffA{A  AzA\)A\AzA(AAAGA33AAAAAθRA{AA
=ApAAəAQAǅA{AӅARAA  AzA=qA33AHAAǙAA(AGAHAHAAHA\AAffA(A
A(A{AzAˮA
AffAAA\)AA=qAffAzAHAAA
A33A
=AzA{AģAHA  ApAAۙAAGAٮA
AޣAAGA(A{A  A(AҸRAzAGA=qA=qA\)A
=A  AAA{AAA=qAHAAHA߅AأAָRAzAA
A噚AzAARAAA(AAQA{A\)A
=A\A{AAAAA
A=qAA{A\)AAAGA޸RA
=AAΣA{A
AA  A=qApA\)AAAAAA{A  A
A33AB {AAAB  A=qAA=qAAAA33A{B =qA
B (BzB =qAA  AHAffAHAQB A33BB(BAQA\B33A  A
=AA(B 
=AzB
=BBGA
=ABffAB33BBB(B\)A=qBpB  BBzBpAAAAzA33AAA\)A(AGAȣApAA
A33AAAA\)AAnHAp(AAmAQpAA
=A~\AtA\ATAyGAffAGAAAGAQA(AAA(A=qAA  A=qA  ARAGA\)AAgA\zAFHA=AXA6{A   AAtAHA~\A(A=qA;A%pA{A!A@zA-A+
=A!ApAA,QA
AAA\)AQAipA\  ASAUpAj=qAMAhA]AfRApAr{A~ffAAAffAA\AGAAAA=qAARAXAA
AAAGA\)AffAA\)AA  A\AzAGA  A  AQAAA\A(AQAQA(AAzAA(A\A{ApAA£A\A(ApAAGAAAzA\)A\A˅A
AA\)A{A
A  AAA\)AQAřAlzAAAA=qAA33ARAo
=AA33A{A
AAZ=qBBB\BBӀ BBޔ{BQBBkB8RB#BuBfB(BBfBLBqB㙚BzBB  BW
B݀ Bݏ\B݀ B)BLB  BB8RB(B؊=BW
B  Bʳ3BfBي=B.BfBٽqBֽqBB֔{BڣB׀ B{BB߳3AGA
=ARAAAAzAAAA(A
=AAHA=qA~HAr\AipApAmGA`QA[AWAmAf\AsAAAaAb=qAP  A`A|AA{ApAffAffAA  AQA\AffA\AHA(A
=AHApAAAHAA
=AQAA{AzAA
AffA=qA33A\AQA
AffAA\AHAAGAAAA\ARAAAׅAиRAAA
=AΏ\A֏\AAffAQAA\)AиRA33A¸RAA
=AAQA  AA33AApA  AAAHAGAAA=qAAQAHAA=qARAffA\)A=qAGAGA33AzAA
AŮAHAHAffA
AA_33AeGAjRApAepAA
=AHA{A{AffA=qApAA}GA
=A33A\AA~HAAr=qAzHAj{AaAqAdA^{AS33AUApA
=A
=AG@33A-GA,A!pA\AAA'
=A9pAYAlA^HA'
=A1AIA7
AAMpA\(A=qARAAA@33A
{A{A33A
A@A3
A>RAD@\AQA   A0  A{A\)@@p@AzA$@
@\)@θR@G@ۅ@˅AzA@陚AGA
A=qAzAA\)AzAA\)AAHA\)AA}Ar\AXQAAAPQA1Az\AH(Ak
A{Az{A,QA^\A1pAC33AQAd(AK\)AMAQGAXQAUGAuAffA
AOAA
=AHAGA(A33ARA  A  A(AzAyGAA33AyAAzAAw33AA=qAAA
A  A  AffA
A(AA{A
A33AAGA(AA  AApA=qA\)A\)A(AAA(AARAA(AAAA
AApAApAffAzAAA\)ApAAGA\)AffA33AQAAzA\AAQA
A33AAA
AHAA
=A
AQApAQA
=AA{A\)AA=qAAHA33A
=AHAARApA
AAAGA{A33A=qA
A\A\AA  AffA\)AzAzAHA\)AzAQAxAyAAARAmA(A	G@{@
=@@=qA!A
=@H@H@@|@5@=q@@Tz@g@Q@@33@(@\)@p@pAG@G@@(@33@@A+
=A/33AH  AA\A+
A/AmGAYpAXA^=qA_AB=qA1pARAuAqAV{A\QAAApAjffAd(A=qA\)AA  A
A=qARA]AApA=qA\A\A(A}AzAupA
=AypA  AHAAbRA\QA=qAzA  ApAzA  A  AA(AAP(Ao
AZ\AyA{A=qA(AAs
=A\AGAQAA\AA=qAHA=qAAffAupA}AqAzAw\)A(AHARA33AHAffAHAzA
=AHAzAQA~{A]Aj\An{AtAo
=Az\A^ffA]GAUpA[
AMpANRAb\AAHAHA{AQAϮA(A
=AGA
AQAAHA(AA{AffAA\)AAA33ARA(A33ApA\AzA
=A
A33A=qA
AAApAffA(AApAAAApA  A(ApAzAzAAA  A33A\)ARAA
=AA\)AQAAəApA׮A(AA
=ApAAA(AAAffA=qA
AAAʣA=qA\)AAA\)A(A\)A(A(AzAAHA㙚AGAA  A(A
=AA\)A
A\A33AAffA
AңARAᙚA֏\AQA
=AA=qAAAA
=AAQA(A
Aڏ\A(AGA\A֏\A
A\)AApA33AGA
=AQAA
=AAA=qAAQApApA
AGA  A33A=qA  AA߅AԸRAzAיApAAԣAGA\A
A=qAܸRAÙAffAՙAA
A
AHAQAzAApAHAAA33ARA  AA\AQAA\AAA\)AAƸRAffA  ApAGA33AAA\)AHAA޸RAHA
=AGAAA33A
AQAҏ\AQAϮAApAAθRAA
AffA(AAAAAzApAAA(A
AA=qAHA\)AzAAAzAA(AHAffAA{AAApAffAAQAAA(AA
AA  A=qAԣA  AʣA=qAՙA
AA\)AQAzAARAÙAHA33AîAAəAAQAQA
AAQAAAA
AљA(AQA\)AA(AAQAQAޣAHAA  A{A  A
=A(A  A33AApA(ApAApA  AffAQA㙚AzAA  AAffA
AHAffAAHA؏\AffA\ApA33A
A=qAA(A  AAڣAffAA(AAAA33A
=A\A=qA
=A  AzAA33AAAߙAffAQA(A33AAGA{AARA{A\AٙAffAA{AAAzAQAzAAGA=qAAQA
AԸRAGAAzAzAAzA  A33A=qAARAA{AAיA
A̸RAәAхA=qAffAA=qAzA
=AAݙA
A\AAA(AمAARA33AzA(AGA
=AzA(AGAAՅAAQA\)A  A=qA
=A
AAzA{A㙚AHA  A\)AAAA
=ApApA  ApA(Aڏ\A{AzAffAAHAA
=AApAAHA{A  AA  A{ARA\)AA\)AzAȏ\A
=A33A(A33AAɮAA͙AAffAA(A\)AffA  A=qAHAffA33AA33AAA  A{AA=qAʏ\AHA˙AHApA܏\AHAHA=qA\)AzA
=A33AAHA
=A(AffAQA33A\)AA  A\AAffAffAAffA  ApAzȀ\A
=AffApAA
A
A=qAGA{AΏ\AHA  AƏ\AA͙A33A{A\)A
=AA  A
=A(AəA
AÅAzAA=qA33AA\)A=qA
AAAAGAA¸RAŮA
AǅApA{A{A  AA
=A£AAƏ\A33AzA
=AəA{A  AffAAAAA  A\)AA  A33AGARAA\AffA  ApAAA
AGAzAA=qAzAA
A=qAQA\)ARA(AHA
=ApA  A(A{A33A\)AA33AffApAAAzA{A33AA(AAARA=qAAA(AAAAA(A\)A33ApA\)A\)A
AQAAzAA\)A33AHAA
=AAGAGAA
AffAAAffA  AffARAHAA{AAAARA=qAzAHA\ApAQApApAA  A33AQA
AHAAA
AffApAA\A  AAGAAzAAAQARA
=AAzApAffARAHA
AAzAARAA\)AffAHA=qARA
=A
AAAAAAA(A33AApApA{A\)A\)AA\A
=A=qA
=AAA\)A\AAARAAA
AAzAAARA
AzAzAAAAAA
AAA\)A(AA\)AHAAA{ApAA
=A  A33A=qAffAA{AAAA(A
A33A
AA=qAAzAGAAffAzA\)A}pA{\)AxA|(A}AzA
=A{A~=qA{A~{AxQAyA{\)Az=qA~RAuAw33Ao33ArHAlAh(Ag33AeA`  AcAc
Ac
Ac\)AaA^ffAYGAUAW33AX  ATA\AVRAW33ATAT  AUAUpAHA;
=AH  AMAMpAJffAGAEAG
AC33A?AEAHAAAG33AEpAC33A@(A>{A7\)A:=qA:=qA1A0zA$QA9pA*{AA4  AQA.{A0zA+A A"ffA$zA{A{AAAAA
=AGAApA
ARA
ffAQAA=qA33AzA\)A
A\AQAA33A\)ApAAA\)A33AA33AARAARARAHA33A\A\)AzA{AAAzAA  A
GAAA
A\)AA=qAAffAA\)A\A\)AAQA33A33AzA\A33AQAAA\)A
AA(A
A33AAAARA33AApA  AAHA=qA
HA
RApARA
RA
AHA
{A	GA(A{A
AA(A=qA\A\A33AAA @@
A
AA{ARAAGA\AAQA
A33AQA@ffAzA{AAQAGA   @zA33AAARA@ff@@@
=@z@=q@
@@p@@@(@33@z@ff@@33@33@@Q@
@Q@@  @{@z@@Q@\@
@@@{@
@@H@@{@@Q@(@@@{@G@@@33@p@@\)@G@ᙚ@\)@
=@H@@@@أ@@@{@G@(@@@Q@߮@{@\@@@@ff@@G@R@(@{@@z@Ӆ@G@@{@{@=q@G@
@ff@@p@p@R@@=q@
=@z@@  @33@\)@ff@ָR@@{@@ָR@\)@p@=q@@@33@@(@H@@(@=q@z@\@@@G@ۅ@\)@ᙚ@G@ff@\@  @(@@陚@{@(@\)@G@G@(@ָR@ff@
@ff@˅@G@@أ@ʏ\@33@ʏ\@z@ff@G@  @  @  @G@ٙ@
=@@H@\)@z@Ϯ@p@ff@{@@Q@@(@H@ָR@Q@33@
@G@˅@θR@(@z@ʏ\@˅@Ϯ@@@\)@\)@
@
=@{@\)@
@G@@ȣ@z@@z@@Q@
=@G@ff@z@@=q@=q@
@=q@(@z@{@=q@H@@@
@{@z@H@
=@p@Q@33@@\)@@@\)@@@=q@(@@@@@z@@\)@z@@@\@ff@@G@@=q@
@
@@\)@R@ff@@@@Q@@33@@  @H@ff@\@G@33@
=@R@\@z@{@
@H@=q@R@ff@
=@R@
=@@{@  @ff@
=@@
=@@=q@@\@  @H@ff@z@{@z@(@33@Q@z@
=@R@\)@\@@R@Q@@\@G@R@@@(@@
=@@33@p@\)@@@=q@@@ff@@G@Q@p@@p@  @G@H@UB\)BQB33BB
BB=qB
BBB33BffB
{B\)BBBBB33BpBHBHBQAA=qB  B zB
=AzBA\AGAAGAAHA
=AzA\)A
=A=qAϮAQA=qBQB
=BQABBHAA=qApA(AA  AәAޣA=qA߅AٮA=qAzA{BApB
ffB  B  ABHBzB33B	
=B
B  B
QBffBB {A  AA
=B

=AApApB33B	B  AB
B  BQB
zB
B
GApB B\)BBBHB(A{<#
AA  AffA33AָRAA
=AAGA\)AAzAQAARA{AϮAƸRA\)A(AƏ\AGA\A  A{A\)A33A=qApAď\AAA=qA33A
A߅A=qAAQAיA˙AA{AA
=AGAAAĸRAď\ApAQA
AHA8A(A<A'
=A
=A-A˙A (A=q@AzApAN=qA{ARHARAA>ffAJ=qAAHAAG
A0@A%A`zA
=ARAC
A.RAYpAQGA  AAAHAzAA((AK@ffApAA[33A\AA'33A,(A
=AIpA`  A=qAA:\APAR{A  AR=qAN=q@  A癚@
@33A=GA&RA_\)AS33A9pAPzA\A
=ACA)@A6=qA\@HA\)AA<  A7
AIAX  A=qA8AIA\A!A9A.\A3@GA:RA>=qApA0  @@RAVRAAM@QAQB	B	AQAB B{B	B
RB
BB
=BBRB
  BBBQBB  BB	BA  AB	B(AGBRBffB33BzB=qBB
QBHB
=BB
B
BB{B
BBRBBBQB
=B\BB	  BBzBARA{BB(BB
=B33B
{B
pB
  B
QBRBB	BB\BBHBA홚A33BQBGBpBBB

=B
B
\B33B  B	RBzBB{B BB=qB\AB
=BzBGB 
=ApB AAAA癚AHAAAAA
=A㙚AA(AGA\)AAffA  A
=A
=B\A{A(A(AAA{AffApAA{AQAB RB
=AAAB 33B(B\)B33B
BAGApAAA\AB(BffB{BHB  BBRBQB	GB	zBBBBRBB
B	AA\)B=qBBRB  B
\B33B\)B\B	33BB	HB
33B=qB\B=qAAHBBB33BffB
GB   B33BRA
=A\AAGB QA{A\)B B\)BQB AAzAAAHA
AB33B\)BB{BHBBHB=qBzBBB  BBB \)A
AQBB\BBpBBAGAAApAHAAffA{A  AA
=A(AAGAAApABQB\BQBBB{BB{BGB HBzBQBB
=B{B	33BBB(BB\BB\)B=qBpBBffB	BBB(B(BBQBQBRBA\BB
AHAffAA\A{A{A(AA33AQAHA  B 33BA(ABB\BBBBBGBAzB\BBA33BBHBHBffB  B\)B(BRB\AA
A{BQBzB33B ffA=qAQAHAzA뙚AGAffA=qA\AAzA{A=qAGA\AffAGA\)A{A\B 
A(BBB
=BBB33AHBpBB	=qBRB	ffB	B
B
{B
B	B
zBB
zB
(B\)B
BzBB
=B\)AA\)A
AB ffAGAA33A  AA
A{A{A\)AA\)AQA33A\B =qA
=B BHBB\)BBzB  BGBzB33B(B
B\)B 33AAB B \BAAABB
BB(A{BffA{A\)A
=AHB33AGAGA(AAQA(AzABpBBB
=BBzBpBzBRBB33B
=BzBRB\)BBffB{BB
=BBBGBBBRBRBA{B33BBQBGBB\)A\)A
=AHAAAQA\)ARA
=A陚AzA
=A=qA
=ApA{AQB =qB\A
=BB33BBB{BBRBzB	B	\B
  BBGBB(BB\BBB BBA33B 
=BRBffBBBB(BHB
33B33B	\BB A{A
=ApAA33A{AGA  ARAGAԣAA\)AA{A
ARAA
=AAffB  ApA
AAzA(A\A(AHAAQBBBBzBRB \)B zA=qAA(ApAAAzAzA  A뙚A뙚A\AzAAA
=AAAمApA(A{AGBB
=AAGARBB	(B{B 
=B  B 
=BRBzBA(A=qA\A
AHABRBB=qBBAA(A=qA  AHAQA
=AAAHAHA뙚AAA33A
=AA\)A33B AGB=qB BB(B
BBB	B	=qB
{B	
=B	{BABBBBpBBBGB=qBffB33BpB33AzARARAAB \)BBB=qB=qB{BBffBzB=qBABzB
=BffB(BRBffBffB
=BBffBzB
B\BpBRBBBB	  B33B A\)B
BRBHBpBB(B\)A(B 
=B\BBpB
BBAzA(B 33B{B
=AARARApAGA{AzA{A(A=qA=qAAB   BB \)B  BA
=BBBAQAB 33B\)A33ARBffB zAAHARAQApAAA
=ABAA=qAGA噚A\AffApAQAGARAffA33A\)AȣAAA{A(ApA
=A{A=qAߙA\AA(AA(AAظRAGA=qAzAzA
=AәAQAHAÙA=qA{A
=AAAAHA˙AffAAAAA
=AzAAAAA(AAHA¸RAffAQA{AAzAAA㙚AGAAffAAHA
AGAA33A
AAAGA{AAAA(A33A\AAAHA(A݅AA\AQAɮA33AffAѮA  Aҏ\A
A{AGA=qẠAffA(A=qAHAAGAAA{A=qA\A
ARA\AffARA{AzAQA{AA  AAQAARA(A(A\AA=qAzAA(AGAA33AQA=qẠAHA(A(A
=AәAzA
A
=A\)A\AzA\AA
AzA=qA
=AzA{A33AA܏\AᙚA
=A(AB(A=qApA
A
A\A
=A=qAAzA\ApA
A=qA\AAʸRAϙAHAAͮA33AApAAׅAAՙAٮAƸRA(A33ApAۮA{ARAA{AzAHA\)AGA\AQAAQAAGA  AA
AA33AAAHAHAA(AffBAAAAA噚A33ARA{AA33AHA
=A{ABBffBHA\AAzA
A\)A(AffAGAAAQAAGA{B B QA33BGAAAA\)A33AA=qA33A
AAA
=AA
=A=qAApA{AAHAAAᙚAA  AAΣAљAffAQAQAA{AA
ApABRBBB 
ARB(A(AAA\AAffAAAzAAAzA33A{A33AAAHAAAGAffAHAHAzA\)A{AQA=qA
=AA33AׅAԸRA33AGB \)BBB
B\BGB	\)BABB  B B \)AGA=qB  AAA\)BRA(AGA=qAB \)A
B HB\BzB\)ApAApAzAAzA(AAA噚AGAAQAޏ\AffA
=ApARAAGAAzB 
=AffBBRB33B\BA=qA\AA=qAAHAARA{AA  ApA\)AAQA\AAQB
AAffAA
=A
=AAHAߙAAA33AޣA޸RAffAAA(A޸RA
AAApAAGAHAB HA(B A\AHAQARAAAHA{AAzARAAA(AA\)ARABGB  AA  AHA{A
=A(A33AA  AAzB=qBA33A{A(AAffARAAA{A  A\AApA\)A=qAB  AGAAB QA
AAAAA\)AAHAffA\)AA\A\)AGAQA=qAffAA33A\)B AAffApAAHARAAAAApA{A
=A\ApAA33B   A
=BHAAffA=qAzA=qAA\A\)A
=B AA  A  ApARAffAQAQA\)AAAAA
A
=A{A  AQAA
AHAݮA\)ApA
AGA\)A
AQA{A\)AAARAB \AAB{A=qARA33A33AA\)AA  A\A\)AA\ApAHAApA\)A\)ARAA
=A33A陚AHAzAAHA33AHAABB
=B \)AAAAApBBB\)B(AA33AB AHA\AHAffA  AA\)A陚A=qAA
=AB(B{BApBB\B	BpB33B=qA=qAAAAA=qA
=AQAQA\A\)A(AAA
B  AB 
=A\ApAAAB=qBBHAAA\BffBHBRBBGB
BB33B pB\)AQA=qB pB=qBffBffAAB A  B  AB  B B
=AQB GBAAAAHB\)B  BBHBRB
=B pB33BHBBHB\B	BB	
B	BB
\)BB\B 
=BBGBRBffBpBpAQApBARBQBRBffB{BBB
=BpA{AAAAGAAffAAAffBzB	RB
pA{BpBBGB	B	
B	33B(BBBzB zBBBBHB
BQBQBBB{BB(A\B33B33BBffBHBARAHAAAzAA  AApARA  AA\A{AGA\)AzABB\)B
B(A\AB QB GB
A
A33BAB zBBAHA33AABB 
=BAGA{B B BBzB
B33B\)A
=B =qAA{A  AQABAffA=qAԏ\AA
=A  A33A
A=qB=qB\BBffB A\)AAAAAA
=AGAHAffARAAAQAGAAA(AAAAzAApAAAB\)A
=A=qARAApA\AAzAأAυAЏ\AиRAAхApA(AARA\)BBBB RA{A\)A{BB
=BBzAB\)AAAffAHAAAAQA33AA\)A{AffB{A  AApAffA߅AQAڸRAHA噚A{AA
=A{AAA
A
A뙚AzA
=AApA\A\)ABB 
=BQBA\ARAHARAAffARB ApAA33AGAAQA\)A{AA{AA  A
=AHA\)A=qAzAQA33A
=A
AQA=qAffA{AA=qAAA=qA\AAAA33AARAzA(AzAA\)A{A
=AGAAϙAffAARAA  AA
AQAGAzAAffAA
=AApA(A  A33AAA
=A{ARAAָRAAAAʏ\AffA\AA{Aޏ\AffAAzAQAA
=A݅AffAAQARA=qA(ARAA  ARAGApA\A=qAAAzAAᙚAߙAڏ\AzA܏\AQAݙAՅAڣAA(AQA{AHAA\)A\)AApAAHA(BApA\)BAAAQAA
=A(AA(AB 
=B QB\B
B(A
A33BA33AA\)A\A
AAA  AA(AGApAA؏\AQA33ARAB(ApA{A33B B\ARBBBQAAA
=AzA
A=qA33AAA\)A{AAABGBAA\AA=qApAAAB  BQAGAQA㙚A=qAA{AA33AGAۙA\)AۙAffA=qAffA㙚A33AA\ARA
AA\)AzAAGAA
=AQAAA(AAQA33ApA=qA
AAAffA{A  AAzA{AQA=qA\ARB 33AGAݙAAAA  A(AAAQApA{AA{AAAA  AffA  AAffAA
APAA
A  A\AAAQAAffAzAHB
=BHAA=qAAARAHAAAQAAGA\AAHA{AA
AB BRB
AzAB\)BBQBGBB{B
=A
=A\)AAQAA{B AA\AAAffA\ApAffA  A{B\B AظRAzA{AzAffA  AAAA\)AA\)AffARA܏\A\)AApAB
AApAQA\)A  AA33AffAA=qAAGA33AHAQA(A=qA\)A\)AzAAAA
AA
AAGBAAQAA  AAA{AHAA\)AծAAHAͅAʏ\AHA\)A
=AApA˙AיA{A(AA33AQAffA{A
=AAAAA
A{AB =qA
=AAApAAAAARAHAAAŮAQAA\)A{AƏ\AHAʸRA(AAθRAθRAGAңẠAGAAA͙A(AGAڸRApAأAAGAۅA
ApApAᙚAGAAARA
A\)A
AA  A\AABzA33AzAzAAAAQA{AA˅A  A֏\AظRAzAGAۙA33AA
AA(A\AGApAAAzARAA  AARAzA=qA\AzA\AffA\A
AAzAHA(ApB\B\)BB{B
BAAffA=qA\)AٙAٙA(AӅAΏ\AAApAGAHAAљAzAHAzA\)A{A  A  AQAA=qAGAAB HAB33AAARA{AAA\AB
=B B\B \BGA{BGB
AAA(AA
AAHAHA\AffA뙚A  A
A
=ApAzA\AA\)BGB{B \B
=BBAA\)ApBB{BBpBzA\)B B (A{BA(A33AARB (A
B(BRB  BffA33ABzB
=BAA33AzAAB B pA
A  AAAB GB\BHBB B(ABA\)B=qB AAApB 
A\B {BzB A{B A\)BBB{B
ARBAA33AAAAAAAAAHAܸRAᙚAQA
ApApAAA(AAAApABA  BB	
=BGA
=B  AApBB
A=qA
B GB (B (A
=AffBB{BHAAB {AHA=qAQARAGAAAzAA(AAA33AHAAظRA
=AAAQAA\)AAzA{A=qAHABB BBHB=qABB{BAA
=AAAA
=ApAffAA33AA(AGAA\)AAGA{AQA=qAffAAGAffA  A(AzAffAA33A  A=qAHB \BB
=BBzBffBBpA33A33A\AA(AQAB 
=BffBzApA  ABB 33A  BBffBB 33B(A
=ARAQA\AAzAGAHA33A33AۮA33A  A
AffA\AAB ffB{B{BpB{B(BHAAAHBQBB=qA  A
=A{AAARB(BAA(B B \BA
=A\)A{AAB A=qA{AAAARA33AGAGA뙚AHA33A\)A  AAffA\)A
=BBBBGBBBBBzBB BBHB BB  BRA  BBHBRB{BffBB	\)B	  BHBB  ARAB pB BAAB  B(BffA
=AQA33A
@HA(A\)B(B
ABB\BBGBffBHB  B
=BAffBB\A\)BB
=BA33A  A{BBA
=AQB(B\)BzBBGBAAHAGA  AAA(A33AAAzAQA{A33AAAA33A33B 33AQBQBpABA33B B 
BpB(B BffBB
BRBBBA"RB33BBB33BzBffB B
BGAzA
=A{AGA
AAffA\)AHAGAHAzAAA33AA(B ffBB{BffBzBBHBpBHBQBB\)B{BQB=qB(B \B zAHB QAA
AAAB\BBBB\)B{AABB RB
=A  A{AQAAAA\A\)AAAAAA\)AAGA  B zB ffB  A
=A\)B=qB B (B zBBffBBRBBpBGBB =qAB BBGB(B\)B 
AAAAAAQARAA(AA(AAAHA33AHA{AAAB(BQBB
B RB 
=B zAB B 33BB 
AApAA=qA\)AGAffAApA(AAA
AA
AQAA(AHA=qAQAH@{A
ARARA{A33A
=AA\A=qAGA
=AQAAzBpBBB HA  ARA(A\B AAAAAAffAAAB{BffB \A\AA\)AB   AA(A(A\)A  AAzAAAAA\)A(AAGB pBBBBpBHAGBQB
=BBpBGB33B33B \)B {A{B33B A33A\)ABAQA=qAAzB  BB B\)A
=AAffAQA\ARAAGAA\AQAQAA=qAA33A\)AHA\)AGA\A\)BBzB\B
=ABBBGB(BGB
=B
=BB33BQBQBB  B\)BBRBffApAAQAAffAAQAAA陚AAQAܸRAQAۙAHA\)A\)ApAAA
AzA\A  AQAAAARAAzAHAA\)AGAQA\)AAAffAAHA(AQA(A{AA\AAAAGAHA(AAAzA
=A33A(A
=ARA  A
=A(AAQA\AzApA噚A뙚AQAAQBzAHAAQB BB(AAAHAAA33A
A
AA\AApAA\)AB 
A{A=qB33A{A33AAHA33AA33A33A=qARA=qARAGA  A
=ARARAAAGAGAAAB 
B 
=B \AAB pAAB GAAAAAHAAzAAA=qAAQA{AA{A
=AGAڸRAA=qAңAҸRA=qAQAAGARA\)AA
=AA=qAAיA{ApAAffA  AQAGApAԏ\AߙA癚A
=A
Aڏ\ApAffA
=AHA  A(AA\)A˙ApAffAffA  A(ARA\)AәAA͙AυA33A=qAϙAAAA{AAAAͮA׮A
=AԸRA݅AzAA33A(A
AAA\A\AA\AA\)A(AffA33A
=A\ARA
=A  AffApAA
ApAAA33AA  AиRA֣A
AA
=A=qAzApA  AAQAAAAAGBBGAGA噚A
A33AARA{AAAAA\BB  A  ApBBAA\)AGAA=qARA  A\)ApA
=A\)A噚AA  ApA(A(AHAָRAffAA
AffA
A\AĸRA(AGARAՙA(AGA\)AܣAA\A33A
A\)A\ApARAHAAGA=qAAȏ\AHARA
A
A{AA
=A  AffA33AA
=AAA
=AGA\A
=A޸RAܸRAٮAAGA33AA=qAHA{AffAAffA\AGA
=AA\AAGAAAA\AzAARAA\)A\AzAGAzAA(A  A33AAAzA=qAGA\AQAݙAA{Aҏ\AzA\)AAA\)AAQAۅAңAARAQA
=ApB QAApA\A  A\)AQA
=B{AAAA{A33AA33A=qAQAAA=qAA33A(A
=AיApA(AɅAA33AAAAffAҏ\A  A\)A
=AA\)A
AA
=A
=ARAffA陚A=qAA33A\AGAA
=AA홚A33AzA
=AApA{A  A(AzAA33AAAAAAAAQAAޏ\A  ApApAHA(A{A˙AƏ\AA
AϮAîAHA(A33A뙚ApA(B 
B=qBRB A  AAAGAffAQBApA
B ffAA(AAA\)A=qAAHAAQB  BBGBABzA
AظRA޸RAAϙAHẠA
=AŅAQA{AGAAGBzB=qA\ApApAAAA33ApAzBRBHAABffABRAAAQA
=AQAHA
B A
A
AGA=qA{ARApAA  AAffA{A33AAAQA
AAGARA33A=qA
A\)A  AAffAGApAQB A
=AAQBBQBB\B\AQA  ABAGA{AzA
AA
=AA33AQAAӅAAzAGA\)A
AGA  AGAHA33AffA\A\A\AGAGAAA
AAffA뙚A
ApAffA\A\)AA
ARA
=B ffB ffAA=qApA33ABffBAzA{A
=AAAAAGAׅA
=A33AffA33AʣAffAGAGAѮAffAԸRAAՅAGAAHBAGAGA{B   BQB
BpAB BGBB\)BffBBHB B  B B B=qBGAHA(A(A  AHBBBBA(AAAApAA
=AAQA
=AHA\)AHAAA\)AA{ARAHB ABBBpB  AAA{A{A=qAQA  AA{AAB{B ffAAHAQBApAGA=qAA\)A  AHAHAB   A33A\)AzApAՙAGAzA  AA{AAQAمA֣AA\)A{A{A
Aʏ\AAQAA{A(AA˅AA33A{AAQAQAzA33AHA\AAA33A(AQA(AffAAQAәA\)AυA
=AA{A  AA\)A\)A  A33AA
=A\)A=qAGAָRAA(AHAA\A  A=qAQA
AA
AAϮAA  AAظRA
AzAQA噚AAA
=AޣAAHApAA33AHAAAAAAffAGAΣAAӮA  AffAיA33A\AQAAAARAA\A\)A
=AQA\)ARAGAAQAQAAQAzAAffAQAHA뙚AB \)B =qAHAQAzAظRAQAzAAAA
=Ȁ\AzA
=AՙA33AAHApA
=ApAAAA33B AA
A33ARAffA(AA
=A\)A
=AAffBQBAGABBBBB{BGBAAA33ARAARA뙚A
AAAAffA
A\)AAAA{ABpBBHB\)B33B=qBzBB
B\)BpAA  B 
A
B A\)AB=qAAB33B(B\)BB{BQA(AAffB\)B{A  AAzA
=B AAB HBpB33A  AA
ApAGAHBB{BBHBBBHBB=qBAB(B  BB
=B zAB\BB
B{AAQB(BzB
=B=qBAAAAA陚A\)AA\AHA\)AA=qAHA=qA33A=qAQAA{A
=AQA33A=qA{A
=AAzAA
B RA
AAAA=qAAHARAHAARAQA
A=qARA  AAʸRA=qA
=AHA(AffAۮA
AGA=qAAQAA=qAA  AAGA؏\AffA  A
AA
AAA
AGA\)ARAzAzAzAffAffA=qAABB GAGA\ApA=qAAAApA
A  AЏ\AA޸RAA
=A{A
=A(AAAٮAQA\)AظRA
=AHA
=A(A\ARA\)ARAAAAHA(A\)AAQA33AAAA=qA33BRB	QB
B
<<
<
<
<
<
<
<
<#
<
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
            <#
<#
    Dÿ޸RC\BLQ  C!HC=q޸RͿz33ÿ׿ÿff׿QHzͿ{Ϳ(˅׿\CIGÿO\)CD>\녿c
fffz(=qBR(
ٙ\\E\(  =q33ffGHHp33
=(  HHٙ  =q\
(녿hCCp\)  (BaH33J=q
z῞R=qaGJ=q녿J=qYBͿ5
=D{Ru#
=@?zH??(?p?=
>8Q>
>?B\?{?{?
?{@33@(Q@;@S33@l(@?(?z>@z>uA\)>aG>#
>ǮǮ?\(R?{@  @33@"\@W@<(@p@@@@@{A
\A
=A-A733AS
=AcAAffApA  AA
AffAffAQAQA
A33A=qAmAp  AGAA
GE@AG?
=@GCf?
=@-p@P  @%@8Q@\)@w@@
=@@S33@@=q@@@{AAQAHA9GAnffAyA\)BB=qBBBB+BBgpA33AAARAA\AzA{AffA\)ADuC\D/HC*=Cxn@zA zA:{A~{A6RA%A
pA=qDɚ@mp@  C=C;@o\)D5H@R\DqA?
=@ff@
=A(zA
=AAAəA(AzAHAA(AHApA  ARA33AW
=AhAoAW33A[AX(AAzARApA0  D"C݈D2C C@8QB@QA(A`zANRAZ=qA*\A}AA>=qD D_#3@(D!` @33A:RAyAAAأB HB GB
QB
RA33AAQA\)AAHAA{A޸RAģA(AAzAHADaA@(@A{AAA0AD^fCD
@  D 
DC}qDN@DB@ @  C4{@zH@@
=@33ApA6HAeAAQAGAAAeAn=qA\AHA(Az\A(AA33AQAAyAAAR@ҏ\C,#Df
@@z@@z@
@u?aG@q@9@DEqC)@\)@uC"@{D3D=Dl)@nR@
@z@GAzA
=A3
=AX(A_
AdQAj\AyAypA]AlAyGAmGAyApAAAAA
=AACyBjQC#DDA33A,  AMGAhzARA  A~HAHAR@\CAH@=q@\)@pA33A@QAXA~\A @
=A\)AA;A^{A|AlAA{AffA{A\)ApAAA  AARA=qA
AAGARAffA<ABRAJRANffA"\B\)A-CbA8AQGAjRADzAW
=Ax  AXAAzA\AhzA
A=qAAAA  AAA=qAA(AAAHAиRAأAAˮAzAA(AGA33A(A=qAABB\B\)C  AB\BGB%
BBzB
BzAAffAffA33AAzApAAAA͙Aȏ\ABB
B{BBB$HB)(B3B1B8\B4B8\B5(B%HB%zBB=qBB33BRB
BHB pB#pB,pB3
=BBAHBBA
AA\)A  ApAAGA
ApBHAHAHB&BqBmAB(B+BE\)BL  BY\)BuB\BBB(B'RB9
BOB]BnQB
=B8RBBpBB{B3B=qB BuBRB=BBCRB0\)BBBLGBP  Bq
BIzBNffBHB_Bi(Bq(BdRByffBzBRBo
BwB}\)Bq\B5B+HBdzBuBB=B{BBB{By{B\)BBB#BB  BBBBffB)BzpBBBQBi
=B>
=BHB$\B4BKRBl{BffB/\BGB*BffBpBB\BQB-RB!\)BB+  AHBAQAffD*޸ARD'DK)A(A=qAAGB\B=qBHB  BBB#B:BKBD{BL
BBB:(BGBE
BBffB3BB\AApBRBB-RBA  A{A؏\AHACٚAυAAB{B33BffAB
{BzB!B,pB<=qBCBJBWBT
BYGB`ffBh=qBB{pB
B(BfBBǮB
=BHBBHBBB.B  B{B	AAAAΣAAGB
zB
=B  C3A
AzA  A(A\)AA
=AA\)A=qAHAA{AffB
(B{BHB B2B:HB"HB0\B/
=B8
=BK(BJ  B\BZBoGBo\Be\Bq{BpzBo\BQB7RBpBBQB BBBB&{B)pBB (B(33B!BB(B\B
GB͞BBffA33AAffAB33BHBGB#B+B:B<BE
=BmBH  BKBOpBIB[HBgGByBBBBffB.B8RBoB"ffB(BBRB=qB.(B*{AأA33AÙA\)Aď\AffAAHAAAAAC*=A{AAQA
AɮA(A33AAHA
=BpABBB
RBB-BA
B2B)ffB+\B&B-B3QB5BCRBHHBB
(AAŅA
=C3D
A͙A33AAAA
ApAAAGAGC)AʸRA
=A33AAAA(AAB  BB\BBpAzABHBB	B
=BB=qB  B&
=B&B3QBA
B:B(BB=qBB\AA
=AHA  AHAAGA{A  AA33AzA=qAAAQAzA
ARA\)ARAA
=AAAיAzApA=qA33BBGB  BHBffB33B
BB
=B$pB-\)B4zB/zB8ffBB#
B0B-AA=qAzA\)A
=AGAAARAA\AA(A\)AAzAHA=qAA
AAGApAAʣA\)AA  A33AAB\)AAQB{BB(BRBRBA
BpAGAA(AAAD&DJAW\)A\QAxQAQAn\AvHA]GA_
AepAV=qAYGA^HAZRAcAgAjHAAA33A
A{BpAHAAffA  AA\B\)ApBBpB
\)BB"
B"HB)B>B7RBC\BD33BzApA̸RA(AAB\B	
BBBGBBQBAA{AA  A{A˙A\AAẠB  A
BB RBBB	HBBBpB'GB3  B-(B1zBAB?BDzBJzBMpBTpBC\B9(B=B7B<B=qA  ARAAϙAA
AA\)AQAHAA(AABOQAAAApAAzApB
=BffB
=B
B'zB3zBGBffBQBUGB]BeBfBr
BjBBBBB{BzB)Bq(Bl(B   BB
BB%
=BAGB@B6B3HB6QB2B6B9B'B+HB&zBBB\)B%33BBffB\)B
GBB6BFzBgGB}BB#B(BB=qBBB{BfBB\)BBĞB=BuBB)BB\ByB

B
AA(AAAQAffA
AABHAAHAڏ\A(A\)AAffAAABRB
BGB/{BzB&B3pB9RBBffBCB8\)BNzBDHBRBW
B]\)BdffBhBvzB~BeffBn\)BxB{
=BmBaQBBB\BB*B(B(B"\B!B\B&B0B0B/\B1B&B/BF\)B#B  BABQBBB-\)B?ffBS
Bg{Bo
BzBBBqBB(Bg33BoffB;33BDRBDB:=qB?zBOGBRzBVB]BgQBqBkB733BOpBTBYRB_GBi33BoBUpBjffBu
Bb
BZGBeBvQB~\)B
BeRBe
BlB{B)BtB3BW
B  B
=B3B#B=BcBy{BU\BPB~
=B>GB:\)B>HBABOBPBFB7RB9HB,B0HB7\)BC  B2B:BFBLB
=BYD@@\@G
=@fff@n{@Y@]pB)@z=q@g@l(@vff@y@j=q@xQ@qG@i@g
=@aG@fff@h@@p@s33@qG@l@s33@s33@z=q@nR@~{@}p@Q@Q@Q@(@Q@{@~{@~R@{@zH@x@@\)@@p@H@?Q@=q@\@\)@R@@(@@Q@@z@p@ff@G@@  @p@@
@ff@p@
=@@@H@@33@\@@
@33@@\@ff@=q@@@ff@33@G@
8Q@
?@  @@(@(@c
@p  @r\>B\@{@@p@!G@@@Q@@\)B@  @@@33@@R@R@@@Q@@G@@(@=q@@@@@ff@@z@z@@@@@Gz@  @c33@c33@p@j=q@s33\)@@
@Q@(@\)@׿G?:HaG@@@@\@33@@G@{@H@\@@p@@R@@@@@p@@33@=q@z@ff@
@z@ff@@Q@=q@w
=@@H@@(@@@@@z@@(@@ff@@R@33@@^R?@\)@z@@{@
=@(@p@z@\)@@p@33@\@33@  @z@
=@Q@@@=q@33@ff@R@p@@@ff?\)>{@R@=q@p@@
@33@=q@g
=@Q@qG@z=@@\)@G@?=q@
=@=qC#@R@@(@33@p@\)@@p@@@@\@z@@\)@zH@}p@}p@zH@{@s
@{@\@@Q@=q@u@r\@p@p  @qG@zH@Q@Å@@vff@q@p@q@r\@q@l@o\)@s33@GA z@z@{@}p@{@Q@@@\@{@@@
@~{@\)@\@\@}p@p  @xQ@s33@nR@\@\@u@xQ@nR@hQ@vff@p@Q@Q@{@=q@p@
=@
@
@  @u@s33@|@~R@(@u@x@R@|(@=q@@\@@vff@~RDC@@@(@@~R@\@  @@~{@@@@z@@@\)@@p  @l(@^{@_\)@Vff@R\@O\)@S
@dz@i@aG@g@nR@r\@]p@s33B
\)?
=?
?\)?ff?ٙ??H@?
=?{??ff?@ff?
=?G?ff?޸R?????
=??{?\???\)?\)?Q????У?p?z??????@@   @R@\)@\)@z@"\@
@@ff@z@@{@@8Q@\@0  @a@fff@A@@  @6ff@(Q@I@1@E@@ff@@x@J=q@g@G@`@aG@@R\@:=q@/\)@6ff@@(@:=q@y@nR@xQ@a@R\@G@R\@R\@S
@NR@L(@G@P  @I@a@g
=@XQ@`  @n{@@Vff@@  @n{@~R@vff@u@h@x@w@x@n{@c33@333@#
@,(@333@B\@5@>{@7@(@@
=@
H@(@=qB{Q@!@*H@G@Mp@w@~{@1@@"\@R@0  @<@*H@(Q@]p@P  @E@G
=@7
=@8@8Q@dz@n{@L(@i@Vff@NR@c33@\(@h@u@mp@hQ@hQ@mp@E@@Q@\)@xQ@\@y@\)@x@G@xQ@dz@^{@mp@p  @S33@X@Y@dz@p@u@@
=@z@@G@pA@\@{@p@@@u@xQ@\)@s
@tz@\)@\@H@p@@  @@@@@@\@k@a@z=q@R@l(@jH@
@\@Q@G@33@@p@q@@z@@z@@ə@@@@S
@]p@@33@\)E RC@
=@@\@Q@\@Q@p@G@y@p@@  @\AQA-GARAHAGATQA<zAEARffAC
=AO33AAA%@
=@
=@(@\@@1@B\@@O\)@@L@JH@G@l(@E@b\@`  @XQ@\)@@  @z?˅?
=@@ @@??Q?33??33??\?G?p??:H?k>\?p?G?B\?aGQ>G?xQ>uaG>Hu>ff>=q
=??>Ǯ?.{>ff?.{>p?G8QE=L;=q녿8QG\{\zffþ
=Ϳ.{
=khÿzH
=(
=p   
=(녿ÿ(>R?{\)>Q>?s33?z?0>\)=#
33#
>R<
(=qW
=
^Rp33{33H{ÿH\
GaG
(Y5Rs33R&ffff\=q{EuQǮ녿33
׿Hÿpÿ\\)G{(׿=q׿ÿ  z῵Ǯp׿xQ5HQ˅HͿ녿ff
H\pG{\) &ff ׿aGRHͿ{=q˅G-p=q+
=,(:HMp?\)8Q'
=
G
H #33RR($zz{녿R{޸R{@R@\)A~ffAhzA\)AAA=qA=qAAzAxA<zAffA?A:{A z@H@@33@c33@33@\)@=q@w@A@_\)@|@=q@dz@1G@8Q@]p@@@3
@R@@{?=q?\)@Q@A=qA?
=A?A+
A6RA@33@@@`@z@
@p@@(@c33@C33@S33@333@33@@'
=?p?W
=?(??\>k?+??H??}p?8Q?Tz    
=q
=q=u?QLͿEÿG  aGEp	s33'(

{Gpff  ?Q쿘Q쿰׿33   z?\)(p	2\7@  5	   \)\zῢ\1녿{K\)!>R'
=:=q\?Tz??R@@G@pA:{AhzA\  AA
=@\@@S33@y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ffzΰ
z(p&ff
=
=@  =ps33EͿ=q
33
  Ǯ=q(
\)
=ffHQ!G
H3333˅=q\)pÿ(\)Ǯ{
p*H33#
p8,(2\3
#
3
2\\){  33"\=q
=$z'
=Ee*H?\)HQ\XQ>Rl[,-pNRDz$z\)'
=R녿Q\)p(G33RQxQW
=E(ÿ333\)^RpGfff3338QTz῅33333=pH ׿ff0  \)`  >RHs33\)ffR@  LͿ+ff=q0=#
?5=q녾\)uzW
=zῬ;
?   ?O\)?s33?(@@ff?޸R?@ff@7
=@H@ff@{@
C33B[?@  @
@G??(??H?xQ?333?fff?G335\
=  녾\33G(Q.{\\(p{HͿ@
=@s33@u@3
@@@j=q@w
=@qG@.{?  @W
=@9@R

?J=qG>?&ff?>>u(:H\>\)LͿ33\Y(ÿ=qff=q\ff{\) ׿Ǯ\)\){z῜(330׾Ϳ
{ffff33(?>.{(ÿͿ  녿ÿ(R?˅??\)?L>\\)zῌͿ(n{LͿffQGQ쿙ffQ쿀  :H=u#
#
?0?\?G?@G?k@p@#33?ff??
=q??\)=k;\=q\E4`B\>8Q=L>녾녿B\aG(??Q@&ff?z?#
?^R>?W
=?(?#
Q켣
0׿hÿff  &ffB\>\)&ffQ=G=>\)<
>.{HͿ;  ({þ  >ÿ   W
=>=q?\
RQk5W
=??\)@33?R@A@4z??33A(B3B{BfBBǮB(B9{BGzBGB^
=BKB}(B\BBB.BBLB=BeBD(B2
B
QB
QAAzA{A{A=qA  ARAAzHAZ{A=APA)A;A   @陚@H@@=q@H@R@@^R@qG@p  @~R@[@HQ@"\@2\@:H@1G@5@@*=q@3
@\)@"\@\?\?33@z?p@?p??
=?Ǯ?ٙ?@6ff@'@6ff@Q@7
=@#33?
????Y>p=\)
=q>Q?z?c
?>Ǯ#
?333\)uaGW
=\(\)ÿL;p>aGu=<#
<
=q>\(k+z῅ffaG
33=LͿR
33  
녾L;녾\)zTzᾳ33<W
=ff(ÿ.{p׿녿Rp  \5Q쿙ffͿÿO\)LͿ0׿O\)z   pͿ*=qp%HͿÿ8QǮ\)޸R#
>\)\H{QͿ\(0׿333ÿQ녿O\)
33Q   
=q ׿z
GG%p=G0׿G녿\)
ÿffQ=qHG
p
=q
=H녿ff
{33hÿ׿  GY
fffW
=(\)p\)=qÿ  pp˅=qQ ׿zǮ
H<(Q!G"\{G(G녿
={ÿ0׿fff\).R
H33<
=#
?&ff?L?0?R>z8Q쿅
\;R.{  >R<
LͿ(Ϳp2\%*=q
p&ff*H
R	
=Tz   EpR
p\ͿTzC3359333YS33JHJ=q:HEPIL(NR+!G(ÿ\) $z#330-p<(NR%G<(J=qWXQ[^RXQXVffVffXQMpC33H=pzGJ=q
  {"\U 6ffP  G
=JHUR\JHO\)PO\)N{HQJHXU\zNRGzzO\)O\)UHQO\)UTzUJHDz>R333/\)   ,(NR(Q(Q#33.{6ff!#33H1G+"\&ff4z6ff9>{<=pA:=q7-p(Q&ff&ff.R{%(+33+:=q;L(O\)IUY7
=Du]p1G#
Y<<(>{;,>R8Q2\4z8QG
=MpC
DzNRP  :HS33L(AW@O\)1G:=qC
O\)9ff33޸RG@  AJ=q6ff9DzP  .{1G@  <<C338Q8Q>{HN{NRGHQDzC33
=R
=q, )(Q1G<@<@  C33=pAGG
=HQ>R>R7
=0  Eff\.R'
=)=q33ff33
=q!G((<@  "\N{!G7
=,(1#338Q,(,%ff1G&ff2\%3
4z/\){@  C331G\.{GRG(Q1G>R%%*=qA-p,(6ff#
 
pz&ff4z.{&ffH˅!G%333@:Hz#
%%2\*H57
=1GNR.R)#33Q'ff\)*=q%,,7[+-pR

=(7
=<AGK9G
pУ׿˅\),(u3336ff4z;<(5/\)\1:=q\=p/\)z:=q&ffR   9#
&ff((*=q%(!RR,(+p0+=q
p!G"\\)녿      R{Q0׿У녿{ff׿B\aG   HkÿͿ  \D   zpͿ녿ÿ\\c
#
׿s33Ez  \  ff(
=
=ÿG^R=#
L;\){
==Q\>?
=qxQ
=q!G녿{Q쿜(׿=qͿJ=qQ녿+Ǯ=>G??\)?33@@??\)@'@P  @QG??{??\@@{?=q@}p@L(@(@@p@@AG@ff@S33@j=q@33@\@R@>{@_\)?(>
=
>\)#
<#
?   ?z>G>G?=q??fff?G?R?\8Q>\)>z?\)>z>???\)?
=?+?B\?
@
p@(@@@@.R@Q@{@q@33?
=@
H@"\@1@G@4z@   ?{????ff???R??R?@E@@U@8Q@nR@_\)>
>Q?B\??u??33?
?Q?@?ff?33????  ?{@"\@S33@\@@@\@  @
=@@AA AHA,  A"HAUpA0(@Q@x@u@  @\)@(AHA6{ABffA/ADQA;33AC\)A%GC  @{@AA
AAA
AA
=q@33ARAA
RAGAA%pA#\)A=qAA!A$A+33A<(AP(AV\AZHA`  AMAdAz{AHAA33AffAZ=qAnHAiAAQAGARA
Aҏ\A
=AffA\A
=AFRAk\)A\)AzAQAAGAHApA{A\)AQA(AffAQAA(AA
=A\)AͅAARA=qAApA=qAA
=AA\)A  AAAA
A(AffAAGA
AAzApA^\AlAA~=qA
A(AAAҏ\AzAA
=Ȁ\A{AffAAA\)AzA=qB 
=BQBB  AffAGAHA  A(ApAGAA=qAB 33BQA33AA
=AAHA
AHAzA33BB B(\B:RB>BBBDBA33B4B9B/\)B7\BBzBFBJBTHBX33BgB`BfpBj\BmBcBq\)Bs
=BuBrQBwBo(Bt  BaHBCBKQBUBeRB{  BBǮB33BB
BuBOzBPBU{BW
=B\B`Bd\B]BbBjBw\B{\BGB8RBaHBfB{BB(BuB=qBHB
=B.B8RBBqB(B33BBB(B8RB\BW
BfBBB=B~33Bx33BzB3B|GB)B B~BLB\)BBB{B33B#D2{B\BB(BuB
BQBBB\)BBaHBzCPqB
BB=qBB=BBBBLBÊ=B(BBB΀ BǮB8RBLD3BkBBB\BBBLB BfBBLB˅BpBfB.B۳3BE*RBffBB{Bߔ{B)B  B{BB#B
=C BC.C	=qC
=qCGC\)BqCQCCzCCCO\C"C ޸C$\)C3CpC
C!CT{C CC\CEC CC"C'LC)3C*!HE%C2\C5zCBO\CFC<(C@=C<qCHcCQO\CE0CYC^C^C`fCbChQCiCmCpxRCsCrRCxfCyC~W
C\C/\CCZCPC\)CCcCbCj+Cq=Cv=qCy5C}CPC}C
CٚCW
CCC,C%CLCCCФCCCC4{CCC5CaHCeC
C CC3C!HCT{C{CC\CC+CnCRC  C΋C CCШCCcCC=qCCbC㹚CRCt{C=CC鹚CCC)CCZCfD 0 DD%DqDDUDvfD${DDD)D>DQDDD{DD D$DfD D!{D#<D$}qD%=D)kD*D(<)D+0 D-.D1D2ҏD1D,D3HD3D{D7D8D:xD:=D>)D>޸D>)D@D@zE1D@DD\)DAvfDKqDODSfDVDWDcfD`3DhNDiDm1HDpEDpDuD{)D|*DwND{D D1DDD DqD%qDfD D(RDW\D DDqDDDDFD%D,DB=D`DcDMD
D(RDD}D	HD{D/
DQHDDrDDDǮDqDHDdDO
DDDDDo
DDDiHDƞfDƮDHD~DLD~fDDφDCDDH DۅD
D3D^fDȰDJD\Dդ)DۅD׹DDDeqElۮB8B*B(pB)=qB&RB)\)B,\)B-  B-
=B033B/B9RB6B533B5
=B5RB6B-{B-B0(B/pB6QB9RB?QB;zB;=qBABBGBF=qBBBG33BC(BLQBDzBARBC=qBCB6B6\BE
=BDBB(BB33B,
=B1\)B/
B*  B&B-B4
B2\B,
B-GB'GB0HB7
=B;\B7B6\B/B/HB0RB1GB,RB0B3\B2QB1pB+B0
B.B0=qB0pB1B0ffB/QB3{B3B4{B6\)B4B4zB2B2B%\B3RBB%
=B*B(B,(B)B,
=B*RB'B(B,RB#=qB)B((B!
=B&HB%pBpB*@@0@5@@1@5@6ff@ff@|(@aG@c33@L@U@R\@X@R\@jH@@z@vff@z=q@8Q@Q@@z@w
=@I@333@C
@L(@@*H@L@L@_\)@c
@.{@:=q@%@
=@@G?R@G@?H@@S33@4z@E@G
=@W
=@R\@Q@O\)@>R@A@3
@,(@@(@%@
@   @=q@2\@@!G@!@!@+@5@%@\)@\)@{@$z@R@%@(@33@ff@ @!@(@'
=@!G@ff@@?@
p@p@'@"\@+@*=q@,(@'
=@=q@ @(@33@
H@@H@R@'@ @%@@@@ff@R@R@"\@ @@)@5@9@"\@%@,@&ff@$z@   @(?@33@"\33@ff@=q@
p@ff@ff@@33@
=@@@@33@@@@Q@"\@!G@@@R@@\?R?Q?H@@@   @  ?n{@@ ?
=@
@@
=q@@
p@@Q?R??@
=?33??޸R?
??\?\?޸R??????
?(@\@%@*H@!@G@@Q?R@?
=:H?˅@p?@{???ff?aG@?H?=q?\)?=q?33?ٙ?H?{@@(@33@ ?(?
=?޸R@G?H?\)?{@ff@33??G??
?z???R??  ?
=??ٙ???ff??{@@ ?ٙ?
=?Q@H?˅?Ǯ?G???(?R??z??\)?=q?p?(?Q???
?=q??z?
=??޸R?\?H?{????p?(?ff?
=?G?R?G?\?Q??J=q?H?  ???33??\)??ff??R?H???\)???{??\)???;?\)?\)?=q?G??\?
=?\)?{??
=??
?}p???ff??{?Q?=q?
???\?{?xQ????
?  ?u?u??z??u?G?\?33?(?\)??Q??p?p?xQ?c
?^R?p?Y?W
=?c
?c
?W
=?s33??{??
=?(?\?p?E?=p?0?#
?:H?B\?J=q?J=q?L?0?8Q?=?R?(>
=>H>
=??
=?>>H>>>Ǯ>p>\>p>p>
=>Q>Ǯ>.{>.{>.{>#
=


\)ͽGu.{kL;W
=u

=LͿþ{GJ=q#
zὸQH5(;p(hþR\
=
=#
k
:H ׿GJ=q^RW
=n{p׿hÿG
GO\){33ÿzHfff׿zH=p#
ͿQ쿝p
\Q쿠  H  
('G\=qGpdzDff{  녿Ϳpÿ(z῾RͿ

Q쿬Ϳ{
=(Hp녿
=G
\)33  ÿR  R˅{ÿRG(HHHEGͿRQ쿺H
{Ϳ녿z
=Qp
=Q޸R
=ffzH    Q=q=q{ǮͿÿGQ\˅\RǮ\)
=˅=qǮ  Ǯ  {33녿У׿=qͿ33
=녿Ϳٙ\){Ǯ=qG˅  \)ÿ{
33
RͿ  H{녿
=\)H
ͿУ׿ǮǮ녿ÿ\)33ÿǮ\CyǮ
У׿˅\)G녿(녿pRuffÿpQ  ppR
=
p33
=  \
=\)׿
\ÿpÿpÿͿ\)
p(zῙp=q\){
ffͿff=q\pRGH\녿\\xQ쿂\ÿ\

{
=녿녿33ppRpQ쿞R}p\=q\=q=qGR׿
=(HQ쿁G\)Q쿓33
=n{\)s33R\(    Q쿔z῕33zῌͿ}p{33
  =qs33G\s33\(E@  Gs33zHzHÿ\\c
+(ÿ3330׿LͿp׿
=n{G\(uxQn{fffc
z.{=qQGEY33LdzJ=q0׿+{.{33(>=qRk:HRz!G녿z&ff.{
==qz   zH
=B\>=q?^R?p׾aGff:=qǮ{þ(\\\W
=G׿   =qLC
?   ?
=q{>B\
{?}pkB\\)L;B\p<33zB\k#
aG=#
uu>>  B\?>Q?O\)?G?(Df?333?Q?\?=p@P  ?@  ?\)@\@&ff@u@Tz@333@.R@\@ ??0׿\)?8Q333>?B\?fff?.{>u?   ?
=>p?@  ?333?(??@  ?Tz?Q>G?#
?^R?Q?>H?\)?Y>>\>>33>{>
=>\>>>>>G>33>\?p?8Q?J=q?(@?=u>p>\)>=q>Q(R>\)>k=="\33Vffff0>  >{?@  ?+>>>G>>
>\)>
>??녾>z>>>u>k>k?&ff?&ff>B\?G?\)>?\?333?H >33u>Q>ff>ff*=qp5Q>p>Ǯ?R?D3??Q?  ?ff?aG?333?O\)?O\)?#
>Q>{>u>z>zD >k>{>  >u>Ǯ?ͿQ>z>uD#>(>Qk>#
>aGFff>u>L7
=9>aG7
=4z>{>\>
>u>z*H>B\#
KGQ?\)>?
=q?!G>ff?(???   =#
??
=q?@  ?&ff?z??R?\>(DO{??+??z>??>
^R?>\)>R>\)>p0  >33>{:=q>Q=
>
><#
>(>G>H?>\>>\>>>>?
=q>>pc
>H>;ffAȏ\?5??fff>>>z?  >(?>?!G?&ffHQ?\)?&ff>(?
=q?<(?(?\xQ>HQ?R??.{?333?L?@  =???k?J=q?s33?W
=?aG?G?@  ?.{?8Q?\(?u?E?O\)?p?p?}p???=q?G?ff?p?xQ?\(
=?\(?5?n{?\(?(?   >
>8Q=
?!G?z?+?#
??.{??5?(?:H?\(?W
=?R<
?:HQ?G?:H?@  ?B\?@  ?5?8Q?B\>>?B\??5?:H?B\?c
?Q??ff?\(?Tz?5?5??\>?}p?k?^R?+?!G?L?333H?p?&ff?G??u?s33?  =G?p?ff?
  ?u?fff?Y?E?+?.{?G?E?G.{?R?5?.{Dv?5?0?@  ?Tz?E?0?8QC ?\(?^R?W
=?LD>?J=q?s33?B\?B\?5?L?B\?E?G?L?8Q?0?E?@  <
?5?LͿ
=q?G?J=q?G?G?Q???O\)??c
?Q?W
=?L?Tz?G?G?G?E?zH?Y?fff?W
=?(?}p?8QC?k>k>ff>H?:HǮL(?(?L?@  ?G?u?h?hL(?Eh>RٙG??
?J=q????xQ?B
=?xQ??pDU?Y?s33?u?xQ?{?u?u?
A  ?
??p?
=?p?p?R?H@QG?{(?z??H?\)?@33?p?R??\aG>ff?˅?\)?(?\?  ?33??(?
?p@
@@
@ff?Ǯ?˅@ÿh?G?33?
=?Q?
??У?ff???
=??Q?H?=q???z5??=q?R????
=?G
=
H>8Q쿂\  ?H?Q?33?(??z?\?p?R?ff?  B(?H?(??33?Q@*HR?У??ff?=q?G??  ?˅?H=G?\)?zQ?=q?Ǯ.{?Ϳ  ???G3
Q?
==?(?@
?޸R?z?=q??˅?\?@	@"\@'@
=q?R?=?Q?
=?Q?Q?=q\)?
=??H?>.{@zὸQ?
=q?R>>Q@{#
@
*=q??p@@Q\)?@?k@ ׿=q@$z@.{@=q@hA=@
H@
=?@#33@*=q@(@(@
=q@@\@@ffAy@
@@=p@#33@!@\)Dz
@
=@W
=@p8Q@z@@:=q?\)@33
=@{-p@@
@@{@
=@@ff@@?z@!@;@p@R@(@H@(Q@ff@@=q@4z@33>G@@(@.R@+@(Q@*=q@,(@1G@(@   @
H@
p@;@@+  ?z@?z4z@ff0  @GHÿQ?(Q@R{@
H@ff>?  @@@\@!G@
pE8{@1G@8Q@9@E@-p@@
@z@33Eͅ@@
H@	@@'A?H?33?p=??
=LͿQ?
=?R?Q"\?(   ??z?Q<(?H@	@33
=q@  @(@   >@?
=q@@@ @@C@@@DDI@	@@Q@ff@@(C-T{@
=q@
p@@?
=@@33H@	@
=q@
H@=qc
@H@@33p.{G@@Q@
=?У@@?@33@@c
@@.R@+@(@ @?Q@'?\?
=@)?@\@
p@R@Q@
=@
@R@
@ff@(@z@	p?c
@@   @H
=?zH@
=?  @$z1@1@
@@
H@\)@   @0  @/\)@Mp@*H@!@#33@$z@6ff@>{@#
?aG<#
>@:=q@7
=@,(@=q@%@   @?\)?33@%@$z@(>@!@0  @1G@R@%\)@  @@%@7@'
=@$z@!G=q@\)'
=?G@4z@=p@333@7@AG@9@*=q@7D)?Q@p@G@JH=q@C33@@B@8Q쿸Q@=p@5?J=q@>R@8@HQ@Fff@:H@
p???G@
p@=p@-p?@HQ@/\)33@5@0@>{@<@<(@>{G?(@*H@Z=qAG
@   @r\@g@i?@XQ@P  @P@O\)@E@HB=@@@@@HQ@C
@P  @H@K@C
@Tz@L@L(@G@C33G@;@2\@ @1G#
@=p@fff@\@b\@N{@K@>R@:HG@>R33@\)@K@Dz@N{@8Q@#33@J=q@<(@<(@9@8Q@9@3
@A@l(@QBS@C33@8@;@:=q@E@>R@?\)aG@@D @K@,@.{@0>Q%@/\)\@@333@,@3
@5@+@0׿Rff?{@(?G@)@33?@=p@>R>Ǯ?  ?8QD3@ @!G@ @{0@	@#
D՝qDD
 @$z@p@#
@)@'@#
@ff@G@R@{k@ff@z?ff\)@׿\@%\)@@*=q@;@\)
@(ff?
=?@Cڙ@
p@?z?E@?\)@@\@HDC=@@p@@@(@@5@$z?\?p?=qp=q?   ?@4z@Q@R   @  @R@(@
p?{R@=q(>W
=@   @@@*=q  Ba@@33@
>{@@  ?z@z@z?z@1G@θR@,(B\?R,(@	\@@@@@
=@@=q@@  @p  @nR>
?{>z?HG@\)޸R@\)@
@
@)?Q>G@G\)@q@p@{@\)@{@H@@(@{@@H@
=@\)@@@R@ffD
H@@A@
@\)@@@  @@{@33@33@z@@33@@(@nR@\)@(Q@@
=@.R+@R@@*H@@@(@ff@z@
=@33@p@@@G@G@@@{@(@  @
@H@G@
@@@
=@(@@@@@\@{@p@  @?&ff@\@{@@Mp@G@@@@R@
=@@\)@ @@\)@{?У@@
@33@z@
@ff@z@@(@@=q@@@@H@\@
@@{@@  @(@H@@@@ff@p@\@z@\)@G@ff@@H@?O\)@~R@@@@\)@p@ff@\@@u?ff@@@@z@@G@@@H@  @@=q@H@@33@\)@@u@@{>@  @\@@@  @G@=q@H@?G@H@{@y@z@vff?@@
=@@(@@@{@@33@
@
@\@@G@\@\@@@@  @@  @@@\)@@{@\@z@zH@@
@@(@=q@G@\@@G@|(@zH@1@@|@zH@|@zH@\@@@@~R@\@@w@}p@u@qG@qG@w@r\@p@mp@xQ@w
=@s
@u@|(@x@}pD1@x@xQ@wA)@p@o\)@o\)@s33@jH@fff@e@fff@c
@l(@g@`@fff@b\@`@`@aG@^R@`@(Q@g
=@j=q@c
@]p@Y@\(@U@U@XQ@qG@k@`@W@S
@Z=q@R\?  @NR@@@I@W
=@aG@Mp@G@Dz@C
@E@AG@@@@@>{@;@8Q@6ff@333@333@1G@,@'@*H@&ff@!@@=q@
=@@	@
=@G@?p?\)??(??޸R??
?:H?
??\??{?G?Q?
=?
?u?^R?zH?s33?aG?G?=p?(>?>>\>{>  >>W
==ͽ
8Q쾸Q쿞RͿ0׿=pLͿn{Gÿ
Qffz33ff녿
=(
H{{\)"\+4z8<8C33G
=
QLR\\(ZH]p^{^Radzeg
=g
=is
mpr\r\Q~R|(Rff
=33H(Hz{ff{R  mp
=q=q  
==qQffR\(H(\)=q33(\)RHG\\)  

=pff{
=RGp(\~{=qphQ\\\)=q{4z
={33\p\)ff\)z
=\)s3333
({\HQz
=qG33A$(R

=qQH{Q33\)=qo\)\)
=\\Qp

=qHG>33ff=q  \)ffp{@\\)p  zp
z
Q{(p{  
QQxQ(ͿQ@?R@љ@ƸR@@z@  @\@@xQ@@33@H@@
=@\)@ff@@33@ff@qGAlQ@  @p  @~R@~{@ff@\@@~R@zH@G@|@G@@ff@=q@|@tz@
=@(@@G@~{@@Ϳ\?k@
@@33@\DsB%@z@zH@5@1@ff@QG@?fff@ÿ#
B*RBPR@p@(@Q?@  @H@=q@z@@z=q@@@  @Q@@@ff@R@z@@Q쾔z@@\)@@@p?=q@~R@@Q@  @|>Q@@H@
@@G
=E{@ffD
@<(@
@z?  @\)@
=@ff@S
@@@
=@G@@{@{@  @H@@A@AG@@@Q@@@p?G@
@@
@9@@+@p>B\CYq@w
=@@%DB@@z@=q@@@@}p?Tz@@p  @G@>8Q@@{@Q@p@G@@p  @{@u@tz@p@u@n{@nR@G@zH@@z@@  @\)C#?+@ffD3@w@B\?H@xC@s33?
=@@@D
@@Q@33@p@R@?
@G@@  @@@p@z@@R@|(@|@p  @|(@}p@g
=@u@u@qG@qG@c
@W@y@y@s33@p@j=q@r\@\@}p@@
=@@
=@=q@@j=q@s
@hQ@c33@xQ@G@=q@\@x@G@  @\)Az@k@   @x@vff@{@=q@nR@mp@s
@z=q@\)@"\@ZH@.{@^R@b\@q@`  @(@X@vff@s33@n{@n{@l@o\)@nR@o\)@k@p@hQ@fff@n{@n{@q@n{@zH@i@fff@#33DpC޸@ZH@Y@\@Y@U@S
@XQ@Y@R\@H@A@Z=q@333@=p@G@>{?\)@333@?\)?\)AG@8@.R@0  @,(@(@=q@@@33??У??Q?˅?\???
?R??  ???  ?c
?^R?W
=?5?c
?5?+>G>\??  =.{=q?\Hz&ff
=\J=qQ녿}pÿQ쿣
\)G\ffB^ٙ   \ff  QRpR'
=%'(#
p( 
Q'+)!l#33'
=:=qQG/\):=q8A@@J=qEN{W
=Q:HIQGL(^RP4z#
HQ[PXQNRJHQGUW
=XR\Ib\ejH^RWh`Udz~Rr\pW
=[`aGlh`  n{hljHj=qhQihhg
=Hc
X[W
=\^{h`  aa`  MpeVffc33IXQUXQdz]pU]p^Ri^R(fff_\)Ff\^Rb\[qG~{mpptzww
=p  pr\khQNRgC
i[QxeUER\Dq=qFvffffDS3D'"o\)0  =p@I.{L(Be
=>{33p  R\
=n{U\(g
=g
=\)ff|(]phQfffZH_\)\(MpGG
=YK<(aGL,(C33@  QG  4zs
Dz=pJH0  \P9AG;Gj=q{?zCNRb\EEE=qCs3C
JH]pp  <LEqGE[Fff7>{=pHQMp^R>RTz)*H?\)("\   '
=#33)-p,'
=1"\333/\)&ff"\jHhjH0  dzL(:HAGk5UKXpDzZHL(|Z=q?\)7?\)333@DzDz@  N{AvffZHZ=q:H<(?\)\Fffc33S
QGJHC3353
1N{8Q,8QXQ/\)1B\(,(  0  :=qL(B\:HE^R=p,(XQRC]qIN{|(=pC*=N{=p.R\)<333AG,>{G
=D  72\4z0(
=\(1/\)'333=q\)#33GD{#
CϏ\u GP  e<C+)/\)/\)ll(O\)#33&ff4zJ=qHffU\)˅
p.{@5&ff333.R)e<&ffRpHQQ!Gj=qz!G\)1q8]p/\)z7
=Q=q;l=ql(hQ쿅\(Qc
{p),
=
H
aJ=qzC
ffA\)33H33\){hQ;(2\eAG=q0A  S33b\NR!GeCWJ=?\)(33c
*HG(	R\\tz
=   C^(
HBu
33\)}p	\)R녿4z@io\)
=ffQGl(ff33@B\n{W
=\)У
G=qQ
=\)(
={RͿ
=0  l($z33(\),ͿffE=qEu\)  ZH!G,(,(׿H.Rz
p6ff(
={\)$z33!G   G  pp
=  =q׿33(33p'
zУDoc3޸RͿÿ333G
(DhFU)\)(G
=q5
=
H5?{=q=q׿HpB8Rÿ(ͿͿ녿{ÿ
=
=
=RGУ׿{G(Q33D
=qS33׿z{ÿpIS

=8Q쿬Ϳ\zdzΌ=qzῠ  ׿\33p
=+333
(ͿͿ3374z!G
=LͿ
=q(<#
33B\>Q?&ffУ
>u?:H>
=qͿ  }pLͿB\L*Hc

=z
HC63p(33=qH  ÿGͿ}pff{:=q\ͿHS
\)p\)zfftz=q녿u  %|ͿR\)ff@׿(=qG
=z῅Q쿡GQ쿥pJ=qÿGzHk'Q@׿W
=R(E녿^RTz7
=ffͿ:Hu33:H=p{zH@  }p\);c
Q쿈ÿ녿s33zHB.\kh>zE
=Ǯ녾B\8Q쿥aG333333.{S33ES
R#
\\ff{   #
\)H=
33\)
=RL;kG\0׾Ϳpÿ
=   Q<
B\{\8Q     )Q>33z(
=q,Ϳ  ff{aG>B\>aGGG  Q*=q׿\
ffR
=;ff+=
>z>þ;RQB|pGǮ=q>ffff=
33#
B((
=5!G}p
={H
>8Q>p<
\)\	&ff?B\c
 ׿#
pp׾(  Rc
%Q쿺H!G\B=RD=q!G>uff!G;HQCd׿&ff&ff0׿
=(.{Ǯ?녿\L;(33'ͿQ녿G>=q?
=5@G
=.{׿
=hÿp׿p׿녿{RxQ쿺H\  B>33Q녿\(YzuTz333333C3ͿQ녿kpaGQG{
  0׿H
33z`\)S33
=p׿Ϳ׿\u=q
=\)ÿA녿(p׿S
  GD!HÿQ쿏\)ff.{ÿͿzH

zH
W
=s33p׿zΐ33
=˅׿HͿ\=qGs33=ps33GCuB5{!G\녿녿ff<(ÿu\QEQq.R33Ǯp#33ÿ\)
-pR\녿{G33zDzῗ
=P  
=fffHW
=Ǯz7z῏\){33H׿N{ÿ{Ϳ  CS#33s33GCGs33Rc
xQ^RJ=q=qp׿n{
=ÿff#
z῜(޸RRMp.RQУ׿Q\)zTz ׿HqTzῐ`  
=5@R)(=q녿G=qp׿ÿ
{z῔zῙff(ff(ͿffN{33\\)\Hp  ÿp?R?G?
?fff?{?z?޸R?ff?p?{@?
=??@
p@-p?
@@{@i@vff@NR@"\??@C
@8@@\??
>{>>=q>aG>=#
>8Q<>>u>aG?33?
=@ @
=@=p@7
=@:=q@i@{@@љ@=q@θR@z@
=@@A
=A!@ff@z@\@{@ƸRA
GA\A z@p@УA
=A
RAAAK\)@\)@33@@˅@
=@@
=@@
AQ@\A=qA"=qA{@@A@=q@Ap@R@H@@ff@@@@R@@{@G@@GA"RA.HAEpA<A*ffA@
@@  @ٙAA
AA&\A zA<A.=qA zA8  A:ffA,(A%AAQGA!pA(AAHAA
AEGA"H@p@A
A
@=q@߮@\)@@ҏ\A=qA\@H@A AT(AVffAaAYGArRAHAs
=A^HAXzA?
=A/
A1pA!pAEA;
=A6=qAQA5A(AEA/A.=qAA&ffA A3A2=qA*\ADzAA-A#\)A@@
@p@z@@p@Ӆ@@{@
@GA	AGA((A!A$  AW
=AAARAAHARBpA{A¸RA{A\)A(AHA\A=qARA\zAQAJ\AJRAYAo
AxzAtA^HA[AlQAA`(AK\)AIANffAO
ADQA8(A
=A
=A  AHA&HA-A"HA  AYA^\A-pAEAR{AvRA\AAAzAzB2A  AAARA  AA
=A=qAs33AuA{33AAfHAt  Aw
AdA\AWAG33B RAiAr{AqGA
=A=qAYA
GA7A(QA4(A?33A.ffA0zA0QA-A4  A>HAHA=qA  AQA7
A4A2HAA'A*ffAXQAo
=A
=AvffAhAtAuGApAIpAX  ANffAYGATA=AApAp(AYAUAd(AzAW
=AF{AJ=qAdQAGAAjHA\)AzAQAWA6=qA
=A (A#
A.{AK\)Ax(A~RAr=qAYGA]GAo\)AzAW
AX  AMAIpAL  Ag33AAQAvHA
AA(A{
As
=AAyA\)AAHAx  AvHApAoA|zAl  Ab{AW\)AZffA[
=AGAApA?\)A  AX(AX(A[
=Ag\)Ak\)Ad  A"ffA/33A4Ar=qA2HAAaGAHARA|(AffA33A  AffAAzAHAAffA\A  AApAGAAAARA|A|(ArHAlA
AAA{
=Aw33AQAAAzAf\AwA~HA`zA:RA&RA(zA-pA)pA,AG
=AMAP  AkA[AfffAffAAAzAA33AAAffA
=ARA  A=qAՙA  A(A
AəApAA癚A\A  AЏ\AAHA؏\AAAɅARAypA{AoAAA
=AAGAAffA  ApAAffA
AA{AAA=qA=qAA\)AAGA{AAGAA{ApA=qAAffAQAAîAA  AA  A(A
=AAA  AAGAHAAA͙A\AAAəA㙚ARA(B (BA
A㙚BBGB	{B  B#GA  A{B(AHBA\)AA33A
=A
AB
A
=ApB\B
BApAAGAffA\A33AA=qAA\)B	\)AB(B\)BpA\B {A33AQAffBB\)B
=BBffB!\BT33BWffB?B<(B+B3HB-GB1HB+B?ffB:\BEB2B3B%B(=qB!RB;pB B3ffB"zB*BBffBB&ffB zBB
=BB\B1HB6=qB-33B:RB"HBHBB(BffBB/33B)=qBB-B*
B'B9QBFB[33BbQB?B:zB;(BAB<zB@RB:  BF{BB{B6B9B:B4B5{B.B*  B4(B2B0B6\)B2BK{B=
B8pB8(B+QB/=qB(HB3B4  B?RB?\)BC=qBFpB=
BDBJB=HB:\)BGRBI\BCzB>(BDBGHBGB(ffB<
BP(B8pB3GB4B?B:HB5B1  B3ffB7B>BE33B;B9HBCHBP33BI
=B8=qB@RBNHBDGB<pB733B5ffB?RB6ffB7RB-BD{BC\B4B7\)B-\B*GBGB  BB!BBGBB
=B\BBBB&{B)B&pB(QB)
B$pB$B#(B*pB@zB033B2B9RB>\B;RB@\B<{BK=qB@ffB<RBHBE=qBKffBIBM\BGBO=qBYQB\BRBUBDzB>
B.  B2B5B:{B133B1{B%zB-B/\B2ffB6B1=qBCBGGBNpBUGBWBDB!(BB(B#B(33B*B1B>B<zBFpBD33B?{B@HB@GBBBBBD{BGGB=ffB9pB8B?{B?HB;HB=pB=\B;\)B5
=B?BE
BD  BL
=BA(BAB;33BBRB<  BIB>B.QB0BAB4B;\B:RB=B633B>33BABa(B[BKHBH  BL33BKpBSQB\BT33BLBNBO
=BN
=BIBN\)BTBQBR
=BOpBgQBcBdB_=qBXB](BlBYBHffBJ
BD\BF{BQRBNBTBWRB_Bh(Bz
=BezBaBZ(B\33B_33BZBcBcpBNHBF(BNBopBVHBTBV(BURBXB`HBc\BZB^=qBe\)Bp(B^
BcBaBcGBdBfffBf
=BqGBnBrffBo(B^GB`Be=qBdQBa
Bm=qBmQBeBOzBPBLHBSBT(BVBO
BTHB_RBiBkBpBn
Bw\BdB_HB^BdBk=qBq
=BvHBxB{
=B~  BBB\)BBǮBfBBtBuBzBvBnzBp=qBB|33B|
=B|pBB
B(BB
B8RBw\)BuHB{B{B~BsByHByB|GB}BBuBBBLBpBkB~RBB3B\BQBLB
=BBBaHB\B(BW
BpB
=B BHB
BBBpBB  BHB(Bc{BfGBjRBjBmBu(B=qB{B
=BB~BB.BffBfBB\B8RB
BBB
=BzBB=qBBBBBBBuB\B)B#B
=BB3B\BW
BuBHBuBBLB.BpBHBW
BLB\BRBQBB  BBkB33BBB33BBzBzBBW
B.B=B B{BB{B\)B=BB8RB)BBB\B
BB{B\BBBBBffB.BBBǮB33BB3BB.BRBBB{BBB#BkBQBffBaHB{BGBBBBBǮB BB
B=BBffBqB3BfBRBBB.BBzB BLBfBB BkB  B BB33BRB#BBBBGBW
B BBBqB
BB=BB\)BB.B33BHBW
BB  B
BQBW
B33BBBLB BzBRBB=B)B)BB#B\BuBB{BpB8RBB{BQBaHBBuBǨBBBBBaHBqBGBaHBW
BGB=qB=BBBB{B=qBfB  BBBǮBBB8RBB£BQBBBƙBʙB\B\)BzBˣBaHBƙBaHB
=BpB.B=qBǮBGB
=B՞B.BBҮB\)Bˊ=BBB#B
BƞB˅B\BǮBBBBW
BBLB33Bϊ=BQBBΣBգBўBW
BǮB\B\)BǮB8RBݨBޏ\BB{BpBBRBB癚BkBfBBB#BBB枸B=qBffB33BBqB#BBfB8RBؙBB33BzB\B۞BBffB#B=qBBGBB8RBBBۙB݀ BGB\BמBzBkB؞B#BB)BBB۔{BB\)Bس3B#BkB
=BרB\BpBGB޽qBB33BޞBBBB{B=qBBuBBuB
B8RB\BBBBQBGBB#B\)B
BǮBBBpBaHBBB  BQBW
B{B\)BBW
BǮBkBQBB=qB8RBB\)B\)B
=B
=CC C	uC
C#CCٚC\C	=C CnCGCCCJ=CC	!HCCGCO\CHC33CT{CqC(pC-C޸CC&fCCC8RC
CC)C)CC
C
C CCCkCzCC xRB=C LC CQC
CaHC(CǮC޸Cf?z?33@Q?@*=q@&ff@@\)@1G@vff@@G@
@p@@
=@
@@@\@33@\@\@@@
@@ff@@
@@z@~{@@|@@mp@^{@9@2\@7
=@  @\@(@@!@\)@/\)@?R@G
=@X@@JH@(@   @.R@HQ@>R@A@W@O\)@[@r\@w
=@A@<@<@Fff@ZH@G@R@
@1G@:=q@C33@S
@C33@1G@>{@(@H@A@*H@?z??\?z??h?33??(?
=?(??p?z?
@  ?(?
?  @0  @
=@\@qG@^{@e@^R@g@g@hQ@\(@g@Dz@<@ @(@8@#
@>R@9@'
=?@%@%@Q@@\)?G?H?33??=q??=q??z?  ?=q??=q?c
?\(?O\)?  ?Tz?
?Y??\)@@P@e@c
@dz@@33@33@{@p@@
@|(@@w@i@p@vff@w@b\@K@*H@'@
H@@R?{@
p@   ?R@
p@
=@AG@QG@L(@ @@@   @p@@ff@,(?33?@{@ @L(@H@
=@\)@H@
=@{@QA QA
@ffApAffAR@@
A\AR@p@\)@\)@@@ʏ\@@@@{@u@u@k@=q@S33@C
@l(@R@H@33@@ff@R@@H@ff@  @  @ƸR@{ApA
pA.=qAAGAB=qA\AAGA33Ak33A`  AXzA7A^{AEA8zA:\ADzA6HAIAEAEpA8A'
AffA'
=A,QAEA,A)A33@߮@@H@|(@=qA	G@G@=q@AAA-A AA)pA#
A3
AQAtzAA
=A{
=A\AffA(ARAzAHAffA(AAAzHAk33AH  A(  @G@@  A  @33A
@  @@A@
AAAA#
A	pA
A$  AAA
=@R@H@z@
AA=pALAR=qAw33AAo33AAc33AzRAAAS33APAUANHAV\A(AC\)A<QA7
A33AA@ffA"=qAAH@AAHA  @{@p@33A@@{@z@@\)A{A{@@zA@@QA$QA3
=Aj\?ǮAQ@
=@=qARAA zA;\)A)GA
A AA/A%A\)@@R@
=@(@@@z@p@@@@@=q@@(@@@H@@aG@333@^R@=p@~R@ڏ\@zA$(A+\)A'A4QAD(A\A@
@@@\A@zAA=q@{@@QA	@ff@zA@
=@Q@=q@G@R@@@=q@
=@zH@tz@.R@(Q@<(@-p@,(@7@&ff@@@@H@2\@E@L@'
=@E@$z@`  @"\@@=q@@@A\AR=qAhAaA<zA6ffA=q@=q@33@  A@
=@AA QA%p@33@z@\)@  @H@Q@\@Q@Ϯ@Q@@@@ff@
@=q@(@ff@@z@w
=@z@z@33@\)@@p@G@(@zAA"RA/AiA=GAzAj=qAipAiAP  A9A%GA#A
=A Ap@@{@@{@ָR@  @z@\@
@=q@z@\@H@@@@  @jH@]p@XQ@Q@|@p@Q@@x@G@@33@Q@R@(A(A   A@\)A
=@R@@\)@@(@@z@p@ff@33@@  @@(@\)@@~R@xQ@zH@o\)@tz@\)@@R@\@tz@^{@]p@3
@P@p  @H@{@z@  @\@~{@@z@@@  @\@@GA  @
@@@33@(@@@
@
@R@33@\)@w@@
=@@u@u@@zH@r\@i@  @Q@
@@@33@z@@@p  @g@W
=@e@tz@XQ@b\@Mp@g@U@E@H@<(@JH@9@U@G@P@2\@'@!@@@\)@
p@?(@	@@G@G@?
=??=q??˅?Q???=q?  ?H?\?  ?p??ff?????\)?H?p?
=??R??=q?\)?=q???33???H??  ??p?=q??p?{?{?\)?Q?H??  ?
=?Q?33??\)??
=?????z?\)?k?aG?k?h?p?W
=?Tz?O\)?Q?^R?G?s33?ff?{?{??=q?
=?@,@   @
=?{@$z@@(@
@
@@ff@#33@B\@<@ @@(?  ?@  @?R??p@?\)??  ?p?ff??У?(?޸R??G?\)???G?z@R@s33@e@}p@`  @~{@@,(@C33@   @%@^R@x@r\@e@mp@QG@Dz@1@tz@zH@~{@~{@p@jH@c33@@@G@g
=@\)@(@?ٙ@Q?˅?z?(@33?
=?p????޸R??z?Q?33?Q?z@\(@W@
=q@@\@)@
=@@!G@&ff@*=q@,(@>{@g
=@]p@???\)?z@
=q@(Q@C
?Ǯ?{@@  @<(@,@?H??\?G?\)?\???
=@
=q@%?@  @@C33@C33@Tz@b\@b\@qG@e@l@K@%@L(@E@Q@\)?\)?33?33@2\@,(@'
=@)@@R@1G@8Q@,(@=q@=q@{@G@@R@
?(??H?=q?p@@  @@G@	?@
?޸R?˅?\?ff?\)?У@@
H@@@@?ff@\@
???(??G???z????  ??(?G?Q?Q?=q?{?z???
??33?=q?ff?R?G?\)?}p?zH?
?W
=?O\)?p?B\?E?5?\(?h?n{?p?&ff?k?L?8Q?!G?.{?#
?fff?:H?xQ?u?h?Y?:H?0?
=?(?(?(?Y?=p?Y?E?s33?J=q?c
?n{?h?^R?\(?333?J=q?z?O\)?R?fff?s33?\??h?zH?\??
?
=????Q?У?@\@
p?\)@
??G?˅@y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ?  ??z??zH??\)?H??\?
=?Q??\??
=?{?Q???z?  ?  ?ff?\?\?
=?R?ff??
?R??=q?Q?ff??(?s33?
?fff??33?H?  ???z?ff??\?\??xQ?^R?p?Q?n{?c
?Q?fff?k?c
?h?Tz?W
=?^R?^R?L?0?333?:H??R?
=q?8Q?8Q?0?@  ?}p????(?s33??k?p?s33?G?\)?\?\?(?{?\??\)??
=??=q?
=?Q?Q?
?{?  ?zH??=q??z?h?\?ff?xQ???ff?
=?H?z?z?  ?p??\)?33?G?(??ff??H???
???{??  ??
=??z?R?Q?p?
=?G?{?
?
=?ff????p?R?
?  ?p?ff?z@G@{@(@?@C33?ff?\)@\@Q?@33@  ?
??8Q?R?ff?z???R??G?H?Q?(?H???{???Ǯ??p???Q?=q?H?Ǯ?G?Ǯ?
?˅?\@   @z?{?{??  @   ?p?ff??ff?(?c
?@??
?33??Q?(?Ǯ?ٙ?{?Ǯ?{?\)??Q?
?G?{?=q??@.R?(?
=??  ?ff?\?z?
=?33?G?G?H?  ??H@
=q@  @QG@|(?@@WA
@r\@@?R@ff@@k@=q@@33@@@33@
=@*H@)@@@ ?(?\)?
=???=q?@ @
p@@?@	@G@@33??@33?޸R??Ǯ@@(@?@
p@
=q@z@?\)@ff?@2\@
=@I?33??\)?ٙ?p?H?\?\)?˅?G??33?Q?
=?G??=q?G?G?p??
=?p???????ff@G@\)@@(?@,?@0  ?@@ ?33@6ff?@$z@Mp@H@@L@1@s33@R??˅?Ǯ?G?˅?
??(@u@c
@@\)@\@n{@H@J=q@g
=@N{@E@W@Y@Tz@N{@E@W
=@<@,(@\)@(@G@!G@$z@ @@{@#
@Q@@G@ff@@*=q@?  @   ?H?ٙ??33?Ǯ?=q?G?p?(?H?ff?
?ff?
?(?(?33??
=?
???G??zH?
?n{?p?h?G?{?\?Q??  ?Ǯ?\??G????(?  ?aG?aG?\(?B\?Tz?J=q?s33?p?G?  ?fff?Tz?k?B\?333?E?@  ?#
?Q?Y?:H?^R?aG?zH?L?=p?\(?p?E?Y?!G?(?=p?.{?
=q?.{?H?=q?\)?33?У??˅@\@?R@@
p?33@0  @	??p?H?p?{@  @@(?
??
??R?
=?\)??  ??33?z?=q?33?{?ff?h?n{?k?R?z?
=?
=@!G?J=q??W
=?\)??G???p??޸R@@+?=q?
?
=?\@@z@?(@7@>R@333@.R@\@nR@<(@l(@HQ@}p@R@\)@\)@
@G@@z@@@@|(@jH@K@8Q@,(@   @?\)@%@@\)@p@!@!G@O\)@Tz@g
=@E@<@5@\)@(A
AA A  A=qA!A;A`A<(A733A#\)A{A  AAffAG@
=A%@
=@@{@{@@@
@p@@@@H@\@Q@n{@ff@zH@
@@@{@޸R@  A{A\)AA
=A$QA2{A<zA'33A  AQA&{AAAA&\A	@z@pA@Q@G@  @33@@R@(@=q@p@@33@p@33@@˅@{@@|@\@=q@(@o\)@ff@H@*H@(@E@I@W
=@Z=q@e@ff@\@@陚@@{@@33@G@(@{@أ@ff@A  @{@z@@Å@G@  @\)AA=A(zA#33A(@\)@
@ʏ\@\@\)@@Q@
=@\)@
=@H@
=@@@ff@33A
ApA)AQAA{A
A0(AK@@ff@ָRA\)@33@
=@RA Q@pA@@p@@@@  @=q@@H@G@@@{@@\)@|(@}p@@h@\@E@]p@a@mp@@Mp@8Q@\(??z@"\@@@@
=@W@n{@@z@(@\@w
=@[@K@9@;@E@JH@E@{@G
=@G
=@Dz@7
=@G
=@?\)@dz@\(@l@{@?\)@HQ@5@+@&ff@@"\@p@p@?z?z?G@
=@?\)?33??@@G@?\@,@9@p?R@Q@Tz@>{@?\)@;@-p@@@  @C
@!@#33@(Q@(@@ @Fff@@3
@E@Tz@j=q@3
@#33@.{@.R@2\@/\)@
H@?p@\)??{??R?G?G?˅?=q?(?
?ff@ @
H@{@HQ@>R@qG@MpA@
=@=q@  @@  @
@33AB{ApA	GA\)AOAUAEA2HA((AQA@@=q@Q@33@pAIp@@ffAA;
=@@Ac
=@{@@GA\)AA$A\)A2ff@  A"R@  A"H@=q@\A,A@(AWA{A
ANRA|AA/\)AUA'33A&=qADAARApQAL(ADAw\)AqAz\AAOAPAIAX  AA[AQA
=AHA(A33Ac\)An\A=qA7\)AmA
=AKA
=A
=AzAAAGA  A\BB{BRB,=qB*  B]BBBNHBC33BT  BLRBA
=BY33BDBwB,B'BNB833B7BRBXRBKB$BffB*33B9BQBNBGB*GBA=qAzAO\)A:=qA8AAGA=GAA  Av=qA{ApAA
=AQAffA=qA\)BB<
BAffB/33B"\BV  B4B33A
A\)BAB"B$QB>  A(BB  B.BHB!GBBzBQAABffB	A\)A33A=qAиRAA\A|Ak\)A(AGA\)A  A\)A\AAffAƸRA=qB QB{B\)B
QA=qAAۙApB B{AffA
=AA\)BmpA\)AHAffABGABA{BBzB	QA\)B
BffBB BffBB (A  AAzA\)AAffAAA
A{A(AAAծAŅAAA\A=qBHB

=BABRBffA{A\)AA\A(B {AQAApB	ffB  BQB
GBB$B	33BBAAHA
=A
A
=AָRAAHAHA(AAA33A33ApAAAݙAA\)AAB\BGA33B=qBBffBAffB33BB=qBBpB,\)B  BBHBBB
33BB
=BBB{BQB$BB
AA(BRBA
B	ffB33AB(ABBGB	B
B{B(RB)GB;BpB\B"B/B$pB-B433BHB)B\)B"(B:BBB>\B6GBBB6B]B7GB1{B?(B:33B;B0pB.BN\)B;BARBE\B&HB9{B.B>B:B)RB,B?B-B*GB.
=B)(B'B0B0(BYRB@ffBI
=BiQBXB~  B9ffBD=qB>
=B-{BKB;
=B?
=B8ffB=B>\)BCBKBEBO33BMBQBPB[B^BWB\
=Bi
BhBeffBe=qBvB}
=B  BtBzQBsBnBp(BeBhHBk33BdBYHB`B^
BNGBVBfBhzBw
Bp\)BqQBrBoBgBi
=BzB  ByBBx
BizBBBBBB\BLBuBqB)BB\)BBW
B{B.BBB#BHBkB(BBzBBBǮB=BB\BB\B=BBaHBBB#BffBBBpB(Bz\BzRB}B|BBB|GB}GBy{B~(Bu
BsBq\)Bw\)B}33BfBW
BsBQB{BB.BBB\B)B\B=qB\B BLB
BB#BQB|  B{=qB~\BxB~  B{HBqBgBhHBd\)BUGBYQBbpBp{BkBozBxBBRBBBQBBLBW
BGB#BfBBGBBBBBЅBBkBBBqBLB  B\)BBBBB=qBfBBeB_\B]pB`
BBήBBBBQB=BqBB{BBBpBW
BaHBLB#B33BОB
=B.BpBBBffBBBB=qB33BzB\BBffBW
BBRBB8RB~BzBz
BwBrB~Bm  BxB\B
=BffBQBBBBB\BHBHBHBBBBByHBx{BBBBBBffB\BBB8RBuBBBpB{BBQB  B)BuB
B  BkBRB=BaHB(BBB(BBRBaHBfBB.BBW
B(B\)B BB
=BșB{BBBW
BBB
=BBB33B8RBB B
BfBaHB{B\)B(BBBBBQBBBB  B BffB{BBBB\)BBB{BqBqBB BBBW
B.BBW
BBBpBBkBBBBBuB\BQBBBB=qBffB
BGBBBW
BpB(BB=BLB\BRB\BQBaHBQBBpBHB
B
BBBGBBB\B{B\)BLB3BBfBBBzB\BB\B\)BW
B{BB{BB\)BzBkB3BGBaHB=qB{BǮBHBBffB
BBqBBGBuBBBBuBRBBzB\BkB
=BffBŞBaHBHBمB33BaHBBuBɞB)B  BŊ=BaHB33BLBBqBB\)B\)BBGBBBzB\)BBǮBqBBBBBĀ B#B#BGBBBkBQB̀ B33BfBɸRBǮB=qBB׏\Bۀ B(BuB.B3B{BB\BzBB{B  BBGBB
B)BǮBpBW
BBB8RBGB8RBٔ{B=BLBBffBꞸBɳ3Bπ B\BŅBffBυBήBπ BͽqBB{BpBBB
BB=Bŏ\BpBŏ\BĽqBaHB BBW
BqB=qBaHBB.BGBkB
=B33BBzB{BB3B
=BHBBaHBffBB8RBW
BB3BBLBB(BB B
BW
BW
B{BBRB{B=qBBGBJQBKHBSQBWzB]=qB`B^
=BWffB[ffBa=qB`B_
=BdBlzBr
=BwBk
=Bn  BhHBrGBrBsBhB33B(BLBRBB8RB\BfB(BfB.B\B=qBBB???@@?Q?33@*H@)@&ff@@
p@@:H@7
=@0@-p@@G@
=@
H??
?ff?
?p?p@	@G@ @ @	?33@
?@ ?z?33???Q???R????ff??  ??}p?^R?H?{@G@@  @	@
=q@H@*H@A@
p@ff@ff@(@@!@@0  @7@1@2\@=q@	@Q@'
=@"\@	?(@ ?=q@??У?@1@9@8?@\?{@@33?(@@	@z@@
@(@<@N{@.R?\)@Dz@i@33@jH@H@\@@Q@~R@R@|(@>{@O\)@U@`@u@E@)@@\@=q@#
@   @"\@@\)@????@H@=q@p@(?  ?R??=q?\)?\)@@.{@S
@vff@33@`@
=@p@  @{A\@33@^R@
@xQ@{@@@mp@@@@@ff@@x@Q@@@O\)@O\)@b\@Y@Q@c
@c33@0  @'@`@'@\)@7
=@z@p  @_\)@Q@(@<(@z@
@˅@{@\)@θR@q@^{@`  @r\@H@A2{AG@H@Q@@@@33A=q@=q@
=@H@@@G@@@  @@Dz@{@Y@@;@Dz?=q@G@@@L@W@(@\)@@ָRA(AEAKAnHAH  AtA0(A7
=A/AL@(@\)@A@RAzAyA+APA
=@@=q?  ?c
?p???H?\)?>?(?8Q?xQ????=q?\)?G?ff?@ ?(?H??z?
=?(?  ?33????
?{?H??(?ٙ@33?=q??G?ff???  ?Tz?=p?(?.{?
=?Y?W
=?Y?fff?33?R?\?(?0?5?{?p?z??Q?z?z???\@\??Q??
=?ff???z?У??(????{?\)?????=q??^R?c
?O\)>>G>ff>>u>>=q>\)>>>Q??@  ?  ?{?@Q@@@  @(@@ @'
=@(@\)@?z?R?R@Q@\@?R@????\)?
=??(????33?=q?p?p?\?Q?
=?J=q>p>>>G>{>=q>(?z?:H?5??c
?Q?fff?\)?Q?=q??\)?=q??  ?G??=q?  ??=q?\)?(?33????=q?Tz?=q?
??p?aG?O\)?Q?   ?   ?>{>Ǯ?\)>>?B\?aG?aG?{??
=?33@@(@=q@\)@33@@(@ff?Q??Q??G??p?{?ٙ@?ff?=q?z?\?
??????z?
=?ff??=q?R?#
??z??
=q>>  >Ǯ?5?G?u?xQ?G?xQ???\??H?
?{?z?\(???\)??^R?W
=?c
?8Q?\(??n{?B\?:H?@  ?#
?\)?E?(?=p?Q?
?Y?R>ff>
>{>H?   >Ǯ>aG>  >Ǯ>33?E?.{?\)?u?Q?H?  ???H?
=?Q?(?G?s33???aG?h?  ?L?^R?L?n{?G?L?333?O\)?Y?  ?ff?h?zH??p?L?(>>Ǯ>>G>
>u>Q>\>R>L>>33>\)???=p??=q?33?  ?p@33@@   @ ??33?  ?H?z??p?
???\)?(?  ??Q????ff?xQ?zH??z?(???\(?(?.{?
=>>
=?\?R?0?.{?(?\(@?ff??
@@dz@o\)@w@O\)@G@)@*=q@,(@=q@
@@z@(@@@\@	@
H@
p?ff@	@Q??H?Q?H?(?
?h???R???O\)?>W
=>(???k?\?p?@{@6ff@
p?=q?p?@@?\)@\?z?z?R?R?ٙ?У?{??R?@z??ff?p?\?H?=q?
=?=q?
=???O\)?n{?\?aG?
=?333?#
?&ff?0?>?0?k?G?\?ٙ@@*H@>{@`  @Y@QG@:=q@Q@6ff?
=?=q@
p@R@5@33@\???Q?޸R??ٙ?\)?\?R?R?R@G@G@{@   @
=???\?޸R?zH?xQ?p?\)>?p?333?\)?R?33@@'
=@@Q@@+@z@+@1@.R@B\@G
=@9@.{@@?\)@XQ@8Q@+@<@@*=q@@=q@R@@@&ff@?Q?R?{?z??R?O\)?h?\)?&ff?33???Q?xQ?u?Q?ٙ@
=?=q?(?H@$z@8Q@l(@<(@@ff@\)@=q@ff@fff@XQ?z@#33@	@33??p?R?
??
=?p???  ???  ?33?У?33??У?\)?  ??\?\??B\?p?fff?R??@<@@@G@R@
=@  @=qA   @޸R@@p@[@:H@G@??\)@@
=@?p?\)?{?G@ff?\)?=q?H?{??
=?(?33???aG?aG?Y?.{?8Q>?
=q?333?(?L?h?(??
?Ǯ?@
=@
p@@=q@?
=?z??p??{?
???ff?(?G???Q?  ?
=??(?
?z?{?  ?aG?  ?G?J=q?(?h?G?u?(?&ff?+?B\?Q?  ?\(?  ??G@U@@QG@'@O\)@Tz@y@L@B\@*H@!G@p@@R??
?\)?(???H??ff??\?z@
??\)?\@ff@?=q?ff?У?  @k@z?z?p@!G@s33@@\@Ӆ@@1@C
@@@\@q@@jH@`@@(@@@H@@
=@  @{@z@@@1@:H@L(@E@.R@;@W
=@5@5@:H@1G@@@A@H@S
@e@L@O\)@R\@ff?H@
=@1@@_\)@J=q@w@z@@=q@=qAR@p@ff@Ӆ@
=AAG@ٙ@@љ@ʏ\@@@(@{@|(@@ff@z@{@  @Q@@\)@@p@@@@p@R@{@\@u@z@=q@P@qG@R@Ǯ@@33@tz@n{@33@AA*=qA/
=AqA^HAD(A_33AAf\AUpA$  A(@hQ@A A
=@z@33@Q@H@R@\)@\@H@R@@33@\@@}p@JH@p@(@<@Mp@@@qG@=q@@\)@\)@@z@ff@\)A!GAl  A`zA=qAA  A#33A
AHAQ@H@R@(@u@^R@k@H@p@ff@}p@{@w@@\@!G@b\@Z=q@W
=@A@%@@p@,(@
@=q@|@@H@;@k@u@\@ƸRA	A\AHA33@{@θRA,zA$  A(@
@hQ@@RA (A;
=AaA/
A33@\)@j=q@H@e@Z=q@i@JH@@@G@  @AA!p@@@z@-p@=q@H@@
=?z?  @
=@&ff@U@\@Vff@c
@#33@A&=q@R@@H@ZH@U@@
=@6ff@`@!@z@{@  @qG@@33@@R@g@  @X@J=q@@z@=q@`  @xQ@%@
=@AG@
@Q@\@
=@\@@AQ@@\@p@H@H@@Z=q@Q@S
@6ff@[@E@{@@ڏ\AA33AAAA&=q@ٙAp@(@
@H@"\@z@Fff@Tz@\@w@@@]p@+@z@
@p@	@#
@S33@@&ff@L@0@@!@z?ff??z?ff?=q?Ǯ?z?=q???@0  @N{@b\@=q@z@H@g
=@s
@jH@]p@5@i@B\@@@#
@H@K?H@5@(@G@@"\@1@\)@@.R@8Q@$z@+@
@B\@	?33?R??H?(?Q?\?G?h??u?\)?  ?\)@   ?˅?Q@@JH@O\)@nR@(@p@Q@p@@H@@P@z@h@Tz@H@X@i@Z=q@  @hQ@l@xQ@g
=@}p@w@H@\)@@Q@p@Q@{@Vff@5@R@)@?
???p?{?z?p?z?Ǯ?R@@R\@ZH@@{@H@@{A4QA&\A
A  A   A\)@33A{@\)@
@@R@=q@@(@Q@H@Q@G@mp@=q@@tz@_\)@L@?\)@a?(?33@C
@.{@$z@(??У?ff?H?˅@5?H?
=@@l(@nR@R@@@@@@@Q@@@@\)@z=q@@@[@W
=@
=@G@zH@@ff@c
@p@c33@e@@@@0@>{@>R@@@*=q@Q@2\@8@+@jH@8Q@*=q?p?33?@p@,@c
@z@@@
@  @G@@\@{@@ff@@Y@Mp@:=q@n{@<@Q@aG@5@/\)@.R@R@"\@z?Q?޸R?=q??
?\?
=?(?\)?Q?p?fff?p?E?z?Q?G???R@!G@0  @G
=@`  @|(@@@@@Q@@@G@`@l@8@P@@@=p@+@$z@B\@e@]p@Z=q@B\@2\@*H@Q@Q@	@ @\@
=q@G@(@G@	@@?\)?=q??33??\)@   @\@R@%@b\@
@33@@33@@s33@h@z=q@Q@\(@\(@S
@G@?\)@P  @>R@5@XQ@A@X@
=@Z=q@+@!@\@
=@
=@5@?@33????p?@?ff??33@Q?ff@?R@z@4z@@@c
@[@@z@e@fff@H@@
@Q@\(@u@n{@4z@_\)@]p@+@
@@'
=@2\@4z@=p@S
@E@L(@'
=@#33@   ?(@?ٙ?
@@
=q?z?˅?\?H?Q?\)?Q?\)?z@@\@:=q@>{@w@q@b\@ff@
=?Q@5@nR@\)@mp@@@   ?(?Q?p??(??  ?33?\)???z??{?
=???
=??
?Q?Q?z?p?33?p?Q?
?(?5?8Q?L?p?
=?H@ @!@@  @<(@-p@G?@'
=@7@1G@33@z@   ??
?
=??  ?G?p??33?33?У?\?H???33@
=q?z?޸R?@ ??@??G?@   ?z?=q?5?n{@-p??
?Ǯ?R@G@P@b\@\)@x@
=@@=q@33@mp@@q@\)@s
@H@G@"\@AG@U@E@C
@{?p?@@@33@@33?p@
=q@
H@
@
H@?G?{?33?  ?\@R@ @$z@(Q@\?ٙ@p@\)@p@Q@G@@Dz@^{@\)@@r\@7@.{@333@a@=p@4z@:H@1@$z@ff@   @;@@  @@  @;@{@"\@1G@  ?  ?ٙ@@*=q@
=q@@%??=q?=q@?(?z?Q@@+@@p@s33@(@@@
A
=A{A+
=A'\)@33@Q@n{@u@@xQ@Y@n{@l@Q@5@??(?p?\)?
=@
H?=q@&ff@\@ ?33?33?z??p?@<(??Q?H?{??H@\@\)@(@@@H@AS\)AiA  ApAQAk33AUA5ARAA
p@Q@@  @@(@{@nR@U@G
=@333@#33@C33@E@<@   @ @?\)@&ff@(@+@)@%?޸R@@\@(@=q@ff@@=q@Ǯ@HAA zAMAHARA=qA
=AJRA`(A(A-GA4  A@{AAQA
=@
=@{@A
p@\@G@^{@@@@p@:H?
=@zH@H@H@|@{@P  @\@<@@  @4z@6ff@{@H@{@z=q@7
=@1G@*H@%@C33@@@  @Ǯ@AffAIA
AEGA?@@p@
=@@ff@@l(A
=@4z@
@G@@p@Q@\@љ@Q@@
=@@~{@@p@:H@=q@;@@@S
@S
@@p@p@\)@\)@\)@
=A33A*{A-Af{A=qADA&RAg
A9A	G@@H@
=@@X@_\)@33@@z=q@q@  @@
=A  @  @
@@  @{@z@@tz@l(@{@i@   @aG@@Q@R@s33@\)?@R@vff@@ff@H@zA\@A2R@޸RA	@GA
A@=q@\)@z@@a@j=q@@@@\@{@@33@u@`@%@*=q@P  @1G@
=q@@!G@ff@:H@8Q@<@\@Y@^R@tz@1@Q@{@9@8Q@'
=@(@@'@>R@
=@\)@ӅAD@(@ff@zA,z@ᙚ@G@RA@
@@@@R@R@ڏ\@G@
=@
=@\@\)@(@(@z@ff@{@@w
=@@{@H@Dz@nR@Y@!G@C
@O\)@%@C
@   @7
=@ff@\)@33@(@33@Az@@@p@@Q@
@z@@@@@@  @{@@{@\@ff@Q@@Y@5@Q@nR@r\@S
@J=q@Fff@L@=p@L(@h@o\)@r\@\@JH@@@W@J=q@j=q@dz@\@\@@
@
=@\)@p@@`  @g
=@\)@(@@|@]p@9@5@@#33@!@2\@%@-p@2\@-p@O\)@ZH@g@a@a@C33@A@E@>{@@@;?Q?(@JH@{@   @@
p?@	@<(@Q@@<@|(@ff@vff@^R@@@=q@\@
=@\@\)@@@u@p@
=@l@z=q@@AQ@@@θR@Q@@hQ@{@G@`@'
=@p@(@^R@jH@|@S33@@
=q@\)@=q?@(?
=??\?H?޸R@@8@G
=@W
=@R@z@p@
@H@љA@Å@Q@u@~{@G
=@k@@)@2\@XQ@)@<@Q@q@mp@i@jH@n{@C
@`@E@U@z=q@p@^R@3
@\)@Q@G?
???
??33?\?@@.{@G
=@QG@33@{@\)@{@=q@{@A@33@{@=q@@H@Q@l@c
@aG@g
=@B\@G
=@N{@s
@Vff@p@^{@C33@@P@<@
@1@:=q?@"\@,(@*=q@
H?@{?z??
@   ?(@
@@S
@e@z@@@H@z@=q@p@@
=@ff@{@(@l(@K@*H@R@
H@{??H@@@@,(@=q@@R@?  ?ff?G?R?z?Q??{?p???@{@{@(@AG@|(@@p@
AA#33AA5GA{@=q@AAH@z@33@33@@׮@
@@\@P@4z@   @R@&ff@(Q@Z=q@L@w@W@Vff?R@>{?33?
=?Q?G??{?z@@4z@!@%@-p@R@8Q@:H@=p@@W@=qA-AKAA	@z@@8@=p@6ff@7
=@'@@??z@R??ff?=q?ٙ??p?\)?Q?
?@G??
=?@Q??p?ff?Ǯ@ @???{?
??p@
=@@0@C
@@
@z@A @G@\@
=@@{@\@@=q@ff@  @l(@S33@.R@@#33@@@
?Q?33?(?˅@@ff@Q?p@*=q??
?(@(@Q?@1@,@ff@"\@G
=@  @@@@@pA	A#AK
=AA=qA:\ALzA/A1@  A{@\)@G@(A1@z@z@
@G@xQ@p@Y@\)@@33@p@@fff@!G@G@E@`  @(@@@O\)@Q@
@ff@  @@R@@ff@A\)A/ADAdA[
A|@(A33AAGAA`ATA@(@߮@G@@7
=@NR@.{@@/\)@0  @<@{@H@
@
=@@(@p@g
=@]p@L@(@!G@
=q@(@-p@g
=@\)@  @G@\)@=q@Q@G@@Q@@\@@A @{@@33@R@@q@@j=q@9@333@)@{@\)@1@7
=@#
@@*H@0  @S33@@  @:H@XQ@z@G@nR@ZH@@
@Q?ٙ??z?=q@@
H@G@@,@0@h@mp@@@˅@  A)AA((A\)A!@@qG@7
=@%@^R@~{@@n{@n{@Fff@7
=@[@q@h@Q@@@θR@N{@O\)@@s33@o\)@h@@@*=qA.H@W@o\)@w@W
=@0  @7
=@E@@@=q@\)@
=q@@U@i@=q@(@@Az@ff@=q@@jH@c33@5@!@(@
=q@
H?{???(?(?H?@$z@:=q@%@.R@ff@{?G??\)??zH?n{?}p?O\)?}p@
p@1G@!G@5@z@R@;@Y@@33@@A
A%@p@Q@=qA(@ȣ@A1@33@  @p@p@A33@>{@NR@(@
@R@@G@@z@@ZH@|@S
@@p  @B\@0  @aG@R?33@,@G@@=q?@R@8Q@HQ@S33@P  @
=A1A,@{@A@AkA^R@{AA2H@@@
@@@@
=@
@ff@@p@=q@|@H@\)@e@(@ZH@ @c
@,@A@%@
?{@Vff@@^R@2\@\)@]p@l(@H@\)@r\@(@A\@{@{A@@GA/33A$zA\)@H@(@z@@p  @<(@  @33?p?\)?{?(?p@:H@b\@?\)@Q@z@C
@@{@@Q@^R@K@9@1@ @p  @R@~R@h@G
=@e@U@ff@g@@AS@{A,(@pAAc\)AffA:HA A0QA@=qA33@@  @=q@|(@G
=@g
=@  @g
=@H@:=q@?p@\)@S
?@
@@@g@<@=q??\@	@@H@W
=@p@L@zH@hQ@p@>R@@@
=@  AI@A*{AA@@RA((@s33@G@_\)@y@x@^{@3
@/\)@%@#
@Tz@<@  ?@p@@b\@K@*H@E@E@$z@\@0  @/\)@*=q@(@@9@@/\)@z@   @
H@@p@G@N{@=q@\@ff@@
A\AH@G@z@Q@@ff@_\)@@@?\)?@=p@-p@6ff@Fff@W@aG@W@z@
@R\@Q@Vff@?(@R@?H?(@33?R?z@G@G@i@.R@H@H@A@
@hQA@GA1A(@QArRAtz@\@g
=@z=q@_\)@U@<(@1G@"\@+@@333@#
@)@\)@e@HA@`  @p@l(@@NR@c
@XQ@&ff@G@333@@ ?\)?  @?G@z?޸R?{?˅?G?H@{@\@R@U@(@G@j=q@H@o\)@H@@33@\@l(@C33@R@@8@@@z@"\@@=q@Q?
=?=q@'@AG@l@@G@E@S
@=q@l(@@ff@"\@333@`@u@:H@5@?\)@A@jH@ZH@l@a@c
@(@G@AQ@  @G@@
AA6=q@Q@\@@A\)@H@{@@p@\)A@@AQA33@
@=q@@@Q@\@p@
=@\(@Y@@@xQ@Q@|(@ff@N{@AG@5@=p@fff@-p@-p@=qAGA
@33A{A QA\A A@{A9pAJR@R@G@33A{@A[\)@@R@Q@yA
=@p@ȣ@=q@
A8  @{A#33@@@@ָR@@W
=@iA@  @e@R\@=q@dz@E@\)@w
=@x@H@@ff@AAA<QA\)AA   A"{@Ǯ@޸R@ʏ\@
@z@@c
@jH@x@5@@u@G@'@u@@@~{@}p@Q@(@!@@
=@@@@@  @(@H??33?@Q@mp@k@@'@GA{@Ϯ@AyG@@޸R@
@\)@@33@@\)@GA
@
@@=q@ff@QA
=A{@R@@I@=q@@\)@H@H@H@H@dz@w@|(@j=q@Dz@A@@G@p@33@0  @a@^R@9@JH@tz@  @A-AA)A%A@(AA33AGA#\)A4  A33AR@A4@Å@@@33@nR@r\@@~{@g
=@jH@Y@l(@R\@C
@6ff@5@O\)@1@Dz@
=q@ff@@(@hQ@,@g@0  @L(@N{@6ff@,(@(@\)@i@p@RA(A5Ab=q@A#\)@A#33Ap@\@AqpA
H@ʏ\@AN{A@@p@R@z@\)@@R@(@U@U@333@dz@O\)@1G@-p@1G@#
@\)@=p@C
@U@5@#
@z?\)@@
@3
@@S33AA\A
A{A z@
=@@(@U@]p@S
A*H@Tz@C
@fff@{@~R@c
@@]p@{@@\)AA
@
A#AxAp@zA%AAz@ff@ff@{@@{@H@@
@@@@tz@HA&H@AQpAp  A0  A{A<(AAs33AAbffAw@ffA-AM@\@l@c33@z@R@\)@z@y@\)AG@=qA"\AA*HA@
=@z@z@HAG@ff@=qA33A
@\)@ffAG
@
@@@Q@  @@P@@=qA3
=A@]p@H@ff@G@zAG33A$@zH@\)AH@Q@޸R@H@
@R\@j=q@p@o\)@G@G@  A33@
=A$@H@ff@ff@{@33@@>{@U@G@A!@z@=q@A/
A$zA_33AjHAf{A4zA*HA?AA=A"ffA{AiA   A
=A  @@A @H@@AapA]G@@A
GAZffA3\)AA{
=ApAxA
=A
A-GAA%@\@@{@z@A@  @
=@{@Q@G@@ffA A
=@QA(ARAAAA>\AZRAffA(A{@p@@33A/33@H@@K@@H@@QA(@{A.\@}p@@(AD  @{@G@g
=@  @{@@=q@A Q@j=q@   @?
@/\)@!?\@@(@AzAH  AIAz\A  AAB=qARAA|(Ap@@
=AZ=qA3\)@@ٙA%AHA
@=q@@ff@(@A~ff@\)@,(@"\@vff@z@@E@n{@Dz@^{@>R@]p@@|(@@p@A1A@A((A4AffA&HApApAffA=qApARAA@zAh  ApA
A5AA?
AA	GAA|  A(@RA+@w@  @
@R@@b\@@p@@H@nR@\)A{@H@{@@@A@  AGA`A>RA
@
AQ@(@
AAN\Ac
=A:HA)pAAAQA"R@A A-GAGAA(A{AIGAAffAzAo
=A
=A
A Q@33AAeARAzA@{@
=@G@@@
=@@
@9@@p  @\@\AG@(A>{A  A&HAhQAARAARA(AffA3\)Ay@G@
AA	@qG@B\@@@c
@/\)@33@z?Q?ff?\?=q@
p@333@^R@s33@L@-p@S
@@e@
=@&ff???
=?@H@Vff@  @G@@A:{A"=qAGA,A%AcAF{AQA\)A>RAH@33@\@p@A
@G@\@@
=Ae@hQ@R@@  AAA?
A,(@ff@@@@Q@ə@@  @@R@Z=q@p@@@@\@ff@@N{@ffARAdzAvRALAC
AuAc\)A\)AA333A33AffADAC
=A5pAYpA A!A33A
pAEGA~\A?
=AEAApA!A=qAA/
=A"\@
=@=q@=q@=q@ff@H@{@=q@z@\)@
=@z@@
=A9A4zAC
=AqA5AHA=qA
=A3
=A(QA:ffA.HA4AA
=A=qAHQAAs33@A(zA@A
p@ArHAF\AIA[AT  A(A=qA
AAffA3
@ÅAGA
@z@(@p@p  @ٙ@u@5@ZH@E@;@ϮA(z@GAAGAIApA
=AApQA=qARAAA@R@{@
@
@p@
=AL(@Q@@@
=@zA#33A  @=q@z@@@陚@@Q@
=@xQ@~{@@7
=@hQ@Az@A{@=q@@z@HAUG@@=qA  @ApA#
=AGAQAffADA'
=A?
=Az@=q@p@\)@A @Q@@QAzA4(@=q@(A=q@z@Å@@@  @{@p@@Q??@	?\?@
p@@k@33@\)A@əA{A3
ApA	pAASAA<z@ffA.{@l(@i@   @Tz@3
@5@\)@@   ?p??z@?H??Q?ff??p@1@=q@z@=p@=q?\)?@S
@@ff@\@AG@\?(?  @ @?H?u@ @A@
p@G@
p@p@z@  @ҏ\@(@(@33@h@y@Dz@N{@,(@,@p@&ff@*=q@@:H@=q@(@HQ@z=q@Q@\)@8@"\@fff@@  @8@(?\)?{?p?G?(?G??{?  ?˅?G@33@!G@C33@<(@qG@p@aG@@=q@QA
AAQAz@\)A=q@
=@@\)@׮@@  @@z@{@q@~R@|(@H@@  @G@p@Q@(@w@W
=@C33@aG@W
=@J=q@^R@vff@g@w
=@c
@|@{@ff@QAffAzA(AzA2{AipAARA\)A
AmpAK\)A
=qA	@{@Q@Q@(AA
=@ffA"RA{@=q@p@33A33AR@@p@z@@z@33@x@G@=q@G@Mp@i@=q@ff@@@G
=@H@@
@(A{A4zA?\)AcAtA  AA\AHAUA/33A@(AAA
=A9AA(@@A z@GAA{AAp@???!G?!G?&ff?8Q?+?L?Q?(?(?B\?&ff??(?!G>=q?p>B\>>>u?.{>G?
=q>>8Q>\)<>8Q>k#
L=Q?
=?(?\?R?(>z=\)>\)<#
L>z=u=u    <
>Q>>ff?333?p??G?ff?p??\y @@p@
=@R@  @\)@Q@Q@G@\)@\)@@@ff@@Q@陚@@  @
@Q@@@@(@Q@@p@@=q@\)@Q@33@
@z@33@׮@(@ۅ@ff@z@@@
=@Q@  @\@33@@@p@@@@@R@ff@(@p@@z@A   AAp@@@G@@G@@@ff@p@R@
=@@޸R@ۅ@@ۅ@@\)@Q@θR@{@ff@@  @@@R@@G@H@Q@\@Q@p@@R@\)@
=@@{@z@(@33@33AGA\)AA
RAffAA33AQA\)A\)AGAp@{A  @R@=q@p@H@(@ٙ@@ff@
@Q@@  @޸R@@R@
=@ff@@  @p@(@@@p@@\)@R@p@@  @=q@@
=@ff@Q@@z@\@z@{@
@33@=q@@@{@\)@
@@p@
@ۅ@ff@ٙ@@߮@
@(@@@  @޸R@ff@@@=q@@
=@ff@ᙚ@(@\@33@ᙚ@@Q@@  @޸R@ᙚ@Q@@߮@Q@p@@  @
=@@\@@z@z@z@
@33@H@=q@H@\@߮@@ڏ\@@(@33@@  @  @G@\)@@@G@@z@33@G@33@=q@@@{@@p@p@  @@@
@
=@ff@\)@G@\)@\@
@p@@@
=@(@@p@
@=q@H@33@@@=q@p@ڏ\@@@
=@  @@
@
@@@(@\@@G@@@@@H@@@33@
@@  @z@߮@33@޸R@
=@\)@{@G@@ᙚ@ff@@33@R@{@R@@z@p@{@@@(@@ᙚ@p@R@G@Q@\@\@@@H@p@33@R@@@(@@@{@ff@@
@H@@\@H@@
=@  @@@@=q@\)@@p@@  @=q@أ@p@@@{@У@@z@ff@@33@33@p@G@@H@陚@\)@{@{@@@ff@@@@=qAA@=q@@@@{@
=@33@@{@=q@@33@33@@p@p@33@@ڏ\@p@
@@H@{@\)@ƸR@Q@Ǯ@=q@@
=@(@@
@@ff@@z@G@G@@@G@(@@
@{@@33@߮@H@߮@ff@@  @@{@H@ڏ\@
@\)@Ϯ@H@33@(@љ@G@  @@{@Ϯ@@ff@33@ʏ\@ƸR@ƸR@@@
@
@ʏ\@@@(@У@{@@=q@@@=q@Ϯ@У@@(@@@=q@(@=q@
@ָR@أ@\)@Q@
=@@ٙ@H@G@
=@  @  @  @\@
=@G@@G@ٙ@ٙ@
=@
=@(@H@H@ʏ\@=q@33@Ϯ@Ϯ@Ϯ@Ϯ@Ϯ@G@љ@ff@  @@@ff@Q@أ@H@=q@@H@=q@@z@z@\)@Ϯ@\)@  @H@  @θR@Q@У@Ϯ@У@Ϯ@\)@H@љ@@@
=@
@@@θR@p@ə@Q@=q@θR@Q@ff@
=@љ@33@(@׮@@@ָR@\)@33@@@׮@33@
@=q@G@z@p@љ@  @\)@@θR@Ϯ@G@θR@@z@@33@
=@33@z@@p@ȣ@\)@\@R@(@G@ff@@G@\)@
=@  @H@Ϯ@=q@ڏ\@p@(@У@(@@=q@H@\)@@ff@ff@љ@@Q@\)@@p@љ@љ@33@љ@@ə@Å@z@H@  @@\)@@
=@@
@@@=q@@{@z@{@H@@@@G@\@ƸR@ƸR@(@ٙ@Q@@H@@=q@ҏ\@G@ȣ@=q@z@@׮@ҏ\@(@p@@R@@@@  @@@\)@@@G@R@Q@@@{@
@R@\)@H@=q@(@Q@ȣ@@ff@ʏ\@ƸR@θR@z@ȣ@@  @
=@H@H@\)@
@
=@Ϯ@Å@p@ə@ƸR@ƸR@z@@\)@=q@(@@@{@=q@@\)@H@\)@@@z@p@33@
=@@@H@33@@H@H@ƸR@Ǯ@ə@@{@\@@\)@{@{@{@33@z@@{@p@  @H@
=@Q@
=@H@θR@@G@ƸR@@@=q@
=@(@{@{@
@{@\@
=@
@@@H@@Q@@@
=@R@@R@@{@
=@@\@H@@33@
@Q@
=@@ȣ@{@z@˅@z@H@p@@z@G@@  @@\@Q@
=@
@  @@
@ff@@@
@\)@33@  @  @\)@@
=@  @Q@@@R@=q@@=q@\)@@@
=@R@=q@@z@@  @Q@z@@R@@z@p@z@ƸR@ȣ@ƸR@z@@z@@
=@R@ff@G@G@p@@@p@=q@@H@G@@(@H@\@p@\)@R@@z@
=@
=@ƸR@@\)@@@Q@Q@G@@\@\)@@@(@G@ff@@@33@H@(@@ff@@Q@H@
=@R@Q@=q@\)@{@\@@(@
=@ff@Q@  @@Q@G@@@H@=q@R@{@
@ff@(@z@ȣ@p@
@@@@@\)@(@H@{@33@Q@@@@z@@Q@@@
@@R@ff@
@
=@G@R@33@G@
=@ff@@Q@@  @G@@(@ff@Q@@=q@{@@@@@
=@33@{@z@
=@H@Å@\)@R@ff@\@(@R@\@(@\@=q@@Q@@G@(@  @@@
=@H@(@p@=q@  @{@H@p@G@@@z@
=@@
@H@@@@
@H@=q@@@@@\@@@ff@=q@R@@˅@@  @33@H@@=q@ƸR@33@Q@@(@@\@G@\)@@G@\)@(@R@(@=q@@=q@R@@@@  @@@(@=q@@{@
@p@  @\@R@@33@\@
@Q@\@@@Q@H@z@\)@@@G@Q@z@\@@{@(@@@=q@{@@@\@R@@@Q@  @{@@
=@
@
=@@ff@\)@(@R@@@@R@@ff@@R@  @z@\)@33@@@\)@{@@@
@@
=@  @{@@@Q@@{@@\@@{@Q@Q@@ff@@@G@\@\@z@{@@@@@ff@  @@@
=@p@p@G@(@\@@
@@=q@@R@@@p@R@@@z@Q@@
=@p@G@\@
@p@@@@\@
=@@@G@@\)@\@\)@@  @
@@  @@@
=@  @@
=@(@ff@H@G@Q@z@{@@
=@@Q@
=@H@@G@=q@
=@p@@
@@\@
=@(@ff@@Q@ff@@
=@\@Q@=q@@@@33@Q@
=@@
@ff@H@
@z@  @Q@@
=@@
@  @
=@p@\)@
@@\@@@@(@{@z@@\@33@@33@\@  @\@(@R@G@  @@@  @@@@Q@@@Q@H@@{@Q@@Q@@@H@@  @\)@=q@@@H@Q@@G@H@  @\@@@{@ff@@\)@z@(@
=@R@\)@(@@
@33@@@G@@H@\)@Q@@\@33@@
=@p@  @@z@G@33@@(@(@z@\@@
@z@=q@
@
@
=@ff@
=@Q@@(@@@@@@R@ff@
=@ff@{@@@z@{@\)@@\)@Q@33@
@=q@@Q@ᙚ@(@@@(@33@\@@Q@{@Q@R@  @
=@  @@@@{@p@@@@
@{@@@@@߮@@@R@(@@@z@z@33@p@陚@陚@z@(@  @@\)@33@
@@G@(@@@\@33@33@
=@ff@R@R@
@
=@33@
=@@@ff@@\)@\)@@  @@R@{@Q@  @H@Q@
=@{@@@p@@@
@{@@@p@Q@@@@@@p@G@@@
=@\)@R@Q@@H@H@@@@@@@z@@陚@G@33@  @  @
=@p@@@  @@R@ff@ff@R@ff@p@@@@  @@\@(@33@33@33@z@\@@  @@
@z@z@
@@@
@(@@(@(@A (@ff@{@pA Q@@\)@(@z@@@\)@H@33@@@
@
@G@ff@{@(@\)@Q@@\)@\@@ff@{@G@
@z@z@
@pA A=qAAzAffAHAGA33AAHA AA z@
=@{@@(@(@p@@
@@G@=q@=q@=q@G@@@z@@H@@{@@{@ff@R@R@@HA Q@H@
@A AA
=AzA	A\)AAAAffAApA A Q@z@{@H@G@ff@@
@@@@\)@ff@
=@@@@@Q@
=@{@  @@@@G@z@Q@(@@
=@zAHAA	A  AAQAAffA	A
=AARAzAA A   A\)A z@A@z@@  @33@ff@ff@陚@ff@33@@p@@@Q@Q@@@@(@\@@@H@z@@{@R@ffA AAAGA
\AQA
=AAGA=qA=qAAzA
=A=qA  AA=qAAffAffA{AGA{A@@{@{@Q@\@R@  @H@@(@@@@@@H@@  @GA AAA33A=qAA33A\)AQA(AAzAQAA(A33A\)A\AHAff@@@@\)@R@@
@
@p@
=AAA (@@A   @
@zAH@z@
@=q@z@@p@ffAA{AAAAA33AAAAzAA	A
=qA
RA\)A
RA	A
=ARAGAAAAQAQAAAARA{@\A QA A (A zA (A A Q@ff@@p@@p@33@p@=q@H@AAAAAA A
A  A	A
A
\AAAA
A	A	A(AHApAA(A\)A
=A=qAAGA A zA A Q@
=@\)@R@p@{@@p@p@ff@@{@p@z@\)@\)@
=A AA\ARAffAAAAAAzAAAAA  AzA33A QApAGA A A AA Q@
=@@@@33@=q@@=q@@@@@
=@G@@zAA @z@\)@\)@AA z@@A\A33AApAzAA
pA=qARAffARAzA{A  A{AGA{AAA{A	AA A\)AAA	GAAA33A
A
A\)A\)AzApAAAAGAA=qA  A(AAA=qAffAA
pAHA	A33A\ARAQA
AAA
GAA33A(A=qAGAAA@AA
A{A
=@ff@Q@R@@H@{@@RA@{A Q@\)@@@@R@z@@
=@@{@33@AG@(A @\)AAAffA z@\)A   AA(A @{@A A@ff@G@A (@@@ff@
=@A\)AA
AR@@(@A @R@
=@
=@@{@\)@z@@33@
@@@
@
@@@
@Q@Q@R@Q@@33@@
@  A @ffA@\)A @@=q@\@\@
@@p@G@
@\@\)@@@H@@ᙚ@R@H@\)@@@@p@z@\@
=@ٙ@@R@
=@p@R@Q@\@(@(@@H@z@=q@\@\@p@z@  @@G@p@(@@  @33@@@\@@\@@=q@@߮@ff@33@@33@@\)@@@H@׮@ٙ@ҏ\@أ@@z@@(@
@
=@G@@z@
@(@
=@  @z@
@޸R@@\)@ᙚ@@R@߮@@@  @@R@R@@(@@θR@\)@  @G@{@ff@
@@33@Q@(@R@  @@陚@@
@A   A  @RA{A	AARAQApA  A(AA\)AA\)A
A{A	pAA=qAAA\)AAA
pAGApA
A  AffAffAHAAA  A	GAHA
=A33A
AA33A=qAAGAA
A
AA	A
AzA  AAGA"RA!pA{A\)AzA
=ARA(A
pA\)A
=A
AzA
{AARApA  AAA
AAAA{A\)AA	A
ffA\)A
A
A\A\A  A	A
=A33A@(Az@=qA@@  A
=AzAffA	A=q@=qAA\)A Q@@\)@A@A\)A33AAG@
=A z@@@R@ffA@R@{@A zA AGA zAGAp@G@@\)@  A@zAA @A @@@{ApA{A
AzA
A\AAAAffA\)AffAAAGAA\)?\)?>>\>{>  >G>>(>>
=>33>>\>ff>>>ff>ff>
=>>>>>\>ff>
=>>Ǯ>p>\>Ǯ>\>\>p>\)>\)>  >>\)>=q>  ?s33>\)>>>
>>
>
AA{AQA
=A	AAARA
A
pAAAA	A
HA
A  AA33AA\AAApAA
A
A{A33A\A
=A33A
=AA	GAA
ffAAAAA	pAAzA33A
ffA  A	GAAHAA  AAAzA=qA	AffA{@AAA Aff@\)A A@R@@Q@A (Ap@33A A @\)@@\@@A@\)A{@(@G@@H@G@@z@p@H@AA  A33A	A
GApA33A
A
ffA	GA\)A	pAA\A
AA\)AQA
\A(A
ffA
=AA
A
AGAA  @{@ffA @  @
=@HA   A  A
GAARAAGA\AA
=AA\)A
=AAAAQAAARA
AzA
{A(AAffAzA  AzA\)AA33AA(A#\)A(  A)A((A&RA AA!pA'
=A#
=A(A%pAzARAAA
AzAA	A
A\AGA=qA=qA
A!GAGA
A\A!A{AQA  AHAGA
GA%AHAA\A(AzA   AA A
A\)A%GA$A+33A(A)A)A&ffA%A&RAHA\AAAffA\AzA(AQA\)A
AA
{A
=A
{A
=AzA{A(AAAAzA
A\A
AA(A
ffA
=qAA
AA\AzA
A
ffA
AQA
{A
RA
\A  A
RA
RA
ffA
{A33A
A=qAA(ApA=qA\AQAzAA	A=qAAAAA	A
\AAA	pAAA	pA	A	GA
ffA
=A	A	AAA	A	A	A
=A	A
HA
A
pA
A
GAAQA
GA
RA
=qAARA33AA33AA	A
HA	A33AA	A
=A
AAAzAAffAA
=qAA\A
=A33A	pAffAAffAGA\A\)AAA\)AARA33AAGA
AGAHAGARAAA@RAARA(AGA=qAffAAA
AAA33AHAA
A
=A
AGAA  A
AffAA((A$QA9A4A-A3
=A&HA0A;A8A5A9pA8A9A7
A8  A@A7A:=qA9A:\A7A8QA4(A.=qA/33A0QA1pA-A333A1A"HA!A(A#
A#\)A!AffAA
=AAAAAQA
{AAAA
=AAGAA  AA
=A{AAzA\)AzA	AzA33A{A
=A\@(A
=AARApAAA
A{AAAAA
=ApA=qAAQ@@(AAA\AA\)AAffAA
{A
A{A{A\A
pAAffAA
AA
HAA  A @A\)A	pA33AA\A	A{A@AA	AHAA	AA	GAAA
=qAHA
A(A{ApA
AQAQAAAffA{AGA=q@@
=AGAA
A(AQA=q@AGAARA(@(@@H@R@ff@@(@(@G@@  ARARAff@A	A@=qA zA   @AA	AA\)AA(@\)A\@Q@  @33A @@ff@R@Ap@@33@@
=@ff@@@G@H@@
@@@(@=qA@@@@
=@@33@@G@@33A33A{@Q@H@A AAzAR@ff@@R@@\@  @@@p@R@R@  @=q@@\)@(@33@{@(@(@@@
@{@@@ff@H@(@@߮@@p@@@@p@
@=q@@H@@ff@=q@zA A{@ffA @z@@=q@G@Q@=q@z@R@=q@
=@\@
@@@
@
=@33@@\@@(@
@p@@
=@@H@=q@@ff@(@33@\)@Q@@z@ff@
=@  @  @z@{@  A QA\AAA  A\@{A A @@\@\)@@
=@@z@
=@@R@H@@@z@@@@  @@@(@@@\@\@G@Q@R@ᙚ@@@@陚@=q@
@H@p@G@@\@\)@
=@{@(@\)@(@G@p@R@z@@G@H@@\)@z@G@@p@33@@ᙚ@@@=q@@z@@@@@=q@p@p@H@@=q@ٙ@p@
=@=q@@@  @H@@G@G@\@{@@H@@(@ᙚ@ڏ\@=q@  @ٙ@ۅ@(@ۅ@@(@
=@׮@@=q@޸R@@{@@33@G@G@ۅ@p@ۅ@G@  @33@љ@ָR@=q@(@
=@ٙ@H@G@ۅ@@=q@@ᙚ@
=@p@ٙ@@ff@ָR@߮@ff@
@
@Q@33@z@\)@z@H@(@љ@\)@ָR@\)@ָR@{@@ָR@@ָR@@(@(@@љ@
=@˅@ʏ\@z@G@ff@θR@
@@ָR@ۅ@ָR@\)@ٙ@\)@33@G@@p@  @=q@@p@H@ᙚ@p@ۅ@߮@Q@  @p@G@@ڏ\@
@׮@׮@@(@(@Q@
=@  @p@p@
=@z@
@Q@{@(@33@@@ۅ@Q@
@ҏ\@
@Q@H@@ff@
@ff@\)@(@@R@ff@@33@=q@@\)@@У@Ǯ@H@@z@@\)@H@33@(@@  @
=@Q@G@(@33@Q@Q@ə@ʏ\@ȣ@ƸR@@\@p@p@ʏ\@\)@  @  @Q@Q@ə@(@@{@@(@@H@  @׮@@Q@\)@Q@p@p@\)@p@@p@
@ff@p@z@Å@z@@\@Q@@ff@R@@@  @33@@p@(@
@\@
=@
@  @{@@@
@z@@z@33@G@ȣ@
@Q@\)@R@Q@Q@(@=q@
@33@H@z@  @G@@{@Å@  @
=@@R@@ff@@@z@33@G@@@p@@
@p@@
@
@ff@p@z@z@@z@z@p@  @@(@=q@p@θR@{@\)@\)@(@R@G@p@z@@@p@@\@33@@  @@ff@(@z@@p@=q@Q@Q@\@@=q@@@H@@@@{@@
@@R@@=q@{@@R@@=q@\)@  @33@G@@@G@@@@
@  @H@@33@=q@ff@@
@33@@z@G@@H@Q@@@@Q@  @@p@@
=@{@@G@z@@33@@}p@vff@\)@~R@|@{@y@|@Q@  @  @~R@x@@Q@\)@xQ@y@xQ@s33@s
@x@y@r\@x@s
@s33@l(@nR@mp@g@p  @qG@n{@h@b\@fff@^R@aG@`@[@c
@g@g
=@e@`  @`@^R@^{@aG@k@p  @p@hQ@e@l@p  @q@l@l(@e@dz@e@`@`@^{@XQ@S
@R\@R\@Mp@K@N{@P  @P  @L@K@G
=@HQ@Mp@P@NR@E@H@H@HQ@S33@L(@Q@Mp@P@R\@P  @JH@I@N{@Vff@]p@G@G
=@Vff@Q@aG@U@Tz@XQ@R\@NR@G
=@>{@AG@C
@<@4z@6ff@3
@.{@+@*H@(@&ff@'@)@(@   @+@(@#
@(@'
=@@\)@H@@=q@  @
@@z@@+@@#
@33@{@@
=q@	@(@@@@(@@@  @G@@@G@(@(@Q@ff@@
=@
=q@@G@@@
=q@z?R?R@@	@
=@   ?
=@	??(?Q?33??
=?Q@G?H???=q?\?Q?33?H?H??=q???\?  ?G?  ??޸R?  ?  ?(?H?(?H??
=?{?У??{?\)?У?
=?ٙ?\)??  ?˅?H?˅?Ǯ?Ǯ??p?G?  ?
?Q?p?H?  ?G?R??ff?{??Ǯ???
?\?p?H?R??(???  ?
?(?R?(?Q?Q??z??\)?z?(??33?
=???z????  ?p?{?33?
=??=q?
=?p?p?H?G?  ?(?G?Q?z?33?z?33?{????????  ???{????{?\)?33?z???\)?z?(?
=?Q?R??  ?\??\??z?Q??\?????ff??{?=q?
?}p?zH?G?ff?
?\?  ?zH?}p?  ?  ?}p?}p?s33?\?G?\?G?}p?ff?\?xQ?zH???xQ??z?z?33?33?H?  ?Q??xQ?\)??????z?\)?ff?  ?u?  ?  ?zH?k?s33?  ?aG?^R?aG?k?k?aG?  ?}p?h?h?^R?W
=?\(?n{?xQ?p?h?^R?aG?Q?W
=?k?s33?u?\?n{?fff?s33?u?zH?aG?^R?Y?O\)?^R?L?aG?G?W
=?^R?p?k?s33?xQ?p?h?h?k?s33?k?Tz?G?Y?h?u?p?aG?fff?k?zH?xQ?zH?n{?c
?Tz?^R?W
=?Q?}p?c
?Q?k?J=q?s33?xQ?zH?^R?zH?xQ?aG?(?=p?=p?@  ?J=q?:H?Y?aG?B\?B\?fff?Y?O\)?L?G?Y?W
=?Tz?E?E?J=q?B\?B\?5?=p?333?:H?333?.{?5?:H?@  ?:H?@  ?E?G?8Q?=p?Q?J=q?@  ?8Q?:H?5?B\?E?+?.{?333?:H?333?(?&ff?.{?0?333?.{?=p?:H?=p?:H?5?8Q?@  ?:H?0?+?333?&ff?333?=p?=p??333?E?B\?0?=p?=p?&ff?B\?8Q?5?5?333?=p?@  ?E?J=q?E?O\)?8Q?0?(?:H?0?5?+?G?5?333?8Q?J=q?Tz?:H?(?R?
=?R?(?!G?(?(?(??#
?!G?z?(?z?.{?333?(?
=?(?+?R?333?0?:H?=p?B\?&ff?(?0?=p?8Q?Tz?B\?@  ?0?333?333?#
?#
?+?(?\)?\)?0?R??z?
=?R?(?R??(?R??#
?!G?0?
=?(?#
?0?8Q?L?G?G?:H?G?B\?&ff?333?=p?8Q?5?.{?8Q?@  ?:H?333?B\?0?8Q?5?=p?+?!G?+?(?R?&ff?.{?333?333?333?333?B\?!G?.{?R?!G?(?8Q?0?\?&ff?@  ?E?5?0?333?0?:H?0?B\?@  ?@  ?@  ?:H?=p?@  ?G?=p?E?G?=p?E?E?z@Q@}p@@
=@@@{@@H@@@33@H@33@
@z@p@\@@@@(@R@@(@{@@@z@@@@@
=@@33@H@@ff@=q@
=@ȣ@33@@G@
=@Q@@Q@
@@
=@  @  @  @@θR@@33@=q@˅@H@z@@@Ǯ@\@\@@
=@
@@@33@@R@Q@@@H@@\@ƸR@H@@ȣ@ƸR@
=@@Q@H@p@H@z@p@
=@\)@@{@@ƸR@\)@Ǯ@ȣ@ʏ\AAAAA(A  A33AA\A
A{A
A
RAAA
A	pA
ffARA33AHA	A
AzAz@A	GA
A(AA
A\)AGA{ApA	AA
\A	AQAA(A  A	A
A
=AA\A(AAGAAAAA
A
=AAQA
ffAA
A\)AzAA33AHA
AAA  A
A
AA\A	A
A
=A\)AA=qAA
=A	pA
=AQA
A
\A\)A
ffAA=qAffAAHARA  AA=qAARA
AAzAzA
=A	GA{A  ARAA33AA33A	pAAAAp@R@@\)@z@\@(@@{@@R@
=@AGAffA AAAHAzA\AAA$A(zApAARAHA=qAAA=qA
{AA
\A
A
A33AG@{@陚@@@H@@@G@{@@p@ff@\)@陚@H@ff@H@@{@@\@
=@H@@@@@\@(@@
@z@@@G@\@G@\)@{@=q@ff@{@Q@@\)@{@@\@@G@p@Q@
@陚@@ff@@H@(@@(@(@@R@Q@@@@  @Q@  @  @
=@@
@@z@33@z@z@H@33@33@@33@\@@H@\@33@\)@z@H@\@=q@=q@R@
=@\@G@(@@p@@@@@H@H@@@@R@@@H@@@
@@@(@p@@H@@G@H@@@\@@@G@@Q@\)@
=@R@R@@z@@\@z@@@@@ff@{@@@R@R@ff@R@@@@@33@
@=q@33@{@@@@33@@Q@@=q@@@  @G@G@@H@z@@33@=q@@@@p@@33@H@@@@G@@@  @@\@H@\@(@\@@ff@@\)@\)@@@@R@@{@{@@@@
@z@@@{@z@{@R@陚@=q@(@p@\)@@@=q@ff@@@=q@\@z@33@@
@33@H@\@\@(@{@R@@@  @
=@{@ff@R@ff@R@R@R@
=@@p@@
@@H@=q@\@@=q@@\)@
=@  @\)@\)@@Q@\)@R@{@@{@R@@Q@Q@{@@(@  @@@z@@{@@  @@H@\@  @@Q@@Q@@\)@ff@ff@R@R@{@ff@ff@p@p@
@@(@
@33@\@33@G@  @=q@  @R@z@
@@
@
@\)@\@  @  @G@@@p@R@Q@@33@=q@
@@\)@@@@@(@@@@Q@\)@R@\)@@(@G@@R@@R@@(@R@G@@\)@{@\)@\)@H@\)@@ff@H@@@Q@
=@G@@
@{@(@  @G@@@@  @33@\@\)@ff@
@@z@H@\)@(@@@H@z@@
@G@\@=q@@Q@
@@H@H@  @Q@
=@H@G@33@@@
@
@@{@
@H@
@  @(@(@@@
@(@@R@{@p@@@@p@@@{@{@@@@z@@p@z@(@
@(@(@@=q@H@@=q@(@{@@@{@@@@33@=q@{@z@@G@(@@
=@p@@p@{@ff@
=@R@
=@@(A   @
@@@p@(@z@p@z@R@\)@ff@@z@R@Q@G@H@=q@@=q@@@Q@\@@{@(@{@{@R@@@G@
=@Q@G@@  @@@=q@33@@@zA@z@=q@@@\@=q@G@@z@33@33@33@@z@@@33@z@@@=q@G@G@=q@@33@H@@\)@@@ff@Q@R@{@@H@=q@@@33@\@
=@(@{A   A\)AAAGA@@\@33@p@@@=q@
@\@G@@  @@\@=q@33@33@=q@@
=@@@@p@z@z@(@@
@(@ff@@@33@R@@33AAA{AffApA @A QA (@=q@G@Q@{@33@\@\@H@R@p@@
@陚@@\@z@G@@@G@  @@@\)@p@
@@
=@  @
=@R@=q@p@  @@=q@\@@@
@
@@ff@ff@Q@(@@@R@ff@@@
@{@p@p@z@
@@=q@=q@R@p@R@R@@@=q@陚@z@@@@@p@@ff@@@
=@@Q@Q@
=@R@G@@=q@@p@@\)@{@@@33@(@@@\)@(@
=@@@
=@\)@R@R@R@ff@\)@Q@@z@33@@@
@@@@A@ff@ff@@@@\@p@GAA A
=qA
A	A\A\)A
=A{A
=AAAAffAQA  A33AHA33A @R@\@  @@ff@R@=q@@ffA Q@
=@=q@ffA=qApA @ff@A A\@@\)@@{AAARAAAA{A33A
=AAA
HA
ffA	GA
=AA
RA	AzA(A
AAA\)AHAA\A\AzA	A(A(A\)A\)A
AR@{@@@33@pAA AAAAQApAA	GA
ffA
{A\)AHA	AA	GA{A(AAAAA
{A
RAzAAA\)A  A (A @33@@H@G@@@@@
=@@@\@@z@@=q@p@G@=q@RA\A
A33A{AAA\)AA(A
AAHApA{A(AffA  A
=A
A
A	GAA
=Aff@p@AffAHA
AA\AAA\ARA(A
AG@  @
=A   AGA @{A zApAA{AAA  AAAA\)A
AA  AAHA!AA=qAAA33A(A
AQA	A	GA
=A(AQAGAGAAA	A  A	AzA
GAAA
ffA  AAzAQAA
=A33A=qAAHA{AHA
=A
A(AA\AffA
=AA33A
=A	GARA@
AGAffA   A\)A
RA=qAA
RA\)A\)A
A33AA{AA
RA33AAA@@(@@@@@(@zA\)A	pA33AzApA
=qAffAAA	AA\A
GAffARAQAffA\)AffA{A33AHARAAHAA @@
@
@ff@@@R@
@@@G@Q@  @\)@
=@{@ff@\)@R@@@\)@Q@@=q@A @z@\@@@@(@@R@\)A QA QA\)ARAAR@p@
@@Q@\)@@H@(@ff@@(@G@@@\)@@R@@@(@G@@=q@\)@@\)@@@\)@{@  @  @@=q@@\@\)@R@@  @@G@@33@G@  @ffA (A QA=qAffAAA Q@(@33@  @@z@R@R@\)@G@@ff@p@@@@\)@H@@@@@  @@H@z@{@R@=q@@p@Q@\@(@p@ff@RA A QApA=qA\AHAHAffApA A zA @ff@p@=q@@H@
@{@@@@(@@33@=q@(@
@\)@\@=q@@@@H@{@G@@{@@33@@(@@{@R@@R@@@H@{AGAGAAA zA   @
@\)@z@ff@  @R@\@{@  @\)@=q@R@p@{@\)@
=@(@@G@33@@{@p@\@p@{@@H@@@@H@=q@@(@\)@@33@p@@\)AA zA   A   A A A   A   A z@=q@A A@
@G@G@\)A (@@H@\@=q@(@@Q@@@=q@H@@@R@@Q@@H@H@=q@ff@
=@ff@
=@Q@G@
=@Q@G@
@(@@@
=@ff@z@(@=q@=q@G@@\)@
=@{@p@p@{@{@G@
@  @
=@陚@Q@p@  @@p@@@@@Q@@p@  @陚@
=@@\@z@ff@G@(@@  @Q@@\@33@z@@QA{A (@@@
@@(@{@H@H@G@@@@@{@G@R@陚@\@@У@p@z@@@@(@@ᙚ@ᙚ@\)@\@@@pA
=q@@@@
=@z@33@@A (A\@@@@@@@z@@{@@@\)@G@@\)@p@@=q@H@R@z@أ@=q@  @\)@=q@\)@z@\)@޸R@G@33@\@@@
@(@{@(@@G@陚@
@z@
@=q@G@@H@@p@H@@@
=@{@@Q@
=@Q@\@Q@Q@  @33@G@@@=q@  @߮@33@H@=q@
@@
=@33@\)@ҏ\@
=@ڏ\@@@ᙚ@@H@z@@R@@{@  @  @
@G@ff@
@  @{@@@33@@G@Q@@R@ff@陚@{@\)@\)@@@=q@\)@  @@=q@(@R@{@(@@(@\)@  @@@@@
@@ff@@R@G@  @@@G@{@
=@{@@p@p@=q@
=@R@@\)@G@\)@(@
=@\)@@G@H@z@@=q@@
=@@  @=q@@
=@  @{@\)@
@
=@(@  @R@@{@@33@@Q@@AA QA@R@@@@@R@@z@@@\@@@\)@ff@ff@ff@@  A z@
=@@@@H@R@H@=q@(@
@{@
@@z@@
=@{@@@@(@A AA  AA33AQAA	A
{A33@(@\)@ff@@@@
@z@=q@@33@z@R@
=@\)@@@\@@@  @p@z@=q@{@(@=q@ff@@Q@@@
@H@AAA	GAA
AAGA
=qA
\A
pA\A{AA
AAAAG@
=A (@\@  @33@@@=q@@@@=q@@
=@Q@\@@@Q@陚@@@
@@
=@pA   AAQAzAA33A
pAAA(A\AAAHAA
ApA
pA	pARA\)A{A
pA
GA\@RA
H@pAff@33@A @
=A @
@{@@R@{A QA@@R@z@{@33@RA=qA	pApA A  AAAApA  A@A
{A(ARAAffA  A33AG@H@z@A@33@A	p@Q@R@G@p@\)A33A (AAH@  @@  @@@zA (A A{A  A	pA
{AAQAA
=AAzAA  A
AAA
A!AApApA
A\)AA@@\)@z@@33@@H@@
@(@@@z@33@
@H@  @=q@
@G@33@@@
=@H@@z@pA@  @@QAQA33AA  A(A\)AA{AAR@ffA=q@33@@p@G@@
@p@
@G@z@33@\)@p@  @
@\@33@
@=q@@z@\)@p@z@p@
=@H@@R@(@p@G@@33@@{@@@@@{@
A A\)AAzAA  AA   A @@@
@@{@\)@@{@z@\)@@@@@(@(@@p@
=@\)@
=@Q@@@@@@=q@  @=q@R@33@=q@@  @z@\@z@{@R@@@@@@@@(@@@@@\@H@33@(@{@
A33@(@=q@@@G@@陚@  @33@=q@@=q@\@
@p@ff@@ff@33@
=@=q@{@@H@@@p@R@A   @@=q@33@@{@p@@z@@ff@ff@@p@@@@z@
@
=@z@陚@@
@p@ff@@z@ff@H@ff@G@\)@陚@@@\@@
=@  @G@@R@R@G@@H@  @@@@@(@@
=@\)@33@z@
@G@@@\@ff@陚@陚@@@G@z@\@Q@@陚@G@@@(@ff@  @  @@@
=@@@z@ff@ff@Q@@H@
@(@@@(@\@(@ff@
=@
@(@\)@Q@ff@ff@@@33@R@\)@@\@z@@@=q@陚@Q@=q@
=@ff@=q@  @z@@\)@@Q@\@@@@R@{@\)@\)@
=@
=@@33@z@R@A AAA @A (@33@\@=q@G@@@@{@(@@ff@{@@@@=q@@@@
=@
=@@
=@@z@\@@33@{@ff@p@@\)@H@\)@@
@
@p@R@A   @ApAp@
=@A Q@@(@p@z@@@@@@@@@@ff@ff@\@@@@@@(@\@\)@  @@@@@@@z@
=A QApA
=AAA=qAQA
=qA  AA(A\)AAAHA(AzA=qAHAA@
=A A @=q@@@\@@{@@=q@@  @@@@@G@p@Q@p@@
=@HA A AGA @\)@
=A   A QAAAHA	AzA
AA{A Q@H@
=@=q@Q@  @@@\)@@@(@\@@@@@R@p@@@@Q@
=@@(@\@@\@ff@@33@@\)@@  @@R@@  @@HA zA
=A=qARA=q@@@@\@H@\)@p@@H@  @@z@
@\@@@@@@@H@陚@(@@(@=q@z@H@@G@
@p@@G@33@@HA A=qA33AQA=qAAA{A{A
AAAAHA
pA33ApAff@  @陚@pAR@QA
=@R@Q@z@33@\@@33@33@Q@@@G@R@(@R@=q@R@A AARA
A	A\)A
=A
A\)AffAA(A(AA=qA"R@ffAA\AGA\A
RAQAp@Q@33@
@\@@@@@p@
=@\)@@@
@\@
@@{@\)@=q@@(@p@  @@  AA  AA  A33AAGA\)AAAAAQA  A\AQA(A{@{@(@
@z@  @\)@@\@@@@@@G@\@
=@@\@\)@@G@@@@{@\)@\@p@ff@ff@Q@@ff@{@R@A AHARAA	pA	A
=qA	A
HA
=A
@pA   @@@@@{@\@(@H@@\)@\)@=q@
@=q@ff@Q@Q@@=q@@@G@ff@{@z@33@@=q@@=q@H@33@@G@R@
=@R@@p@z@@AA @ffA (@@G@=q@R@
=@@p@@(@@
@@޸R@
=@߮@(@ᙚ@@@
=@@  @߮@@Q@{@p@(@߮@@@
@@p@@@@陚@33@z@R@
@\)@@GAQ@{@  @\)@@(@H@@z@H@@@=q@(@@߮@\)@p@p@@ff@@33@z@@
@@@H@@ff@@p@
=@  @@
=@p@\)@@z@33@33@ff@RA ApA AffA\A@ff@
@@G@=q@=q@\)@G@=q@@G@@@@(@\)@@(@@{@Q@@@{@
@(@@ff@ᙚ@߮@z@@@陚@@@\@@@(@A (@QAA
=A A\A{@R@\)@H@33@G@@z@ᙚ@  @޸R@@߮@p@z@(@p@@H@
@@H@\)@G@@G@  @Q@\@
@33@R@@ff@\)@ff@@HA
=A@=q@ff@
=A Q@A   AffARAA
=A{A{ApAA@@@
@H@
=@\@@\@޸R@@z@@=q@H@
@ۅ@
@@  @@Q@أ@љ@@ff@@p@G@\)@@\@
@@  @\@@ff@p@@@Q@@{@H@ff@z@G@Q@R@
@z@@@p@H@
=@
=@\)@ff@@\@ᙚ@@ָR@  @@@  @  @H@ᙚ@@@
=@p@H@R@@RA@Q@@(@@@@@@  @=q@33@
@@@R@33@\)@߮@ۅ@
@ۅ@(@@\@G@  @@G@=q@Q@@
=@33@
@޸R@ᙚ@z@{@p@@
=@陚@@@@@\)@ff@@{@A A @z@@33@@\)@@H@@@Q@@G@
@ᙚ@޸R@z@@\)@@@33@33@@@Q@
@ff@@G@Q@\@z@R@p@  @@\)@Q@  @Q@G@@(@Q@33@{@ff@\)@
@@=q@=q@ff@@\)@(@33@\@@@H@@@p@@@
@=q@=q@ff@\)@  @p@\)@@@ڏ\@{@޸R@{@=q@{@{@(@(@@H@{@33@@=q@H@@G@33@  @@p@p@@@R@@@
=@@@@@33@R@{@@{@{@\@
=@ff@@p@ff@
=@  @  @@{@(@ff@ٙ@ۅ@33@@@@@@(@p@
@AAAQAA\)A\AGA=qA
=@@@
=A (@@@@H@=q@陚@@
=@@@=q@@\@@@@陚@33@ff@(@G@H@\@(@\)@@@@@@@\)@@@=q@H@z@\)ApA Q@=qA @@
@Q@
=@G@@(@R@R@33@G@@33@33@z@@@@\)@Q@H@
@p@\)@=q@@@
@ff@@z@@
=@@
@  @=q@@ff@pA\A
=A@@H@p@R@@z@33@Q@
@@R@@Q@@\@@{@ff@p@޸R@G@R@@(@@@Q@  @ᙚ@  @33@@  @Q@@G@@@
=@  @@(@
=@33@RA A=qAffAHA
AA
Ap@A@p@@=q@
@@33@
=@
=@@@@@@@@H@@@G@
@@@Q@@p@@\@\@@R@  @H@H@z@{@@\@@ff@ffA AAHA z@\)@@=q@H@@\@z@
=@\)@\)@@@@
=@ff@p@@@Q@\)@ff@z@@{@Q@\@@@@@33@R@R@@@H@(@
@@ff@@A{A\A
=qA
AAA(AA
HA z@H@@QA
ff@\)@G@
=@=q@33@\)@G@(@@@Q@33@\)@ff@G@\@(@p@A   AGA\A@A zA(AA
=ARA A
=A\AA
AA
RA  AAAA
=A
AffA33AAffAzAA @R@G@@H@@@\)@ff@@\)@H@G@@@=q@  @(@p@@
=@@\@@\)AH@(A(ApARAAA
GAR@pA=qAAzA@A @R@
=A
=A33A33@\@AGAAAGAff@@p@33@{@
@@ff@@(@  AQ@33@{A Q@pAGA (@p@@AAA33AGAA\A  AAAA"{A#\)A+
=A#
=A'33A.RAHA(AAAAAAA  AA\)A33AAAA(A{AAAA
=AAA A=q@@H@(@(A
AA(A(AQA(A#A33A(AHA
A
=A
A"\A#\)A+
A,zA!A*ffA%GA&HA$QAA AG@H@=q@G@@@\@{AAA
=AA
=@A
=AA33@\)@@{@AGAffA@A  @@ff@@\)@33@R@GAzAffAA\AARA(A+A2{A1pAffA\A	A'@ffARA  A(A\ARA\@R@ff@G@@
=@Q@
=@33@@33@  @\)@Q@\)@@
@߮@\@@Q@
@A A	GApA
A{A	A33A33ARAAffAAzA QA#A
=A33A
AzAA  A @Q@ff@R@33@
=@@z@  @\@@z@@(@ȣ@z@z@@\)@ᙚ@H@=q@R@AAAAA  A\AAA  AHA
AA
=A{AHAHA\)AQA{AHAAA=qA
=A  A=qA\)@AA @33A\)ARAR@\)AA{@@\)@=q@@(@@@33@H@@(@33@QA (A @GAAAzA  AA
=A
AAAAA
AApAAAA33@R@
=@H@33@33@Q@陚@Q@@@p@(@\)@z@
=@أ@ٙ@׮@@ᙚ@Q@޸R@@
=@@\@@
@Q@H@@{@AHA	A=qA  AGAHAH@pA33AGA	A
AA	A33@
=@@
=@p@Q@(@@@p@z@p@H@G@陚@@\@(@
=@{@z@@  @Q@
@@p@\@H@=q@@\)A@R@zA (A @p@ffAApA33A	A33AAQAARA Q@
@
@@R@@=q@@R@33@z@33@@z@\)@@陚@G@@
@G@
=@أ@\)@
@@z@ff@AAAA{A33A
=A
AQA=qApAAHA@A
=AA	A(A	GA=qA  AQA
A	A@@z@\)@zAH@G@@G@(@=q@33@(@=q@@@  @@\@z@=q@  @33@QA33@@\@@@(@\A
A
GAQA
A
=qAAAffA
A
=AAGAApA(AA
{A=qA
=AAA@p@@33@
=@@33A=q@ff@=q@R@(@
@@R@陚@@  @Q@@R@RAA  A
AAA
GA(A
=AAGAAAffA=qA=qAQA\@A(A\@
=@A Q@@@@z@\@@R@Q@33@R@@Q@@\@{@33@@  @߮@\)@Q@޸R@@{@@@A (A(A(A(A\)A\A(A
HAQA
{A{A@@=qAp@陚@@G@p@ff@=q@z@ۅ@33@(@@׮@׮@{@p@ҏ\@ҏ\@H@@ff@@\)@Q@
@  @H@@Ӆ@ff@@\@Q@
=@H@(@
@@  @
@\)@ff@33@
@@@G@p@@@׮@(@
=@ff@љ@ʏ\@ʏ\@33@(@H@ff@G@  @@p@@33@
=@33@
@p@˅@33@ə@H@z@z@z@G@H@33@  @ָR@ָR@  @G@޸R@H@33@@@@޸R@޸R@@@@@
@@R@z@@(@Q@\)@@׮@  @Q@p@p@@33@  @\)@
=@
=@{@@33@ҏ\@ۅ@G@@H@
@{@{@@p@
=@@(@AAAHAAAQA	GA	AAA
HA
=@@@@(@{@  @\@G@=q@=q@@ff@@@ff@ff@G@H@Q@p@33@z@=q@@H@@\)@޸R@H@@@ff@@@@A(A
A
ffAA
A\)A(AAzA	p@\)A (A Q@ff@z@p@=q@ff@  @  @G@=q@G@@@
=@z@=q@=q@ff@G@љA
pA(AA  A zA @@=q@z@@@
=@z@ff@@@@
=@@\)@=q@
A (AffAAA\AA  AAGA
=AAAA(A
AQAA
=qA
=A
A
pA\ARA=qAA
HA{AG@(@{@@\)@ff@R@  @\)B
=B33BuBuB33B֣B
B  B{B֊=B33BB)B
BBW
B)BQB33BB.BBW
B\B(BuB\)BzBBي=BffB.BLBB\BQBĞBîBBңBBBffBB#B(B
=B{BzBB33B݊=B  B
=BBBfB.BpBpB=B3BGBB)B8RB3B
B(BaHBԙB(BԅBkBuBBB̞BfB.BĀ BB B{BBBγ3BHBaHB{Bӏ\B8RB8RBzBـ B)BBي=BB8RBՀ BB#B)BBB{B  B8RBfBGCCnBBB)BB=BBB#B\BB\BBBkBBffBŔ{Bó3BBqBBḄBuBǮBҮBҀ BfBBBBffBўBBBBBҔ{B\BB׊=B(BfBѣBљBǮBzBBQB\BuBaHBѽqBѸRB  BBB#B=qBB
B33BzBBqB B̔{BͅB=qBBBW
BpBBB{B=qBǏ\B\)B
BǮBɣBHBʳ3BzBɏ\B.BɣBʀ BGBW
B.B33BBͮBkBʸRB{BfB
=B(BBB(B)B҅BfBϔ{BѽqBLBpB̊=B{BƽqBBBB8RBzBHB(BGB8RBʊ=B)BB#BW
BϙBpB͞BQBǮBBuBBLB=qBBѳ3B#BBLBBaHB)Bה{BuB8RBBڊ=B8RBBԨB׳3B.BBzBffBֳ3B=qB)BиRB
=BBBBkB#Bˏ\B\BLBЅBǮBՔ{B{BHBBBLB)B  B#BBffBսqB33B(BW
BӔ{BHBzB.B8RBQB̳3BBBfBBLB\BBBѳ3BBШBΣBLBB
=BB΅BBuB\)BLBBBԀ BQBҔ{B.BzBרBBظRB֙B(BBW
B
BfBޅBffBܽqBB#B
B.BLBHBuBfBQB
=B\BҨBBB=qBBHBzB=qBB̀ B˙B33BGB#B
BB¨BpB33BƨBHBBfBՊ=B  BfBBkBߞB(BBܸRBHBBBQBB  B)BqB\BBfB\)B8RB{B޽qBuBBLB{B.BuB#BBˣBHB8RBB=qBBaHBB BuBQBBGB)BBuB(B(BLBB(BҽqBpBB(BBBBBaHBQBW
B
=B̔{B΅B33BQBʅBBƳ3Bʔ{BfBBHBB=qB)BBB  B=BB.B  BzB33BGBBBBRB  BǮBuB\BBzBfBQBBffB΅BBBHBBBBfB
=BBGB8RBBBŊ=B
BpB\BBǮBBƸRB  B{B=qB  BBfB\BpBW
B)BaHBGBBBQB(B8RBzB\BGBBW
B#B{BLB B33BBBBBGBýqBQBBuBBaHBGBBB=B.BHB{BqB8RBLBHBB3BzBuB=qBpBGB{BB33B\B\BB\)BBRB=qBBLB\)BffBpBzB3B3BHBLBLBBBHBB=B=qBffBB=qB(BBHBB#BýqB=BB#B B=B=BLB
BGBB BBBBzBkBB\B=qBW
B33B{BaHB\)BfBaHBBuBBzBBB=BaHBBBLBffBB(BB(BB{BƊ=BBB8RB\)BB=qB)BBRB(BW
B\B{BBB\B3B{BBBBqBBBBBBffBffBBBBǮB{BBaHB=qBBBBBǮBW
BaHBBB\)BB\)BffBzB\)BBBBBzB{BfBBB=qBB  BfB8RB8RBB=BW
BB
BB3B(B.BǮB BBBB=qB33BpBQB)B=qBǮB  B8RBB\BBBpB{BBB8RBBffBQBGBQB=BB3BBqB{BB(B=B  B
B.B#BW
B8RBGB B8RBB33B
BzBuBBBffB)B)Bϊ=BHBԸRBңB\B#BB)BBBBBȳ3BuB\B(B  BB3BW
BBBBW
BBB.BfBBB8RBpBW
BfBBRB)BzBHB33B8RBB
=BBB#B=qBqBaHB\)B{B  BffB֮BW
B)B B
B{BB
BBRBBfB=B8RBW
BB(BBBB=qB.B3BkBB\)BfBpBHBqBBBBaHBuB{BffBLBBBW
BBBBBB8RBBBBB(B\)B\BBB
=BB33B#BB{BHBǮBBaHBffBB8RBBHB
=BLB
B  BBB  BBB=BqB#B=B33B\BHBQBBaHBGBBB)BkB=qBBLB B(B\BBLBBBGBBQB{B{B(BBB3B
=BB\B\BzBffB{B  BqBBBzB#B)B=BGB.B(BBBW
B(B{BBkBffBGBGBaHBBaHBW
BBBBBW
BpB.B  BaHBzBuBBBǮBHBfB  BzBBBBBqBW
BBpBBpBuBQBQBRB  B3BBBB.B{BuBB\BkBBHB{BBLB{B\)BQBpBB3BB)B{B{BqB{BBBBBW
BuBBBHBB)BuB33B\)BBBB=qB\)BBBpBRBHBfBffB{BB\)BBB.BBǮBǮB
=BRBLBGB=B{B8RBBBBBB=qBkBBBBB BffBaHBpB\)B8RB=B)B
=BB\BBBBGB
=BB B\)BB(B
=BB\BqBB33B\B)BBqB)B
BBzBkBBBRBaHBqBBBLBHBBB(BB BuB{BQBBBpB\BRBǮB
=BGB.BB33B=BBB33BBLBBzB=B)B
=BLBffB3BB
=B\BBB=BBBBaHB(BffB=qB BHBRBpBW
B#BQBqBBpB=qBBkB3BRBǮBBB3BBW
B{pBfBBBB\BffBaHBzB33BuBuBaHB
BffBzB
BqB{BRB=qBB
=B  BBLBBW
BBB  BBqB\B3B=qB{B BuB)B{B
B\BBB33B\BBBRBBB(B\)BW
B#BǮB\)BB)BpBqBHBpBRB.BzBBW
B{B3B3B(B{BBB(B)BBffBB{BzBRB BBBBBLB{B=BB#B#BHBkBBB  BBW
B=B{BBB
=BBBB\)BBB
BB(B33B
=BkBBLBBBfB\BBBBBB\)BBB
=BBGBBB8RBRBBaHB\BGB
B(BBfB=BGB8RBBQBkB=qBBpB33B  BB8RBB)BBLBBB{BRB8RBB)BB=qBRBB8RBzBtGBqBHBBpBBB{BB{BBǮBB\B#B8RBB8RBW
BHB{33B
=BBByzB#BBbB#BLB)B.BBBBҊ=B׏\BBB#BW
B33BBǮB8RBׅBaHB(B
=B33BBfB
=B߸RBޣBB݀ BBffBݔ{B؊=B׮B#B8RBՊ=B׳3BLB)BfBBה{BϸRBўB.B=qBBffB.BǮBpBBBBzB=qB=qB)BffBٙBԏ\BBǮBҽqBBBǮBBԔ{BӮBЅBB؏\BB  B
B3B33BܞBpB(BBД{BҔ{B˽qBШBΊ=Bӳ3BaHBB.BBУB#BpB33BBУBGBǮBW
BBQBHBzBمBBGBB
=BٮBٞBzBܸRB
=BB؊=BLB  BףBzBـ B)BffBѣBس3BBٙB.B#BkB\B(B
BaHB\)B.BW
BaHB8RBzB{BfBB
=B͔{B
=BuBzB
=B(B
=BuB.BٸRB
B8RBkBBՔ{BսqBaHBؔ{BBBأBLBBB
B{B{BӣB8RBBҔ{BԳ3BӅBӀ B
=BBaHB
Bє{BfBнqBр BuBҊ=BHBؙB׽qBffBfBݞB
BGB  B(BBBRBGB)B噚B\)B33B33B(BǮBBBHB8RBGBuBB왚BfBBkBRB\BBǮB߀ BߣBǮB۔{BBB.BǮBaHBfBW
BԅBW
BB8RBB\)BHB
=B3BBHB噚B=qBꙚB3B\)BBBBpB\BpBaHB=BBuB
=BGB=qB8RBB\)B33BzBBfBW
BBBBBB=qBpBHBQBQBBBW
BzB
=BaHB
=B)BB=qBB=BffBBqBfBB잸BpB\B(BB8RBB#BqB(BBB
BߨBBBGBkB(BfBuBӊ=Bҏ\BB{B)BٙBأB؏\BBB33BzBffBB33B33BHB{B垸BힸBqBBqBB8RBW
B=BBBqB=BzBBGB{BBW
BBLBffBuBGBuBQBBB)B{BB{B\BW
B=qBW
BBڏ\B33B33Bٔ{BǮB8RBLBޙBpB\BLB\BBuBBϔ{BBW
B8RB{BBaHB\)B\B33BBBǮBffB(BǮB\)BB BBGB{B BBBߙB8RBB)B  B(BB#BۙBߏ\B{B؏\B3BpBߙB
=B B8RB.BHBW
BkB.BB
BBB.B\BBB  B噚BBffB
=B#BGBBLBB
=BB33B8RB(BHB߀ BaHBܽqBB.BuBBBB)BffBڮBW
BBHB33BBB
BB=qBaHBqBBBGBpBaHB=B(BB.BB)B B33B=BBBߙBB{BLB3BLBB{BB\)B33B33B߀ BB۔{BݽqBBfBffBB\)BBpBBB.BݨBQB33BB
B\)BBBkBGB  BBffBBQBHBHB.BpBkB{BB{BHBQBaHBBBGBB׀ B؏\BHBBB׽qBHB؞Bٔ{B8RBBB.BBffB\)BpB{BffBkB  BffBB=qB㙚B3BqB(BQB BkBBBBaHB
BB{BGBǮBBW
BQBݨB
BW
BBܣBuB\)BڣBB
B33B\B۔{B۞BB؞B  B
=B֊=B׸RB(BBaHBٔ{BfBBB(BڸRBBBBkB
B(BB\)BBpBqB BaHBGBffBB8RBkBB\B\BHBBߨBHBBfBB=qBB{BBB BHB)B\BBkBBB#BǮB8RBBڙB\)B޽qBB
=BԞBڊ=B(BzB.BB(B(B(BݣBǮBuBBBԣB
=B\)BuB׳3BBBҸRBǮBBр BBǮBƏ\B\B
=B΀ B
BHB33BW
BҸRBLBB
BB(B\Bó3BŽqBŔ{B\)BffB.BǮBBBW
B=qBB33B#BuBԮBօB׀ BLBԣB=qB  BBBBǮB)BǮB  B\B.BBЏ\Bӊ=BB\BuBոRBգBBBB
BϙBBBǮBBǮB#B)BǮBLBңB\)BfBB\)BӸRBLBB=qB(B֔{B=qB
=B֙B=qB)BffBBkBҏ\BB
BB33BҸRBuB#BGB  BGBkBfBHBŔ{B\BǮBQBBҨBffBԣBQBuBˣBƙB
BBƞBBaHBaHB
BǮBuBЀ BHBfBQBBzBъ=B
BʽqBfB̊=B8RB̞BffBfBBƮB)BaHB̨BBQBBɊ=BBBaHBLB.BB8RB  BuBBB(B BBBQB{BffBGBƙB.B8RB(BB
=BaHBBB)BB.BŮBBøRBǮBkBkBGBBHB(BʅBǮBkB{BBLBB\)B(BB\B{BB3B\)B
BBpBǣBQB8RBǣBW
BǮBaHBۀ B)BףBފ=BǮB䞸BB(BBB(B
=B=qB{BkBǮBBBBۅB{B8RBuBB޳3BfB  BaHB.BBpBHBBB\B{BٽqB֏\B=qBۨB\BBuBW
BpB BBB{B
=BبBkBBݮBBBBBpB3BBB枸BBpB#BܮB҅BϸRB
=B=qB=B{BB\BB
=BBpB
Bٳ3B#B׸RBfBBٙBBzBݣBB=qB{B)B
=BzBͮB\)B\)BzBBó3BӔ{BרBՅBڊ=BffBBֳ3BBBҞBϣBB  BӽqBB؏\BLB=qB33B\)BzBBHBBBkB
B̮B  B=qBQBBBQBHBuB{BGB.BzBBBBBfBңBBBW
BBמB؅BpB
=BBW
B왚BB\BBaHBLBW
B)B=qBffBf@@@@@@{@{@@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{@@{@{@{@p@@@Q@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{@{B=qBBܙBB(BܞB.BBǮB
B  BBpBaHBBBBޅB۔{Bۏ\BffBLBBBQBB݊=BBB#BBB{B8RBB{BuBfB8RB(BخBٞB8RB)BGB  BuBڸRBBB
=BLBfB܀ BǮBרBGBW
BB8RBffB(BLBB(Bҏ\BήBД{BLB.BB33BŅB\B
=BʙB̨B͸RB˙BB\)BBW
B  BB\)BԙBBӽqB֔{Bӳ3B8RBΣBfB8RBӮBW
BԸRBݮB۞BBҀ BBuBB8RBQBܣBBB  B
B{BߨBGBffBBܸRBڨBLBޙBԔ{BQB.Bˏ\BəBBHB(BuBHBGB\)BBBB=BBzBLBLBGB.BRBGBBB\)BǮB  BBBBߏ\BBQB잸B
=BBRB(B.BW
B{B B{BpBǮBGB33BffBLBffBRB3B
=B33B3BB  BRBaHB.BͮBBzB\B=qBBRBBHBpBffBB  BB\)B(BB#B(BǮBޣBܳ3B3BB33BBB噚BB\BBBBuBBBBHBB.B.BBfB3B3BBBB8RBB
B
BpB۔{B)B8RBB  B
=BpBBBܽqB)BHBܞB)BGBaHBԀ B#BB)BBBfBمBHBzBיB33BB8RBBpBHBݙBܸRB
B(B(BuBzBB=BkBBߨB\BBBGBۅBqBBuBuB\)B=qBۙB(Bۀ BڙBB)BW
BBBzB8RBؔ{BBaHBB޳3B\BBkB)B۳3BܸRBݔ{B۸RBݔ{B#BW
BuB#BB\)B
=BBފ=B߽qBǮBǮBffBߙBޏ\B=qB\)BaHBڀ B)BfB=qBݏ\Bݳ3BW
B\B8RBٳ3B#BQBkB׽qBBfBB.BٞBظRB33B8RB=qB
B\)B#B)B\B  B)B8RBBBӸRBBB\)BBܞBBuBW
B\BaHBaHBaHBBܽqBBpBBB
Bߊ=BkB  B޸RB=BB3B\B
=B=BW
BqBHBB#BBBǮBqBBBBBB\B\)BǮBǮBBffBW
BBzB\B#B=BHBHBB3B\B\B=qBaHBqBuBBRBݣBB3B׊=B B#BߣBzBBB\BBHB)B#B33B߮B\)BԸRB)B#B{BB{B#BBBBfBB.BW
BfB3BBB33BuB8RBݏ\BǮBޮB\)BpBaHBaHBffBkBpBBfB33B؏\BҀ BLBBuBڣBBLBBBۙBׅBffB#BpBpBB  B(B33BB\)BǮBBܔ{BpBpBЅB8RBW
B۽qB  B٨B۳3B\)BBpBۏ\B)B
=B܀ BҞBBB̨B#BpBLBB׀ BuB\)BLBBB\)B8RB(BuBLBBQBǮB֙BӞBBϏ\BBkBȮB
B.B\)B)BB͏\BǮBBLBpBה{BÊ=B(BLBQB33BBʔ{B޳3BffBݮBB=qB\)BzB
B=qBBBՊ=BBճ3BըBBBzB˽qB)B#BaHBLBє{BǮB=qBBʙBBʮB{B(BuBuBBzB8RB\BąB
B=qBBGB{Bճ3B\BLBLBHB\)BݸRB8RBس3BBBfBW
Bճ3BՏ\BBӊ=BԊ=B(BBBBBB  BaHBGBBʣBB\B
BBBB
BffBŀ BpBƞBaHBHBȞBǊ=Bǳ3BB33BýqBBɣB.BBB8RB\)B=qB׽qBLB  BQBB҅B8RBaHBB
BѸRBBBӞBҀ B#B(B#BǮBBW
BzBkBQBОBӮBQB\BfBřB\B)B  BLBB  BffB33BBɳ3B\BB=qBQBBր BaHBۣB\B۸RB  BB.BkB{BfB؅B
BظRBמBֳ3BuBHBaHBԊ=BGBpB\BBǮBȊ=Bǔ{BŨBBBHBƣB33BHB)BBLBŞB8RB
=B
=B˅BBHB{BQB.Bя\BОBkBԮBBǮBBB{BϮBuBЀ B.BfBuBãBB®BǮB=qB33B
=BuBQBBBģB33BfBLB=qBW
BĔ{B.B)B=qBBBǮB8RB B\)BpB(B.B
Bʔ{BBBpBBaHBpBBB
BHBfB{BLB\)BHBGBBpBǮBBB{BkBQBBGB\BBGBkBBBBQB
BkBB3BGBBBHBBBuBB3B
=BzBQBBB.BBB(BQBęB=qBzBffBzBB
=BBBBB BkB\B#BW
BB=qB33BB\)B3BkBB{BBB#B=qBaHBuBHB.B{B
BBBBLB B
BBQB{BBBW
BBB=qBŮBŔ{BB
BaHB=qBLB{BfBBGB
=B#BkB(BBqB\)B
=BqB  BǮBB\BBBaHBB=qB(B{B
=B{B)B)B3B33B{BB8RB\B
=B#B#B  BǞBB  BƮBzB8RB)BffBǮBB
BGBRBB BBkBaHBB{B#BBaHBBkBB{BHBB\)B
BB B  BBB8RBQBB#B{BBB
=B\BBaHBB8RB\BBQBB#B{BRB33B\BBffBBB  BB  BkBzB33BB
BRB3BBHB{BB3BfB)BBB\)BBB)BBuB\BfBLBBBǮBkB BBzB\BBBB(BaHB33B(BfBBGBHBBǮB{BBBBGBB\)BpB\BHB
=BBBuBpBaHB
BBB BBB)B{BRBBBLB\)BBqBBuBzBBBBǮB  B
=BfBQB B.B8RB(B)BBB=B=qBLBBǮBW
BBBQB{BBBB8RBB)B\)BaHBzBqBB{BB(B BB\BBBǮBB=qBHBkB
=BB\)BB=BGB B{B\BBzBQB)BBB
=BQB)B B{B~B|
=BaHB~ffBz  B8RB{(BxByGBxHBmBw(BuBo=qBq(BlGBv\)BsBnBkBcBdRBbB^
=BZBTzB[BZQBY33BWRBU  BVBY(BXGB[RB[33BUB_ffB]QBYBT\)BVBUpBPBQpBV(BVBPBV  BQBQ
=BE33BD{BDB@\BHBIHBF\)BBRB@BB
B<B?ffB>ffB:B>pB@BB=qBA=qB=\)B>B>(B=B?=qBGBK\)BKBDB@\)BFffBHBLBGRBGBABAzBBffB<GB;GB:B6{B2ffB1ffB1B,B*B,B.ffB-HB,(B,
B(B'=qB((B.\)B-GB%
B'(B'B&B-
B)\B,33B({B)
B-QB+ffB(33B'  B*RB1B7B'ffB'33B2B0GB<B1B1{B5
=B0QB-ffB'\BRB"RB$zBBBB=qB\BBGB33BBBBGBBzBHBBBB33BB=qB =qB A=qAAQABB
GB B=qA\)A33AAAGA
=AAAAHAAAffAGB A  AAA癚AA޸RAAޏ\A  AGAAAA\)AAҸRAУAQA\)ApA=qAA
=AʸRAͅAQAƏ\AAȏ\AGAυAAA{AAQA\)A\)A\)A=qAHA\AAApAAA  AA=qAAQA
AA
A\)AAAAAARAApAffA
=A(AzAA  AHAA
=A
AA{AGAA
=A\AAAzAAA
=A
AAAApA
AAQAHAAAGAA(AAAA\AHA(AAHAAffAA
=AGA
AAGA(AffAA\)AzA
=AHA}GAwA_AjHArffAnHA]GArRA|zA}Ax  A(A
Az=qAAsAmGAk
AlAkAc
=Ak
=A_
AeAV\A^{A^ffAXAGAVffAPA_
=A[AdQAbffA^RA`Ag
=Ah(Ac
=AXQA`AfRAs33AmAnHAyAc
A|A~RAA{\)AQAiAqGA\AN\A\AkApAdAR=qAV=qA^RAYANffAG
ADzAK33AS\)AOAL(AIGAEAFRAFHAG
AEADA>ffAKAIpAK
=AIAC
AO33ALzAAABHAN\AQA?
=AYAdAeAb=qAb=qAn\AupAjRAT  AB\A_
=AcAXAaGAbffAk\)Ah  A_AS\)AGA@AHAGAD  A7
A>=qAG\)A0A-GA/33A4A6=qA.RAEGADA5A2RA,(A&{A)A7\)A?\)A8QA2\A,  A-pA A$A5GA:\A<(AIGA8zA1A;A@  AD(A/\)A+A((A!A-AA/\)AA'
=A,(A:ffA8QA>ffA@(A:HA5A5A8QA>=qA733A$AA)A4A=GA9A.HA1GA6{A?A>HA@(A7
=A/\)A$zA*ffA'
=A"RA@A-GA A5GAA;
=A?AB=qA,AC\)AAGA.ffA
A\A33AAAffA*{A.HAHAzA3A)A!A QAA)A(QA$QA  A
AA33A=qAA33A(AA
=AA
AHAHARAGARAAAA zA  AHA
AQAAHAzAQA(AQAAA
=A
=A  A	A33A  A\A{A\)AffA
A\)AAA	GApAA=qAA
=A{@A\)AA33AQAffAAAAffAQA\)A	GAA
A
AA
A\)ARA
A\)A{AA
GA=qA\)A{A  A\AA$(A@\@(@@(@@@H@G@@R@@@ff@@(AffAA @ffA{AR@AzAHA
AQAz@AA
=A\)AA"=qAQA=qAA
=A\)@ffA (AA@\)@\)A@(@@ff@H@@@(@ff@
@  @@\)@A(@\)A=q@A\)A
AA=qAA33AQA(@\)A
RAARAARA=qAA
A
RAffAA\)A
RAA(@QA33@\@(A AHA33A
{A	pA	Ap@A=q@@AffAffA@
AAAAQA	A
ffA33AAAGA(A\)AAzA{AzA=qA\A  A{AHAzA  @{B@{Bi\)B{BBǮBBqBBpBBBBB B3B=BHBkBQBGBpBBBW
BBzB\BRBBBBfBpB{B#BffBfBBBBBBqBBBBBqBǮBB{BB\BfBqBB.BBRBBB\)BB=BBBBǮBB\)B=qBB33BB(B BBB{B(BpB
BffBLBBB33B3BǮB\)BBBB#BzB#BQB#BBBB)B3B(B=qB(BBBBB{BaHBLBڨB{B#B#B=qB8RB\)B)B݊=B(B۳3B  Bي=B  Bڏ\BٸRBي=B=qBBB{B=qBW
BֽqBHBBffBѣBzBBҞBBB
=BffBHB֞BBkB33B=qB(B߀ B=qBGBzBǮBffBffBaHBBBLB޽qB
=B=qBۮB8RBB#B=qB߳3BB33BBǮB޽qBޞB݊=BܣBڀ BQB֊=BB
=Bٔ{B)BBB݅B
BBB܀ BBڮB=qB{B  B33B\BB BBQBBBkB{B{BBzB=B(BB#BB33B8RBBuB=qBHBB=qB.BpBBB#BǮBՔ{BBHBה{B  BHBظRB٨BمBBkBW
BǮBB
BBCCCJ=C}qCCW
C CW
BzB
BuBB3BzC GBBzBW
B(BǮBB8RBՀ BpB
=BԔ{B֊=BՙBfBuB  BB#B\)BׅBW
BfBܮBޙBݳ3Bۏ\BaHBQBۨBB׊=B  B.B8RBBBQB\)BuBԣBԅBԀ BB
=BB͙B
BB\BB\)BήBўBLBBQBBB  BHB33Bҏ\BffB
=BHBԣBfB{BֽqBuBW
BfB\B.B\B\)BBخBuB33BfBLBծBkBԀ BՀ BBBǮBBBfBLBԽqBBBӽqBӊ=BB\)B)B̀ B#B=qBBϸRB͙BB(BBaHBҔ{BfBՔ{BLBkBؔ{B
=BڙB8RBڨBݏ\Bߏ\B\BBހ BaHB#B=qBڔ{BBBBpB׏\BW
B8RBzB(BpBٽqBW
BkBB=qBה{B\)BBBuB33BBԅB\)BQBB33BԊ=BՅBLB=qB\)BٙB(Bڏ\BaHBݏ\BݽqBBuB߅B8RBޔ{Bߊ=B33B
=BB\B8RBuBGBីBBBGB܊=B
B8RBB
B\BHBB܀ B)B{BBݮBuB)B{BٞBBBfBԊ=BԣBBBB8RBBݸRBܳ3BfB(BB  BuBuBB=qB\)B=qBffB  BLBBQBBGBݔ{Bۏ\B{BיBQBBW
B33BՊ=BHBٽqBuB{B܀ B՞BBՊ=BBBffBffBaHBffB#B8RBW
BpB)B  B33BW
BpB\BzB.B(BB#B\)BffBBB  B8RBB8RBQB=B.B\B߳3BuBffBǮBGBLBB=qBHBB
=BܸRBkBBٽqBzBffB
=B
BpB܅BBHBBBӏ\BaHBՏ\B֨BBبBB؅BQBGBٞBfBBڸRBڮBBڙBڅBڽqBkB\B#BB(BffBٔ{B
B#BHBBQBB{BpBԀ BGB8RBBLBBBBBBB33B֊=B=qB)BB(BֽqBBBBuBBݣBݽqBQB
=BBB۽qB\B)BkBܳ3B)B܅BQBkBBBB
BffBkBǮBԊ=BLBfB؀ BӨBuBҔ{Bր BGBW
BըB҅BBBfBzB
=BuBzB8RBǮBBBBLBمBfBޙBBuB  BBBkB{B=qBfBBBBzB  BGBHBBfB՞B\B׳3BBffBݨBBB33BBBڀ Bـ BB#B=qBߊ=BBݨB=BQB\)B\BݨBffBǮBǮBB\)BzB.BB.BqB3B=BBB#BfB\BBBRBHB#B.BBᙚBBBBHBRBBBaHB.BBuB33BGBzBfB8RB BBǮBݽqBHBBB
BpB\)BBǮBpB  BޅBBߏ\BB8RBBHBBBB BfBǮB㞸B)B\BuBB{BLB BڞB)B8RBǮB{BQBzB)BaHBݙBBBBBqBQBkBaHBB\B(BkB B\BBfB߳3BߞBB\)BzB\BB\)BBBܮBW
B߅B܀ B  B
B\)B B܀ BۅBLBB)BBۀ Bۏ\Bۀ B)BLBQBuBBڮBB33BܨBBي=BBuB)B)BB33B=qBB
BuBBBBQBB枸BB{BBBW
BBW
BB噚BffBLBBܸRB\)BBBݸRBڀ BffB8RBB{BܞBըBGB{BzBGB٣BaHBޙBߞBBǮBݮBڔ{BB(BBpBfBݙBߨBB➸BRB)B(BRBpB33B
B#BpB䙚BBaHB{BޞB33BHB8RB33B\B)B
BBB(B
=B
=BBޞBpBkBLB٣BۅB8RB(BBޣB׮BQBkB֨BBW
BB޸RB#BB.B\BB
BីBQBޮBBzBܞB܀ BGB)BffB׽qB׳3BB؀ B\BBkB֊=BaHBffBҙBя\B#BΙBaHBɞBQBBkBW
BHBǮBҔ{BBpB\BծBBBB)B33B)B٣B܏\Bڳ3B#BBߙBffBLB߽qBߊ=Bފ=BB
=B\)B
BGBBB֙BaHBBٔ{B\B\)BԨB33B׳3B\BkBaHBBBzBBB33BӮBpB  BqB(B܀ B8RB(Bڀ B.BBBuB߸RB\BBBBB\B(BLBBB33BLBB{B#BffB{B{BffB3BܮBBBBzBBW
BfBLBBffBBڊ=BBڔ{BuBٮBڏ\B߳3BظRBW
BܞB\)B)BBBBBBBQB  BW
B(BQBW
BzB#B
BǮBBB#BBBBBBǮB8RB\)B=BBHBkB=qBGB\)BGB\B#BרBٸRBBQBB3BffBkBqBBB  BBǮB(B
=BkB8RBB=BBLBqC O\CJ=CBBBǮBBBB3B
=BGBBB{B)B
=BpB33B\BuB=qBBGBuB\B{BبBffBBB{Bݳ3BB3BힸBBBB{BfBǮBBaHBaHB\CCHBRC =CBpB{BuB\B(BkBQBzBfBB=qBBBBuB=qBBB\)BuB\)BffB
BHB  B33B8RBBBB\BꞸBuBBB(B(B.CGC8RC:C	:CJ=CC	CC	O\BB{B=qBBQB.BHBpBBpBzBBBBLB{BqBB
BqB=C0B{BBpBHBB{B3B
=BkB=BBBBzB.BB=B
=C\C\C\BBǮBB BB#B枸BLB=BB  BBLB(BBBuBB33BqB(B)BBBBBqBܔ{BBB޳3Bۏ\BǮBHBaHBBHB#B
=BB{BBBB.BB
B  B33B=B  CCs3C
C
=C{C
BBBLBB.BaHBHB BBB߅B߅BB B{Bޔ{BQBB8RB{B\B33B33B8RBfBǮBBBaHBBBB{BB
=B۽qB
B(BuB(BaHB B\B{BBBpBǮB
B晚BuB8RBGBW
BB  B
=BBuB33B٣BׅBuBր B\B8RBԽqBظRB  Bה{B=qBBֳ3B=qBffB8RB33B  BףB\)BԨBճ3B
BkBpBLBڅBۏ\BaHBBBaHBGBpBݞBBkBfB{BBqB(BBQBBBaHB
=B.BB33BBޞB  BW
B#B
=BB33B3BB BqBuBBBBܸRBBޮBB=qBڮB\BB\)BqB  B.B噚BHB8RB8RBBB\B{BuBzBffBBBkBB#BBBLBGBBBGB\)B=qBBBB֨BLBٙBڞB\B33BBpBzBkB\B
=BB{BpBݣBߨB  B(B)BqB{B
=B(BGB\B3BB.B噚BfBkBQBܸRBݣBGBB\)B
BBBzBaHB#B{BpB(BGBBaHB{BǮBBBffBffBBBBQBkBُ\B)BGB{BuBBBaHB޸RB=qBBHB3BaHBBB{B\B=qB=BBB3BfBLBHB\B
B8RBB.B
BܞBߨB\)BBHBB#B.BBB׸RB\)B(BBB\)BuB8RB֙BBԔ{B33BׅBؔ{BBأB  BW
B
=BkB  BB\BBzBGBBBܳ3BB)Bڊ=B׊=B33BB׏\BfB
=B  BٽqBڞBGB\Bӳ3BBuBBuB\B.BBBGBٮBُ\BzB(Bϊ=BLBѽqBfBB
=BBaHBpBBfBfB
=BfBB BBBGBB  B\BBᙚBGB߽qBۀ BBٮBٙBףBܸRBBBHBHB
=BW
BzBGBɮB{BBzBkBfBB\)B̙Bɔ{B\B\BzB33B#BW
BBBBQB
=BfBLB
BpBB(B{BǮB8RB{B33BB8RB.B  B\)B\BkBBۅB\)BBBӮB\)BǞB\BB\)BBBəB=qB)B̳3BffBBBǮBϙBЏ\Bє{BGB׽qBգBB(BؙB{BpBس3BW
BpBpB#BBfBQB޸RBB{B8RBߏ\BfB\)B
=BBBaHB\B
B#B8RB̸RBB8RB.BBQBBBBB  B(BkB  B(BϣB8RB=qBkBHB(B(BB\BܸRBfBuBBBBkB۸RBـ B؀ BօBpBBB
B)BB(BB#BBffBHB\BBBkBpBОB̮B׸RBBՀ BڞB8RBД{BٮBQBي=BfBBԅBǮB  BמBffB)B)B۳3BB)Bފ=BޞBBBLBីBBB)B\B  B
Bߔ{BzB\BۮBB.BܞB{BBBHBѸRB)BuBuB{BQB8RBBBB\)BfBHBϔ{B33BՅBB33BGBzBfB{BuBW
BBB8RBBHB\BBffB
B3BLB33BBaHBBߏ\BBBfBffBkBB(BfBBffBBBBBBpBؔ{BHB׸RBي=B  Bڏ\BBۙB)BخBۨBBBffBBBB3BB=qBaHBB
B\)BffBBBBaHBGBfBkB)B#BqB\BpB\BBGBBffB{BB\B{B8RBGB33BBޅBB߮BޙBBzBBzBǮBBBٳ3B#B䞸B#BB
=BpBBkBBBB#C C}qCW
C =qBRBBBBB)B{BLB枸BpBLBBފ=BpBB.B\BٙB8RBBBBӮBffBԊ=B#BuB֔{B׽qBB=qB3B.BB=B  B)BW
CW
CC=qC(C

=CkCC
C
BǮC cBBuBqC kC )C \B)BBBGB
=BLBzBB)BB)B#BfBݣBzB=qBffBB8RBaHB)BfB
=B3BpC{B3BGBQB BBB\)B\B枸BGBffBB  CB
=BBaHBBߣB߳3B虚B߽qBمB=qB8RB{B
=BBBB)BW
BBffB
=BBBffBݞBܮB#BBuBpBfB(B.B#BLB3C
=CqCCBC
:C
pCC.C=C5C
CBLBBzBB\)BaHBB8RB8RBBBffBBB=BB
BޅB#BB#B BW
B߽qBpB\BBHBkB
=BW
B8RB#Bߊ=BBBaHBfBBB{B)C =BBBkBLBힸB)BQB BBۣB#B.BBBߙB#BBLBBBBBBLBBԸRBӔ{B(BuB\B8RBaHBzBQB33B܏\BLB
=Bڏ\Bҏ\B\B\)B#B
B BBޙBB#B  BB
=B랸BB=qBB鞸B)BaHBW
BkBB\BqBBBBGBBHB(BB.BuBffB{BkBףBBBǮB8RB٣BBBffBBBB33B\BGB߅Bޏ\B)B(BBߨBᙚB➸B33BB)B
B=qB.BW
B=qBuB)BBڳ3Bڔ{BQB.BBBծBB#BB(B8RB=qBBϣBBѨBpBaHBBuB\BǮBB#BW
BW
BBծBQBܣB  BB\BW
BBB=qBaHBQB\)BuBLBBQBGBBBzBBGBBBB(BBхBaHBffBҨBpBѽqB(BHBW
B͞BHBpB{BkBHBΨB(BpBBBӮBfBQBǮBظRBǮBkBffBBGBfB33BݽqBݸRBߣBzBǮBuBBBkB\)BΊ=BBffB#BB8RBffBzB(BШBHBkBπ B
=BkBGBΔ{BB=qBЅBήBҙBѳ3BHBBBBBGBգB  B=qBW
B\Bڔ{BHBB.B  B=B=qBuB.BBHBBخBBBQB\)BHB)BLBֽqB۳3B  BLB֏\B33B33B؏\BaHBBB
BpB{BB33BuB  B8RBuBֳ3BBB.BzB#B  B)B33B  BkBBB.BBBǮBǮB.B\BߙB B\BuBǮBڳ3BBfBfBuB=qBB{Bފ=B݀ B۳3BpB
=B(BzBBǮB\)BqB
=BB  BBBBBBuB
=B BB=B枸B\BB
=B\BBBǮB癚B陚BfBffBQBqBW
B݀ B)B
=B\Bה{BBBـ B)B{BaHBB؊=BHBBpB
BzB=qB)BpBB֊=BpB\BB(BffBBB=BBBBB{BB\B
=B(BB\)B\BB
BW
BW
BBBBBW
BB\B߅B{BBqB{BBzB)BBLBB߳3BBڣB(BffBfB
=B瞸BHBBBB(BBBB=BBaHB#BBBBBkBBBqBqB33B  BBBuBBkBBRB߀ BW
BݨBffB8RBBݣBzB
B(BW
BօBLBٮBLB#B)BQBuBBBaHBBBW
BkBǮB\BGBǮB{B#BBHB
BzB瞸BBfB\)BBffBBB\BuBpBaHBfBuB޳3B  BfB\B{BBBB8RBBB  BBBBpBܞBٞB\BBߨBpB3BQB\BBuBBBzBfBQCC}qC\CCCqCcCHC {B33B B{BܸRBޅB{B8RBqB B(BpBaHB(BB.B BRBB BW
B B33B\B)B
=BW
B=qBLBGBB BfB{C BC(C8RC
C
HCC)CCBffCC5CCpC )BkB3B\BB
=BW
BBHB{B׀ BffB(B33B
=BRB{B8RBB8RB#BB.B{BBǮBBHBBB
=BB3BBB(BBB=qCCCCfCBQB  BB{BpBW
BBBQBBpB=qBߔ{BHBuBB33B\)BըB̮BҊ=BBuBB.BǮB߽qB(BߣBBBpBBǮBffBBqB(B#B\BLB(BuB
B\B
BC )BHBQB
=BaHBfBBqB=qB.BBB♚BBGBfBBB  B33BBޔ{B߸RBB=qB(BШBpBB۳3BΣBB.B\)BGBzBLB\B33BBB\BBBB33BBLBGBBW
BB\BQBފ=BBGB
=B(B.BB8RB33BffB(BУBBpB)B׮B.B͸RBўBBB
BҞBBΣBzB(BBBBBB\)B  B٨BB\)BBBݨB(BHBfBBBpB\)BǮB\)B{BB۳3B33BBBGBѸRBkB8RBBGB8RB֨BB{B֞BuBBB.BuB8RBaHBД{BuB
BB.B֔{BffBг3BB  BB{BLBB=qBHBW
B
=BW
BW
BuBBBBzB.BpB
=BaHBGBkBffB(BkBBaHBB33BBuBЏ\B{B#B͔{Bπ B
=BBՀ BBBBW
B33B#BB{BبBB\B߸RBRBW
B3B{B3B8RBBBBBBBB(B{BۨBBؔ{B.BǮBGBУBΏ\BʙBBB
=B8RBQB33B
=BfBϞB  BpBBBBBaHB
=Bπ Bє{B
BLB33BLB33B݅B.Bڊ=BB#BqB33B\)B虚B8RBaHBBffBpB\B)B\B)BkBB.BB)Bُ\BGB=qBkBǮBǮBˮB(BʮBʔ{B8RBɣBɳ3BɊ=BzB{B#BǮB\BB)B.B)B̮B(BBB\)B{BzBٔ{BBuB)BaHBǮBBBBǮBBB
BٙB֊=BǮB\)BBB  BѸRBHBBBW
B=qB\B\)B)B͞BfBəBHBpB=qBuB̨BBBBΔ{BBGBB8RBB
=BBB(B\BB؞B۽qB
B\B8RBBQBB{B33B=BB֨BB
=BBBʊ=B
=B8RBW
BBǮB̳3BBγ3BuBͮBBB˳3B̏\B͔{BήBaHB
=BҸRBֽqBԞBzBBBݳ3BqBݣBW
B޳3B߳3B B(BB{B BBרB\BW
BҙBW
B.B΀ BLB)BBУBͨB̔{BʮB8RB#BuBGBϸRBB  BͨBaHBB8RBQBB.B33BսqBр BB(BB8RB\)B(BB؅BBոRBخBܞB\)B33BߨBBLBB#B(B8RBԨB\BBHBBaHBBfBԣBӳ3BҮBӀ BЊ=BBHBϏ\BkB(BkBBaHB8RBBW
BQBBBkB33BuBfBBB۸RBW
BzBۊ=Bۀ B
=BpBBBߙBߊ=B\BB
BpB޽qB♚B)B߸RBfBGBي=BB)Bފ=B܊=BffB߽qBpBuBHBGB
=BBԳ3B(BԅBǮBQBBB8RB  BGB=qBB\BLB\B.BLB=BB\BB\)BuBRBBLB{BB➸BBBB
=B  BaHBW
BB
BfBBB\B\BרBԞB֏\BBffB=qBaHBЀ BήBGB BGBBBffB B\)B=qB8RBBۙBB߽qB BB8RB
BꞸBB㞸B\B8RBHBBfBfB\B(B
BB#B{BGB.B\)B.BBBՔ{BҮBҨBpB(BuBҙBLBӳ3BBfBѨBQBǮBأBpB؅Bڳ3BBffBBBBB(B#BBBBzB\BٽqBB߅BW
BGBݳ3BaHBՅBB.B\)B)BBLBʮBBBkB
B8RBBB
=BɮBBBpB(BaHBuBaHBBHBBBսqBBBBGBLBLBLBRBuBBkBpBW
BqBRBB  BBBBBǮBRBB{BffB8RBBBݔ{B33B܊=BB۞BffBܨBB  BQBGB#Bؔ{B֊=BfBǮBHB33BBߔ{B)BBGBfBB BLBpBpB=B\BqB8RBBߏ\BBzB\)B)Bڔ{B33B#BB#BBBB)BB
=B
B
=B  BpBfB33B܀ BޞBǮBπ BBӀ BBzB٨BkB݀ BٙBޣB
BaHB(B
BBGB8RBuBǮC&fCqCCB8RBBBٳ3BBB\)BLBԅBHBB  BӣBըBHBُ\BBBBBffBBB(BB(BQB(BW
B뙚BQBaHB(B{BBLBBqB=B\BkB\)C BzC)CCCC BpBffB(B
BQBBBB\)BB#B8RBB=qBBB)B8RBkBB#BB#BfB8RBីB8RBzBB
B(BBBpB33B
=BBffBGBW
BCB(BB=qC0C
B{B)BffBݣB\)BB8RBLBuCCBRBLB{B
BpBӞB)B(Bي=BaHBQB  BݮB(BzBBB  BǮBBB.BzB8RB虚BHBuC BC(CCC	
CqC
C@ CC C3CCC3qCC{C3BaHBLC }qBBB
=CJ=CxRB)BfCHCO\C@ CqChBRC\BBzBǮBaHBB
B֮BBzB{C5CCRCuCBB8RCHC C#C
nC\CC)ChCCHCuCC=CB B.BBffBGB)BQBLBQB3CCCBB{BBB8RB\BB\BHBB
BBBB(BuBzBޮB♚BB
=BpBpBC0C C)CC
&fCٚCnC!cC!YCJ=C
aHB8RC\)BRB
=CO\BQBkB=B#BߣBHBuBRB(BBBBBB.BBzBBBB̅B\)Bس3BuBBӨB=BLBkBC BǮBBuC+CLC(C CCaHCBCkCBffCffCCBBGBqBBW
B=qB{BW
BBٽqB֏\BffBzBBBB=qB33B؞BLB\BffBڮBW
B#BB(B33BaHB)B{C#C3CT{C	{CC&fCC&fC	RC33C&fC5C!HCǮBBBfBB33CGBBBB33B{B BB=BǮB8RB.B)B\)BRBǮBpBBՏ\B
B=qBuBHBBGBBuBffBBaHBCcC.CRC	CCBCcCaHC
xRC
8RCC(C.BLC{B\)BׅB虚BzBՅBǮBQBzB)B\)Bր B=qBǮBBBʅBQBBuB33B)BϮB8RB
=BBBfBՏ\BٮBܙBݔ{Bܔ{B.BBBBBQBCxRB)B{CBC\CBW
B33BB
BpB  B3B(B\)B֙B{BB
BQBBB
=BϞB.BHBBθRBB(B\)BB)BB33B#BօB
BkBaHBBBBB8RB(BffCCC BqChB3BB\BBBfB♚BLB  B
BaHBQBٔ{BգB8RB׊=B\B\)BkB
B˽qBBǮBǳ3B)BȸRB
=BÀ BǨB
=BǮB؅BB(BQB#BaHB  BaHBǮBB\C=qC J=BBB
BBB(BqBCB B3B\)B\B螸BB=B#B#BB  BBЮBaHBHBѣBҨB8RB{BգB\BǮB
=B8RBޮB(BW
Bڔ{BffBB\BBB33BBqBqB=B\C B
CCC
{Cs3C+C CaHCC
CBBRC:C ffBzB  B BǮBǮBB3BBB  B(BffBfBGB.BW
BB
=BǮBHBB{BݣBBRBBqBkB8RCCJ=CǮBBQB
B33C)C\)C}qCC8RB\B\B\)B\)BW
BBBڊ=B{B{BpBBB
=BB
=BܽqBGBpBffBQB#B)BϞBBQBB҅BkB  BBQBzB#BB BHBBW
BB BpBBBRBB#BffBBHB.BӅB{BЀ B8RBBuBΙBΨBBBHB)BŨBpB(B\BBBBƮB)B{BB.B\BkBB\BυBǮBBBˣB
=BfB
=BǮBffBB\Bƀ BBُ\Bγ3BfB
BBHBBHB\BRBQBLB{BaHB33BqB\BBB)BuB\)BB\)B.BBuB8RBB\BfB3BB BffBÏ\BBŮB8RBŅB)BffBBuBBBaHB.B̀ BaHBBBBBW
BB\BzBW
BBkBУBϙBfBGBpB=BW
B\BLBuBffB  BzBkBkBĀ BHB)BǮB
=B˸RBΞBBBW
BبBBٳ3BGBkBB3BB)B.BfB\B)B33B{CBfB BBǮB܀ BfBB#BǮB{BkBг3BսqBHBBfBpBfB8RBLB8RBͮBҏ\BӽqBW
BHBuBpB\)BBBBaHBBB(BQB
B{B=qB.B\CECBCLC )CfC RBBB{B=BqB㞸B#BܽqBڅBB
=BׅB\BBBԽqBǮBBBBkB=BHB  BBB{B33BBB33BBW
B)BGB{B\BzBuBW
BRB  B\BBqB=BffBpB8RB{B(B=qBLBkB\BpBB{BBB
B  BB.B)B
=BBBB
=BLBffBW
BqBB B{BBB#BHB
=B)y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AQAAGAŮA(A  AŮAA{AŮAzAʸRAA=qAɅAʏ\Aʏ\AAGAA  A˅AˮA˙AGA(AffA(ẠAQA=qAAAA  A\)A
A(A\)Aȏ\AHAȏ\AHAA\)AřAƏ\AŮA=qAȏ\A=qA{AǙA(A{AəAAAffAAHAʸRA33A  A(AzAHA{A\)AzAffA  AA̸RA\)Aʏ\AɅA33AɮAȏ\A33A33A\)AA\)A33Aď\A(AîA(A{ARA¸RAřA(A=qAǮAƸRAA  A=qA{A=qA=qA=qAffA{A˙A{Ȁ\AAffA\)AffAʏ\AA33A
AAͮẠAHAA͙A
AͮAˮAAƣAAAɮA=qAffA
=A\)AA\)AɅAǅAǙA33AȸRAəA=qAffAffAʸRA{AɅA
AɮA33AGAȏ\AGAA
A=qA{Aʏ\AApApA˙AˮA=qA(AAQAQA  AəAAȣAHAHApA\)A{AffA\)AɅAHA˅AʣAAQA£AîA33AAřA\)A=qAzA(AAGAǮApAAAȸRA{AAȏ\AɅAA
=AAHA  AʣAQA{ApA  AAAHA
=A(AɮAQA
=A33AǮAAȣA=qA
=A(AǮAřAʏ\ApAAHAɮA
=A
ApAGA
=AʸRAzAHAA
=AAGAʏ\AʸRApAʸRAApA=qȀ\AAAAAAAAȸRA
AHA=qAƏ\A
AȸRAAQA{A
=AGA(A
=AɮA{A
=AAAAA33AθRAzApA{AA\)AA33AAͅA33AHA\)A
=A˅AffA˅AffA(AA(AʸRAAʣAA33A=qA  AQA{AA
=AGAffA
A
AHAřAQA  AA{A=qAffAzAffAA=qAHAAA{A
AAHA
A
=AGA\)AHAɮA33AɮAffApApAɅA
AǙA  AA{AȸRAzA  A(AQAɮAffAGAģApAQAA\AQAģA(AQApAȏ\A  AAəApAȏ\AGA=qApAɮA33AȸRAffAzA=qA{AǮAǙA  A
AǙAHAAzA˅AQAͅẠAAffA˙A  Aʏ\AHA33AHA33AffAQA{AQA{A(A  A  AɮAHA\)A̸RA͙AAʏ\AffAffA̸RAA{A  A(A(A{A
=A(AAʏ\AGA\)AAGA\)AȣA(AffAA=qAApAA{AGAAA{AAzApAzAzA
AƣAAƏ\AȣAHAzAHAA
=AAŮA  A(AǮAA
A
AəAȣAȣAȏ\AA(A\)A
AǅAAGAGApA\)AAǅAA  AǙAAAGAǙAƸRAA  A  AģApA
AA\)AAAAffAGA(AGA\)AHAǮAAǅAAǮAQAffA{AǅAǙA
=AAGAffA(A(AA=qAffA(A
=AəAA  A33A
=A33AŮA\)AA
=A
AffApAAAA\)ApA=qAAřAAHAĸRAAģA
ApAAGAAzA33AǅA  AGAǮAǮAǅAǅAA(A=qAGAƏ\AA
=AAƏ\AƸRAAHAA
=AzAƸRAApAHAQA=qA  AAzAAGA  A
=AAHA
AAď\A=qApAƣA
ApA  A  AɮAGAȏ\A=qAǙAƸRAǮAAGAA\)AAffAƸRAffAƣAƸRAffAzAAA(A\)AGAƏ\AffA
=AAAřAA
A=qA
A
=AŮA  AřA33AŅAGAA(A(AƸRAA
=AA\)AGApAǙAAǅA33AAAƸRA=qAffAƸRAƸRAQAGAHA{AAAGA
=AĸRA=qAĸRA(A{A(A(A  AîA=qAA=qA{A
A=qAGAAzA  AHAffAA{AŮA=qAffAApA\)AģAA
=AApAƸRAƏ\AƏ\AAƏ\AzA
=AǅApAAA(AHA=qA33AƣAǙAAǙA{AȸRAȏ\A¸RAîA  AƏ\AƸRAîA
AAřAA\)Aȏ\ApAffAA˅A˅A=qAHA=qA
=A33AAȣAzA˅A\)AAGAQA\)AA33AȸRAHAzA  AAA  AQA{A\)AǅAǙA  A(AƏ\AQAQAGAAffA  AȣAffAƸRA  ApApA(A=qAƸRAAHAǮA  A
AzA=qAHApAA\)ApA33A33AAAffA{AAA
=AA(AƣAApA33AAŮAHA\)AffAHAA{AAĸRA  AAGAAQA(A\)A  A33AȸRAGAɅA\)AHA
=AȸRA{AǙAzA  AAHAAǅAǮA
AAffAQA(A=qAzAǅAƸRA
=AAřAģAŅA\)AA
=AŮA  Aď\AƏ\A  AȸRA33AǙAHAǙAQA
=ApAA  A  A
AAɮAAQAAA=qAA  A{A
AAGAGA{AǙAAƣA=qAƣAzAzAƏ\A(A(AƸRA(AffAģAA\)A\)AHApA
AffAAA
A  AHAAǮA{AzAȏ\AȸRAzAȏ\AQA{A  AǙAǅAzA  A{AA\)A\)AffA
=AƣAzA  ApA33Aď\AAHAĸRAA{AAzAŮA(AGA\)AAffApA=qAď\AŮA  AƸRA33A
AƣA33AǮAAffAQA(A  A  A  AǅAƣAAzAA{A{AGAHAzAƣA(AGAƣAGA
=AĸRA
=Aď\AQAAA(AĸRA=qAffA
AÙAffA(AA=qA  AAA\)AǅAƣAřAŮA  A{A
AAffA33AǮAǮAǙAǮA
AzAAAffAAAHAGA33AzAffA  A33AHAHAď\AŮA  AģAÙA33A£A
=AAGAÙAîA
A\)ARAAAzA  AAA  A\)AîA(AA\)A\)AĸRA  AAzAÙAHAģAď\AHAAA
AÅAGAAAAApA
=AAGAA  AQAA\)AÙAîAHAA¸RA\)A\)A=qAA
=AÅAA(A
=AQA£A
=AzAď\AA=qAAƸRA
=A  AA33AAƣAzAA(AffAQAAřA
A(A{AAŅA\)AA
=AffAAffAffA=qAffAffAA\)AAQAAzAď\AAHApAĸRAA{AAŅAffA
=AÅA\)AÅA¸RAGAzAAGA¸RAď\ApAHAAffA{AÅA
AA{AQAĸRAřAA33A\A\)AA=qAÙA\)AffA
=AffApAffAAzAzAAA33AÙAAHA33ApA
AAffAAÙA\)AAA£AAHAffAÅAģA
=A\)AAŅAƏ\A
=A33AAƸRAƸRAƏ\AHAƣAffA  AģAzAģAzA
=ApAAAGA  AzA  AzA33A\AAAÅA{A{Aď\AGAŮA
=AÅA\)AAA=qA\)AQAƏ\AƏ\AQAHA
=A  ApAď\A\)AģA\)A
=AAAzA  A  A=qAď\A(AAGA(AAŮAApAzAHApA¸RAÙAŅAŅA=qAHAŅA  A33Aȏ\AȸRAAřAGApAQAHAHAHAAŅAAAHAAHA\A{A33A(ARAHA\)A(A=qAQAA
A\)ARAA
=AAAA33AffA(AQAAGA\)A{A\)AAffAAÙAîAApA
=AAAzApAAAzARAAA¸RA{AffAA{AzA£A(AzA  A\A
A
A=qAAffA\)A£AA\AÙApA=qAA33A=qAHARApA\)AAA{A{A
=A33AQAQA\AzAAA(AHApA=qAzA
A33A
=AA\AGAffA{AffAřAGA\)AHA£AA\)AzAA{AzAffAGA{A
A
=AApA
AA
=A
=AŮAAA
=A(A  AQAGA
A{AAŮAzA
AÙA
A(AAÙAîAHAAģAAGAA  A  AHA
AAffAAAA
AHA{AA  A33A
AƸRAQAŮAƣA33AAAǅA33A(AəA
A\)A{AHA{A  A  AzAȸRA33AAHAAAffA(A=qAAǙA33AAA
=AAHA=qA\)AffAHAAzA
AƸRAA{AApAA  A˅AffAɮAʸRAA(Ȁ\A̸RAffA{A˅AʸRAA
AQAA(AQA{AAAʸRAA\)AGAHAʏ\A
=AʸRAʏ\AɮA(A\)AApAɮA\)AGAǅAAGAGAAAffAAəA33A(AAƏ\AGA33AHA
=AGAA
A
=AAGApApAGAȏ\Aȏ\A33AAəA{A{AApA33AʸRAȣA(AGAˮAA{AAAˮAǅA
=AGAQAA\)A
=AǙAGAHAAGAA{AÅA
AApAzAAƸRA(AƏ\AffAApAŮAŅAGAAĸRAîAHAģA33A{A=qAQA(A=qAQAƏ\A
=AzAƏ\A=qA\AAď\AAřAŅA=qA
AģA£ApA33AA
AAAzA
=A33AA  AQA
=AGA=qAA
AQA{AGAǮAǮAƸRAŅA  AAHA
AĸRAHAAAHAzAHA
ApAffAHA  AA=qA\AffA
A\AAď\AA  AHAƸRAAAffAƏ\AƣApAGAApAzA(AA  AAŅAǅAǙAHA\)AzA33AřAŮAƏ\A(AAAƸRAģAAHA¸RAQA{A¸RA
=AřAÙAîAAƏ\A=qAA(AŅA
=AffAď\AAÅAHAÅA33ApAffAA{A{AÙAAQAAHAAAzA¸RAQAHAffAffA\A\A¸RA£A  AA(AA=qAA  A33AAA
AzAA  AAGAAffAzAA\)AAA\AA33A{A(A(A  AARA(ARAGAAHAA(A=qARAAAA(A\)AAA\AffA
=AAAHAAAA33A
A\)AA\AAAA  A
ApA
AzAGA{AQAGARAAAzA\)A
AA(A33A\A  A(A
AGAzAAHAA
AA  AffAAA=qA\AA  AGA=qA(A  A
=AHAA33AffAAGAHApAAA(A(AA
=A
A=qA\A\A\AAA=qA  A(A  ARA(A\A\A{AA=qAA33AA33ARAGAQAAAA
=AAAAAzApA{AffARAzAAA(AAHAA\)AAAA\AA
AA  A{AA\A{AGAAffAAHA{AQA(AAGAzA{AARAHA\A\A
ARA(A  A  ARApA=qA\AHA(AAAAQAGA(A=qApAA
AGA\A\)AAAAHAAAAHA\)AffAzAAffAA(A
=A=qAGA\)A  A
=AA=qAQAA=qAA\)A  A{AAA(A\)AAAA{AzAA\AAAzA{AA
=ARAA\)AA(A(AGAAHAHAffAffARAA  ARAffA\A\)A\)AAAAHA\AAA\ApAzAffAzAAA
=A\AAQAAAQAHApAA
=AA\)AA\)AGA{AAAA\A  AA
AffA\ApAAA  A=qA33AA(AffA
AA
AA
A  AAA33AAA
=AARA  A\AGA{AAAHApARAzAA33AffAA
=A
A\)A=qAAGAA\)A(A
AA33A
A
ApAA\A  AzA=qA\)AAGAAHAffAAARAAA
=A{AA33ARAA=qA
=A{AHA\)AGA
=ARAAA33AQAQAAQAQAGA33AffAA=qA=qAGA=qAzAA\)ARAzA(ARAA
A  A33A\)AAA{A\AffAApAAAHA33AA
AGA  A  AHAA{AA33A\)AffAHA=qAffA\AA\)A
=AffA  AQA
AA33A
AAA(AAffApA
ARAAApA\ApAAAA\)AAAffAAGAGARAApApAA\)AAA  AAA{ARAAAA\AA33AAHAQAAAAzAAffAAA33A{A  AA
=AA=qAffA\)A
AA(A(A
=AAA=qAA
=AAffA\)AAzA  AHARAAzApA=qAffApARARA
A(A33A=qA\)A  AAAAAHAA
=AAAApA\AAffA
ApAARAAzA\A33A(AffAffAAQAA\)AHA(ApA
AA  AzA  AAAffA
=A
=AAA\)AAQA\)ARA{AH@ffAAA  AA33A	A
=A	ARAQAzAGARARAHA
AAffA{AGA(AffAAAAHAA	GA(AAGA zAA33AA(AGAffAAHA(@  A(A
pAAA=qApAA  AHAGA\AffAAAA(AAGA(ApAffA  A\A
A  AHAAQAA
AA  ApAzAQARAAGAQAHA33A
=AzApAARA  A\A\)AQAAA\A33AQA33ARAQA\)AHAA33AffA
AAffA  AQARAApAzA
=AzAQAAA\A\A
AAA=qAGAA(AAffA
A\AA\)AApAAHAQA=qAHA
=AffAffAAAA\A{AA
AAA=qA  A(AA\)A  AAApAzAA  AzA  A\)A\A{ARAAA=qA=qA\AA(A\AQAzAQA
=AHAAffAA{AHApApA
A{AAGAGAA(AHAAQA\AApA\)A  AAA\AAA\)AAA  AQA
=AQA
ARA(AAGAAAApAQAAAffAAA  AAHA{A
AA33A(ApAA33AAA\)A\AA{A\ApAAAQA{A  A
A33AAffA\AAHA33AA\AAAGAAA33AA(ARA33AAA  AGAQAA=qAHAQAA(AGAAffAAAA\A=qA=qApAA\A
AA
A33AHAQA  AQA
ApA\A\)A
A
=AA=qA\)AQA\AAHAA(A(AA(AGAAA
=A(AAAA\)ARAAHA(AffA\)AQA=qAA
AA\)A
A
A=qA33AGAAGAAAAA33AffAGA(AA\AffA\AAAHAARA{A{AAA(A33AAQA{AGAAQAHA33AAAQApAHA
ApA
=A\AffAAAHApA(A=qAAAAzAA  A
=AzA(A(AffA{AA(AA=qA  AAAA  AA=qA\)AHApAAA{A
=AA33AA=qAA
AHA{AA  AHA
AA{A(A
A\AAA{AA  AA=qA  AA{ARAA\A  A{AAAAAA(ARARA(AARA\AA\)A  A{AffA
AA(AAHAA=qARA=qA(A=qAAApAGA=qA\)AA
=AHAzAzA\AA{ApAA\AARAAAGApAGARA(A
A=qA33AA\)AHAffAAAA\A
AHAQAAAAffA\)AzA  AAGAQAARA  AGA33A\A\)A(ApA\)AGARAA  AffAA
=A  A  ApARAA
=ARA  A\A
=A=qA(AAAA{ApAHA  AAA  AA\)AA=qA(AHAAzAA\A
AAAA
=AffAQA=qAA\)A=qAffAAAAzAQAQAffAffAApAffA
A\)AA{A
ARAA
AARAAA(A=qA\)ApAQAQAAQA{AAQA(AGAHA\A=qARAAAA
ARARApAGA{ARA(AAAzARA
A(AQAAA
=AÙAHA=qAApAffAQAAzAGA\AA\AA33A
AQAA=qApAAAQA33AA
=AffAARAA(ApAGAzAzAHARA
AHAzAAGA  A33AA(AAA
AGA\AAARAARA\)A(AGAAAA=qAffAAA
AAAAffAA33AAA  AHAzAAHAGA
=AA33AA\AQAffAQAAA
AAAApARA
AGA
=AHAAffAA
A33A(AÙA
A
A\ARA
AQAGA\AA\AzAAHA=qA=qA  AA=qARAAA\)AQA{A£AAffA
A=qA\)A\)A£AAGA=qAzAAGA\A33AA\AHA  A{Aď\A\)AAAAAApAApA(A\AAA
=ApAA\AAAAAA33A\)AHA  AzA(A  A=qAAARAGAAAA=qA(AffAGA
=A
A\)A\ARAHAAzAA  A\)AGA
=A  AAAA\)AAHAHAAAAGA33ApAAARAAQA(A{ARAffARA=qA(AApApApAAA\)A\)AffAzA  A33AA  AAffAAQAA
A
=A(ApAGAHA
=AAAGAGA(A  AAAAAGAGA33AApAA  AHAGA33AARA(A  AzAAAAģA  AA
AAģAĸRAřApAQAA
=AGAAQAA  A(AA¸RA\)AAAîA  AģA=qA=qA
=AHA  A=qAA33AAGA(A(AQA33AGAAģAAA
AA
AA
AGAÙA{A
=ApA33A
=A  AÅAA33A33AQA
A
=AAŅAď\A
AA(AA  AAĸRA
A{AAAA
A33AGAQAǮAȏ\ApA  AffAAffAffAQAA=qAQAAʸRAˮAˮAAɅAəAzA  A  AffAʸRA\)ApA=qAA{A\)ApAǮA  A{A(AAQAAGA  AɮAAHAAHA=qA  AA
A
=A{AͅAzAͮA
AȣApAAȸRAAΏ\AAGAGAA{AAˮAɮAzA=qA˅AQA̸RAzAAAHAAȏ\A(Aʏ\A
ApA˙A
=AɮAʣAffA
A  A  AGAQA
=A\)AzApA33AQAΣAϙAzAHAGAGA
=AΣAffAA  A  AAAAAAGAA=qȀ\A=qAGAAA33ApAAˮAģAAŮA(AAAA(A  AHAǙAȸRApAA
=A\)AGAA˙AGA
=Ȁ\A=qAzAzAˮAQAffAȏ\AɮA=qAˮA33AQA
AɅAAA
=AˮAAApA  AzA\)AɮA\)AɮAAȣAȣAAƸRA(AƸRA{AɅAAAQAʣAHAAHAffAffAɅA
=AɅAA  A
=A{A
ApA
A33AAɮA=qAȸRA\)AəA\)A\)A\)ApAAHAəA33A
AHA
A\AAAA
AģA=qAGA(A=qAAÅA
AffA(A  Aȏ\AɮAɮAHAQA\)AQAAQA(AzA=qAǙA=qA
AǅApAAAřA=qA=qA{AffA  AA=qAģA(A\)A  AA
=AA¸RApAĸRAAÅAGAA=qAGAAAGA\)AŅAŅA\)A  A=qAGA  AA(AAHA33A(AAzA\)AAAAHAzAzAƸRA\)AHAA\)ApAA\A  AAA\)AAAAAĸRAGAƣAƸRAAQAɅAAA\)ApA33A{A̸RAA\)AHAAzAAAAA
A
AAGA(A\)A
A33AAzAQAŮA{AGAƏ\AzAA
=A33AGAřAffAHA  AÅAAAQAĸRAA\)AŅA=qA
AAARA33A£AGAřA33A
=AQA
AAAĸRAřAAzAQA
A33AARA\)AApA(AQAffAGAAA{AA\)AHAAGAHA{A(A{A(A\A\)AAAAAHA  A
A  A
AGAřAƸRAffAQA=qAģA
=AĸRAGAA{A
=AŅA\)A
=AAģA33A£ApAÅAQAAAHA
AAzAQAA  A(A  A\)A{A{AHAĸRAřA\)A
A33A(AffAǙAȣA\)AA(AffA
A=qAzAA{Aȏ\A(AQA  AAGAAAřAA33AAHAGA\A¸RA(AAAAAA33AzA
AA(A
A33AAď\A=qAÙAA{ApAA=qA(A33AŅAď\AîAGAîApA33AAQAA33AîA=qAîA{AzAGAGA(AA  AHA33AA
AA33A  AAAzAGAffA\)AGApAHAA\AQAAAAA  A\AHA33AAApA(AÙA£AģAÅAApApAHAÅAAApAQA{A(AzA{AAzA(ARA\A  AAzAHA=qA\)AApAffA\AHAAA
=A
=A
AA=qAAHAAAQAA{A=qA(A  A=qAzA33AÙAA\AÙAÙAAGApA
=A
=A
AA=qA  AQA\)AAAGA
=AHAA=qAA=qAAzAAA(A=qA  AHAAGA{A{AAAffA  AffA\A
=ApA\)AÙAÅA\)A
=AHAAffA£A33AA33A\)AAA{AQA(AGAHA
=AAAAAA{AA(AffAQApAAHA{AAAA=qAAÙAAģAA33A33AzAģA{AGAA33AAffA(AĸRA(A  AîApAGA
=AAÅA{A(A=qAA  A33A33AHAHA  AAAAA  A
AHA\AzA
AA=qA
AAGAƣAAAQAAffAQAÅA£AA\)ApAAGAHAQA¸RA¸RA(ApAQAAffARA¸RAzA\)AAA\)A{AAHAAAAAAffApAAA(AzA¸RA
A33AřA  A=qA=qAGA
=AAÙAHApAÙA
=A33A33AA
=AGAGAAQA(AQAAzA£AAAHAA(AffAAA=qAAzA{AHApA
AAApAAzAA
AAÅA  A
A  AAQAA
AAÙA(AzAģAA
A{AA\)A(A{A
ApAĸRAřA  AHAAA33AAģA=qAApA  A
A=qA\)A33AA\)A\AA
AQAÅAQAA\)A
AřApAA
=A=qAÙAARAffAřAAAzAA
ApAAAzA
AAA
A
=A33A  AA=qAAHAAAGA\A(A
AAGA\AAGARAffAAzAAzAA=qAffAA(AGAAA\)A
A
AAQAzAAAA{A\)AQA¸RA  A  AzAA\)AA\)ARAffA(A=qAAGAA=qAAAAAQAffAzAAAGAQAAGA\)AzAzAAA(A
=ApAAHA
AGA  AAAHAARAAffAffARAAAA\AQAA  AA(A  AHARAARA  AzA\AGAAARAffA
A\)AAGA  AAA(ARAAAAAAzAA{ARAAAAAzAQA\)ARAAAApARAAAAffARAffApA(AHARA33AAAA(AGAHAQA33ARAHAAA  AHA\AApAHA33AAA\AAQAQAARA  A=qAAApAAGAzApAAHA\)ARAAAAARApARA{A=qAAA
=AA  AA
AGA=qAîA{A
=A{ApA(A{A{AApAHA33AA(AA(AAzAĸRA  AQA33AƣAzA
AřAď\Aď\Aď\Aď\AzA(AA33AAA\)A¸RAAQA=qA33AA(A{A£AA  ApA¸RAAQAHAAAA
=AQAA=qA=qApA\A\AA=qAA  AAA  A  AQApA{AAzARA\AA
=AAAA33A
=AHAAzAApA\AzAzAffA  AAA{A{AAAARAffApA\ARAQA
AzAApAzAARA
AA\)AAGAAÅA(A=qAǮAǮA
AGAA33A˙A33AGAȏ\AƸRAȣAď\AǙA
AƏ\AzAǅAƏ\AffAƏ\AƏ\AffA  AA\)AAQAAAAAĸRAA\)AA(A{AÅAA=qAGApAAǙA  AQAȣAHAAAȸRAzAȣA  A{A(AAffAApA=qA
=AȣAHAGAA{AǮA
=AHAA{A(A(AŅA  A33AÅAffA
=AîA
=A33AAA  ApAAzA(AģAǙAHA=qAAƏ\A
Aȏ\Aȏ\A  AAA  AzAƸRAAA
=AƸRAA33AƣA\)A{AQAzAAffApAAAHA
A  A
=ApAAGA33AffA=qApAAAAHA
=AzAAffAǮAɮA
AHAɅAA
A(AffA{A(A
A
=A  AQA  AA˙AGAʸRAʏ\AGAHA\)A33AȣAzAȸRAHAffA=qA33A(AǮAǮAƏ\AǅA33AƏ\AAȣAAHAA{AffA\)AHA33A33ApApAɮAzA{A
=AGA33AAGA\)ApAəAɮApAəA\)AA{A
=A33AGApA
=A33AA
=A=qAȣA{AAǮAAzA(A
Aȏ\AɅA33AAQAAffA
=A\)AHA=qApAAAzAAHAɮAffAʏ\AʸRAffA
A˙AffA33AAGA33A
AAGA=qA(A=qA  AA
A˙AˮA˙AʣA\)ApAAApAʸRA{AəAAAȣA  AAA33A  Aʏ\A
=AGAAHA=qAGAzA33AA  A˙Aʏ\AA\)AHAAͅA33A̸RApA\)AGAffAA
AˮA
=AʸRAʣAA33AGA˅AffA  AŅAˮAA(AʸRAHAffAˮA33ApApAzA(AẠA=qA  AA{A{AzA̸RAA̸RAˮA  AzȀ\A{A  AAQA{A=qAffA{AA
AA=qAˮAʏ\AAA
AffAA
=A\)AAˮA  A{AʣApA
=AAǙAHAʣAQAˮApAHAAAAϙA
=AυAθRAHA{AͮA{AffAffAQAffAAQA
ApApA
AApA
AAzAA˅A{A{ApAA˙AǅAAzAHA
=AͮA
=AAQAQAΣAHAϙA
AGA(A=qA  A˅AAzAǙAzAAGAffAAAƏ\AřAAA\)AHAƣA  A
AzAQAGAQA{ApA\)A  A33AƏ\ApA=qAA  A(AɅAffAHA
AA  AffAAzAǮA
A  ApA=qAA(AA
AHA
AAȸRAzAAAffA  A(AA{A33AAApAAŮA
=A=qA(AA\AĸRAA  AQA  ApA\)A  AHApAŮA33AHAffAʸRA˙A
A
A(A˙AAAˮApAˮAGAHA  A˙AzA˅AHA(A(AQAʣAAA
=AQA\)A
AGAAA
=A
A{AƸRA(AǮAQAAHAɮA=qA33AAƸRAffAɮAGAAͮAAͅA  A\)A
=AǅA  A
A
A{AAGA
AǙA\)AGAA(AQA{AŮA(A
AA
=AGApAÙAAAAHAzAGAA(A  AQAHAAAGAÙAģAŮAA{A  A
=ApAAA33AϮAAGAHA\)A  AA\)AAǅA
AǮA  AAA
=AřAŅAzAGAQAď\AffA{AA\)Aď\A=qAA
A(AA  AAĸRAffA33AHA\)AGAA33AA
AA(AAzAA=qAA(AzAffA{ARAzA\A£A(AffA{AHA{A{AA(A(AAA\AA33AAQA
AHAAAHAAAAA\AQAQA
AAHAffApAApAŮAřAA
=AAffAĸRAA  A33AA
=AÅAHA=qARA=qAA
=ApA
A\)AÅAA33AAAAffARARA\)A£AA  AQA\)A{AA(AAffAAffApAffAɅA˅A{AAɅA=qAAAAÙAǅAƣApA  AffAffAȣAƸRA(AzAGAGAĸRA=qAHA\)AAřA=qA\)Aď\AffAAřA\)ApAîA
=A(ApA\AA\)A
Aď\AAǅA33AĸRAŅA{AffAȸRAȣAřAAA
=A
AƏ\A  A\)AAffA
AŅA\)A
A
=A
=AQApAɅAHAAQAffA(AAzA
=A  A\A
=A=qAA\)AApA\AîAzAAA
Aȏ\AHAɮAffAA33AHAŮAApA\)A=qAAAŅAÅAGAGAzAĸRAGAzAʸRA
A\)AəA{A  A
=AƏ\A  AAȏ\AAģAď\AAA
A
AA{A  A  AAŅA
AƣApAQAffAAɅAɮAAA\)AA=qA
=A(AƏ\AffAÅA{A(A=qAGAAHAffAApAAA  A=qA=qAAAAQA
=AffAQA=qAGAAAAAA(A{AHA\)AAzAzAAAGApAHA\)AzApAǮAA
A\)ApAAAffAĸRAA¸RA  AA\A(AGA33A  ApAA=qA
AffAĸRA33A
A
AÅAA(AAAGA(AAzA(Aȏ\AȸRAzAAA
=AHA
=AAAQAAA\)A\)A33AQA\)AĸRAģAAHAAzA33A\)AîAA
=AQAffAAîAAÅApAAzA\)AA33A=qAGA=qA
=A  AQA
=A
AHAApA
ApAQAǅAzA=qAʏ\AzA{AffA  A  A=qAApAGAHAAHAA
A{AffAzAHA{AA=qAHAAHA\)AəA{A=qAAHA
=AǙAǅAHApAAffAHAGA33AAˮA=qA  A  A  A(A  A˅AʸRẠA͙AAA  AϮAθRA(AGAAȏ\A(A
=A  AAAʏ\A\)ApAQA33AzA
AẠA{ApAAGAzAffAÅA33AGA  AHAA\)ApAffAəAAQAAA33AffAA=qApAȣA  AA(A33AGAGA{AHA˙AǮA
=AAzAzA
A\AGAHAA  A
AApA
AAȸRAzAAffA  AƏ\AffAƏ\A33AQA  Aȏ\AAȣAȣAAȏ\AQApA{AGAA(AǮAHA  A
A=qA
AAffAQAGAŅA\)AAGA
=AÙA  A(A=qAģAzApA  AAŮAď\AGA  A  A
=AAAəAA\)Aȏ\A\)A33AHA
AGAɮA=qApA  AȸRAHA
AǮA(AAȸRA  ApA
A=qAA\)AƸRA  A{AřA
AzAffAŮA=qA¸RA33AffA
AȣAffAřAA
=AŮAzA
=AffA=qA  AAʸRAʏ\AAAAʏ\AǅAʸRAA=qAAHA{AAAǙAHA
=AAAAÅAAGAffAffAĸRAHA{Aȏ\AÙAʏ\A̸RAAˮApA  AA
AHAÅA  Aď\A{AŅA=qAApAAɮA33AAAʏ\AzA\)A{A\)AAHA33AAHApAAA33Ȁ\AAGA
=AAQA\)A\)A(AzAA\)AzAʣA{AƏ\AǙA(AAQAHA  ApAʏ\A˅AHA=qA̸RAzAA̸RAGAΏ\AθRAHAͅAͅAAA
AzAAHApA33A  A(A33AAffAΣA˅AAAˮAA=qAA\)AA˙A
ApȀ\ApAͅAAͅAΏ\AHAɮA̸RA
AHA(AzAAAՙAәAzAAGAGAQA
=A
A
A\)A(AЏ\A
A
=A  AAzAA
=AΏ\A
=AΏ\AzAͮAQA
=A{AͅA
=A(AHAQA  A{AzA
=AzA
Aȏ\A(AAиRA
=A
=AAAңAHA
AQAҏ\AңA
=A
AA33AffAzAѮA\)A\)AA  AAѮAAQAҸRA
=A(A\)AA͙AиRApAffAffAffAиRAAffAυAϙA{AHAGAAΏ\AHA
=AHAA  AхAHAGA33AиRApAAApA{AA\)A
=AAzA
AGA
AHAQAA
=AAAΏ\A(AA(A(AθRAzA
=A(A
=A(AƏ\A˅AQA  AȣAAHAGȀ\AʣApȀ\A=qAA(A͙A33A
=A33AHA=qAzAAGAA33A=qA33A  AхAAA\)AA{AәAffAzAzAȏ\A33AApAApA33A̸RAGA  AͮAQAHAиRAиRA
AAzAzAAzAAAӅAҸRAffAAңA(A(A  AGAGA=qAffA{AљApAffAA{AAиRAθRAGAˮApA
=AʸRAAffA͙AHA(A(AA\)ApAzȀ\ApAͮA
=AɮAAQAGAA=qA
=AGAͅAffAAAAA
AϙA\)AAʸRApAͮAΏ\AA{A=qAQA˅AHAffAQA{AzAGApAď\AffAʏ\AAAȀ\A
=AA\)AAA{A
A=qA\)AzAʣAzA
A\)A=qAQAͅAzAθRAAQAGAHAAA=qAΣAθRApA\)A33AffAAGAȸRAAȣAA  AAffAʣAGA\)AA(A  AffȀ\AGApAA  AQAAAͅAHAAAAҸRAQA
AAAAУAљA
ApAѮA(ApAAffA  A33AA(AA
AApA=qAffA{AQAffAA
=A͙AͅAA\)AAAHAzA͙AHA  ApAθRA(AHA{A{AffA
AΣAЏ\AQAAA33AυA{A\)A\)A
=A(AAffAΏ\AA=qAAϙAA{AA
=AɅAQApAAHA  AffA  AAffA
AA˅AʣAAʸRAθRAЏ\AΣA  A\)AΏ\A\)AQAGA{A
=ApAQA\)AAffA\)A(AУAffApApAΣA
AzAAAQAA˙AẠA(AQAApAGA
=AQAHA=qA(A˅A{A  AzAzAffA  AAAΣA33AΏ\AA˅A˅AGApA(A=qAȏ\AAAʏ\A˙AAʏ\AA˙ApA=qA(A=qApAʸRAʣA\)A
=A  A33AGAAǅAȸRAffAA
=AQAAAffAHAHAəAAA33AzAȀ\AAAͅAffAApAУAzA
=A33AѮAAʣA=qAңAЏ\AA\)AQA(AHAA  AAGẠAzAApAǮAHAAAẠȀ\A
=ApAHAAzA£A(A£AHAGA
=AffA
A(AGAɅAʸRA  A˅AˮAHAffAHA{A33A33A  A
AffAAHAA
AAA(A=qAəAffAŅAHAA=qAzAģAAA=qAffAAzẠAAzAʣAffAAˮAffȀ\A
=A͙ApAAͅAA{AΣAΣAθRA  Aȏ\AɮAA(AθRAHAA(AA
AA̸RAzA\)AGAΏ\AAHAGA͙A
A{AAA  AHAȏ\A{AʸRAGAȣAA(AffAʸRAGAͮAAAzA
=AQA(AQAGAA=qAAAA  AͮAA  AУAҏ\A  AAAϙAQA͙AAA\)AAӅA  A33AAzA=qAυAѮAAAϮAљAzAGAApAffA\)AHAffA\)A33AzAAAAffA
AңA\)AGA=qApA{A33AA=qAApAQA
AAAͅAzAzA=qA
=AHA33AȣAͅAЏ\AzAA
=AңAHAљAAApA˅A\)AffAͅAzAAυAA{AQAУA
=A33A\)A(A  AхAA
ApAхA=qAAzAAA
AQAΣA
=AЏ\AAЏ\AzA33AͅAQAzA
AAzA
A=qAҏ\AApAAHA  AAA33AәA33AӅA  AzA
AHAGAљAңAffAA\)Aԏ\A33ApA(A
A  AQA{AϮA
=AA(ApApA{A  A\)ẠAQAAQA(A{AAzAAA(AAͅAΏ\A  AA\)AGAЏ\AиRAхApApAA(A  ApA
AӅAҏ\AӮA33ApAҏ\AAffAAffAҏ\AAzAGAAHAͅA\)A
=Ȁ\A  A
AGAAAffA˙AA(Ȁ\AAA(AzA=qA
AffAzA33AΏ\AAA{A  AAHA\)AGA
AәAffA{A\)AӅAAҸRAGApAQA=qA  A
AϙAͅA  AAHAУAA33AΣAΏ\AA{AҸRAυA33A(ApAA
=A  A͙AGAиRAѮAҏ\AGAӅA=qAAծA  A֏\AffAAՅAAׅA֣A(ApAffAzAGA{AGAԏ\AffAffAӮA
=AAӅA33A(A{AҸRAӮA33AәAAHAҸRAңApAәAQAӅAHAҸRAԏ\ApA{AApA(A؏\AA
A\)AGA(AA
A\)A׮A
A׮AA  A  A33AיAָRA  AAAΏ\AͮA
AGAAHA=qAљA
AϮAGAA(AҸRAӮA=qAAAAAԏ\AӮA(AHAAHA׮A  AQAAظRAأApA\)AAQA=qA=qA{AGA\)AأA=qA\)A֣A
=AծAGA=qAAAAHAGAzAGAָRAAԸRAA33A
Aԏ\AAAAծAzAQAָRA\)AQA=qA(A
=AA
A
AQAGAA\)A33AڸRA=qAۙA  AٙAHAAA(AQA=qAA\)A  AHAHA33AAԣA{ApAffA
=AAGA
AхAљAA
=AљAљAѮApAԏ\Aԏ\A=qAzA  AՙA  A=qAָRAיA֏\AA
AHA֏\AAAA
A{AӅA
AӅA=qAљAAυA
=A33AAAθRAҸRAA33AѮAθRAΣApAхAиRAA
AGApAҏ\A=qAGAԏ\AHAHAԏ\AծA؏\A׮A  A؏\AffA=qAA֣A\)AGAQA33AׅAffAGAԏ\AffAffAѮAҏ\AAA
=AљAУA=qAGAΣA\)A\)AΣAffAϙAͮA(A  AAẠAHAzA=qAHA(A33A{AzApA
AՙAՅAՙAՙA{A33A33AA{AָRA33ApA
=AzAљApA=qA{AυAHA33A
=AΏ\AA33AAA
=A
=A{AΏ\A  A  AQAʸRA  AΣAAGA(A  AHAAљAхA=qAQA=qAA(A
AzAQAЏ\AθRAУAGA{AAzA
AffA\)ApAA=qA{AGAQA̸RAGAAAAQAQA̸RẠA{AQA{AA\)AGȀ\AAΏ\AΏ\AθRAffȀ\A
=AΏ\AA
=A33AAGAGAAHAΏ\A
=AΏ\A(AͮAGAHAffAAͅAA
A̸RA  Ȁ\A˅ApAAGA
ApA=qAQA(A(AʸRAʸRA(AGAʣA˅A(A
A(A\)A(AQAQAQA=qAGAffA
A
=AGAA33AGA  AәAӮAӮAffA=qA\)A
=AҸRAңAQA
AApA{AA{AЏ\AͅAA(A
A=qAzAHA(A(AϮAQAGA  AA33A  AffAQA
AffAУAA
=A(A  Aҏ\AGAA{AϙAЏ\AЏ\A{AA
=AHA(AΣA
A  A
AθRAΣA=qAͮAΏ\AQAAzAHAzA{AAȸRA{A{A
=ApA  AʣȀ\A
AHA̸RA˙Ȁ\A
=A  AAϙAzAApAAQAԏ\AԸRAԏ\AԣAԏ\Aԏ\AӮAәAҸRAҸRAA  AApAHAΣA33AA\)A
=A33ApA\)AAQA(A
AzAͅAzAGAθRAʣA33AQA  A
A˙AˮAQA
=Ȁ\A
AΏ\A
A{AffA33A(AAAGAԏ\AzAQA
AӅAA\)AAAԣA\)A
=AAAzAәAA
=AиRAAA=qAzAЏ\AffAϙAΣA  ApẠAA{A{AAAиRAAѮAGA(Aҏ\AHA{A
A\)A(AA
=A33AA=qAffAAAffA{AAӅAzAzAffAңAQA
AυAA\)AѮAҸRAиRAA  AQA{AHAϙA(A
AHA
=A{A  A33A33A33A=qA(ApAҸRAQAAѮAҏ\AAљAHAGA33AAffAHA33AУA{AљAHAAA  A=qAυAυA\)AAHAHA
=AGA\)AzAzAffApA͙AAΏ\AAAͅA33A(AϮA
=AHAУAυAAQA
=AAԣAՅAQAҸRA
=A  AAљAљA
AzAHAffA  AffAΣA33AGA  A{AθRA(A  A{AȸRAA33AQAɅA=qAAHAəAHA{A
AA33A{AˮA
AθRAθRAGAA=qA
A
=Aԏ\AAAӮAHA
AУA(AQAAУAQAQAQAθRA{A  A
=AAGAAAAQAAzAȀ\A
=AGA˅AAˮAHAˮAQAA=qAͅA  AͮAffAzA=qAυA=qAHA
A  A\)A  AffAQA(AzApAzA(A(AAApA=qAA(AУA33A
=A{A  AAAQApA(A  AzAΣA
=A{AzAA  AAA͙A{A͙A
=AͅAΏ\AυAϮA{A(AиRAУApAA(A\)AzA=qAAϙAHApAAffAɅA\)AɅA(A
=A
=AzAAzAA{AAAȸRA
=AAAffAA  A(AͮAffAͅAQA
AHA  ApAGAхAңApA(AffAԸRAӮA  AәAzA{AҸRAzA{AхA(AffAGA{AQAA\)AA\)A33AffAˮAЏ\AΏ\AHA
=AAAHA  AѮApA\)AAA
A{AAʸRA(A=qAHA(A  AQAGAAәAAA  A̸RAA͙AA
A(AA(A{AzApAԸRAQAхA  AθRA͙ApApAQApA  A  A̸RA{AQA
A
AϙA  A
=A
A=qAA\)ApA
AffAQAffAzApA(AApA  A=qAҸRAҏ\AәAHAӅApAԸRAѮAϮAAzA33A
AApAӮA(A
ApA  AHA
=A\)AGAԸRAA=qAԏ\A(AͮAθRA
=A
AHA(A
AGAՅAAAӅA(AAGAAApA33A׮A  AGAمA(A֏\A֏\A\)A{AAA
=AԸRAԏ\AأApApA{A؏\ApA  AA
AA{ApAHAиRA
=AAQA  A  AљA33AԸRA
AA33A
AәA
AQA
AأAffAHAHApAAڸRA؏\A
=A؏\A
=AffAA33AأAA(A  A  A\)AAGAAAQAGA  AAzAA(AQA(AθRApAңA\)A
AѮAzA\)AAҸRAzAA{AA  AԣA\)A(AծA  AzA=qA=qAָRAAzA(A=qAApAAхA\)A33ApAԸRAәAԏ\A
=A
AAffAzAAθRAԣAԣAHAHAA{A
=AAHAQApA
AffAУAиRA{AHAAӅApA
=AA(A  A  A{AԸRA{AAԣA=qA33AӅAAGA\)A
=AҸRA(A
ApAхAҏ\AffA(A{A
=A33A\)A33A  A  A\)A{AңAffAQApAAAхA{AӮA
AAAHAظRAGAffAAAffAAָRA\)AظRAأA
AAffAظRAA(AffA\)AffAԏ\AA\)AzAҏ\AAңAAAffA(AAA
AHApAzA  AzAA=qAָRA\)A{AAծApAGAٮA33AA
=AffAׅApA
=AQAAՙAHA  AծAָRA\)AAHA֣A֏\AԣAGAՅAA=qAѮA\)AՅA\)A{AAA33AAͅApA(A33AffA=qAѮApAAQAӮA
=AӮAzApAHAӮA
A=qAҏ\Aҏ\AGAQAA(A=qAAЏ\A  AAͮAGA
AAHA˙AGAAffAɅAǮAƏ\AAəAAQAAA\)A\)AͅA\)AffA=qAˮAHApAAΏ\AΣAΏ\AϙAϮAЏ\A33AHAңA{AQAffA  A=qAͮA  A̸RAzAʸRAHA=qA
AQAԣAиRA
=AƏ\A(A33AAffAAAAAď\A  A33A
ApA{A
A\)A˙AA{A͙ApAљA{AAՙAәA
=AzA
=A=qA\)AәAӅAҏ\AHAҸRAхAGAAffAHAAA=qAхAGAAѮAAљAAAQA
=A\)AϙAHAͅA
=AиRAУAиRA33AGAңAAхAхAQAA\)A
A
A=qApAAӮAծAA  AzA\)AHA
A=qA(AՅAzA=qA
AAЏ\AAAA
AAϙAQAхA\)A  AҸRAңA
AQAѮAңApAffAԣAApAAQAAAҏ\AAԣAGApA{AzAA֣A
=AAQA=qA
A33AՙAAԣAGA33AzA(AzAHAGA33A=qA
=AAAA33AGAHAхAAAQAAA
AԸRAΣAAffAAffAQAָRApA33A=qAGAAGA(AA\)Aԏ\AՅApA=qA33ApAA=qAԏ\AzA=qAffAAHAӮApAԏ\A
=ApAӮAGAУAA(A֏\A֏\AA  AGA\)A  AAӮAHA  AәAӮA\)AQAGAAzAHAGA33AQAׅAיA33AיAA(A  AAHA{AzAQA֏\AA
=A
AA=qA=qAHAиRA
=A
AAHAAQA
=AAA(AQAθRA  A33A
=AffA\)AAHA
A֏\AAGA
AzAٮA{AA  AzA{A׮A
=AיA(AAA=qAأAQAAAӅAffAAԸRAՙAָRAיAӮA(AיA\)A֏\AAԸRAԣAGAУAхAՅAA֣AQA
=A(A  A֏\AHAׅAAQAأA\)AٙAمAGAAأA=qA؏\AGA=qAffAׅAA؏\AAQA{A33A  AGAffA  A33A33A̸RAQA
=AәA(A{ARAffAA33A
A(ARAA  A¸RA(A
A{ApA  A(A\)AHA  ApAzApAApA
AAQApA  AGAAA{AA{A\AA
A=qAAApAAAAAAGA
A  AυAAA֏\AAAffAՙ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ApA{A^\A33A{AAAffAffAABBHBBBBB=qBRB
=BHB  BBB
=B	HB
pB	HB
pB	ApAzAAB=qBHBBHB
BB=qBffA{BBffAzAAzA  AAHAffApAQARB (AA
=BBB33BpBBffBBQB{BBB\)B	B	BB
ffBBB
=BBBGAB\)B	
=BB	
=B {BzA
A\)A{AQAAGA
B{A\A\)A=qA\)AGA  AGA33AAAzB RBzB=qB\)BB
BBBHBB  B(BB	HBBB	33BB	B	ffB\BHBB
=BHBB	BBGBBB
B B QBAffB\)BpB
=BB\)AGAAffA\A
AAA㙚AzA
=AB B (BB{BBQBBpB{BB
=BBBB
=B(BffBRB B33B
=BHB{B=qBHB=qB\)B33B HAffAA
=A(AA33ApA33ApAA  A
=AA{A
=A  AB QB{AB
=BffBRBB\)BBRB{BRB{BBzB
B	B
=B   BB=qB\)BB=qB\)BBpBQBB ffAAHAffA
AHA33AHAHAt  AAA=qAGA33AA\AHARA\)ARB 
=ABB(B  BzBBBBffBBGB\)BB
BRB=qB GB\)BRBB33B(BpB =qB=qB\BzB
BBGB A  AAB pBA\)AAA33A
=A=qARA{A\AQAHAA33B (B
=BHBRB
BB33BffBQBQB\BGB QB =qA
AB 
=B ffB B B
=B
=B 
=B ffA\)B BB{B\A\)ARARAAָRA{AA=qAQAA\AA\AHAGA
AAQAGA(ApB BBffB
BGBB  BBBBQBBzBBBzBQBzB\BRBABzBzB
B\BBQB  BB
=B (AGARB B HA33A\ApA(AAAA\A{A(A(AB
BGB(BBffBHBzBBHB\B=qBBRB{B=qBQB\)BffBHB  BB(B
=ABffBBA\BffA
=BApBBQB  BQB\B  B\B\B\BBB\BBBRB B BQBzBB(BHBpBB\B33BBGB{BBffB  BB{BBBpB

=B
ffBffBHBzBAHAQB=qBRB
=BGB A
=B 33BRBzB pB  B(ABBB BAB  B33B  B  BBBBpBBzB(BB
=BRBBB\BA{A=qB BffB=qBQB 
B{BGA
=B RA33AApB B(AffAA
=A\A\AQA  AffAHAQA
AB {B 
ABB{A
BB B RA=qB \)B pA
=AffAQA(A(AGA{A33ApA33BBBB33B A\AA\A=qApA33AAHA
=A=qA33AQA  AAA  A\AffB AARAAB{BRBB=qB=qBBB\BHBBB33B=qB  BB{BzBGBQBB33B=qB AzBA=qAA{B  AA
AARAAApAHA(AARBffBBffBB
BBB33B\B{BffBB\B
BQB\BHBRBBHB
=BB=qBB(BB
BzB  B\)B  BA(A  BAffAApA
=A  A(ApAQA\AA\)ApA{B QBB ffBBBB(B\B=qBzB{B HBBzBBBBB\)BGB
B(B
BBBBffB	zBB  B  BBB33BzB\)A  B A
A
AzAA=qA(A  A\AzAAGB33BB  B{B=qBB
=BRBzBHBpBB=qB=qBBQBBBB  B  B	=qB	
BBQBQBHBAGBGB
BHB{ABB ffBBffB
B(B
B
=BzB  BGA
A  B pBB
B
=B\)BBB
BBBGBB{BB
B\)B{B33BffBHBB	B	RBRBBzB	BBB(B	B
BRBBB\BGBGBA33A33B=qBpBB RApB  B B \)B33B33BGBB33BpBzBBB=qB  B
=BBQB(BBRBBBGAQB=qBBBBBB	pB
pB	\)B	pBB pBBBBB\)BffB=qB B\BQB ffA{BzBQB  B\)BffBB{B
=B{B33BQB(B\)BBBGBRBHBGB\BffBB{B  B  B
=BB	(B
(B
=B	B	\B=qB=qBQBB(BBQBBBBzBGBpB
BB  BBBBpB\)BGB
BffB
=BB
=BBzB
BBBB=qB
BpB	RBBBB{B33B	{B=qBB	(B
=BBB\)BzBHBffBBB	=qB

=BHB	BBBB33B(BBQB	pB	{B	\)B\)BBBzBB\B=qBpBzB
=BB
B\)BzB=qB
pBBffB33BRB	33B	{B	33BB	B	B
QBBffBzBGBzBffB33BBGB(BffB
=B  BzBBGBB{BRBRB
BRBBffBB33BzBpB
=B
B\B33BRB
=B  B(BBB=qBffBpBB\B
BBBffAHB
QB	(BB=qBGB33BzB B {AA{AHA\A\AHAAA(ARA33AB \)B GB{B{BRBB  B\)B\)BzBBQBpBBB  B
=B  BBB
B33B\BBGB
=BRB\)BBBBpB=qBffB\AAQB(B33BQA(AA33A(A\AAA{AQA33AQB zBRBBBB
BBBHB \)B33BB{BBBGBBHBpBBBBpB\)B
BBBRBBB   AB pB A
=A\B AApA  AAHAQBBB B\)ARB GBB{B=qBBBGBBzBBB=qBQBB(BBB33BB	
B	33BB	zBpBGB\)BB\)BBGBpBB QAGB   B {AGAAHA{A  B33BB(BBBffBB =qBRAA=qB BBB  BB  B\AB \BBBHB33A
ABB {ApBB
=B=qB GB=qB\B
=B33BAABHB (A{AGAffA  AAAAHB(BGB\)B\)BBpB\BBpBpBBBBB  B\)BRB
BzBGB
B
BGBB(B{B
=BHBQBB=qBBBB33B AB GAARApAA\AARAAAAQAAzB zB  BBB=qB RBB
BRBzB
BBB
=BAB B (B   BBBBHBffB{B=qB33A(A
=BBB\)B33B\BGBBffB
=BQB
BB\)ABB B {AB=qA33ApA=qAAGA(AffAA=qAA  AQApAAAA\AA
AQB33B\)AA  AA=q>
BB{B\)B
=B(BA
A33B RB{BpB ffA\A
AApAARARB 
ApA\)BQBBpBBB=qBBBB  B
B\)BB  BzBHBBBGB  B
=BBB(BBB=qBB\)B=qBBBBBHBGBBBQAA
A33AAAAAHA  AA=qA(B33BBBBQB
BB\BffB=qB{BAGA{ARB
=BB  BffBGB\BBzB\)B B(BzBBBBBARB B ffBzBBB(BHBRBB=qB  BRB
=BQBHBGB33B\BBBpBB
=B
=BRBB {BQB
=BBBRB
=BBHBBHBB=qBffB\)BzB QB{ARB AffAHA\B 33B zAABzBffBBBffBBB{BffBBBBBBBB33BB33B33B  BBzB33BBzBpB(BHB
=BzB\)B33BRBA{A33B  B RB {AffAB   B B B AAAA=qAA  B \)B 
=B HBHBB\)BB{B{BB	\)B\)B33B
BffBB  BB	HB
QB
ffBBGB{B\B33B
=BzBffBBffA=qBBzBB =qBBB
=B A
ARA\)B{AGA=qB BB{BBGBffBBBRB\)B=qB
B=qB
B
B	{BpBBRBffBB
=B{B=qB	B	{B\BQBB	zB\BBB=qARA\)AA(A=qAQAGAAHAA33AA=qAAAAzA33AzAffAB B{B BB
=BQBzBB	BHB	ffB	GBBB\)BB33B
=BzB33BABGBB\BQB33BBBpB{BB\)B33BzBBBB\BGB  B 
=B\)B33ABffBBB
=ApBB=qBB{BBB  B{BQB
=B{BBAB HB 
=AB GBGB{B33BffBQB{BQBpB  BBCAAQAAA\)ApA33AApA\)A
=AQB A(A  AAB ffAAARApApAAA
=A
ApA33A
B=qAA
=B
=BABffBAB(ABBAA(AAffAffAA뙚AQApA
=A\AzAApAA=qAAAAAAffAAQA  ARA
=A
A  AzAffA(A
=AQApA\)A  A33ApAA33AA33A(AAffAffAzAAA=qAHA
A(A(AHAHAυAAӅAAA\)AŅAϮA
=A
=Aʏ\AȸRAffA  AA33AApAffA\)AAAGAAׅA33ARAA\A{A  A33AzAGAzAQAzAAffA=qA
=AڣA=qA
=A=qA\)AzAAHAGA33A\)AQApAApA=qA˅A=qA=qAffAAǮAffA33AGAҏ\AGAθRA֣AAffAA
AAQA홚A\)AARAA=qA陚AAA  A
A33A؏\AׅAHAمAA{A  A=qA
=A
AA{AGA
=AᙚAޏ\A(AܣA\)AA  A{AGAAAQA=qAAAHA{A\)AffA{A(AffA
A33AQAA\)ApA33AA=qA33AA33AA33A(A\AARAHAڸRApAGA(AAυA33AAAzA{AAٙA  AAׅA(AGA\AGAA(AʣAffA(A33AA  AgAXA`zAmGAs
=AyAwARHA=qAA{AApARARAffAA\)ApApAAGAffAGAHAffA{A  AzA\)A\AzA(AAAGA33AAAAAθRA{AA
=ApAAəAQAǅA{AӅARAA  AzA=qA33AHAAǙAA(AGAHAHAAHA\AAffA(A
A(A{AzAˮA
AffAAA\)AA=qAffAzAHAAA
A33A
=AzA{AģAHA  ApAAۙAAGAٮA
AޣAAGA(A{A  A(AҸRAzAGA=qA=qA\)A
=A  AAA{AAA=qAHAAHA߅AأAָRAzAA
A噚AzAARAAA(AAQA{A\)A
=A\A{AAAAA
A=qAA{A\)AAAGA޸RA
=AAΣA{A
AA  A=qApA\)AAAAAA{A  A
A33AB {AAAB  A=qAA=qAAAA33A{B =qA
B (BzB =qAA  AHAffAHAQB A33BB(BAQA\B33A  A
=AA(B 
=AzB
=BBGA
=ABffAB33BBB(B\)A=qBpB  BBzBpAAAAzA33AAA\)A(AGAȣApAA
A33AAAA\)AAnHAp(AAmAQpAA
=A~\AtA\ATAyGAffAGAAAGAQA(AAA(A=qAA  A=qA  ARAGA\)AAgA\zAFHA=AXA6{A   AAtAHA~\A(A=qA;A%pA{A!A@zA-A+
=A!ApAA,QA
AAA\)AQAipA\  ASAUpAj=qAMAhA]AfRApAr{A~ffAAAffAA\AGAAAA=qAARAXAA
AAAGA\)AffAA\)AA  A\AzAGA  A  AQAAA\A(AQAQA(AAzAA(A\A{ApAA£A\A(ApAAGAAAzA\)A\A˅A
AA\)A{A
A  AAA\)AQAřAlzAAAA=qAA33ARAo
=AA33A{A
AAZ=qBBB\BBӀ BBޔ{BQBBkB8RB#BuBfB(BBfBLBqB㙚BzBB  BW
B݀ Bݏ\B݀ B)BLB  BB8RB(B؊=BW
B  Bʳ3BfBي=B.BfBٽqBֽqBB֔{BڣB׀ B{BB߳3AGA
=ARAAAAzAAAA(A
=AAHA=qA~HAr\AipApAmGA`QA[AWAmAf\AsAAAaAb=qAP  A`A|AA{ApAffAffAA  AQA\AffA\AHA(A
=AHApAAAHAA
=AQAA{AzAA
AffA=qA33A\AQA
AffAA\AHAAGAAAA\ARAAAׅAиRAAA
=AΏ\A֏\AAffAQAA\)AиRA33A¸RAA
=AAQA  AA33AApA  AAAHAGAAA=qAAQAHAA=qARAffA\)A=qAGAGA33AzAA
AŮAHAHAffA
AA_33AeGAjRApAepAA
=AHA{A{AffA=qApAA}GA
=A33A\AA~HAAr=qAzHAj{AaAqAdA^{AS33AUApA
=A
=AG@33A-GA,A!pA\AAA'
=A9pAYAlA^HA'
=A1AIA7
AAMpA\(A=qARAAA@33A
{A{A33A
A@A3
A>RAD@\AQA   A0  A{A\)@@p@AzA$@
@\)@θR@G@ۅ@˅AzA@陚AGA
A=qAzAA\)AzAA\)AAHA\)AA}Ar\AXQAAAPQA1Az\AH(Ak
A{Az{A,QA^\A1pAC33AQAd(AK\)AMAQGAXQAUGAuAffA
AOAA
=AHAGA(A33ARA  A  A(AzAyGAA33AyAAzAAw33AA=qAAA
A  A  AffA
A(AA{A
A33AAGA(AA  AApA=qA\)A\)A(AAA(AARAA(AAAA
AApAApAffAzAAA\)ApAAGA\)AffA33AQAAzA\AAQA
A33AAA
AHAA
=A
AQApAQA
=AA{A\)AA=qAAHA33A
=AHAARApA
AAAGA{A33A=qA
A\A\AA  AffA\)AzAzAHA\)AzAQAxAyAAARAmA(A	G@{@
=@@=qA!A
=@H@H@@|@5@=q@@Tz@g@Q@@33@(@\)@p@pAG@G@@(@33@@A+
=A/33AH  AA\A+
A/AmGAYpAXA^=qA_AB=qA1pARAuAqAV{A\QAAApAjffAd(A=qA\)AA  A
A=qARA]AApA=qA\A\A(A}AzAupA
=AypA  AHAAbRA\QA=qAzA  ApAzA  A  AA(AAP(Ao
AZ\AyA{A=qA(AAs
=A\AGAQAA\AA=qAHA=qAAffAupA}AqAzAw\)A(AHARA33AHAffAHAzA
=AHAzAQA~{A]Aj\An{AtAo
=Az\A^ffA]GAUpA[
AMpANRAb\AAHAHA{AQAϮA(A
=AGA
AQAAHA(AA{AffAA\)AAA33ARA(A33ApA\AzA
=A
A33A=qA
AAApAffA(AApAAAApA  A(ApAzAzAAA  A33A\)ARAA
=AA\)AQAAəApA׮A(AA
=ApAAA(AAAffA=qA
AAAʣA=qA\)AAA\)A(A\)A(A(AzAAHA㙚AGAA  A(A
=AA\)A
A\A33AAffA
AңARAᙚA֏\AQA
=AA=qAAAA
=AAQA(A
Aڏ\A(AGA\A֏\A
A\)AApA33AGA
=AQAA
=AAA=qAAQApApA
AGA  A33A=qA  AA߅AԸRAzAיApAAԣAGA\A
A=qAܸRAÙAffAՙAA
A
AHAQAzAApAHAAA33ARA  AA\AQAA\AAA\)AAƸRAffA  ApAGA33AAA\)AHAA޸RAHA
=AGAAA33A
AQAҏ\AQAϮAApAAθRAA
AffA(AAAAAzApAAA(A
AA=qAHA\)AzAAAzAA(AHAffAA{AAApAffAAQAAA(AA
AA  A=qAԣA  AʣA=qAՙA
AA\)AQAzAARAÙAHA33AîAAəAAQAQA
AAQAAAA
AљA(AQA\)AA(AAQAQAޣAHAA  A{A  A
=A(A  A33AApA(ApAApA  AffAQA㙚AzAA  AAffA
AHAffAAHA؏\AffA\ApA33A
A=qAA(A  AAڣAffAA(AAAA33A
=A\A=qA
=A  AzAA33AAAߙAffAQA(A33AAGA{AARA{A\AٙAffAA{AAAzAQAzAAGA=qAAQA
AԸRAGAAzAzAAzA  A33A=qAARAA{AAיA
A̸RAәAхA=qAffAA=qAzA
=AAݙA
A\AAA(AمAARA33AzA(AGA
=AzA(AGAAՅAAQA\)A  A=qA
=A
AAzA{A㙚AHA  A\)AAAA
=ApApA  ApA(Aڏ\A{AzAffAAHAA
=AApAAHA{A  AA  A{ARA\)AA\)AzAȏ\A
=A33A(A33AAɮAA͙AAffAA(A\)AffA  A=qAHAffA33AA33AAA  A{AA=qAʏ\AHA˙AHApA܏\AHAHA=qA\)AzA
=A33AAHA
=A(AffAQA33A\)AA  A\AAffAffAAffA  ApAzȀ\A
=AffApAA
A
A=qAGA{AΏ\AHA  AƏ\AA͙A33A{A\)A
=AA  A
=A(AəA
AÅAzAA=qA33AA\)A=qA
AAAAGAA¸RAŮA
AǅApA{A{A  AA
=A£AAƏ\A33AzA
=AəA{A  AffAAAAA  A\)AA  A33AGARAA\AffA  ApAAA
AGAzAA=qAzAA
A=qAQA\)ARA(AHA
=ApA  A(A{A33A\)AA33AffApAAAzA{A33AA(AAARA=qAAA(AAAAA(A\)A33ApA\)A\)A
AQAAzAA\)A33AHAA
=AAGAGAA
AffAAAffA  AffARAHAA{AAAARA=qAzAHA\ApAQApApAA  A33AQA
AHAAA
AffApAA\A  AAGAAzAAAQARA
=AAzApAffARAHA
AAzAARAA\)AffAHA=qARA
=A
AAAAAAA(A33AApApA{A\)A\)AA\A
=A=qA
=AAA\)A\AAARAAA
AAzAAARA
AzAzAAAAAA
AAA\)A(AA\)AHAAA{ApAA
=A  A33A=qAffAA{AAAA(A
A33A
AA=qAAzAGAAffAzA\)A}pA{\)AxA|(A}AzA
=A{A~=qA{A~{AxQAyA{\)Az=qA~RAuAw33Ao33ArHAlAh(Ag33AeA`  AcAc
Ac
Ac\)AaA^ffAYGAUAW33AX  ATA\AVRAW33ATAT  AUAUpAHA;
=AH  AMAMpAJffAGAEAG
AC33A?AEAHAAAG33AEpAC33A@(A>{A7\)A:=qA:=qA1A0zA$QA9pA*{AA4  AQA.{A0zA+A A"ffA$zA{A{AAAAA
=AGAApA
ARA
ffAQAA=qA33AzA\)A
A\AQAA33A\)ApAAA\)A33AA33AARAARARAHA33A\A\)AzA{AAAzAA  A
GAAA
A\)AA=qAAffAA\)A\A\)AAQA33A33AzA\A33AQAAA\)A
AA(A
A33AAAARA33AApA  AAHA=qA
HA
RApARA
RA
AHA
{A	GA(A{A
AA(A=qA\A\A33AAA @@
A
AA{ARAAGA\AAQA
A33AQA@ffAzA{AAQAGA   @zA33AAARA@ff@@@
=@z@=q@
@@p@@@(@33@z@ff@@33@33@@Q@
@Q@@  @{@z@@Q@\@
@@@{@
@@H@@{@@Q@(@@@{@G@@@33@p@@\)@G@ᙚ@\)@
=@H@@@@أ@@@{@G@(@@@Q@߮@{@\@@@@ff@@G@R@(@{@@z@Ӆ@G@@{@{@=q@G@
@ff@@p@p@R@@=q@
=@z@@  @33@\)@ff@ָR@@{@@ָR@\)@p@=q@@@33@@(@H@@(@=q@z@\@@@G@ۅ@\)@ᙚ@G@ff@\@  @(@@陚@{@(@\)@G@G@(@ָR@ff@
@ff@˅@G@@أ@ʏ\@33@ʏ\@z@ff@G@  @  @  @G@ٙ@
=@@H@\)@z@Ϯ@p@ff@{@@Q@@(@H@ָR@Q@33@
@G@˅@θR@(@z@ʏ\@˅@Ϯ@@@\)@\)@
@
=@{@\)@
@G@@ȣ@z@@z@@Q@
=@G@ff@z@@=q@=q@
@=q@(@z@{@=q@H@@@
@{@z@H@
=@p@Q@33@@\)@@@\)@@@=q@(@@@@@z@@\)@z@@@\@ff@@G@@=q@
@
@@\)@R@ff@@@@Q@@33@@  @H@ff@\@G@33@
=@R@\@z@{@
@H@=q@R@ff@
=@R@
=@@{@  @ff@
=@@
=@@=q@@\@  @H@ff@z@{@z@(@33@Q@z@
=@R@\)@\@@R@Q@@\@G@R@@@(@@
=@@33@p@\)@@@=q@@@ff@@G@Q@p@@p@  @G@H@UB\)BQB33BB
BB=qB
BBB33BffB
{B\)BBBBB33BpBHBHBQAA=qB  B zB
=AzBA\AGAAGAAHA
=AzA\)A
=A=qAϮAQA=qBQB
=BQABBHAA=qApA(AA  AәAޣA=qA߅AٮA=qAzA{BApB
ffB  B  ABHBzB33B	
=B
B  B
QBffBB {A  AA
=B

=AApApB33B	B  AB
B  BQB
zB
B
GApB B\)BBBHB(A{<#
AA  AffA33AָRAA
=AAGA\)AAzAQAARA{AϮAƸRA\)A(AƏ\AGA\A  A{A\)A33A=qApAď\AAA=qA33A
A߅A=qAAQAיA˙AA{AA
=AGAAAĸRAď\ApAQA
AHA8A(A<A'
=A
=A-A˙A (A=q@AzApAN=qA{ARHARAA>ffAJ=qAAHAAG
A0@A%A`zA
=ARAC
A.RAYpAQGA  AAAHAzAA((AK@ffApAA[33A\AA'33A,(A
=AIpA`  A=qAA:\APAR{A  AR=qAN=q@  A癚@
@33A=GA&RA_\)AS33A9pAPzA\A
=ACA)@A6=qA\@HA\)AA<  A7
AIAX  A=qA8AIA\A!A9A.\A3@GA:RA>=qApA0  @@RAVRAAM@QAQB	B	AQAB B{B	B
RB
BB
=BBRB
  BBBQBB  BB	BA  AB	B(AGBRBffB33BzB=qBB
QBHB
=BB
B
BB{B
BBRBBBQB
=B\BB	  BBzBARA{BB(BB
=B33B
{B
pB
  B
QBRBB	BB\BBHBA홚A33BQBGBpBBB

=B
B
\B33B  B	RBzBB{B BB=qB\AB
=BzBGB 
=ApB AAAA癚AHAAAAA
=A㙚AA(AGA\)AAffA  A
=A
=B\A{A(A(AAA{AffApAA{AQAB RB
=AAAB 33B(B\)B33B
BAGApAAA\AB(BffB{BHB  BBRBQB	GB	zBBBBRBB
B	AA\)B=qBBRB  B
\B33B\)B\B	33BB	HB
33B=qB\B=qAAHBBB33BffB
GB   B33BRA
=A\AAGB QA{A\)B B\)BQB AAzAAAHA
AB33B\)BB{BHBBHB=qBzBBB  BBB \)A
AQBB\BBpBBAGAAApAHAAffA{A  AA
=A(AAGAAApABQB\BQBBB{BB{BGB HBzBQBB
=B{B	33BBB(BB\BB\)B=qBpBBffB	BBB(B(BBQBQBRBA\BB
AHAffAA\A{A{A(AA33AQAHA  B 33BA(ABB\BBBBBGBAzB\BBA33BBHBHBffB  B\)B(BRB\AA
A{BQBzB33B ffA=qAQAHAzA뙚AGAffA=qA\AAzA{A=qAGA\AffAGA\)A{A\B 
A(BBB
=BBB33AHBpBB	=qBRB	ffB	B
B
{B
B	B
zBB
zB
(B\)B
BzBB
=B\)AA\)A
AB ffAGAA33A  AA
A{A{A\)AA\)AQA33A\B =qA
=B BHBB\)BBzB  BGBzB33B(B
B\)B 33AAB B \BAAABB
BB(A{BffA{A\)A
=AHB33AGAGA(AAQA(AzABpBBB
=BBzBpBzBRBB33B
=BzBRB\)BBffB{BB
=BBBGBBBRBRBA{B33BBQBGBB\)A\)A
=AHAAAQA\)ARA
=A陚AzA
=A=qA
=ApA{AQB =qB\A
=BB33BBB{BBRBzB	B	\B
  BBGBB(BB\BBB BBA33B 
=BRBffBBBB(BHB
33B33B	\BB A{A
=ApAA33A{AGA  ARAGAԣAA\)AA{A
ARAA
=AAffB  ApA
AAzA(A\A(AHAAQBBBBzBRB \)B zA=qAA(ApAAAzAzA  A뙚A뙚A\AzAAA
=AAAمApA(A{AGBB
=AAGARBB	(B{B 
=B  B 
=BRBzBA(A=qA\A
AHABRBB=qBBAA(A=qA  AHAQA
=AAAHAHA뙚AAA33A
=AA\)A33B AGB=qB BB(B
BBB	B	=qB
{B	
=B	{BABBBBpBBBGB=qBffB33BpB33AzARARAAB \)BBB=qB=qB{BBffBzB=qBABzB
=BffB(BRBffBffB
=BBffBzB
B\BpBRBBBB	  B33B A\)B
BRBHBpBB(B\)A(B 
=B\BBpB
BBAzA(B 33B{B
=AARARApAGA{AzA{A(A=qA=qAAB   BB \)B  BA
=BBBAQAB 33B\)A33ARBffB zAAHARAQApAAA
=ABAA=qAGA噚A\AffApAQAGARAffA33A\)AȣAAA{A(ApA
=A{A=qAߙA\AA(AA(AAظRAGA=qAzAzA
=AәAQAHAÙA=qA{A
=AAAAHA˙AffAAAAA
=AzAAAAA(AAHA¸RAffAQA{AAzAAA㙚AGAAffAAHA
AGAA33A
AAAGA{AAAA(A33A\AAAHA(A݅AA\AQAɮA33AffAѮA  Aҏ\A
A{AGA=qẠAffA(A=qAHAAGAAA{A=qA\A
ARA\AffARA{AzAQA{AA  AAQAARA(A(A\AA=qAzAA(AGAA33AQA=qẠAHA(A(A
=AәAzA
A
=A\)A\AzA\AA
AzA=qA
=AzA{A33AA܏\AᙚA
=A(AB(A=qApA
A
A\A
=A=qAAzA\ApA
A=qA\AAʸRAϙAHAAͮA33AApAAׅAAՙAٮAƸRA(A33ApAۮA{ARAA{AzAHA\)AGA\AQAAQAAGA  AA
AA33AAAHAHAA(AffBAAAAA噚A33ARA{AA33AHA
=A{ABBffBHA\AAzA
A\)A(AffAGAAAQAAGA{B B QA33BGAAAA\)A33AA=qA33A
AAA
=AA
=A=qAApA{AAHAAAᙚAA  AAΣAљAffAQAQAA{AA
ApABRBBB 
ARB(A(AAA\AAffAAAzAAAzA33A{A33AAAHAAAGAffAHAHAzA\)A{AQA=qA
=AA33AׅAԸRA33AGB \)BBB
B\BGB	\)BABB  B B \)AGA=qB  AAA\)BRA(AGA=qAB \)A
B HB\BzB\)ApAApAzAAzA(AAA噚AGAAQAޏ\AffA
=ApARAAGAAzB 
=AffBBRB33B\BA=qA\AA=qAAHAARA{AA  ApA\)AAQA\AAQB
AAffAA
=A
=AAHAߙAAA33AޣA޸RAffAAA(A޸RA
AAApAAGAHAB HA(B A\AHAQARAAAHA{AAzARAAA(AA\)ARABGB  AA  AHA{A
=A(A33AA  AAzB=qBA33A{A(AAffARAAA{A  A\AApA\)A=qAB  AGAAB QA
AAAAA\)AAHAffA\)AA\A\)AGAQA=qAffAA33A\)B AAffApAAHARAAAAApA{A
=A\ApAA33B   A
=BHAAffA=qAzA=qAA\A\)A
=B AA  A  ApARAffAQAQA\)AAAAA
A
=A{A  AQAA
AHAݮA\)ApA
AGA\)A
AQA{A\)AAARAB \AAB{A=qARA33A33AA\)AA  A\A\)AA\ApAHAApA\)A\)ARAA
=A33A陚AHAzAAHA33AHAABB
=B \)AAAAApBBB\)B(AA33AB AHA\AHAffA  AA\)A陚A=qAA
=AB(B{BApBB\B	BpB33B=qA=qAAAAA=qA
=AQAQA\A\)A(AAA
B  AB 
=A\ApAAAB=qBBHAAA\BffBHBRBBGB
BB33B pB\)AQA=qB pB=qBffBffAAB A  B  AB  B B
=AQB GBAAAAHB\)B  BBHBRB
=B pB33BHBBHB\B	BB	
B	BB
\)BB\B 
=BBGBRBffBpBpAQApBARBQBRBffB{BBB
=BpA{AAAAGAAffAAAffBzB	RB
pA{BpBBGB	B	
B	33B(BBBzB zBBBBHB
BQBQBBB{BB(A\B33B33BBffBHBARAHAAAzAA  AApARA  AA\A{AGA\)AzABB\)B
B(A\AB QB GB
A
A33BAB zBBAHA33AABB 
=BAGA{B B BBzB
B33B\)A
=B =qAA{A  AQABAffA=qAԏ\AA
=A  A33A
A=qB=qB\BBffB A\)AAAAAA
=AGAHAffARAAAQAGAAA(AAAAzAApAAAB\)A
=A=qARAApA\AAzAأAυAЏ\AиRAAхApA(AARA\)BBBB RA{A\)A{BB
=BBzAB\)AAAffAHAAAAQA33AA\)A{AffB{A  AApAffA߅AQAڸRAHA噚A{AA
=A{AAA
A
A뙚AzA
=AApA\A\)ABB 
=BQBA\ARAHARAAffARB ApAA33AGAAQA\)A{AA{AA  A
=AHA\)A=qAzAQA33A
=A
AQA=qAffA{AA=qAAA=qA\AAAA33AARAzA(AzAA\)A{A
=AGAAϙAffAARAA  AA
AQAGAzAAffAA
=AApA(A  A33AAA
=A{ARAAָRAAAAʏ\AffA\AA{Aޏ\AffAAzAQAA
=A݅AffAAQARA=qA(ARAA  ARAGApA\A=qAAAzAAᙚAߙAڏ\AzA܏\AQAݙAՅAڣAA(AQA{AHAA\)A\)AApAAHA(BApA\)BAAAQAA
=A(AA(AB 
=B QB\B
B(A
A33BA33AA\)A\A
AAA  AA(AGApAA؏\AQA33ARAB(ApA{A33B B\ARBBBQAAA
=AzA
A=qA33AAA\)A{AAABGBAA\AA=qApAAAB  BQAGAQA㙚A=qAA{AA33AGAۙA\)AۙAffA=qAffA㙚A33AA\ARA
AA\)AzAAGAA
=AQAAA(AAQA33ApA=qA
AAAffA{A  AAzA{AQA=qA\ARB 33AGAݙAAAA  A(AAAQApA{AA{AAAA  AffA  AAffAA
APAA
A  A\AAAQAAffAzAHB
=BHAA=qAAARAHAAAQAAGA\AAHA{AA
AB BRB
AzAB\)BBQBGBB{B
=A
=A\)AAQAA{B AA\AAAffA\ApAffA  A{B\B AظRAzA{AzAffA  AAAA\)AA\)AffARA܏\A\)AApAB
AApAQA\)A  AA33AffAA=qAAGA33AHAQA(A=qA\)A\)AzAAAA
AA
AAGBAAQAA  AAA{AHAA\)AծAAHAͅAʏ\AHA\)A
=AApA˙AיA{A(AA33AQAffA{A
=AAAAA
A{AB =qA
=AAApAAAAARAHAAAŮAQAA\)A{AƏ\AHAʸRA(AAθRAθRAGAңẠAGAAA͙A(AGAڸRApAأAAGAۅA
ApApAᙚAGAAARA
A\)A
AA  A\AABzA33AzAzAAAAQA{AA˅A  A֏\AظRAzAGAۙA33AA
AA(A\AGApAAAzARAA  AARAzA=qA\AzA\AffA\A
AAzAHA(ApB\B\)BB{B
BAAffA=qA\)AٙAٙA(AӅAΏ\AAApAGAHAAљAzAHAzA\)A{A  A  AQAA=qAGAAB HAB33AAARA{AAA\AB
=B B\B \BGA{BGB
AAA(AA
AAHAHA\AffA뙚A  A
A
=ApAzA\AA\)BGB{B \B
=BBAA\)ApBB{BBpBzA\)B B (A{BA(A33AARB (A
B(BRB  BffA33ABzB
=BAA33AzAAB B pA
A  AAAB GB\BHBB B(ABA\)B=qB AAApB 
A\B {BzB A{B A\)BBB{B
ARBAA33AAAAAAAAAHAܸRAᙚAQA
ApApAAA(AAAApABA  BB	
=BGA
=B  AApBB
A=qA
B GB (B (A
=AffBB{BHAAB {AHA=qAQARAGAAAzAA(AAA33AHAAظRA
=AAAQAA\)AAzA{A=qAHABB BBHB=qABB{BAA
=AAAA
=ApAffAA33AA(AGAA\)AAGA{AQA=qAffAAGAffA  A(AzAffAA33A  A=qAHB \BB
=BBzBffBBpA33A33A\AA(AQAB 
=BffBzApA  ABB 33A  BBffBB 33B(A
=ARAQA\AAzAGAHA33A33AۮA33A  A
AffA\AAB ffB{B{BpB{B(BHAAAHBQBB=qA  A
=A{AAARB(BAA(B B \BA
=A\)A{AAB A=qA{AAAARA33AGAGA뙚AHA33A\)A  AAffA\)A
=BBBBGBBBBBzBB BBHB BB  BRA  BBHBRB{BffBB	\)B	  BHBB  ARAB pB BAAB  B(BffA
=AQA33A
@HA(A\)B(B
ABB\BBGBffBHB  B
=BAffBB\A\)BB
=BA33A  A{BBA
=AQB(B\)BzBBGBAAHAGA  AAA(A33AAAzAQA{A33AAAA33A33B 33AQBQBpABA33B B 
BpB(B BffBB
BRBBBA"RB33BBB33BzBffB B
BGAzA
=A{AGA
AAffA\)AHAGAHAzAAA33AA(B ffBB{BffBzBBHBpBHBQBB\)B{BQB=qB(B \B zAHB QAA
AAAB\BBBB\)B{AABB RB
=A  A{AQAAAA\A\)AAAAAA\)AAGA  B zB ffB  A
=A\)B=qB B (B zBBffBBRBBpBGBB =qAB BBGB(B\)B 
AAAAAAQARAA(AA(AAAHA33AHA{AAAB(BQBB
B RB 
=B zAB B 33BB 
AApAA=qA\)AGAffAApA(AAA
AA
AQAA(AHA=qAQAH@{A
ARARA{A33A
=AA\A=qAGA
=AQAAzBpBBB HA  ARA(A\B AAAAAAffAAAB{BffB \A\AA\)AB   AA(A(A\)A  AAzAAAAA\)A(AAGB pBBBBpBHAGBQB
=BBpBGB33B33B \)B {A{B33B A33A\)ABAQA=qAAzB  BB B\)A
=AAffAQA\ARAAGAA\AQAQAA=qAA33A\)AHA\)AGA\A\)BBzB\B
=ABBBGB(BGB
=B
=BB33BQBQBB  B\)BBRBffApAAQAAffAAQAAA陚AAQAܸRAQAۙAHA\)A\)ApAAA
AzA\A  AQAAAARAAzAHAA\)AGAQA\)AAAffAAHA(AQA(A{AA\AAAAGAHA(AAAzA
=A33A(A
=ARA  A
=A(AAQA\AzApA噚A뙚AQAAQBzAHAAQB BB(AAAHAAA33A
A
AA\AApAA\)AB 
A{A=qB33A{A33AAHA33AA33A33A=qARA=qARAGA  A
=ARARAAAGAGAAAB 
B 
=B \AAB pAAB GAAAAAHAAzAAA=qAAQA{AA{A
=AGAڸRAA=qAңAҸRA=qAQAAGARA\)AA
=AA=qAAיA{ApAAffA  AQAGApAԏ\AߙA癚A
=A
Aڏ\ApAffA
=AHA  A(AA\)A˙ApAffAffA  A(ARA\)AәAA͙AυA33A=qAϙAAAA{AAAAͮA׮A
=AԸRA݅AzAA33A(A
AAA\A\AA\AA\)A(AffA33A
=A\ARA
=A  AffApAA
ApAAA33AA  AиRA֣A
AA
=A=qAzApA  AAQAAAAAGBBGAGA噚A
A33AARA{AAAAA\BB  A  ApBBAA\)AGAA=qARA  A\)ApA
=A\)A噚AA  ApA(A(AHAָRAffAA
AffA
A\AĸRA(AGARAՙA(AGA\)AܣAA\A33A
A\)A\ApARAHAAGA=qAAȏ\AHARA
A
A{AA
=A  AffA33AA
=AAA
=AGA\A
=A޸RAܸRAٮAAGA33AA=qAHA{AffAAffA\AGA
=AA\AAGAAAA\AzAARAA\)A\AzAGAzAA(A  A33AAAzA=qAGA\AQAݙAA{Aҏ\AzA\)AAA\)AAQAۅAңAARAQA
=ApB QAApA\A  A\)AQA
=B{AAAA{A33AA33A=qAQAAA=qAA33A(A
=AיApA(AɅAA33AAAAffAҏ\A  A\)A
=AA\)A
AA
=A
=ARAffA陚A=qAA33A\AGAA
=AA홚A33AzA
=AApA{A  A(AzAA33AAAAAAAAQAAޏ\A  ApApAHA(A{A˙AƏ\AA
AϮAîAHA(A33A뙚ApA(B 
B=qBRB A  AAAGAffAQBApA
B ffAA(AAA\)A=qAAHAAQB  BBGBABzA
AظRA޸RAAϙAHẠA
=AŅAQA{AGAAGBzB=qA\ApApAAAA33ApAzBRBHAABffABRAAAQA
=AQAHA
B A
A
AGA=qA{ARApAA  AAffA{A33AAAQA
AAGARA33A=qA
A\)A  AAffAGApAQB A
=AAQBBQBB\B\AQA  ABAGA{AzA
AA
=AA33AQAAӅAAzAGA\)A
AGA  AGAHA33AffA\A\A\AGAGAAA
AAffA뙚A
ApAffA\A\)AA
ARA
=B ffB ffAA=qApA33ABffBAzA{A
=AAAAAGAׅA
=A33AffA33AʣAffAGAGAѮAffAԸRAAՅAGAAHBAGAGA{B   BQB
BpAB BGBB\)BffBBHB B  B B B=qBGAHA(A(A  AHBBBBA(AAAApAA
=AAQA
=AHA\)AHAAA\)AA{ARAHB ABBBpB  AAA{A{A=qAQA  AA{AAB{B ffAAHAQBApAGA=qAA\)A  AHAHAB   A33A\)AzApAՙAGAzA  AA{AAQAمA֣AA\)A{A{A
Aʏ\AAQAA{A(AA˅AA33A{AAQAQAzA33AHA\AAA33A(AQA(AffAAQAәA\)AυA
=AA{A  AA\)A\)A  A33AA
=A\)A=qAGAָRAA(AHAA\A  A=qAQA
AA
AAϮAA  AAظRA
AzAQA噚AAA
=AޣAAHApAA33AHAAAAAAffAGAΣAAӮA  AffAיA33A\AQAAAARAA\A\)A
=AQA\)ARAGAAQAQAAQAzAAffAQAHA뙚AB \)B =qAHAQAzAظRAQAzAAAA
=Ȁ\AzA
=AՙA33AAHApA
=ApAAAA33B AA
A33ARAffA(AA
=A\)A
=AAffBQBAGABBBBB{BGBAAA33ARAARA뙚A
AAAAffA
A\)AAAA{ABpBBHB\)B33B=qBzBB
B\)BpAA  B 
A
B A\)AB=qAAB33B(B\)BB{BQA(AAffB\)B{A  AAzA
=B AAB HBpB33A  AA
ApAGAHBB{BBHBBBHBB=qBAB(B  BB
=B zAB\BB
B{AAQB(BzB
=B=qBAAAAA陚A\)AA\AHA\)AA=qAHA=qA33A=qAQAA{A
=AQA33A=qA{A
=AAzAA
B RA
AAAA=qAAHARAHAARAQA
A=qARA  AAʸRA=qA
=AHA(AffAۮA
AGA=qAAQAA=qAA  AAGA؏\AffA  A
AA
AAA
AGA\)ARAzAzAzAffAffA=qAABB GAGA\ApA=qAAAApA
A  AЏ\AA޸RAA
=A{A
=A(AAAٮAQA\)AظRA
=AHA
=A(A\ARA\)ARAAAAHA(A\)AAQA33AAAA=qA33BRB	QB
B
<<
<
<
<
<
<
<
<#
<
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
            <#
<#
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 