CDF       
      
timeseries        obs   :(   station_name_strlen       platform1_strlen      instrument1_strlen     +   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.10, ACDD-1.3, IOOS-1.2    
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2025-01-06T21:07:13Z http://pacioos.org
2025-01-06T21:07:13Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2024-01-01T00:00:00Z&time%3C2025-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2024-11-10T20:30:00Z   time_coverage_resolution      PT15M      time_coverage_start       2024-01-15T02:15:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      Ai%I   AE      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      @ r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      AA   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        D$   salinity                   _ChunkSizes                
_FillValue        y    actual_range      <#
Bp   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B        ,   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      >
F   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        d   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      
CVJ=   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C           oxygen                     _ChunkSizes                
_FillValue        y    actual_range      @A5G   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH           oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      BxC$
   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        D   ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`           temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AA   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        	   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                
$   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      q   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      Zd   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      
C   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      +   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      D   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	         temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	         temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      $   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	         temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      d   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	         temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      p   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	      YD   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      A   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      <#
Bp   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B        *   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range                $   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	         salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      d   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	         salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	         salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      D   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	         salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      o   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	       X$   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      !@   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      ")d   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      #   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      #   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	      $D   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      %   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      >
F   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        &   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range                '$   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      (   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      )nd   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      *W   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      +?   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      ,(D   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      -   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      -   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      .$   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      /   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      0d   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      1   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      2   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      
CVJ=   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        3mD   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range                4U   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      5>   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      6'$   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      7   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      7d   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      8   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      9ɤ   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      :D   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      ;   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      <   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      =l$   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      >T   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      ?=d   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      @A5G   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        @&   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                A   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      AD   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      B   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      CȄ   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      D$   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      E   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      Fd   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      Gk   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      HS   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      I<D   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      J$   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      K
   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      K$   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      BxC$
   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        L   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range                Md   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      N   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      O   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      PD   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      Qi   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      RR   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      S;$   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      T#   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      Ud   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      U   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      Vݤ   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      WD   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      X   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        Y   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                Z$   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      [h   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      \Qd   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      ]:   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      ^"   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      _D   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      _   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      `܄   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      a$   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      b   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      cd   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      d   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      eg   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       \ fPD   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     	ĸ g4   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    h qqAp?  wqb_04  Ai%I   Ai&*   Ai'   Ai'   Ai(   Ai)   Ai*   Ai+p   Ai,Q   Ai-2   Ai.   Ai.   Ai/   Ai0   Ai1   Ai2x   Ai3Y   Ai4:   Ai5   Ai5   Ai6   Ai7   Ai8   Ai9   Ai:a   Ai;B   Ai<#   Ai=   Ai=   Ai>   Ai?   Ai@   AiAi   AiBJ   AiC+   AiD   AiD   AiE   AiF   AiG   AiHq   AiIR   AiJ3   AiK   AiK   AiL   AiM   AiN   AiOy   AiPZ   AiQ;   AiR   AiR   AiS   AiT   AiU   AiV   AiWb   AiXC   AiY$   AiZ   AiZ   Ai[   Ai\   Ai]   Ai^j   Ai_K   Ai`,   Aia
   Aia   Aib   Aic   Aid   Aier   AifS   Aig4   Aih   Aih   Aii   Aij   Aik   Ailz   Aim[   Ain<   Aio   Aio   Aip   Aiq   Air   Ais   Aitc   AiuD   Aiv%   Aiw   Aiw   Aix   Aiy   Aiz   Ai{k   Ai|L   Ai}-   Ai~   Ai~   Ai   Ai   Ai   Ais   AiT   Ai5   Ai   Ai   Ai   Ai   Ai   Ai{   Ai\   Ai=   Ai   Ai   Ai   Ai   Ai   Ai   Aid   AiE   Ai&   Ai   Ai   Ai   Ai   Ai   Ail   AiM   Ai.   Ai   Ai   Ai   Ai   Ai   Ait   AiU   Ai6   Ai   Ai   Ai   Ai   Ai   Ai|   Ai]   Ai>   Ai   Ai    Ai   Ai   Ai   Ai   Aie   AiF   Ai'   Ai   Ai   Ai   Ai   Ai   Aim   AiN   Ai/   Ai   Ai   Ai   Ai   Ai   Aiu   AiV   Ai7   Ai   Ai   Ai   Ai   Ai   Ai}   Ai^   Ai?   Ai    Ai   Ai   Ai   Aiɤ   Aiʅ   Aif   AiG   Ai(   Ai	   Ai   Ai   AiЬ   Aiэ   Ain   AiO   Ai0   Ai   Ai   Ai   Ai״   Aiؕ   Aiv   AiW   Ai8   Ai   Ai   Ai   Ai޼   Aiߝ   Ai~   Ai_   Ai@   Ai!   Ai   Ai   Ai   Ai   Ai   Aig   AiH   Ai)   Ai
   Ai   Ai   Ai   Ai   Aio   AiP   Ai1   Ai   Ai   Ai   Ai   Ai   Aiw   AiX   Ai9   Ai   Ai   Ai   Ai   Ai   Ai   Ai`   AiA   Aj "   Aj   Aj   Aj   Aj   Aj   Ajh   AjI   Aj*   Aj   Aj   Aj	   Aj
   Aj   Ajp   Aj
Q   Aj2   Aj   Aj   Aj   Aj   Aj   Ajx   AjY   Aj:   Aj   Aj   Aj   Aj   Aj   Aj   Aja   AjB   Aj#   Aj   Aj   Aj   Aj    Aj!   Aj"i   Aj#J   Aj$+   Aj%   Aj%   Aj&   Aj'   Aj(   Aj)q   Aj*R   Aj+3   Aj,   Aj,   Aj-   Aj.   Aj/   Aj0y   Aj1Z   Aj2;   Aj3   Aj3   Aj4   Aj5   Aj6   Aj7   Aj8b   Aj9C   Aj:$   Aj;   Aj;   Aj<   Aj=   Aj>   Aj?j   Aj@K   AjA,   AjB
   AjB   AjC   AjD   AjE   AjFr   AjGS   AjH4   AjI   AjI   AjJ   AjK   AjL   AjMz   AjN[   AjO<   AjP   AjP   AjQ   AjR   AjS   AjT   AjUc   AjVD   AjW%   AjX   AjX   AjY   AjZ   Aj[   Aj\k   Aj]L   Aj^-   Aj_   Aj_   Aj`   Aja   Ajb   Ajcs   AjdT   Aje5   Ajf   Ajf   Ajg   Ajh   Aji   Ajj{   Ajk\   Ajl=   Ajm   Ajm   Ajn   Ajo   Ajp   Ajq   Ajrd   AjsE   Ajt&   Aju   Aju   Ajv   Ajw   Ajx   Ajyl   AjzM   Aj{.   Aj|   Aj|   Aj}   Aj~   Aj   Ajt   AjU   Aj6   Aj   Aj   Aj   Aj   Aj   Aj|   Aj]   Aj>   Aj   Aj    Aj   Aj   Aj   Aj   Aje   AjF   Aj'   Aj   Aj   Aj   Aj   Aj   Ajm   AjN   Aj/   Aj   Aj   Aj   Aj   Aj   Aju   AjV   Aj7   Aj   Aj   Aj   Aj   Aj   Aj}   Aj^   Aj?   Aj    Aj   Aj   Aj   Aj   Aj   Ajf   AjG   Aj(   Aj	   Aj   Aj   Aj   Aj   Ajn   AjO   Aj0   Aj   Aj   Aj   Aj   Aj   Ajv   AjW   Aj8   Aj   Aj   Aj   Aj   Aj   Aj~   Aj_   Aj@   Aj!   Aj   Aj   Aj   Ajǥ   AjȆ   Ajg   AjH   Aj)   Aj
   Aj   Aj   Ajέ   Ajώ   Ajo   AjP   Aj1   Aj   Aj   Aj   Ajյ   Aj֖   Ajw   AjX   Aj9   Aj   Aj   Aj   Ajܽ   Ajݞ   Aj   Aj`   AjA   Aj"   Aj   Aj   Aj   Aj   Aj   Ajh   AjI   Aj*   Aj   Aj   Aj   Aj   Aj   Ajp   AjQ   Aj2   Aj   Aj   Aj   Aj   Aj   Ajx   AjY   Aj:   Aj   Aj   Aj   Aj   Aj   Aj   Aja   AjB   Aj#   Aj   Aj   Ak    Ak   Ak   Aki   AkJ   Ak+   Ak   Ak   Ak   Ak   Ak	   Ak
q   AkR   Ak3   Ak
   Ak
   Ak   Ak   Ak   Aky   AkZ   Ak;   Ak   Ak   Ak   Ak   Ak   Ak   Akb   AkC   Ak$   Ak   Ak   Ak   Ak   Ak   Ak j   Ak!K   Ak",   Ak#
   Ak#   Ak$   Ak%   Ak&   Ak'r   Ak(S   Ak)4   Ak*   Ak*   Ak+   Ak,   Ak-   Ak.z   Ak/[   Ak0<   Ak1   Ak1   Ak2   Ak3   Ak4   Ak5   Ak6c   Ak7D   Ak8%   Ak9   Ak9   Ak:   Ak;   Ak<   Ak=k   Ak>L   Ak?-   Ak@   Ak@   AkA   AkB   AkC   AkDs   AkET   AkF5   AkG   AkG   AkH   AkI   AkJ   AkK{   AkL\   AkM=   AkN   AkN   AkO   AkP   AkQ   AkR   AkSd   AkTE   AkU&   AkV   AkV   AkW   AkX   AkY   AkZl   Ak[M   Ak\.   Ak]   Ak]   Ak^   Ak_   Ak`   Akat   AkbU   Akc6   Akd   Akd   Ake   Akf   Akg   Akh|   Aki]   Akj>   Akk   Akl    Akl   Akm   Akn   Ako   Akpe   AkqF   Akr'   Aks   Aks   Akt   Aku   Akv   Akwm   AkxN   Aky/   Akz   Akz   Ak{   Ak|   Ak}   Ak~u   AkV   Ak7   Ak   Ak   Ak   Ak   Ak   Ak}   Ak^   Ak?   Ak    Ak   Ak   Ak   Ak   Ak   Akf   AkG   Ak(   Ak	   Ak   Ak   Ak   Ak   Akn   AkO   Ak0   Ak   Ak   Ak   Ak   Ak   Akv   AkW   Ak8   Ak   Ak   Ak   Ak   Ak   Ak~   Ak_   Ak@   Ak!   Ak   Ak   Ak   Ak   Ak   Akg   AkH   Ak)   Ak
   Ak   Ak   Ak   Ak   Ako   AkP   Ak1   Ak   Ak   Ak   Ak   Ak   Akw   AkX   Ak9   Ak   Ak   Ak   Ak   Ak   Ak   Ak`   AkA   Ak"   Ak   Ak   Ak   AkŦ   AkƇ   Akh   AkI   Ak*   Ak   Ak   Ak   Ak̮   Ak͏   Akp   AkQ   Ak2   Ak   Ak   Ak   AkӶ   Akԗ   Akx   AkY   Ak:   Ak   Ak   Ak   Akھ   Ak۟   Ak܀   Aka   AkB   Ak#   Ak   Ak   Ak   Ak   Ak   Aki   AkJ   Ak+   Ak   Ak   Ak   Ak   Ak   Akq   AkR   Ak3   Ak   Ak   Ak   Ak   Ak   Aky   AkZ   Ak;   Ak   Ak   Ak   Ak   Ak   Ak   Akb   AkC   Ak$   Ak   Ak   Ak   Ak   Al    Alj   AlK   Al,   Al
   Al   Al   Al   Al   Alr   Al	S   Al
4   Al   Al   Al   Al
   Al   Alz   Al[   Al<   Al   Al   Al   Al   Al   Al   Alc   AlD   Al%   Al   Al   Al   Al   Al   Alk   AlL   Al -   Al!   Al!   Al"   Al#   Al$   Al%s   Al&T   Al'5   Al(   Al(   Al)   Al*   Al+   Al,{   Al-\   Al.=   Al/   Al/   Al0   Al1   Al2   Al3   Al4d   Al5E   Al6&   Al7   Al7   Al8   Al9   Al:   Al;l   Al<M   Al=.   Al>   Al>   Al?   Al@   AlA   AlBt   AlCU   AlD6   AlE   AlE   AlF   AlG   AlH   AlI|   AlJ]   AlK>   AlL   AlM    AlM   AlN   AlO   AlP   AlQe   AlRF   AlS'   AlT   AlT   AlU   AlV   AlW   AlXm   AlYN   AlZ/   Al[   Al[   Al\   Al]   Al^   Al_u   Al`V   Ala7   Alb   Alb   Alc   Ald   Ale   Alf}   Alg^   Alh?   Ali    Alj   Alj   Alk   All   Alm   Alnf   AloG   Alp(   Alq	   Alq   Alr   Als   Alt   Alun   AlvO   Alw0   Alx   Alx   Aly   Alz   Al{   Al|v   Al}W   Al~8   Al   Al   Al   Al   Al   Al~   Al_   Al@   Al!   Al   Al   Al   Al   Al   Alg   AlH   Al)   Al
   Al   Al   Al   Al   Alo   AlP   Al1   Al   Al   Al   Al   Al   Alw   AlX   Al9   Al   Al   Al   Al   Al   Al   Al`   AlA   Al"   Al   Al   Al   Al   Al   Alh   AlI   Al*   Al   Al   Al   Al   Al   Alp   AlQ   Al2   Al   Al   Al   Al   Al   Alx   AlY   Al:   Al   Al   Al   Al   Al   Al   Ala   AlB   Al#   Al   Al   Al   Alç   AlĈ   Ali   AlJ   Al+   Al   Al   Al   Alʯ   Alː   Alq   AlR   Al3   Al   Al   Al   Alѷ   AlҘ   Aly   AlZ   Al;   Al   Al   Al   Alؿ   Al٠   Alځ   Alb   AlC   Al$   Al   Al   Al   Al   Al   Alj   AlK   Al,   Al
   Al   Al   Al   Al   Alr   AlS   Al4   Al   Al   Al   Al   Al   Alz   Al[   Al<   Al   Al   Al   Al   Al   Al   Alc   AlD   Al%   Al   Al   Al   Al   Al   Alk   Am L   Am-   Am   Am   Am   Am   Am   Ams   AmT   Am5   Am	   Am	   Am
   Am   Am   Am
{   Am\   Am=   Am   Am   Am   Am   Am   Am   Amd   AmE   Am&   Am   Am   Am   Am   Am   Aml   AmM   Am.   Am   Am   Am    Am!   Am"   Am#t   Am$U   Am%6   Am&   Am&   Am'   Am(   Am)   Am*|   Am+]   Am,>   Am-   Am.    Am.   Am/   Am0   Am1   Am2e   Am3F   Am4'   Am5   Am5   Am6   Am7   Am8   Am9m   Am:N   Am;/   Am<   Am<   Am=   Am>   Am?   Am@u   AmAV   AmB7   AmC   AmC   AmD   AmE   AmF   AmG}   AmH^   AmI?   AmJ    AmK   AmK   AmL   AmM   AmN   AmOf   AmPG   AmQ(   AmR	   AmR   AmS   AmT   AmU   AmVn   AmWO   AmX0   AmY   AmY   AmZ   Am[   Am\   Am]v   Am^W   Am_8   Am`   Am`   Ama   Amb   Amc   Amd~   Ame_   Amf@   Amg!   Amh   Amh   Ami   Amj   Amk   Amlg   AmmH   Amn)   Amo
   Amo   Amp   Amq   Amr   Amso   AmtP   Amu1   Amv   Amv   Amw   Amx   Amy   Amzw   Am{X   Am|9   Am}   Am}   Am~   Am   Am   Am   Am`   AmA   Am"   Am   Am   Am   Am   Am   Amh   AmI   Am*   Am   Am   Am   Am   Am   Amp   AmQ   Am2   Am   Am   Am   Am   Am   Amx   AmY   Am:   Am   Am   Am   Am   Am   Am   Ama   AmB   Am#   Am   Am   Am   Am   Am   Ami   AmJ   Am+   Am   Am   Am   Am   Am   Amq   AmR   Am3   Am   Am   Am   Am   Am   Amy   AmZ   Am;   Am   Am   Am   Am   Am   Am   Amb   AmC   Am$   Am   Am   Am   Am   Am   Amj   AmK   Am,   Am
   Am   Am   AmȰ   Amɑ   Amr   AmS   Am4   Am   Am   Am   Amϸ   AmЙ   Amz   Am[   Am<   Am   Am   Am   Am   Amס   Am؂   Amc   AmD   Am%   Am   Am   Am   Amީ   Amߊ   Amk   AmL   Am-   Am   Am   Am   Am   Am   Ams   AmT   Am5   Am   Am   Am   Am   Am   Am{   Am\   Am=   Am   Am   Am   Am   Am   Am   Amd   AmE   Am&   Am   Am   Am   Am   Am   Aml   AmM   Am.   An    An    An   An   An   Ant   AnU   An6   An   An   An   An	   An
   An|   An]   An
>   An   An    An   An   An   An   Ane   AnF   An'   An   An   An   An   An   Anm   AnN   An/   An   An   An   An   An    An!u   An"V   An#7   An$   An$   An%   An&   An'   An(}   An)^   An*?   An+    An,   An,   An-   An.   An/   An0f   An1G   An2(   An3	   An3   An4   An5   An6   An7n   An8O   An90   An:   An:   An;   An<   An=   An>v   An?W   An@8   AnA   AnA   AnB   AnC   AnD   AnE~   AnF_   AnG@   AnH!   AnI   AnI   AnJ   AnK   AnL   AnMg   AnNH   AnO)   AnP
   AnP   AnQ   AnR   AnS   AnTo   AnUP   AnV1   AnW   AnW   AnX   AnY   AnZ   An[w   An\X   An]9   An^   An^   An_   An`   Ana   Anb   Anc`   AndA   Ane"   Anf   Anf   Ang   Anh   Ani   Anjh   AnkI   Anl*   Anm   Anm   Ann   Ano   Anp   Anqp   AnrQ   Ans2   Ant   Ant   Anu   Anv   Anw   Anxx   AnyY   Anz:   An{   An{   An|   An}   An~   An   Ana   AnB   An#   An   An   An   An   An   Ani   AnJ   An+   An   An   An   An   An   Anq   AnR   An3   An   An   An   An   An   Any   AnZ   An;   An   An   An   An   An   An   Anb   AnC   An$   An   An   An   An   An   Anj   AnK   An,   An
   An   An   An   An   Anr   AnS   An4   An   An   An   An   An   Anz   An[   An<   An   An   An   An   An   An   Anc   AnD   An%   An   An   An   An   An   Ank   AnL   An-   An   An   An   AnƱ   Anǒ   Ans   AnT   An5   An   An   An   An͹   AnΚ   An{   An\   An=   An   An   An   An   Anբ   Anփ   And   AnE   An&   An   An   An   Anܪ   An݋   Anl   AnM   An.   An   An   An   An   An   Ant   AnU   An6   An   An   An   An   An   An|   An]   An>   An   An    An   An   An   An   Ane   AnF   An'   An   An   An   An   An   Anm   AnN   An/   An   An   An   Ao    Ao   Aou   AoV   Ao7   Ao   Ao   Ao   Ao   Ao   Ao	}   Ao
^   Ao?   Ao    Ao
   Ao
   Ao   Ao   Ao   Aof   AoG   Ao(   Ao	   Ao   Ao   Ao   Ao   Aon   AoO   Ao0   Ao   Ao   Ao   Ao   Ao   Aov   Ao W   Ao!8   Ao"   Ao"   Ao#   Ao$   Ao%   Ao&~   Ao'_   Ao(@   Ao)!   Ao*   Ao*   Ao+   Ao,   Ao-   Ao.g   Ao/H   Ao0)   Ao1
   Ao1   Ao2   Ao3   Ao4   Ao5o   Ao6P   Ao71   Ao8   Ao8   Ao9   Ao:   Ao;   Ao<w   Ao=X   Ao>9   Ao?   Ao?   Ao@   AoA   AoB   AoC   AoD`   AoEA   AoF"   AoG   AoG   AoH   AoI   AoJ   AoKh   AoLI   AoM*   AoN   AoN   AoO   AoP   AoQ   AoRp   AoSQ   AoT2   AoU   AoU   AoV   AoW   AoX   AoYx   AoZY   Ao[:   Ao\   Ao\   Ao]   Ao^   Ao_   Ao`   Aoaa   AobB   Aoc#   Aod   Aod   Aoe   Aof   Aog   Aohi   AoiJ   Aoj+   Aok   Aok   Aol   Aom   Aon   Aooq   AopR   Aoq3   Aor   Aor   Aos   Aot   Aou   Aovy   AowZ   Aox;   Aoy   Aoy   Aoz   Ao{   Ao|   Ao}   Ao~b   AoC   Ao$   Ao   Ao   Ao   Ao   Ao   Aoj   AoK   Ao,   Ao
   Ao   Ao   Ao   Ao   Aor   AoS   Ao4   Ao   Ao   Ao   Ao   Ao   Aoz   Ao[   Ao<   Ao   Ao   Ao   Ao   Ao   Ao   Aoc   AoD   Ao%   Ao   Ao   Ao   Ao   Ao   Aok   AoL   Ao-   Ao   Ao   Ao   Ao   Ao   Aos   AoT   Ao5   Ao   Ao   Ao   Ao   Ao   Ao{   Ao\   Ao=   Ao   Ao   Ao   Ao   Ao   Ao   Aod   AoE   Ao&   Ao   Ao   Ao   Ao   Ao   Aol   AoM   Ao.   Ao   Ao   Ao   AoĲ   Aoœ   Aot   AoU   Ao6   Ao   Ao   Ao   Ao˺   Aơ   Ao|   Ao]   Ao>   Ao   Ao    Ao   Ao   Aoӣ   AoԄ   Aoe   AoF   Ao'   Ao   Ao   Ao   Aoګ   Aoی   Aom   AoN   Ao/   Ao   Ao   Ao   Ao   Ao   Aou   AoV   Ao7   Ao   Ao   Ao   Ao   Ao   Ao}   Ao^   Ao?   Ao    Ao   Ao   Ao   Ao   Ao   Aof   AoG   Ao(   Ao	   Ao   Ao   Ao   Ao   Aon   AoO   Ao0   Ao   Ao   Ao   Ao   Ao   Ap v   ApW   Ap8   Ap   Ap   Ap   Ap   Ap   Ap~   Ap_   Ap	@   Ap
!   Ap   Ap   Ap   Ap
   Ap   Apg   ApH   Ap)   Ap
   Ap   Ap   Ap   Ap   Apo   ApP   Ap1   Ap   Ap   Ap   Ap   Ap   Apw   ApX   Ap9   Ap    Ap    Ap!   Ap"   Ap#   Ap$   Ap%`   Ap&A   Ap'"   Ap(   Ap(   Ap)   Ap*   Ap+   Ap,h   Ap-I   Ap.*   Ap/   Ap/   Ap0   Ap1   Ap2   Ap3p   Ap4Q   Ap52   Ap6   Ap6   Ap7   Ap8   Ap9   Ap:x   Ap;Y   Ap<:   Ap=   Ap=   Ap>   Ap?   Ap@   ApA   ApBa   ApCB   ApD#   ApE   ApE   ApF   ApG   ApH   ApIi   ApJJ   ApK+   ApL   ApL   ApM   ApN   ApO   ApPq   ApQR   ApR3   ApS   ApS   ApT   ApU   ApV   ApWy   ApXZ   ApY;   ApZ   ApZ   Ap[   Ap\   Ap]   Ap^   Ap_b   Ap`C   Apa$   Apb   Apb   Apc   Apd   Ape   Apfj   ApgK   Aph,   Api
   Api   Apj   Apk   Apl   Apmr   ApnS   Apo4   App   App   Apq   Apr   Aps   Aptz   Apu[   Apv<   Apw   Apw   Apx   Apy   Apz   Ap{   Ap|c   Ap}D   Ap~%   Ap   Ap   Ap   Ap   Ap   Apk   ApL   Ap-   Ap   Ap   Ap   Ap   Ap   Aps   ApT   Ap5   Ap   Ap   Ap   Ap   Ap   Ap{   Ap\   Ap=   Ap   Ap   Ap   Ap   Ap   Ap   Apd   ApE   Ap&   Ap   Ap   Ap   Ap   Ap   Apl   ApM   Ap.   Ap   Ap   Ap   Ap   Ap   Apt   ApU   Ap6   Ap   Ap   Ap   Ap   Ap   Ap|   Ap]   Ap>   Ap   Ap    Ap   Ap   Ap   Ap   Ape   ApF   Ap'   Ap   Ap   Ap   Ap   Ap   Apm   ApN   Ap/   Ap   Ap   Ap   Ap³   ApÔ   Apu   ApV   Ap7   Ap   Ap   Ap   Apɻ   Apʜ   Ap}   Ap^   Ap?   Ap    Ap   Ap   Ap   ApѤ   Ap҅   Apf   ApG   Ap(   Ap	   Ap   Ap   Apج   Apٍ   Apn   ApO   Ap0   Ap   Ap   Ap   Apߴ   Ap   Apv   ApW   Ap8   Ap   Ap   Ap   Ap   Ap   Ap~   Ap_   Ap@   Ap!   Ap   Ap   Ap   Ap   Ap   Apg   ApH   Ap)   Ap
   Ap   Ap   Ap   Ap   Apo   ApP   Ap1   Ap   Ap   Ap   Ap   Ap   Apw   ApX   Aq 9   Aq   Aq   Aq   Aq   Aq   Aq   Aq`   AqA   Aq"   Aq	   Aq	   Aq
   Aq   Aq   Aq
h   AqI   Aq*   Aq   Aq   Aq   Aq   Aq   Aqp   AqQ   Aq2   Aq   Aq   Aq   Aq   Aq   Aqx   AqY   Aq:   Aq   Aq   Aq   Aq    Aq!   Aq"   Aq#a   Aq$B   Aq%#   Aq&   Aq&   Aq'   Aq(   Aq)   Aq*i   Aq+J   Aq,+   Aq-   Aq-   Aq.   Aq/   Aq0   Aq1q   Aq2R   Aq33   Aq4   Aq4   Aq5   Aq6   Aq7   Aq8y   Aq9Z   Aq:;   Aq;   Aq;   Aq<   Aq=   Aq>   Aq?   Aq@b   AqAC   AqB$   AqC   AqC   AqD   AqE   AqF   AqGj   AqHK   AqI,   AqJ
   AqJ   AqK   AqL   AqM   AqNr   AqOS   AqP4   AqQ   AqQ   AqR   AqS   AqT   AqUz   AqV[   AqW<   AqX   AqX   AqY   AqZ   Aq[   Aq\   Aq]c   Aq^D   Aq_%   Aq`   Aq`   Aqa   Aqb   Aqc   Aqdk   AqeL   Aqf-   Aqg   Aqg   Aqh   Aqi   Aqj   Aqks   AqlT   Aqm5   Aqn   Aqn   Aqo   Aqp   Aqq   Aqr{   Aqs\   Aqt=   Aqu   Aqu   Aqv   Aqw   Aqx   Aqy   Aqzd   Aq{E   Aq|&   Aq}   Aq}   Aq~   Aq   Aq   Aql   AqM   Aq.   Aq   Aq   Aq   Aq   Aq   Aqt   AqU   Aq6   Aq   Aq   Aq   Aq   Aq   Aq|   Aq]   Aq>   Aq   Aq    Aq   Aq   Aq   Aq   Aqe   AqF   Aq'   Aq   Aq   Aq   Aq   Aq   Aqm   AqN   Aq/   Aq   Aq   Aq   Aq   Aq   Aqu   AqV   Aq7   Aq   Aq   Aq   Aq   Aq   Aq}   Aq^   Aq?   Aq    Aq   Aq   Aq   Aq   Aq   Aqf   AqG   Aq(   Aq	   Aq   Aq   Aq   Aq   Aqn   AqO   Aq0   Aq   Aq   Aq   Aq   Aq   Aqv   AqW   Aq8   Aq   Aq   Aq   AqǼ   Aqȝ   Aq~   Aq_   Aq@   Aq!   Aq   Aq   Aq   Aqϥ   AqІ   Aqg   AqH   Aq)   Aq
   Aq   Aq   Aq֭   Aq׎   Aqo   AqP   Aq1   Aq   Aq   Aq   Aqݵ   Aqޖ   Aqw   AqX   Aq9   Aq   Aq   Aq   Aq   Aq   Aq   Aq`   AqA   Aq"   Aq   Aq   Aq   Aq   Aq   Aqh   AqI   Aq*   Aq   Aq   Aq   Aq   Aq   Aqp   AqQ   Aq2   Aq   Aq   Aq   Aq   Aq   Aqx   AqY   Aq:   Aq   Aq   Ar    Ar   Ar   Ar   Ara   ArB   Ar#   Ar   Ar   Ar   Ar	   Ar
   Ari   ArJ   Ar
+   Ar   Ar   Ar   Ar   Ar   Arq   ArR   Ar3   Ar   Ar   Ar   Ar   Ar   Ary   ArZ   Ar;   Ar   Ar   Ar   Ar   Ar   Ar    Ar!b   Ar"C   Ar#$   Ar$   Ar$   Ar%   Ar&   Ar'   Ar(j   Ar)K   Ar*,   Ar+
   Ar+   Ar,   Ar-   Ar.   Ar/r   Ar0S   Ar14   Ar2   Ar2   Ar3   Ar4   Ar5   Ar6z   Ar7[   Ar8<   Ar9   Ar9   Ar:   Ar;   Ar<   Ar=   Ar>c   Ar?D   Ar@%   ArA   ArA   ArB   ArC   ArD   ArEk   ArFL   ArG-   ArH   ArH   ArI   ArJ   ArK   ArLs   ArMT   ArN5   ArO   ArO   ArP   ArQ   ArR   ArS{   ArT\   ArU=   ArV   ArV   ArW   ArX   ArY   ArZ   Ar[d   Ar\E   Ar]&   Ar^   Ar^   Ar_   Ar`   Ara   Arbl   ArcM   Ard.   Are   Are   Arf   Arg   Arh   Arit   ArjU   Ark6   Arl   Arl   Arm   Arn   Aro   Arp|   Arq]   Arr>   Ars   Art    Art   Aru   Arv   Arw   Arxe   AryF   Arz'   Ar{   Ar{   Ar|   Ar}   Ar~   Arm   ArN   Ar/   Ar   Ar   Ar   Ar   Ar   Aru   ArV   Ar7   Ar   Ar   Ar   Ar   Ar   Ar}   Ar^   Ar?   Ar    Ar   Ar   Ar   Ar   Ar   Arf   ArG   Ar(   Ar	   Ar   Ar   Ar   Ar   Arn   ArO   Ar0   Ar   Ar   Ar   Ar   Ar   Arv   ArW   Ar8   Ar   Ar   Ar   Ar   Ar   Ar~   Ar_   Ar@   Ar!   Ar   Ar   Ar   Ar   Ar   Arg   ArH   Ar)   Ar
   Ar   Ar   Ar   Ar   Aro   ArP   Ar1   Ar   Ar   Ar   Ar   Ar   Arw   ArX   Ar9   Ar   Ar   Ar   ArŽ   Arƞ   Ar   Ar`   ArA   Ar"   Ar   Ar   Ar   Arͦ   Ar·   Arh   ArI   Ar*   Ar   Ar   Ar   ArԮ   ArՏ   Arp   ArQ   Ar2   Ar   Ar   Ar   Ar۶   Arܗ   Arx   ArY   Ar:   Ar   Ar   Ar   Ar   Ar   Ar   Ara   ArB   Ar#   Ar   Ar   Ar   Ar   Ar   Ari   ArJ   Ar+   Ar   Ar   Ar   Ar   Ar   Arq   ArR   Ar3   Ar   Ar   Ar   Ar   Ar   Ary   ArZ   Ar;   Ar   Ar   Ar   Ar   As    As   Asb   AsC   As$   As   As   As   As   As   As	j   As
K   As,   As
   As   As
   As   As   Asr   AsS   As4   As   As   As   As   As   Asz   As[   As<   As   As   As   As   As   As   Asc   As D   As!%   As"   As"   As#   As$   As%   As&k   As'L   As(-   As)   As)   As*   As+   As,   As-s   As.T   As/5   As0   As0   As1   As2   As3   As4{   As5\   As6=   As7   As7   As8   As9   As:   As;   As<d   As=E   As>&   As?   As?   As@   AsA   AsB   AsCl   AsDM   AsE.   AsF   AsF   AsG   AsH   AsI   AsJt   AsKU   AsL6   AsM   AsM   AsN   AsO   AsP   AsQ|   AsR]   AsS>   AsT   AsU    AsU   AsV   AsW   AsX   AsYe   AsZF   As['   As\   As\   As]   As^   As_   As`m   AsaN   Asb/   Asc   Asc   Asd   Ase   Asf   Asgu   AshV   Asi7   Asj   Asj   Ask   Asl   Asm   Asn}   Aso^   Asp?   Asq    Asr   Asr   Ass   Ast   Asu   Asvf   AswG   Asx(   Asy	   Asy   Asz   As{   As|   As}n   As~O   As0   As   As   As   As   As   Asv   AsW   As8   As   As   As   As   As   As~   As_   As@   As!   As   As   As   As   As   Asg   AsH   As)   As
   As   As   As   As   Aso   AsP   As1   As   As   As   As   As   Asw   AsX   As9   As   As   As   As   As   As   As`   AsA   As"   As   As   As   As   As   Ash   AsI   As*   As   As   As   As   As   Asp   AsQ   As2   As   As   As   As   As   Asx   AsY   As:   As   As   As   Asþ   Asğ   Asŀ   Asa   AsB   As#   As   As   As   As˧   As̈   Asi   AsJ   As+   As   As   As   Asү   AsӐ   Asq   AsR   As3   As   As   As   Asٷ   Asژ   Asy   AsZ   As;   As   As   As   As   As   As   Asb   AsC   As$   As   As   As   As   As   Asj   AsK   As,   As
   As   As   As   As   Asr   AsS   As4   As   As   As   As   As   Asz   As[   As<   As   As   As   As   As   As   At c   AtD   At%   At   At   At   At   At   Atk   AtL   At	-   At
   At
   At   At   At
   Ats   AtT   At5   At   At   At   At   At   At{   At\   At=   At   At   At   At   At   At   Atd   AtE   At&   At    At    At!   At"   At#   At$l   At%M   At&.   At'   At'   At(   At)   At*   At+t   At,U   At-6   At.   At.   At/   At0   At1   At2|   At3]   At4>   At5   At6    At6   At7   At8   At9   At:e   At;F   At<'   At=   At=   At>   At?   At@   AtAm   AtBN   AtC/   AtD   AtD   AtE   AtF   AtG   AtHu   AtIV   AtJ7   AtK   AtK   AtL   AtM   AtN   AtO}   AtP^   AtQ?   AtR    AtS   AtS   AtT   AtU   AtV   AtWf   AtXG   AtY(   AtZ	   AtZ   At[   At\   At]   At^n   At_O   At`0   Ata   Ata   Atb   Atc   Atd   Atev   AtfW   Atg8   Ath   Ath   Ati   Atj   Atk   Atl~   Atm_   Atn@   Ato!   Atp   Atp   Atq   Atr   Ats   Attg   AtuH   Atv)   Atw
   Atw   Atx   Aty   Atz   At{o   At|P   At}1   At~   At~   At   At   At   Atw   AtX   At9   At   At   At   At   At   At   At`   AtA   At"   At   At   At   At   At   Ath   AtI   At*   At   At   At   At   At   Atp   AtQ   At2   At   At   At   At   At   Atx   AtY   At:   At   At   At   At   At   At   Ata   AtB   At#   At   At   At   At   At   Ati   AtJ   At+   At   At   At   At   At   Atq   AtR   At3   At   At   At   At   At   Aty   AtZ   At;   At   At   At   At   At    AtÁ   Atb   AtC   At$   At   At   At   Atɨ   Atʉ   Atj   AtK   At,   At
   At   At   Atа   Atё   Atr   AtS   At4   At   At   At   At׸   Atؙ   Atz   At[   At<   At   At   At   At   Atߡ   At   Atc   AtD   At%   At   At   At   At   At   Atk   AtL   At-   At   At   At   At   At   Ats   AtT   At5   At   At   At   At   At   At{   At\   At=   At   At   At   At   At   At   Atd   AtE   Au &   Au   Au   Au   Au   Au   Aul   AuM   Au.   Au   Au   Au	   Au
   Au   Aut   Au
U   Au6   Au   Au   Au   Au   Au   Au|   Au]   Au>   Au   Au    Au   Au   Au   Au   Aue   AuF   Au'   Au   Au   Au   Au    Au!   Au"m   Au#N   Au$/   Au%   Au%   Au&   Au'   Au(   Au)u   Au*V   Au+7   Au,   Au,   Au-   Au.   Au/   Au0}   Au1^   Au2?   Au3    Au4   Au4   Au5   Au6   Au7   Au8f   Au9G   Au:(   Au;	   Au;   Au<   Au=   Au>   Au?n   Au@O   AuA0   AuB   AuB   AuC   AuD   AuE   AuFv   AuGW   AuH8   AuI   AuI   AuJ   AuK   AuL   AuM~   AuN_   AuO@   AuP!   AuQ   AuQ   AuR   AuS   AuT   AuUg   AuVH   AuW)   AuX
   AuX   AuY   AuZ   Au[   Au\o   Au]P   Au^1   Au_   Au_   Au`   Aua   Aub   Aucw   AudX   Aue9   Auf   Auf   Aug   Auh   Aui   Auj   Auk`   AulA   Aum"   Aun   Aun   Auo   Aup   Auq   Aurh   AusI   Aut*   Auu   Auu   Auv   Auw   Aux   Auyp   AuzQ   Au{2   Au|   Au|   Au}   Au~   Au   Aux   AuY   Au:   Au   Au   Au   Au   Au   Au   Aua   AuB   Au#   Au   Au   Au   Au   Au   Aui   AuJ   Au+   Au   Au   Au   Au   Au   Auq   AuR   Au3   Au   Au   Au   Au   Au   Auy   AuZ   Au;   Au   Au   Au   Au   Au   Au   Aub   AuC   Au$   Au   Au   Au   Au   Au   Auj   AuK   Au,   Au
   Au   Au   Au   Au   Aur   AuS   Au4   Au   Au   Au   Au   Au   Auz   Au[   Au<   Au   Au   Au   Au   Au   Au   Auc   AuD   Au%   Au   Au   Au   Auǩ   AuȊ   Auk   AuL   Au-   Au   Au   Au   Auα   Auϒ   Aus   AuT   Au5   Au   Au   Au   Auչ   Au֚   Au{   Au\   Au=   Au   Au   Au   Au   Auݢ   Auރ   Aud   AuE   Au&   Au   Au   Au   Au   Au   Aul   AuM   Au.   Au   Au   Au   Au   Au   Aut   AuU   Au6   Au   Au   Au   Au   Au   Au|   Au]   Au>   Au   Au    Au   Au   Au   Au   Aue   AuF   Au'   Au   Au   Av    Av   Av   Avm   AvN   Av/   Av   Av   Av   Av   Av	   Av
u   AvV   Av7   Av
   Av
   Av   Av   Av   Av}   Av^   Av?   Av    Av   Av   Av   Av   Av   Avf   AvG   Av(   Av	   Av   Av   Av   Av   Av n   Av!O   Av"0   Av#   Av#   Av$   Av%   Av&   Av'v   Av(W   Av)8   Av*   Av*   Av+   Av,   Av-   Av.~   Av/_   Av0@   Av1!   Av2   Av2   Av3   Av4   Av5   Av6g   Av7H   Av8)   Av9
   Av9   Av:   Av;   Av<   Av=o   Av>P   Av?1   Av@   Av@   AvA   AvB   AvC   AvDw   AvEX   AvF9   AvG   AvG   AvH   AvI   AvJ   AvK   AvL`   AvMA   AvN"   AvO   AvO   AvP   AvQ   AvR   AvSh   AvTI   AvU*   AvV   AvV   AvW   AvX   AvY   AvZp   Av[Q   Av\2   Av]   Av]   Av^   Av_   Av`   Avax   AvbY   Avc:   Avd   Avd   Ave   Avf   Avg   Avh   Avia   AvjB   Avk#   Avl   Avl   Avm   Avn   Avo   Avpi   AvqJ   Avr+   Avs   Avs   Avt   Avu   Avv   Avwq   AvxR   Avy3   Avz   Avz   Av{   Av|   Av}   Av~y   AvZ   Av;   Av   Av   Av   Av   Av   Av   Avb   AvC   Av$   Av   Av   Av   Av   Av   Avj   AvK   Av,   Av
   Av   Av   Av   Av   Avr   AvS   Av4   Av   Av   Av   Av   Av   Avz   Av[   Av<   Av   Av   Av   Av   Av   Av   Avc   AvD   Av%   Av   Av   Av   Av   Av   Avk   AvL   Av-   Av   Av   Av   Av   Av   Avs   AvT   Av5   Av   Av   Av   Av   Av   Av{   Av\   Av=   Av   Av   Av   Av   Av   Av   Avd   AvE   Av&   Av   Av   Av   AvŪ   AvƋ   Avl   AvM   Av.   Av   Av   Av   Av̲   Av͓   Avt   AvU   Av6   Av   Av   Av   AvӺ   Avԛ   Av|   Av]   Av>   Av   Av    Av   Av   Avۣ   Av܄   Ave   AvF   Av'   Av   Av   Av   Av   Av   Avm   AvN   Av/   Av   Av   Av   Av   Av   Avu   AvV   Av7   Av   Av   Av   Av   Av   Av}   Av^   Av?   Av    Av   Av   Av   Av   Av   Avf   AvG   Av(   Av	   Av   Av   Av   Aw    Awn   AwO   Aw0   Aw   Aw   Aw   Aw   Aw   Awv   Aw	W   Aw
8   Aw   Aw   Aw   Aw
   Aw   Aw~   Aw_   Aw@   Aw!   Aw   Aw   Aw   Aw   Aw   Awg   AwH   Aw)   Aw
   Aw   Aw   Aw   Aw   Awo   AwP   Aw 1   Aw!   Aw!   Aw"   Aw#   Aw$   Aw%w   Aw&X   Aw'9   Aw(   Aw(   Aw)   Aw*   Aw+   Aw,   Aw-`   Aw.A   Aw/"   Aw0   Aw0   Aw1   Aw2   Aw3   Aw4h   Aw5I   Aw6*   Aw7   Aw7   Aw8   Aw9   Aw:   Aw;p   Aw<Q   Aw=2   Aw>   Aw>   Aw?   Aw@   AwA   AwBx   AwCY   AwD:   AwE   AwE   AwF   AwG   AwH   AwI   AwJa   AwKB   AwL#   AwM   AwM   AwN   AwO   AwP   AwQi   AwRJ   AwS+   AwT   AwT   AwU   AwV   AwW   AwXq   AwYR   AwZ3   Aw[   Aw[   Aw\   Aw]   Aw^   Aw_y   Aw`Z   Awa;   Awb   Awb   Awc   Awd   Awe   Awf   Awgb   AwhC   Awi$   Awj   Awj   Awk   Awl   Awm   Awnj   AwoK   Awp,   Awq
   Awq   Awr   Aws   Awt   Awur   AwvS   Aww4   Awx   Awx   Awy   Awz   Aw{   Aw|z   Aw}[   Aw~<   Aw   Aw   Aw   Aw   Aw   Aw   Awc   AwD   Aw%   Aw   Aw   Aw   Aw   Aw   Awk   AwL   Aw-   Aw   Aw   Aw   Aw   Aw   Aws   AwT   Aw5   Aw   Aw   Aw   Aw   Aw   Aw{   Aw\   Aw=   Aw   Aw   Aw   Aw   Aw   Aw   Awd   AwE   Aw&   Aw   Aw   Aw   Aw   Aw   Awl   AwM   Aw.   Aw   Aw   Aw   Aw   Aw   Awt   AwU   Aw6   Aw   Aw   Aw   Aw   Aw   Aw|   Aw]   Aw>   Aw   Aw    Aw   Aw   Aw   Aw   Awe   AwF   Aw'   Aw   Aw   Aw   Awë   AwČ   Awm   AwN   Aw/   Aw   Aw   Aw   Awʳ   Aw˔   Awu   AwV   Aw7   Aw   Aw   Aw   Awѻ   AwҜ   Aw}   Aw^   Aw?   Aw    Aw   Aw   Aw   Aw٤   Awڅ   Awf   AwG   Aw(   Aw	   Aw   Aw   Aw   Aw   Awn   AwO   Aw0   Aw   Aw   Aw   Aw   Aw   Awv   AwW   Aw8   Aw   Aw   Aw   Aw   Aw   Aw~   Aw_   Aw@   Aw!   Aw   Aw   Aw   Aw   Aw   Awg   AwH   Aw)   Aw
   Aw   Aw   Aw   Aw   Awo   Ax P   Ax1   Ax   Ax   Ax   Ax   Ax   Axw   AxX   Ax9   Ax	   Ax	   Ax
   Ax   Ax   Ax
   Ax`   AxA   Ax"   Ax   Ax   Ax   Ax   Ax   Axh   AxI   Ax*   Ax   Ax   Ax   Ax   Ax   Axp   AxQ   Ax2   Ax   Ax   Ax    Ax!   Ax"   Ax#x   Ax$Y   Ax%:   Ax&   Ax&   Ax'   Ax(   Ax)   Ax*   Ax+a   Ax,B   Ax-#   Ax.   Ax.   Ax/   Ax0   Ax1   Ax2i   Ax3J   Ax4+   Ax5   Ax5   Ax6   Ax7   Ax8   Ax9q   Ax:R   Ax;3   Ax<   Ax<   Ax=   Ax>   Ax?   Ax@y   AxAZ   AxB;   AxC   AxC   AxD   AxE   AxF   AxG   AxHb   AxIC   AxJ$   AxK   AxK   AxL   AxM   AxN   AxOj   AxPK   AxQ,   AxR
   AxR   AxS   AxT   AxU   AxVr   AxWS   AxX4   AxY   AxY   AxZ   Ax[   Ax\   Ax]z   Ax^[   Ax_<   Ax`   Ax`   Axa   Axb   Axc   Axd   Axec   AxfD   Axg%   Axh   Axh   Axi   Axj   Axk   Axlk   AxmL   Axn-   Axo   Axo   Axp   Axq   Axr   Axss   AxtT   Axu5   Axv   Axv   Axw   Axx   Axy   Axz{   Ax{\   Ax|=   Ax}   Ax}   Ax~   Ax   Ax   Ax   Axd   AxE   Ax&   Ax   Ax   Ax   Ax   Ax   Axl   AxM   Ax.   Ax   Ax   Ax   Ax   Ax   Axt   AxU   Ax6   Ax   Ax   Ax   Ax   Ax   Ax|   Ax]   Ax>   Ax   Ax    Ax   Ax   Ax   Ax   Axe   AxF   Ax'   Ax   Ax   Ax   Ax   Ax   Axm   AxN   Ax/   Ax   Ax   Ax   Ax   Ax   Axu   AxV   Ax7   Ax   Ax   Ax   Ax   Ax   Ax}   Ax^   Ax?   Ax    Ax   Ax   Ax   Ax   Ax   Axf   AxG   Ax(   Ax	   Ax   Ax   Ax   Ax   Axn   AxO   Ax0   Ax   Ax   Ax   Axȴ   Axɕ   Axv   AxW   Ax8   Ax   Ax   Ax   Axϼ   AxН   Ax~   Ax_   Ax@   Ax!   Ax   Ax   Ax   Axץ   Ax؆   Axg   AxH   Ax)   Ax
   Ax   Ax   Axޭ   Axߎ   Axo   AxP   Ax1   Ax   Ax   Ax   Ax   Ax   Axw   AxX   Ax9   Ax   Ax   Ax   Ax   Ax   Ax   Ax`   AxA   Ax"   Ax   Ax   Ax   Ax   Ax   Axh   AxI   Ax*   Ax   Ax   Ax   Ax   Ax   Axp   AxQ   Ax2   Ay    Ay    Ay   Ay   Ay   Ayx   AyY   Ay:   Ay   Ay   Ay   Ay	   Ay
   Ay   Aya   Ay
B   Ay#   Ay   Ay   Ay   Ay   Ay   Ayi   AyJ   Ay+   Ay   Ay   Ay   Ay   Ay   Ayq   AyR   Ay3   Ay   Ay   Ay   Ay   Ay    Ay!y   Ay"Z   Ay#;   Ay$   Ay$   Ay%   Ay&   Ay'   Ay(   Ay)b   Ay*C   Ay+$   Ay,   Ay,   Ay-   Ay.   Ay/   Ay0j   Ay1K   Ay2,   Ay3
   Ay3   Ay4   Ay5   Ay6   Ay7r   Ay8S   Ay94   Ay:   Ay:   Ay;   Ay<   Ay=   Ay>z   Ay?[   Ay@<   AyA   AyA   AyB   AyC   AyD   AyE   AyFc   AyGD   AyH%   AyI   AyI   AyJ   AyK   AyL   AyMk   AyNL   AyO-   AyP   AyP   AyQ   AyR   AyS   AyTs   AyUT   AyV5   AyW   AyW   AyX   AyY   AyZ   Ay[{   Ay\\   Ay]=   Ay^   Ay^   Ay_   Ay`   Aya   Ayb   Aycd   AydE   Aye&   Ayf   Ayf   Ayg   Ayh   Ayi   Ayjl   AykM   Ayl.   Aym   Aym   Ayn   Ayo   Ayp   Ayqt   AyrU   Ays6   Ayt   Ayt   Ayu   Ayv   Ayw   Ayx|   Ayy]   Ayz>   Ay{   Ay|    Ay|   Ay}   Ay~   Ay   Aye   AyF   Ay'   Ay   Ay   Ay   Ay   Ay   Aym   AyN   Ay/   Ay   Ay   Ay   Ay   Ay   Ayu   AyV   Ay7   Ay   Ay   Ay   Ay   Ay   Ay}   Ay^   Ay?   Ay    Ay   Ay   Ay   Ay   Ay   Ayf   AyG   Ay(   Ay	   Ay   Ay   Ay   Ay   Ayn   AyO   Ay0   Ay   Ay   Ay   Ay   Ay   Ayv   AyW   Ay8   Ay   Ay   Ay   Ay   Ay   Ay~   Ay_   Ay@   Ay!   Ay   Ay   Ay   Ay   Ay   Ayg   AyH   Ay)   Ay
   Ay   Ay   Ay   Ay   Ayo   AyP   Ay1   Ay   Ay   Ay   AyƵ   Ayǖ   Ayw   AyX   Ay9   Ay   Ay   Ay   Ayͽ   AyΞ   Ay   Ay`   AyA   Ay"   Ay   Ay   Ay   Ayզ   Ayև   Ayh   AyI   Ay*   Ay   Ay   Ay   Ayܮ   Ayݏ   Ayp   AyQ   Ay2   Ay   Ay   Ay   Ay   Ay   Ayx   AyY   Ay:   Ay   Ay   Ay   Ay   Ay   Ay   Aya   AyB   Ay#   Ay   Ay   Ay   Ay   Ay   Ayi   AyJ   Ay+   Ay   Ay   Ay   Ay   Ay   Ayq   AyR   Ay3   Ay   Ay   Ay   Az    Az   Azy   AzZ   Az;   Az   Az   Az   Az   Az   Az	   Az
b   AzC   Az$   Az
   Az
   Az   Az   Az   Azj   AzK   Az,   Az
   Az   Az   Az   Az   Azr   AzS   Az4   Az   Az   Az   Az   Az   Azz   Az [   Az!<   Az"   Az"   Az#   Az$   Az%   Az&   Az'c   Az(D   Az)%   Az*   Az*   Az+   Az,   Az-   Az.k   Az/L   Az0-   Az1   Az1   Az2   Az3   Az4   Az5s   Az6T   Az75   Az8   Az8   Az9   Az:   Az;   Az<{   Az=\   Az>=   Az?   Az?   Az@   AzA   AzB   AzC   AzDd   AzEE   AzF&   AzG   AzG   AzH   AzI   AzJ   AzKl   AzLM   AzM.   AzN   AzN   AzO   AzP   AzQ   AzRt   AzSU   AzT6   AzU   AzU   AzV   AzW   AzX   AzY|   AzZ]   Az[>   Az\   Az]    Az]   Az^   Az_   Az`   Azae   AzbF   Azc'   Azd   Azd   Aze   Azf   Azg   Azhm   AziN   Azj/   Azk   Azk   Azl   Azm   Azn   Azou   AzpV   Azq7   Azr   Azr   Azs   Azt   Azu   Azv}   Azw^   Azx?   Azy    Azz   Azz   Az{   Az|   Az}   Az~f   AzG   Az(   Az	   Az   Az   Az   Az   Azn   AzO   Az0   Az   Az   Az   Az   Az   Azv   AzW   Az8   Az   Az   Az   Az   Az   Az~   Az_   Az@   Az!   Az   Az   Az   Az   Az   Azg   AzH   Az)   Az
   Az   Az   Az   Az   Azo   AzP   Az1   Az   Az   Az   Az   Az   Azw   AzX   Az9   Az   Az   Az   Az   Az   Az   Az`   AzA   Az"   Az   Az   Az   Az   Az   Azh   AzI   Az*   Az   Az   Az   Az   Az   Azp   AzQ   Az2   Az   Az   Az   AzĶ   Azŗ   Azx   AzY   Az:   Az   Az   Az   Az˾   Az̟   Az̀   Aza   AzB   Az#   Az   Az   Az   Azӧ   AzԈ   Azi   AzJ   Az+   Az   Az   Az   Azگ   Azې   Azq   AzR   Az3   Az   Az   Az   Az   Az   Azy   AzZ   Az;   Az   Az   Az   Az   Az   Az   Azb   AzC   Az$   Az   Az   Az   Az   Az   Azj   AzK   Az,   Az
   Az   Az   Az   Az   Azr   AzS   Az4   Az   Az   Az   Az   Az   A{ z   A{[   A{<   A{   A{   A{   A{   A{   A{   A{c   A{	D   A{
%   A{   A{   A{   A{
   A{   A{k   A{L   A{-   A{   A{   A{   A{   A{   A{s   A{T   A{5   A{   A{   A{   A{   A{   A{{   A{\   A{=   A{    A{    A{!   A{"   A{#   A{$   A{%d   A{&E   A{'&   A{(   A{(   A{)   A{*   A{+   A{,l   A{-M   A{..   A{/   A{/   A{0   A{1   A{2   A{3t   A{4U   A{56   A{6   A{6   A{7   A{8   A{9   A{:|   A{;]   A{<>   A{=   A{>    A{>   A{?   A{@   A{A   A{Be   A{CF   A{D'   A{E   A{E   A{F   A{G   A{H   A{Im   A{JN   A{K/   A{L   A{L   A{M   A{N   A{O   A{Pu   A{QV   A{R7   A{S   A{S   A{T   A{U   A{V   A{W}   A{X^   A{Y?   A{Z    A{[   A{[   A{\   A{]   A{^   A{_f   A{`G   A{a(   A{b	   A{b   A{c   A{d   A{e   A{fn   A{gO   A{h0   A{i   A{i   A{j   A{k   A{l   A{mv   A{nW   A{o8   A{p   A{p   A{q   A{r   A{s   A{t~   A{u_   A{v@   A{w!   A{x   A{x   A{y   A{z   A{{   A{|g   A{}H   A{~)   A{
   A{   A{   A{   A{   A{o   A{P   A{1   A{   A{   A{   A{   A{   A{w   A{X   A{9   A{   A{   A{   A{   A{   A{   A{`   A{A   A{"   A{   A{   A{   A{   A{   A{h   A{I   A{*   A{   A{   A{   A{   A{   A{p   A{Q   A{2   A{   A{   A{   A{   A{   A{x   A{Y   A{:   A{   A{   A{   A{   A{   A{   A{a   A{B   A{#   A{   A{   A{   A{   A{   A{i   A{J   A{+   A{   A{   A{   A{   A{   A{q   A{R   A{3   A{   A{   A{   A{·   A{Ø   A{y   A{Z   A{;   A{   A{   A{   A{ɿ   A{ʠ   A{ˁ   A{b   A{C   A{$   A{   A{   A{   A{Ѩ   A{҉   A{j   A{K   A{,   A{
   A{   A{   A{ذ   A{ّ   A{r   A{S   A{4   A{   A{   A{   A{߸   A{   A{z   A{[   A{<   A{   A{   A{   A{   A{   A{   A{c   A{D   A{%   A{   A{   A{   A{   A{   A{k   A{L   A{-   A{   A{   A{   A{   A{   A{s   A{T   A{5   A{   A{   A{   A{   A{   A{{   A{\   A| =   A|   A|   A|   A|   A|   A|   A|d   A|E   A|&   A|	   A|	   A|
   A|   A|   A|
l   A|M   A|.   A|   A|   A|   A|   A|   A|t   A|U   A|6   A|   A|   A|   A|   A|   A||   A|]   A|>   A|   A|    A|   A|    A|!   A|"   A|#e   A|$F   A|%'   A|&   A|&   A|'   A|(   A|)   A|*m   A|+N   A|,/   A|-   A|-   A|.   A|/   A|0   A|1u   A|2V   A|37   A|4   A|4   A|5   A|6   A|7   A|8}   A|9^   A|:?   A|;    A|<   A|<   A|=   A|>   A|?   A|@f   A|AG   A|B(   A|C	   A|C   A|D   A|E   A|F   A|Gn   A|HO   A|I0   A|J   A|J   A|K   A|L   A|M   A|Nv   A|OW   A|P8   A|Q   A|Q   A|R   A|S   A|T   A|U~   A|V_   A|W@   A|X!   A|Y   A|Y   A|Z   A|[   A|\   A|]g   A|^H   A|_)   A|`
   A|`   A|a   A|b   A|c   A|do   A|eP   A|f1   A|g   A|g   A|h   A|i   A|j   A|kw   A|lX   A|m9   A|n   A|n   A|o   A|p   A|q   A|r   A|s`   A|tA   A|u"   A|v   A|v   A|w   A|x   A|y   A|zh   A|{I   A||*   A|}   A|}   A|~   A|   A|   A|p   A|Q   A|2   A|   A|   A|   A|   A|   A|x   A|Y   A|:   A|   A|   A|   A|   A|   A|   A|a   A|B   A|#   A|   A|   A|   A|   A|   A|i   A|J   A|+   A|   A|   A|   A|   A|   A|q   A|R   A|3   A|   A|   A|   A|   A|   A|y   A|Z   A|;   A|   A|   A|   A|   A|   A|   A|b   A|C   A|$   A|   A|   A|   A|   A|   A|j   A|K   A|,   A|
   A|   A|   A|   A|   A|r   A|S   A|4   A|   A|   A|   A|   A|   A|z   A|[   A|<   A|   A|   A|   A|   A|ȡ   A|ɂ   A|c   A|D   A|%   A|   A|   A|   A|ϩ   A|Њ   A|k   A|L   A|-   A|   A|   A|   A|ֱ   A|ג   A|s   A|T   A|5   A|   A|   A|   A|ݹ   A|ޚ   A|{   A|\   A|=   A|   A|   A|   A|   A|   A|   A|d   A|E   A|&   A|   A|   A|   A|   A|   A|l   A|M   A|.   A|   A|   A|   A|   A|   A|t   A|U   A|6   A|   A|   A|   A|   A|   A||   A|]   A|>   A|   A}     A}    A}   A}   A}   A}e   A}F   A}'   A}   A}   A}   A}	   A}
   A}m   A}N   A}
/   A}   A}   A}   A}   A}   A}u   A}V   A}7   A}   A}   A}   A}   A}   A}}   A}^   A}?   A}    A}   A}   A}   A}   A}    A}!f   A}"G   A}#(   A}$	   A}$   A}%   A}&   A}'   A}(n   A})O   A}*0   A}+   A}+   A},   A}-   A}.   A}/v   A}0W   A}18   A}2   A}2   A}3   A}4   A}5   A}6~   A}7_   A}8@   A}9!   A}:   A}:   A};   A}<   A}=   A}>g   A}?H   A}@)   A}A
   A}A   A}B   A}C   A}D   A}Eo   A}FP   A}G1   A}H   A}H   A}I   A}J   A}K   A}Lw   A}MX   A}N9   A}O   A}O   A}P   A}Q   A}R   A}S   A}T`   A}UA   A}V"   A}W   A}W   A}X   A}Y   A}Z   A}[h   A}\I   A}]*   A}^   A}^   A}_   A}`   A}a   A}bp   A}cQ   A}d2   A}e   A}e   A}f   A}g   A}h   A}ix   A}jY   A}k:   A}l   A}l   A}m   A}n   A}o   A}p   A}qa   A}rB   A}s#   A}t   A}t   A}u   A}v   A}w   A}xi   A}yJ   A}z+   A}{   A}{   A}|   A}}   A}~   A}q   A}R   A}3   A}   A}   A}   A}   A}   A}y   A}Z   A};   A}   A}   A}   A}   A}   A}   A}b   A}C   A}$   A}   A}   A}   A}   A}   A}j   A}K   A},   A}
   A}   A}   A}   A}   A}r   A}S   A}4   A}   A}   A}   A}   A}   A}z   A}[   A}<   A}   A}   A}   A}   A}   A}   A}c   A}D   A}%   A}   A}   A}   A}   A}   A}k   A}L   A}-   A}   A}   A}   A}   A}   A}s   A}T   A}5   A}   A}   A}   A}   A}   A}{   A}\   A}=   A}   A}   A}   A}   A}Ƣ   A}ǃ   A}d   A}E   A}&   A}   A}   A}   A}ͪ   A}΋   A}l   A}M   A}.   A}   A}   A}   A}Բ   A}Փ   A}t   A}U   A}6   A}   A}   A}   A}ۺ   A}ܛ   A}|   A}]   A}>   A}   A}    A}   A}   A}   A}   A}e   A}F   A}'   A}   A}   A}   A}   A}   A}m   A}N   A}/   A}   A}   A}   A}   A}   A}u   A}V   A}7   A}   A}   A}   A}   A}   A}}   A}^   A}?   A}    A}   A}   A}   A~    A~   A~f   A~G   A~(   A~	   A~   A~   A~   A~   A~	n   A~
O   A~0   A~   A~   A~
   A~   A~   A~v   A~W   A~8   A~   A~   A~   A~   A~   A~~   A~_   A~@   A~!   A~   A~   A~   A~   A~   A~g   A~ H   A~!)   A~"
   A~"   A~#   A~$   A~%   A~&o   A~'P   A~(1   A~)   A~)   A~*   A~+   A~,   A~-w   A~.X   A~/9   A~0   A~0   A~1   A~2   A~3   A~4   A~5`   A~6A   A~7"   A~8   A~8   A~9   A~:   A~;   A~<h   A~=I   A~>*   A~?   A~?   A~@   A~A   A~B   A~Cp   A~DQ   A~E2   A~F   A~F   A~G   A~H   A~I   A~Jx   A~KY   A~L:   A~M   A~M   A~N   A~O   A~P   A~Q   A~Ra   A~SB   A~T#   A~U   A~U   A~V   A~W   A~X   A~Yi   A~ZJ   A~[+   A~\   A~\   A~]   A~^   A~_   A~`q   A~aR   A~b3   A~c   A~c   A~d   A~e   A~f   A~gy   A~hZ   A~i;   A~j   A~j   A~k   A~l   A~m   A~n   A~ob   A~pC   A~q$   A~r   A~r   A~s   A~t   A~u   A~vj   A~wK   A~x,   A~y
   A~y   A~z   A~{   A~|   A~}r   A~~S   A~4   A~   A~   A~   A~   A~   A~z   A~[   A~<   A~   A~   A~   A~   A~   A~   A~c   A~D   A~%   A~   A~   A~   A~   A~   A~k   A~L   A~-   A~   A~   A~   A~   A~   A~s   A~T   A~5   A~   A~   A~   A~   A~   A~{   A~\   A~=   A~   A~   A~   A~   A~   A~   A~d   A~E   A~&   A~   A~   A~   A~   A~   A~l   A~M   A~.   A~   A~   A~   A~   A~   A~t   A~U   A~6   A~   A~   A~   A~   A~   A~|   A~]   A~>   A~   A~    A~   A~   A~ģ   A~ń   A~e   A~F   A~'   A~   A~   A~   A~˫   A~̌   A~m   A~N   A~/   A~   A~   A~   A~ҳ   A~Ӕ   A~u   A~V   A~7   A~   A~   A~   A~ٻ   A~ڜ   A~}   A~^   A~?   A~    A~   A~   A~   A~   A~   A~f   A~G   A~(   A~	   A~   A~   A~   A~   A~n   A~O   A~0   A~   A~   A~   A~   A~   A~v   A~W   A~8   A~   A~   A~   A~   A~   A~~   A~_   A~@   A~!   A~   A~   A~   A~   A~   A g   AH   A)   A
   A   A   A   A   Ao   AP   A	1   A
   A
   A   A   A
   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A    A    A!   A"   A#   A$p   A%Q   A&2   A'   A'   A(   A)   A*   A+x   A,Y   A-:   A.   A.   A/   A0   A1   A2   A3a   A4B   A5#   A6   A6   A7   A8   A9   A:i   A;J   A<+   A=   A=   A>   A?   A@   AAq   ABR   AC3   AD   AD   AE   AF   AG   AHy   AIZ   AJ;   AK   AK   AL   AM   AN   AO   APb   AQC   AR$   AS   AS   AT   AU   AV   AWj   AXK   AY,   AZ
   AZ   A[   A\   A]   A^r   A_S   A`4   Aa   Aa   Ab   Ac   Ad   Aez   Af[   Ag<   Ah   Ah   Ai   Aj   Ak   Al   Amc   AnD   Ao%   Ap   Ap   Aq   Ar   As   Atk   AuL   Av-   Aw   Aw   Ax   Ay   Az   A{s   A|T   A}5   A~   A~   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A¤   AÅ   Af   AG   A(   A	   A   A   Aɬ   Aʍ   An   AO   A0   A   A   A   Aд   Aѕ   Av   AW   A8   A   A   A   A׼   A؝   A~   A_   A@   A!   A   A   A   Aߥ   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   Aـ *   Aـ   Aـ   Aـ   Aـ   Aـ   Aـp   AـQ   Aـ2   Aـ   Aـ   Aـ	   Aـ
   Aـ   Aـx   Aـ
Y   Aـ:   Aـ   Aـ   Aـ   Aـ   Aـ   Aـ   Aـa   AـB   Aـ#   Aـ   Aـ   Aـ   Aـ   Aـ   Aـi   AـJ   Aـ+   Aـ   Aـ   Aـ   Aـ    Aـ!   Aـ"q   Aـ#R   Aـ$3   Aـ%   Aـ%   Aـ&   Aـ'   Aـ(   Aـ)y   Aـ*Z   Aـ+;   Aـ,   Aـ,   Aـ-   Aـ.   Aـ/   Aـ0   Aـ1b   Aـ2C   Aـ3$   Aـ4   Aـ4   Aـ5   Aـ6   Aـ7   Aـ8j   Aـ9K   Aـ:,   Aـ;
   Aـ;   Aـ<   Aـ=   Aـ>   Aـ?r   Aـ@S   AـA4   AـB   AـB   AـC   AـD   AـE   AـFz   AـG[   AـH<   AـI   AـI   AـJ   AـK   AـL   AـM   AـNc   AـOD   AـP%   AـQ   AـQ   AـR   AـS   AـT   AـUk   AـVL   AـW-   AـX   AـX   AـY   AـZ   Aـ[   Aـ\s   Aـ]T   Aـ^5   Aـ_   Aـ_   Aـ`   Aـa   Aـb   Aـc{   Aـd\   Aـe=   Aـf   Aـf   Aـg   Aـh   Aـi   Aـj   Aـkd   AـlE   Aـm&   Aـn   Aـn   Aـo   Aـp   Aـq   Aـrl   AـsM   Aـt.   Aـu   Aـu   Aـv   Aـw   Aـx   Aـyt   AـzU   Aـ{6   Aـ|   Aـ|   Aـ}   Aـ~   Aـ   Aـ|   Aـ]   Aـ>   Aـ   Aـ    Aـ   Aـ   Aـ   Aـ   Aـe   AـF   Aـ'   Aـ   Aـ   Aـ   Aـ   Aـ   Aـm   AـN   Aـ/   Aـ   Aـ   Aـ   Aـ   Aـ   Aـu   AـV   Aـ7   Aـ   Aـ   Aـ   Aـ   Aـ   Aـ}   Aـ^   Aـ?   Aـ    Aـ   Aـ   Aـ   Aـ   Aـ   Aـf   AـG   Aـ(   Aـ	   Aـ   Aـ   Aـ   Aـ   Aـn   AـO   Aـ0   Aـ   Aـ   Aـ   Aـ   Aـ   Aـv   AـW   Aـ8   Aـ   Aـ   Aـ   Aـ   Aـ   Aـ~   Aـ_   Aـ@   Aـ!   Aـ   Aـ   Aـ   Aـ   Aـ   Aـg   AـH   Aـ)   Aـ
   Aـ   Aـ   Aـǭ   AـȎ   Aـo   AـP   Aـ1   Aـ   Aـ   Aـ   Aـε   Aـϖ   Aـw   AـX   Aـ9   Aـ   Aـ   Aـ   Aـս   Aـ֞   Aـ   Aـ`   AـA   Aـ"   Aـ   Aـ   Aـ   Aـݦ   Aـއ   Aـh   AـI   Aـ*   Aـ   Aـ   Aـ   Aـ   Aـ   Aـp   AـQ   Aـ2   Aـ   Aـ   Aـ   Aـ   Aـ   Aـx   AـY   Aـ:   Aـ   Aـ   Aـ   Aـ   Aـ   Aـ   Aـa   AـB   Aـ#   Aـ   Aـ   Aـ   Aـ   Aـ   Aـi   AـJ   Aـ+   Aـ   Aـ   Aف    Aف   Aف   Aفq   AفR   Aف3   Aف   Aف   Aف   Aف   Aف	   Aف
y   AفZ   Aف;   Aف
   Aف
   Aف   Aف   Aف   Aف   Aفb   AفC   Aف$   Aف   Aف   Aف   Aف   Aف   Aفj   AفK   Aف,   Aف
   Aف   Aف   Aف   Aف   Aف r   Aف!S   Aف"4   Aف#   Aف#   Aف$   Aف%   Aف&   Aف'z   Aف([   Aف)<   Aف*   Aف*   Aف+   Aف,   Aف-   Aف.   Aف/c   Aف0D   Aف1%   Aف2   Aف2   Aف3   Aف4   Aف5   Aف6k   Aف7L   Aف8-   Aف9   Aف9   Aف:   Aف;   Aف<   Aف=s   Aف>T   Aف?5   Aف@   Aف@   AفA   AفB   AفC   AفD{   AفE\   AفF=   AفG   AفG   AفH   AفI   AفJ   AفK   AفLd   AفME   AفN&   AفO   AفO   AفP   AفQ   AفR   AفSl   AفTM   AفU.   AفV   AفV   AفW   AفX   AفY   AفZt   Aف[U   Aف\6   Aف]   Aف]   Aف^   Aف_   Aف`   Aفa|   Aفb]   Aفc>   Aفd   Aفe    Aفe   Aفf   Aفg   Aفh   Aفie   AفjF   Aفk'   Aفl   Aفl   Aفm   Aفn   Aفo   Aفpm   AفqN   Aفr/   Aفs   Aفs   Aفt   Aفu   Aفv   Aفwu   AفxV   Aفy7   Aفz   Aفz   Aف{   Aف|   Aف}   Aف~}   Aف^   Aف?   Aف    Aف   Aف   Aف   Aف   Aف   Aفf   AفG   Aف(   Aف	   Aف   Aف   Aف   Aف   Aفn   AفO   Aف0   Aف   Aف   Aف   Aف   Aف   Aفv   AفW   Aف8   Aف   Aف   Aف   Aف   Aف   Aف~   Aف_   Aف@   Aف!   Aف   Aف   Aف   Aف   Aف   Aفg   AفH   Aف)   Aف
   Aف   Aف   Aف   Aف   Aفo   AفP   Aف1   Aف   Aف   Aف   Aف   Aف   Aفw   AفX   Aف9   Aف   Aف   Aف   Aف   Aف   Aف   Aف`   AفA   Aف"   Aف   Aف   Aف   Aف   Aف   Aفh   AفI   Aف*   Aف   Aف   Aف   AفŮ   AفƏ   Aفp   AفQ   Aف2   Aف   Aف   Aف   Aف̶   Aف͗   Aفx   AفY   Aف:   Aف   Aف   Aف   AفӾ   Aفԟ   AفՀ   Aفa   AفB   Aف#   Aف   Aف   Aف   Aفۧ   Aف܈   Aفi   AفJ   Aف+   Aف   Aف   Aف   Aف   Aف   Aفq   AفR   Aف3   Aف   Aف   Aف   Aف   Aف   Aفy   AفZ   Aف;   Aف   Aف   Aف   Aف   Aف   Aف   Aفb   AفC   Aف$   Aف   Aف   Aف   Aف   Aف   Aفj   AفK   Aف,   Aف
   Aف   Aف   Aف   Aق    Aقr   AقS   Aق4   Aق   Aق   Aق   Aق   Aق   Aقz   Aق	[   Aق
<   Aق   Aق   Aق   Aق
   Aق   Aق   Aقc   AقD   Aق%   Aق   Aق   Aق   Aق   Aق   Aقk   AقL   Aق-   Aق   Aق   Aق   Aق   Aق   Aقs   AقT   Aق 5   Aق!   Aق!   Aق"   Aق#   Aق$   Aق%{   Aق&\   Aق'=   Aق(   Aق(   Aق)   Aق*   Aق+   Aق,   Aق-d   Aق.E   Aق/&   Aق0   Aق0   Aق1   Aق2   Aق3   Aق4l   Aق5M   Aق6.   Aق7   Aق7   Aق8   Aق9   Aق:   Aق;t   Aق<U   Aق=6   Aق>   Aق>   Aق?   Aق@   AقA   AقB|   AقC]   AقD>   AقE   AقF    AقF   AقG   AقH   AقI   AقJe   AقKF   AقL'   AقM   AقM   AقN   AقO   AقP   AقQm   AقRN   AقS/   AقT   AقT   AقU   AقV   AقW   AقXu   AقYV   AقZ7   Aق[   Aق[   Aق\   Aق]   Aق^   Aق_}   Aق`^   Aقa?   Aقb    Aقc   Aقc   Aقd   Aقe   Aقf   Aقgf   AقhG   Aقi(   Aقj	   Aقj   Aقk   Aقl   Aقm   Aقnn   AقoO   Aقp0   Aقq   Aقq   Aقr   Aقs   Aقt   Aقuv   AقvW   Aقw8   Aقx   Aقx   Aقy   Aقz   Aق{   Aق|~   Aق}_   Aق~@   Aق!   Aق   Aق   Aق   Aق   Aق   Aقg   AقH   Aق)   Aق
   Aق   Aق   Aق   Aق   Aقo   AقP   Aق1   Aق   Aق   Aق   Aق   Aق   Aقw   AقX   Aق9   Aق   Aق   Aق   Aق   Aق   Aق   Aق`   AقA   Aق"   Aق   Aق   Aق   Aق   Aق   Aقh   AقI   Aق*   Aق   Aق   Aق   Aق   Aق   Aقp   AقQ   Aق2   Aق   Aق   Aق   Aق   Aق   Aقx   AقY   Aق:   Aق   Aق   Aق   Aق   Aق   Aق   Aقa   AقB   Aق#   Aق   Aق   Aق   Aق   Aق   Aقi   AقJ   Aق+   Aق   Aق   Aق   Aقï   AقĐ   Aقq   AقR   Aق3   Aق   Aق   Aق   Aقʷ   Aق˘   Aقy   AقZ   Aق;   Aق   Aق   Aق   Aقѿ   AقҠ   AقӁ   Aقb   AقC   Aق$   Aق   Aق   Aق   Aق٨   Aقډ   Aقj   AقK   Aق,   Aق
   Aق   Aق   Aق   Aق   Aقr   AقS   Aق4   Aق   Aق   Aق   Aق   Aق   Aقz   Aق[   Aق<   Aق   Aق   Aق   Aق   Aق   Aق   Aقc   AقD   Aق%   Aق   Aق   Aق   Aق   Aق   Aقk   AقL   Aق-   Aق   Aق   Aق   Aق   Aق   Aقs   Aك T   Aك5   Aك   Aك   Aك   Aك   Aك   Aك{   Aك\   Aك=   Aك	   Aك	   Aك
   Aك   Aك   Aك
   Aكd   AكE   Aك&   Aك   Aك   Aك   Aك   Aك   Aكl   AكM   Aك.   Aك   Aك   Aك   Aك   Aك   Aكt   AكU   Aك6   Aك   Aك   Aك    Aك!   Aك"   Aك#|   Aك$]   Aك%>   Aك&   Aك'    Aك'   Aك(   Aك)   Aك*   Aك+e   Aك,F   Aك-'   Aك.   Aك.   Aك/   Aك0   Aك1   Aك2m   Aك3N   Aك4/   Aك5   Aك5   Aك6   Aك7   Aك8   Aك9u   Aك:V   Aك;7   Aك<   Aك<   Aك=   Aك>   Aك?   Aك@}   AكA^   AكB?   AكC    AكD   AكD   AكE   AكF   AكG   AكHf   AكIG   AكJ(   AكK	   AكK   AكL   AكM   AكN   AكOn   AكPO   AكQ0   AكR   AكR   AكS   AكT   AكU   AكVv   AكWW   AكX8   AكY   AكY   AكZ   Aك[   Aك\   Aك]~   Aك^_   Aك_@   Aك`!   Aكa   Aكa   Aكb   Aكc   Aكd   Aكeg   AكfH   Aكg)   Aكh
   Aكh   Aكi   Aكj   Aكk   Aكlo   AكmP   Aكn1   Aكo   Aكo   Aكp   Aكq   Aكr   Aكsw   AكtX   Aكu9   Aكv   Aكv   Aكw   Aكx   Aكy   Aكz   Aك{`   Aك|A   Aك}"   Aك~   Aك~   Aك   Aك   Aك   Aكh   AكI   Aك*   Aك   Aك   Aك   Aك   Aك   Aكp   AكQ   Aك2   Aك   Aك   Aك   Aك   Aك   Aكx   AكY   Aك:   Aك   Aك   Aك   Aك   Aك   Aك   Aكa   AكB   Aك#   Aك   Aك   Aك   Aك   Aك   Aكi   AكJ   Aك+   Aك   Aك   Aك   Aك   Aك   Aكq   AكR   Aك3   Aك   Aك   Aك   Aك   Aك   Aكy   AكZ   Aك;   Aك   Aك   Aك   Aك   Aك   Aك   Aكb   AكC   Aك$   Aك   Aك   Aك   Aك   Aك   Aكj   AكK   Aك,   Aك
   Aك   Aك   Aك   Aك   Aكr   AكS   Aك4   Aك   Aك   Aك   Aكȸ   Aكə   Aكz   Aك[   Aك<   Aك   Aك   Aك   Aك   AكС   Aكт   Aكc   AكD   Aك%   Aك   Aك   Aك   Aكש   Aك؊   Aكk   AكL   Aك-   Aك   Aك   Aك   Aكޱ   Aكߒ   Aكs   AكT   Aك5   Aك   Aك   Aك   Aك   Aك   Aك{   Aك\   Aك=   Aك   Aك   Aك   Aك   Aك   Aك   Aكd   AكE   Aك&   Aك   Aك   Aك   Aك   Aك   Aكl   AكM   Aك.   Aك   Aك   Aك   Aك   Aك   Aكt   AكU   Aك6   Aل    Aل    Aل   Aل   Aل   Aل|   Aل]   Aل>   Aل   Aل    Aل   Aل	   Aل
   Aل   Aلe   Aل
F   Aل'   Aل   Aل   Aل   Aل   Aل   Aلm   AلN   Aل/   Aل   Aل   Aل   Aل   Aل   Aلu   AلV   Aل7   Aل   Aل   Aل   Aل   Aل    Aل!}   Aل"^   Aل#?   Aل$    Aل%   Aل%   Aل&   Aل'   Aل(   Aل)f   Aل*G   Aل+(   Aل,	   Aل,   Aل-   Aل.   Aل/   Aل0n   Aل1O   Aل20   Aل3   Aل3   Aل4   Aل5   Aل6   Aل7v   Aل8W   Aل98   Aل:   Aل:   Aل;   Aل<   Aل=   Aل>~   Aل?_   Aل@@   AلA!   AلB   AلB   AلC   AلD   AلE   AلFg   AلGH   AلH)   AلI
   AلI   AلJ   AلK   AلL   AلMo   AلNP   AلO1   AلP   AلP   AلQ   AلR   AلS   AلTw   AلUX   AلV9   AلW   AلW   AلX   AلY   AلZ   Aل[   Aل\`   Aل]A   Aل^"   Aل_   Aل_   Aل`   Aلa   AٴJ   AٴK   AٴL   AٴMl   AٴNM   AٴO.   AٴP   AٴP   AٴQ   AٴR   AٴS   AٴTt   AٴUU   AٴV6   AٴW   AٴW   AٴX   AٴY   AٴZ   Aٴ[|   Aٴ\]   Aٴ]>   Aٴ^   Aٴ_    Aٴ_   Aٴ`   Aٴa   Aٴb   Aٴce   AٴdF   Aٴe'   Aٴf   Aٴf   Aٴg   Aٴh   Aٴi   Aٴjm   AٴkN   Aٴl/   Aٴm   Aٴm   Aٴn   Aٴo   Aٴp   Aٴqu   AٴrV   Aٴs7   Aٴt   Aٴt   Aٴu   Aٴv   Aٴw   Aٴx}   Aٴy^   Aٴz?   Aٴ{    Aٴ|   Aٴ|   Aٴ}   Aٴ~   Aٴ   Aٴf   AٴG   Aٴ(   Aٴ	   Aٴ   Aٴ   Aٴ   Aٴ   Aٴn   AٴO   Aٴ0   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴv   AٴW   Aٴ8   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ~   Aٴ_   Aٴ@   Aٴ!   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴg   AٴH   Aٴ)   Aٴ
   Aٴ   Aٴ   Aٴ   Aٴ   Aٴo   AٴP   Aٴ1   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴw   AٴX   Aٴ9   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ`   AٴA   Aٴ"   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴh   AٴI   Aٴ*   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴp   AٴQ   Aٴ2   Aٴ   Aٴ   Aٴ   Aٴƶ   AٴǗ   Aٴx   AٴY   Aٴ:   Aٴ   Aٴ   Aٴ   Aٴ;   AٴΟ   Aٴπ   Aٴa   AٴB   Aٴ#   Aٴ   Aٴ   Aٴ   Aٴէ   Aٴֈ   Aٴi   AٴJ   Aٴ+   Aٴ   Aٴ   Aٴ   Aٴܯ   Aٴݐ   Aٴq   AٴR   Aٴ3   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴy   AٴZ   Aٴ;   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴb   AٴC   Aٴ$   Aٴ   Aٴ   Aٴ   Aٴ   Aٴ   Aٴj   AٴK   Aٴ,   Aٴ
   Aٴ   Aٴ   Aٴ   Aٴ   Aٴr   AٴS   Aٴ4   Aٴ   Aٴ   Aٴ   Aٵ    Aٵ   Aٵz   Aٵ[   Aٵ<   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ	   Aٵ
c   AٵD   Aٵ%   Aٵ
   Aٵ
   Aٵ   Aٵ   Aٵ   Aٵk   AٵL   Aٵ-   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵs   AٵT   Aٵ5   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ{   Aٵ \   Aٵ!=   Aٵ"   Aٵ"   Aٵ#   Aٵ$   Aٵ%   Aٵ&   Aٵ'd   Aٵ(E   Aٵ)&   Aٵ*   Aٵ*   Aٵ+   Aٵ,   Aٵ-   Aٵ.l   Aٵ/M   Aٵ0.   Aٵ1   Aٵ1   Aٵ2   Aٵ3   Aٵ4   Aٵ5t   Aٵ6U   Aٵ76   Aٵ8   Aٵ8   Aٵ9   Aٵ:   Aٵ;   Aٵ<|   Aٵ=]   Aٵ>>   Aٵ?   Aٵ@    Aٵ@   AٵA   AٵB   AٵC   AٵDe   AٵEF   AٵF'   AٵG   AٵG   AٵH   AٵI   AٵJ   AٵKm   AٵLN   AٵM/   AٵN   AٵN   AٵO   AٵP   AٵQ   AٵRu   AٵSV   AٵT7   AٵU   AٵU   AٵV   AٵW   AٵX   AٵY}   AٵZ^   Aٵ[?   Aٵ\    Aٵ]   Aٵ]   Aٵ^   Aٵ_   Aٵ`   Aٵaf   AٵbG   Aٵc(   Aٵd	   Aٵd   Aٵe   Aٵf   Aٵg   Aٵhn   AٵiO   Aٵj0   Aٵk   Aٵk   Aٵl   Aٵm   Aٵn   Aٵov   AٵpW   Aٵq8   Aٵr   Aٵr   Aٵs   Aٵt   Aٵu   Aٵv~   Aٵw_   Aٵx@   Aٵy!   Aٵz   Aٵz   Aٵ{   Aٵ|   Aٵ}   Aٵ~g   AٵH   Aٵ)   Aٵ
   Aٵ   Aٵ   Aٵ   Aٵ   Aٵo   AٵP   Aٵ1   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵw   AٵX   Aٵ9   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ`   AٵA   Aٵ"   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵh   AٵI   Aٵ*   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵp   AٵQ   Aٵ2   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵx   AٵY   Aٵ:   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵa   AٵB   Aٵ#   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵi   AٵJ   Aٵ+   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵq   AٵR   Aٵ3   Aٵ   Aٵ   Aٵ   Aٵķ   AٵŘ   Aٵy   AٵZ   Aٵ;   Aٵ   Aٵ   Aٵ   Aٵ˿   Aٵ̠   Aٵ́   Aٵb   AٵC   Aٵ$   Aٵ   Aٵ   Aٵ   AٵӨ   Aٵԉ   Aٵj   AٵK   Aٵ,   Aٵ
   Aٵ   Aٵ   Aٵڰ   Aٵۑ   Aٵr   AٵS   Aٵ4   Aٵ   Aٵz   Aٵ[   Aٵ<   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵc   AٵD   Aٵ%   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵk   AٵL   Aٵ-   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٵs   AٵT   Aٵ5   Aٵ   Aٵ   Aٵ   Aٵ   Aٵ   Aٶ {   Aٶ\   Aٶ=   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶd   Aٶ	E   Aٶ
&   Aٶ   Aٶ   Aٶ   Aٶ
   Aٶ   Aٶl   AٶM   Aٶ.   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶt   AٶU   Aٶ6   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ|   Aٶ]   Aٶ>   Aٶ    Aٶ!    Aٶ!   Aٶ"   Aٶ#   Aٶ$   Aٶ%e   Aٶ&F   Aٶ''   Aٶ(   Aٶ(   Aٶ)   Aٶ*   Aٶ+   Aٶ,m   Aٶ-N   Aٶ./   Aٶ/   Aٶ/   Aٶ0   Aٶ1   Aٶ2   Aٶ3u   Aٶ4V   Aٶ57   Aٶ6   Aٶ6   Aٶ7   Aٶ8   Aٶ9   Aٶ:}   Aٶ;^   Aٶ<?   Aٶ=    Aٶ>   Aٶ>   Aٶ?   Aٶ@   AٶA   AٶBf   AٶCG   AٶD(   AٶE	   AٶE   AٶF   AٶG   AٶH   AٶIn   AٶJO   AٶK0   AٶL   AٶL   AٶM   AٶN   AٶO   AٶPv   AٶQW   AٶR8   AٶS   AٶS   AٶT   AٶU   AٶV   AٶW~   AٶX_   AٶY@   AٶZ!   Aٶ[   Aٶ[   Aٶ\   Aٶ]   Aٶ^   Aٶ_g   Aٶ`H   Aٶa)   Aٶb
   Aٶb   Aٶc   Aٶd   Aٶe   Aٶfo   AٶgP   Aٶh1   Aٶi   Aٶi   Aٶj   Aٶk   Aٶl   Aٶmw   AٶnX   Aٶo9   Aٶp   Aٶp   Aٶq   Aٶr   Aٶs   Aٶt   Aٶu`   AٶvA   Aٶw"   Aٶx   Aٶx   Aٶy   Aٶz   Aٶ{   Aٶ|h   Aٶ}I   Aٶ~*   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶp   AٶQ   Aٶ2   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶx   AٶY   Aٶ:   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶa   AٶB   Aٶ#   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶi   AٶJ   Aٶ+   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶq   AٶR   Aٶ3   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶy   AٶZ   Aٶ;   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶb   AٶC   Aٶ$   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶj   AٶK   Aٶ,   Aٶ
   Aٶ   Aٶ   Aٶ   Aٶ   Aٶr   AٶS   Aٶ4   Aٶ   Aٶ   Aٶ   Aٶ¸   AٶÙ   Aٶz   Aٶ[   Aٶ<   Aٶ   Aٶ   Aٶ   Aٶ   Aٶʡ   Aٶ˂   Aٶc   AٶD   Aٶ%   Aٶ   Aٶ   Aٶ   Aٶѩ   AٶҊ   Aٶk   AٶL   Aٶ-   Aٶ   Aٶ   Aٶ   Aٶر   Aٶْ   Aٶs   AٶT   Aٶ5   Aٶ   Aٶ   Aٶ   Aٶ߹   Aٶ   Aٶ{   Aٶ\   Aٶ=   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶd   AٶE   Aٶ&   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶl   AٶM   Aٶ.   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶt   AٶU   Aٶ6   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ   Aٶ|   Aٶ]   Aٷ >   Aٷ   Aٷ    Aٷ   Aٷ   Aٷ   Aٷ   Aٷe   AٷF   Aٷ'   Aٷ	   Aٷ	   Aٷ
   Aٷ   Aٷ   Aٷ
m   AٷN   Aٷ/   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷu   AٷV   Aٷ7   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ}   Aٷ^   Aٷ?   Aٷ    Aٷ   Aٷ   Aٷ    Aٷ!   Aٷ"   Aٷ#f   Aٷ$G   Aٷ%(   Aٷ&	   Aٷ&   Aٷ'   Aٷ(   Aٷ)   Aٷ*n   Aٷ+O   Aٷ,0   Aٷ-   Aٷ-   Aٷ.   Aٷ/   Aٷ0   Aٷ1v   Aٷ2W   Aٷ38   Aٷ4   Aٷ4   Aٷ5   Aٷ6   Aٷ7   Aٷ8~   Aٷ9_   Aٷ:@   Aٷ;!   Aٷ<   Aٷ<   Aٷ=   Aٷ>   Aٷ?   Aٷ@g   AٷAH   AٷB)   AٷC
   AٷC   AٷD   AٷE   AٷF   AٷGo   AٷHP   AٷI1   AٷJ   AٷJ   AٷK   AٷL   AٷM   AٷNw   AٷOX   AٷP9   AٷQ   AٷQ   AٷR   AٷS   AٷT   AٷU   AٷV`   AٷWA   AٷX"   AٷY   AٷY   AٷZ   Aٷ[   Aٷ\   Aٷ]h   Aٷ^I   Aٷ_*   Aٷ`   Aٷ`   Aٷa   Aٷb   Aٷc   Aٷdp   AٷeQ   Aٷf2   Aٷg   Aٷg   Aٷh   Aٷi   Aٷj   Aٷkx   AٷlY   Aٷm:   Aٷn   Aٷn   Aٷo   Aٷp   Aٷq   Aٷr   Aٷsa   AٷtB   Aٷu#   Aٷv   Aٷv   Aٷw   Aٷx   Aٷy   Aٷzi   Aٷ{J   Aٷ|+   Aٷ}   Aٷ}   Aٷ~   Aٷ   Aٷ   Aٷq   AٷR   Aٷ3   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷy   AٷZ   Aٷ;   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷb   AٷC   Aٷ$   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷj   AٷK   Aٷ,   Aٷ
   Aٷ   Aٷ   Aٷ   Aٷ   Aٷr   AٷS   Aٷ4   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷz   Aٷ[   Aٷ<   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷc   AٷD   Aٷ%   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷk   AٷL   Aٷ-   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷs   AٷT   Aٷ5   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ{   Aٷ\   Aٷ=   Aٷ   Aٷ   Aٷ   Aٷ   AٷȢ   AٷɃ   Aٷd   AٷE   Aٷ&   Aٷ   Aٷ   Aٷ   AٷϪ   AٷЋ   Aٷl   AٷM   Aٷ.   Aٷ   Aٷ   Aٷ   Aٷֲ   Aٷד   Aٷt   AٷU   Aٷ6   Aٷ   Aٷ   Aٷ   Aٷݺ   Aٷޛ   Aٷ|   Aٷ]   Aٷ>   Aٷ   Aٷ    Aٷ   Aٷ   Aٷ   Aٷ   Aٷe   AٷF   Aٷ'   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷm   AٷN   Aٷ/   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷu   AٷV   Aٷ7   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ   Aٷ}   Aٷ^   Aٷ?   Aٷ    Aٸ    Aٸ    Aٸ   Aٸ   Aٸ   Aٸf   AٸG   Aٸ(   Aٸ	   Aٸ   Aٸ   Aٸ	   Aٸ
   Aٸn   AٸO   Aٸ
0   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸv   AٸW   Aٸ8   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ~   Aٸ_   Aٸ@   Aٸ!   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ    Aٸ!g   Aٸ"H   Aٸ#)   Aٸ$
   Aٸ$   Aٸ%   Aٸ&   Aٸ'   Aٸ(o   Aٸ)P   Aٸ*1   Aٸ+   Aٸ+   Aٸ,   Aٸ-   Aٸ.   Aٸ/w   Aٸ0X   Aٸ19   Aٸ2   Aٸ2   Aٸ3   Aٸ4   Aٸ5   Aٸ6   Aٸ7`   Aٸ8A   Aٸ9"   Aٸ:   Aٸ:   Aٸ;   Aٸ<   Aٸ=   Aٸ>h   Aٸ?I   Aٸ@*   AٸA   AٸA   AٸB   AٸC   AٸD   AٸEp   AٸFQ   AٸG2   AٸH   AٸH   AٸI   AٸJ   AٸK   AٸLx   AٸMY   AٸN:   AٸO   AٸO   AٸP   AٸQ   AٸR   AٸS   AٸTa   AٸUB   AٸV#   AٸW   AٸW   AٸX   AٸY   AٸZ   Aٸ[i   Aٸ\J   Aٸ]+   Aٸ^   Aٸ^   Aٸ_   Aٸ`   Aٸa   Aٸbq   AٸcR   Aٸd3   Aٸe   Aٸe   Aٸf   Aٸg   Aٸh   Aٸiy   AٸjZ   Aٸk;   Aٸl   Aٸl   Aٸm   Aٸn   Aٸo   Aٸp   Aٸqb   AٸrC   Aٸs$   Aٸt   Aٸt   Aٸu   Aٸv   Aٸw   Aٸxj   AٸyK   Aٸz,   Aٸ{
   Aٸ{   Aٸ|   Aٸ}   Aٸ~   Aٸr   AٸS   Aٸ4   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸz   Aٸ[   Aٸ<   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸc   AٸD   Aٸ%   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸk   AٸL   Aٸ-   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸs   AٸT   Aٸ5   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ{   Aٸ\   Aٸ=   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸd   AٸE   Aٸ&   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸl   AٸM   Aٸ.   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸt   AٸU   Aٸ6   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ|   Aٸ]   Aٸ>   Aٸ   Aٸ    Aٸ   Aٸ   Aٸƣ   AٸǄ   Aٸe   AٸF   Aٸ'   Aٸ   Aٸ   Aٸ   Aٸͫ   AٸΌ   Aٸm   AٸN   Aٸ/   Aٸ   Aٸ   Aٸ   AٸԳ   AٸՔ   Aٸu   AٸV   Aٸ7   Aٸ   Aٸ   Aٸ   Aٸۻ   Aٸܜ   Aٸ}   Aٸ^   Aٸ?   Aٸ    Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸf   AٸG   Aٸ(   Aٸ	   Aٸ   Aٸ   Aٸ   Aٸ   Aٸn   AٸO   Aٸ0   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸv   AٸW   Aٸ8   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ   Aٸ~   Aٸ_   Aٸ@   Aٸ!   Aٸ   Aٸ   Aٸ   Aٹ    Aٹ   Aٹg   AٹH   Aٹ)   Aٹ
   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ	o   Aٹ
P   Aٹ1   Aٹ   Aٹ   Aٹ
   Aٹ   Aٹ   Aٹw   AٹX   Aٹ9   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ`   AٹA   Aٹ"   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹh   Aٹ I   Aٹ!*   Aٹ"   Aٹ"   Aٹ#   Aٹ$   Aٹ%   Aٹ&p   Aٹ'Q   Aٹ(2   Aٹ)   Aٹ)   Aٹ*   Aٹ+   Aٹ,   Aٹ-x   Aٹ.Y   Aٹ/:   Aٹ0   Aٹ0   Aٹ1   Aٹ2   Aٹ3   Aٹ4   Aٹ5a   Aٹ6B   Aٹ7#   Aٹ8   Aٹ8   Aٹ9   Aٹ:   Aٹ;   Aٹ<i   Aٹ=J   Aٹ>+   Aٹ?   Aٹ?   Aٹ@   AٹA   AٹB   AٹCq   AٹDR   AٹE3   AٹF   AٹF   AٹG   AٹH   AٹI   AٹJy   AٹKZ   AٹL;   AٹM   AٹM   AٹN   AٹO   AٹP   AٹQ   AٹRb   AٹSC   AٹT$   AٹU   AٹU   AٹV   AٹW   AٹX   AٹYj   AٹZK   Aٹ[,   Aٹ\
   Aٹ\   Aٹ]   Aٹ^   Aٹ_   Aٹ`r   AٹaS   Aٹb4   Aٹc   Aٹc   Aٹd   Aٹe   Aٹf   Aٹgz   Aٹh[   Aٹi<   Aٹj   Aٹj   Aٹk   Aٹl   Aٹm   Aٹn   Aٹoc   AٹpD   Aٹq%   Aٹr   Aٹr   Aٹs   Aٹt   Aٹu   Aٹvk   AٹwL   Aٹx-   Aٹy   Aٹy   Aٹz   Aٹ{   Aٹ|   Aٹ}s   Aٹ~T   Aٹ5   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ{   Aٹ\   Aٹ=   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹd   AٹE   Aٹ&   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹl   AٹM   Aٹ.   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹt   AٹU   Aٹ6   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ|   Aٹ]   Aٹ>   Aٹ   Aٹ    Aٹ   Aٹ   Aٹ   Aٹ   Aٹe   AٹF   Aٹ'   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹm   AٹN   Aٹ/   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹu   AٹV   Aٹ7   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ}   Aٹ^   Aٹ?   Aٹ    Aٹ   Aٹ   Aٹ   AٹĤ   AٹŅ   Aٹf   AٹG   Aٹ(   Aٹ	   Aٹ   Aٹ   Aٹˬ   Aٹ̍   Aٹn   AٹO   Aٹ0   Aٹ   Aٹ   Aٹ   AٹҴ   Aٹӕ   Aٹv   AٹW   Aٹ8   Aٹ   Aٹ   Aٹ   Aٹټ   Aٹڝ   Aٹ~   Aٹ_   Aٹ@   Aٹ!   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹg   AٹH   Aٹ)   Aٹ
   Aٹ   Aٹ   Aٹ   Aٹ   Aٹo   AٹP   Aٹ1   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹw   AٹX   Aٹ9   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ`   AٹA   Aٹ"   Aٹ   Aٹ   Aٹ   Aٹ   Aٹ   Aٺ h   AٺI   Aٺ*   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺp   AٺQ   Aٺ	2   Aٺ
   Aٺ
   Aٺ   Aٺ   Aٺ
   Aٺx   AٺY   Aٺ:   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺa   AٺB   Aٺ#   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺi   AٺJ   Aٺ+   Aٺ    Aٺ    Aٺ!   Aٺ"   Aٺ#   Aٺ$q   Aٺ%R   Aٺ&3   Aٺ'   Aٺ'   Aٺ(   Aٺ)   Aٺ*   Aٺ+y   Aٺ,Z   Aٺ-;   Aٺ.   Aٺ.   Aٺ/   Aٺ0   Aٺ1   Aٺ2   Aٺ3b   Aٺ4C   Aٺ5$   Aٺ6   Aٺ6   Aٺ7   Aٺ8   Aٺ9   Aٺ:j   Aٺ;K   Aٺ<,   Aٺ=
   Aٺ=   Aٺ>   Aٺ?   Aٺ@   AٺAr   AٺBS   AٺC4   AٺD   AٺD   AٺE   AٺF   AٺG   AٺHz   AٺI[   AٺJ<   AٺK   AٺK   AٺL   AٺM   AٺN   AٺO   AٺPc   AٺQD   AٺR%   AٺS   AٺS   AٺT   AٺU   AٺV   AٺWk   AٺXL   AٺY-   AٺZ   AٺZ   Aٺ[   Aٺ\   Aٺ]   Aٺ^s   Aٺ_T   Aٺ`5   Aٺa   Aٺa   Aٺb   Aٺc   Aٺd   Aٺe{   Aٺf\   Aٺg=   Aٺh   Aٺh   Aٺi   Aٺj   Aٺk   Aٺl   Aٺmd   AٺnE   Aٺo&   Aٺp   Aٺp   Aٺq   Aٺr   Aٺs   Aٺtl   AٺuM   Aٺv.   Aٺw   Aٺw   Aٺx   Aٺy   Aٺz   Aٺ{t   Aٺ|U   Aٺ}6   Aٺ~   Aٺ~   Aٺ   Aٺ   Aٺ   Aٺ|   Aٺ]   Aٺ>   Aٺ   Aٺ    Aٺ   Aٺ   Aٺ   Aٺ   Aٺe   AٺF   Aٺ'   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺm   AٺN   Aٺ/   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺu   AٺV   Aٺ7   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ}   Aٺ^   Aٺ?   Aٺ    Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺf   AٺG   Aٺ(   Aٺ	   Aٺ   Aٺ   Aٺ   Aٺ   Aٺn   AٺO   Aٺ0   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺv   AٺW   Aٺ8   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ~   Aٺ_   Aٺ@   Aٺ!   Aٺ   Aٺ   Aٺ   Aٺ¥   AٺÆ   Aٺg   AٺH   Aٺ)   Aٺ
   Aٺ   Aٺ   Aٺɭ   Aٺʎ   Aٺo   AٺP   Aٺ1   Aٺ   Aٺ   Aٺ   Aٺе   Aٺі   Aٺw   AٺX   Aٺ9   Aٺ   Aٺ   Aٺ   Aٺ׽   Aٺ؞   Aٺ   Aٺ`   AٺA   Aٺ"   Aٺ   Aٺ   Aٺ   Aٺߦ   Aٺ   Aٺh   AٺI   Aٺ*   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺp   AٺQ   Aٺ2   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺx   AٺY   Aٺ:   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺa   AٺB   Aٺ#   Aٺ   Aٺ   Aٺ   Aٺ   Aٺ   Aٺi   AٺJ   Aٻ +   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻq   AٻR   Aٻ3   Aٻ   Aٻ   Aٻ	   Aٻ
   Aٻ   Aٻy   Aٻ
Z   Aٻ;   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻb   AٻC   Aٻ$   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻj   AٻK   Aٻ,   Aٻ
   Aٻ   Aٻ   Aٻ    Aٻ!   Aٻ"r   Aٻ#S   Aٻ$4   Aٻ%   Aٻ%   Aٻ&   Aٻ'   Aٻ(   Aٻ)z   Aٻ*[   Aٻ+<   Aٻ,   Aٻ,   Aٻ-   Aٻ.   Aٻ/   Aٻ0   Aٻ1c   Aٻ2D   Aٻ3%   Aٻ4   Aٻ4   Aٻ5   Aٻ6   Aٻ7   Aٻ8k   Aٻ9L   Aٻ:-   Aٻ;   Aٻ;   Aٻ<   Aٻ=   Aٻ>   Aٻ?s   Aٻ@T   AٻA5   AٻB   AٻB   AٻC   AٻD   AٻE   AٻF{   AٻG\   AٻH=   AٻI   AٻI   AٻJ   AٻK   AٻL   AٻM   AٻNd   AٻOE   AٻP&   AٻQ   AٻQ   AٻR   AٻS   AٻT   AٻUl   AٻVM   AٻW.   AٻX   AٻX   AٻY   AٻZ   Aٻ[   Aٻ\t   Aٻ]U   Aٻ^6   Aٻ_   Aٻ_   Aٻ`   Aٻa   Aٻb   Aٻc|   Aٻd]   Aٻe>   Aٻf   Aٻg    Aٻg   Aٻh   Aٻi   Aٻj   Aٻke   AٻlF   Aٻm'   Aٻn   Aٻn   Aٻo   Aٻp   Aٻq   Aٻrm   AٻsN   Aٻt/   Aٻu   Aٻu   Aٻv   Aٻw   Aٻx   Aٻyu   AٻzV   Aٻ{7   Aٻ|   Aٻ|   Aٻ}   Aٻ~   Aٻ   Aٻ}   Aٻ^   Aٻ?   Aٻ    Aٻ   Aٻ   Aٻ   Aٻ   Aٻ	   Aٻ   Aٻ   Aٻ   Aٻ   Aٻn   AٻO   Aٻ0   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻv   AٻW   Aٻ8   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ~   Aٻ_   Aٻ@   Aٻ!   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻg   AٻH   Aٻ)   Aٻ
   Aٻ   Aٻ   Aٻ   Aٻ   Aٻo   AٻP   Aٻ1   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻw   AٻX   Aٻ9   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ`   AٻA   Aٻ"   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻh   AٻI   Aٻ*   Aٻ   Aٻ   Aٻ   AٻǮ   Aٻȏ   Aٻp   AٻQ   Aٻ2   Aٻ   Aٻ   Aٻ   Aٻζ   Aٻϗ   Aٻx   AٻY   Aٻ:   Aٻ   Aٻ   Aٻ   Aٻվ   Aٻ֟   Aٻ׀   Aٻa   AٻB   Aٻ#   Aٻ   Aٻ   Aٻ   Aٻݧ   Aٻވ   Aٻi   AٻJ   Aٻ+   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻq   AٻR   Aٻ3   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻy   AٻZ   Aٻ;   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻb   AٻC   Aٻ$   Aٻ   Aٻ   Aٻ   Aٻ   Aٻ   Aٻj   AٻK   Aٻ,   Aٻ
   Aٻ   Aټ    Aټ   Aټ   Aټr   AټS   Aټ4   Aټ   Aټ   Aټ   Aټ   Aټ	   Aټ
z   Aټ[   Aټ<   Aټ
   Aټ
   Aټ   Aټ   Aټ   Aټ   Aټc   AټD   Aټ%   Aټ   Aټ   Aټ   Aټ   Aټ   Aټk   AټL   Aټ-   Aټ   Aټ   Aټ   Aټ   Aټ   Aټ s   Aټ!T   Aټ"5   Aټ#   Aټ#   Aټ$   Aټ%   Aټ&   Aټ'{   Aټ(\   Aټ)=   Aټ*   Aټ*   Aټ+   Aټ,   Aټ-   Aټ.   Aټ/d   Aټ0E   Aټ1&   Aټ2   Aټ2   Aټ3   Aټ4   Aټ5   Aټ6l   Aټ7M   Aټ8.   Aټ9   Aټ9   Aټ:   Aټ;   Aټ<   Aټ=t   Aټ>U   Aټ?6   Aټ@   Aټ@   AټA   AټB   AټC   AټD|   AټE]   AټF>   AټG   AټH    AټH   AټI   AټJ   AټK   AټLe   AټMF   AټN'   AټO   AټO   AټP   AټQ   AټR   AټSm   AټTN   AټU/   AټV   AټV   AټW   AټX   AټY   AټZu   Aټ[V   Aټ\7   Aټ]   Aټ]   Aټ^   Aټ_   Aټ`   Aټa}   Aټb^   Aټc?   Aټd    Aټe   Aټe   Aټf   Aټg   Aټh   Aټif   AټjG   Aټk(   Aټl	   Aټl   Aټm   Aټn   Aټo   Aټpn   AټqO   Aټr0   Aټs   Aټs   Aټt   Aټu   Aټv   Aټwv   AټxW   Aټy8   Aټz   Aټz   Aټ{   Aټ|   Aټ}   Aټ~~   Aټ_   Aټ@   Aټ!   Aټ   Aټ   Aټ   Aټ   Aټ   Aټg   AټH   Aټ)   Aټ
   Aټ   Aټ   Aټ   Aټ   Aټo   AټP   Aټ1   Aټ   Aټ   Aټ   Aټ   Aټ   Aټw   AټX   Aټ9   Aټ   Aټ   Aټ   Aټ   Aټ   Aټ   Aټ`   AټA   Aټ"   Aټ   Aټ   Aټ   Aټ   Aټ   Aټh   AټI   Aټ*   Aټ   Aټ   Aټ   Aټ   Aټ   Aټp   AټQ   Aټ2   Aټ   Aټ   Aټ   Aټ   Aټ   Aټx   AټY   Aټ:   Aټ   Aټ   Aټ   Aټ   Aټ   Aټ   Aټa   AټB   Aټ#   Aټ   Aټ   Aټ   Aټ   Aټ   Aټi   AټJ   Aټ+   Aټ   Aټ   Aټ   Aټů   AټƐ   Aټq   AټR   Aټ3   Aټ   Aټ   Aټ   Aټ̷   Aټ͘   Aټy   AټZ   Aټ;   Aټ   Aټ   Aټ   Aټӿ   AټԠ   AټՁ   Aټb   AټC   Aټ$   Aټ   Aټ   Aټ   Aټۨ   Aټ܉   Aټj   AټK   Aټ,   Aټ
   Aټ   Aټ   Aټ   Aټ   Aټr   AټS   Aټ4   Aټ   Aټ   Aټ   Aټ   Aټ   Aټz   Aټ[   Aټ<   Aټ   Aټ   Aټ   Aټ   Aټ   Aټ   Aټc   AټD   Aټ%   Aټ   Aټ   Aټ   Aټ   Aټ   Aټk   AټL   Aټ-   Aټ   Aټ   Aټ   Aټ   Aٽ    Aٽs   AٽT   Aٽ5   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ{   Aٽ	\   Aٽ
=   Aٽ   Aٽ   Aٽ   Aٽ
   Aٽ   Aٽ   Aٽd   AٽE   Aٽ&   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽl   AٽM   Aٽ.   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽt   AٽU   Aٽ 6   Aٽ!   Aٽ!   Aٽ"   Aٽ#   Aٽ$   Aٽ%|   Aٽ&]   Aٽ'>   Aٽ(   Aٽ)    Aٽ)   Aٽ*   Aٽ+   Aٽ,   Aٽ-e   Aٽ.F   Aٽ/'   Aٽ0   Aٽ0   Aٽ1   Aٽ2   Aٽ3   Aٽ4m   Aٽ5N   Aٽ6/   Aٽ7   Aٽ7   Aٽ8   Aٽ9   Aٽ:   Aٽ;u   Aٽ<V   Aٽ=7   Aٽ>   Aٽ>   Aٽ?   Aٽ@   AٽA   AٽB}   AٽC^   AٽD?   AٽE    AٽF   AٽF   AٽG   AٽH   AٽI   AٽJf   AٽKG   AٽL(   AٽM	   AٽM   AٽN   AٽO   AٽP   AٽQn   AٽRO   AٽS0   AٽT   AٽT   AٽU   AٽV   AٽW   AٽXv   AٽYW   AٽZ8   Aٽ[   Aٽ[   Aٽ\   Aٽ]   Aٽ^   Aٽ_~   Aٽ`_   Aٽa@   Aٽb!   Aٽc   Aٽc   Aٽd   Aٽe   Aٽf   Aٽgg   AٽhH   Aٽi)   Aٽj
   Aٽj   Aٽk   Aٽl   Aٽm   Aٽno   AٽoP   Aٽp1   Aٽq   Aٽq   Aٽr   Aٽs   Aٽt   Aٽuw   AٽvX   Aٽw9   Aٽx   Aٽx   Aٽy   Aٽz   Aٽ{   Aٽ|   Aٽ}`   Aٽ~A   Aٽ"   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽh   AٽI   Aٽ*   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽp   AٽQ   Aٽ2   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽx   AٽY   Aٽ:   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽa   AٽB   Aٽ#   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽi   AٽJ   Aٽ+   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽq   AٽR   Aٽ3   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽy   AٽZ   Aٽ;   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽb   AٽC   Aٽ$   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽj   AٽK   Aٽ,   Aٽ
   Aٽ   Aٽ   Aٽð   Aٽđ   Aٽr   AٽS   Aٽ4   Aٽ   Aٽ   Aٽ   Aٽʸ   Aٽ˙   Aٽz   Aٽ[   Aٽ<   Aٽ   Aٽ   Aٽ   Aٽ   Aٽҡ   Aٽӂ   Aٽc   AٽD   Aٽ%   Aٽ   Aٽ   Aٽ   Aٽ٩   Aٽڊ   Aٽk   AٽL   Aٽ-   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽs   AٽT   Aٽ5   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ{   Aٽ\   Aٽ=   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽd   AٽE   Aٽ&   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽl   AٽM   Aٽ.   Aٽ   Aٽ   Aٽ   Aٽ   Aٽ   Aٽt   Aپ U   Aپ6   Aپ   Aپ   Aپ   Aپ   Aپ   Aپ|   Aپ]   Aپ>   Aپ	   Aپ
    Aپ
   Aپ   Aپ   Aپ
   Aپe   AپF   Aپ'   Aپ   Aپ   Aپ   Aپ   Aپ   Aپm   AپN   Aپ/   Aپ   Aپ   Aپ   Aپ   Aپ   Aپu   AپV   Aپ7   Aپ   Aپ   Aپ    Aپ!   Aپ"   Aپ#}   Aپ$^   Aپ%?   Aپ&    Aپ'   Aپ'   Aپ(   Aپ)   Aپ*   Aپ+f   Aپ,G   Aپ-(   Aپ.	   Aپ.   Aپ/   Aپ0   Aپ1   Aپ2n   Aپ3O   Aپ40   Aپ5   Aپ5   Aپ6   Aپ7   Aپ8   Aپ9v   Aپ:W   Aپ;8   Aپ<   Aپ<   Aپ=   Aپ>   Aپ?   Aپ@~   AپA_   AپB@   AپC!   AپD   AپD   AپE   AپF   AپG   AپHg   AپIH   AپJ)   AپK
   AپK   AپL   AپM   AپN   AپOo   AپPP   AپQ1   AپR   AپR   AپS   AپT   AپU   AپVw   AپWX   AپX9   AپY   AپY   AپZ   Aپ[   Aپ\   Aپ]   Aپ^`   Aپ_A   Aپ`"   Aپa   Aپa   Aپb   Aپc   Aپd   Aپeh   AپfI   Aپg*   Aپh   Aپh   Aپi   Aپj   Aپk   Aپlp   AپmQ   Aپn2   Aپo   Aپo   Aپp   Aپq   Aپr   Aپsx   AپtY   Aپu:   Aپv   Aپv   Aپw   Aپx   Aپy   Aپz   Aپ{a   Aپ|B   Aپ}#   Aپ~   Aپ~   Aپ   Aپ   Aپ   Aپi   AپJ   Aپ+   Aپ   Aپ   Aپ   Aپ   Aپ   Aپq   AپR   Aپ3   Aپ   Aپ   Aپ   Aپ   Aپ   Aپy   AپZ   Aپ;   Aپ   Aپ   Aپ   Aپ   Aپ   Aپ   Aپb   AپC   Aپ$   Aپ   Aپ   Aپ   Aپ   Aپ   Aپj   AپK   Aپ,   Aپ
   Aپ   Aپ   Aپ   Aپ   Aپr   AپS   Aپ4   Aپ   Aپ   Aپ   Aپ   Aپ   Aپz   Aپ[   Aپ<   Aپ   Aپ   Aپ   Aپ   Aپ   Aپ   Aپc   AپD   Aپ%   Aپ   Aپ   Aپ   Aپ   Aپ   Aپk   AپL   Aپ-   Aپ   Aپ   Aپ   Aپ   Aپ   Aپs   AپT   Aپ5   Aپ   Aپ   Aپ   Aپȹ   Aپɚ   Aپ{   Aپ\   Aپ=   Aپ   Aپ   Aپ   Aپ   AپТ   Aپу   Aپd   AپE   Aپ&   Aپ   Aپ   Aپ   Aپת   Aپ؋   Aپl   AپM   Aپ.   Aپ   Aپ   Aپ   Aپ޲   Aپߓ   Aپt   AپU   Aپ6   Aپ   Aپ   Aپ   Aپ   Aپ   Aپ|   Aپ]   Aپ>   Aپ   Aپ    Aپ   Aپ   Aپ   Aپ   Aپe   AپF   Aپ'   Aپ   Aپ   Aپ   Aپ   Aپ   Aپm   AپN   Aپ/   Aپ   Aپ   Aپ   Aپ   Aپ   Aپu   AپV   Aپ7   Aٿ    Aٿ    Aٿ   Aٿ   Aٿ   Aٿ}   Aٿ^   Aٿ?   Aٿ    Aٿ   Aٿ   Aٿ	   Aٿ
   Aٿ   Aٿf   Aٿ
G   Aٿ(   Aٿ	   Aٿ   Aٿ   Aٿ   Aٿ   Aٿn   AٿO   Aٿ0   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿv   AٿW   Aٿ8   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ    Aٿ!~   Aٿ"_   Aٿ#@   Aٿ$!   Aٿ%   Aٿ%   Aٿ&   Aٿ'   Aٿ(   Aٿ)g   Aٿ*H   Aٿ+)   Aٿ,
   Aٿ,   Aٿ-   Aٿ.   Aٿ/   Aٿ0o   Aٿ1P   Aٿ21   Aٿ3   Aٿ3   Aٿ4   Aٿ5   Aٿ6   Aٿ7w   Aٿ8X   Aٿ99   Aٿ:   Aٿ:   Aٿ;   Aٿ<   Aٿ=   Aٿ>   Aٿ?`   Aٿ@A   AٿA"   AٿB   AٿB   AٿC   AٿD   AٿE   AٿFh   AٿGI   AٿH*   AٿI   AٿI   AٿJ   AٿK   AٿL   AٿMp   AٿNQ   AٿO2   AٿP   AٿP   AٿQ   AٿR   AٿS   AٿTx   AٿUY   AٿV:   AٿW   AٿW   AٿX   AٿY   AٿZ   Aٿ[   Aٿ\a   Aٿ]B   Aٿ^#   Aٿ_   Aٿ_   Aٿ`   Aٿa   Aٿb   Aٿci   AٿdJ   Aٿe+   Aٿf   Aٿf   Aٿg   Aٿh   Aٿi   Aٿjq   AٿkR   Aٿl3   Aٿm   Aٿm   Aٿn   Aٿo   Aٿp   Aٿqy   AٿrZ   Aٿs;   Aٿt   Aٿt   Aٿu   Aٿv   Aٿw   Aٿx   Aٿyb   AٿzC   Aٿ{$   Aٿ|   Aٿ|   Aٿ}   Aٿ~   Aٿ   Aٿj   AٿK   Aٿ,   Aٿ
   Aٿ   Aٿ   Aٿ   Aٿ   Aٿr   AٿS   Aٿ4   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿz   Aٿ[   Aٿ<   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿc   AٿD   Aٿ%   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿk   AٿL   Aٿ-   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿs   AٿT   Aٿ5   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ{   Aٿ\   Aٿ=   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿd   AٿE   Aٿ&   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿl   AٿM   Aٿ.   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿt   AٿU   Aٿ6   Aٿ   Aٿ   Aٿ   Aٿƺ   AٿǛ   Aٿ|   Aٿ]   Aٿ>   Aٿ   Aٿ    Aٿ   Aٿ   AٿΣ   Aٿτ   Aٿe   AٿF   Aٿ'   Aٿ   Aٿ   Aٿ   Aٿի   Aٿ֌   Aٿm   AٿN   Aٿ/   Aٿ   Aٿ   Aٿ   Aٿܳ   Aٿݔ   Aٿu   AٿV   Aٿ7   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ}   Aٿ^   Aٿ?   Aٿ    Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿf   AٿG   Aٿ(   Aٿ	   Aٿ   Aٿ   Aٿ   Aٿ   Aٿn   AٿO   Aٿ0   Aٿ   Aٿ   Aٿ   Aٿ   Aٿ   Aٿv   AٿW   Aٿ8   Aٿ   Aٿ   Aٿ   A    A   A~   A_   A@   A!   A   A   A   A   A	   A
g   AH   A)   A
   A
   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A `   A!A   A""   A#   A#   A$   A%   A&   A'h   A(I   A)*   A*   A*   A+   A,   A-   A.p   A/Q   A02   A1   A1   A2   A3   A4   A5x   A6Y   A7:   A8   A8   A9   A:   A;   A<   A=a   A>B   A?#   A@   A@   AA   AB   AC   ADi   AEJ   AF+   AG   AG   AH   AI   AJ   AKq   ALR   AM3   AN   AN   AO   AP   AQ   ARy   ASZ   AT;   AU   AU   AV   AW   AX   AY   AZb   A[C   A\$   A]   A]   A^   A_   A`   Aaj   AbK   Ac,   Ad
   Ad   Ae   Af   Ag   Ahr   AiS   Aj4   Ak   Ak   Al   Am   An   Aoz   Ap[   Aq<   Ar   Ar   As   At   Au   Av   Awc   AxD   Ay%   Az   Az   A{   A|   A}   A~k   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   Au   AV   A7   A   A   A   AĻ   AŜ   A}   A^   A?   A    A   A   A   A̤   Aͅ   Af   AG   A(   A	   A   A   AӬ   Aԍ   An   AO   A0   A   A   A   Aڴ   Aە   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A    A`   AA   A"   A   A   A   A   A   Ah   A	I   A
*   A   A   A   A
   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A #   A!   A!   A"   A#   A$   A%i   A&J   A'+   A(   A(   A)   A*   A+   A,q   A-R   A.3   A/   A/   A0   A1   A2   A3y   A4Z   A5;   A6   A6   A7   A8   A9   A:   A;b   A<C   A=$   A>   A>   A?   A@   AA   ABj   ACK   AD,   AE
   AE   AF   AG   AH   AIr   AJS   AK4   AL   AL   AO   APz   AQ[   AR<   AS   AS   AT   AU   AV   AW   AXc   AYD   AZ%   A[   A[   A\   A]   A^   A_k   A`L   Aa-   Ab   Ab   Ac   Ad   Ae   Afs   AgT   Ah5   Ai   Ai   Aj   Ak   Al   Am{   An\   Ao=   Ap   Ap   Aq   Ar   As   At   Aud   AvE   Aw&   Ax   Ax   Ay   Az   A{   A|l   A}M   A~.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A¼   AÝ   A~   A_   A@   A!   A   A   A   Aʥ   Aˆ   Ag   AH   A)   A
   A   A   Aѭ   AҎ   Ao   AP   A1   A   A   A   Aص   Aٖ   Aw   AX   A9   A   A   A   A߽   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   A B   A#   A   A   A   A   A   Ai   AJ   A+   A	   A	   A
   A   A   A
q   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A    A!   A"   A#j   A$K   A%,   A&
   A&   A'   A(   A)   A*r   A+S   A,4   A-   A-   A.   A/   A0   A1z   A2[   A3<   A4   A4   A5   A6   A7   A8   A9c   A:D   A;%   A<   A<   A=   A>   A?   A@k   AAL   AB-   AC   AC   AD   AE   AF   AGs   AHT   AI5   AJ   AJ   AK   AL   AM   AN{   AO\   AP=   AQ   AQ   AR   AS   AT   AU   AVd   AWE   AX&   AY   AY   AZ   A[   A\   A]l   A^M   A_.   A`   A`   Aa   Ab   Ac   Adt   AeU   Af6   Ag   Ag   Ah   Ai   Aj   Ak|   Al]   Am>   An   Ao    Ao   Ap   Aq   Ar   Ase   AtF   Au'   Av   Av   Aw   Ax   Ay   Azm   A{N   A|/   A}   A}   A~   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A 8   A¡   A¡   A¢   A£   A¤   A¥~   A¦_   A§@   A¨!   A©   A©   Aª   A«   A¬   A­g   A®H   A¯)   A°
   A°   A±   A²   A³   A´o   AµP   A¶1   A·   A·   A¸   A¹   Aº   A»w   A¼X   A½9   A¾   A¾   A¿   A   A   A   A`   AA   A"   A   A   A   AȦ   Aɇ   Ah   AI   A*   A   A   A   AϮ   AЏ   Ap   AQ   A2   A   A   A   Aֶ   Aח   Ax   AY   A:   A   A   A   Aݾ   Aޟ   A߀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A    A    A   A   A   Aj   AK   A,   A
   A   A   A	   A
   Ar   AS   A
4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A    A!k   A"L   A#-   A$   A$   A%   A&   A'   A(s   A)T   A*5   A+   A+   A,   A-   A.   A/{   A0\   A1=   A2   A2   A3   A4   A5   A6   A7d   A8E   A9&   A:   A:   A;   A<   A=   A>l   A?M   A@.   AA   AA   AB   AC   AD   AEt   AFU   AG6   AH   AH   AI   AJ   AK   AL|   AM]   AN>   AO   AP    AP   AQ   AR   AS   ATe   AUF   AV'   AW   AW   AX   AY   AZ   A[m   A\N   A]/   A^   A^   A_   A`   Aa   Abu   AcV   Ad7   Ae   Ae   Af   Ag   Ah   Ai}   Aj^   Ak?   Al    Am   Am   An   Ao   Ap   Aqf   ArG   As(   At	   At   Au   Av   Aw   Axn   AyO   Az0   A{   A{   A|   A}   A~   Av   AÀW   AÁ8   AÂ   AÂ   AÃ   AÄ   AÅ   AÆ~   AÇ_   AÈ@   AÉ!   AÊ   AÊ   AË   AÌ   AÍ   AÎg   AÏH   AÐ)   AÑ
   AÑ   AÒ   AÓ   AÔ   AÕo   AÖP   A×1   AØ   AØ   AÙ   AÚ   AÛ   AÜw   AÝX   AÞ9   Aß   Aß   Aà   Aá   Aâ   Aã   Aä`   AåA   Aæ"   Aç   Aç   Aè   Aé   Aê   Aëh   AìI   Aí*   Aî   Aî   Aï   Að   Añ   Aòp   AóQ   Aô2   Aõ   Aõ   Aö   A÷   Aø   Aùx   AúY   Aû:   Aü   Aü   Aý   Aþ   Aÿ   A   Aa   AB   A#   A   A   A   AƧ   Aǈ   Ai   AJ   A+   A   A   A   Aͯ   Aΐ   Aq   AR   A3   A   A   A   AԷ   A՘   Ay   AZ   A;   A   A   A   Aۿ   Aܠ   A݁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A    A   Ak   AL   A-   A   A   A   A   A   A	s   A
T   A5   A   A   A
   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   A M   A!.   A"   A"   A#   A$   A%   A&t   A'U   A(6   A)   A)   A*   A+   A,   A-|   A.]   A/>   A0   A1    A1   A2   A3   A4   A5e   A6F   A7'   A8   A8   A9   A:   A;   A<m   A=N   A>/   A?   A?   A@   AA   AB   ACu   ADV   AE7   AF   AF   AG   AH   AI   AJ}   AK^   AL?   AM    AN   AN   AO   AP   AQ   ARf   ASG   AT(   AU	   AU   AV   AW   AX   AYn   AZO   A[0   A\   A\   A]   A^   A_   A`v   AaW   Ab8   Ac   Ac   Ad   Ae   Af   Ag~   Ah_   Ai@   Aj!   Ak   Ak   Al   Am   An   Aog   ApH   Aq)   Ar
   Ar   As   At   Au   Avo   AwP   Ax1   Ay   Ay   Az   A{   A|   A}w   A~X   A9   AĀ   AĀ   Aā   AĂ   Aă   AĄ   Aą`   AĆA   Ać"   AĈ   AĈ   Aĉ   AĊ   Aċ   AČh   AčI   AĎ*   Aď   Aď   AĐ   Ađ   AĒ   Aēp   AĔQ   Aĕ2   AĖ   AĖ   Aė   AĘ   Aę   AĚx   AěY   AĜ:   Aĝ   Aĝ   AĞ   Ağ   AĠ   Aġ   AĢa   AģB   AĤ#   Aĥ   Aĥ   AĦ   Aħ   AĨ   Aĩi   AĪJ   Aī+   AĬ   AĬ   Aĭ   AĮ   Aį   Aİq   AıR   AĲ3   Aĳ   Aĳ   AĴ   Aĵ   AĶ   Aķy   AĸZ   AĹ;   Aĺ   Aĺ   AĻ   Aļ   AĽ   Aľ   AĿb   AC   A$   A   A   A   AĨ   Aŉ   Aj   AK   A,   A
   A   A   A˰   Ȃ   Ar   AS   A4   A   A   A   AҸ   Aә   Az   A[   A<   A   A   A   A   Aڡ   Aۂ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   A l   AM   A.   A   A   A   A   A   At   AU   A	6   A
   A
   A   A   A
   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A    A    A!   A"   A#   A$u   A%V   A&7   A'   A'   A(   A)   A*   A+}   A,^   A-?   A.    A/   A/   A0   A1   A2   A3f   A4G   A5(   A6	   A6   A7   A8   A9   A:n   A;O   A<0   A=   A=   A>   A?   A@   AAv   ABW   AC8   AD   AD   AE   AF   AG   AH~   AI_   AJ@   AK!   AL   AL   AM   AN   AO   APg   AQH   AR)   AS
   AS   AT   AU   AV   AWo   AXP   AY1   AZ   AZ   A[   A\   A]   A^w   A_X   A`9   Aa   Aa   Ab   Ac   Ad   Ae   Af`   AgA   Ah"   Ai   Ai   Aj   Ak   Al   Amh   AnI   Ao*   Ap   Ap   Aq   Ar   As   Atp   AuQ   Av2   Aw   Aw   Ax   Ay   Az   A{x   A|Y   A}:   A~   A~   A   Aŀ   AŁ   Ał   AŃa   AńB   AŅ#   Aņ   Aņ   AŇ   Aň   Aŉ   AŊi   AŋJ   AŌ+   Aō   Aō   AŎ   Aŏ   AŐ   Aőq   AŒR   Aœ3   AŔ   AŔ   Aŕ   AŖ   Aŗ   AŘy   AřZ   AŚ;   Aś   Aś   AŜ   Aŝ   AŞ   Aş   AŠb   AšC   AŢ$   Aţ   Aţ   AŤ   Ať   AŦ   Aŧj   AŨK   Aũ,   AŪ
   AŪ   Aū   AŬ   Aŭ   AŮr   AůS   AŰ4   Aű   Aű   AŲ   Aų   AŴ   Aŵz   AŶ[   Aŷ<   AŸ   AŸ   AŹ   Aź   AŻ   Aż   AŽc   AžD   Aſ%   A   A   A   A©   AÊ   Ak   AL   A-   A   A   A   Aɱ   Aʒ   As   AT   A5   A   A   A   Aй   Aњ   A{   A\   A=   A   A   A   A   Aآ   Aك   Ad   AE   A&   A   A   A   Aߪ   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A /   A   A   A   A   A   Au   AV   A7   A   A   A	   A
   A   A}   A
^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A    A!   A"v   A#W   A$8   A%   A%   A&   A'   A(   A)~   A*_   A+@   A,!   A-   A-   A.   A/   A0   A1g   A2H   A3)   A4
   A4   A5   A6   A7   A8o   A9P   A:1   A;   A;   A<   A=   A>   A?w   A@X   AA9   AB   AB   AC   AD   AE   AF   AG`   AHA   AI"   AJ   AJ   AK   AL   AM   ANh   AOI   AP*   AQ   AQ   AR   AS   AT   AUp   AVQ   AW2   AX   AX   AY   AZ   A[   A\x   A]Y   A^:   A_   A_   A`   Aa   Ab   Ac   Ada   AeB   Af#   Ag   Ag   Ah   Ai   Aj   Aki   AlJ   Am+   An   An   Ao   Ap   Aq   Arq   AsR   At3   Au   Au   Av   Aw   Ax   Ayy   AzZ   A{;   A|   A|   A}   A~   A   Aƀ   AƁb   AƂC   Aƃ$   AƄ   AƄ   Aƅ   AƆ   AƇ   Aƈj   AƉK   AƊ,   AƋ
   AƋ   Aƌ   Aƍ   AƎ   AƏr   AƐS   AƑ4   Aƒ   Aƒ   AƓ   AƔ   Aƕ   AƖz   AƗ[   AƘ<   Aƙ   Aƙ   Aƚ   Aƛ   AƜ   AƝ   Aƞc   AƟD   AƠ%   Aơ   Aơ   AƢ   Aƣ   AƤ   Aƥk   AƦL   AƧ-   Aƨ   Aƨ   AƩ   Aƪ   Aƫ   AƬs   AƭT   AƮ5   AƯ   AƯ   Aư   AƱ   AƲ   AƳ{   Aƴ\   AƵ=   Aƶ   Aƶ   AƷ   AƸ   Aƹ   Aƺ   Aƻd   AƼE   Aƽ&   Aƾ   Aƾ   Aƿ   A   A   Al   AM   A.   A   A   A   Aǲ   Aȓ   At   AU   A6   A   A   A   Aκ   Aϛ   A|   A]   A>   A   A    A   A   A֣   Aׄ   Ae   AF   A'   A   A   A   Aݫ   Aތ   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A    A   A   Av   AW   A8   A   A   A   A   A	   A
~   A_   A@   A
!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   A w   A!X   A"9   A#   A#   A$   A%   A&   A'   A(`   A)A   A*"   A+   A+   A,   A-   A.   A/h   A0I   A1*   A2   A2   A3   A4   A5   A6p   A7Q   A82   A9   A9   A:   A;   A<   A=x   A>Y   A?:   A@   A@   AA   AB   AC   AD   AEa   AFB   AG#   AH   AH   AI   AJ   AK   ALi   AMJ   AN+   AO   AO   AP   AQ   AR   ASq   ATR   AU3   AV   AV   AW   AX   AY   AZy   A[Z   A\;   A]   A]   A^   A_   A`   Aa   Abb   AcC   Ad$   Ae   Ae   Af   Ag   Ah   Aij   AjK   Ak,   Al
   Al   Am   An   Ao   Apr   AqS   Ar4   As   As   At   Au   Av   Awz   Ax[   Ay<   Az   Az   A{   A|   A}   A~   Ac   AǀD   Aǁ%   Aǂ   Aǂ   Aǃ   AǄ   Aǅ   Aǆk   AǇL   Aǈ-   Aǉ   Aǉ   AǊ   Aǋ   Aǌ   AǍs   AǎT   AǏ5   Aǐ   Aǐ   AǑ   Aǒ   AǓ   Aǔ{   AǕ\   Aǖ=   AǗ   AǗ   Aǘ   AǙ   Aǚ   AǛ   Aǜd   AǝE   AǞ&   Aǟ   Aǟ   AǠ   Aǡ   AǢ   Aǣl   AǤM   Aǥ.   AǦ   AǦ   Aǧ   AǨ   Aǩ   AǪt   AǫU   AǬ6   Aǭ   Aǭ   AǮ   Aǯ   Aǰ   AǱ|   Aǲ]   Aǳ>   AǴ   Aǵ    Aǵ   AǶ   AǷ   AǸ   Aǹe   AǺF   Aǻ'   AǼ   AǼ   Aǽ   AǾ   Aǿ   Am   AN   A/   A   A   A   Aų   AƔ   Au   AV   A7   A   A   A   A̻   A͜   A}   A^   A?   A    A   A   A   AԤ   AՅ   Af   AG   A(   A	   A   A   A۬   A܍   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A    Aw   AX   A9   A   A   A   A   A   A   A	`   A
A   A"   A   A   A
   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A :   A!   A!   A"   A#   A$   A%   A&a   A'B   A(#   A)   A)   A*   A+   A,   A-i   A.J   A/+   A0   A0   A1   A2   A3   A4q   A5R   A63   A7   A7   A8   A9   A:   A;y   A<Z   A=;   A>   A>   A?   A@   AA   AB   ACb   ADC   AE$   AF   AF   AG   AH   AI   AJj   AKK   AL,   AM
   AM   AN   AO   AP   AQr   ARS   AS4   AT   AT   AU   AV   AW   AXz   AY[   AZ<   A[   A[   A\   A]   A^   A_   A`c   AaD   Ab%   Ac   Ac   Ad   Ae   Af   Agk   AhL   Ai-   Aj   Aj   Ak   Al   Am   Ans   AoT   Ap5   Aq   Aq   Ar   As   At   Au{   Av\   Aw=   Ax   Ax   Ay   Az   A{   A|   A}d   A~E   A&   AȀ   AȀ   Aȁ   AȂ   Aȃ   AȄl   AȅM   AȆ.   Aȇ   Aȇ   AȈ   Aȉ   AȊ   Aȋt   AȌU   Aȍ6   AȎ   AȎ   Aȏ   AȐ   Aȑ   AȒ|   Aȓ]   AȔ>   Aȕ   AȖ    AȖ   Aȗ   AȘ   Aș   AȚe   AțF   AȜ'   Aȝ   Aȝ   AȞ   Aȟ   AȠ   Aȡm   AȢN   Aȣ/   AȤ   AȤ   Aȥ   AȦ   Aȧ   AȨu   AȩV   AȪ7   Aȫ   Aȫ   AȬ   Aȭ   AȮ   Aȯ}   AȰ^   Aȱ?   AȲ    Aȳ   Aȳ   Aȴ   Aȵ   Aȶ   Aȷf   AȸG   Aȹ(   AȺ	   AȺ   AȻ   Aȼ   AȽ   AȾn   AȿO   A0   A   A   A   Aô   Aĕ   Av   AW   A8   A   A   A   Aʼ   A˝   A~   A_   A@   A!   A   A   A   Aҥ   Aӆ   Ag   AH   A)   A
   A   A   A٭   Aڎ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   A Y   A:   A   A   A   A   A   A   Aa   AB   A	#   A
   A
   A   A   A
   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A    A!   A"   A#   A$b   A%C   A&$   A'   A'   A(   A)   A*   A+j   A,K   A-,   A.
   A.   A/   A0   A1   A2r   A3S   A44   A5   A5   A6   A7   A8   A9z   A:[   A;<   A<   A<   A=   A>   A?   A@   AAc   ABD   AC%   AD   AD   AE   AF   AG   AHk   AIL   AJ-   AK   AK   AL   AM   AN   AOs   APT   AQ5   AR   AR   AS   AT   AU   AV{   AW\   AX=   AY   AY   AZ   A[   A\   A]   A^d   A_E   A`&   Aa   Aa   Ab   Ac   Ad   Ael   AfM   Ag.   Ah   Ah   Ai   Aj   Ak   Alt   AmU   An6   Ao   Ao   Ap   Aq   Ar   As|   At]   Au>   Av   Aw    Aw   Ax   Ay   Az   A{e   A|F   A}'   A~   A~   A   Aɀ   AɁ   Aɂm   AɃN   AɄ/   AɅ   AɅ   AɆ   Aɇ   AɈ   Aɉu   AɊV   Aɋ7   AɌ   AɌ   Aɍ   AɎ   Aɏ   Aɐ}   Aɑ^   Aɒ?   Aɓ    Aɔ   Aɔ   Aɕ   Aɖ   Aɗ   Aɘf   AəG   Aɚ(   Aɛ	   Aɛ   Aɜ   Aɝ   Aɞ   Aɟn   AɠO   Aɡ0   Aɢ   Aɢ   Aɣ   Aɤ   Aɥ   Aɦv   AɧW   Aɨ8   Aɩ   Aɩ   Aɪ   Aɫ   Aɬ   Aɭ~   Aɮ_   Aɯ@   Aɰ!   Aɱ   Aɱ   Aɲ   Aɳ   Aɴ   Aɵg   AɶH   Aɷ)   Aɸ
   Aɸ   Aɹ   Aɺ   Aɻ   Aɼo   AɽP   Aɾ1   Aɿ   Aɿ   A   A   A   Aw   AX   A9   A   A   A   AȽ   Aɞ   A   A`   AA   A"   A   A   A   AЦ   Aч   Ah   AI   A*   A   A   A   A׮   A؏   Ap   AQ   A2   A   A   A   A޶   Aߗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A    A    A   A   A   A   Ab   AC   A$   A   A   A	   A
   A   Aj   A
K   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A    A!   A"c   A#D   A$%   A%   A%   A&   A'   A(   A)k   A*L   A+-   A,   A,   A-   A.   A/   A0s   A1T   A25   A3   A3   A4   A5   A6   A7{   A8\   A9=   A:   A:   A;   A<   A=   A>   A?d   A@E   AA&   AB   AB   AC   AD   AE   AFl   AGM   AH.   AI   AI   AJ   AK   AL   AMt   ANU   AO6   AP   AP   AQ   AR   AS   AT|   AU]   AV>   AW   AX    AX   AY   AZ   A[   A\e   A]F   A_   A`   Aa   Ab   Acm   AdN   Ae/   Af   Af   Ag   Ah   Ai   Aju   AkV   Al7   Am   Am   An   Ao   Ap   Aq}   Ar^   As?   At    Au   Au   Av   Aw   Ax   Ayf   AzG   A{(   Aʋ   Aʌ   Aʍ   Aʎ~   Aʏ_   Aʐ@   Aʑ!   Aʒ   Aʒ   Aʓ   Aʔ   Aʕ   Aʖg   AʗH   Aʘ)   Aʙ
   Aʙ   Aʚ   Aʛ   Aʜ   Aʝo   AʞP   Aʟ1   Aʠ   Aʠ   Aʡ   Aʢ   Aʣ   Aʤw   AʥX   Aʦ9   Aʧ   Aʧ   Aʨ   Aʩ   Aʪ   Aʫ   Aʬ`   AʭA   Aʮ"   Aʯ   Aʯ   Aʰ   Aʱ   Aʲ   Aʳh   AʴI   Aʵ*   Aʶ   Aʶ   Aʷ   Aʸ   Aʹ   Aʺp   AʻQ   Aʼ2   Aʽ   Aʽ   Aʾ   Aʿ   A   Ax   AY   A:   A   A   A   Aƾ   Aǟ   AȀ   Aa   AB   A#   A   A   A   AΧ   Aψ   Ai   AJ   A+   A   A   A   Aկ   A֐   Aq   AR   A3   A   A   A   Aܷ   Aݘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A    A   A   Ac   AD   A%   A   A   A   A   A	   A
k   AL   A-   A
   A
   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   A d   A!E   A"&   A#   A#   A$   A%   A&   A'l   A(M   A).   A*   A*   A+   A,   A-   A.t   A/U   A06   A1   A1   A2   A3   A4   A5|   A6]   A7>   A8   A9    A9   A:   A;   A<   A=e   A>F   A?'   A@   A@   AA   AB   AC   ADm   AEN   AF/   AG   AG   AH   AI   AJ   AKu   ALV   AM7   AN   AN   AO   AP   AQ   AR}   AS^   AT?   AU    AV   AV   AW   AX   AY   AZf   A[G   A\(   A]	   A]   A^   A_   A`   Aan   AbO   Ac0   Ad   Ad   Ae   Af   Ag   Ahv   AiW   Aj8   Ak   Ak   Al   Am   An   Ao~   Ap_   Aq@   Ar!   As   As   At   Au   Av   Awg   AxH   Ay)   Az
   Az   A{   A|   A}   A~o   AP   Aˀ1   Aˁ   Aˁ   A˂   A˃   A˄   A˅w   AˆX   Aˇ9   Aˈ   Aˈ   Aˉ   Aˊ   Aˋ   Aˌ   Aˍ`   AˎA   Aˏ"   Aː   Aː   Aˑ   A˒   A˓   A˔h   A˕I   A˖*   A˗   A˗   A˘   A˙   A˚   A˛p   A˜Q   A˝2   A˞   A˞   A˟   Aˠ   Aˡ   Aˢx   AˣY   Aˤ:   A˥   A˥   A˦   A˧   A˨   A˩   A˪a   A˫B   Aˬ#   A˭   A˭   Aˮ   A˯   A˰   A˱i   A˲J   A˳+   A˴   A˴   A˵   A˶   A˷   A˸q   A˹R   A˺3   A˻   A˻   A˼   A˽   A˾   A˿y   AZ   A;   A   A   A   AĿ   AŠ   AƁ   Ab   AC   A$   A   A   A   Ą   A͉   Aj   AK   A,   A
   A   A   AӰ   Aԑ   Ar   AS   A4   A   A   A   Aڸ   Aۙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A    Ad   AE   A&   A   A   A   A   A   Al   A	M   A
.   A   A   A   A
   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A '   A!   A!   A"   A#   A$   A%m   A&N   A'/   A(   A(   A)   A*   A+   A,u   A-V   A.7   A/   A/   A0   A1   A2   A3}   A4^   A5?   A6    A7   A7   A8   A9   A:   A;f   A<G   A=(   A>	   A>   A?   A@   AA   ABn   ACO   AD0   AE   AE   AzApAGAîA£AŅAffAAAGA33ApAAAÅAîA(AQAzA  AAHA\AffAǙAHAGAApAǅA
A
AǙA
=AGAzAHAA{AAzAAGA33AAAA{A\ARARA  A\AA(A(A33AAQAAAAA=qAA33AzA
=AzA(A{AģAîAGA  A{A{A
AĸRAHAGA{AŮAƣA=qAQAzAA
=ApA
AAA  AQA=qAffAʣAʏ\AAQA=qA(AAGAAzAzApAəAɮA33AGAA{AɮAHAHAAɮA=qAA
=AAəAAGAřAzA\)A\)AAGAQAʸRAQAˮA33AHAHAȏ\A{AƸRAAApA  AǮA=qAA  A\)A£AAGAffAŮAǮA33AzAzAɮAɅA33AAɅAǮAGAəA\)AffAAƣA{AzAǅA  AffApAzA(AQAAQAzAʏ\AAHAA˙AA
ApA(A{A
A=qA̸RA̸RAAʸRAzAHA33A
=A33AA33A
=A33AA33A33AA\)A˙A˅AGA
=AA33AAHAǙAffA(A=qAŮAAffAzAzA
AA
=A  AffAffAȣA
ApAffA  AÅA
=ApAHA{AƣAƏ\AA(A  AɮAAAHAǮA=qAȸRAQAȏ\AģA33Aď\A  AA\)AzAA
=A\)A{A\)AHAA  AʸRAˮApA
A̸RẠApA  AQA{AA
A
AA˅ApAˮA˙AˮAffAAAffAffAzAAȀ\AHApA
A
A
AA͙AAAAAGAGAffApA33AAAHAQȀ\AffȀ\A̸RẠȀ\AffA=qAQAffA{A=qA{A{A{A  A˅A
Aʏ\AȣAA
A{ApAȸRAGAzAffAzAA=qA˙AA=qA̸RAzA̸RAHȀ\A33AͅȀ\AAʣAAʏ\AHAAA33A33A
AAffAA=qApA  A{A  AApAA  AQApAA
=AͮA̸RAHAA̸RAAGA̸RA
=A
=A̸RAHAA
=AAHA33AGA͙ApA33AGA\)AApA\)ApAͅA͙A̸RA  AGAGA
=AAHAAHAǙA=qAʸRA33A=qAQAGAA
A  AəAəAAʣA\)AGA\)ApA˅A˅AɮAA  A33AHA  A˙A=qAɮAHA(A
=AGAA{AQA=qAʣAAAApA
A  A(Ȁ\AHA33AGA͙A
AA͙ApApA\)A\)A\)A
=AAHAAAA
=AHAHA{A\)AʣAˮȀ\AzAAẠẠAA
=A33ApAͮA33AͅAGAAA  AAffAɮApAzA
=AA{AȣAɮAʸRẠA\)AHA33AGA  AApA\)A͙A
AA=qA{A(AAzAθRA{A
=A=qAApAGApA  AθRAHAAGApAAυAGAAzAAθRAAΏ\AAAApAͅAffA\)AAHAA(AAθRAͅApA
=A(AHA
AAθRAϮA33AGAffA{A=qAzȀ\AAzA
=ẠA=qA=qA(A=qAˮAAzA(ApAɮA
ApAGAAQAȏ\A{AɅAəAzA  AɅAHA\)AAȏ\Aʏ\ApAȏ\AƣAQA\)AA{AəAʣAffAHAA{AɮA33AGA\)AȣApApA  AəAAAȣAffAffAA{AʣA33AA\)AˮA
A
A=qȀ\AAApA
=AAA
=AHAʸRA
=AʸRAQAɅAɅAHAA{A=qA=qAHAAʣAAAʏ\A=qA(A
A{AffAɮA  ApAȸRAQAȣAAffAffAAHAȣAzA=qAȏ\ApAffApAHA\)AɮAAAɅApAffAAřA=qA
AQA
AAffAģA\)ApA
AQAřAffA{AƣA
AǙAǅA
AƣAǙA  A(A
AA=qAQAA\)AffAƏ\AffApAƣAGAȏ\AAAɮAɮAAGApAɮAɅAȏ\Aȏ\AQAffA  AAǙAAGAǅAŮAȣAGApAəAAffA\)AA33AȸRAA{AffA=qA(AA
=A
=AAAA  ApA
=AƣAGAA  AŅAA=qAAŅAA33ApAĸRA\)AřAAŅA  A{AGA33A33AA  AŅAApA  AŅAApA
AAzAffAAGAA
AAƣA\)AǮA
AAǮA=qAȏ\AzAȸRAffAzAffAȣAȏ\AȸRAȣAȣAAȸRAQAǙApAǅAƏ\AGAƸRAAGAAA=qA{AƣA\)AĸRAzAĸRAǙAAGAǅA33AA
=AffAApAAAQA{A  AŮApAŅAGA
=AHAģAď\A(AGAAAA{AHAÙAAQAAA(AGApAŅA\)AQAA(A=qA(Aď\AîA33AĸRAAHA\)A
=A33AAĸRAď\AApAQA=qAffAƣAzA(A{A=qAǮAȸRAffAffAAȸRAȏ\Aȏ\AzA{A
AAǮAǅAǅA  A=qAAA=qAAAA  AA
AzAƏ\A=qAŮA  AŮA
AA  AA  A(AŅA
AffAAHAAAGA33AA33AAƣAzA(AƏ\A(A\)AAApApAGA33AA33AAÙARA  A(AzA  ApAffA33AAîAAA=qAŮA
A  AffAŮA
AAzAĸRAHA
AAď\AffA
=A
AƏ\A\)AǙA{AffAȏ\A
AAƸRAzApA(AffAȏ\A33AȸRAA
=AQAffA{AzAȣAȏ\AAǙAAAHA=qAQAAAAGApAǙA=qA=qAffAHAǮAŅAAGAHA  A\ApAQA\)A
=AAQAApAAGAA  AA
A\AHA£AApA
A(AA  Aď\AAģAGAĸRA=qAĸRAŮAƣAA=qA(AAGAQAA(AAA  A=qAAÙAģAŅA  AŅA33AHAA\)AQA=qA=qAffA(AA  A\)AAƸRAAGAAzAǮAA(A
AAQAȣAɅApA
A\)AɮA
AɮAɅApAəA(A(A=qA=qA{A=qAQAQA
AAAzAǙAA33AffAA33A
=AGA
=AɮAɮA{AAɅApA\)A  A
=A=qA33A33AAGAHAAƸRA=qAǮA
=A{AAʏ\Aʏ\AAApA  A{AAʣAA
=AHA(A
AɮAA(AʣAʸRA
=AGAAHAHAHAA˅A{A˙AGA33AHAHAHA33AʸRAAAGA
A
AA{A(A  A
AAAˮAˮAˮAˮA˅AA(A=qAʣAAGAɅAəAHAGAGA̸RA{AApA{AɅA\)ApAQA
AGA(AzA=qAAAAHAȸRAQA
=A\)A33ApA(AƣAʸRAAGAʸRA{A{A=qA=qẠA=qA{A  AffȀ\A
AHAQAǮAA
=A{AAGA
AQAzAA33A33A͙AHA
=A\)A\)AHA˅AApA˙AA
A˅AˮA=qA̸RAzA(Ȁ\AzA̸RAHẠA̸RȀ\A\)AQAA˅ẠA
AˮAAA33AAGA̸RAGAGAGA
=AGA=qAA\)AʣA˅AəAHAŮApA(AAĸRAîA\)A
=AAA
=AA33A  Aȏ\A\)AffAŮAAAAȏ\ApA  AȀ\AA
=AffA  AQApA\AffA(AAA
AƏ\ApA=qAGApAAͅA͙A{A
=AzAAGAGAHȀ\A(A{AzẠAzAAA˙A˅A̸RAɅẠA(AƣAzAA\)AGA33AHAƣAQApAzAA33AHA{AA
=A  AȸRAA=qA=qAAAƣAAA
=AAĸRAGAffA=qAHAȏ\A=qA\)AffA
=AəAzAʏ\A=qAAƸRAAffAAGAffAɮAʣA\)AA{AʣA(ApAǮAǮAǅAQAffAAŮAzA\)AffAAɮA33A33AAAA
ApAˮA(AAˮA{Ȁ\ẠAA33A\)A=qA  A(A=qAΣAΣA(AA{A(AGAA(AzAAGAʏ\AffA(AʣA33A
ApA(A{Aȏ\A{A{AŅA{AǙAAA{AffAAɮA(AQA=qA(A(AzAA
=AAffA=qAffAA\)AA\A=qA(AAǙAzA{AAHAQA\)AGApA33AəAAʏ\AˮAAʏ\AApA33AǅA  AffApAəAɅAGA
=AA\)AA{A=qAAʣA=qAGAzAɮA=qA\)AGA
=Aʏ\A=qA{A  ApA̸RA=qA(AzȀ\AAffAA
=AAHAͅAQA˅ApAGApA\)AAffAʸRAʏ\AGAAʏ\AʸRAzA
=A=qA{AzAʸRAAəA
AffAAAffAGApAˮAA\)A(A
A=qA
=A  AQA{AȣAA
A
A
=AGAAGApA33AAQAʣA  A(A33A{A{A  A=qAAA(Aȏ\AAHAȸRAAA(A(AǮA
AA
AA(AffAAAAHAA  A\)A
A
AǙAǮAApAǮAzAȸRA=qA{A  A  A  AǮAzA̸RAƣAAAɮAA
=AA  AʸRA˙A=qAAA
AAəA
=A
AGAGAAHA  AA
A
A  A(AGA(A=qA  AAAAQAffAȣAǮAȣA\)A33AA
=AHAAAAȸRAȣA33AHAzA  AQAȏ\AȸRAȸRAȣAffAzA=qA
A  A{A{A{A{AǙApA
ApAǙA
AAǅApAGA
=AƸRAƏ\AQA=qA=qAffAQAAffA
A=qAQA
A(AzAA=qA{AŮA{AŅAHAĸRAHAAAřA
AŮAAAGAÅA  A  AA
AQAzAîAAA33A\A33ApA  ApA¸RAAAAAHAGAAzAģAAÅA{A¸RA\)AÙApA
A\)A
A
A  AA
A
AApAÅApA\)AÅAÅAÅAGAHA
=AHAA¸RA(AffAAAAGAGA33AAAARAAAAARAzAApAAAA{AA\)AA\AQA=qAAzA(AA\A(A33AAzAAffARAffAQA(A
AA\)AARApAA\A\A{AA  AA
AA=qApA\)AAQA
=A=qApA
A  AA(ARAAHARA
A  A33AAAQARAAA  AA
=ARAGA{AAAA33A
AAHAA=qApAA
=A
=AA  AHAAA\)A{AA=qA(AffAA\AARA\)AAAAAA\)AAHAzA{AAApAA(A\AAAGA\ARAGAA\)A  A{A{ARAffAQAQAzAQA\A
=AA\)AAA=qAzAAA\)AApA
A(AzApAzAARAffARAA
=AGA
AA33A{AHA(A(AQAQA  AAA\)A
=AAzA=qAQAQA=qAQAffAffAffA{A  A{A
AAAAAAAAApApApApAGA\)AGA
=AGA
=A
=AAA
=A
=AHAHAAARAHAA
=AHAHAHAHAffAA33A33A
=AAHARAHAAApAffAzA33AAA(AffARA33A\)AQAAA¸RA\)AAffAApA
=A
=A33AAAA33AAHA\)AA  A  AA33AAHARAGAARAHARA\A\AQA(AffAzAQAQA=qA  A{A(A(A{A{A
A(A=qA
AAA=qAQA
A  A  AQAApAAAAffA{AAHA33A
=AARAzAHA\A  A=qARAA33AA
AA{AA(AApA=qAAAffA(ARA\)AAAARApAGAA
A
AQAÅAGAGAAA  AQA(ApAÅApAGAHAHAffAAAA£AAA  AAAApAAAA\A{A\A=qA(AffA=qAffA=qA=qA
AA(AzAQAffA\AffAffA  A=qA{A(A  A\)ApAQAzAzAAAQA\AAAAffA\A\A\A\A33A{AAApAAAAAAAAAA\)ApAffA  A(A=qAzA33A
A
=ApAA¸RAA\)AGAîAď\Aď\AHAď\A{ApAGAffAffA\A£A£AAA{A£AAffA(AA\)A{AzAQAffAA{A  A{AzA\)A\AAffAA\)A
=AA\AARAAAAApAzAAAAAAApAAAARARAAA\)ApAAA\AQAAAQA{ApAffA\A33ApA  A(AAA=qAAGAGAAAA33A\)AGA33AA  AA33AAAAQAAzA=qA{ApAHAAAAGA33A
AffAAAA33A33AGApA
AAQApAAAAAGA\)AAAzAAAGA
=AzA(A  A{A(A(AA\ARApAAHAA\ARAAA  A(A\AA{AGA33AHA
=AffA\)AA{AQAffAAAGAzAGAA  AA
AHARA\AAHA\A
=AAffAQAzA\AA
A(A(A¸RA\)A
=AGApA
A
AGA\A(AQAQA  AA
A=qAAffAffAA
=A=qAAffA  A(ARAAA=qA(AAA{A\)AAGAffARApA\)AAffA\AzAA=qAQAzAzAA=qAAAHAAA
AAffAAQA33ARAAAAGARA  A{A\A33AA(A
AQAAA  AA(ARA
A(A(A  A
AzA
A  A=qApA
A=qA
ARAGAAAA{AQAAffA\AGAARA=qA
AAAGAAzA\AA
=A\A\A\)A{AAHA33AGA(A
=AzA\)A  A=qA(ARAAAQA
A{AAA33AA
=AGAA\)AGA\)AApAQA=qA
=AA\A\AffAA  AffARA=qAGA=qA(AA
A(A  AAAAAAffA\AAHA33AA\)AA{AzAGApA¸RA33AîA£AGA{AQAA{A(ApA{A{AffAď\AŮA=qAHAA
A=qAGA  A  AA{A  A\AQA
ARApAAÅApApAÙA
=A\A¸RApAîAHA{AA{AGA  AzA
=A  AAA  AApAA=qAAffAffA
=AHAA
=ApA{AAHA\)AHAAA\AGAHA\AA=qAffAGAA(AAAAAAGAAQA
=AGAAAA(AQAzAAHA33A33AGApA33AGAGA33AAîApApAQA33AzA¸RAģAď\AAQAÙA=qApAQA{AîAA
A
AQAģAAAĸRAAHAA
=A\)AŅA\)AAAAAAffAAAA(AA(AAA{AA
=AAŅA\AAď\A  AQA33AGAHAAzA  A=qA  A{AGApA=qAffAA\A\A\AA
AAApAAGAffA=qA{AA
AA\ARApA{AA
=AA
AAÅAGAGAÅAA{AģAģAffA=qAÙA33A33A{A=qA
AffA\)AffAAHAA=qAzAHA  A¸RAzAAAGA=qAĸRA{A(A  A  AffA  A
AzAzAAAAAGA{AffAAA\AAA\A
=A\A\)A=qAffAAQAÙAģA33AŅAAzA  A  AÅA=qA{A\A\AzAA  AffAAAÅA{AQAAƣAA{AŮAffAAÅApA\)AÙAffAÅA\)AAApA
AA\)A
=A
=ApAA
=AffA{AAA  A
AAAA
AzA{AA  AAA
AA(A\A{A
AApAAGA{A(AffAAGARAffA{A=qA33A33AffAAA
=AA  A
AAA{A{A(AApAApAAA{AA
=AGApAA
A(AffAQAQA=qAAAAGA33A\A\AGAA=qA=qA{A{AAAGAffAQA=qA  A  AAAAGAA\)AffApA
=AARA{AAA\A33AAA(A
ApAAA
A
ARAHAAAQAAffAAQAzAffA(AAAA
=AAAzAffAA\)A{A=qARAA\AA\)ApA
A\AAA\AA{A\AHAA=qAHA{AAAAQA=qAGA33A=qA  A\A\A\AHAAAAAAA  A  AA33AA33AAQAAA
AAAffAAzA
AAGApAzA\A\A
AGA(AGA(AA(A(A{A
A
AAAHA(AHAffA{AApA=qAffAA=qAHAA\ARAA
AGAA\A\AAAAAGA  A\)AAAA33AffAA{AAAAA=qA{A(AA
AA33AAA33AGA
A
=A
=A\AA\AHA\AAQA(A=qA{AAAA
AAffAffAzAQAHA=qAffA=qA\)AzA
=ARA  A
=AGA
=A(AffAA  AQAQAAAAApA
=AQAApAAzARAA\AAHAAAQAA  A\)AQA=qAHARAA(A33ARAA=qAzA(AzAHAAQA  AAAAAA{AQA\AAA33AAA=qA\)A33A
AAAAAQAAGAA\)A33A(A  AzAHA\AAA
A{A{AffAAA\)AA
=AQA{A(ARARApA  A=qAA=qA\)AQAzAGA\)A
AA
=AA\)AA\)AA(A(A=qAGARAAA  AAAA\AAA\AHAAAA\AAGA\)AAAffAA(AHAA
AAffARAGARAAGA\)AAAAAAAAffA(A33A
AAÙAAAzAHAQA(AffA  A  AQA£A¸RA(A{A{A{A
A=qA(ARA
=A
=AHARAGA\)A  AAAAAA\A=qA\AzAAA\)A{AHAAA
=AApA
AAAARA\)A
=AGAQAAAAAHA
A33AAHAA
ARAzA(AA=qA=qAQA33AA
A
AAApAGAAHAHAAA
AA
AQAA  AA\ARAGAHAARAffARAffARA\)AAAAAffA=qAA\A
=A
AAApA(AA{AAQAzAffAffA33A
=AGAAGAA33ARAApAAA  AA
A  AQAzAAA(AAA(AffAAQAzA  AA
AHAffAAAQA(AzAAGA\AAAGAffAA
AQAzARA
=AApAAGApA(A=qAffAffAA(A=qAA33A\)AAA{AHAAAAAA
=AAAAffARAAA\)AAAAffAzA{ARAHA=qAffAA  A=qAGAAAGAApAApA
A{AQAffAHAAAGA\)A
=AAApAAffAQA{A
=ApA(AHAA
=AGA\)AGAzARAHA\AzA
=ApAAAQAQAQAA  A{AAAAAQAA(AAQAffAA(AzAGA33A33AAAAAAAAApAAď\A=qAHAffAď\A
=AQAîA33AÅAA(A{AzAQA33A\A{AA\A33AffA{AQA
AAA  AAAAA¸RAA33AHAffAA
=AHAHA\AAA(A\)A\)AAQAAAffA\A
=AApAAzA=qAHA  ApAAGAA  AQAAGA  AA\)AAAA(ARApA=qA  AAAzAA
AA\)AA=qApA33ARA
ARA33A{ARA(A(A{AQAA
AA\A(A
A=qAffAAAApAAAA\)A{AA33AffAAApAQAAA\AAA=qAAGAHAAAGAAA=qAAHAAAzARAA33AAQAAAffA(AffAAHAQA{AAA=qA=qAA\)AzAApAHAGAA
AA\A\)A
A33AzA\A(A
AAzA\A\A\A\AAGAAA=qAzA(AGA33AApAAffA=qAAAAAAAA\AzAffAA=qA=qA
AAA  A
AHAAGAA{AAAAAA(A
=A
=A33A
A{AGA
AAffAHA\AApA\AHAQAzA(AAAA\)A\A\)AGA  AQA
=A
=ARAApAA\AffA\AApA£AHAHApA(AffApA\)A33AQA  ApAAffAď\Aď\A=qAAAAAÙAGAAAffA
AA33AGA
=AAAGA
=A33AffA  AAGAA\)A
AGAAA
A{AQA\AzAffA
AAQAA(A
A=qAQA{A=qAQA(ARA{AGApA\)ApAA33AAApAzA\AffAQA
=AQAffAzAAA{A
ARAARA\)A  AzAA33A33A\)A(AAApA
A  A
AffAAARARAA  AAAQA33AA(A33AA(AzApARAGARAA
AAA=qARAAAApAAffAAA\)AAARA
A
AzA  ApAA
=AGA(A
AAAA\)AAGAAHAGAGApA=qA  A{AHA33AHAQApA(AAHARAGARA\AffA
=A  AGA
ARA
A
AA\AQAA  A\)AAAApA=qAAA
AGAffAzAffA=qA(AA33AGAŅAHA(A¸RAîApAÙAAHAA33A
=AApAAAHApAGAQA33AAA\)AA  AAAAAAQA
=AAQApAAGA  A
=AAApA
=A=qAAA=qAAAHA=qAQAA=qA
AGARA{A  AAGAAA
=A\)A(A  AAAGA\)ApAzA  AA\)AAHA=qA
ApAGAGAAAAGAA33AApAGA
=AAHAAHAAAAA33AAffAGAA\AAHA(AA
ARA
=A
A(AA\)A  AQA\)A  AA33AAQAGAAA=qA=qARAHARAQA33AA  AAHAA
A(AAAARA\AA\)AzAHA(AAHA\AHA33AA33A(AAffAA=qAzA(A33A\A{AA\A  ApAGAA\)A  AffAA33A\A{AA33AGA
=ARA33AARA(AHAA\)AffAffAHA\)AQAGA(A\AAGAzA  A(AGA33AzAzAAA
AHA\A33AzAA=qAA\AA=qAffA
=ApA33A
AAApApAAGAHAA(AAA
AA
AAARA
A=qAApAHAHAA{AA
=ARA33AApA\A  AQAHAAAA
=AzAzA{A=qAQAzAAGAA  AŅAŅAŅAřA\)AřAGA
=AAAffAzA  ApAAHA£A£AAÅA\)AGAď\AîApA
=AAGAA=qApA33AffApA33A=qAîAQAîAîAîA\)A{AA(AGAÙA
AffA\)AffA33AGAGA33A
A\AAÙA(AA33A\AHAAHAHAA\AA{A
=AQAHAA
A
=AA\)AGA(A\)A(AAGApAÅApAÅAAAHA\A\AApAGA\)AGAA¸RAAA=qA\)A
=A(A{A=qAffAzA(AApA(AAHAA\)AAzAA=qAffAAAAAGA\AA  ApAA
=AA=qA\A\A
AA=qAA=qAHA33ApAAffARA  AAA(AA\AAAffAAA  AGAzARA
A  AA{A  AAA\)A
AAAAQApAGApAHA  AAA{A
=AA
AzAHAHA
AHAApAA\AA{AAA33A(AA
A
AA  ARARARApApAA=qAHA33A\AARAHApARAAHARA=qAA\)A\)A33ARAA(AzAffAzAQAAAffA=qA\A{AHAAffAA\)ARA\)AGAAzA  ApA(AffAQAffA33A(AAA  AGAA
AARA
A33AA{A\AAARA
=AQAA=qA\AffA\)AA  ApA
=A\)AQA{AA=qAApAffAA(A\A  A(AAAHAA  AHA33AA(A(AGAAAA{AA  AGAA
=AA\AAzAA\AAHAQA  AA
A=qAAzAA{AAA33AA\)AAAAA33AA{AffAAffAAAHAHAA(AA{AAAQAA(ApA\AAGA
ARA{A=qA
=A
=AQA  AA{AA=qA(AzAAffA
A  AA  A\)AGA(A{A\A\A
ARAAAAQAA  A33AAGA  A\ApApAffA
=AAA\)AA\)AA=qAAzA
=A
=AAA{A\A  AGAAGA(AA  A(AA
A\A
AAGA\AA\AHA
AAffA\AHAA
=AGA{A=qAHAAAQAAARA(AGA  A\)A
AGAAAffAAffA
=AzA  AQAAAGA(AARAGAA  A=qA
AA\)AGAGAAARAAA  AzAA{AARARAffA=qA
A  A\)AA33AAAQAAAzA33AAAA
AffApA\)A
A33AAAA\)AHAAARAffA{A=qA=qAzAAzAApAAAffAffA
=A
AAAAAAAAAA33A=qA
ARA(A\A=qAA\A(A\AffAA33AAzA
AA
=AAHAHAA
A(A
AffAARAAffA=qAAA
=AAAA  ApAA
=A(A  AGA  ARAAAAAffA=qAzAAAHAARAA(AAA
AA\AGA(A(AAAGAA(A=qApA\)AAA=qA=qAHAzA(AHA33A=qA
A(AHA
A\AGAAAA{A=qAffA  AAARAzApAAAAQAffAAGAHAAQAzAAAAAHAffAA=qA33A  A\AGA=qA
AAApAA{AA
=A=qAHAAAffA
A
AAAffAA(AffA{AQA
AARAAAAAA(A{A
A\A  ARAffApAGApAAAAA\AA=qAHA\)AAzA  A(A  AffAAAAQAffARAAHAA{AA  AQA\)ApAQA\A33AA33AA{ApAAGAQAGAAffARAHA33ApA
=AAzAAA=qApAAHAA33AGAAAAA(A33A  AA
=AGAA\)AA{AA
AA(AAA{A{AzA{AQAGAA  AAAQA  AzAA{AGA{A{A\)A
A33AA  A  AQAAAGA(ApAA(AAAHA(AGAA{A\ApAAAA  AzA  A(ApAAA{AGA(A  AGA33A  AAAAAAAAHAA{AAAAAARAAA  AA  A{A
AAAQAAAAffA
AARAzAAzAAffAAAAAffAAAApAQApAGAAA
=AQAQAHAGARA\)AAQAA33AzAAA\AARA  AA\A
=A\AGAAAGA33A=qAQAffA(A\)A  A{AQAQAA¸RAAAAHAzA(AGA33A=qAzA\)AApAA=qAffAzAAA33AAApAAHA33AAAAHAHA(AHAffA=qApAAAApA
=AA\)AA
=ARA=qA=qA{A
A33AA33A  A
AffAffAHAAffAA  AffApAAA=qAAAARAAAGAAA\)AAAAA{A(A  AAHA\)AAHAA\)ApA=qAÙAGAGAAÅAA  AffA
A
A
A\)AffA\)AApA(A(AAQAApAAAA33AHAffAAQAAApA=qAGAAAA=qA{AAAHAApApAHA
=AHAAGARAAffA
AAGA  AAAA
AGAAHAAAHA  A  AAGARAffAffA
=AGAAHARAzAAAAA\AAA=qAApAA¸RAAA=qAAA33AîAQAîAîA(A
A33A\)A  A  AAAîAA
AHAAA\AA
A\)AzA\)AQA=qA=qAA33AA
ARAApAA=qA33ARAQAAzA{A{AffAQA  ARAARAA
A  A(AA{ARAGAQA{A\AA=qA\AA
AAAAAAApA=qA\ARAAQAGA\)AAQAzAAAGAHAQAA\)AApApAA\)A
A
A=qA(A
=AAARAGA\)AA33A{AQApAffAQA
AA(AAAApApA
A(AHAGA\A\)AAA\)AAAA33A=qAA\)A33AAAA=qAA\A  A
AAAApAAzAGA=qAA
=AzAA\)AGAA\AA
ARAAAQAA{AGAA\AzAAARAffA\)ApA33AA\)ApA\)AAAzA\)ApAA
=AAAA  AA(A=qA\A
AzAA
=A  AzAGAAAAQAHA33AAffAffAA  AA\AARAzAAA
=AA\A  AAAA
AQAHA33A
=A
=ARARAApAAGAAAAARA33AAA
=AA=qARAAAAffAAAA(A
=A\)ARAAzAA{A
=AffAAAHARARA=qAffAAAAQAA=qA\)AAAzA33ARAffAQA
A=qAQA\A\A
=A\)AAA  AAHA(AAAAAAAffAA{AA
A
=AQAA
A  AzAzA  AAAQA=qAzAffAAAAAzAAA=qA(AQA\)A\)A  AA(A  AAAAHA\)AA
AAAA  AHAAAffAGAA{A\AA=qAAAAAA\)AA\AHAGA(AAA\)A33AApA\)A33AGAGA33A33AzAA
AAHAAA(AA  A=qA\AAAAHA\AGA
AA
AApAffAAQAA\)A  AAffAQA\AQAGAApAAA33A\A\)AGAAARAQAAAHAffA
=A  A\AA=qARAffApAAA(A\A
=AAAA33AGAAffA(A
AA{AA=qA\AzA33A(AQARA\)A  ARAAA=qAGA33AGAAGApA33AAAGAAAAARARAAQAA\AAAffAApAA
=A{AAAAzARAA\AA\A(AHApARA{A\)A{A{AA33AQA\ApAHAAA(A\)AzAGAAzA\)A
=AA=qA\A
=A
A{AHA33AAAA
=ApA\ARAGAApAAffAA
=A\)A
=AGAA{A  A=qAHAAAAQAA\)AGAAAzAffAAffA  A33AAAAA  AARA\)AAffApA
=ApAAffARApA=qA33AAHA=qARAAQA
AGAAHA\)A\AA
=AAffA33AHARAAAA  AHA  AAAAAGA
=AAzAHAAAA33AAAAAAA{AAHA  A{AA=qA\)AAAA{AAAHARAAAGA33AARAA=qA  ARARAAAQA\AAffA=qAA  A
AAApA\)AA
=A\)AAzAQAAA
=AARAzAffAGAGAGA
AzA{AAAA=qAAffAffA=qARA
=AzAAAAAffAHAffAAAQAA
A  AA\)ARA(AA(AA
A\)AAAffAHAzAAAA\)AAffAHA33A\)A
A=qARAHA(AA  A\A
=AGA
=AQAA\)AA\A\AAGAA33AffAA  AGAA=qA
AA  AA=qAGA33ApAAHAzA
=AAA33ARAAHAA  A{AGA\A(A33AGA\AGAAHAGARAAA
=A
=A\AAAffA
A{A
=AAAA{AAAAzA\ARAAzAA33AAAzAffA  AzAzApA\ApAAAA\A\)ARAAAHA
=AGA
=A\AARA(A33AAzAHAAGApAApAffA\AzAffAHA
A
=ApAA
AzARA
=AHA(AAffAApApAAHAAzA=qAffA
=AARARAAGAHARA(AffA\ApAA  AAAAffA
A{AffA\A(AGA  A(A
=AffA{A\A(A33AA\)AAzA=qA(A\AA(AAAA{AA(A\)AAzA=qA(AAÅAÅAÅAAAQAAAzA  AA  AAAAGA=qAHA
=ApA(AAA33AAHARAQAAApAzAAffAHAA  AAzA\)AffAzA  A(AĸRA(AA  ApAAApAAAď\AffA
AffA(A33AA
AA33A\)AA{AHA=qApA=qAffAAAGAAzAAARA33AÅAAGAAA=qAÅApAÙAAHAHA\A{A
=A33A\A
A=qA33AAGAAARAGA{A(A=qAAAÅAGAHA{AGAARAAAAAHAGAAHAzA
=AzA¸RA  AQA\A\)A  A{AA(AAA{A¸RA{AAHAAA(AAÙA{A\)AAGA(A¸RApAÙApAzA{AGAAzA(A\AAGAAAAAA=qA\AAAzAA
=A
=A\A
A=qAAzA\AAAQApAAGAAA
A=qA=qAffAAAA{A(AffA¸RA¸RA(A{A(A
AAAApA(AAAffA{A\A\A\)A\AQA
=AAAAA33A\)AA33A  A
AA(AA(AGA\AffAffAARARA=qA{AGA{A  AAApA
=AQAAzA\)A
A
A  AffAHAAHAGAAA\)A{A\ApA(AAffAQAHAHA¸RApA(AAAAGA
=AŮApAApAřAŅA
A  AGAQAŅAAGA\)A\)ApAAď\AzAffAď\A
=A33AHAAîA33AÅAAHA\)ApAApA  A{A£AA(AAAzAAffAA\AHAAGA
A\A¸RA
=A£ApAHA{AAAA\AA
A33A\AQAAffApAAAA=qA\)A=qA{A\AQAGA\)A(AA
=A{AAA(A{A
A  AAAA\A=qA  A=qA\AA33AApAA=qAQA£AHAîAA\)AAA(AAAď\AĸRAģAAffA=qAîAA\)AîA{ApAGA
=AAHAQA{A{AAAA
AHAA  A  ApA\AffAAffAA\A  A=qAffAQAQARAGAGA=qARA
A\)AQARARA  A
AAAAApAA
A\)AAA=qA(AAQAAAA  A(A=qAAHA{AffA£AAAGAApA  AA33A\)A\)AGAAGAGAHAAģAď\AģAAAĸRAQA33AA33AA  AGAģA=qAģA
AÙAÅAAÅAGAzA
AQA
AAzA\)A=qA¸RA  A
A
=A33A{A\AA(AAAAHA(AAffARA33AAAAA  A
AGA\A\A\)AAARAAGAHAQAAAA  AAAGA33AAQAHA
A{A=qA
A=qAHAHAA
=AGAǙA
AzA33A(A(A33AəAɮAəA\)A\)AəAAGAGAȸRAȸRAHAGAAɮApAAȣAǮAřAHAAŅApAA{AÙAA
=A£AA  A  A\A\A
AA=qAA=qAApAA\A\A
=A33A{A(AAApAAAQA=qA
ApAAQAA33AARAAAAA
=AAAA  AzA\)AffA
=AAA
AQAQAzAAǅA(AAəAɮAGAʣA{A33AǙAQAA33A{A{AApA
=AəAAƸRAGAAǅAǙA{A\)AA(AzA{ApAQAƣAƣAƣAƣAA
AA=qA  A
=A33A  AŮAffAQAA{AzA¸RA{A
=AAÙAQA{AAffA33AGA\)AģAA  AAApA=qAffAîAHA(A=qApApAffAA\A\)A  A
=AHAA
=AHAA\AAĸRAA33A  ApAAřApAAQAzAzAƏ\AQAAHAƸRAAGAGA
=A
=AHAHAAzAffAAģAzA
=A33A{A
A
A{AA{AHAƏ\A=qAA
=AffAA(AQAƏ\AA  A¸RA\A\)A£AÙAGAHA  A33A\A(AA\A
A{AAAAAAHAAAA=qA\A=qAffAAQAzA=qA\A{ARA
ARAAAAffAffAA
A{AAQA\)AzAAAAA  AAGA33ApA(A=qAHAAA(AAApAAA=qAAGAGAAGA(AAA\A
AQAffA
AffA{ApAffAGAA
=A  A(AAHAHA
=AA33A
A=qAA
AffA\ApAA(AAA  AAGAffAA\)A33A
ARAA
A33AAGAGA
A33AAA  AAffAHA{AHAA
AHAA\)A
A
=AA  A
AzAHAAAA
A(AzAAA{AA(AAGAA
=AHA
=AzA{A\)AAAARAA  AApAAzAGA=qARAA(AHA
ARA
=A
AAAApAAAzA33AARA33A  AA{AQA  AAA\)AAAAAAHAGAA(AAGA=qA\A  A  A
=AffAHAHARAHAAAA=qA
AffA(A  AffApA=qAHAA(A=qAAAHAAAA{A
=A(A{A
=A
=ApAzAHAAHAffAQAAzAA
=ApA33AARAQAA
=AARAAARAAAHA  AA  A33AAAHAAQAA=qAffAAffAA=qAAA{A(AGAAA
=AzA  AHAA\)A\A
=A\)A\)AAzA=qAA\)AA  A{AA
A{A33AA\A
=AAAAAA
=AA(ApA\)AA=qAGAAAffAA
A  AApA33ARA{A
AQAffAffAffAzA(A{A
AApA
=A=qAA=qA=qA
AAApApA  AGAA
AA
A33AGAAAARAAzAARAQAGAQA(AA\)AA33AAGAAQAffA
AAA
=AffAHAffA\AHAQA33A
A
AGA33A\)AA͙A̸RAA
=A\)AzA(AffAHAQA
=A(AAУA=qA\)AΏ\A
=AΏ\A=qAͅAиRAApA{AAAA
=AAA
=A
=AθRAGAA=qAffAΏ\A
AͅA͙AAGAffAAHAffAAzA=qAHẠAAQA=qA{AffAQAAzA
=AϙAA
=A33AGAAУA(AծApAzAHAA
=AיA
=A
AۮAQAGA=qAޏ\A=qA(A
AGA  AzAԸRApApApAӮAԣA
A{AңA  AQAzAAA\)AԣA(A(A33ApA(AAҸRA(A\)AиRA  ApAиRA  A{ApAA
=A\)AGAңAGAҏ\AңAҏ\AAиRAиRAzAЏ\AApAӮA=qAzAAHA  AHAA33AхA
=ApAA
=AAAffA\)AҸRAңApApA
AHApA  AA
=AAGApA=qA=qAQAAAQAAzAzAffAA{AHAٮAٮA33AffA33A֣AծA\)A  A{AAAA֏\AծAQAQA
A(AҸRA
A
AGA=qA{A
AHAzAυAҸRAӅA
=AQA=qAAzA  AAGAҸRAQAzAԣAAHAA33A{A=qA(AGAQA{AΏ\AυAHAzAAGA\)AAΣA
=A{A\)AυAA{AffApApAffAHAȏ\Aʏ\A(Ȁ\AHAͮAͅAΏ\AθRAυAυAͅAAAA\)AHA\)AHA33A{ApA33AυAυApAΣAA
AAAffAυAЏ\AθRA\)A=qAAHAʏ\ApAQA\)A=qA(AGA=qA˙A33A˙A
AA˅ẠAApAAΏ\A=qAθRAAGAHAΣAΣAAAAAΣAAAAGAA
=AzAGA33A33A33AʸRA
AGA(AAffAHA̸RAAGAffA͙A  AAzAA(ApAHA=qAffAffAzA
A
ApAΏ\Ȁ\AΣAHAA(A\)AхAffA  AAAӅAӮA
AA  AQA(AԸRA=qAAԏ\AՅAAԸRAHAңAQAA(AAAУAA=qAzA
AGA\)A=qAffA  A33AAθRAQA{AυAGA{A
=AAAҏ\AQA=qA{A
AљAљAA{AϙAHA
AA{AA33ApApAHAHAA{AGAQAA͙AΏ\ApAQAAиRAAAAAA  ApAAA
=A33AzAҏ\AQAAӅA{A\)AzAGA
A=qA׮A֏\AAӮA
ApA
A{A(AGA  A  AHA{AӅAAәAУA=qAϙAGA
=AGAffAʣAAffA\)A
=AffA(AQA
AϙA  AϮAffAffAHAхApAAУAυAAGAAɮAzA33AQAA
AHA
=ApA(AAAAΏ\AˮA
=AAȏ\A
=AͮAQAA\)AиRAzAϙA
A=qAAAQAAAϮAУA(AA(AA
A֏\A׮AffAzAA֏\AzAHAԏ\A33AAԸRAԸRA\)AAՙAՙAAָRAAAՙAA
AzA
AffAУA33A  A
AѮAҏ\AffAffAҏ\AA33A
ApA33AHAA33A=qAGAϮAυA
A33A33A=qAQApAHAẠAA
A(AθRApA
AA(A
=ApA
AѮA
ApAAAAиRAЏ\A(A
AAffAA=qApA  AхA\)AҸRAңA\)AҸRA
=Aҏ\AѮAA  AAA
A
A{AQAԏ\AA
ApAԸRApAՅApAՙAՙAңAffAҸRApAӅA
AffA\)A(A{AA  AЏ\AGAzAхA(AҸRAGAϙAϙA\)AиRA(AAA{AffAҸRA\)A
=AӮAGAHAҏ\AQA=qAAѮAA
=AиRA=qA
AHAˮA=qApAəAQA˙A33Ȁ\AAGA=qAΏ\A\)A  AQAffAиRA33ApAѮA(AffAҸRAӮA
=AffAA\)AQA{A=qAҏ\AffAHAӅAԸRApAA(A(AzAQA  AծAAAA
A=qA  AA
=AA
AҸRA  AAӮAQAA{AApAGAA  AHA
AәAхAQAAAҸRAAzAzA33AхA(AAzAffA  AzA\)A  AΏ\AͮAͮA(AΣAffAAGA33AϙApA
=AGAυAAυAυAυAQA  A
A  AA\)AffAҸRAA{A33AҸRAѮA
=AңA
AәAңAѮA(AGA
AϮAA{AУAA\)AQAAA  A=qAAHA֣AffA֣AָRA=qA(AAՅAՙAHAԸRA
AA
A{AHA
A=qA  A
=A֣AGAAԣAAA33A(A\)A\)AffAA=qA{AAӮAAҏ\AхAϮA(AzAGAхA{AңAHAA\)AGAGAQAffAGAA{A\)AͮA{AAхA=qAAԏ\AHApA=qAHAGA33AGAzAApA
=AAԏ\AA\)A33AAA
=AAHA33AQA=qAAGAAָRAffApAQA(AHAA(A(A(ApAיAָRAA؏\AA{AAAffAQAAӮAHAәAծA(AHA\)ApAיA֣AA33AGA  AHA=qA֏\AzAQA  A  AAAffAffAԣApAffAԸRAHAA{AәAHAGA
ApA33AAAϮAGAGA
=A=qA(AHA
=AAzAңAQA(AffAGAԏ\AAҏ\AGAԸRAԏ\A33AҸRAңA33AԸRA  AAAffAAٮAzAGA
AAHAܸRAܸRApAڏ\AڣAۙA33A\)A(AۙAڏ\AA  AיAA
A(AمA=qA
=A\)AAHAAڏ\AٙAA33A\)AA=qAAffA
AAQAAԸRAHA=qAAҏ\AApAӅA
AzA{A=qAAQAӮAQApAԏ\Aԏ\AQApA=qAәA֏\A33AծAffA
A(AffA
AٮA
AۮA{AffA
=A  AzAQA{AQAAمA  AA\)A{AظRA{A=qA؏\AظRAظRAظRAHAAzAָRA=qAأApAGApAٙAQAQAٮA  AAHAAظRAQA{AffA؏\A
A33A(AGAظRAffAQA׮A(AA\)AיA{AApA33A=qAծA
=AӅA33AQAԣA(AAA{AGA=qA{AA33AQAGA
=ApAԣAGAծAzA֏\AAGA֣AׅA
AA֣A33A33AQApAAAԣA  A֏\A֏\A
AffA֣AծApAՙA
A(A{AָRA֣AA
=A
A=qA
ApAzA\)A33AQApA׮A  AAAQA֏\A=qA
A
A֏\AָRA֏\AA\)AA=qAA  A{AzA(AׅAApApA=qApApA{A
A{AԸRApA33AAAԏ\A{A(AӅAGAHAңAzA=qA(A
AѮAљApAљApAѮApAAAиRAиRA(AAAAAA(A
AzAHAHA=qAϙA(AAυA
=AQAA33AzAA  AAAQA33AAЏ\A\)A
A=qA(A{AzAAGAGA{AffAAԸRAAAAԸRAA=qAzAA
AԸRAӮAAҸRAAҏ\AҸRAҏ\Aҏ\AAңAљAхA
AA
A(A
A
AHA
=AңAzAHAQA=qApAУAAθRAϙA{AA(AGA(A{A̸RA̸RAA=qAQAA(A˅AHA  AzAͅAQA33AυAЏ\A=qA\)A=qAA
=A
=AծA
A
AAՙAAָRAGA=qAظRAffAffAQAApA{A\)AzAAҸRA
=AЏ\A(AθRA\)AAGA
A\)A׮AA=qAԣAՙAиRApAA33AQAͮA=qAffA{AƸRAƏ\A33AϮA͙A̸RA  AffA  AffAͅAͮA(AAΏ\A=qA
AffA33AϙAGAAͅAͅAHAzAθRA  AQAЏ\A{AϮAϙA\)ApA33A
=AAAGAAQA
AffAHAzA  A  AȸRAȸRAffA\)AȣA
AA33AQAƣA
=AǅAffA\)A(ApAυAGAAAHAHAׅA
AffAәAffAҸRAҏ\ApAAA؏\A
AיA֣A=qAՙAGAAԸRAAљAA
AAϙA  A
=AffAApAхAAϙAAϙA\)A{A
=AHAffA\)AA=qAA33AAѮAAңA
AхA\)AхAҸRA(AAzAffA˙A
=AA
=AGAffAA  A=qAAA͙AzAͮAA
AA  AzAAυA{AAиRAGAGA
AAθRAΏ\AffAGAAA
AzAGA(AԸRA
=AGApAAAffA
AָRAHAGA
=AA(AAffA
ApA\)AA
AәAAӮA\)A33A֣A֣AָRAA(AՅAAGAApA  A33AHAzAҸRA(A  A\)AQA
A\)A(A=qA=qAȣAȣAǮA  AAAď\A\AA  AAAA\AApA33A=qAGA\A  A
ApAA\AGA{A=qAffAA33A\A{ARA33AA33A{AffA
AffAHAHA\)AQAQA\AGAAA  AA
=AGAHA  A(A=qAffAAAA{ApA{A  AǮAzAAřAřAffA£AĸRAGA\A
AA\)ApAģA
Aȏ\AQAŮA33A  AHAŅAď\A\)AA£AA33AA{A  AHAƏ\Aʏ\AAǅA\)AA(AAAď\AŅA\A\)AǮAÙA  AŅAQA33A33AAAAřAA
AAŮA  A\)AGA
A̸RA=qAHAffA
Aҏ\Aԏ\A\)AՅAAAAڣA
AA
AffAA
=AܣAHAGA֏\ApAمAffAGA=qAӮAָRAAAȸRA(AθRAAAzAA\)A33AיAA  AffAѮAQAҸRAәA
=AԣAffAAәA{A֣AGAAGAҏ\AӮAGA\)AθRA(A
AA{AffA(A  AA(A=qAͅA̸RAẠAA33AGAffAΏ\A(A(A(A͙AΣA
A͙AGA\)AAͮA
AA  AиRA\)AA\)AхAA33A{A  Aڏ\AQA
AمAٮA(Aڏ\AAۮAzAQAGA
=AGAA
AAѮAAzA\)AAAיAGA
=AAҏ\AՙAQA=qA  AA͙AAϙA{AGAϮAffAЏ\AA
A  Aԏ\A(AAQAәA(A\)AAA{AAӅAffA=qAхAυA
AAA(AAHAHA
=A{AQA\)AAУAffAzAHA(AQAA  A\)ApA\)AA{A
AHAУA(AzA\)A؏\A\)AffA  AAٙA  AAAٙAڸRAۮA
=AzA޸RApA޸RA޸RAAޏ\A=qAzA
ApAܣAA  A
AA\)AׅA{ApA
=A{AHAϙAQA
AQAәAQA؏\AAffA
AQAGAA
A
AHAљA=qAԸRA
=AAиRAzAQApA\)AAAA=qAљA
=AиRA{AGA
=AυApAϮAϮA{A  A{AQAиRA\)AA=qAHAәAңAA{AљApA  AHAυAHAA33A
AңA\)A
A
AӮA=qAԸRA33ApAQA֏\ApAzAՅA\)AAAHAAAӮAAϮA
AѮA  AffAHAׅA\)AңAҏ\AΏ\AQA
AGApAA  AA33AGA=qA(AͅA\)A
AHAͮAQAϙAθRA\)A  A=qAA\)AA{A=qAHA
=AHAGA  AңA  ẠAGAˮAAẠAẠA=qAGAͅAAͅAQAQA33AHAͅAAȀ\A(A
AA33AA33AA33AљA=qA(A  AAA{A{AAϙAAGAҏ\AңAҏ\Aҏ\AԸRAAffAAθRAAAAϙAzAϮAGAApApAՙAԸRA
=A{AAA\)ApA  AA33A
A(AЏ\A
AQAzA(AQA
AAA=qA\)AУA{AυAAυAAQAAAGAƸRAA˅ApAffA{AȣAʏ\AA\)A33ApApAA
AЏ\A
AУApA  ApA33AѮAHAЏ\AHAGA33AӮA(Aԏ\AAՙA֣AָRA{AzAԏ\AӅA(A\)A=qAҏ\Aԏ\A{A{AA=qA=qAAӮAAA=qAzAAAՅAHA(AAӅAӮA{AA  A{AApA\)AzAA{A(AAQAGAхApA  AQA=qAQAљA
=AQAA{AA\)A33A  AAљAAAΣA̸RAəAˮA
A\)A{A(AHA33A
AϙA{ApA  A  A(AGA=qAzAGAQAңAzAҸRA{AffAA33A\)AծA  AffA(AAԣA
A  AAffA(AљApAGAzAzA
=AхAA33AHAӅAHAԏ\A
=A33AԸRA(AԣAԸRA=qAԣAQA{A  AԸRA=qA(A
A  AAAffAυAϙAʏ\A{A\)AծAGȀ\AA{ẠAɮAApAA\)A33A  A(AGA(A
=AѮAQAQA{AHAHAHAAApAԣAffA=qAzAԸRA(A  A
AAԏ\AApA\)AQAA\)A{AԣAA
AAׅAיAיAGAمA(AA33ApA(AAAӅA  AA  AffAAffAڣAffAHAיA{AAAAA33AҸRApAҏ\AAAAAиRAGAzA33AQAңA33AGAHAңAAAGA33AԸRAҏ\AAҸRA\)AУAGA{ApAAHAffAΣAQAQAҏ\AϮApA
=AGA=qA=qAԣA=qAхAzA33A  A
=AAA
=AΣAϙA\)AQA(Aҏ\A
AυAхAffAffA  AхAAԸRA  AQA(AApAՙA(AAԸRApAA(AffAԏ\A33AAЏ\AљAѮA\)AAхA33ApAAGA33AAӮAAAָRAՙAA33ApA
=A(AGAיAzAA33A  AәAӮAӅA33AA(AGA͙A33A33AffAffAљApAѮAzAѮAљAAУAAAAљA{AHA  A  AA33AffAA  AңApAҏ\AA
=AApAͮAͮA
=AиRA{AffAHA\)A(Aҏ\AA
=AQA{AϙAQAffA(AиRAЏ\AυAGA=qAA
AϙA
AA
AӮAQA(AԣAԸRA=qA{AӅA\)AΣA{A=qAzA\)AәAծA
A\)AQA\)AӅA(AAA
AffA\)A  AA
=AΏ\AApAffAѮAхAхAϙAϙA{AzA
AA=qẠAAͅAΏ\ApA{AҸRAAAffA
=AAAA  AԸRA
AAAA33AffAأA\)AzAzAՙAָRA  AA֏\AՅApA(AGAҏ\ApAAӮAAGAGAυA͙A(AzAAHA33AиRAϮAGAzA  AAAA{AA=qAѮA=qAzAҸRAҸRA\)A
=AӮApA{AAAӅA{AA
A{AHApA
=AzAHA̸RA33A=qAAΏ\A˅A=qAGAAʸRA
A
=Aʏ\A{A33ApA{A{AУAҏ\AAAAAЏ\A33AGA33AAУAHAϮA(AQAApAAAAЏ\A\)A\)AffA(A
=A
=A33A  AQAHApA  AԣAAGAՅA
A  AՅA  AׅA֣AAQAHAՅA=qA=qAHAGA=qA
=AQA33AHApAffAAQA
=AQA=qAAӅA
ApA(AՅA
=A
A
A
A33AQAԣAAAzAәAѮApAңA
=AΏ\AхAffA33AУA
=AиRAϮApAЏ\AͅA=qApA
AӮA{AҸRAApAA{AԣA\)AAA  A(AA=qA
=A؏\A33A
ApAٮA=qAHAAA
AәAAAHA\)AAأA{AQA{A(A=qA33A33A֏\AָRAָRAHAHAAGAGA֏\A֏\AA  AGAәA(AՙAA  AAzA(AAzAծAAzAGAӮAҸRAҸRAҸRAѮAхA  A  AхAffAиRAЏ\AϙA
AffAϙA33A(AAϮA{A{AA͙ApA\)AA
=AǙA
AA̸RAAУAHAЏ\AA
AA͙AHȀ\A͙AθRA=qAẠA  AA
=AQAAʣAzAffAGA(A33A  AzA
AAԏ\AңA  Aԏ\AzA(A
A
=Aҏ\AҸRA(AѮAA=qAӅAҏ\AA(AA=qAЏ\AљAAffA(AυA
AϙA{AϙAθRApAQAGApAAAAAHAAffAffAAӮA{AӮAzAAQA(Aԏ\AA\)A\)AGAAGAɅAffAffAA(AиRA=qAAAυA\)A33AQAˮAQAAQAɅAʸRAAffAA  AzAffAхA\)AGAQA(A=qAHAHAQAzAAיAA֣AQA֏\A֏\AQAzA{A֏\AHAzA{AAGA
A  A
=AGA  A  AԣAӮA33AA33Aҏ\A(A(AӅA33AHA  A
=AҸRAA=qAHAQAAAAхAиRAAA
A=qAA  A
AҸRA=qAQAҏ\Aҏ\A33A33AGAҏ\ApAυA(AA=qAʸRAA
=AA
ApAAҏ\AzA  AAffAҸRAAљAљAHA33A{AAA\)A=qA33A\)A
A(AָRApA
AffAمAAQA(A܏\A܏\AAܣA܏\AGAٙAAzAڏ\AAffAHA33AffAzA
A33AׅAׅApA  A׮AGAָRAGAApAA(AzAAQAHAA  ApA  AՅAzAQApAzAՙAՅA؏\A
A؏\A֣A\)AQAQA33AЏ\AυAffAHAAA=qA
A  A=qAHA
A(AAхA(AAAzA  A
=A(A  A(AٮA33ApApA
A=qAظRA
=A  AA(AAzAAڸRAۮAۮA  A{A(AffAffAQA  ApApAۙAܸRApAٮAٙA(A=qAٮAffA؏\AffAGA
=A׮AA֏\A  AՅAGAAAHAAGAA=qA
A֏\A{AAGA
A\)AָRA׮A(A׮A33A(A(AA  AHAՅAՙAAԸRA(AӮAA(AԣAffA  AHAӅA{Ȁ\AffA(A֏\AAظRAGA\)ApAQAՅAffA{AzA=qAAGAA
=AׅAיA
AظRA
=AQAۙAA=qAA(AzA{AQAQAۅAA(AQAHAڸRA\)A
=A\)AHA{AAQA
=AمApAHA
AAAיA׮AA=qAA(A\)AՅAA
=AمA=qAffA(A  AA\)AffA=qA(AAffA=qAAffAA  AGA=qA\)AָRA(AAծAծA=qAՙA֣A(AA33ApA
=A
A(AѮAffAAQA\)AffApAҸRA(AHA(AAӮA
=AљAAљA=qAҏ\A33AәAA(AԣA\)AׅAمAAٙAHAAA
AAAAٙAAApAAGAA  A{A؏\AHA
=AHAAHAָRAQAA֣A=qAzA
A
=AHA\)A\)AGA
ApAأAzAA
=AQAAA{A33AHAA
=AѮA  AծAAٮAٙAمAAۅAGAمA
A
=AHA  AծAQAffAAAυAApAzA
ApAAHAϮAHA(A\)A\)Aҏ\A
AAծA{AffA
AQA֣AA
AA(A(A  AzA֣A
AיA{AظRAGAQAיAAָRAA
=AمA\)AA=qAԸRA  AAׅAׅAA{AAיAAظRAAՅA33AGApA
=ApA
=A\)A{AәA=qAҸRAѮAAA{AAУAϙA
A\)AәAΏ\A33A
=A{A{A
A(A{AAA
ApA33A\)A{ApA33AA
AQApAGApA؏\AՅA=qAHAApA
AңA\)AffAԸRAծA{AQAHAA
=AA؏\AHAHAAApAٮAٙAٙAمAAAHAڸRA\)AAAڸRAHA(Aڏ\A(A׮AۙA  A
A33AA
AGAAՙA֣AAңAљApAѮA(AָRAAQAffAָRAAAzAҸRAzAAϮAzAЏ\A  AApAQAθRAAHA{AAϮAԸRApAңA{AծAָRAGAAυAA
=AA{ApAәAA
=AՙAՙA  A=qAzAffAָRAָRA
=AGAAׅA
A  AمAمAHAA{A\)A
=AAAApA
A=qAA
AGAzAAGAHAAAՙA
=AAzAңAՅA=qA֏\AHAAיAApA\)AӮAңAљA
=AAҸRAHAҸRA33AͮA=qAQAQA33Ȁ\A  A33A
=AϮAҏ\AAәAҏ\AҸRAHAAAͮAȀ\A(AGAЏ\AΏ\A
=AffAAzA{A
=A=qAиRA33AΣAϙA  AAљAffAA
AQAՙA
AՅA  A֏\AGA(AffAAAأAأA؏\AzA=qA=qA؏\A׮AGAHA֏\A33AׅA֏\AA؏\AGAA\)AAAڸRAڣA{AٙA  AA(A(AA{ApA؏\AՙA
AԸRA=qAAHAٮAA
=AQAҸRAծApA{A\)AQApAAָRA  AA
=ApAzApAڸRAA(AۅAٮAGAҏ\A
A  AA\)AHA(AQAڸRA=qA\)AffAۮA܏\AܣA=qA
AzA=qA
AA
=A֏\A{AAAffAGAGAڸRAffAzA{A  A  AA{AAٙApAمAA33A\)AA33AzA(A֏\A\)AAAffAظRA
ApAHAAzApAGAٮAۅAA֏\A33A{AAAՅAA
=ApA  AQAӅA33A=qAzAGAҸRAңAӮAׅA=qA{AQAA
=A(A=qAGAԣAzApAAffAA=qAQA
AApAffA  AffAQA\)AHA33AәAA=qApAGA
=A
AffA33AAzAՙAGAffAffA؏\AAGA  A=qAffA=qAمA33AAA
A
=A
=AٮA=qAffAۅA
A(Aڏ\AٙAQA׮AQAٮAffA=qAGAׅA؏\A
=AA\)A=qAAzAAA(A׮AָRAffAzApA=qA  A\)A
=ApAθRA
AQAApAծA(A
A(AAՅAHAzA
A33A{AϙA  AzA\)ApAHAGAHAzAGAAأA33AA33A(AAԣAԏ\A  AffAԸRA\)AծA  A֏\A
=ApA
AQAHAָRAAAffAffA(A
AGA
A  A33A  A
ApAzAָRAA  AיAffAظRAAHA؏\A  AzAAAffA؏\AָRAGAGAθRAA{AQApAՙAffA33A
AAиRA
AHAәAӅAӮA
AAGAffAAЏ\ApAAA\)AffAԸRAAAAzAQA=qA֣A֏\A(A֏\AәAA
=A33A
=AA֏\AQAAGApAGAGAՅAffAHApA  AA؏\AA
A  A{A֏\AיA؏\A(AA؏\AzAffAA֣AA33A(A  AأAAzA=qAzAHA  A(A
AzA=qA(A(AQAAGAAA
=A{AA\)AԣAAׅA֏\AA֏\A\)A
=A(A
AӮA  AӅAA{ApA  A33AٙAمA(AAHA  A\)A
=AQAָRA\)A{AAA\)A
AGAzA=qAA\)AA\)AظRA׮A{A(AffAA  AffAۙAAٙAAHApAٙA\)ApA\)A{A{AٮAAA=qAٙAٙA
A\)A
A(A
=A\)A\)AAA؏\A33AٙAA(A{A{AA(A
A  A
A\)AׅAAHA
=AAHA=qAQA(AGAיAָRAָRAָRA֏\AA֏\A֏\ApA=qA33AGA\)AԸRAԸRAԏ\AAӅAffA
A33AffAGA
AӅAHA\)AиRAΏ\A33AffA
=AиRAѮAffAAHAHAHA\)A  AAәAҏ\AЏ\A
=ApAHAGA=qAԏ\ApAA{A֏\A֣A֣A=qA֣AAApAAٮA\)AظRAQA=qAAיA֏\A
=AGA
=AQAAָRA=qA=qA؏\AظRAأA؏\AՙApAAՙAָRAָRA{AՙAQA֣A  AAՙA{AA{A33AQAA{AQA(A
AӅA{A\)AA\)AGA=qAA
=A33AхAAzA
=AиRA
AQAGAӅAAAHA\)AAHAԏ\A  AЏ\A
A33A  AиRA{ApAΣAA
AAAҸRAAGA
AffAAHAzAzAԸRApAQA\)AAAҏ\ApAԸRA{A=qAA
=A  Aԏ\A33A
=AәAҸRAApA=qA
=AAңAAA\)AAHAGA  ApAՅA(A(A
AӅAҏ\AzA\)A=qA{AϮAAҸRA  A{AQAAAAAAA
=ApAHAzA{AϮAυAΏ\AΏ\A(AͅȀ\AЏ\A  ẠẠA
=ApAzAA=qA\)AA
=AAQA͙AˮA  AθRA\)A=qAθRAAA=qAApAGAծAՙAAGAԸRAՅA33AGAA(AAAәA=qAA
AЏ\AAҸRAҸRAffAҸRAAGA\)A33AϮAAQA33A  AҸRA  AA  AЏ\AͮA̸RAAẠAʸRAȣA=qAQAQAAΏ\ApA̸RA33AͮAиRA  AQAͅAAApAzAAQAЏ\AQAθRAΣAffA(AHAϙAAљA=qAA
AffApAAԏ\AQAffAAҏ\AffA(AA
AffAGAθRAΏ\AAA(Aҏ\A(A\)AApAffA\)AGAѮAѮA=qA
Aҏ\AAffAGAffAԏ\AA
=AAAҏ\A=qAҸRAAffAҏ\AzA(A(AHAңAHApAA\)AУA=qAAQAAУAAHAAиRA(AA(AzA
A\)AQAˮAAHA{A  A(AʣAˮAA
AɅA(A{AGA\)AHȀ\AAẠAAAA
A(AHAAA(AApA
AθRAΏ\AffAHAϙAЏ\AffAQAҏ\AҸRA
AңAA
=AAAA
AAGAHAAҏ\AHAхAA=qAϮAAHAAffA=qAΏ\A{A  AffAҏ\AA(A\)AA
AApAAՙAAQAHApAУAϙApAЏ\AQAљApA  A  AAzAHApAffAAAAffAA=qAϙA
A  A\)A
AAͅAϙAQAQAԏ\Aԏ\AGAӅApAGAԏ\AGAծA
AHA(A  A=qApAAAGA  A֣ApAA
=Aҏ\AzA
AӅA\)ApAӮA=qA=qAzAffAQAӅAGA(A  A=qAQA(A֏\A
=AAzA؏\AأAGA  AffAA{AA
A
ApAAQAҸRA(AЏ\A=qApAљA33AҸRApAHAzAAиRAAЏ\AЏ\AѮA\)AAУAA  AˮAЏ\AGA{AхA(AЏ\A\)AGA(A  Aҏ\AAffAәAGAҏ\A=qAԏ\A
A
AQAՙA
A{A=qA33AӅAӅA
=AApAAAffAңApA
A(AffAԏ\AAAzApAәA(A=qA33AQAAGAՙAՅAGA{AGAәAՙA
AծAծAՙAՙAՙA\)A\)AffAԏ\A=qA{AQAA
AHAљAGAA  A33AAљAхAљA
=AиRAAЏ\A  AAffAAApAGAffA33AzAAΣA(AzAAzA=qAAHA˙A(AA
AffAffA
=AA
AffA=qAЏ\A{AϙAУAffAAGȀ\AzAApApAϮA(AУAHA
=A
=AϙAϙAzAApAЏ\AϙAAυA(AυAAAHAΏ\A{A(AυA(AHAQA
AA(AGA{Aԏ\AәA=qA  AAхAѮAхAGAљA{AAA33ApAQA
=ApAљAzA{A  AAzA\)ApA\)AAGA
=AυAGAAΏ\AΏ\ApAffA=qA  AУAЏ\A
=AϮAA\)AЏ\AA\)A
A  AѮAffA\)A
A  AQAffAԸRAAՅAHAAԏ\A(AApAՅAQAffAA\)AA{A  A  A{A(AՅA
Aԏ\Aԏ\A{AԸRA
=A
=ApAApA
AA{A=qAzA֏\AָRA֏\AAAAHAָRAָRAָRAָRAffAQAzAAzA{A
A=qA{AA  Aҏ\AҸRAzA=qAAffApA33AϮA=qAffApAиRA
AA33AffApAхA{A\)A{A=qAHAAљAAAҏ\AAGAA=qAхAљAHA=qAffAԣAffAHAՅA(AָRA  AA\)A(A؏\AAzAHAA33AQAAA{AمAzA{AA(A
A  AمAծAA(AA؏\A֏\AA=qAAأAՙA(AGA33A=qAAׅAGAA33AׅAffAәAՙAԸRAՅA33AәAәA
ApAӮAAA33AGA
=AHAAиRAHAzAzA
=AAA\)AңAAHAЏ\A33AиRApAA\)AӮAәAAQAԏ\AzA{A(AffAAHAHAԸRA\)AGA33A33AGAAAAA(A(A(A֏\AָRAָRAHAffA=qA֏\AzA֏\AffA=qAՅApA\)AAԣAԸRAzAzAԏ\A=qA  AAHAQA{A(A{AAхA
ApAљA\)A\)AхAљA
AѮAAѮAAAAA
=AHAAиRAУAиRAУAЏ\AAA
A(A=qA(AQA{AQA(A
AϮAυAϮAϙAυAυAA(AzAЏ\AУAQA=qA{A{A  A{AQA{A  AApA33AHAϙAЏ\A=qAGAхAzAffA  AAУAQA=qA  AAѮAхAЏ\AУAffA
AΏ\AAΣAΣAAΏ\ẠAA
=A͙A
=AAffA33AzAzA
AzA  AffA  AϮA\)AA͙AAɮAzA33AHA(ẠA33AGAɅAȣA
=AGAA=qAffA=qA  A  A\)A\)AA\)A=qAʣA
=A˙A
A˙AzA(AGAAQAʏ\A  AAɮApAffA(AAAA(AGA˙AˮAˮApAAffAA
A\)A{AAGAzAхA(A\)AυA{AffA=qAЏ\A{A
ẠA˅A˙A{A\)AA
AA=qAAAGAAͅAȀ\A{A{AA
A=qAAΏ\AΣAGAAAϙAϙAAθRAΏ\AθRAffAQAAͮA
=A=qA˙AGAGA̸RAzAzȀ\A33Aʏ\Aȏ\AŅAĸRAAHA
=AffAϙAQAQAǙAAGA33AθRAA̸RẠAAͮAffAzAffAffAzẠAA˅AHAHAʏ\ApAQA˙AffAAʸRAGA{A{AA(A
AΣAAΏ\AͅAθRAGAAϮA=qA{A(A
=AHAA=qAυA=qA\)AGA
AQAA\)AAθRAAA  A\)A  A=qA{A(AAApAΏ\AzAʏ\AAA=qA\)AAAɮA=qAApA
=AGA{AQA=qA\)A  Ȁ\A\)A(AA  A
AQAHA
=AʸRAAAHA
AQA̸RA˙AQA
=A
=A͙AzAGAQA(A\)AAљAAAA  A{A33ApA
AٮAGAՙAԏ\AffAՙAԏ\AAӮA33AңAzAffAәA
A\)AәA
A33A33AϮAΣA33AθRAΣAzAЏ\AHA  A
A
AϮA  ApA\)AΣAzAΣA
=A͙A  AϙAиRApAA\)A  A(AQA=qAϮA33AʣA(A33A{ApA33AffAȏ\A
=AffAAʏ\A˅A=qAzAAA
AʸRA(A˙AHAȀ\A(A(AAиRAGAхAAхAљAѮA{A
=AA(AzAGAәA  A{A{A  AӅAQApA
AHAzAAәAGAAGAGA=qAAAzAGAхAљA(AA\)AѮA33AQA͙AA
=AzẠA{A33A(Aʏ\AGAAzAȸRA33AA
=AɮAɮA{Aʏ\AɮAHAȣA(A  Aȏ\A{A{AȸRA=qAffA  AHA=qAzA
ApAřAřAAHAAď\AĸRA(A¸RA
AffA
=A\AAA33A(A
A\)ARAAQAAApAzAApAA  AA
AAAA\AA{A\A\)AA{AA33A33A
=A  AAAzAAA
AAAffA  A\AffAGA
=A33A\AAA  AA=qA(AAzARA=qARAAA
AApAApA
AAQAAGA\)AQAA
A  A=qAA
AA(AzA
A\A
=AzA=qA  A=qA\)AGAA{A\A
=AA(AQAA\AA33A  ARAAA  A{A
AAAApAARAGAAA
A  AA=qA\)AAA33AAHAA{AzA{AARAAGAGAffA=qA=qA\AA\AAzAAAA
=A{AQARA(AApAARAA\)A(AAAA33A\AffA\A\)ARAffAzA{AA  A(AA\)AA  AA\)AQA=qA\AAAA{AApA
A{AffA{ApA33A\A=qA\AApAAA\)AAAffA=qA{A  AHAAGApAA=qAA  A(A¸RAŮA{AģA
AffAŅApAzAAQA{A\)AffA\)AAzAA  AAAffAAAAHAzAQAîAÙA(AQA
=AAAAHA(A=qA(AQAGA\)AGARAA
=AAAQAzAAA
=A\)ApAA\AffA\AHAAÅA
=AHA  A\AA=qA\)AAÙA=qA¸RAGApAÙA33A
ApAA(AAƸRA
AGAzAÙAffAffAîA\A(A  AAAHAĸRAA=qAHAǅAAǙAǅAřAAȸRA=qAŮA
=AAAĸRAQA(AA
AAŮAA33A
AȸRAɮAzA
AA  AGA33AAAHAŅAŅA(A{AffAǅAƣAƣA
=A=qAƣA=qA{AƣAffAƣAAƸRAQA=qAzAGAĸRA
=AAHAŮAÙA\)A(AAîA33A  AA\)AffAffA  ARA\A
=ApAQAARApAzA
AQA
AffARA(AARAGAGAffAffA(AQA(AA=qAzAAA
A
ARAGAzAzAAA=qAQAGARAzA=qAApAA  AAHA=qA{A\ARA=qAffA=qAzAAzAAzA
=AGARA\A  AAAffAAHAzA\AHARA33AHARAA(AAA
AAGAAARA\A=qAARAQAQAA\)A=qA\A=qA
AAAGAAA33AAzAA(AGA=qA
=A{AffA=qA(A  AA
=A
A=qAQAGARAAAGAAAAAffA
=AA{A(AzApAA33A
AAA{AGARAA  ApAzAAAQA=qAAApAAA=qAQAAzAQA\AAA{AA(AApA
=AA\ARAGAHAzAAAAAAAA33ARA(A(ApA\)AAAA33AAffAA=qA=qA\AAGA=qA(AzAAAAA  A\AA{ApAffA{ARARAA
AffAA(AffA\)A(AAAA(AffAA33A33AAGAAAA(AARAGApAA{AA(A
=A\)A\)AAHAAA
A  A  AA\A33AA(AÙAA=qA  A  AzA
AQA
=AzAřApAA(AQA\AAAQA
=AAAAGAffAA\AA{A\)AARAAHA(AARA
A=qAQAAAzAĸRAAřAď\A=qAřAĸRAGAģAAA  AQAAffA33AQAzAzAAA
AAÅAď\AřA33AA(AřA
AffA{A{A33A33AȣA{AGAAA
=AHApAAQAřAA(AAAHA  A=qAzAɮA(AffAAAA\)A=qA
AA(Ȁ\A̸RA̸RAGA=qA(AA
A33ApA=qA=qAGAA
AA33A\)ApA  AȸRAȣAǙApAƏ\A
=AǙAǙAǙA=qAɅAGAʣAAApAzAʏ\AA{A  AA\)AAɅAǙAAGAffAGA\)A\)A33AǅApAƣAƸRAGAAǮA=qAǅAŅAzAGAAzAAɮAzA33ApA33AffȀ\AAHA33A33Ȁ\A
=AA
AHAAAɮAɮAffA
=AAQA
=AQA\)A(A(AȸRAGAɮA  AʸRAQAʏ\AɅA{AQAǅAAƣAffA{A\)AAAǙA(AHA  A\)A  AAȣAffA\)AAHA  AɅApAȏ\A=qA=qA=qA  AȣAzAAAAQAzA=qAA=qAȏ\AAAQAGAGAffAAzAď\AǅA\)A\)AʸRA33A{AƸRAHAřA
A(AffAffA\)AǙAƸRAAA{A
A(A\)AGAAAAffAHA33AAzAApARA=qAA33AA=qA33AQAGA{AzApB=qB pARBzBGBQAGB\B(A{BHB
=B ffB pBzAA  A
AzAffA=qAffA
=A33AffAQAA
=AAAAAAHA33AARAzAAAAAA
BBpBHB\B AA(AB {AGB pAAAAAA  AGAffA\)AAHAAffAQA
=AHAQA  AffAGA(A
AAA=qAQAffAA\)B B RBB
=B
AGBBAGA{AB33B
=AB\)A  BA{ApA(ABGBHB\)B	=qBB	
=BB	(BBQBpBHBQB BBBffBB\)BBQBGA
=AQA
B BB\B\)BB	B	=qB
B
BzB	=qB	QB
=B{BBGB {A\)B
BGBffB
=B33BB\BffBB  B\B(B33B  A\ApAzA
=AHA(AAAGAHA33ApB   A{A{A=qAA33A\)ApB\)B
=BB\BB\B33BpBRBHBBRB\)BBBBA
B=qBffBGAzBBBHBRAAARBBRBB  B pB BAHAffBpA
=A\B   BRBffB33BB\BpBpBB=qB\BB(BBGB 33AB   BBBB33B\)B  BpBQBBBpB AA33A\)AAQA  AffA
A33ApAzAApAQA
=A\A
=AAzAB BB QBffBBBB\)B
B33BHB
BBQB\)B  B33BpB33B
BBB B=qBQB{BBzBBB(BzBpBpB\)BB  BBffBBBB\BB{B HB{AApA33BpB=qB BBB
=BBRB(BB\)B\)BBBB(BBBRBzA(AffA=qB   B\)B(BGB   AA33AGARA(AAffAQA
=AA{A  AzAAAzAHAGARAA  A=qA
AHA{AffB =qB \BHBAB GApBBBB33B{AGBB=qBBBBB
B=qBB(B QBB 
B33ApAAzAB 
=B B33AA
=AzAB HB AABGB\BQB(BQB33BBApAAAB
=BB=qA{AAAGAA{AQA\)AAGARA=qAQARA\A(AApA  AHA  A\A
AQAAzA
AzARAA\)A\A=qA=qAffARA
=ApApApA\A\)A홚A{AARB (A
A
B(B B
B
=BBBpB=qBB(B   A=qA\)B 33AAApA  AffAzB zB ffBGBBffB HBBAGBB=qB BBB33BHBB(BzBRB(BBffABzBQB QB ffB HAABBQB B B A
AAAApB\)B 33BBBB B  BB\)B  BffBGBQBBB(B(BB A=qAQBRB=qBHB=qB
B	zB

=B
B
\B
B{BB	B
B{B
=B33BBRB=qB  B  BBBBB\)BpB\BzBQBpBB\B
GBpB\)BpBBB
  BBHBBQB{BzB pB
(B
=AHB
B
=BRBpB
B
B
B	  B	GB(B RB
B{B(BB=qBB=qB{BB  BRBBBGBBB  B{B{B=qB=qB  B=qB(B  BB33BB\BBGBffB(B ABBB  BffBB{BBffB	(B

=B
(B

=B
BRB	ffBQBBB	{BzB=qB
{B
B	\B	B	\B
  B	zB	BBBzBB
pBpB=qBQBBQBB
BpB

B(B
BB=qBRBBBB
B	=qBB	QB
B
B	B
B
QB
B
BBBffBHBzBzB{AB AB\B zA33ApB {B=qBBpBB(B\)B\BBB
=BzBBffBBBRB
B AQBBzBBBBQB\BBBB{B
=B	
=B\)BQBRBzBffBBQB	HB
=BffBB33BGB
BBBB	ffBpB\B  BBGB{BB	33BHB	\)B	zB
=BBpB
RBGBBQB
pB
\B
HBBB
=B\B A
=B ABBBpB=qB
BQB\)B	=qBpB

=B	BRB	GB\)B	B	\B
  B	B	B	HB	B	B	B	RB	QBBQB=qBBBBBBB  BBRB
BpBpB
=B
=BBB
  B	B	(B	ffBB
B	HB
GB	HB
pB	\BB	
BBB	B	HB	
B	RB	
=B	pBHB
{BB
B
zB{B
BQBHB
\B(BffB
GB{B	{BBpB
pBBGBB	RB

=B	{BQB	B
  B	B	HBB	
=B(B\)B{BGBB=qBBHB	
=BBRBBBpBGB(B{B{B(BHBRB  B\)BpBBBA  AAA
AABB{BBQB
=BffBBGBB=qBQB  B33BBBpB=qB
=BQB
BBBBBQB	  BRBBBRBBBzB	B	  BB	{B	(BB	{B	(B	33BB	=qB	33B	(B
BRB\)BzBQBGAB\)A
B\BzB=qBQBzBB33B{BBBB=qB \)A{A=qAAAB 
=BB{B  BffBHB33B\)B\BzBB B RA
=AAA(A\)AzAffA\A{AGA
A
AָRAB A
AB =qAB=qBBGB
B=qB
=BGBBB33B
BffABHB(B
B   BB{BzBGB=qBB 
ApA
AHAB
=BA33B 33B B 
BzB(BpB{BBA  BzB=qBBB{B33BHB\)B
BBffB\A
=B\AzAAAHAGAQAA  A(AAAGAzA\)A\A  A{ApA\A\A{A
AffAA\AAAAzA(AGA33A
=AAzA{B
BB
=BQBBQBB
=BBffBRBpBBB(B
=B33BBHBAGBAARB\)B BGB\BGBBBQBRBBQBBBGBzB  BQBBA\)BB ffB {AB zBHBpB=qBHBpBGB\)BB
=BB\BRB=qBBQBRB \A
=AB (B zBpBB
B  BRBHBB\)B\B33B HB 33B AHAB pAAB 
=A33A\AA33ARA(A
AAzA33BffB{B HBHBB=qB
BzBB
=B{AB 
BBB =qBzB{B\B
BzBBzBffB B B{B\BBB  B
=B HBQB\)BQBzBB{B{BffBBzBBBBB\BzBHBffBzBpBBRBHBzBffBBQB RAAAGAGA
=B
=B(BBB\)BB
=BBB\)BBBB
=BB(A\)A33BB B 
=AGAAA(AHAB pB \)BzB=qB(BAAӮABQA
B\)AABRAffBB33BzBBB
BBB
=A33ABBGBBB{A
=B ARB{B 
A
=BB{BBzB=qB=qB
B\BHBQB\)BffBBGBB\)BBHBHBB
B(AApBGA33A{AHA
AHA  ApAA
AA33B\)B\BpBBzBB
AARA=qAB =qAA33B QB zAAApAzA{AHApA(A33AARAGAQAA\)AffAAQA
B \BGBHBBB{B(BffBBB{BBBQBzB\)B(BHBB  B\B GB (B B
ABAB \)BBffB=qBQBHAABffBBzBB{BRB
BpBA\BB
=AAA(A  AAAA홚A(AAAAAffA\AzA
=ARA  AAA\A33AAAAAA33B   B GBAABBBpBBBQB
BQB\)BBAAAzAHAB HBA=qAGAffA\)AA؏\AAAAA=qApAGAARA\)AffAAzA=qAAHApAffAAB \B
=AGAA
=AA{A
=A=qA33AzAffA  A
A{A\)A
=B BBBBBGAHB A=qAA\AA\)AGA33AAARA{A33A{AAA(AAA\)A=qA  A
AAffA
A\B
=BGB{BGB33B{BB(BRAB{BBHBGBGBB\)BffBB
=BffBB zB33B=qB
BGB33B\)B{BBB=qB  B
=BHAB BHBpB\)B
B33BBGBHBBpBGBB  BzBB=qBBQBBB
BHBBBBB
=A\)B pA=qAA(A
=A33A
=A33AHA{ARAAAAQAzAAAHAA33A\AGA
A33A  A\AA\)A33AGAQARAAffAA  AffA(A\)B QB RB =qBGARAB \)B  B{BAffBA\)B 
B 
AB33B\B  B
=B33B\)BBRB33BBBB   BHBBB\)BB\)BRB	  B	{B
B	GBB
zBzBBBGBffBpBB
=B
B	QB	B
  B	GB	\)B	\B	QB33B\B	B=qB33BB\BGB\)B
BGBQBBzB  BRBBBBB\)BpB
BB  B\)BpBpBffBzBffBQBffBB
=B{BB33BB33BBQBB\)BRB	GB	B	zB	33B	33B	QB	
=BBzB\BBB	(B	B	\B	B	
B	RBB33BB\BB	{B	(BBB  BQBHB(BffBB\BBB=qB\)BBBBB	QB	\)BBQB
BB\BHBzB  BffB=qB33B{B=qBGBffBBB  BBBpB\B
B
B=qBBB
BHBBBBBRBpBBRB
BBBHBB
=BpB
=BB\)BBffBBHB
=BGB
=BHBHB\BGBQBBB\B{BzBGBB(BHBffBBB=qBffBB\)B(B  BQB
B(B  B
B
BRBRBBBBB
=BQB B BB AHARA\)B A=qBBRB
BA\)BpB\)B33BB33BQBAAHA33B RA\)AAA
ABBBpB\)B\)BHBBBBB=qBB{B{BRBBBGBB\)BffBB
BffBQB\BRB
=BzB\)BBQB\)BB
BHB
BBBBffB\)B33B\)BBGB{BBBBBB
BB  B
=BBB  BBB=qBBpBBBHB  B{BBGBQBffBffBQBGBGB=qB\BBBBQB(BGBBQBpBBGBBBffBBB(BBRBB  B33BzBHBffB
=BQBBBB33B{B{B{B{B33BQBffBzBzBB\BBBBBB
B
B
B
BBBBBBBBB  BBB33BGB\)BffBBBffBzB\)B33BB(B{B  B  BBB
BBBzB\B
BB	
=B	{B	B	(B	(B	B	=qB	33B	=qB	(B	(BBBBB33B
BGB=qB\B\)BBBBBB\)BGBB\BBRB\)BBRBBBpB\BHB33B\)BBBHBHBB\)BBRB\BBBB	zB	\B	=qB	B	HB	
B	
B	B	
B	B
  B
  B

=B
B
B
B	RB	
B	33B	  BBHBRBBzB(BB  BBBHB(BzBBzBBBBHBBBBzBB
BBB{AB\B=qB
B  B\BBBffBzBBQB{B
=BffBzB pB  BABAB
=B33BGB33BBB B zBAAzBQB33BB33BBBBBB
=BBB{B  B(B
=B33BpBRBB(BGB\)BzBBRBBBBB\BpB33B(BBBzB
BBzBRBBBRBBAGB BGB33B(BGBGBQBzB33BzB(AAB=qBBBBBBQB{BHAGBpBB
BB  BB AAzAA{A=qAAA
=AHAAB (AQB BQBBpBB zB ffA
A
=BB BpBB
BBB\BB\)BBB(BBB
BzBB\)BBQBzBzBB
=B\BRBBBBffB\BB
=BB  B  BQBpBBB	BQBB
BRBQB  B
=BBBHBGBAA(B{ABBHA(AB AA(B BA{AB\)B
=BQB  BBHBpBpB
=BB
=BpB\BpB
=BffBpB\AB33BBB
BBHBBHBB(B33B BB
BpBpB(BpB  BBBRBBRBBzBBzBBBBpBHBpBQB
=BHB\B
B=qBRBQBB	pB	B
B
ffB
RBB
ApAB BBBBBRBBBB   AGAB 33BBpBB HA=qApB
BBBBffB
=BB\)AB B \)B\)BBQBBBffB  BzBQB BB =qA
=AA
=AB 
=B(B{BHB(ApB RA(AB\B{A\)BGBGBGB
BB(BQB\)B=qB  BpB
BB(BB\BBHBBB(BQBpBQBHB=qB\B
=BBzB	B	QBQBQBHB
=B=qAAB AApABBQB=qBBBB\BHBAAQAB(B\)B=qBGB GA  AA33ABB=qB\BB33B
=B  BGBRBB33BB  B{B=qBBpB RA  B =qBRBBBB
B33B=qBBB  AGB\)B33BQBQBB33BBffA(B\B
=BB=qBHBB (A
BffBffB(BBBB{BzB\)BBBGBB\BBB
B  B\BffB  BBBzBBBQBpBBB  BzB
BRB{BBBBHBARAA\)AAA\)AAA\AAA=qAA
A
AA
=AGAAAffAA33A\AA
=A
A\)AA  A{AAAB 33B GBB{B A(A
=BBBBBB
BBffBBRBB \)A
B GAB 
B BBB\)B BB  BffB33BBRBQBBBBpBB{B	BB\)BHBBGBAffBHBBzBB
=B
=AB
=AA  AAAAAA(A(A\AzA
=AQAAAAA{AGAAAGA33AAAffAAAffA\AAffB \)AQAARA
=B
B A\B A(AAA\)AA\A  AA{AB ffB33B
BBRBQBpB\BpB(BpBBB=qB{A\)B\B(B RBB RB BB{BB
=B
=B
=BRBBB
=BRB{BHB{BBzB
=B	  BB\B33BB(B
BB 33A(A\)AA\A  AQA
AffApAA
=A(AA33AzAAA  AAAARA
=AA33AAA\AAzAA  A(A  AARA=qB B RAGAQB
=BBBBpA=qAHB(BGB{A
B\)BHBBBGBBQBffBBBBB
A
=B QB
=B {A\)B BB\)BB  BpBffBBzBQB
=BBHBB(BB=qB  B33B
BpBBBBpB  B(BB33BGB A(ApB   AB (B B GAzAQAAAHA=qAAB (B 33B pBRB B \B 
AGAARAAB zAA\AB (A
B ffB 33B (B B =qAAzAA=qAA=qAA
=AQAffA33AHA\AAAQA  AGAA{AA=qApAAAA{AA\AAHAA\AA  AAB zAB (B B B33B\BQAAAAAffB zB{BQBB\)B\BB  AAA33ApAAAAzApAAzApAA
A\)A
AHAA홚A(A\)A
AAAApAA{AApAAAGAARAAAA{AAAApAAAAA
AGA33A  AGAAHAAA
=ARAHAAAA33A
A{AAAA
=AᙚAAQAAAA33AA{ApAHA  A\ARAzA=qApA33AAzAA
=AۮAQA(AAHAA{A33AzA{A  A=qA\)AffAffA
=A(A
AAHA33AA(A{AAAӅAA
=AA
=AA(A\)AzAzAAApA(AzApAAffA\A{A  A  AHAA  AAffAzA
A\A
AA{AAAHA  A  AGAAAARA  AA(AGAAA33A
AApAAffAA\)A(AHAQA{A33AA(A\AAAQA(ApA\AHAQA(A(A߮AAAffA{AA(AA{A
=AQAޣA߅AGAA=qAA33AAAffA  A33AAGAA\)A  AA\)A\)ApAzApAA  A
=AHAQAA33A\)A܏\AمAA\)AA  A{A  AAA
=AAzAHA\A33ApAAޣA܏\AGAΣAffA  AApAA\AHA
A\)AzAffA\A{A
=A(AA\AAAAA{AA\ARAQA\AA\AA  A
=AAAAAA\A33AHAAA
=A
ApAHA=qAAA\)A{AffA\)AffA\)A
=ApApA
AAA\A33ApAA\A
A  AB=qB=qB {ARAHB   B pB\BB
=BB=qBBBffB{BBBB
BB\B  BBQBBBHB B   A33AAQAAAA=qAffAAAAB \BQBQBBB(B  BffBBzBzB QB pAAB HBGBpB\)BBB B33A\)ApAA\)B GBBB RA\AB A(AffA
=A
=AAzAGA\)AA  B (B QA
=ABB  BGB 
=BGBzB33BBB{BB{BBBpBBB{BB  BzB  B
=BGBBHB	  B\B\BB	{B\B33BB
AffB B BffBB{BBzB	HB
GB
=qB

=B
33BzB	pB
BpB
BpB\B  BBBBBzB\)B
=ARARAHBBzBB (BzB\B\)B
=B\B\BBBBBHBQBA(A
=AGARB 
=AB B(BzBB
=B
=B  BA{BABB{BBB33B{B
BB=qBB  B33BBBBBBQB{BHBpB\)B	B
GB
B
(B	BB{B	BB
=BQBffBB{B33B \B zBGBBBBzBBBBBB
=A\AB
B{B(BBQB{ARAffB 
BQB\)B
B=qBffB BBzB B{ApA
=AQA33AffA
AA33A{AzBBBRBA=qB
B{BBBBGAffA\)AGB BB \)A{AA
BB33B
BBB  BB
BzB=qBB{BBRBBHBBBffBGBHB
BRBGBBffBffB(ABB zB BAGAA
BAAAQA=qA\)AQAzBAAAffA{AAARAAA
=A  AGAzBBB\)B33BpBBRBB33BGBRBGBffBBQB\BB   AB B BB \)A{BBBRBffBB\BB
BAGAGAB 
=B B=qBB  BzBBQBGBHB33BBpBB33BBBBBGBpB=qBGBBBB33BHBBBHB
BBGBBQB=qB\)B(BBHBffB QB QAAAB B HB\B BBB B{BBBffBB33BB{B33B33BB
B\BB  B
B\BGB{BB33BBGBBQBffB\BBzBGBpBHBB=qB
BBffBBB\)B=qB{BB
BQBBzB\BGBB
=B{B\)B\)B
=BBzBBGB{BBB \)B=qB AB AAB pB =qB(B RB\)A  AAGBA\)B AB {A  B \)AGAffA(A{AABQB B ffAA
=AA33AGA{AQA{A{AQA33ApA  AAAAA
=AzAHAAAApAAzA(AGAAA\)AQA
=AHA(AHA
=A{A33AAAA
A  AAAA\)AAzAffAA33A
=ApAGAB \B {AB \)B =qB =qAAQAA\)A
ARAAA{ABzB\BB\)B(BBB=qBB\)BBBB B {B BHBpBRA\)B pBBHBBB(B B 33B33B
=BQBBRBffBB  BBHB=qBBRB33BBBGB  BBBBHBB{BB  BRB\)B33BHBB{BHBGB(BB
=B\)B33BRB\B\)BGB\BzBGBBHBBpBBBpB=qB
BHB  BRBBBzBpBffBpBGBGB  BB\BffBpBQB=qBQBpB\)BB\B{BpBBBB\BHB\)BRBzBB(B
BHBBRBBRB\BBffAA(A\A\A(AAA=qAGA  A\AzAAA(AAA(A33A\)AzAffA(A=qA(AzAQAA=qAGAA33AAGAAQA\AffA
=AظRAffAҏ\AHA
AA  ARAzAߙAA{AA\)AARAQApAAA
A(AGAA
ApAffA  A{A
=AHA  A
ApAQAأApAA=qA=qA33A  A(AA(A
=AAA
=AHA=qAAHA=qA\A̸RA=qA噚AGAծA33A(AHApA(A{AA
=AQA˙A(AƏ\AʣAď\A{AGAΏ\AzAǙA(AAAAHA33A=qA{AA{AAzA33AݙAAQAGA߮AAffAffAA33AAAQAA(AAA33AARAAffAffA噚A  A
AGAA\AQARARA=qA
=AAGA(AAAQAA  A  AAA33A\)A  AAHAA\A33A
=AŮAGA
=AߙA
ApApA  A  AA
AzA
=AAAQA{AA܏\Aҏ\A\)AA֏\A
=Ȁ\AӅAA˅AQAHA\)AׅA=qAffAA=qApAGARAQAGAA  AA(AAAAQA
=ApA\A{A33AA{AAffAAAAzAA{AأA  AQA֏\AمA(AzAAAAQA=qA(AAA33AHAAGA\A(A\AzAAzAיA
AffAAAHAޏ\AAߙAHA݅A33Aޏ\AffA\)ApAA=qApA{A{AAAQAAиRAzAǮAAQA=qA\A癚AApAHApAHAGA33AQAzAAHA(AffAGA  A܏\AQAHAzAQAHA
=AA
AApA33AA{AAzA܏\AQAA\)AAA
A(ApA  A  A
AAAAᙚB pAffAABB RAB\)AA=qAzAQB   AAAffAA\ARAARAQA\AAQAzAA  AᙚApAA(AAAAHA߅A{A
AA܏\A܏\A܏\AffAA  A(AA{AA=qAA\)A㙚A{AAA\)A(AARAA
=AAA{AzAAAzAA33A=qA
=A  AAA(A
=A
=A
=AzA\)A=qAHAAAHA=qAHA
=AA  AGAAAffAHAAzAA\A(ApARAGA\AApApA{A\B AAHAApApA\)AAAffApAHAB33B  AARAHAffAAGB33BffBGBpABGAAHBAAA(AHAA{AzA
BA  AA\)AHA  AGAAAAA{ApAΣA33AA=qAzAAQAA=qAAAAAAA{AzAffAffApAәAAAŅAAAzAARA
=AHAHA(AޣAGAՙA  AAAͅAA  AAQA{ApAAHAڏ\A(A  AAA{AѮAAظRAA33A(AAAA
A=qA  AzAAApAQA  AA\ARAffARAzAAApAA=qA\)AA(A33AHA
=A  AAAAA
=A˙AzA{A{AA
=AGAffAAGA{AHAGẠA\)AGARA
=AzA=qA{AQAģA=qA
AQA=qAAAA=qAA  A
=AzAA
A(A{AQApAAGAA(A  AAA{AAHA{AzA33AffAAARA=qA{AA
=A{AApAAffA\)AA  AffAAn=qA~HAA{AA  As
ARAzAo33AAffAAjffAuARAHAA  AA33AA{A  AA
AAAAHARAAzAAQApAA{AϙAA\)A(AQA\A\AQAAAAAffA\AGAApAAA
AQA{A=qA  AA33A33AffApAAffA
AAAHAA
=AA
A  AA\A\A{A\AA  AffAA  A(A
=AGAAA\A\ARA\)AQA\A  AAQARA{AA  AA
AzAAHA
AGAřAAAHAAΣAAA
=ApAA(AA
AQAQARARA\)A\AffA(A(AffA{AQAffAAHAHA\A{AAGAA  AAApARAAA
AA33A(AffAzAHA£A(AQA(AApAAAA  A
=AHAhAo
=Ag33AhAeAGAA(A=qAqAyAc\)AL  A7
A;
AG\)AL  AH  AF=qAAh(AIAVffAaAMAIA@  A>HAIGA5A/
=AC\)A2HA<A{AOAJ\ASAUATzAMAp(AbHAOA[
=AO33ASA^HASA^=qAhzAv=qA\AAQA
=A
=AA(A  AA33AGAzAAffAAmGAV\AWAVffASAO33AL(AO33AS
AUAO33AXAO
=AJffAJ{ADA=GA8A9A0  A,QA2\A"{A A(  A'33A (A!A.\AARA3
A;A7
=AHAHA
=A  A"=qA#
=A%pAGA
RApA\)A{AzA=qA   @@  @p@  @G@z@AQA#
AzA	p@AGA
{AA(AA)A$(A$  A((A$AA4AO
AEA*\A2ffAAGAQA	AA  A
=qA,(AS
=AZ{AipArHA{33AA
A\A  AAA
AAffAAHAzA33A(AA~=qAvHAA33AA{A(AGAyGAzRA
AAHAApA(AHA  A{AHApAffAGA|A33AQAA\)AQAAHARA
=ApAA{A
A(AtA`AiAuAk
AkAaAZffAl  AdAWAqAuAx  ApA(Ad(AA  AAr{ARAApAAffAQAAHAQA(ApApAAGAA
=AHAAAzAzAA=qA
AAA=qA{A(A
=AHAHAGA(AAAGA\AA=qA{A\)AAffAAA  AAzA{AA{AGA33A  AzAzAŮAA\A  A=qA\ARAGA=qARAzA=qAA=qARA  AAAAQA(A(AApAAzAGAzA=qAHApAA{AA\)AGA{AA\)AA=qAAAA  AϮAzAzAAA
ARA{AzA=qAHAzAffȀ\A\)A
A=qAAՅA\)A  AAAхApA(AAQAffAУAՙAGApAAÅAAƣAǮA=qARAQA=qAHAffA33AѮAffAĸRAAAA{AAGApAA
=AA\)AA\)AHAAƏ\A\)AA
A=qA(A33AApA=qAȣAA{AQAGAۅA\)AffA
A  AffAAA(A{AAGA(ApAA
AGAAAffAQAffA
=AA陚AA33AA=qA\AAHApAHA33AAzA  AffAARAAQAzA\A\)ARApAA33AA33AGAA
A\AA  B zAAAzAAA\AffA(A\)AzAGAAA(A=qAAAQAzBRBQBQB=qBBpB  B=qAAHAffA\ApA=qAABQAA
BBQA\B QAAABffAffB AHAHBB(ApA\)B \ABA(AGBRB \)B(BBHB\B{BB
=BBBQB{BHB\B\)B
=B=qAABA
AB =qABRB B(BB=qB=qB
=B pABpBA
=B{B B
=B33B GAAA\)AA(A  A(AڣAAA  AAGA(A33A\A
=A  AA{AمA33AGAمAAAޏ\ApAAAAGA=qAA
=AAB {B B B   B GApARAA
AGA\A(A\)A
=AQAQAA֣ApA
=AAAffA\)A33AAApA{A
=AQAA=qA\)AQAB GB  ApA=qB pA
=ABHA\)BA{AzAQAzA33A뙚A  AzAffA(A\)AAA{A\)A
=AAA=qAQAA{AAAzAzA33ApAzAGAأA=qAəA\)A(AGAGAGAAԏ\A  AQAAQA33AffAAٙAAυAԏ\AAHAffA
A\AzAAA(AAGA=qA\)ARA  AQA\)AAʸRAAQAHAAGAA33AAљA
=A
=AffAA(A
=AÙA(AA\)AָRAA{AQAA
A
AAߙARA  AA(A
=ARAޣAHAޣAAzAޣAAծApA(Ȁ\AGA\)AApA
A=qA
AAď\AAAA
=AɅA=qAЏ\AƸRAAģA  AffAAA{ARAԸRA͙AAffAAA  AAA  ApA
ARAQA33A  AAA
=A(AAA\)A=qAARAAQAAAAA\)A  AGAGA  AHAAAHA\)AA
A{Aď\A  A33AzAǅA  AA
=AӅAA(A\)A33A(AA
=A=qApA  A݅A(AzAHA(AAA\A  AA  AAHAA{AzAəAHA(A  A33AAffAAAGA\AQA
AθRA33A\)A(ApAzAGApAQA
=A=qAA{A£A  AHAAAGAظRAAGA  ApAɮA£AՅA=qA  Aڏ\AA
=AzApA  A
A\)AHA33AAHAۅA(A  AGAӮA
ARAA
=Aҏ\AGAAzA
AzA  AA=qAAzA=qAəApA
A  AHAAAAƏ\A
=AA̸RAA
=AAHAAAzAA33A{AA  AffAAApAQAŅA¸RAQAGA\AģAŮA
=AffAAAA=qA{A=qAHA{AGA
A
ApAGAHA\AffAAQA\AHAffAQAGAA
=A
=AAGAQAڣA  AݮAzA߮A  AəA=qA\)AA=qApA
=A(AAA㙚AHA\AأAzApApAAQAQARA=qAߙA{AAApAffAffAA\)AQA33AAA{A
A\)A  A\AAʣAAAď\AzA{ApA\)AHAAAARAApAA\)A(A{AHAHAzAQAffAՙAٙApAQA\)A  AA\)AAAAGA
A\A
=A\AHAA\)AApA
AAA
AAAAAQA33AA\)A
AGAAffAHAݮApAGAAAAA{AAHA(ApAQApAA=qA  AAffAQA=qAA{A(AGAٮAA(Aʏ\AA
=A=qA\)A  A\)AϙA  AGA
=AA
=AУAzAQApApA
A\)A{A=qA33AzAQAQAffA
AGAQAAA
AQAffAHA  AAᙚAԣAҸRA
=AARA\)AQA
A  A
=AA߮AA33A=qA
=A33A
=AAA(ARApA㙚A  ApAՙAAAA
=AA=qAۮAمA{AAمAHA
ApA=qAݙAzA
=A뙚A\AApA=qA=qAAA\)A\)A
=A  AGApA\)A\AHA㙚AׅAApAA
=ApAAffAԣA  AƣAzA
AHApA\A{ApAAHApAHAAzA33AA홚A
=AQAffAHARAAzA33AffAzA33AߙAAffA  A{AGAGAׅAڸRAޣAHAAAffA  A
AGAAAۙApA\)A{A(A噚A
A(AGAffA陚AܣApA\)AָRAAzAA
=AAA߮AffA˅AңA\)AzAңAˮAA\)A\)A  AGAzAAA
AָRA(A\)A33AŮA(AAQA
=AAzARAAA33AGA{AHAAzAzA\A  A(AffAzA  AA
=A33ARA{ApA
=A
A33AAA  AHAAAA{AARAffA{ARA(AAA=qAģẠA{A\)AA  AΏ\A=qAQAffAҸRAԣAAܸRAHAHA噚AA܏\AQAGA
AҸRAffAAAAAAGAffAAA=qAAAHAQA(AŅA
AǅAA{A
=AHA33AffA33AHA33AAA(A=qApA\)A(AA=qA
=AA  A{AzAAQAA\AffAAffAffAQAAApARA\A=qA\)AAAAARA\)AffA\AA33A=qA\AzAHApAQAA
AA  AGAυAˮA(A
A˙A
A(AAřAAHA  AřAA
AzAA\)A{ApAAУAԸRA  AAܣAQA{AA
AzA(AA˅AAAׅAۅA֣AffA
=A  AAHAA
A33A33AA{Aڏ\AffAΣAffAڣAA\)A33AffAzARAA\)AARAGAHARAΏ\AAA\)AAA{ApAA\)A  A  AffAA{AAAA
=AA
AzA=qAA{A33AAzA(AAAAAHAffAzAARAA\)AAffA؏\AծAzAGA33A
ApA\ARAffApAAAAAzA33AGAA33AA33AAAA  AA{AۙAԏ\AGAzA̸RAAAQAA  AAQAA
=AA
A
AApAAHA
=ApA뙚AAAA\)A{A\)A
A  A{A  AARB GAAQAB pA(A
AAAA{A
=A33AA(A=qAzAHARA\ARAQAAQAA33A33AA
=AAAAA=qAA=qB   AHAAHBffBRA
AzAHARA{AzAHB   A
=ApAHAGAzAzAA(A33AQApA޸RA\A\A(A33A\A33AAGA33AzAAA=qA
A  A\AAA홚A{A(ABB A\)AB(A=qB pA33AffAGA\AGB=qB=qBBBB=qB\)BB=qBffBffBB\)B
=BBBffBBB
=B(BBAAQAHAA  A\AAA=qAQA
B  BBffA{BA(AA
AB
=ApAA=qA33AGAzApAA\)A\)AHAHAAA=qA33AAAAQAAzA{AAARA
=AA陚AAA{AAAAۮARAA  A\)AڣAAܣAffAᙚAzA
AHAQA
=A\)A
AzAQA(AA
AGApBpAAAAB 33A
=A=qA\)A=qA\A
=AA{ApAffA  AAHAGAAHAAffAA  AAAA(A\A=qA(AA33ARA(AA
=AAA{AA
AffAffAQAݙAA(AݮApAAffAA33A
AHA{AQAGA=qA㙚AGA
ApAAAAffAA߮AAGA33A=qAݮA\)ApARAA\AAAA  AHAA\A\)AAAA
AAޏ\AAffAA33B zB BQAA  AAHA  A
A=qAffA33ARA{A癚A癚A\)A{AHAzAHA
=A{AQAHAzApBGAGAQAQAApA\)A  A
=AAGA{AAݙAGAzAAQAAAәAGA(A(A33A
=AQA(A  AAHAQA(AffAQA\)A
=AQAA{AffAݙAHAAGAҏ\AԣA݅ApA\)A
A
=A\)AA\A{AApA{A\A\AA\)AA  AGA{AffAAHAA\)AQAAARAAzA
=A
=AAAQAGAA=qAAA陚AQA  AA(A33AAA  AA{A陚A\AAffA\)A=qAAzAzA=qA{AARAQAHAAA
A
AQAԣA=qAߙAݮAzA=qAzAٙA׮A  AffA{AQA
A(AAQAA홚A33AGAAAQAffA{A{A=qA\)A{ARAGA
AGAAAA\)AAGA33AAAAAA33ApAzA(AAGAQAQA(AA33AzAA
=A(A
AQA
AA  ApAAAQAA\)AApA{ARAffA
=A33A\)AA뙚AA  A  AzAA33AHAׅA  AGA  AGApAڣApAۮAffAܣAAۅAAAAЏ\AAʸRA{AQA
=ApA  AᙚA
=AQAAzA(AzApAAHA
AAApAQAAApA=qAAHAA=qAA(AA\)AHApA(AARA=qAffAAA
AAHAA33A\)A\)AzA=qARA33AffAARA
A  AAffA{A=qAAAQA\)ApA33AA\)A  A֣A\)A
=A33AffAffAݙA=qA=qAApAٮAأAAffAәAҸRA(A(AָRAҏ\AGA{ApAΏ\AQAGAffAA\)AA{A
AAAAAARA陚AffApA(AzAAzA{AA=qAAHAA33AAGA\ApAARA
=AA  A\AAAAAAGA  ApAB AA33A\)AffAAAffAGAffAzA33AzA{A  AGA(AAHARAQAA
AHA(A\ARAzAA=qA=qApAA{A
A(AAApA
=A33A\AAAHA  AffA33A\)A33A
=A뙚AAA=qAAAA\)AHAA=qA\A(AABBzB zAAffAAA33B zB \)AAHAAffAGAAffA{A陚A\AffAA=qA陚AffAA{A  A  AĸRAAAAA  AA33A=qAA  AffAA\)A
=A
AAٙA=qA33AzA33AAAARA  A\)A\)A=qA
AA
AffAzA(AzAAARA  AQA33A
AAQAGAAAAGA
AA{A\AA(AAAHAA
AAAAGA
=AA(AÅAHApAzAAA33AHA33AÙA{AffA
=A\)AʣAAƸRA{AAA¸RAǙA
AAƸRAÅA33AA\)AARA\)AÙAәAA  ARA(AQA
=AffAGAAffAǙA
AٮA߅A  A{A  ApA\AA  ARA߮A{A  AHA33A˅AAAAA{A33AffAQAAA
AA
A
=A{AAHAA
AHApAGAѮAGAљAA  AzA֏\A  ApAffAA33AŮAɮA(A\AGAQA
A
=A\AHA(A
A\A  AQA=qAA{AHAffAAQA  AA͙AңAٙA  AAzA(A{AGA  A\)AHA\Aڏ\A\AQA݅AzA=qA33A
AffAۙAAA癚AffAA33AApAAQAAᙚA
=AٮAHA܏\ARAzA  AffAߙA޸RAׅAHA
A=qAAA(AA뙚A\)A=qA=qA޸RAzAAA߅AzA
AۙAۮAffAAٙA33A  A
=ARAݮA33AAAzA33A33AAׅAՙAיA
=A{ApA(A֏\Aڏ\A݅A\)ApAޏ\AQA
=AApA
AA޸RA33A܏\A=qAARA
AApAAAGA{A\)A
=A(AA(AᙚApAffA
=AffA
A
=A܏\A(A\A
=A
=AA(AApA\AffAޏ\AGA33AۮAQA33A=qAzAأAA  AA=qA݅AApAA=qAAAAᙚAGA噚A=qAzA33A=qA(A㙚AAAAAA=qAA
=AQA\)AffARAAffA{AzApAHAAA\)AzAAׅAA
=AAA\A\A{AA
A\AAQA
=A\AhQAb=qAA(AAQA{AQA
AA
=AAA
AA(AAAzA{AA\)ARA
AAffAffAAAAAzAAA
AHA\AGA=qA\A
AAAAzAzAAGA{A\A  AA  ApA
=ApA  A{A
AAHA33A¸RAAHAGAGAQApA
=A(AAHAAzAGA=qAθRA
AʣAAA{AAҸRA{A\AQA\)A
AGA=qAHAGA
AA33AAQAAAAHA(A(AAԸRA(AzA(A
A܏\AHAA
=AAzA=qA܏\ARA\AAQAܣApAӅAڣAHAיAӮA=qAQA  AA=qApAAffA
AAA(Aޏ\A=qAծAzApAAA\A܏\AGAffAAHARAHAAGAGAAܣAGARAA뙚AAffAHAAAA\A
=AAAAAGAAAHAzAzAzA
=AzA(AAA
=AA{AڸRAӅA  AzAHA(A=qAָRAA(AAffA\)AGA\)AA{A33AffAffAңAAљAיAAיA
ARAHAAAAHAA
=AAAA
AAzAAAHAAQA  A\)AAzA=qA(AAzAݙAQAAAAA{A  A=qA  AHAAAA֏\A33A33AAȸRA˙ApApAzAAAAָRAAHAffAAffA{AffAAA=qARA\)A\AAAA  A=qAA  AAzAAQApApAHA  AAAHApAffA=qAAA(AA\AA¸RARA{AAHAЏ\AQAҏ\AQAQAׅAzA33AӮAAApA
A֏\AAأA؏\AA\)A
AffApA=qA=qA(AzAA=qAARAffAϙAՙAׅAAzA
A=qAAGA
AAzAۮA=qAᙚAA(ARA\)AȣAGAffA{AHAA\)A33ẠAƸRA=qAffAѮA׮Aԏ\AظRA
=AHAУẠAHAĸRApAřAHAĸRAQA(AA\)AQA33A=qA33AHAΣAzAAA(AՅA=qA
A
=AڸRAAA33A(A  AA(A{A{AAAQA33AzAAAARAAA\)A(A(A\AApAGAA{A
AхAA  A{AzAۮA  A33AHAAQA߅A=qAGAAˮA܏\A\)A׮AHA33AϙẠAAəA(AυA33A=qAA\AHAծA\)A  AңAzA(AθRAA  AӮA\)A\)A\)A=qAҏ\A{AGAA\A
A(ApA(AQARAA
=AA(A{AAәAՅAՙAA{AٙAffA  A\)A\AA{A33A
A
A׮AApA(AHA׮A(AԣAA
A؏\Aҏ\A{AA
=AAծAzAHAffA
A
AffAAAݮAffA{AθRApAGA{A˙AAȣA
=Aȏ\A(ApA\)A(AQA݅A
AHA\)A
ApAՙAȣAQAΏ\Ȁ\A=qAȣAA
=A
AA  AHAffAAӅAQAzAQAՅAQAمAA
=A=qARAzAA=qAHAARAAA  AffA\)ApA33AAHA{AGA\A  AAzAApApAGAHAᙚAzApARA
=A\AA
A33ARApA  AGA(AA(AQAAAAHAzA
A
AAAGA\)AAAAARA
AffAQA=qAAۮAGA33AHAݙA݅ApA؏\AHAffAҏ\A33A{A
=A֏\A{A{AApAA{ApA(AʣAAAHAGA  A=qA{A\A=qA{A
A
=A
=AGAHAAA
AAA\A
=A\)AHAzA33AAAffAA\)AA噚A\)AAffAAA  A{AHAޏ\A{AHAA33ARA{A\)A
=ApA陚AA{AA(AAA
=AQA\)A
=AffAHAA{AՙAQApAffAzA\)AzA33AӮA  Aҏ\AQAңAӅAAAQA  A33AA
A33A33AƸRAA(A\)A
AУAхA\)A\AQA{AԣA  A\)AѮAAAffAׅAA  A\)AAHAzA߮AHA=qA\)AA\)AAA(AיAGAGA33AffA(AיA{AAأAQAGAA(A\)A
=A(AQAAAAA
=AHAA  AARARA\A޸RAA{A
=AAAAAzAAAAɅAA=qAAѮA{ApAиRA{A
AA  AʸRAυAθRAHA  AΣA
=AAffAAΣAffAGApAffAУAAzAA߅AAAHA=qARA
=A
=A\)A(A
A33AHAzAQAAA
=A=qAzA܏\AݮAAARA{A噚AA\)AHA  A=qAHAA  AffAAA
=A=qAA(A\)AAAzA(A{A
=A\AQAQAQA  AGAQAQAGAAA(ApAׅA  A(A(AHAיAٙApA33AffAӅAԏ\A{AGAAGA˅A
AA=qAffAθRApAQAAʏ\AARAGAAHA(AƣAHAԸRA
=A
A
A\)AzARAAQA(AQAQA  AA\AAQAzAGAAzA\AA(A噚AA33A(A33A߅AA
AۮAٮA33A{AٮAָRA؏\AA  AAAzAGA=qA
=AQAᙚAAA  AGAAAՙA  A{A˙A
=AGAAȣAAəA{A  A{A{A  A{A(A\)AGAAAA33AA=qAÙAA(Aȏ\AģAAAȀ\AAAיA{AԸRAəAGA{AGA\)A=qAA\A33AGAAA㙚AA\)AQAAA
A=qA\)AQAA  AHA؏\AәAffAAظRAA=qAQAGAARAA
=AAzAzAQA(AQAA
=AB zA{AAffB \B=qBAAAARARAA噚AARAGAA\)A\A(AA\)AffA
AA\AffAARA  AAzARA
AAA33A=qAffAAffAGAAzA  ApAHA33A\AA\A
=AAQAAffA
=ApAQAAAHAGA(ApAffAAAHAHA\)A
=AAGAffA\AAQAGARAAA{AffAB B=qBffBB{B(B(BBBGB(A
=AAGAAAA33AzAB AApAA
AffAAAA(AzAQARAAAHBAffA
AAAGAzAApA\)AzAAAAHB   AAB ffAA\AQAAAGA{B AA
=AHAffAAQApAA(AAAAHAA
=A
=AGAAA=qA
=AAzA
=A
=AA33A
A\)AAHA
=ARAAAAA=qA
=AA33A
AzARA
=AffA=qApA(A\A=qA=qAA
=AA\A33A\)AApAڸRA33A޸RAA
A
=A
A{A33AARAARARA\)A
A=qAA\AARAGAәAzAA  A\)AAAAHA\)AA\)A  AHA\)A=qA\)AHApApARA33AAAAffA{AA
A\AHAAHA
=A  AGA噚A
AzAAAA{A33A{A\)AAHA
AGAQAA\)AA  A{ApA  AGAB 
=BBB\BRB(BB(BBBB=qBB	(B{BRBABAAffA\AAHA
A\)ARAυA
=AAA
A\)AAQAAAzAzAӅAGA
=AAAA33AzAA
AɅApAQA(AzApA
A{A  AڣAffAzA=qA\)A噚AHAA\ApA33AA\A  AffA33AffAzAA{A=qA{A  AA\A
=AA  A\A(A  AffA=qAA(AQA(ApAQA\AAAAAffA
=AAAARARAAzAGA
=AʣȀ\AΣAʸRA
=AAʣAHAəAəAzA
=A͙A=qA=qA(AQAzAAHApAA(AQAΏ\AGAҏ\A  AθRAGAՅA33A\)AffAׅA
AأA
AԸRAAHA  A\)ApA  ApA{AGA{AA噚AHA33AQAApAHA  A  AARA噚AzA
=AffA׮AzApAיAHA
=AңAzAzAzA
AݮAAA  AAܸRA
AظRA
=AA\)A
=AAȏ\AHA
=AřAffAʸRAffAAͅA{A=qAΏ\AHAAA
A
=AffAA
=AGA33AAΏ\AəAAffAffAGARA  ApAA  A(A  AffAA(Aޏ\AApAApAzA  ApARA33AAߙAGAۙApAA܏\A{AӅA33AGAApA\A  AA
=AAAtzATAK
A?A>ffA0A(  AffA(zApAApAA(AGAG@{@@R@=q@Q@@
@@z@@@ۅ@أ@׮@  @Q@ڏ\@@@@(@(@@ff@@ff@{@ҏ\AHA33A(AQARA
ARffA;\)AA  A  A3\)AMAeAQAAHAz=qAcA4A(  A,zA(  AG33AgAuAkAr{Ao\)AnHAx  A{A(AAAAAA
=A{A}GAh(A\AA{AAAQA
=ApAffAQAA{AHAQAApA  A
AQAAHA
A
=AGAzARAApA  A
=AAAA\)A
A33A
=AAffARAA33A
A33AGAAffA33AAA
AHAAAzApAQAA\)ARAAA
AzAA
=AHAAHAA33AA33AffAA=qA  AARA\)A{A{A33AAAAAAAGA
=A=qAA  AffA\AHA{AAA\A(AAA  AA
A\AAA
A{AGA{AGA(AA(AGAřApA\)AAHA\)A=qAzA
=AA(AAQAAffAzA\)ARA=qAA33ApAzAffAApAAApAAzAAAAffA
=A\)AA(AAA
A{AAAAA\)A33AzA
AzAGA(A\)AAAGA\A33A
A33AQAA
=AffA{AQAۅA
A33A  AQAA33A  AAQA33AzAԏ\AϙAУAffA  A  AAAAzAϙAGA֣AA\)ApAAУAAͮA\)AAAA33A\)AffAA  A  AAQA{AffA
AA\)A݅AυA(AA\A\)AAffAÙAиRA
=AA\)AHAAAA33AHAAzAHAHA
AAAHA
A
AA{AHAAA(A33AA(AƸRAGAffAHAA=qAхAA\)AGAffA=qAAHAЏ\A  A  A{A33AQAAzAHA
=AA݅A\)A؏\AׅA=qAApAԣAffAׅAQAAծAGApA{AA  AAӮAљAѮA
=AϮAGAA
=ẠA(A(AA33AQAA=qA{AAA  A33ARAA\)AA\AzAzA{AA
AA˅A(AzAظRAffAA
=Aޏ\A癚A33AA(A=qA\)A=qAAQAAA뙚A=qAQA(AA33ARApAAǮA{AAAݮA
=A
AQAA
A\AA(AHA  A{AAHAAA  AffAGAGAٮAA
=AAӮAAffAzAA33AHApAĸRA
=AŅAHAHAA\)A\AͅAď\AΏ\ApAɅAAAAAAģAAQAA
=ApAzAA{A=qAAÅAA33AAAGAAzARAAQAAʣAA=qAAңA  AҸRA{A{AA\)A\)A=qAAAAzAA=qA{AAA=qAzA33AA
A{AA
AA޸RAޏ\A  A33AAAЏ\A̸RAGAA֣AAAAӅAAffA33AA߮AAA\)A׮AծAA
AA{AA̸RAzAGAAGAAGA£AffAQAA
=A33A\)A\)A\AA  A=qA
=AA\)AمAQAԏ\AA޸RAQAzAAAAA
=A  A
AA
AAAA(A홚AGAA
A=qA33A
AAAAA(AGA
=AAApAHAAffAffA\)AA
=AQAApA{A
A(A\AApAzAAAAA  AGAzA\)A33AffAffAAHAAAA  A=qA=qAAAA\)AAAAQA㙚A  AffA=qAzA
=AAʣA{AυAAAУAυA͙AGApA=qAυAиRAzAHA\)AffAAAA\)A(A  AAA{AA33A(AAffAGA{A(ARAARARA
=AARAB\AzA  AHAHAAAA  AzAHAHAzAAffA(AAAzA\A{A=qAAA33A
=ApB
=BBzB
BAB ffApA
ABBQAGA(A\)AzAA(AA{AHA癚AA\)A癚AzAAAApA(AA
=AŅAffAͮA(AGA33A  A33ARAAQA\AۮAzA\)AHAAzAA(A=qA  ApA  AمAAA  AffA㙚AAzAA  AA
AAAA\)A\AApAzAAzAAGAA
AzAGA(A  A=qApAA
A  ApAzA
A߮AGAAApAzAzAffAA(AGA  ApAڏ\AAɮA=qA\)A=qAffAAGAA
AHA{A=qAAQAHA{AȸRA33AɮAGAA(A{A{A(AAAÙA=qA
=AHA{ApAԣAQA
=ApAffARA{A
A\)AQA
=A
A
=AᙚAAA\)ApAᙚAAAA(A=qA陚AA֏\AQAAGA
=AGA=qAAA{AGA=qAQApAApA
AffAQAA{AffA陚AAzAAA
A33ApA(AʸRA(A\)A
AܣAڸRAAAޣARAzAAA  AΣA  A˅Ȁ\Aȏ\A  A=qA
=AA{AA
=AQAzA{AǮA׮AAŮAA\)AAA뙚A{A뙚A  AAQApAA=qA{A
=AHAA33A{AQApAAA
=AA(AQA33AA33AA
AffA33AApA癚AAAffA
AffAAARA  A癚A
AHAHA{AHA33AA{AAzAA\BGB33BBB33BBB
=AA=qAA홚AAApA(A  ApA\A=qAAGAQA33A\AAڣAzAffApA33AA
A
ApApApA
=A33A\)AأAQAffAARAA33AAAA33AQAA=qA(A\)AA  AA\BA=qAGBBQAA\AAzAzA(A
=ApAHARA\)A(AAQAA
AAGAAzAHA
A\)AA
=AHAA
=A{A=qA\)AA\A=qA
AA  AA=qAffAQA֣A=qA
=A
A{A(A
=A
=AՅApAՙAԏ\AԸRAA
=A
=AGA
A
=ApAzAǮA=qA(A
AAAzAΏ\AGAAAʸRAA(A(AGA33A(A
=AzAޏ\A=qA  AAޏ\A=qA  A\AAAAGA  A33A  AA
AQAA߅AQAA\AۙA\)A(A=qAAHApAA33A\)ApA\)AGA\AzAQAHAAA\)A\)AA\AffA
AB (BzAAAHA\)AAA
A
=AA
=AיA
=AGA  A\AAA(AGAGA=qAA
A  A
ARAޣA(AAAQAHA؏\AQAffAQAGAՅAAzAA\)AAAAAAApAA
=A\)A  AHAA\A陚A(AA\)AA
=AGA\A{AA
=A\)A33A
A=qA\)A\ARAAGAA{AQAۮAظRA\A=qARAAAA33A
AGAA  ApA{ARAA
AA
AHA  AAأA33AffAAޏ\AAHA噚A=qA  AA33AGARAA33A=qA(A
A  A33A؏\AٮAA
=AGA
A(AA噚A(AGAAAQA(AHA
=AA33AAGARAAA=qAA\)AA\)A\A33AA  A\A\)A{A\)B33B 33B 
B B{BGBBzA\)AzAAHAڸRA陚AHA33AzA33A33AAAzAB 33A
=AAAHAAՙA(ApAәAՙAzAGARA\)AظRAAA
AQAHAGA
ARA  AffAzA(AܸRAGAָRAGAAzA=qAApAA=qA
=AABzAB A\ApA
=AA\)A  AAAffA
=A  AQA  AA
AAA{AA\)AA
=A(AAAQA(A33ApAAHAARAAB pB 
=AffAA
A33A  AA=qAA{A(ApB33AAARAAzA  A=qARAA{A\)AffAAAHApA=qA{AzAHA  A=qAA
ARAA  AAQAAظRA33AHAGA33A
=AиRA
A݅A(AHApApAA{A33A(AͅAAA  AᙚAffAzARAzA  AGA
A\A{AAAAAAA\AA
=A=qAQAHAA33AzA=qA(A{AQAA{ApAAAffAAffAAQAAA33AA޸RAݮAHA
AAAA=qAA33AApAA=qApA\A\)A(A\AA܏\A=qAݮAQA
=A{AAхAAAљAApAѮA{AHAҸRAA
AAGAԣAffAՅAA׮A=qAA
A(AGAA֏\Aҏ\Aԏ\AҸRA=qAHAA=qAA=qAffA{AܸRAAGA=qAA=qAApAApAGAA=qA  AHA33AAHA=qAAQApAA  ApAAA{AA
=AA  A
A=qAAA{A\)A{A
A(AAzAѮAQA(AͅAGA  A  AиRAՅAљAAA\)AУAA{AQAɅAˮA=qAzAGAģA˅A͙AӅAAQAģA=qAΣApAQA=qA=qAzA(AA\)A
=A=qA{AzApAřA
AAѮAθRAHAͮAAA\AHAA
AԣA
=A(A\)A(AAݙAAffAffA
=AAAA=qAARAQA
=AAA\AAAAA
=AAAA(A{AHA(A
=AQAffA=qA
ARA\)AAˮA{A˅AffA=qAAA
AʣAHAffA33AA33A\)AAܣAۮApA\)AzAQA
=AffAՅA
ApAGA\)AGAQAffAGAAA\)A
AݮA\)AᙚA
=A(A(AffA=qA(AAAGAGA\AffAA
=ARAzA33AAffAHAAGA
A\)AHAGARARAAAB B BHBBB{BffB\AzA33AQAB AQAAQA=qA  A>\)>#
<#
<#
A=qA
AA\)AAA\)A㙚AffAAAAAffA
=A\)AAQAͮAΏ\ApA(AA
ARAA{AAHAffA
=AAA=qA=qAA33A33AAAA=qA
=AAAAB \)AB AAzAffAB BGB=qBBRApAA{AHA33AAzARAAABQA  AAAAAAAAA  AffA{A(ApA\)ARAHAARAA33AA=qB GAA(A
A{AAޣA
=AAGAQA33A\)A{A=qA33A33AAAQA
A33AHAzA  AA{A=qAA(A
=A  AAA\)AzAA  AAQA  AffBA\)AGA(AGApAAA33A\ApAQAA33A{A{A\AQAA=qAA33A\)A뙚ApApA
=AAA\)A(AffA\)AAAAA
=ApAA33A{AA=qAAQAAGA33ARAAAGAffA33A=qAAffAffAffAzA=qA(ARAQAffA\A=qA
A  A\A33AffA\A=qApA=qAGAA
=ARA{A(AGA{ARAA\)A\)ARA33AQA33AAAAQA(A{AA
AARAAzBQA=qA\AzAGA=qA(ApAA홚AۮA
=AA\)AzA(A=qAA=qA
=AzA
=AAzA
A=qA
=AAمA(A33AA=qAAGAA33AzAAGAA=qA(AzA
=Aȏ\A
AAƸRA
=AAAA(AGA(AQAʣAHA  AAHA=qAHAAffAAAA
A33AAAA
=A
=A33AAHAGAzA(AHA=qAAHA  A(AHAAQApAAGAA\)AzA=qA\A33AQApAAARApA=qAAAQAzAAffA
=AA33A(A
=A{A{AQA\)A  A\)AA\)A(A=qAA\)AA(A{A=qAffA=qAA\)AȣAzAȸRAȣAffA
A  AQA{AzAA  A\)AHAApAA(AA\)A
ARARA
AARAAQARARAA{A\)ApAQAffAAAGAAA
ARA  AÅAAA
=AGA\A\AA\)AA33AzAAGAzA33ARAHA\)A{A
A=qA  A
=AAApA=qA{AŮA(AHAAAA\A{A\)AzA
=AHAȏ\A{AGA(A33AQAzApAAA(ApAARAA(ApARAAffAGAA33AQAAQAQAAGA33ApAffA
AHAA\)A33AAffA(AA(A  AA
A  A\)A(ARAQAA  AAffAAAÙA{A
AA  AA(A
=AA\AQAApAA33ARA
A  A  AffA
=AA(AAffAQApA=qAHAA{AApAAffA=qA(AAAAffA  A33A  AAď\A=qAĸRAARAffAAAA
=A=qA
=AAffARAApA\AAHAHA{A{ARA{AHAA
AHA\AAApA33A33A=qA(ApAGA33A  AA
AAffAAzAzAAAARA\)A=qA33A
=AAAAAA
AHA
AffAAď\AQAAA{ApAAA(ARA
=AAAA33A\AffAAA\AA\)AHAHAGAzA  A
=A
=AÙARApAAAA(A{A
A33A33AAA=qAAHA33AA(AApAQAA
=AAA33AAA\)AAAzAHAAzAAA  AQAA{AAA33AARAAAAQA\)AffAA  AA{AAAQA
A(A  AGAGA
AAAGA\AARA\AzARAzA
=AAA
=AHA\AAA=qA\)ARAA  AA33A{A
=A(AA=qA
=A\)AAAHA\AAAAffAAA{AzA\ApAAAzAGAzAA\A(A33AffAA  AzAA33A
=A\)AGARAGAffAARARAAA\)A¸RAQAGAAAAA
AAHA=qAApAQAHA=qAƏ\A
AA(A  A
=A  AA(AQAffAHAA\AAAAffAGA{AQARAzA\)AA
AHAA33AGAAAAffA
=AApA{A33A\AzAA
AAAA=qA\)A=qA
A(A(A
A  AAA\AAA  AA\)A{AAQAAGAAffAQAApAGA
=A\ARA\A  AAA
=AzAffA\AAAA=qA(A\)AA33AzAAAAA{AzA(A
=AA\)A  A=qA=qAARAzA
=A{AAA
AAHAAAzAAAffAA=qAA
=AAzAAA
ApAAA{A33AGAAA{AAQAffAA{A(AffA33AHA{AAAA  AA(A(ApAAAAzAGA
AHA
ARA33A=qA\)AzAzA{AAzAffAffAGAApARA{AApAA
=AzAAAAA33A\)A(A=qA\)ARAffAHAAA
A
AAAHAAffA\)A33A(AʣAffAGA(AA{A\A(AGAApAAA33AffAGAGAA
AA33A
AA
=AA  A{A(A{A{A{AHAA(AHAAHA33AzAzA{A=qA\AAffAAzA{AA=qA
A\)ApARAARA{AzA{AGA{A
=AAAAQA=qARAAGA{AAAGA\)A\AAffA
A\)A  A  ARAAAA33A
A\)AAAAA{AAHA\ARAA¸RA(AAŅAGAffAA{AApAffAAGA(AA
ARAHAA  A
A33A(AzA(AA
=AAAAzAAAApAQA(A  A\AGA=qA33AGA=qAHAA\AA
A\)A{AffA=qA33AAA{AHAQApAQAA\AQAAQAA£A
=A33AzAzAHA33AAffARAAGAGA{AAHApAA=qA
=AGAAA\AAA(AA{A33A{AApA33ARAQAGAffAAA\AGARA\AzA{AAAGA=qA{A
=AAAAQA=qAA
=ARAHAHAA{AHAA\)AA{A\)ARAAffAAA  AGAA{A\)AAHAAAffAGAGA  AffAQAHApAA\A
AGAGA(A(ARAffA
=A
=AAARAffA  AHAQAA33AzAAA
AAGAAAARAAQApApA
AQAAzApA
=ARARA  A=qAHA=qA\AAA\)AAAAAA=qAA
=AApApA  A
=AAHA
=AQAffAAffA(A
=AAAHAAA{AGA\)A\AQA(ApAAQAAAffAGA{A{AHAAzA
A\)AA{AA
AQAAAA\AA\)AGA33AAARA
AffA{AQAA(AQAQA\A{AAAA  A  AAGAA33ApAAAAAA=qAAGAAAAAQAAAA=qA
AA\A{AAARAffAA
=ARA
=A  AAAAA33AHAAGAGAffA  AA=qA{A{A\AAA33AffAA(A(A
=A(AA\)A
A\)AffApAAAQAAA=qA  AAHAAA=qAQAA(AA£AHAď\AffAģAŅAHAAAffAAzAAA{A(AGA\A  A33AzAA  ARAffAHAAA
=A
A=qAĸRA{AA\ApAAA{A  AGA(A33AAAA  ARAAAffAzAGAHA33A
=AA(A\A  A
=AAHAQAGAQAA
=AHAzAffAzA\)AA{AAApA
A{AApAGAAffApA
=AAGAzAAffARAAHAA(A\)A
=AA=qAAffAApARA33AAAAA\AAA{A
=AAA\A=qA=qA\AAAHAffA(AA\ARAAHA33A  AŮA=qAAQA33A\)A{AQA  A\)AA33AHAQA(AApAA33AAAAzAzA{A
=AzAffAQApAAzA33AAGA  AQA(AA33A\)ApApAAQA(AAApAzAHA
AA=qAGA
=AAAAA\)A=qAQApAA
=AA=qAzA{A  AAA(A  A
AzAAGA\)A33A{AA
AA\AAA
=A\)A\)A\A
A
A\A\AHAA=qAAA
AzA  AffAAHAHA\AAQA\)AA(AHAAApA  A  A
=AAHAA\AA  A\)A
=AApAffAA  AA\A
AHA=qA
A\AApApAA\)AAHAAAA  A=qA\A33AAA
AAAA
AAA{A\A\AAA
=AffA  A33AGAA  A  A
AHAffAA(AA\A33A33A{A
AffAAGA  ARA=qAAzAA{AffA\)A\)A(A
AAAAApA{AAA{AffA33AAA
=AAAAzA\A
=A
A\)A
A(A
ARAffAAGAAGAAApApAAAA=qA\AHA
=A33A\)A\)A\)A\)AAAAA
A
A
A
AA33A33A\)AAAA\)A33A
=A
=A\A\ARAHA
=A
=A
=A
=A
=A33A\)AAAAAA
A
A
AARApA
ARA
A
A  AA(AA33A
AA(A
A=qAffA
pA\)AAA  A
AA
pAzAA  A  A
=qA
A
ffA	AA	AAA(AAGAAAAA=qA  AzA  AA
AA{A\A(A33AA
A
A
A  AffAA=qA  A	GA
=qA	A	pA	AzAAA33A	A33A  A
GARAHA
A
A
GA{A
GAzAHA
pAzA  A
HAA
=qA
RA
ffA
AAAffA\AAA
A A QA\AHA
=A  A(AQAzAApAApARA=qAA @=q@@@ff@H@H@p@@@
=A A{A=qA  A33A\AARA A{A\)AQA33A(A33A
HA
\AzA
AQA
HA
ffA33AA  A
=A
\A
HAAAAA33A  A
ffA
RA	pA(AGA @\@\ApA  AAA=qAA
\A	AffA(A=qARA
GA
A{A\A(A(A
=A	pA
ffA
HA
ffA	A(AAAAAA\A zA (@AApAp@@@{A A (@A ApA\AA\)AAA
=AA{A{AAHAGA@z@(@ARA ApAff@
=A=qA  A
A
HA
RA
RA
\A\)AzA
=A
AGAzA @A33A@zAA
HA\)AzA(AzA
RA33A  AzA	A
HAA{A
HAA	A
AA	A	A	A	A(A
RA
\A33A	A	A  A\)A  AzA	pA\)AQA
A
=AzAHAGA@
=A zA zAAHAGARA
AAAA A @@@z@ff@zA @RA QA QAGAG@\@  @@@A   AGA33AAAA	A	GA
ffA
\A
=qA
AA33AA=qAGA\A
=A33ApAQAARAA{AAAzA\AA\AAAA{A A QAGAARAzAA zAGA zARAA33AGAffA\)AA(A33A(AQA
GA(A
AAA
HA
ffA	AA{AAA QA @{@ff@ffAAA@
=@\)AApAHAA@\)@@ff@
=A ARAA\AQAHAHAAzA (@@
=@  @
@\@@(@@@@H@@߮@ٙ@G@
@@=q@H@@H@(@G@{@@Q@@R@G@(@(@G@ff@
@(@
@@Q@G@@
=@ۅ@ۅ@33@@H@˅@@R@
=@  @ff@@\@p@@x@o\)@b\@JH@2\@.{@%@R@*H@(@%@+@2\@<(@>R@;@=p@<(@:=q@#33@*=q@0  @0  @:=q@@  @Fff@C33@G
=@N{@X@aG@fff@c33@_\)@S
@N{@J=q@E@Fff@I@C
@HQ@NR@P@K@H@E@<(@7@?\)@P@Tz@U@U@U@W@\(@c
@dz@dz@i@i@\@Mp@G
=@S
@b\@i@e@G
=@AG@B\@E@B\@C
@AG@B\@C33@A@Fff@J=q@N{@N{@L@L(@G@C
@@  @B\@J=q@QG@W
=@]p@a@dz@e@g
=@jH@nR@tz@x@zH@\)@@@@@
@Q@=q@33@  @R@w
=@e@e@g
=@_\)@]p@^{@\@b\@j=q@u@s33@l(@dz@e@q@r\@xQ@\)@~{@\@@=q@33@  @@33@@H@ff@
@=q@33@R@R@ff@@=q@@@(@p@(@H@@@z@@@@=q@  @{@p@z@z@@p@@(@p@
=@@@G@@@  @=q@(@@\)@R@{@
=@
=@
=@
@G@@@@@
@H@H@@  @R@
=@@33@{@G@p@@@=q@
=@{@z@@@\)@  @(@(@@@@  @
=@ff@@@@@@z@{@=q@@@@@
=@\@@{@ƸR@33@G@@@@ff@p@@Q@@@@@
=@R@ff@z@{@H@@33@@(@@\)@@@ff@@33@@@ƸR@
=@\)@ƸR@@Å@p@@33@\@@@(@@33@
=@
@p@@p@=q@  @@{@@=q@
=@\)@G@  @=q@R@@p@
=@@Q@Q@(@@@  @Q@=q@@ff@
@p@
=@ۅ@أ@Q@Q@p@H@z@H@@ʏ\@
=@@  @33@Q@@@R@33@{@ٙ@ff@Ӆ@=q@@=q@(@@
=@أ@z@z@z@ff@@ff@{@@ff@
=@  @@@@߮@@\)@@33@@أ@
@
=@@@H@ff@
@Q@@
@=q@G@@H@\)@@\)@33@
@\)@@jH@H@R\@R\@;@&ff@(?
?\>R>L>.{>L>\)>8Q>\)>u>B\>z>L>#
>.{>  >{>Ǯ>>ff>H>H???(?!G?.{?333?@  ?J=q?Q?Tz?p@z@Q@R@G@p@@!G@-p@5@9@A@H@L@QG@U@U@Mp@JH@NR@S
@O\)@H@G
=@E@C33@>R@>{@=p@:H@9@:H@:=q@>{@=p@@  @AG@A@:H@8Q@7
=@7
=@6ff@7@8Q@<(@>R@@  @@@HQ@Fff@\@\@_\)@Vff@P  @^{@fff@g
=@u@@@Q@@@Q@}p@G@H@~R@u@q@s33@l(@k@p@r\@s33@u@qG@l(@i@g
=@dz@b\@a@b\@c
@fff@g@i@nR@tz@}p@H@\)@@=q@@R@@Q@z@@@@@~{@|(@zH@z=q@z=q@y@z=q@zH@qG@nR@nR@nR@n{@j=q@dz@c33@`@^{@[@c
@h@^R@Z=q@NR@E@=p@7
=@333@/\)@,(@*H@*H@*H@*H@,@.R@1G@2\@3
@7
=@8Q@9@:=q@:=q@9@8Q@4z@7
=@7@9@;@?\)@@  @@  @Fff@JH@U@aG@g@jH@g
=@g
=@c
@fff@j=q@mp@qG@}p@~{@@33@
@\)@
@(@p@@u@h@g
=@tz@@p@\@@ff@ff@ff@33@  @Q@G@@Q@  @@=q@ff@=q@z@ff@@@\)@@@  @@H@33@=q@
=@@@(@{@
=@G@@@R@z@z@(@
@H@@}p@~R@~{@Q@|@z=q@w
=@s
@nR@zH@=q@|(@}p@~R@|(@|@33@@@@@@Q@
@
=@@p@=q@ff@H@@@@@p@
=@Q@R@  @z@H@(@@Q@
=@p@
@ff@R@  @=q@p@@R@
=@p@H@˅@
@=q@33@=q@ə@@@z@@(@z@=q@Ǯ@H@\@ff@ȣ@z@Å@
@  @Q@(@  @G@@@@33@G@Q@R@
@
=@p@{@@z@
@@
@  @ff@@@@@ff@@p@@z@Q@@@(@{@R@p@p@@@@\)@@@ff@@33@ȣ@
=@{@
=@G@θR@У@  @{@
@ʏ\@@Ǯ@p@@(@Å@p@@@ff@ƸR@
=@
=@
=@ʏ\@33@(@p@@p@Q@H@(@p@  @H@@  @ᙚ@33@(@
@H@ᙚ@  @@@ڏ\@\)@
@љ@Ϯ@{@=q@  @(@G@ff@@@{@@=q@@@@G@33@@@  @{@@p@
=@\)@@G@@H@Å@@p@G@\)@@Q@\@ff@33@Ǯ@  @G@p@@Ӆ@=q@У@\)@\)@\)@  @@ҏ\@@G@׮@p@=q@Ϯ@
=@H@
=@Q@\)@
@У@
@Ǯ@@{@G@@G@@ָR@
@p@p@@H@33@H@@z@{@ff@{@ָR@\)@׮A\)@@@{@H@@@@@
@33@Q@~R@\)@  @Q@  @z@H@@@p@G@@~{@@H@G@=q@@Q@@ff@
=@|(@R@
@@@@G@~R@@Q@Q@Q@y@z=q@x@\)@{@zH@xQ@u@|@  @}p@@33@@33@@}p@@@w
=@w@{@z=q@w
=@w@|@\@@{@@(@s33@=q@u@x@y@w
=@@G@@(@\)@=q@\)@p@@=q@  @  @
=@
@@@33@@Q@@  @
=@H@@  @~R@{@z=q@zH@w@u@zH@vff@s33@s
@w
=@{@w@|@(@@@@zH@x@u@u@s33@q@q@qG@\@|(@y@q@tz@{@u@q@qG@s33@w
=@u@u@u@r\@p@p@r\@y@z=q@~{@|(@~{@}p@@@(@@Q@=q@@@H@G@=q@\)@
=@@}p@z@  @p@@  @@@xQ@qG@p@tz@H@33@=q@@z@  @@G@33@\@\@@
=@@Q@\@H@@@ff@@
=@@@@@Q@s
@r\@w@s
@u@s33@qG@u@\)@tz@o\)@n{@u@p@p@  @tz@@}p@33@@@{@@
=@@
@H@@{@@@@ff@|@=q@@\@G@~{@Q@@@@@Q@|(@=q@z@\@\@@(@@p@@@
@z@\@\@=q@\@@z@@  @@p@@Q@@@{@\@z@33@G@\@z@H@33@@=q@R@@  @@=q@@\@=q@z@@@ff@
@p@R@p@p@\)@  @@\)@@
@\@@{@@@ff@z@p@
@@p@@@@\)@  @@p@\)@@{@@
=@G@@@@@\)@
@H@33@@(@33@p@{@{@ff@p@33@@@@@\)@\)@{@@H@@@@@
=@Q@@p@ff@@{@@p@p@
@H@  @  @  @G@Q@R@33@
@R@33@@@G@G@\@@@R@  @
@\@@ff@R@  @p@p@@p@G@@{@
@@{@p@@
=@@@@\@
=@@@@@ff@z@{@
=@@=q@@R@@  @@@@  @p@{@@Q@
=@\@  @@@Å@=q@Q@  @ff@  @  @33@z@@(@@  @@ff@@(@(@@(@@H@\)@33@@p@@(@z@@Q@
@@H@ff@(@z@Ϯ@  @H@H@@33@
@z@@@33@@  @GAAAzA
=A
A33AAAzAQA  A	pAAA QAA\)A=qAffAA	A
GA(AzAA!pA'
=ARAApA{AA(A:\ApAZffA
=A
AAA(A
ARAAHAffARA33AApARAA
pA  A(AA\)AAIAA\)AQ@GAffAAGA3A1AA"\A/
=A;A6{A3A5AMAFRAIAAAHAZRAVHAeAYpAUA\Al  A|A{Ar{AQApQAqAd  AlAs
Ak
=A]pA]GAd  AfHA^{AZffAlAg
=Ar\Ad  AeGA^=qAj{Aj\AAo
AxAz{AiAmAmGApAhAARAAnHA
=ApzAA~HA  A(AA=qAAsAipAqAhzAmGAlzAn{Ax  Ap  AwAffA|  A}AzHAqAbHA33A33AQAzA(AQAAGA@
=AzBnRAA|B33AARAB
=AGA{BfA9pA  A=qAApBǮBîAAAA\)A
AzAAAABA33A(A
ApA=qA  A  AHA33A=qAHApAA}AA33A}AzA{A33A(A
AA33AAmGAh(A\)A}pAdQA\(AAlAZffAA
A\)AA=qAA
=A(AAARAQAHA@  AAHAA  AzA\AeGA{A=qA=qA=qA
=AA\AA  ARA{A{AA\AyB=A`QA{A
=AARAN{AGAApAMAHA{A
AAAHAAAAzAAAffA\A\)A
=AffAuA
=ApAHA\)A{A33AA
=AQAtAHApAA~HAA|  ApAyA=qAArHAApA~HAAHA
AAdAA\)A=qAA~HAmpAtAtAAqAzHAvHA33AApA  ABkBx
AAA
AA33ARAA33AuA|QAAzAo33AzAuAA
=ApA{A{\)AhQA33Aw
AeAHA\)AQA(AA  AffAmpAA
=AAHAHAA(A\A
A\AAAA(A=qAzAAHAHA~HAHAjHAAzAzAffAGApAzAd(Af\AcAhAaAP(ARRAQAUAJffAQAG\)AR\ALzAMpAJ{AMAO
=AK33AZHAXzA_33Af=qAQAqApA  AuAk
A`(AGAAffAzAtAAt(AoAzRAAw33AAQAuAt(AMAuGAAAJ\A^ffASAB\A[33Ac
=APAAc33Ag
AapAAyA
=AtzArRA(A=qAcB4HAA{ARAxAc
Af\AVHALAXAL(AMAV=qATAP(AVffAQGAS
=AUAR{ALAL  AJffAEAEGA@A>HA@AAA<A>HA8zA6\AEpA6=qA4zA;\)A6\A5GA6=qA6{A9GA:=qA8zA5A4A7A6HA5GA8(A<A<QAYGA=A8A2\A6HA:ffA4QA4A2HA5GA2RA3A4zA*HA4A(A-GA,A3\)A3\)A4zA*\A%A$zAA.\A4AQpA0AW33A7\)AFHAZHA4(ABffAAA/\)A8QA*ffA5A/AAA4QA7
A;A.{A0  A*=qA$zA'A0  A2ffA2RA1A/A3\)A8(A;A;ABffA;
A<A;33A;
=A>RA@A@QA;A<zA:HA:RA<A@A?
=AL(ADAHQAB{AF\ACA<A<(AUA733A7
=A1A2{A/
A2{A0(A-A*RA-A/A/
=A0(A2\A1GA1pA8A5A5A8A7A6RA.HA/
=A,A1A5GA2{A4A:HAGA<A6=qA6\A.{A:RAC
AEpAAIA?\)AHAHA=AApAIA9A<  A>RALA\  Ap(A_
AAMAPAf{AZffAb\AXA^=qAG
ANffAHQAAAD  A@QAB\A?A:HAD  AG
=AIAMB^ffAK33AHQAB{ANHAH(A>HA8A.\A,A*\A/33A0A-GA1A8  A/A$A.{A)GA*{A*=qA,zA0zA-A%A*ffA1GA-A.RA6ffA:=qA6{A9GA@AEpAEpAC
ATzAS
=AWALQAEAHQAIA?
=A@  A>{A=A2HA7
=A3
A6RA6\A4zAFRA:RA.\A#\)A5AEA#
A#
=A+A:{A+
A5GAH(A#A6=qA1A5A0A"RAA$A!A A!A&=qA/A!A!A$A   A&{A$A(zA&RA*{A4A2RA5pA/\)A0  A1A0QA2=qA1A9AIGAIA5pA<QA<A:HAAGAQA@AT  AO33ABffAHzACAIAAGAHQA=pA6HA8zA9GAEAK
AAA?
AFHAQA^{AeAeAV=qA\(AUpADQAB\A>=qAAABHA:=qA-A/
A+
=A/
A"ffAAHARA2{A)pA0zA!AA,(A zAC
A333A8zA`QA"RATzAZRA!AUGATATzA-A9pA<AdQAEBA5A4A"HA1A:{A;
A$A&RA!A%A&\A*RA0  A0A6RA-A3A0zA5A8  A<A6HA?A8(AB{ADA>RA  AApA;AEACA:RA5A3A/
A.{A0(A'A'\)A.\A333A/A4A1GA5A5A2\A.{A(A%pA$A((A((A'
=A(A)A1A3A5A3A0zA/A-A0  A1pA,(A*ffA+A+A.=qA=A+
=A+
=A!A(  A"{A$A
=A+
=A)A QA*HA1GA7\)A$A,zAAjHAUA-GA{A*HA3A.=qATzA,(A(zA)A(QA#
A%pA"HA$A*HA)A333A+
=A+A)pA*HA6ffA.\A0(A*=qA/
=A4zA7
=A0QA2=qA#
A3
A5A2{A5A0A4zA4  A.ffA/\)A+A.ffA,A0  A.{A,A-pA*HA)pA#
=A&RA$zA0  A*ffA$A$A#A/\)A$A$A'A5pA,(AOAK
A4  AB\AIA.HA333A1A.RA.RA((A   A$A A!GAJRA6ffA=GA0A8A@A+
A*HAffAA A A#
=AA!pAHApA%AA=qA   A
=A{A\A=qAAAAzAAAA(AA33AAAAHARAA\A3A4A8(A1GAAkAffAffAf\AA2ffA.{A4A&RA8QA.=qA%A#\)A"ffA A$zA(A\)A%A:ffAAAR\AP  A\AA=qAhAk33AmArHAoAQA_AYAdAH(AHA<zABRAPzAH(AL(AUA9pA>ffA<  A?
ADA>HA:RA=A(zA"HA&{A%GA(QAffA%A(A,A\A{AA
=AGAA!A!AAAzAGAAAzAA{AffAAAffAA&{A$QA  A(A (A,  ApA
pA
A
AA33A	AAAzA{A
ffA\)AA(ARA33A(AAzA	A
AA(@\AAzAQA
AGA\AffA
=A!ARA  A\)A\)A	A  A33AA AA
=AQA!A%A{AAzA
HA
A
=A
RAAA
{A(AAAHA
=A%@  AAAAA (A (@=qAQAzAARAzA
AA(A
GA\A(A=qA   A
=AAA
=@ffApAAAGAApApAAQAAA(A
GA	AAA\A\)A\AA  A zA&=qA(zA@(AR\AUAbRAk
A^HAPAPAG
AP  Ao
=AMA=AF\A7
=AA"=qAGA)A+\)A,(A:RAJHA{A!A?
A9AIpA'A9AtzAs
AB\AHAapAh(A2\AUATAbHAB=qAIAeAF\ASA0QAO
=AJ=qAV=qA<AV{A^{A~RAxA4  A;
=AipAS
=AdzAg
=AbffAF{A~RAQGA6=qAYAZffAC
AV\AUA\A8ALQAZ\A<ALAmpAlzAhAAHQAAUA  A  A(AAmAw
AA  AA
=AffAl(A
=A=qA=qA
AepAAyAA=qAzAAzAHA{A
=A\)A\A\A=qA
AGABHAAffAAffA\AA
ABA3
Bn
A
=BVGARAS\)A  AffAAGAAAA\A\)A33AAc
AsA
=AHAAAA=qAApAGAAAzAAHAA\AA
=AAApApA
AypAffA(AffAAAZffAHA=qANHAAAzA
=A=qAA\AHAB
AypAGB!zBMA
=A\A{A\)AAA{A(ARA\BffA
=A
A{A\)AAWA\)ApAQAo
AJRA
ARA{AAHA(AzHAzARB{AHAzffB QAeAbHAB9RAAAAA
=A=qARB7AB.ABf  AffA
B	33B=qALzAzA{A(AABAAGApBw=qAgARA\)B"AHB3AAlzAA  AffAQA\AHApAuBzAzBC(A33AA\)AffA(Aw
A=qA_
=AfHAAxB\B {A
=A
AHA=qA  A^{BAHA(A
AGAQA
=AP  B*ffAGAAiAHA=qA=qAA`zAA\AApAAA{A{ApA33BJABW
B2{ABAA
=B5pAУAGBt\BzB\ARA
A33A
=B  A\)A(ARAffAAA̸RBBB5ApBB-BhAAAB{A
=B#AGB\A}AwAHAQAAA\Aw
ApBERApA\)AA33As33AAABApAA33B8A~ffApB[A
B033ARAAypA33AGABERAA\A  AGAffAA{ApQAApB	ffABQBAHABAffB
HAzBBAffB
B5BBB?{B,BǮBJQB"BBWRBC~BffCBBޔ{A
=BpABHB {AoBpAB$B[BEGB+ffC\AܣAA33B
zAAB33B B	zAzA\)ARAܣABB*B}
ABpB\AVHA=qBU  BBA=qBzA5GB{A(AGAA{AAGB QA(BBDBOA(ABpA{AQAQA=qAAB\AQAA33AAAGB)A
=A(A33CLB33B)B
{BBBHBB-RB1BBA\)BϸRBLBB*
=BB>pBBQA
=C_
BpAGB\=qBA
B]\)B
CkfC1B$=qAѮAB  AQBNBW
BVBBB3BffB@AB\)BA{AVRB
A\)CAHB
AHA\B/AAA=qBRAHA=qBB8BAGBA\BGAQBzB3AAA~\A33A
=CGA33A
=BeQABhffB8RARA\B"
B\)BBA֣Ce{A
AҸRAB  B=BB33B!HB2AA  ABBBoBpB<
=BA33AC"xRB0QA\BQC
A#BpB
{BB~C?BB	=qAȸRA
A
BaHAQB
=AffB{A  B=BBG33A=qBAQBs(AapA(A33B\)AA(AɅB^\)AA  B A(B¨B#AQA33AC BBFB)AA33AAXB33AB\)A{A
ARBB.  A
=A
=Av\AJ=qAAB0{B{AA{BHBLApzA
=B  BBBpHAB5BpBzB|
=BrC,fB)Bh33B.BL\)Bj33BE
BBQB9By=qB=qAAɅA  A
AAAʣA  B陚B*A
=A=qA  BHABGBC..AAj{A
A\)AA{AB0AQAffBRAABAffCBA\BBǮAHB/AB4\A
=B\)AQAzA33AGA܏\AAApBBYBA  AzAffA{ABGAzAB.A
=A33BQ=qB B1GCBB=HA(AQABBZ
B33B(
B=qBBSRB&BIpB,ffB
CUJ=BpB\RCW  B:BDzB){B(BBB  A(B{AGB#A\)AffAARBBΨBN  BB.AtzAGAffB{CvB³3AHA
=BwA
BBBpB
zB=qC QB3ABY\BGB)  BB0QBB${BBA(B8RB3B`B)GB\BW
A
=BGB\)BBB"{BHA\)BHB=qBB1CCaBGB#BB$HB(B
B:=qB5HB*CB$B|CkO\Bh\)C ffB8zB2HBVBqB33AAzBRBIB3BGBU(BJ
=B%33B(BK
B5
=AB(BOGBpCABBzBN  A\BRB}=qB5
BGB=qCB?B%Bۊ=AGC~
=B,AGBB4B$\BHAQBBffAABBKB`B&B&B,B&HB8ffB=zBB\BDffBURBJBZ(BJ
BBffB@BE33BIRB9BQGBR
B)Bx
=BiBN(BHQB[Bd\B[BLBBBD=qBHzBNBJ=qBP
BP=qBGBF33B_33BTffBhB&GB533B3  B?B^\Bl
=B`\Bt{B8B5B_GBYBV
=BaBUffBgBKBHB=BMzBBRBs\)A\BEB"  BQAB6BffB#GB)RB@RB!B)QBzB!RB0A{B
=B?{A  BDzB@ffBTB=BCpBI33BBBGBM33BQpBuQBkBYBaffBVBfB^QBUBSBQA33B(Bz=qBzBBh(BiB\BCffB9QBPBTQBFB>BFQBPzBXBe33BSB@33B=RBGB2QBH
=B,33BOBzBN33BWBUpABX\)BzBXBJBW
=BS
=BAQBMRBCBQGBcpBi33B  BdQBBpBt(Bp{B@pBvBr
BrB=qB=ffB=BOBNBPA=qB9B=  BNGB
BAffB]AB;
=BFBMBBBhBUHBZ  BZBT=qBd  Bs  BqRB`BgB`BkBbB\BB(Bi\)Br33B]
=Bi33BczBfB]pBxBsBHBQBHB B  BBBGB  Bw=qBW
BByBeHBgpBQGBh33B
=BrAB(B_QBeBaB]Bp=qByB
=BB~BqQBy\)C{Bv33BSpBo\)BB8RB33BB{BpB=BˣB33BB\)B.BuABHBkBAA33ABuBuBpB
=AB{BAB	\ABA=qA
A(AɮB8BBGABAARAApBABzAzB (B7BAB=qAQBBHBffBffBGBGBpBB=pB$AAA\AAzApAAzAffAA\AGA
AffAAARAHAARAAQAGA  AA  ARA  B9zAGAffA\)AAzAAA
=EA\A  CSA
ARAA{B@C|ٚCu.AHA\)AffAAAB
BpAXA؏\A=B?(BffB\)A<CPA\AHA}A(C
pAeA33A\)AARAyAypA
AHA=qC @ AB)A£AQAzAAW
=A
=B3AApAeAA  AS
A
A=qACAtzAARB5pAffB<(A~{A
=AAQpAA
=AAMB\)A=qARA(AAA  Ap  AB=qA\A\)AUGAC#)CDYAd(A|AiAo33ApAAHA9AHA\A癚AARAg33A((AMpA=AC33A2\A4A@(A5AMA,A9GA;33A9GA<(AB{A1A.ffA3\)A8QAUAR=qAAA;A>RAKA<ADADAO
A@AX  AT  AH(AH(AC
=AZHALQAPA=A+\)A?33AapA]AzRANHAmGANffAL(AH  ASAS
=ATQAXAT(AXAh(AUGATAb\Af\A`A\AaAlQA]GAG\)AEA=GA8A7A>\AFffALQA8(A733A5A<(A:\AZ{Ab=qAMAAA@zA@zAApA>RAG\)A<A<zA:RA@A9AqGA4  A7\)A.\A'\)A&HA*RA\A%AHA*{A(A#A)pA"\AQAffA=qAAA
=AQA+
=A  A(QA#A.ffA33A A"{A)pA%GA.\A%AA,QA!A&{A\A!A'AzA)A(A'\)A#A$A#33A0(A{AA (AHA zA=qA=qA  AA  AAAHAQAAAQApARAGA\A33AAA  A33AA
=A{AA
=A((A>=qA5A((A)GA3A0A5A.HA)AA/A%A\A\AA
AA,C5aHA*=qA5AzBBGA  A9CocD)A(AQBizAA\AA\)A=qAA#33A'
=A"HA#
A#
=ARA!AA#
=A"RA'
A!A A"HA%A%A$QA"HA"ffA((A A)A/
A+\)A
=A
=AHAGA   AA  A\)AzAffA\A33A33A=qAffA
AA (A
A&HA
AffA(AA(AffA{A!A)A"RA
AzAGAffAzA33A (AA  A AA  A
A=qA  A\A0  A (A (A AGA A A!A QA"RA!A AA'A((A%GA%A"\A A A (A33A\)A"HA\)A(AHAA
=AAAAAGAA#33AHAA33AA\AAHA33AzAffA{AA(A{ApAQA(A
=AzAA zAA=qAA(AAAGAAAAA\A
=A=qApAAAAffAAAA=qA AAA!pAA33ApA
=AAHA"HA(AGA zA A"ffA QA A!A{A"ffA A=qA
AAGA zA
ARA/A'
=A+A(  A A (AffAHA=qA  A(AA
RA33AAGAA33AA\)C!AAA  AAzAzA (AA
=A\AA(AA
AA  AHAffAAA\A
A=qA=qA
=A@{@pAARAffApA{A=qA{A33A33ARA{A{AA  A$A!AGAA*\A"=qARA$A(  A'
A6{A@(A4A733A4A333A4(A3A3
A3\)A,(A zA$A"ffAQAAA#A (A
AffA\AAAA=qAzAGAA=qAffAA
=AzAA	AA  AffAAAAzAA zAffA-A33AA
ApAffAAAA{A33A$QAGAAAAA{A=qAA
A=qAA	A
=AHAA(A  AAA
A!AffA33A  AAzAAHAGA33AAGAGApAGA\)AffAApAAA{A
GAAHAHAAffA
RA
GAA
=A{AzA\)A)A.HAHA"RA
A{AQA(AAzA(A{A\)AAzApA=qARA\AAAA33A\A33A{AQAA\)AffAAffAffA\)AA\)AffAA{AA33AzA{AHA
AA{A{A\)AffAAAA33A
\A(A\AffA
{AA  A=qAffA
A
=A
=A33A=qAzAAAAA
=AARAzA
=AffARA\)A\)A	A
AQAAA33AA	pA33AA\)ARCApA@ff@A33@H@Q@R@H@\@G@@@(@@(@33@@R@@@G@=q@A (@@(@@@{@=q@@@33@33@33@@@\)@{@@
@H@
=@@33@ff@\@\@@@\@H@@@H@@(@(@@(@Q@
@@G@
=@33@z@@H@(@ff@陚@z@\@@@  @\)@R@
=@@@ff@\)@\)@  @p@@@
@33@\)@@@  @@ff@=q@
@z@@@
@  @(@p@p@@@Q@A @@@33@=q@QA{@{@@@@@@@H@
=@33A AApA   AA=qA@RAAA{A zAGA AffA\@@Q@  @33@p@G@z@(@陚@陚@{@33@R@
@A Q@(A @(A @p@p@@33@@ARAA
RA=q@@A AA33AGA @\)A @ffAffAzAA\A@QAA@@A33AffAAGA
=AA AQAQA
A(AAA{AA\)A33AffA33AA\)A ARA
AA  AA	GA  A33AAAGA{@RA
=AAHAAQAAHAA
=AffA
=A  ApA=qA  A
=A\A@\)AA A A{@
=@@(@p@(@@33@Q@33A{A{A A\A  AzA @\)@
=@ffA@@@
@H@H@pA QAAA
AHAffA(A\A\)AA\)AA(ApAzAAA%A&{A!GAzA(A\ARA QAffA!AA33A(AAffAAAAA
HA	A33AmpAA(A33A
pAffA(AAQA\)A
RA(A
=AzAA
AAzAQA
RA(A
=A
=A  A33A\)A33A=qA	GAA=qA@AA{A
=A(AAQA\A\)A
AQA
=AffAAffAAQA(ARAHA\AHAGAAAA\A33AAAAA33AAA33A	pAA
A
ffA33A	AffA=qAQA{AzApApA"HA#A&\A(QA&ffA!GA*=qA
=AHAA33AAHA (A\)A\AA{A%A{AAzAARAA
=AHAAA
AffAzA
HAAAQAAA33ARAA  A=qAA
AQAAffAHAQAAA
RAA
=qA
=A{AAA\AffA\A
A{A{A
A\A\A  A
GA\)A
AAffA
=AAA	pAA{AGA33A	AQAAffA
RAzAA
A33AA\)A
A
A
{A	pA
ffA	AHAA\A=qA  A	A+
=@HAGA
=AQA
=qA  AHA
A
=qAffA	pAA=qAHA
ffA
A
=qAA AHA\AAA(A
A
=AAAAffA (@@
=AAHAA A @\)@R@Q@(@@33@@@Q@@{@z@@
@@\)@@@Q@G@
=AAQApAA @R@{@@33@=q@  @@{ApAz@A   A A@ff@@(@\@ff@p@@{@p@\)@Q@Q@@QA (AAAGARAzA	A33A=qA(A @(@Q@
=@@@
=A@p@@Q@33@ff@33@\)AG@\)@HA   A   @@
@@@(@{@G@@ff@@(@zA A QA@\AAApAGA{A{A(A A @(@Q@@
=A   AAAA A A (@p@@@p@Q@A
=AA(@(@33A@G@@p@@ff@Bp@@@ff@׮@׮@{@@@G@ָR@
@{@R@GB(@H@陚@z@
=@
=@Q@Q@=q@z@=q@=q@=q@@@G@@\@  @=q@陚@@(@@@@@@(@{@@ff@
=@ᙚ@@@33@p@H@p@@z@H@ff@  @  @R@
@R@{@@@ۅ@@\)@
=@@  @z@  @\)@z@ff@@ff@@(@@z@33@33@G@(@@@Q@@RA@\@@ff@@R@33@R@
@A
@@љ@Q@@\)@C@G@=q@R@z@Q@@
=@@@\)@(@33@\)@H@@\)@Q@
=@H@
=@=q@33@@=q@@\)@(@z@@@@z@p@  @p@@@@陚@@33@@p@33@@z@AG@A\)A
At@pA	GAH@@ff@@
=@@陚@@@G@A zA @z@
=@
=AAAA
\AAA
pA\)A
GA
=A33A	A   AA(AAAA  @{@
=@(@@R@Q@@H@@ff@@  @@
@
=@pA
ff@QA-GA  A\)AAGA!GA\A{@A2ffAP(AO33AhAzAffAzAo
AXQA`A0  AIA~\A~ffAaGAUAkAYAL  Ab=qA1A?AS33AB=qAAAAA8QA8QB(A\AAB=qA1A(A&HA&=qAzA0A`zAAffA+33A#AA
A'\)A.{AARA'A$A!GA0A0(A&RA)A+
=A"\A'\)A+A
A
=A*{A A!A%AffARAzAAAQA=qA%A
HA
ffAA
pA{A\AB=qAzAHA	A{AQA
pA+\)A#33A/\)A5pAH(AA{AGAAzA/
=A5A(AA\)A\A zA"HA=qAQA{AHQA#
A AAAA#
A(A"HA#\)AHA
A)GAuALA1AH  AHAK
AUGAO
A5A$(A0QA@(A3
=A((A4A\A)A<A6\A2=qA0zA5A>ffA9ABHAFHAK
AAA$AffAGA'\)A%A#\)A"RA*{A%A$(A$  A$A(A'A"ffA!A
=A"=qA A)A&{A\A"RAA{A=qAzAGAAA{AffA@\@@HA\)@  A~HARA33AffAA
\AQ@A,(A\)A AAAAAGAAR@33@Q@(@@ə@  @33@Ǯ@  @Ǯ@
@pA{AA.=q@H@33A
ARAAQAA
A\)A	AHA
A
=qAzAA(AzAAp@ff@33A
GAHA\A	pAA\AA
GA
A	GAQA
=@@z@pApA
=ApAA  A	A=qA	AffAAA\)AHA (A\)A A(@RAGARA$QA+
=@p@  @=q@@ff@{@@ȣA
A
A(@A\@G@=q@@@G@@G@(@@p@@@HAz@A@
=A(A
A\)A	GAQA
A(AAA	pA
{AHAAA33A
\ARA	AA	AARARApA
A33A"{A$QA A$A&RA*HA/\)A4(A?\)AKA?33AtAQA(A\)AzA33AA
AzA
AA33AsAn{AyA{\)A_AcAyAkASA;
=A(A4A5A:HA;\)ALAAAL(AG33A2\A5A2{A3A@A1GA2\A)A'33A&HA(zA/
A.\A4A/A.{A.ffA.=qA,A(A\)A\)AHAffA  A=qA
AA33AAffA\A\A@z@RA  A\)AApA=qAzA\AAAAA\A$A3\)A0QA7A/33A4A1A,QA,A%A\)A QAA&\AAffAGA33AA
GA33AAAffA\AHA\)AA  A(AHA\AGAA zAHA\)AzAApAA33AA
ffAzA	A\)A33AAA	AAA z@H@@@@
=@(@33@@θR@ᙚ@=qAHA
GAARAH@@{@ff@@ۅ@@(@  @33@H@θR@@(@Q@
=A\@GA
=AAH@H@Ǯ@p@=q@R@\@@@@@z@H@@\@@=q@=qAA)@@
=@=q@\)@=q@R@@@@G@@@@  @@@@@@G@˅@  @\@ff@H@p@
@@\)@ff@(@@\@@Q@{A@У@ҏ\@@=q@陚@Q@ڏ\@  @G@\@(@@p@ۅ@@
@(@@A@  @\)@@@{@R@@@ff@@Q@@
@\@@p@@
@ff@@  @@ff@
@\@@\)@@@Q@\)@  @(@{@=q@
=@\@@@@(@(@@@33@@@@{@H@R@p@H@H@@@(@(@
@G@@H@ff@R@@z@(@
@{@(@@z@@=q@@(@33@@@@R@
=@ffA@@G@Q@  @@
@Q@=qA=q@@33@@@@@׮@@\@@Å@G@@p@H@
@@  @z@=q@}p@@  @z@\)@ff@p@Q@CB@@H@p@@G@@{@@A@@Q@  @@H@ff@z@ff@@@R@33@  @@@@@p@A,(@R@=q@H@@@Q@@{@R@ff@\)@@@@ff@@H@R@  @|@@{@
@@@u@r\@@`  @xQ@
@G@(@@(@@\)@33@{@@R@@p@@G@(@H@33AL@\@@
@H@@33@@H@=q@R@G@@\)@@(@G@H@@R@ff@{@Q@
=@=q@
@\@Q@
@@@pA  @@{@\@p@z@@
=@G@@@H@Q@
@G@AxQ@
@@@@@G@@@
=@(@@33@A\@p@R@
@Q@@\@@G@R@=q@H@p@\)@
@@@p@z@@  @Q@H@@@\)@@@@@z@\)@R@@G@
@\)@
=@@{@{@G@ff@\)@@{A
=@@33@@ff@\)@
=@(@H@{@\)@Q@  @p@
=@HAw
@@Q@@p@pA
=@{@{@R@@33@
@@@
=@@{@\)@@@@H@
@G@G@p@pC(@z@33@\@@
@@@H@@ff@
@  @H@33@@p@(@@{@@QAN=q@@\)Ad@@@=qAG@Q@\@G@QAG@
@\)@  @p@z@RA
=@@(@R@G@Q@@G@p@
=@@Q@@@@\@
=@(D@33@R@@@@H@ff@  @
@  @R@\@@@p@
=@G@ff@ff@@@{@@=q@G@R@\@Q@{@@\@@(@\)@z@{@\)@\)@
=@@@@ʏ\@@p@@\)@G@\@R@  @33@=q@@H@@\AP(Avff@ƸR@\)@ff@u@zAG@  @(@@\@=q@@@
@@
=@{@
=@@@ff@z@@33@{@H@@@  @@@@\)@G@(@
=@@G@\@ffA@H@33@ff@R@  @Q@z@(@=q@@(@z@{A"ff@z@@
@
@ff@R@ƸR@=q@\)@ə@{@  @R@H@
@@ff@z@Å@p@33@R@HA
=A(A@
=@ff@ə@H@ʏ\@G@H@z@ff@@z@@
@ƸR@ff@
@@@{@@@@p@(@@\@33@@  @ff@{@H@\)@˅@z@
@\)@@
@\)@ڏ\@z@
@
@Q@@@
=@{@
@\)@љ@G@33@G@p@@Q@\@\@
=@@
@=q@@z@=q@{@@@(@@=q@GA@\)@z@{@陚@أA(@{@ffA	p@Ӆ@33@z@\)@(@z@H@RA(A@pA((@Q@߮@ffA33A
A	@@pA0QA33A/
A!A	A{AAA\)AA33ApA!AHA#\)A\)A$zA%A
ffAA0zA9GA\A33A+
=A"=qA\AP  A=qARA-GA ARA@HA@{@AA@QABHA=A)pA-A.ffA%A)AffA%A?33A&\A/AAAAA\)A8A+
A8A"HA6\A)A=AEAG
A8QA0  A1A0A:HA&HA@AHzA4AIAGAIpAo
=AiAdA}AuGA(A9AQpA>ffA9AB=qA9A-A*\AaA"=qA*{A9pA*ffAP  AJ\A;
ABHATA[
AVRA_A=qAEpAw
AT  A`zA_AGAh  AAc\)AAAeAmpA\)AR\A
=AA\A
=AAGAAƸRA{A
AlQA33A(A{A33E{\A  A\AAQAHA(ARAzA  AA  AA{AGAQA
=A(ApAA{A33A33A33AAHAA=qAffA
ApAAApAAAQAAGAQAQAQAffAA
AAȣA33AA{AAGAΏ\AAA  AA(AGA=qApAGAA(AGApAGA\)Aʏ\A֏\A(AA{AծAAA\A=qARA\AGAAͮARA=qA(A33A33A
=AAHA  AAQApApAHBQBffAB
AB HA  A33AܸRAAHAHA=qAApAAAAA  A{AQAGA=qA
A\)A݅AApAAݮAffA  A  AHApA=qBRAB\B{BB
=BB!
=B QBzB+B8
=B<zB 
BRBBB 33B#B{B	BBBB
=B,BB&B HB
=B2BB&B&pB)B$
B1B)  B9HB)RB+ffB-pB'{B+ffB&B.(B"B!B)QBB#33B6QB)(B,B(RB2HB&
B0pB)ffB"33B%{B
B({B'B
=B  BBDݠAGAA{A(BBGBpB
B33B\)BffB	  B"B!B/=qB+
B-{B  BB!=qB#B!33B5=qB.B)  B<GB7zB1zB<=qB9GBLQBWBNGBB(B.zBK=qBAB@RBO
=B?HBQ  BCRBBRBTHBV
BWBP  BL
BGBH=qBNRBZpB_GBdBIB@BIRBL\BRHBSRBORB_{B^pBV  B_
BXGB[BYBV33BtBOffBmBrBw
=Bq{Bg\)B_=qBYHBaHBeBRBT
=BbBcBeBaffBdBmHBqBm\BtpBB|\)BpBxBy(BBl=qB_B[\BeBd\BtHBt  Bb\BwB^pB\  Bd
=BiBdpBeRBcGBh\)Be\)BWRB_  BmBnBd
=Bn33BvBaRBzRBsBxBt\BBBB#BlBBjQBkQBn  Bj{BpBs  B^HBm
=Bi
Bw33Bz33BwHBg  B\BB8RBw
=BsBsBxBW
B=qBqBpBv\)BBBffB{33BqBBHBl\)BzzBqffB=B3B{B\BBkB{BW
BaHB~BffBBB B|\)BW
BBW
BzBtffBzzBs(BkBkBiBdBfRBV(BgpBmBt(B|
=BRB{B3B.B=qB{BpB B#BRB#BzBkB(B\B\BBW
B
=BBkBqB8RB{B B\BHB{B\)BBpBHB8RB{BzB#BpBuB\)BGBBBBBW
B
=B
BaHBpB)BBfBBBLB
=B=qB{BBpB
=BBڣB8RBBBHBRBaHBBB(BB3BLBfBuBQBBBffBuBBkBB.BzB.B.BB=qB=B
BB)BaHBB33B.B33BHBBBBLB.B
BpBBB
BzBBBQB\B(BB33BǮBkBqB
BB(BfBEX'3BRBB.B\B B3BBBfB=qBuBǮB=B33BׅBBB  B\BីBبBLB
=BLB  BHBB=qBڸRB؀ B.BƳ3Bϳ3BĔ{BBB
BBBҸRBQBpBҳ3BBkBfBuBzBB
=BGC zBW
B33B{BӔ{BʣB(BΔ{BRBəBfBBGBBBGBB BBkBqBBffBGBpB(BffBpBBfBBBBffB.BǮBBBBpBBQBB  B B\B\)B=qBBBuB\B{B{BHBBǮB BLB\B)B\)BzB
=BBBBB{BB{BBBR33BlpBBeHBHBaHBBBBB=qBǮB8RBBBB\BBRBB\B BpB~
=Bt{B8RB33BB~pBǮB(B.BBB\B\BB
=BB
=Bm33Bi  A\BB_zBmBgpBVB]AffA=qBHBTBe\Bn\)ApAQARB1BCpBV
=BV(BUBKA(AAGA
=B
pB\AE B*RBHAQB ffB&=qAGBQBAHAB zB33B HABRB\)B(BB(B\)B
B*BB!BGBB
B=qB
=B"A33BGA33BpABBQB\)BHBA  AB	ABA\(ARB GBGB
=AA\)B GB   B	AApApBAЏ\AA(A\AA33AA33BAAA\)AAƸRAXAuGAJ{AzA
ApA]AʣAHB#AffA\)A  A  B33AAQAAA  A\)AQApBOzAB
=AA33A
AGA33ApAARA
AA\)AzffA{
AA  AAΣA  A~RAAAd  AuA33AeA\AzAA{A  A(A{AtAxApAuAepAj{AYAyGAjHA\ApAAW33AAA
AlzAg\)Ab\AkAhAd(AcAc
=Ao\)AtAl(Al(AYAX  An{AmAn{AuAp(An=qAqAlQAtAQAw\)AlAsA(A33AGAAzA\A=qAffAAffApA(A\)AA{AAA  A\)ARA{AGAظRAAHB\AA(AģA\)A33AA33AA{AAAzAA\)AzA=qAAAA=qAHAAA\AAGAGA(A{A=qA\AAAAиRAffA33A(Aҏ\A{BAQAƣAQAzAA  A(AٙA
=AA33A  A33ApA(A\)ApAQA  AAA
AAA{AzAGAGA
=AAffA=qAA(B*A=qAңBB
\BzACр B-\B(\B,BB=B@pBB\B{B!=qB%
=B0B zB  B#HAB(HBB]B!
=B)zB#
=B.RBQpB33B)(B)B\B&
=BQBBB(BBHBB
=B{BzB
BQBBffB
33BzBGB33BQBQB{BBGBB
GB\B  BBB B)B#
=B  B \)B&\)B"B B{BzB$  BHBBRB*(B\)B=qBBzB 
=BHB RBB!B*HB0B4pB9(BHGB?\)B?B8(B@BBGBM33B;
=BV
B?B@BABB{BRBLBGGB=BH=qBB{B%BT{BN  BCB,ByB_B9HB=GB:
=B8B<E9>=B,B2{B/(B.QB'
B%pB&B9QB33B(B%=qB B$  B \BffB'(B 
=B zBB!B#B!B
=B)B+\)B#HB#
B%
=B'B0B3BHB'
BpBQB
B  BBzA\ARA\)A
AzAzAQApAAA
=A癚A  BAAQAAAA  BAA=qApAߙAA  AA(BQB{B
B=qBzB
B
B
=BHB
QB,ffB
=BB\)BffBGB*
BA33B ApAA33B(B\)AzAAAA\ApAAA\)A(ApAA
A=qA  A{AHA=qAAffAAGARA
AHAGA
A  AAAGAיAGAA\)AƏ\AHAzA
=A{A£A\)AAA
AzA\AAAAA(A{AApA
AA(AA\AHA=qA\)ARAAA33A  A  AAA{A33A{A\A\)AQAA\A  AApA\)AGAA\)A(AAARAARAzA33A\)AAHA
=AA  AffAA\ARA=qC%A{A
AzAAAAAAAQAAzA(AAQA(AAzAAAA
AAARA\)A33AAAffA  AAzA\AQAzA  AAA{A
A\AzAAAA=qAAHA\)AAApA
AAQA=qA33A
AHAA=qAA
A(AAzA33A=qAQA  AA(AAAAffAQA  A  A\A=qA\)AA  AAQA\A33ApA=qA{AzAAAAAA  AAAffA(AGAAA33AA\)AAAB	QA
A\)A(A
AAffABAA{AAffAGA{A˙AAB{A{A  A
=AϮAAAA{AzA{AA  AAAAAA(CcJ=AARA\)AApARAA5A|AAQApAv\AV\AQpAmBkAd  AfRAzAQAffA\)ARA{A]AA~ffArRAvHAAvRAA
AAA|  AAS
=AvHA=qA%AH  A0(AeGAA\)A|Aw\)AeGAAn\A'AxQAepAAWA<  A^{AL  AAGAQAHAHA
=ApA  AA
A
=A  A QA.HAzA%GAA
AQA.{AApAGAffAA
A
=AAA   A Q@{@A	A\ApA%pAQA7
=A0(A=A<QAMAMAB=qAK
AA)A'33AEARA  AQAA33ARA$(A$A&RA(  A!A&=qA%AGA<A7
=A@A<A)pAK
=A+\)A5AW\)AHAEA=AK33A2RA>{A<(ADAB=qA<zACAJffAApAP  AQGAMA8A9ABHA=AUpAN\A?
=AFHAA?A3A9A4  A"HA<A"{A6ffAzA/A2\A8AQAJ\A3A#\)A7\)A
=ARA4A  B3A,(A*\A(A.ffA]pAAGA=A:\Dk3A#33AA8A!A+A9A0ALA@Av{A8zADA7AP(Ab\AL  AXAP(AXA?\)A?
A<A#33AGA"\A$A4zA'33A1AIA(A:ffA4(A9AF{ATzA;
AB=qAAGAZ\AEpA1AJ\AN=qAffA.{AA'33A\AJ\AG33A`(A;
AAK\)ACAMGAwAxAj=qAaApAdQA\Ah  A`QA_A`AEpAG\)ARRAIpAL(AGAG33AV\AJffAW33C\)AG\)AS33AMAO
AARffA^ffAXATAXzApATAeGAnRAp  A_\)AY@A]pAepAs
=A
AAf=qAj=qAvRA
AhQA_\)AQAc
AzAZffA_
Ag
=AUAAbHA[AHApApAHQ@A\)A33@{@@@Ǯ@@
@ȣ@@\)@@\)@\@ȣ@
=@(@H@\@@@˅@{@\)@p@pAz@߮@
@ٙ@AR@@pAz@AA\A%A/33AGA{A>RAJ\?R@@
=@Q@?ff?=q??
=?33@   @\)@*=q@
=?R@\?????\)?  ??Q?n{?n{?G?h?Tz?\?k?k?aG?  ?G?h?J=q?s33?ff?{?ff?\)?z??H?=q?=q?zH?z?  ???  ?p???\)??Q?H?33??R?z?޸R?ff???R?
=?=q?R@
@Q@!@*H@)@Q@{@ @@4z@H@!?У?zH?u?xQ??
=?{?G??33??\?\??\)??\)?\?xQ?W
=?fff?Y?G?J=q?^R?J=q?333?Tz?O\)?c
?G?E?E??H@G?˅?H?\)?(?R?(?H?H????p??ff?H?R?=q?{??\)?У?=q??z?z?\?z?8Q?fff?J=q?\?33????H???ٙ?
?  ?=q?ٙ?޸R?33?{??ff??  ?(?G??ff??R@=q@?(??5?>>
>Q>
=>>G>??
=q?
=>H?:H?!G?^R?Tz?:H?:H???G??s33?fff?u?!G?(?8Q?\?H?
=?
@\)@
?\)@ ?33?
?
?p?˅??{@
=?Q?{@33@G?ٙ?Q?z?ff?(?=q@ @
@G@\)@ff@@ ?  ?p?=q??p??Q?z?=q?z?.{??(?L?G?ff?B\?O\)?+?!G?.{?=p?!G?z?
=q>ff>(?#
>\?
=?h?=q?xQ???(??Q?ff?n{???\)?Q?
=@   @@??@   @Q@33?\?\?\??R??
=?
=?ff?????  ?У?(@@@ff@@.{@0@!@\)@(@@33@@@
?Q@@
=q@@33@   @@ff@
p@@
=@33@R@Q@\)@\@(@   ?R?{??У@G@@z@
@@
p@
@ ?z@
=q??=q??=q?{?{?\?=q?H?
=???
?  ??n{?h?G?@
p@'
=@?\)@;@A@2\@;@p??=q??xQ??z?\)??H?H??\@G@@
H@@@
=@p@{@
=@@@
H@Q@33@G@z@\)@@@
=q@@   ?\)??@ @ ?p@@   @@
=q@
=q@	@@
p@(@{@
H@33?(@G?z@	@z@G@R@R@\)@@@Q@"\@\)@!@p@   @ @@G
=@,(?=q??  @\)@z@@?33?H@
@@   @ff@\@
=@33?
=?H@ff@?@@
=@%@/\)@z@@@H@{@
H@@\@(@#33@"\@(Q@8@@  @HQ@0  @R@$z@(Q@-p@1G@.R@333@;@8@=p@>{@E@AG@;@AG@AG@E@>{@?\)@I@N{@QG@JH@L@Y@_\)@^{@@  @>{@8Q@:=q@5@8@9@>{@9@0  @/\)@,@7
=@@  @G@Mp@W@[@X@qG@l(@q@r\@(@z@
=@\@\)@{@@ ?
=??=q?=q?=q?H?????p?p@@
=q@	@
p@G@
=@@
@@(@@   @&ff@ @@@ @$z@0@0  @AG@Mp@I@L@G
=@P  @P  @[@S
@P@P  @Q@U@[@c33@b\@u@\@@33@@H@@\@@  @=q@@p@\@(@
@(@z@@{@@@@@z@H@\)@@@p@{@H@R@@ff@33@@  @@@
@@@@Fff@333@{@{@{@@\@@@@33@Q@=q@p@'@&ff@&ff@+@;@;@G@P  @Vff@hQ@U@]p@^R@a@g@h@qG@z=q@@@33@R@p@  @@z@(@@@|(@=q@=q@=q@@  @
@(@u@hQ@dz@a@`  @W
=@S33@R\@S33@P@P@R\@S
@S33@S33@^R@jH@xQ@|@|(@w@x@p@c
@^{@_\)@c33@`@b\@c33@fff@i@nR@nR@p@y@|(@z=q@
@@@p@\)@@@\@y@hQ@k@dz@i@j=q@e@`@l(@`@U@U@\(@X@P  @R\@U@P  @U@NR@P  @QG@U@XQ@[@\@dz@mp@zH@(@|(@Q@@(@(@@\)@p@@@H@z@G@R@G@  @  @
=@R@H@@=q@@@\@\@@{@ff@
=@z@Q@  @H@H@Ӆ@Q@
@@@33@޸R@H@H@
@ٙ@ᙚ@@@@\@
@  @  @@@@z@@  @ff@@{@  @(@
=@
@  @{@Q@{@p@Q@@@
@H@=q@ff@(@@G@33@@ff@ff@Q@\)@R@@@z@@R@@
@@  @@@@@@@@@@(@\)@  @Ǯ@G@Q@=q@33@G@(@@z@@@陚@
=@z@ff@AffA @A   AAGA QAHA
pA\ARA33@\)@R@{@@ff@AGAQApA QA,  A-A:ffA:RA(QA4  A-GA*ffA'33A,(A1A-A+A*ffA&=qA$A=qAGAAA@=q@{@@R@\@@p@@
=@z@˅@@Q@@@H@@(@
=@p@@p@@33@  @@\)@G@
=@@@@@p@@z@\)@\)A AAHAA	A	A33AAA
=qA33AQA33A\)AHA
AQApAffAAQApA
GAA
A
AAA
A
AAffA  AAA
AA(AARAAARA{AA
A
=q@(@ff@{@
=@ٙ@Q@G@  @=q@
=@p@
=@\@=q@ᙚ@ff@p@(@@\)@33@@(@@
@{@@{AAQA33A
AA	A	AA
ffA
ffA\)A
GAA
\AQA  A\)A
A
=AAApAAQA2{AAAGA
=A&{A!A#A&=qA&=qA%A)A%A'33A%A&{A)A+A.=qA+A,A0  A.RA.{A+A&{A,A'\)A+A*HA+A)A&{A!A#
=A'A#A%GAffA33A\A"RA+A*RA
A@\)@
=@@ڏ\@
@(@  @=q@z@ff@ff@p@H@z@
@Q@@p@\@@z@H@(@p@@@@
=@z@ᙚ@@@R@@H@z@(@@ff@z@  @A   A   @pA=qAA
\A(A\)A
A
{A	A
GA33A\ARAAAHAGAA(ApApA=qA\AQAA\AAAA(AA  A
pAA{AAA33AHA
=AAAAGAAAA{A!A QA%pA%A$A#A.RA1GA/33A3A+\)A&ffA/\)A<  A@AG33AD  A<A3
=AAABHAJ\AF{ALAAAAAH  AIAQAOANffAPAJRAHQAJ\AMGAN\AS33AR=qARRAXzASAUpAX  A^=qAYGAZffAbHA[33A^RAlQAgAoAk33Ap(As33Ak\)An=qAtAqAtzAmAt  AmGAs\)ApAtAl  AtQAw
=AxQAv\Av=qA\AzRAzA}AA
A=qA}A33AGAAzRARA  AA{An\AA{AAo
AdAT  AZ{AV=qAZRAaGAVRA\  AaA\AVRAAA?\)A8QA2HA333A>{A3
A?
=AF{AG
=AR\AS
ATAVHATARRAK
AXQAYAQGAW
=A[A\QA^\A_
AaAfRA\  AX(A`ApAfRA^RAb=qAbRAfffA_AiAc
=AhAcA\(AaA`A`(A`Ab{A_AbRAc\)Ad  A`  AdzAmAo\)Ak
=Ao\)ApQAs\)At(AoAqGA{33A  AAGAAA\)A\AyA|A
A~\AyA|zAffAAzAA(A(ApA(AAAA(AA(AAAGA
A|A~{AuGA|AyApzAj=qAd(Al  AlAn=qAVHAYGAbffA_\)AZRA[
AbffA`AYGA_AIAUATzAMpAR=qAQpALAEpA@QA@A:ffA?33A@A?33AC
=AB=qABRADzAEAEpAC33AJRAKAHQALAMALAQAR\AO
AR=qASAQAOAR{Az{AAA=qA  AtAyAs33AvRAtA}A}AtAo\)AtzAv=qA~RAs
=A{
Ax  An{AiAn{Af{AhzAlAiGAeAf{AeA]AiA[\)A[
A`(A[
A[
AXAS\)AXQAO33AK33AN{APAJRAIpADADzADQA?33A:\A
A  AA  AA A&HA'A#
A&\ApAHAAffA{A
=AA QA#
=A$(A$A$QA(zA'\)A-GA/33A*RA2=qA2=qA2ffA1A4A6ffA8  A:HA=A>ffA@(AAGA@A:{A;A=GA>=qA>ffA<zA?A?33ABHAG
=AC\)A@QAC
=AFffAIAK33ALAJHAJffAKAMAFHAL  AFHAJ=qAJRAHAGAH(AHQAIAIAK\)AS\)AMAEAIAK33AQAHAEpAAGA=pA8A6=qA6RA,A+
=A+33A,A((A$  A%GA"ffA"{A(A)A$  A+
A)A'
=AAAAA\)A=qAffA"HA!GApA'33A%GA'\)A)A(A-GA/
A4zA.ffA+33A/A0  A0QA5A8  A9pA8QA7\)A733A9A9A<zAAAG
=AIAJRA?A5A4QA/
A2\A`zA{A
=AB
=B#zB9
=B7pBC\BIRBTBb=qB`Bz\B~33BffBLBBsBgBOBS
=BHBC33B?33B9B5B9B7B5=qB2B.B(B#GBB\B(B=qBBB ffB$
=B  BBB{BRAAGA  AA{AQA
=BAAApA33A33AHBB=qAA\)AAAAGAA
AAAffA(ARA33AAApAHARAB {BHAA\)A33AA
=AAA
=A
=AAGA\)AARAA\)A噚A\AAAGARAAAffAffARA
AA  AQA
=A{AAAA\)A
AمAأAA
=AAҏ\AffAApA
AffA  AzAA  A
AzApA\)A\AAAAAAQA\AA  B=qAARA(AA  AA{A33AAzAA{AHAA
AA
ApAGA\)A=qAffARA\A{AffAzA\)AA\)A\)AHAA
=A  AAGA\AQAA  A(A(AA(A\)AA{AAHA33A
AHARA
=AQA33AAAzA\)AAzAAGAAHAGAzAQA\AzA  AHAffA  AGA\AA
AApA
A33AGA33AApARA\)A
AAAzAHAHAA
=A33AA\)AAA
A=qA{AA\AA
A\AAHAAGAGApA33AAAHA\)A\)AAzAzA{AHAA=qAAGAAQA\A  AAAAA
=AAzAffAGARAAA
A\AAGAffAffAA{33AGAx  AA  AApAApARAA  A
=A=qAAzAHAA=qA(ApAQA  A(A=qAA
AGAGA{AzA
=A
=AzHAyA}A{33AyAtQAwAypAzHAqGAtAyApQAwAw\)AtzAw
A
=AApApARAAGAffA=qAA
AAAffAA  AzA{AA
=ApApAAAAGAAzA33AApAA(A
ARApAAQAAA33AA33AHAA  A`A`QAf\AbHApAd(AgAoAk\)AhQAn{As
=AuAvHAx(AtAsAxAyA|  Ak\)Ak\)Ac
=AZRAYAHA@AIAH(AEAJRAC\)AGB<ffA@=q@@33@AO@(@
@@zA$zAAA+A(A1GA%pA*RA*\A1pA/A;A5A6=qAlAAmApAuAw
=AqAs
=AlzAw
AlAlAw
AyAx(A~\A|  A}ARA|AxzAwAiAo
=AbHAh(Ag
AbRAVHAPAIpADzAAAF{A7A3
=A_
A&HA*ffA'A.{ARADzA/33A0A,QA.HA333A2HAAGA4zA3
A<A2\A-AlzA:HA6RA<  A<zAC\)AEACA;33A?
A0A,  A+\)A-pA4A6HA>HAB\AFRAIAJRAIpAFHAAAFRAHQAMA_AHAs33AGAJ{AP(AVHAPAVRA\A\AaGAGAZHA33A~ffAx(Aw
=Ax  Ao
AmGAAqAPAUAZ\Ap  AyGA
AqpAk
=AiAhzAk33AjffArRAs\)A|QA~{A}AyA}A{Az\AsAvRAk\)AnRA
Aw
=Ao\)AipA]GA`ApQAeA^ffA`AW
AbffAbffA`(AfffAk
=AbRA]GAP(AVffA(A'A\AA
AAGA(ApA  AGA%A!A"=qA&HA&{A'A((A((A#A%GA#
A*ffA)GAN\A,A0  A,(A-A
=A3
=A>ffA/\)A-A0zA1pA4(AHzA6HA;ADzABHAMALA;A8AAADAQAO\)A\)AoATATAQpAqA\)AAwA`A]AUAIA@zA>\A=GA9A9A6{A5AA6=qA0A4  A5AHA/33A+A/
=A.ffA*ffA.ffAPA+A+
=A(Ad  A)GA$zA-pA+
=A+
A(zA#\)A'A&HAAGA
RA AQ@p@@R@
@{@G@@=q@@@\@
=@H@H@(@@H@=q@(A@@H@33@33@=q@@@@H@33@33@@@@z@
=@\)@@p@{A4QA,(Ap@@AHA@  @G@H@{@ffA/@
@Q@@R@A(A@\@@@@\)@R@@=q@A\AGA$(A @
=A A AAA
A
A
pApA33AQA	AAAQAA33A	p@A   @H@@G@@H@(@
@@Ӆ@z@z@  @
=@
@\)@޸R@=q@
=@߮@=q@z@z@ʏ\@У@  @@@@
@{@p@\)@ָR@(@33@Ӆ@  @У@{@@p@ᙚ@@p@H@
@@(@޸R@=q@ָR@@߮@  @=q@  @33@33@  @ڏ\A2=q@У@=q@@@ff@@R@θR@
=AzA\AG@
=@@ff@  @=q@@R@\)@  @@@@H@@@H@\)@{@@@\@\)@G@(@=q@@\)@@G@@33@G@(@  @=q@G@G@G@@@@z@@@H@R@(@R@  @  @\)@@\)@@33@H@\@@@@@H@@@@\@
=@G@z@@@R@(@H@R@
@
@ff@z@p@
=@
=@R@  @@=q@@B1H@\)@@y@u@p@nR@\@q@jH@g@b\@p  @fff@\(@c
@S33@_\)@W@  @o\)@JH@<(@G@A@:=q@%@,(@.{@%@4z@8Q@0  @(@6ff@)@0@P  @Dz@(Q@'
=@-p@Q@@
@R@
=q@
=q@@ff@@
=@
=@?@?H@
@@Q@@*H@1@=q@+@@z@@\@%@!G@!G@,@"\@*=q@=q@.{@.{@@;@;@E@aG@R\@JH@HQ@<(@>{@?\)@C
@XQ@:=q@7@Q@G
=@=q@(Q@p@\)@\@@@  @.{@   AR@@U@{@33@\)@׮@{@0  @7A@:=q@@0  @8@P  @r\@@@@\)@  @@R@w
=@mp@l@@
@\)@\)@z@]p@o\)@jH@e@jH@k@dz@~{@w
=@{@|@=q@@@H@@Q@@HA@@{@\)@=q@ff@ff@{@@G@(@=q@
=@
=@@Å@p@AAG@@z@G@
@@  @33@{@QA&H@p@
=A(@˅A(@
=@@أ@G@  @@R@  A{@\)A=q@Q@
@=q@Q@S
@<@_\)??޸R?  ?{@r\?(?=q@,@
@@Q@?Q@(?
=?(?33??
?=q??ff??Q?@!G@@ff@%@H?p@@(@p@333@7
=@;@\)@u@  @l@w@H@y@Q@{@@{@z@@@
=@
@@z@(@A>H@G@\@@(@
=A<@{@H@@=qA@R@@A@GA<AA,  @  @QAQA
@@
=@z@H@G@Ӆ@=qAp@p@(@@\)@(A{AQA@Z=q@=qA\@0  @8Q@@XQ@>{@*H@5@:H@u@@(@(@~{@(@\)@p@\)@\@@p@\@~R@G@\(@^{@fff@c
@b\A
@ZH@`@qG@\A;\)@@HA;@
=@{@q@@p  @@@@@z@@AFff@
=@
AA_AQp@@@A
=A!A Q@RAK\)AG@G@@ffA@(A_@ҏ\@@ᙚ@ٙ@A33A@@ffAJH@p@@
=@@@@  @\@p@A{A@G@
=@@=q@
=@H@  @=q@QB#Q@A
RA<  @G@@{@{@  @@@\)@@Å@R@Ǯ@G@Ӆ@@G@  @z@\@@@@A Q@Q@33@
@A zAzAA
=AGAHAA$(A$zA#
A2HA/\)A2{A1GA2\A7B 33BA<QA9AB\A
=AOAv{AbHA.RA6\A6{A@AEpAK\)AL(ABHADAK
AJ=qADQATQA{AOA_AK
A33ApATAG33AW
=AřA=qA{AffAGA1ApAB  AAK\)AA
B)AA8A@zARAAH(AA+AA=qA
AA(A
=A(A33A\)A
AA AA
A*HA+
=A
=A-A6{AG\)AWAzAHAffA:\A7ABaHB;RBpA
=AA`AmGAmpAAA=qA  AQAffABQ33BB8RB  ABx\)ABqffAffARA
A(A33Ar\A\)AzHAxAtAAmGAo\)AypArRAw
=AHAAAGAAAffA
A\)BA\)A
BW
BuB  ARB"BuB{BBƮB33AA\B#BA
=AA=qAb\AbffAg\)ApzA\A\A
ApQA2HA&RA(A1A+\)A+
A\)A-A-A4zA4(A9A8  A8AHA>ffAPAXQBAңA\)AffA^{A|zAAHA
=AzHAA
AGBB]  B  BT(BHBBrRB B2
=B:RBBA{B.HBB3AffAApAffAŮApAffAԣBuB33BҀ A{AA(A\B6pA33AzBpAAB=BUpB4B2B[
=B\A}Ak
=C'@ BQffC
3BxBBpBD
CIcB{BA\ABRAG\)BB,BGBY(B}B\)B7A\BpB(BBRBBA^=qAAo\)AA|AA˙Ar{AHApA(ARBs(BXpBqB8RBBZCQBRA
=BBBffAHAǙBfB1HB4AkAw
=Al(AxAzBB(B=qB3
=A(ARB_BBA=qAAA33A\)A{ARBQAAAGAAAAA(CpA
A(B QA33ApA(AӅAHBUB=qCAAHBVAîAffAA\)AHAď\AB{AzAAzAQARA
B(A\)AffA33AǮAˮA(A(AffAA(AA{AGA\AffAA\)A=qAQBkRB =qB\BJpB'BLB633CfBkBu=qC BHBBB33B
=BffBGB
=B;BBVGB5BdB  BB.HBBB.HC,!HB{B=qB(BzB\BpBQBHB B-GB*  B'B,{B1\B.B.(B>zB;B3B6BA\)B6(B9=qBBpB<ffB5QB)Bp
=B8(B-(B2(B5B^ffB%QB&\)B+  B,=qB/GB3{B0ffB"B$33BffBi(B!\)B1B*\B6GB,
B,B=B.HBAHB,QB8  B8QB@BL\BHHBZ
=BSBk
=BozBO\BRBVBU\)BPpBSB B#BK  BFHB@BVGBjBzBv{BLB_B=BB{CaHB=qC	s3B  CPBB{B33BqRBy
=BtzBǮBqRBqzB
Bn33C$B(B|\)B
B~=qBBB|(B\B{B|pBn  BB(B
BBB
=BBB
BB{BB3B\BffB[{BXQB=qBd=qCCFfCC
AzB4pB*{AH@zAR{AH@
AAL@
=@Q@
@AHz@pA@z@C33@p  @!G@@A?\@R?\@(@ə@pA<CRA-@^{?Ab=qAff@   A(@AA33@zA8Q@@%AffBA
A-As
=@P  A@An{@@B B33@l(A8@ᙚA,  B_?H@A6ffA@@
@p@GAA
=C@33BC?\?\?B@
E@'
=?A\)AP(Az@*H@G?\@{?xQB?zA#\)@<(?33?޸R?h??5?
=?Q?Q@=q@e??0?u@ff@(@H?L?h??A+\)?O\)A(?aG?n{?Q?G?W
=?p@@_\)@@HB@У@"\A?\)A{@R@AffBsQBB"R@z@3
@
@@|@z@S33Aj\@\)@@A{AAA=q@S33AA=qAL(?p@\@@@Q?Q?z?@@G?
=?ff?G???Q@$z?n{?u?Tz?\?u?Y?zH??  ?=q??H?p@?H??
?G?
@
?33???(???@)?(?R?(?\)?Q??p?\??  ?{??\@??z?ff?G@#
@3
?ff??H?H?ff@xQ?@@n{@`  @@@G@
=@  @ff@@   ?G@(@@z@!?Q?ff??ff?G?ff?33?R??ٙ?\@?@
?Q?ff??\)?
?z?Q?H?p?
=?=q??ff?{?(?˅?=q?  @#
??޸R?33?{?
??\)?˅?@+????p??ff?(?p?
=?H?Ǯ?޸R?\?=q?
?ٙ?\)?33?H??\@"\?У?ٙ?ff??
@b\@@@@??33@{?Q?@p?p?
=?  ?@z=qB333@QB.ff@33AT@PB{AHD&^B=CfCFB33B8RA)B
BA
@\@A?\@W
=@I?\)@{@g@p?@ff@ B.?BBr(@L@\)@"\@H?@H@{@
@%?(BA33@I?Q@GA0A1pB_@,@s
?G@?Q??R@ff?Q??
=?Q?@:=q@?R?
AaB@
=AQBP
=B5zC6@p@@(A
=CuAأ?B@
=@=q@AvH?z@y@B)AdA\)AAzBq?
=@l(@QCŀ ??(?
=@  ?A@AB^\)A\)@S33@@
p@\C%@@\)@Q@\@
=@8BS=q@{?H@7?޸R@
pDU3D  @@@GEH{@@&ffA8(@Q@N{@L(?\?=q@U?{??˅@R@	@ A>{@p?@z=q?{@}p?У@?G@>{@G?D=??33?@33CG)@@   @S
?{@(@ff?ff?33@_\)A?@(Q@C33@H?H@*=q?
@p@5@p@NR@{@\??33?{@i@GBz?C?ffAGCaHD#2B+{??ff@Dz@{?
A@@!G@b\@@Q@A1@  ?@@QG@&ffAA\)B=q@AA\CRBL@G@]pA@Ӆ@
A  @QAAG@
=B]H@=q?
@G@
?@}p?Q?p?z??˅??У?(??޸R?޸R@S33?
=@3
?(@r\?(?ٙ@4z?G@zAQ?Q?=q@??
=CC?C@@{?@9?H@<(@
=A	AzAAS@ApC4?ff@>RAR@b\@GB
AC
BA\)@  @\E$fA
@33@zA@`@\)@vff@G@(@Q@{@Ӆ@33@@A (C"(A4@:HAAUAA@  C%5@
=@@p?Afff@-pChB@+AR@
p@=q@@$z@@\)@"\@ff@33@(@\@@  @,(@*H@r\@g
=@(@@\)@@@
AwAR@HQ@,(@
=@K@E@8@AȣAff@p  @ffA
@l@{AS33@pDg\AC\)AyGA/@\)@Am@Z=qA@\)@\@G@
=@@(AG\)AffA
@ָR@E3A33C@θRD尤@  D@޸RBffA.\@p@HBBBffCYBZ@A$(A%@QA@AHAmAAg@=q@
@AA
pA(@
A1B@\)A>{@@XQ@g
=A
=@H@@Mp@>RB\DFf@@@@  @A)A1A
GAJff@}p@@Dc5D*qCRAB3A|A"H@A&HBBn@B =qAffAAECh@=q@A+
A\QA\@HA'@33@@Q@@H@ff@(@@(@Q@G@ff@
=AG
=AzAG
=AAGFM
AA]BRB(A1A(zA@g@UCy}q@AB33@_\)@~RAGAQA
=@{Ac33BKzC>xRBzB\)A(B=qA-@  BVBW
BuA(@\B=qB 
=CB
=@\)@zB@pApAA QA&HA8A"ffBBǮB

B}  BABAۅA/
=A(BAs
AiBB\)Aff@G@@RAl@{@pAzAAiA6H@zA)@@  @33A\)B  A\)A33Ap@=q@\)@p@Aq@  @@@pAK\)A[@pArR@A33@@(@أ@=q@@
=A0QA @(AAffB!BIAG\)BB =qA
pA33C}qC^xRB{@C(xRBʽqB0
AkAg
AA(AîBA=qB
AA\AYA{C}{DBDEB\)BkAA=qCs3AAG
=A
=ETc\C"ĈCAA
B8RBr=qB{AHA33AHApA(A z@RARA
Ac\)A\)AKAAAffA
=A33ApAzA"HA6{A\)A{AAEAUAALzAARA33AzBA  @@@ff@QA=qAGC%&f@Ӆ@=q@33@A
GA@@GC!HDC~T{AA-A@A8(AWBu@\)@{AHBA
=A33B ffBz33C-hBq{A0QB
Aw
=AC BaHA(CuA
=qARffA
=A)GAy@Ӆ@
=A
AC>Ahz@
=B)AqAaAWA5A\A@
=E$@=q@@@{@ə@\)@z@
@GA (A=qAApA_33A
=Af=qAAA4QAGBx\)A+
=A4A$QA
BpAA
A/
=A\A\)A  AuAQAGAS
A*R@{A@  @Aff@@@BkB}CA  AffAzAAHA  A  AzA+AffEfAqA$zA	GB&pBH
=APQA#
AXA
A{A`F'1Ci33ARA,(@@33@\)@p@A
@A Aw
ABHA
@(A-@HF)E?@33@C}qBA@
@ff@@ҏ\@{@AB
33A Q@A33BGAe@GAnRA'
@ָR@=q@(@H@z@ffB{@
AAT@33@@
=@G@A	p@p@  @ff@ffAXz@׮A9G@ff@A
A"\@@@ӅE8C|f@\)AHD^'
CCYAģB8GAHA&=q@ȣE@
=B@{@R@@
=@@H@ARAA`QB @Q@<@?pB 33@\@{Er
E
B33AC@AHADθBkHC_pA~H@HA (BB AA{@K@|(@(@Z=q@e@g
=@(@\@@p@yB<ff@w
=@G@@zA<(AA3
=B֙B(AθRBQCCuB
=BGB"zB|HCA<zA4QAEA=qA\)Al  ApBAAB=@@AXBRB%B\BB#B`33A
=BRC)@AG@W
=D DAFffAp@\BQAFRBV33A(@A(A\)@@/\)A(AYp@33@pAQ@A\)@&ff@
=@A2\AV\Ac
A\)A@BE@=qARA\ABC%B5zB\Ap@AQBGAQG@A\BuBQA\BB^(AEA{B
A
A$  AŮBMHAIGBi
=BAQA@
B  BO=qAB  BC>CX@
AB`33A8B3@A=GBB%@GAzAzRAȏ\AZ{B-QBqGB9ffB)C=CYB)A)ABA)A2HBLBΊ=B2\)@AaAg
AA(A8A#\)A(Al  @(@ARAffAR{@\)@33@=q@  @ə@@R@@@
=@(A?
@p@AO
A@33B(@\BfAn{B~ADBHAzA*ffAmAC\)@A'33@\A>RA9BRB\)C8R@pBB9=qA  B33BƔ{ASAQB{@\)@
=A{@zA\@@@  @@@A@(@(@A7
BNAq@U@O\)@  AffARAUA  @A Q@@j=q@\@@\)@@GA@A%A@AjffBAHB&pAw@@zEn@@@\(@N{@ZH@W@QA	@
=C\C8RBcffB\)AQ@BBHBή@p@{A=AAv=qAVHAC/B=B`\)ADA QA~\@pDA=qC.CDRCZDDA~DqCS3CDxRDCIB33B CFfCƽqA
AzB=C
hAX  AwA\)CtB.\)A֣C'@ Cm+A>\B.
=C+\B\CȮBuBB)BffBB\BB=qB7\BBN
BuA=qB'H@(BCJ=B
AGCB\BB&BBB[\)C8aHB\)BBBffAB
=A(A9pB=qB6A.{Ahz@
@
=AA0(@
=@\)@A6=qBx{B 
DmUD)B\)BBp33BpBfBGC'  C+
@ApB  A@B!B33C&@BYC޸B>=qAхB\C$YBAB@33AO
=AϮB]ffBB3BǮA?
AQA{A
=BV\)B{B33B(BGBkBIBkB3B=qBRBPAp@AYA@HA(B\)BHA
=DCULD FDE1W\EBLABHDYDBB4A\A
=BB\)BmB<zEEvXRC\BRA
B˽qB3B2B
BB 33AGA(BRA=qAAƣARA(B4B<zCHB&RC$YCPA
=BAB\)B=B7BS{BB	RA
=B=qBHBN  B%(BBHBfB\)BBGB=C	5B܏\BpBB*(B1B4  B=qBffBB%RB\GBqB3B \)BBBBBGB5
=AQB3B  BqB  B
pBBEGDHC{C
E=]D/
C$BT  BffA{B
A\)A{AzB{AHAE*AjffALQ@z@zAGAUAAAAHAuAffA(B2\)Bh
ATA5A[
ApAA(AIAAGA:RAKAAAHA  ABsBpB\AHA(AffAAffAffAAA
=Aw
=Ag
AAA(ARA\)AAGAAAAAGAAg
=AffAAaA`(AfHAk
AkA}A
A|Ap(AuA|(AyAAARA=qAAA  A{AAHAAA
A\A
ARAQAA  AffA\AzHA
=A}A[33AmAqApAAA{A\ApAA\AARAHA\)AARAAAA\AA(AHAzAQAAAA
ApAAAAffAA=qAA\)A\AAA
A=qA
=ARAApAffAHA\AzA\AHA5A&{A+33A!GAA A-A4  A8QA<  AAAFHALAMANffAPzAZ{Ap  A\A`AmA]A]pAdAkAc\)As33AzA{
AA(AdQAw33A~ffA=qAxQA]pAGAH  A)A>ffA?\)AK\)AKAG\)A?AIGAAADQABRAHzAPQA\AlzA
AhQAdQAEANHATzAMpA[\)AuAl(ArHA=qA|  AA  AzA(A\)ApAzAQAQA=qAA{ApA33AAAffA\)A\A  A(A
=AffA(A=qA(AA=qApA%A#A*RA0A8A:{A>RA@(AHAf=qAG\)ASAQAQAQAUAT  An{AXzA`  Ak
AkA]GAlA[AZRAc
A]Af\AdzAmGAp(AyAeAeA]pAiGA]AhAqAxQAyA=qA33AQAzA
=AzAv{AkAbffAhAW
=AUAk
=A^{AG
AJ=qA^HAdAWA\(AlQAmA^ffAZ\AdAzRAxzAs
AzA~HAz=qA~ffA~\AA{
=AffAdA^ffA^{A]pAepAR{AZRAYAUAXA\(Ah  AfRApAr{AvffAt(ApAs33AtQA=qA}GA
=AA
A~HA~RAz{A|zA|AypAp(A\A\A]AcAl  A}ApApAHAz{AA\)ApAA{AAHApAAAAzA=qAGAAQAAA
=A{AA(AARA
ARB;ARffA^ffAIGAW
A`AipAj\Ab=qAeGAb\Aw33AA=qAA{A
AA\)AQA33ARAHA\)A33A\)AAA=qARA=qAAA=qA\A\)AQA  A(AGAQA=qAAAAAffAzA33AAAAzA33A
=AHARAGARAAGA
=AAAAHA{AAffA\AA
ARAAAApA\)AAHAAA
A{AAAAAABfAGA{AApA=qAGApAAA=qA(AAA\A\)ARA(ApARA
A
=AQA33AA
AGAzAHARA\)A{A33AApAA(AAAQA\)AA\)AAHAA{AffA=qAffApAAHAAARAQA
A=qA\AAGA{A=qA  A
=A33A  AQȀ\AAApAQB=qAA뙚AB˳3DqAHAAA
=AA{B
B\)B(B=qB,B7  B0HB7GB(pB;B5B?RB1B5B-B%BHBQBBB  BHBRB!
=BB33BHA
=A33AA33AGA
A홚AA
=A
BARBHBQBBpBBB&pB,B(GB,ffB0BCHB7QBEB`B6pB7
B;=qBmBJ  BWBffB5B$B7\)B#RBzBffBzA\)A33A
AυAA  A  A  AffA33ApA(AAA=qA  AA  AA{AAA  AAAAffAAAHAAAffA{ARA֣A33AGApBAffA{A{ABAffB \BB RBffBB
=BB
=B
=BffB
AB
\BB  BBQB  BB!B'\)B6BCBBB(33B?zB>{B*ffB$33B1B2  B.\)B'ffB*  B-pB@B,B!
B+B$HB-(B+RB)B6RBF
B'
=B'  B.\B<RB8BI  B`B=B4B.  B.ffB*
=B/BB!B#\)B"pB(zBBQB\BHB!  B"zB#
=BB"BB ffB
=B\)BBBBGBBRBB{B'zB'
=B.B2ffB7B-B@
BJB@HB@B@QB;zB=  BC(BDBMBSBTffBTBLBSBX
=BS  B[
=BU  BIBFBOQB?
B<B@B>{B.{B4
=B3
=B2RB;B6\B?GB:RBI{BbzBQBRBJ=qBGBXBV
B\BZ  B\BVBZBZBqBqQBsGBtB{BB=B~BrGBzQBmBGBQBKBI  BFBCQBC
BERB>BCBKffBNQB={BLGBMBKBa33BUBZBWffBT  BVBZpBaBf33BfBqBnBkzBmffBpByA\)AiGAiAhArffAxQA|A\)AAA=qA=qAffA˙AA
AGA(AQA
B{BBHB
=B	RBB	BffBBB(B  BB+B>RB0\)B.  B,B,\B1RBF\BE33BKBZB^BcBbQBZB_B`BZ
B)33B<HB@B,ffB#B6\)B/B2B/zB*B.HBLB^BK33B;  B6
=BJBE
=BI
=B>33B:BCB7GB5HB-ffB6B:33B`B?zBFpBB=qB8HB;pB=BDpBFB>B&
B*B)B6GBB(B
=BGB33A
BzA33BffB.33BqB\BaHBRBd=qB^GB`B\\BO33BVGB{B(BОCs3C C"RC8J=CRC
xRC hBBRBBQB{B=BBB(BɞBBBBB BGB.BBzBB{B{B)B(BBBBpBBBBpB\)BBB Bq{Bp=qBN
=BE33BJBIB,B<BARBJ(BS33BX33B~GBBoBBzBBffBwB#By  B^=qBH\)B;
BD{BGBQQBR  B_
=BoffBuBGBfBW
BǮBBuB  BRB  BBuBqBBBǮBBQBqBRBB)B=qBpBQB  BBB.B
B(B  B33BLBB{  BBB8RBuB)B
B#B
=BkBB B#B)B#BB)BB{B\BW
BBBuBBB=qBB\BHB\B=B\)BBGBHBBBzBHB}HB~{B{\BxBW
BW
BrBlQBm33BlBpGBvBi
BlBoGBjBdGBc
=B`B^RB`GBg=qBbBfBgGBX(BYBXpB[QB`B_\B\
BYQB](Bj  BcHB[=qBb=qBg  BhGBgBs(BrpBw
=BtBmHBt=qBnpBuBB{BBBzBGB  BzBB33BW
BHB(BzBpBBBfB.B{B
=BBBBffB
BBBBkBBLBHBB{BzBB)BB\BzBGBpBGB{BLBGB3B=qB{BBW
BRBBBB33B\)BBB
BLB{BW
BaHB  BaHBBB#BBB{B{B#BzBB BB{BBBzBLBBRBW
B3B{B{B8RBBpB{BQBǮBBW
BBBB
B{BpBpB#BffBffB#B(BBBˣBB(BB͞BaHB{B
B
BBfB{BzBǮB  BǮBLB˽qB\BGBýqBB(B\)BBB{BBBB(CBLB3BǮBBpBB\B#BuBkBB#B  BkB{BzBzBffB33BBQB3B)BfBBRBB(BQBuBqBpBBuB#BffB=qBBpBaHBzB.BRBRBB=B BGBGBBBϊ=BffBܳ3BB֔{B  B=qBBݳ3B)B\Bя\BfBffBBqBQB3B8RB)B#BffB=qBzBffBW
BQBBBGBǮB=BBBBLB  B33B(BBkBBGBأB
B)BԀ BB.BBB\B(B
=BBB=qB)CxRCGB#B݊=B(BaHB\BGBBǮB  BBǮBLBB33B(BB3BBBBBBǮBBŞB{B=qBǮBBzBBBB֏\BB33BGBaHBB\)B|BBxBs\BvGB|33BBBaHBaHBBB\B{BzB8RB3BBBB  B\)B\)CqCBBuBمBB
=BqB
=BB(B{BW
BBBuBBBGBffBffBzB8RBBB,  ?  ?\)?{?p??(?33?\?p?33???R?G?p??\)?޸R?  ??=q@z?z?У@\@@@
H@
p?33?@ @   ?
@?ٙ???=q?{???
=???z??G?  ??aG?W
=?W
=?h?c
?n{?ff?  ??aG?aG?G?  ?h?.{?+?J=q?#
?+?+??G?&ff>>>Ǯ?\)>>>u>p>Ǯ>ff>?z?8Q?L??0?.{?8Q?B\?+?J=q?k?\)?H?G?z?R??=q?  ??H?У??Q?
=?  ?Q?
=?\?G?
=?Q?  ?{?{@@?H?\)?33?{?{??R?H??\?z?p?????H???\???O\)?L?=p?aG?+?(?=p?
=q?(?Y?^R?Tz?E?E?^R?Tz?O\)?ff?0?0?aG?fff?fff?&ff?\)?(?J=q??\)?5>>p>>(>?\)>G>>Ǯ>Q??   ?&ff?L?ff?k???p?  ?У?ٙ?(@
@Q?Q??=q@@G@\@G@
@ff@G@?33??Q?33?У???G?H?\)???
?z????s33?У?(??p?У??33?Q?{?R?(?{??  ?
=???\?}p?n{?Y?{?ff?zH?(?=p?
?\(?Q?h?n{?c
?n{?W
=?xQ?z>>?0>\>33>??.{>Ǯ>?#
?aG?J=q?G?^R?Y?xQ?W
=?z?s33?\)?
?z?(?
?˅??  ?(?(???У?@2\@@@/\)@\)@1@K@6ff@+@6ff@C
@P  @0  @'@'
=@.{@$z@!G@\)@%@#
@(@\)@@3
@+@1@*=q@@?p@@\)@@??=q?ff?\?{?33?
??33??\)????
?(?H??h??Q?(????33?ff?n{?G?=q??n{?^R?s33?{?G??>>H>>{>
?+?&ff?J=q?u?  ?ff??
=@@!G@'@L@^R@C33@AG@Q@@Q@{@Tz@-p@   @%@\)@1G@@
=@{@
=?33@
=q@
@{?(?{?Ǯ?=q?\)?
@1?
=?(?  ??޸R?@G?R??G?\?  ??  ??\)?\)?xQ?33?\)?(?R?33???^R?G?h??G?G?=q???ff?ff??\?ff?c
?B\?\?k?^R?L?:H>G?\)>(>G>>Q??333?.{??=p?33?u?zH??Q?@\@(@%@#33@H@R\@e@aG@g
=@aG@g
=@~R@e@vff@@~{@R@^R@@u@u@'
=@j=q@C33@HQ@^R@z???H?
=?\????
?33@??
@G@	@\@@6ff@W
=@%@`@X@J=q@6ff@Vff@:=q@C33@3
@#
@7
=@<@1@@&ff@
@{@\)@
?R?H????z?z?\?ff?\????  ?\??ff?z?=q??=q?
?ff?p?G?xQ?G?=q?R?(?H?G??Ǯ@@@ @&ff@I@I@n{@7
=@I@5@\)@%@8Q@Y@B\@A@B\@@@	@
=@p@ @'
=@nR@Dz@33@33@\@ff@1@ @'@p@R@=p@(@ff@\)@   @@ ?33@@?
=?ff?˅?z@@R@??R@(Q@W
=@fff@fff@Vff@^{@tz@%@Dz@l(@|@J=q@I@C
@p  @@\@G@33@l@N{@s
@R@E@@Mp@.R@ff@tz@P@Mp@Y@fff@R\@c33@ff@z@R@{@Mp@|@\)@xQ@u@xQ@c
@Q@pA,>(@θR@{@H@  @{@G@\)@p@@@x@aG@@{@@@@HA\?A
?\(@@z@R@s33@G?ff@|(@k@\@S
@H@Af\@S
A,  @G@
@  @ZH@@@
@
@Q@
=@
@@@?{AGAYAIAA
=@\@GA!ApAA0  A?p@p@S
A{@ffA:\AQ@
H@_\)AAA{33@
@Q@  @#33?
=@33A<@c
@P@33@
=@eAz=Q@A'33@pA#
=?  @333@33@A~RAc
=@@AA{@@33AvR@=qAhAv{A;
=AיADQ@pAG@{AA
=AAAAH@zA733A
=ArffAZH@@(A33AMAA@\)@A
=@\Ah  A!G@R@9@5@zAQ@@6ffA=qAAzAL  AΏ\A\AApA>{AAGAzBG33B@  B/pANRA{A=qA   @QAA2{AA  A$AQ@ȣ@-pA
=@mpA?AϮ@B33AA733@b\AA A33@R@=qA
GAffAQ@33A%A=qAHAAB\)AAAA|QA=qAAf{AApAA`zA{AQ@\A
AAffAAzAA%A=qA:ffAAAK\)AIAAS
@
ARA^HA@A\@{A^RA
=Az=qAAUpA[A@A-A1AθRAGAJ{B$QAAA]BBzAAH  BAA
=AW
AApAl  A\BAGA9pAQ@Y@
AB0zA_AA(A=qAfffAAGBzB\B(A:HA2RABAGA33BAzB
=B,BB/HBO=qB
BSzAGA(A(AAAADB{B{ApB33A  A뙚APA{BpA܏\AĸRApB
=AAB GA<(AHBRA  AA\ApA(AA(Aҏ\BBB
AمAQAAs\)AAAzAGAeGBGAA|AmpAHApAbRA  A{A{AA\A
=AHA1ATAAzAFffAO
=A  A  A.{A|  AAv{AA\A
=AAlAepB:A  @
=AA\B!B!QB
ffBD
=B\)B}Ba  A
B
=AARABAffAAQB'{B(BGA|zA(A{B3A33B
=AzA
=B#
AQA=qA=qAA\A=qB(B)ffAB
=B!ARB3zAHAAA
=AHB1pB
(B%QAQAAffAWAAAAQAޏ\AAVHAG33A(A
=ASA
=A=qA{A33AAA{AѮA
=AAA{AAυAGAͅA`  AA33A
=AAnR@QAAAn\A
AffA=qARA{A\B.{B((B
=BHBd
=BBYpB;zBffBffB5
=B=BU  B5QB   BRA
=BAQAAGA  AB
=A(A  AAHAffAA\)AAGAAAzA
=AzA
=A{A(AA(A(AAAffA]pAGApA=qA33AQA
=AAAHA=qAQARB#GB
=A͙B'B(B$\B2QBA  B HAA=qAzAA  AA  AJ=qAAHA
AHA\)ARAB=qB A  A|  A\)AA`B=qA33AHAGAA(AzA\)A
=A\)BRpB2
=AAB)B
B0B?pAAAzAA\)AٮAAAAQAzA33AGAAAffAAA
=A(A  AA  A  A\AQA(ARApA  AARARAA{A{AAQAAzA\ARAAffAmA\)AxzAzApA
=AA=qAxzAYAoARRAPACA:\AiAJ=qAc\)AV\AzALAFffA3\)A?
=ANHASA6HA{AzAGAl  A33A[A]A*{@\@33A(AHAJ\AAA
AffApAaAdzApAQAGB	A\)A33A=qAAAffAAYpA\)A3
=A33AAGA}GAA|ARAo
=A(AaAEAHAhQAYAs\)AffAA=qA_
A\ApAr\AAd  Ag33AZ{AA733Ag\)AR=qAV\An{Az=qAPAfHA\AAJ{A
ArffAAGA{A{At  ATARHA33A:RA/33A/A$ARA\)A\)A%A$A$A-A/AAzAYA@A9ApAA2{AA,AzAAyAA0AAGB
=A{AyARHAeA+
A AJ\AArRAAX(A_
A]A=qAT(AXQAh  AHA@AG
A/
=A%A(AARA\)AP  @@ᙚAA>{A/AJHA0A*ffAZ{A8QAH  AEA\)Ac33AAOAG33Af\A)pARAMAXAS
AW\)A\)ADAPAK33A A(A8  @{A%A`  A@=q@أ@@G@G@@
@@
=@p@\)@@
=@=qA(@AG@QAT(@z@@@@УA{@{A@zA@(A33@  A33AQA$(A(@AQAAApQApAp  AN\A(A
A@AxzA.R@=qAFRA
=AHAA@AdQA*RAzANHA܏\@\)AtAAA  AG
A5GARffA$zAiAhQA2RAzA'\)@ȣAgA>{APzAAZ\@@(AA1GAff@Q@ۅA;A/
=A>{AS
=A(A @@\@H@A@@(@p@@  @@@@QA\)@@@z@
=@33@?\)@  @z@@@@@|(@@  A+\)@@AQA5@@RAGANRA=qAz@AA*ffA1pARA\)@A	G@@@\)@@@xQ@@ff@Tz@ff@H@e@z@33@\@  @c33@ff@@
@@@ff@@c33@L(@p@Tz@g
=@@@z=q@z=q@{@@@\)@\@@=q@@|(@^{@H@l@Q@H@33@
=@
=@@W@S
@N{@=p@2\@=p@<@(@*=q@HQ@Q@@  @3
@^R@\@@\)@ƸR@B>Q@=q@  @Bn33AHBATAffA33@ACA|  A
=AmpA;
=AvRAHQA"ffA=qALzAc
=AA[
A(AEpA}GA=pA\)A{AFffARA^{A\  A`A33AGAJffAQA`zALA
G@AT@љ@@
@z@=q@@  @(@@=q@{@{@  @
=@{@{@@@Q@@\)@Q@
=@z@ָR@  @ff@\)@@@
@@@@QG@@#
@NR@vff@O\)@ZH@?\)@%@@@33@z?@0@   @7@/\)@;?@L(@;@<@L@{@8@}p???G@"\?\)?ff?Q@z@?(@ff@(@'
=@'
=?33@G?˅?{?G??Q?У?ٙ??{?p?Q@K?Q???z??@r\???@Z=q?G???\)?
??(?33?R?  ?zA?H??R?R?(???ff?\??Q?޸R??\?z@\?\)?p@?G@:=q?p@7
=@*=q@Q@`@@@ff?(??p@.{@H@ @@   @@?  AG@	??
=@U??\@@Dz@:H@H?(@?Q@ff@ @ZH?  @ ??33?(?33?
?\?\?ff?H@G@G@   ?=q?@(@   @{@@R@
=q@   @?@!@Q@
=@(@{@@7@(@P  @aG@^R@[@Q@g
=@C33@;@*=q@\(@Vff@O\)A(@G?H@XQ@\)@L(@{@@p@z@33?A-p@УAuA;\)A.ffA,(A@@UAAUA6\@A  AG
AH(AA@z@xQAHAyA.RA=qA\)AGAAAffAA?\)B>AmAHAqpApARA\)AAffBAA@zAhQADzAmAw33A`(As
=Ag
=A=q@\)A;\)ApAQAAEAF{ARA>{AipAN{A{AaA
=AyGA3AA
A
ApA zAZffAAc\)@P  ANffA?A!AFff@(A&{AU@33ANffA
HAQA=qA$A
AA:RAA@C3BAA7
=AXA33A(AA=qA
=AyA  A
A>=qAk\)A=qA33AAiAHA
A8QB%AupAGAuGA33AAffAA}AGA=qA(AA  AAAAAzAAGAAAGAAffA
=AAffAAA  A
BA\AUA  Ax(A
=A=qAO
A-GA33AHAA33Aj\A>ffAADAiGAHAmA8(AgA6RAxAV{AABffA4AAQAģAqAzARARAGA(AGA|ApA\AAzAA?33AeAtA\)ABRASA
=AW
=A6=qAQA@A{AC\)A.H@
AffA(AzA4AGAA@G@@HAHQA*ffA:RA
A\)A>ffAzA
A0zA=qA5GA
A{AA4zAAB{AXA`AEAGA$A3
AQA4(AYGA.H@(A
=A@QA'\)@  AA(A4  @A3\)@@Q@{@{A&\A@\@
=Apz@@@\@=qAC
=@@\)AA!@G@\@Q@@=q@P@(AH(@\@\)@R@\@=pA@\)@@ə@5@=p@Y@z@=qAz?
=@=qA\@GA@
@ff@  @@33A   @@@@p@H@p@(@@A3
A@z@\)@z@@B\@@Q@A=q@  AAA'A	ARA
{@
=AHAARA-G@33AR@
@ff@(A(AfHA(AJ\A*\A}p@zAQGA8  @AA  @HAV=qA33A;
@BffA<QA7AR@RA=qAc\)AYB\Ac
=AAxQA
=AjffAA(AAGAx(A?
=AHAB\AzBAn=qAiAGAAApAAGAA\)ApAA.HAEA?
A7
=AW
AHAHA  AA  A  BQ33A\AQA,QA5A  A\AHAqAjHAzApAl(AxApA|zAQAGBApAA(ApAA33A@B$RAHA
=AzAApBQA{B%A
AABcBGA
=A\)A{AHAݙAABBA  AƣA
AAffB
=AhAHAdA0  AAAhA\)AA
=A
A{
AAHAAHAQAz\A	A{AAA}AG33Ak\)AHARRARHATAx(AT(AffA
RAb=qAAA<(AffAO33BATQ@  AHA
=AAA
AAA
=ABRA_\)AXQAZHADAW\)AAeAHApABQAA(AAB.zA(AAApA(AAffAAApAQA\)AjHAA\AA33A\)AAAzA  AB*A
=BAAAQApA
=AkAPzAGANRB A:{AC
=A<A>ffA@QADzAB=qA-AA8A9A4QA4zAAGA8QA>ffAG
AQAIGAffAx  AeGAHAA!GAHA@AR\A
AAF=qAHANHAIGA_A
=AW\)AAAIGApQA5AF{AAW33B:(AffAHA\)AAA33AA(AQBM=qB>A
=AՙApA\)A33AA
=A׮Aҏ\AQAәAAGAQA
AϙBOHAGA  Bp
A͙ApA{A\)AʣAHAGAAffApAA\)AǙAģA=qAGA뙚AHAǙA
AڸRAARBB
=AîB\B\BB 33BBB!
=B*GB\AGB=qAffA
=AAA뙚B
ApAߙA\)A{A\)AXA
=BffA
=A
A\)ABGBQB\AʣAB\)BAzBLBDGBnA=qB6
=BHB6BDBs\B{BG\)BWB%{BpB%BSBSzBLBP
BM(BX33BBNQBCBW{B:BQB<HB9B,BC{BQBBAGB4\BCB;B6BCB<B?BA{B6GBPB8pBEBC=qBbRBLBR
B
BLBR33BEffBRBU(BdBhB
=BB(Bw\)ByBnffB3BeBYB
BG33BffB4B=B:(B033B\BGB1B2A
B'\BB=qBGB+B0{BZBI\)AGA  BpBB[ABYBPBBBsHB~BPBo  B)B#BspBHB\)BK=qBOB Bd\)BBs(BHBffBQBz
=BRBB^{Bz
B.B|pB}HBXRBX33B]zBJBoB;(B}33B]HBm
B.(BKBXHBGBL
Bd\B^\B`\)BtBRBn(BR
=BlB[33BJ33B=BBqQB|=qBb
=BkGB33B}RBx=qB\)BHB  BB}BBTB`pBcBFB]QBUffBL{BzB6BQpB,B:BBIBDHBOBOB+  B7  B \B<ffBQpBlpB-QB433BBB33BHB?\AǙBjB\)BK\)Bv(BB[=qBj33BnB\\B'B(B]By  BB`BkBTB\33B\zBBBa=qBE33BHpBE33BE(BGBNRB:pB!B2
B033B:RB*ffB2\B-  B:B-RBB B'B!
B
BGB&BB-RBffBGBzBffB
ABBGARA\BB
=A33ABAA\)AHAzA33ApAA(A
A(AHAARAnRAmAK
=AHzAA\AmAAAAA(ApAApAA(Ag\)AAQA{AA  A_33@
AHAA33AHA{ABAGA{AzAAAQBVARAHAAAAffAHA\A=qApAAApAA׮AHAA{AQAQAqGA}AA
=A{ApAzffA~HA(AAmpA
=A
=Ag\)AQA|AJ=qAeA:=qA5AA3\)AXA_33AUAT(A_AHQA(A$zA)AA A Q@=q@R@  @@G@
@\A	G@A
@A33AzBM33A"\AQA@(A3A;
A5GA>{AUGASAQAzA(AAA  A
A|  ARApAp  ArHA`QAw33AA#
AA(A  A=qA
=ApA(AA\)A\)A\AABAA[\)@HA (A\)B=qAA  B
AAGA)A\)AAAAAA
=Aȏ\A(AA(A|zAA\)AhQA
A(Ay@pAg\)AjffA[\)AAGA?A8AFRA(AQAGA  @{@@  @H@
=@R@{@޸R@A-@zA zA.=qApzA&RAS33ApA,(@A9GA5GA@AAW@HA0QA.HAYpA1@  ADQAJ{A"=qAxz@A9GAmA=qA`AN\AAqAvHAepA=qAAk\)AN=qA-AAo\)AO33A  AAp@əAHA/33A]A:=qAУAۅB%B8RB6GBA
=AA\@ffAAApAaAQ@ÅAQAuA;@33@(AQA3A#
=@G@\)@{A@{@  @z@A;33A,  @pA	ADA@A]AA=ARAM@p@QAH  AASAHzA_AAARA;
AQA  AhAGAHAAApAUpAA=qAFffAAAAA̸RAA^\B\)AA\AQ@GAA(A   @R@AOAMA;
=AQA)GA;33A2ffAHA'A$A!@A4QAG\)A8zAD  AQAw
=@AAA @AAAO
=AS
=@@L@I@1@2\@E@@   @z@\??Q?\?(???
=@Q@\@p@3
@G
=@/\)@%@)@?\)@>{@H@<(@Q@_\)@  @\)@=q@@@33@@\)@ff@@ffAffA
AAA  A*ffA3AJRAB=qAPANRAapA]AVffAP(AZffA_AWA\AQpA\  A`  A@A+\)A$zAA  A%A+@߮A33AH@A(A)AA/33A8  A33@@\@ᙚ@ff@G@Ǯ@  A{A	pAQ@@\)@@z@ᙚ@@33@33@@z@33@@@@ff@R@33@{@  @@@
=@(@\@@p@k@33@\)@G@\)@dz@  @Q@\@@z@@@y@@Q@(@H@
=@@@@@@G@33@ff@@=q@=q@(@=q@~{@b\@q@Tz@5@<(@6ff@6ff@$z@p@@  @#
@>{@S
@B\@5@2\@^{@c33@R\@HQ@:H@(Q@1@*H@7@5@0@8Q@7@7
=@.R@*=q@*H@/\)@#
@*H@(@#
@
@@@Q@z@G@ff@@\???ff?Q?=q?H???H??R?
?
??p??aG???
?}p??
=???Y?p?zH?=q?k???ff??H??}p??h?G??=q?ff??G?R?\)?{???У?=q?ff?
=?\???ff?}p?=q??(???p??\?}p?xQ?aG?L?fff?aG?h?B\?p?:H?aG?zH?G?Tz?c
?\(?Tz?c
?zH?}p?  ?n{?W
=?s33?fff?  ?p?}p?s33?p?}p?=q?p??\)?ff?  ??\?ff?
=?k??Tz?G?.{?O\)?0?J=q?0?#
?#
?z?\)?   >(>H?z>Ǯ>H??z>(?5?aG?   ?=p?(?=p?Tz?k?xQ?}p?ff??\??ff?k?\)?  ?G?Q????z???u?Y?\(?}p??ff?k?Y?W
=?=p?\(?Q?E?Tz?=p?B\?J=q?E?B\?E?L?E?B\?L?=p?@  ?+?E?8Q?R?G?.{?E?L?\(?Q?&ff?^R?O\)?E?\?333??
=q?\)?333?!G??:H?0?&ff?R?333?J=q>(>?O\)?O\)?n{?@  ?\?!G>>?\)?>H>?\)?+?(?:H?
=?J=q?=p?Q?L?aG?
?G?p?G?}p???
=?
?H?G?z??{??z?{??p?
?
?p?33?zH?\)?}p?
?\(?u?p?\?h?Tz?zH?z??xQ?s33?fff?O\)?:H?B\?^R?^R?Tz?:H?\(?^R?Y?Y?(?B\??h?\)?ff??s33?=q?J=q?
=q?0?
=?
=>Ǯ>>>G?
=q>>Q?>H>>(>>Ǯ?
=>>?
=?Tz?(?G?@H?
=>Q??(?R?aG?@  ?W
=?u??Q?\)?\)?G?33?p?{?  ?\)??G?\)?˅??=q?ff?G?\?z?z??fff?ff?G?u??p?h?n{?\(?W
=?p?E?h?G?L?:H?B\?:H?G?E?L?O\)?G?B\?5?(?+?
=?(?G?G?p?Tz?L?u?c
?^R?J=q?p?8Q?B\??^R?^R?}p?
?Y?B\?(?   >?!G?!G??   ??!G?>?0???(?B\?Y?Q?zH??zH@G?zH?  ??33??\)?ff??(???R?\)??33???G?=q?H?(??(?{?=q???=q?H?\)?(??  ?{?u?fff?L?8Q?J=q?@  ?O\)?W
=?.{?
=?.{?Tz?\(?zH?zH?aG?:H?5?B\?&ff?0?O\)?&ff?+?333?+?@  ?c
?\)?#
?=p?\?&ff?E?
=q?\)??(?:H?&ff?5?zH?Y?Q?J=q?G?>?(?
=>
=@XQ?>p?>?   ??\)?
=q?(?xQ?s33?
=?\)???(?ٙ?@33???(?z?\)?@ff@
=q@
p@@z??z?{??p??33?
=?(?Q???G?(??=q??\??H?
??
?\???\(?=q?ff??(??{?\)?G?Q??c
???  ?p?zH?=p?Y?p?n{?H?E?  ?s33?p?\??
=??c
?&ff?J=q?Q?\?=q?\)??}p?fff?J=q???Ǯ?
?\)?(????(??\@@
=??Q@@G?޸R?ff??\)?\???H?  ?˅??
?G???\)?Q?(???{@?  ??
?\)?=q??????}p?s33?aG?k?n{?.{?@  ?u??fff?c
?fff?Tz?O\)?Q?O\)?u?s33?^R?s33?u?Y?fff?:H?E?:H?W
=?8Q?Tz?O\)?Q?k?aG?G?s33?E?+?Y?fff?(?
=???
=??(??G?@  ?c
?L?Y?\(??  ?
?Q??33?(??p?\)?Q??{?33?=q???
=??(?Q?
=?33??  ?  ??  ???????p??z???{?G?}p?O\)?\(?\(?p?@  ?n{??s33?k?\)??h??  ?k?fff?aG?u?\(?W
=?aG?Y?Y?8Q?&ff?:H?\)?.{?8Q?L?c
?E?s33?aG?E?.{?R?B\?(?Q?=p?333?\?>?G?&ff?\?(?333?+?Y?5?:H?@  ?Tz?c
?Tz?xQ?  ?H??33??p?\)?G??\@R@Q@?H?Q?˅??ff??=q??@@?p?ff??Q?R?{???z??У??H?Q??
=?  ?z?=q?G?z?ff??  ?  ?:H?zH??G??  ?33???  ?\?\(?!G?Tz?E?333?p?c
?}p?p?  ?s33?xQ?s33?h?c
?+?J=q?aG?J=q?!G?B\?@  ?s33?  ?c
?xQ??=q?
?{?p?(?{?Q?ff??
=?H?(??˅?\)?ff?ff?޸R?
=?33??޸R?@(@#
@R@ @G@*=q?
=?R?˅?G?H?G??xQ?\??ff??Q?{?{?G?\)?H??????p?  ?ff?\?ff?Q??=q??R?\?  ??Q?(?
=?Q??ff?^R??zH?^R??\)?p?\)??\??h?fff?8Q?=p?#
?xQ??&ff?\)?
=>>G??@  ?=p?.{?\(?xQ@!G?^R?=p?\)?R?xQ??R?z??p?=q?z?\?
=??
?
=??R?Ǯ????  ?
=??  ???p??33??
??
=?z?ff????=q??Q?(??ff?
?ff???O\)?h?p?c
?}p?zH?=q??xQ??H???}p?G?B\??u?zH??\)?
?}p?Tz?5?J=q?
=?R?333?+?(??
=q?5>ff?z?(?#
??8Q??=p?z?G?zH???\)?\?ٙ??
=?ff@
H@z@Q@=q@(@$z@"\@\)@3
@\)@"\@0@:H@=q??ٙ?ff?
?=q?=q??  ?
=@
@
H?z@H@??
??{?33?G?
=??p??{?˅?G?Q??(???=q?
=?z?k?{?
??h?zH?u?ff?=q?G?zH?
?\)?33?
?p?33???ff??ff?
=??
?ff?k?p?=q?
=???{??У?\?\)??\)?z@\?p?=q??(?{???H??z?(???
=?=q?\)?33?Q?{?z??(??ff??ff?H?33?
?33?{?=q??  ???=q?=q??=q???
?=q?(???z?(??O\)?.{?p?\)??  ?n{?n{?{?O\)?333?&ff?Tz?h?n{?s33?ff?Y?{?Q??G?ff??{??(?\?ff?p?H?\?33?(?{??ff?ff??(?ff?Q?\)?  ???@G?@?p??{?H?@33?R???޸R?У?ٙ?\?ff??޸R?H???
=?Q?
?33?G?p????У?Ǯ??
=?33??ff?G?{??R?ff?\)??Q??z@   ??R?H?ff??Ǯ@Q?=q?p@@ ???(?p?ٙ@%?
@{@P  @u@tz@
=@{@  @@@  @\)A\)@@=q@Q@ff@@
=@p@@|@@ȣ@33@@HA~{A(@A	@(A QARHA
=AUp@z@@33@
@G@\@@@r\@n{@dz@l(@jH@Y@|@@}p@=q@Tz@W@O\)@A@R\@H@Q@G
=@S33@H@Dz@E@5@6ff@XQ@9@R\@7
=@H@G
=@1@'
=@p@@H@;@Q@5@{@*H@@O\)@\)@$z@N{@@  @G@=q@
=@@G@
=A33@
=A7
A-pApA4QA]GA(?AlA(A
AA{A+\)A\)A=AA33AcA@QAK\)AhzAJ{AYAB=qAeAG\)AzA}AAA
A33AlQAAZffA
=AgA9Ab\A
AGA6RA
GA
RApAGA@(A3\)@Q@\)?E@A @HA	@@G@@A@@p@@z@(@(@R@@H@p@ffAHA-@{@@R@
=@@z@@  @@@R@@r\@G@ff@@\@J=q@`@33@@\)A?33?  AA
B#  B*B&BN
BBBRB)B>B
B)BfB}QB|RBǮBX=qBJ(BǮB)BW
BǮBb\)B?BW
=BHB&AzB	QBA\AQAʏ\A{A(AffAQAHAfffA>{AdQA7AzA=A'
AzALA&ffA
{A!@A
A	AGAo@@ff@
=@
@zA=q@(A
\@A[@pAA
=q@RA*=qATzAC33@{@
=@A5A!pA!A(A6{AdzA@R@
A5A
GAGAX(A  B	AABB
=A=qB8zB?pBB3(BB?zB5\ARA
AA  A˅AAA\)AHAӅA33AAQAF\A+
=AQp@@MpAL@
@k@@@ҏ\@@  @@@1@xQ@{@XQ@ZH@l@H@{@u@G@zH@ZH@  @@(@jH@  @(@G@ZH@jH@l(@x@j=q@@XQ@I@Mp@C
@A@>{@@3
@
=@R@7
=@[@@\)@ff@\)@'@??z@@=q@@
@??33@
H?
=@?@@(?(@!@@1G@Fff@Q@+@P@n{@xQ@@33@=q@˅Ai@@@Q@\)@AL(@ڏ\@AA\)@@A
@
=AHARAAw33@(@@(@@=q@nR@G@dz@^{@AG@G
=@{@8Q@5@(@=p@H@<@C33@n{@l@p@z@Q@p@@=q@~{@|(@`@.{@@  @Tz@+@G
=@C
@3
@p  @<(@B\@O\)@;@%@8@(@/\)@'@0@
=@H@4z@+@\@q@p@
@z@{@"\@@>{@Vff@@@z@{@׮@{AffA@
A
A=qAO33ARAFffA0(A$AA,?{A*ffA0QA8QA!pA'\)A	pAzA*ffA,AZHAqAzApAffAqAAAuAhQAAAj{AAuAUA
=AN=qA0  A'
A)pApAAzA\@p@@@H@@ff@
=@(@@@@
=@H@A@(@
=@\@z@{@
ARAAp@p@\@@@
=@@p@@{@ȣ@
=@@z@@θR@@@z@ff@R@AA4QAGA%AFRA @ A33A @@  @@@ff@@ƸR@\)@p@\)@.{@(@׮@\)@{@@=q@A	A
HA	AA	A zAA9A+
AA\)A
@@@(A33A=qA
A-A
pAz@@@HAAQ@p@=q@H@A\@陚@\)A{@\)@
@33@@@@R@@@љ@  @ָR@=q@7@5@AG@s33@\(@a@@  @p@@p@G@@@ARA
A zAQAQGAx  AAyAA|(As
=A33AAAHA\A
=ApAEpA`A|QAiGAGAAffA=qAqpB+AffAfHARA=qA{AHB
\Af\A}AAApB  AQBGAffA  A=qAAffȀ\AffAA8QAn{A\)AAFffA0(AAAQAeA@zAV{Ab=qAQAR=qAXALAiAl(A\)AP  AB=qAO@RAYAXA=qAqAQpAA4AA6HA
An=qA\AJ=qA?AMGATAS33AX  AeA$A9A0QAD(AnffAC\)ApAj=qAZ{ADAjRAT(AmA&\AA
=AtzAQAO33AAK\)@=qAARHAGA@@=q@=q@G@  @A?
=AffA\)A*ff@(A(A$(A!A/33A  A (Ax  Ah  AIpAQAs33AAzAĸRA=qAAS
AQAA@
=Aj\A"HAxA8  A
=AzA@zAAl  @ffA{A{AA\)A
=@33A\)A
H@{A{@Aff@@@
@pA
=qAz@
=AGA\)A\)@A<  AC
=A\ARA{AO33AHAWBoA{A{ARA
=ApAAUAp  A\)@(AA=AzA33A@pA5AA(zAA
A1p@ff@\AA=qAzA
=A1@A+
@A-@yAn\Ao\)AzA zAA33AAA3
=A"{A8A^ffAOAQAzAA\Ag
AGAXAk
A[
A[33A<A<  A=A.{AF\A4  AB\A4A>=qA9GA4zA<QABffAAAMAc\)AHAmApAkAc33AAGA{33AhQAjRA`A|AlAo
AxAc
=Ap(AZ=qAQGA[
ArHATQAFHAqAZffAk
Aw
=AAA(AW
ArRA
AA\AA{AA  AAl  A{A}pA{33ATzAT(Ag
Aw
=AvffAc\)AApAv=qA|A}pAzRAQAj{A\A=qAFffA(A£A33BzB33A¸RA33AffA=qAŅApBBQARA홚BGAAzBAQAAB4B*ffB#A  B
A  AхApBGAffAAHAAzA(AffARAAA{ApBBA
AAAAQA33A=qApAAAA(A\AffAAzAAA{B
=A
=A˙A\)BGAzAٮA؏\AA(A{B
AxQAA\)AQA
=A33B
=A
=BGApB
=BRAQBzB(BpB\B(A  A=qBB
B,33B1HBLffB^B9BE{BFBa=qBJ
=BIpBtBIGB.B=qBm\BpB BWB{  BcGB[
BA\B@B?(B6
B|ffBGB(  B8{B7
=BYffBA
B)pBfB4B9B	B.
=BJ
B5BRB0B)B@
=BF\)Bs  B
=B  B  BEHB&BBBGpB HBTBB=qAB=BfBdBL
=BuB/QB?B<zB*\B3GB|BxBJBKBJRBFBW
=BpB\)BNB:  BIBV
BfB7QBB BGB*
B\BB33BffBB)Bi=qB
BSffB33B=qB#BC YBBBffBp33B
=BB'B33B\B{B)BlBRCT{CB
=B}ffBaHB\)B
BB=qBB
B(B#B
BkBBB{B#B.BBB
B
B½qBs\)B
BHB)BqB(B=B]BDBn\B
=B)BHBZRBoQB=qB33B[RBBaHBh33BGBlB(BͣBHBظRB
=B\B
B3B=qB.BBBBNB{B|QBgGBBxB
=B#B
=B  B8\B]BǮC
RBǮB]B(CBBBW
B{BffBBBBBǮB  B(B`33B\)BǸRBBg{BqB(C fBǮB#BC5BB  BBW
BC1
BzBR  BBBBǮBuB33B\CBB8RBQBW
BBBǞCBuBFB8RBBRC xRB.B8BpBWffB(BW
C zC8B3BffBB#B̞BuBW
C+B=qB#B)B(B3CGBqBB,pBBzB\)B)BHBI(BߣBuB^zBN
B=B&BaHB\B
BBBBBLBRBNB BHHBqB
BpBBB=qB{BCBCBSC8RBC BpBQBf{BC3BHB
B8RBW
C
BW
BBy{BBI(B  B=qBQBHBBfB=BfBW
B.B{BBBERB˅BuBaHBB BBB\)BOffB[ffB{BfBB;(CxRB3B3B
B=B.BBBM  CC.BffC$kBA\)BkB@*=qB:B*pBR=qBQ  BHBGBqBaHBUB
=BaB  BB.B˨B{BgBLB BB5{BBuC BBBBBBB>pC
BffA(B.BW
BLAQBBHBWB2CB
=B~(B33B=\)C=B.BuCHBCBǮBpBS  BCffBHB
=BfB#BP\BB)B  BBpBBB{Ba33BǮAA
B͔{BBHB B+33BkB({B`pC BqB\)BfAB1pBBBY(B
=BB&\A33B;\)B]B  AB33AzB$QB\BpB.ABhB?
BC	33B)B8RB+GBffBVGB33BBG(BBC
BGBˣCDqBGBC0BUffB=qCVJ=B\B\)BaHB
zBQBCC=  B\C$xRBC(BC\B BB=qBgRBǮBBHC$B
=BoC2uC3BkBABffA33CBB{BمBAGBS=qA33BBKB#AQBzB:
=BDpApB=BZBBoAuB AmB{BƮApB3BpGBpBBBQAffAGBS  B#B  BCBBCC=B\)BAbHBUQBB3C
C \B)CffBBTBHBzBB{CB.BB
=C
ARBLB䞸BCGBffBW
BcBiA{BXB~pBDBW
BW
B3B  C7B.BMC#:BT33C;YB&BGBVBLA
BJQCzBBB(BB8RBM\)B\)B8RB"BIBwHB3BdQB\)B{BpBrBHBfBW
BUB)GB{B]
BkB\B5HBS  BL@pB̏\AQBB2zBB&=qBB3B(Bc\BBÊ=BB=BBB<(BSBaBW
A{B BVAHB)A  BBXzA
=B\HBó3B{B
BBvAGBBqA߮BB֣BBBpBǮCHBBǮB=B\)BLBuBBqB+C)BzBAQB3Bd
=BSAHBzBDHB+BGffBB=AQAƣAH@+A\)BffA
=BأBBM\B=qBHAřAAkB*BaA(B#A?33A{BߙB=qBqABiBq\BB=qB#BBB\B\B=BuQB"RB  BW
BBBnGBd
ABA=qBGBRBS=qBqB?BB`B33BRBBB<C#BʸRBBC\BUBBGBuCJ=BkBpB  B33BQAǅBBB  B#B.BBGB@BǮB B33BBe=qBB3BC
B\BB{B(B	  B_pB(BBBzBq@
BBL
=AffAtABcQBBRBǮB4GBy
BSQB  BqBr\)B#AffABABY33B)(B|B!\Bv(B7ffB{B33BBA{A\BkBB/\)Bk
=BW
A33BSB~GA{B\)B9B$ABr=qB=qBaHBQpBGAk\)B6A
BBBB(A
ARBHAB`AzBUAB33AzAffB\A
=A(B(A  B7
=BABSGB BBOHB_  BD33B;B5BL=qB
=B,ABBBfAQA
=BBBDB^GB3BzAA\)BtGB\ffAQBHAA\)B-\Bq(B9\A\)B33BC
=A
=AHAxQAB>AGB
A
=BTB
=B2BB\AA`B!BB,  BGQB
  B\B
=ABBDzB,=qB((BIBBp(B}\)BBה{B\BABB8RBBEpBB=BBzB3B3C\)AAB BBB)pBmRABQ=qBf(BBbBuHB2ffBGBB'  B RBffBB/(ABA\)A  B
=B4pB
=BA  B=GB33ABKHB {B  B	\)B-33BRBcpBJHB&B=BPB
B^BjpB
B\ffBPHB(BffB\B=qB33BDBF
=BJffB
=BWBQA
=BA33BB<B?HB\)B'\)BGB ffB#HA33BB:pB\B
HA33B=BRB<\)B/BzBkB߮BǮB$BrBRC
BD  CUBH{B
BBBm{BSBlffBgffB
ffBHBQQBǀ BBQHBhpBw\)B=qB3ffBtzBBkA
=BEGBd
=Bq{BGBA33BB{BbAGBV
BVBXzB8A㙚BB'B"{B833A{B5B (AxzBIffBLBj(B1zBEffB
=B5B=BQB  BffB"
A\)BB
HB0B;QAAQBAB33AARAAGA{AᙚA(A\)AAAA
ApBRB
=AB
AzB9{B!BMAAʣBVBnBBBmRBhQBsHBkB=B~pB_BfB{HB@GBJB{BB?  B6BKB9B'B{A
=BffB=qA  BB!=qARBffBpB0=qARB
zApAA
=A]AA  A33A  BpA\AHA׮BA(B  B=ABBzB   A
=BGBARB,BLHBpBGffBL
=B!B0ffA=qBffBHAqBIB#B
33A(AQA  BA=qANRA
=AzApAapBffB!AB4HBGGB AHB&ffBA  B=qB\)B8ffB*BSB	BIRB(B[AApB+B(\BHB/ffB33Bv
=AQB?Ba(B7ffABGB	{AGB,B
BAGApA
A
A`zB7AnffBABAARA
BB1A\AB pAABffAܸRA\AHA\)B33B'=qB33B<RBABB
RB%ffB
B HB
=BQB(A
B!  BzB  ARAffB\)AzARB#BAffB
A(A=qBB\)B+  A{ApB#B!zABffB,AABJ=qAB%BK(Ba\)BffB<
Bu\)Bm{B3ffBGB?BuB3BffBBBBtBB(B	pBtB^B[33BdBQGAb=qB\BI\)BGBABEB/QB<QB6A\)B1BB)
B0B>{BBFB2{BEB(\)BGBB]BD33AffBp
BXB^B<AAz@k@o\)@HQ@_\)@p  @g@S
?R@R\@Z=q@E@zH@@U@p@\(@q@a@i@nR@p  @r\@nR@=q@w@  A
A\)@@(@(Q@{@(@=q@W@G@Q@@h@У@X@@Q@A(A\)@A$A5pA1p@{@{A\AHA.{@Aff@=q@
@
=@@z@@@ff@ָR@p@@@p@@@\)@_\)@(@R@33@Q@@HA*=q@@G@H@p@=q@H@G@@ָRA
A
=@Ӆ@{@b\@@@{@G@  @G@fff@\@{@\)@e@(@33@@@@G@(@@\)@o\)@p@@
=@(A&\@@33@A1G@:=q@'@@@\)@2\@
@H@@ABffA]AIp@R@  @GA33@R@@33@z=qAP@_\)@33AYAQB33AcA#@GA@\)@@=q@
@\@(@{@=q@P  @ff@H@\)@ۅ@Q@7@\)@}p@  @
@H@
=@=q@(@
=@G@@@u@@aG@vff@r\@@a@H@HQ@jH@@vff@r\AE@\)@ff@@
=@@ff@l@fff@w
=?G@H@q@@\)@@@a@u@Y@R@p@y@=q@@ffA
=@\)@@z@<(A:HA
@[@<@z@  @@R\@  @l(@\)@  @=qA@p@$z@@@mp@p  @p  @@33@@jH@(@p@]p@@P  @g
=@JH@Q@z@@\)@\)@fff@u@(@`@Q@1@
=@R@
@-p@  @zH@@A@@W
=@nR@33@nR@x@y@I@S
@QG@\)@Y@c33@?\)@~{@w
=@E@tz@Q@<@G@ZH@k@~{@=q@`  @b\@Z=q@`@H@>R@Q@U@l@\(@jH@R\@w@Q@xQ@z@Q@w@~{@@XQA\)AffA@@@  @nR@@G@G@@[@ff@{@R@
=@p  @\)@33@P@p  @_\)@E@#33@(@,@>R@NR@B\@[@3
?@0@ @p@@  @5@G@N{@<@C33@,@9@<@(@@   @p@?\)@Q@ff@%@(@?z@ @33@\@???(?ff?@\)@ff@@ff?R?  ?Q@@?ff?H@'@XQ@mp?p@#33@Q@@@   @ @R@z@
=@33@ff@R@(@{@/\)@2\@,(@@@/\)@J=q@j=q@e@9@Q@
@  ?@z?G??\)????R???\?z?ٙ?
=?p?G?{????\)?\)?  ?ff?H????33?p?p??=q?=q?=q?^R?
??zH?fff?
?=q?  ?G??  ?^R?=q??k?\?c
??s33?ff?c
?@  ?&ff?O\)?E?5?c
?aG?333?#
?@  ?5?aG?
=?0?(?B\?(?@  ?z?0?0?fff?=p?Y?aG?c
?h?^R?xQ?
?u?xQ?
?H?z?H???33?n{??
?{??k?n{?fff?u?k?p?}p?\)?ff??J=q?E?Y?G??fff?^R??  ???ff?}p?z?zH?
?  ?Tz?Q?zH?zH?fff?Y?Y?L?B\?J=q?E?Q?O\)?W
=?O\)?E?Tz?L?L?O\)?Q?Tz?B\?c
?c
?^R?8Q?k?h@Q@@G@@\)??Q?@e@pA
@ᙚ@@pA{@@ᙚ@A
@\)@R@@@
@ٙ@@H@@
=@У@p@p@@@  A\)@  @Q@g
=@8Q@`  @K@/\)@@*=q?H?@	?@@(@R@7@\)@
@@
p@&ff@ @&ff@\)@\@Q?Q@@@%@\)@ ??G?Tz?O\)?J=q?J=q?ff??\)?Q?
=?fff?33????  ??R?\?Q@
=q@*H@3
@%@=p@@z?@{@@{@#33@33@#33@
H@(@>{@1G@\)@.{@0@2\@,@%?
?
=??H?Q??H?{??R?\)?\?  ??\)?˅?ff?H???Q?Q?\??H??{?z?}p?xQ???ff?z?(?
?  ??
=?  ?ff????G?xQ?zH?xQ?c
?5?@  ?>ff????\)?+?0?z?8Q?=p?O\)?\)?#
?8Q?O\)?\?E??O\)?!G?R?=p?u???33?ff?=q?}p?fff?xQ??Q?Tz?c
?k?k?  ?aG?aG?\(?W
=?B\?B\?+?J=q?@  ?Tz?fff?L?E?aG?aG?\(?c
?k?O\)?@  ?^R?\(?W
=?\(?W
=?J=q?W
=?=p?Q?E?W
=?Y?Q?c
?B\?B\?:H?L?J=q?#
?&ff?333?Tz??5?(?(>G>
=>>?
=>H??>
=>>>
=>(>\>>
>Q>
=?\)>(?\)??+?=p?5?5?
?n{?s33??R?{?H?\)?{?R?Q?R??ff?
=?(?R?33?
=?G?\?=q?O\)?Q?Tz?ff?\?ff?R?H?H??zH?fff?}p?u?k?}p??
=?p??z?R?H??=q?\?ff???=q??  ?ff??33?p?R?{?  ?s33?????
=?\??\?Tz?+?s33?n{?fff?G?B\?k??h??}p?u?p?h?k?^R??ff??\)??R?
=?H??  ????J=q?\?zH?u?У?33?  ?H?33?=q@?z??G?(?33?\???fff?Y?Q?\(?Tz?W
=?G?.{?(?0?333?
=?(?
=q?5?!G?\)?:H?R?(?R?=p?aG?k?\(?E?:H?aG?J=q?Tz?:H?.{?5??&ff?+?=p?J=q?W
=?\(?Tz?5?B\?G?O\)?W
=?:H?u?G?G?Q?G?k?s33?\?????G??}p?s33?(??z?{??G???\?k?Q?=q?z??(??G??ff??(?Q?33??R??\?H?{?=q?z?\)?(?=q?@@ff@(?H?33?
=??Q?
=?z?  @z@z@   @@?(@Q@
H@@@@@(@=q@
=q@
@!G@G??\@
@'@&ff@)@!G@=q@@3
@2\@=p@fff@W
=@>R@Fff@7@7@2\@,@8Q@5@5@.R@??{?  ???Ǯ?
=???????{?Q???H@Q@1@8Q@b\@b\@z@(@Q@ff@
@@H@@{@@33@@@z@Q@p@G@H@x@q@q@s33@q@{@~{@(@z=q@(@z@G@y@r\@@33@@\)@{@=q@@@~{@\)@_\)@z=q@|@h@l@jH@i@|(@dz@9@7@>{@:H@;@?\)@<(@;@5@-p@(@.R@7@>R@8@,(@%@-p@(@#33@\)@0  @7
=@-p@7
=@Q???H?(?
?\)?H?Q?H?Ǯ?@z@@/\)@S
@W@u@e@r\@@  @@ٙ@@@@H@
@33@@@@@33@z@@  @
@׮@
=@@33@
=@\)@@p@@Q@@@=q@@R@\@=q@@@p@p@nR@b\@aG@
=@@H@  @|@@
@p@G@
=@=q@G@R@Y@dz@c
@L(@Mp@P  @>R@J=q@:H@W@3
@AG@8Q@"\@"\@H@@Q@ff@(?(@	?z?R@   @
@Q@ff@
p@(@\@
=q@R@=q@1G@/\)@G@S
@P  @QG@Tz@Z=q@e@g
=@g@U@I@C33@xQ@HQ@
=@@(@{@H@@@~R@n{@U@Mp@C33@Vff@k@W
=@Dz@XQ@a@U@e@O\)@i@g@z=q@hQ@`@K@NR@NR@P@NR@<(@@  @8Q@5@,@*=q@?Q?(???z?ff?˅?
=??ff?ff??p?@   ?z??H?\)?У?
=?˅?(?33?Q?H?33??
????z?=q?Ǯ?R?H?{?(?{?G????Q?R@Q@)@QG@qG@@H@@zH@xQ@@}p@G@33@q@z=q@u@dz@xQ@n{@s
@[@W
=@0@/\)@@{@\)@@@\@
p@	@  @  @Q@   @Q@H@.{@'@(Q@$z@(Q@@
=@{@\)@{@
=q@	@
=@@
H@
=@@?@33?@
@\?R@\@G@
=q@z@@\)@z@  ?
=@@
p@
H@@
H@\@   ??\)?ff?
=?@
=@33@Q@G?G?У?  ?33?޸R??\)@   @
@!G@%@8@W@jH@w
=@(@\)@}p@\)@@~R@p@q@xQ@aG@Vff@L(@W@G@Vff@aG@_\)@^{@^R@c
@h@zH@c33@NR@JH@Fff@<@@@@@C33@@  @8Q@<(@8@7
=@9@:=q@7@P  @]p@g@dz@jH@k@p@j=q@l@G
=@I@N{@QG@Mp@W@c
@i@i@s33@l@g@`@e@ZH@^R@Y@W
=@N{@P@Tz@%@@{@H@$z@H@@G@@@G@  @R@=q@=q@ @'
=@!@&ff@)@O\)@G@R\@\@Mp@i@k@r\@S33@g@xQ@{@HQ@JH@^{@h@W@R\@Vff@W
=@g
=@L@JH@G@Dz@@@K@@@I@E@=p@B\@1G@5@?\)@:=q@<(@A@E@B\@L(@C33@2\@4z@4z@,@5@I@6ff@Dz@G
=@=p@@@B\@N{@Dz@JH@@  @^R@B\@P@Fff@I@N{@Fff@A@@@8@5@JH@9@G@@  @(Q@,@,@(Q@$z@?Q@@   @
??\)??{?\?z?Q??G?
=?H?G????˅?=q?@\@H@Q@R@
p@@  @@@@	@@ff@Q@?z???{@z@Q?Q???ff?Q???33?\)?{???ff?޸R?33?{@?H?z?@   @
=@z@33@\@??
?{?z??z?{?33?
=??У?ff?H?\?Ǯ??G?\?˅?p?Q?H?R?  ??\)?У???H?33?Q??  ?(?˅?z????
=?33?G@
=q?@
p@@@   ??=q?ٙ??ٙ?\)??{?(?
???=q?(?
??\??\??33??{?(?
=??H?  ?p?G?\?G?p?(?z?
?33??\?
?
=??{????(?
?G??G?=q?ff?{??Q?  ?
?
?  ????G?=q?\??G?=q?
??Q?z?Q??G?z?G??{?p??{?Q?33?  ?  ?(????\)?R?G?\?޸R?33?У??z?
=??Q?  ??  ??\)?ff?z?\?p?33?˅?=q??p?z?R??\)?{?\)????Q??G?
?G?p?
?G?(?H?{?33???=q????33?{?Q?{?R?}p?ff??=q?=q?\)?????H??Q?z??k?xQ?n{?n{?xQ???G?k?  ?s33?n{?fff?c
?\(?.{?L?fff?u?}p?ff???
?{??G?G??  ?\)?{?Q?33?ff?H???z???=q??R?{??=q?zH?
??
=?\)?  ?p?\?  ?  ??ff?
?G????33?????ff?\?G?zH?}p?u?zH?k?ff?xQ?s33?zH?zH?^R?k?fff?Y?^R?Tz?@  ?aG?E?zH?fff?^R?p?s33??p???  ?n{?s33?Tz?W
=?\(?p?aG?O\)?8Q?Tz?B\?333?+?=p?.{?5?8Q?@  ?s33?^R?aG?u?c
?Q?n{?Y?h?  ???R??ff?ff?=q???R?(?  ????H?G???{?u?zH?ff?s33?zH?u?p?\???z??\)?n{?u?c
?=p?\(?^R?h?Q?Tz?Tz?B\?5?E?Q?L?Q?O\)?Tz?c
?Y?Q?Q?Q?fff?fff?fff?O\)?Y?=p?=p?5?@  ?E?&ff?+???8Q?!G?J=q?:H?.{?0?333?=p?=p?Q?Tz?E?Tz?\(?W
=?n{??@?\)?
=?  ???ٙ?У??\)?=q@?33??H?ff??p?=q??
?R??z?33?=q?p??{??{?aG?u?^R?k?k?n{?k?\(?^R?\(?W
=?W
=?}p?p?  ??\?ff??
=?\?=q??G??=q?z?=q?p??
??˅??  ?H?z?H?
=??\)??R?\?H?
=??Q?Q?(?H?\?R?R?G?=q?{?G?p?p?\(?  ?}p?s33?  ?}p??ff?\?xQ?zH?s33??  ?p?h?k?zH?n{?k?W
=?aG?k?\?s33?\?p?n{?Tz?\(?s33?xQ?aG?Y?W
=?fff?Y?E?aG?Q?@  ?Tz?L?Q?B\?\(?^R?B\?0?5?0?=p?5?B\?@  ?L?B\?.{?333?&ff?B\?=p?0?8Q?B\?&ff?(?+?Tz?+?
=?:H?333?8Q??R??
=q???!G?
=???\?!G>?\)?
=q????!G??z?H?!G?R?+?\(?O\)?O\)?.{?+?0?333?R?z?z?&ff?&ff?(?#
?0?=p?\)??#
??#
?
=q?(?(?G?O\)?E?Y?G?8Q?#
?&ff??+?333>H?
=??!G??!G?z?\?&ff?#
?#
?z?#
??\)?z?
=?!G?&ff?!G??
=q?
=?&ff?(?&ff??(?z??(?!G?
=q??+?&ff?&ff?5?:H?#
?0??(??&ff?(?+?
=?(?R?#
??z?\)??0?(?0?333?Q?G?G?\(?k?zH??Q??(?&ff??z?#
?k?(?c
?????p?\)?aG?Q???{?\)?c
?.{?8Q?B\?J=q?Q?G?E?k?L?^R?B\?G?B\?E?333?h?W
=?^R?E?J=q?=p?=p?:H?W
=?#
?0?=p?=p?333?B\?0?0?&ff?&ff?!G?R?(?&ff?#
?(?.{?@  ?+?0?8Q?@  ?J=q?Y?G?:H?:H?+?L?W
=?L?Tz?:H?G?:H?8Q?Q?Q?8Q?fff?n{?\?p??aG?\)?\)?(?\)?
??p??ff?  ?ff@@33@@
@@@H?(??H?33?p??(?Ǯ??=q??H?R?z?  ??\)?
=??z??ff?G?{??(??z??H??Q??ff??33??ff?G?  ?G?u?  ?p?xQ?ff?
?G?^R?G?G?
?=q?ff?xQ?s33?=q?k?h?fff?c
?h?k?G?h?xQ?  ???=q???ff??ff??  ?Ǯ@1@)@??@  @p?Q?=q@@#
??ٙ?\?  ?}p?G?k?zH?O\)?s33?Y?Y?0?
=??B\?:H?(?333?
=q>>??\)?&ff?0?#
?5?J=q?@  ?#
?
=?R?(??(>H>H?
=q?>>H>Ǯ>{??   >(>>
=>p>>Q>?\?#
?&ff??
=q?
=q?
=q>>??z?\?5?&ff?=p?#
?\)?z??8Q?=p?8Q?@  ?>?
=q??E?=p?\?\(?^R?8Q?0?O\)??ff?u?Q@%?
=@@@z@ ?H??33??n{??@   @=q@A@@
=?p?\)?s33??W
=?E?J=q?0?E?Y?@  ?G??{?W
=?\)?p?u?J=q?fff?8Q?L?B\?J=q?=p?5?G?5?\)?O\)?W
=?W
=?B\?J=q?\?   >?(?\)???c
?s33?p?h?\(?&ff?5?.{?0?:H?0?5?Tz?=p?+?+?k?@  ?33??z?  ?
?H???\)?\)@@G@G?(?p?G?{??33???@8@?u?Q?zH?ff?xQ?c
?fff?B\?aG?@  ?333?Y?B\?G?5?&ff?(?.{?0?+?
=?#
?z?
=q?&ff?
=q>?\?\)??\>(>H>?R?R?\)?!G?&ff?   ?\??z?(?(?#
?0?^R?
?\?\?u?h?L?!G?L?R?\(?n{?0?8Q?B\?(?R?z??(?Q?#
?:H?B\?L?G?k?
??33?\@?(?
?{?=q@#
@!G@$z@@@*=q@%@HQ@X@R\@W
=@
=@
=?R?˅??z?{?u?s33?^R?Q?Y?G?5?&ff?E??(???z?\?
=q?(?O\)?\?  ?H?J=q?0?
=q??=q?
?\?O\)?L?.{?G????
=q?!G?z?>H??>>>G>G?   ?8Q?#
?5?
=?>>
=>ff>{>
>=q>(>Ǯ>>>Q>G??(?
=?O\)?c
?h?G??{?  ?^R?Q?(?R?=q?ff?Q???  ??@  ?^R@e@L@`??@@ff?Q???{?{?{??c
?L?  ?J=q?fff?}p?zH?0?(?.{?Tz?=p?O\)?@  ?\?(??  ?\)?
?  ?G?ٙ?(?=q@ff?ff?ff?\(?=q??33??H?\)?\?z?R?\)????\)?{?  ???u???  ?p?G?33?\)?
??H?Ǯ?R?  ??@G@*H@\?33?Q@O\)@HQ?p?H??@33@>R@#
@P@P  @  @
=@?33??G@(@!G?p?Q?^R?@  ?8Q?+?B\?@  ???.{?c
?333?{?J=q?5???aG?{@G
=@>{@=q@@
=@@!G@   @@33?\)?Q@?
=?33?z?G??G?:H?&ff?333?G?\(?!G?R?:H?L?(?B\?c
?333?#
??\(?W
=?O\)?5?Y?Q?0?Y?}p?(??(@33?
=??@1?Q?@H@W@@=q@Q@{@@@(@  A"H@
A A$  @(A@
=@K@W@@?ff?Ǯ?G???Q@Z=q?{?c
???p@@b\@Fff@@@Q??G?Q??fff??=q?ff@z?=q?z?33??G@G@ff@@@
=q@z@7@(@N{@k@
=@   @z@ @,?޸R?ff?u?}p?xQ?J=q?:H?O\)??.{?>???   ??\)??aG?Y?n{?0?\?n{?s33?Q@33@8?@i@E@g@,(@1@@Q@P  @(@G@=qA=q@@@H@Tz?R@#33@   ??
=@?@!?ff?\?(??
=?ff?\?{?\)???H?{???p?  ?k??ff?^R?B\?G?fff?(?H??\?G@33@G@
=??G?\)?H?У?޸R?=q?G?˅?p?Q??p?ff???333?5?+?O\)?.{?(?5?Tz?&ff?G?!G?Q?L?h??G?h??\?R?R@@@)@*H@E@mp@z=q@p@@@(A	G@@@p@Ӆ@Q@fff@5@(@{@@h@mp@@Dz@	@5@ @@P@H@@@أ@@1G@3
@G@(@?Q@Q@^{@?\)@JH@JH@@ff@Q@@Å@@@@
=@@@{@@P@  @`@=p@Mp@c33@o\)@:H@:H@O\)@u@@'@G?H?H?H?xQ??33?O\)?Q?8Q??#
?(?#
?8Q?.{?Y?k?G?=p?8Q?c
?Q@
=@c33@|@7@*=q@-p@Vff@AG@:=q@O\)@ZH@z=q@s33@R@~{@33@|(@\@@@Q@  @ff@{@xQ@@xQ@=q@w
=@h@fff@
=@@@H@zH@mp@@tz@R\@h@(@7@0@@  @<(@Dz@-p@@\)@ff@@
H@
p@33@@@G@@@@p@R@ff@@\)@(@1G@
=q@,@\@+@ff@
?z?\)?(?˅??z?=q??p?G@?\?ff?=q?˅@@G@ @\)@p@)@P  @L(@W
=@a@ZH@5@333@b\@x@<(@33@X@`@=q@(@@׮@@@33@33@@
@ʏ\@H@Ǯ@@@z@\)@@ff@~R@`@vff@U@@@
@@33@<(@{@\@z?R?\?33@\@
=?G?Q?p?H?
=?Q?H?H?R?G?z?33??33??H??33@?@@
p@(?ff@(@ @@=q?Q@H@\)@
p@2\@#
@4z?(@\)@A@0  @NR@
@$z@\)@@
p@p@@{?R?H?\)@33@33@6ff@6ff@+@nR@y@{@
@=q@@@@33@@R@@z=q@@33@j=q@  @hQ@dz@Fff@4z@H@=q@#
@E@Dz@)?
=@?R@
=?(?=q?z@?@\@	?޸R?  ??\?{??33?  ?(???33??\??\)???
??33?
?  ?G?ff?G?G?=q?ff?
??{@
p?33??Q??
=?  ?33??{?
=?p?ٙ??z?=q?H??G?Ǯ?33?
=?z?G?p?p?  ?@ @6ff@W@p@33@p@c33@@vff@nR@g@@C33@P@L(@)@Fff@k@  @Q@?\)@{@@H@??\)?  @33?@-p?@7
=?ff@\@
=@?z?H?Q??Q??G?\@
p@   ?@
@ff?{?=q?\)?p?  ??R?ff??G??  ?G?p?\?{?{?{??Q?ff?p?  ?H?H?Q?=q???33?  ???ٙ?z??Ǯ?޸R?\)@33@R@%@@  @?\)@E@W@jH@a@
@(@R@@@{@G@@ff@G@H@H@@p@@ff@\@R@(@@
=@{@e@c33@JH@Fff@0  @
H@3
@jH@\)@   @-p?@XQ@@u@N{@\@s
@G
=@8@8Q@8Q@-p@L(@R\@;@)@@
=@G@(@#33@'
=@
p@H@
H@??R@@333@@?@????G?H?ff???У@@ ??@G?\@33@  @  @@R@0@N{@N{@jH@c33@@Q@@\@@@@i@@  @=q@@=q@θR@@z@\)@@p@@
=@R@\)@
@@
=@p@Q@l(@`  @@
=@QG@<@h@0  @ff@p@u@&ff@33@ @{@\)@1G@G?33??=q@\?z?p?=q?(?z?z?H?(?\???  ????xQ?p?  ?Q?޸R?z?  ?R?@?z?(?p?\?Ǯ@z@
@@+@{?
=?Q@@(@@2\@Fff@l@{@333?\?@ ?(@{@ @^{@(@E@@@'@.{@p@#33@JH@U@B\@4z@(Q@,(@,(@\)@q@dz@?\)@5@h@e@P@fff@@:H@@333?@L@333@+@-p@0  @
@33?z???z?Q?\?{???  ?ff???z???H???z?\)?G?{??
?n{?Tz?\?n{?xQ??
@L@:=q?=q?33?n{??\?\)?=q?z?
??(?R?z?ff?  ??p?
?\)?{@@*H@(@nR@@HQ@x@
@:H@;@G@(@r\@s33@i@b\@`  @.{?(?˅?У@  ?  ??=q??H?\?{?33??s33?c
?=p?#
?z?
=q?.{?(?\?&ff>?z?5?^R>?s33??  ?\?:H??W
=?\?Y?Q?{??\)?
?Q?8Q?Y?k?5?=p?Tz?{?
?Q?Q?fff?Q?p?33??!G?(?W
=???\)?G?H@??ff?@.R@/\)@:=q@@\)@,@U@Q@O\)@(A;@33@  @(@(@
=@A\)@Q@p@RA @>R@`  Aff@Y@=q@@aG@@@
=q@@{?H@H?Ǯ??@R@(?
??
??H@\)@@>{?@1@<@S33@I@*H@^{@#
@  ?@\)?Q@@@@z@?
=?{??(?
??G?aG?k?E?33?z?zH?{?s33?ff?G??Q?zH????33??=q?R@Q@33?p@@p@ @%@2\@=q@@/\)@W
=@{@H@@\@q@^R@@l@5@ff@@H@@vff@a@w@n{@u@U@=q@~R@h@Y@G
=@P@\@w@
=@G@=q@ƸR@H@@H@ff@u@]p@@ƸR@@\)@G@@@w
=@{@@@qG@l@~{@ZH@G@!G@U@@o\)@fff@{@k@c
@^{@7@H@E@J=q@(@@33@@@?ٙ?p@33?p??@{@@=q@*=q@*H@U@<@_\)@k@@{@@H@@zA
ff@ȣ@ff@zA"RA@Ab{A0QAC
=A~\AeARA A	A  A&{@p@  @@k@Vff@s
@J=q@`  @r\@b\@A@o\)@7
=@R@dz@*H@A>=u=>\)=u=\)<=G=#
<
=\)=Q=Q=u=Q<
=>.{=
<
=
=
=G>=L==u=#
>\)=Q=L=\)=#
=#
=
<=#
=
=G>W
==
=\)=u=#
=#
<#
=G=Q=\)=\)<#
=<
=\)<
==u=\)>#
=\)>#
==\)=u=#
=Q>=
>#
>8Q=u=
<
===Q=Q=\)<
#
>=
==Q===>=
=
=L=<
=#
=u>==G=
=\)=\)=u=u=Q=L<#
>\)=u=#
=u=L<=G=#
=
<#
=G=u<=\)=\)=#
>>=#
=Q=Lͼ#
=#
=Q=u=#
=u#
=Q=L=u<#
=L<<<#
=u    <=\)=u>=
=\)<
=u===\)=
>=    =Q<#
#
=G=u=#
>=

=
=\)=G=#
=G=#
=
=Q<=L<=#
==Q=L=>\)=G=#
=\)=u=
<#
=G=
=Q=
==#
=
=Q=\)
    
    =L=\)    =Q=u>\)=#
=G>=
=L=

=Q<
=L<=#
=u=u=#
>8Q=#
=Q=#
==L=#
<
=
=u=L<
=Q=#
<#
=L=
=L=u=
<
=\)=L=L=#
=\)=

=>\)=    =
=u=Q=\)=#
>=G=G=\)=u=L<#
=G=\)==u<
=G=Q=Q    =#
    =\)=
=Q=
=
=\)#
>=\)=G=#
=u=\)=Q=
=G<
=G
<=Q=L=#
=L=L==L<
=G==#
=u    =
==\)<#
=L=u#
<<
=<=\)=
=L>=\)    =
<=Q=#
=\)=L=L>\)    =G=Q<=Q=#
=ͼ#
=L=u<
=G><#
>\)=\)=\)=Q=u=
===Lͼ
=<
=L==#
=#
>=G==#
=\)=L=u=#
==u<<

=G=u==G    =Q<=L=u<
<
=\)<
#
=>\)=G=\)=G=\)>>.{=#
#
<
<#
=u=G=
==\)=>\)=#
=<#
=Lͽ#
>=Q=Q#
=Q=u#
=
=>.{==#
#
=G=Q=<=G=L<
=Q<<<
==
=\)=\)=>
>\)=
==L<
=u<#
>==G<
#
=\)<
=Q=u==Q><=G=
=
<<=\)=#
=
=
=#
=
=#
<#
=#
=Q=u=<
<#
=L==
<=Q=u#
=L=#
<
=#
==Q=u#
=u<#
#
<<#
=#
=<#
=
=#
==\)<
=\)==\)=G=Q=ͼ#
=\)=L=
=G=
=u=L    <#
>>\)=Q==Q=L=
=u>.{=#
=L=u=G<=L==
<
==\)=#
=u=L<

=L=#
=L=#
<
=u<
==G=<=#
=#
<
==<
=#
=u=Q==L==L<#
=\)<
=u#
==u=L=#
=Q=#
=Q=u
=L=u    =L=\)<=Q=Q=#
=L=\)=\)==\)<=L=L<#
=Q=G=#
=#
=Q=#
=u#
=u=L<=\)=\)>=Q==L=\)=\)=
=u==L=L=#
<=#
=L=Q=\)=Q=#
=
<=<#
=Q<
=#
=L=L=G=#
<#
=
>=Lͽu=G<=Q<#
#
=L<
<=
    #
=\)=L=<=#
=L=G=Q<
=
=u<#
=
=Lͼ    =u<#
=L=#
=u=L>=\)<=#
=G<
=#
<
=L=Q=\)=L=
=L<#
<
=
=G<
>#
<#
<
<=u=L<
=#
<#
<
>    =#
=L<
=u=Q=\)=\)<
<#
=#
=
=
>=#
<=\)=u<#
=L=#
=
=u#
=#
=\)=L=Q=L=
=#
==#
=Q<
=u<<#
#
<#
<
<#

<
<#
=#
<=
=Q<
=#
=    #
=G=\)=u    =Q=\)\)=u=
>\)=Q    =
=u=u=L<#
==u=\)=
=L<#
=Q=
    =\)=
=#
<#
<#
===u=\)==#
<#
=
=\)=u=G
<
=L=Q=u=u=#
=G=Q=Q==
=#
    
>=u<
=#
=\)=\)==
    =#
#
=
=u<#
<#
<
=u=#
=\)=<=L=#
=#
<#
=u=Q=\)=Q<<=#
    =#
<=#
<#
=L=L>=
=L=u<
<<#
=
=u=>=G=G=L=Q=#
=#
=\)>=\)<
    ==L<=Q=Q=#
<
<#
=L=\)<
=\)=L==
<
>=\)=
=#
=Q<

=u>\)=#
#
=Q#
=\)=\)=
=L=u=Q=L=
<
    =
<#
==u=\)=Q<#
    #
=
=<=u=u=L>=u=L=u=
=\)=Q=<#
<#
#
#
=
=#
=\)=Q#
=#
=
=#
=\)>=u<==
=u=u=#
=#
=Q=Q=#
=#
=
=<=Q==L=G<#
=L>\)=G=Q=Q=
=<=u=u=u<#
=
==#
=#
=u=\)<
=u=\)=u=#
<
>.{>\)=\)==
=\)>.{>=u>>8Q==u==\)=u=
=
=u==L>    <
==L    =\)=u=L=<#
=\)=
    =L=L=G=G=#

<
=L=u=\)=u<=u<
<
<#
=L=u=u=G=
=u=Q=u=Q==L=u==#
>===Q=Q<=Q=Q=L>=\)=
=L=u=u=L=u=>=#
<#
=Q=#
=u<
<=\)=#
==#
=\)#
=Q>=
=
=G=
==Q=G=#
=\)==G<==\)=\)==L=\)=Q<=u#
=u=#
=L=L=
=#
=\)=\)<=#
#
=L=u=#
=Q=L>=Q==Lͼ#
=u<
<#
===
=G=
=#
<
#
==L=G=\)<#
=
>=Q=#
=Q>=Q=
=Q>\)#
<=u<=L=u=L=L=#
=\)=
=\)=Q=#

><
=L><
=L=
==Q=\)<#
==L    =Q==\)=u=L<
==L=Q=L    =\)==L=Q>\)>    <=
    =
=>=Q<=\)==\)    =u=Q=L=u=Q=Q==#
<
=
=\)=G=L>\)<<=L=u==L=\)=#
=>=G=\)=G=
==
=Q=\)>\)#
===u<
=Q==G
=<=#
=u=\)=\)=L=G=u<
=\)=\)<
=u=Q=#
=
=\)<
=
=u>=L=>.{=\)=\)<
=\)>==L>8Q=u==Q=
=u>.{=u=L=L=#

=#
==G=u=G=#
>\)    <#
=u=
#
=
=#
=G=\)<
=L=G>#
<#
=
>\)=u=u=
=
=u=Q=\)>\)    =#
=G=L<
=<#
=u=u=L=\)=
=
=L<
=Q=Q=Q=L=Q=\)<==\)=u=u<=>    =#
=
=<#

>====L=u=u=Q=L=>\)>=#
=u>B\=Q==Q===\)====u=u=G=\)==u<#
<

=#
<
><#
=\)=G=
=Q=L=Q=\)=G==<
=u=L=#
<#

=#
=u=u=Q=\)=u<
=
=L=Q><=\)>\)=Q=\)?(?n{?  @>{@  @(@`@R@@=qAQ@pAHA)AGA<(AeAQAffA
=AGA£AHAAAAGAHAARAQAA  AffAQAzA\)AAffAHApAA\)A  AAARA=qAQAAA33ARA=qA\A
=AzARA=qApA  ApAAQA{AApAA(ApA\)AApARAA
AAAAA\)A33AA  A{A\AA(AAAAtAmA\(AYAH(AO
=ADzAS
ABRA0QA.HA(A*\A*{A4A@QA7\)A7\)AKA8A>=qAC
=AtAL  AEA=AO\)AP(A{
=As\)AyGA}GAuA{
A`AqAAA|QADA9A;\)ATA[AWA=A1A,A"RAHA	AA(  A0AA(A@{@(@@g
=@C
@333@#33@\@z@4z@+@5@(Q@\)@
?H????
@\@@@Q?p?\)?  @\)@	@z@
=q@?z?
=?z?H?????p@@33??
=?z??\)?z?>\)>aG?(?{?ff@   ?
?\)?{@@	?R@
@@@  @8@)?p@\@\@6ff@1@8@>R@0  @<@G@;@H@5@L(@4z@ @E@R@=q@"\@@!@>{@@@ ??
=?G?h?G?{?G??H?{?}p?h?k?G?W
=>H?h?W
=?  ?k?xQ?B\?G?^R?Y?n{?z?z?B\?n{?aG>{?
=?
?
=?W
=???=q?
?H??=q??  ?s33?  ?}p?  ??z?(?\)?Q?У?{?z?R@R@:H@A@HQ@e@mp@@@Q@33A   A
A  AA*ffA(zA)A,A#A"\ApA	AA
=A   @ᙚ@ڏ\@33@=q@33@  @G@  @ff@G@@|@U@`@g
=@@Q@\)@@@G
=@h@W
=@Y@qG@Y@U@Tz@Mp@[@6ff@'@!@R?????@ ?(?fff?\?aG?xQ?z??ff?\???R?  @?H??=q?@Q@G?Q@\??H?{??
?@G@33@E@E@|(@Q@@ff@GA
A A>HA333ABffAC33AIpAlQAt  AsA=qAAA
=AA
=A\)AeAN=qAaABffA9AS
AXAz\AOAGA1A6\A%AzA (A  AA$A<QA.=qA7A=GAEpA/
=A1A\AA  A (A	A@=q@{@z@\@p@{@@  @
@
=@\)@ȣ@p@=q@@
=@@  @Q@@
@33@G@p@ff@
=@=q@@ȣ@@ff@ff@@\@
@ָR@\)A
AAzA
=A,(A+APQA\)ARAAyAHA\AŮA=qAᙚA܏\AיA\AGAHB\AQAA  AA{AָRB(AAzAAGAAA\)AAA  AQA}AyAc\)AXAXQAIAO33AEA<  A8QA9pA9A/\)A1pAAA
=AQA
=AAHAzA\)AAQAQARAQAQA
=A33A   AzAzA%AA1pA4AC
A4  A'\)A
=A@  @ff@\)A  A
A @޸R@  @@G@
=@ʏ\@=q@=q@
@޸R@G@
=@@ə@Q@
@33B{@ff@
@θR@33@ff@=q@@G@@ָR@=q@33@=q@z@\)@
=@p@@@Q@=q@@@H@G@Å@@Q@R@Q@@z@=q@\)@\)@\)@G@@\)@@
=@@@@@p@p@(@(@(@@\)@(@o\)@@jH@e@n{@e@Z=q@]p@[@qG@Tz@Vff@XQ@ZH@]p@fff@h@U@W
=@S
@e@b\@vff@R@g
=@@~{@|(@n{@s
@u@g@k@~R@w@Q@xQ@p  @@H@|(@@=q@s
@Y@[@QG@X@aG@s33@~R@
=@=q@R@R@@\@G@
=@@H@@p@˅@Q@@@33@  @H@p@H@z@{@
@@\)@
=@=q@x@y@u@z=q@nR@fff@e@c33@dz@n{@l(@g@l(@u@dz@hQ@tz@e@`  @a@w
=@xQ@@@@{@Q@ff@@{@
@@=qAAACAB{AHAXA{\)AQAypAtAc33A`AHAPAQAdAQAMA33AeAMpAb=qA
A^\A\QAMA?
A7A+A!A&\A+
=A  AA
@ffA\)@@z@\@(@G@(@z@\@@@@G@  @ۅ@@R@陚@(@ҏ\@@ff@@(@
=@@z@H@\@@
=@@G@(@\@H@@{@
@@=q@[@C33@C33@aG@|(@(@
@r\@k@  @H@\@@ff@
=@G@=q@@@@G@޸R@H@@@@\@ff@@@=q@@@G@Q@R@@\)@33@w
=@@p@(@  @A+
=A5A(A
A z@A
AA\@{ApA@\@A\)A33A	G@@@@(@=q@Q@
=@@@{@(@
@{@\@@H@ff@љ@
=@@
=@\@  @@@\)@z@=q@z@p@{@{@  @(@R@\@@@ff@@R@\)@ȣ@\)A
=@G@\@  @陚@ARApARA{A33AGAA	AA#\)A?33AQA1pA+33A  AA
=A
A{A4A9AeGA{
=AcAz\Ao
=AHAHAA33Bq{B,
B"pB	HB!RBA{AٙAAGBA
A33A
A  A
A{A(ARA=qAsAdA\QAZffATAOAWA^RAQGA^HATAAA<zAR{A
=A@R@\@ff@@@׮@p@@  @H@H@ڏ\@@@
@ff@
@  @G@(@p@R@Q@H@@@@
@@\@(@nR@fff@H@
@H@@=q@p@
@  @@R@  @z@@@(@z@@G@
@@@z@@@{@p@H@33@}p@|@vff@@zH@z@\@tz@a@jH@i@Tz@NR@K@Y@Vff@^R@]p@c33@tz@l(@nR@jH@z@@L@P  @P  @>R@:H@5@)@.{@!@0  @   @@(@R@(Q@!@@   @$z@#33@$z@,(@.{@)@,(@+@5@.R@.{@.R@%@333@A@!G@%@%@%@-p@1G@"\@@\)@!G@2\@)@x@@
@
@Å@H@\)@  @@@
=@@
@H@
=@33@@@@\@@ff@\@@@@  @33@Q@H@{@ff@\)@@Ϯ@أ@@pA@ff@ff@p@=q@(@
=@=q@33@p@@(@@@G@H@@@@ff@|(@=q@@
=@{@G@@@\)@
@@z@=q@(@R@@\)AA\)A
@
=@
=@@@H@=q@@@Ǯ@@ʏ\@ҏ\@p@Q@33@
=@ۅ@@=q@@ҏ\@
=@@@@@@Q@@@33@ۅ@
@\)@z@@\)@@p@ڏ\@  @@\)@@޸R@\@@@أ@ָR@33@{@Q@@@ڏ\@@G@33@ָR@Q@{@R@@\@\@У@أ@У@Q@@
=@\)@ff@{@@@Q@@Q@@@QA(@@Ϯ@@\)@
@@@
@@@@33@
=@Q@@\)@G@{@
@@R@33A=qA
AAffA33A/\)A2RB1\A>=qATzAapAx  AA=qA  AAHA
A=qAGAARAA\A
=ApA{AAzAA
A
=A
=AAAffAApAA\)A=qAAAHA
=AAA  AA(ApA(AAQAAARAGA=qA33A  AA  AA\AGAAAHA
A{\)Av\AoAk
A[
=AmAdApzAzHAA=qAyGA{Av\At  A~\AzA{Az=qA~\A(AA\)A\)A\)AzA\)ApA  AA33AA{ApAAAAHAHA\A{AA
AQA(A\)A  A  A33AQAxQAmA|(AnffAmAr=qAApQAeAc
=A\  AW
=AcAYAYAVHARRAPAV{A_ASAEA<A5GA+
=A/A9A$  A$(A1A%GAffA!A+33A\A(A{ARA=qA
=A{AAA=qARA33A{A(A AA!AzAA
AAHA
=AAffA
=A%A#A)pA(zA8QA6{<y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @ٙ@G@=q@ڏ\@ڏ\@H@(@(@(@z@z@
=@
=@  @H@@z@{@\)@@@@=q@H@33@@Q@@@R@G@G@Q@  @
=@  @\)@R@@@@@p@{@@@@(@z@(@@{@  @@Q@޸R@@  @
=@{@
@z@ۅ@
@{@  @@\)@{@Q@@  @\)@  @=q@ۅ@p@p@p@p@@=q@@׮@z@\)@  @
=@׮@Q@p@{@@@@@z@@\)@Q@G@@H@@
@@ff@\)@  @=q@@(@@@ff@{@@@z@(@p@@@p@
=@@Q@
=@R@
=@{@@R@ff@@(@33@\@=q@@@G@Q@@z@@ff@(@@@@
@G@@  @R@@@(@@z@@p@
=@陚@@(@z@@(@ff@(@p@{@Q@  @Q@߮@Q@p@ڏ\@ڏ\@@@@\@@33@@ᙚ@ᙚ@@(@\)@@\)@H@33@@H@\@\@\)@
=@@(@\@z@
=@Q@@H@
@@(@@@Q@@{@R@  @@  @@\)@  @\)@  @ff@@ff@@
=@p@@\@@@=q@G@  @@Q@@\@@  @@@ᙚ@G@ᙚ@ᙚ@@  @߮@
=@  @  @Q@ᙚ@=q@  @=q@G@  @=q@  @@\)@@@ۅ@(@z@@{@޸R@\@\@33@\@R@@ᙚ@Q@G@z@(@@@
=@
=@Q@G@@=q@@@@@\)@  @@\@33@z@@@\)@G@\@=q@@G@@  @  @
=@
=@{@@@p@@=q@@=q@(@@@G@@@  @  @@
=@{@p@p@@ff@(@@\)@=q@@\@@@ff@z@Q@  @@@z@@z@
@H@@(@@
=@@
=@Q@
=@
=@ff@@R@G@陚@(@@@p@R@R@\)@@Q@@\)@R@p@@\@陚@G@H@H@
@\@(@p@@陚@=q@@R@{@
=@R@ff@@R@@p@ff@Q@@R@(@z@\@R@@@=q@G@G@ᙚ@\@\@
@@޸R@ff@{@@{@{@@
@33@=q@G@Q@  @  @Q@  @߮@ff@{@޸R@p@p@@@p@@(@(@ڏ\@{@ٙ@z@33@z@׮@H@@\)@H@
@׮@p@Ӆ@(@@@  @p@H@p@޸R@ff@@@@@ff@޸R@{@{@ff@
=@ff@Q@@{@{@
=@
=@߮@  @@@@=q@=q@\@=q@\@H@\@H@H@H@@@@Q@@@\)@@\)@
=@߮@p@߮@޸R@\)@߮@޸R@@@
@=q@=q@
@H@H@=q@ۅ@G@@33@ٙ@ٙ@G@@ٙ@ٙ@ٙ@ٙ@@ٙ@G@@  @׮@\)@
=@ָR@
=@ָR@׮@@H@ۅ@
@׮@أ@=q@@@ٙ@ٙ@=q@@ۅ@p@޸R@Q@\)@Q@
=@{@\)@޸R@޸R@  @@H@33@\@=q@ᙚ@@޸R@p@{@ff@޸R@\)@
=@\)@  @@G@
@R@陚@  @33@z@H@\)@޸R@޸R@޸R@p@
=@z@33@@z@(@H@H@H@ٙ@@  @@=q@33@H@@ڏ\@H@@ٙ@ٙ@G@@ڏ\@H@
@
@33@=q@أ@
=@׮@@z@
@(@33@33@Ӆ@33@
@@ָR@
=@G@=q@ۅ@=q@=q@=q@ٙ@ڏ\@=q@H@=q@ڏ\@ڏ\@ڏ\@33@33@ۅ@
@(@z@@@p@@{@{@ff@޸R@޸R@
=@  @Q@Q@@@@ᙚ@G@\@33@@33@ᙚ@=q@G@߮@@p@޸R@(@(@z@(@z@33@Q@{@׮@@
=@Q@ff@G@G@
=@\)@\)@\)@׮@׮@׮@\)@  @׮@أ@׮@@G@أ@  @أ@Q@ٙ@ٙ@  @@H@z@H@
@ڏ\@Q@@@׮@ff@ff@  @\)@  @أ@ڏ\@ۅ@@޸R@{@ff@ff@{@{@޸R@
=@\)@߮@Q@Q@ᙚ@H@z@H@=q@@@=q@\@H@33@33@
=@G@陚@  @
=@\)@{@@@(@33@@33@H@
@Q@\)@H@@=q@G@@ᙚ@G@
=@޸R@
=@
=@߮@޸R@߮@
=@ff@޸R@޸R@ff@{@޸R@p@{@z@ۅ@ڏ\@(@@@z@@ۅ@33@z@@p@@@{@@p@ۅ@@z@  @\)@{@@
=@Q@  @߮@߮@H@33@p@p@@@@{@ff@@p@{@p@{@{@ff@{@R@@Q@@@ff@@  @G@@=q@@{@{@@@H@@陚@@\)@G@@=q@@  @Q@ff@p@@(@H@=q@H@ᙚ@\@@
@
@@@ڏ\@33@ۅ@(@
@33@33@33@H@@=q@{@{@\)@p@@@
@p@ff@{@33@z@@@\)@߮@@=q@H@\@  @{@@@H@@H@(@@z@=q@
@p@@{@R@\)@\)@@Q@@H@@(@@@@p@z@@{@{@
=@{@H@z@
=@z@{@@@H@@@
@G@@Q@\@@陚@G@@@\)@ff@ff@{@{@@p@ff@{@{@  @z@p@H@H@@\)@@R@p@
@@@z@@@H@H@p@@\@@Q@G@Q@@p@H@  @G@\@H@ff@@ff@
=@{@
@  @@@(@@G@@\)@@@{@@z@z@@@@@R@{@
=@  @@G@Q@@@Q@@@R@@Q@@@@@  @@\@33@\)@(@@@=q@Q@{@ff@\)@  @H@@{@@
=@@H@@@=q@@(@@
=@  @R@@@Q@\)@@@@ᙚ@޸R@ff@
=@p@@@
=@  @G@@@
@G@p@@@G@@G@@H@@{@H@=q@p@@p@z@(@
@33@(@H@H@H@@H@@ff@
@R@\@{@@@@z@@
@(@{@\)@Q@=q@ff@@ff@R@R@z@\)@{@@@@(@
=@\@=q@  @G@H@@H@@@H@@@H@(@@(@
@Q@  @@@p@@@(@(@\@߮@=q@(@(@@p@p@z@z@H@@33@@=q@@
@G@R@
=@陚@H@=q@z@\@@
@H@\@=q@\@ff@z@Q@z@
@
@R@\@@ff@@
=@ff@{@RA zAA@z@33@@
=@AAARA=qAA @GA\@ff@@G@z@@@\)@G@p@
=@Q@@@@{@ff@@z@(@
@(@z@@@(@G@ff@@z@(@@@33@z@33@
@=q@G@33@\@陚@@G@p@
=@Q@\@@@z@@=q@G@G@  @\@@@R@\)@(@\)@ff@@@Q@R@R@z@  @
=@A AAA{ARAzAGA\A33AQAQAAQAAzAA
=A  A\ARAAH@A33@{@GA   AAAA zAA\)A @
@@(@z@=q@z@@@ff@\@@@z@ff@\@@@=q@p@@R@ff@=q@@=q@\@  @陚@G@G@G@\@H@@@H@@@@@@@=q@33@@@G@33@\@H@
=@ff@AAQAGAA
AzAAzAffAAA\AA
=AAHAQApAAA33ARApAA\)A33A
=AHAQAAA
=qA @\)AGAzARAAAA (A zA zA{A@
=A z@RARA
=AffAzAA Q@\@R@{@{@@@@=q@@@R@@@@@33@Q@@{@@p@ff@@ᙚ@  @\@
=@=q@
@\)@G@@
=@z@@@ᙚ@
@\@
@
=@@
=@=qA zAAAA
A
@p@{@{@\)ApAA\ApAA  AARA33AffA=qAAGAQA
A
AA\)A@p@\)@R@RAA{A @@\)@z@p@z@R@ffA (@ff@G@z@@@z@=q@H@H@@@=q@@33@@\)@  @@ָR@p@@\@@ۅ@=q@(@@(@33@@@ҏ\@Q@@ָR@p@
@H@ff@
=@33@p@ָR@Ӆ@@  @G@
@ff@p@@ָR@ҏ\@@@׮@@@@(@=q@z@(@Ӆ@@
=@(@ҏ\@=q@ҏ\@=q@p@p@Ӆ@Ӆ@@  @θR@\)@ff@p@ə@@@{@˅@H@  @@Å@G@33@@G@H@=q@@G@\@H@Å@H@@G@@33@33@p@
@33@=q@@ȣ@
=@@z@H@@ȣ@Ǯ@\)@Q@ə@\)@(@G@@@@ff@G@\)@R@@  @=q@@@(@Å@\)@G@\)@ff@@˅@˅@ə@33@ȣ@H@G@z@(@p@\)@@Q@@33@ʏ\@ȣ@\)@Ǯ@H@ə@ʏ\@H@33@@(@@p@@p@@z@z@p@@@@@Q@{@@{@(@H@H@33@z@@
@(@θR@@@  @@33@Ӆ@љ@Q@\)@(@
=@H@@@\)@\)@
=@
=@\)@Ϯ@Ϯ@
=@G@Ϯ@  @Ϯ@@{@θR@ff@Ϯ@  @Ϯ@θR@@=q@=q@33@ۅ@@=q@߮@Q@  @@
=@ƸR@=q@ۅ@\)@  @{@=q@ff@z@33@33@޸R@ٙ@
@p@{@{@@@ۅ@H@(@@z@@Q@@ָR@@@ٙ@H@أ@ff@@z@(@33@
@  @@
=@@@z@p@ٙ@  @ff@{@p@{@\)@׮@ָR@\)@\)@Q@׮@  @Q@أ@{@(@{@
=@ٙ@ٙ@@أ@أ@׮@׮@׮@׮@  @  @  @׮@@G@أ@@أ@@
=@
=@ָR@@Ӆ@33@ҏ\@ҏ\@@ָR@\)@G@@@=q@@(@p@
@(@z@@(@@ff@@\)@@\)@
=@@@@
=@@ᙚ@
=@(@p@=q@ڏ\@ٙ@
=@׮@׮@
=@
=@
=@ָR@ff@{@ָR@
=@
=@ָR@{@@@(@(@z@z@@@@@@@@z@@@Ӆ@@G@У@  @Ϯ@
=@\)@ff@Ϯ@ff@Ϯ@Ϯ@  @\)@\)@  @Ϯ@G@љ@H@ҏ\@@θR@{@@(@@ff@{@  @  @θR@Q@ff@{@@Ϯ@ҏ\@
@p@أ@H@@@  @ٙ@Q@G@H@33@ۅ@@߮@@@@@Q@ᙚ@z@@@@(@H@@Q@  @޸R@z@@@33@33@ۅ@ڏ\@@(@Ӆ@(@p@@=q@p@@@@@@(@@
=@
=@@@@  @أ@ٙ@ٙ@@ٙ@G@ٙ@@أ@׮@׮@
=@
=@ff@{@p@@@@@ff@H@@ҏ\@z@p@ָR@ff@z@Q@أ@z@׮@Ӆ@
=@@أ@@ٙ@=q@ff@ۅ@(@  @
=@{@Q@33@(@ff@@ᙚ@ᙚ@@@߮@{@@G@@H@(@@(@=q@  @޸R@@ff@\)@\)@H@z@z@33@33@ڏ\@33@=q@ۅ@=q@\)@z@33@G@Ϯ@Ϯ@\)@Ϯ@θR@θR@{@θR@Q@  @Q@  @  @@ָR@\)@@@Ӆ@ҏ\@Ӆ@Ӆ@
@(@@
=@{@@H@@Q@33@(@@@Q@{@@׮@{@@{@@
=@
=@  @ۅ@
@@p@@z@@(@
@ff@ᙚ@@(@(@
@
@
@33@=q@H@33@@=q@G@@33@@H@\@H@33@
@ff@H@G@G@߮@{@z@33@H@ٙ@=q@Q@@  @׮@
=@\)@ff@ff@z@(@ҏ\@(@H@ҏ\@  @ff@\)@
=@
@@ȣ@G@Ǯ@ƸR@Q@@G@Q@  @ƸR@@G@ʏ\@H@У@@z@33@Ϯ@  @{@Ӆ@=q@ff@z@p@  @ڏ\@ۅ@33@z@33@(@H@ۅ@
@
@@{@߮@ᙚ@33@z@R@z@@z@
@@
@
@H@33@H@\@=q@ᙚ@@G@@ᙚ@ᙚ@=q@\@H@H@@@@߮@Q@\)@ff@\)@p@p@@H@\)@33@z@=q@ٙ@ڏ\@G@Q@׮@\)@\)@ff@ָR@ff@
@Ӆ@33@@
@Ӆ@ҏ\@θR@˅@@(@Ϯ@=q@{@=q@љ@@=q@@33@
@@(@(@
@z@\)@H@
@p@33@z@
=@G@ڏ\@ۅ@@ff@@p@ff@޸R@
=@  @
=@
=@޸R@ff@@@
=@߮@Q@@  @Q@ᙚ@=q@  @p@\)@\)@H@G@{@@  @p@ᙚ@ᙚ@(@H@@Q@@@@\)@\)@ff@(@G@H@ڏ\@z@@z@=q@@@=q@ٙ@أ@׮@{@ָR@  @أ@Q@=q@ٙ@أ@@  @  @{@{@\)@@Q@\)@G@@@=q@(@ڏ\@@  @G@@@ٙ@  @
=@Q@׮@Q@ָR@p@{@@@33@׮@G@ٙ@
@@p@p@@z@@ۅ@H@@ۅ@33@ۅ@(@ۅ@@
@ff@  @  @ᙚ@G@@  @  @  @  @  @\)@\)@  @\)@@߮@
=@޸R@{@33@@
@p@޸R@@z@@
@ۅ@33@\)@ٙ@ٙ@׮@ڏ\@@33@ٙ@ٙ@G@\)@أ@ff@Q@ָR@  @  @Q@
=@Ӆ@У@ff@z@  @  @@p@ٙ@ff@׮@ڏ\@\)@Q@߮@ᙚ@@  @
=@
=@޸R@@p@  @Q@@G@G@=q@ᙚ@ᙚ@
@33@@(@H@@(@(@
@(@@(@p@@p@@33@=q@
=@p@p@@
=@Q@@(@\@H@@\@33@@@@ᙚ@ᙚ@@  @Q@޸R@Q@љ@  @Ӆ@{@=q@@ff@{@ۅ@33@z@z@@߮@\)@{@޸R@ff@\)@޸R@޸R@@ff@޸R@{@p@(@z@@@p@  @@@{@@G@ᙚ@
@@
=@
@=q@H@
@@@@\)@Q@  @  @G@@陚@\@@33@33@33@
@@@陚@@@@@@=q@=q@G@@33@  @\@=q@\)@@
=@  @H@@(@  @  @@@@G@@ff@@@p@p@
@@H@ᙚ@
=@ff@޸R@ff@  @  @Q@ᙚ@Q@Q@G@@33@G@G@G@@Q@G@@@
=@@@ᙚ@޸R@Q@{@33@G@H@@Q@أ@G@G@@(@  @@=q@(@@@@{@@p@@p@R@@
=@@  @@@@@
=@ff@z@R@@=q@\@=q@  @  @H@@33@陚@@{@\)@R@p@z@p@@@@H@H@\@@@@Q@G@Q@Q@Q@@  @
=@  @߮@޸R@
=@Q@޸R@߮@߮@G@H@@\)@Q@Q@Q@@߮@  @\)@@@z@@@p@p@@@@p@@ۅ@
@33@33@H@(@{@Q@Q@G@@=q@=q@@\@\@=q@@=q@\@H@33@@
@(@(@@@@@@z@(@z@(@\@
@@\)@\)@@z@@p@@@@@
@@
@
@(@{@ff@@H@z@{@@p@p@@p@@(@z@@@@(@H@z@z@(@@p@@@=q@
@z@@G@@\)@Q@ᙚ@\@=q@@ᙚ@ᙚ@@@33@
@@@(@(@z@z@z@z@z@z@@@@ff@ff@\)@@@@\@@\@
@z@z@@@ff@\)@@@
=@\)@
=@R@ff@ff@@ff@{@@(@33@\@@p@@(@H@  @Q@\@@@H@33@H@33@33@@=q@陚@@@ff@
=@\)@\)@
=@  @\)@  @  @@  @\)@@@@Q@@@\@=q@\@@@G@R@@33@33@33@H@\@
@z@ff@\)@  @{@@ff@33@@=q@
@@@ff@(@
=@=q@H@\@(@ffA (AA
AAA33A
A	A
RA
HA	AA
=AAA
=AAA33@AR@{@
@\)@  @G@
@33@@\AAp@\@\)@@\@H@  @@@@(@
@
@(@@H@@G@@@G@Q@@@@@p@z@{@@@{@(@p@@p@@陚@H@(@H@\@@G@  @=q@@@@ff@  @  @\@(@
=A (AAAGA33AzA
=A
=A  A	pA
A
{AA	pA	A(A
A
A
A\)ARA
=A
=AHA
=A33A\)ARAHAA
AA33AA\)AAAA@AffAAA33A
=AA
=A\)A@RA Q@A @33@@(A   @@{@@@@H@=q@@Q@@@\)@  @@  @@(@@@  @@
=@\@=q@@z@Q@ApAAGAA\A\)AA=qA\)AzA(A zAAA
{A
=qA(ARA=qAA  A33AffAAAAAA\AA
=ApARA
=A
\A33A\)A(A	pAQA
=AffA\ApAA
AARA{A@R@@
=@@@{@\)@G@@@@Q@{@H@p@@@@@{@
=@
=@@z@(@@H@\@@@p@
=@33@\@H@@=q@(@\@33@@@@@ff@{@@H@@
=@H@=q@33@@@=q@=q@\@G@@33@p@G@@@G@R@z@
@R@@@@(@\@
@G@@G@Q@
=@  @
=@  @H@@\@@G@@(@@\@@  @p@@@{@
@@@  @߮@
=@޸R@ff@޸R@޸R@{@ff@
=@z@33@ff@{@Q@{@@ƸR@33@(@\@@(@(@Q@G@ƸR@33@@=q@p@33@\@@ff@\)@
=@G@p@ҏ\@=q@(@@@  @@
=@  @@=q@߮@@@  @{@\@\@=q@߮@(@޸R@@z@ۅ@
@@ff@\)@\)@  @@G@=q@H@33@
@@33@=q@G@  @  @
=@\)@@=q@Q@@  @\)@
=@
=@@@@z@(@ۅ@ڏ\@H@33@@ٙ@@  @׮@\)@ָR@{@@ҏ\@  @  @Q@Ӆ@@@@Ϯ@@
@(@G@33@ָR@@ٙ@@ڏ\@ڏ\@@ڏ\@G@ڏ\@=q@=q@Q@@@ٙ@p@{@@@׮@
@ff@  @޸R@޸R@{@ff@\)@
=@޸R@߮@߮@Q@@@ᙚ@@=q@H@
@@@(@@33@@G@33@(@\@\)@ff@@z@Q@
@33@\@ᙚ@
=@Q@G@
=@@33@H@ڏ\@ڏ\@=q@G@׮@Q@  @ָR@{@{@
=@׮@\)@ff@ָR@{@ff@ָR@{@ff@p@Ӆ@Q@H@ff@33@ff@ҏ\@أ@Ӆ@ڏ\@ڏ\@ٙ@ڏ\@أ@H@ڏ\@=q@G@=q@33@H@@33@H@=q@=q@=q@H@@ڏ\@ڏ\@33@33@z@p@
=@ff@{@@p@{@޸R@޸R@\)@Q@ᙚ@H@H@(@z@(@(@
@@@z@@@p@ᙚ@@ᙚ@Q@߮@\)@
=@ff@{@߮@\)@ff@ff@@
@33@ۅ@ۅ@ۅ@
@=q@ڏ\@H@33@ڏ\@ٙ@=q@@@ٙ@@@@ٙ@ٙ@G@@Q@Q@\)@G@ڏ\@
@@(@
@33@ڏ\@G@@ָR@أ@׮@@ڏ\@ڏ\@ۅ@ۅ@=q@z@(@޸R@߮@Q@߮@\)@Q@߮@Q@G@ᙚ@@=q@@G@=q@H@@@@@@
@{@@(@@
@p@z@@(@(@
@=q@@\)@{@
=@
=@ff@{@@@{@޸R@ff@\)@\)@޸R@ڏ\@H@(@@޸R@@
@\)@ᙚ@@Q@p@z@׮@@z@=q@Q@  @{@Q@G@ff@أ@33@
@=q@ڏ\@Q@z@@p@@@
=@@@@  @
=@Q@@\@@33@ᙚ@@  @@\@p@ff@ff@
=@
=@@p@R@
=@
=@  @G@陚@陚@@=q@H@@@@
=@ff@{@ff@  @\)@
=@@R@\)@\)@@z@z@33@\@H@33@33@@@H@=q@@@@Q@@  @@@Q@  @  @@@\)@\)@@\)@@\)@\)@@  @Q@Q@p@@(@@@@@@@(@
@H@ᙚ@
@\@@@߮@(@
@
@@p@z@p@\)@Q@Q@33@\)@=q@G@H@Q@G@=q@@(@{@Ӆ@(@  @@{@H@ۅ@@ٙ@@\)@=q@=q@\@=q@G@@߮@ff@z@z@@
@@@z@p@ff@\)@@\@
=@@p@{@ff@
@G@ᙚ@33@\)@@z@(@33@(@(@{@{@
=@@@@ڏ\@@@G@@أ@\)@  @Q@  @  @׮@Q@أ@\)@H@ڏ\@@@@p@ۅ@p@@p@@(@ڏ\@p@33@33@߮@
=@Q@H@=q@{@
@@@{@ff@Q@\)@Q@33@\@@@H@(@R@
=@\)@  @@R@R@@{@
=@  @
=@ff@ff@z@@z@@@{@ff@\)@@ff@@ff@
=@  @\@@p@@Q@{@ff@@
=@=q@@H@@  @@p@@
@ff@R@ff@
=@@
@G@Q@R@G@  @@\@@Q@@H@@@=q@(@H@R@@R@@R@p@Q@ff@(@p@ᙚ@G@\)@@@@=q@
=@G@@@
=@\)@G@@@@@=q@33@z@@@Q@
=@\)@@@ff@@ff@(@Q@@p@
=@p@  @33@@@Q@@G@@@ff@Q@@@z@@H@@R@@G@ff@@Q@{@(@{@H@@@(@Q@@p@
@@@@p@ff@z@\)@33@G@H@@H@
@33@33@@@  @R@@
@Q@陚@@@H@(@Q@@  @@@@H@@G@陚@陚@=q@\@@z@p@\)@  @@@@33@H@H@@@\@Q@(@=q@33@@=q@@ff@@@@\@@33@z@@@@H@陚@
@p@@@@@\)@@
=@@ff@@(@=q@R@\@\@33@=q@@@{@  @@G@@=q@@@
@(@{@@\)@G@  @
=@{@(@{@{@Q@p@@@\@
@@{@
=@R@@p@ff@(@=q@@Q@@=q@=q@=q@@z@{@z@
=@H@z@z@
@p@@=q@p@@=q@z@@G@@p@@G@@=q@@@@G@\@Q@ff@  @=q@@
=@
=@@@  @\@H@
@p@@@R@(@Q@Q@ۅ@@޸R@޸R@33@p@{@p@
=@p@߮@@33@
@{@H@
@
@@\)@33@{@@@33@(@\@G@R@@33@{@33@33@
@
=@Q@  @陚@@\@=q@@33@\@@@@
=@  @Q@@@@@@@@@@\)@ff@{@{@ff@
=@z@@
@33@H@=q@H@H@=q@\@@
@\@z@(@@  @
=@陚@(@@=q@p@Q@R@G@=q@@@\)@@@@{@
=@\)@@R@{@(@z@{@{@@@{@
=@@@{@\)@{@@G@z@Q@(@Q@@z@G@@33@@@
=@߮@޸R@p@߮@p@G@@33@ᙚ@z@@H@
@
@{@@(@@G@
@z@z@=q@H@@@(@ff@(@Q@(@(@\@33@@@@@G@{@@G@z@@@G@
=@@
=@\)A QA z@GAR@@  A\@R@
@@@@z@z@H@(@@p@p@33@H@  @z@\)@  @H@\@  @Q@
=@@@@p@\@\@@@ff@@ff@z@@\)@Q@p@G@{@ff@R@ff@
=@{@=q@p@\)@\@{@@=q@@Q@@@G@33@{@@\@33@
@  @R@
@z@ff@
=@\@@p@  @@
@ff@(@@G@=q@Q@=q@@@(@(@@@z@\@H@@\@=q@HAAffA@\@@R@@{@G@(A
A33A\)A	pAGAAffA
Aff@
A
=@QA Az@p@Q@pAA33A=qA33A{A\AzA	pAAA A   @H@G@GA AA zA A zAA zA zA
=AAA(A\AA33AQA   A   A z@(A (AA @z@\A33AH@
=@\)@@H@@@@(@z@
@
=A z@{@R@\)A A QA zA{A=q@R@\)@\@\@@@G@ff@z@ffA zApA A{A
AQA
A\)@A\A
AAAGA=qA33AGA\Ap@\)@p@
=@
=A @\)@\)@=q@p@z@@A z@@z@A@G@pAA@G@  @ff@p@=q@G@@{A@p@33AR@
=@
@z@@@Q@@@ffAQ@=q@@(@z@33@
=@
=@
@{@  @ff@
=@\)@@{@z@@\)@p@AGAA\A AAA @
AG@
@  @\@@{@{@33A A (A\A\AA(A AAAHAAG@
@=q@@R@ff@\@\)@@Q@QA   A\A{AAQA	GA
HA33A
AA(AAApA{AAAQA=qAA
AffA{AA
=A\AAA\)ARAAA
A
\AzA(A	A  AAA
A=qAA(A(AA=qA
AQAA
AzA
AAffA
A
ffAAHA
AA
ffA33A
=qA
\A	pA	GA	GAA
=A	A	A
HA	GAA  A(A\A
=A\)AAA
=A
AzA  AAzAGA{AffAAAAzAA
AA
A\)AAGARAzA{A\AA
=A
=AA
AA=qAA=qAAAA\)A{AGA
=A\AAAA=qAAA
AA\A\ARAAHA
=A
AA
A\)AAAA(A
AA\A33ApA
AGAQAApA\AAAAQAAHAAA
A
pAzAA
{AQAA
ffA\)AAAAA
A	AQA@=q@H@@ff@G@@A
=A(A33A
AffARA(A(AA33AA  ARA
=AzAzA\)AA (A QAGA zA AAHA
=A\ARAGAffA33A(AQA
{A	A
{A
\AQAA33A
=A\)A
\AAzA
=AA	AARApAAA(A  A
A\)A\AAA{A zA (A zA
=AApAApA=qAAA\)AA33AA
A	GA	pARAAffAGA
=AQA   A{A  A\AA33AAA\)A\A
A  A@
=@{@\@A   @z@AA @Q@=q@\)@H@@AAp@RA A (AA @=q@@33A{AGAAffAHA33ARAAQAA
=AffAHA
=A
=ARA{ARA
AA=qAp@\)@@@ff@@@@R@@@G@=q@(@\@
@@@{@@G@
@
=@ff@ff@@\@{@@z@G@\)@(@{@
=@ff@=q@{@@(@@ff@
@\)@@=q@p@@@@@ff@@  @@  @@33@@@@@@33@ff@ff@Q@z@@@@\@Q@@@\@G@@@@@Q@=q@\@33@H@@ff@@G@@@ff@
@(@ff@R@
@\)@@陚@\)@R@
=@  @z@
@H@{@ff@Q@H@
@Q@ָR@@@Q@33@\)@
@(@Q@ff@@@
=@Q@\)@  @љ@{@{@ʏ\@H@G@ff@@p@(@33@33@{@
@(@  @G@
@@
@أ@(@(@@Ϯ@G@G@Ϯ@=q@z@Q@(@θR@H@=q@H@z@θR@Ϯ@У@У@ҏ\@33@Ӆ@أ@ٙ@ڏ\@{@@\@޸R@=q@@Q@@Ӆ@z@p@(@ָR@׮@H@ʏ\@G@@
@ҏ\@G@G@љ@  @  @@
@@ff@33@ff@Q@G@G@33@  @ʏ\@(@\)@H@@z@p@@@ff@@ff@׮@\)@G@׮@ָR@أ@@љ@@Q@p@@G@θR@H@p@{@H@ff@׮@ٙ@أ@Q@
=@أ@@H@{@33@  @z@p@  @=q@H@=q@=q@p@R@p@
=@ff@=q@p@@(@p@\@@@z@
@
=@@@@{@ᙚ@߮@{@@(@@z@
@p@ff@  @{@G@z@z@@
=@
=@@p@޸R@z@@@{@  @Q@(@33@H@\@ᙚ@@@p@޸R@33@z@
@ٙ@@33@H@أ@H@ڏ\@ָR@ڏ\@Q@(@@@@߮@=q@߮@߮@@ff@@@@@
@33@ᙚ@33@@@@{@
=@\)@R@R@ff@\)@G@33@=q@@@@@z@{@{@
=@\)@H@33@=q@@@@=q@H@33@{@33@@33@\@  @@H@@
=@z@
=@@G@  @Q@z@@@R@
=@
=@p@H@@@\)@
=@@{@@G@@(@{@(@\@p@=q@z@@@@ff@  @@\@ff@@޸R@@@  @H@ff@ff@p@{@R@@@
=@@=q@@@  @
@(@{@p@{@{@@{@H@ff@@
=@z@R@p@@@=q@@{@\@\)@@@  @
=@
=@Q@@@33@\)@
=@@33@@  @\@@@@
=@R@@R@
=@R@R@{@33@@@H@@@R@33@ff@
=@@Q@=q@=q@p@(@33@
@@@ff@
=@\)@{@{@{@
@  @@\@{@@H@@@{@33@@@
@@(@@
=@  @\)@
=@@@@=q@@G@Q@G@=q@\@(@{@\)A (A ApAffA33A  A33A\)A
=AAzAzA(A  AG@ffAGA QA @\)@RA zA AA @=q@\@  @@@\)@33@p@{@\@@@@G@R@\)@
@@@@@(@ff@R@p@ff@@@@@
@@R@@z@z@@=q@@@33@33@
@R@=q@Q@  @\)@Q@@@Q@@\@H@@@\@RA A AAAHAA
AGA	A
HA\)A\)A\AARAHAAzAffA  ARARA
pA
=A
=AHAAAAAARAApA
HAA	A	A	GARA
A
A
A
A{AA
=A\)A	GA	GA  A
=A33AzA\)AHA  AAA	AQA	pA @
=@@=q@R@@@{@@p@G@A (A{A(ApAAQA @\)A@\)A{A A(A
AA  A
=A	AffA	A\AA
RAQA
=A{AAA{A=qA{AAHAGA\)A!pAffAAffA{A\)A
pA	A
AAzAzAAHA{A33ApA
=A{ARAAffAA{AHAA	AAAA
=A	GAA	AffA
HAA
=A	AQAAQAAzA\AA  A33@{@{@RA zA A{AQAffA   @p@@RA33@RA @33@\)@z@\@GA@z@\)@A  A\)AA=qA\)AHA	pA	AAHAA
=AQAAA  AApAA  A{ApA QA!A!AAA\)AAAzA QA!A#
=A!GA A$  AA=qAAHAAAGA=qA
=A=qA33A(A
A
AQAAA
=A\)A{A33A
ffA  A	A{A\)A	GAQA\A
AAHAffA\)AA
AA
=A=qARAAA  AA\)A(AA{AAA(AA
ffAA
=A
RA
\A33A33AA	pAQA  AQA  AA\)A  AA
A=qARAAGAzA
A
GAzAA\AA=qA=qAA33AAA  AAAA
=A33A
=A(A33A{A\AAGAA33A(AAzA{A33AAARAA	A(A33AAA
A
=AA  AGAAAHAA
=AAA=qAA
=A\)A=qA
=A
ApA (AGAffA   A   A   @(@z@
=Ap@RA (A   AA AAAAffAAA  AffA  A	GA
ffAA33A	A	A
A\AAA33AAAGARA(AQAffA=qAAAGAAAAzAAA(A\)AAAQA\)AAAQAzAA\)AAffA
=A\)A
A
ffAAA
=A
{A
\A	AzAA	AA
AA33AA  A
{AAAAA33ARAHAffAHA\A33A
=AAARA\A\)A(AzA  A\)AQAQAGA\)A33AAA
=A
AffA=qA
=A\)ARA\AHA=qAffAA{A33A	A
pA
A
AA\)AA(AQARA
A
HA
RA33A
HA
RA	A	GAzA	AA33AzARAQA33AzA33A(AA\AHA
AAAA  AA(AAAAAffA
AGAAAAGA=qAHA33A\A=qAAAHA{A\AAA
=A
=A A z@RA A @@@(@
=@\)A   @p@@33@@
=@G@\)@p@A A QA @AA Q@@@
@@\)@@@ff@@@@@@@=q@\)A @\)@@
@@\)A (@\)@@@H@@R@33@(@=q@\)@H@\@
@@\)@@R@R@@@z@
@Q@  @@Q@=q@陚@@z@@Q@33@
@@p@\@(@  @G@Q@\@H@@Q@@@@{@33@
@@@
=@@H@@(@@@@@陚@@@@G@Q@G@@@\@{@ff@R@{@@@@@@R@@Q@33@@R@\@p@A z@@@@\)@z@@@@@ff@
@@=q@G@{@Q@z@@p@p@(@Q@@  @
=@=q@@(@33@33@G@=q@H@33@\@@
@\@{@(@(@{@@ff@
@@  @ff@ff@@@(@
@33@@@陚@33@z@ff@=q@  @
@H@H@@G@33@@
@@33@{@{@ff@{@p@@@@\)@@H@\@\@\@33@@R@R@R@
=@R@@{@@
@@
@
@
@@z@(@H@(@z@ff@(@@@33@33@G@@@陚@=q@@G@@\@陚@@
@Q@\)@@@@
@
@@p@@@@z@z@ff@G@@@Q@\@Q@(@߮@  @p@@(@\@\)@@p@33@  @ff@{@{@@
@@p@߮@z@
=@
=@@  @@33@z@@z@z@@@{@33@33@@Q@@  @R@ff@R@\)@@@@@@@@\@(@@\@33@@@=q@@\)@Q@z@@p@
@
@Q@Q@@R@Q@
=@z@@
@
@@@z@G@G@@ff@@G@޸R@߮@  @ᙚ@ᙚ@33@@H@\@H@
@G@
@z@z@
@@ff@@ᙚ@@@H@
@(@
@@p@ff@@@  @  @
=@@@
=@p@@{@@陚@=q@=q@(@z@@@G@H@z@\@H@
@ff@H@33@33@G@@@33@33@@@@=q@@
@
@@z@@p@@33@@\)@@p@
@H@=q@@@@G@@@(@陚@
@
@\@G@\)@
=@\)@R@
=@@R@
@@@33@33@@\)@@  @\)@  @@R@@@p@Q@@{@
=@@@@33@\@H@33@@p@ff@R@ff@Q@G@@  @
=@\)@=q@{@G@H@33@@@@@(@@
=@AHA A   A QAA @(@@@\@G@@(@ff@@{@{@@=q@  @R@{@ff@@(@
@@33@
@\@陚@@33@(@@
@\@\@\@ff@@(@H@z@@(@(@@z@(@(@@H@(@ff@\)@(@(@
@@p@p@p@{@Q@z@R@G@@p@@@\)@  @@  @H@@@H@@@Q@H@H@@
@
@@  @\)@=q@z@\)A A A @A (A=qA{@A Q@R@@@@Q@@@G@@@=q@Q@=q@@@p@@@@@H@p@p@p@@G@R@@Q@{@@R@  @@H@@G@p@p@G@  @Q@G@  @@=q@@@
@@G@Q@G@@\@@33@
=@33@z@ff@ff@@@
@33@R@R@\)@G@33@ff@z@@@
A   A zAA{ARAHAzAA(ApA=qAAA33A zAQAAA(A(ApAAAHAA
ffA
ffA(AzAGA z@@G@@R@ff@p@@@@R@{@
=@ff@@\)@(@p@@{@R@  @Q@{@{@@@@p@(@@@(@(@z@(@@@z@@@{@R@ff@{@p@z@@  @33@\@z@R@@@@p@A AAA=qARAAAA
{A
\A
ffA
=qA  A
A=qA
A	pAA	pA	pA
=A
AQAA=qAffA33AGApAGA@@G@G@@@@ff@@@\)@@@@z@@@@R@z@@ff@GA A=qA A33Aff@@@z@z@@(@@@{@@@@
=@ff@
=@
@@\)@@@G@ff@
@z@Q@@@ff@=q@(@R@  @z@@@A AA\)AA AA @z@\)@z@@(@A AAA
AA	AAAQAGAA	GA	pAA\A(AA
RA
=AzA\)A (@
=AA33AAQA@@@
=@G@{@@
@@{@
@p@=q@@@@@@@33@R@R@@G@Q@H@@\@@@@p@z@
=@z@p@@@@
@ff@@33@@@\)@33@p@@
=@\@33A
ffAAA(@AQA{A A A AAARAA=qAA
A{@\)AAAGA33A	AA	pARApAA\AAAHAGAAAGA=qAA A=qA
=A\)AAA=q@{A@{A\AApA\A{ApAGA @33@@pA{ApAA A   A AAA AA zAGA A AA A QA QAA
=A\AA Q@33@ff@
=@@z@@@\)@(@{@ffA Q@@33@@ff@@G@z@G@p@z@{@@p@GA33AA A@R@@
=A=qAffA33A=qAA{A\)AHA  A
AAHA{A
=qAAA	A
A\@zAp@
=@@
@@Q@H@=q@@\@QA@
@QA zAAAAAAA33A   A{@R@RAAAAA(AA@ffA@\@ff@Q@@R@A   @=q@z@=q@@@=q@@@ff@  @33@@@R@z@Q@p@G@@Q@@@@@
=@z@
@@  @
=@@  @
=@@  @
@=q@33@p@
@(@(@\@@p@p@
@z@@=q@(@33@ff@ff@p@p@
@@(@
@(@z@{@@(@(@@@p@{@@
=@\)@Q@@@H@H@@
@@Q@
=@@
=@
=@z@{@z@@\@33@@G@@H@=q@@@@Q@@Q@@G@H@H@33@(@@@=q@@Q@ff@=q@33@p@@@H@Q@@@@R@@@ff@@p@p@@{@@@p@p@@@@p@@=q@H@=q@@=q@33@H@@@R@\)@  @ff@
=@  @@@
=@  @@=q@@\@@G@G@@@33@33@33@@(@ff@Q@@@=q@@@=q@@@=q@\@A\)AQ@A
=ARAzAAzA(AH@A (A zA @@Q@\)@@@H@=q@z@@33@
=@{@@\@z@@@@\)@H@@@@\@Q@\)@\)@R@@33@陚@@Q@{@ᙚ@ᙚ@G@@Q@ᙚ@@\)@\)@  @@@33@33@33@@ff@
@@  @
=@ff@{@@=q@
=@
@  @@{@Q@@@z@(@
@ᙚ@@@@=q@  @@
=@p@@R@@33@=q@G@@@
@@R@z@@ff@@33@H@z@@=q@@G@@  @
@p@@
@
@H@=q@H@=q@߮@ff@G@
=@Ϯ@=q@33@
=@׮@\)@Ӆ@ָR@Q@Ӆ@@=q@
@љ@@33@@p@ҏ\@Q@Q@Ϯ@(@@
@@p@ָR@Ӆ@
@H@ҏ\@p@ҏ\@33@Ϯ@  @ҏ\@
=@Q@{@H@˅@
@@
=@
=@˅@
@
=@У@G@@У@Q@ff@z@@ҏ\@@\@@\@\)@
=@\)@ff@  @@p@
=@@=q@@@@33@@@ᙚ@@ᙚ@(@\)@@
=@@@=q@ҏ\@У@H@Q@@Å@{@@{@@
@  @
=@33@p@@@@p@H@{@{@{@@@
=@@=q@H@(@  @Å@(@@z@@У@Ϯ@@ȣ@Q@ȣ@@=q@@H@Ǯ@33@=q@z@33@˅@  @  @z@{@@33@(@Ӆ@ҏ\@  @@@@{@@ff@
@p@(@p@R@R@@@\)@(@(@
@R@@  @(@@@@@@@@@ff@@G@@@  @@
@Q@(@{@@@H@Ӆ@  @  @ҏ\@33@Ӆ@p@
=@{@ָR@׮@أ@@  @׮@Q@Q@Q@@  @  @ff@@33@Ӆ@H@@z@@@33@H@@p@ָR@
=@
=@ff@\)@\)@\)@H@=q@{@
=@
=@p@Q@H@ۅ@@@\)@Q@z@@Q@33@
@@G@@Q@
@@߮@33@@@
=@\)@Q@33@
@@@@@@\)@=q@@p@
@@@p@@ff@@@H@33@z@(@(@Q@33@(@H@أ@\)@@׮@ڏ\@33@p@ff@@(@
@p@(@@@@ٙ@Q@أ@\)@أ@Q@أ@ָR@
=@Ӆ@ҏ\@  @
@G@ٙ@أ@ָR@ff@(@
@@@33@(@@@޸R@p@G@@@
=@陚@=q@@z@@R@@Q@@=q@@\@=q@H@(@z@\)@@z@ff@@ff@\@@G@{@陚@{@
=@@(@z@@z@\@Q@  @@@@@@@ᙚ@ᙚ@Q@G@G@Q@
=@߮@\)@  @@޸R@\)@ۅ@@@z@@@\)@(@@G@@ff@{@\)@
=@p@H@@ff@p@
=@@=q@33@p@أ@H@G@߮@@߮@ۅ@
@@H@
@@R@{@\)@@33@p@ff@@@z@{@@@H@\)A@\)A=qA{A
\AA  A=qA=qA
=A\)A
@\)@@@@p@陚@G@陚@@@ff@H@\@Q@  @@{@@ᙚ@ᙚ@
=@
@Q@z@@{@@{@z@{@33@˅@G@=q@p@@ff@Ӆ@У@ҏ\@У@  @ff@z@@θR@{@@z@33@
=@Ϯ@У@ҏ\@=q@z@\)@ʏ\@ə@\)@
@@ƸR@H@ڏ\@=q@p@{@
=@\)@@@H@H@@33@@G@ff@@@33@(@AAApA\)A\AAQA=qAffA@z@\@R@  @\)@ff@\@
@@G@ۅ@Ӆ@@G@\)@=q@{@ff@ʏ\@{@@H@˅@ff@У@Q@У@@@@θR@Q@  @=q@ҏ\@G@\)@  @{@\)@p@Ӆ@У@@@  @G@׮@p@׮@ָR@
=@ٙ@=q@ڏ\@ۅ@\)@{@@@У@@\)@
=@=q@@p@p@@@@@p@Q@\)@A   ARA
A{AQARA(A	pAAA\)A@@@\)@
@Q@{@Q@33@A  A@A @p@H@@\@@(@ۅ@޸R@\@(@ڏ\@p@@
@\)@(@Q@@@\@@G@{@@@(@ڏ\@@H@@ٙ@ָR@@\)@ҏ\@Q@(@H@H@G@=q@{@(@@@@{@=q@@@
@G@@33@ۅ@@
@z@
@z@z@p@
@=q@ff@  @R@Q@=q@H@z@  @ffA=q@A  A @  @ff@AAA
RA
=qA\ApARA\ApAGA33AQAQA @@33AzA   @=q@R@33@\@G@
@33@
=@
@
@p@z@
=@G@У@@ff@ff@޸R@H@@{@ָR@@@ff@
=@@33@@@{@@
@Ӆ@@z@@ڏ\@G@أ@@  @Q@{@@
@H@z@@33@
=@(@H@޸R@G@@@z@@@{@33ApApA\)AA(AzAAAHA{AA
{A	pA
=A
AAAQA33AA33AAA
=A\AApAAA(A Q@{A Q@@
=@\)@
=@@\@ff@z@p@z@ff@
@\)@˅@{@=q@ff@
@H@Ϯ@33@ʏ\@ʏ\@ʏ\@H@@@@  @ᙚ@@陚@\@  @
@p@z@@  @љ@G@@љ@ڏ\@33@ڏ\@
=@@p@љ@@
@  @@H@@@@ffA A\AA	A	pA
HAA
pAA
ApAffAAzAAGA A'A+33A
A
A{A/33A5GA0A2{A4A-pA
A
=A
AzAA
=qAffApA  @Q@G@p@G@ᙚ@\@@\)@љ@G@=q@
@У@(@@ƸR@  @R@\@
@p@
@@33@@=q@
@@{@\)@=q@ƸR@G@Å@Q@ff@R@@ٙ@@љ@z@ff@p@@{@θR@G@@Ӆ@
=@ҏ\@Q@(@޸R@Ϯ@p@@\A  AAA zAff@
=@\)@\@G@@@H@
@@@33@Q@@{@@AAAAQA @=qA\)AA@\)@@{@=q@p@\)@@\)@
@G@{@
=@
=@Ϯ@z@@\)@(@=q@θR@@@ƸR@ə@@ff@ff@@  @{@@  @@˅@@@ٙ@љ@{@@ff@ə@
=@\)@z@Å@33@(@@=q@p@@33@  @@@{@ə@ʏ\@  @
=@33@  @@33@@@@\)@z@@\)@@H@ə@@\@Å@Å@(@ff@@ȣ@33@@@33@@ff@@@
=@@{@@  @(@@G@Q@@θR@Q@Q@љ@\)@\)@@(@
=@
=@ȣ@\@=q@ff@\)@
=@  @@Q@{@
=@=q@@ff@@\)@Q@=q@@ff@@(@H@=q@@
=@@=q@@H@H@{@\@H@
=@@{@  @@@z@H@33@p@p@\@\@p@Q@
@@@Q@@33@\)@
=@@ҏ\@\)@У@θR@У@ff@H@=q@˅@Q@Ǯ@\)@˅@@(@љ@أ@=q@=q@(@ff@@  @@ƸR@\)@љ@{@׮@@@G@G@\)@33@@33@(@@G@ə@(@@  @  @
=@  @ə@˅@@=q@@ʏ\@@
=@ff@33@Å@G@@@@  @G@p@{@H@
=@R@@@R@R@p@\)@p@@@33@@33@@33@@=q@H@@@@  @{@@33@
@p@p@˅@ʏ\@\)@ff@ff@\)@Q@\)@
=@
=@
=@
@
@
@@
@\)@H@Q@\)@{@
@׮@أ@Ӆ@@
@Q@@G@z@G@ff@p@@Q@
@˅@У@@Ӆ@{@ff@p@@z@z@ȣ@(@33@@ȣ@=q@@p@33@H@@z@@@\@\@
=@R@G@=q@@@@{@Q@Å@@  @  @{@@ʏ\@˅@z@33@@z@@߮@@@@@=q@@  @ᙚ@{@
=@@@Ӆ@\)@θR@ڏ\@@ff@Q@@  @33@(@ָR@@Q@ٙ@ff@ᙚ@p@G@Q@߮@@
=@z@33@޸R@@=q@أ@@
=@G@Q@\)@{@=q@Ϯ@Ϯ@Ӆ@ff@p@p@ff@ə@Q@z@׮@  @
=@@@
@@
@˅@p@p@@p@
@=q@H@@ə@ʏ\@\)@z@H@p@H@Ӆ@  @G@Q@H@@33@{@@@Q@
=@Ϯ@\)@θR@Q@  @У@У@@(@{@G@=q@z@@
=@ff@
=@\)@߮@ᙚ@ᙚ@R@{@@  @@G@(@@p@@{@陚@@{@\@33@=q@G@z@Q@У@@p@׮@ٙ@أ@׮@@(@У@=q@@Ϯ@
=@љ@G@@H@θR@Q@θR@@
@
=@@@ARApA
A	GA33AzA(AAffAQAA33AAAHARARA  AAA=qA=qA=qA zA zA#
A!AA!A\)AA{AAffA=qAGAAHA33AAA33A  ARA(A	@
=A
HA
{A33AAAA\)@AHAGAAAzA   A\Aff@R@  @33@@
=@@z@A @\)@\@ff@@p@p@Q@
=@ff@@@
@
@@ff@أ@
=@(@=q@G@@33@33@@ָR@@\)@p@@
=@z@ڏ\@@Q@H@p@@G@ڏ\@@ff@˅@33@Ǯ@@p@p@R@R@@
@H@
@(@p@33@\)@p@
=@z@{@G@\)@\)@{@(@@@H@ȣ@Ϯ@p@Q@Q@  @G@У@׮@p@(@ff@Q@@R@陚@@=q@(@߮@z@=q@@z@\)@@R@G@
@z@@ۅ@  @\)@=q@
=@
@أ@z@ff@ff@{@ff@У@  @(@@p@׮@\)@(@
@أ@
@(@p@{@(@(@@{@@@@H@ٙ@  @@33@z@ҏ\@  @=q@33@\)@p@\)@\)@{@(@@޸R@޸R@z@33@Q@
=@
@أ@H@(@أ@{@ff@@׮@H@ۅ@H@
@@  @@=q@(@
@@z@߮@\)@
@Q@@H@ff@{@(@G@  @
=@ۅ@G@@@ff@33@ٙ@أ@@ۅ@(@߮@p@@z@=q@@@(@=q@p@=q@Ӆ@ҏ\@У@ҏ\@@љ@  @G@H@@z@@G@ҏ\@@љ@У@У@{@\)@p@z@33@ə@(@θR@@G@@@(@Ӆ@G@33@ff@{@ٙ@׮@ָR@ٙ@ڏ\@@
=@ҏ\@ҏ\@Q@ff@
@޸R@@@߮@@\)@  @G@\@=q@ᙚ@H@=q@@R@Q@陚@@\)@
=@@33@H@陚@
=@@@z@{@ff@Q@(@p@@љ@أ@{@G@Ӆ@@@  @=q@أ@@=q@Ϯ@\)@У@@љ@z@\)@@33@33@(@@@ff@@@ָR@ָR@@(@ff@ָR@ff@z@p@{@@{@z@H@Ӆ@ҏ\@
@33@ҏ\@33@љ@@@ҏ\@@љ@=q@@ڏ\@ۅ@߮@@@ff@R@  @陚@p@@@@z@@=q@G@z@@@ff@(@\@p@@G@ָR@@@@˅@Q@θR@љ@G@Q@ҏ\@  @@
=@ff@׮@33@@G@=q@@Q@
=@G@{@@
@@@G@Ϯ@θR@=q@z@p@z@@z@׮@
=@  @
=@ff@\)@@@@@ٙ@ڏ\@ٙ@G@ۅ@  @ڏ\@=q@
=@@ۅ@޸R@@
=@߮@H@\@  @  @z@@Q@@@{@  @H@@@
=@@33@33@=q@=q@
@  @@@陚@
=@R@Q@G@@H@=q@=q@@@G@\)@\@@(@@z@@=q@z@ff@@Q@ff@z@Q@@߮@p@@@p@
@׮@
@(@@\)@
=@
=@{@@z@{@(@@
@H@@
=@  @@G@
=@߮@@Q@{@  @@ᙚ@Q@@@{@ff@R@@@@@陚@=q@Q@@
=@H@  @33@@p@@@@@
=@33@@R@@@@@z@@Q@Q@@@@33@\)@
@@@z@33@
=@\)@33@ۅ@33@@@ۅ@ۅ@@=q@׮@أ@Q@z@(@33@z@
@@@p@Ӆ@ҏ\@z@׮@  @@\)@\)@ٙ@=q@أ@@ff@ָR@@{@Ӆ@33@ҏ\@33@@@p@Q@\)@@{@ָR@@H@
@
=@
=@߮@@ᙚ@@\)@ff@@@@H@H@(@
@@ff@\)@@33@
@z@@@@@\@(@@@@H@ff@  @Q@=q@p@@=q@{@@G@ڏ\@p@  @@\)@@Q@@׮@Ӆ@@H@33@
@z@(@@z@{@ҏ\@У@أ@\)@ff@У@@{@=q@G@\)@  @  @=q@ff@@Ӆ@H@\)@У@{@p@@ə@@
@@  @{@Q@  @p@ə@@@33@{@У@  @@@أ@  @  @{@@ff@߮@33@@陚@\)@R@G@@@G@\)@
@@@@
=@  @R@@@33@\@\)AAA  @z@(@=q@@@@z@@@@@@@ᙚ@@@z@@@@@@@{@p@׮@@@\@=q@@
@@@
=@@׮@ff@@Q@@@p@ff@
@ָR@׮@
@=q@z@ʏ\@Q@{@@z@߮@\)@
@
@@
@@\@  @@@
@@
AGA A{ApAAGA
A\)@R@\)A
=qAz@p@@=q@
=@@p@(@(AA(@ff@\)@@z@33A  @@@G@{@@@߮@\@H@\)@=q@
=@(@ٙ@{@@@33@@ڏ\@z@G@@@\)@Q@ᙚ@@@@R@  @@@z@أ@\)@  @z@@  @G@  @H@G@{@\)@G@У@@ҏ\@@@ff@
@Ӆ@
=@
@@
@@@\)@陚@Q@z@
=@@(@@A (@@pA zA\A
ffA
RA
ffA
=qA
=qA33A
A
pA=qA
A=qA\A\AA  @  @A
ff@
=@  @G@\)@
=@H@Q@(@\)@  @@ff@@p@H@\)@(@ff@@\@߮@
=@
@{@Q@׮@@33@\)@  @@33@@(@H@H@=q@@=q@߮@p@p@{@H@@p@ٙ@
=@=q@
=@ָR@H@
@@Ӆ@@ff@33@ff@ҏ\@@=q@ָR@\)@\)@Ǯ@Å@(@Ϯ@׮@
=@@G@@@@A   A=qA z@33@HAAA\)AffA
AzAAzA@p@p@@33@p@R@{@
=@ff@{@\@@޸R@{@@
@@H@33@׮@=q@{@أ@
=@׮@@љ@љ@G@(@@@@
@ff@У@\)@Ϯ@  @أ@ڏ\@
=@@@@ff@
=@ҏ\@θR@G@Å@@@@@\@{@\)@=q@@Q@=q@
@p@Ӆ@G@У@Q@G@H@޸R@33@  @޸R@R@33A A A(A33A  AA
AAGAAffAAQA33A AHAGAffA
HA(ARAAA=qARAHA@@G@p@33@@pA	pA{AffAQ@
=@{@Q@ff@@
@\)@޸R@@H@@@
=A=q@RAARAQApA   AAR@@G@\)@\)@Q@@
@@G@  @
=@\)@\)@@{@߮@Q@@Ӆ@@=q@@{@p@У@ҏ\@@\)@z@أ@@(@G@Ϯ@=q@ҏ\@أ@(AzA
AA
A  ApA\A\A\AAffA{AAAAAAGAApA
RA
A
RA
A
=A
ffAHARA@=q@=qApAA33@@=q@  @  @@@(@@@z@33@p@33@\)@p@H@G@33@G@\@p@
=@@љ@33@ff@  @  @@@
@H@
@
=@@@ָR@=q@Q@\@ҏ\@@ff@
=@H@\@ə@
@=q@߮@z@Q@z@z@@H@z@@H@H@@\)@@Q@
=@@  @@{@\)@=q@{@
=@@\@G@z@RApAGA=qA=qAA@@ff@HA
=A A z@@33@陚@
=@@(@@@@
=@@R@@\)@H@ff@G@Ӆ@
=@\@33@z@@@G@G@
@p@z@ff@H@@@{@ȣ@@@=q@H@Ϯ@z@
=@G@{@׮@
@33@љ@@=q@p@Q@@@ʏ\@p@@@@@@(@@
AAzA@@H@@G@@A
AAA@A
=AAQAzA
A\)A(A@(@@@@陚@p@G@ۅ@H@\@(@޸R@ۅ@ڏ\@Ӆ@  @(@@@{@ڏ\@G@Ӆ@@33@33@p@\@{@H@@Q@=q@H@أ@ָR@@  @\)@33@أ@@ff@(@ָR@
@(@@@
=@ff@Q@(@ʏ\@z@@p@(@Q@p@ə@=q@p@Ǯ@ff@@{@=q@љ@G@p@p@Q@Q@@@@ff@@R@@33@H@(@  @=q@
=@@@@@A QAffA
A=qAAA@\)A=q@@\)@=q@Q@陚@33@  @G@@޸R@@33@ᙚ@ff@׮@
=@33@׮@{@@ٙ@ҏ\@ڏ\@@@@G@@
=@ƸR@@p@
=@أ@\)@ᙚ@
=@޸R@@߮@ff@(@ڏ\@=q@@H@Q@ٙ@G@@  @  @@H@У@ۅ@@{@(@33@33@ٙ@Å@@z@ff@\@R@߮@
@@(@(@p@@ff@
=A  A(AAA
AA	GA
GAAAA33AAzA
=A{A\AA(AA=q@pA
RAA QA\)A{A
=@A A @@z@@(@@@
=@=q@
=@=q@أ@\@p@G@  @G@陚@33@33@@33@@@Q@33@\)@@  @ff@@@@Ӆ@Q@=q@˅@=q@z@ƸR@\)@@G@@˅@=q@(@@˅@@33@
@33@{@\)@\)@  @@G@33@
@@(@
@\)@RAA\AHAHAA	pA=qAA
AzA\)A=qA
RARA
RA	A{A
\AHAffA z@@33@Az@z@A	A
=qAAA	GA\)Aff@z@
=@
=A z@  @׮@@@
@@(@θR@@θR@{@@{@33@33@  @@z@G@\)@Ӆ@@@@Q@ڏ\@  @ff@p@ҏ\@Ϯ@Q@Q@  @@ҏ\@@θR@\)@ff@љ@(@@
@G@@ۅ@(A
A\)A\A @  @
=@@
=@A33AffA
\AAHA z@(@R@=q@
@\)@H@{@HA(Az@@@\)A{@޸R@@@=q@33@G@@ff@(@(@z@{@ff@߮@ȣ@љ@
@=q@Q@@ff@R@=q@@(@@(@G@=q@ʏ\@ۅ@Ϯ@Ӆ@H@33@@@@ᙚ@{@
@@@33@@=q@{@أ@@p@љ@=q@Ϯ@{@Å@˅@G@\@ff@@{ApAH@{AG@H@@G@ff@
@@R@@G@@=q@@@R@  @
@ff@ff@zA A(A=qAzAAA33@{@ffA z@=q@ff@
=AGA QA z@H@@\)@@@\)@@ff@@Q@@أ@ۅ@@=q@(@  @33@ff@ff@@ȣ@˅@Ϯ@@ʏ\@@{@ə@
@љ@(@H@  @  @  @{@Q@  @Å@
@ڏ\@R@@@@\)@p@Ǯ@@@Q@ٙ@H@{@  @@33@Q@  @
=@@ff@Q@ff@@
@(@@@@G@33A A@RAHAApAzA
pAGA=qA
=ARAHA{AAzARA33AA\)A@
=AffA A@@\@Q@R@
@\)@  @p@{@Q@(@ff@@ۅ@z@ָR@{@z@\)@@G@Ϯ@
@Q@{@@ᙚ@ff@z@@ff@߮@{@ff@߮@{@z@@=q@ڏ\@
@ۅ@ff@ҏ\@Ӆ@љ@@ff@G@(@=q@
=@(@  @(@=q@{@z@@Q@陚@(@(@@  @
@\)@@ffAA\A
AA\AAA
A
=AzA
pA
AA  AA=qA33A33A\A\)AA\)A\)AHAAp@\)A	GA
=A  @GAGA	AQA  ARAQ@
=A @=q@@{@@@=q@@陚@ff@@\)@33@{@(@\)@@@ff@H@Q@H@H@@@ᙚ@p@(@(@@@33@
@@陚@@@
=@@@@׮@
=@@(@ff@\@R@33@@@@RAA zA
AA	A
A
A
pAA=qA=qA\A (A=qA\A (A!A"=qA
A\AAAAAA
{A  AAAR@@@\@Q@A Q@@\@{@=q@G@@ff@
=@@@\)@@=q@z@AG@A\A@33A=qA (A
=@
@@z@{@
@33@@{@  @z@@Q@@@=q@(@33@@p@ff@@@@(@G@@@=q@(@
@
@H@  @Q@@=q@
A AzA	GA	AA\)@A A QA@ff@RA\)A AA   A@33@HAAGA=q@\@@@@(@@H@@z@(@@  @@ff@@Q@
=@p@R@  @z@@޸R@@ָR@p@  @@@
=@(@ff@
@p@@@أ@
@  @@ָR@(@=q@ff@@\@{@
@G@ff@@=q@@33@G@
@33@G@=q@@@ȣ@\)@Q@Å@  @ff@G@ҏ\@33@p@p@ff@\@R@@  @R@
@\AG@=q@\)AA	A
HA  A  AA
GA  A33ARAQAA
AR@@@H@Q@=qA@G@@\)@ۅ@z@@z@R@@ƸR@@ۅ@ff@33@@@@޸R@
=@@@H@G@˅@@p@=q@@У@@{@@\)@Q@@  @R@\@ȣ@(@ff@@
=@\)@z@
=@  @  @@
@(@Q@33@@p@ᙚ@ָR@@@@@G@
=@H@A\@@ff@A\)AA	AA\)AA33AA   A   A  A
RAGA\)AzA{A
A
@zA\A(A\)A{A Ap@
=A (@=q@(@ff@H@\)@ff@ָR@@ff@p@@ٙ@  @=q@@p@
@Q@
@Ӆ@33@θR@@\@@Q@߮@߮@z@@
@  @ff@˅@p@@p@{@  @\@G@Ǯ@@33@@z@  @@{@ff@@θR@@
=@z@@G@AAQA@RApApAHAffA  ARAQA(A	A	AAffA(A\AAAQAGAA{AAAAffA=qAAA(A=qAA{A33A  A\AAAA AA	AA@  A{@RA zAA
{AAA
A\A33@@@
=@  @陚@G@(@@\@pAp@
=@\)@@  @@
=@z@
@
=@@׮@\)@(@z@
@
=@
=@p@H@@ָR@Ǯ@@\)@G@Å@ȣ@p@@ff@H@  @(@ff@R@33@p@Q@Q@
@@=q@ff@ff@  A=q@@@@A (@@G@@ڏ\@(@  @\@ff@ۅ@
=@θR@=q@
=@z@ٙ@\@G@\)@@=q@33@@(@z@
@  @G@p@@@\@G@33@(@33@p@޸R@@z@@θR@Ϯ@@(@Q@Ǯ@H@@љ@Ӆ@ff@@@@ָR@ff@ff@@
=@ff@@\)@@z@@Q@
@Å@ff@{@@@
@
@ff@Q@
@ۅ@޸R@@׮@{@أ@  @ff@p@\@ٙ@ff@  @\@أ@=q@ff@@\)@p@@\)@
=@޸R@G@߮@@ۅ@{@@ff@G@=q@(@z@z@@
=@G@@=q@z@H@@=q@z@ڏ\@G@@Q@@@G@(@=q@@G@H@H@
=@@p@=q@
@z@(@@
=@H@{@{@
=@@(@\)@=q@  @ٙ@z@ff@=q@@@Q@{@G@z@\)@У@@z@@z@
=@@\)@=q@  @ָR@@{@
@߮@@H@@߮@z@  @ڏ\@z@
=@@@@G@{@޸R@Ӆ@@
=@أ@(@ᙚ@z@Q@ᙚ@  @@@z@@߮@@  @@ff@ҏ\@{@˅@  @@33@\@ff@p@p@@=q@
@@G@\)@@G@ᙚ@\@ᙚ@ƸR@@ٙ@
=@{@@ٙ@ff@=q@ff@@{@@H@z@z@@ڏ\@ٙ@G@Q@=q@ʏ\@(@p@p@{@@\@أ@ff@z@˅@ҏ\@33@33@޸R@@ᙚ@ff@{@@@ᙚ@Q@G@z@33@G@\@陚@@\)@ff@  @@{@z@@p@@ᙚ@G@ff@@ۅ@(@
@@
=@ڏ\@ff@ff@(@@@  @@  @
@@ff@@33@Å@p@z@ff@z@p@G@z@p@(@ʏ\@Q@z@@{@Q@Ǯ@Ǯ@ə@ff@@R@p@33@@=q@p@ƸR@ə@@\)@@z@R@H@@Q@\)@{@=q@@@
@{@\)@33@
=@  @z@(@G@
=@Ϯ@θR@
=@z@z@G@@@H@  @ƸR@33@p@
@\@Q@@H@
@
=@z@@{@\@G@(@@G@\@@ƸR@z@Ǯ@\)@Q@  @@(@@\)@
@θR@33@Q@ff@@=q@@G@G@
=@@H@Å@  @ff@\)@  @@
@
=@  @33@ff@  @@G@  @p@G@Ӆ@@Ǯ@@p@@p@{@
=@@\)@Q@(@p@@ۅ@G@ָR@Q@ٙ@ff@ff@(@p@ff@=q@Q@  @  @\@p@z@(@\@@33@@p@(@Q@@=q@@@  @
=@޸R@@@@ٙ@Q@33@@Q@
=@z@(@33@߮@߮@(@  @z@θR@@\)@G@ۅ@=q@{@\)@أ@{@R@θR@Ϯ@  @=q@ff@أ@ff@\)@˅@p@@ff@˅@@@H@@@  @
=@θR@  @Q@(@Q@Ӆ@љ@Q@(@=q@
@Ǯ@(@@أ@(@  @=q@ƸR@@@=q@˅@@p@G@\)@{@أ@ڏ\@G@
=@H@33@ff@@{@G@@p@@
@
=@ff@{@@@G@ff@  @@@33@  @
@ٙ@@@@@p@\)@Ӆ@@ƸR@ff@Q@z@@@  @=q@@
=@\)@Q@H@Q@(@{@(@\)@\@@@@{@ff@{@@(@@33@p@@@@@G@  @@@=q@@@@ff@@{@=q@\)@R@@޸R@@
@ff@z@p@z@@33@
@
=@\)@
=@
=@
@@
=@@H@p@\)@\)@@\)@@@@{@
@Q@
=@@{@\)@@z@@H@ȣ@@ƸR@
@
@
@{@(@p@=q@@ə@\)@@@У@Q@33@Q@  @θR@@33@@33@{@@˅@ƸR@θR@@p@
@@@@z@@H@
=@\@@G@{@\)@
@H@Q@@@@@@@
@
=@H@љ@@
=@p@@ᙚ@=q@@  @@׮@
@
@ff@@
=@@ҏ\@33@H@{@@Q@  @@{@@{@@ff@33@@
=@ָR@ҏ\@@33@{@@H@@@  @
=@ָR@(@@
=@@
=@33@H@ҏ\@(@(@\)@θR@\)@R@@Q@G@(@Q@=q@\)@
@33@Q@\@@Q@=q@z@\@G@@
@Q@Ǯ@R@p@ȣ@@Ǯ@@@\)@@@p@\)@
=@@ƸR@\)@ff@ƸR@Q@G@@=q@أ@  @@z@=q@H@@ָR@\)@=q@p@33@Ϯ@@\)@@p@@=q@=q@أ@p@
@@@\)@θR@@ָR@z@ff@\)@Q@p@@@p@=q@ʏ\@@H@33@@ƸR@G@  @{@@@Q@33@
@H@ٙ@ۅ@\)@@(@  @أ@@  @33@@Ӆ@p@\)@p@˅@@z@@@@
@p@
@
=@@
=@{@Ǯ@@  @Ǯ@ff@Ϯ@H@{@Å@Q@  @@=q@@Ӆ@@Ӆ@@z@  @љ@
@H@
@ۅ@ָR@׮@@@@H@@z@陚@z@H@@
@@H@ff@  @
@{@@  @\)@@љ@@@H@{@˅@
@{@@  @@{@أ@ƸR@Ӆ@ff@ڏ\@
@ff@H@ۅ@ۅ@ff@  @أ@{@@G@H@@أ@{@p@@أ@H@\)@  @Ϯ@{@
=@Ϯ@
=@У@z@@@θR@Ӆ@ff@Q@ۅ@\)@@{@p@@  A A QAp@R@@@{@@@
@pA
AA  AzAAA\)AHARA(A
=AAAHA@R@@@@
=@
=@=q@@\@Q@  @ff@\)@Q@R@ff@G@H@p@@@
=@@=q@@\@@  @@@@陚@@@\@z@H@\@z@G@(@
@@G@H@ff@{@=q@ᙚ@ff@ۅ@33@G@@׮@Q@Ӆ@G@33@{@@@\)@
=@{@޸R@@Q@@Q@߮@ff@@33@p@R@@@=q@{@@@ff@ff@  @z@@
@{@@\)@Q@G@G@ᙚ@z@@=q@=q@@
=@ff@@@H@@@33@H@p@p@(@@z@R@@@H@H@\)@@R@(@G@33@ff@\)@(@
=@\@@@@@\)@
=@{@{@@{@ff@{@@{@33@H@@@\)@\)@@33@@@G@H@@@@(@@@@p@{@@@\@  @R@@  @\)@@@@
=@\@G@  @@@@=q@@@33@=q@R@=q@z@@@=q@@\@ff@R@ff@Q@@G@G@  @  @p@@\@=q@G@R@@@Q@@@@H@=q@33@  @@@\@\@@@@H@G@߮@33@33@=q@{@z@@@{@{@ff@{@H@\)@p@\)@H@@
=@@ȣ@@ƸR@=q@Ϯ@33@ָR@=q@z@33@Q@H@\@
@Q@G@
@=q@z@=q@=q@@R@\)@\)@@@@@@@@@  @ff@H@@R@\@33@=q@=q@\)@@H@@@@33@\@@Q@@@G@  @@G@G@  @
=@@ff@{@Q@@Q@G@@R@z@  @@
@@R@
@ff@(@z@\)@޸R@޸R@33@޸R@z@@  @@(@
=@  @@p@
@
@{@\)@@  @@ff@(@ff@\)@  @\@\)@  @(@@ᙚ@  @@H@
@
=@@
@{@@p@z@\@z@(@z@
@@@@ff@p@{@{@p@@z@@\)A   @{@@ff@@\)@\@=q@@z@R@@z@@ff@p@@{@@ff@@  @@@=q@(@@ff@33@@@@  @G@  @
=@R@Q@@@\)@@@
@33@\@@
@=q@=q@
@(@R@@@z@@
@@\@@@@p@ff@RA A zAAAAARApAHA@A(A\)AzA(AzAA
A
AffA=qA
A\)ApA
A\)A=qA\@AA
=AHAQAHAGAAAzA  AGA@A (@@(@@@p@{@=q@@(@ff@@G@G@@@=q@@R@\)A zA A (A   A   @{@ff@R@{A QAGA AGAAAAHA\A\)A33A  ApA(AAA\A
=AzA
A
AAA=qAAA33AzAzA\A zA!AA QAA{AARAA\)AHA
AAHAA{AGA
A(A33A33A{A  ARA{A{ApAffA{AAA\AGAAGAGA(A
AAQAHA33AAAzAA\)AAQAAAHAA
=AHAAzAA
A\ApAA
AGAA\)AA\A  AAAQAA(AHAA
A\AAHA33AA\)A  AAAzA(A33A
A
GA
GA(A  A\)A\)A
{AAQA(A\)AA\AAAA
A	A
=A
=ARAA
A
A=qA\A
AAA
{A=qA
HA{A=qA\)AQA=qA(A
AARA	GAA
=A	A	A
HA
AA
AA{A	GAAA\)A	A
=qA
=qAAA33A
ffAA\)AHAA  A
AA
=A\AHAHAAAGAQAAQAQA  AQA
A{A{A @
=A A @R@(@@=q@RAA33AffA Q@zA (@\)@ApAA(A33AffA{AGA{A{A A\ARA33AHAHA A @@
=@@@z@@@  @Q@\@G@@@pA (AAA Q@H@ff@@ff@
=@\@
=@@@=q@(@@@@z@@(@H@33@@G@@H@=q@@@
=@@33@{@\)@{@p@ff@R@@=q@@p@@@=q@H@@Q@Q@@\@@@(@@z@  @@z@(@H@z@ff@  @@޸R@33@@p@@{@=q@
=@Q@@
=@z@@@Q@R@ff@@@@  @
=@@(@H@(@H@G@{@(@@@@
=@޸R@\)@\@\@@@=q@Q@p@G@\)@z@p@  @@z@
=@{@ff@@z@
@\@
@\)@G@G@
=@@@p@{@@@@{@33@(@
@ᙚ@(@R@(@p@@Q@@ff@{@{@{@@@\)@{@\)@33@@
=AA
A
=qA  A
A
AzAAA  AAA
AA(QA+
=A-pA+\)A,QA,A-A-A.{A.\A/
=A-pA.=qA0  A1A2{A0A/
A0A0zA,(A,A+\)A+A'A(A$(A$QA AA
A!AAQA	A
A\)A33AAAQA33AA  A
=AA
{AA\)A\AQ@z@(@@@
@@(@@R@AA\A33A\@@\)@ff@@=qAA A{AAzAAAAAHARA A@(@@AA
{AGA zA@@p@@ffAffA AHA@Q@@(A A   AA @p@@@p@@@A ARA(AAAHAAAA\)ARApA33A{AA A @\)@(@@
@=q@R@Q@
=@@ff@\@33@z@@33@z@@@ffApAAAA
@@H@p@GA
=ARA
ffA
A(AzA33AAAGARA
ffAQAQAffAp@@{@@@A (A QA   A (A (A (A   A{A AAGAAA QA QAA
A\)A  ARAAp@33@@@33ApA @HA(AAp@G@@@ff@
@ff@@@p@AA(A@R@陚@ff@33@p@ff@G@@  @
=@{@@@Q@@@@@Q@=q@A A=qAGA QA{@{@
A (@R@
=@@(@
=@ffA A A A (A
AA(AHAA\)A(AAA @AffA@@RA=qA\A Q@{@p@@z@@(AHAffAzA(A\)A\A AG@
=@@G@  @  @=q@@Q@@33@G@Q@@@z@{@@p@=q@
=@@z@@@ff@@ff@@H@G@H@@\@Q@G@@@@33@@G@@33@\)@(@@@@A A @@\@  @@@@33@
@A (@R@Q@{A (@RA (@
=A @\)@\)@33@  @  A A@@
=AAA=qA@AA A QA (A   @R@A z@
=@@ff@
@H@=q@Q@@@Q@@@\@@@p@
=@@
=@@@  @
@z@p@@{@ff@
@H@G@@z@@{@\@@H@33@G@@@(@\@33@@@=q@33@\@G@@p@@
=@ff@\@R@\)@33@33@@@(@@@@(@@  @ff@\)@@@R@G@\@@@
=@p@{@Q@  @@R@ff@=q@Q@
=@H@@R@@@@@z@{@
=@G@ff@@@Q@@G@=q@@
=@ff@R@(@p@\@G@33@z@33@Q@@@H@@33@@@@@\)@  @p@z@@@@\)@@@@z@(@z@(@@@@H@\@33B
=BB
=BB)BBBQBϮBW
BzBνqB(BaHB\)B)BД{BυBΨB\BͣB8RB̀ BΙB)BaHB33Bπ BffBGBBB(B  BΨB̀ BkB
=B
=Bɳ3BɣBzBBBBȏ\B(BGBƏ\Bƀ BBBB33B(BkB
BHBRBBpBBBÙB¨B¸RB#BW
BĞBŔ{BŸRBzB33BBB{BBaHB\BGBBaHBBkBzBB
=BǣB.BȽqBBfBaHBɊ=Bǔ{BpBQB̀ Bͳ3BkBkB
BЏ\BW
BffBǮBBͅBBB̽qB8RB{BˣBBˣBkB̨B
=BBнqB͞BuBkB
B
=B\)BȞBƞBBĊ=BB=qBʨBGB
=BBBQBBBęBkB)Bǀ BB.BBBB.BB3BBfB#B{BBBǮB\B#BzB  B B\)B³3B
BffBkBRB=Bĳ3BaHB\)BGBBBBpB
=B\BǮBB8RBɣB˔{B(BBBϸRBнqBЊ=BўBuBLBzBոRBԨBBBǮBGBW
BѽqBBBԸRBBHBӞBB\)B(BҮBҳ3BkBB8RB(Bӳ3BBGBBW
BBkBB=qBkB8RBǏ\B͞BaHB=qBʏ\B8RBŨBkB{BʅB\BBǮBɅBBB
=BBýqBB=qBuBB\B£BRBBBW
B33BBzBzBuBĮB
=B
BffB\)B(BBȽqBȸRBɏ\B\)BQBBHB)BBϮBfBBBҞBәBaHB֣B=qBמBzBQBuB8RBGBuBǮBיBGBBיBBBǮB(B\BpBQBBB\Bڔ{BBLBأB؏\BB׽qB{BkBfB
B(BڸRB
=B  BB  BBGB.BգBԅB=qB)BpBѳ3BaHBҸRBLBQBLBҮBHB33BLBzB{BHBBBBQBHBffBuB̊=BkB)BBǮB
BԨBB#BffB.BǮB#BϏ\B
=BBB#BpBffBǮBzB
=BGBQBBHBBBBؔ{BB8RBB
=BHBpBQB߸RBǮBܳ3BBHBW
B33BkBڅB33Bڀ BpBB۔{BBٳ3B  B{BBHBخBHBϮBzB8RB=qBGBuB  B
=BBϣB  B\)B)BffBΔ{B(BW
BpB)BW
BʨBB.ḄBB
=BB  B̅B)BB
=BBffBɔ{Bǔ{BɣB  Bʀ B˅BB̔{B#BǮBB͸RBHBҙBΔ{B˞BB=qB{BffBkB
=BBW
BfBәB.B.BuBBB\)BB۽qBBݸRB
=B33BB.B{B{BQBHB\B\BGB\B(BGB{B(B\)BBaHB  B܊=BGBfBQB(BW
BW
B8RBffBBBkBHBGBfBuBB\)BB{BzBգBW
BLBҽqBBԅBB҅B
BB
=BfB(BB  BQBzBfBBkBaHBB=qBճ3B\)BGB\B\)BkBBQB؊=BBڨBB.BW
BQBܨBB=qB\)B(B33B.B33B{B#B33BمBBBۀ BffBր BkBaHBܙBǮBܸRBܔ{B  BpBܞBBzB
=B\)BBBHB  B
BݨBzBBBъ=BuBѨBHB)B
B
=B#BBpBzB  Bӏ\B\BBBBϸRBB33B͞BǮBuB=qḄBB̸RBB̞B\BB(B˽qB˙BǮBǔ{BșBQBzBpBBGBBBB)BƸRBuB˙BǊ=BBÀ B  BHBzBƮBBBBuB  B{BBuBzBaHBB
B̙BGB\B\Bϔ{BuB\)BffBͽqB̀ BǮB(BBB  B\)BLB8RBW
BffB8RBB  BB\B
=BkBҨBBBBBpBuB=qBBBǮB=qB̀ B\)BQBB˞BBB8RBaHB\)BɊ=BQB#BuB=qBɔ{B)BW
BuBzBBɅBɊ=BHB=qBBuB\)BB.Bó3BBBW
BBBzBBkB)BəBzBuBȊ=Bǳ3BB8RBQBȀ BBǮBʀ BʨBBW
Bʊ=BBfBffBɊ=BaHB\B\)B{BHBLB(Bͳ3BaHB\B
BkBBW
BBLBBBB̅BB{BB.BД{Bѳ3BЀ BB̸RḄḄBˏ\BBffBɸRBB8RBBȞBpBȊ=BzBkB\B{BǮBaHB\)Bǳ3BBǞBGBQBƸRBQBB=qB)BBBLBffBBfBB
B)BB®BBqB B BaHB¸RBQB=qBzBBB.BBffB)BBǔ{BB(B\BșBȸRBuBɊ=BəB  BaHBʏ\B\BaHB˳3B\BB̅B̊=BBBBLBB=qB\)BffB  BB.BBBΊ=B.BBkBB8RB)BʞBGBfB{B=qB  B=qBHBB\)BƏ\Bĳ3B\BpB(B)BGBƀ BƞBĸRBHBBĨBĨBBď\BBpBų3BzB\Bǳ3BffBBW
BGB#BǊ=BBŀ B.BǸRBW
BɊ=BƳ3BB.BLBpB\BB(B\)B(B#BǮB8RBBQBɏ\BəBʸRB{BB\)BfB(B8RB̙B(B̀ BQB.BuBϮBπ BffBπ B
BB=qBzB\)B  BѨBҔ{B#BuB)BzBB8RBЊ=B  BB(Bγ3Bϔ{Bӊ=BHB
B  BGB͸RB.B
B͞BB\BBaHBB33BB̏\B\B
=BLBBkB)BzBffBɳ3BȮBǞBȣBfBBǮB)B
BpBaHB{BGB=qBzBȣBǅBȣBaHBBB33BǮB
=BaHBfB=qB\BB˸RBθRB
BGBBffB͙BLB
BθRBΨBϙBB\BBQBңBҨBҨBǮB  BӽqB8RBBLBfBB\)Bۏ\BڸRBBָRB\)B\)BzBϮBfBBBBBҳ3BBӀ BfBңBBffBBЏ\B
=BϣBBϳ3BkBBuBǮB\BBƊ=BuBLBB.BϣBBB)BBBB#B
=Bǳ3B)BkB  BBŔ{BuBzBșBBBB{B33B˙B=qB)BHBBHBaHBBQBBkBB#B{BLB  BffBBBB#BνqBϮBkB8RB8RBB҅B\B
BؙBBaHB  B#B\B33B\BaHBffB
BHBuBBBB\BBaHBHBkBոRBGBaHBBBzBBpBQB\BBB
B
BaHB8RB#B
BffB#BuBHBLBBB.B\BҀ BӀ BB#BўB\)BљBҞB
=BGB.B8RBQB.BϙBəB{BșB
=B
=BfBkBpBBBBҨB  BzBB8RB.BۅB݀ B{B8RBǮBܽqB\BffB۳3BQBfBBB؅BW
B(BǮBzB\)BBڙBLB=qBfBpBB
=BzBBB.B߽qB
B  BfBHBW
BkBkB(BkB
=B߸RB\BkBޔ{B܏\B(Bӏ\BB)BΏ\B͊=BBϊ=BBLBGBңBB33BffBB܏\BBffBkBǮBя\B#BfBШB͊=BBfBBBʳ3BzBBGBBBB  BǮBЙBzBkBfBӀ BGB׽qBW
B׮BخBBB\)B\)BQBBBօBkBB֙B\)B֣BGBkBBaHB{BǮB  B{B#B#BߣBHBBBB(B=B(BߣB=qBkB33B=BBBB#B  B
BܽqBBQBkB=qBpB#B(BzBBB{BBBBٞB=qBـ BٮB(BBfB8RBBkBԨBBр BB΀ BB(BfBBBȞBW
B(B)BpB\)B33Bг3BBBHB{B˸RBBȅBBBBԀ BGBمB؅BHBB#BݮB؞BuB֞BBuBBBBBHBߔ{BaHB\BB{BB(B.BB=qBBB B
B.BW
BBGB#BkBBǮBBBBB\)BBzBLBQB)BpB{BfBuBB
=BԅBє{BGB)BfBϸRBkBBЊ=BLBǮBϸRB{BBW
BpBր BBBӳ3BfB\BǮBҸRBB
Bԏ\BpBB33BBҀ BBffBB8RBBW
B8RBQBBQBzBHBHBqBBffB߮BuB)BݮB(BB\B=qB޳3BpB8RBzBBQB#BBB.BBffB#BBqB\BBBBkB
B BBB
=B잸BBpBBGB\BǮBBBBQBB\B)BBB)BݽqBٽqBڙB  BffBaHBBLBfB
=BѣBuBӅBB33BؙBpBԙBW
B(BBӳ3B\B33B\)B33B#B33B8RBɮBBB˳3B˳3B33BǮBٽqBuBǮB\)Bճ3BkBB{B(BBBB
BB3B=BBGB3BuBLC)CC
B{CT{CQCuC+CO\C	C&fC+B3BkBffCCnC
C
J=CCHC  BBBǮB.B3B\B8RBaHBB.BB.B홚BGBB\)B3BuB#BaHB\B\B
=BBBffBRB{Bڊ=B8RBܙBBLBBBBBBBBfBzB.BBB(B\)BLBӮBzB\BW
B33BBBGBڽqBkBaHB=qBҸRBuBaHB(B{B)BQBBB\BaHBBB33B\B{B)BB B{B B33B  B8RBBBB3BB(BB
B3B{B3BaHBBBBzBBHBBaHBBBꙚB33BBBB8RBuBB(BBfB噚BڙBBB܀ BۮBLBHBBBaHBΏ\B)B
Bҏ\BkBpBBW
BBBffBffBBB)BaHBBpBãBBģBBfBQBBfBĔ{BkBȅB  Bŀ BBLB(B  BBB(BBŅBģBBkBBBHBǮB
=BaHBBBGBB£B33BBBB BBuB#BÊ=BÔ{BHB)B BHBBGBW
B8RB)BHB.BBB\)BHBkBBBpBQBfB#B{B{BBW
BQBfBB.BQBqBB(BBzB{B\BBB
=BBB)BBB  B)B8RB\BBB\)B.BBfBBQBB.B#BffBuBpBRBfB{BffB  BBǮBQBBHB=qBLB=qBBHBQB8RB33B)BǮBB3B.BRBB
B{BBB BBBzBBBffBfBB3BaHBGBBLBQBpB\B33BǮB BBkBQBkBB#B\BBǮBBǮB{BBzB{B
B{B
=B
B{B=BffBB33BBfB=B{B3BǮB)BuB3BHBRBuBRBǮB(BB33B=qBBBBBBBBBfBW
B33BuBpBpBzB33BkB(BBkB  BffBQBB8RBãBzBBB\)BęBBBď\BBãBGBffB33BQB)BB=qB
=Bƀ BBB(BB\)B.B  Bó3BĮBB.BǙB.B33BHBuBW
BaHBBB  BuB\)BpB3BBfBW
BHB
=B.B\B{BBBBLBBLB
B
BBLBLB=qBBqBqBBBzBfBBBBLBǮB\BHBW
BQB(BpBBqBffB8RBLBBģBĮBpBuBǙBBƮB8RB8RBƙBkBBLBɮBQBBɏ\BQB)B(BBBBBȳ3BLBW
BffBǮBBfBB33B3B
BqB\)BBǮBBB\BBpBfB BB#B#BkBkB=B3B B3BBHBǮBaHBBffBGB  B(BqB=qBBffBBB{BBBaHBpB{B  B33B.BGBBB3BBHBpBB\)BBBffB{BBGB33BB{BuBB
=BfBHBãB
=BĀ BĞB#BĀ BÏ\B\)BBŞB8RBBW
B.BBBʽqBʸRB
=BB{B\)B\)BGB͏\B̅BʮBW
BBHBBBBǙBB
BBkBpB{B#B\BQBW
B  BBBBRBBBBBB=B\)BQB{B.B BBffB\)BBBB(BfBfBBzBB=qBBB B\B3BBB=BHBfB
=BaHBGBzB#B)B
B33BBBGBBBîB{BĨBŊ=B
B.BBBBkB(B̸RBǞB33BuBBB33B#B(BHBǮBBʊ=B33B)B̮B˸RB˳3BəBȅBB  B)BȮBGBW
BGBkBkBBţBď\Bŏ\BęB#B)BBBB B.BkBB\B
=B=BqB B  B
BB{B  BGB  BffBpBqBBBQBB)BQBB3BGB\)B\BBBpBǮBQBB  B33B\)BǮBLBfBLBBǮBȞBęBzB\)BzB{BB\)B\)BBBGBffBBBBpBǮBB\)B
=B
BQBʳ3BQBB)B#BɮB˸RB  BBGBBQBʏ\BkBffBkBHBŞBBBèBÞB B BB#BBGBBBfBzBBB=B
B.BBBffB=BzBBaHB
B#B{BBB\BW
BQBkB(BBBHBzBaHBBB
=BGBB{BBQBuBB\BGBGB£BBBýqB)BkBó3BBÏ\BĊ=BLBǮBpB̞B)BBͣB33B
=B̀ BB̮BuBkBB˞BBǮBȸRBHBɮB(BBʸRBaHB˽qB{BfBuB\)BȔ{BBɽqB{BȞB33BǙBQBkBB
B33BpBBzBaHBGBRBW
B#B
=B
=B BGBBBBBkB8RB{BBBuB#B\)BpB3BHBBBaHBW
B{BBBǮBQBBB  BBBB=BǮBBW
BBBŽqBƙBų3BaHBǀ BǞBǮB33BQBǞBǔ{Bǀ BHB{B33BɽqBW
BpBB\BkBBɽqBŞBǅBBBʞBfBȳ3BɸRBW
BBɏ\Bɏ\B#BBkB{BBuBȔ{BBQBW
BŅBaHBfBW
Bŏ\BB.BBîBÔ{B\)BB#B)BfBpBB\)BLBaHBÅBǮBBǮBaHBBLB\BBBpB=BBB#B
=B)BRB=BLBzBĔ{BĀ BB  BB
=B\BBB BBBGBQBBB(Bĳ3BB=qB  BBBŮBǮBǔ{BƮB\)BƽqBzB33BBHB#Bȏ\BW
BBHBȏ\B#BBBǨBBǔ{BǞBǸRBQBǮB\BB.BƣBŅBģBŊ=BƔ{BBų3BLBŔ{Bŀ B#BąBQB\BBW
BǮBGBĊ=B\B.BBuB¸RBfBǮB{BB  B BQB3BBBB=BB3B B®BBGBBQBGBBpB\)BBBƸRBBBŮBBBaHBGBȳ3Bɳ3BW
Bɳ3BW
BB\)B
BGB̔{B  B  BBBfBBB˔{BfB  B\)B\)B΀ B̞B̸RBQBHBuB̳3BǮB  BW
B.BLB˅B
BɮBˣBBˮBBʽqBHBQBBfB=qBffBqB\)B\)B)BGB
=BkB33B.Bŀ BpBǔ{BBpBǞBǙBfB
B  BȣBȮBȀ B#BfB(BBfB  BBȽqBǽqBffBB#BʙBQB(B8RBaHB(BkB.BHBɣBʀ BkBB̔{BB8RB(B{BBfBB  B.BBѽqBkB8RBffBУBLBQB\)BBW
BBB\BkB
=B\B(BaHBЙB)B\)B)B\BGB33B33B\B
=BpB)B(B{B#B
=BaHB\BBBͅBW
B#B  Bʔ{BǮB˳3B˸RB\BǮB#BB=qB{BBɣB.B#Bɀ B̞B\BǮBǮBǮB#Bͳ3BGBLBW
BŔ{B\B=qBĊ=B#BQBĳ3BBBBBəBBB.BʸRB(B)BQB.Bˏ\BǮB˔{BkB˳3BǮBʞBB̽qBBBB̙BuBLB̔{B̀ BBQBBffB=qB33BBBBB.BLBLBpBaHB͸RBΏ\BkBBBB8RBBGBɔ{B(BʨB  Bɀ B=qBuBɊ=BȸRBɊ=B\BB=qBGBBffBʅBʏ\Bʔ{BpB#BȸRBBǔ{BB  B.BQBBB(B\)B\)BƙBƳ3BaHBBHB8RBHBLBǮBzB8RB\BzBȣBffBBffB\BBaHBBBʙBʞB\BBBaHB\BaHBBBHB̮B\BLB͸RB͔{BͽqBB̀ B͙BBkB33B˞BLB8RBϽqBϏ\B͔{B.BLBBͨB̀ BW
BBB˳3B8RB\BHBffBHB˙BɅB˔{BB)BaHBpBBpB\)B(B=qBBHBʳ3BɸRBffBBzBǮBBǀ B\B#BkBəBB
BBBB
=BȸRB)BɮBaHBBɊ=BɣB  BffBW
BʅBʨBʨBBˏ\BBuB̏\BB  BͨBBͣBͳ3BBB  BBB#B
=BkBBaHBzBўB
=BB\)Bӳ3BaHB.BB#BB
BљBB{B#BzBϨB΀ BfBQBpB8RBЏ\BffBͨBB  BΊ=BνqB\BBBBuBHBBBW
BHBBǮB.BʸRBBW
BuBɽqB
BʮBʨB\)BkBɣBfBGB#BB33B
=BǨBǞBB33B#B33BBBfB{BɸRBGBǮB#BpBǮBkB(B̨B̸RBB#B#B8RBBҮBffBԞB\BzB
Bڳ3B
BaHB(B#B3B33BkBQB3BffBRBBzB3BuB瞸BB3B(B\B33B=qBHBRBݏ\BB#B(BBBB)BBڔ{BpB\)BڮB޳3BB۽qBǮB٨BBBB  BBpBLBQB.BǮBB\B̽qBΏ\BΏ\BυB.BBBBffB(Bʳ3BBffBB=qBpBW
BB
BBffBʅBB
B͸RBpBfBΞB{B=qB8RBpB
=BBuBB
=Bݳ3B߳3BpBLBBLBBuBB
=B
=B3B\BBB33B(B
B{B
=B\BfB
=BzBBBBBHBBBGBB=B{BW
BB\)B(BӣBGBה{BؙB)BBڏ\BkBݏ\BB
B  BBB(BǮBBfB8RB33BpBW
B(BpBLBҙBffBuBνqB=qBaHBǮB̅BW
B(BϽqBǮBB
=B8RB)BHBkB
B\)BBBBܮBuBB33BGBfBqBB\BaHBGBޅBaHBB{BaHB)BQC GCCT{CٚC
C	fC=C
fC	\CaHC CBC8RCC \BHBB)B{B#B8RBB{BQBBB=qBB  BqBfBuBBfBLB\)B؞Bڳ3BBW
BW
BGBkBݮB۸RB=qBB\)B=qBה{B֏\BGBԙBQBҳ3BaHBя\BЀ BBϣBϊ=BϏ\B.B{BB
=BBЮBB8RBǮBȀ BfBHBBB͙BBffB
=BǮBB{BǮBѸRB8RBW
B8RBиRBљBQB  BpBaHB(BٞBي=B.BԔ{B
=BBW
BڅB٣BGB)BУBuBB
BД{B\)B\BϙBΙBkBzBBBBǮBBҊ=BuBBBffBнqBB(BΨBB  B#B(B.B=qBȣBȽqBBB\)BfBpBBBaHB(B)BB8RBBBB)BW
BB  BB=BfBqB{BLB{B)BpBBBpBW
B)B33B=B B33BBfBzB=BBÊ=B\)BBuBBaHB=qBBB33BB(BkB{BuBǽqBkB#BpBBffBǊ=BȀ B  BBɨBaHBBɔ{BLBffBB8RBQBBBBǮBBǸRB=qBBǮB=qBffB
=BBfBƏ\BffB#BŞB\)B#BBB#BǮBpB(BBQBfB3B8RBQB\BHBBLBHB
BBBBBW
BB3B\BGB8RBBQBpBǮBBW
B½qBBHB#BBB£B8RBBaHBB
BRBuB=qB
B
B
=B.BBzBffBaHB\BǙBuB  BșBǮBǊ=BaHBəB)BHBW
BBpBʀ BʞB  B.BuBʔ{B=qBBȣBǔ{BBȽqBɀ BW
B33BȸRBBuB=qBBaHBãB{B#BãBB\BB33BffBBBHB
=BB¨BBaHB\B(BGBB
BBHBB=qBB=qB  BRB(BfB=B
BB
=BffB3B#B\)BBfBpBBBBBLBBǮBB33BBffB³3BaHBuB(B=qBȣBBHBBɞB.BBʨBW
B\)BuB͙B(BGB΅BkBBfBGBB\)BBffBˏ\BzB=qBʊ=BaHBB=qBkB8RB)BuBƣBpBƅBƀ BBƞBBų3BţB\)BW
BpBŔ{BLBŔ{BǮBĊ=BffBBĨBfBBĀ BpBBBąBLBǮB BB)BÏ\B{BBÙBB
=BB\)BBB®B
B#B
=BpBLB  B(B)BB
=BBB8RBQBBB  BBBB
BB{BpBʞB\)BˣBffB͊=B
=BW
BͨB#BB̽qB)B̳3BW
BaHB
BBBB.B\BLBǮBȨBBBW
BBǳ3BBB
=BȀ BȔ{B)BřBų3BffBBǮB#BĸRB\)B\)Bɀ BpB8RB{B BBîB\BkB\)BB.BBqBB\)BBGBqBBpBffBQBBQB)B£B=B³3BBǮBW
BuBŸRBƮB
=B  BBǮBBB(BɨBɏ\B  B)B)BuBB(BǮB\BHBBBγ3BHB
=BϽqBЙBBҸRB.B
=BӣBBӞBӏ\BfBBǮBzBЀ BBBѽqBОBBGB33BBfB=qB(B  B{B)BͨB͔{BB=qBBQB͸RB̮BͅBBkB͔{B  B\B.BQBB̙B#B#B8RBW
BaHBHBǮB.B#BʽqBQBB\B#B8RBGBQB\BHBɀ BȽqB=qBBGB(BʣBuB)BB{BΨBpBHBpBW
BϣBBиRBB
=B33B  BLB.B)B\BW
B(B8RBǽqB(BŮBȮBBGB
=BGB{BW
BBʔ{BLBǀ BQBǅBQBB\BkBW
BBzBBʞBGBLBǏ\BB
B
=B(BBˊ=B\)BBBHBaHB\B
=BuBGB\)Bɏ\B#BƸRBĳ3BBBøRBW
BBB=qB  BBqBB#B33B\)BBBBkBĔ{BĞBBÔ{BBBBB
=BffBuBB=qB\)BaHBBW
BBBBfB
BuḄBˏ\BGBQBQBB͔{B͊=BzBBB\BBB
B
BHBBǮBkBBBBУBǮBǮB\B#B33BΏ\BGBBBQBBGBγ3B(BBB8RBBffBBBͣB̀ B(BBBuBЏ\BϮBkB.B
=BHBͽqBBBzBBB̙BW
BuBг3BBB{B  BaHBB̞Bȳ3Bˏ\B)BƙB)BpB8RBB
=BQBBB8RBBBʨBɏ\B(BfBGBB8RBkBLBLB33BpBzB{B
BϽqB(B
B#BB(B=qBǮB.BԳ3BuBB֙BB
=B
BԣBԨB8RB  BӀ BBB\B(BzB
B8RBԔ{B.BнqBBͳ3B\)B̀ BGB̮B  B(B
=BB=qBϞB\BB)BBB{B͙BffBpB{B
BɞBQBB(BBBƣBŊ=B  BŸRBffBpBpBBLB)BBʀ BʮBB8RBBBW
BBzB  B#B)B\)B\)BfBffBBBBkBBBLBzB\)BffBˣB˅BffBˏ\B.B̳3BBaHBυBBΞB
B
=BЮBЀ BGBQBѸRBӳ3BԽqBǮBB.Bє{BBЅBGBaHBB
BΊ=BB͊=B͸RB=qBBaHB̳3B̮B̸RB8RBB
=BfBfBffB  B\)B  BuB{BϞBЮBQB33BB
BpB΅B=qB)BBpB8RB=qBzBB(BuB#Bʳ3BBǔ{BBɮBffBɮBBW
BBuBzBaHBɳ3Bɳ3BpBBBB̳3B
=BGB̀ BǮB#B̏\BGBǮBB\)B(BGB{BLBBǮBBBB֊=BfBׅBzBBB֔{B=qBBBQBB.B̨BBffBѨBGB(BBϽqBLBг3B#BЏ\BkBB8RBGBW
BBγ3B8RB˳3BǮB
BW
B̨BLB8RBΔ{BkBBBW
B8RBǮB8RB{BƳ3B(B{BBBkBƳ3BGB
BBuBfBŏ\BǽqBɳ3BBBBBʀ B{B˽qBpB˽qB#BB.B8RBBBƏ\BƳ3BƞBBǮBˣBkBB
=B\)BW
BЅB  BQBLBBffB#BәB)BԅBaHBpBԅB=qBԀ BԙBӨBҳ3BBffBLBfB\BBӞBӣBҏ\Bє{B.BBΙBBffB)B(BBB
=BBLBkB#BuBɽqBB̊=BLBaHBLB=qBυB{B33B̨B
BBzBGBBaHB˨B̞BaHBBB̽qBǮB33BBzBBBˣḄBBˊ=B8RBɞB  BaHB˸RBGBǮB
BȅBzBHB
BQBfBpBǮBLBpBƮBɸRB\B
=BB{ḄB.BGBW
B̀ B#B
=ḄB(BLB#Bʊ=B8RB#B#BQB#BuB8RB33B33BBȞBȸRBɅBBkBʅB8RBBϨBBffBB\BBЀ BBнqBӽqB  BB\BBBpB{BB{B
=B33B{BŮB̸RBB\)BuBBŀ B)BȽqBW
B33B{B
B#BBBW
BffBpB
B  B)Bʔ{BBBkB=qBB#BHBBBBBɞBGB(B8RB
=BǏ\BLBǮB΅B#B͊=BͮBkBkBBƔ{B=qBɞBBGBBBǮBpBBB)BɣBǮBɅBȔ{B{B.B(Bď\BLBɽqB33Bŀ BȔ{BfBB\)BǊ=BƳ3B#BLBǮBLBģBB)BB
B)Bų3BBBəBBͮBBB#BpB\)B.BBBffB͸RB͊=B=qBѨBսqBB#BffBϙBԀ B#BB
=BaHB)BGBB̏\B
B͸RBυBг3BzB8RBQBǮBBQBW
B8RBͽqB33Bʳ3BzBʙBBLBBя\BBW
BffBB  BB(BǮBӽqBǮBW
B#BB  B
BW
BBB=qB{BͽqB8RB͸RBHBLB  B8RB)B  B̞B̙B8RBQB  B̀ B(B̊=BB33BBW
BθRB)B{BBBB{B̞BB͏\BaHBBΊ=BkBQB(BЀ B\BGBkBя\BB8RB̳3B\BBHBє{BӔ{BpBԏ\B(BBHB
BHBϣB
=Bπ Bʀ Bǀ BÔ{BHBB\)Bѳ3BЀ BQB.B\BHBνqB8RB)B̊=BGB̊=B  Bγ3B)B(BBffB)B(B33BBB҅B)BBBfBBfBB{B\)BLBУBBBǮB\)BϏ\BpB  BBzBffBˣB˳3B͸RBQB33BW
BBW
BffBaHBaHBЏ\BBkBQBBLB͙BW
B#BHB(B)BBҔ{BHBәBǮBՏ\B33B(BBzBBBBzBkBɔ{B#BήBˮBffB\BB8RBLBkBBBB(BBfBֽqB=qB(BBBkB B  BzB{B
BQB8RBzBBBBBBLB
=B=qB33BߙBހ BkBљB\B\)BHBθRB{B)B33BHB
=B.BGBԳ3B֙B#B
=BBЊ=B  BBzBBǮBBB.BBרBǮBBր B֊=BսqBճ3BBծBԨB#BzB׽qBBHBQBBffBW
B
BffBB#BݸRB\BuB=qBzBߙB33BuBᙚBRBB8RB33BkBBLBݨBffB\)B׊=B
B8RBףB\)B(B#BB=qBGB
=B=qBLBBBuBQBffB8RBߊ=BBBHB
B(BffBBBݳ3B{B\B\)B8RBzBBB
=BԮBLB
=B.BfBaHBߔ{B{B  B3BLBQBۨBݮBzBBܮB\B{BBzB#B33BB
BBڨB=qB\)BبBBֽqBBՅBֽqB֣B  B
B{BfB
=BBBBB
=BB.B BHBBffBBхBaHBpB  BGBԀ BգB#B  BfBBBffB.B.B.BB#B  BΏ\BB΀ BЏ\BBҀ BBBLB֮BBBHB)B8RBfBأBB.BمBBfBBpBB=qBB  BҨBԅB8RB=qB8RB.BѽqBхBѨBBBBB  BzBuBB=qBffBBҀ B
BaHB.BϨBЀ BǮBfBԮBמBBBaHBՀ BBzBԀ BQBҨBW
BB)BԙB)Bӏ\BBҙBǮB33BнqB  BLBB(BЙBGBW
BBҳ3B  B̔{B\)B33BBBB  BӮBָRBBBfB֞BBQBfBBՙB\B  B֣B\)BՙBBBaHBffBBֳ3B֨B֔{BօBBBffBԸRBBӽqBԨBӳ3BuBzB=qBBBBHBД{BfBBuB˅B)BaHBaHBfB)B.BͨBHBγ3B#BBBQB
=BΔ{BQBγ3BBBД{BBϮB8RB(Bъ=BϽqBУB
=B  BLB
BϽqBBzB̳3BpBGBÞBBBʮBʽqBBuBɽqB
=Bˀ BuBƅBkBW
BGBBffB\BѮBϣB  BkBQB)BW
B
B)BzB{BBkBBpB{BfBѨBѸRBB{BBBBffBHBzB#B˨BB
=B#BB\)Bǔ{BʽqB
=BpBBffB=qB8RB.BB
BzBBB.B#BQB8RBBffBW
BW
BfBBBBBǮBǮB BkBBBBpB
BBuB\)BBBB=qB\BB\BB{BB(B33BBBB
BBzB\B=B#BzBqBBBuBBBBB B#BBBBB=qB#BBzB=qB{BɊ=B
BǮBB¸RBBB#BBW
B{BB{BkBfBBffBBuBBffB8RBB\)BB\B{BǮBB
=BBB{BB
BB#BB33BBBBBaHBB  B=qBGBBW
BGBB
=B\BBQBzBpB3B=BBBzBBffBBBfBRBpBB#B\B33BpBBB3BBBB.BBBBƏ\BǨBBW
BˣB=qB{BB.BͣBϨBBzB{B
=BBB8RBLB.BB#B\BGBǮBfB.B)B{BffB\Bĳ3BB
BQBŔ{BfBǨB
=BuB8RB)B\B
=BpBffBBaHBB
=BBLB.BBŞB8RBĞBaHBB33B  BpB  B#BBfBBLB
=B.BW
B(BHB{BģBBøRB\)BBBŊ=BŨBkB(BĔ{BBĨB  BBƙB
=BƣBW
B\BpBBB=qBBQBW
B
=BʨBB͊=BkB\BͣB#B\B8RBϣBϸRBBЊ=Bӳ3BBBBBӏ\B\)BB(BBӞBffB
B
=BBљBkB(B(Bϳ3BLBW
B\)BfB˔{BB\B̸RB̸RBBBzBǮB)BͽqBBBB.BffBǮBGBƣBǮBuB8RB=qBHBBĊ=BBBǸRBǽqBŨBƀ BǮBBB®B  BBHB  BBBBƏ\BfBǸRB)B(B
B˙B  B\)BϨBД{BBД{B  BpBLBQB=qBнqBffBffBΨBBBǮB.B.BB33B8RBՙBԮBzBW
BҀ B8RBӞB\)BkBОBϊ=BaHB.BfBQBѨB=qBОB(BLB{B.B
B#B{BffBˊ=BGBzB.B\B#BBBBʔ{BB
B8RB{BɊ=BuBBHBBuBGBʣB\BBpBǞB
=BǸRBƞB(BǮBBBffB33B  B#BHBQBzBBBuBˊ=BɽqBǮB͸RB)BBBQBuBЅB  BzBҮBGBҀ BkB8RBӞBzBW
B33BpB{BfB)BB=qBBBBB)BǮBBBۀ BۣBB޸RB
=BBW
BB(B\BǮB׽qBkB׸RB.B)BՔ{BpBffBǮB  B
B
=BaHB
=BԙBBǮBB8RB  B
=BШBkB\Bҳ3B{BҔ{B{BӀ B#BɸRBHBfB  B(BBzBΞB=qBBήBGB33Bϊ=BHBBB
BѮBըB׸RB.BՊ=B8RBӨB33B)Bѳ3B\)BuBBffBׅBBBfB8RB
=BB
=B뙚BzB
BBǮC kBqB33B.BB8RB{BBB.B=B݊=BpBW
B#BB8RBǮB#B8RBfB8RBW
B#BB
BB枸BB\BW
B{BBBGBB.BB
=B{BBzBpBBHB\BffBzBuB{B8RBЅBBGBuBW
B)B  BՔ{B)B݀ BB\BGBuBRBB=qBpBBfB.BǮBHB㙚BQBBBBW
BfB=B{BBBBB8RB=qB)BBHBzBpB
BfCBC=qB3BBuB8RBB#B  BBaHBBC ^BBC =qCnB#BB{BQBRB\)BHBaHBBkBffB
B\B{BBBaHBBHBuB\BBBBkB\)B BBGB(BHBaHBBݳ3BǮB޸RBRBBB\)B\Bր BRBԮB#BQBuBڅBaHBzBffBڏ\B  BW
BB\BǮB{BBBkB8RBB(BLBQBffBkB
C{C=CLCC3CC=C	C
C
C)CCCxRC\CC	qC
HC
=C

C
)CRCLC
C33BaHC RBW
BB\)B=qBB\)B.B
=B  BBBBkB#BRB{BB BQBB=BBBBB)BzBǮBBB#BffB
BB
BRBB=qB{BGB)BqBpBHB{B
BBB{BHB=B{BB\BBpB8RBqB{BBuB8RB=qB(BqBRB B\BuBBBRBRB=qBBC=qCC CpB3C {BC   BGBBBCuCpC.CCBCC0C0CBC HCcCCGCpB=qBfBBGB8RBLBffBkBBW
BpBffB߳3BuBkBBGB.BfB  B3BpBBBB枸B BBBB#BfB8RBBBB
B߳3B  BأBBHB)B۽qB#B܀ BB.BB߳3BB33BaHB)BBB噚BkB\BLBBBBpBGBpBaHBBBCCQC ^BkC 5CC)CHCCaHCuCCCCCYCCBC C EBBW
BB BpB)BBBB=qBBB8RBBffBBBkBRB33B33Bߏ\B.B߀ BffBB#BܣB.BuBߙBBݮBQB
=B(BݮB#BuBݸRBLBޣBߊ=B)B8RBHBW
B)BffBBB(B BBB.B BB䙚BBܙBBffBᙚBBBB#BBpBBBBpB{BaHBLBBB  BQBBLB33BBffBB
BaHB{BB#BuBQBfB33BBBBffBܳ3BBBBzB33BHBיB֮B#BLBB8RB33B33BBBffBٔ{BBB  BzBBfBBBǮBBHBߏ\BaHB=qBHBBۨB(BffBkB{BڙBaHBה{B(BB֞BծB
=BB\B  BɅB8RBaHBѸRB8RBُ\BՊ=BfBޅBffBݙBBBۏ\BԔ{BԞBBW
BQB=qB8RB֮B׀ BBB\)BBffBBBzBaHBB.Bڔ{BܨBuB
=Bٔ{BBW
BQBB
B\B҅BBB\)B{BaHBB{B#Bр B8RBЮBBϞBffBBLBBBϊ=BkBffBBB  BBB  BB  BBW
BԀ BaHBBzBըB{B
BzB33BzBW
BҮB  BLBQBzBW
B#BѮB=qḄB.B̅BBBɏ\BBB{B.B.BLBHBpB{B(BkBHBBQBǮB̽qBǮBBЏ\B)BBҀ BҸRBՀ BBuBkB؅B=qBkBBB\BuBמB=qBՙB(BǮB{B\)BGBԽqBӳ3BхBB(BхBǮBӮBӳ3Bҳ3BBҸRB(B)BљBҏ\B33BfBBBuB\)BӀ BkB\)Bӊ=BҮBB33BӅBBB{B8RB{BW
BхB{Bг3BЙBkB)BΔ{BǮB͊=B#BHBʽqBQBGB(B)BfB)BB(BB̊=B\BaHBͮBBzBB͊=BΞBffBaHBQB8RBBkBʙBBBυBЏ\BBHB33B  BLBя\BBpBѨB33BҨBuBpB
BљBўB(BB{BBBиRBB{BBBє{BхBaHBB.BѨBBўBffBϣBπ B=qB)B\BQB͏\BΊ=BϨBπ BиRBB=qB\)BBBaHBB˸RBʏ\B
=B33BB33BW
BB)BǮBșBBaHB{B(BaHBĽqBuBƀ B)BQB(BƮB\)BB\BŔ{BffBW
BǸRBaHBB33B.Bʀ BɞB  BzBȳ3B{B  ḄB#BB̙BffBzBzBHBBǮBBθRBBЙBfBGBΞBϨBBLB8RBΞB\)B
BBaHB#BGBffBffBˀ B#B\)B̨BBBȅBHBHBBǏ\BHBǽqB
BfBǽqBǮB.BBƞBǀ B
BB
=B
=BBzBǅBȅBBBGBBȀ BȀ BƣBǮBBB33BzBBBQBɮBB\)BBB̅BaHBBBBπ BB#BB(B)BBB\BzBpBaHB\BнqBW
BǮBpB
=BǮBBB{B\)B֮B֨BԽqB\BB
BHB.BaHB{BՅBBָRBր B{B.BHBfB՞B(BԙBӞBBѸRBLBHBBϳ3BήBBBЊ=Bϊ=BLBB#B̔{BQB̀ B͞BǮBϣB(BBB\)BpBǮBW
B  B\BBʙB̨BLBBʔ{BʅB33B#Bǔ{BǮB=qBǞB˞BGḄBϣBBʅB˳3B̨B)BBǮBΔ{BB33BхB)BBЮBW
B(BB  BϣBaHB=qBӊ=BԮBB#BBfB  B۽qBBLBLB#B#B(BǮBǮBkBٸRB.BaHBָRB=qB\B՞BBՊ=BBBǮBҏ\BHBBB)BBBг3BЮBGB=qBW
B.BѣBҏ\Bъ=BLB
=B
BBQBB͊=BffB{BΊ=BW
BfBfB33B\)BB.BQBͅB33B(B33BHBͣB#BBBʔ{BBB)BpBг3B.BuBљBuBLBHB#B.BBQBӸRBHBBHB8RBkB
=B33BffBzB\BBpBkBHBpBQB
=BBBBBǮBBfBB=qB{B.B.BܨBמBzBBǮB\)BBמBfBǮBB33BkBLBGB  BBѳ3BpBBBԊ=BԮB
BBBBB8RB33B׸RBffBBB=qBϞB͞B͏\BLBGBBͽqBBGBkBaHBpBaHBB
BQBͣBQB\BͽqB\BzBQBBB̽qBBuBBB\)BՔ{BB.B\)BٮBQBBQB\BRB8RBBpB(B\BBRBaHB B
B\BB8RB)BkBuB#BGBpB8RB#BBBQB33B{BB
BBGBҊ=BBҽqB8RBمBfBBkBԅBӽqBLB8RBkBҊ=BpB)BӮBԅBpBҔ{BpBBѮB=qBaHBffBўBuBBfBϳ3B.BϮB
=BBBW
BBB#BΏ\B
=Bѳ3B#BBB8RBBBB\BBaHB#Bފ=BQB)BBLBffBBHBBBLBpBQBB)BQBffB(B#BQBB=B\B晚BB  CYB=C =qCC)C)CǮBBڞBBBǮBzBBBۏ\BBW
B݀ B(BBuB(BBLB(BBB\)BBB BzB{B(BBިB{BB\)B׊=BB\)BGBBfB(BBB۔{BHB(BۣBBaHBaHB8RBոRBٔ{B܀ B33BkBBB܊=BBؔ{BLBkBݽqB#BBBB=BqBBBBBfBBB➸B33BިB\BkB{BB=BqB(BRB\B{C CaHB\BffBBBBkC HB)B BfBBBBǮBBBBRBkB=qBQBB׮BB\B)B܏\BBfBfBǮBǮBڔ{BBיBLB{BBBuBBǮB)BGBԨBՔ{BGBQB\B\)B\BBffB\)BՀ B{B
Bр BuBQB  BڣB\)BǮBLBfB8RB  BBՊ=B׮BبBGB۞BLB=qB.BBBBW
BaHBuBHBHBB۽qBffBBzB֨B\)BޙB
=BߨB=qBBǮBܸRBuBHBה{B
=BոRBQBܮB۳3B{BܮBօBǮBB=qBLBۏ\BBBzBՔ{B֙B֞B\BBffBٞB٣BBBBօBBBB  B{BڽqBٽqBHB)BffBBBBBظRB(BBB
=BB.B33BB33BՅBӅBҏ\B
=BaHBzB#BB\)BBHBHBLBQB
BBBBBkB͸RBffB=qBϸRBzBGBBBffBBGBܳ3BB  BffB޳3Bߊ=BB{BܙB  BǮBLBۙBB3B#BfBpB3BݞBBǮBBLBBBBBaHBӳ3BԸRBB
BLBԔ{BמBLBBGB(BBB=qBٮBuB)BW
B)BԞB֊=BǮB׳3BBؔ{BB#B=qB\)B(B\B֣BBzB#BОBzB.BҮBBɽqBȽqBɔ{BBuBB\)Bʊ=B{BД{B.B=qBQBuBQBBBє{BHBъ=B\)BzBLBffBHB\BW
B=qB33BB)B֣B
B  BǮB=qBBBQB֨B.BգB\)BԙBB.BB(BBԸRB=qBBBQBBLBfBг3B{BGBzBkBaHBѣB8RBBўB\B)BѣBffBHB
=BLBԣBB.BLB33BҊ=BBffBхBfBг3BЏ\BBuBήBΏ\BzB
=BfB  BB
=BGBͮBͣBͨB\)B33BpBBB\)BBϳ3Bπ BBffB\)BB̽qBϏ\B.BuB(BǮBBЮBzBϏ\BB\)Bҳ3B{BfBՅBffBըBffBոRB.B33BB  Bӏ\BB\)BB\)BҨBBBѮBQBѽqBҳ3B8RBЅBЙBBB\)BЙBHBGB
=B8RB\)BpBBQBHBB
B)BfBW
B)BkB#BʽqB
=B˸RBQBkB
B
=BffBHBBuB͊=B̽qBǮBΙBθRB  BHBӊ=B=qBW
BW
BBGBB(Bۊ=B33B3B
=B BpBfB#B\)Bה{Bڔ{B33BpBЙBBkB.BfBBBǮBuBӔ{B\)BBՊ=B)BBǮBaHBνqBB
B
=BpBγ3BBLBBB
=BǅBB)BfBBBBffBBB(B\)BƸRBƅBǽqB(B)B\)BzBǮBW
B
BffBB\B
=B
=BʅB.Bƀ BǽqB(B\BfB
=BBB.BBB˔{BB8RBףB(BpB{B\)BBkBBB=qB(B3BBHBڀ B)BBLBڳ3B)BٸRB\)B#BۣB{BמBљBЙB#BνqB\)B̮BB\)BQBʨBŨBBBBuBB8RB(B)BB
=B=BzB
B\B(BBB®B#B8RBLBBB3B33BfBBRBpBQBQBGB(BBzBkBBLBBW
BaHBaHBBuBBB#BBB.BB#BkBBQB{BB=B3BBuBB{BfBQBBkB̞B  B(BB#BQB)BԙBzBfBBӨBճ3BԨBuB˳3B̀ BƣBffB8RB=B\Bʔ{BBB{BqB\BBB\BB33BGBBBB=qBqBBW
BB  BBGB33BzBqBkBBBfBffBBzBzBB.B(BqBBBBpBBpBpBpB)BBBBBffB)BBaHB{BBBBBB
B\B
=BBBkBB{BRB{BffBB\BȮB8RB#BɨBfBQBLB̀ B˽qBB8RB)BǮBɮBkB\)BLB
Bɀ BGBșBBB33BaHB#BƨBpB{B.BșBŨB\B.B=qBBW
BBBQBBBfBBBBpBBkBB®B=qB
BkB\BHB8RBBǮB=BfBB
B\)BB\BqBBW
BW
B  BGBB{BHB  BBGBǮBBB8RB\)BffBfB=BǮBaHB8RBʽqBĸRB  BǽqBȅBBGB
=BBaHBW
BBǙB\)BBBBBǮB.BB؊=BؽqBQBB33BBW
Bݳ3B۳3B\)B֨BȞB)BƊ=BǮBƀ B
=B{BBBĸRBpBaHBB)B\BB33B33B8RBÔ{BBW
BBŀ BBW
BaHB)B8RBLBBaHBBkBƏ\BBHBB\)B\BzBèB
B\)BW
BBBRB
BB=B  B#B33BkB\B  BBBBǊ=B
BBfB#B(BBBγ3BнqBўBzB\B(B\)B33Bӏ\B
BaHBԔ{BB=qB8RB8RBӮBգBՀ B  B=qBfBոRBBB{BB  BB
B(B)BBBaHBʅBB)BpBkBʔ{BʙBɳ3BffB{BB{BBB\BffBQB\)BBkBǮBɣB)B.BǮBɊ=B½qBuB{BǏ\BuB  BǮBəB\)BĸRB(BBB.B\)B(BQBzB
=BfB
=BB\BuBÞBW
BffBǮBBBĞB\BǮB(B33BBBٸRBB8RBHBpBaHBfBBBB{BfB
=B
B=BffBQBBB
BLB33BB#B#B33B\BW
BzBuB\BBӏ\BfBBBfB֔{B
B\BӅBB33BЅBЏ\BB  BBffBfBBB#B\)B  BW
BBQBHBBBBRBffBBW
B\BB
=B8RBzB3BGB(BBkBLB{BBGB.BBLBBRB=qB)B.BBuBŮB͏\BGBpBB{BҮB8RBӏ\Bӏ\B)BԸRBڨBB߳3B{BHB{B.BffBBBBQBaHBB=qBBBBBHBB8RBՅBרBըB  B
=B\)B
=BB½qB BBzB8RBBB B\BBBǮBBBBLBB=qB.BBBQB3B\)BfBBBLBRB  BB  B33BB.B
B\B)B{BqB3B#BBĔ{Bų3BQBǳ3Bó3BBB\BBBB\B\BBBLB.B{BW
BGBBB׀ B#BuBHB8RBqBfB33B  B BB BB3B鞸BBW
BBpBǮBBBLBaHB{BBBB B
=B.BB)BŸRB
=B
BkBuBB)B(BfBW
BpB  BffBӮB33BW
BB8RBͳ3B̅BǏ\BHBBB#BuB3BB{BBBW
BB\)B.BzBpBGB
=B33BBBƅBŊ=BɽqBaHB.BBƣBB{BϽqBBυBBǮBǮBBpBpB33BuB#B׀ B׏\BٽqB8RBB3B=qBBǮBBݽqB
BQBuBBHBǮBHB
BBB虚BBB\)B
=BRBBaHBW
B8RBLB  BBffBLB(BB(BaHBBB3B
BW
BGB(BBBHB
=Bǀ B8RBGBÙBBBB)B BB=qBÔ{BBLBHBGB8RBBHBBB\BB  B{BBB3BkBBBLB=BBBffB33B#BffB\BpBBuB\B)BRBLBBBBfBBBffB8RBB33C CLC
C=qC
pCǮCHC^CC	W
CCqCO\C
B\)B)B䞸BB  Bހ BLBpB#BBޏ\BfBB\BHB΀ B̔{B\)B{BB)BzB#B#BLBB  BBBBBHBճ3BB{BЅBaHBzBҞBBB  B=qBQBB
B=BB\)BBBB#B
=B
BuBBB{BGB\BԀ Bր BBǮBBBBB\BHB
CC
=C)CYC	RC
ǮC!HCnCCRC3CB\)CCpC$#C s3C"O\C$
CqBaHB=qBBLBHBBRBCaHBB{BBB)B\BQB\B3BQBBB.BB33B8RB\B8RBBkB8RBRBGBffBBBŔ{BpBB B(BBuBBBzB8RB)B33BB
=BB=qBB=qB\)BLB.B33B(BBzBŮBɨBBBBǮBzB\B  B\BBBB{BaHBBߣB BB.B{BB\BٙBLBޮBqBBꙚB.BQB
=BBQBBBBB\)BBBB)B)BٽqB33Bъ=B33B(B\)BǮB=qBBGBkBuBĸRB\BBfB#BRB  B  B\)BpBBHB BaHB
BB=qBGB
=B.B8RB)B#BBB\BBBBBBpBHBLBBBBBRBBBB  BŊ=BfBHB#BuBʏ\BW
BȣBfBҊ=BuBǮBB  BBkBuBBBBB BGB  BW
BǮB
BuB
BřB\)BHBB
BBя\BfBB#B¨BÔ{B
=BBHBÊ=BB¨B\BzBqBB33B=BB  B  B\)BBB33BBBBBBBBBB#BqBǮBpBLBBQB  BBfB#BaHBkBaHB\)BW
BGBBBǮB=BpB\BBBqB8RB.BLBB\)BBB
=BBLBBBBpBBBpBBffB#B.BBB{BBBfBB\)BqBǮB
=BƊ=BνqBfBBuB\)BBB.BGBRBĨBB{B\BkBuBBBBBBBBBBBB3BHB33BaHBfB=qBpBB{BBaHBBBBGBHBBBB(B.B{BB3BRBffBBǮBGB3B33BBǮBLBB3B BB33BffB
=BBkBB
=B#BBB\B\BB{BBB\BW
B\B.BqBLBqBLB\BBBkB\)B3BB8RB33BLB)BBBkB#BpBB BW
BW
BB=B.BǮBuBB{BBffB BB\)BB(BBkBQBffB)BB)BBB\)BB  BRB{B
=BBffBqBB33B\B=qB\)B  B\B\)BBB=BBB33B)B)BBB  BB.BffBaHB\BBB{BB#B33B=BBBÔ{BaHBøRBÞBLBBuBBBBB33B(BŮBqBzBBB33BǮBQBBBBB(B33BB.B=qBʅB33B˸RBQB{B  B)BQB\)BaHB
B.B®BffBBzBuBRBBBqBfBBQBGB.BffBW
BŅBzBffBuBGB=qB
B\B=qBBuB
=BQB=BBB8RBBBǮB.BB{BBB8RBaHBzB33B BqB3BRB=qB
=BfB\)BǮBffBLBB\B=BB B\B{BfBĊ=BBǏ\BǣBȔ{B(BW
BʮB˽qBW
B\BuBB\)BBuB33Bֳ3BBQBя\B
=B܏\B\)BBLBBBǮBBkBBĽqBBƏ\BzBpB B=qBHB#BBBW
BzBBBaHB{B33BB.B
=BuB
BHBkBۏ\B߀ BBLB)BBB B.BBGB
BGBBzBLBuB{BHB{BpB{B)BǮBLBfB.BRB.BpBW
BBBB33BBHBBBB BB߀ Bޔ{BӽqBffBBҀ B8RBBBBӮBQBBB{BBB)BϞBfBϮB
=BaHB33BãBģBBfBʀ BBHB˔{BLBBBBBͳ3BB33B8RB=BBfBW
BRB=qB33BB\)B8RBqB BBBBBffBB\)BfBfBGBB{B\)BBBW
BBaHBB8RBBW
B{B=BGB\BBBGBfB\B=BŸRBfB8RBGBGB33BfBpBHBzBfBBRBB{B33BkBBBBB\BǮBBB\BuBƸRB.BB(B8RBzBBʀ BBÞB)BQB{BʙBffBǀ B\)BBLB=qBBBuBuBuB{BpBB#BRBǮB33BBRBBHB BBBBBBB  B{B(B{BBB#B=B=qBB\BqBaHBB\BB B
BBBBBǮBB{B B)BB(BHBBBkB  BGBB
B#B
BfBB33BRBøRBBBýqBBBBzB
BLB̔{BBĽqB¨B33B  BfB33B(B#B\BuB\)BLB)BfBǮB{BuBW
BB\)BB B.B.B8RB\)B{BBfB{B\BBfB BB\)BkB\B\)BuBBfB  BBpBBB33BHB{B
BGBRBfBBffB\)BǮBB
=B3BfB=B{BB{BLBkBB#BzB33B{B
B{B#B(B(B\)BBƨBBffBzB
BBB\)BɊ=B#Bˀ B(BuB33BΙBǮBW
B33BҔ{BӣB(BBBBѨBBBѮBBffBffBQBHBÙBuBpB=qBBGB{BqBBèB  BB3BBBB
B(BBzBaHBaHBB=B33BGB\)BBpBaHBBB
B{B B{BB33B{BRB.BpB\)BpBBBBB.BBLBBB33B  BBBBBBW
B\BB BHB{B)BʅBB˸RBB33BBBaHB{BBBuBffBLBBffBνqB  BսqB8RB#Bŏ\BW
BqBB
=BBqBB#BBB8RBBBBBGB=qBB(BkBpBuBBBHBHBRBRBBQBBBB=B33BzB8RBW
BBýqB¸RB\)BŨBaHBBzB)BW
BB=qBfBB³3BBB³3BB
=BB8RBBÏ\BÙB
B(BQBW
BBB\)BBuB)BϮBpBхBԀ Bˀ BȸRBB{B#BǮBѣBBpBͮB͏\B͞BQB)BGB8RBkBܔ{B)B#BHBuB(BB
=BaHBB33Bȳ3BkBLBBٳ3B\)BԳ3BaHBHBǽqBBB8RB{BB(B33BzB\)B)B{B.BBȊ=BˮB#B
=BuBșBaHB  BBBGBzB\BW
BffBkBǮBBîB
=BBÏ\BŮBGBǮB#BkB  BGBЙB=qBBBBGBBЅBϮBB̞BzB33BB؅BڽqBڸRB#B33Bۀ BBLBW
Bۏ\B=qBBLBBٙBBڔ{BأBzBkBB
BffB)BkB{BнqBkB̨BGB)BzBB=qBBBɨB8RBBBBƔ{BQB=B(BkB)B.BǮBfBBǮBBBB#Bĳ3B33Bƀ BǊ=BLB{BfBB=qBęBuBGBBBfBB\)BBpBfB)BBȨB
=BBB˙BW
B8RBQB̙BBQBB{BaHBӞBBBzB׳3B
BB.BܨB#BzBfBB)B(BӸRB.BB؏\B.BB{BHBLB#B؏\BۨBBΏ\BB̞BfBLBHBǽqBLBzBĽqBBBHB
=BpBBBGBBĔ{B\BLB=BBBǮB(B BBBB
B{B)BffB
=B(B
BHB3BB.BkBBB#B B  B\BBaHBBB
BQBpBHBB\)BB8RBB\)B\)BǮBffBɅBǮBȏ\B̀ B̀ B=qBB)B܏\BBaHBޞBݨB
BҨB׏\BzB=BBzBBBBB߅BݞBHBaHBBBBBW
B֨BBBB.BBzBzBBB\Bʳ3Bͳ3BpBzB\BkB8RBB)BkBƞBÏ\B½qBW
B̏\BʸRB(Bϊ=B.BϞB=qB˳3BɊ=BpBB)BBBBGBkBB.Bȳ3B3BfBBW
B.BB#B
Bр BԳ3BB8RB֏\ḄBB߀ BBBӏ\Bس3B.B\BB=qB  B䞸B鞸B  B(B
=BkBqBB׏\BGBffBݨB8RBffBݏ\B
=B
B B BzBffBBߨB՞BBB BkB{B{BΙB{BϽqBɽqB΀ BLBQBzBBBȏ\B\BBBǀ B#Bɳ3B\)B=qB.BW
BW
BƸRBΣB
B
=B8RBBǙBĽqBBQBBÅBB33BaHBQBHBffBLB33BLBB33B\BB#B)BBBRB=BBfBBBΙBHBBЀ BaHBՏ\BBB=qBB݀ B\BܽqBRB(B؏\B{B  BzBffBBzBBQB\)B  BBCCCnC fB\B\B=qB33B{B)BB{B̽qBBB33BfBǣB33BB=qBuBᙚBBQBָRBBuB8RB\)BBLBŀ BLBBĞB\B)BBBǞBuBGBBͳ3B\BfBͣBHBpBΏ\B͞BB
=B.B8RBQBBffB
=BaHB{BB¨Bŀ BW
B  BfBŮBB  Bɳ3B{BHBkB
=BkB(BBkBGBBLB\)B.BqBkBpBB  BB\)BBCB33BpCqCBB
=BԙBaHBѮBBЊ=B͏\BpBBB{BBpB
BBǮBpBBBkBƮBffBpB)B  BȅBɣBBBǮBuB
=B)B)B\)B B(BaHBBzBHB.BuBBB=BW
BBBBB(BBBBB8RBpB{BǮBB
=B(BBBkB.B
=B.BffBpBBzB#B
=B33B֣BpBBB=B3BBBBBCCJ=CT{C\C33C
CBC
CC
=CBB(B
=BBǮCǮBBCBB.BW
BpBӀ BB.C#CHC
B(BBBBffBffB8RḄBBB{BzB㙚BaHBBB3BB  BB
BffBLB33B)BޮB#B
=BӸRB)Bٳ3B͏\B
BǊ=BօBޔ{B)BBǙBuBBBB(B8RBqB8RBkBB
B=B.BBBffBǮBLB{BpBkBB̀ BC &fB)BBGBB.BB{BBW
B=qBpB=B  BfBLB(BRBRBBqBaHBpCBBpBBBBBڞB BBǮBBBݙBBffBuB˽qBQB{B
BB8RBBBBBB
=BBǮBqB8RBGB B{B\B=qB)BBBB(B\BBQB=B)BuBBǮB
=BBB.BBfBaHBfBffBaHBpBBBB{B33B\)BRBͣBfBQB׊=BffBУBۨB33B\)BLB#B)B)BBǮBLBqBGBfBpB
=B\B)B=qBB  BBHBBffBpBzBQBBBBBuBBLB  BaHBB=qBB
BǮBLBqB=qBó3BBBBHBzBBffB=BBB=qBBHBfBBqBHBBBBB)BRBQBǮBRB(BBBÊ=BǮBǀ BRBfBBB\)BHBBB)BLB˔{B  BǮB
BսqBB
=BBzBBHBBpB䞸BǮBBQBQBB BힸBBBBBC YC )BC B B  BRBBpBzBBGBuB͊=BǮB\)BB8RB#BffB\B B{B{BBfBzBBGBÔ{BBHB BB3BBǮBȏ\B
BGBkBB
=BkBBfBBW
BpBBGBLB)BaHBkBB)BBB)BQB{BB=qBaHBW
BHBkBuB{B=qBBW
B8RBBfBGB8RBW
BHBB޳3B{B߮BBpBffBQBGBݙB=qB{BǮB=qBǮBBB\)BHC ffCHB{C)B\BB BB
B(BިBzB  BB#BuB(BB)BBfB(B33B.B
BB=BBW
B\B#B(BBȳ3BQBB.B=qB33B.BBBҳ3BBpBB33B˳3B
B
BBB  Bŀ BBzB=qBBW
BBBGB
=BuBpBHB\)BʨB#BȊ=BBBBuBBBB  BQBaHB=qBLBLBW
B#BuBBzB=qB3B  BzBaHCkCC:CCC	=qCC
}qC	CW
CChC C	hB8RBGBBQBBB#ḄBBBڸRBkBǮB΅BBB#BBuBaHBGBBpBB׸RB\B
BBٳ3BBBBϊ=B͸RBuBffBffBǮBBBB3BBBřBBBBqBRBǮB{B8RB(B{BBB
=B#B3B)BBkBW
BLBB(BBB\)Bճ3BBݸRBkBBHB=B{BBBB)B
CCRC޸B{CBW
BBBBBRBCffC}qBpB#BҙBzBzB垸BuB\)BB
B\)B(B(BBfB
BBBzB#B؏\B  B
B=qBƳ3B  B\)B\BQBBkB(BzBB\BffBȣB
=BBȮBW
B\BƏ\BQB{BƞBĳ3BÊ=B{B33BfBaHBB
=BBBpBB{B=qB֔{BffBBB\BBB)BBqBBpB
BffBqB.BǮB BBfC HB{BB33B)BB݅BҸRBLB  BC J=BBW
BBB\BǮBBəBʊ=B\)BLB
BǮB(BB\BB͞BBBBBB
=BBBB(BpBW
B(BBиRBpBfBQB\BBǮBB
BBB\BϨB#B
B8RBȮB\BB{Bҳ3ḄB
B
B{Bó3BffBB#B  BBQBBBB)BBȨBpB(BB8RBBBQBpBBBB=qBBQB
=B(B=BBW
B)B螸BB=B\BLB8RB=BffBBB۞BЏ\B)B.BB=qBBBBzBңBֳ3BfBBծB8RBЏ\Bр B{BuBBBBfBBBB(BB(BB3BB.BBB\BBQBBHBB3BBfBaHB B
=B  BBBBfB33B=BW
BLBB̮BHBpB8RB.BQB(BHB#BB\)BffB=qBъ=BBٞBBBފ=B8RBaHB\B BB
=BGBǮBBǮBQBC޸CzC޸CkC^CcCfC
=qCBqC0B
BfB\B(B
B\)BfBLBB\)B۞BaHBB=qBBǮB)BBήB
BuBkBLBB(Bה{BzBBB33BϽqB۽qBaHBGB=qB\BȽqBQB˸RBuBfBɨBȨBBǀ BBaHB=qBW
B{B  B=qBLBB\BGB(B.BBʊ=B
B
=BBffBHBՙBzB
BBBBݞBBB{BBRBffB(BB8RB B{BB  C {C.CC33C=CBBBaHBuBBB.BC)ChB)C B)BQBBQBffBޮB3BaHBBBB BBBRBffB.BBLBB
B33BBBǮB\B33BaHBЏ\Bˏ\BzB33BLB{BaHBBpB\BʅBBB͊=BLBBB.BkBfBGB͏\BؽqBǅBGBոRBW
B{BuBΙBܽqB{BBӊ=BףB݊=BB8RB{B)BRBBHBB33BBQCC(CfC!HCCaHC)CnC}qC@ C)C
{CCxRC
C
3C&fB33CCRBzBBB.BǮBB3BB{B\)BBGB33BzBƀ BkB  BqBBBHB  BLB{B߀ B{B  B  B
=BB\BBW
B  BۅBB.B#B(BЏ\BW
BBBzBнqBW
B.BB(B#BfBٳ3BGB33BffB΀ BBϣBffBffBkBǮBϮBBB
BffBB{B33BLBBB\)BBpBǮBǮB BB  BBBffBB(BpBBuBpBB  B33BaHBօBW
B\BBBW
BQBBB{BݣB(B\BׅB8RBW
BB  B\BţBqB  BBRB
=BBB.BQBBRB
=BfBęBBpBBffBBHBBB BpBB#BffBHB8RB=qBRBkB
BBBffB8RBBB=B8RBuBGB.BBHBBBaHBuBW
B{B8RBBBGB#BBQBǮB)BBBuBBqBBCCBB\B\BBW
BٙBBǮBQBffB
BBW
BHBGB\BB\B͸RB33B=qBBBĨBBBkB33BB=qBBǮBB(BB(B  B  B)BBqBkBW
BBB\)BaHBfB3BBBqBB=B(B
=BĮBB.B\B\B{BQBkBqB\)BkB\B
BBǳ3BB.B{B=qB\)B\B\BaHB\B
B۽qBW
B䞸BBzB
=BffB\BBGBQBBzCC3C BkBB8RB8RBBaHBfB
B(BBBffBB)BW
BΨBW
BBzB B=qBpB  B3B\)BuBBB\B£BȔ{BBffB  B(B=BBHBkBƙBƔ{BqBBBqBB\)B3BpB\BBB(BGBB{BBBBB=BfBGB\)B{B#BB\BGB=qB=qB䙚B\BBB\BHBW
BB(BLBzBB#BB=qBW
BBuC C C=C33CBaHCHBC޸C:C CٚCC	{CCCO\BQB(BaHBGB=qB.B垸BꞸBBBB޳3BaHB.B{BB\B\BaHB B3BQBkBυBǮB)B
B͏\BǮB
=B͊=B(BBkBB)BBBHBҨBˮB(B.BBθRB8RBuBB
=BBǮB3BB\)BGBB=B  BffB3B(B(BԀ B  BGBW
BB
B
BԔ{BȀ BBuBQBШBHBBHBkBfBBߞBǮB\BB{BУB33B
BϙBQBǣBHBQB{BǮBkBkBÏ\BǮBʅBϣB
BBB
=BBŊ=BBʣB\B֣BBpB(BǮB=BfBW
B  B\)BW
BzB\)BB.BǮB)BBB8RBB\BpB
B{BQBuBB3BpB#BBBffB=B)BB3B{BffBkBW
BLB  B
B33B\)BGBHBǮB8RBB33BBQBBƣBBW
BfBB8RBBB(BB)B#B
BB.B8RBBBBQBkB8RBffBʨBfBBpBRBřBaHB\B{BuBǳ3BQBـ BɨBLB#BzB\)B  BHBBHB8RBkBB\)BGBB{BW
BuBBBHBB\)BɅBzBkBB.BʮBʞB˨BQBB\)B.B BRBuB BBBó3BzB{B3BRB)BzB3B\B  B33BBBǮBBpBB(B{B{B3B\)B)BB)B)B33BfB\)BW
B#BB
=BpBBffB½qBW
B\BBLB{BQBB)BffBęBB8RB BB)BGB8RBBBBB\B  B.B.BBBŽqBBkB
=BBLBfB\BuBBQBQBȳ3B.BuBQBBqBaHBBB#BRB¨BŸRB.B
=BRBBBǮB8RBBQB33B#BpB.BB{BB#BǮBqB)B(B\)BqB.BB
BaHBBBB{BaHB8RBB\BLB(B(BW
BBGBŞBB=qB8RBpB  BBB\)B8RBfBGBQB
B{BBaHB.BuBRBRBaHBBGBuBB(BBpB{B33BzB33BBBRBqB{B3B=B#B=B  BB3BuBBBRB.BBaHBLBkB{BqBGBzB8RBQB#B{BGB
BffBBB(B BffBB(B}{BBB
=BBpB  B=qBBB
B=qBBqBBBBkBBBBBqB{B3BfB
B
B\BGBB\B\)BBǮBBǮB(B  B3BRBGBzB8RBBǮB
B#B\B)B=BLB
BB
=BuB{BB=BkB BB.B\B\B
BGB33BBBB=qB\)BW
B.BffB
B8RB3B
=B
=BBBGBpB33BB\BB#BHBzBzBBB33BB  BQB)BBzBffB BkB\BBBGB
B
B=BBBB£B=BGBģB  BW
BBÀ BQB̀ BBQB
=BzBBѳ3B  B8RBǮBBqBĊ=Bǳ3BRB\BzBB#B\BzB{BzBB#BffB)BǮBBBB͊=BB.BBqB33B=qBBB.BW
B  BQBaHBkBB BBBLBB#B{B33B.B)B{B=qBkBB3BB{BB\B33BfBBB33BkBB  BBqB BHBRBB(BLB3B=qB\)BBzBGBB#B{B)B3B3BǮBqBffBB¨BB=qB  BBLB
B\)B{BB8RBLBffBffBffBB.B=qB{BaHBGBLB³3BÀ BBB  B\BBB=qBLB33BW
BBBBW
BBB\BBBRBBBW
B{BRBfB\BB8RBBuBBaHBuBzB|BBxBHBQBaHBffBBBǮBBzB33BǮB#BfBBQBBƮBB33BBB=BfBW
BBBBffBB8RB\BkB=BBfBǸRBfBBkB¸RBGB=qBuB\BkBB)B\B\B{B#BzB#BW
BffB
BqB8RB.B\)B(B
=BQBzBB
=B33B=qBqBB\BB{B8RBBBLBqBHB.BBGB\BRB\)BBW
B=qBBB\BW
B BB\BBpB
B8RBzBBBBLBzBBBBBkB=qBBGBffBHB8RB#Bď\BkB
BB  B#B=qBÏ\BW
BpB\)B.BzBpBBfBzBBqB.BBRB  BpB=qBBBzBBǮBB\BB#BBzB\)B33BBaHBfB=BBaHB=BQBBGBB)BqBHB#B{BBBǮBBBBB{BBBBBBBBBfBBLB.BBBqBǮBfBGBBBGBzBBHBB  BW
BBBffBBB3BB.BQBB.BpBB8RB  B B#BBBGBB{BB
=BBBQBB\BBaHBB B33B=qBffBuB(BRBBB=B)B(BBW
BB=qBB8RBGB.BBpB#BB33BqBBQBǮB)B
B.BBpBfB8RBB#BkBLB)BLBffB(B=BfBHBBBB\B)B33B8RBBB  BǮBQB=qB.BBBBB.B\BB\)BBBzBaHB
=BzBffBLBGB\)BkBBĔ{B#BLB(BB.BBΨBBHBfBpBϔ{B\BB\)BfBBBpBBGBW
BBGBaHB=qBQB3BǮBpBGB=BBBpB)B=BBW
B3B®B¨B3B{BW
BLBB{BRBQB{BB.BãBBpBaHB(BBB{B#BB3BBaHBLBBGBLBfBBB{BkBpBBW
B̽qBpBBνqBӏ\BQBGBfBB#B)BȽqB.B{B8RBW
Bڀ BB  BffB؊=BǮBݞB#BBfBB\)BW
B8RBʽqB£BGB\)BffBB  BQB{BB\B#BB33BBBHBBBQBGBBGBqBBBǮBBB\B\B{B8RBW
BBBBfBB#BBpBBGBB.BuBBBBBB#BBB{BqBW
BkB.BqB#B\BzBaHB33B33BRBLBBB.BkBBpBB BQB=qB\B=BfB{BkBǮBpB=BGB
BB=qBffBBpB33BaHBB BGB=qBBRB{B
BB=BB
B)B\B#B  BQBGBBffBBfBǮB#B3BBBRBB#BB  BBW
BW
BkBB\BpBRB
BB#B(BRB)BBBǮBBB)B.B33BqB=BaHBǮBzB3B=B3BBzBB33B B33B(B
BffBGB BBBB{BBRBW
BfB\B  BQBLBBîB\)BBaHB{B¨BĀ BfBffB33B)BBuBǮBBBW
BB)BB8RBǸRBBBƨBLBBB.B
BBB\B)B{B  BLB{BB{B(B B{BBBB
=B BBpBBB.BW
BQBBBpBB.BBBLB\)B\)BǮBBuB{BuBpBRBB8RBBBBfB  B B
=B
=BB  B(BBLB\B{B  BuB8RBď\B.B  B8RBLBaHBB8RBfB{BB)BW
BQB\BuB\)BĸRBîBzBǮB=qBÊ=B33BB
B\B\)BBBpB8RB33BB.BB{BfBBBfB)BBzB3BBBkBB\)BuBaHBGBBpBǮBaHB{BaHB.BB
B{B
B\)BuB=qB)BuBHB.B  B\B.BBHBW
BBBqBW
B\)BkBBBBHB  B8RB=qB3BaHBBBB33BB33B#B
=BQBϳ3B#BΣB=qBffB8RB͞BB=qBffBzB͊=B
BfB(B{BBBW
BW
BBQBB̙Bɳ3B8RB  BBΨB(BGB{BB\BBaHBBBzBzBaHB)BzBB)BBBGBBĳ3B{BǮBǙBQB33BBŔ{B33B33BŊ=BpB\)B\B B\BB)B¸RBfBBǮBB\BW
B{BuBHB=qB
B\BW
B=qBB
BΣBzB
=BBҔ{BѽqBHBѣB\)BLBHBB=qBBգBffB֨BֽqBGBBBGBڮBBB8RBkBB=qBaHBBBB̀ BBHBfBkBBBzB=qBpB
=B#BzBBǮBQBǮB(BaHBB3BGBýqBBǊ=B#B
=Bŀ BB33BHBkBGBɞBʏ\BGB33BHB
BȅB)B  BaHBBBʅBʸRBBBBB̏\BB̨B̸RB\B{BLBӣBҨB׳3BׅB
=B33BBٙBBB߽qB\B.BqBQBB=qB33BfB
=B{BHBGBQBBB)BBBBqB3BqB\B=qBBqBffBLB.B޸RBW
BzBpB\)B{BW
B  BB B
BǮBqBaHBߞB\BQBkBRBzB.B
B܏\B{BB BBqBQBHB.B.B#B BB.BLBqBǮBBBݮBaHBBB=qBǮBfB{BمBB׀ B.BpB֊=BըB֙BֽqBB׏\BؽqBس3BB)BԀ BBB8RBBfBϙBB(B.BBGBW
BffBkBB{BʮB͏\BBBˀ B\BĞBĸRBB{BϞBBBәBHBGBB͞BҽqBΣBBLB(BǮBǮBGBBB˸RB#BͨBЮBGBǮBϔ{B.B̸RBB͙BʣB(BQBBB(BB33Bъ=BW
BBϏ\B\BzBʨBǏ\BǮBLBuBɸRBBQB=qBǊ=B=qBuBkBƏ\B
=BƅBƣBBzB=qB33BzB\B
BpBBBBGBaHBýqBŊ=BBBkBuBB3B33B.B(BBBBW
BBBfBffBŏ\BW
BBBǔ{B#BǽqBǞBų3BuBHB BGB
=BBBBaHBBBBLBB
BW
BǨBB
=BGBB#BqB
B\BLB=B  BkBBGBB
B B\B{BBB\)B{B{BB{B3BqBpBGBB3BǮB3BW
BBBB
BBfBQBLB)BRB{BǮBfBffBW
BB3B{B(BBpBBLBGBLB33BB=qB(B{B
=B\BLBBqB(B3B.BBW
BBBB=B#BRBBBB\BBaHBkBBB3BB.B.BB#BB)B\)BpBBzBqB=BBBBuBuB  BBBBBBQBqBǮB\BBpBaHBBB
B
BuBaHB3BfB(B=B=BB BffBBuB)BaHB
=BBB(BBB\B3BHB(BBfB33B\B=BQBBB\B8RB
=BuBkBӀ Bֳ3BffBuBីB{BBRBB=BBffB
=BW
BLB#BB  B(BQBuBBHB B=qBkBBW
BBRBBBBBBBffBB=qBuB虚B33BkBB{BGBBzB3B=BW
B=B΀ BǮB\)BBǮBͽqB8RB̅B
BzB=qB(B8RB33BRBLBGB)B
=BfB{B=B(BB#BBzB33BfB8RBQBŅB
BHB
=BB8RBfB\)B(BB{B{Bʏ\BBBW
Bǳ3B͏\B£BBB{B3B.B{B{B)BŅBBB\B.B=qBLBó3BzB\BfBBB{BB BBB
=B)B)B\BȨBșBǽqBpBBfB
BŔ{Bŀ BpBQBBW
BBBzB=qB\BHBBBBuBǮB
=BBBBB\)B®BB{Bų3BfBB8RB)B\B(B
BB#B˳3B
BaHBȀ B(BfBBW
BaHBˣBBB£B{BHBB\BW
BLBffBB  B
B BBkB.BBfBBQBBB
=BøRB{BǮBBffBBB33B=qBBQBBBQB BBȊ=BB\BfBB B\BBkBGBBkBBǮB\BB=BzBHB\BkBBBBffBHBffB BqBRBBRB\)B B#BÀ B  BƸRBŅBW
BƔ{B{B
=BBĊ=BpB BBBffBzBƏ\BkBaHB8RB=qB̞B33B33B  B
BGBBBBffBGB8RBB
BffBB\B\BǮB BzBHBǏ\BƣBBʮBBB8RBB  BzBBBRB\BQBLBRBBBǮBB  B  BRBBGBLBÀ BkBB{B{BkBBGBHBQBW
BBBkBBHB
=BBqBuBuB.B{BBqBBBBBBBǊ=BB)B
=BW
BBĞB{BƊ=B{BǮBfB¨BǊ=B
Bȳ3B{BBaHBBBÏ\B\BBǏ\BBƸRBuBʨB{B͔{BBBpBʽqB33BfBBHBaHBȊ=BQBŅBB\)BQBŞBHBLBkBBBqB8RBǮBHB
=BLBW
B{B33B
BkBBBB=qBB#B=qB
BBǮB{BGB{B{B)B
=B
=BBffBB{B{BQBuBpBB{BaHB8RB)BB=B33BuB(BBBB\)BfB{B\)B\BB
B
Bǳ3BGB#BBkB\)BuBǮBB\BBĸRBkB=B=qBGB®BW
B\BfBď\BBãBBB(B
=BffB=BLB  BaHB B Bó3B.BB=qB.B  BîBkBBBRB(B8RB{BHBB=qBB#BHBBBBBRBBaHB
=BB.BBBBaHBQBW
B3B
B8RBuBBW
BGBBzBLBBǮBBy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AzApAGAîA£AŅAffAAAGA33ApAAAÅAîA(AQAzA  AAHA\AffAǙAHAGAApAǅA
A
AǙA
=AGAzAHAA{AAzAAGA33AAAA{A\ARARA  A\AA(A(A33AAQAAAAA=qAA33AzA
=AzA(A{AģAîAGA  A{A{A
AĸRAHAGA{AŮAƣA=qAQAzAA
=ApA
AAA  AQA=qAffAʣAʏ\AAQA=qA(AAGAAzAzApAəAɮA33AGAA{AɮAHAHAAɮA=qAA
=AAəAAGAřAzA\)A\)AAGAQAʸRAQAˮA33AHAHAȏ\A{AƸRAAApA  AǮA=qAA  A\)A£AAGAffAŮAǮA33AzAzAɮAɅA33AAɅAǮAGAəA\)AffAAƣA{AzAǅA  AffApAzA(AQAAQAzAʏ\AAHAA˙AA
ApA(A{A
A=qA̸RA̸RAAʸRAzAHA33A
=A33AA33A
=A33AA33A33AA\)A˙A˅AGA
=AA33AAHAǙAffA(A=qAŮAAffAzAzA
AA
=A  AffAffAȣA
ApAffA  AÅA
=ApAHA{AƣAƏ\AA(A  AɮAAAHAǮA=qAȸRAQAȏ\AģA33Aď\A  AA\)AzAA
=A\)A{A\)AHAA  AʸRAˮApA
A̸RẠApA  AQA{AA
A
AA˅ApAˮA˙AˮAffAAAffAffAzAAȀ\AHApA
A
A
AA͙AAAAAGAGAffApA33AAAHAQȀ\AffȀ\A̸RẠȀ\AffA=qAQAffA{A=qA{A{A{A  A˅A
Aʏ\AȣAA
A{ApAȸRAGAzAffAzAA=qA˙AA=qA̸RAzA̸RAHȀ\A33AͅȀ\AAʣAAʏ\AHAAA33A33A
AAffAA=qApA  A{A  AApAA  AQApAA
=AͮA̸RAHAA̸RAAGA̸RA
=A
=A̸RAHAA
=AAHA33AGA͙ApA33AGA\)AApA\)ApAͅA͙A̸RA  AGAGA
=AAHAAHAǙA=qAʸRA33A=qAQAGAA
A  AəAəAAʣA\)AGA\)ApA˅A˅AɮAA  A33AHA  A˙A=qAɮAHA(A
=AGAA{AQA=qAʣAAAApA
A  A(Ȁ\AHA33AGA͙A
AA͙ApApA\)A\)A\)A
=AAHAAAA
=AHAHA{A\)AʣAˮȀ\AzAAẠẠAA
=A33ApAͮA33AͅAGAAA  AAffAɮApAzA
=AA{AȣAɮAʸRẠA\)AHA33AGA  AApA\)A͙A
AA=qA{A(AAzAθRA{A
=A=qAApAGApA  AθRAHAAGApAAυAGAAzAAθRAAΏ\AAAApAͅAffA\)AAHAA(AAθRAͅApA
=A(AHA
AAθRAϮA33AGAffA{A=qAzȀ\AAzA
=ẠA=qA=qA(A=qAˮAAzA(ApAɮA
ApAGAAQAȏ\A{AɅAəAzA  AɅAHA\)AAȏ\Aʏ\ApAȏ\AƣAQA\)AA{AəAʣAffAHAA{AɮA33AGA\)AȣApApA  AəAAAȣAffAffAA{AʣA33AA\)AˮA
A
A=qȀ\AAApA
=AAA
=AHAʸRA
=AʸRAQAɅAɅAHAA{A=qA=qAHAAʣAAAʏ\A=qA(A
A{AffAɮA  ApAȸRAQAȣAAffAffAAHAȣAzA=qAȏ\ApAffApAHA\)AɮAAAɅApAffAAřA=qA
AQA
AAffAģA\)ApA
AQAřAffA{AƣA
AǙAǅA
AƣAǙA  A(A
AA=qAQAA\)AffAƏ\AffApAƣAGAȏ\AAAɮAɮAAGApAɮAɅAȏ\Aȏ\AQAffA  AAǙAAGAǅAŮAȣAGApAəAAffA\)AA33AȸRAA{AffA=qA(AA
=A
=AAAA  ApA
=AƣAGAA  AŅAA=qAAŅAA33ApAĸRA\)AřAAŅA  A{AGA33A33AA  AŅAApA  AŅAApA
AAzAffAAGAA
AAƣA\)AǮA
AAǮA=qAȏ\AzAȸRAffAzAffAȣAȏ\AȸRAȣAȣAAȸRAQAǙApAǅAƏ\AGAƸRAAGAAA=qA{AƣA\)AĸRAzAĸRAǙAAGAǅA33AA
=AffAApAAAQA{A  AŮApAŅAGA
=AHAģAď\A(AGAAAA{AHAÙAAQAAA(AGApAŅA\)AQAA(A=qA(Aď\AîA33AĸRAAHA\)A
=A33AAĸRAď\AApAQA=qAffAƣAzA(A{A=qAǮAȸRAffAffAAȸRAȏ\Aȏ\AzA{A
AAǮAǅAǅA  A=qAAA=qAAAA  AA
AzAƏ\A=qAŮA  AŮA
AA  AA  A(AŅA
AffAAHAAAGA33AA33AAƣAzA(AƏ\A(A\)AAApApAGA33AA33AAÙARA  A(AzA  ApAffA33AAîAAA=qAŮA
A  AffAŮA
AAzAĸRAHA
AAď\AffA
=A
AƏ\A\)AǙA{AffAȏ\A
AAƸRAzApA(AffAȏ\A33AȸRAA
=AQAffA{AzAȣAȏ\AAǙAAAHA=qAQAAAAGApAǙA=qA=qAffAHAǮAŅAAGAHA  A\ApAQA\)A
=AAQAApAAGAA  AA
A\AHA£AApA
A(AA  Aď\AAģAGAĸRA=qAĸRAŮAƣAA=qA(AAGAQAA(AAA  A=qAAÙAģAŅA  AŅA33AHAA\)AQA=qA=qAffA(AA  A\)AAƸRAAGAAzAǮAA(A
AAQAȣAɅApA
A\)AɮA
AɮAɅApAəA(A(A=qA=qA{A=qAQAQA
AAAzAǙAA33AffAA33A
=AGA
=AɮAɮA{AAɅApA\)A  A
=A=qA33A33AAGAHAAƸRA=qAǮA
=A{AAʏ\Aʏ\AAApA  A{AAʣAA
=AHA(A
AɮAA(AʣAʸRA
=AGAAHAHAHAA˅A{A˙AGA33AHAHAHA33AʸRAAAGA
A
AA{A(A  A
AAAˮAˮAˮAˮA˅AA(A=qAʣAAGAɅAəAHAGAGA̸RA{AApA{AɅA\)ApAQA
AGA(AzA=qAAAAHAȸRAQA
=A\)A33ApA(AƣAʸRAAGAʸRA{A{A=qA=qẠA=qA{A  AffȀ\A
AHAQAǮAA
=A{AAGA
AQAzAA33A33A͙AHA
=A\)A\)AHA˅AApA˙AA
A˅AˮA=qA̸RAzA(Ȁ\AzA̸RAHẠA̸RȀ\A\)AQAA˅ẠA
AˮAAA33AAGA̸RAGAGAGA
=AGA=qAA\)AʣA˅AəAHAŮApA(AAĸRAîA\)A
=AAA
=AA33A  Aȏ\A\)AffAŮAAAAȏ\ApA  AȀ\AA
=AffA  AQApA\AffA(AAA
AƏ\ApA=qAGApAAͅA͙A{A
=AzAAGAGAHȀ\A(A{AzẠAzAAA˙A˅A̸RAɅẠA(AƣAzAA\)AGA33AHAƣAQApAzAA33AHA{AA
=A  AȸRAA=qA=qAAAƣAAA
=AAĸRAGAffA=qAHAȏ\A=qA\)AffA
=AəAzAʏ\A=qAAƸRAAffAAGAffAɮAʣA\)AA{AʣA(ApAǮAǮAǅAQAffAAŮAzA\)AffAAɮA33A33AAAA
ApAˮA(AAˮA{Ȁ\ẠAA33A\)A=qA  A(A=qAΣAΣA(AA{A(AGAA(AzAAGAʏ\AffA(AʣA33A
ApA(A{Aȏ\A{A{AŅA{AǙAAA{AffAAɮA(AQA=qA(A(AzAA
=AAffA=qAffAA\)AA\A=qA(AAǙAzA{AAHAQA\)AGApA33AəAAʏ\AˮAAʏ\AApA33AǅA  AffApAəAɅAGA
=AA\)AA{A=qAAʣA=qAGAzAɮA=qA\)AGA
=Aʏ\A=qA{A  ApA̸RA=qA(AzȀ\AAffAA
=AAHAͅAQA˅ApAGApA\)AAffAʸRAʏ\AGAAʏ\AʸRAzA
=A=qA{AzAʸRAAəA
AffAAAffAGApAˮAA\)A(A
A=qA
=A  AQA{AȣAA
A
A
=AGAAGApA33AAQAʣA  A(A33A{A{A  A=qAAA(Aȏ\AAHAȸRAAA(A(AǮA
AA
AA(AffAAAAHAA  A\)A
A
AǙAǮAApAǮAzAȸRA=qA{A  A  A  AǮAzA̸RAƣAAAɮAA
=AA  AʸRA˙A=qAAA
AAəA
=A
AGAGAAHA  AA
A
A  A(AGA(A=qA  AAAAQAffAȣAǮAȣA\)A33AA
=AHAAAAȸRAȣA33AHAzA  AQAȏ\AȸRAȸRAȣAffAzA=qA
A  A{A{A{A{AǙApA
ApAǙA
AAǅApAGA
=AƸRAƏ\AQA=qA=qAffAQAAffA
A=qAQA
A(AzAA=qA{AŮA{AŅAHAĸRAHAAAřA
AŮAAAGAÅA  A  AA
AQAzAîAAA33A\A33ApA  ApA¸RAAAAAHAGAAzAģAAÅA{A¸RA\)AÙApA
A\)A
A
A  AA
A
AApAÅApA\)AÅAÅAÅAGAHA
=AHAA¸RA(AffAAAAGAGA33AAAARAAAAARAzAApAAAA{AA\)AA\AQA=qAAzA(AA\A(A33AAzAAffARAffAQA(A
AA\)AARApAA\A\A{AA  AA
AA=qApA\)AAQA
=A=qApA
A  AA(ARAAHARA
A  A33AAAQARAAA  AA
=ARAGA{AAAA33A
AAHAA=qApAA
=A
=AA  AHAAA\)A{AA=qA(AffAA\AARA\)AAAAAA\)AAHAzA{AAApAA(A\AAAGA\ARAGAA\)A  A{A{ARAffAQAQAzAQA\A
=AA\)AAA=qAzAAA\)AApA
A(AzApAzAARAffARAA
=AGA
AA33A{AHA(A(AQAQA  AAA\)A
=AAzA=qAQAQA=qAQAffAffAffA{A  A{A
AAAAAAAAApApApApAGA\)AGA
=AGA
=A
=AAA
=A
=AHAHAAARAHAA
=AHAHAHAHAffAA33A33A
=AAHARAHAAApAffAzA33AAA(AffARA33A\)AQAAA¸RA\)AAffAApA
=A
=A33AAAA33AAHA\)AA  A  AA33AAHARAGAARAHARA\A\AQA(AffAzAQAQA=qA  A{A(A(A{A{A
A(A=qA
AAA=qAQA
A  A  AQAApAAAAffA{AAHA33A
=AARAzAHA\A  A=qARAA33AA
AA{AA(AApA=qAAAffA(ARA\)AAAARApAGAA
A
AQAÅAGAGAAA  AQA(ApAÅApAGAHAHAffAAAA£AAA  AAAApAAAA\A{A\A=qA(AffA=qAffA=qA=qA
AA(AzAQAffA\AffAffA  A=qA{A(A  A\)ApAQAzAzAAAQA\AAAAffA\A\A\A\A33A{AAApAAAAAAAAAA\)ApAffA  A(A=qAzA33A
A
=ApAA¸RAA\)AGAîAď\Aď\AHAď\A{ApAGAffAffA\A£A£AAA{A£AAffA(AA\)A{AzAQAffAA{A  A{AzA\)A\AAffAA\)A
=AA\AARAAAAApAzAAAAAAApAAAARARAAA\)ApAAA\AQAAAQA{ApAffA\A33ApA  A(AAA=qAAGAGAAAA33A\)AGA33AA  AA33AAAAQAAzA=qA{ApAHAAAAGA33A
AffAAAA33A33AGApA
AAQApAAAAAGA\)AAAzAAAGA
=AzA(A  A{A(A(AA\ARApAAHAA\ARAAA  A(A\AA{AGA33AHA
=AffA\)AA{AQAffAAAGAzAGAA  AA
AHARA\AAHA\A
=AAffAQAzA\AA
A(A(A¸RA\)A
=AGApA
A
AGA\A(AQAQA  AA
A=qAAffAffAA
=A=qAAffA  A(ARAAA=qA(AAA{A\)AAGAffARApA\)AAffA\AzAA=qAQAzAzAA=qAAAHAAA
AAffAAQA33ARAAAAGARA  A{A\A33AA(A
AQAAA  AA(ARA
A(A(A  A
AzA
A  A=qApA
A=qA
ARAGAAAA{AQAAffA\AGAARA=qA
AAAGAAzA\AA
=A\A\A\)A{AAHA33AGA(A
=AzA\)A  A=qA(ARAAAQA
A{AAA33AA
=AGAA\)AGA\)AApAQA=qA
=AA\A\AffAA  AffARA=qAGA=qA(AA
A(A  AAAAAAffA\AAHA33AA\)AA{AzAGApA¸RA33AîA£AGA{AQAA{A(ApA{A{AffAď\AŮA=qAHAA
A=qAGA  A  AA{A  A\AQA
ARApAAÅApApAÙA
=A\A¸RApAîAHA{AA{AGA  AzA
=A  AAA  AApAA=qAAffAffA
=AHAA
=ApA{AAHA\)AHAAA\AGAHA\AA=qAffAGAA(AAAAAAGAAQA
=AGAAAA(AQAzAAHA33A33AGApA33AGAGA33AAîApApAQA33AzA¸RAģAď\AAQAÙA=qApAQA{AîAA
A
AQAģAAAĸRAAHAA
=A\)AŅA\)AAAAAAffAAAA(AA(AAA{AA
=AAŅA\AAď\A  AQA33AGAHAAzA  A=qA  A{AGApA=qAffAA\A\A\AA
AAApAAGAffA=qA{AA
AA\ARApA{AA
=AA
AAÅAGAGAÅAA{AģAģAffA=qAÙA33A33A{A=qA
AffA\)AffAAHAA=qAzAHA  A¸RAzAAAGA=qAĸRA{A(A  A  AffA  A
AzAzAAAAAGA{AffAAA\AAA\A
=A\A\)A=qAffAAQAÙAģA33AŅAAzA  A  AÅA=qA{A\A\AzAA  AffAAAÅA{AQAAƣAA{AŮAffAAÅApA\)AÙAffAÅA\)AAApA
AA\)A
=A
=ApAA
=AffA{AAA  A
AAAA
AzA{AA  AAA
AA(A\A{A
AApAAGA{A(AffAAGARAffA{A=qA33A33AffAAA
=AA  A
AAA{A{A(AApAApAAA{AA
=AGApAA
A(AffAQAQA=qAAAAGA33A\A\AGAA=qA=qA{A{AAAGAffAQA=qA  A  AAAAGAA\)AffApA
=AARA{AAA\A33AAA(A
ApAAA
A
ARAHAAAQAAffAAQAzAffA(AAAA
=AAAzAffAA\)A{A=qARAA\AA\)ApA
A\AAA\AA{A\AHAA=qAHA{AAAAQA=qAGA33A=qA  A\A\A\AHAAAAAAA  A  AA33AA33AAQAAA
AAAffAAzA
AAGApAzA\A\A
AGA(AGA(AA(A(A{A
A
AAAHA(AHAffA{AApA=qAffAA=qAHAA\ARAA
AGAA\A\AAAAAGA  A\)AAAA33AffAA{AAAAA=qA{A(AA
AA33AAA33AGA
A
=A
=A\AA\AHA\AAQA(A=qA{AAAA
AAffAffAzAQAHA=qAffA=qA\)AzA
=ARA  A
=AGA
=A(AffAA  AQAQAAAAApA
=AQAApAAzARAA\AAHAAAQAA  A\)AQA=qAHARAA(A33ARAA=qAzA(AzAHAAQA  AAAAAA{AQA\AAA33AAA=qA\)A33A
AAAAAQAAGAA\)A33A(A  AzAHA\AAA
A{A{AffAAA\)AA
=AQA{A(ARARApA  A=qAA=qA\)AQAzAGA\)A
AA
=AA\)AA\)AA(A(A=qAGARAAA  AAAA\AAA\AHAAAA\AAGA\)AAAffAA(AHAA
AAffARAGARAAGA\)AAAAAAAAffA(A33A
AAÙAAAzAHAQA(AffA  A  AQA£A¸RA(A{A{A{A
A=qA(ARA
=A
=AHARAGA\)A  AAAAAA\A=qA\AzAAA\)A{AHAAA
=AApA
AAAARA\)A
=AGAQAAAAAHA
A33AAHAA
ARAzA(AA=qA=qAQA33AA
A
AAApAGAAHAHAAA
AA
AQAA  AA\ARAGAHAARAffARAffARA\)AAAAAffA=qAA\A
=A
AAApA(AA{AAQAzAffAffA33A
=AGAAGAA33ARAApAAA  AA
A  AQAzAAA(AAA(AffAAQAzA  AA
AHAffAAAQA(AzAAGA\AAAGAffAA
AQAzARA
=AApAAGApA(A=qAffAffAA(A=qAA33A\)AAA{AHAAAAAA
=AAAAffARAAA\)AAAAffAzA{ARAHA=qAffAA  A=qAGAAAGAApAApA
A{AQAffAHAAAGA\)A
=AAApAAffAQA{A
=ApA(AHAA
=AGA\)AGAzARAHA\AzA
=ApAAAQAQAQAA  A{AAAAAQAA(AAQAffAA(AzAGA33A33AAAAAAAAApAAď\A=qAHAffAď\A
=AQAîA33AÅAA(A{AzAQA33A\A{AA\A33AffA{AQA
AAA  AAAAA¸RAA33AHAffAA
=AHAHA\AAA(A\)A\)AAQAAAffA\A
=AApAAzA=qAHA  ApAAGAA  AQAAGA  AA\)AAAA(ARApA=qA  AAAzAA
AA\)AA=qApA33ARA
ARA33A{ARA(A(A{AQAA
AA\A(A
A=qAffAAAApAAAA\)A{AA33AffAAApAQAAA\AAA=qAAGAHAAAGAAA=qAAHAAAzARAA33AAQAAAffA(AffAAHAQA{AAA=qA=qAA\)AzAApAHAGAA
AA\A\)A
A33AzA\A(A
AAzA\A\A\A\AAGAAA=qAzA(AGA33AApAAffA=qAAAAAAAA\AzAffAA=qA=qA
AAA  A
AHAAGAA{AAAAAA(A
=A
=A33A
A{AGA
AAffAHA\AApA\AHAQAzA(AAAA\)A\A\)AGA  AQA
=A
=ARAApAA\AffA\AApA£AHAHApA(AffApA\)A33AQA  ApAAffAď\Aď\A=qAAAAAÙAGAAAffA
AA33AGA
=AAAGA
=A33AffA  AAGAA\)A
AGAAA
A{AQA\AzAffA
AAQAA(A
A=qAQA{A=qAQA(ARA{AGApA\)ApAA33AAApAzA\AffAQA
=AQAffAzAAA{A
ARAARA\)A  AzAA33A33A\)A(AAApA
A  A
AffAAARARAA  AAAQA33AA(A33AA(AzApARAGARAA
AAA=qARAAAApAAffAAA\)AAARA
A
AzA  ApAA
=AGA(A
AAAA\)AAGAAHAGAGApA=qA  A{AHA33AHAQApA(AAHARAGARA\AffA
=A  AGA
ARA
A
AA\AQAA  A\)AAAApA=qAAA
AGAffAzAffA=qA(AA33AGAŅAHA(A¸RAîApAÙAAHAA33A
=AApAAAHApAGAQA33AAA\)AA  AAAAAAQA
=AAQApAAGA  A
=AAApA
=A=qAAA=qAAAHA=qAQAA=qA
AGARA{A  AAGAAA
=A\)A(A  AAAGA\)ApAzA  AA\)AAHA=qA
ApAGAGAAAAGAA33AApAGA
=AAHAAHAAAAA33AAffAGAA\AAHA(AA
ARA
=A
A(AA\)A  AQA\)A  AA33AAQAGAAA=qA=qARAHARAQA33AA  AAHAA
A(AAAARA\AA\)AzAHA(AAHA\AHA33AA33A(AAffAA=qAzA(A33A\A{AA\A  ApAGAA\)A  AffAA33A\A{AA33AGA
=ARA33AARA(AHAA\)AffAffAHA\)AQAGA(A\AAGAzA  A(AGA33AzAzAAA
AHA\A33AzAA=qAA\AA=qAffA
=ApA33A
AAApApAAGAHAA(AAA
AA
AAARA
A=qAApAHAHAA{AA
=ARA33AApA\A  AQAHAAAA
=AzAzA{A=qAQAzAAGAA  AŅAŅAŅAřA\)AřAGA
=AAAffAzA  ApAAHA£A£AAÅA\)AGAď\AîApA
=AAGAA=qApA33AffApA33A=qAîAQAîAîAîA\)A{AA(AGAÙA
AffA\)AffA33AGAGA33A
A\AAÙA(AA33A\AHAAHAHAA\AA{A
=AQAHAA
A
=AA\)AGA(A\)A(AAGApAÅApAÅAAAHA\A\AApAGA\)AGAA¸RAAA=qA\)A
=A(A{A=qAffAzA(AApA(AAHAA\)AAzAA=qAffAAAAAGA\AA  ApAA
=AA=qA\A\A
AA=qAA=qAHA33ApAAffARA  AAA(AA\AAAffAAA  AGAzARA
A  AA{A  AAA\)A
AAAAQApAGApAHA  AAA{A
=AA
AzAHAHA
AHAApAA\AA{AAA33A(AA
A
AA  ARARARApApAA=qAHA33A\AARAHApARAAHARA=qAA\)A\)A33ARAA(AzAffAzAQAAAffA=qA\A{AHAAffAA\)ARA\)AGAAzA  ApA(AffAQAffA33A(AAA  AGAA
AARA
A33AA{A\AAARA
=AQAA=qA\AffA\)AA  ApA
=A\)AQA{AA=qAApAffAA(A\A  A(AAAHAA  AHA33AA(A(AGAAAA{AA  AGAA
=AA\AAzAA\AAHAQA  AA
A=qAAzAA{AAA33AA\)AAAAA33AA{AffAAffAAAHAHAA(AA{AAAQAA(ApA\AAGA
ARA{A=qA
=A
=AQA  AA{AA=qA(AzAAffA
A  AA  A\)AGA(A{A\A\A
ARAAAAQAA  A33AAGA  A\ApApAffA
=AAA\)AA\)AA=qAAzA
=A
=AAA{A\A  AGAAGA(AA  A(AA
A\A
AAGA\AA\AHA
AAffA\AHAA
=AGA{A=qAHAAAQAAARA(AGA  A\)A
AGAAAffAAffA
=AzA  AQAAAGA(AARAGAA  A=qA
AA\)AGAGAAARAAA  AzAA{AARARAffA=qA
A  A\)AA33AAAQAAAzA33AAAA
AffApA\)A
A33AAAA\)AHAAARAffA{A=qA=qAzAAzAApAAAffAffA
=A
AAAAAAAAAA33A=qA
ARA(A\A=qAA\A(A\AffAA33AAzA
AA
=AAHAHAA
A(A
AffAARAAffA=qAAA
=AAAA  ApAA
=A(A  AGA  ARAAAAAffA=qAzAAAHAARAA(AAA
AA\AGA(A(AAAGAA(A=qApA\)AAA=qA=qAHAzA(AHA33A=qA
A(AHA
A\AGAAAA{A=qAffA  AAARAzApAAAAQAffAAGAHAAQAzAAAAAHAffAA=qA33A  A\AGA=qA
AAApAA{AA
=A=qAHAAAffA
A
AAAffAA(AffA{AQA
AARAAAAAA(A{A
A\A  ARAffApAGApAAAAA\AA=qAHA\)AAzA  A(A  AffAAAAQAffARAAHAA{AA  AQA\)ApAQA\A33AA33AA{ApAAGAQAGAAffARAHA33ApA
=AAzAAA=qApAAHAA33AGAAAAA(A33A  AA
=AGAA\)AA{AA
AA(AAA{A{AzA{AQAGAA  AAAQA  AzAA{AGA{A{A\)A
A33AA  A  AQAAAGA(ApAA(AAAHA(AGAA{A\ApAAAA  AzA  A(ApAAA{AGA(A  AGA33A  AAAAAAAAHAA{AAAAAARAAA  AA  A{A
AAAQAAAAffA
AARAzAAzAAffAAAAAffAAAApAQApAGAAA
=AQAQAHAGARA\)AAQAA33AzAAA\AARA  AA\A
=A\AGAAAGA33A=qAQAffA(A\)A  A{AQAQAA¸RAAAAHAzA(AGA33A=qAzA\)AApAA=qAffAzAAA33AAApAAHA33AAAAHAHA(AHAffA=qApAAAApA
=AA\)AA
=ARA=qA=qA{A
A33AA33A  A
AffAffAHAAffAA  AffApAAA=qAAAARAAAGAAA\)AAAAA{A(A  AAHA\)AAHAA\)ApA=qAÙAGAGAAÅAA  AffA
A
A
A\)AffA\)AApA(A(AAQAApAAAA33AHAffAAQAAApA=qAGAAAA=qA{AAAHAApApAHA
=AHAAGARAAffA
AAGA  AAAA
AGAAHAAAHA  A  AAGARAffAffA
=AGAAHARAzAAAAA\AAA=qAApAA¸RAAA=qAAA33AîAQAîAîA(A
A33A\)A  A  AAAîAA
AHAAA\AA
A\)AzA\)AQA=qA=qAA33AA
ARAApAA=qA33ARAQAAzA{A{AffAQA  ARAARAA
A  A(AA{ARAGAQA{A\AA=qA\AA
AAAAAAApA=qA\ARAAQAGA\)AAQAzAAAGAHAQAA\)AApApAA\)A
A
A=qA(A
=AAARAGA\)AA33A{AQApAffAQA
AA(AAAApApA
A(AHAGA\A\)AAA\)AAAA33A=qAA\)A33AAAA=qAA\A  A
AAAApAAzAGA=qAA
=AzAA\)AGAA\AA
ARAAAQAA{AGAA\AzAAARAffA\)ApA33AA\)ApA\)AAAzA\)ApAA
=AAAA  AA(A=qA\A
AzAA
=A  AzAGAAAAQAHA33AAffAffAA  AA\AARAzAAA
=AA\A  AAAA
AQAHA33A
=A
=ARARAApAAGAAAAARA33AAA
=AA=qARAAAAffAAAA(A
=A\)ARAAzAA{A
=AffAAAHARARA=qAffAAAAQAA=qA\)AAAzA33ARAffAQA
A=qAQA\A\A
=A\)AAA  AAHA(AAAAAAAffAA{AA
A
=AQAA
A  AzAzA  AAAQA=qAzAffAAAAAzAAA=qA(AQA\)A\)A  AA(A  AAAAHA\)AA
AAAA  AHAAAffAGAA{A\AA=qAAAAAA\)AA\AHAGA(AAA\)A33AApA\)A33AGAGA33A33AzAA
AAHAAA(AA  A=qA\AAAAHA\AGA
AA
AApAffAAQAA\)A  AAffAQA\AQAGAApAAA33A\A\)AGAAARAQAAAHAffA
=A  A\AA=qARAffApAAA(A\A
=AAAA33AGAAffA(A
AA{AA=qA\AzA33A(AQARA\)A  ARAAA=qAGA33AGAAGApA33AAAGAAAAARARAAQAA\AAAffAApAA
=A{AAAAzARAA\AA\A(AHApARA{A\)A{A{AA33AQA\ApAHAAA(A\)AzAGAAzA\)A
=AA=qA\A
=A
A{AHA33AAAA
=ApA\ARAGAApAAffAA
=A\)A
=AGAA{A  A=qAHAAAAQAA\)AGAAAzAffAAffA  A33AAAAA  AARA\)AAffApA
=ApAAffARApA=qA33AAHA=qARAAQA
AGAAHA\)A\AA
=AAffA33AHARAAAA  AHA  AAAAAGA
=AAzAHAAAA33AAAAAAA{AAHA  A{AA=qA\)AAAA{AAAHARAAAGA33AARAA=qA  ARARAAAQA\AAffA=qAA  A
AAApA\)AA
=A\)AAzAQAAA
=AARAzAffAGAGAGA
AzA{AAAA=qAAffAffA=qARA
=AzAAAAAffAHAffAAAQAA
A  AA\)ARA(AA(AA
A\)AAAffAHAzAAAA\)AAffAHA33A\)A
A=qARAHA(AA  A\A
=AGA
=AQAA\)AA\A\AAGAA33AffAA  AGAA=qA
AA  AA=qAGA33ApAAHAzA
=AAA33ARAAHAA  A{AGA\A(A33AGA\AGAAHAGARAAA
=A
=A\AAAffA
A{A
=AAAA{AAAAzA\ARAAzAA33AAAzAffA  AzAzApA\ApAAAA\A\)ARAAAHA
=AGA
=A\AARA(A33AAzAHAAGApAApAffA\AzAffAHA
A
=ApAA
AzARA
=AHA(AAffAApApAAHAAzA=qAffA
=AARARAAGAHARA(AffA\ApAA  AAAAffA
A{AffA\A(AGA  A(A
=AffA{A\A(A33AA\)AAzA=qA(A\AA(AAAA{AA(A\)AAzA=qA(AAÅAÅAÅAAAQAAAzA  AA  AAAAGA=qAHA
=ApA(AAA33AAHARAQAAApAzAAffAHAA  AAzA\)AffAzA  A(AĸRA(AA  ApAAApAAAď\AffA
AffA(A33AA
AA33A\)AA{AHA=qApA=qAffAAAGAAzAAARA33AÅAAGAAA=qAÅApAÙAAHAHA\A{A
=A33A\A
A=qA33AAGAAARAGA{A(A=qAAAÅAGAHA{AGAARAAAAAHAGAAHAzA
=AzA¸RA  AQA\A\)A  A{AA(AAA{A¸RA{AAHAAA(AAÙA{A\)AAGA(A¸RApAÙApAzA{AGAAzA(A\AAGAAAAAA=qA\AAAzAA
=A
=A\A
A=qAAzA\AAAQApAAGAAA
A=qA=qAffAAAA{A(AffA¸RA¸RA(A{A(A
AAAApA(AAAffA{A\A\A\)A\AQA
=AAAAA33A\)AA33A  A
AA(AA(AGA\AffAffAARARA=qA{AGA{A  AAApA
=AQAAzA\)A
A
A  AffAHAAHAGAAA\)A{A\ApA(AAffAQAHAHA¸RApA(AAAAGA
=AŮApAApAřAŅA
A  AGAQAŅAAGA\)A\)ApAAď\AzAffAď\A
=A33AHAAîA33AÅAAHA\)ApAApA  A{A£AA(AAAzAAffAA\AHAAGA
A\A¸RA
=A£ApAHA{AAAA\AA
A33A\AQAAffApAAAA=qA\)A=qA{A\AQAGA\)A(AA
=A{AAA(A{A
A  AAAA\A=qA  A=qA\AA33AApAA=qAQA£AHAîAA\)AAA(AAAď\AĸRAģAAffA=qAîAA\)AîA{ApAGA
=AAHAQA{A{AAAA
AHAA  A  ApA\AffAAffAA\A  A=qAffAQAQARAGAGA=qARA
A\)AQARARA  A
AAAAApAA
A\)AAA=qA(AAQAAAA  A(A=qAAHA{AffA£AAAGAApA  AA33A\)A\)AGAAGAGAHAAģAď\AģAAAĸRAQA33AA33AA  AGAģA=qAģA
AÙAÅAAÅAGAzA
AQA
AAzA\)A=qA¸RA  A
A
=A33A{A\AA(AAAAHA(AAffARA33AAAAA  A
AGA\A\A\)AAARAAGAHAQAAAA  AAAGA33AAQAHA
A{A=qA
A=qAHAHAA
=AGAǙA
AzA33A(A(A33AəAɮAəA\)A\)AəAAGAGAȸRAȸRAHAGAAɮApAAȣAǮAřAHAAŅApAA{AÙAA
=A£AA  A  A\A\A
AA=qAA=qAApAA\A\A
=A33A{A(AAApAAAQA=qA
ApAAQAA33AARAAAAA
=AAAA  AzA\)AffA
=AAA
AQAQAzAAǅA(AAəAɮAGAʣA{A33AǙAQAA33A{A{AApA
=AəAAƸRAGAAǅAǙA{A\)AA(AzA{ApAQAƣAƣAƣAƣAA
AA=qA  A
=A33A  AŮAffAQAA{AzA¸RA{A
=AAÙAQA{AAffA33AGA\)AģAA  AAApA=qAffAîAHA(A=qApApAffAA\A\)A  A
=AHAA
=AHAA\AAĸRAA33A  ApAAřApAAQAzAzAƏ\AQAAHAƸRAAGAGA
=A
=AHAHAAzAffAAģAzA
=A33A{A
A
A{AA{AHAƏ\A=qAA
=AffAA(AQAƏ\AA  A¸RA\A\)A£AÙAGAHA  A33A\A(AA\A
A{AAAAAAHAAAA=qA\A=qAffAAQAzA=qA\A{ARA
ARAAAAffAffAA
A{AAQA\)AzAAAAA  AAGA33ApA(A=qAHAAA(AAApAAA=qAAGAGAAGA(AAA\A
AQAffA
AffA{ApAffAGAA
=A  A(AAHAHA
=AA33A
A=qAA
AffA\ApAA(AAA  AAGAffAA\)A33A
ARAA
A33AAGAGA
A33AAA  AAffAHA{AHAA
AHAA\)A
A
=AA  A
AzAHAAAA
A(AzAAA{AA(AAGAA
=AHA
=AzA{A\)AAAARAA  AApAAzAGA=qARAA(AHA
ARA
=A
AAAApAAAzA33AARA33A  AA{AQA  AAA\)AAAAAAHAGAA(AAGA=qA\A  A  A
=AffAHAHARAHAAAA=qA
AffA(A  AffApA=qAHAA(A=qAAAHAAAA{A
=A(A{A
=A
=ApAzAHAAHAffAQAAzAA
=ApA33AARAQAA
=AARAAARAAAHA  AA  A33AAAHAAQAA=qAffAAffAA=qAAA{A(AGAAA
=AzA  AHAA\)A\A
=A\)A\)AAzA=qAA\)AA  A{AA
A{A33AA\A
=AAAAAA
=AA(ApA\)AA=qAGAAAffAA
A  AApA33ARA{A
AQAffAffAffAzA(A{A
AApA
=A=qAA=qA=qA
AAApApA  AGAA
AA
A33AGAAAARAAzAARAQAGAQA(AA\)AA33AAGAAQAffA
AAA
=AffAHAffA\AHAQA33A
A
AGA33A\)AA͙A̸RAA
=A\)AzA(AffAHAQA
=A(AAУA=qA\)AΏ\A
=AΏ\A=qAͅAиRAApA{AAAA
=AAA
=A
=AθRAGAA=qAffAΏ\A
AͅA͙AAGAffAAHAffAAzA=qAHẠAAQA=qA{AffAQAAzA
=AϙAA
=A33AGAAУA(AծApAzAHAA
=AיA
=A
AۮAQAGA=qAޏ\A=qA(A
AGA  AzAԸRApApApAӮAԣA
A{AңA  AQAzAAA\)AԣA(A(A33ApA(AAҸRA(A\)AиRA  ApAиRA  A{ApAA
=A\)AGAңAGAҏ\AңAҏ\AAиRAиRAzAЏ\AApAӮA=qAzAAHA  AHAA33AхA
=ApAA
=AAAffA\)AҸRAңApApA
AHApA  AA
=AAGApA=qA=qAQAAAQAAzAzAffAA{AHAٮAٮA33AffA33A֣AծA\)A  A{AAAA֏\AծAQAQA
A(AҸRA
A
AGA=qA{A
AHAzAυAҸRAӅA
=AQA=qAAzA  AAGAҸRAQAzAԣAAHAA33A{A=qA(AGAQA{AΏ\AυAHAzAAGA\)AAΣA
=A{A\)AυAA{AffApApAffAHAȏ\Aʏ\A(Ȁ\AHAͮAͅAΏ\AθRAυAυAͅAAAA\)AHA\)AHA33A{ApA33AυAυApAΣAA
AAAffAυAЏ\AθRA\)A=qAAHAʏ\ApAQA\)A=qA(AGA=qA˙A33A˙A
AA˅ẠAApAAΏ\A=qAθRAAGAHAΣAΣAAAAAΣAAAAGAA
=AzAGA33A33A33AʸRA
AGA(AAffAHA̸RAAGAffA͙A  AAzAA(ApAHA=qAffAffAzA
A
ApAΏ\Ȁ\AΣAHAA(A\)AхAffA  AAAӅAӮA
AA  AQA(AԸRA=qAAԏ\AՅAAԸRAHAңAQAA(AAAУAA=qAzA
AGA\)A=qAffA  A33AAθRAQA{AυAGA{A
=AAAҏ\AQA=qA{A
AљAљAA{AϙAHA
AA{AA33ApApAHAHAA{AGAQAA͙AΏ\ApAQAAиRAAAAAA  ApAAA
=A33AzAҏ\AQAAӅA{A\)AzAGA
A=qA׮A֏\AAӮA
ApA
A{A(AGA  A  AHA{AӅAAәAУA=qAϙAGA
=AGAffAʣAAffA\)A
=AffA(AQA
AϙA  AϮAffAffAHAхApAAУAυAAGAAɮAzA33AQAA
AHA
=ApA(AAAAΏ\AˮA
=AAȏ\A
=AͮAQAA\)AиRAzAϙA
A=qAAAQAAAϮAУA(AA(AA
A֏\A׮AffAzAA֏\AzAHAԏ\A33AAԸRAԸRA\)AAՙAՙAAָRAAAՙAA
AzA
AffAУA33A  A
AѮAҏ\AffAffAҏ\AA33A
ApA33AHAA33A=qAGAϮAυA
A33A33A=qAQApAHAẠAA
A(AθRApA
AA(A
=ApA
AѮA
ApAAAAиRAЏ\A(A
AAffAA=qApA  AхA\)AҸRAңA\)AҸRA
=Aҏ\AѮAA  AAA
A
A{AQAԏ\AA
ApAԸRApAՅApAՙAՙAңAffAҸRApAӅA
AffA\)A(A{AA  AЏ\AGAzAхA(AҸRAGAϙAϙA\)AиRA(AAA{AffAҸRA\)A
=AӮAGAHAҏ\AQA=qAAѮAA
=AиRA=qA
AHAˮA=qApAəAQA˙A33Ȁ\AAGA=qAΏ\A\)A  AQAffAиRA33ApAѮA(AffAҸRAӮA
=AffAA\)AQA{A=qAҏ\AffAHAӅAԸRApAA(A(AzAQA  AծAAAA
A=qA  AA
=AA
AҸRA  AAӮAQAA{AApAGAA  AHA
AәAхAQAAAҸRAAzAzA33AхA(AAzAffA  AzA\)A  AΏ\AͮAͮA(AΣAffAAGA33AϙApA
=AGAυAAυAυAυAQA  A
A  AA\)AffAҸRAA{A33AҸRAѮA
=AңA
AәAңAѮA(AGA
AϮAA{AУAA\)AQAAA  A=qAAHA֣AffA֣AָRA=qA(AAՅAՙAHAԸRA
AA
A{AHA
A=qA  A
=A֣AGAAԣAAA33A(A\)A\)AffAA=qA{AAӮAAҏ\AхAϮA(AzAGAхA{AңAHAA\)AGAGAQAffAGAA{A\)AͮA{AAхA=qAAԏ\AHApA=qAHAGA33AGAzAApA
=AAԏ\AA\)A33AAA
=AAHA33AQA=qAAGAAָRAffApAQA(AHAA(A(A(ApAיAָRAA؏\AA{AAAffAQAAӮAHAәAծA(AHA\)ApAיA֣AA33AGA  AHA=qA֏\AzAQA  A  AAAffAffAԣApAffAԸRAHAA{AәAHAGA
ApA33AAAϮAGAGA
=A=qA(AHA
=AAzAңAQA(AffAGAԏ\AAҏ\AGAԸRAԏ\A33AҸRAңA33AԸRA  AAAffAAٮAzAGA
AAHAܸRAܸRApAڏ\AڣAۙA33A\)A(AۙAڏ\AA  AיAA
A(AمA=qA
=A\)AAHAAڏ\AٙAA33A\)AA=qAAffA
AAQAAԸRAHA=qAAҏ\AApAӅA
AzA{A=qAAQAӮAQApAԏ\Aԏ\AQApA=qAәA֏\A33AծAffA
A(AffA
AٮA
AۮA{AffA
=A  AzAQA{AQAAمA  AA\)A{AظRA{A=qA؏\AظRAظRAظRAHAAzAָRA=qAأApAGApAٙAQAQAٮA  AAHAAظRAQA{AffA؏\A
A33A(AGAظRAffAQA׮A(AA\)AיA{AApA33A=qAծA
=AӅA33AQAԣA(AAA{AGA=qA{AA33AQAGA
=ApAԣAGAծAzA֏\AAGA֣AׅA
AA֣A33A33AQApAAAԣA  A֏\A֏\A
AffA֣AծApAՙA
A(A{AָRA֣AA
=A
A=qA
ApAzA\)A33AQApA׮A  AAAQA֏\A=qA
A
A֏\AָRA֏\AA\)AA=qAA  A{AzA(AׅAApApA=qApApA{A
A{AԸRApA33AAAԏ\A{A(AӅAGAHAңAzA=qA(A
AѮAљApAљApAѮApAAAиRAиRA(AAAAAA(A
AzAHAHA=qAϙA(AAυA
=AQAA33AzAA  AAAQA33AAЏ\A\)A
A=qA(A{AzAAGAGA{AffAAԸRAAAAԸRAA=qAzAA
AԸRAӮAAҸRAAҏ\AҸRAҏ\Aҏ\AAңAљAхA
AA
A(A
A
AHA
=AңAzAHAQA=qApAУAAθRAϙA{AA(AGA(A{A̸RA̸RAA=qAQAA(A˅AHA  AzAͅAQA33AυAЏ\A=qA\)A=qAA
=A
=AծA
A
AAՙAAָRAGA=qAظRAffAffAQAApA{A\)AzAAҸRA
=AЏ\A(AθRA\)AAGA
A\)A׮AA=qAԣAՙAиRApAA33AQAͮA=qAffA{AƸRAƏ\A33AϮA͙A̸RA  AffA  AffAͅAͮA(AAΏ\A=qA
AffA33AϙAGAAͅAͅAHAzAθRA  AQAЏ\A{AϮAϙA\)ApA33A
=AAAGAAQA
AffAHAzA  A  AȸRAȸRAffA\)AȣA
AA33AQAƣA
=AǅAffA\)A(ApAυAGAAAHAHAׅA
AffAәAffAҸRAҏ\ApAAA؏\A
AיA֣A=qAՙAGAAԸRAAљAA
AAϙA  A
=AffAApAхAAϙAAϙA\)A{A
=AHAffA\)AA=qAA33AAѮAAңA
AхA\)AхAҸRA(AAzAffA˙A
=AA
=AGAffAA  A=qAAA͙AzAͮAA
AA  AzAAυA{AAиRAGAGA
AAθRAΏ\AffAGAAA
AzAGA(AԸRA
=AGApAAAffA
AָRAHAGA
=AA(AAffA
ApA\)AA
AәAAӮA\)A33A֣A֣AָRAA(AՅAAGAApA  A33AHAzAҸRA(A  A\)AQA
A\)A(A=qA=qAȣAȣAǮA  AAAď\A\AA  AAAA\AApA33A=qAGA\A  A
ApAA\AGA{A=qAffAA33A\A{ARA33AA33A{AffA
AffAHAHA\)AQAQA\AGAAA  AA
=AGAHA  A(A=qAffAAAA{ApA{A  AǮAzAAřAřAffA£AĸRAGA\A
AA\)ApAģA
Aȏ\AQAŮA33A  AHAŅAď\A\)AA£AA33AA{A  AHAƏ\Aʏ\AAǅA\)AA(AAAď\AŅA\A\)AǮAÙA  AŅAQA33A33AAAAřAA
AAŮA  A\)AGA
A̸RA=qAHAffA
Aҏ\Aԏ\A\)AՅAAAAڣA
AA
AffAA
=AܣAHAGA֏\ApAمAffAGA=qAӮAָRAAAȸRA(AθRAAAzAA\)A33AיAA  AffAѮAQAҸRAәA
=AԣAffAAәA{A֣AGAAGAҏ\AӮAGA\)AθRA(A
AA{AffA(A  AA(A=qAͅA̸RAẠAA33AGAffAΏ\A(A(A(A͙AΣA
A͙AGA\)AAͮA
AA  AиRA\)AA\)AхAA33A{A  Aڏ\AQA
AمAٮA(Aڏ\AAۮAzAQAGA
=AGAA
AAѮAAzA\)AAAיAGA
=AAҏ\AՙAQA=qA  AA͙AAϙA{AGAϮAffAЏ\AA
A  Aԏ\A(AAQAәA(A\)AAA{AAӅAffA=qAхAυA
AAA(AAHAHA
=A{AQA\)AAУAffAzAHA(AQAA  A\)ApA\)AA{A
AHAУA(AzA\)A؏\A\)AffA  AAٙA  AAAٙAڸRAۮA
=AzA޸RApA޸RA޸RAAޏ\A=qAzA
ApAܣAA  A
AA\)AׅA{ApA
=A{AHAϙAQA
AQAәAQA؏\AAffA
AQAGAA
A
AHAљA=qAԸRA
=AAиRAzAQApA\)AAAA=qAљA
=AиRA{AGA
=AυApAϮAϮA{A  A{AQAиRA\)AA=qAHAәAңAA{AљApA  AHAυAHAA33A
AңA\)A
A
AӮA=qAԸRA33ApAQA֏\ApAzAՅA\)AAAHAAAӮAAϮA
AѮA  AffAHAׅA\)AңAҏ\AΏ\AQA
AGApAA  AA33AGA=qA(AͅA\)A
AHAͮAQAϙAθRA\)A  A=qAA\)AA{A=qAHA
=AHAGA  AңA  ẠAGAˮAAẠAẠA=qAGAͅAAͅAQAQA33AHAͅAAȀ\A(A
AA33AA33AA33AљA=qA(A  AAA{A{AAϙAAGAҏ\AңAҏ\Aҏ\AԸRAAffAAθRAAAAϙAzAϮAGAApApAՙAԸRA
=A{AAA\)ApA  AA33A
A(AЏ\A
AQAzA(AQA
AAA=qA\)AУA{AυAAυAAQAAAGAƸRAA˅ApAffA{AȣAʏ\AA\)A33ApApAA
AЏ\A
AУApA  ApA33AѮAHAЏ\AHAGA33AӮA(Aԏ\AAՙA֣AָRA{AzAԏ\AӅA(A\)A=qAҏ\Aԏ\A{A{AA=qA=qAAӮAAA=qAzAAAՅAHA(AAӅAӮA{AA  A{AApA\)AzAA{A(AAQAGAхApA  AQA=qAQAљA
=AQAA{AA\)A33A  AAљAAAΣA̸RAəAˮA
A\)A{A(AHA33A
AϙA{ApA  A  A(AGA=qAzAGAQAңAzAҸRA{AffAA33A\)AծA  AffA(AAԣA
A  AAffA(AљApAGAzAzA
=AхAA33AHAӅAHAԏ\A
=A33AԸRA(AԣAԸRA=qAԣAQA{A  AԸRA=qA(A
A  AAAffAυAϙAʏ\A{A\)AծAGȀ\AA{ẠAɮAApAA\)A33A  A(AGA(A
=AѮAQAQA{AHAHAHAAApAԣAffA=qAzAԸRA(A  A
AAԏ\AApA\)AQAA\)A{AԣAA
AAׅAיAיAGAمA(AA33ApA(AAAӅA  AA  AffAAffAڣAffAHAיA{AAAAA33AҸRApAҏ\AAAAAиRAGAzA33AQAңA33AGAHAңAAAGA33AԸRAҏ\AAҸRA\)AУAGA{ApAAHAffAΣAQAQAҏ\AϮApA
=AGA=qA=qAԣA=qAхAzA33A  A
=AAA
=AΣAϙA\)AQA(Aҏ\A
AυAхAffAffA  AхAAԸRA  AQA(AApAՙA(AAԸRApAA(AffAԏ\A33AAЏ\AљAѮA\)AAхA33ApAAGA33AAӮAAAָRAՙAA33ApA
=A(AGAיAzAA33A  AәAӮAӅA33AA(AGA͙A33A33AffAffAљApAѮAzAѮAљAAУAAAAљA{AHA  A  AA33AffAA  AңApAҏ\AA
=AApAͮAͮA
=AиRA{AffAHA\)A(Aҏ\AA
=AQA{AϙAQAffA(AиRAЏ\AυAGA=qAA
AϙA
AA
AӮAQA(AԣAԸRA=qA{AӅA\)AΣA{A=qAzA\)AәAծA
A\)AQA\)AӅA(AAA
AffA\)A  AA
=AΏ\AApAffAѮAхAхAϙAϙA{AzA
AA=qẠAAͅAΏ\ApA{AҸRAAAffA
=AAAA  AԸRA
AAAA33AffAأA\)AzAzAՙAָRA  AA֏\AՅApA(AGAҏ\ApAAӮAAGAGAυA͙A(AzAAHA33AиRAϮAGAzA  AAAA{AA=qAѮA=qAzAҸRAҸRA\)A
=AӮApA{AAAӅA{AA
A{AHApA
=AzAHA̸RA33A=qAAΏ\A˅A=qAGAAʸRA
A
=Aʏ\A{A33ApA{A{AУAҏ\AAAAAЏ\A33AGA33AAУAHAϮA(AQAApAAAAЏ\A\)A\)AffA(A
=A
=A33A  AQAHApA  AԣAAGAՅA
A  AՅA  AׅA֣AAQAHAՅA=qA=qAHAGA=qA
=AQA33AHApAffAAQA
=AQA=qAAӅA
ApA(AՅA
=A
A
A
A33AQAԣAAAzAәAѮApAңA
=AΏ\AхAffA33AУA
=AиRAϮApAЏ\AͅA=qApA
AӮA{AҸRAApAA{AԣA\)AAA  A(AA=qA
=A؏\A33A
ApAٮA=qAHAAA
AәAAAHA\)AAأA{AQA{A(A=qA33A33A֏\AָRAָRAHAHAAGAGA֏\A֏\AA  AGAәA(AՙAA  AAzA(AAzAծAAzAGAӮAҸRAҸRAҸRAѮAхA  A  AхAffAиRAЏ\AϙA
AffAϙA33A(AAϮA{A{AA͙ApA\)AA
=AǙA
AA̸RAAУAHAЏ\AA
AA͙AHȀ\A͙AθRA=qAẠA  AA
=AQAAʣAzAffAGA(A33A  AzA
AAԏ\AңA  Aԏ\AzA(A
A
=Aҏ\AҸRA(AѮAA=qAӅAҏ\AA(AA=qAЏ\AљAAffA(AυA
AϙA{AϙAθRApAQAGApAAAAAHAAffAffAAӮA{AӮAzAAQA(Aԏ\AA\)A\)AGAAGAɅAffAffAA(AиRA=qAAAυA\)A33AQAˮAQAAQAɅAʸRAAffAA  AzAffAхA\)AGAQA(A=qAHAHAQAzAAיAA֣AQA֏\A֏\AQAzA{A֏\AHAzA{AAGA
A  A
=AGA  A  AԣAӮA33AA33Aҏ\A(A(AӅA33AHA  A
=AҸRAA=qAHAQAAAAхAиRAAA
A=qAA  A
AҸRA=qAQAҏ\Aҏ\A33A33AGAҏ\ApAυA(AA=qAʸRAA
=AA
ApAAҏ\AzA  AAffAҸRAAљAљAHA33A{AAA\)A=qA33A\)A
A(AָRApA
AffAمAAQA(A܏\A܏\AAܣA܏\AGAٙAAzAڏ\AAffAHA33AffAzA
A33AׅAׅApA  A׮AGAָRAGAApAA(AzAAQAHAA  ApA  AՅAzAQApAzAՙAՅA؏\A
A؏\A֣A\)AQAQA33AЏ\AυAffAHAAA=qA
A  A=qAHA
A(AAхA(AAAzA  A
=A(A  A(AٮA33ApApA
A=qAظRA
=A  AA(AAzAAڸRAۮAۮA  A{A(AffAffAQA  ApApAۙAܸRApAٮAٙA(A=qAٮAffA؏\AffAGA
=A׮AA֏\A  AՅAGAAAHAAGAA=qA
A֏\A{AAGA
A\)AָRA׮A(A׮A33A(A(AA  AHAՅAՙAAԸRA(AӮAA(AԣAffA  AHAӅA{Ȁ\AffA(A֏\AAظRAGA\)ApAQAՅAffA{AzA=qAAGAA
=AׅAיA
AظRA
=AQAۙAA=qAA(AzA{AQAQAۅAA(AQAHAڸRA\)A
=A\)AHA{AAQA
=AمApAHA
AAAיA׮AA=qAA(A\)AՅAA
=AمA=qAffA(A  AA\)AffA=qA(AAffA=qAAffAA  AGA=qA\)AָRA(AAծAծA=qAՙA֣A(AA33ApA
=A
A(AѮAffAAQA\)AffApAҸRA(AHA(AAӮA
=AљAAљA=qAҏ\A33AәAA(AԣA\)AׅAمAAٙAHAAA
AAAAٙAAApAAGAA  A{A؏\AHA
=AHAAHAָRAQAA֣A=qAzA
A
=AHA\)A\)AGA
ApAأAzAA
=AQAAA{A33AHAA
=AѮA  AծAAٮAٙAمAAۅAGAمA
A
=AHA  AծAQAffAAAυAApAzA
ApAAHAϮAHA(A\)A\)Aҏ\A
AAծA{AffA
AQA֣AA
AA(A(A  AzA֣A
AיA{AظRAGAQAיAAָRAA
=AمA\)AA=qAԸRA  AAׅAׅAA{AAיAAظRAAՅA33AGApA
=ApA
=A\)A{AәA=qAҸRAѮAAA{AAУAϙA
A\)AәAΏ\A33A
=A{A{A
A(A{AAA
ApA33A\)A{ApA33AA
AQApAGApA؏\AՅA=qAHAApA
AңA\)AffAԸRAծA{AQAHAA
=AA؏\AHAHAAApAٮAٙAٙAمAAAHAڸRA\)AAAڸRAHA(Aڏ\A(A׮AۙA  A
A33AA
AGAAՙA֣AAңAљApAѮA(AָRAAQAffAָRAAAzAҸRAzAAϮAzAЏ\A  AApAQAθRAAHA{AAϮAԸRApAңA{AծAָRAGAAυAA
=AA{ApAәAA
=AՙAՙA  A=qAzAffAָRAָRA
=AGAAׅA
A  AمAمAHAA{A\)A
=AAAApA
A=qAA
AGAzAAGAHAAAՙA
=AAzAңAՅA=qA֏\AHAAיAApA\)AӮAңAљA
=AAҸRAHAҸRA33AͮA=qAQAQA33Ȁ\A  A33A
=AϮAҏ\AAәAҏ\AҸRAHAAAͮAȀ\A(AGAЏ\AΏ\A
=AffAAzA{A
=A=qAиRA33AΣAϙA  AAљAffAA
AQAՙA
AՅA  A֏\AGA(AffAAAأAأA؏\AzA=qA=qA؏\A׮AGAHA֏\A33AׅA֏\AA؏\AGAA\)AAAڸRAڣA{AٙA  AA(A(AA{ApA؏\AՙA
AԸRA=qAAHAٮAA
=AQAҸRAծApA{A\)AQApAAָRA  AA
=ApAzApAڸRAA(AۅAٮAGAҏ\A
A  AA\)AHA(AQAڸRA=qA\)AffAۮA܏\AܣA=qA
AzA=qA
AA
=A֏\A{AAAffAGAGAڸRAffAzA{A  A  AA{AAٙApAمAA33A\)AA33AzA(A֏\A\)AAAffAظRA
ApAHAAzApAGAٮAۅAA֏\A33A{AAAՅAA
=ApA  AQAӅA33A=qAzAGAҸRAңAӮAׅA=qA{AQAA
=A(A=qAGAԣAzApAAffAA=qAQA
AApAffA  AffAQA\)AHA33AәAA=qApAGA
=A
AffA33AAzAՙAGAffAffA؏\AAGA  A=qAffA=qAمA33AAA
A
=A
=AٮA=qAffAۅA
A(Aڏ\AٙAQA׮AQAٮAffA=qAGAׅA؏\A
=AA\)A=qAAzAAA(A׮AָRAffAzApA=qA  A\)A
=ApAθRA
AQAApAծA(A
A(AAՅAHAzA
A33A{AϙA  AzA\)ApAHAGAHAzAGAAأA33AA33A(AAԣAԏ\A  AffAԸRA\)AծA  A֏\A
=ApA
AQAHAָRAAAffAffA(A
AGA
A  A33A  A
ApAzAָRAA  AיAffAظRAAHA؏\A  AzAAAffA؏\AָRAGAGAθRAA{AQApAՙAffA33A
AAиRA
AHAәAӅAӮA
AAGAffAAЏ\ApAAA\)AffAԸRAAAAzAQA=qA֣A֏\A(A֏\AәAA
=A33A
=AA֏\AQAAGApAGAGAՅAffAHApA  AA؏\AA
A  A{A֏\AיA؏\A(AA؏\AzAffAA֣AA33A(A  AأAAzA=qAzAHA  A(A
AzA=qA(A(AQAAGAAA
=A{AA\)AԣAAׅA֏\AA֏\A\)A
=A(A
AӮA  AӅAA{ApA  A33AٙAمA(AAHA  A\)A
=AQAָRA\)A{AAA\)A
AGAzA=qAA\)AA\)AظRA׮A{A(AffAA  AffAۙAAٙAAHApAٙA\)ApA\)A{A{AٮAAA=qAٙAٙA
A\)A
A(A
=A\)A\)AAA؏\A33AٙAA(A{A{AA(A
A  A
A\)AׅAAHA
=AAHA=qAQA(AGAיAָRAָRAָRA֏\AA֏\A֏\ApA=qA33AGA\)AԸRAԸRAԏ\AAӅAffA
A33AffAGA
AӅAHA\)AиRAΏ\A33AffA
=AиRAѮAffAAHAHAHA\)A  AAәAҏ\AЏ\A
=ApAHAGA=qAԏ\ApAA{A֏\A֣A֣A=qA֣AAApAAٮA\)AظRAQA=qAAיA֏\A
=AGA
=AQAAָRA=qA=qA؏\AظRAأA؏\AՙApAAՙAָRAָRA{AՙAQA֣A  AAՙA{AA{A33AQAA{AQA(A
AӅA{A\)AA\)AGA=qAA
=A33AхAAzA
=AиRA
AQAGAӅAAAHA\)AAHAԏ\A  AЏ\A
A33A  AиRA{ApAΣAA
AAAҸRAAGA
AffAAHAzAzAԸRApAQA\)AAAҏ\ApAԸRA{A=qAA
=A  Aԏ\A33A
=AәAҸRAApA=qA
=AAңAAA\)AAHAGA  ApAՅA(A(A
AӅAҏ\AzA\)A=qA{AϮAAҸRA  A{AQAAAAAAA
=ApAHAzA{AϮAυAΏ\AΏ\A(AͅȀ\AЏ\A  ẠẠA
=ApAzAA=qA\)AA
=AAQA͙AˮA  AθRA\)A=qAθRAAA=qAApAGAծAՙAAGAԸRAՅA33AGAA(AAAәA=qAA
AЏ\AAҸRAҸRAffAҸRAAGA\)A33AϮAAQA33A  AҸRA  AA  AЏ\AͮA̸RAAẠAʸRAȣA=qAQAQAAΏ\ApA̸RA33AͮAиRA  AQAͅAAApAzAAQAЏ\AQAθRAΣAffA(AHAϙAAљA=qAA
AffApAAԏ\AQAffAAҏ\AffA(AA
AffAGAθRAΏ\AAA(Aҏ\A(A\)AApAffA\)AGAѮAѮA=qA
Aҏ\AAffAGAffAԏ\AA
=AAAҏ\A=qAҸRAAffAҏ\AzA(A(AHAңAHApAA\)AУA=qAAQAAУAAHAAиRA(AA(AzA
A\)AQAˮAAHA{A  A(AʣAˮAA
AɅA(A{AGA\)AHȀ\AAẠAAAA
A(AHAAA(AApA
AθRAΏ\AffAHAϙAЏ\AffAQAҏ\AҸRA
AңAA
=AAAA
AAGAHAAҏ\AHAхAA=qAϮAAHAAffA=qAΏ\A{A  AffAҏ\AA(A\)AA
AApAAՙAAQAHApAУAϙApAЏ\AQAљApA  A  AAzAHApAffAAAAffAA=qAϙA
A  A\)A
AAͅAϙAQAQAԏ\Aԏ\AGAӅApAGAԏ\AGAծA
AHA(A  A=qApAAAGA  A֣ApAA
=Aҏ\AzA
AӅA\)ApAӮA=qA=qAzAffAQAӅAGA(A  A=qAQA(A֏\A
=AAzA؏\AأAGA  AffAA{AA
A
ApAAQAҸRA(AЏ\A=qApAљA33AҸRApAHAzAAиRAAЏ\AЏ\AѮA\)AAУAA  AˮAЏ\AGA{AхA(AЏ\A\)AGA(A  Aҏ\AAffAәAGAҏ\A=qAԏ\A
A
AQAՙA
A{A=qA33AӅAӅA
=AApAAAffAңApA
A(AffAԏ\AAAzApAәA(A=qA33AQAAGAՙAՅAGA{AGAәAՙA
AծAծAՙAՙAՙA\)A\)AffAԏ\A=qA{AQAA
AHAљAGAA  A33AAљAхAљA
=AиRAAЏ\A  AAffAAApAGAffA33AzAAΣA(AzAAzA=qAAHA˙A(AA
AffAffA
=AA
AffA=qAЏ\A{AϙAУAffAAGȀ\AzAApApAϮA(AУAHA
=A
=AϙAϙAzAApAЏ\AϙAAυA(AυAAAHAΏ\A{A(AυA(AHAQA
AA(AGA{Aԏ\AәA=qA  AAхAѮAхAGAљA{AAA33ApAQA
=ApAљAzA{A  AAzA\)ApA\)AAGA
=AυAGAAΏ\AΏ\ApAffA=qA  AУAЏ\A
=AϮAA\)AЏ\AA\)A
A  AѮAffA\)A
A  AQAffAԸRAAՅAHAAԏ\A(AApAՅAQAffAA\)AA{A  A  A{A(AՅA
Aԏ\Aԏ\A{AԸRA
=A
=ApAApA
AA{A=qAzA֏\AָRA֏\AAAAHAָRAָRAָRAָRAffAQAzAAzA{A
A=qA{AA  Aҏ\AҸRAzA=qAAffApA33AϮA=qAffApAиRA
AA33AffApAхA{A\)A{A=qAHAAљAAAҏ\AAGAA=qAхAљAHA=qAffAԣAffAHAՅA(AָRA  AA\)A(A؏\AAzAHAA33AQAAA{AمAzA{AA(A
A  AمAծAA(AA؏\A֏\AA=qAAأAՙA(AGA33A=qAAׅAGAA33AׅAffAәAՙAԸRAՅA33AәAәA
ApAӮAAA33AGA
=AHAAиRAHAzAzA
=AAA\)AңAAHAЏ\A33AиRApAA\)AӮAәAAQAԏ\AzA{A(AffAAHAHAԸRA\)AGA33A33AGAAAAA(A(A(A֏\AָRAָRAHAffA=qA֏\AzA֏\AffA=qAՅApA\)AAԣAԸRAzAzAԏ\A=qA  AAHAQA{A(A{AAхA
ApAљA\)A\)AхAљA
AѮAAѮAAAAA
=AHAAиRAУAиRAУAЏ\AAA
A(A=qA(AQA{AQA(A
AϮAυAϮAϙAυAυAA(AzAЏ\AУAQA=qA{A{A  A{AQA{A  AApA33AHAϙAЏ\A=qAGAхAzAffA  AAУAQA=qA  AAѮAхAЏ\AУAffA
AΏ\AAΣAΣAAΏ\ẠAA
=A͙A
=AAffA33AzAzA
AzA  AffA  AϮA\)AA͙AAɮAzA33AHA(ẠA33AGAɅAȣA
=AGAA=qAffA=qA  A  A\)A\)AA\)A=qAʣA
=A˙A
A˙AzA(AGAAQAʏ\A  AAɮApAffA(AAAA(AGA˙AˮAˮApAAffAA
A\)A{AAGAzAхA(A\)AυA{AffA=qAЏ\A{A
ẠA˅A˙A{A\)AA
AA=qAAAGAAͅAȀ\A{A{AA
A=qAAΏ\AΣAGAAAϙAϙAAθRAΏ\AθRAffAQAAͮA
=A=qA˙AGAGA̸RAzAzȀ\A33Aʏ\Aȏ\AŅAĸRAAHA
=AffAϙAQAQAǙAAGA33AθRAA̸RẠAAͮAffAzAffAffAzẠAA˅AHAHAʏ\ApAQA˙AffAAʸRAGA{A{AA(A
AΣAAΏ\AͅAθRAGAAϮA=qA{A(A
=AHAA=qAυA=qA\)AGA
AQAA\)AAθRAAA  A\)A  A=qA{A(AAApAΏ\AzAʏ\AAA=qA\)AAAɮA=qAApA
=AGA{AQA=qA\)A  Ȁ\A\)A(AA  A
AQAHA
=AʸRAAAHA
AQA̸RA˙AQA
=A
=A͙AzAGAQA(A\)AAљAAAA  A{A33ApA
AٮAGAՙAԏ\AffAՙAԏ\AAӮA33AңAzAffAәA
A\)AәA
A33A33AϮAΣA33AθRAΣAzAЏ\AHA  A
A
AϮA  ApA\)AΣAzAΣA
=A͙A  AϙAиRApAA\)A  A(AQA=qAϮA33AʣA(A33A{ApA33AffAȏ\A
=AffAAʏ\A˅A=qAzAAA
AʸRA(A˙AHAȀ\A(A(AAиRAGAхAAхAљAѮA{A
=AA(AzAGAәA  A{A{A  AӅAQApA
AHAzAAәAGAAGAGA=qAAAzAGAхAљA(AA\)AѮA33AQA͙AA
=AzẠA{A33A(Aʏ\AGAAzAȸRA33AA
=AɮAɮA{Aʏ\AɮAHAȣA(A  Aȏ\A{A{AȸRA=qAffA  AHA=qAzA
ApAřAřAAHAAď\AĸRA(A¸RA
AffA
=A\AAA33A(A
A\)ARAAQAAApAzAApAA  AA
AAAA\AA{A\A\)AA{AA33A33A
=A  AAAzAAA
AAAffA  A\AffAGA
=A33A\AAA  AA=qA(AAzARA=qARAAA
AApAApA
AAQAAGA\)AQAA
A  A=qAA
AA(AzA
A\A
=AzA=qA  A=qA\)AGAA{A\A
=AA(AQAA\AA33A  ARAAA  A{A
AAAApAARAGAAA
A  AA=qA\)AAA33AAHAA{AzA{AARAAGAGAffA=qA=qA\AA\AAzAAAA
=A{AQARA(AApAARAA\)A(AAAA33A\AffA\A\)ARAffAzA{AA  A(AA\)AA  AA\)AQA=qA\AAAA{AApA
A{AffA{ApA33A\A=qA\AApAAA\)AAAffA=qA{A  AHAAGApAA=qAA  A(A¸RAŮA{AģA
AffAŅApAzAAQA{A\)AffA\)AAzAA  AAAffAAAAHAzAQAîAÙA(AQA
=AAAAHA(A=qA(AQAGA\)AGARAA
=AAAQAzAAA
=A\)ApAA\AffA\AHAAÅA
=AHA  A\AA=qA\)AAÙA=qA¸RAGApAÙA33A
ApAA(AAƸRA
AGAzAÙAffAffAîA\A(A  AAAHAĸRAA=qAHAǅAAǙAǅAřAAȸRA=qAŮA
=AAAĸRAQA(AA
AAŮAA33A
AȸRAɮAzA
AA  AGA33AAAHAŅAŅA(A{AffAǅAƣAƣA
=A=qAƣA=qA{AƣAffAƣAAƸRAQA=qAzAGAĸRA
=AAHAŮAÙA\)A(AAîA33A  AA\)AffAffA  ARA\A
=ApAQAARApAzA
AQA
AffARA(AARAGAGAffAffA(AQA(AA=qAzAAA
A
ARAGAzAzAAA=qAQAGARAzA=qAApAA  AAHA=qA{A\ARA=qAffA=qAzAAzAAzA
=AGARA\A  AAAffAAHAzA\AHARA33AHARAA(AAA
AAGAAARA\A=qAARAQAQAA\)A=qA\A=qA
AAAGAAA33AAzAA(AGA=qA
=A{AffA=qA(A  AA
=A
A=qAQAGARAAAGAAAAAffA
=AA{A(AzApAA33A
AAA{AGARAA  ApAzAAAQA=qAAApAAA=qAQAAzAQA\AAA{AA(AApA
=AA\ARAGAHAzAAAAAAAA33ARA(A(ApA\)AAAA33AAffAA=qA=qA\AAGA=qA(AzAAAAA  A\AA{ApAffA{ARARAA
AffAA(AffA\)A(AAAA(AffAA33A33AAGAAAA(AARAGApAA{AA(A
=A\)A\)AAHAAA
A  A  AA\A33AA(AÙAA=qA  A  AzA
AQA
=AzAřApAA(AQA\AAAQA
=AAAAGAffAA\AA{A\)AARAAHA(AARA
A=qAQAAAzAĸRAAřAď\A=qAřAĸRAGAģAAA  AQAAffA33AQAzAzAAA
AAÅAď\AřA33AA(AřA
AffA{A{A33A33AȣA{AGAAA
=AHApAAQAřAA(AAAHA  A=qAzAɮA(AffAAAA\)A=qA
AA(Ȁ\A̸RA̸RAGA=qA(AA
A33ApA=qA=qAGAA
AA33A\)ApA  AȸRAȣAǙApAƏ\A
=AǙAǙAǙA=qAɅAGAʣAAApAzAʏ\AA{A  AA\)AAɅAǙAAGAffAGA\)A\)A33AǅApAƣAƸRAGAAǮA=qAǅAŅAzAGAAzAAɮAzA33ApA33AffȀ\AAHA33A33Ȁ\A
=AA
AHAAAɮAɮAffA
=AAQA
=AQA\)A(A(AȸRAGAɮA  AʸRAQAʏ\AɅA{AQAǅAAƣAffA{A\)AAAǙA(AHA  A\)A  AAȣAffA\)AAHA  AɅApAȏ\A=qA=qA=qA  AȣAzAAAAQAzA=qAA=qAȏ\AAAQAGAGAffAAzAď\AǅA\)A\)AʸRA33A{AƸRAHAřA
A(AffAffA\)AǙAƸRAAA{A
A(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       