function Xover_subplot(result_file,ID_file,p,Afs,Mfs)

% funtion that creates a summary plot of all the offsets found for a single
% parameter on a single cruise
%
% input: result_file        .mat file with diff and std generated by the
%                           xover_2ndQC function for a given parameter and
%                           cruise
%        ID_file            .mat file  with the expocode(s) for the
%                           reference cruise(s) that give the offset listed 
%                           in result_file. ID_file is also generated by the 
%                           xover_2ndQC function
%        p                  A number defining which parameter will be
%                           plotted. Defined by run_2QC_toolbox
%        Afs                The fontsize you want to use on the axes
%        Mfs                The fontsize you want to use for the text
%                           written into the figure (mean/weighted mean of
%                           the offsets)
%
% output: a figure
%
% calls xticklabel_rotate.m
%
% Siv Lauvset
% last modified 2015-07-28


load(result_file); load(ID_file);

if size(RESULT(isfinite(RESULT)),2)~=0 % cannot make a figure if there are no Xovers

% sort the reference cruises by their year
yr=RESULT(:,4);
pseudoyr=1989;
ind=find(isnan(yr));
if ~isempty(ind);for i=1:length(ind);yr(ind(i))=pseudoyr+i;end;end;
[yr,ind]=sort(yr); 
RESULT=RESULT(ind,:); 
ID=ID(ind,:);

% remove nans from the results
F=find(~isnan(RESULT(:,1)));
yrs=yr(F);
   
for i=2:length(F)-1
    if yrs(i)==yrs(i-1)
        yrs(i)=yrs(i)+0.5;
    end
    if yrs(i)==yrs(i+1)
        yrs(i+1)=yrs(i+1)+0.5;
    end
end

% % plot the offsets with standard deviations as errorbars
% errorbar(RESULT(F,4),RESULT(F,1),RESULT(F,2),'k.'); hold on
% % add the expocodes as ticklabels on the x-axis
% set(gca,'xlim',[yrs(1)-1 yrs(end)+1],'xtick',yrs);

% plot the offsets with standard deviations as errorbars - bug fixed 2017-03-10: duplicate years
errorbar([1:1:length(F)],RESULT(F,1),RESULT(F,2),'k.'); hold on
% add the expocodes as ticklabels on the x-axis
set(gca,'xlim',[0 length(F)+1],'xtick',(1:1:length(F)));

if length(F)<3;set(gca,'xticklabel',ID(F,:),'fontsize',Afs);
else set(gca,'xticklabel',ID(F,:),'fontsize',Afs);xticklabel_rotate;
end
ylabel('Offset');

% add information about the weighted mean offset
absoffset=abs(RESULT(F,1));

medel=sum(RESULT(F,1)./RESULT(F,2).^2)/sum(1./RESULT(F,2).^2); % weighted mean
smedel=sqrt(1./sum(RESULT(F,2).^-2)); % standard deviation of weighted mean
plot(xlim,[medel medel],'r-');hold on;plot(xlim,[medel-smedel medel-smedel],'r--');hold on;plot(xlim,[medel+smedel medel+smedel],'r--');hold on;
mm=sprintf('Weighted mean of the absolute offset = %3.2f %s %3.2f',medel,char(177),smedel);
% text(yrs(1)+0.5,max(ylim)-(0.55*(max(ylim)-min(ylim))),mm,'fontsize',Mfs,'color','r');
text(0.5,max(ylim)-(0.55*(max(ylim)-min(ylim))),mm,'fontsize',Mfs,'color','r');

% plot the maximum offset limits as reference lines
if p<=10
minlim=[-4 -4 0.99 0.98 0.96 0.98 -0.005 -0.005 0.99 -0.005];
maxlim=[4 4 1.01 1.02 1.04 1.02 0.005 0.005 1.01 0.005];

plot(xlim,[minlim(p) minlim(p)],'-.','linewidth',1,'color',[0.5 0.5 0.5]);hold on
plot(xlim,[maxlim(p) maxlim(p)],'-.','linewidth',1,'color',[0.5 0.5 0.5]);hold on
end

if p==1 | p==2 | p==7 | p==8 | p==10 | p==11 % tco2,alk,sal,ctdsal,pH,theta
    plot(xlim,0,'-','linewidth',1.5,'color',[0 0 0]);hold on
else
    plot(xlim,1,'-','linewidth',1.5,'color',[0 0 0]);hold on
end

% clear the data
clear RESULT ID F MM mm ylim xlim absoffset medel

end
