echo off
rem SIMPLIFIED VERSION FOR PEOPLE WHO HATE DEBUGGING BATCH FILES
rem -----------------------------------------------------------------------------------------------------
rem This process is as automatic as possile but still requires a lot of preparation
rem step 1: change all the set-section variables below
rem step 2: If you don't use the simple.txt script, change the script name in
rem               the process section down at the bottom of this program
rem step 3: run through the first cast manually with SBEDataProc.exe using the same
rem                 steps you use in your script (i.e. simple.txt or nobottles.txt, etc.)
rem             Make sure you select the correct .psu file (from BASE_PSU normally)
rem                 it's a good idea to back up the .psu files in case you mess them up
rem             Make sure all variables under data setup are included for the instrument
rem                package for that cast for each subprogram (derive, wildedit, etc.)
rem            Check that  the directories chosen for data in/data out and the con file
rem                are correct -datcnv reads from raw, all others from process
rem            Say yes to save your changes to the .psu file after each subprogram runs
rem            If you mess up, you have to delete your process files and start over
rem                from datcnv or else the variables won't match
rem step 4: run the batch file to re-run the same cast you just ran manually to reset
rem                all the pointers in the sea-bird configs to the right values
rem            If you change your instrument configuration mid cruise you must run
rem               through that cast manually as well- then run it agin via batch file as above
rem
rem      if a cast has no bottles, and your script errors out on the last (rossum) step it's OK
rem        since there's no bottle data anyway, but the next cast you must restart the script
rem        from the beginning when the seabird warning window pops up
rem -------------------------------------------------------------------------------------------
rem  file: process.bat
rem To run this batch file, command line is:  WinprocessV5 <XXX>
rem   where XXX is the last 3 characters of the cast file.

rem DOS only allows 8 characters in the prefix and this script will add
rem one character to the filename for up and down casts. A typical
rem name for cast 1 would be g303001. This would be cruise lmg0303. If
rem you may have over 99 ctd stations, your cruisename must be 4 characters
rem or less.


rem ***********  SET SECTION- CHANGE FOR EACH CRUISE *********** 

rem Set the 4 letter cruise name for all casts (omit first year digit):
rem LTER wants the name to be l[YY=Year][1 digit Cruise #]
set cruisename=g501

rem set the directory path where the raw data exists from the CTD locally
set rawdir=c:\data\raw

rem set the directory path where  the processed data should go locally
set processdir=c:\data\process

rem set the directory path where  the graphs should go locally
set graphdir=c:\data\graphs

rem set the directory paths where the raw data should be backed up on the network
set rawnetdir=T:\Raw
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Raw

rem set the directory paths where the processed data should be backed up on the network
set processnetdir=T:\Process
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Process

rem set the directory paths where the graphs should be backed up on the network
set graphnetdir=T:\Graphs
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Graphs

rem This is the variable entered after running " winprocess.bat XXX" where XXX is the
rem    last three characters in the cast file name. i.e 001 for the 1st cast, 002 for the 2nd, etc.
set station=%cruisename%%1

rem set the local computer time to pontus's time
echo y | net time \\pontus /set

rem *************** END OF SET SECTION *************************

rem start program output
cls
echo station  name = %station%

rem -------------------------------------------------
choice Copy raw data files for %station% to Network  
if errorlevel 2 goto SkipRBackup
rem  Backup raw data files to network: 
rem  to  \\PONTUS\science\CTD_Data\raw
echo copying raw data...
copy %rawdir%\%station%.* %rawnetdir%
echo Raw data files  copied to the network.
:SkipRBackup

rem --------------------------------------------------------
rem copy con file to process dir and process the data
rem ****************** NOTE****************
rem change batch program and script below if you need to
rem the process.txt script works for most configs
rem it will fail on the rossum program if no bottles are fired
rem but that's the last step so it's OK
rem -----------------------------------------------------------------
echo processing data
echo Coping con file to process directory...
copy %rawdir%\%station%.con %processdir%\%station%.con 
echo Copied con file to process directory
C:\WINDOWS\SBEBatch.exe C:\DATA\SCRIPTS\process.txt %station%
echo wait for seabird programs to finish processing data
pause
rem ---------------------------------------------------------
choice Were Bottles Triped on this cast  
if errorlevel 2 goto SkipBottles
C:\WINDOWS\SBEBatch.exe C:\DATA\SCRIPTS\bottle.txt %station%
echo wait for seabird programs to finish processing data
pause
:SkipBottles
rem ---------------------------------------------------------
choice Print Graphs for this Cast 
if errorlevel 2 goto SkipPlots
C:\WINDOWS\SBEBatch.exe C:\DATA\SCRIPTS\plot.txt %station%
echo wait for seabird programs to finish processing data
pause
:SkipPlots
rem ---------------------------------------------------------
choice Copy processed files to Network
if errorlevel 2 goto SkipPBackup
rem --------------------------------------------------------
rem  Backup processed data files to network: 
rem  to  T:\process
echo Backing Up the Processed Data to the Network
echo copying processed data...
copy %processdir%\%station%.* %processnetdir%
echo copying downtrace data...
copy %processdir%\D%station%.* %processnetdir%
echo copying uptrace data...
copy %processdir%\U%station%.* %processnetdir%
echo copying graphs...
copy %graphdir%\D%station%*.jpg %graphnetdir%
echo Done putting processed  data on network
:SkipPBackup
rem ---------------------------------------------------------
echo Done processing station %station%