echo off
rem ********************************************************
rem ** Greatly simplified version for people who REALLY   **
rem ** hate debugging DOS batch files                     **
rem **                                                    **
rem ** Created by W. Kevin Pedigo during LTER'06          **
rem ** Never change the script.  Only edit where it says  **
rem ** "User Servicable parts"                            **
rem ********************************************************
REM
REM
REM
rem ********************************************************
rem **                                                    **
rem ** USER SERVICEABLE PARTS GO HERE.  AND NOWHERE ELSE  **
rem **                                                    **
rem ********************************************************

set cruisename=G705
set CRUISE=LMG0705

rem ********************************************************
rem **                                                    **
rem **     NO USER SERVICEABLE PARTS BELOW THIS LINE      **
rem **                                                    **
rem ********************************************************

rem set the directory path where the raw data exists from the CTD locally
set rawdir=E:\data\raw\%CRUISE%

rem set the directory path where  the processed data should go locally
set processdir=E:\data\process

rem set the directory path where  the graphs should go locally
set graphdir=E:\data\graphs

rem set the directory paths where the raw data should be backed up on the network
set rawnetdir=T:\Raw
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Raw

rem set the directory paths where the processed data should be backed up on the network
set processnetdir=T:\Process
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Process

rem set the directory paths where the graphs should be backed up on the network
set graphnetdir=T:\Graphs
rem  Above is \\PONTUS\POSEIDON_SHARES_DATA\CTD_DATA\Graphs

rem This is the variable entered after running " winprocess.bat XXX" where XXX is the
rem    last three characters in the cast file name. i.e 001 for the 1st cast, 002 for the 2nd, etc.
set station=%cruisename%%1

rem set the local computer time to pontus's time
echo y | net time \\pontus /set

rem *************** END OF SET SECTION *************************


cls
echo station  name = %station%

rem ********************************************************
rem * Copy raw data to network if not already there,       *
rem * otherwise ask before copying                         *
rem ********************************************************
if not exist %rawnetdir%\%station%.dat goto copy_raw
choice Raw data already on network.  Overwrite
if errorlevel 2 goto SkipRawBackup

:copy_raw
echo Copying raw data to network
copy %rawdir%\%station%.* %rawnetdir% > NUL:  
:SkipRawBackup

rem ********************************************************
rem *  Copy con file to network if not already there,      *
rem *  otherwise ask before copying                        *
rem ********************************************************
if not exist %processnetdir%\%station%.con goto copy_con
choice "CON file already archived.  Overwrite
if errorlevel 2 goto SkipConBackup

:copy_con
echo Copying con file to network
copy %rawdir%\%station%.con %rawnetdir%\%station%.con > NUL: 
copy %rawdir%\%station%.con %processdir%\%station%.con > NUL:
:SkipConBackup

rem ********************************************************
rem * Determine if bottles were tripped, and process       *
rem * accordingly.                                         *
rem *********************************************************
set NOBOTTLES="FALSE"
find /c "1," %rawdir%\%station%.bl > NUL:
if errorlevel 1 set NOBOTTLES="TRUE"
if %NOBOTTLES%=="TRUE" goto SkipBottles
C:\WINDOWS\SBEBatch.exe E:\DATA\SCRIPTS\process_w_bottle.txt %station% %CRUISE%
goto graph_section 

:SkipBottles
C:\Windows\SBEBatch.exe E:\DATA\Scripts\process_no_bottle.txt %station% %CRUISE%

rem ********************************************************
rem *  We always generate graphs, but only sometimes print *
rem ********************************************************
:graph_section
choice Print Graphs for this Cast 
if errorlevel 2 goto SkipPlots
C:\WINDOWS\SBEBatch.exe E:\DATA\SCRIPTS\plot2.txt %station% %CRUISE%
:SkipPlots


rem ********************************************************
rem *  If processed files aren't alreay on the network     *
rem *  go ahead and copy them.  Otherwise ask first        *
rem ********************************************************
:Archive_Processed
if not exist %processnetdir%\%station%.cnv goto copy_process
choice Processed data already exists on the network.  Overwrite
if errorlevel 2 goto SkipPBackup
goto copy_process


:copy_process
echo Backing Up the Processed Data to the Network
echo copying processed data...
copy %processdir%\%station%.* %processnetdir%
echo copying downtrace data...
copy %processdir%\D%station%.* %processnetdir%
echo copying uptrace data...
copy %processdir%\U%station%.* %processnetdir%
echo copying graphs...
copy %graphdir%\*%station%*.jpg %graphnetdir%
echo Done putting processed  data on network


:SkipPBackup
echo Done processing station %station%
:FINIS
