%
% -*-C-*- % this forces emacs to edit in C mode
%
% Atlantis matlab rountine to plot shipboard asciilog data
% at01min1.* or at970923.* files located in the directory
%
% 	linus:/files/linus/data/athena/asciilog/
%
%
%					Sept. 24, 1997
% modified by gherlein 10/18/97                 
%
clear;
warning off;

dir = '/files/linus/data/athena/asciilog/';

% first find today's date for today's logfile knyymmdd.001
% d=datestr(date,2) returns [y m d hr min sec]

% d=datestr(date,2);
% yr = d(7:8);
% mo = d(1:2);
% dy = d(4:5);
%filena = [dir, 'at',d(7:8),d(1:2),d(4:5),'.001'];
%filena = [dir, 'at01min1.001'];

% Enter filename by user 
finp=input('Enter asciilog file name ', 's');
filena = [dir, finp];
disp(['load file ',filena]);
fid = fopen(filena,'r');
if fid == -1 
    disp('No such file');
end

k= 0;
m= 0;
l = 0;
first_row = 0;
time_flag = 0;
index = 0;
xstart = 0.0;
xtmp = 0.0;
shr=0.0;
smn = 0.0;
ssc = 0.0;

% scan through the headers for variable names
for i = 1:50
    line = fgetl(fid);
    if i == 3
	[tmp,count] = sscanf(line,'%*s %d:%d:%d');
	if count == 3
		shr = tmp(1);
		smn = tmp(2);
		ssc = tmp(3);
	else
		shr = 0.0;
		smn = 0.0;
		ssc = 0.0;
	end
	
    end
    if findstr(line,'|') == 4
	index = sscanf(line, '%d|', 1);	
	name = sscanf(line, '%*d| %s %*s');
	% make the name 8 characters long by 
	% adding character '.' at the end
	addnum= 8-length(name);
	if length(name) < 8
	    for j = 1:addnum
	    	T=strcat(name,'.');
		name = T;
	    end
	    tname(index,:) = T;
	else
	    tname(index,:)=name(1:8);
	end
	% replace '_' character by '-'
	for j =1:8
	    if tname(index,j) == '_'
		tname(index,j) = '-';
	    end
	end
    end
    %  end of header and break out
    if strcmp(line,'')  == 1 & i > 8  
        break;
    end
end

% read data lines
while  1
	line = fgetl(fid);
	l = l + 1;
%	if the end of file line = -1
	if line == -1
%		disp(['end of file with num of lines = ', num2str(l)]);
		break;
	end
	if findstr(line,'|') == 4
		index = sscanf(line, '%d|', 1);	
	 	if index == 3
%                       % CTIME id code       
			[tmp,count] = sscanf(line,'%*s %d:%d:%d');
			if count == 3
				time_flag = 1;
				shr=tmp(1);
				smn=tmp(2);
				ssc=tmp(3);
			else
				time_flag = 0;
			end
		elseif index == 12
%                       % IMET id code       
			[tmp,count]=sscanf(line,'%*s %*f %*f %f %*f %*f %f %*f %*f %*f; %f; %f %*f; %f; %f %*f %*f;');
			% set bad data points equal to value -99.9
			if count ~= 6
				tmp=[-99.9,-99.9,-99.9,-99.9,-99.9,-99.9];
			end
			for i=1:6
				var(m+i) = tmp(i);
			end
			varname(m+1,:)='IMET-WSP';
			varname(m+2,:)='IMET-WDR';
			varname(m+3,:)='IMET-BPR';
			varname(m+4,:)='IMET-HUM';
			varname(m+5,:)='IMET-SWR';
			varname(m+6,:)='IMET-PRC';
			m = m+6;
		elseif index == 11 | index == 24 | index == 25 | index == 82 | index == 83  
%                       % single number id codes       
%                       % 11| GYRO
%                       % 24| SSCND
%                       % 25| SSTMP
%                       % 82| GPSPC_CG
%                       % 83| GPSPC_SG
			m = m+1;
			temp = sscanf(line,'%*s %f');
			if temp == ''
				var(m) = -99.9;
			else
				var(m) = temp;
			end
			varname(m,:)= tname(index,:);
		elseif index == 69
			[tmp,count] = sscanf(line,'%*s %f, %f');
			if count ~= 2
				tmp = [-99.9,-99.9];
			end
			for i=1:2
				var(m+i) = tmp(i);
			end
			varname(m+1,:) = 'TRUEWSPD';
			varname(m+2,:) = 'TRUEWDIR';
			m = m + 2;
		end
	elseif strcmp(line,'')  == 1  
		tnumrow = m;
		if first_row == 0
			data = var;
			xstart = shr + smn/60.0 + ssc/3600.0;
			x = xstart;
			xtmp = xstart;
			first_row = 1;
		else
			if time_flag == 1
				% use recorded time
			        xtmp = shr + smn/60.0 + ssc/3600.0;
			elseif time_flag == 0
				% add 1 minute to the time
				xtmp = xtmp + 1/60.0;
			end
			x = [x, xtmp]; 
			data = [data; var];
		end 
		m = 0;
	end	
end
fclose(fid);


% if there is more than 8 variables, plot them with 2 figures

nplot = 1;
nrows(1) = tnumrow;
st(1) = 0;
if  tnumrow >= 5 
	nplot = 2;
	nrows(1) = ceil(tnumrow/2);
	nrows(2) = tnumrow - nrows(1);
	st(1)=0;
	st(2) = nrows(1);
                if ymin == '' & ymax == -99.9
                        % for all -99.9 bad data case
                        ymin = ymax;
                end
                if ymin == ymax
                        dy = 0.05;
                end

end
for i = 1:nplot
	figure(i);
	if i == 1
		set(1,'Position',[15 20 480 700]);
	else
		set(2,'Position',[500 20 480 700]);
	end
	for j = 1:nrows(i) 
		subplot(nrows(i),1,j), plot(x,data(:,st(i)+j));

		ymin=min(data(find(data(:,st(i)+j) > -99.9),st(i)+j)); 
		ymax= max(data(:,st(i)+j));
		dy = (ymax -ymin)/10.0;
                if ymin == '' & ymax == -99.9
                        % for all -99.9 bad data case
                        ymin = ymax;
                end
                if ymin == ymax
                        dy = 0.05;
                end

		set(gca, 'Ylim',[ymin-dy ymax+dy],'Xlim',[floor(min(x)) ceil(max(x))] );
		if nrows(i) <= 7
		    ylabel(varname(st(i)+j,:),'Fontsize',13,'FontName','times');
		else
		    ylabel(varname(st(i)+j,:),'Fontsize',10,'FontName','times');
		end
			
		if j < nrows(i)
			set(gca,'XTick',[]);
	   	end
		if j == 1
		    title(filena, 'Fontsize',20,'FontName','times');
		end
		if j == nrows(i)
		    xlabel('Hours (GMT)','Fontsize',15,'FontName', 'times');
		end
	end
end

