/*
program: rwnodc
reformat data for nodc
*/
#include <stdio.h>
#include <stdlib.h>

FILE	*fpin;

void main (int argc, char *argv[])
{
	double	lat, lon, pr, te, sa, ox;
	int	c, cast, day, hour, ia, min, month, sta, work, year, zz;


	if ((fpin = fopen (argv[1], "r")) == NULL) {
		fprintf (stderr, "usage: rwnodc file\n");
		exit (-1);
	}

	fscanf (fpin, "%*s %d %d %lf %lf %d/%d/%d %*d %d:%d", &sta, &cast,
	    &lat, &lon, &year, &month, &day, &hour, &min);
	while (getc (fpin) != '\n');
	fscanf (fpin, "&zz:%d", &zz);

	fprintf (stdout, "Arlindo Circulation 1998\n");
	fprintf (stdout, "Ship: Baruna Jaya IV, Indonesia\n");
	fprintf (stdout, "Stn: %3d  Cast: %2d\n", sta, cast);
	fprintf (stdout, "Lat: %8.4f  Lon: %8.4f\n", lat, lon);
	fprintf (stdout, "Depth(uncorrected meters): %4d\n", zz);
	fprintf (stdout, "Date(yyyy/mm/dd): %4d/%02d/%02d  GMT: %02d:%02d\n",
	    year, month, day, hour, min);
	fprintf (stdout, "   CTDPR   CTDTE    CTDSA    CTDOX\n");
	fprintf (stdout, "   dbar    ipts-68  pss-78   ml/l\n");

	while (getc (fpin) != '@');
	while (getc (fpin) != '\n');


	/*  loop through data  */
	while (fscanf (fpin, "%lf", &pr) != EOF) {
		fscanf (fpin, "%lf %lf %lf %*f", &te, &sa, &ox);
		fprintf (stdout, "%7.1f   %8.4f %8.4f %6.3f\n", pr, te, sa, ox);
	}
}
