c program: convert.f
c written by K. Levinson  07/96
c the purpose of this program is to:
c     1. divide the blocked (4000) data into logical (80) records
c     2. convert original's ASCII characters into standard ASCII characters
c     3. to maintain the original order of the data, file-wide sequence numbers were generated
      dimension io(3)
      byte array(4000)
      character*80 recin(50)
      character*85 recout
      equivalence(recin,array)
      character*64 filein,fileout
      print *,'enter input file name'
      accept '(a64)',filein
      open(unit=15,file='data/'//filein,status='old',form='formatted')
      open(unit=16,file='dataout/'//filein,status='unknown',
     2 form='formatted')
c read first input record block
      read(15,'(q,4000a1)',iostat=inum) len,(array(i),i=1,len)
      do while(inum.eq.0)
      io(1)=io(1)+1 ! input record counter
c divide input block into logical records
      do j=1,len/80
c process each record by individual byte
      do k=1,80
c convert each original's ASCII character into standard ASCII character
      recin(j)(k:k)=char(ichar(recin(j)(k:k))-128)
      end do
c file-wide sequence numbers
      io(3)=io(3)+1
c move input record into output record area
      recout(1:80)=recin(j)(1:80)
c insert sequence number into output record area
      write(recout(81:85),'(i5)') io(3)
c output record
      write(16,'(a85)') recout
      io(2)=io(2)+1  ! output record counter
      end do
c read next input record block
      read(15,'(q,4000a1)',iostat=inum) len,(array(i),i=1,len)
      end do
c check for error in input data
      if(inum.ne.-1) then
      print *,inum
      print *,'error'
      endif
      print *,'input record block count ',io(1)
      print *,'output logical record count ',io(2)
      end
