      PROGRAM REFORMAT
c
c     This program will read stations headers from stations_list
c     and bottle or CTD data from ALBATROSS-???-nodc.asc and
c     produce files that contain the information from these files
c
c     R. A. Locarnini, OCL/NODC/NOAA, 8 January 2003
c
      integer idat, ibsta, icsta
      integer ista, iday, imon, iyea, ihou, imin, ilat, ilon, isam
c
      real*8 rlat, rlon
      real*8 rhead(15), rdat(12), rbot(30,12), rctd(7)
c
      character*1 clath, clonh
      character*4 cship, ccrid
c
      clath(1:1) = 'S'
      clonh(1:1) = 'W'
      cship(1:4) = '74JC'
      ccrid(1:4) = 'JR40'
c
c     Assigns value for year variable
      iyea = 1999
c
c     Asks what type of data will be processed
    5 write (*,*) 'Enter 1 for Bottle data, 2 for CTD data'
      read (*,*) idat
c
c     Opens file that will contain header information and data
      if ( idat .eq. 1 ) then 
       OPEN ( unit = 9, file = 'albatross.bot', status = 'NEW' )
      elseif ( idat .eq. 2 ) then 
       OPEN ( unit = 9, file = 'albatross.ctd', status = 'NEW' )
      else
       goto 5
      endif
c
c     Opens file with header information
      OPEN ( unit = 10, file = 'stations_list', status = 'OLD' )
c
c     Skips header lines in file stations_list
c
      do 10 i = 1, 14
       read (10,*)
   10 continue
c
c     Starts to read header info from file stations_list
c
   20 read (10,*,end=100) ( rhead(i), i = 1, 15 )
c
      ista = rhead(1)
      iday = rhead(3)
      imon = rhead(4)
      ihou = rhead(5)
      imin = rhead(6)
      ilat = rhead(7)
      ilon = rhead(9)
      isam = rhead(15)
c
c     Writes header information in new file with combined headers and data
      if ( idat .eq. 1 ) then
       write (9,11) cship(1:4), ccrid(1:4), ista, iday, imon, iyea,
     & ihou, imin, ilat, rhead(8), clath(1:1), ilon, rhead(10),
     & clonh(1:1), rhead(14), isam
      elseif ( idat .eq. 2 ) then
       write (9,22) cship(1:4), ccrid(1:4), ista, iday, imon, iyea,
     & ihou, imin, ilat, rhead(8), clath(1:1), ilon, rhead(10),
     & clonh(1:1), rhead(14)
      endif
c
   11 format(A4,1X,A4,I4,1X,2I3,I5,1X,2I2,2(I4,F6.2,A1),F8.1,I3)
   22 format(A4,1X,A4,I4,1X,2I3,I5,1X,2I2,2(I4,F6.2,A1),F8.1)
c
      rlat = (-1.0) * (ilat + rhead(8)/60.)
      rlon = (-1.0) * (ilon + rhead(10)/60.)
c
c     Opens file with bottle or CTD data
c
      if ( idat .eq. 1 ) then
       OPEN ( unit = 11, file = 'ALBATROSS-bot-nodc.asc',
     & status = 'OLD' )
c
       j = 0
c
   30  read (11,*,end=50) ( rdat(i), i = 1, 12 )
       ibsta = rdat(1)
c
       if ( ibsta .eq. ista ) then
        j = j + 1
        do 40 i = 1, 12
         rbot(j,i) = rdat(i)
   40   continue
c
        rdlat = rlat - rdat(2)
        if ( rdlat .lt. 0.0 ) rdlat = rdlat * (-1.0)
        rdlon = rlon - rdat(3)
        if ( rdlon .lt. 0.0 ) rdlon = rdlon * (-1.0)
        if ( rdlat .gt. 0.005 ) then
         write (*,*) rdlat, ' lat diff for stat ', ista 
        endif
        if ( rdlon .gt. 0.005 ) then
         write (*,*) rdlon, ' lon diff for stat ', ista 
        endif
c
       endif
c
       goto 30
c
   50  close (11)
c
       idif = isam - j
       if ( idif .ne. 0 ) then
        write (*,*) idif, ' mismatch in bottles for stat ', ista 
       endif
c
       if ( j .gt. 0 ) then
        do 60 h = j, 1, -1
         ibsta = rbot(h,1)
         write (9,66) ibsta, ( rbot(h,i), i = 2, 12 )
   60   continue
       endif
c
   66  format(I3,2F10.4,9F11.4)
c
      elseif ( idat .eq. 2 ) then
       OPEN ( unit = 11, file = 'ALBATROSS-ctd-nodc.asc',
     & status = 'OLD' )
c
   70  read (11,*,end=80) ( rdat(i), i = 1, 7 )
       ibsta = rdat(1)
c
       if ( ibsta .eq. ista ) then
        write (9,77) ibsta, ( rdat(i), i = 2, 7 )
       endif
c
   77  format(I3,2F10.4,4F11.4)
c
       goto 70
c
   80  close (11)
c
      endif
c
      goto 20
c
  100 close  (9)
      close (10)
c
      stop
c
      end
