#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()
{
	int bndo_count = 0;
	int nodc_count = 0;
	int irpe_count = 0;
	int i, count;
	char str[120], str2[120], *end;
	char tempstr[5];
	FILE *fp1, *fp2, *fp3, *fp4;

	if ((fp1 = fopen("year.med2", "r")) == NULL){
		printf("file year.med2 couldn't be opened\n");
		exit(1);
	}
	if ((fp2 = fopen("bndo.d", "w")) == NULL){
		printf("file bndo.d couldn't be opened\n");
		exit(1);
	}
	if ((fp3 = fopen("nodc.d", "w")) == NULL){
		printf("file nodc.d couldn't be opened\n");
		exit(1);
	}
	if ((fp4 = fopen("irpem.d", "w")) == NULL){
		printf("file irpem.d couldn't be opened\n");
		exit(1);
	}

	while (!feof(fp1)){
		/* get a line - presumably a header will be first */
		fgets(str, 120, fp1);
		strcpy(str2, str, 120);

		tempstr[0]='\0';
		/* get data type - BNDO or NODC or IRPEM */
		strcat(tempstr, str, 4);
		tempstr[4]='\0';

 		/* get the number of profiles field */
		count = strtol(&str[54], &end, 10);

		/*
		printf("\nstr = %s",str);
		printf("tempstr = %s\n",tempstr);
		printf("str2 = %s",str2);
		printf("count = %d\n",count);
		*/
	
		if (!strcmp(tempstr, "BNDO", 4)){ /* if they match */
			bndo_count++; 
			fputs(str, fp2);
			for (i=1; i<=count; i++){
				fgets(str, 120, fp1);
				fputs(str, fp2);
			}
			
		}
		else {
			if (!strcmp(tempstr, "NODC", 4)){ /* if they match */
				nodc_count++;
				fputs(str, fp3);
				for (i=1; i<=count; i++){
					fgets(str, 120, fp1);
					fputs(str, fp3);
				}
			}
			else {
			if (!strcmp(tempstr, "IRPE", 4)){ /* if they match */
				irpe_count++;
				fputs(str, fp4);
				for (i=1; i<=count; i++){
					fgets(str, 120, fp1);
					fputs(str, fp4);
				}
			}
			else{
				if (!feof(fp1)){
					printf("Error in input file - \n");
					printf("\tExpecting nodc or bndo\n");
					exit(-1);
				}
			}
			}

		}
	}

	printf("bndo count = %d\n",bndo_count);
	printf("nodc count = %d\n",nodc_count);
	printf("irpe count = %d\n",irpe_count);

	fclose (fp1);
	fclose (fp2);
	fclose (fp3);
}
