open (INFILE, "ctd.mtr") || die "Can't open ctd.mtr: $!\n";
# Discard first line (labels)
$_ = <INFILE>;
while (<INFILE>) {
  chop;
  split(/\,/);
  $LN              = $_[0];
  $_[1] =~ /^(\d{1,2})\/(\d{1,2})\/(\d\d)/;
  $mo = $1;
  if ($mo < 10) {$mo = "0" . $mo;}
  $da = $2;
  if ($da < 10) {$da = "0" . $mo;}
  $yy = $3;
  $yyyy = "19" . $yy;
  $VisitDate{$LN}       = "$yyyy/$mo/$da";
  $Station{$LN}         = $_[2];
  $Latitude{$LN}        = $_[3];
  $Longitude{$LN}       = $_[4] * -1;      # (Lon is West)
  $_[5] =~ / (\d{1,2})(\:\d\d\:\d\d)/;
  $hr = $1;
  if ($hr < 10) {$hr = "0" . $hr;}
  $BeginCastTime{$LN}   = $hr . $2;
  $Depth{$LN}           = $_[6];
  $FailureCode{$LN}     = $_[7];
  $StationAccept{$LN}   = $_[8];
  $StaAccComments{$LN}  = $_[9];
  $WeatherCode{$LN}     = $_[10];
  $WindSpeed{$LN}       = $_[11];
  $WindDir{$LN}         = $_[12];
  $SwellHt{$LN}         = $_[13];
  $Vessel{$LN}          = $_[14];
  $Vessel{$LN}          =~ s/\"//g;
  $Agency{$LN}          = $_[15];
  $Agency{$LN}          =~ s/\"//g;
  $Comments{$LN}        = $_[16];

  # print $Comments{$LN},"\n";

# "LogNumber","VisitDate","Station","Latitude","Longitude",
# "BeginCastTime","Depth","FailureCode","StationAccept",
# "StationAcceptComments","WeatherCode","WindSpeed","WindDir",
# "SwellHt","Vessel","Agency","Comments"
}
close (INFILE);
open (INFILE, "onemeter.dat") || die "Cannot open onemeter.dat: $!\n";
# Discard first line (labels)
$_ = <INFILE>;
while (<INFILE>) {
  chop;
  split(/\,/);
  $PrevLN = $LN;  
  $LN        = $_[0];
  $DEPTH     = $_[1];
  $SEC       = $_[2];
  $RATE      = $_[3];
  $TEMP      = $_[4];
  $COND      = $_[5];
  $SALIN     = $_[6];
  $OXYCONC   = $_[7];
  $OXYPCTSAT = $_[8];
  $TRANSMIS  = $_[9];
  $pH        = $_[10];
  $DENSITY   = $_[11];

  # "LogNumber","Depth of sample","SECONDS","DESCENTRATE","TEMPERATURE",
  # "CONDUCTIVITY","SALINITY","OXYGEN_MG/L","DO%SATURATION",
  # "TRANSMISSIVITY","pH","DENSITY"

  # Output Section:
  if (!($LN =~ /$PrevLN/)) {
    #Print Header
    $LN2 = $LN;
    $LN2 =~ s/\"//g;
    if ($n++ >= 1) { print "\n";}
    print "ID         STN  DATE       TIME     LAT     LON      BDEP";
    print " VESSEL         AGENCY\n";
    printf "%10s %4d %10s %8s %7.3f %8.3f %4d %-14s %2s\n\n",  
       $LN2, $Station{$LN}, $VisitDate{$LN}, $BeginCastTime{$LN}, 
       $Latitude{$LN}, $Longitude{$LN}, $Depth{$LN},
       $Vessel{$LN}, $Agency{$LN};

    print "DEPTH  SEC    RATE  TEMP   COND   SALIN   OXY    OXYPCT";
    print " TRANSM  pH    DENS\n";
  }
  printf "%5d %6.1f %5.2f %6.2f %6.3f %7.3f %6.2f %7.2f %6.2f %5.2f %7.3f\n",
    $DEPTH, $SEC, $RATE, $TEMP, $COND, $SALIN, $OXYCONC,
    $OXYPCTSAT, $TRANSMIS, $pH, $DENSITY;
}



