#!/usr/bin/perl
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#%                                                                     %
#%             PROGRAM  :  MOM-preview-add-task.pl                     %
#%             CREATOR  :  Mark Gaither                                %
#%       CREATION DATE  :  Fri 17 Nov 1995                             %
#%         DESCRIPTION  :  Preview data to create a MOMspider          %
#%                         instruction file.                           %
#%                                                                     %
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

# flush stdout buffer
$| = 1;

# Print this out no matter what
print "Content-type: text/html\n\n";

if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    # How many bytes are we supposed to receive?
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    
    @pairs = split(/&/, $buffer);
    
    foreach $pair (@pairs)
    {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
    }
}

print <<"HTML";
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HEAD>
<TITLE>MOMspider Intruction Preview</TITLE>
</HEAD>
<BODY>
<H1>MOMspider Instruction Preview</H1>
<HR>
<PRE>
&lt;$in{'boundary'}
  Name $in{'info-struct-name'}
  TopURL $in{'topURL'}
  IndexURL $in{'indexURL'}
  IndexFile $in{'indexfile'}
HTML

if($in{'indextitle'} ne '' &&
   $in{'indextitle'} !~ /^\s*$/) {
  print "  IndexTitle $in{'indextitle'}\n";
}
if($in{'changewindow'} ne '' &&
   $in{'changewindow'} !~ /^\s*$/) {
  print "  ChangeWindow $in{'changewindow'}\n";
}
if($in{'expirewindow'} ne '' &&
   $in{'expirewindow'} !~ /^\s*$/) {
  print "  ExpireWindow $in{'expirewindow'}\n";
}
if($in{'emailaddress'} ne '' &&
   $in{'emailaddress'} !~ /^\s*$/) {
  print "  EmailAddress $in{'emailaddress'}\n";
}
if($in{'emailbroken'} eq 'yes') {
  print "  EmailBroken\n";
}
if($in{'emailredirected'} eq 'yes') {
  print "  EmailRedirected\n";
}
if($in{'emailchanged'} ne '' &&
   $in{'emailchanged'} !~ /^\s*$/) {
  print "  EmailChanged $in{'emailchanged'}\n";
}
if($in{'emailexpired'} ne '' &&
   $in{'emailexpired'} !~ /^\s*$/) {
  print "  EmailExpired $in{'emailexpired'}\n";
}
if($in{'exclude'} ne '' &&
   $in{'exclude'} !~ /^\s*$/) {
  @URLs = split(/\n/,$in{'exclude'});
  foreach $URL (@URLs) {
    print "  Exclude $URL\n";
  }
}

print <<"HTML";
&gt;
</PRE>
<P>
<HR>
<P>If these values are correct, <STRONG>submit</STRONG> your choices.
<P>
<FORM ACTION="/cgi-bin/MOM-add-task.pl" METHOD="POST">
<INPUT NAME="inst-filename" TYPE="hidden" VALUE="$in{'inst-filename'}">
<INPUT NAME="boundary" TYPE="hidden" VALUE="$in{'boundary'}">
<INPUT NAME="info-struct-name" TYPE="hidden" VALUE="$in{'info-struct-name'}">
<INPUT NAME="topURL" TYPE="hidden" VALUE="$in{'topURL'}">
<INPUT NAME="indexURL" TYPE="hidden" VALUE="$in{'indexURL'}">
<INPUT NAME="indexfile" TYPE="hidden" VALUE="$in{'indexfile'}">
<INPUT NAME="indextitle" TYPE="hidden" VALUE="$in{'indextitle'}">
<INPUT NAME="changewindow" TYPE="hidden" VALUE="$in{'changewindow'}">
<INPUT NAME="expirewindow" TYPE="hidden" VALUE="$in{'expirewindow'}">
<INPUT NAME="emailaddress" TYPE="hidden" VALUE="$in{'emailaddress'}">
<INPUT NAME="emailbroken" TYPE="hidden" VALUE="$in{'emailbroken'}">
<INPUT NAME="emailredirected" TYPE="hidden" VALUE="$in{'emailredirected'}">
<INPUT NAME="emailchanged" TYPE="hidden" VALUE="$in{'emailchanged'}">
<INPUT NAME="emailexpired" TYPE="hidden" VALUE="$in{'emailexpired'}">
<INPUT NAME="exclude" TYPE="hidden" VALUE="$in{'exclude'}">
<INPUT TYPE="submit" VALUE="Add Task Directives and Proceed to Next Step">
</FORM>
</BODY>
</HTML>
HTML

exit;
