#!/usr/bin/perl
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#%                                                                     %
#%             PROGRAM  :  MOM-inst.pl                                 %
#%             CREATOR  :  Mark Gaither                                %
#%       CREATION DATE  :  Fri 17 Nov 1995                             %
#%         DESCRIPTION  :  Create a MOMspider Instruction file.        %
#%                                                                     %
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

# flush stdout buffer
$| = 1;

# Print this out no matter what
print "Content-type: text/html\n\n";

if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    # How many bytes are we supposed to receive?
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    
    @pairs = split(/&/, $buffer);
    
    foreach $pair (@pairs)
    {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
    }
}

print <<"HTML";
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HEAD>
<TITLE>MOMspider Traversal Task Directives</TITLE>
</HEAD>
<BODY>
<H1>MOMspider Traversal Task Directives</H1>
<HR>
<FORM ACTION="/cgi-bin/MOM-preview-task.pl" METHOD="POST">
<H2>Required Elements</H2>
<STRONG>Specify boundary of infostructure:</STRONG> 
<INPUT NAME="boundary" TYPE="radio" VALUE="Site"> <EM>Site</EM>
<INPUT NAME="boundary" TYPE="radio" VALUE="Tree"> <EM>Tree</EM>
<INPUT NAME="boundary" TYPE="radio" VALUE="Owner"> <EM>Owner</EM>
<P>
<INPUT NAME="info-struct-name" SIZE="40"> <STRONG>Infostructure Name</STRONG><BR>
<INPUT NAME="topURL" SIZE="40"> <STRONG>Top URL of infostructure to be traversed</STRONG><BR>
<INPUT NAME="indexURL" SIZE="40"> <STRONG>Absolute URL of index document produced</STRONG><BR>
<INPUT NAME="indexfile" SIZE="40"> <STRONG>File name of index file produced</STRONG>

<H2>Optional Elements</H2>
<INPUT NAME="indextitle" SIZE="40"> <STRONG>Title of HTML index document</STRONG><BR>
<INPUT NAME="changewindow" SIZE="3"> <STRONG>Number of days to consider a URL's Last-modified date interesting</STRONG><BR>
<INPUT NAME="expirewindow" SIZE="3"> <STRONG>Number of days to consider a URL's Expires date interesting</STRONG><BR>
<INPUT NAME="emailaddress" SIZE="40"> <STRONG>Send automatic email reponses to</STRONG>
<P>
<STRONG>Email broken link messages?</STRONG> 
<INPUT TYPE="radio" NAME="emailbroken" VALUE="yes"> <EM>Yes</EM>
<INPUT TYPE="radio" NAME="emailbroken" VALUE="no" CHECKED> <EM>No</EM>
<P>
<STRONG>Email redirected link messages?</STRONG> 
<INPUT TYPE="radio" NAME="emailredirected" VALUE="yes"> <EM>Yes</EM>
<INPUT TYPE="radio" NAME="emailredirected" VALUE="no" CHECKED> <EM>No</EM>
<P>
<INPUT NAME="emailchanged" SIZE="3"> <STRONG>Number of days that a test link is considered changed</STRONG><BR>
<INPUT NAME="emailexpired" SIZE="3"> <STRONG>Number of days that a traversed document will expire</STRONG>
<P>
<STRONG>URL prefix(es) to test but not traverse (one per line)</STRONG><BR>
<TEXTAREA ROWS="5" COLS="40" NAME="exclude"></TEXTAREA> 
<P>
<HR>
<P>
<INPUT TYPE="submit" VALUE="Preview Task Directives">
<INPUT NAME="inst-filename" TYPE="hidden" VALUE="$in{'inst-filename'}">
</FORM>
</BODY>
</HTML>
HTML

exit;
