#!/usr/local/bin/perl
#
# web_quote.pl - a script for processing the CGI input from a Quoting
# 				 database form called from a web server.
#
# Copyright (C) 1995 Mike W. Erwin <mikee@outer.net>
# All rights reserved.
#
#
#
#	PURPOSE:		In simple, this script was designed as a gateway on OuterNet's
#					system to provide a link between the webserver and our 
#					stand-alone quoting engine.  This is accomplished by this
#					script by parsing the user's input that was filled out on the
#					web form, and building a "PARAMETER LINE" of options, which is
#					then passed to the quote generating script ("gen_quote.pl").
#					This script is is charge of calling the quote program 
#					directly, but more importantly, is in charge of directing
#					the form of the output, and where to send it.  Our examples
#					include this script and the gen_quote.pl script, which both
#					illustrate the function and capabilities of the CGI backend.
#					The "quote" program, is an merely an application that
#					creates a specific quote based on arguments (either as text
#					or postscript).  Since it can be easily replaced by any such
#					script or program, we are not going to detail its functionality.
#
#	INSTALLATION:	To configure this script, edit all of lines in the next 
#				 	section that have a "#!" as a comment to their immediate
#				 	right.  This script needs to be installed in the binary
#					directory accessible by your web server software.
#					For us, that: "/www/cgi-bin";
#
#
#	USAGE:			This script is called by the web server software when a user
#					hits the "Submit" button found in the "quote_page.html" file
#					after it has been received by a web browser and parsed
#					appropriately. This script will run on any UNIX machine 
#					(or ther OS) that can execute PERL 4 compliant code.
#   
#
#           
############################################################################

############################################################################
#
# Include the forms processing PERL Library.
#
############################################################################

require "/arnav/vishwas/public_html/formgen/formlib.pl";

############################################################################
#
#  Various Startup Variables and constant definitions
#
############################################################################

$| 			= 1;								# Unbuffer STDOUT

$datestr 	= `date '+%m/%d/%y %H:%M:%S'`;		# various date formats to be used with
$logdate    = `date '+%h %d %T 19%y'`;			# logging and reporting functions
$timedate	= `date '+%H%M%S'`;					# Get a time string as well
	
chop ($logdate);								# The next three lines of chopping
chop ($datestr);								# is done to remove the superfluous
chop ($timedate);								# Carriage Returns

$QUOTER = "/arnav/vishwas/public_html/tools";					#! Here's the location of your quote generator
$LOGFILE = "/usr/logs/quote.log";				#! The location of your log file
$QUOTEFILE = "/arnav/vishwas/public_html/tools ";			#! Our quoter uses this file to number quotes
$FAXDIR = "/arnav/vishwas";						#! Where to put Postscript file to be made into g3 files
$QUOTE_GENERATOR = "/arnav/vishwas/public_html/tools/gen_quote.pl"	#! The intermediate quote generator.

############################################################################
#
#  Get the number of the quote that is about to be generated.  We use another
#  script to produce the quote which is called from this script with the
#  appropirate arguments.  This allows us to make the correct log entries
#  at the bottom of this form.
#
############################################################################
$quote_number = `cat "$QUOTEFILE"`;
$quote_number++;
$quote_filename = "\www\cgi-bin\quote_print.${quote_number}";

############################################################################
#
# This section parses through the POST arguments found in various enviornment
# variables detailed in the "quote_page.html" form.  You will notice that
# every environment value mentioned in that file is assigned to a local
# variable by the same name.  I could have used the assoicated $in{}
# variable whereever I use the local variable throughout the code, but
# ease of use and readability I tend to make re-assignments.
#
############################################################################
&GetFormArgs();        # parse arguments passed from FORM (now in %in)
$ENV{PATH_INFO} ne '' && &GetPathArgs($ENV{PATH_INFO});

$delivery			= $in{Delivery_Method};		# This is the popup with the delivery options

$c_customer_num		= $in{c_customer_num};		# This information is specific to our
$account_type		= $in{account_type};		# quoting engine.  These two items are used to pull
												# Address and contact information
												
$fax_number			= $in{fax_number};			# The telephone number of the fax machine to send to

$config_hours		= $in{config_hours};		# most of the following are specific options
$program_hours		= $in{program_hours};		# that the user has selected via the web form.
$consult_hours		= $in{consult_hours};		# Items relevant to OuterNet's business, such as
$postprocess_hours	= $in{postprocess_hours};	# hourly consulting, administration and connection
												# services are passed to this script in the following
$hourly_contract	= $in{hourly_contract};		# variables.  
$sysadmin_contract	= $in{sysadmin_contract};

$dnsps				= $in{dnsps};				# Please note that since our quoter is a living 
$shell				= $in{shell};				# script, it has some fields that are no longer in
$mail_opt			= $in{mail};				# use, as well as some variables with no fields
$fix				= $in{fix};					# found on the form.
$route				= $in{route};
$dialburst			= $in{dialburst};
$dedburst			= $in{dedburst};
$host				= $in{host};
$host_amount		= $in{host_amount};
$domreg				= $in{domreg};
$upgrade			= $in{upgrade};
$ftp				= $in{ftp};
$gopher				= $in{gopher};
$wais				= $in{wais};
$list				= $in{list};
$sysadmin			= $in{sysadmin};
$www				= $in{www};
$webman				= $in{webman};
$webstat			= $in{webstat};
$vsldy				= $in{vsldy};
$vis64dy			= $in{vis64dy};
$vis128dy			= $in{vis128dy};
$source				= $in{source};
$source_amount		= $in{source_amount};
$router_mgmt		= $in{router_mgmt};

$custman_num		= $in{custman_num};
$hardware			= $in{hardware};
$hardware_price		= $in{hardware_price};

$shell_num          = $in{shell_num};
$mail_num           = $in{mail_num};
$fix_num            = $in{fix_num};
$route_num          = $in{route_num};
$dialburst_num      = $in{dialburst_num};
$dedburst_num       = $in{dedburst_num};
$host_num           = $in{host_num};
$domreg_num         = $in{domreg_num};
$upgrade_num        = $in{upgrade_num};
$www_num            = $in{www_num};
$webman_num			= $in{webman_num};
$webstat_num	    = $in{webstat_num};
$dnsps_num          = $in{dnsps_num};
$ftp_num			= $in{ftp_num};
$gopher_num			= $in{gopher_num};
$wais_num			= $in{wais_num};
$list_num			= $in{list_num};
$sysadmin_num		= $in{sysadmin_num};
$vsldy_num			= $in{vsldy_num};
$vis64dy_num		= $in{vis64dy_num};
$vis128dy_num		= $in{vis128dy_num};
$source_num			= $in{source_num};

$mail_address		= $in{mail_address};
$accountnumbers		= $in{accountnumbers};
$billing_cycle		= $in{billing_cycle};
$extra_info			= $in{extra_info};
$extra_price		= $in{extra_price};
$extra_dis			= $in{extra_dis};
$extra_cust			= $in{extra_cust};
$extra_dns			= $in{extra_dns};
$extra_noc			= $in{extra_noc};
$extra_src			= $in{extra_src};

$fax_message_1		= $in{fax_message_1};
$fax_message_2		= $in{fax_message_2};
$fax_message_3		= $in{fax_message_3};
$fax_message_4		= $in{fax_message_4};

$who				= $in{who};

############################################################################
#
# Here we redirect the standard error to the trash.  For debugging purposes
# I will generally send the output to a file with a statement like:
#
# print STDERR "Here where I think the error is: $some $data\n";
#
############################################################################
open (STDERR,"> /dev/null");

############################################################################
# Approprite WEB Header Information
#
############################################################################
print "Content-Type: text/html\n\n\n";

############################################################################
# 
# MAIN
#
# Here's where most of the work gets done in this script. The bulk of the
# processing is done by building up a parameter configuration line, which
# is then passed to the gen_quote.pl script.  This script will pass those
# arguments directly to the quoting engine (in our case a C program called:
# "quote"). The paramter line is stored in the variable "$PARAM_LINE"
# logically enough, with each service scrutinized then appended to the
# running line as the script progresses.
#
# To create your own script, for your own purposes, this is where you will
# need to test for the existence of your services, data, or options. Most 
# everything below is specific to our setup, but can be easily modified for
# other uses, if nothing else, but by example.
#
############################################################################

{
	$PARAM_LINE = "";							# Initialize the parameter line
	
	@accounts = split("#", $account_type);
	$PARAM_LINE .= " -c${c_customer_num}";

	if ($host_amount) {
		$PARAM_LINE .= " -z${host_amount}";
	}
	
	if ($custman_num) {
		$PARAM_LINE .= " -q${custman_num}";
	}
	
	$PARAM_LINE =$PARAM_LINE." -a";
	for ($ct=0; $ct<=$#accounts; $ct++) {						# The main popup that declares 
		if ($accounts[$ct] =~ "No Account") {					# the exact service options
			$account_type = "nacct";							# is parsed within this big "for"
		}														# loop.
		if ($accounts[$ct] =~ "Dynamic SLIP/PPP") {
			$account_type = "sldy";
		}
		if ($accounts[$ct] =~ "Dedicated SLIP/PPP") {
			$account_type = "slde";
		}
		if ($accounts[$ct] =~ "Dynamic 64K ISDN") {
			$account_type = "is64dy";
		}
		if ($accounts[$ct] =~ "Dynamic 128K ISDN") {
			$account_type = "is128dy";
		}
		if ($accounts[$ct] =~ "Network On-Demand 64K ISDN") {
			$account_type = "is64nod";
		}
		if ($accounts[$ct] =~ "Network On-Demand 128K ISDN") {
			$account_type = "is128nod";
		}
		if ($accounts[$ct] =~ "Dedicated 64K ISDN- Single Machine") {
			$account_type = "is64de";
		}
		if ($accounts[$ct] =~ "Dedicated 128K ISDN- Single Machine") {
			$account_type = "is128de";
		}
		if ($accounts[$ct] =~ "Dedicated 64K ISDN- Multiple Machines") {
			$account_type = "is64dem";
		}
		if ($accounts[$ct] =~ "Dedicated 128K ISDN- Multiple Machines") {
			$account_type = "is128dem";
		}
		if ($accounts[$ct] =~ "Dedicated 64K ISDN- Managed Multiple Machines") {
			$account_type = "is64man";
		}
		if ($accounts[$ct] =~ "Dedicated 128K ISDN- Managed Multiple Machines"){
			$account_type = "is128man";
		}
		if ($accounts[$ct] =~ "Dedicated 128K ISDN- Customer Managed") {
			$account_type = "is128cust";
		}
		if ($accounts[$ct] =~ "UUCP Dial-up Account- news/mail") {
			$account_type = "uucp";
		}
		for ($counter=1; $counter <= $accountnumbers; $counter++) {
			$PARAM_LINE .= "$account_type:";
		}
	}
	
	#
	# As you can see, the script does a string append as each service is tested.
	# I use the $bundle variable as a boolean placeholder so that I don't
	# accidently pass a wrong string to the quoter. 
	#
	
	if ($vsldy) {
		for ($ct = 1; $ct <= $vsldy_num; $ct++) {
			$PARAM_LINE .= "vsldy:";
		}
		$bundle = 1;
	}
	if ($vis64dy) {
		for ($ct = 1; $ct <= $vis64dy_num; $ct++) {
			$PARAM_LINE .= "vis64dy:";
		}
		$bundle = 1;
	}
	if ($vis128dy) {
		for ($ct = 1; $ct <= $vis128dy_num; $ct++) {
			$PARAM_LINE .= "vis128dy:";
		}
		$bundle = 1;
	}
	if (($bundle) && ($PARAM_LINE =~ "nacct")) {
		$PARAM_LINE =~ s/nacct\://;
	}

	chop ($PARAM_LINE);					# Get's rid of the extra ":"
	
	#
	# These services are considered "ancillary" by our quoting engine and 
	# are referenced by the "-x" option followed by a string of service
	# options.  The section between the "if {}" builds up that part of
	# the command line.
	#
	if ( $mail_opt || $shell || $fix || $dnsps || $domreg || $upgrade 
	     || $dns || $route || $dialburst || $dedburst || $host || $sysadmin 
	     || $www || $webman || $webstat || $ftp || $gopher || $wais 
	     || $list || $router_mgmt ) {
	     
		$PARAM_LINE .= " -x";
		if ($mail_opt) {
			for ($innerct=0; $innerct < $mail_num; $innerct++) {
				$PARAM_LINE .= "mail:";
			}
		}
		if ($shell) {
			for ($innerct=0; $innerct < $shell_num; $innerct++) {
				$PARAM_LINE .= "shell:";
			}
		}
		if ($fix) {
			for ($innerct=0; $innerct < $fix_num; $innerct++) {
				$PARAM_LINE .= "fix:";
			}
		}
		if ($dnsps) {
			$PARAM_LINE .= "dnsps:";
		}
		if ($domreg) {
			for ($innerct=0; $innerct < $domreg_num; $innerct++) {
				$PARAM_LINE .= "domreg:";
			}
		}
		if ($upgrade) {
			for ($innerct=0; $innerct < $upgrade_num; $innerct++) {
				$PARAM_LINE .= "upgrade:";
			}
		}
		if ($dns) {
			for ($innerct=0; $innerct < $dns_num; $innerct++) {
				$PARAM_LINE .= "dns:";
			}
		}
		if ($route) {
			for ($innerct=0; $innerct < $route_num; $innerct++) {
				$PARAM_LINE .= "route:";
			}
		}
		if ($dialburst) {
			for ($innerct=0; $innerct < $dialburst_num; $innerct++) {
				$PARAM_LINE .= "dialburst:";
			}
		}
		if ($dedburst) {
			for ($innerct=0; $innerct < $dedburst_num; $innerct++) {
				$PARAM_LINE .= "dedburst:";
			}
		}
		if ($host) {
			for ($innerct=0; $innerct < $host_num; $innerct++) {
				$PARAM_LINE .= "host:";
			}
		}
		if ($sysadmin) {
			for ($innerct=0; $innerct < $sysadmin_num; $innerct++) {
				$PARAM_LINE .= "sysadmin:";
 			}
		}
		if ($www) {
			for ($innerct=0; $innerct < $www_num; $innerct++) {
				$PARAM_LINE .= "www:";
			}
		}
		if ($webman) {
			for ($innerct=0; $innerct < $webman_num; $innerct++) {
				$PARAM_LINE .= "webman:";
			}
		}
		if ($webstat) {
			for ($innerct=0; $innerct < $webstat_num; $innerct++) {
				$PARAM_LINE .= "webstat:";
			}
		}
		if ($ftp) {
			for ($innerct=0; $innerct < $ftp_num; $innerct++) {
				$PARAM_LINE .= "ftp:";
			}
		}
		if ($gopher) {
			for ($innerct=0; $innerct < $gopher_num; $innerct++) {
				$PARAM_LINE .= "gopher:";
			}
		}
		if ($wais) {
			for ($innerct=0; $innerct < $wais_num; $innerct++) {
				$PARAM_LINE .= "wais:";
			}
		}
		if ($list) {
			for ($innerct=0; $innerct < $list_num; $innerct++) {
				$PARAM_LINE .= "list:lstart:";
			}
		}
		if ($router_mgmt) {
			$PARAM_LINE .= "rtr:";
		}
		chop ($PARAM_LINE);
	}

	#
	# Calculates what periodic rate to use as a multiplier (and discounter)
	# for services purchased in monthly, semi-annual or yearly packages.
	#
	if ($billing_cycle eq "Monthly") {
		$periodic = 1;
	}
	if ($billing_cycle eq "Half-Year") {
		$periodic = 6;
	}
	if ($billing_cycle eq "Annual") {
		$periodic = 12;
	}

	$PARAM_LINE =$PARAM_LINE." -b${periodic}";
	
	if ($dnsps) {
		$PARAM_LINE =$PARAM_LINE." -w${dnsps_num}";
	}
	
	if ($hourly_contract) {
		$PARAM_LINE =$PARAM_LINE." -e";
	}
		
	if ($config_hours) {
		$PARAM_LINE =$PARAM_LINE." -f${config_hours}";
	}
	if ($consult_hours) {
		$PARAM_LINE =$PARAM_LINE." -s${consult_hours}";
	}
	if ($program_hours) {
		$PARAM_LINE =$PARAM_LINE." -r${program_hours}";
	}
	if ($postprocess_hours) {
		$PARAM_LINE =$PARAM_LINE." -o${postprocess_hours}";
	}
	if ($hardware && $hardware_price) {
		$PARAM_LINE =$PARAM_LINE." -h\'${hardware}\' -H${hardware_price}";
	}
	
	if ($delivery =~ "View Quote as Postscript") {
		$PARAM_LINE = $PARAM_LINE." ";
	}
	if ($delivery =~ "View Quote as Text") {
		$PARAM_LINE = $PARAM_LINE." -t ";
	}
	if ($delivery =~ "Fax Quote") {
		# $PARAM_LINE = $PARAM_LINE." -t ";
		$fax =1;
	}
	if ($delivery =~ "Mail Quote as PostScript") {
		$mail = 1;
	}
	if ($delivery =~ "Mail Quote as Text") {
		$PARAM_LINE = $PARAM_LINE." -t ";
		$mail = 1;
	}
	if ($delivery =~ "Print Quote") {
		$PARAM_LINE = $PARAM_LINE." -p ";
	}

	#
	# Here's where some output is given back to the web client.  The
	# document's title and a header is displayed.  Furhter processing
	# is required to actually report that other actions have been 
	# performed.
	#
	print STDOUT "<TITLE>OuterNet Automated Quote</TITLE>\n";
	print STDOUT "<H2>OuterNet Automated Quote</H2><p>\n";

	#
	# The first thing to do is to stash away our arguments that we toiled
	# for so long to create. These are then dumped into a file called:
	# "/tmp/quote.args." This file is read by the $QUOTE_GENERATOR and
	# acted upon further from there.
	#
	open(PARAMS,">/tmp/quote.args");
	print PARAMS "$PARAM_LINE";
	close(PARAMS);
	
	#
	# Here we determine what delivery is needed for the end product.
	# Note that a "View Text" selection will fall through to the 
	# "else" below.
	#
	if ($mail || $fax) {
		if ($mail) {
				
			#
			# Creates the messages file for temporary storage. The data for these messages
			# could be passed any number of other ways, but this was the quickest to program.
			#
			open (MESSAGEFILE, "> /tmp/messages");
			print MESSAGEFILE "$fax_message_1\n$fax_message_2\n$fax_message_3\n$fax_message_4\n\n";
			close (MESSAGEFILE);
			
			#
			# Here's the call to the $QUOTE_GENERATOR.  Notice that I background the call to the
			# script since it doesn't provide output, and it was designed to where we don't have
			# to wait for it.
			#
			
			system("$QUOTE_GENERATOR -m -a${mail_address} &");
			
			#
			# Albeit, this stuff should live inside of the $QUOTE_GENERATOR, but everyone is
			# busy, eh? Sometimes, cleanup is a nasty job :<  
			#
			# Basically this just checks for the request of other information then mails it out
			# to the receipient.
			#
			if ($extra_info) {
				system ("/usr/bin/mailx -s \"Automated Information: OuterNet Connection Strategies, Inc.\" $mail_address < /usr/local/bin/information.outer.net");
			}
			if ($extra_price) {
				system ("/usr/bin/mailx -s \"Automated Prices: OuterNet Connection Strategies, Inc.\" $mail_address < /usr/local/bin/prices.outer.net");
			}
			if ($extra_dis) {
				system ("/usr/bin/mailx -s \"Automated Information: OuterNet Connection Strategies, Inc.: Service Agreement\" $mail_address < /usr/local/bin/disclaimer.outer.net");
			}
			if ($extra_dns) {
				system ("/usr/bin/mailx -s \"Automated Information: OuterNet Connections DNS Registration\" $mail_address < /www/cgi-bin/dns/domreg.form");
			}
			#
			# A little feedback is always good.  That way, the web user isn't scratching their head
			# for too long.
			#
			print STDOUT "Mail has been successfully sent to: $mail_address\n";
		}
		
		#
		# Here's where the fax delivery option is realized.  This script was designed to do
		# a minimal amount of error-checking, the least of which is that it we check for the
		# existence of a $fax_number before we try anything.
		#
		if ($fax) {
			if (! $fax_number) {
				print STDOUT "<h2>There was no fax number specified</h2>\n";
			}
			else {
				print STDOUT "<H2>The Fax has been spooled and will be sent within 1 hour</H2>";
				
				open(FAXMESSAGES, "> /tmp/faxmsgs");
				print FAXMESSAGES "${fax_message_1}\n${fax_message_2}\n${fax_message_3}\n${fax_message_4}\n\n";
				close (FAXMESSAGES);
				
				$argline = "-f -w${who} -x${fax_number} ";
				if ($extra_info) {
					$argline .= "-i ";
				}
				if ($extra_price) {
					$argline .= "-p ";
				}
				if ($extra_dis) {
					$argline .= "-d ";
				}
				if ($extra_noc) {
					$argline .= "-y ";
				}
				if ($extra_src) {
					$argline .= "-z ";
				}
				
				system("$QUOTE_GENERATOR ${argline} &");
			}
		}
	}
	
	#
	# This is the fall through condition, which usually means that the user requested
	# a view by text or similar mode. Simply put, the "quote" program is called directly
	# rather than through the $QUOTE_GENERATOR above. Yes, this is another prime candidate 
	# for house-cleaning. The following code calls the quoter then opens up the file 
	# created, sending the text back at the web user as <PREFORMATTED>.
	#
	#
	else {
		open(QUOTESTREAM,"/www/cgi-bin/quote ${PARAM_LINE} |");
		while (<QUOTESTREAM>) {
			$filename = $_;
		}
		close (QUOTESTREAM);
		chop ($filename);
	
		print STDOUT "<pre>";
		open (FILEHANDLE,$filename);
		while (<FILEHANDLE>) {
			print STDOUT;
		}
		close (FILEHANDLE);
		unlink($filename);
		print STDOUT "</pre>";
	}
	
	#
	# Lastly we make a log of what goings on are happening.  Since our quote generator
	# will be open to public abuse in the future, we want to keep a tab on what's going
	# on by whom and when.
	#
	
	$quote_number = `cat "$QUOTEFILE"`;

	open (LOG,">>$LOGFILE");
	print LOG "$datestr: $quote_number: $c_customer_num: $delivery: $PARAM_LINE\n";
	close (LOG);
}


