#! /usr/bin/perl5
print <<EndOfFile;
Content-type: text/html

<H1><A NAME="_wmh1_827796637">DHCP</A></H1>
<P>
The dynamic host configuration protocol (DHCP) is a service that
automatically assigns a network address and other operating parameters
to client hosts that request them. The DHCP service is implemented by
the <VAR>dhcp_bootp</VAR> process, which runs on a server. The
configuration parameters that a DHCP server provides clients are stored
in files that are contained in the <VAR>/var/dhcp/config</VAR>
directory on the server. This directory contains a file for each
network for which the DHCP server provides client configuration
information (see the dhcp_bootp reference page for details).
</P>
<P>
For clients on remote networks (any network to which the DHCP server is
not directly attached), <VAR>dhcp_bootp</VAR> is assisted by a
forwarding agent, <VAR>dhcp_relay.</VAR> You run <VAR>dhcp_relay
</VAR>instead of <VAR>dhcp_bootp </VAR>on a system on each of these
networks to forward client configuration requests to the DHCP server
(see the dhcp_relay reference page for details). The DHCP server, which
is the central source of Internet addresses for all the networks that
it serves, maintains a list of assigned addresses in a table that you
can display to monitor address status.
</P>
<P>
To request configuration information from a DHCP server, the client
host runs proclaim, the complementary DHCP client application. When the
server receives a request (which contains the client's hardware
address), it forwards the network address and other requested
configuration parameters to the client. Because client addresses are
assigned for a specified time interval, they are referred to as
<EM>address leases</EM>. Leases provided an efficient way of managing
hosts that only occasionally require an Internet address.
</P>
<P>
When the DHCP server configures a new host, it automatically updates
the appropriate name and address databases on the server. You provide
information about your name service (either the local hosts file or
maps for DNS or NIS) and other DHCP server parameters when you
configure the DHCP server.  Server configuration data is stored in the
<VAR>/etc/config/dhcp_bootp.options </VAR>file.
</P>
<P>
<STRONG>Note:</STRONG> If you are running the NIS name service, the
DHCP server must be installed on the primary NIS server. If you are
running DNS, you must update maps manually (or provide an update
script).
</P>
<P>Use these forms to manage and configure DHCP:</P>
<UL>
<LI><A HREF="index.dhcp1.shtml" TARGET="left">Client Configuration Options</A>
<LI><A HREF="index.dhcp2.shtml" TARGET="left">Show Currently Assigned Address Leases</A>
<LI><A HREF="index.dhcp3.shtml" TARGET="left">Relay Agent Options</A>
<LI><A HREF="index.dhcp4.shtml" TARGET="left">DHCP Server Options</A>
</UL>
EndOfFile
