#!/usr/bin/perl5

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$title = "DHCP Leases";

print $query->header;
&title_block($title);

sub error {
    &error_block($_[0]);
    exit 0;
}

$srv_off = system ("/etc/chkconfig", "proclaim_server");
if ($srv_off) {
    &error("This system is not configured to be a DHCP server.");
}

$lsf = "/var/dhcp/etherToIP";
open(LEASE, $lsf) || &error("There are no current address leases.");

&header_block($title);

print "<center><table cellpadding=5 width=450>";
print "<tr><th align=left>Hostname<th align=left>Domain<th align=left>
	    IP Address<th align=left>Expiration";
while(<LEASE>) {
    chop;
    ($ether, $ip, $host, $expiry) = split(/\s+/);
    ($hname, @domain) = split(/\./, $host);
    $domain = join('.', @domain);
    if ($expiry) {
	if (time < $expiry) {
	    @gt = localtime $expiry;
	    $date = sprintf "%02d/%02d/%02d", $gt[4]+1, $gt[3], $gt[5];
	    $fol = "AM";
	    if ($gt[2] == 12) { $fol = "PM"; }
	    if ($gt[2] > 12) { $gt[2] -= 12; $fol = "PM"; }
	    if ($gt[1] < 10) { $gt[1] = "0$gt[1]"; }
	    $time = "$gt[2]:$gt[1] $fol";
	    print "<tr><td align=left>$hname<td align=left>$domain" .
		"<td align=left>$ip<td align=left>$time, $date</tr>\n";
	} else {
	    print "<tr><td align=left>$hname<td align=left>$domain" .
		"<td align=left>$ip<td align=left>Expired</tr>\n";
	}
    }
    else {
	print "<tr><td align=left>$hname<td align=left>$domain" .
	    "<td align=left>$ip<td align=left>Negotiating</tr>\n";
    }
}
close(LEASE);
print "</table></center>\n";
