#!/usr/bin/perl5

# ftp-anonymous.frm
#
# Scott A. Hotes -- April, 1996 
# Silicon Graphics Inc.
# 
# flow chart on form validation:
#
# if (ftp user does not already exist) 
#   if (home directory already exists) -> error
#   else -> create directory and ftp user
# else
#   if (home directory exists and owned by ftp) -> check for nec. files
#   elsif (home dir. exists and not owned by ftp) -> error
#   else -> create home dir. and add nec. files

# TO BE DONE : add entry to groups file...

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$passwdfile = "/etc/passwd";
$confI = "/etc/inetd.conf";
$dummy = "/etc/passwd.tmp";
$title = "Anonymous FTP Configuration";

print $query->header;
&title_block($title);

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

# if anonymous FTP user exists, we assume directory tree
# also exists.

@getpass = getpwnam("ftp");
if ($query->param('doit') eq 'Ok') {
    if ($getpass[0]) {
		$oldHome = $getpass[7];
		$oldEftp = 'Yes';
    }
    if ($query->param('eftp') eq 'Yes') {
	$home = $query->param('home');
	&error("Invalid home directory.") if !$home;
	&formValidation;
	&checkInetdEntry;
	
    if (!$getpass[0] || $oldHome ne $home) { 
		if ($getpass[0]) { &deleteOld; }
	    &add_password("ftp","*",500,25,"anon ftp",$home,"/bin/false"); 
	}
	if (-d $home) { &checkForFiles; }
	else { &createHome; }
	$message = "Anonymous FTP enabled.";
    } else { &disable_ftp; }
} elsif ($getpass[0]) {
	$home = $getpass[7];
	$eftp = 'Yes';
} else {
	$home = '/var/ftp';
	$eftp = 'No';
}
 
&generic;

print $query->end_html;

sub deleteOld {
	open(IN,"< $passwdfile");
	open(OUT,"> $dummy");
	while(<IN>) {
		@items = split(/:/);
		if ($items[0] ne "ftp") { print OUT $_; }
	}
	close(IN);
	close(OUT);
	rename($dummy,$passwdfile);
}		

sub checkInetdEntry {
    $found = 0;
    $doRename = 0;
    open(IN,"< $confI");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if (($items[0] eq "#" && $items[1] eq "ftp") || $items[0] eq "#ftp") {
	    $_ =~ /^\s*#\s*(.*)$/;
	    $line = $1;
	    print OUT "$line\n";
	    $found = 1;
	    $doRename = 1;
	} elsif ($items[0] eq "ftp") {
	    print OUT $_;
	    $found = 1;
	} else { print OUT $_; }
    }
    if (!$found) {
	$doRename = 1;
	print OUT "ftp\tstream\ttcp\tnowait\troot\t/user/etc/ftpd\tftpd\n";
    }
    close(IN);
    close(OUT);
    if ($doRename) { 
	rename($dummy,$confI); 
	`/etc/killall -HUP inetd`;
    }
}

sub formValidation {
    if ($getpass[0]) {		# ftp user exists
	if (-d $query->param('home')) {
	    my($dev,$ino,$mode,$nlink,$fuid,
		      $fgid,$rdev,$size,$atime,$mtime,
		      $ctime,$blksize,$blocks) = stat(_);

	    my($name,$psswd,$uuid,$ugid,$quota,
		      $comment,$gcos,$dir,$shell) = getpwnam("ftp");

	    &error("Home directory not owned by FTP") 
			if $fuid != $uuid;
	}
    } else {		#ftp user does not exist
	if (-d $query->param('home')) {
	    &error("Home directory owned by other user.");
	}
    }
}

sub error {
	&error_block($_[0]);
	&generic;
	exit 0;
} 

sub createHome {
    if (!$home) { return 0; }
    # create home directory
    `mkdir -p $home`;
    `chown ftp.ftp $home`;

    # create subdirectories
    `mkdir -m 111 $home/bin`;
    `mkdir -m 555 $home/pub`;
    `mkdir -m 111 $home/etc`;
    `mkdir -m 555 $home/lib`;
    `mkdir -m 555 $home/dev`;

	`chown ftp.ftp $home/pub`;
	`chmod 777 $home/pub`;

    `cp /bin/ls $home/bin`;
    `chmod 555 $home/bin/ls`;

    `cp /lib/rld $home/lib`;
    `cp /lib/libc.so.1 $home/lib`;
    `chmod 555 $home/lib/rld $home/lib/libc.so.1`;

    `mknod $home/dev/zero c 37 0`;
    `chmod 444 $home/dev/zero`;

    $ftp_pass = $home . "/etc/passwd";
    $ftp_grp = $home . "/etc/group";

    open(OUTP,"> $ftp_pass");
    open(OUTG,"> $ftp_grp");

    my($name,$psswd,$uuid,$ugid,$quota,
	$comment,$gcos,$dir,$shell) = getpwnam("ftp");
    print OUTP "ftp:*:${uuid}:${ugid}:anon ftp:${dir}:${shell}\n";
    print OUTG "ftp:*:${ugid}:\n";

    my($name,$psswd,$uuid,$ugid,$quota,
	$comment,$gcos,$dir,$shell) = getpwnam("user");
    print OUTG "user:*:${ugid}:\n";    

    my($name,$psswd,$uuid,$ugid,$quota,
	$comment,$gcos,$dir,$shell) = getpwnam("root");
    print OUTP "root:*:${uuid}:${ugid}::/:/bin/false\n";
    print OUTG "sys:*:$ugid:\n";

    close(OUTP); 
    close(OUTG);  
}
   
sub checkForFiles { }  

sub disable_ftp {
	$value = "";
	&putpass;
	$message = "Anonymous FTP disabled.";
}

sub generic {
    &header_block("Anonymous FTP");

    print "<i>$message</i>";

    print $query->startform;

    print "<center><table cellpadding=5 width=450>\n";

    print "<tr><th align=left>Enable anonymous FTP:</th><th align=left>",
	  $query->radio_group(-name=>'eftp',
	  -values=>['Yes','No'], -default=>$eftp),
	  "</th></tr>";

    print "<tr><th align=left>Home directory for the FTP account:</th><th align=left>",
	  $query->textfield('home', $home),
	  "</th></tr>";

    print "</table></center><br>\n";

    &button_table($query,"doit", "Ok", "help", "Help");

    print $query->endform;

    print $query->end_html;
}

sub putpass {
	$variable = "ftp";
	local($len) = length($variable);

	open(IN,"< $passwdfile") || print "unable to read $passwdfile";
	open(OUT,"> $dummy") || print "unable to write to $dummy";
	$found = 0;

	while (<IN>) {
		if ($variable eq substr($_,0,$len)) {
			$found = 1;
			print OUT $value;
		} else { print OUT $_; }
	}
	if ($found == 0) { print OUT $value; }
	close(OUT);
	close(IN);
	rename($dummy, $passwdfile) || print "unable to rename $dummy";
}
