#!/usr/bin/perl5

# ftp-config.frm
# Scott Hotes -- April, 1996
#
# Form validation:  Inactivity timeout > 60
#
# Configuration file:  /etc/inetd.conf

*MINTIMEOUT = \240;
*MAXTIMEOUT = \7200;

require "/usr/OnRamp/lib/OnRamp.pm";

$myname = "ftp-config.cgi";
$conf = "/etc/inetd.conf";
$dummy = "/etc/inetd.conf.tmp";

$title = "FTP Server";

print "Content-type: text/html\n\n";
&title_block($title);

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@fields = split('&',$buffer);

&getValues;

foreach (@fields) {
  @line = split('=',$_);
  $line[1] =~ tr/+/ /; 
  $fld{$line[0]} = $line[1];
  }

if (%fld) {
	$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
	$help =~ s/cgi$/hlp/;
	exec $help if ($fld{'help'} eq "Help");

	if ($fld{'doit'} eq 'Ok') {
		&formValidation;
		if ($fld{'eftp'} eq 'Yes') { &enableFTP; }
		else { &disableFTP; }
	&getValues;
	}
}

&generic;

sub formValidation {
	if ($fld{'dto'}) {
		local ($error) = &check_int($fld{'dto'}, $MINTIMEOUT, $MAXTIMEOUT);

		&error("Timeout must be an integer value") if $error == 1;

		&error("Inactivity timeout must be between $MINTIMEOUT and $MAXTIMEOUT seconds.")
			if $error > 1;
	}
	else { $fld{'dto'} = 900; } 
}

sub error {
    &error_block($_[0]);
    $val{'dto'} = $fld{'dto'};
    $val{'logf'} = $fld{'logf'};    
    $val{'eftp'} = $fld{'eftp'};    
    &generic;
    exit 0;
}

sub enableFTP {
	$value = "ftp\tstream\ttcp\tnowait\troot\t/usr/etc/ftpd\tftpd";
	if ($fld{'logf'} eq 'Yes') { $value .= " -l"; }
	if ($fld{'dto'} ne '900') { 
		$value .= " -t" . $fld{'dto'}; }

	$or = $fld{'or'};
	$ow = $fld{'ow'};
	$oe = $fld{'oe'};

	$gr = $fld{'gr'};
	$gw = $fld{'gw'};
	$ge = $fld{'ge'};

	$tr = $fld{'tr'};
	$tw = $fld{'tw'};
	$te = $fld{'te'};

	$mask = &args_to_umask;

	if ($mask ne '022') { 
		$value .= " -u" . $mask; }
	
	&putEntry($conf,"ftp",$value);
	`/etc/killall -HUP inetd`;

	$message = "FTP deamon enabled.";
}

sub disableFTP {
	if ($val{'eftp'} eq "Yes") { 
	    &commentEntry($conf,"ftp"); 
	    `/etc/killall -HUP inetd`;

	    $message = "FTP deamon disabled.";
	}
}

sub commentEntry {
	local($file) = $_[0];
	local($entry) = $_[1];
	local($len) = length($entry);

	open(IN,"< $file");
	open(OUT,"> $dummy");
	while(<IN>) {
		if ($entry eq substr($_,0,$len)) {
			print OUT "# ",$_;
		} else { print OUT $_; }
	}
	close(IN);
	close(OUT);
	rename($dummy,$file) || &error("Unable to rename to $file");
}

sub putEntry { 
	local($file) = $_[0];
	local($key) = $_[1];
	local($val) = $_[2];

	open(IN,"< $file");
	open(OUT,"> $dummy");
	local($found) = 0;
	while(<IN>) {
		if (/^$key/ || /^#\s*$key/) {
			print OUT $val,"\n";
			$found = 1;
		} else { print OUT $_; }
	}
	if ($found == 0) { print OUT $val,"\n"; }
	close(IN);
	close(OUT);
	rename($dummy,$file) || &error("Unable to rename to $file");
}

sub umask_to_args {
	local($toct);
	$toct = oct($_[0]);

	@otdef = @owdef = @grdef = ();

	if (!($toct & 0400)) { $val{'or'} = ""; } else { $val{'or'} = "on"; }
	if (!($toct & 0200)) { $val{'ow'} = ""; } else { $val{'ow'} = "on"; }
	if (!($toct & 0100)) { $val{'oe'} = ""; } else { $val{'oe'} = "on"; }

	if (!($toct & 0040)) { $val{'gr'} = ""; } else { $val{'gr'} = "on"; }
	if (!($toct & 0020)) { $val{'gw'} = ""; } else { $val{'gw'} = "on"; }
	if (!($toct & 0010)) { $val{'ge'} = ""; } else { $val{'ge'} = "on"; }

	if (!($toct & 0004)) { $val{'tr'} = ""; } else { $val{'tr'} = "on"; }
	if (!($toct & 0002)) { $val{'tw'} = ""; } else { $val{'tw'} = "on"; }
	if (!($toct & 0001)) { $val{'te'} = ""; } else { $val{'te'} = "on"; }
}

sub args_to_umask {
    $umask = 0;
    if ($te eq "") { $umask += 1; }
    if ($tw eq "") { $umask += 2; }
    if ($tr eq "") { $umask += 4; }
    if ($ge eq "") { $umask += 10; }
    if ($gw eq "") { $umask += 20; }
    if ($gr eq "") { $umask += 40; }
    if ($oe eq "") { $umask += 100;}
    if ($ow eq "") { $umask += 200; }
    if ($or eq "") { $umask += 400; }
    if ($umask < 100 && $umask > 9) { $umask = "0" . $umask; }
    elsif ($umask < 10) { $umask = "00" . $umask; }
    return $umask;
}

sub getValues {
	$val{'dto'} = $default_dto = 900;
	$mto = $default_mto = 7200;
	$val{'logf'} = $default_logf = "No";
	$default_logf = "Yes";
	$val{'eftp'} = "No";		# only set this to "Yes" if we find line

	$val{'or'} = "";    $val{'ow'} = "";	$val{'oe'} = "";
	$val{'gr'} = "";    $val{'gw'} = "on";	$val{'ge'} = "";
	$val{'tr'} = "";    $val{'tw'} = "on";	$val{'te'} = "";

	if (open(INETD, "< $conf")) {
     	    while (<INETD>) {
		@args = split(/\s+/);
		if ($args[0] ne "ftp") { next; }
		$val{'eftp'} = "Yes";
		while ($arg = pop(@args)) {
	    	    if ($arg eq "-l") { $val{'logf'} = "Yes"; }
	    	    elsif (substr($arg,0,2) eq "-t") { $val{'dto'} = substr($arg,2); }
	    	    elsif (substr($arg,0,2) eq "-T") { $mto = substr($arg,2); }
	    	    elsif (substr($arg,0,2) eq "-u") { umask_to_args(substr($arg,2)); }
	    	}
	    }
	}

   	close(INETD);
}

sub generic {
	&header_block($title);

	print "<i>$message</i><br>";
	print "<form action=$myname method=post>";

	print "<center><table cellpadding=5 width=450>\n";

	print "<tr><th align=left>Enable FTP:</th><th align=left>",
	      &radio('eftp',$val{'eftp'},'Yes','No'),
	      "</th></tr>";

	if ($val{'dto'} == 900) { $val{'dto'} = ""; }
	print "<tr><th align=left>Idle time before connection is dropped
		    (seconds):</th><th align=left>",
	      &text('dto', $val{'dto'},10),
	      "</th></tr>";

#	print '<TR><TH ALIGN="left">Maximum Inactivity Timeout (seconds)',
#    		'<TH ALIGN="left">';
#	print &text('mto', $mto);

	print "<tr><th align=left>Log events in FTP sessions:</th><th align=left>",
	      &radio('logf',$val{'logf'},'Yes','No'),
	      "</th></tr>";

	print "<tr><th align=left>Permission settings for new files:",
	      "</th><th></th></tr>";

	print "</table></center>\n";

	if ($val{'or'} eq "") { $chor = "checked"; } else { $chor = ""; }
	if ($val{'ow'} eq "") { $chow = "checked"; } else { $chow = ""; }
	if ($val{'oe'} eq "") { $choe = "checked"; } else { $choe = ""; }

	if ($val{'gr'} eq "") { $chgr = "checked"; } else { $chgr = ""; }
	if ($val{'gw'} eq "") { $chgw = "checked"; } else { $chgw = ""; }
	if ($val{'ge'} eq "") { $chge = "checked"; } else { $chge = ""; }

	if ($val{'tr'} eq "") { $chtr = "checked"; } else { $chtr = ""; }
	if ($val{'tw'} eq "") { $chtw = "checked"; } else { $chtw = ""; }
	if ($val{'te'} eq "") { $chte = "checked"; } else { $chte = ""; }

	print "<center><table><tr><td></td><td>Owner</td><td>Group</td>
		    <td>Other</td></tr>";

	print "<tr><td>Read</td>";
	print "<td>",qq|<input type="checkbox" name="or" $chor>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="gr" $chgr>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="tr" $chtr>|,"</td>";
	print "</tr>";

	print "<tr><td>Write</td>";
	print "<td>",qq|<input type="checkbox" name="ow" $chow>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="gw" $chgw>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="tw" $chtw>|,"</td>";
	print "</tr>";

	print "<tr><td>Execute</td>";
	print "<td>",qq|<input type="checkbox" name="oe" $choe>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="ge" $chge>|,"</td>";
	print "<td>",qq|<input type="checkbox" name="te" $chte>|,"</td>";
	print "</tr>";

	print "</table></center><br>";

	print &buttons('doit','Ok');

	print "</form>";
}
