#!/usr/bin/perl5

# isdn.frm 
# Scott A. Hotes -- April 1996
#
# currently allowed only one switch type (and pair of SPID #'s),
# but can have multiple connection names (and phone numbers).
# this is to remove ambiguity that entries in isdnd.options know
# nothing of connection names.  code will comment out conflicting
# entries.

require "/usr/OnRamp/lib/OnRamp.pm";

$confS = "/etc/uucp/Systems";
$conf = "/etc/config/isdnd.options";
$dummy = "/etc/config/isdnd.options.tmp";
$myname = "isdn-setup.cgi";
$title = "ISDN Setup";

print "Content-type: text/html\n\n";
&title_block($title);

@types = ('DMS100','NI1','5ESS','NTT','NET3','1TR6','VN3','TPH');

&get_fields;

&getInfo;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($fld{'help'} eq "Help");

if ($fld{"doit"} eq "Ok") {
    &formValidation;
    &edit; 
    &getInfo; 
    &putValues;
    if (!$message) { $message = "No change."; }
} else { &putValues; }

if (-e "/usr/etc/isdnd") { &generic; }
else {
    &header_block($title);
    print "<i>ISDN software not installed.  Install subsystem </i><b>isdn_eoe.sw</b><i>
		from the 6.2 CD.</i>";
}

sub formValidation {
    &error("Invalid telephone number entry.") if &check_phone($fld{'phone'});
    &error("Invalid connection name.") if $fld{'name'} =~ /$METACHARS/o;
    &error("Invalid SPID number.") if $fld{'spid1'} =~ /$METACHARS/o;
    &error("Invalid SPID number.") if $fld{'spid2'} =~ /$METACHARS/o;
    
    if ($fld{'switch'} eq 'DMS100' || $fld{'switch'} eq 'NI1') {
	&error("Invalid SPID number: $fld{'spid1'}.") 
	    if ($fld{'spid1'} =~ /[^0-9]/);
	&error("Invalid SPID number: $fld{'spid2'}.") 
	    if ($fld{'spid2'} =~ /[^0-9]/);
	if (!$fld{'spid1'}) 
	    { &error("Two SPID numbers required for this switch."); }
	if (!$fld{'spid2'}) 
	    { &error("Two SPID numbers required for this switch."); }
    }
}

sub error {
    &error_block($_[0]);
    %val = %fld;
    &generic;
    exit 0;
}

sub edit {
    if ($fld{'isdns'} ne $isdns) { &editStatus; }
    if ($fld{'isdns'} eq "Yes") { &writeFile; }
}

sub writeFile {
    if (&checkOpChange) {
	open(IN,"< $conf");
	open(OUT,"> $dummy");
	while(<IN>) {
	    $line = $_;
	    if (substr($_,0,2) ne "-t") { print OUT $_; }
	    else { print OUT "# $line"; }
	}
	print OUT "-t $fld{'switch'}";
	if ($fld{'switch'} eq 'DMS100' || $fld{'switch'} eq 'NI1') {
	    print OUT " -s $fld{'spid1'} -s $fld{'spid2'}";
	}
	print OUT "\n";
	close(OUT);
	close(IN);
	rename($dummy,$conf);
    }

    $fld{'phone'} =~ s/-//g;
    if (&checkSyChange) {
	open(IN,"< $confS");
	open(OUT,"> $dummy");
	while(<IN>) {
	    @items = split(/\s+/);
	    if (substr($items[0],0,1) eq '#') { print OUT $_; next; }
	    if ($items[0] ne $name || $items[2] ne 'ISDN') { print OUT $_; }
	    else { print OUT "# $_"; }
	}
	print OUT qq|$fld{'name'} Any ISDN 38400 "" "" ISDNCALL[56]$fld{'phone'} CONNECTED\n|;
	close(OUT);
	close(IN);
	`chmod 600 $confS`;
	rename($dummy,$confS);
	`chmod 400 $confS`;
    }
    $message .= "Parameters edited.";
}

sub checkSyChange {
    if ($fld{'name'} ne $name || $fld{'phone'} ne $phone) { return 1; }
    return 0;
}

sub checkOpChange {
    if ($fld{'switch'} ne $swType) { return 1; }
    if ($swNum > 1) { return 0; }
    if ($fld{'spid1'} ne $spid[0]) { return 1; }
    if ($fld{'spid2'} ne $spid[1]) { return 1; }
    return 0;
}

sub editStatus {
    if ($fld{'isdns'} eq "Yes") { 
	`/etc/chkconfig isdnd on`;
	`/etc/init.d/isdnd stop > /dev/null 2>&1`;
	`/etc/init.d/isdnd start > /dev/null 2>&1`; 
	$message = "ISDN enabled.  ";
    }
    else {
	`/etc/chkconfig isdnd off`; 
	`/etc/init.d/isdnd stop > /dev/null 2>&1`;
	$message = "ISDN disabled.  ";
    }
}

sub putValues {
    $val{'isdns'} = $isdns;
    $val{'name'} = $name;
    $val{'phone'} = $phone;
    $val{'switch'} = $swType;
    $val{'spid1'} = $spid[0];
    $val{'spid2'} = $spid[1];
}
   
sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th align=left>Enable ISDN:</th><th align=left>";
    print &radio('isdns',$val{'isdns'},"Yes","No");
    print "</th></tr>";

    print "<tr><th align=left>Connection name for host answering calls:
	    </th><th align=left>";
    print &text('name',$val{'name'},20);
    print "</th></tr>";
    
    print "<tr><th align=left>Phone number for host answering calls:
	    </th><th align=left>";
    print &text('phone',$val{'phone'},20);
    print "</th></tr>";    

    print "<tr><th align=left>Type of switch used for connections:
	    </th><th align=left>";
    print &select('switch',$val{'switch'},'DMS100','NI1','5ESS','NTT','NET3',
	    '1TR6','VN3','TPH');
    print "</th></tr>";

    print "<tr><th align=left>SPID #1:</th><th align=left>";
    print &text('spid1',$val{'spid1'},20);
    print "</th></tr>";

    print "<tr><th align=left>SPID #2:</th><th align=left>";
    print &text('spid2',$val{'spid2'},20);
    print "</th></tr></table></center><br>";

    print "<i>Note: SPID numbers are required only for switch types\n";
    print "DMS100 and NI1.</i><br><br>\n";

    print &buttons("doit", "Ok");

    print '</form>';
}

sub getInfo {
    `/etc/chkconfig isdnd`;
    $output = $? >> 8;
    if ($output) { $isdns = "No"; }
    else { $isdns = "Yes"; }
    $spid[0] = $spid[1] = "";

    open(IN,"< $conf");
    while(<IN>) {
	$line = $_;
	if (substr($line,0,2) eq "-t") {
	    @args = split(/\s+/,$line);
	    $swType = $args[1];
	    $countSPID = 0;
	    for ($i=0;$i<=$#args;$i++) {
		if ($args[$i] eq "-s") { 
		    $spid[$countSPID] = $args[$i+1];
		    $countSPID++; 
		}
	    }
	}
    }
    close(IN);

    open(IN,"< $confS");
    while(<IN>) {
	@items = split(/\s+/);
	if (substr($items[0],0,1) eq '#') { next; }
	if ($items[2] eq 'ISDN') { 
	    $name = $items[0];
	    $items[6] =~ /.*\](\w+)$/;
	    $phone = $1;
	}
    }
    close(IN);
}
