#!/usr/bin/perl5

# modem-accounts.cgi
# Scott A. Hotes, 3 / 25 / 96
# Silicon Graphics
#
# we need to be careful about read access for Systems and Systems.tmp ...
# also about how to write nottrivial phone numbers to file...
#
# what is $num

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/uucp/Systems";
$dummy = "/etc/uucp/Systems.temp";
$myname = "modem-account.cgi";
$title = "Modem Accounts";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

&getAccounts;

if (%fld) {
    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    $fld{'phone'} =~ s/-//g;
    $fld{'phone'} =~ s/\(//g;
    $fld{'phone'} =~ s/\)//g;
    $fld{'phone'} =~ s/,//g;
    $fld{'chosen'} =~ /(\w+)/;
    $fld{'chosen'} = $1;
}

if ($fld{'add'}) { 
    &formValid_add;
    $val{'name'} = $fld{'name'}; 
    &addAccount; 
}
elsif ($fld{'delete'}) { 
    &error(2,"To delete an existing account, first select an account from
	list, then click the delete button.") if !$fld{'chosen'};
    $message = qq|Click "Ok" to save changes.|; 
    &generic($fld{'chosen'}); 
}
elsif ($fld{'edit'}) { 
    &error(2,"To edit an existing account, first select an account from
	list, then click the edit button.") if !$fld{'chosen'};
    &putEdit; 
    &editAccount; 
}
elsif ($fld{'doedit'}) { &formValid_doedit; &doEdit; &getAccounts; &generic; }
elsif ($fld{'doit'}) {
    &tryToDelete; 
    &getAccounts; 
    if (!$message) { $message = "No changes made."; }
    &generic; 
}
elsif ($fld{'doadd'}) { &formValid_doadd; &doAdd; &getAccounts; &generic; }
else {
    if (%fld) { $message = qq|Use "Ok" button to submit form.|; } 
    &generic; 
}

sub formValid_add {
    &error(2,"Account name required.") if !$fld{'name'};
    &error(2,"Invalid account name.") if &deluxeError($fld{'name'});
}

sub formValid_doadd {
    &error(0,"Invalid phone number.") if !$fld{'phone'} || &check_phone($fld{'phone'});
    &error(0,"Invalid login name.") if &deluxeError($fld{'login'});
    &error(0,"Invalid password.") if &deluxeError($fld{'password'});
}

sub formValid_doedit {
    &error(1,"Invalid remote host name.") if &deluxeError($fld{'login'});
    &error(1,"Invalid phone number.") if !$fld{'phone'} || &check_phone($fld{'phone'});
    &error(1,"Invalid login name.") if &deluxeError($fld{'login'});
    &error(1,"Invalid password.") if &deluxeError($fld{'password'});
}

sub deluxeError {
    return 1 if length($_[0]) > 8;
    return 1 if $_[0] =~ /$METACHARS/o;
    return 1 if $_[0] =~ /\s/;
    0;
}

sub error {
    &error_block($_[1]);
    %val = %fld;
    if ($_[0] == 0) { &addAccount; }
    elsif ($_[0] == 1) { &editAccount; }
    else { &generic; }
    exit 0;
}

sub doEdit {
    open(IN,"< $conf");
    open(OUT,"> $dummy");
    $found = 0;
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	$line =~ /^\s*(.*)$/;
	$line1 = $1;
	@items = split(/\s+/,$line1);
	if ($items[2] eq "ACU" && $items[0] eq $fld{'chosen'}) {
	    print OUT "# $line";
	    if ($found == 0) {
		$found = 1;
		print OUT "$fld{'name'} Any ACU $fld{'speed'} $fld{'phone'}";
		print OUT " in:--in: $fld{'login'}";
		if ($fld{'password'}) { print OUT " word: $fld{'password'}"; }
		print OUT "\n";
	    }
	} else { print OUT $line; }
    }
    if ($found == 0) {
	print OUT "$fld{'name'} Any ACU $fld{'speed'} $fld{'phone'}";
	print OUT " in:--in: $fld{'login'}";
	if ($fld{'password'}) { print OUT " word: $fld{'password'}"; }
	print OUT "\n";
    }
    close(IN);
    close(OUT);	
    `chmod 600 $conf`;
    rename($dummy,$conf);
    `chmod 400 $conf`;

    $message = "Account edited.";
}    

sub clear {
    open(OUT_0,"> $_[0]");
    close(OUT_0);
}

sub putEdit {
    $num = -1;
    for ($i=0;$i<$number;$i++) {
	if ($name[$i] eq $fld{'chosen'}) { $num = $i; }
    }

    $val{'name'} = $name[$num];
    $val{'phone'} = $phone[$num];
    $val{'login'} = $login[$num];
    $val{'password'} = $password[$num];
    $val{'speed'} = $speed[$num];
}
 
sub editAccount {
    &header_block("Edit Modem Account");

    print "<form action=$myname method=post>";

    print qq|<input type=hidden name="chosen" value=$fld{'chosen'}>|;

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th align=left>Remote host name:</th><th align=left>",
	  &text('name',$val{'name'}, 20),"</th></tr>";

    print "<tr><th align=left>Phone number:</th><th align=left>",
	  &text('phone',$val{'phone'}, 20),"</th></tr>";

    print "<tr><th align=left>Login name:</th><th align=left>",
	  &text('login',$val{'login'}, 20),"</th></tr>";

    print "<tr><th align=left>Password:</th><th align=left>",
	  &text('password',"$val{'password'}", 20),"</th></tr>";   

    print "<tr><th align=left>Baud rate:</th><th align=left>",
	  &select('speed',$val{'speed'},
	  '2400','9600','14400','19200','28800', '38400'),"</th></tr>";

    print "</table></center><br>";

    print &buttons('doedit','Ok');

    print "</form></body></html>";
}
    
sub tryToDelete {
    $account = $fld{'toDelete'};
    if (!$account) { return 0; }

    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	$line =~ /^\s*(.*)$/;
	$line1 = $1;
	@items = split(/\s+/,$line1);
	if ($items[2] eq "ACU" && $items[0] eq $account) {
	    print OUT "# $line";
	} else { print OUT $line; }
    }
    close(IN);
    close(OUT);
    `chmod 600 $conf`;
    rename($dummy,$conf);
    `chmod 400 $conf`;

    $message = "Account deleted.";	
}

sub doAdd {
    `chmod 600 $conf`;
    open(OUT,">> $conf");
    print OUT "$fld{'name'} Any ACU $fld{'speed'} $fld{'phone'} in:--in:";
    print OUT " $fld{'login'}";
    if ($fld{'password'}) { print OUT " word: $fld{'password'}"; }
    print OUT "\n";
    close(OUT);
    `chmod 400 $conf`;

    $message = "New account added.";
}

sub addAccount {
    &header_block("Add New Modem Account");

    print "<form action=$myname method=post>";

    print "<center><table cellpadding=5 width=450>";

    print "<input type=hidden name=name value=$val{'name'}>";

    print "<tr><th align=left>Remote host name:</th><td><tt>",
	  $val{'name'},"</tt></td></tr>";

    print "<tr><th align=left>Phone number:</th><th align=left>",
	  &text('phone',"$val{'phone'}",20),"</th></tr>";

    print "<tr><th align=left>Login name:</th><th align=left>",
	  &text('login',"$val{'login'}",20),"</th></tr>";

    print "<tr><th align=left>Password:</th><th align=left>",
	  &text('password',"$val{'password'}",20),"</th></tr>";

    print "<tr><th align=left>Baud rate:</th><th align=left>",
	  &select('speed',$val{'speed'},
	  '2400','9600','14400','19200','28800', '38400'),"</th></tr>";

    print "</table></center><br>";

    print &buttons('doadd','Ok');

    print "</form></body></html>";
}

sub getAccounts {
    $i = 0;
    open(IN,"< $conf");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { next; }
	$line =~ /^\s*(.*)$/;
	$line1 = $1;
	@items = split(/\s+/,$line1);
	if ($items[2] eq "ACU") {
	    $name[$i] = $items[0];
	    $speed[$i] = $items[3];
	    $phone[$i] = $items[4];
	    for ($j=5;$j<$#items;$j++) {
		if (substr($items[$j],length($items[$j])-3,3) eq 'in:') 
		    { $login[$i] = $items[$j+1]; }
		if (substr($items[$j],length($items[$j])-3,3) eq 'rd:') 
		    { $password[$i] = $items[$j+1]; }
	    }
	    $i++;
	}
    }
    $number = $i;
    close(IN);
}
	

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    if($_[0]) { print "<input type=hidden name=toDelete value=$_[0]>"; }

    if ($number) {
	print "<h3>List of modem accounts:</h3><center>";

	print "<table cellapdding=5 width=450>";

	print qq|<tr><th align=left><input type=submit name="add" value="Add New Account">
	    </th><td align=left><input name="name" value="$val{'name'}" size=19></td></tr>|; 

	print "<tr><th align=left>";
	print qq|<input type=submit name="edit" 
	    value="Edit Selected Account"></th>|;

	print "<td rowspan=2 align=left>";
	undef @locList;
	for ($i=0;$i<$number;$i++) { 
	    if ($name[$i] ne $_[0]) { push(@locList,$name[$i]); } 
	}
	print &choice_list(*locList,"chosen",20);

	print "</td></tr>";

	print qq|<tr><th align=left><input type=submit name="delete" 
	    value="Delete Selected Account"></th></tr>|;    

	print "</table></center><br>";

    } else {
	print "<i>No existing modem accounts.</i><br><br><center>";
	print "<table cellapdding=5 width=450>";
	print qq|<tr><th align=left><input type=submit name="add" value="Add New Account">
	    </th><td align=left><input name="name" value="$val{'name'}" size=19></td></tr>|; 
	print "</table></center><br>";
    }

    print &buttons('doit','Ok');

    print "</form></body></html>";
}

