#!/usr/bin/perl5 -w
#
# ns_httpd.p 	$Revision: 1.3 $
#
# Program to give onRamp access to the netscape admin
# server "ns-admin" for configuring the netscape httpd server
#
# The program must 1) find if the server is installed, 2) find the port to use
# to connect to the ns-admin server, 3) determine if it is running,
# 4) start it if not,  5) redirect the url to the admin-server or 6) if it is
# not installed and configured, to the url for the marketing blurb
# 
#
# NOTE,  this script must be run as root if it must start up the server.
# 
######################################################################
# global variables						     #
######################################################################
#
# List of possible netscape server home directories.
# Feel free to extend the list.
#
@ns_admin_home_dirs = (
    '/usr/ns-home',
    '/var/ns-home',
    '/var/netscape',
    '/var/www/ns-home', 
    '/var/www/netscape', 
);

$ns_admin_config_file = 'admserv/ns-admin.conf';  # below home_dir

$start_admin = 'start-admin';	# the command in homedir to start the server
		
$home_dir = "";			# global variable to save netscape home dir

$admin_port = -1;	        # port of the netscape admin server

# get the hostname to construct the re-direct url's
#

# this is not needed when we administer with "localhost:81"
#
#$hstname = `/usr/bsd/hostname`;
#chop($hstname);			# remove the trailing '\n'
#
#$host_name = $hstname;

#######################################################################
# First see if we can find the admin server.			      #
#######################################################################

DIR:
foreach $dir (@ns_admin_home_dirs) {
   $file = $dir . "/". $ns_admin_config_file;
   if (! open(FILE, $file)) {
#	warn "Cannot open file $file: $!\n";
        next;			# Not in this directory try the next
   }
   $home_dir = $dir;
   
   # Look through the file for the line defining the port the admin server uses
   #
   while (<FILE>) {
	if (/^Port\s+([0-9]+)/) {
	    $admin_port = $1;
	    last DIR;		# found it get out of the loop
	}
   }
}

# So was it installed? Check if there are any news directories under ns-home
# XXX this assumes 1) news is under the same home as the admin-server for it.
# 2) The netscape naming convention of news-<port> is followed.
#
$subdirs = `/bin/ls $home_dir`;
if (! ($subdirs =~ m:http[d|s]-:)) {
    # nope, redirect to the marketing verbage by creating an html page
    # with the marketing url
    #
    print "Content-type: text/html\n\n";
    print <<EndOfPass;
    <HTML>
    <HEAD>
    <TITLE>Netscape HTTPD</TITLE>
    <META HTTP-EQUIV="refresh" CONTENT="0; URL=ns-httpd-marketing.cgi">
    </HEAD>
    <BODY></BODY>
    </HTML>
EndOfPass

    exit 0;
}
####################################################################### 
# Now let's see if it is already running			      #
#######################################################################
#
# Make a pattern for the test in the if statement
# This can be a problem if the server is started any way other than with its
# full pathname. XXXX
#
$admin_process = $home_dir . "/admserv/ns-admin";

# search the ps output for the admin process.
# 
if ( `/bin/ps -ef`  =~ m:$admin_process:) {
    #it's running,  nothing more to do.
}
else {
    # it wasn't running,  start it up.
    #
   system $home_dir . "/" . $start_admin;
}

######################################################################
# re-direct to the admin server url				     #
######################################################################
#

$url = "http://localhost:".$admin_port;

print "Content-type: text/html\n\n";
print <<EndOfPass;
    <HTML>
    <HEAD>
    <TITLE>Netscape  HTTPD</TITLE>
    <META HTTP-EQUIV="refresh" CONTENT="0; URL=$url">
    </HEAD>
    <BODY></BODY>
    </HTML>
EndOfPass

exit 0;
