#! /usr/bin/perl5

#.........................................................
#..  popper.cgi											..
#..  Scott A. Hotes  3 / 14 / 96						..
#.........................................................

$MINTIMEOUT = 15;
$MAXTIMEOUT = 600;

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/inetd.conf";
$dummy = "/etc/inetd.conf.tmp";
$title = "POP3 Mail Server";

$query = new CGI;
print $query->header;
&title_block($title);

&getValues;

if ($query->param) {
	$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
	$help =~ s/cgi$/hlp/;
	exec $help if ($query->param('help') eq "Help");

	if ($query->param('doit') eq 'Ok') {
		if ($query->param('n_popsrv') eq 'Yes') {
		    &formValidation; 
		    &enablePOP; 
		}
		else { &disablePOP; }

		`/etc/killall -HUP inetd`;
	}
}

$NSstatus = &checkForNS;

if ($NSstatus) { 
    &header_block($title);
    print "<i>NS Mail is currently running.  To enable POP 3 Mail, first
	    disable NS Mail.</i>";
} else { &generic; }

sub checkForNS {
    local($mail_process) = "NscpMail";
    local($ret) = 0;
    if ( `/bin/ps -ef` =~ m:$mail_process:) { $ret = 1; }
    return $ret;
}

sub formValidation {
	my $trace    = $query->param('n_tfile');
	my $bulletin = $query->param('n_bdir');

	if ($trace) {
	    my $error = &check_fname($trace);
	    &error($error) if $error;

	    @trace = split(/\//,$trace);
	    $traceFile = pop(@trace);
	    $traceDir = join('/',@trace);

	    &error("Directory path for trace file must be valid.") if $trace && ! -d $traceDir;

	    &error("Trace file must not already exist.") if -e $trace;
	}

	$timeOut = $query->param('n_tmout');
	&error("Timeout value must be between $MINTIMEOUT and $MAXTIMEOUT seconds.")
		if $timeOut > $MAXTIMEOUT || $timeOut < $MINTIMEOUT;

	(my $uuid, my $ugid) = (getpwuid("mail"))[2,3];

	if ($bulletin) {
	    $error = &check_fname($bulletin);
	    &error($error) if $error;

	    if ($bulletin) {
		if (-d $bulletin) {
		    (my $fuid, my $fgid) = (stat(_))[4,5];

		    &error("Bulletin directory must be owned by mail.")
			if $fuid != $uuid && $fgid != $ugid;
		}
		else {
		    `mkdir -p $bulletin`;
		    $error = $? >> 8;
		    &error("Could not create bulletin directory ($myerror)") if $error;
		    chown $uuid, $ugid, $bulletin;
		}
	    }
	}
}

sub error {
	&error_block($_[0]);
	&generic;
	exit 0;
}

sub enablePOP {
	$value = "pop-3\tstream\ttcp\tnowait\troot\t/usr/freeware/lib/popper";
	if ($query->param('n_dflag') eq 'Yes') { $value .= " -d"; }
	if ($query->param('n_sflag') eq 'Yes') { $value .= " -s"; }
	if ($query->param('n_tmout') ne '120') { 
		$value .= " -T " . $query->param('n_tmout'); }
	if ($query->param('n_tfile')) { 
		$value .= " -t " . $query->param('n_tfile'); }
	if ($query->param('n_bdir')) { 
		$value .= " -b " . $query->param('n_bdir'); }
	
	&putEntry($conf,"pop-3",$value);

	$message = "POP3 mail server enabled.";
}

sub disablePOP {
	if ($epop eq "Yes") { &commentEntry($conf,"pop-3"); }

	$message = "POP3 mail server disabled.";
}

sub commentEntry {
	local($file) = $_[0];
	local($entry) = $_[1];
	local($len) = length($entry);

	open(IN,"< $file");
	open(OUT,"> $dummy");
	while(<IN>) {
		if ($entry eq substr($_,0,$len)) {
			print OUT "# ",$_;
		} else { print OUT $_; }
	}
	close(IN);
	close(OUT);
	rename($dummy,$file) || &error("Unable to rename to $file");
}

sub putEntry { 
	local($file) = $_[0];
	local($key) = $_[1];
	local($val) = $_[2];

	open(IN,"< $file");
	open(OUT,"> $dummy");
	local($found) = 0;
	while(<IN>) {
		if (/^$key/ || /^#\s*$key/) {
			print OUT $val,"\n";
			$found = 1;
		} else { print OUT $_; }
	}
	if ($found == 0) { print OUT $val,"\n"; }
	close(IN);
	close(OUT);
	rename($dummy,$file) || &error("Unable to rename to $file");
}

sub getValues {
    	$dflag = "No";
    	$sflag = "No";
    	$tfile = "";
    	$tmout = 120;	# Default timeout value in seconds
    	$dftmout = 120;
    	$bdir = "";
	$epop = "No";		# only set this to "Yes" if we find line
	if (open(INETD, "< $conf")) {
     	    while (<INETD>) {
		@items = split(/\s+/);
		if ($items[0] ne "pop-3") { next; }
		$epop = "Yes";
		while ($arg = shift(@items)) {
	    	    if ($arg eq "-d") { $dflag = "Yes"; }
	    	    if ($arg eq "-s") { $sflag = "Yes"; }
	    	    elsif ($arg eq "-t") { $tfile = shift(@items); }
	    	    elsif ($arg eq "-T") { $tmout = shift(@items); }
	    	    elsif ($arg eq "-b") { $bdir = shift(@items); }
	    	}
	    }
	}
  	close(INETD);
}

sub generic {
	&header_block($title);

	print "<i>$message</i>";
  
	print $query->startform;
	print "<center><table cellpadding=5 width=450>\n";

	print "<tr><th align=left>Enable POP3 mail server:\n",
      		"<th align=left>",
      		$query->radio_group(-name=>'n_popsrv',
			  -values=>['Yes', 'No'],
			  -default=>$epop), "</tr>";

	print "<tr><th align=left>Record debugging information:\n",
      		"<th align=left>",
      		$query->radio_group(-name=>'n_dflag',
			  -values=>['Yes', 'No'],
			  -default=>$dflag), "</tr>";

	print "<tr><th align=left>Log POP3 mail events:\n",
      		"<th align=left>",
      		$query->radio_group(-name=>'n_sflag',
			  -values=>['Yes', 'No'],
			  -default=>$sflag), "</tr>";

	print "<tr><th align=left>Enter filename to enable tracing:\n", 
		"<th align=top>",
      		$query->textfield(-name=>'n_tfile', -default=>$tfile,
			-size=>20, -maxlength=>256), "</tr>";

	print "<tr><th align=left>Enter directory to enable bulletin 
		posting:\n","<th align=top>",
      		$query->textfield(-name=>'n_bdir', -default=>$bdir,
			-size=>20, -maxlength=>256), "</tr>";

	print "<tr><th align=left>POP3 client session timeout 
		(seconds):\n","<th align=left>",
      		$query->textfield(-name=>'n_tmout', -default=>$tmout,
			-size=>8, -maxlength=>6), "</tr>";

	print "</table></center><br>";

	&button_table($query, "doit", "Ok", "help", "Help");

	print $query->endform;
}
