#!/usr/bin/perl5

# ppp-in.cgi
# Scott A. Hotes, 3 / 25 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/passwd";
$dummy = "/etc/passwd.temp";
$myname = "ppp-in.cgi";
$title = "Dial-in PPP Accounts";

print "Content-type: text/html\n\n";
&title_block($title);

if ( ! -e "/usr/etc/ppp" ) {
    &header_block($title);
    print "<i>PPP software not installed.  Install subsystem 
		</i><b>eoe.sw.ppp</b><i> from the 6.2 CD.</i>";
    exit 0;
}

&get_fields;

&getAccounts;

if (%fld) {
    $fld{'chosen'} =~ s/\W//g;

    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    if ($fld{'add'}) {
	&error(2,"Login name required.") if !$fld{'new_account'};
	@test = getpwnam($fld{'new_account'});
	&error(2,"Account already exists.") if $test[0];
	&error(2,"Invalid login name.") 
	    if $fld{'new_account'} =~ /$METACHARS/o || $fld{'new_account'} =~ /\s/; 
	$val{'login'} = $fld{'new_account'}; 
	&addAccount; 
    }
    if ($fld{'delete'}) {
	&error(2,"To delete an existing account, first select an account from
	    list, then click the delete button.") if !$fld{'chosen'};
	$message = qq|Click "Ok" to save changes.|;
	&generic($fld{'chosen'}); 
    }
    if ($fld{'edit'}) {
	&error(2,"To edit an existing account, first select an account from
	    list, then click the edit button.") if !$fld{'chosen'};
	$val{'login'} = $fld{'chosen'}; 
	&editAccount; 
    }
    if ($fld{'doedit'}) { &formValid_doEdit; &doEdit; &getAccounts; &generic; }
    if ($fld{'doit'}) { &tryToDelete; &getAccounts; &generic; }
    if ($fld{'doadd'}) { &formValid_doAdd; &doAdd; &getAccounts; &generic; }
} else { &generic; }

sub formValid_doAdd {
    if (!$fld{'password'}) 
	{ &error(0,"You must enter a password."); }
    if ($fld{'password'} ne $fld{'passcheck'}) 
	{ &error(0,"Input passwords not equivalent."); }
    &error(0,"Invalid login name.") if $fld{'login'} =~ /$METACHARS/o;
}

sub formValid_doEdit {
    if ($fld{'password'} ne $fld{'passcheck'}) 
	{ &error(1,"Input passwords not equivalent."); }
    &error(1,"Invalid login name.") if $fld{'login'} =~ /$METACHARS/o;
}

sub error {
    &error_block($_[1]);
    %val = %fld;
    if ($_[0] == 0) { &addAccount; }
    elsif ($_[0] == 1) { &editAccount; }
    else { &generic; }
    exit 0;
}

sub doEdit {
   open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/:/);
	if ($items[0] ne $fld{'chosen'}) { print OUT $_; }
	else { $oldcrypt = $items[1]; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    if ($fld{'password'}) {
	&add_password($fld{'login'},$fld{'password'},0,0,$fld{'login'}." ppp","/","/usr/etc/ppp");
    } else {
	open(OUT,">> $conf");
	print OUT "$fld{'login'}:$oldcrypt:0:0:$fld{'login'} ppp:/:/usr/etc/ppp\n";
	close(OUT);
    }
	
    $message = "Account edited.";
}    
 
sub editAccount {
    &header_block("Edit Dial-in PPP Account");

    print "<form action=$myname method=post>";

    print qq|<input type=hidden name="chosen" value=$fld{'chosen'}>|;

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th align=left>Login name:</th><th align=left>",
	  &text('login',$val{'login'}, 20),"</th></tr>";

    print "<tr><th align=left>Password:</th><th align=left>";
    print qq|<input type=password name="password" size=20>|;
    print "</th></tr>";
    print "<tr><th align=left>(Password again):</th><th align=left>";
    print qq|<input type=password name="passcheck" size=20>|;
    print "</th></tr>";

    print "</table></center>";

    print &buttons('doedit','Ok');

    print "</form></body></html>";
}
    
sub tryToDelete {
    $account = $fld{'del_name'};
    if ($account eq "") { return; }

    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	@items = split(/:/,$line);
	chop $items[6];
	if ($items[6] eq "/usr/etc/ppp" && $items[0] eq $account) {
	    next;
	} else { print OUT $line; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    $message = "Account deleted.";	
}

sub doAdd {
    &add_password($fld{'login'},$fld{'password'},0,0,$fld{'login'}." ppp",
	    "/","/usr/etc/ppp");
    $message = "New account added.";
}

sub addAccount {
    &header_block("Add New Dial-in PPP Account");

    print "<form action=$myname method=post>";

    print "<center><table>";

    print "<input type=hidden name=login value=$val{'login'}>";

    print "<tr><th align=left>Login name:</th><td><tt>",
	  $val{'login'},"</tt></td></tr>";

    print "<tr><th align=left>Password:</th><th align=left>";
    print qq|<input type=password name="password" size=20>|;
    print "</th></tr>";

    print "<tr><th align=left>(Password again):</th><th align=left>";
    print qq|<input type=password name="passcheck" size=20>|;
    print "</th></tr>";

    print "</table></center><br>";

    print &buttons('doadd','Ok');

    print "</form></body></html>";
}

sub getAccounts {
    $i = 0;
    open(IN,"< $conf");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { next; }
	@items = split(/:/,$line);
	chop $items[6];
	if ($items[6] eq "/usr/etc/ppp") {
	    $name[$i] = $items[0];
	    $i++;
	}
    }
    $number = $i;
    close(IN);
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";
    
    if ($_[0]) { print qq|<input type=hidden name="del_name" value=$_[0]>|; }

    if ($number) {
	print "<h3>Account name:</h3><center>";

	print "<table width=400>";

	print qq|<tr><td><input type=submit name="add" value="Add New Account">
	    </td><td><input name="new_account" value="$val{'new_account'}" size=19></td></tr>|;

	print "<tr><td>";
	print qq|<input type=submit name="edit" 
	    value="Edit Selected Account"></td>|;

	undef @locList;
	for ($i=0;$i<$number;$i++) { 
	    if ($_[0] ne $name[$i]) { push(@locList,$name[$i]); }
	}

	print "<td rowspan=2>";

	print &choice_list(*locList,"chosen",20);

	print "</td></tr>";

	print qq|<tr><td><input type=submit name="delete" 
	    value="Delete Selected Account"></td></tr>|;    


	print "</table></center><br>";
    } else {
	print "<i>No existing dial-in PPP accounts.</i><br><br><center>";
	print "<table width=400>";

	print qq|<tr><td><input type=submit name="add" value="Add New Account">
	    </td><td><input name="new_account" value="$val{'new_account'}" size=19></td></tr>|;

	print "<tr><td>";
	print "</table>";
    }

    print &buttons('doit','Ok');

    print "</form></body></html>";
}

