#!/usr/bin/perl5

#.........................................................
#..  routed.cgi											..
#..  Scott A. Hotes  3 / 13 / 96						..
#.........................................................

*MIMETRIC  =  0;
*MAXMETRIC = 16;

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$conf = "/etc/config/routed.options";
$title = "Dynamic Routing";

print $query->header;
&title_block($title);

`/etc/chkconfig routed`;
$out = $? >> 8;
if ($out) { $enabled = "No"; }
else { $enabled = "Yes"; }

&getOptions;

if ($query->param) {
	$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
	$help =~ s/cgi$/hlp/;
	exec $help if ($query->param('help') eq "Help");

	if ($query->param('doit') eq 'Ok') {
		if ($query->param('enable') eq 'Yes') {
		    &formValidation;
		    &writeOptions;
		    $message = "Completed changes.";
		} else { &disable; }
		if (!$message) { $message = "No changes made."; }
	}
}

&generic;

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub writeOptions {
	open (OUT,"> $conf");
	$value = "";

	if ($query->param('sflag') eq "Yes") { 
		$d_sflag = "Yes";
		$value = "s";
	} else { $d_sflag = "No"; }

	if ($query->param('gflag') eq "Yes") { 
		$d_gflag = "Yes";
		$value .= "g";
	} else { $d_gflag = "No"; }

	if ($query->param('qflag') eq "Yes") { 
		$d_qflag = "Yes";
		$value .= "q";
	} else { $d_qflag = "No"; }

	if ($query->param('tflag') eq "Yes") { 
		$d_tflag = "Yes";
		$value .= "t";
	} else { $d_tflag = "No"; }

	if ($query->param('hflag') eq "Yes") { 
		$d_hflag = "No";
		$value .= "h";
	} else { $d_hflag = "Yes"; }

	if ($query->param('mflag') eq "Yes") { 
		$d_mflag = "Yes";
		$value .= "m";
	} else { $d_mflag = "No"; }
	
	if ($value) {print OUT "-$value\n"; }

	if ($query->param('net')) {
		print OUT "-F ",$query->param('net'),",",
			$query->param('metric'),"\n";
		$d_net = $query->param('net');
		$d_metric = $query->param('metric');
	} else { $d_net = ""; $d_metric = "14"; }

	if ($query->param('logf')) {
		print OUT $query->param('logf'),"\n";
		$d_logfile = $query->param('logf');
	} else { $d_logfile = ""; }
    
	close(OUT);

		`/etc/chkconfig routed on`;
		`/etc/killall routed`;
		open(IN,"< /etc/config/routed.options");
		while(<IN>) {
		    chop($_);
		    $configFile .= " $_";
		}
		close(IN);
		`/usr/etc/routed $configFile > /dev/null 2>&1`;
		$enabled = "Yes";
}

sub disable {
	if ($enabled eq 'Yes') {
		`/etc/chkconfig routed off`;
		`/etc/killall routed`;
		$enabled = "No";
		$message = "Dynamic routing disabled.";
	}
}


sub getOptions {
	$d_sflag = "No";
	$d_qflag = "No";
	$d_tflag = "No";
	$d_gflag = "No";
	$d_hflag = "Yes";
	$d_mflag = "No";
	$d_Fflag = "No";
	$d_logfile = $dfl_logfile = "";
	$d_metric = $dfl_metric = 14;
	$d_net = "";

    	open(OPTIONS, $conf) || print "Cannot open $conf";
    	while(<OPTIONS>) {
		if (/^#/) { next; }
		chop;
		@optlist = split(/\s+/);
		$i = 0;
		while ($optlist[$i]) {
	    	    if ($optlist[$i] =~ /^\//) {
			$d_logfile = $optlist[$i];
			last;
	    	    }
	    	    @chars = split(//, $optlist[$i]);
	    	    if ($chars[0] eq "-") {
			if ($chars[1] eq "F") {
		    		@flt = split(/\,/, $optlist[$i+1]);
		    		$d_net = $flt[0];
		    		if ($flt[1] ne "") { $d_metric = $flt[1]; }
		    		$i += 2;
		    		next;
			} 
			$j = 0;
			while ($chars[++$j]) {
			    if    ($chars[$j] eq "s") { $d_sflag = "Yes"; }
			    elsif ($chars[$j] eq "q") { $d_qflag = "Yes"; }
			    elsif ($chars[$j] eq "t") { $d_tflag = "Yes"; }
			    elsif ($chars[$j] eq "g") { $d_gflag = "Yes"; }
			    elsif ($chars[$j] eq "h") { $d_hflag = "No"; }
			    elsif ($chars[$j] eq "m") { $d_mflag = "Yes"; }
			    else { print "Unknown Option $optlist[$i]"; }
			}
	    	    } else { print "Unknown Option $optlist[$i]"; }
	    	    $i++;
		}
	}
	close(OPTIONS);
}

sub formValidation {
	if ($query->param('logf') && $query->param('logf') ne $d_logfile) {
		my $errvar = &check_fname($query->param('logf'), 2);
		&error($errvar) if $errvar; 
	}

	$retNet = $query->param('net');
	&error("Invalid IP address") if $retNet && &check_ipaddr($retNet);
		
	&error("Metric must be between $MINMETRIC and $MAXMETRIC")
		if &check_int($query->param('metric'), $MINMETRIC, $MAXMETRIC);
}

sub error {
	&error_block($_[0]);
	&generic;
	exit 0;
}   

sub generic {
	&header_block($title);

	open(IN,"/usr/OnRamp/bin/htnetwork | ");
	$num = 0;
	while(<IN>) {
	    @items = split(/:/);
	    if ($items[2] == 1) { $num++; }
	}
	close(IN);

	print "<i>$message</i>";

	print $query->startform;

	print "<center><table cellpadding=5 width=450>\n";

	print "<tr><th align=left>Enable dynamic routing:\n",
		"<th align=left>",
      		$query->radio_group(-name=>'enable',
			  -values=>['Yes','No'],
			  -default=>$enabled), "</tr>";

	print "<tr><th align=left>Offer default destination for unknown
		routes:\n","<th align=left>",
      		$query->radio_group(-name=>'gflag',
			  -values=>['Yes','No'],
			  -default=>$d_gflag), "</tr>";

    if ($num == 1) {
	print "<tr><th align=left>Force router to supply network
		information:\n","<th align=left>",
      		$query->radio_group(-name=>'sflag',
			  -values=>['Yes','No'],
			  -default=>$d_sflag), "</tr>";
    } else {
	print "<tr><th align=left>Force router to suppress network
		information:\n","<th align=left>",
      		$query->radio_group(-name=>'qflag',
			  -values=>['Yes','No'],
			  -default=>$d_qflag), "</tr>";
    }

	print "<tr><th align=left>Print all inbound and outbound 
		packets to standard output device:\n","<th align=left>",
      		$query->radio_group(-name=>'tflag',
			  -values=>['Yes','No'],
			  -default=>$d_tflag), "</tr>";

	print "<tr><th align=left>Advertise host routes 
		on the primary interface:\n","<th align=left>",
      		$query->radio_group(-name=>'mflag',
			  -values=>['Yes','No'],
			  -default=>$d_mflag), "</tr>";

	print "<tr><th align=left>Advertise host 
		routes on secondary interfaces:\n","<th align=left>",
      		$query->radio_group(-name=>'hflag',
			  -values=>['Yes','No'],
			  -default=>$d_hflag), "</tr>";

	print "</table><table width=450 cellpadding=5>";

	print "<tr><th align=left>Filename for logging routing events:
		    </th><th align=right>",
      		$query->textfield(-name=>'logf',
			-default=>$d_logfile,
			-size=>20, -maxlength=>256), "</th></tr>";

	print "</table><table width=450 cellpadding=5>";

	print "<tr><th align=left>Filter out routes to network ",
	    $query->textfield(-name=>'net', -default=>$d_net, -size=>15),
	    " and replace with a default route with hop count of: ",
	    $query->textfield(-name=>metric, -size=>3, -default=>$d_metric),
	    "</tr>";

	print "</table></font></center>";

 	print "<br>";

	print &buttons("doit", "Ok", "help", "Help");

	print $query->endform;
}
