:
# common procedures for WebMeter cgi scripts
#

# global controls and variables
#
ERR=false			# boolean, do not change
TRACE_INIT=false		# boolean, do not change
CONTROL=/usr/pcp/pmlogger/control # control file for pmlogger administration
CRONTAB=/var/spool/cron/crontabs/root	# crontab for root
IS_ON=/sbin/chkconfig
PATH=/usr/sbin:/sbin:$PATH:.; export PATH
tmp=/var/tmp/$$
trap "rm -f $tmp.*; exit" 0 1 2 3 15

# preamble ... $1 is <title>
#	   ... $2 is centered <h1> [optional, defaults to $1]
#
_preamble()
{
    cat <<End-of-File
Content-type: text/html

<html>
<head>
<body background="/webdist/images/background.jpeg">
<title>`echo "$1" | sed -e 's/<\([^>]*\)>/\1/g'`</title>
<a>
<center>
<h1>${2-$1}</h1>
</center>
</a>
End-of-File
}

# postscript at the end
#
_postscript()
{
    echo "</body></html>"
}

# internal error botch
#
_yyerror()
{
    if $ERR
    then
	echo "<p>$1</p>"
    else
	ERR=true
	_preamble "WebMeter Administration Error" 
	cat <<End-of-File
<hr>
<h3>Internal botch in `basename $0` script</h3>
<p>$1</p>
End-of-File
    fi
}

# generic user error reporting
#
_yywarn()
{
    _preamble "WebMeter Administration Error"
    cat <<End-of-File
<hr>
<h3>User input error for `basename $0` script</h3>
<p><font +2>$1</font></p>
End-of-File
    if [ "X$2" != X ]
    then
	cat <<End-of-File
<hr>Return to the <a href="$SCRIPT_NAME"><strong>$2</strong></a> page.
End-of-File
    fi
    _postscript
    exit
}

# wrap up generic error reporting
#
_yyfail()
{
    cat <<End-of-File
<hr>
<h3>Please contact your Silicon Graphics support office.</h3>
End-of-File
    _postscript
    exit
}

# error check before mainline, and standard set up
#
_yycheck()
{
    $ERR && _yyfail

    # for any subsequent CGI scripts
    #
    unset QUERY_STRING CONTENT_LENGTH
    REQUEST_METHOD=GET; export REQUEST_METHOD
    export SCRIPT_NAME
}

# generic CGI tracing
#
_trace()
{
    $TRACE || return

    if $TRACE_INIT
    then
	:
    else
	TRACE_INIT=true
	if [ ! -f /tmp/cgi.trace ]
	then
	    touch /tmp/cgi.trace
	    chmod 777 /tmp/cgi.trace
	fi
	echo >>/tmp/cgi.trace
	date >>/tmp/cgi.trace
	echo "$0" >>/tmp/cgi.trace
	echo "cwd=`pwd`" >>/tmp/cgi.trace
    fi
    echo "$1=\"$2\"" >>/tmp/cgi.trace
}

# undo URL encoding
#
_fix_url()
{
    sed \
	-e 's/+/ /g' \
	-e 's/%21/!/g' -e 's/%22/"/g' -e 's/%23/#/g' -e 's/%24/$/g' \
	-e 's/%25/%/g' -e 's/%26/&/g' -e "s/%27/'/g" -e 's/%28/(/g' \
	-e 's/%29/)/g' -e 's/%2A/*/g' -e 's/%2B/+/g' -e 's/%2C/,/g' \
	-e 's/%2D/-/g' -e 's/%2E/./g' -e 's/%2F/\//g' -e 's/%3A/:/g' \
	-e 's/%3B/;/g' -e 's/%3C/</g' -e 's/%3D/=/g' -e 's/%3E/>/g' \
	-e 's/%3F/?/g' -e 's/%40/@/g' -e 's/%5B/[/g' -e 's/%5C/\\/g' \
	-e 's/%5D/]/g' -e 's/%5E/^/g' -e 's/%5F/_/g' -e 's/%60/`/g' \
	-e 's/%7B/{/g' -e 's/%7C/|/g' -e 's/%7D/}/g' -e 's/%7E/~/' \
	-e 's/%A0/ /g'
}

# check for expected parameter names
#
_check_name()
{
    __a=`echo $1 | sed -e 's/=.*//'`
    shift
    [ "X$*" = X ] && return 0
    for __b
    do
	[ "X$__a" = "X$__b" ] && return 0
    done
    return 1
}

# handle FORM methods
#	- call _default to set defaults
#	- if GET and no parameters, call _current and _home, then exit
#	- else get parameters, then return
# args here define expected parameter names
#
_form()
{
    if $TRACE
    then
	_trace REMOTE_ADDR "$REMOTE_ADDR"
	_trace SERVER_NAME "$SERVER_NAME"
	_trace SERVER_PORT "$SERVER_PORT"
	_trace SCRIPT_NAME "$SCRIPT_NAME"
	_trace REQUEST_METHOD "$REQUEST_METHOD"
	_trace QUERY_STRING "$QUERY_STRING"
	_trace "IAM" "`id`"
    fi

    # in case not all variables set in the current form, get defaults
    #
    _default

    if [ "$REQUEST_METHOD" = "GET" -a -z "$QUERY_STRING" ]
    then
	# GET and no parameters, dispay current state
	_current
	_home
	exit
    fi

    # get parameters for _form
    #
    SFS="$IFS"
    if [ -n "$QUERY_STRING" ]
    then
	# response read from $QUERY_STRING expected to be of the
	# form
	#	name=value&name=value&name=value&...
	#
	IFS="&$IFS"
	set - $QUERY_STRING
    else
	# response from standard input expected to be in the form
	#	name=value&name=value&name=value&...
	_trace CONTENT_LENGTH "$CONTENT_LENGTH"
	data=`dd ibs=1 count=$CONTENT_LENGTH 2>/dev/null`
	_trace CONTENT "$data"
	IFS="&$IFS"
	set - $data
    fi
    IFS="$SFS"

    PARAMS=""
    for __e
    do
	if [ "X$PARAMS" = X ]
	then
	    PARAMS="$__e"
	else
	    PARAMS="$PARAMS $__e"
	fi
    done
}


# decode and check form parameters
#
_decode_params()
{

    # build set for expected parameter names
    #
    __c=""
    for __d
    do
	__c="$__c $__d"
    done

    rm -f $tmp.extra $tmp.seen
    touch $tmp.extra $tmp.seen
    for __f in $PARAMS
    do
	__f=`echo "$__f" | _fix_url`
	_trace arg "$__f"
	case "$__f"
	in
	    # debug, special case
	    #
	    debug=*)
		eval $__f
		set $debug
		;;
	    
	    # recognized variable assignments
	    #
	    *)
		if _check_name "$__f" $__c
		then
		    __n=`echo "$__f" | sed -e 's/=.*//'`
		    if grep "^$__n\$" $tmp.seen >/dev/null
		    then
			# seen this one before, save previous assignment
			eval echo "$__n=\\\"\$$__n\\\"" >>$tmp.extra
		    fi
		    echo "$__n" >>$tmp.seen
		    eval `echo "$__f" | sed -e "s/'/\\'/g" -e "s/=/='/" -e "s/\$/'/"`
		else
		    # bogus?
		    _yyerror "Unknown variable assignment: $__f"
		fi
		;;
	esac
    done

    # check for errors and setup
    _yycheck
}

# get current pmlogger status
#
_pmlogger_status()
{
    rm -f $tmp.status
    version=1.0
    cat $CONTROL \
    | while read host primary socks dir args
    do
	case "$host"
	in
	    \#*|'')	# comment or empty
		    continue
		    ;;
	    \$*)	# in-line shell command
		    cmd=`echo "$host $primary $socks $dir $args" | sed -e 's/^\\$//'`
		    eval $cmd
		    continue
		    ;;
	esac

	if [ "$version" = "1.0" ]
	then
	    args="$dir $args"
	    dir="$socks"
	    socks=n
	fi

	if [ ! -d $dir ]
	then
	    # _error "archive directory ($dir) does not exist"
	    continue
	fi
	cd $dir

	if [ "X$primary" = Xy ]
	then
	    if [ "X$host" != X`hostname` ]
	    then
		# _error "\"primary\" only allowed for localhost (not $host)"
		continue
	    fi

	    pid=`ps -ef \
		 | sed -n \
		     -e '/grep/d' \
		     -e 's/$/ /' \
		     -e '/\/usr\/pcp\/bin\/pmlogger .*-P /p' \
		 | nawk '{print $2}'`
	else
	    pid=`ps -ef \
		 | sed -n \
		     -e '/grep/d' \
		     -e 's/$/ /' \
		     -e "/\/usr\/pcp\/bin\/pmlogger .*-h *$host /p" \
		 | nawk '{print $2}'`
	fi

	[ "X$pid" = X ] && pid=0

	config=/usr/pcp/pmlogger/config
	xxx=`echo " $args" \
		| sed -n -e 's/.*-c *//p' | sed -e 's/ .*//'`
	[ "X$xxx" != X ] && config=$xxx

	# seems to be Ok
	echo "$pid:$host:$primary:$socks:$dir:$config" >>$tmp.status
    done
}

# check the status of a PMDA
#
_check_pmda()
{
    echo '<hr>'
    if [ "`pminfo -f $1 | grep value`" != "" ]
    then
	echo '<p>Agent is <strong>up</strong>.'
	echo '<p>Exporting ...<br>'
	pminfo -f $2 \
	| awk '
NF==0		{ inInst=0; next }
/ inst /	{ if (inInst==0) mulInst++
		  inInst=1
		  next }
/ value /	{ value++; next }
/^'$2'/		{ metric++
		  if ($0 !~ /:/) next }
		{ warn++ }
END		{ printf "%d metrics and %d warnings (metric instances: %d single and %d multiple).\n", metric, warn, value, mulInst
		}'
    else
	echo '<p>Agent is <blink><strong>down</blink></strong>.'
    fi
}

# find and display a PMDA log
#
_check_log()
{
    for __d in /var/adm/pcplog /var/tmp /tmp
    do
	if [ -f $__d/$1.log ]
	then
	    echo "<p><hr><h3>Log File: $__d/$1.log</h3>"
	    echo '<pre><tt><font -1>'
	    cat $__d/$1.log
	    echo '</font></tt></pre>'
	fi
    done
}

# rebuild htdocs links on the fly, thanks to htmake!
#
if [ ! -d /var/www/htdocs/webface/pcpweb ]
then
    if [ -h /var/www/htdocs/webface/pcpweb ]
    then
	:
    else
	rm -f /var/www/htdocs/webface/pcpweb
	ln -s /usr/pcp/doc/pcpweb /var/www/htdocs/webface/pcpweb
    fi
fi
