#!/usr/bin/perl5

# connect-start.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

if (!$ARGV[0]) { printf("Location: ../%s%c%c","tasks/Tasks.connect-start.cgi",10,10); } 

$myname = "connect-end.cgi?" . $ARGV[0];
$temp = "task.tmp";
$dummy = "task.dummy";

$passwd = "/etc/passwd";
$isdnop = "/etc/config/isdnd.options";
$sendmail = "/etc/sendmail.params";
$hosts = "/etc/hosts";
$resolv = "/etc/resolv.conf";
$ppp = "/etc/ppp.conf";
$modem_file = "/usr/OnRamp/etc/modem.trans";
$devices = "/etc/uucp/Devices";
$systems = "/etc/uucp/Systems";
$confW = "/etc/config/wsyncd.options";
$init = "/etc/inittab";

$it = "<td colsapn=60>";
$ni = "</td>";
$bo = "<td colspan=150><font size=5><i>";
$nb = "</i></font></td>";

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@fields = split('&',$buffer);

foreach (@fields) {
  @line = split('=',$_);
  $line[1] =~ tr/+/ /; 
  $fld{$line[0]} = $line[1];
}

if ($fld{'left.x'}) {
    if ($ARGV[0] eq 'm') { $go = "tasks/connect-modem.cgi?f"; }
    elsif ($ARGV[0] eq 'i') { $go = "tasks/connect-isdn.cgi?f"; } 
    elsif ($ARGV[0] eq 't') { $go = "tasks/connect-t1.cgi?f"; } 
    elsif ($ARGV[0] eq 'e') { $go = "tasks/connect-ether-fddi.cgi?f"; } 
    printf("Location: ../%s%c%c",$go,10,10); 
} elsif ($fld{'cancel'}) { $message = "Network configuration cancelled"; 
} elsif ($fld{'accept'}) {
    &configure;
    print "Location: connect-epitath.cgi\n\n";
}

&readValues;

&generic;

sub configure {
    &readValues;

    $hostName = `/usr/bsd/hostname`;
    chop $hostName;
    if ($hostName =~ /^([^\.]*)\./) { $hostName = $1; }
#    ($name, $dummyb, $dummyc, $dummyd, @dummye) = gethostbyname($hostName);
#    $name =~ /^\w+\.(.*)$/;
#    $domainName = $1;

    $domainName = $terms{'domain'};

    # named
  if (-e "/usr/sbin/named") {
    open(IN,"/usr/OnRamp/bin/htnetwork | ");
    $line = <IN>;
    close(IN);
    @items = split(/:/,$line);
    $IPaddr = $items[3];
    @parts = split(/\./,$IPaddr);
    if ($parts[0] < 128) {	# class A
	$rddan = $parts[0];
	$rddahni = "$parts[3].$parts[2].$parts[1]";
    }
    elsif ($parts[0] < 192) {	# class B
	$rddan = "$parts[1].$parts[0]";
	$rddahni = "$parts[3].$parts[2]";
    }
    else {			# class C
	$rddan = "$parts[2].$parts[1].$parts[0]";
	$rddahni = $parts[3];
    }
    
    @parts = split(/\./,$terms{'provider'});
    if ($parts[0] < 128) {	# class A
	$rddahxe = "$parts[3].$parts[2].$parts[1]";
    }
    elsif ($parts[0] < 192) {	# class B
	$rddahxe = "$parts[3].$parts[2]";
    }
    else {			# class C
	$rddahxe = $parts[3];
    }

    $nmd{'localhost.rev'} = "/var/named";
    $nmd{'named.boot'} = "/etc";
    $nmd{'named.hosts'} = "/var/named";
    $nmd{'named.rev'} = "/var/named";
    foreach $arg (keys(%nmd)) {
		$fileIN = "/usr/OnRamp/etc/" . $arg;
		open(IN,"< $fileIN");
		open(OUT,"> $dummy");
		while(<IN>) {
	    	$_ =~ s/HOSTNAME/$hostName/g;
	    	$_ =~ s/DOMAIN/$domainName/g;
	    	$_ =~ s/RDDAN/$rddan/g;
	    	$_ =~ s/INADDR/$IPaddr/g;
	    	$_ =~ s/EXADDR/$terms{'provider'}/g;
	    	$_ =~ s/RDDAHNI/$rddahni/g;
	    	$_ =~ s/RDDAHXE/$rddahxe/g;
		$_ =~ s/NSADDR/$terms{'nameserver'}/g;

	   	 	print OUT $_;
		}
		close(IN);
		close(OUT);
		$fileOUT = $nmd{$arg} . "/" . $arg;
		rename($dummy,$fileOUT);
	}
  `/etc/chkconfig named on`;
  }

    # sendmail deamon
    open(OUT,"> $sendmail");
    print OUT "rootdomain:$domainName\n";
    print OUT "directdomains:$domainName\n";
    print OUT "forwarders:$terms{'mailserver'}\n";
    close(OUT);

    # /etc/ppp.conf
    $addLine = 1;
    $rename = 0;
    open(OUT,"> $dummy");
    open(IN,"< $ppp");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq 'ppp' && $items[1] eq 'add_route') {
	    @subItems = split(/=/,$items[2]);
	    if ($subItems[0] eq 'remotehost' && 
			$subItems[1] eq $terms{'provider'}) {
		$addLine = 0;
		print OUT $_;
	    } else { $rename = 1; print OUT "# $_"; } 
	} else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    if ($rename) { rename($dummy,$ppp); }
    
    if ($addLine) {
	open(IN,"< $ppp");
	open(OUT,"> $dummy");
	$found = 0;
	while(<IN>) {
	    $line = $_;
	    @items = split(/\s+/,$line);
	    if ($found == 0 && $items[1] eq 'Add' && $items[2] eq 'actual') {
		$found = 1;
		print OUT "$line\n";
		print OUT "ppp\t\tadd_route ";
		print OUT "remotehost=",$terms{'provider'},"\n\n";
	    } else { print OUT $line; }
	}
	if (!$found) {
	    print OUT "\nppp\t\tadd_route ";
	    print OUT "remotehost=",$terms{'provider'},"\n";
	}
	close(IN);
	close(OUT);
	rename($dummy,$ppp);
    }

    # /etc/uucp/Systems
    if ($terms{'phone'}) {
	$phone = $terms{'phone'};
	$phone =~ s/-//g;
	$phone =~ s/\(//g;
	$phone =~ s/\)//g;
    }
    if ($terms{'hardware'} eq 'ISDN') {
	open(IN,"< $isdnop");
	open(OUT,"> $dummy");
	while(<IN>) {
	    $line = $_;
	    if (substr($_,0,2) ne "-t") { print OUT $_; }
	    else { print OUT "# $line"; }
	}
	print OUT "-t $terms{'switch'}";
	if ($terms{'switch'} eq 'DMS100' || $terms{'switch'} eq 'NI1') {
	    print OUT " -s $terms{'spid1'} -s $terms{'spid2'}";
	}
	print OUT "\n";
	close(OUT);
	close(IN);
	rename($dummy,$isdnop);

	`/etc/chkconfig isdnd on`;
	`/etc/init.d/isdnd stop > /dev/null 2>&1`;
	`/etc/init.d/isdnd start > /dev/null 2>&1`; 

	$addLine = 1;
	$commentLine = 0;
	open(IN,"< $systems");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[0] eq 'ppp') {
		if ($items[6] eq 'ISDNCALL[56]' . $phone) {
		    $addLine = 0;
		} else {
		    $commentLine = 1;
		}
	    }
	}
	close(IN);
	if ($commentLine) {
	    @lst = ('ppp','Any','ISDN'); 
	    &comment($systems,*lst); 
	}
	if ($addLine) {
	    `chmod 600 $systems`;
	    open(OUT,">> $systems");
	    print OUT qq|\nppp Any ISDN 38400 "" "" ISDNCALL[56]$phone CONNECTED\n|;
	    close(OUT); 
	    `chmod 400 $systems`;
	}
    } elsif ($terms{'hardware'} eq 'Modem') {
	$addLine = 1;
	$commentLine = 0;
	open(IN,"< $systems");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[0] eq 'ppp') {
		if ($items[3] eq $terms{'speed'} && $items[4] eq $phone) {
		    $addLine = 0;
		} else {
		    $commentLine = 1;
		}
	    }
	}
	close(IN);
	if ($commentLine) {
	    @lst = ('ppp','Any','ACU'); 
	    &comment($systems,*lst); 
	}
	if ($addLine) {
	    `chmod 600 $systems`;
	    open(OUT,">> $systems");
	    print OUT "\nppp Any ACU $terms{'speed'} $phone in:--in: ";
	    print OUT "$terms{'lname'} word: $terms{'lpassword'}\n";
	    close(OUT); 
	    `chmod 400 $systems`;
	}

    } elsif ($terms{'hardware'} eq 'T1') {
	$addLine = 1;
	$commentLine = 0;
	open(IN,"< $systems");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[0] eq 'ppp') {
		if ($items[2] eq 'WAN') {
		    $addLine = 0;
		} else {
		    $commentLine = 1;
		}
	    }
	}
	close(IN);
	if ($commentLine) {
	    @lst = ('ppp','Any','WAN'); 
	    &comment($systems,*lst); 
	}
	if ($addLine) {
	    `chmod 600 $systems`;
	    open(OUT,">> $systems");
	    print OUT qq|ppp Any WAN - "" "" PPP CONNECTED\n|;
	    close(OUT); 
	    `chmod 400 $systems`;
	}
    }

    # /etc/uucp/Devices
    if ($terms{'hardware'} eq 'Modem') {
	if ($terms{'speed'} > 2400) { $port = "ttyf"; }
	else { $port = "ttym"; }
	if ($terms{'port'} eq 'Port 1') { 
	    $port .= "1"; $prt = "1";
	    $dport = "ttyd1";
	} else { 
	    $port .= "2"; $prt = "2";
	    $dport = "ttyd2";
	}
	$modem = &getModem($terms{'modem_type'});
	open(OUT,">> $devices");
	print OUT "ACU $port null $terms{'speed'} 212 x $modem\n";
	print OUT "Direct $dport - Any direct\n";
	close(OUT);

	$cmd = &hash_modem($terms{'modem_type'},1,3);
	if ($cmd) { 
	    $cmd = "/etc/uucp/" . "$cmd $prt";
	    `$cmd > /dev/null 2>&1`;
	} 
    } elsif ($terms{'hardware'} eq 'T1') {
	if ($terms{'port'} eq 'Port 1') { $dname = "/dev/gsc/wsty00"; }
	else { $dname = "/dev/gsc/wsty01"; }
	$rename = 0;
	$found = 0;
	open(IN,"< $devices");
	open(OUT,"> $dummy");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[0] ne 'WAN') { print OUT $_; next; }
	    if ($items[1] ne $dname) {
		print OUT "# $_";
		$rename = 1;
		$found = 1;
		print OUT qq|WAN $dname - - direct\n|;
	    } else { print OUT $_; $found = 1; }
	}
	if (!$found) {
	    print OUT qq|WAN $dname - - direct\n|;
	    $rename = 1;
	}
	close(IN);
	close(OUT);
	if ($rename) { rename($dummy,$devices); }
    }	

    # /etc/inittab
    if ($terms{'hardware'} eq 'Modem') {
	$rename = 0;
	if ($terms{'port'} eq 'Port 1') { $port = 1; }
	else { $port = 2; }
	open(IN,"< $init");
	open(OUT,"> $dummy");
	while(<IN>) {
	    @items = split(/:/);
	    if ($items[0] ne "t".$port) { print OUT $_; next; }
	    if ($items[2] ne "off") {
		$items[2] = "off";
		print OUT join(/:/,@items);
		$rename = 1;
	    }
	}
	close(OUT);
	close(IN);
	if ($rename) { rename($dummy,$init); }
    }

    # /etc/resolv.conf
    open(OUT,"> $resolv");
    print OUT "search $domainName\n";
    print OUT "hostresorder nis bind local\n\n";
    print OUT "nameserver 0.0.0.0\n";
    print OUT "nameserver $terms{'nameserver'}\n";
    close(OUT);

    # T1
    if ($terms{'hardware'} eq 'T1') {
	if ($terms{'port'} eq 'Port 1') {
	    &turnOffPort(1);
	    &turnOnPort(0);
	} else {
	    &turnOffPort(0);
	    &turnOnPort(1);
	}

	`/etc/chkconfig wsyncd on`;
    } else {
	`/etc/chkconfig wsyncd off`;
    }

    # ethernet (effects /etc/hosts and /etc/config/ifconfig-[n].options)
    if ($terms{'hardware'} eq 'Ethernet') {
	($eth_type,$eth_label) = split(/ /,$terms{'interface'});
	open(IN,"/usr/OnRamp/bin/htnetwork | ");
	while(<IN>) {
	    @items = split(/:/);
	    if ($eth_type == $items[1]) {
		$oldIP = $items[3]; 
		$num = $items[0]; 
	    }
	}
	close(IN);
	$num++;
	$file = "/etc/config/ifconfig-" . $num . ".options";
	open(OUT,"> $file");
	print OUT "netmask $terms{'netmask'}\n";
	close(OUT);

	open(IN,"hostname | ");
	$hostname = <IN>; chop($hostname);
	close(IN);

	if ($oldIP) { &removeHosts($oldIP); }
	&addHosts($terms{'address'},"gate-".$hostname.".".$terms{'domain'});
	`/usr/etc/ifconfig $eth_label inet $terms{'address'} netmask $terms{'netmask'}`;
    }

    # tighten security
    &nofreepass;
}

sub nofreepass {
	$PASSSOURCEFILE = "/etc/passwd";
	$PASSWORKFILE = "/etc/passwd.tmp";
	open(PASSWORDS, $PASSSOURCEFILE );
	open(PASSOUT,   ">$PASSWORKFILE");

	while (<PASSWORDS>) {
		split(/:/);
		$_[1] = '*' if !$_[1] && $_[0] ne 'root';
		print PASSOUT join(':' ,@_);
	}

	close(PASSOUT);
	close(PASSWORDS);

	rename($PASSWORKFILE,$PASSSOURCEFILE);
	unlink $PASSWORKFILE;
}

sub removeHosts {
    local($rem_ip) = $_[0];
    open(IN,"< $hosts");
    open(OUT,"> $dummy");
    while(<IN>) {
	if (/^#/) {
	    print OUT $_;
	    next;
	}
	if (/^$rem_ip/) {
	    print OUT "# ".$_;
	    next;
	}
	print OUT $_;
    }
    close(OUT);
    close(IN);
    rename($dummy, $hosts);
}

sub addHosts {
    local($add_ip) = $_[0];
    local($add_hs) = $_[1];
    open(OUT,">> $hosts");
    print OUT "$add_ip\t$addhs\n";
    close(OUT);
}

sub getModem {
    $ret = "";
    $key = $_[0];
    open(IN,"< $modem_file");
    while(<IN>) {
	@items = split(/:/);
	if ($key eq $items[1]) {
	    $ret = $items[0];
	    last;
	}
    }
    close(IN);
    return $ret;
}
		
sub readValues {
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	chop $items[1];
	$terms{$items[0]} = $items[1];
    }
    close(IN);
}

sub generic {
    print "Content-type: text/html\n\n";
    print "<html><body bgcolor='c7ded4' background=/tasks/connect-task.bg.gif>";

    print "<i>$message</i>";


    print '<table width=100%>',
	  '<tr><th align=left><h1>Summary</h1></th>',
	  '<th align=right>',
	  '<a href="/newsplash.shtml"><img border=0 src="/tasks/home.gif"></a>',
	  '&nbsp&nbsp<a href="/tasks/Tasks.shtml"><img border=0 src="/tasks/back.gif"></a>',
	  '</tr></table>';

print "<br><br>
Review the information that you entered in the Internet Gateway configuration
forms:<br><br>";

    print "<center><table>";

    if ($terms{'hardware'} eq 'Ethernet or FDDI') {
	@items = split(/\s+/,$terms{'interface'});
	$outHardware = $items[0];
	$outInterface = $items[1];
    } else { $outHardware = $terms{'hardware'}; }

    print "<tr><td>Domain name:</td><td>$terms{'domain'}</td></tr>";
    print "<tr><td>Provider address:</td><td>$terms{'provider'}</td></tr>";
    print "<tr><td>Name server:</td><td>$terms{'nameserver'}</td></tr>";
    print "<tr><td>Mail forwarder:</td><td>$terms{'mailserver'}</td></tr>";
    print "<tr><td></td><td></td></tr>";
    print "<tr><td>Hardware:</td><td>$outHardware</td></tr>";

    if ($terms{'hardware'} eq 'Modem') {
	print "<tr><td>Port:</td><td>$terms{'port'}</td></tr>";
	print "<tr><td>Modem type:</td><td>$terms{'modem_type'}</td></tr>";
	print "<tr><td>Baud rate:</td><td>$terms{'speed'}</td></tr>";
	print "<tr><td>Phone number:</td><td>$terms{'phone'}</td></tr>";
	print "<tr><td>Login name:</td><td>$terms{'lname'}</td></tr>";
	print "<tr><td>Login password:</td><td>$terms{'lpassword'}</td></tr>";
    } elsif ($terms{'hardware'} eq 'ISDN') {
	print "<tr><td>Switch:</td><td>$terms{'switch'}</td></tr>";
	print "<tr><td>Phone number:</td><td>$terms{'phone'}</td></tr>";
	if ($terms{'switch'} eq 'DMS100' || $terms{'switch'} eq 'NI1') {
	    print "<tr><td>SPID #1:</td><td>$terms{'spid1'}</td></tr>";
	    print "<tr><td>SPID #2:</td><td>$terms{'spid2'}</td></tr>";
	}
    } elsif ($terms{'hardware'} eq 'T1') {
	print "<tr><td>Port:</td><td>$terms{'port'}</td></tr>";
    } elsif (substr($terms{'hardware'},0,6) eq 'Ethern') {
	print "<tr><td>Interface:</td><td>$outInterface</td></tr>";
	print "<tr><td>IP address:</td><td>$terms{'address'}</td></tr>";
	print "<tr><td>Netmask:</td><td>$terms{'netmask'}</td></tr>";
    }

    print "</table><br>";

    print qq|<form action=$myname method=post>|;

print "</center>If your entries are correct, select \"Accept and Reboot\" to configure 
and reboot your Silicon Graphics WebForce Internet Gateway. Your Gateway will take four
or five minutes to reboot and restart its networking services. Once
this is done, if you have correctly entered the information supplied by
your Internet Service Provider, you'll be able to access the Internet!<center><br>";

    print "<font size=5><i>";
    print qq|<input type=submit name="accept" value="Accept and Reboot">&nbsp&nbsp|;
    print "</i></font><br><br>";

print "</center>
If you see an error in your entries, select Cancel to delay the 
configuration. Then, use the arrow button to return to the beginning 
of the forms and correct your entries.<center><br>";

    print "<font size=5><i>";
    print qq|<input type=submit name="cancel" value="Cancel">|;
    print "</i></font><br>";
 
    print '</center>';

    print '<input name="left" type="image" border=0 
		src="/tasks/leftarrow.gif" align="right">';

    print "</form></body></html>";
}

sub turnOffPort {
    $nm = $_[0];

    undef @terms;
    $terms[0] = 'wan0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }

    $terms[0] = 'wstyd0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }

    $terms[0] = 'wstyd0'.$nm;
    $terms[1] = 'wan0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }
}

sub turnOnPort {
    $nm = $_[0];

    undef @terms;
    $terms[0] = 'wan0'.$nm;
    if (&lookFor(1,$confW,*terms)) { &uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) { 
	&writeTop($confW,"wan0".$nm."\td\t\t/dev/gsc/wan0".$nm); 
    }

    $terms[0] = 'wstyd0'.$nm;
    if (&lookFor(1,$confW,*terms)) { &uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) { 
	&writeTop($confW,"wstyd0".$nm."\t\td\t/dev/gsc/wstyd0".$nm); 
    }

    $terms[0] = 'wstyd0'.$nm;
    $terms[1] = 'wan0'.$nm;
    if (&lookFor(1,$confW,*terms)) { 
	&uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) {
	if ($nm == 0) { $let = "D"; } else { $let = "E"; }
	&writeBottom($confW,"$terms[0]\t\t$terms[1]\tWSYNCD_SNID=$let"); 
    }
}

sub writeTop {
    local($file) = $_[0];
    local($value) = $_[1];
    $found = 0;
    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	if ($_ eq "%%\n" && $found == 0) {
	    $found = 1;
	    print OUT "$value\n\n%%\n";
	}
	if ($_ eq "\n" && $found == 0) {
	    $found = 1; 
	    print OUT "\n$value\n";
	} else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$file);
}	        

sub writeBottom {
    local($file) = $_[0];
    local($value) = $_[1];
    $found = 0;
    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	if (substr($_,0,2) eq '%%' && $found == 0) {
	    print OUT "%%\n\n$value\n";
	    $found = 1;
	} else { print OUT $_; }
    }
    if ($found == 0) { print OUT "$value\n"; }
    close(IN);
    close(OUT);
    rename($dummy,$file);
}
   
sub uncomment {
    local($file) = $_[0];
    local(*values) = @_[1];

    open(IN,"< $file");
    open(OUT,"> $dummy");
    $fix = "fix";

    while(<IN>) {
	$line = $_;
	if ($line eq "\n") { print OUT "\n"; next; }
	$fix =~ /(fix)/;
	$line =~ /^\s*\#\s*(\S.*)/;
	$line1 = $1;
	@items = split(/\s+/,$line1);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { print OUT "$line1\n"; }
	else { print OUT $line; }
    }
    close(OUT);
    close(IN);
    rename($dummy,$file);
}

sub comment {
    $ret = 0;	
    local($file) = $_[0];
    local(*values) = @_[1];

    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line eq "\n") { print OUT "\n"; next; }
	@items = split(/\s+/,$line);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { print OUT "#$line"; $ret = 1; }
	else { print OUT $line; }
    }
    close(OUT);
    close(IN);
    rename($dummy,$file);
    return $ret;
}

sub lookFor {
    local($ii);
    local($mode) = $_[0];
    local($file) = $_[1];
    local(*values) = @_[2];
    open(IN,"< $file");
    while(<IN>) {
	$line = $_;
	if ($mode == 1) {
	    $line =~ /^\s*\#\s*(\S.*)/;
	    $line1 = $1;
	} else { $line1 = $line; }
	@items = split(/\s+/,$line1);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { close(IN); return 1; }
    }
    close(IN);
    return 0;
}
