#!/usr/bin/perl5

# connect-start.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

$myname = "Tasks.connect-start.cgi";
$temp = "task.tmp";
$data = "task.dummy";
$htnet = "/usr/OnRamp/bin/htnetwork";

$it = "<td align=right>";
$ni = "</td>";
$bo = "<td><font size=5><i>";
$nb = "</i></font></td>";

@find_vals = ('hardware','mailserver');

&get_fields;

  if ($ARGV[0] eq 'loop') { %vals = %fld;  }
  else { &readValues; }

$t1board = &isT1Board;
$eboard = &isSecondEboard;

if ($fld{'left.x'}) {
#    &errorCheck;
#    &writeFile;

    printf("Location: ../%s%c%c","tasks/Tasks.connect-start.cgi?s",10,10);
}

if ($fld{'right.x'}) {
   &errorCheck;
   &writeFile;

    if ($fld{'hardware'} eq 'Modem') { $go = "tasks/connect-modem.cgi?s"; }
    elsif ($fld{'hardware'} eq 'ISDN') { $go = "tasks/connect-isdn.cgi?s"; } 
    elsif ($fld{'hardware'} eq 'T1') { $go = "tasks/connect-t1.cgi?s"; } 
    elsif ($fld{'hardware'} eq 'Ethernet or FDDI') { $go = "tasks/connect-ether-fddi.cgi?s"; } 
    printf("Location: ../%s%c%c",$go,10,10); 
}

&generic;

sub readValues {
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	foreach $arg (@find_vals) {
	    if ($arg eq $items[0]) { 
		if ($items[1] ne "\n") {
		    $vals{$arg} = $items[1];
		    chop $vals{$arg};
		}
	    }
	}
    }
    close(IN);
}

sub errorCheck {
    if ($fld{'mailserver'}) {
	&error("Invalid hostname: $fld{'mailserver'}.") if &check_hostname($fld{'mailserver'});
    }
}

sub isSecondEboard {
    $ret = 0;
    `$htnet > $data`;
    open(IN,"> $data");
    while(<IN>) {
	@items = split(/:/);
	if ($items[0] > 0) { 
	    $ret = 1;
	    $last;
	}
    }
    close(IN);
    return $ret;
}    

sub isT1Board {
    $ret = 0;
    `hinv > $data`;
    open(IN,"> $data");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq 'GIO') { 
	    $ret = 1;
	    $last;
	}
    }
    close(IN);
    return $ret;
}

sub error {
    $error = $_[0];
    &generic;
    exit 0;
}
    
sub writeFile {
    undef %terms;
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	chop $items[1];
	$terms{$items[0]} = $items[1];
    }
    close(IN);
    foreach $arg (@find_vals) {
	$terms{$arg} = $fld{$arg};
    }
    open(OUT,"> $temp");
    foreach $arg (keys(%terms)) {
	print OUT "$arg=$terms{$arg}\n";
    }
    close(OUT);
}

sub generic {
    print "Content-type: text/html\n\n";
    print "<html><body bgcolor='c7ded4' background=/tasks/connect-task.bg.gif>";

    if ($error) {
	print "<font size=4 color=ff0000><b>Error: </b>$error<br></font>";
    }

    print "<i>$message</i>";

    print '<table width=100%>',
	  '<tr><th align=left><h1>Connect to the Internet (continued)</h1></th>',
	  '<th align=right>',
	  '<a href="/newsplash.shtml"><img border=0 src="/tasks/home.gif"></a>',
	  '&nbsp&nbsp<a href="/tasks/Tasks.shtml"><img border=0 src="/tasks/back.gif"></a>',
	  '</tr></table>';

    print qq|<form action="connect-second.cgi?loop" method=post>|;
    
    print '<center><table width=620>';

    @list = ('Modem','ISDN');
    if ($t1board) { push(@list,"T1"); }
    if ($eboard) { push(@list,"Ethernet or FDDI"); }

    print "<tr>$bo Type of hardware connection to your service
		    provider: $nb $it <font size=4>",
	    &select_list("hardware",$vals{'hardware'},*list),
	    "</font>$ni </tr>";

print "<tr><td colspan=2>
The connection between the Internet Gateway and an Internet service provider is 
implemented by a modem and serial line, ISDN service, a T1 line, or Ethernet hardware.
Select the type of hardware that connects the Gateway to your ISP. 
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo Hostname of mail forwarder: $nb $it", 
	    &text("mailserver",$vals{'mailserver'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
(Optional) To forward mail outside of your local network properly, your
Internet Service Provider may have given you a fully qualified hostname 
for forwarding outgoing mail.  If so, enter the hostname here. this field
is not required.
</td></tr>";

    print "</table>";

    print '</center><br>';

    print '<input name="right" type="image" border=0 
		src="/tasks/rightarrow.gif" align="right">';
    print '<input name="left" type="image" border=0 
		src="/tasks/leftarrow.gif" align="right">';

    print "</form></body></html>";
}
