#!/usr/local/bin/perl

$| = 1;                # output NOT buffered
print "Content-Type:\ttext/html\n\n\n";

chop($date = `/bin/date`);   
	# for the 'this page created' line at the bottom

$debug = 0;
$host = $ENV{SERVER_NAME};
$ENV{SCRIPT_NAME} =~ s/([a-zA-Z0-9\.\-_]+)$//;
$program = $1;
$scriptpath = $ENV{SCRIPT_NAME};
$readablepath = "/www/httpdocs/";
$datapath = "formgen/";
$compress = "/usr/local/bin/gzip";
$mail = "/usr/bin/mailx -s 'Form Generation Delivery' ";

## formlib stuff.

if ($ENV{REQUEST_METHOD} eq "POST") { 
 
	require "./formlib.pl" || print "<H1>Can't find formlib:$!";

	&GetFormArgs();        
	# parse arguments passed from FORM (now in %in)
	$ENV{PATH_INFO} ne '' && &GetPathArgs($ENV{PATH_INFO});
	
	if ($debug) {
	
		require "./debugforms.pl";
		&debug;
	}

	$build_doc = $in{BUILD_DOC};
		
	if ($in{BUILD} eq "Begin Document") {
	
		$build_doc =~ s/( |&|\+|\/|\\|,|'|"|!|\$|\*|\(|\))/_/g;
			# strip possible danger characters

		$build_doc =~ s/\.(html|htm|pl)$//i;
			# take html or perl suffix off

		$counter = "";
		
		while (-e "$datapath$build_doc$counter.HEAD") {
			$counter++;
		}
		
		$build_doc .= $counter;
				
		open (DOC, ">$datapath$build_doc.HEAD") || &liedowndie;
		print DOC "<!DOCTYPE HTML PUBLIC \"-//",
				  "IETF//DTD HTML 2.0//EN\">",
				  "<HTML>\n<HEAD>\n<TITLE>$in{TITLE}</TITLE>\n",
				  "\n</HEAD>\n<BODY>\n<!-- Form created by",
				  " $program on $date -->\n",
				  "<!-- For: $in{EMAIL} -->\n";
		close DOC;

		open (LOG, ">>${datapath}${program}.log");
		print LOG "$date : $in{EMAIL}\n";
		close LOG;
				  
		$step = 0;					  
		$table[1] = " CHECKED";			
		$table = 0;

		&toolbar;
		
	} elsif ($in{BUILD} eq "Choose Next Element") {
		
		$table[$in{TABLE_STATUS}] = " CHECKED";
		$step = $in{STEP};
		$table = $in{TABLE_STATUS};
		&toolbar;
	
	} elsif ($in{BUILD} eq "Remove last element") {
		# undo last document element created
		
		$in{STEP} -= 1;
		open (TARGET, "$datapath$build_doc.$in{STEP}");
		print "<B>Removed the following source:</B><P>\n";
		while (<TARGET>) {
			s/</&lt;/g;
			s/>/&gt;/g;
			s/\n$/<BR>/;
			print
		}
		unlink ("$datapath$build_doc.$in{STEP}");
		open (LAST, "$datapath$build_doc".$in{STEP}-1);
		while (<LAST>) {
			$element = $_
		}
		close LAST;
		if ($element =~ /<TR>/) {
			$in{TABLE_STATUS} = 1
		} else {
			$in{TABLE_STATUS} = 0
		}
		&next_element;
		
	} elsif ($in{BUILD} eq "Create Element") {
		print "<HTML>\n",
		"<HEAD><TITLE>Set Element Options</TITLE>\n",
		"</HEAD>\n",
		"<BODY>\n",
		"<H2>Working document: $in{BUILD_DOC}</H2>\n",
		"<FORM METHOD=\"POST\" ",
		"ACTION=\"http://$host$scriptpath$program\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"TABLE_STATUS\" ",
		"VALUE=\"$in{TABLE_STATUS}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"BUILD_DOC\" ",
		"VALUE=\"$in{BUILD_DOC}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"TABLE\" ",
		"VALUE=\"$in{TABLE}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"LINE_BREAK\" VALUE=\"",
		"$in{LINE_BREAK}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"STEP\" ",
		"VALUE=\"$in{STEP}\">\n";
		
		if ($in{ELEMENT_TYPE} eq "FORM") {
		
			if ($in{FORM_ELEMENT} eq "Text or Numeric Input") {
				print "<H3>HTML Form Input Options</H3>\n",
					"<TABLE>\n<TR><TD><B>Label",
					" text:</B></TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"LABEL\" SIZE=",
					"\"20\" ></TD></TR>\n",
					"<TR><TD><B>Name:</B></TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"NAME\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n",
					"<TR><TD><B>Type:</B></TD>\n",
					"<TD><SELECT NAME=\"TYPE\" SIZE",
					" =\"1\">\n",
					"<OPTION>text\n<OPTION>number\n",
					"<OPTION>password\n</SELECT></TD></TR>\n",
					"<TR><TD><B>Value:</B>(if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"VALUE\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n",
					"<TR><TD><B>Size:</B> (if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"SIZE\" SIZE=",
					"\"2\" MAXLENGTH=\"4\"></TD></TR>\n",
					"<TR><TD><B>Maxlength:</B> (if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"MAXLENGTH\" SIZE=",
					"\"2\" MAXLENGTH=\"4\"></TD></TR>\n";

			} elsif ($in{FORM_ELEMENT} eq "Large Text Area") {
				print "<H3>HTML Form Textarea Options</H3>\n",
					"<TABLE>\n<TR><TD><B>Label ",
					"text:</B></TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"LABEL\" SIZE=",
					"\"20\" ></TD></TR>\n",
					"<TR><TD><B>Name:</B></TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"NAME\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n",
					"<TR><TD><B>Value:</B>(if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"VALUE\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n",
					"<TR><TD><B>Rows:</B> (if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"ROWS\" SIZE=",
					"\"2\" MAXLENGTH=\"4\"></TD></TR>\n",
					"<TR><TD><B>Columns:</B> (if ",
					"desired)</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"COLUMNS\" SIZE=",
					"\"2\" MAXLENGTH=\"4\"></TD></TR>\n";
			
			} elsif ($in{FORM_ELEMENT} eq "Hidden Field") {
				print "<H3>HTML Form Hidden Field ",
					"Options</H3>\n",
					"<TABLE>\n<TR><TD><B>Name:",
					"</B></TD>\n</TD>",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"NAME\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n",
				 	"<TR><TD><B>Value:</B></TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"VALUE\" SIZE=",
					"\"20\" MAXLENGTH=\"40\"></TD></TR>\n";
			
			} elsif ($in{FORM_ELEMENT} eq "Radio Button") {
				print "<H3>Radio Button Options</H3>\n",
				"<TABLE>\n<TR><TD><B>Name: </B></TD><TD>",
				"<INPUT TYPE=\"text\" ",
				"NAME=\"NAME\" SIZE=20 MAXLENGTH=40 >",
				"</TD></TR>\n",
				"<TR><TD><B>Number of buttons: ",
				"</B></TD><TD><INPUT TYPE=\"text\" ",
				"NAME=\"NUMBER\" SIZE=2 MAXLENGTH=3 ",
				"VALUE=\"1\" ></TD></TR>\n",
				"<TR><TD><B>Enter Labels for buttons:</B>",
				"(One per row) ",
				"If you wish a button to have a value ",
				"when checked,",
				"add a comma and the value to the ",
				"button's label. i.e.<BR>",
				"<PRE>Label for a button,value for ",
				"button\nAnother label,",
				"another value for the second ",
				"button</PRE>If you do not specify a ",
				"value, the button's label will be ",
				"provided as a value.</TD><TD>",
				"<TEXTAREA NAME=\"LABELS\" ROWS=10 ",
				"COLS=60></TEXTAREA></TD></TR>\n",
				"<TR><TD><B>Number of button to be ",
				"checked</B><BR>(zero for none ",
				"checked)</TD><TD><INPUT TYPE=\"text\" ",
				"NAME=\"CHECKED\" SIZE=2 ",
				"MAXLENGTH=3 VALUE=\"1\" ></TD></TR>\n";
				
			} elsif ($in{FORM_ELEMENT} eq "Checkbox") {
				print "<H3>Check Box Options</H3>\n",
				"<TABLE>\n<TR><TD><B>Name: </B></TD><TD>",
				"<INPUT TYPE=\"text\" ",
				"NAME=\"NAME\" SIZE=20 ",
				"MAXLENGTH=40 ></TD></TR>\n",
				"<TR><TD><B>Number of checkboxes: ",
				"</B></TD><TD><INPUT TYPE=\"text\" ",
				"NAME=\"NUMBER\" SIZE=2 MAXLENGTH=3 ",
				"VALUE=\"1\" ></TD></TR>\n",
				"<TR><TD><B>Enter Labels for checkboxes:</B>",
				"(One per row) If you wish a ",
				"checkbox to have a value when checked,",
				"add a comma and the value to the ",
				"checkbox's label. i.e.<BR>",
				"<PRE>Label for a checkbox,value for ",
				"checkbox\nAnother label,",
				"another value for the second ",
				"checkbox</PRE></TD><TD>",
				"<TEXTAREA NAME=\"LABELS\" ROWS=10 ",
				"COLS=30></TEXTAREA></TD></TR>\n",
				"<TR><TD><B>Number of checkbox to be ",
				"checked</B><BR>(zero for none ",
				"checked)</TD><TD><INPUT TYPE=\"text\" ",
				"NAME=\"CHECKED\" SIZE=2 ",
				"MAXLENGTH=3 VALUE=\"1\" ></TD></TR>\n";
			
			} elsif ($in{FORM_ELEMENT} eq "Select") {
				print "<H3>Select Options</H3>\n",
				"<TABLE>\n",
				"<TR><TD><B>Label: </B></TD><TD><INPUT ",
				"TYPE=\"text\" NAME=\"LABEL\" SIZE=20 >",
				"</TD></TR>\n",
				"<TR><TD><B>Name: </B></TD><TD><INPUT ",
				"TYPE=\"text\" NAME=\"NAME\" SIZE=20 >",
				"</TD></TR>\n",
				"<TR><TD><B>Number of options: ",
				"</B></TD><TD><INPUT TYPE=\"text\" NAME=",
				"\"NUMBER\" SIZE=2 MAXLENGTH=3 VALUE=\"2\" >",
				"</TD></TR>\n<TR><TD><B>Enter options:</B>",
				"(One per row)</TD><TD>",
				"<TEXTAREA NAME=\"OPTIONS\" ROWS=10 ",
				"COLS=60></TEXTAREA></TD></TR>\n",
				"<TR><TD><B>Number of option to be selected",
				"</B><BR>(zero for no selection)",
				"</TD><TD><INPUT TYPE=\"text\" NAME=",
				"\"SELECTED\" SIZE=2 ",
				"MAXLENGTH=3 VALUE=\"1\" ></TD></TR>",
				"<TR><TD><B>Check to allow multiple ",
				"selections:",
				"</B></TD><TD><INPUT TYPE=\"checkbox\" NAME=",
				"\"MULTIPLE\" VALUE=\"yes\"></TD></TR>",
				"<TR><TD><B>How large should the selection ",
				"area",
				" be?</B></TD><TD><INPUT TYPE=\"text\" NAME=",
				"\"SIZE\" SIZE=2 MAXLENGTH=3 VALUE=\"1\"> ",
				"</TD>",
				"</TR>\n";
			
			} elsif ($in{FORM_ELEMENT} eq "Submit") {
				print "<H3>Submit Options</H3>\n",
				"<TABLE>\n<TR><TD><B>Name: </B></TD>\n",
				"<TD><INPUT TYPE=\"text\" NAME=\"NAME\" ",
				"SIZE=20 MAXLENGTH=40 ></TD></TR>\n",
				"<TR><TD><B>Value: </B></TD>\n<TD><INPUT TYPE=",
				"\"text\" NAME=\"VALUE\"  SIZE=20 ",
				"MAXLENGTH=40>",
				"</TD></TR>\n<TR><TD><INPUT TYPE=\"radio\" ",
				"NAME=\"TYPE\" VALUE=\"submit\" CHECKED> ",
				"Submit",
				" Button<BR><INPUT TYPE=\"radio\" ",
				"NAME=\"TYPE\" ",
				"VALUE=\"reset\"> Reset Button</TD></TR>\n";
			}
				
			
			print "<INPUT TYPE=\"hidden\" ",
				"NAME=\"ELEMENT\" VALUE=",
				 "\"$in{FORM_ELEMENT}\">";
				  
		} elsif ($in{ELEMENT_TYPE} eq "HTML") {
		
			if ($in{HTML_ELEMENT} eq "Horizontal Rule") {
				print "<H3>Horizontal Rule Options</H3>",
				"<TABLE><TR>",
				"<TD>Thickness:</TD>",
				"<TD><INPUT TYPE=\"number\" SIZE=\"2\" ",
				"NAME=\"THICK\" MAXLENGTH=\"3\" ",
				"VALUE=\"1\" ></TD>",
				"</TR>",
				"<TR><TD>Width:</TD>",
				"<TD><INPUT TYPE=\"number\" SIZE=\"3\" ",
				"NAME=\"WIDTH\" MAXLENGTH=\"4\" ",
				"VALUE=\"100\" ></TD>",
				"<TD><INPUT TYPE=\"radio\" NAME=\"UNITS\"",
				"VALUE=\"PERCENT\"",
				"CHECKED></TD>",
				"<TD>Percentage</TD>",
				"<TD><INPUT TYPE=\"radio\" NAME=\"UNITS\"",
				"VALUE=\"PIXELS\"></TD>",
				"<TD>Pixels</TD></TR><TR>",
				"<TD>Alignment</TD>",
				"<TD><SELECT NAME=\"ALIGN\">",
				"<OPTION>Default",
				"<OPTION>Center",
				"<OPTION>Left",
				"<OPTION>Right",
				"</SELECT></TD></TR>",
				"<TR><TD>Shaded line:</TD><TD><INPUT",
				" TYPE=\"checkbox\" ",
				"NAME=\"SHADE\" CHECKED></TD>",
				"</TR>";

			} elsif ($in{HTML_ELEMENT} eq "Line Break") {
				print "<H3>Break Options</H3>\n",
					  "<TABLE>\n",
					  "<TR><TD><B>Choose type of ",
					  "break</B></TD>\n",
					  "<TD><SELECT NAME=\"NAME\">\n",
					  "<OPTION>Line Break\n",
					  "<OPTION>Paragraph Break\n",
					  "<OPTION>Word Break\n",
					  "</SELECT></TD></TR>";

			} elsif ($in{HTML_ELEMENT} eq "Heading") {
				print "<H3>Heading Options</H3>\n",
					"<TABLE>\n",
					"<TR><TD><B>Level (1-6): </B></TD>\n",
					"<TD><SELECT NAME=\"LEVEL\">",
					"<OPTION>1\n<OPTION>2\n",
					"<OPTION>3<OPTION>4\n",
					"<OPTION>5\n<OPTION>6\n</SELECT></TD>\n",
					"<TD><B>Alignment: </B></TD>\n",
					"<TD><SELECT NAME=\"ALIGN\">\n",
					"<OPTION>Default\n",
					"<OPTION>Left\n",
					"<OPTION>Right\n",
					"<OPTION>Center\n",
					"</SELECT></TD></TR>\n",
					"<TR><TD COLSPAN=3><B>Heading ",
					"Text:</B></TD>",
					"\n<TD><INPUT TYPE=\"text\" ",
					"NAME=\"TEXT\" ",
					"SIZE=\"45\" ",
					"MAXLENGTH=\"160\"></TD></TR>\n";
				
			} elsif ($in{HTML_ELEMENT} eq "Comment") {

				print "<H3>Comment Options</H3>\n",
					"<TABLE>\n",
					"<TR><TD>Comment text:</TD>\n",
					"<TD><INPUT TYPE=\"text\" ",
					"NAME=\"COMMENT\"",
					" SIZE=\"30\"  MAXLENGTH=\" ",
					"\"120\">\n</TD>",
					"</TR>\n";
			
			} elsif ($in{HTML_ELEMENT} eq "Image") {

				print "<H3>Image Options</H3>\n",
					"<TABLE>\n",
					"<TR><TD>Image URL:</TD>\n",
					"<TD><INPUT TYPE=\"text\" NAME=\"URL\"",
					" SIZE=\"50\"  MAXLENGTH=\"120\"> ",
					"\n</TD>",
					"</TR>\n";			
			
			} elsif ($in{HTML_ELEMENT} eq "Link") {

				print "<H3>Link Options</H3>\n",
					"<TABLE>\n",
					"<TR><TD>Link URL:</TD>\n",
					"<TD><INPUT TYPE=\"text\" NAME=\"URL\"",
					" SIZE=\"50\"  ",
					"MAXLENGTH=\"120\" >\n</TD>",
					"</TR>\n<TR><TD>Link Text:</TD>\n",
					"<TD><INPUT TYPE=\"text\" NAME=\"LINK\"",
					" SIZE=\"50\"  ",
					"MAXLENGTH=\"120\" >\n</TD>",
					"</TR>";			
			
			} elsif ($in{HTML_ELEMENT} eq "Text") {
				
				print "<H3>Text Options</H3>",
					"<TABLE>",
					"<TR><TD>Enter Text:</TD>",
					"<TD><TEXTAREA NAME=\"TEXT\" ROWS=\"5\"",
					" COLS=\"60\"></TEXTAREA></TD>",
					"</TR>",
					"<TR><TD>Choose text style:</TD>",
					"<TD><SELECT NAME=\"STYLE\">",
					"<OPTION>Plain",
					"<OPTION>Bold",
					"<OPTION>Italic",
					"<OPTION>Preformatted",
					"</SELECT></TD></TR>";

			}
			
			print "<INPUT TYPE=\"hidden\" NAME=\"ELEMENT\" ",
				  "VALUE=\"$in{HTML_ELEMENT}\">";

		}
		
		print "</TABLE><BR>\n",
			  "<INPUT TYPE=\"submit\" NAME=\"BUILD\" VALUE=",
			  "\"Set Options\">\n</FORM>\n</BODY>\n";
		
		&footer;
	
	} elsif ($in{BUILD} eq "Set Options") { 
		# create actual HTML object in working doc
	
		open (DOC, "> $datapath$build_doc.$in{STEP}");
		$step = $in{STEP} + 1;
		
		if ($in{TABLE_STATUS} != $in{TABLE}) {
			if ($debug) {
				print "table status has changed<P>";
			}
			
			if ($in{TABLE}) {
				print DOC "<TABLE>\n<TR>\n";
			} else {
				print DOC "</TABLE>";
			}
			
			close DOC;
			$in{STEP}++;
			open (DOC, "> $datapath$build_doc.$in{STEP}");
			$step = $in{STEP} + 1;	
					
		} 
		
		if ($in{TABLE}) {
			$td="<TD>";
			$endtd="</TD>";
		}
		
		if ($in{ELEMENT} eq "Text or Numeric Input") {
			if ($in{LABEL}) {
				print DOC "$td$in{LABEL}$endtd\n";
			} 
			print DOC "$td<INPUT TYPE=\"$in{TYPE}\" ",
					  "NAME=\"$in{NAME}\" ";
			
			if ($in{SIZE}) {
				print DOC "SIZE=\"$in{SIZE}\" ";
			}
			if ($in{MAXLENGTH}) {
				print DOC " MAXLENGTH=\"$in{MAXLENGTH}\" ";
			}
			if ($in{VALUE}) {
				print DOC " VALUE=\"$in{VALUE}\" ";
			}
			print DOC ">$endtd\n";
			
			&line_break;
										    
		} elsif ($in{ELEMENT} eq "Large Text Area") {
			if ($in{LABEL}) {
				print DOC "$td$in{LABEL}$endtd\n";
			} 
			
			print DOC "$td<TEXTAREA NAME=\"$in{NAME}\" ";
			
			if ($in{ROWS}) {
				print DOC "ROWS=\"$in{ROWS}\" ";
			}
			
			if ($in{COLUMNS}) {
				print DOC "COLS=\"$in{COLUMNS}\" ";
			}
			
			print DOC ">";
		
			if ($in{VALUE}) {
				print DOC "$in{VALUE}";
			}	
			
			print DOC "</TEXTAREA>$endtd\n";
			
			&line_break;
			
		} elsif ($in{ELEMENT} eq "Hidden Field") {
			print DOC "<INPUT TYPE=\"hidden\" NAME=\"$in{NAME}\"",
				" VALUE=\"$in{VALUE}\">";
			
			&line_break;
		
		} elsif ($in{ELEMENT} eq "Radio Button") {
					
			$in{LABELS} =~ s/\r//g; 
			# strip carriage returns and line feeds
			@buttons = split(/\n/, $in{LABELS});
			
			for ($i = 0; $i <= $#buttons; $i++) {
				if ($debug) {
					print "Loop index $i<P>";
				}
				
				if ($td eq "<TD>") {
					$td1 = "<TD ALIGN=RIGHT>"
				}
				
				@butt = split (',', $buttons[$i]);
				print DOC "$td1<INPUT TYPE=\"radio\" NAME=\"",
					"$in{NAME}\"";
				
				if ($butt[1]) { 
					# there is a value for the button
					print DOC " VALUE=\"$butt[1]\"";
				} else {
					print DOC " VALUE=\"$butt[0]\"";
				}
				
				if ($i == ($in{CHECKED} - 1)) {
					print DOC " CHECKED";
				}
				
				print DOC ">$endtd\n";
				
				print DOC "$td$butt[0]$endtd\n";
				
				if ($in{LINE_BREAK}) { 
					if ($in{TABLE}) {
						print DOC "</TR>\n<TR>";
					} else {
						print DOC "<BR>";
					}
				}	
			
			}									
			
		} elsif ($in{ELEMENT} eq "Checkbox") {
			
			if ($td eq "<TD>") {
				$td1 = "<TD ALIGN=RIGHT>"
			}
			
			$in{LABELS} =~ s/\r//g; # strip line feeds
			@boxes = split(/\n/, $in{LABELS});
			
			for ($i = 0; $i <= $#boxes; $i++) {

				@box = split (',', $boxes[$i]);
				print DOC "$td1<INPUT ",
					"TYPE=\"checkbox\" NAME=\"",
					"$in{NAME}\"";
				
				if ($box[1]) { 
					# there is a value for the button
					print DOC " VALUE=\"$box[1]\"";
				} else {
					print DOC " VALUE=\"$box[0]\"";
				}
				
				if ($i == ($in{CHECKED} - 1)) {
					print DOC " CHECKED";
				}
				
				print DOC ">$endtd\n";
				
				print DOC "$td$box[0]$endtd\n";
				
				if ($in{LINE_BREAK}) { 
					if ($in{TABLE}) {
						print DOC "</TR>\n<TR>";
					} else {
						print DOC "<BR>";
					}
				}	

			
			}									
		} elsif ($in{ELEMENT} eq "Select") {
			
			print DOC "$td$in{LABEL}$endtd\n";
			
			print DOC "$td<SELECT NAME=\"$in{NAME}\"";
			
			if ($in{SIZE} > 1 ) {
				print DOC " SIZE=$in{SIZE}";
			}
			
			if ($in{MULTIPLE} eq "yes") {
				print DOC " MULTIPLE";
			}

			print DOC ">\n";
			
			unless ($in{SELECTED} == 1) {
				$select[$in{SELECTED} - 1] = " SELECTED";
			}
			
			$in{OPTIONS} =~ s/\r//g; 
				# strip carriage returns and line feeds
			@option = split(/\n/, $in{OPTIONS});
			
			for ($i = 0; $i <= $#option; $i++) {
				print DOC "<OPTION$select[$i]>$option[$i]\n";
			}
			
			print DOC "</SELECT>$endtd";

			&line_break;
			
		} elsif ($in{ELEMENT} eq "Submit") {
		
			print DOC "$td<INPUT TYPE=\"$in{TYPE}\" NAME=",
				"\"$in{NAME}\" VALUE=\"$in{VALUE}\">$endtd";
				
			&line_break;
			
		} elsif ($in{ELEMENT} eq "Horizontal Rule") {
			
			
			if ($in{TABLE}) {
				print DOC "</TR>\n</TABLE>\n";
			}
						
			print DOC "<HR";
			
			if ($in{SHADE} ne "on") {
				print DOC " NOSHADE";
			}
			
			if (!(($in{WIDTH}==100)&&($in{UNITS} eq "PERCENT"))) {
				print DOC " WIDTH=\"$in{WIDTH}";
				
				if ($in{UNITS} eq "PERCENT") {
					print DOC "%"
				}
				print DOC "\"";
			}
			
			if ($in{THICK} != 1) {
				print DOC " SIZE=$in{THICK}";
			}
			
			if ($in{ALIGN} ne "Default") {
				print DOC " ALIGN=\"$in{ALIGN}\"";
			}
			
			print DOC ">\n";
			
			if ($in{TABLE}) {
				print DOC "<TABLE>\n<TR>\n";
			}
		
		} elsif ($in{ELEMENT} eq "Line Break") {
			
			print DOC "$td";
			
			if ($in{NAME} eq "Line Break") {
				print DOC "<BR>"
			} elsif ($in{NAME} eq "Paragraph Break") {
				print DOC "<P>"
			} elsif ($in{NAME} eq "Word Break") {
				print DOC "<WBR>"
			}
			
			print DOC "$endtd";
			
			&line_break
			
		} elsif ($in{ELEMENT} eq "Heading") {
		
			print DOC "$td<H$in{LEVEL}";

			if ($in{ALIGN} ne "Default") {
				print DOC " ALIGN=\"$in{ALIGN}\"";
			}
			
			print DOC ">$in{TEXT}",
				  	  "</H$in{LEVEL}>$endtd\n";

			&line_break	
				
					  					
		} elsif ($in{ELEMENT} eq "Comment") {
		
			print DOC "$td<!-- $in{COMMENT} -->$endtd";
			
			&line_break
		
		} elsif ($in{ELEMENT} eq "Image") {
		
			print DOC "$td<IMG SRC=\"$in{URL}\">$endtd";
			
			&line_break
		
		} elsif ($in{ELEMENT} eq "Link") {
		
			print DOC "$td<A HREF=\"$in{URL}\">",
					  "$in{LINK}</A>$endtd";
					  
			&line_break
			
		} elsif ($in{ELEMENT} eq "Text") {
		
			if ($in{STYLE} eq "Bold") {

				$style = "B";

			} elsif ($in{STYLE} eq "Italic") {
				
				$style = "I";
			
			} elsif ($in{STYLE} eq "Preformatted") {
				
				$style = "PRE";
				
			}
			
			unless ($in{STYLE} eq "Plain") {
				print DOC "$td<$style>$in{TEXT}</$style>$endtd";
				
			} else {
				print DOC "$td$in{TEXT}$endtd";
			}
			
			&line_break
		}
		
		close DOC;
		print "Added $in{ELEMENT}\n<P>";			
		$table[$in{TABLE}] = " CHECKED";
		$table = $in{TABLE};
		&toolbar;
		

		
											
	} elsif ($in{BUILD} eq "View Source") {
		
		print "<HTML><HEAD><TITLE>View $in{BUILD_DOC}",
			   " Source</TITLE>\n";
			   
		print "<PRE>\n";
		
		open (HEAD, "$datapath$in{BUILD_DOC}.HEAD");
		
		while (<HEAD>) {
			s/</&lt;/g;
			s/>/&gt;/g;
			print
		}
		
		close HEAD;
		
		for ($loop = 0; $loop <= $in{STEP}; $loop++) {
			open (PART, "$datapath$in{BUILD_DOC}.$loop");
			while (<PART>) {
				s/</&lt;/g;
				s/>/&gt;/g;
				print 
			}
			close PART;
		}

		
		print "</PRE>\n";				
		
		&next_element;
	
	} elsif ($in{BUILD} eq "Preview Document") {
		
		
		open (HEAD, "$datapath$in{BUILD_DOC}.HEAD");
		print while <HEAD>;
		close HEAD;
		
		print "<FORM ACTION=\"http://$host$scriptpath$program\"",
			  " METHOD=\"POST\">\n";
		
		for ($loop = 0; $loop < $in{STEP}; $loop++) {
			open (PART, "$datapath$in{BUILD_DOC}.$loop");
			print while <PART>;
			close PART;
		}
		
		print "</TABLE>\n</FORM>\n";
		
		&next_element;				
	
	} elsif ($in{BUILD} eq "End Document") {
	
			print "<HTML><HEAD><TITLE>Complete $in{BUILD_DOC} ",
			"Construction</TITLE></HEAD>\n<BODY>\n",
			"<FORM ACTION=\"http://$host$scriptpath$program\"",
			" METHOD=\"POST\">\n",
			"<TABLE><TR><TD COLSPAN=2><H2>Build Form",
			"</H2></TD></TR>",
			"<TR><TD><FONT SIZE=-1>Supply name of host: <BR>",
			"(If not $host)</TD>",
			"<TD VALIGN=top><INPUT TYPE=\"text\" NAME=\"HOST\" ",
			"SIZE=\"20\"></TD></TR>",
			"<TR><TD COLSPAN=2><B>Choose the desired method for",
			" delivering the form to you.</B></TD></TR>",
			"<TR><TD><INPUT TYPE=\"radio\" NAME=\"METHOD\"",
			"VALUE=\"view\" CHECKED></TD>",
			"<TD>View form on your Web browser</TD>",
			"</TR>",
			"<TR><TD><INPUT TYPE=\"radio\" NAME=\"METHOD\"",
			"VALUE=\"download\"></TD>",
			"<TD>Download form to your local machine</TD>",
			"</TR>",
			"<TR><TD><INPUT TYPE=\"radio\" NAME=\"METHOD\"",
			"VALUE=\"email\"></TD>",
			"<TD>E-mail the form to you</TD>",
			"</TR>",
			"<TR><TD><INPUT TYPE=\"radio\" NAME=\"METHOD\"",
			"VALUE=\"install\"></TD>",
			"<TD>Install the form on $host</TD>",
			"</TR>",
			"<TR></TABLE><B>Choose options for final building of",
			" form:</B><BR><TABLE>",
			"<TD><INPUT TYPE=\"checkbox\" NAME=\"OPTIONS\"",
			"VALUE=\"perl\"></TD>",
			"<TD>Make self-contained Perl script</TD>",
			"</TR>\n",
			"<TR><TD></TD>",
			"<TD><FONT SIZE=-1>Supply path for perl:<BR>",
			"(If other than /usr/local/bin/perl)</FONT></TD>\n",
			"<TD><INPUT TYPE=\"text\" NAME=\"PERL\" SIZE=",
			"\"20\"></TD></TR>\n",
			"<TR><TD><INPUT TYPE=\"checkbox\" NAME=\"OPTIONS\"",
			"VALUE=\"validate\"></TD>",
			"<TD>Validate HTML source</TD>",
			"</TR></TABLE>",
			"<INPUT TYPE=\"hidden\" NAME=\"BUILD_DOC\" ",
			"VALUE=\"$in{BUILD_DOC}\">\n",
			"<INPUT TYPE=\"hidden\" NAME=\"STEP\" VALUE=\"",
			"$in{STEP}\">\n",
			"<INPUT TYPE=\"submit\" NAME=\"BUILD\" VALUE=\"",
			"Deliver Completed Form\">";
			
			&footer;

	} elsif ($in{BUILD} eq "Deliver Completed Form") {
		
		$program =~ /(.*)\.pl/;
		$progname = $1;

		print "<HTML>\n<HEAD>\n<TITLE>Completed Form: $build_doc",
			  "</TITLE>\n</HEAD>\n<BODY>\n";
		
		if ($in{OPTIONS} =~ /perl/){
			
			$build_final = $build_doc . ".pl";
			
			if ($in{PERL} eq "") {
				chop ($in{PERL} = `which perl`);
			}
			
			if ($in{HOST} eq "") {
				$in{HOST} = "$host/$scriptpath";
			}
			
			$doc[0] = "#!$in{PERL}\n";
			$doc[1] = "# perl script to both supply and support" .
					  " the $build_doc HTML form\n";
			$doc[2] = "# generated by http://$host$scriptpath" .
					  "$program on $date\n";
			$doc[3] = "\n\n";

			$count = 4;
			
			open (PERL, "${datapath}$progname.perl") ||
			 print "<B>ERROR</B> Can't open ${datapath}",
			 	   "$progname.perl : $!";
			
			while (<PERL>) {
				$doc[$count] = $_;
				$count++
			}
			
			close PERL;
		
		} else {
			
			$build_final = $build_doc . ".html";
			$count = 0
		
		}
		

		open (HEAD, "$datapath$build_doc.HEAD"); 

		while (<HEAD>) {
			
			if ($in{OPTIONS} =~ /perl/){
				chomp;
				$_ =~ s/"/\\"/g;
				$doc[$count] = "\tprint \"" . $_ . "\\n\";\n";
			
			} else {

				$doc[$count] = $_;	
			
			}
			
			$count++;
			
		}
		
		close HEAD;
		#unlink ("$datapath$build_doc.HEAD");
		
		if ($in{OPTIONS} =~ /perl/) {
			$doc[$count] = "\tprint \"<FORM ACTION=\\\"http://" .
		   "$in{HOST}$build_doc.pl\\\" METHOD=\\\"POST\\\">\\n\";\n";
		 } else {
		 	$doc[$count] = "<FORM ACTION=\"http://$in{HOST}" .
		 		"$build_doc.pl\" METHOD=\"POST\">\n";
		 }
		 
		$count++;
		
		for ($loop = 0; $loop <= $in{STEP}; $loop++) {
			open (PIECE, "$datapath$build_doc.$loop");
			
			while (<PIECE>) {
				
				if ($in{OPTIONS} =~ /perl/){
					chomp;
					$_ =~ s/"/\\"/g;
					$_ =~ s/;/:/g;
				$doc[$count] = "\tprint \"" . $_ . "\\n\";\n";
				
				} else {
	
					$doc[$count] = $_;	
				
				}
				
				$count++;
				
			}
			
			#unlink ("$datapath$build_doc.$loop");
			
		}
		
		if ($_ =~ /<TR>/) { 
			# very last line of form contains open row tag
			if ($in{OPTIONS} =~ /perl/){
				$doc[$count] = "\tprint \"</TR></TABLE>\\n\";\n";
			} else {
				$doc[$count] = "</TR></TABLE>\n";
			}
			$count++
		}
		
		open (END, "${datapath}$progname.end") ||
			 print "<B>ERROR</B> Can't open ${datapath}",
			 	   "$progname.end : $!";
		
		while (<END>) {
			if ($in{OPTIONS} =~ /perl/) {
				chomp;
				$_ =~ s/"/\\"/g;
				$doc[$count] = "\tprint \"" . $_ . "\\n\";\n";

			} else {

				$doc[$count] = $_;	
			
			}
			
			$count++;
			
		}
		
		close END;	
		
		if ($in{OPTIONS} =~ /validate/) {
			open (VAL, "${datapath}validate.html");
			while (<VAL>) {
				if ($in{OPTIONS} =~ /perl/) {
					chomp;
					$_ =~ s/"/\\"/g;
					$doc[$count] = "\tprint \"" . 
							   $_ . "\\n\";";
	
				} else {
	
					$doc[$count] = $_;	
				
				}
			
				$count++;
			
			}
		
			close VAL;
		}
		
		if ($in{OPTIONS} =~ /perl/) {
			$doc[$count] = "}";
			$count++;
		}						

		if ($in{METHOD} eq "view") {
			
			print "<PRE>\n";
						
			for ($loop = 0; $loop < $count; $loop++) {
			
				$doc[$loop] =~ s/</&lt;/g;
				$doc[$loop] =~ s/>/&gt;/g;
				print $doc[$loop];
			}
						
			print "</PRE>\n";
			
			&footer;
			
		} elsif ($in{METHOD} eq "download") {
			
			open (FINAL, ">$readablepath" .
					     "$in{BUILD_DOC}.html");
			
			for ($loop = 0; $loop < $count; $loop++) {
				print FINAL $doc[$loop]
			}
			
			close FINAL;
			
			system ("$compress " .					
			"$readablepath$in{BUILD_DOC}.html");

			print "Download <A HREF=\"http://$host/",
				  "$in{BUILD_DOC}.html.gz\">",
				  "$in{BUILD_DOC}.html.gz</A><P>";
			
			&footer;
		
		} elsif ($in{METHOD} eq "email") {
			
			open (ADDRESS, "$datapath$build_doc.HEAD");
			while (<ADDRESS>) {
				/For:\s*(.*\@.*)\-\-/;
				$email = $1
			}
			close ADDRESS;
			
			if (open (MAIL, "|$mail $email")){
			
				for ($loop = 0; $loop < $count; $loop++) {
					print MAIL $doc[$loop]
				}
				
				close MAIL;
			
				print "<H2>Mail sent successfully to $email",
					  "</H2>\n";
					  
			} else {
			
				print "<H2>Error</H2><B>Could not send mail to",
					  " $email.</B><BR>";
			}
						
			&footer;

		} elsif ($in{METHOD} eq "install") {
			
			open (FINAL, ">$datapath$build_final");
		
			for ($loop = 0; $loop < $count; $loop++) {
				print FINAL $doc[$loop]
			}
			
			close FINAL;			
			
			print "<FORM ACTION=\"http://$host$scriptpath",
			  "${datapath}form_install.pl\" METHOD=",
			  "\"POST\">\n<",
			  "INPUT TYPE=\"hidden\" NAME=\"FORM\" ",
			  "VALUE=\"$build_final\">\n",
			  "<TABLE>\n<TR>\n<TD><B>Specified desired target ",
			  "directory:</B></TD>",
			  "<TD><INPUT TYPE=\"text\" NAME=\"TARGET\" SIZE",
			  "=\"20\"></TD></TR>\n",
			  "<TR><TD COLSPAN=2 ALIGN=center><INPUT TYPE",
			  "=\"submit\" VALUE=\"Install Form\"></TD></TR>\n",
			  "</TABLE>";
			  
			  &footer;
		}
	
	}
	
} else {
	print "<HTML>\n",
 	"<HEAD>\n",
	"<TITLE>",
	"$program : Begin Creating Form",
	"</TITLE>\n",
	"</HEAD>\n",
	"<BODY>\n",
	"<FORM ACTION=\"http://$host$scriptpath$program\"",
	" METHOD=\"POST\" >\n",
	"<H1>Form Generation Tool</H1>\n",
	"<H2>Start building your forms here</H2>\n",
	"<BR>\n",
	"If you wish to create an HTML form, enter the data ",
	"asked for below, then click the button labelled ",
	"'Begin Document.'<P>",
	"<TABLE>\n",
	"<TR><TD>Specify a file name<BR>\n",
	"for the new document: </TD>\n",
	"<TD><BR>\n",
	"<INPUT TYPE=\"text\" NAME=\"BUILD_DOC\" SIZE=\"20\"",
	" MAXLENGTH=\"80\"></TD></TR>\n",
	"<TR><TD>\n",
	"HTML title for the document:</TD><TD>\n",
	"<INPUT TYPE=\"text\" NAME=\"TITLE\" SIZE=\"30\" ",
	"MAXLENGTH=\"80\">",
	"</TD></TR>\n",
	"<TR><TH><BR></TH></TR>\n",
	"<TR><TD>Please enter your e-mail address: </TD><TD>\n",
	"<INPUT TYPE=\"text\" NAME=\"EMAIL\"",
	" SIZE=\"30\" MAXLENGTH=\"80\"></TD></TR>\n</TABLE>\n",
	"<CENTER><INPUT TYPE=\"submit\" NAME=\"BUILD\" VALUE=\"Begin",
	" Document\"></CENTER>\n",
	"</FORM>\n",
	"</BODY>\n";
	
	&footer;
}


####################  END PROGRAM  #####################

sub toolbar {
	print "<HTML>\n",
		"<HEAD><TITLE>Form Generation Tool</TITLE>\n",
		"</HEAD>\n",
		"<BODY>\n",
		"<FONT SIZE=5><B>Choose Next Element</B></FONT><BR>",
		"<H2>Working document: $build_doc</H2>\n",
		"<FORM METHOD=\"POST\" ",
		"ACTION=\"http://$host$scriptpath$program\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"TABLE_STATUS\"",
		"VALUE=\"$table\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"BUILD_DOC\" ",
		"VALUE=\"$build_doc\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"STEP\" VALUE=\"$step\">\n",
		"<TABLE>\n",
		"<TR>\n",
		"<TH COLSPAN=2>Choose next element for ",
		"document:</TH></TR>\n",
		"<TR><TD><INPUT TYPE=\"radio\" NAME=\"ELEMENT_TYPE\" ",
		"VALUE=\"FORM\" CHECKED>Form Element:\n",
		"</TD>\n",
		"<TD><INPUT TYPE=\"radio\" NAME=\"ELEMENT_TYPE\" ",
		"VALUE=\"HTML\" >HTML Element:</TD></TR>\n",
		"<TR><TD><SELECT NAME=\"FORM_ELEMENT\" SIZE=\"1\">\n",
		"<OPTION>Text or Numeric Input\n",
		"<OPTION>Large Text Area\n",
		"<OPTION>Hidden Field\n",
		"<OPTION>Radio Button\n",
		"<OPTION>Checkbox\n",
		"<OPTION>Select\n",
		"<OPTION>Submit\n",
		"</SELECT></TD>\n",
		"<TD><SELECT NAME=\"HTML_ELEMENT\" SIZE=\"1\">\n",
		"<OPTION>Horizontal Rule\n",
		"<OPTION>Line Break\n",
		"<OPTION>Heading\n",
		"<OPTION>Comment\n",
		"<OPTION>Image\n",
		"<OPTION>Link\n",
		"<OPTION>Text\n",
		"</SELECT></TD></TR>\n",
		"<TR><TH COLSPAN=2>Document Creation Options</TH></TR>\n",
		"<TD>Table: <INPUT TYPE=\"radio\" NAME=\"TABLE\" ",
		"VALUE=\"1\"",
		" $table[1]> On or <INPUT TYPE=\"radio\" NAME=\"TABLE\" ",
		"VALUE=\"0\" $table[0]> Off </TD>\n",
		"<TD ALIGN=\"right\"><INPUT TYPE=\"checkbox\" ",
		"NAME=\"LINE_BREAK\" CHECKED> Line break after ",
		"element</TD></TR>\n",
		"<TR><TH><BR></TH></TR>\n";
		
		if ($in{STEP} > 0) {
			print "<TR><TD COLSPAN=2 ALIGN=\"center\"><INPUT ",
			"TYPE=\"submit\" NAME=\"BUILD\" VALUE=\"Remove last ",
			"element\"</TD></TR>";
		}
		
		print "<TR><TD ALIGN=\"center\"><INPUT TYPE=\"submit\" ",
		"NAME=\"BUILD\" VALUE=\"Create Element\"></TD>\n",
		"<TD ALIGN=\"center\"><INPUT TYPE=\"submit\" ",
		"NAME=\"BUILD\" ",
		"VALUE=\"End Document\"></TD></TR>\n",
		"<TR><TH><BR></TH></TR>\n",
		"<TR><TD ALIGN=\"center\"><INPUT TYPE=\"submit\" NAME=",
		"\"BUILD\" VALUE=\"Preview Document\"></TD>",
		"<TD ALIGN=\"center\"><INPUT TYPE=\"submit\" ",
		"NAME=\"BUILD\" ",
		"VALUE=\"View Source\"></TD></TR>\n",
		"</TABLE>\n",
		"</FORM>\n";
		
	&footer;
}
	
sub next_element {
	# mini-form to jump to next element creation form
	print "<FORM METHOD=\"POST\" ",
		"ACTION=\"http://$host$scriptpath$program\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"TABLE_STATUS\" ",
		"VALUE=\"$in{TABLE_STATUS}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"BUILD_DOC\" ",
		"VALUE=\"$in{BUILD_DOC}\">\n",
		"<INPUT TYPE=\"hidden\" NAME=\"STEP\"",
		" VALUE=\"$in{STEP}\">\n",
		"<INPUT TYPE=\"submit\" NAME=\"BUILD\" ",
		"VALUE=\"Choose Next Element\">",
		"</FORM>\n";		
		
		&footer;

}

	
sub footer {
	# the usual yatta-yatta
	print "<HR>Start <A HREF=\"http://$host$scriptpath",
	      "$program\">$program</A> over again. <B>Warning</B> ",
		"the current form will be lost.<BR>",
	      "<ADDRESS>$program written by singe\@outer.net<P>\n",
		  "Page generated $date</ADDRESS>",
		  "</HTML>\n";
	
}

sub liedowndie {
	# error handler
	print "<H1>Script is not functional.</H1>",
	      "check installation or notify administrator.";
	exit (1)
}


sub line_break {
	if ($in{LINE_BREAK}) {
		if ($in{TABLE}) {
			print DOC "</TR>\n<TR>";
		} else {
			print DOC "<BR>";
		}
	}	
	
}



