#!/usr/bin/perl

#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#%                                                                     %
#%             PROGRAM  :  MOM-add-task.pl                             %
#%             CREATOR  :  Mark Gaither                                %
#%       CREATION DATE  :  Fri 17 Nov 1995                             %
#%         DESCRIPTION  :  Add a task to a MOMspider instruction file. %
#%                                                                     %
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

# flush stdout buffer
$| = 1;

# Print this out no matter what
print "Content-type: text/html\n\n";

if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    # How many bytes are we supposed to receive?
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    
    @pairs = split(/&/, $buffer);
    
    foreach $pair (@pairs)
    {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
    }
}

open(INST,">> $in{'inst-filename'}") || die "Can't open file $in{'inst-filename'}: $!\n";
select(INST);
print <<"INSTRUCTION";
# Instruction
<$in{'boundary'}
  Name $in{'info-struct-name'}
  TopURL $in{'topURL'}
  IndexURL $in{'indexURL'}
  IndexFile $in{'indexfile'}
INSTRUCTION

if($in{'indextitle'} ne '' &&
   $in{'indextitle'} !~ /^\s*$/) {
  print "  IndexTitle $in{'indextitle'}\n";
}
if($in{'changewindow'} ne '' &&
   $in{'changewindow'} !~ /^\s*$/) {
  print "  ChangeWindow $in{'changewindow'}\n";
}
if($in{'expirewindow'} ne '' &&
   $in{'expirewindow'} !~ /^\s*$/) {
  print "  ExpireWindow $in{'expirewindow'}\n";
}
if($in{'emailaddress'} ne '' &&
   $in{'emailaddress'} !~ /^\s*$/) {
  print "  EmailAddress $in{'emailaddress'}\n";
}
if($in{'emailbroken'} eq 'yes') {
  print "  EmailBroken\n";
}
if($in{'emailredirected'} eq 'yes') {
  print "  EmailRedirected\n";
}
if($in{'emailchanged'} ne '' &&
   $in{'emailchanged'} !~ /^\s*$/) {
  print "  EmailChanged $in{'emailchanged'}\n";
}
if($in{'emailexpired'} ne '' &&
   $in{'emailexpired'} !~ /^\s*$/) {
  print "  EmailExpired $in{'emailexpired'}\n";
}
if($in{'exclude'} ne '' &&
   $in{'exclude'} !~ /^\s*$/) {
  @URLs = split(/\n/,$in{'exclude'});
  foreach $URL (@URLs) {
    print "  Exclude $URL\n";
  }
}
print ">\n";

close(INST);

select(STDOUT);

print <<"HTML";
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HEAD>
<TITLE>Automatic Creation of MOMspider Instruction File</TITLE>
</HEAD>
<BODY>
<H1>Automatic Creation of MOMspider Instruction File</H1>
<HR>
<FORM METHOD="POST" ACTION="MOM-task.pl">
<INPUT TYPE="submit" VALUE="Add Another Instruction">
<INPUT NAME="inst-filename" TYPE="hidden" VALUE="$in{'inst-filename'}">
</FORM>
<P>
<HR>
<P>
[<A HREF="file://localhost/$in{'inst-filename'}">Current Instruction File</A>]
[<A HREF="/tools/MOMspider/MOM-inst-form.html">WebTechs MOMspider Instruction File Form</A>]
</BODY>
</HTML>
HTML

exit;
