#!/usr/local/bin/perl
#
# gen_quote.pl - this script takes a series of action arguments, reads
#				 in a command line then executes the quoting engine.
#
# Copyright (C) 1995 Mike W. Erwin <mikee@outer.net>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#   gen_quote.pl
#
#   Version: 1.0  -  Wed, Nov 9, 1994, 4:38:08 PM  
#
#   Revision History:
#
#	Version 1.0		Script Created.
#
#	PURPOSE:		The purpose of this script is to first call our quote
#					program, thereby creating either a postscript or text
#					version of the output for the user. This script is tasked
#					with processing the extra messages that need to go along
#					with the quote, the other information that needs to
#					be delivered (such as price lists and information sheets),
#					as well as the actual creation of the quote via a 
#					third party program, "quote". Lastly, this script needs
#					to figure out the delivery mechanism requested by the
#					user and enact it.  Currently it supports "e-mail" and
#					and automated fax gateway (using the shareware packages
#					of ghostscript and mgetty on a Linux machine). 
#
#					** Which is an excellent choice for a good quick fax gw **
#
#
#	INSTALLATION:	To configure this script, edit all of lines in the next 
#				 	section that have a "#!" as a comment to their immediate
#				 	right.  This script need to be installed in what ever
#					directory is specified in the "web_quote.pl" script in the
#					definitions section at the beginning of the script.
#
#
#	USAGE:			This script is called directly by the "web_quote.pl" script
#					to process the quote. Since this script is called as a 
#					background only application (&) it does not have any output
#					directly to the calling program or the browser for that 
#					matter.
#   
#
#           
############################################################################

$MAILER				= "/usr/bin/mailx";				# Defines the location of your mailer
$POSTSCRIPT_CVRTR	= "/usr/bin/enscript -p- ";		# A program that converts text->postscript

#
# We use a program called "enscript" which comes with A/UX to convert our files
# to postscript.  However, we do have ghostscript installed, which would be
# a perfectly acceptable solution.  (PS> you could also just produce a .ps file
# directly with some WP or DTP program if you wish too).
#

############################################################################
#
# Process the command line options
#           
############################################################################
require "getopts.pl";
&Getopts('mfia:psw:x:yz');

$mail = $opt_m;					# User wants to mail results to recipient
$fax = $opt_f;					# User wants to fax the results
$extra_info = $opt_i;			# Send along extra Information Sheet	
$extra_price = $opt_p;			# Send along a price list
$extra_dis = $opt_d;			# Send along a disclaimer (Service Agreement)
$who = $opt_w;					# The name of the sender
$fax_number = $opt_x;			# The Fax Telephone number
$mail_address = $opt_a;			# The Mail address of the recipient
$noc = $opt_y;					# Send along a product slick
$source = $opt_z;				# Send along a different product slick

############################################################################
#
# Setup some constants and some variables.
#           
############################################################################

$FAXDIR = "/home/transfer";

$arguments = `cat "/tmp/quote.args"`;
chop($arguments);

open(QUOTESTREAM,"/www/cgi-bin/quote $arguments |");	# The quoter returns the filename
while (<QUOTESTREAM>) {									# on standard output. This filename
	$filename = $_;										# is used for processing below.
}
close (QUOTESTREAM);
chop ($filename);

############################################################################
#
# MAIL
#
# The quote engine which is engaged above will produce a text or postscript
# file which is them mailed to the user specified below. Since there are 4
# lines of messages which can be echoed to the user, these are handled by
# appending the text quote to the end of the "/tmp/messages" file, which was
# produced by the "web_quote.pl" file that calls this.  You may need
#           
############################################################################
if ($mail) {
	system("cat $filename >> /tmp/messages");
	system("cp /tmp/messages $filename");
	system ("rm -f /tmp/messages");
	system ("${MAILER} -s \"Automated Quote Generation: OuterNet Connection Strategies, Inc.\" $mail_address < $filename");
}

############################################################################
#
# FAX
#
# The quote can also be faxed to a user. Some pre-processing is required, since
# we need g3 format fax files for the transfer and most of our files are raw
# text to begin with (some may be postscript as well). The first section 
# converts the extra information pages into postscript and places them into
# the middle-man fax directory "$FAXDIR".  The $noc and $source files are 
# precooked g3 files of some of our product slicks. We made them with ghostscript.
# We then calculate the total number of pages (to be supplied on the fax
# cover sheet) and them process the messages that need to go there as well.
# The last part of this script does the actual fax queueing, which is then
# picked up by mgetty at the next (faxrunq) which runs every 15 minutes on
# our fax UNIX box.
#
#           
############################################################################
if ($fax) {
	if ($extra_info) {
		$info_pgs = `${POSTSCRIPT_CVRTR} /usr/local/bin/information.outer.net > ${FAXDIR}/info.ps`;
		$info_pgs = 1;
	}
	if ($extra_price) {
		$price_pgs = `${POSTSCRIPT_CVRTR} /usr/local/bin/prices.outer.net > ${FAXDIR}/prices.ps`;
		$price_pgs = 3;
	}
	if ($extra_dis) {
		$dis_pgs = `${POSTSCRIPT_CVRTR} /usr/local/bin/disclaimer.outer.net > ${FAXDIR}/disclaimer.ps`;
		$dis_pgs = 1;
	}
	if ($noc) {
		$noc_pgs = 2;					# We don't postscriptize these as they are g3 already.
	}
	if ($source) {
		$source_pgs = 2;
	}

	#
	# Calculate the total number of pages in the fax
	#
	$total_page_faxed = $info_pgs + $price_pgs + $dis_pgs + $noc_pgs + $source_pgs + 2;
	
	#
	# Get the messages from the message file and replace where appropriate on the cover sheet.
	# The calling script produced a file in the /tmp directory, which is read into an
	# array called "fax_message".
	#
	open(FAXMESSAGES, "/tmp/faxmsgs");
	while (<FAXMESSAGES>) {
		$fax_message[$ct++] = $_;
	}
	close (FAXMESSAGES);
	
	#
	# The quote engine is nice enough to create a cover sheet if the fax option
	# is specified on its command line.  Here we open ip the cover sheet (which
	# turns out to be a postscript file) in need of marking up. The remainer
	# is merely a find/replace on some keywords found embedded in the postscript.
	#
	open (COVERSTREAM, "cat $filename.cover |");
	open (NEWCOVER, "> $filename.cover.1");
	while (<COVERSTREAM>) {
		$line = $_;
		if ($line =~ '\<\<pages\>\>') {
			$line =~ s/\<\<pages\>\>/$total_page_faxed/;
		}
		if ($line =~ '\<\<noteline1\>\>') {
			$line =~ s/\<\<noteline1\>\>/$fax_message[0]/;
		}
		if ($line =~ '\<\<noteline2\>\>') {
			$line =~ s/\<\<noteline2\>\>/$fax_message[1]/;
		}
		if ($line =~ '\<\<noteline3\>\>') {
			$line =~ s/\<\<noteline3\>\>/$fax_message[2]/;
		}
		if ($line =~ '\<\<noteline4\>\>') {
			$line =~ s/\<\<noteline4\>\>/$fax_message[3]/;
		}
		print NEWCOVER $line;
	}
	close ( COVERSTREAM );
	close ( NEWCOVER );
    
    #
    #
    # Here's where the most of the fax work is done.  Once the files have been made
    # They few that don't exist in the $FAXDIR are copied there and a script is
    # run that feed them to the fax gateway (/usr/local/bin/faxout.pl).
    #
    # In short, the "/usr/local/bin/faxout.pl" script runs postscript against the .ps
    # files in the $FAXDIR directory then runs "/usr/local/bin/faxspool" to insert them
    # into the fax queue.
    #
    #
	system ("cp $filename $FAXDIR/${fax_number}-${who}-quote.ps");
	system ("cp $filename.cover.1 $FAXDIR/${fax_number}-cover.ps");
	system ("rm -f ${filename}.cover.1 ${filename}");
	system ("/usr/bin/remsh goanna '/usr/local/bin/faxout.pl > /tmp/output.1' &");
	
	#
	# Since these packages are stored in g3 format already all that needs to be done
	# with them is the spooling process.
	#
	#
	if ($noc) {
		system ("/usr/bin/remsh goanna '/usr/local/bin/faxspool -f ${who} ${fax_number} /usr/spool/fax/templates/on1.g3 /usr/spool/fax/templates/on2.g3' &");
	}
	if ($source) {
		system ("/usr/bin/remsh goanna '/usr/local/bin/faxspool -f ${who} ${fax_number} /usr/spool/fax/templates/src1.g3 /usr/spool/fax/templates/src2.g3' &");
	}
}
