#!/usr/bin/perl
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#%                                                                     %
#%             PROGRAM  :  MOM-inst.pl                                 %
#%             CREATOR  :  Mark Gaither                                %
#%       CREATION DATE  :  Fri 17 Nov 1995                             %
#%         DESCRIPTION  :  Preview data to create a MOMspider          %
#%                         instruction file.                           %
#%                                                                     %
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

# flush stdout buffer
$| = 1;

# Print this out no matter what
print "Content-type: text/html\n\n";

if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    # How many bytes are we supposed to receive?
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    
    @pairs = split(/&/, $buffer);
    
    foreach $pair (@pairs)
    {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
    }
}

print <<"HTML";
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HEAD>
<TITLE>MOMspider Preview</TITLE>
</HEAD>
<BODY>
<H1>MOMspider Global Directives Preview</H1>
<HR>
<P>
HTML

$ERRORS = 'false';

if($in{'inst-filename'} eq '' || 
   $in{'inst-filename'} =~ /^\s*$/) { 
  &error("You must provide a local instruction file name."); 
  $ERRORS = 'true';
}
if($in{'gd-sitescheck'} ne '' && 
   $in{'gd-sitescheck'} !~ /[0-9]+/) {
    &error("You must use an integer when specifying number of days.");
    $ERRORS = 'true';
}
if($in{'gd-maxdepth'} ne '' && 
   $in{'gd-maxdepth'} !~ /[0-9]+/) {
    &error("You must use an integer when specifying number of days.");
    $ERRORS = 'true';
}

if($ERRORS eq 'true') {
  print <<"HTML";

<P> Please traverse back and correct the errors.
</BODY>
</HTML>
HTML

  exit;
}

print "<PRE>\n";

if($in{'inst-filename'} ne '' && 
   $in{'inst-filename'} !~ /^\s*$/) {
  print "    Instruction file name = $in{'inst-filename'}\n";
}
if($in{'gd-sysavoid'} ne '' && 
   $in{'gd-sysavoid'} !~ /^\s*$/) {
  print "        System avoid file = $in{'gd-sysavoid'}\n";
}
if($in{'gd-syssites'} ne '' && 
  $in{'gd-syssistes'} !~ /^\s*$/) {
  print "        System sites file = $in{'gd-syssites'}\n";
}
if($in{'gd-avoidfile'} ne '' &&
   $in{'gd-avoidfile'} !~ /^\s*$/) {
  print "          User avoid file = $in{'gd-avoidfile'}\n";
}
if($in{'gd-sitesfile'} ne '' &&
   $in{'gd-sitesfile'} !~ /^\s*$/) {
  print "          User sites file = $in{'gd-sitesfile'}\n";
}
if($in{'gd-sitescheck'} eq '') { $in{'gd-sitescheck'} = 15; }
if($in{'gd-sitescheck'} ne '' &&
   $in{'gd-sitescheck'} !~ /^\s*$/) {
  print "Window between site check = $in{'gd-sitescheck'}\n";
}
if($in{'gd-replyto'} ne '' &&
   $in{'gd-replyto'} !~ /^\s*$/) {
  print "    ReplyTo email address = $in{'gd-replyto'}\n";
}
if($in{'gd-maxdepth'} eq '') { $in{'gd-maxdepth'} = 20; }
if($in{'gd-maxdepth'} ne '' &&
   $in{'gd-maxdepth'} !~ /^\s*$/) {
  print "  Traversal maximum depth = $in{'gd-maxdepth'}\n";
}

print <<"HTML";
</PRE>
<P>
<HR>
<P>If these values are correct, <STRONG>submit</STRONG> your choices.
<P>
<FORM ACTION="/cgi-bin/MOM-task.pl" METHOD="POST">
<INPUT NAME="inst-filename" TYPE="hidden" VALUE="$in{'inst-filename'}">
<INPUT NAME="gd-sysavoid" TYPE="hidden" VALUE="$in{'gd-sysavoid'}">
<INPUT NAME="gd-syssites" TYPE="hidden" VALUE="$in{'gd-syssites'}">
<INPUT NAME="gd-avoidfile" TYPE="hidden" VALUE="$in{'gd-avoidfile'}">
<INPUT NAME="gd-sitesfile" TYPE="hidden" VALUE="$in{'gd-sitesfile'}">
<INPUT NAME="gd-sitescheck" TYPE="hidden" VALUE="$in{'gd-sitescheck'}">
<INPUT NAME="gd-replyto" TYPE="hidden" VALUE="$in{'gd-replyto'}">
<INPUT NAME="gd-maxdepth" TYPE="hidden" VALUE="$in{'gd-maxdepth'}">
<INPUT TYPE="submit" VALUE="Add Global Directives and Proceed to Next Step">
</FORM>
</BODY>
</HTML>
HTML

chop($date = `date`);


open(INST,"> $in{'inst-filename'}") || die "Can't open $in{'inst-filename'}: $!\n";
select(INST);

print <<"INSTRUCTION";
# MOMspider Instruction File automatically created by WebTechs MOMspider Form
# $date
#
# Global Directives
#
INSTRUCTION

if(defined($in{'gd-sysavoid'}) && 
   $in{'gd-sysavoid'} !~ /^\s*$/) {
  print "SystemAvoid $in{'gd-sysavoid'}\n";
}
if(defined($in{'gd-syssites'}) && 
   $in{'gd-syssites'} !~ /^\s*$/) {
  print "SystemSites $in{'gd-syssites'}\n";
}
if(defined($in{'gd-avoidfile'}) && 
   $in{'gd-avoidfile'} !~ /^\s*$/) {
  print "AvoidFile $in{'gd-avoidfile'}\n";
}
if(defined($in{'gd-sitesfile'}) && 
   $in{'gd-sitesfile'} !~ /^\s*$/) {
  print "SitesFile $in{'gd-sitesfile'}\n";
}
if(defined($in{'gd-sitescheck'}) && 
   $in{'gd-sitescheck'} !~ /^\s*$/) {
  print "SitesCheck $in{'gd-sitescheck'}\n";
}
if(defined($in{'gd-replyto'}) && 
   $in{'gd-replyto'} !~ /^\s*$/) {
  print "ReplyTo $in{'gd-replyto'}\n";
}
if(defined($in{'gd-maxdepth'}) && 
   $in{'gd-maxdepth'} !~ /^\s*$/) {
  print "MaxDepth $in{'gd-maxdepth'}\n";
}

close(INST);

exit;

sub error {
  local($str) = @_;

  select(STDOUT);
  print "<STRONG>ERROR:</STRONG> $str<BR>\n";
}
