#!/usr/bin/perl5

# Get directories

opendir(DIRECTORIES, $ARGV[0]);
@directories = grep(!/^\.\.?$/, grep(-d "$ARGV[0]/$_", readdir(DIRECTORIES)));
closedir DIRECTORIES;

foreach (@directories) {
	$name = "$ARGV[0]/$_/$_.lbl";

	if (-e $name) {
		open(LABEL, $name);
		$label = <LABEL>;
		chop $label if substr($label, -1) eq "\n";
		close LABEL;
	}

	push(@labels, $label);
}

sort(@labels);

if ($#labels >= $[) {
	print qq|<BR><STRONG>Items: \n|;
	print join("; ", @labels);
	print qq|\n</STRONG>\n|;
}
