#! /usr/bin/perl5
print <<EndOfFile;
Content-type: text/html

<H1>Routing</H1>
<P>
Routing is the method by which information originating at one host on
the Internet is delivered  to a destination that might be anywhere in
the world. Information is transfered in packets. If the
packets are addressed to a destination on a remote network, they 
are sent to a router, which either forwards the packets to the
destination host (if the address is local) or sends them to another
network. Because a router can forward packets to local networks only
(networks to which it is directly attached), the forwarding action is
repeated, from router to router, until the packets reach their final
destination.
</P>
<P>
By TCP/IP conventions, a system that routes packets between networks is
considered a gateway. On the WebFORCE Internet Gateway, routing is supported 
by the <VAR>routed</VAR> process.
</P>
<P>
To determine the available paths to a destination, a router relies on
routing tables. A default routing table is automatically generated
during system startup. Because the default routing table supports local
routing only (routing to those networks to which the host is directly
attached), the table must be supplemented to include routes to remote
networks. Additional routes are added in two ways: With static
routing, the administrator explicitly specifies the route to
remote destinations; these routes remain constant, regardless of
changing conditions on the Internet.  With dynamic routing,
the router process communicates with other routers to determine the
most efficient route to a destination; these routes increase the
chances of fast and successful packet delivery.
</P>
<P>
The server can also be configured to perform multicast
routing. In multicast routing, information packets are forwarded
to a designated group of routers, skipping intermediate routers in the
path if they do not support the multicast routing protocol. To
configure multicast routing, the administrator creates tunnels that
allow packets to bypass non-multicast routers on their way to a
destination.
</P>
<P>Use these forms to configure routing:</P>
<UL>
<LI><A HREF="index.routing1.shtml" TARGET="left">Dynamic Routing</A>
<LI><A HREF="index.routing2.shtml" TARGET="left">Gateways Configuration</A>
<LI><A HREF="index.routing3.shtml" TARGET="left">Multicast Routing</A>
</UL>
EndOfFile
