#! /usr/bin/perl5
print <<EndOfFile;
Content-type: text/html

<H1><A NAME="_wmh1_828407857">Domain Name Service</A></H1>
<P>
The Domain Name Service (DNS) is a decentralized database service that
resolves hostnames and addresses on the Internet. DNS organizes the
Internet into a hierarchy of administrative units called <EM>domains</EM>. 
The <EM>root domain</EM> at the top of the hierarchy has authority over the 
entire Internet. Decending the hierarchy, subordinate domains are decreasingly 
comprehensive, so that a local domain usually serves a single organization 
(such as your local network). Large domains are frequently organized into 
<EM>subdomains</EM> to further distribute the maintenance task.
</P>
<P>
<STRONG>Note:</STRONG> All sites connected to the Internet are required
to have two systems that answer requests for their domain.
</P>
<P>
DNS is used instead of or in addition to a local hosts file
(<VAR>/etc/hosts</VAR>) to provide name and address information. The
Network Information Service (NIS) can also be used with DNS and the
local hosts file. If you use multiple naming services, you must specify
the order in which each service is to be used for name and address
resolution.
</P>
<P>
The <EM>named</EM> process supports DNS on an <I>WebForce Internet Gateway</I>
server (see the named(1M) reference page for details). A system running
<EM>named</EM> is referred to as a <EM>name server</EM>. If a domain contains
subdomains, several name servers are used. In this case, the
<EM>primary name server</EM> is the designated authority; it contains
the master database for the domain. <EM>Secondary servers</EM> contain
a copy of the database that is maintained on the primary server, and
<EM>clients</EM> relay name and address requests to primary or
secondary servers to be resolved.
</P>
<P>
When <EM>named</EM> receives a request for a domain for which it is neither
primary nor a secondary server, it forwards the request to another name
server for resolution. The addresses of such servers are maintained in 
a <EM>forwarder</EM> address list. The DNS protocol provides support for 
dynamically locating authoritative servers.  If you do not wish to use this 
feature, you can limit all forwarding to the specified forwarder list.
<P>
All hosts operate as DNS clients, including DNS servers. To request
domain information from DNS servers, all applications use a set of
routines collectively called the <VAR>resolver</VAR>. The resolver determines 
the order in which name services are to be used and the name servers and 
domain names to be queried in name lookups.
</P>
<P>
Use these forms to configure DNS:
</P>
<UL>
<LI><A HREF="index.dns1.shtml" TARGET="left">DNS Name Server</A>
<LI><A HREF="index.dns2.shtml" TARGET="left">DNS Resolver</A>
</UL>
<P>
For additional information, see Chapter 6 of <CITE>IRIX Admin:
Networking and Mail</CITE>. Also see the resolver(4) and named(1M)
reference pages.
</P>
EndOfFile
