#!/usr/bin/perl5

use Sys::Hostname;
use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$type = $ARGV[0];
if ($type eq "add") { $message = "New subnet added."; }
elsif ($type eq "edit") { $message = "Subnet edited."; }

$query = new CGI;

$def_config_dir = "/var/dhcp/config";
$netcgi = "dhcp-netconf.cgi";
$title = "DHCP Client Options";

$srv_off = system, "/etc/chkconfig", "proclaim_server";
$inetd_cf = "/etc/inetd.conf";
$use_propel = "No";

open(OUT,"> $dummy"); close(OUT);

&getLeases;

if ($query->param) {
    $subnet = $query->param('subnet');
    $subnet =~ /([\d.]+)/;
    $subnet = $1;

    if ($query->param('add')) {
	$newIP = $query->param('newIP');
	&error("Network address required.") if !$newIP;
	&error("Invalid IP Address.") if &check_ipaddr($query->param('newIP'));
	&addLease($query->param('newIP')); 
    }
    elsif ($query->param('doit')) { 
	$delFile = $query->param('delFile');
	if ($delFile && $delFile ne "Invalid") {	# Too late to check into  
	    &delete($delFile);				# quirky CGI.pm bug
	    &getLeases;
	    $message .= "  Subnet deleted.";
	} else { $message = "No changes made."; }
    }
    elsif ($query->param('edit')) {
	&error("To edit an existing subnet, first select a subnet from the
	    list, then click the edit button.") if !$subnet; 
	&edit($subnet); 
    }
    elsif ($query->param('delete')) {
	&error("To delete an existing subnet, first select a subnet from the
	    list, then click the delete button.") if !$subnet; 
	print $query->header;
	&title_block($title);
	$message = qq|Click "Ok" to save changes.|;
	&generic($subnet); 
	exit 0;
    } elsif (!$type) { $message = "Use buttons to submit form."; }
}

print $query->header;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

&title_block($title);

if ($srv_off == 0) { &getFile; }	# chkconfig proclaim_server is on

if ($srv_on && $osf) { &getOptions; }

&generic;

sub error {
    print $query->header;
    &title_block($title);
    &error_block($_[0]);
    &generic;
    exit 0;
}    

sub addLease {
    $file = $netcgi . "?add$_[0]";
    print $query->redirect($file);
}    
   
sub delete {
    $file = $def_config_dir . "/config." . $_[0];
    `rm $file`;
}

sub edit {
    $file = $netcgi . "?edit$_[0]";
    print $query->redirect($file);
}

sub getFile {
    open(INETD, $inetd_cf) || die "Cannot open $inetd_cf";
    while (<INETD>) {
	if (/^#/) {
	    next;
	}
	# bootp dgram udp wait root /usr/etc/dhcp_bootp dhcp_bootp -o <file>
	if (/^bootp/) {
	    chop;
	    @entlist = split(/\s+/);
	    if ($entlist[7] eq "-o") {
		$osf = $entlist[8];
		last;	# Break out of the while loop
	    }
	}
    }
    close(INETD);
}

sub getOptions {
    $found = 0;
    open(OPTIONS, $osf) || die "Cannot open $osf";
    while(<OPTIONS>) {
	if (/^#/) {
	    next;
	}
	chop;
	@optlist = split(/\s+/);
	$i = 0;
	while ($optlist[$i]) {
	    if ($optlist[$i] eq "-c") {
		$def_config_dir = $optlist[$i+1];
		$found = 1;
		last;
	    }
	    $i += 1;
	}
	if ($found == 1) {
	    last;
	}
    }
    close(OPTIONS);
}

sub getLeases {
    undef @lst;
    opendir(CONFIG, $def_config_dir) || 
		&error("Unable to open directory $def_config_dir");
    while ($name = readdir(CONFIG) ) {
	if ($name =~ /^config\./) {
	    $ipa = $name;
	    $ipa =~ s/^config\.//;
	    if ($ipa ne "Default") { push(@lst,$ipa); }
	}
    }
    closedir(CONFIG);
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print $query->startform;

    if ($_[0]) { print "<input type=hidden name=delFile value=$_[0]>"; }

    print "<center><table width=400>";
    print "<tr><th align=left>",$query->submit('add','Add New Subnet'),"</th>";
    print "<td>",$query->textfield(-name=>'newIP', -size=>19),"</td></tr>";

    if ($_[0]) { 
	undef @locList;
	foreach $arg (@lst) {
	    if ($arg ne $_[0]) { push(@locList,$arg); }
	}
    } else { @locList = @lst; }
    print "<tr><th align=left>",$query->submit('edit','Edit Existing Subnet'),"</th>";
    print "<td rowspan=2>",&choice_list(*locList,'subnet',20),"</td></tr>";

    print "<tr><th align=left>",$query->submit('delete','Delete Existing Subnet'),"</th></tr>";

    print "</table><br>";

    &button_table($query,'doit','Ok','help','Help');

    print $query->endform;
}

sub old {
    if ($#lst > -1) {

	print "<center><table width=300>";

	print "<tr><th align=left>Name</th><th>Edit</th><th>Delete</th></tr>";

	foreach $arg (@lst) {
	    print "<tr><td>",$arg,"</td><td align=center>",$query->submit("edt".$arg,"Edit"),
		"</td><td align=center>",
		"<input type=checkbox name=del$arg value='Delete'>",
		"</td></tr>";
	}
    } else { print "<i><center>No clients currently configured.
				    </center></i>"; }

    print "</table></center><br>";

    &button_table($query,'doit','Ok','help','Help');

    print $query->endform;
}	
