#!/usr/bin/perl5

$ifcmd = "/usr/OnRamp/bin/htnetwork";

$hostsf   = "/etc/hosts";
$hoststmp = "/etc/hosts.tmp";
$sysid = "/etc/sys_id";
$netif = "/etc/config/netif.options";
$netiftmp = "/etc/config/netif.options.tmp";
$title = "Network Interfaces (FDDI & Ethernet)";

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";
require "flush.pl";

$query = new CGI;
print $query->header;
&title_block($title);

undef @interfaces;
undef @ifnm;
undef @ipa;
undef @hsnm;
undef @smsk;
undef @sts;

$ip = "ip";
$hs = "hs";
$sm = "sm";
$st = "st";

&getValues;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

if ($query->param('edit') eq 'Edit Selected Interface') {
    $dummy = $query->param('chosen');
    $dummy =~ /([\w.]+)[^\w]+([\w.]+)?/;
    $ifChoice = $1; $ipChoice = $2;

    &error(0,"To edit an interface, first select the interface from 
	the list, then click the edit button.") if !$ipChoice;

    for ($i=0;$i<=$#ipa;$i++) { 
	if ($ipChoice eq $ipa[$i]) { $numChoice = $i; }
    }
    &getEdit($numChoice);
    exit 0;
}

if ($query->param('doEdit') eq 'Ok') {
	&formValidation;

	$num = $query->param('numChosen');

	if ($query->param($st) eq "Yes") {
	    $cip = $query->param($ip);
	    $chs = $query->param($hs);
	    $csm = $query->param($sm);
	}

	$run_script = 0;

	# only check other fields if the state has changed
	$cst = $query->param($st);
	if ( ($cst ne $sts[$num]) && ($cst eq "No")) {
	    # If Primary then chkconfig network off
	    # else update netif.options
	    # ifconfig interface down
	    if ($num == 0) {
		`/etc/chkconfig network off`;
	    }
	    else {
		&updateNetifOptions($num, 0, 0);
	    }
	    `/usr/etc/ifconfig $ifnm[$num] down`;
	    $run_script = 1;
	}
	elsif ($cst eq "Yes") {
	    # If Primary, update sys_id, set hostname, set hostid
	    # else update netif.options
	    # Update hosts, ifconfig.options

	    $cip = $query->param($ip);
	    $chs = $query->param($hs);
	    $csm = $query->param($sm);

	    $nipa = $cip;

	    $nhsm = $chs;

	    if ( ($cip ne $ipa[$num]) || ($chs ne $hsnm[$num]) ) {
		$run_script = 1;
		&removeHosts($ipa[$num]);
		&addHosts($nipa, $nhsm);
		if ($num == 0) {
		    # Primary
		    if ($chs ne $hsnm[$num]) {
			$unchs = $chs;
			$unchs =~ s/\..*//;
			&updateSysid($chs);
			`/usr/bsd/hostname -s $unchs`;
		    }
		    if ($cip ne $ipa[$num]) {
			`/usr/bsd/hostid -h $chs`;
		    }
		}
		else {
		    &updateNetifOptions($num, $nhsm, 1);
		}
	    }
	    if ($csm ne $smsk[$num]) {
		&updateIfconfigOptions($num, $csm);
		$run_script = 1;
	    }
	    `/etc/chkconfig network on`;
	    `/usr/etc/ifconfig inet $cip netmask $csm`;
	}

    # Run networking script
    if ($run_script) {
	&flush(stdout);
	unless (fork) {
	    `/etc/init.d/network stop > /dev/null 2>&1`;
	    `/etc/init.d/network start > /dev/null 2>&1`;
	    exit 0;
	}
    }
    $message = "Interface reconfigured.";
    if (!$num) { $message .= "  It is recommended that your machine be
	rebooted at this time."; }
}

&generic;

sub formValidation {
	&error(1,"Invalid IP address: ".$query->param($ip).".") if
	    &check_ipaddr($query->param($ip));
	&error(1,"Invalid hostname: ".$query->param($hs).".") if
	    &check_hostname($query->param($hs));
	&error(1,"Invalid netmask: ".$query->param($sm).".") if
	    &check_netmask($query->param($sm));
	&error(1,"You cannot disable your primary interface.") if
	    ($num == 0 && $query->param($st) eq 'No');
}

sub error {
    &error_block($_[1]);
    if ($_[0] == 0) { &generic; }
    else { &getEdit($num); }
    exit 0;
}

sub getValues {
    @interfaces = `$ifcmd`;
   for ($i = 0; $i <= $#interfaces; $i++) {
	($n, $ifnm[$i], $sts[$i], $ipa[$i], $smsk[$i], $hsnm[$i]) = split(/:/, $interfaces[$i]);
	$sts[$i] = $sts[$i] ? "Yes" : "No";
    }
}

sub get_iflabel {
    $_ = $_[0];
    if( (/^et]/) || (/^ec/) || (/^ee/) || (/^enp/) ) {
	$lb = "Ethernet $_";
    }
    elsif (/^egl/) {
	$lb = "EFast Eagle $_";
    }
    elsif (/^fxp/) {
	$lb = "EFast FXP $_";
    }
    elsif (/^ep/) {
	$lb = "EPlex Ether $_";
    }
    elsif (/^ipg/) {
	$lb = "FDDIXPress $_";
    }
    elsif (/^xpi/) {
	$lb = "FDDI $_";
    }
    elsif ( (/^fv/) || (/^mtr/) || (/^gtr/) ) {
	$lb = "TokenRing $_";
    }
    else {
	$lb = $_;
    }
    $lb;
}

sub getEdit {
    $num = $_[0];

    if ($num) { $type = "secondary"; }
    else { $type = "primary"; }

    &header_block("Edit Network Interface");

    print $query->startform;

    print "<input type=hidden name=numChosen value=$num>";

    print "<center><table cellpadding=5 width=450>\n";
    $row1 = "<tr><th align=left>Interface Name:</th>";
    $row2 = "<tr><th align=left>IP Address:</th>";
    $row3 = "<tr><th align=left>Hostname:</th>";
    $row4 = "<tr><th align=left>Netmask:</th>";
    $row5 = "<tr><th align=left>Interface Up:</th>";

	$lbl = &get_iflabel($ifnm[$num]);
	$row1 .= "<td align=left>$lbl</td></tr>";
	$row2 .= "<td align=left>";
	$row2 .= $query->textfield(-name=>$ip, -default=>$ipa[$num],
				   -size=>15, -maxlength=>16)."</td></tr>";
	$row3 .= "<td align=left>";
	$row3 .= $query->textfield(-name=>$hs, -default=>$hsnm[$num],
				   -size=>15, -maxlength=>256)."</td></tr>";
	$row4 .= "<td align=left>";
	$row4 .= $query->textfield(-name=>$sm, -default=>$smsk[$num],
				   -size=>15, -maxlength=>16)."</td></tr>";
	$row5 .= "<td align=left>";
	$row5 .= $query->radio_group(-name=>$st, -values=>['Yes','No'],
				     -default=>$sts[$num])."</td></tr>";

    print $row5,"\n";

    print "<tr><th align=left>Interface Type:</th><td align=left>$type</td></tr>";

    print $row1,"\n";
    print $row2,"\n";
    print $row3,"\n";
    print $row4,"\n";

    print "</table></center><p>\n";

    print &buttons("doEdit", "Ok", "help", "Help");

    print $query->endform;
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print $query->startform;

    if($_[0]) { print "<input type=hidden name=toDelete value=$_[0]>"; }

	print "<table cellapdding=5 width=450>";

	print "<tr><th align=left valign=top>";
	print qq|<input type=submit name="edit" 
	    value="Edit Selected Interface"></th>|;

	print "<td rowspan=2 align=left>";
	undef @locList;
	for ($i=0;$i<=$#ipa;$i++) { 
	    push(@locList,"$ifnm[$i] $ipa[$i]");
	}
	print &choice_list(*locList,"chosen",20);

	print "</td></tr>";

	print "</table></center><br>";

    print $query->endform;
}

sub removeHosts {
    local($rem_ip) = $_[0];
    open(IN,"< $hostsf");
    open(OUT,"> $hoststmp");
    while(<IN>) {
	if (/^#/) {
	    print OUT $_;
	    next;
	}
	if (/^$rem_ip/) {
	    print OUT "# ".$_;
	    next;
	}
	print OUT $_;
    }
    close(IN);
    close(OUT);
    rename($hoststmp, $hostsf);
}

sub addHosts {
    local($add_ip) = $_[0];
    local($add_hs) = $_[1];
    local($tempHs) = $add_hs;
    $tempHs =~ s/\..*//;
    open(OUT,">> $hostsf");
    print OUT "$add_ip\t$add_hs\t$tempHs\n";
    close(OUT);
}

sub updateNetifOptions {
    local($in) = $_[0];
    local($new_hs) = $_[1];
    local($act) = $_[2];

    local($ifname) = sprintf "if%dname=", $in+1;
    local($ifaddr) = sprintf "if%daddr=", $in+1;

    open(IN, "< $netif");
    open(OUT, "> $netiftmp");
    if ($act == 0) {
	while(<IN>) {
	    if (/^#/) {
		print OUT $_;
		next;
	    }
	    if ( (/^$ifname=/) || (/^$ifaddr=/) ) {
		print OUT ": ".$_;
		next;
	    }
	    print OUT $_;
	}
    }
    else {
	while(<IN>) {
	    if (/^#/) {
		print OUT $_;
		next;
	    }
	    if ( (/^:\b+$ifname=/) || (/^$ifname=/) ) {
		print OUT $ifname.$ifnm[$in];
		next;
	    }
	    if ( (/^:\b+$ifaddr=/) || (/^$ifaddr=/) ) {
		print OUT $ifaddr.$new_hs;
		next;
	    }
	    print OUT $_;
	}
    }
    close(IN);
    close(OUT);
    rename($netiftmp, $netif);
}

sub updateSysid {
    local($new_hs) = $_[0];
    open(OUT, "> $sysid");
    $new_hs =~ s/\..*//; 
    print OUT "$new_hs\n";
    close(OUT);
}

sub updateIfconfigOptions {
    local($in) = $_[0];
    local($msk) = $_[1];

    local($fname) = sprintf "/etc/config/ifconfig-%d\.options", $in+1;
    open(OUT, "> $fname");
    print OUT "netmask $msk";
    close(OUT);
}
