#!/usr/bin/perl5

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$dmfile = "/usr/etc/yp/ypdomain";
$title = "NIS Client";

print $query->header;
&title_block($title);

$dmname = `/bin/domainname`; chop($dmname);

$havenfs = system ("/etc/havenfs");
$nis_cl = system ("/etc/chkconfig", "yp");
$nisc = "Yes";
if ($nis_cl) {
    $nisc = "No";
}

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

if ($query->param('doit') eq 'Ok') {
    &formValidation;
    # Check domainname syntax XXX
    $newdm = $query->param('domain');
    if ($newdm ne $dmname) {
	&set_domain($newdm);
	$message = "Domain name changed.";
    }
    if ($query->param('nisc') eq 'Yes') {
	if ($nisc eq "No") {
  	    &enable_nisc;
	    $message .= "  NIS client enabled.";
	}
    } else { 
	if ($nisc eq "Yes") {
	    &disable_nisc;
	    $message .= "  NIS client disabled.";
	}
    }
    if (!$message) { $message = "No change to NIS client configuration."; }
}
 
&generic;

print $query->end_html;

sub formValidation {
	my $error = &check_hostname($query->param('domain'), 1);
	&error("Domain name cannot contain shell metacharacters") if $error == 911;
	&error("Domain name must exist") if $error == 4;
	&error("Invalid domain name") if $error;
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub set_domain {
    open(DMN, ">$dmfile") || print "Failed to open $dmfile.\n";
    print DMN $_[0]."\n";
    close (DMN);
    `/bin/domainname $_[0]`;
}

sub enable_nisc {
    `/etc/chkconfig yp on`;
    `/etc/chkconfig ypserv off`;
    `/etc/chkconfig ypmaster off`;

    $ypbind_options = `cat /usr/etc/ypbind.options`;

    `/etc/killall ypbind`;
    `/usr/etc/ypbind $ypbind_options > /dev/null 2>&1`;
}

sub disable_nisc {
    `/etc/chkconfig yp off`;
    `/etc/killall ypbind ypserv rpc.passwd`;
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    if ($havenfs != 0) {
	print "<i>NIS is not installed on this System.</i>";
	return 0;
    }
    print $query->startform;

    print "<center><table cellpadding=5 width=450>\n";

    print "<tr><th align=left>Enable NIS client:</th><th align=left>",
	  $query->radio_group(-name=>'nisc', -values=>['Yes','No'],
			      -default=>$nisc),
	  "</th></tr>";

    print "<tr><th align=left>NIS domain name:</th><th align=left>",
	  $query->textfield('domain', $dmname, 20),
	  "</th></tr>";

    print "</table></center><br>\n";

    print &buttons("doit", "Ok", "help", "Help");

    print $query->endform;
}
