#!/usr/bin/perl5

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$dmfile = "/usr/etc/yp/ypdomain";
$title = "NIS Slave Server";

print $query->header;
&title_block($title);

$dmname = `/bin/domainname`; chop($dmname);

$havenfs = system ("/etc/havenfs");
$nis_cl = system ("/etc/chkconfig", "yp");
$nis_sl = system ("/etc/chkconfig", "ypserv");
$niss = "Yes";
$nis_master = "";
if ($nis_cl || $nis_sl) {
    $niss = "No";
}
else {
    @mps = `/bin/ypwhich -m`;
    ($mp, $nis_master) = split(/ +/, $mps[0]);
}

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

if ($query->param('doit') eq 'Ok') {
    &formValidation;
    # Check domainname syntax XXX
    $newdm = $query->param('domain');
    $master = $query->param('master');

    if ($newdm ne $dmname) {
	&set_domain($newdm);
	$message = "Domain name changed."
    }
    if ($query->param('niss') eq 'Yes') {
	if ($niss eq "No") {
  	    &enable_niss;
	    $message .= "  NIS Slave Server enabled.";
	}
    } else { 
	if ($niss eq "Yes") {
	    &disable_niss;
	    $message .= "  NIS Slave Server disabled.";
	}
    }
    if (!$message) { $message = "NIS Slave Server configuration updated."; }
}
 
&generic;

print $query->end_html;

sub formValidation {
	my $error = &check_hostname($query->param('domain'));
	my $MSH = "Master server hostname";
	&error("Domain name cannot contain shell metacharacters") if $error == 911;
	&error("Invalid domain name") if $error;

	$error = &check_hostname($query->param('master'), 1);
	&error("$MSH must already exist") if $error == 4;
	&error("$MSH cannot contain shell metacharacters") if $error == 911;
	&error("Invalid master server hostname") if $error;
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub set_domain {
    open(DMN, ">$dmfile") || print "Failed to open $dmfile.\n";
    print DMN $_[0]."\n";;
    close (DMN);
    `/bin/domainname $_[0]`;
}

sub enable_niss {
    `/etc/chkconfig yp on`;
    `/etc/chkconfig ypserv on`;
    `/etc/chkconfig ypmaster off`;
    `/usr/OnRamp/bin/inityp -s $master`;

    $ypbind_options = `cat /usr/etc/ypbind.options`;
    $ypserv_options = `cat /usr/etc/ypserv.options`;

    `/etc/killall ypbind ypserv rpc.passwd`;
    `/usr/etc/ypbind $ypbind_options > /dev/null 2>&1`;
    `/usr/etc/ypserv $ypserv_options > /dev/null 2>&1`;
}

sub disable_niss {
    `/etc/chkconfig ypserv off`;

    `/etc/killall rpc.passwd ypserv`;
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    if ($havenfs != 0) {
	print "<i>NIS is not installed on this System.</i>\n";
	return 0;
    }
    print $query->startform;

    print "<center><table cellpadding=5 width=450>\n";

    print "<tr><th align=left>Enable NIS slave server:</th><th align=left>",
	  $query->radio_group(-name=>'niss', -values=>['Yes','No'],
			      -default=>$niss),
	  "</th></tr>";

    print "<tr><th align=left>NIS domain name:</th><th align=left>",
	  $query->textfield('domain', $dmname, 20),
	  "</th></tr>";

    print "<tr><th align=left>Hostname of NIS master server:</th><th align=left>",
	  $query->textfield('master', $nis_master, 20),
	  "</th></tr>";

    print "</table></center><br>\n";

    print &buttons("doit", "Ok", "help", "Help");

    print $query->endform;
}
