#!/usr/bin/perl5

# pop-account.cgi

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/passwd";
$dummy = "/etc/passwd.temp";
$myname = "pop-account.cgi";
$title = "POP3 Mail Accounts";
$popdir = "/usr/pop3";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

&getAccounts;

if (%fld) {
    $fld{'chosen'} =~ s/\W//g;

    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    if ($fld{'add'}) { 
	&formValid_add;
	@test = getpwnam($fld{'new_account'});
	&error(2,"Account already exists.") if $test[0];

	$val{'login'} = $fld{'new_account'};
	&addAccount; 
    }
    if ($fld{'delete'}) { 
	&error(2,"No account selected.") if !$fld{'chosen'};
	$message = qq|Click "Ok" to save changes.|;
	&generic($fld{'chosen'}); 
    }
    if ($fld{'doit'}) { 
	&tryToDelete; 
	&getAccounts; 
	if (!$message) { $message = "No changes made."; }
	&generic; 
    }
    if ($fld{'doadd'}) { &formValid_doAdd; &doAdd; &getAccounts; &generic; }
    
} else { 
    $NSstatus = &checkForNS;

    if ($NSstatus) { 
	&header_block($title);
	print "<i>NS Mail is currently running.  To enable POP3 Mail, first
		disable NS Mail.</i>";
    } else {
	&generic;
    }
}

sub checkForNS {
    local($mail_process) = "NscpMail";
    local($ret) = 0;
    if ( `/bin/ps -ef` =~ m:$mail_process:) { $ret = 1; }
    return $ret;
}

sub formValid_add {
    &error(1,qq|To add new account, first enter in login name for new account, 
	    then click "Add New Account" button.|) if !$fld{'new_account'};
    &error(1,qq|Invalid login name.|) if $fld{'new_account'} =~ /$LOGINCHARS/o;
}

sub formValid_doAdd {
    if (!$fld{'password'}) 
	{ &error(0,"You must enter a password."); }
    if ($fld{'password'} ne $fld{'passcheck'}) 
	{ &error(0,"Input passwords not equivalent."); }
    &error(0,"Invalid login name.") if $fld{'login'} =~ /$METACHARS/o;
}

sub error {
    &error_block($_[1]);
    %val = %fld;
    if ($_[0] == 0) { &addAccount; }
    if ($_[0] == 1 || $_[0] == 2) { undef @_; &generic; }
    exit 0;
}

sub tryToDelete {
    $account = $fld{'del_name'};
    if ($account eq "") { return; }

    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	@items = split(/:/,$line);
	if ( ($items[5] =~ /^$popdir/) && $items[0] eq $account) {
	    next;
	} else { print OUT $line; }
    }
    close(IN);
    close(OUT);
    rename($dummy, $conf);

    $message = "Account deleted.";	
}

sub doAdd {
    local($lgname) = $fld{'login'};
    $userdir = $popdir."/$lgname";
    &add_password($lgname,$fld{'password'},2000,20,$lgname." pop3",
		$userdir, "/bin/false");

    if (! -d $popdir) {
	mkdir($popdir, 0755);
    }
    mkdir($userdir, 0755);
    chown((getpwnam($lgname))[2,3], $userdir);
    $message = "New account added.";
}

sub addAccount {
    &header_block("Add New POP3 Mail Account");

    print "<form action=$myname method=post>";

    print "<center><table>";

    print "<input type=hidden name=login value=$val{'login'}>";

    print "<tr><th align=left>Login name:</th><td><tt>",
	  $val{'login'},"</tt></td></tr>";

    print "<tr><th align=left>Password:</th><th align=left>";
    print qq|<input type=password name="password" size=20>|;
    print "</th></tr>";

    print "<tr><th align=left>(Password again):</th><th align=left>";
    print qq|<input type=password name="passcheck" size=20>|;
    print "</th></tr>";

    print "</table></center><br>";

    print &buttons('doadd','Ok');

    print "</form></body></html>";
}

sub getAccounts {
    $i = 0;
    open(IN,"< $conf");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { next; }
	@items = split(/:/,$line);
	chop $items[5];
	if ($items[5] =~ /^$popdir/) {
	    $name[$i] = $items[0];
	    $i++;
	}
    }
    $number = $i;
    close(IN);
}

sub generic {
    &header_block($title);

    %val = %fld;

    if (!$number && !$message) { $message = "No existing POP3 accounts."; }

    print "<i>$message</i>";

    print "<form action=$myname method=post>";
    
    if ($_[0]) { print qq|<input type=hidden name="del_name" value=$_[0]>|; }

    print "<center><table width=400>";

    print "<tr><td></td><th align=left>Login Name</th></tr>";

    print qq|<tr><td><input type=submit name="add" value="Add New Account">
	</td><td><input name="new_account" value="$val{'new_account'}" size=20></td></tr>|;
    
    if ($number) {
	undef @locList;
	for ($i=0;$i<$number;$i++) { 
	    if ($_[0] ne $name[$i]) { push(@locList,$name[$i]); }
	}

	print qq|<tr><td valign=top><input type=submit name="delete" 
	    value="Delete Selected Account"></td><td>|;    

	print &choice_list(*locList,"chosen",20);

	print "</td></tr>";
    }

    print "</table></center><br>";

    print &buttons('doit','Ok');

    print "</form></body></html>";
}

