#! /usr/bin/perl5

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";
require "flush.pl";

$query = new CGI;

$cmd = "/usr/etc/configmail";
$prm = "/etc/sendmail.params";
$tmpprm = "/etc/sendmail.params.tmp";
$MAILSCRIPT = "/etc/init.d/mail";
$title = "Sendmail Configuration";

@supported = (	'forwarder',
		'rootdomain',
		'relayname',
		'localdomain',
		'pathalias',
		'directdomains' );

print $query->header;
&title_block($title);

&getValues;

if ($query->param) {
    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($query->param('help') eq "Help");

    if ($query->param('doit') eq 'Ok') {
	if ($query->param('enable') eq 'Yes') { &formValidation; }

	if ($hash{'enable'} ne $query->param('enable')) {
	    if ($query->param('enable') eq 'Yes') {
		`/etc/chkconfig sendmail on`;
		$message = "Sendmail enabled.";
	    } else { 
		`/etc/chkconfig sendmail off`;
		$message = "Sendmail disabled."; 
	    }
	    &flush(stdout);
	    if (!fork) {
		`$MAILSCRIPT stop`;
		`$MAILSCRIPT start`;
		exit 0;
	    }
	}

	if ($query->param('enable') eq 'Yes') {
	    undef %fileList;
	    open(PRM, "< $prm");
	    while(<PRM>) {
		chomp();
		($left,$right) = split(/:/);
		    if ($left && $right) {
		$fileList{$left} = $right;
		    }
	    }
	    close(PRM);

	    $mod = 0;

	    foreach $arg (@supported) { $vals{$arg} = $query->param($arg) }

	    foreach $arg (keys(%vals)) {
		if ($vals{$arg} ne $hash{$arg}) {
		    $mod = 1;
		    $fileList{$arg} = $vals{$arg};
		}
	    }

	    if ($mod == 1) {
		open(PRMT, ">$tmpprm");
		foreach $arg (keys(%fileList)) {
		    print PRMT "$arg:$fileList{$arg}\n";
		}
		close(PRMT);
		rename($tmpprm, $prm);
		`$MAILSCRIPT start`;

		$message .= "  Configuration file updated.";
	    }
	}
    }
    if (!$message) { $message = "No changes made."; }
}

$NSstatus = &checkForNS;

if ($NSstatus) { 
    &header_block($title);
    print "<i>NS Mail is currently running.  To enable sendmail, first
	    disable NS Mail.</i>";
} else { &generic; }

exit 0;

sub checkForNS {
    local($mail_process) = "NscpMail";
    local($ret) = 0;
    if ( `/bin/ps -ef` =~ m:$mail_process:) { $ret = 1; }
    return $ret;
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub getValues {
    $hash{'enable'} = &get_config("sendmail");
    @configlist = `$cmd list`;
    for ($i = 0; $i < $#configlist; $i++) {
	$configlist[$i] =~ s/[\"\s+]//g;
	($attr, $aval) = split(/=/, $configlist[$i]);
	if ($attr ne "") {
	    $hash{$attr} = $aval; chop($aval);
	}
    }
    $hash{'directdomains'} =~ s/,/\n/g;
}

sub formValidation {
	my $error;

	$error = &check_hostname($query->param('forwarder'));
	&error("Forwarding host name cannot contain shell metacharacters") if $error == 911;
	&error("Invalid forwarding host name") if $error;

	$localDomain = $query->param('localdomain');
	&error("Invalid local domain name.") 
		if (!$localDomain || &check_hostname($localDomain)); 	

	$error = &check_hostname($query->param('rootdomain'));
	&error("Root domain name cannot contain shell metacharacters") if $error == 911;
	&error("Invalid root domain name") if $error;

	my $directs = $query->param('directdomains');
	$directs =~ s/[\n\s]+/,/g;
    $directs =~ s/(^,)+|(,$)//g;
	foreach (split(/,/,$directs)) {
		&error(qq|Invalid relay hostname "$_"|) if &check_hostname($_);
	}

	$query->param('directdomains', $directs);

	&error("UUCP path-alias database directory must already exist") if 
	    ! -d $query->param('pathalias') && $query->param('pathalias') ne '/dev/null';

	$error = &check_hostname($query->param('relayname'));
	&error("Relay host name cannot contain shell metacharacters") if $error == 911;
	&error("Invalid relay host name") if $error;
}

sub generic {
	&header_block($title);

	print "<i>$message</i>";

	print $query->startform;
	print "<center><table cellpadding=5 width=450>\n";

	print "<tr><th align=left>Enable sendmail:</th><th align=left>",
		$query->radio_group(-name=>'enable', -values=>['Yes','No'],
					-default=>$hash{'enable'}),"</th></tr>";

	print "<tr><th align=left>Hostname of mail forwarder:</th>\n",
		"<th align=left>",
		$query->textfield(-name=>'forwarder',
				   -default=>$hash{"forwarder"},
				   -size=>20, -maxlength=>256), "</th></tr>";

	print "<tr><th align=left>Root domain name:</th>\n",
		"<th align=left>",
		$query->textfield(-name=>'rootdomain',
				   -default=>$hash{"rootdomain"},
				   -size=>20, -maxlength=>256), "</th></tr>";

	print "<tr><th align=left>Hostname of mail relay:</th>\n",
		"<th align=left>",
		$query->textfield(-name=>'relayname',
				   -default=>$hash{"relayname"},
				   -size=>20, -maxlength=>256), "</th></tr>";

	print "<tr><th align=left>Local domain name:</th>\n",
		"<th align=left>",
		$query->textfield(-name=>'localdomain',
				   -default=>$hash{"localdomain"},
				   -size=>20, -maxlength=>256), "</th></tr>";

	print "<tr><th align=left>Directory of the UUCP path-alias database:</th>\n",
		"<th align=left>",
		$query->textfield(-name=>'pathalias',
				   -default=>$hash{"pathalias"},
				   -size=>20, -maxlength=>256), "</th></tr>";

	print "<tr><th align=left valign=top>List of domains for which this host
				  is the relay:</th>\n",
		"<th align=left>";

	$fix = $query->param('directdomains');
	$fix =~ s/,/\n/g;
	$query->param('directdomains',$fix);

	print $query->textarea(-name=>'directdomains', -rows=>4,
				     -default=>$hash{"directdomains"}),
					"</th></tr>";

	print "</table></center><br>";

	print &buttons("doit", "Ok", "help", "Help");

	print $query->endform;

}
