#!/bin/sh
#
# pmcd admin script for WebMeter
#
# $Id: webmeter1.frm,v 1.7 1996/05/01 09:02:43 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>pmcd</i> Administration for Host `hostname`"
CONFIG_TRACE=false		# make true to enable pmcd trace control in UI

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    PMCD_STATE="<strong><blink>disabled</blink></strong>"
    if $IS_ON pmcd
    then
	pmcd_yes=checked
	pmcd_no=
	if [ "`pminfo -f pmcd.numagents | grep value`" != "" ]
	then
	    PMCD_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    PMCD_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    else
	pmcd_yes=
	pmcd_no=checked
    fi
    timeout_in=`grep -v '^#' /etc/config/pmcd.options \
		 | sed -n -e '/-t/{
s/.*-t *//
s/\([0-9][0-9]*\).*/\1/
p
}'`
    if [ "X$timeout_in" = X ]
    then
	timeout_in=5
	pmda_to_yes=checked
	pmda_to_no=
    else
	# -t 0 for disable
	if [ "X$timeout_in" = X0 ]
	then
	    pmda_to_yes=
	    pmda_to_no=checked
	else
	    pmda_to_yes=checked
	    pmda_to_no=
	fi
    fi

    trace_conn=false
    trace_conn_yes=
    trace_conn_no=checked
    trace_pdu=false
    trace_pdu_yes=
    trace_pdu_no=checked
    if $CONFIG_TRACE
    then
	trace=`grep -v '^#' /etc/config/pmcd.options \
	       | sed -n -e '/-T/{
s/.*-T *//
s/\([0-9][0-9]*\).*/\1/
p
}'`
	if [ "X$trace" != X ]
	then
	    mask=`expr "$trace" % 4`
	    if [ $mask -eq 3 -o $mask -eq 1 ]
	    then
		trace_conn=true
		trace_conn_yes=checked
		trace_conn_no=
	    fi
	    if [ $mask -eq 3 -o $mask -eq 2 ]
	    then
		trace_pdu=true
		trace_pdu_yes=checked
		trace_pdu_no=
	    fi
	fi
    fi
}

# restore sane defaults
#
_default()
{
    pmcd=true
    pmcd_yes=checked
    pmcd_no=
    pmda_to=true
    pmda_to_yes=checked
    pmda_to_no=
    timeout_in=5
    timeout=5
    trace_conn=false
    trace_conn_yes=
    trace_conn_no=checked
    trace_pdu=false
    trace_pdu_yes=
    trace_pdu_no=checked
    show=false
    show_yes=
    show_no=checked
}

# do default page set up
#
_home()
{
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter1.cgi">
<p>If this system is to be used as a Web server,
you may wish to enable WebMeter's collection of performance data.
The Performance Metrics Collection Daemon (<i>pmcd</i>) is used to
co-ordinate all collection of performance data.</p>
<p>Currently <i>pmcd</i> is $PMCD_STATE.</p>
<p>For most systems, if <i>pmcd</i> is enabled,
the default options should be appropriate.</p>
<hr>
<table valign=top border=0 cellspacing=0 cellpadding=1 width=500>
<tr valign=baseline align=left><th>Enable <i>pmcd</i>?
<td><input type=radio name="pmcd" value="true" $pmcd_yes > Yes
<input type=radio name="pmcd" value="false" $pmcd_no > No
</tr>
End-of-File

    if [ "$pmcd_yes" = checked ]
    then
	cat <<End-of-File
<tr valign=baseline align=left><th>Enable PMDA timeouts?
<td><input type=radio name="pmda_to" value="true" $pmda_to_yes > Yes
<input type=radio name="pmda_to" value="false" $pmda_to_no > No
&nbsp &nbsp timeout <input type="text" name="timeout" value="$timeout_in" size=5 maxlength=5> seconds
</tr>
End-of-File

	if $CONFIG_TRACE
	then
		cat <<End-of-File
<tr valign=baseline align=left><th>Enable connection tracing?
<td><input type=radio name="trace_conn" value="true" $trace_conn_yes > Yes
<input type=radio name="trace_conn" value="false" $trace_conn_no > No
</tr>
<tr valign=baseline align=left><th>Enable PDU tracing?
<td><input type=radio name="trace_pdu" value="true" $trace_pdu_yes > Yes
<input type=radio name="trace_pdu" value="false" $trace_pdu_no > No
</tr>
End-of-File
	fi
    fi

    cat <<End-of-File
<tr valign=baseline align=left><th>Show <i>pmcd</i> configuration file?
<td><input type=radio name="show" value="true" $show_yes > Yes
<input type=radio name="show" value="false" $show_no > No
</tr>
</table>
<hr>
<center><table border=5 cellpadding=1>
<tr align=center><th width=100><input type=submit name="action" value="Ok">
<th width=100><input type=reset value="Reset">
<th width=100><input type=submit name="action" value="Defaults">
<th width=100><input type=submit name="action" value="Cancel">
<th width=100><input type=submit name="action" value="Help">
</tr>
</center></table>
<hr>
</form>
Display the
<a href="webmeterman.cgi?entry=pmcd&from=$0"><i>pmcd</i></a>
man page.
End-of-File
    _postscript
}

# mainline
#
_form
_decode_params pmcd pmda_to timeout trace_conn trace_pdu action show

if [ "$action" = "Cancel" ]
then
    echo "Location: webmeter0.cgi"
    echo
    exit
fi

if [ "$action" = Help ]
then
    echo "Location: http://$SERVER_NAME:$SERVER_PORT/pcpweb/planning.html"
    echo
    exit
fi

[ "$action" = Defaults ] && _default

# Ok, Default or \n from text input
#
if $pmcd
then
    sed </etc/config/pmcd.options >$tmp.tmp \
	-e '/^-[tT] *[^ ]*$/d' \
	-e '/^#/!s/-[tT] *[^ ]*//'
    if $pmda_to
    then
	if [ "X$timeout" = X ]
	then
	    _yywarn "<strong>Timeout</strong> must be non-blank to enable <strong>PMDA timeouts</strong>." "$MYTITLE"
	    exit
	fi
	if echo "$timeout" | grep '[^0-9]' >/dev/null
	then
	    _yywarn "<strong>Timeout</strong> must be numeric and non-negative to enable <strong>PMDA timeouts</strong>." "$MYTITLE"
	    exit
	fi
	[ "$timeout" != 5 ] && echo "-t $timeout" >>$tmp.tmp
    else
	echo "-t 0" >>$tmp.tmp
    fi
    mask=0
    $trace_conn && mask=1
    $trace_pdu && mask=`expr $mask + 2`
    [ $mask -ne 0 ] && echo "-T $mask" >>$tmp.tmp
    if [ -s $tmp.tmp ]
    then
	mv -f $tmp.tmp /etc/config/pmcd.options
    else
	rm -f $tmp.tmp
	_yyerror "Failed to edit /etc/config/pmcd.options"
	_yyfail
    fi
    chkconfig pmcd on
    /etc/init.d/pcp start >$tmp.out 2>&1
    if [ "`pminfo -f pmcd.numagents | grep value`" = "" ]
    then
	# did not start
	_preamble "Failed to start <i>pmcd</i>"
	echo '<hr><h3>Input Control</h3>'
	echo '<pre><tt><font -1>'
	cat /etc/pmcd.conf
	echo '</font></tt></pre>'
	echo '<hr><h3>Output from <i>/etc/init.d/pcp</i></h3>'
	echo '<pre><tt><font -1>'
	cat $tmp.out
	echo '</font></tt></pre>'
	log=`cat $tmp.out | sed -n -e '/started/{
s/.*logfile is //
s/)//p
}'`
	if [ "X$log" != X ]
	then
	    echo '<hr><h3><i>pmcd</i> Log</h3>'
	    echo '<pre><tt><font -1>'
	    cat $log
	    echo '</font></tt></pre>'
	fi
	echo "<hr>Return to the <a href=\"$SCRIPT_NAME\"><strong>$MYTITLE</strong></a> page."
	_postscript
	exit
    fi
else
    chkconfig pmcd off
    /etc/init.d/pcp stop >/dev/null 2>&1
fi

if $show
then
    from=`echo "$MYTITLE" | sed -e 's/ /+/g'`
    QUERY_STRING="file=/etc/pmcd.conf&banner=true&title=<i>pmcd</i>+Configuration+File&cgi=$SCRIPT_NAME&from=$from"
    export QUERY_STRING
    SCRIPT_NAME=/webmeterfile.cgi
    exec `pwd`/webmeterfile.cgi
fi

exec `pwd`/webmeter1.cgi
