#!/bin/sh
#
# weblog PMDA admin script for WebMeter
#
# $Id: webmeter2.frm,v 1.8 1996/05/01 09:02:46 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>weblog</i> Agent Administration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    PMCD_STATE="<strong><blink>disabled</blink></strong>"
    if $IS_ON pmcd
    then
	if [ "`pminfo -f pmcd.numagents | grep value`" != "" ]
	then
	    PMCD_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    PMCD_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    WEBLOG_STATE="<strong><blink>disabled</blink></strong>"
    if grep '^weblog[ 	]' /etc/pmcd.conf >/dev/null 2>&1
    then
	weblog=true
	weblog_yes=checked
	weblog_no=
	if [ "`pminfo -f web.config.numservers | grep value`" != "" ]
	then
	    WEBLOG_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    WEBLOG_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    else
	weblog=false
	weblog_yes=
	weblog_no=checked
    fi
}

# restore sane defaults
#
_default()
{
    weblog=true
    weblog_yes=checked
    weblog_no=
    verify=false
    verify_yes=
    verify_no=checked
    delay_in=15
    delay=15
    rot_in=20
    rot=20

    # fixed
    ipc=pipe	# PMCD-PMDA IPC
    wspa=80	# max Web servers per PMDA
}

# do default page set up
#
_home()
{
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter2.cgi">
<p>Performance data is collected by Performance Metric Domain Agents (PMDAs or
simply &quotagents&quot) under the control of the
Performance Metrics Collection Daemon (<i>pmcd</i>).</p>
The <i>weblog</i> agent collects data on the activity of the
local Web server(s).</p>
End-of-File

    if $IS_ON pmcd
    then
	:
    else
	cat <<End-of-File
<p>At present, <i>pmcd</i> is $PMCD_STATE, and must be enabled <strong>before</strong>
any configuration of the <i>weblog</i> agent will be possible.<p>
<strong><input type=submit name="action" value="Reconfigure"></strong> &nbsp <i>pmcd</i>
End-of-File
	return
    fi

    cat <<End-of-File
<p>Currently the <i>weblog</i> agent is $WEBLOG_STATE.</p>
<p>For most systems, if the <i>weblog</i> agent is enabled,
the default options should be appropriate.</p>
<hr>
<table valign=top border=0 cellspacing=0 cellpadding=1 width=450>
<tr valign=baseline align=left><th>Enable the <i>weblog</i> agent?
<td><input type=radio name="weblog" value="true" $weblog_yes > Yes
<input type=radio name="weblog" value="false" $weblog_no > No
</tr>
End-of-File

    if [ "$weblog_yes" = checked ]
    then
	delay_in=`grep '^weblog[ 	]' /etc/pmcd.conf \
		  | sed -e 's/.*-t *//' -e 's/ .*//'`
	[ "X$delay_in" = X ] && delay_in=15
	rot_in=`grep '^weblog[ 	]' /etc/pmcd.conf \
		| sed -e 's/.*-n *//' -e 's/ .*//'`
	[ "X$rot_in" = X ] && rot_in=20
	cat <<End-of-File
<tr valign=baseline align=left><th>Check for new HTTP activity every ...
<td><input type="text" name="delay" value="$delay_in" size=5 maxlength=5> seconds
</tr>
<tr valign=baseline align=left><th>Check for log rotation every ...
<td><input type="text" name="rot" value="$rot_in" size=5 maxlength=5> seconds
</tr>
End-of-File
    fi

    cat <<End-of-File
<tr valign=baseline align=left><th>Verify configuration outcome?
<td><input type=radio name="verify" value="true" $verify_yes > Yes
<input type=radio name="verify" value="false" $verify_no > No
</tr>
</table>
<hr>
<center><table border=5 cellpadding=1>
<tr align=center><th width=100><input type=submit name="action" value="Ok">
<th width=100><input type=reset value="Reset">
<th width=100><input type=submit name="action" value="Defaults">
<th width=100><input type=submit name="action" value="Cancel">
<th width=100><input type=submit name="action" value="Help">
</tr>
</center></table>
<hr>
</form>
Display the
<a href="webmeterman.cgi?entry=pmdaweblog&from=$0"><i>pmdaweblog</i></a>
man page.
End-of-File
    _postscript
}

# mainline
#
_form
_decode_params pmcd weblog delay rot action verify

if [ "$action" = "Cancel" ]
then
    echo "Location: webmeter0.cgi"
    echo
    exit
fi

if [ "$action" = Help ]
then
    echo "Location: http://$SERVER_NAME:$SERVER_PORT/pcpweb/custom.html#weblog_PMDA"
    echo
    exit
fi

if [ "$action" = "Reconfigure" ]
then
    echo "Location: webmeter1.cgi"
    echo
    exit
fi

[ "$action" = Defaults ] && _default

# Ok, Default or \n from text input
#
here=`pwd`
cd /usr/pcp/pmdas/weblog
if $weblog
then
    _trace "Install opts" "rot=$rot delay=$delay"
    if [ "X$delay" = X ]
    then
	_yywarn "<strong>Check for new HTTP activity</strong> period must be non-blank to enable <i>weblog</i> agent." "$MYTITLE"
	exit
    fi
    if echo "$delay" | grep '[^0-9]' >/dev/null
    then
	_yywarn "<strong>Check for new HTTP activity</strong> period must be numeric and non-negative to enable <i>weblog</i> agent." "$MYTITLE"
	exit
    fi
    if [ "X$rot" = X ]
    then
	_yywarn "<strong>Check for log rotation</strong> period must be non-blank to enable <i>weblog</i> agent." "$MYTITLE"
	exit
    fi
    if echo "$rot" | grep '[^0-9]' >/dev/null
    then
	_yywarn "<strong>Check for log rotation</strong> period must be numeric and non-negative to enable <i>weblog</i> agent." "$MYTITLE"
	exit
    fi
    ./Remove >/dev/null 2>&1
    rm -f /usr/pcp/config/web/weblog.conf /var/tmp/weblog.log /var/adm/pcplog/weblog.log
    PAGER=cat; export PAGER
    ./Install >/dev/null 2>&1 <<End-of-File
b
y
n
y
n
n
$delay
$rot
$wspa
$ipc
End-of-File
else
    ./Remove >/dev/null 2>&1
fi
cd $here

if $verify
then
    _preamble "Status for <i>weblog</i> Agent"
    _check_pmda web.config.numservers web
    _check_log weblog
    echo "<hr>Return to the <a href=\"$SCRIPT_NAME\">$MYTITLE</a> page."
    _postscript
    exit
fi

exec `pwd`/webmeter2.cgi
