#!/bin/sh
#
# pmlogger admin script for WebMeter
#
# $Id: webmeter4.frm,v 1.4 1996/05/01 09:02:53 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>pmlogger</i> Administration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
# stolen from /usr/pcp/pmlogger/cron.pmcheck
#
_current()
{
    _pmlogger_status
}

# restore sane defaults
#
_default()
{
    :
}

# do default page set up
#
_home()
{
    localhost="<strong>`hostname`</strong>"
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter4.cgi">
<p>The <i>pmlogger</i> utility and may be used to
create historical archives of system and Web server performance for the local
host and/or remote hosts.</p>
<p>These archives are most useful for retrospective performance analysis,
problem diagnosis and capacity planning.</p>
End-of-File

    if [ -s $tmp.status ]
    then
	cat <<End-of-File
<table border=2 cellpadding=2 cellspacing=2>
<caption align=top>Current <i>pmlogger</i> setup on $localhost
<tr align=left>
<th><th>Archive for Host<th><i>pmlogger</i><br>Status<th>Archive Directory
</tr>

End-of-File

	nawk -F: <$tmp.status '
	    { printf "<tr>"
	      printf "<td><strong><input type=submit name=\"host-" $2 "\" value=\"Reconfigure\"></strong>"
	      printf "<td>" $2
	      if ($1 == 0)
		printf "<th><blink>inactive</blink>"
	      else
		printf "<td>active"
	      printf "<td>" $5
	      print "</tr>"
	    }'
	echo "</table>"
    else
	cat <<End-of-File
<p>Currently $localhost is <strong>not</strong> setup to collect archives for <strong>any</strong> hosts.</p>
End-of-File
    fi

    cat <<End-of-File
<hr>
<p>To activate a <strong>new</strong> <i>pmlogger</i> instance on $localhost,
enter the name of the host from which performance metrics are to be
collected
<input type="text" name="new" value="" size=30> then
<strong><input type=submit name="action" value="Add"></strong>
<hr>
</form>
Display the
<a href="webmeterman.cgi?entry=pmlogger&from=$0"><i>pmlogger</i></a>
man page.
End-of-File
    _postscript
}

# mainline
#
_form

# do our own _decode_params
#
for arg in $PARAMS
do
    arg=`echo "$arg" | _fix_url`
    _trace arg "$arg"
    case "$arg"
    in
	# recognized variable assignments
	#
	host-*)
	    host=`echo "$arg" | sed -e 's/host-//' -e 's/=.*//'`
	    ;;

	new=*)
	    eval $arg
	    newhost=$new
	    ;;
	
	action=*)
	    eval $arg
	    ;;
	
	# debug
	#
	debug=*)
	    eval $arg
	    set $debug
	    ;;

	# bogus?
	#
	*)
	    _yyerror "Unknown variable assignment: $arg"
	    ;;
    esac
done

# check for errors and setup
_yycheck

[ "X$host" = X ] && host="$newhost"
if [ "X$host" = X ]
then
    _yywarn "You must specify a host to be archived, before selecting Add."
fi

SCRIPT_NAME=/webmeter5.cgi
QUERY_STRING="host=$host&action=$action"
export QUERY_STRING

exec `pwd`/webmeter5.cgi
