#!/usr/bin/perl
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#%                                                                     %
#%             PROGRAM  :  MOM-preview-task.pl                         %
#%             CREATOR  :  Mark Gaither                                %
#%       CREATION DATE  :  Fri 17 Nov 1995                             %
#%         DESCRIPTION  :  Preview data to create a MOMspider          %
#%                         instruction file.                           %
#%                                                                     %
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

# flush stdout buffer
$| = 1;

# Print this out no matter what
print "Content-type: text/html\n\n";

if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    # How many bytes are we supposed to receive?
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    
    @pairs = split(/&/, $buffer);
    
    foreach $pair (@pairs)
    {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
    }
}

print <<"HTML";
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HEAD>
<TITLE>MOMspider Traversal Directives Preview</TITLE>
</HEAD>
<BODY>
<H1>MOMspider Traversal Directives Preview</H1>
<HR>
<P>
HTML

$ERRORS = 'false';

if($in{'boundary'} eq '' ||
   $in{'boundary'} =~ /^\s*$/) {
  &error("You must specify the boundary of the infostructure (Site,Tree,Owner).");
  $ERRORS = 'true';
}
if($in{'info-struct-name'} eq '' ||
   $in{'info-struct-name'} =~ /^\s*$/) {
  &error("You must specify a name for the infostructure to be traversed and tested.");
  $ERRORS = 'true';
}
if($in{'info-struct-name'} ne '' && 
   $in{'info-struct-name'} =~ /\s+/) {
  &error("The infostructure name can contain no whitespace.");
  $ERRORS = 'true';
}
if($in{'topURL'} eq '' ||
   $in{'topURL'} =~ /^\s*$/) {
  &error("You must specify either an absolute or relative top URL.");
  $ERRORS = 'true';
}
if($in{'indexURL'} eq '' ||
   $in{'indexURL'} =~ /^\s*$/) {
  &error("You must specify an absolute URL of the produced index file.");
  $ERRORS = 'true';
}
if($in{'indexURL'} ne '' && $in{'indexURL'} !~ /^(http|file|ftp)/) {
    &error("You must specify an absolute URL (http|file|ftp) of the produced index file.");
  $ERRORS = 'true';
}
if($in{'indexfile'} eq '' ||
   $in{'indexfile'} =~ /^\s*$/) {
  &error("You must specify a file name for the index produced.");
  $ERRORS = 'true';
}
if($in{'changewindow'} ne '' &&
   $in{'changewindow'} !~ /^[0-9]+$/) { 
  &error("You must specify an integer >= 0 for number of days.");
  $ERRORS = 'true';
}
if($in{'expirewindow'} ne '' &&
   $in{'expirewindow'} !~ /^[0-9]+$/) {
  &error("You must specify an integer >= 0 for number of days.");
  $ERRORS = 'true';
}
if($in{'emailchanged'} ne '' &&
   ($in{'emailchanged'} !~ /^[0-9]+$/ ||
    scalar($in{'emailchanged'}) < 1)) {
  &error("You must specify an integer > 0 for number of days.");
  $ERRORS = 'true';
}
if($in{'emailchanged'} ne '' &&
   $in{'emailchanged'} =~ /^[0-9]+$/ &&
   ($in{'emailaddress'} eq '' ||
    $in{'emailaddress'} =~ /^\s*$/)) {
  &error("You must specify an email address to receive messages.");
  $ERRORS = 'true';
}
if($in{'emailexpired'} ne '' && 
   $in{'emailexpired'} !~ /^[0-9]+$/) {
  &error("You must specify an integer > 0 for number of days.");
  $ERRORS = 'true';
}
if($in{'emailexpired'} ne '' &&
   $in{'emailexpired'} =~ /^[0-9]+$/ &&
   ($in{'emailaddress'} eq '' ||
    $in{'emailaddress'} =~ /^\s*$/)) {
  &error("You must specify an email address to receive messages.");
  $ERRORS = 'true';
}
if(($in{'emailbroken'} eq 'yes') && 
   ($in{'emailaddress'} eq '' ||
    $in{'emailaddress'} =~ /^\s*$/)) {
  &error("You must specify an email address to receive messages.");
  $ERRORS = 'true';
}
if(($in{'emailredirected'} eq 'yes') && 
   ($in{'emailaddress'} eq '' ||
    $in{'emailaddress'} =~ /^\s*$/)) {
  &error("You must specify an email address to receive messages.");
  $ERRORS = 'true';
}
if($in{'exclude'} ne '' && $in{'exclude'} !~ /^\s*$/) {
  @URLs = split(/\n/,$in{'exclude'});
  foreach $URL (@URLs) {
    if($URL !~ /^(http|ftp|file)/) {
      &error("You must specify an absolute URL to traverse but not test.\n");
      $ERRORS = 'true';
    }
  }
}

if($ERRORS eq 'true') {
  print <<"HTML";

<P> Please traverse back and correct the errors.
</BODY>
</HTML>
HTML

  exit;
}

print "<PRE>\n";

if($in{'boundary'} ne '' && $in{'gd-sysavoid'} !~ /^\s*$/) {
  print "                     Infostructure boundary = $in{'gd-sysavoid'}\n";
}
if($in{'info-struct-name'} ne '' && $in{'info-struct-name'} !~ /^\s*$/) {
  print "                         Infostructure name = $in{'info-struct-name'}\n";
}
if($in{'topURL'} ne '' && $in{'topURL'} !~ /^\s*$/) {
  print "                                    Top URL = $in{'topURL'}\n";
}
if($in{'indexURL'} ne '' && $in{'indexURL'} !~ /^\s*$/) {
  print "                 URL of HTML index document = $in{'indexURL'}\n";
}
if($in{'indexfile'} ne '' && $in{'indexfile'} !~ /^\s*$/) {
  print "                       HTML index file name = $in{'indexfile'}\n";
}
if($in{'indextitle'} eq '') { 
  $in{'indextitle'} = "MOMspider Index for " . $in{'info-struct-name'};
}
if($in{'indextitle'} ne '' && $in{'indextitle'} !~ /^\s*$/) {
  print "               Title of HTML index document = $in{'indextitle'}\n";
}
if($in{'changewindow'} eq '') { $in{'changewindow'} = 7; }
if($in{'changewindow'} ne '' && $in{'changewindow'} !~ /^\s*$/) {
  print "        Days to consider Last-modified date = $in{'changewindow'}\n";
}
if($in{'expirewindow'} eq '') { $in{'expirewindow'} = 0; }
if($in{'expirewindow'} ne '' && $in{'expirewindow'} !~ /^\s*$/) {
  print "              Days to consider Expires date = $in{'expirewindow'}\n";
}
if($in{'emailaddress'} ne '' && $in{'emailaddress'} !~ /^\s*$/) {
  print "                Send automatic responses to = $in{'emailaddress'}\n";
}
if($in{'emailbroken'} ne '' && $in{'emailbroken'} !~ /^\s*$/) {
  print "                  Send broken link messages = $in{'emailbroken'}\n";
}
if($in{'emailredirected'} ne '' && $in{'emailredirected'} !~ /^\s*$/) {
  print "              Send redirected link messages = $in{'emailredirected'}\n";
}
if($in{'emailchanged'} ne '' && $in{'emailchanged'} !~ /^\s*$/) {
  print "      Number of days a test link is changed = $in{'emailchanged'}\n";
}
if($in{'emailexpired'} ne '' && $in{'emailexpired'} !~ /^\s*$/) {
  print "Number of days a traversed document expires = $in{'emailexpired'}\n";
}
if($in{'exclude'} ne '' && $in{'exclude'} !~ /^\s*$/) {
  @URLs = split(/\n/,$in{'exclude'});
  foreach $URL (@URLs) {
    print "                Traverse but don't test URL = $URL\n";
  }
}
 
print <<"HTML";
</PRE>
<P>
<HR>
<P>If these values are correct, <STRONG>submit</STRONG> your choices.
<P>
<FORM ACTION="/cgi-bin/MOM-preview-add-task.pl" METHOD="POST">
<INPUT NAME="inst-filename" TYPE="hidden" VALUE="$in{'inst-filename'}">
<INPUT NAME="boundary" VALUE="$in{'boundary'}" TYPE="hidden">
<INPUT NAME="info-struct-name" VALUE="$in{'info-struct-name'}" TYPE="hidden">
<INPUT NAME="topURL" VALUE="$in{'topURL'}" TYPE="hidden">
<INPUT NAME="indexURL" VALUE="$in{'indexURL'}" TYPE="hidden">
<INPUT NAME="indexfile" VALUE="$in{'indexfile'}" TYPE="hidden">
<INPUT NAME="indextitle" VALUE="$in{'indextitle'}" TYPE="hidden">
<INPUT NAME="changewindow" VALUE="$in{'changewindow'}" TYPE="hidden">
<INPUT NAME="expirewindow" VALUE="$in{'expirewindow'}" TYPE="hidden">
<INPUT NAME="emailaddress" VALUE="$in{'emailaddress'}" TYPE="hidden">
<INPUT NAME="emailbroken" VALUE="$in{'emailbroken'}" TYPE="hidden">
<INPUT NAME="emailredirected" VALUE="$in{'emailredirected'}" TYPE="hidden">
<INPUT NAME="emailchanged" VALUE="$in{'emailchanged'}" TYPE="hidden">
<INPUT NAME="emailexpired" VALUE="$in{'emailexpired'}" TYPE="hidden">
<INPUT NAME="exclude" VALUE="$in{'exclude'}" TYPE="hidden">
<INPUT TYPE="submit" VALUE="Submit and Proceed to Next Step">
</FORM>
</BODY>
</HTML>
HTML

exit;

sub error {
  local($str) = @_;

  select(STDOUT);
  print "<STRONG>ERROR:</STRONG> $str<BR>\n";
}

