#!/usr/bin/perl5

require "/usr/OnRamp/lib/OnRamp.pm";
use CGI;

$query = new CGI;

($type,$editingIP) = ($ARGV[0] =~ /([a-z]+)(.*)/);

$def_config_dir = "/var/dhcp/config";
$defaultFile = "/var/dhcp/config/config.Default";

$size = 20;
$wid = 450;

$title = "Client Subnet Number: $editingIP";


&setTypes;
&setHash;

if ($type eq 'add') { $fname = $defaultFile; }
else { $fname = $def_config_dir . '/config.' . $editingIP; }

&read_config_file($fname);

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

if ($query->param('save_config') eq 'Ok') { &handleRequest; }

print $query->header;
&title_block($title);

&generic;

sub
error
{
    print $query->header;
    &title_block($title);
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub
read_config_file
{
    $gname = $_[0];
    $netnum = $gname;
    $netnum =~ s/^.*config\.//;
    open(CONFIG, "<$gname") || &error("Cannot open file $gname for reading.");

    while (<CONFIG>) {
	if (/^#/) {
	    next;
	}
	chomp;
	/:\s*/ || next;	# Find the first colon, skip line if no colon found
	$left = $`;
	$right = $';
	if ($types{$left} eq "bool") {
	    $right =~ s/1/Yes/;
	    $right =~ s/0/No/;
	    $right =~ s/yes/Yes/;
	    $right =~ s/no/No/;
	}
	elsif ($type{$left} eq "quad") {
	    $right =~ s/1/Bnode/;
	    $right =~ s/0x1/Bnode/;
	    $right =~ s/2/Pnode/;
	    $right =~ s/0x2/Pnode/;
	    $right =~ s/4/Mnode/;
	    $right =~ s/0x4/Mnode/;
	    $right =~ s/8/Hnode/;
	    $right =~ s/0x8/Hnode/;
	}
#	if ($right ne "") {
	    $hash{$left} = $right;
#	}
    }
    close(CONFIG);

    if ($netnum eq "Default") { $hash{'subnet'} = $editingIP; }
    else { $hash{'subnet'} = $netnum; }
}

sub
new_config_file
{
    open(CONFIG, ">$fname") || &error("Cannot open file $fname for writing.");
    @names = $query->param;
    $i = 0;
    while ($names[$i]) {
	if ( ($names[$i] eq "config_file") ||
	     ($names[$i] eq "save_config") ||
	     ($names[$i] eq "subnet")) {
	    $i++;
	    next;
	}
	$value = $query->param($names[$i]);
	if ($types{$names[$i]} eq "bool") {
	    if ($value eq "Yes") {
		$_ = $names[$i].": 1"."\n";
	    }
	    else {
		$_ = $names[$i].": 0"."\n";
	    }
	}
	elsif ($types{$names[$i]} eq "quad") {
	    if ($value eq "Hnode") {
		$_ = $names[$i].": 0x8"."\n";
	    }
	    elsif ($value eq "Mnode") {
		$_ = $names[$i].": 0x4"."\n";
	    }
	    elsif ($value eq "Pnode") {
		$_ = $names[$i].": 0x2"."\n";
	    }
	    else {
		$_ = $names[$i].": 0x1"."\n";
	    }
	}
	else {
	    $_ = $names[$i].": ".$value."\n";
	}
	print CONFIG $_;
	$i++;
    }
    close(CONFIG);
}

sub
save_config_file
{
    $tmpfile = $fname.".tmp";
    open(CONFIG, "<$fname") || &error("Cannot open file $fname for reading.");
    open(CONFIGTMP, ">$tmpfile") || &error("Cannot open file $tmpfile for writing.");
    while (<CONFIG>) {
	if (/^#/) {
	    print CONFIGTMP $_;
	    next;
	}
	/:\s*/ || next;

	while (($key, $value) = each %save_items) {
	    if ($key eq "subnet") {
		next;
	    }
	    if ($` eq $key) {
		if ($types{$key} eq "bool") {
		    if ($value eq "Yes") {
			$_ = $key.": 1"."\n";
		    }
		    else {
			$_ = $key.": 0"."\n";
		    }
		}
		elsif ($types{$key} eq "quad") {
		    if ($value eq "Hnode") {
			$_ = $key.": 0x8"."\n";
		    }
		    elsif ($value eq "Mnode") {
			$_ = $key.": 0x4"."\n";
		    }
		    elsif ($value eq "Pnode") {
			$_ = $key.": 0x2"."\n";
		    }
		    else {
			$_ = $key.": 0x1"."\n";
		    }
		}
		else {
		    $_ = $key.": ".$value."\n";
		}
	    }
	}
	print CONFIGTMP $_;
    }
    close(CONFIGTMP);
    close(CONFIG);
    rename($tmpfile, $fname);
}

sub
check_int
{
    $_[0] =~ s/\s+//g;
    if ($_[0] =~ /^\d+$/) {
	return 0;
    }
    if ($_[1]) {
	&error("Illegal int value: $_[0].");
    }
    return 1;
}

sub
check_dhcp_fname
{
    $_[0] =~ s/^\s+//;
    $_[0] =~ s/\s+$//;
    if ($_[0] =~ /^\//) {
	if (-r $_[0]) {
	    return 0;
	}
    }
    &error("File is inaccessible: $_[0].");
}

sub
check_hname
{
    $_[0] =~ s/^\s+//;
    $_[0] =~ s/\s+$//;
    if ($_[0] =~ /^[a-zA-Z][\w*\-\.]*[a-zA-Z0-9]*$/) {
	if ($_[0] =~ /[_\.\-]$/) {
	    &error("The hostname cannot end with a \. or \- or _ : $_[0].");
	}
	if ($_[0] =~ /\.\.|\-\-|__/) {
	    &error("The hostname cannot have consecutive \. or \- or _ : $_[0].");
	}
	return 0;
    }
    &error("The name is not a valid hostname: $_[0].");
}

sub
check_addr
{
    $_[0] =~ s/^\s+//;
    $_[0] =~ s/\s+$//;
    if ($_[0] =~ /^0x[0-9a-fA-F]+/) {
	if ($_[0] =~ /[^0-9a-fA-Fx]/) {
	    &error("Illegal hex notation address: $_[0].");
	}
	return 0;
    }
    else {
	($a, $b, $c, $d) = split(/\./, $_[0], 4);
	if ( ($a eq "") || ($b eq "") || ($c eq "") || ($d eq "") ) {
	    &error("Illegal dot notation address: $_[0].");
	    return 1;
	}
	if ( ($a =~ /[^0-9]/) || ($a =~ /[^0-9]/) ||
	     ($c =~ /[^0-9]/) || ($d =~ /[^0-9]/) ) {
	    &error("Illegal dot notation address: $_[0].");
	    return 1;
	}
	if ( ($a < 0) || ($a > 255) || ($b < 0) || ($b > 255) ||
	     ($c < 0) || ($c > 255) || ($d < 0) || ($d > 255) ) {
	    &error("Illegal dot notation address: $_[0].");
	    return 1;
	}
    }
    return 0;
}

sub
error_check
{
    if ($types{$_[0]} eq "int") {
	if (check_int($_[1], 1)) {
	    return 1;
	}
    }
    elsif ($types{$_[0]} eq "int_list") {
	@intlist = split(/\,/, $_[1]);
	$j = 0;
	while ($intlist[$j]) {
	    if (check_int($intlist[$j], 0)) {
		&error("Illegal int value: " .
			"$intlist[$j] in list $_[1].");
		return 1;
	    }
	    $j += 1;
	}
    }
    elsif ($types{$_[0]} eq "filepath") {
	if (check_dhcp_fname($_[1])) {
	    return 1;
	}
    }
    elsif ($types{$_[0]} eq "hname") {
	if (check_hname($_[1])) {
	    return 1;
	}
    }
    elsif ($types{$_[0]} eq "addr_range") {
	@rnglist = split(/\,/, $_[1]);
	$j = 0;
	while ($rnglist[$j]) {
	    if ($rnglist[$j] =~ /\-$/) {
		&error("Illegal range value: ".
			"$rnglist[$k] in list $_[1].");
		return 1;
	    }
	    @intlist = split(/\-/, $rnglist[$j]);
	    $k = 0;
	    while ($intlist[$k]) {
		if (check_int($intlist[$k], 0)) {
		    &error("Illegal int value: ".
			  "$intlist[$k] in list $_[1].");
		    return 1;
		}
		$k += 1;
	    }
	    if ($k > 2) {
		&error("Illegal range value: $rnglist[$j]".
			" in list $_[1].");
		return 1;
	    }
	    if ($k == 2) {
		if ($intlist[0] > $intlist[1]) {
		    &error("Illegal int value: ".
			  "$rnglist[$j] in list $_[1].");
		    return 1;
		}
	    }
	    $j += 1;
	}
    }
    elsif ($types{$_[0]} eq "netmask") {
	return 1 if &check_netmask($_[1]); 
    }
    elsif ($types{$_[0]} eq "addr_pairs") {
	@intlist = split(/\,/, $_[1]);
	$j = 0;
	while ($intlist[$j]) {
	    ($adr1, $adr2) = split(/\-/, $intlist[$j], 2);
	    if ( ($adr1 eq "") || ($adr2 eq "") ){
		&error("$intlist[$j]" .
			" is not a valid address pair.");
		return 1;
	    }
	    if(check_addr($adr1)) {
		&error("Illegal address value: ".
			"$adr1 in address pair $intlist[$j].");
		return 1;
	    }
	    if(check_addr($adr2)) {
		&error("Illegal address value: ".
			"$adr2 in address pair $intlist[$j].");
		return 1;
	    }
	    $j += 1;
	}
    }
    elsif ($types{$_[0]} eq "addr") {
	if (check_addr($_[1])) {
	    return 1;
	}
    }
    elsif ($types{$_[0]} eq "addr_list") {
	@intlist = split(/\,/, $_[1]);
	$j = 0;
	while ($intlist[$j]) {
	    if (check_addr($intlist[$j])) {
		&error("Illegal address value: ".
			"$intlist[$j] in list $_[1].");
		return 1;
	    }
	    $j += 1;
	}
    }
    elsif ($types{$_[0]} eq "string") {
	return 0;
    }

    return 0;
}

sub setTypes {
    $types{"Serve_This_Network"} = "bool";
    $types{"pro_choose_name"} = "bool";
    $types{"pro_IPforwarding"} = "bool";
    $types{"pro_source_routing"} = "bool";
    $types{"pro_allnets_local"} = "bool";
    $types{"pro_domask_disc"} = "bool";
    $types{"pro_resp_mask_req"} = "bool";
    $types{"pro_do_router_disc"} = "bool";
    $types{"pro_trailer_encaps"} = "bool";
    $types{"pro_ether_encaps"} = "bool";
    $types{"pro_TCP_keepalive_garbage"} = "bool";

    $types{"pro_address_counter"} = "int";
    $types{"pro_host_pfx_counter"} = "int";
    $types{"pro_lease"} = "int";
    $types{"pro_bootfile_size"} = "int";
    $types{"pro_time_offset"} = "int";
    $types{"pro_max_reassy_size"} = "int";
    $types{"pro_IP_ttl"} = "int";
    $types{"pro_pathmtu_timeout"} = "int";
    $types{"pro_mtu"} = "int";
    $types{"pro_arpcache_timeout"} = "int";
    $types{"pro_TCP_ttl"} = "int";
    $types{"pro_TCP_keepalive_intrvl"} = "int";

    $types{"pro_pathmtu_table"} = "int_list";

    $types{"pro_meritdump_pathname"} = "filepath";
    $types{"pro_root_pathname"} = "filepath";
    $types{"pro_extensions_pathname"} = "filepath";
    $types{"pro_bootfile_name"} = "filepath";

    $types{"pro_host_prefix"} = "hname";
    $types{"pro_TFTPserver_name"} = "hname";
    $types{"pro_dns_domain"} = "hname";
    $types{"pro_nis_domain"} = "hname";
    $types{"pro_nisplus_domain"} = "hname";

    $types{"pro_ipaddress_range"} = "addr_range";

    $types{"pro_static_routes"} = "addr_pairs";
    $types{"pro_policy_filter"} = "addr_pairs";

    $types{"subnet"} = "addr";
    $types{"pro_netmask"} = "netmask";
    $types{"pro_propel_server"} = "addr";
    $types{"pro_broadcast"} = "addr";
    $types{"pro_router_solicit_addr"} = "addr";

    $types{"pro_router_addr"} = "addr_list";
    $types{"pro_dnsserver_addr"} = "addr_list";
    $types{"pro_timeserver_addr"} = "addr_list";
    $types{"pro_logserver_addr"} = "addr_list";
    $types{"pro_cookieserver_addr"} = "addr_list";
    $types{"pro_LPRserver_addr"} = "addr_list";
    $types{"pro_resourceserver_addr"} = "addr_list";
    $types{"pro_swapserver_addr"} = "addr_list";
    $types{"pro_nameserver116_addr"} = "addr_list";
    $types{"pro_impressserver_addr"} = "addr_list";
    $types{"pro_NTPserver_addr"} = "addr_list";
    $types{"pro_X_fontserver_addr"} = "addr_list";
    $types{"pro_X_displaymgr_addr"} = "addr_list";
    $types{"pro_mobileIP_homeagent_addr"} = "addr_list";
    $types{"pro_SMTPserver_addr"} = "addr_list";
    $types{"pro_POP3server_addr"} = "addr_list";
    $types{"pro_NNTPserver_addr"} = "addr_list";
    $types{"pro_WWWserver_addr"} = "addr_list";
    $types{"pro_fingerserver_addr"} = "addr_list";
    $types{"pro_IRCserver_addr"} = "addr_list";
    $types{"pro_StreetTalkserver_addr"} = "addr_list";
    $types{"pro_STDAserver_addr"} = "addr_list";
    $types{"pro_NetBIOS_nameserver_addr"} = "addr_list";
    $types{"pro_NetBIOS_distrserver_addr"} = "addr_list";
    $types{"pro_nisserver_addr"} = "addr_list";
    $types{"pro_nisplusserver_addr"} = "addr_list";

    $types{"pro_NetBIOS_scope"} = "string";

    $types{"pro_NetBIOS_nodetype"} = "quad";
}

sub handleRequest {
    undef %array;
    open(IN,"< $theFile");
    while(<IN>) {
	@items = split(/\s+/);
	if (substr($items[0],0,1) eq "#") { next; }
	chop($items[0]); chop($items[1]);
	$array{$items[0]} = $items[1];
    }
    close(IN);

    @names = $query->param;
    $fname = $query->param('config_file');
#    if (-e $fname) { $file = $fname; }
#    else { $file = $defaultFile; }
    &read_config_file($defaultFile);
# foreach $arg (keys(%hash)) { print "$arg $hash{$arg}<br>"; }
    %save_items = %hash;
    foreach $arg (@names) {
	if ( ($arg eq "config_file") ||
	     ($arg eq "save_config") ) {
	    next;
	}
	$old = $hash{$arg};
	$new = $query->param($arg);
	if ($new && $old ne $new) {
	    if ($types{$arg} eq "bool") {
		if ( (($old eq "") || ($old eq "0") || ($old eq "no")) &&
		     ($new eq "No") ) {
		    $i += 1;
		    next;
		}
		if ( (($old eq "1") || ($old eq "yes")) &&
		     ($new eq "Yes") ) {
		    $i += 1;
		    next;
		}
	    }
	    elsif ($types{$arg} eq "quad") {
		if ( ((($old eq "") || ($old eq "1")) && ($new eq "Bnode")) ||
		     (($old eq "2") && ($new eq "Pnode")) ||
		     (($old eq "4") && ($new eq "Mnode")) ||
		     (($old eq "8") && ($new eq "Hnode")) ) {
		    $i += 1;
		    next;
		}
	    }
	    if (error_check($arg, $new)) {
		&error("Input error");
	    }
	    $save_items{$arg} = $new;
	}
    }

    if (1 || $query->param('save_config') eq "Ok") {
	# Save the File now
	if ($type eq 'add') {
	    $fname = $def_config_dir . '/config.' . $editingIP;
	    `cp $defaultFile $fname`;
	    &save_config_file;
	} elsif ( ($a1 = $save_items{"subnet"}) ne "") {
	    # This probably is a new file so need to write everything if so
	    $fname =~ s/config\..*/config.$a1/;
	    if (-e $fname) {
		save_config_file;
	    }
	    else {
		save_config_file;
	    }
	} else {
	    save_config_file;
	}
	$message = "The configuration file $fname has been saved.";
    }
    elsif ($query->param('save_config') eq "Delete") {
	$message = "The configuration file $fname has been deleted.";
    }
    $file = "dhcp-config.cgi" . "?$type";
    print $query->redirect($file);
}

sub setHash {
    $hash{"Serve_This_Network"} = $query->param('Serve_This_Network') ?
	$query->param('Serve_This_Network') : 'No';
    $hash{"pro_choose_name"} = $query->param('pro_choose_name') ?
	$query->param('pro_choose_name') : 'No';
    $hash{"pro_host_prefix"} = $query->param('pro_host_prefix') ?
	$query->param('pro_host_prefix') : '';
    $hash{"pro_netmask"} = $query->param('pro_netmask') ?
	$query->param('pro_netmask') : '';
    $hash{"pro_ipaddress_range"} = $query->param('pro_ipaddress_range') ?
	$query->param('pro_ipaddress_range') : '';
    $hash{"pro_nis_domain"} = $query->param('pro_nis_domain') ?
	$query->param('pro_nis_domain') : '';
    $hash{"pro_pathmtu_timeout"} = $query->param('pro_pathmtu_timeout') ?
	$query->param('pro_pathmtu_timeout') : '';

    $hash{"pro_IPforwarding"} = "No";
    $hash{"pro_source_routing"} = "No";
    $hash{"pro_allnets_local"} = "No";
    $hash{"pro_domask_disc"} = "No";
    $hash{"pro_resp_mask_req"} = "No";
    $hash{"pro_do_router_disc"} = "No";
    $hash{"pro_trailer_encaps"} = "No";
    $hash{"pro_ether_encaps"} = "No";
    $hash{"pro_TCP_keepalive_garbage"} = "No";

    $hash{"pro_NetBIOS_nodetype"} = "Bnode";
}

sub generic {
    if ($query->param('adv')) { &longform; }
    else { &shortform; }
}

sub longform {
    &header_block($title);

    print "<i>$message</i>";

    print $query->startform;

    print $query->hidden(-name=>'adv', -default=>'Yes');

    print $query->hidden(-name=>'config_file', -default=>$fname);

    print "<center><strong>Enable DHCP service for this network: \n",
      $query->radio_group(-name=>'Serve_This_Network',
			  -values=>['Yes','No'],
			  -default=>$hash{"Serve_This_Network"}),
      "</strong></center>\n";

    print "<h3>General Options:</h3>";
    print "<center><table cellpadding=5 width=$wid>\n";
    print "<tr><th align=left>Allow clients to choose their own hostname:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_choose_name',
			  -values=>['Yes','No'],
			  -default=>$hash{"pro_choose_name"}),
      "</tr>";
    print "<tr><th align=left>Starting number for new IP Address:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_address_counter',
			-default=>$hash{"pro_address_counter"},
			-size=>$size, -maxlength=>5),
      "</tr>";
    print "<tr><th align=left>Prefix for automatic hostname assignments:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_host_prefix',
			-default=>$hash{"pro_host_prefix"},
			-size=>$size, -maxlength=>7),
      "</tr>";
    print "<tr><th align=left>Starting number to append to Hostname Prefix:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_host_pfx_counter',
			-default=>$hash{"pro_host_pfx_counter"},
			-size=>$size, -maxlength=>5),
      "</tr>";
    print "<tr><th align=left>Subnet mask for this network:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_netmask',
			-default=>$hash{"pro_netmask"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>Maximum allowable address Lease in seconds:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_lease',
			-default=>$hash{"pro_lease"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>Generate new IP addresses from this range:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_ipaddress_range',
			-default=>$hash{"pro_ipaddress_range"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of IP Addresses for Routers:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_router_addr',
			-default=>$hash{"pro_router_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Bootfile Size (in 512-Octet blocks):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_bootfile_size',
			-default=>$hash{"pro_bootfile_size"},
			-size=>$size, -maxlength=>8),
      "</tr>";
    print "<tr><th align=left>Bootfile Name:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_bootfile_name',
			-default=>$hash{"pro_bootfile_name"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Time Offset from UTC (in seconds):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_time_offset',
			-default=>$hash{"pro_time_offset"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>Merit Dump File Pathname:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_meritdump_pathname',
			-default=>$hash{"pro_meritdump_pathname"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Root Disk Pathname:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_root_pathname',
			-default=>$hash{"pro_root_pathname"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Extensions Pathname:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_extensions_pathname',
			-default=>$hash{"pro_extensions_pathname"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>TFTP Server Name:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_TFTPserver_name',
			-default=>$hash{"pro_TFTPserver_name"},
			-size=>$size, -maxlength=>256),
      "</tr></table>";

    print "</center><h3>Server related options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>NIS domain name for this network:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_dns_domain',
			-default=>$hash{"pro_dns_domain"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of DNS Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_dnsserver_addr',
			-default=>$hash{"pro_dnsserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Propel Server IP Address:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_propel_server',
			-default=>$hash{"pro_propel_server"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Time Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_timeserver_addr',
			-default=>$hash{"pro_timeserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of UDP Log Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_logserver_addr',
			-default=>$hash{"pro_logserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Cookie Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_cookieserver_addr',
			-default=>$hash{"pro_cookieserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of LPR Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_LPRserver_addr',
			-default=>$hash{"pro_LPRserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Service Location Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_resourceserver_addr',
			-default=>$hash{"pro_resourceserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>Swap Server IP Address:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_swapserver_addr',
			-default=>$hash{"pro_swapserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of IEN 116 Name Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nameserver116_addr',
			-default=>$hash{"pro_nameserver116_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Impress Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_impressserver_addr',
			-default=>$hash{"pro_impressserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of NTP Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_NTPserver_addr',
			-default=>$hash{"pro_NTPserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr></table>";

    print "</center><h3>Application options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>List of X Window Font Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_X_fontserver_addr',
			-default=>$hash{"pro_X_fontserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of X Window Mgr Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_X_displaymgr_addr',
			-default=>$hash{"pro_X_displaymgr_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Mobile Home Agent Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_mobileIP_homeagent_addr',
			-default=>$hash{"pro_mobileIP_homeagent_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of SMTP Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_SMTPserver_addr',
			-default=>$hash{"pro_SMTPserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of POP3 Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_POP3server_addr',
			-default=>$hash{"pro_POP3server_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of NNTP Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_NNTPserver_addr',
			-default=>$hash{"pro_NNTPserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of WWW Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_WWWserver_addr',
			-default=>$hash{"pro_WWWserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Finger Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_fingerserver_addr',
			-default=>$hash{"pro_fingerserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of Internet Chat Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_IRCserver_addr',
			-default=>$hash{"pro_IRCserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of StreetTalk Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_StreetTalkserver_addr',
			-default=>$hash{"pro_StreetTalkserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of STDA (StreetTalk) Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_STDAserver_addr',
			-default=>$hash{"pro_STDAserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr></table>";

    print "</center><h3>Services options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>List of NetBIOS Name Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_NetBIOS_nameserver_addr',
			-default=>$hash{"pro_NetBIOS_nameserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of NetBIOS Dist Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_NetBIOS_distrserver_addr',
			-default=>$hash{"pro_NetBIOS_distrserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>NetBIOS over TCP/IP Scope Option:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_NetBIOS_scope',
			-default=>$hash{"pro_NetBIOS_scope"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>NIS Domain Name:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nis_domain',
			-default=>$hash{"pro_nis_domain"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of NIS Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nisserver_addr',
			-default=>$hash{"pro_nisserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>NIS+ Domain Name:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nisplus_domain',
			-default=>$hash{"pro_nisplus_domain"},
			-size=>$size, -maxlength=>256),
      "</tr>";
    print "<tr><th align=left>List of NIS+ Server IP Addresses:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nisplusserver_addr',
			-default=>$hash{"pro_nisplusserver_addr"},
			-size=>$size, -maxlength=>256),
      "</tr></table>";
    print "<table cellpadding=5 width=$wid>\n";
    print "<tr><th align=left>NetBIOS over TCP/IP Node Type Option:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_NetBIOS_nodetype',
			  -values=>['Bnode','Pnode', 'Mnode', 'Hnode'],
			  -default=>$hash{"pro_NetBIOS_nodetype"}),
      "</tr></table>";

    print "</center><h3>IP per host options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>Perform IP Forwarding:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_IPforwarding',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_IPforwarding"}),
      "</tr>";
    print "<tr><th align=left>Perform Non-Local Source Routing:",
      "<th align=left>",
      $query->radio_group(-name=>'pro_source_routing',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_source_routing"}),
      "</tr>";
    print "<tr><th align=left>Source Routing Policy Filters (Addr-Mask pairs):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_policy_filter',
			-default=>$hash{"pro_policy_filter"},
			-size=>$size, -maxlength=>512),
      "</tr>";
    print "<tr><th align=left>Maximum Datagram Reassembly Size (&gt 576):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_max_reassy_size',
			-default=>$hash{"pro_max_reassy_size"},
			-size=>$size, -maxlength=>6),
      "</tr>";
    print "<tr><th align=left>Default IP Time To Live (TTL):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_IP_ttl',
			-default=>$hash{"pro_IP_ttl"},
			-size=>$size, -maxlength=>3),
      "</tr>";
    print "<tr><th align=left>Path MTU Aging Timeout (Seconds):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_pathmtu_timeout',
			-default=>$hash{"pro_pathmtu_timeout"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>List of MTU's for MTU Path Discovery:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_pathmtu_table',
			-default=>$hash{"pro_pathmtu_table"},
			-size=>$size, -maxlength=>256),
      "</tr></table>";

    print "</center><h3>IP per interface options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>MTU for the Interface (&gt 68):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_mtu',
			-default=>$hash{"pro_mtu"},
			-size=>$size, -maxlength=>6),
      "</tr>";
    print "<tr><th align=left>All Subnets are Local:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_allnets_local',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_allnets_local"}),
      "</tr>";
    print "<tr><th align=left>Broadcast IP Address:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_broadcast',
			-default=>$hash{"pro_broadcast"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>Perform Mask Discovery:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_domask_disc',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_domask_disc"}),
      "</tr>";
    print "<tr><th align=left>Respond to Subnet Mask requets using ICMP:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_resp_mask_req',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_resp_mask_req"}),
      "</tr>";
    print "<tr><th align=left>Perform Router Discovery:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_do_router_disc',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_do_router_disc"}),
      "</tr>";
    print "<tr><th align=left>Router Solicitation IP Address:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_router_solicit_addr',
			-default=>$hash{"pro_router_solicit_addr"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>Static Routes (pairs of dest-router addrs):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_static_routes',
			-default=>$hash{"pro_static_routes"},
			-size=>$size, -maxlength=>512),
      "</tr></table>";

    print "</center><h3>Link layer per interface options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>Perform Trailer Encapsulation:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_trailer_encaps',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_trailer_encaps"}),
      "</tr>";
    print "<tr><th align=left>Perform Ethernet Encapsulation:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_ether_encaps',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_ether_encaps"}),
      "</tr>";
    print "<tr><th align=left>ARP Cache Timeout (Seconds):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_arpcache_timeout',
			-default=>$hash{"pro_arpcache_timeout"},
			-size=>$size, -maxlength=>16),
      "</tr></table>";

    print "</center><h3>TCP options:</h3><center>";
    print "<table cellpadding=5 width=$wid>\n";

    print "<tr><th align=left>TCP Default Time To Live (1-255):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_TCP_ttl',
			-default=>$hash{"pro_TCP_ttl"},
			-size=>$size, -maxlength=>4),
      "</tr>";
    print "<tr><th align=left>TCP KeepAlive Interval (Seconds):\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_TCP_keepalive_intrvl',
			-default=>$hash{"pro_TCP_keepalive_intrvl"},
			-size=>$size, -maxlength=>16),
      "</tr>";
    print "<tr><th align=left>TCP KeepAlive Garbage Option:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_TCP_keepalive_garbage',
			  -values=>['Yes', 'No'],
			  -default=>$hash{"pro_TCP_keepalive_garbage"}),
      "</tr></table><br>";

    &button_table($query,"save_config", "Ok", "help", "Help");

    print $query->endform;
}

sub shortform {
    &header_block($title);

    print "<i>$message</i>";

    print "<h3>Basic Options:</h3>";

    print $query->startform;

    print $query->hidden(-name=>'config_file', -default=>$fname);

    print "<center><table cellpadding=5 width=$wid>\n";
    print "<tr><th align=left>Enable DHCP service for this network:\n",
      "<th align=left>",
      $query->radio_group(-name=>'Serve_This_Network',
			  -values=>['Yes','No'],
			  -default=>$hash{"Serve_This_Network"}),
      "</tr>\n";

    print "<tr><th align=left>Allow clients to choose their own hostname:\n",
      "<th align=left>",
      $query->radio_group(-name=>'pro_choose_name',
			  -values=>['Yes','No'],
			  -default=>$hash{"pro_choose_name"}),
      "</tr>";

    print "<tr><th align=left>Prefix for automatic hostname assignments:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_host_prefix',
			-default=>$hash{"pro_host_prefix"},
			-size=>$size, -maxlength=>7),
      "</tr>";

    print "<tr><th align=left>Generate new IP addresses from this range:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_ipaddress_range',
			-default=>$hash{"pro_ipaddress_range"},
			-size=>$size, -maxlength=>256),
      "</tr>";

    print "<tr><th align=left>Subnet mask for this network:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_netmask',
			-default=>$hash{"pro_netmask"},
			-size=>$size, -maxlength=>16),
      "</tr>";

    print "<tr><th align=left>NIS domain name for this network:\n",
      "<th align=left>",
      $query->textfield(-name=>'pro_nis_domain',
			-default=>$hash{"pro_nis_domain"},
			-size=>$size, -maxlength=>256),
      "</tr>";

    print "<tr><td></td><td>";
    print qq|<input type=submit name="adv" value="Go to Advanced Options">|;
    print "</td></tr>";

    print "</table></center><br>";

    &button_table($query, "save_config", "Ok", "help", "Help");

    print $query->endform;
}


