#!/usr/bin/perl5

#.........................................................
#..  dhcp_sopts.cgi										..
#..  Scott A. Hotes  3 / 13 / 96						..
#.........................................................

#  Q: what is initial configuration for bootp and dhcp_bootp
#		in inetd.conf, and which line is it that we are
#		altering?

use Sys::Hostname;
use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$title = "DHCP Server Options";

print $query->header;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

&title_block($title);

$conf = "/etc/inetd.conf";
$osf = $def_osf = "/etc/config/dhcp_bootp.options";

$dummy = "/etc/inetd.conf.tmp";

$def_hosts = "/etc/hosts";
$def_ethers = "/etc/ethers";
$def_sys = "/unix";
$def_propel_dbm = "/var/IRIXpro";
$def_config_dir = "/var/dhcp/config";
$host = hostname;
$def_propel_mgr = "$host:1525";
$dbfile = "/usr/IRIXpro/lib/system.dbtclrc";
$use_propel = "No";

$rly_off = system ("/etc/chkconfig", "proclaim_relayagent");
$srv_off = system ("/etc/chkconfig", "proclaim_server");
$def_sstate = "No";
if ($srv_off == 0) {
    $def_sstate = "Yes";
}

if ($def_sstate eq "Yes") { &getFilename; }

if ($query->param) {
	&formValidation;
	if ($query->param('doit') eq 'Ok') {    
    	$new_sstate = $query->param('sstate');
		&error("You must first disable DHCP relay agent before you can
			enable DHCP server.") if ($new_sstate eq "Yes" && !$rly_off);
    	if ($new_sstate ne $def_sstate) {			# state changed
			if ($new_sstate eq "Yes") {
	    		system ("/etc/chkconfig", "proclaim_server", "on");
			} else {
	    		system ("/etc/chkconfig", "proclaim_server", "off"); 
			}
		}
		if ($new_sstate eq 'Yes') { &makeChanges; }
    }
    print "<i>The new state has been saved.</i>\n";
}

if ($def_sstate eq "Yes") { &readConfig; }

&generic;

sub formValidation {
	my $error = &check_fname($query->param('hosts_map'), 1);
	&error($error) if $error;	
	
	$error = &check_fname($query->param('ethers_map'), 1);
	&error($error) if $error;
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub makeChanges {
#	if ($query->param('opt_file') ne $osf) {
#		$osf = $query->param('opt_file');
#		$value = "bootp\tdgram\tudp\twait\troot\t/usr/etc/bootp\tbootp\t-o $osf\n";
#		&putEntry($conf,"bootp",$value); 
#	}

	$rename = 0;
	open(IN,"< $conf");
	open(OUT,"> $dummy");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[6] eq "bootp" || $items[7] eq "bootp") {
		if ($items[0] eq "bootp") {
		    print OUT "# $_";
		    $rename = 1;
		}
	    }
	    elsif($items[6] eq "dhcp_bootp" || $items[7] eq "dhcp_bootp") {
		if ($items[0] ne "bootp") {
		    $line = "bootp\tdgram\tudp\twait\troot\t/usr/etc/dhcp_bootp ";
		    $line .= "dhcp_bootp -o /etc/config/dhcp_bootp.options\n";
		    print OUT $line;
		    $rename = 1;
		}
	    }
	    else { print OUT $_; }
	}
	close(IN);
	close(OUT);
	if ($rename) { rename($dummy,$conf); }		

	open(OUT,"> $osf");

	if ($query->param('use_propel') eq 'Yes') {
		print OUT "-s ", $query->param('propel_dbms'), "\n";
		if ($query->param('propel_mgr') ne $def_propel_mgr) {
			print OUT "ih ", $query->param('propel_mgr'), "\n";
		}
	}
	if ($query->param('hosts_map') ne '/etc/hosts') {
		print OUT "-w ", $query->param('hosts_map'), "\n"; }
	if ($query->param('ethers_map') ne '/etc/ethers') {
		print OUT "-e ", $query->param('ethers_map'), "\n"; }
#	if ($query->param('sys_name') ne '/unix') {
#		print OUT "-u ", $query->param('sys_name'), "\n"; }
#	if ($query->param('config_dir') ne '/var/dhcp/config') {
#		print OUT "-c ", $query->param('config_dir'), "\n"; }
	close(OUT);
}

sub putEntry { 
	local($file) = $_[0];
	local($key) = $_[1];
	local($val) = $_[2];
	local($dummy) = "dummy";

	open(IN,"< $file");
	open(OUT,"> $dummy");
	local($found) = 0;
	while(<IN>) {
		if (/^$key/ || /^#\s*$key/) {
			print OUT $val,"\n";
			$found = 1;
		} else { print OUT $_; }
	}
	if ($found == 0) { print OUT $val,"\n"; }
	rename($dummy, $file) || &error("Unable to rename $dummy to $file");
	close(IN);
	close(OUT);
}

sub getFilename {
    open(INETD, $conf) || &error("Unable to open $conf");
    $osf = "";
    while (<INETD>) {
	if (/^#/) {
	    next;
	}
	# bootp dgram udp wait root /usr/etc/dhcp_bootp dhcp_bootp -o <file>
	if (/^bootp/) {
	    chop;
	    @entlist = split(/\s+/);
	    if (($entlist[6] eq "dhcp_bootp") && ($entlist[7] eq "-o")) {
		$osf = $entlist[8];
		last;	# Break out of the while loop
	    }
	}
    }
    close(INETD);
    if (!$osf) { $osf = $def_osf; }
}

sub readConfig {
    open(OPTIONS, $osf) || &error("Unable to open $osf");
    while(<OPTIONS>) {
	if (/^#/) {
	    next;
	}
	chop;
	@optlist = split(/\s+/);
	$i = 0;
	while ($optlist[$i]) {
	    if ($optlist[$i] eq "-y") {
		&error("Option $optlist[$i] in file $osf is no longer supported");
	    }
	    elsif ($optlist[$i] eq "-s") {
		$def_propel_dbm = $optlist[$i+1];
		$use_propel = "Yes";
		$i += 2;
		next;
	    }
	    elsif ($optlist[$i] eq "-h") {
		$def_propel_mgr  = $optlist[$i+1];
		$i += 2;
		next;
	    }
	    elsif ($optlist[$i] eq "-w") {
		$def_hosts = $optlist[$i+1];
		$i += 2;
		next;
	    }
	    elsif ($optlist[$i] eq "-e") {
		$def_ethers = $optlist[$i+1];
		$i += 2;
		next;
	    }
	    elsif ($optlist[$i] eq "-u") {
		$def_sys = $optlist[$i+1];
		$i += 2;
		next;
	    }
	    elsif ($optlist[$i] eq "-c") {
		$def_config_dir = $optlist[$i+1];
		$i += 2;
		next;
	    }
	    else {
		&error("Option $optlist[ei] in file $osf is not recognized");
	    }
	    $i += 1;
	}
    }
    close(OPTIONS);
}

sub generic {
	&header_block($title);

	print $query->startform;
	print "<center ><table cellpadding=5 width=450>\n";

	print "<tr><th align=left>Enable DHCP server:</th><th align=left>\n",
      		$query->radio_group(-name=>'sstate',
			  -values=>['Yes','No'],
			  -default=>$def_sstate), "</th></tr>";

#	print "<tr><th align=left>DHCP Server Option File:</th><th align=left>\n",
#      		$query->textfield(-name=>'opt_file',
#			-default=>$osf,
#			-size=>20, -maxlength=>256), "</th></tr>";

	if (-e $dbfile) {
    		print "<hr><tr><th align=left>Use the Propel database for the hosts 
				and ethers maps:</th><th align=left>\n",
	  		$query->radio_group(-name=>'use_propel',
			      -values=>['Yes','No'],
			      -default=>$use_propel), "</th></tr>";
    		print "<tr><th align=left>Directory for Propel database:</th><th align=left>\n",
	  		$query->textfield(-name=>'propel_dbms',
			    -default=>$def_propel_dbm,
			    -size=>20, -maxlength=>256), "</th></tr>";
    		print "<tr><th align=left>Hostname of Propel lock manager:</th><th align=left>\n",
	  		$query->textfield(-name=>'propel_mgr',
			    -default=>$def_propel_mgr,
			    -size=>20, -maxlength=>256), "</th></tr>";
	}

	print "<tr><th align=left>File name for translating IP addresses to 
			hostnames:</th><th align=left>\n",
      		$query->textfield(-name=>'hosts_map',
			-default=>$def_hosts,
			-size=>20, -maxlength=>256), "</th></tr>";
	print "<tr><th align=left>File name for translating ethernet address to 
			hostnames:</th><th align=left>\n",
      		$query->textfield(-name=>'ethers_map',
			-default=>$def_ethers,
			-size=>20, -maxlength=>256), "</th></tr>";

#	print "<tr><th align=left>System File Name:</th><th align=left>\n",
#      		$query->textfield(-name=>'sys_name',
#			-default=>$def_sys,
#			-size=>20, -maxlength=>256), "</th></tr>";
#	print "<tr><th align=left>DHCP Config Directory:</th><th align=left>\n",
#      		$query->textfield(-name=>'config_dir',
#			-default=>$def_config_dir,
#			-size=>20, -maxlength=>256), "</th></tr>";

	print "</table></center><br>";

	&button_table($query,"doit", "Ok", "help", "Help");

	print $query->endform;

	print $query->end_html;
}
