#!/usr/bin/perl5

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/gateways";
$dummy = "/etc/gateways.dummy";
$myname = "gateways-config.cgi";
$title = "Gateway Configuration";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;
&getGateways;

$delete = 0;

if (%fld) {
    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    $fld{'gateway'} =~ /([\w.]+)/;
    $fld{'gateway'} = $1;
    if ($fld{"add"}) { 
	&validAdd;
	$val{'metric'} = 1;
	&getAdd;
	exit 0; 
    }
    if ($fld{"doAdd"}) {
	&valid(0);
	&doAdd;
	$fld{'destination'} = "";
	&getGateways;
    }
    if ($fld{"doEdit"}) {
	&valid(1);
	&doEdit;
	&getGateways;
    }
    if ($fld{"edit"}) {
	&error(2,"To edit an existing gateway, first choose one from the list,
	    then click the edit button.") if !$fld{'gateway'};
	&getGateways($fld{'gateway'});
	&putEdit;
	&getEdit;
	exit 0; 
    }
    if ($fld{"delete"}) { 
	&error(2,"To delete an existing gateway, first choose one from the 
	    list, then click the delete button.") if !$fld{'gateway'};
	$delete = 1;
	$message = qq|Click "Ok" to save changes.|; 
    }
    if ($fld{"doit"}) { 
	if ($erd ne $fld{'erd'}) { &changeStatus; }
	if ($fld{'delGateway'}) { &doDelete; };
	&getGateways;
    }
    if (!$message) {
	if ($fld{'destination'}) { $message = qq|Click "Add New Gateway" 
	    to go to the add form.|; }
	else { $message = "No change made."; }
    }
    %val = %fld; 
} 

&generic;

sub valid {
    &error($_[0],"Invalid route address.") if !$fld{'route'} || &check_ipaddr($fld{'route'});
    &error($_[0],"Number of hops must be an integer.") if $fld{'metric'} =~ /[^0-9-]/;
    &error($_[0],"Number of hops must be greater than zero.") if $fld{'metric'} < 1;
    &error($_[0],"Number of hops must be no greater than 16.") if $fld{'metric'} > 16;    
} 

sub validAdd {
    &error(2,"You must provide a gateway address.") if !$fld{'destination'};
    &error(2,"Invalid gateway address.") if &check_ipaddr($fld{'destination'});   
}

sub error {
    &error_block($_[1]);
    %val = %fld;
    if ($_[0] == 0) { &getAdd; }
    elsif ($_[0] == 1) { &getEdit; }
    else { &generic; }
    exit 0;
}

sub changeStatus {
    if ($fld{'erd'} eq 'Yes') { 
	`/etc/chkconfig routed on`;
	`/etc/killall routed`;
	open(IN,"< /etc/config/routed.options");
	while(<IN>) {
	    chop($_);
	    $configFile .= " $_";
	}
	close(IN);
	`/usr/etc/routed $configFile > /dev/null 2>&1`;
	$message = "Dynamic routing enabled.";
    }
    else {
	`/etc/chkconfig routed off`;
	`/etc/killall routed`;
	$message = "Dynamic routing disabled.";
    }
}
   
sub doDelete {
    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[1] eq $fld{'delGateway'}) { print OUT "# $_"; }
	else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    $message = "Gateway deleted.";
}

sub doAdd {
    open(OUT,">> $conf");
    print OUT "$fld{'type'} $fld{'destination'} gateway $fld{'route'} ";
    print OUT "metric $fld{'metric'} $fld{'mode'}\n";
    close(OUT);

    $message = "Gateway added.";
}

sub putEdit {
    $val{'type'} = $type;
    $val{'mode'} = $mode;
    $val{'route'} = $rout;
    $val{'metric'} = $metr;
}

sub doEdit {
    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[1] eq $fld{'gateway'}) { print OUT "# $_"; }
	else { print OUT $_; }
    }
    print OUT "$fld{'type'} $fld{'gateway'} gateway $fld{'route'} ";
    print OUT "metric $fld{'metric'} $fld{'mode'}\n";
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    $message = "Gateway edited.";
}
    
sub getEdit {
    &header_block("Edit Gateway");

    print "<form action=$myname method=post>";

    print "<input type=hidden name=gateway value=$fld{'gateway'}>";

    print "<center><table width=450>";

    print "<tr><th align=left>IP address of gateway destination:</th><td>
		<tt>$fld{'gateway'}</tt></td></tr>";
    print "<tr><th align=left>IP address of route interface:</th><td>",
		&text('route',$val{'route'},16),"</td></tr>";
    print "<tr><th align=left>Type of network gateway:</th><td>",
		&select('type',$val{'type'},'net','host'),"</td></tr>";
    print "<tr><th align=left>Mode of network gateway:</th><td>",
		&select('mode',$val{'mode'},'active','passive'),"</td></tr>";
    print "<tr><th align=left>Number of hops from route interface to 
		    destination:</th><td>",
		&text('metric',$val{'metric'},5),"</td></tr>";

    print "</table></center>";

    print "<br>", &buttons('doEdit','Ok');
    
    print '</form>';
}

sub getAdd {
    &header_block("Add New Gateway");

    print "<form action=$myname method=post>";

    print "<input type=hidden name=destination value=$fld{'destination'}>";

    print "<center><table width=450>";

    print "<tr><th align=left>IP address of gateway destination:</th><td>
		<tt>$fld{'destination'}</tt></td></tr>";
    print "<tr><th align=left>IP address of route interface:</th><td>",
		&text('route',$val{'route'},16),"</td></tr>";
    print "<tr><th align=left>Type of network gateway:</th><td>",
		&select('type',$val{'type'},'net','host'),"</td></tr>";
    print "<tr><th align=left>Mode of network gateway:</th><td>",
		&select('mode',$val{'mode'},'active','passive'),"</td></tr>";
    print "<tr><th align=left>Number of hops from route interface to 
		    destination:</th><td>",
		&text('metric',$val{'metric'},5),"</td></tr>";

    print "</table></center>";

    print "<br>", &buttons('doAdd','Ok');
    
    print '</form>';
}
   
sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    print "<center><table width=450>";

    print "<tr><th align=left>Enable dynamic routing:</th><th align=left>",
	    &radio('erd',$erd,'Yes','No'),"</th></tr>";

    print "<tr><th align=left>";
    print qq|<input type=submit name=add value="Add New Gateway"></th>|;
    print "<td><input size=19 type=text name=destination 
	    value=$val{'destination'}>";
    print "</td></tr>";

    if ($delete) { 
	undef @locList;
	foreach $arg (@gateways) {
	    if ($arg ne $fld{'gateway'}) { 
		push(@locList,$arg); }
	}
	print "<input type=hidden name=delGateway value=$fld{'gateway'}>"; 
    } else { @locList = @gateways; }

    print "<tr><th align=left>";
    print qq|<input type=submit name=edit value="Edit Selected Gateway"></th>|;
    print "<td rowspan=2>", &choice_list(*locList,"gateway",20), "</td></tr>";

    print "<tr><th align=left>";
    print qq|<input type=submit name=delete value="Delete Selected Gateway"></th></tr>|;

    print "</table></center>";

    print "<br>", &buttons('doit','Ok');
    
    print '</form>';
}

sub getGateways {
    undef @gateways;

    open(GATE, "< $conf");
    while (<GATE>) {
	@items = split(/\s+/);
	if ($items[0] ne 'net' && $items[0] ne 'host') { next; }
	push(@gateways,$items[1]);
	if ($items[1] eq $_[0]) {
	    $type = $items[0];
	    $rout = $items[3];
	    $metr = $items[5];
	    $mode = $items[6];
	}
    }
    close(GATE);

    `/etc/chkconfig routed`;
    $erd = $? >> 8;
    if ($erd) { $erd = "No"; }
    else { $erd = "Yes"; }
}
