#!/usr/bin/perl5

require "/usr/OnRamp/lib/OnRamp.pm";

# modem-hardware.cgi
# Scott A. Hotes, 3 / 25 / 96
# Silicon Graphics
#
# The following actions are taken to reconfigure modem hardware:
# - port turned "off" in /etc/inittab
# - telinit q command issued to reinitialize port
# - fix-modem configuration script is run
# - Devices file is edited (for dial-out or both)
# - device is given uucp ownership (for dial-out or both)
# - action field of /etc/inittab is updated (for dial-in or both)
#
# To determine current modem configurations, the following steps
# are taken:
# - to determine mode, first check inittab file.  if status=off,
#    assume dial-out, if status=on check for existing ACU line
#    in /etc/uucp/Devices.  if line exists it is both, otherwise
#    assume dial-in.  got that?								
# - for dial-out or dial-in/dial-out, existing "ACU" line with proper
#    port label gives modem and speed.  for dial-in only, I know of
#    no way to get modem or speed.
#
# Note: this script requires the existance of the file 
# /usr/OnRamp/etc/modem.trans to operate correctly

$confI = "/etc/inittab";
$confD = "/etc/uucp/Devices";
$translate = "/usr/OnRamp/etc/modem.trans";
$dummy = "/etc/uucp/Devices.tmp";
$myname = "modem-hardware.cgi";
$title = "Modem Configuration";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

&get_modemList;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($fld{'help'} eq "Help");

if ($fld{'doit'} eq 'Ok') {
    if ($fld{'enable1'} eq 'Yes') { 
	&reconfigure(1);
	$message = "Port 1 has been reconfigured.";
    }
    if ($fld{'enable2'} eq 'Yes') { 
	&reconfigure(2);
	$message .= "  Port 2 has been reconfigured."; 
    }
    if (!$message) { $message = qq|To reconfigure a given port, click "Yes"
			for the appropriate port under "Reconfigure".|; }
}

&getCurrentStatus;

if (-d "/etc/uucp") { &generic; }
else {
    &header_block($title);
    print "<i>Modem software not installed.  Install subsystem
		</i><b>eoe.sw.uucp</b><i> from the 6.2 CD.</i>";
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub get_modemList {
    open(IN,"< $translate");
    while(<IN>) { 
	@items = split(/:/);
	push(@modemList,$items[1]);
    }
    close(IN);
}

sub reconfigure {
    $num = $_[0];

    $switch = "";
    &turnOffPort($num);
    `telinit q`;
    if ($fld{'dial_out'.$num} eq 'Yes') {
	$switch = "o"; 
	&editDevice($num);
	$expr = "chown uucp /dev/ttyd" . $num;
	eval($expr);
	if ($fld{'speed'.$num} > 2400) { 
	    $expr = "chown uucp /dev/ttyf" . $num; 
	} else { $expr = "chown uucp /dev/ttym" . $num; }
	eval($expr);
    } else { &deleteDevice($num); }
    if ($fld{'dial_in'.$num} eq 'Yes') {
	$switch = "i" . $switch;
	&turnOnPort($num);
    }
    if ($switch) {
		$cmd = &hash_modem($fld{'modem'.$num},1,3);
		if ($cmd) {
	    	if ($switch ne "o") {
				@cmd = split(/\s+/,$cmd);
				$cmd[1] = "-".$switch;
				$cmd = join(' ',@cmd);
	    	}
	    	$cmd = "/etc/uucp/"."$cmd $num";
	    	`$cmd > /dev/null 2>&1`;
		}
    } 
}

sub deleteDevice {
    $doRename = 0;
    open(IN,"< $confD");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq "ACU" && substr($items[1],4,1) eq $_[0]) {
	    $doRename = 1;
	    print OUT "# $_";
	} elsif ($items[0] eq "Direct" && substr($items[1],4,1) eq $_[0]) {
	    $doRename = 1;
	    print OUT "# $_";
	} else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    if ($doRename) { rename($dummy,$confD); }
}

sub editDevice {
    $nm = $_[0];

    $found = 0;
    open(IN,"< $confD");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	$line =~ /^\s*(.*)$/;
	$line1 = $1;
	@items = split(/ /,$line1);
	if ($items[0] eq "Direct" && $items[1] eq "ttyd".$nm) { 
	    print OUT "# $line";
	    if ($found == 0) {
		$found = 1;
		$mdm = &hash_modem($fld{'modem'.$nm},1,0);
		if ($fld{'speed'.$nm} < 9600) { $dev = "ttym".$nm; }
		else { $dev = "ttyf".$nm; }
		print OUT "ACU $dev null $fld{'speed'.$nm} 212 x $mdm\n";
		print OUT "Direct ttyd",$nm," - $fld{'speed'.$nm} direct\n";
	    }
	} elsif ($items[0] eq "ACU" && substr($items[1],4,1) eq $nm) {
	    print OUT "# $line";
	} else { print OUT $line; }
    }
    if ($found == 0) {
	$mdm = &hash_modem($fld{'modem'.$nm},1,0);
	if ($fld{'speed'.$nm} < 9600) { $dev = "ttym".$nm; }
	else { $dev = "ttyf".$nm; }
	print OUT "ACU $dev null $fld{'speed'.$nm} 212 x $mdm\n";
	print OUT "Direct ttyd",$nm," - $fld{'speed'.$nm} direct\n";
    }
    close(OUT);
    close(IN);
    rename($dummy,$confD);
}
    

sub turnOffPort {
    $nm = $_[0];
    
    open(IN,"< $confI");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	$line =~ /^\s*(.*)$/;
	$line1 = $1;
	@items = split(/:/,$line1);
	if ($items[0] eq "t".$nm) { 
	    splice(@items,2,1,"off");
	    $line = join(':',@items);
	    print OUT "$line\n"; 
	}
	else { print OUT $line; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$confI);
}

sub turnOnPort {
    $nm = $_[0];
    $found = 0;
    open(IN,"< $confI");
    open(OUT,"> $dummy");
    while(<IN>) {
		@items = split(/:/);
		if ($items[0] eq "t".$nm) {
	    	$iArg = &hash_modem($fld{'modem'.$nm},1,2);
	    	print OUT "t$nm",":23:respawn:/usr/lib/uucp/uugetty ";
	    	print OUT "-Nt60 -i$iArg",",conn ttyf$nm dx_38400\n";
	    	$found = 1;
		}
		else { print OUT $_; }
    }
    if ($found == 0) {
		$iArg = &hash_modem($fld{'modem'.$nm},1,2);
		print OUT "t$nm:23:respawn:/usr/lib/uucp/uugetty ";
		print OUT "-Nt60 -i$iArg ttyf$nm dx_38400\n";
    }
    close(IN);
    close(OUT);
    rename($dummy,$confI);
}
	
sub getCurrentStatus {
    $di[0] = 0; $di[1] = 0;
    $do[0] = 0; $do[1] = 0;
    open(IN,"< $confI");
    while(<IN>) {
	@items = split(/\s+/);
	@terms = split(/:/,$items[0]);
	if ($terms[0] eq "t1") {
	    if ($terms[2] ne "off") { 
		$di[0] = 1;
		$items[2] =~ /-i(.*)\,conn/;
		$modem1 = &hash_modem($1,2,1); 
	    }
	}
	if ($terms[0] eq "t2") {
	    if ($terms[2] ne "off") { 
		$di[1] = 1; 
		$items[2] =~ /-i(.*)\,conn/;
		$modem2 = &hash_modem($1,2,1); 
	    }
	}
    }
    close(IN);

    open(IN,"< $confD");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq "ACU") {
	    $char = substr($items[1],4,1);
	    if ($char eq "1") {
		$do[0] = 1;
		$modem1 = &hash_modem($items[6],0,1);
		$speed1 = $items[3];
	    }
	    if ($char eq "2") {
		$do[1] = 1;
		$modem2 = &hash_modem($items[6],0,1);
		$speed2 = $items[3];
	    }
	}
    }
    close(IN);
    
    $val{'dial_in1'} = $di[0] ? 'Yes' : 'No';
    $val{'dial_in2'} = $di[1] ? 'Yes' : 'No';
    $val{'dial_out1'} = $do[0] ? 'Yes' : 'No';
    $val{'dial_out2'} = $do[1] ? 'Yes' : 'No';

    if ($speed1 eq "") { $speed1 = "9600"; }
    if ($speed2 eq "") { $speed2 = "9600"; }
    if ($modem1 eq "") { $modem1 = "Hayes smartmodem"; }
    if ($modem2 eq "") { $modem2 = "Hayes smartmodem"; }
} 
    
sub generic {
    print "<form action=$myname method=post>";

    &header_block($title);

    print "<i>$message</i>";

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th></th><th align=left>Port 1</th><th align=left>Port 2</th></tr>";

    print "<tr><th align=left>Reconfigure:</th><td align=left>",
	  &radio('enable1','No','Yes','No'),
	  "</td><td align=left>",
	  &radio('enable2','No','Yes','No'),"</td></tr>";

    print "<tr><th align=left>Allow users to dial in:<td align=left>",
	    &radio('dial_in1',$val{'dial_in1'},'Yes','No'),"</td><td>",
	    &radio('dial_in2',$val{'dial_in2'},'Yes','No'),"</td></tr>";

    print "<tr><th align=left>Allow users to dial out:<td align=left>",
	    &radio('dial_out1',$val{'dial_out1'},'Yes','No'),"</td><td>",
	    &radio('dial_out2',$val{'dial_out2'},'Yes','No'),"</td></tr>";

    print "<tr><th align=left>Modem model:</th><td align=left>",
	  &select_list('modem1',$modem1,*modemList), "</td>";

    print "<td align=left>",&select_list('modem2',$modem2,*modemList),"</td></tr>";

    print "<tr><th align=left>Baud rate:</th><td align=left>",
	  &select('speed1',$speed1,
	    '2400',
	    '9600',
	    '14400',
	    '19200',
	    '28800',
	    '38400'), "</td>";
    print "<td align=left>",&select('speed2',$speed2,
	    '2400',
	    '9600',
	    '14400',
	    '19200',
	    '28800',
	    '38400'), "</td></tr>";

    print '</table></center><br>';

    print &buttons('doit','Ok');

    print '</form></body></html>';
}

